/* tracker-sparql-builder.c generated by valac, the Vala compiler
 * generated from tracker-sparql-builder.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>


#define TRACKER_TYPE_SPARQL_BUILDER (tracker_sparql_builder_get_type ())
#define TRACKER_SPARQL_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_BUILDER, TrackerSparqlBuilder))
#define TRACKER_SPARQL_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_BUILDER, TrackerSparqlBuilderClass))
#define TRACKER_IS_SPARQL_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_BUILDER))
#define TRACKER_IS_SPARQL_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_BUILDER))
#define TRACKER_SPARQL_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_BUILDER, TrackerSparqlBuilderClass))

typedef struct _TrackerSparqlBuilder TrackerSparqlBuilder;
typedef struct _TrackerSparqlBuilderClass TrackerSparqlBuilderClass;
typedef struct _TrackerSparqlBuilderPrivate TrackerSparqlBuilderPrivate;

#define TRACKER_SPARQL_BUILDER_TYPE_STATE (tracker_sparql_builder_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TrackerSparqlBuilder {
	GObject parent_instance;
	TrackerSparqlBuilderPrivate * priv;
};

struct _TrackerSparqlBuilderClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_BUILDER_STATE_UPDATE,
	TRACKER_SPARQL_BUILDER_STATE_INSERT,
	TRACKER_SPARQL_BUILDER_STATE_DELETE,
	TRACKER_SPARQL_BUILDER_STATE_SUBJECT,
	TRACKER_SPARQL_BUILDER_STATE_PREDICATE,
	TRACKER_SPARQL_BUILDER_STATE_OBJECT,
	TRACKER_SPARQL_BUILDER_STATE_BLANK
} TrackerSparqlBuilderState;

struct _TrackerSparqlBuilderPrivate {
	gint _length;
	TrackerSparqlBuilderState* states;
	gint states_length1;
	gint states_size;
	GString* str;
};


static gpointer tracker_sparql_builder_parent_class = NULL;

GType tracker_sparql_builder_get_type (void);
static GType tracker_sparql_builder_state_get_type (void);
#define TRACKER_SPARQL_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_SPARQL_BUILDER, TrackerSparqlBuilderPrivate))
enum  {
	TRACKER_SPARQL_BUILDER_DUMMY_PROPERTY,
	TRACKER_SPARQL_BUILDER_RESULT,
	TRACKER_SPARQL_BUILDER_LENGTH
};
static void _vala_array_add1 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
TrackerSparqlBuilder* tracker_sparql_builder_new_update (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type);
static TrackerSparqlBuilderState tracker_sparql_builder_get_state (TrackerSparqlBuilder* self);
void tracker_sparql_builder_drop_graph (TrackerSparqlBuilder* self, const char* iri);
static void _vala_array_add2 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self);
void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const char* s);
void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const char* iri);
static void _vala_array_add3 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const char* s);
void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const char* iri);
static void _vala_array_add4 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const char* s);
void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const char* iri);
static void _vala_array_add5 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self);
static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self, gint value);
static void _vala_array_add6 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const char* literal);
void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal);
void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal);
void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal);
void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, double literal);
static void _vala_array_add7 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self);
static void _vala_array_add8 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value);
void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self);
void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const char* raw);
TrackerSparqlBuilder* tracker_sparql_builder_new (void);
TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type);
const char* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self);
static void tracker_sparql_builder_finalize (GObject* obj);
static void tracker_sparql_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_sparql_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);




static GType tracker_sparql_builder_state_get_type (void) {
	static GType tracker_sparql_builder_state_type_id = 0;
	if (G_UNLIKELY (tracker_sparql_builder_state_type_id == 0)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BUILDER_STATE_UPDATE, "TRACKER_SPARQL_BUILDER_STATE_UPDATE", "update"}, {TRACKER_SPARQL_BUILDER_STATE_INSERT, "TRACKER_SPARQL_BUILDER_STATE_INSERT", "insert"}, {TRACKER_SPARQL_BUILDER_STATE_DELETE, "TRACKER_SPARQL_BUILDER_STATE_DELETE", "delete"}, {TRACKER_SPARQL_BUILDER_STATE_SUBJECT, "TRACKER_SPARQL_BUILDER_STATE_SUBJECT", "subject"}, {TRACKER_SPARQL_BUILDER_STATE_PREDICATE, "TRACKER_SPARQL_BUILDER_STATE_PREDICATE", "predicate"}, {TRACKER_SPARQL_BUILDER_STATE_OBJECT, "TRACKER_SPARQL_BUILDER_STATE_OBJECT", "object"}, {TRACKER_SPARQL_BUILDER_STATE_BLANK, "TRACKER_SPARQL_BUILDER_STATE_BLANK", "blank"}, {0, NULL, NULL}};
		tracker_sparql_builder_state_type_id = g_enum_register_static ("TrackerSparqlBuilderState", values);
	}
	return tracker_sparql_builder_state_type_id;
}


static void _vala_array_add1 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


TrackerSparqlBuilder* tracker_sparql_builder_construct_update (GType object_type) {
	TrackerSparqlBuilder * self;
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
	_vala_array_add1 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_SPARQL_BUILDER_STATE_UPDATE);
	return self;
}


TrackerSparqlBuilder* tracker_sparql_builder_new_update (void) {
	return tracker_sparql_builder_construct_update (TRACKER_TYPE_SPARQL_BUILDER);
}


void tracker_sparql_builder_drop_graph (TrackerSparqlBuilder* self, const char* iri) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	g_return_if_fail (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
	g_string_append (self->priv->str, _tmp0_ = g_strdup_printf ("DROP GRAPH <%s>\n", iri));
	_g_free0 (_tmp0_);
}


static void _vala_array_add2 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_UPDATE);
	_vala_array_add2 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_SPARQL_BUILDER_STATE_INSERT);
	g_string_append (self->priv->str, "INSERT {\n");
}


void tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail ((tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	if (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " .\n");
		self->priv->states_length1 = self->priv->states_length1 - 3;
	}
	self->priv->states_length1--;
	g_string_append (self->priv->str, "}\n");
}


void tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self, const char* iri) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	tracker_sparql_builder_subject (self, _tmp0_ = g_strdup_printf ("<%s>", iri));
	_g_free0 (_tmp0_);
}


static void _vala_array_add3 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_subject (TrackerSparqlBuilder* self, const char* s) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail ((tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	if (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " .\n");
		self->priv->states_length1 = self->priv->states_length1 - 3;
	}
	g_string_append (self->priv->str, s);
	_vala_array_add3 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
}


void tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self, const char* iri) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	tracker_sparql_builder_predicate (self, _tmp0_ = g_strdup_printf ("<%s>", iri));
	_g_free0 (_tmp0_);
}


static void _vala_array_add4 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_predicate (TrackerSparqlBuilder* self, const char* s) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (((tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_SUBJECT) || (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_BLANK));
	if (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " ;\n\t");
		self->priv->states_length1 = self->priv->states_length1 - 2;
	}
	g_string_append (self->priv->str, " ");
	g_string_append (self->priv->str, s);
	_vala_array_add4 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_SPARQL_BUILDER_STATE_PREDICATE);
}


void tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self, const char* iri) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iri != NULL);
	tracker_sparql_builder_object (self, _tmp0_ = g_strdup_printf ("<%s>", iri));
	_g_free0 (_tmp0_);
}


static void _vala_array_add5 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_object (TrackerSparqlBuilder* self, const char* s) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail ((tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	if (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " ,");
		self->priv->states_length1--;
	}
	g_string_append (self->priv->str, " ");
	g_string_append (self->priv->str, s);
	_vala_array_add5 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
	_tmp0_ = self->priv->_length;
	tracker_sparql_builder_set_length (self, _tmp0_ + 1);
	_tmp0_;
}


static void _vala_array_add6 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_object_string (TrackerSparqlBuilder* self, const char* literal) {
	gchar* p;
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (literal != NULL);
	g_return_if_fail ((tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	if (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " ,");
		self->priv->states_length1--;
	}
	g_string_append (self->priv->str, " \"");
	p = literal;
	while (TRUE) {
		gsize len;
		if (!((*p) != '\0')) {
			break;
		}
		len = strcspn ((const char*) p, "\t\n\r\"\\");
		g_string_append_len (self->priv->str, (const char*) p, (glong) len);
		p = p + len;
		switch (*p) {
			case '\t':
			{
				g_string_append (self->priv->str, "\\t");
				break;
			}
			case '\n':
			{
				g_string_append (self->priv->str, "\\n");
				break;
			}
			case '\r':
			{
				g_string_append (self->priv->str, "\\r");
				break;
			}
			case '"':
			{
				g_string_append (self->priv->str, "\\\"");
				break;
			}
			case '\\':
			{
				g_string_append (self->priv->str, "\\\\");
				break;
			}
			default:
			{
				continue;
			}
		}
		p++;
	}
	g_string_append (self->priv->str, "\"");
	_vala_array_add6 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
	_tmp0_ = self->priv->_length;
	tracker_sparql_builder_set_length (self, _tmp0_ + 1);
	_tmp0_;
}


void tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self, gboolean literal) {
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = NULL;
	if (literal) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	tracker_sparql_builder_object (self, _tmp0_);
}


void tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self, gint64 literal) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	tracker_sparql_builder_object (self, _tmp0_ = g_strdup_printf ("%lli", literal));
	_g_free0 (_tmp0_);
}


static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	gmtime_r (&time, &_result_);
	*result = _result_;
	return;
}


void tracker_sparql_builder_object_date (TrackerSparqlBuilder* self, time_t* literal) {
	struct tm _tmp0_ = {0};
	struct tm tm;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	tm = (g_time_gm (*literal, &_tmp0_), _tmp0_);
	tracker_sparql_builder_object_string (self, _tmp1_ = g_strdup_printf ("%04d-%02d-%02dT%02d:%02d:%02dZ", tm.tm_year + 1900, tm.tm_mon + 1, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec));
	_g_free0 (_tmp1_);
}


static char* double_to_string (double self) {
	char* result;
	gint _tmp0__length1;
	gchar* _tmp0_;
	char* _tmp1_;
	result = (_tmp1_ = g_strdup (g_ascii_dtostr ((_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE), _tmp0__length1 = G_ASCII_DTOSTR_BUF_SIZE, _tmp0_), G_ASCII_DTOSTR_BUF_SIZE, self)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


void tracker_sparql_builder_object_double (TrackerSparqlBuilder* self, double literal) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	tracker_sparql_builder_object (self, _tmp0_ = double_to_string (literal));
	_g_free0 (_tmp0_);
}


static void _vala_array_add7 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail ((tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT));
	if (tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
		g_string_append (self->priv->str, " ,");
		self->priv->states_length1--;
	}
	g_string_append (self->priv->str, " [");
	_vala_array_add7 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_SPARQL_BUILDER_STATE_BLANK);
}


static void _vala_array_add8 (TrackerSparqlBuilderState** array, int* length, int* size, TrackerSparqlBuilderState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail ((tracker_sparql_builder_get_state (self) == TRACKER_SPARQL_BUILDER_STATE_OBJECT) && (self->priv->states[self->priv->states_length1 - 3] == TRACKER_SPARQL_BUILDER_STATE_BLANK));
	g_string_append (self->priv->str, "]");
	self->priv->states_length1 = self->priv->states_length1 - 3;
	_vala_array_add8 (&self->priv->states, &self->priv->states_length1, &self->priv->states_size, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
	_tmp0_ = self->priv->_length;
	tracker_sparql_builder_set_length (self, _tmp0_ + 1);
	_tmp0_;
}


void tracker_sparql_builder_append (TrackerSparqlBuilder* self, const char* raw) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (raw != NULL);
	g_return_if_fail (self->priv->states_length1 == 1);
	g_string_append (self->priv->str, raw);
}


TrackerSparqlBuilder* tracker_sparql_builder_construct (GType object_type) {
	TrackerSparqlBuilder * self;
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
	return self;
}


TrackerSparqlBuilder* tracker_sparql_builder_new (void) {
	return tracker_sparql_builder_construct (TRACKER_TYPE_SPARQL_BUILDER);
}


const char* tracker_sparql_builder_get_result (TrackerSparqlBuilder* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_warn_if_fail (self->priv->states_length1 == 1);
	result = self->priv->str->str;
	return result;
}


gint tracker_sparql_builder_get_length (TrackerSparqlBuilder* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_length;
	return result;
}


static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_length = value;
	g_object_notify ((GObject *) self, "length");
}


static TrackerSparqlBuilderState tracker_sparql_builder_get_state (TrackerSparqlBuilder* self) {
	TrackerSparqlBuilderState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->states[self->priv->states_length1 - 1];
	return result;
}


static void tracker_sparql_builder_class_init (TrackerSparqlBuilderClass * klass) {
	tracker_sparql_builder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlBuilderPrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_sparql_builder_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_sparql_builder_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_builder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_RESULT, g_param_spec_string ("result", "result", "result", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_LENGTH, g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tracker_sparql_builder_instance_init (TrackerSparqlBuilder * self) {
	self->priv = TRACKER_SPARQL_BUILDER_GET_PRIVATE (self);
	self->priv->str = g_string_new ("");
}


static void tracker_sparql_builder_finalize (GObject* obj) {
	TrackerSparqlBuilder * self;
	self = TRACKER_SPARQL_BUILDER (obj);
	self->priv->states = (g_free (self->priv->states), NULL);
	_g_string_free0 (self->priv->str);
	G_OBJECT_CLASS (tracker_sparql_builder_parent_class)->finalize (obj);
}


GType tracker_sparql_builder_get_type (void) {
	static GType tracker_sparql_builder_type_id = 0;
	if (tracker_sparql_builder_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBuilder), 0, (GInstanceInitFunc) tracker_sparql_builder_instance_init, NULL };
		tracker_sparql_builder_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlBuilder", &g_define_type_info, 0);
	}
	return tracker_sparql_builder_type_id;
}


static void tracker_sparql_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlBuilder * self;
	self = TRACKER_SPARQL_BUILDER (object);
	switch (property_id) {
		case TRACKER_SPARQL_BUILDER_RESULT:
		g_value_set_string (value, tracker_sparql_builder_get_result (self));
		break;
		case TRACKER_SPARQL_BUILDER_LENGTH:
		g_value_set_int (value, tracker_sparql_builder_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_sparql_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlBuilder * self;
	self = TRACKER_SPARQL_BUILDER (object);
	switch (property_id) {
		case TRACKER_SPARQL_BUILDER_LENGTH:
		tracker_sparql_builder_set_length (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




