/* tracker-miner-flickr.c generated by valac, the Vala compiler
 * generated from tracker-miner-flickr.vala, do not modify */

/*
 * Copyright (C) 2010, Adrien Bustany <abustany@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libtracker-miner/tracker-miner-web.h>
#include <libtracker-client/tracker-client.h>
#include <rest/rest-proxy.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-miner/tracker-miner-object.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-xml-parser.h>
#include <libtracker-client/tracker-sparql-builder.h>
#include <float.h>
#include <math.h>
#include <libtracker-miner/tracker-password-provider.h>
#include <signal.h>
#include <stdio.h>
#include <sys/select.h>


#define TRACKER_TYPE_MINER_FLICKR (tracker_miner_flickr_get_type ())
#define TRACKER_MINER_FLICKR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_MINER_FLICKR, TrackerMinerFlickr))
#define TRACKER_MINER_FLICKR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_MINER_FLICKR, TrackerMinerFlickrClass))
#define TRACKER_IS_MINER_FLICKR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_MINER_FLICKR))
#define TRACKER_IS_MINER_FLICKR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_MINER_FLICKR))
#define TRACKER_MINER_FLICKR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_MINER_FLICKR, TrackerMinerFlickrClass))

typedef struct _TrackerMinerFlickr TrackerMinerFlickr;
typedef struct _TrackerMinerFlickrClass TrackerMinerFlickrClass;
typedef struct _TrackerMinerFlickrPrivate TrackerMinerFlickrPrivate;

#define TRACKER_MINER_FLICKR_TYPE_EXIF_TAG (tracker_miner_flickr_exif_tag_get_type ())

#define TRACKER_MINER_FLICKR_TYPE_EXIF_METERING_MODE (tracker_miner_flickr_exif_metering_mode_get_type ())

#define TRACKER_MINER_FLICKR_TYPE_EXIF_WHITE_BALANCE (tracker_miner_flickr_exif_white_balance_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rest_xml_node_unref0(var) ((var == NULL) ? NULL : (var = (rest_xml_node_unref (var), NULL)))
typedef struct _TrackerMinerFlickrInitPullData TrackerMinerFlickrInitPullData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TrackerMinerFlickrWritebackPhotoData TrackerMinerFlickrWritebackPhotoData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_ptr_array_free0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_free (var, TRUE), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

typedef enum  {
	TRACKER_REST_CALL_ERROR_INVALID_RESPONSE,
	TRACKER_REST_CALL_ERROR_CALL_ERROR
} TrackerRestCallError;
#define TRACKER_REST_CALL_ERROR tracker_rest_call_error_quark ()
struct _TrackerMinerFlickr {
	TrackerMinerWeb parent_instance;
	TrackerMinerFlickrPrivate * priv;
};

struct _TrackerMinerFlickrClass {
	TrackerMinerWebClass parent_class;
};

struct _TrackerMinerFlickrPrivate {
	guint pull_timeout_handle;
	TrackerClient* tracker_client;
	RestProxy* rest;
	char* frob;
	char* auth_token;
	char* user_id;
};

typedef enum  {
	TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA = 271,
	TRACKER_MINER_FLICKR_EXIF_TAG_FLASH = 37385,
	TRACKER_MINER_FLICKR_EXIF_TAG_FNUMBER = 33437,
	TRACKER_MINER_FLICKR_EXIF_TAG_FOCAL_LENGTH = 37386,
	TRACKER_MINER_FLICKR_EXIF_TAG_ISO_SPEED = 2,
	TRACKER_MINER_FLICKR_EXIF_TAG_METERING_MODE = 37383,
	TRACKER_MINER_FLICKR_EXIF_TAG_WHITE_BALANCE = 5
} TrackerMinerFlickrExifTag;

typedef enum  {
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_AVERAGE = 1,
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_CENTER_WEIGHTED_AVERAGE,
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_SPOT,
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_MULTISPOT,
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PATTERN,
	TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PARTIAL
} TrackerMinerFlickrExifMeteringMode;

typedef enum  {
	TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_AUTO = 0,
	TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_MANUAL
} TrackerMinerFlickrExifWhiteBalance;

struct _TrackerMinerFlickrInitPullData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerMinerFlickr* self;
	RestProxyCall* albums_call;
	RestXmlNode* photosets_node;
	RestProxyCall* _tmp0_;
	RestXmlNode* _tmp1_;
	RestXmlNode* _tmp2_;
	char* error_message;
	GError * call_error;
	GError * _inner_error_;
};

struct _TrackerMinerFlickrWritebackPhotoData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerMinerFlickr* self;
	char* uri;
	GPtrArray* results;
	char*** triples;
	gint _triples_size_;
	gint triples_length1;
	char* photo_id;
	char** local_tags;
	char** _tmp0_;
	char** _tmp1_;
	gint _local_tags_size_;
	gint local_tags_length1;
	GHashTable* flickr_tags;
	char** tags_to_add;
	char** _tmp2_;
	char** _tmp3_;
	gint _tags_to_add_size_;
	gint tags_to_add_length1;
	char** tags_to_remove;
	char** _tmp4_;
	char** _tmp5_;
	gint _tags_to_remove_size_;
	gint tags_to_remove_length1;
	RestProxyCall* tag_call;
	RestXmlNode* root_node;
	RestXmlNode* tag_node;
	GPtrArray* _tmp8_;
	char* _tmp6_;
	GPtrArray* _tmp7_;
	GError * tracker_error;
	char*** _tmp9_;
	char* _tmp10_;
	guint i;
	gboolean _tmp11_;
	RestProxyCall* _tmp12_;
	RestXmlNode* _tmp13_;
	RestXmlNode* _tmp14_;
	char* error_message;
	GError * get_tags_error;
	RestXmlNode* _tmp15_;
	RestXmlNode* _tmp16_;
	char** local_tag_collection;
	int local_tag_collection_length1;
	int local_tag_it;
	char* local_tag;
	GList* flickr_tag_collection;
	GList* flickr_tag_it;
	const char* flickr_tag;
	char** tag_collection;
	int tag_collection_length1;
	int tag_it;
	char* tag;
	GError * _inner_error_;
};


static GMainLoop* tracker_miner_flickr_main_loop;
static GMainLoop* tracker_miner_flickr_main_loop = NULL;
static gboolean tracker_miner_flickr_in_loop;
static gboolean tracker_miner_flickr_in_loop = FALSE;
static gpointer tracker_miner_flickr_parent_class = NULL;

GQuark tracker_rest_call_error_quark (void);
GType tracker_miner_flickr_get_type (void);
#define TRACKER_MINER_FLICKR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_MINER_FLICKR, TrackerMinerFlickrPrivate))
enum  {
	TRACKER_MINER_FLICKR_DUMMY_PROPERTY
};
static GType tracker_miner_flickr_exif_tag_get_type (void) G_GNUC_UNUSED;
static GType tracker_miner_flickr_exif_metering_mode_get_type (void) G_GNUC_UNUSED;
static GType tracker_miner_flickr_exif_white_balance_get_type (void) G_GNUC_UNUSED;
#define TRACKER_MINER_FLICKR_MINER_NAME "Flickr"
#define TRACKER_MINER_FLICKR_MINER_DESCRIPTION "Tracker miner for Flickr"
#define TRACKER_MINER_FLICKR_API_KEY "7983269709fa3158c752e3e4d6b3b9e5"
#define TRACKER_MINER_FLICKR_SHARED_SECRET "c0316d1cb4b15e2d"
#define TRACKER_MINER_FLICKR_DATASOURCE_URN "urn:nepomuk:datasource:2208f9fc-3c5b-4e40-ade4-45a0d7b0cf6f"
#define TRACKER_MINER_FLICKR_FLICKR_AUTH_URL "http://api.flickr.com/services/auth/"
#define TRACKER_MINER_FLICKR_FLICKR_REST_URL "http://api.flickr.com/services/rest/"
#define TRACKER_MINER_FLICKR_FLICKR_PHOTOSET_URL "http://www.flickr.com/photos/%s/sets/%s"
#define TRACKER_MINER_FLICKR_FLICKR_PHOTO_URL "http://farm%s.static.flickr.com/%s/%s_%s.jpg"
#define TRACKER_MINER_FLICKR_NMM_PHOTO "http://www.tracker-project.org/temp/nmm#Photo"
#define TRACKER_MINER_FLICKR_PULL_INTERVAL ((guint) (5 * 60))
void tracker_miner_flickr_shutdown (TrackerMinerFlickr* self);
static void tracker_miner_flickr_init_datasource (TrackerMinerFlickr* self);
static gboolean tracker_miner_flickr_pull_timeout_cb (TrackerMinerFlickr* self);
static gboolean _tracker_miner_flickr_pull_timeout_cb_gsource_func (gpointer self);
static gboolean _lambda0_ (TrackerMinerFlickr* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void tracker_miner_flickr_association_status_changed (TrackerMinerFlickr* self, GObject* source, GParamSpec* pspec);
static void tracker_miner_flickr_init_pull (TrackerMinerFlickr* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_miner_flickr_init_pull_finish (TrackerMinerFlickr* self, GAsyncResult* _res_);
static void tracker_miner_flickr_init_pull_data_free (gpointer _data);
static void tracker_miner_flickr_init_pull_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _tracker_miner_flickr_init_pull_co_gsource_func (gpointer self);
static RestXmlNode* tracker_miner_flickr_run_call (TrackerMinerFlickr* self, RestProxyCall* call, GError** error);
static void tracker_miner_flickr_insert_photosets (TrackerMinerFlickr* self, RestXmlNode* root_node);
static gboolean tracker_miner_flickr_init_pull_co (TrackerMinerFlickrInitPullData* data);
static char* tracker_miner_flickr_get_resource (TrackerMinerFlickr* self, const char* graph, char** types, int types_length1, const char* identifier, gboolean* created, GError** error);
static void tracker_miner_flickr_insert_photos (TrackerMinerFlickr* self, RestXmlNode* root_node);
static void tracker_miner_flickr_insert_photo_info (TrackerMinerFlickr* self, RestXmlNode* photo_node, TrackerSparqlBuilder* builder, const char* graph, const char* urn);
static void tracker_miner_flickr_insert_exif_data (TrackerMinerFlickr* self, RestXmlNode* photo_node, TrackerSparqlBuilder* builder, const char* graph, const char* urn);
void tracker_miner_flickr_update_triple_string (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const char* graph, const char* urn, const char* property, const char* new_value);
void tracker_miner_flickr_update_triple_object (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const char* graph, const char* urn, const char* property, const char* new_value);
void tracker_miner_flickr_update_triple_double (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const char* graph, const char* urn, const char* property, double new_value);
static double tracker_miner_flickr_ratio_to_double (TrackerMinerFlickr* self, const char* ratio);
void tracker_miner_flickr_update_triple_int64 (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const char* graph, const char* urn, const char* property, gint64 new_value);
static void tracker_miner_flickr_add_tags (TrackerMinerFlickr* self, const char* photo_id, char** tags, int tags_length1);
static void tracker_miner_flickr_remove_tag (TrackerMinerFlickr* self, const char* tag_id);
static void tracker_miner_flickr_writeback_photo_data_free (gpointer _data);
static void tracker_miner_flickr_writeback_photo_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
static void _vala_array_add2 (char*** array, int* length, int* size, char* value);
static gint tracker_miner_flickr_array_search_str (TrackerMinerFlickr* self, const char* needle, char** haystack, int haystack_length1);
static void _vala_array_add3 (char*** array, int* length, int* size, char* value);
static void tracker_miner_flickr_writeback_photo (TrackerMinerFlickr* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_miner_flickr_writeback_photo_finish (TrackerMinerFlickr* self, GAsyncResult* _res_);
static gboolean tracker_miner_flickr_writeback_photo_co (TrackerMinerFlickrWritebackPhotoData* data);
static void tracker_miner_flickr_sign_call (TrackerMinerFlickr* self, RestProxyCall* call);
static GHashTable* tracker_miner_flickr_real_get_association_data (TrackerMinerWeb* base, GError** error);
static void tracker_miner_flickr_real_associate (TrackerMinerWeb* base, GHashTable* association_data, GError** error);
static void tracker_miner_flickr_real_authenticate (TrackerMinerWeb* base, GError** error);
static void tracker_miner_flickr_real_dissociate (TrackerMinerWeb* base, GError** error);
void tracker_miner_flickr_writeback (TrackerMinerFlickr* self, GHashTable* properties);
static void tracker_miner_flickr_signal_handler (gint signo);
static void _tracker_miner_flickr_signal_handler_sighandler_t (gint signal);
static void tracker_miner_flickr_init_signals (void);
void tracker_miner_flickr_main (char** args, int args_length1);
TrackerMinerFlickr* tracker_miner_flickr_new (void);
TrackerMinerFlickr* tracker_miner_flickr_construct (GType object_type);
static void _tracker_miner_flickr_writeback_tracker_writeback_callback (GHashTable* resources, gpointer self);
static void _tracker_miner_flickr_association_status_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static GObject * tracker_miner_flickr_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void tracker_miner_flickr_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark tracker_rest_call_error_quark (void) {
	return g_quark_from_static_string ("tracker_rest_call_error-quark");
}


static GType tracker_miner_flickr_exif_tag_get_type (void) {
	static volatile gsize tracker_miner_flickr_exif_tag_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_miner_flickr_exif_tag_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA, "TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA", "camera"}, {TRACKER_MINER_FLICKR_EXIF_TAG_FLASH, "TRACKER_MINER_FLICKR_EXIF_TAG_FLASH", "flash"}, {TRACKER_MINER_FLICKR_EXIF_TAG_FNUMBER, "TRACKER_MINER_FLICKR_EXIF_TAG_FNUMBER", "fnumber"}, {TRACKER_MINER_FLICKR_EXIF_TAG_FOCAL_LENGTH, "TRACKER_MINER_FLICKR_EXIF_TAG_FOCAL_LENGTH", "focal-length"}, {TRACKER_MINER_FLICKR_EXIF_TAG_ISO_SPEED, "TRACKER_MINER_FLICKR_EXIF_TAG_ISO_SPEED", "iso-speed"}, {TRACKER_MINER_FLICKR_EXIF_TAG_METERING_MODE, "TRACKER_MINER_FLICKR_EXIF_TAG_METERING_MODE", "metering-mode"}, {TRACKER_MINER_FLICKR_EXIF_TAG_WHITE_BALANCE, "TRACKER_MINER_FLICKR_EXIF_TAG_WHITE_BALANCE", "white-balance"}, {0, NULL, NULL}};
		GType tracker_miner_flickr_exif_tag_type_id;
		tracker_miner_flickr_exif_tag_type_id = g_enum_register_static ("TrackerMinerFlickrExifTag", values);
		g_once_init_leave (&tracker_miner_flickr_exif_tag_type_id__volatile, tracker_miner_flickr_exif_tag_type_id);
	}
	return tracker_miner_flickr_exif_tag_type_id__volatile;
}


static GType tracker_miner_flickr_exif_metering_mode_get_type (void) {
	static volatile gsize tracker_miner_flickr_exif_metering_mode_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_miner_flickr_exif_metering_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_MINER_FLICKR_EXIF_METERING_MODE_AVERAGE, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_AVERAGE", "average"}, {TRACKER_MINER_FLICKR_EXIF_METERING_MODE_CENTER_WEIGHTED_AVERAGE, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_CENTER_WEIGHTED_AVERAGE", "center-weighted-average"}, {TRACKER_MINER_FLICKR_EXIF_METERING_MODE_SPOT, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_SPOT", "spot"}, {TRACKER_MINER_FLICKR_EXIF_METERING_MODE_MULTISPOT, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_MULTISPOT", "multispot"}, {TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PATTERN, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PATTERN", "pattern"}, {TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PARTIAL, "TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PARTIAL", "partial"}, {0, NULL, NULL}};
		GType tracker_miner_flickr_exif_metering_mode_type_id;
		tracker_miner_flickr_exif_metering_mode_type_id = g_enum_register_static ("TrackerMinerFlickrExifMeteringMode", values);
		g_once_init_leave (&tracker_miner_flickr_exif_metering_mode_type_id__volatile, tracker_miner_flickr_exif_metering_mode_type_id);
	}
	return tracker_miner_flickr_exif_metering_mode_type_id__volatile;
}


static GType tracker_miner_flickr_exif_white_balance_get_type (void) {
	static volatile gsize tracker_miner_flickr_exif_white_balance_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_miner_flickr_exif_white_balance_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_AUTO, "TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_AUTO", "auto"}, {TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_MANUAL, "TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_MANUAL", "manual"}, {0, NULL, NULL}};
		GType tracker_miner_flickr_exif_white_balance_type_id;
		tracker_miner_flickr_exif_white_balance_type_id = g_enum_register_static ("TrackerMinerFlickrExifWhiteBalance", values);
		g_once_init_leave (&tracker_miner_flickr_exif_white_balance_type_id__volatile, tracker_miner_flickr_exif_white_balance_type_id);
	}
	return tracker_miner_flickr_exif_white_balance_type_id__volatile;
}


void tracker_miner_flickr_shutdown (TrackerMinerFlickr* self) {
	g_return_if_fail (self != NULL);
	g_object_set ((TrackerMiner*) self, "status", "Shutting down", NULL);
	g_object_set ((TrackerMinerWeb*) self, "associated", FALSE, NULL);
}


static void tracker_miner_flickr_init_datasource (TrackerMinerFlickr* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		tracker_resources_sparql_update (self->priv->tracker_client, _tmp0_ = g_strdup_printf ("insert { <%s> a nie:DataSource ; nao:identifier \"flickr\" }", TRACKER_MINER_FLICKR_DATASOURCE_URN), &_inner_error_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("tracker-miner-flickr.vala:107: Couldn't init datasource: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean _tracker_miner_flickr_pull_timeout_cb_gsource_func (gpointer self) {
	return tracker_miner_flickr_pull_timeout_cb (self);
}


static gboolean _lambda0_ (TrackerMinerFlickr* self) {
	gboolean result = FALSE;
	tracker_miner_flickr_pull_timeout_cb (self);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	return _lambda0_ (self);
}


static void tracker_miner_flickr_association_status_changed (TrackerMinerFlickr* self, GObject* source, GParamSpec* pspec) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (pspec != NULL);
	if ((g_object_get ((TrackerMinerWeb*) self, "associated", &_tmp0_, NULL), _tmp0_)) {
		if (self->priv->pull_timeout_handle != 0) {
			return;
		}
		g_message ("tracker-miner-flickr.vala:116: Miner is now associated. Initiating per" \
"iodic pull.");
		self->priv->pull_timeout_handle = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, TRACKER_MINER_FLICKR_PULL_INTERVAL, _tracker_miner_flickr_pull_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		if (self->priv->pull_timeout_handle == 0) {
			return;
		}
		g_source_remove (self->priv->pull_timeout_handle);
	}
}


static gboolean tracker_miner_flickr_pull_timeout_cb (TrackerMinerFlickr* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	tracker_miner_flickr_init_pull (self, NULL, NULL);
	result = TRUE;
	return result;
}


static void tracker_miner_flickr_init_pull_data_free (gpointer _data) {
	TrackerMinerFlickrInitPullData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (TrackerMinerFlickrInitPullData, data);
}


static void tracker_miner_flickr_init_pull (TrackerMinerFlickr* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerMinerFlickrInitPullData* _data_;
	_data_ = g_slice_new0 (TrackerMinerFlickrInitPullData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_miner_flickr_init_pull);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_miner_flickr_init_pull_data_free);
	_data_->self = g_object_ref (self);
	tracker_miner_flickr_init_pull_co (_data_);
}


static void tracker_miner_flickr_init_pull_finish (TrackerMinerFlickr* self, GAsyncResult* _res_) {
	TrackerMinerFlickrInitPullData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_miner_flickr_init_pull_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerMinerFlickrInitPullData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_miner_flickr_init_pull_co (data);
}


static gboolean _tracker_miner_flickr_init_pull_co_gsource_func (gpointer self) {
	return tracker_miner_flickr_init_pull_co (self);
}


static gboolean tracker_miner_flickr_init_pull_co (TrackerMinerFlickrInitPullData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_object_set ((TrackerMiner*) data->self, "status", "Refreshing photo albums", NULL);
		g_object_set ((TrackerMiner*) data->self, "progress", 0.0, NULL);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tracker_miner_flickr_init_pull_co_gsource_func, data, NULL);
		data->_state_ = 1;
		return FALSE;
		_state_1:
		;
		data->albums_call = (data->_tmp0_ = rest_proxy_new_call (data->self->priv->rest), _g_object_unref0 (data->albums_call), data->_tmp0_);
		rest_proxy_call_add_param (data->albums_call, "method", "flickr.photosets.getList");
		{
			data->_tmp1_ = tracker_miner_flickr_run_call (data->self, data->albums_call, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			data->photosets_node = (data->_tmp2_ = data->_tmp1_, _rest_xml_node_unref0 (data->photosets_node), data->_tmp2_);
			tracker_miner_flickr_insert_photosets (data->self, data->photosets_node);
		}
		goto __finally1;
		__catch1_g_error:
		{
			data->call_error = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->error_message = g_strdup_printf ("Could not get photosets list: %s", data->call_error->message);
				g_object_set ((TrackerMiner*) data->self, "status", data->error_message, NULL);
				g_warning ("tracker-miner-flickr.vala:153: %s", data->error_message);
				_g_error_free0 (data->call_error);
				_g_free0 (data->error_message);
			}
		}
		__finally1:
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->albums_call);
			_rest_xml_node_unref0 (data->photosets_node);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		g_object_set ((TrackerMiner*) data->self, "status", "Idle", NULL);
		g_object_set ((TrackerMiner*) data->self, "progress", 1.0, NULL);
		g_message ("tracker-miner-flickr.vala:158: Pull finished");
		_g_object_unref0 (data->albums_call);
		_rest_xml_node_unref0 (data->photosets_node);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gpointer _rest_xml_node_ref0 (gpointer self) {
	return self ? rest_xml_node_ref (self) : NULL;
}


static void tracker_miner_flickr_insert_photosets (TrackerMinerFlickr* self, RestXmlNode* root_node) {
	GError * _inner_error_;
	RestXmlNode* photoset_node;
	RestXmlNode* title_node;
	RestXmlNode* photos_node;
	char* photoset_url;
	char* photoset_identifier;
	gboolean resource_created = FALSE;
	char* photoset_urn;
	char* delete_query;
	RestProxyCall* photos_call;
	TrackerSparqlBuilder* builder;
	guint n_photosets = 0U;
	guint indexed_photosets;
	RestXmlNode* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_node != NULL);
	_inner_error_ = NULL;
	photoset_node = NULL;
	title_node = NULL;
	photos_node = NULL;
	photoset_url = NULL;
	photoset_identifier = NULL;
	photoset_urn = NULL;
	delete_query = NULL;
	photos_call = NULL;
	builder = NULL;
	indexed_photosets = (guint) 0;
	photoset_node = (_tmp0_ = _rest_xml_node_ref0 (rest_xml_node_find (root_node, "photoset")), _rest_xml_node_unref0 (photoset_node), _tmp0_);
	n_photosets = g_hash_table_size (root_node->children);
	while (TRUE) {
		RestXmlNode* _tmp15_;
		if (!(photoset_node != NULL)) {
			break;
		}
		{
			char* _tmp1_;
			char* _tmp2_;
			gint _tmp4__length1;
			char** _tmp4_;
			char** _tmp3_ = NULL;
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			TrackerSparqlBuilder* _tmp8_;
			RestXmlNode* _tmp10_;
			char* _tmp11_;
			RestProxyCall* _tmp12_;
			RestXmlNode* _tmp13_;
			RestXmlNode* _tmp14_;
			photoset_url = (_tmp1_ = g_strdup_printf (TRACKER_MINER_FLICKR_FLICKR_PHOTOSET_URL, self->priv->user_id, rest_xml_node_get_attr (photoset_node, "id")), _g_free0 (photoset_url), _tmp1_);
			photoset_identifier = (_tmp2_ = g_strdup_printf ("flickr:photoset:%s", rest_xml_node_get_attr (photoset_node, "id")), _g_free0 (photoset_identifier), _tmp2_);
			_tmp6_ = (_tmp5_ = tracker_miner_flickr_get_resource (self, photoset_url, (_tmp4_ = (_tmp3_ = g_new0 (char*, 2 + 1), _tmp3_[0] = g_strdup ("nfo:MediaList"), _tmp3_[1] = g_strdup ("nfo:RemoteDataObject"), _tmp3_), _tmp4__length1 = 2, _tmp4_), 2, photoset_identifier, &resource_created, &_inner_error_), _tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL), _tmp5_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			photoset_urn = (_tmp7_ = _tmp6_, _g_free0 (photoset_urn), _tmp7_);
			g_message ("tracker-miner-flickr.vala:187: Getting photos for album %s", photoset_url);
			builder = (_tmp8_ = tracker_sparql_builder_new_update (), _g_object_unref0 (builder), _tmp8_);
			tracker_sparql_builder_insert_open (builder, photoset_url);
			tracker_sparql_builder_subject_iri (builder, photoset_urn);
			if (!resource_created) {
				char* _tmp9_;
				delete_query = (_tmp9_ = g_strdup_printf ("delete { <%1$s> nie:title ?title }" "where  { <%1$s> nie:title ?title }", photoset_urn), _g_free0 (delete_query), _tmp9_);
				tracker_resources_sparql_update (self->priv->tracker_client, delete_query, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch2_g_error;
				}
			} else {
				tracker_sparql_builder_predicate (builder, "nie:dataSource");
				tracker_sparql_builder_object_iri (builder, TRACKER_MINER_FLICKR_DATASOURCE_URN);
				tracker_sparql_builder_predicate (builder, "nie:url");
				tracker_sparql_builder_object_string (builder, photoset_url);
			}
			title_node = (_tmp10_ = _rest_xml_node_ref0 (rest_xml_node_find (photoset_node, "title")), _rest_xml_node_unref0 (title_node), _tmp10_);
			if (title_node != NULL) {
				tracker_sparql_builder_predicate (builder, "nie:title");
				tracker_sparql_builder_object_string (builder, title_node->content);
			}
			tracker_sparql_builder_insert_close (builder);
			tracker_resources_sparql_update (self->priv->tracker_client, tracker_sparql_builder_get_result (builder), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			g_object_set ((TrackerMiner*) self, "status", _tmp11_ = g_strdup_printf ("Refresing album \"%s\"", title_node->content), NULL);
			_g_free0 (_tmp11_);
			photos_call = (_tmp12_ = rest_proxy_new_call (self->priv->rest), _g_object_unref0 (photos_call), _tmp12_);
			rest_proxy_call_add_params (photos_call, "method", "flickr.photosets.getPhotos", "photoset_id", rest_xml_node_get_attr (photoset_node, "id"), "media", "photos", "extras", "original_format", NULL);
			_tmp13_ = tracker_miner_flickr_run_call (self, photos_call, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			photos_node = (_tmp14_ = _tmp13_, _rest_xml_node_unref0 (photos_node), _tmp14_);
			tracker_miner_flickr_insert_photos (self, photos_node);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				char* error_message;
				error_message = g_strdup_printf ("Could not list photos for photoset %s: %s", photoset_url, err->message);
				g_object_set ((TrackerMiner*) self, "status", error_message, NULL);
				g_warning ("tracker-miner-flickr.vala:227: %s", error_message);
				_g_error_free0 (err);
				_g_free0 (error_message);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_rest_xml_node_unref0 (photoset_node);
			_rest_xml_node_unref0 (title_node);
			_rest_xml_node_unref0 (photos_node);
			_g_free0 (photoset_url);
			_g_free0 (photoset_identifier);
			_g_free0 (photoset_urn);
			_g_free0 (delete_query);
			_g_object_unref0 (photos_call);
			_g_object_unref0 (builder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		photoset_node = (_tmp15_ = _rest_xml_node_ref0 (photoset_node->next), _rest_xml_node_unref0 (photoset_node), _tmp15_);
		indexed_photosets++;
		g_object_set ((TrackerMiner*) self, "progress", ((double) indexed_photosets) / n_photosets, NULL);
	}
	_rest_xml_node_unref0 (photoset_node);
	_rest_xml_node_unref0 (title_node);
	_rest_xml_node_unref0 (photos_node);
	_g_free0 (photoset_url);
	_g_free0 (photoset_identifier);
	_g_free0 (photoset_urn);
	_g_free0 (delete_query);
	_g_object_unref0 (photos_call);
	_g_object_unref0 (builder);
}


static void tracker_miner_flickr_insert_photos (TrackerMinerFlickr* self, RestXmlNode* root_node) {
	GError * _inner_error_;
	RestXmlNode* photoset_node;
	char* photoset_url;
	RestXmlNode* photo_node;
	char* photo_url;
	char* photo_urn;
	gboolean resource_created = FALSE;
	TrackerSparqlBuilder* builder;
	RestXmlNode* _tmp0_;
	gboolean _tmp1_ = FALSE;
	char* _tmp2_;
	RestXmlNode* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_node != NULL);
	_inner_error_ = NULL;
	photoset_node = NULL;
	photoset_url = NULL;
	photo_node = NULL;
	photo_url = NULL;
	photo_urn = NULL;
	builder = NULL;
	photoset_node = (_tmp0_ = _rest_xml_node_ref0 (rest_xml_node_find (root_node, "photoset")), _rest_xml_node_unref0 (photoset_node), _tmp0_);
	if (photoset_node == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = rest_xml_node_get_attr (photoset_node, "id") == NULL;
	}
	if (_tmp1_) {
		g_warning ("tracker-miner-flickr.vala:247: Malformed response for flickr.photosets" \
".getPhotos");
		_rest_xml_node_unref0 (photoset_node);
		_g_free0 (photoset_url);
		_rest_xml_node_unref0 (photo_node);
		_g_free0 (photo_url);
		_g_free0 (photo_urn);
		_g_object_unref0 (builder);
		return;
	}
	photoset_url = (_tmp2_ = g_strdup_printf (TRACKER_MINER_FLICKR_FLICKR_PHOTOSET_URL, self->priv->user_id, rest_xml_node_get_attr (photoset_node, "id")), _g_free0 (photoset_url), _tmp2_);
	g_message ("tracker-miner-flickr.vala:252: Indexing photoset %s", photoset_url);
	photo_node = (_tmp3_ = _rest_xml_node_ref0 (rest_xml_node_find (root_node, "photo")), _rest_xml_node_unref0 (photo_node), _tmp3_);
	while (TRUE) {
		RestXmlNode* _tmp12_;
		if (!(photo_node != NULL)) {
			break;
		}
		{
			char* _tmp4_;
			char* _tmp7_;
			gint _tmp6__length1;
			char** _tmp6_;
			char** _tmp5_ = NULL;
			char* _tmp8_;
			char* _tmp9_;
			char* _tmp10_;
			TrackerSparqlBuilder* _tmp11_;
			photo_url = (_tmp4_ = g_strdup_printf (TRACKER_MINER_FLICKR_FLICKR_PHOTO_URL, rest_xml_node_get_attr (photo_node, "farm"), rest_xml_node_get_attr (photo_node, "server"), rest_xml_node_get_attr (photo_node, "id"), rest_xml_node_get_attr (photo_node, "secret")), _g_free0 (photo_url), _tmp4_);
			_tmp9_ = (_tmp8_ = tracker_miner_flickr_get_resource (self, photo_url, (_tmp6_ = (_tmp5_ = g_new0 (char*, 3 + 1), _tmp5_[0] = g_strdup ("nmm:Photo"), _tmp5_[1] = g_strdup ("nfo:RemoteDataObject"), _tmp5_[2] = g_strdup ("nfo:MediaFileListEntry"), _tmp5_), _tmp6__length1 = 3, _tmp6_), 3, _tmp7_ = g_strdup_printf ("flickr:photo:%s", rest_xml_node_get_attr (photo_node, "id")), &resource_created, &_inner_error_), _g_free0 (_tmp7_), _tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL), _tmp8_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			photo_urn = (_tmp10_ = _tmp9_, _g_free0 (photo_urn), _tmp10_);
			builder = (_tmp11_ = tracker_sparql_builder_new_update (), _g_object_unref0 (builder), _tmp11_);
			if (resource_created) {
				tracker_sparql_builder_insert_open (builder, photo_url);
				tracker_sparql_builder_subject_iri (builder, photo_urn);
				tracker_sparql_builder_predicate (builder, "nie:dataSource");
				tracker_sparql_builder_object_iri (builder, TRACKER_MINER_FLICKR_DATASOURCE_URN);
				tracker_sparql_builder_predicate (builder, "nie:url");
				tracker_sparql_builder_object_string (builder, photo_url);
				tracker_sparql_builder_insert_close (builder);
			}
			tracker_miner_flickr_insert_photo_info (self, photo_node, builder, photo_url, photo_urn);
			tracker_miner_flickr_insert_exif_data (self, photo_node, builder, photo_url, photo_urn);
			tracker_resources_sparql_update (self->priv->tracker_client, tracker_sparql_builder_get_result (builder), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("tracker-miner-flickr.vala:285: Couldn't insert photo %s: %s", photo_url, err->message);
				_g_error_free0 (err);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_rest_xml_node_unref0 (photoset_node);
			_g_free0 (photoset_url);
			_rest_xml_node_unref0 (photo_node);
			_g_free0 (photo_url);
			_g_free0 (photo_urn);
			_g_object_unref0 (builder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		photo_node = (_tmp12_ = _rest_xml_node_ref0 (photo_node->next), _rest_xml_node_unref0 (photo_node), _tmp12_);
	}
	_rest_xml_node_unref0 (photoset_node);
	_g_free0 (photoset_url);
	_rest_xml_node_unref0 (photo_node);
	_g_free0 (photo_url);
	_g_free0 (photo_urn);
	_g_object_unref0 (builder);
}


static void tracker_miner_flickr_insert_photo_info (TrackerMinerFlickr* self, RestXmlNode* photo_node, TrackerSparqlBuilder* builder, const char* graph, const char* urn) {
	GError * _inner_error_;
	RestProxyCall* info_call;
	RestXmlNode* root_node;
	RestXmlNode* title_node;
	RestXmlNode* description_node;
	RestXmlNode* tag_node;
	RestXmlNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	RestXmlNode* _tmp4_;
	gboolean _tmp5_ = FALSE;
	RestXmlNode* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_node != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	_inner_error_ = NULL;
	info_call = rest_proxy_new_call (self->priv->rest);
	root_node = NULL;
	title_node = NULL;
	description_node = NULL;
	tag_node = NULL;
	rest_proxy_call_add_params (info_call, "method", "flickr.photos.getInfo", "photo_id", rest_xml_node_get_attr (photo_node, "id"), NULL);
	{
		RestXmlNode* _tmp0_;
		RestXmlNode* _tmp1_;
		_tmp0_ = tracker_miner_flickr_run_call (self, info_call, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		root_node = (_tmp1_ = _tmp0_, _rest_xml_node_unref0 (root_node), _tmp1_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * call_error;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		{
			char* error_message;
			error_message = g_strdup_printf ("Couldn't get info for photo %s: %s", rest_xml_node_get_attr (photo_node, "id"), call_error->message);
			g_object_set ((TrackerMiner*) self, "status", error_message, NULL);
			g_warning ("tracker-miner-flickr.vala:307: %s", error_message);
			_g_error_free0 (call_error);
			_g_free0 (error_message);
			_g_object_unref0 (info_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (title_node);
			_rest_xml_node_unref0 (description_node);
			_rest_xml_node_unref0 (tag_node);
			return;
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (info_call);
		_rest_xml_node_unref0 (root_node);
		_rest_xml_node_unref0 (title_node);
		_rest_xml_node_unref0 (description_node);
		_rest_xml_node_unref0 (tag_node);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	title_node = (_tmp2_ = _rest_xml_node_ref0 (rest_xml_node_find (root_node, "title")), _rest_xml_node_unref0 (title_node), _tmp2_);
	if (title_node != NULL) {
		_tmp3_ = title_node->content != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		tracker_miner_flickr_update_triple_string (self, builder, graph, urn, "nie:title", title_node->content);
	}
	description_node = (_tmp4_ = _rest_xml_node_ref0 (rest_xml_node_find (root_node, "description")), _rest_xml_node_unref0 (description_node), _tmp4_);
	if (description_node != NULL) {
		_tmp5_ = description_node->content != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		tracker_miner_flickr_update_triple_string (self, builder, graph, urn, "nie:comment", description_node->content);
	}
	tag_node = (_tmp6_ = _rest_xml_node_ref0 (rest_xml_node_find (rest_xml_node_find (root_node, "tags"), "tag")), _rest_xml_node_unref0 (tag_node), _tmp6_);
	tracker_sparql_builder_insert_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	while (TRUE) {
		RestXmlNode* _tmp7_;
		if (!(tag_node != NULL)) {
			break;
		}
		tracker_sparql_builder_predicate (builder, "nao:hasTag");
		tracker_sparql_builder_object_blank_open (builder);
		tracker_sparql_builder_predicate (builder, "a");
		tracker_sparql_builder_object (builder, "nao:Tag");
		tracker_sparql_builder_predicate (builder, "nao:prefLabel");
		tracker_sparql_builder_object_string (builder, rest_xml_node_get_attr (tag_node, "raw"));
		tracker_sparql_builder_object_blank_close (builder);
		tag_node = (_tmp7_ = _rest_xml_node_ref0 (tag_node->next), _rest_xml_node_unref0 (tag_node), _tmp7_);
	}
	tracker_sparql_builder_insert_close (builder);
	_g_object_unref0 (info_call);
	_rest_xml_node_unref0 (root_node);
	_rest_xml_node_unref0 (title_node);
	_rest_xml_node_unref0 (description_node);
	_rest_xml_node_unref0 (tag_node);
}


static void tracker_miner_flickr_insert_exif_data (TrackerMinerFlickr* self, RestXmlNode* photo_node, TrackerSparqlBuilder* builder, const char* graph, const char* urn) {
	GError * _inner_error_;
	RestProxyCall* exif_call;
	RestXmlNode* root_node;
	RestXmlNode* exif_node;
	char* exif_value;
	RestXmlNode* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_node != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	_inner_error_ = NULL;
	exif_call = rest_proxy_new_call (self->priv->rest);
	root_node = NULL;
	exif_node = NULL;
	exif_value = NULL;
	rest_proxy_call_add_params (exif_call, "method", "flickr.photos.getExif", "photo_id", rest_xml_node_get_attr (photo_node, "id"), NULL);
	{
		RestXmlNode* _tmp0_;
		RestXmlNode* _tmp1_;
		_tmp0_ = tracker_miner_flickr_run_call (self, exif_call, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		root_node = (_tmp1_ = _tmp0_, _rest_xml_node_unref0 (root_node), _tmp1_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * call_error;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		{
			char* error_message;
			error_message = g_strdup_printf ("Couldn't get EXIF data for photo %s: %s", rest_xml_node_get_attr (photo_node, "id"), call_error->message);
			g_object_set ((TrackerMiner*) self, "status", error_message, NULL);
			g_warning ("tracker-miner-flickr.vala:356: %s", error_message);
			_g_error_free0 (call_error);
			_g_free0 (error_message);
			_g_object_unref0 (exif_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (exif_node);
			_g_free0 (exif_value);
			return;
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (exif_call);
		_rest_xml_node_unref0 (root_node);
		_rest_xml_node_unref0 (exif_node);
		_g_free0 (exif_value);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	exif_node = (_tmp2_ = _rest_xml_node_ref0 (rest_xml_node_find (root_node, "exif")), _rest_xml_node_unref0 (exif_node), _tmp2_);
	while (TRUE) {
		char* _tmp3_;
		RestXmlNode* _tmp5_;
		if (!(exif_node != NULL)) {
			break;
		}
		exif_value = (_tmp3_ = g_strdup (rest_xml_node_find (exif_node, "raw")->content), _g_free0 (exif_value), _tmp3_);
		switch (atoi (rest_xml_node_get_attr (exif_node, "tag"))) {
			case TRACKER_MINER_FLICKR_EXIF_TAG_CAMERA:
			{
				tracker_miner_flickr_update_triple_string (self, builder, graph, urn, "nmm:camera", exif_value);
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_FLASH:
			{
				const char* _tmp4_;
				_tmp4_ = NULL;
				if ((atoi (exif_value) % 2) == 1) {
					_tmp4_ = "nmm:flash-on";
				} else {
					_tmp4_ = "nmm:flash-off";
				}
				tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:flash", _tmp4_);
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_FNUMBER:
			{
				tracker_miner_flickr_update_triple_double (self, builder, graph, urn, "nmm:fnumber", tracker_miner_flickr_ratio_to_double (self, exif_value));
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_FOCAL_LENGTH:
			{
				tracker_miner_flickr_update_triple_double (self, builder, graph, urn, "nmm:focalLength", tracker_miner_flickr_ratio_to_double (self, exif_value));
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_ISO_SPEED:
			{
				tracker_miner_flickr_update_triple_int64 (self, builder, graph, urn, "nmm:isoSpeed", (gint64) atoi (exif_value));
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_METERING_MODE:
			{
				switch (atoi (exif_value)) {
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_AVERAGE:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-average");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_CENTER_WEIGHTED_AVERAGE:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-center-weighted-average");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_SPOT:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-spot");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_MULTISPOT:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-multispot");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PATTERN:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-pattern");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_METERING_MODE_PARTIAL:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-partial");
						break;
					}
					default:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:meteringMode", "nmm:meteringMode-other");
						break;
					}
				}
				break;
			}
			case TRACKER_MINER_FLICKR_EXIF_TAG_WHITE_BALANCE:
			{
				switch (atoi (exif_value)) {
					case TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_AUTO:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:whiteBalance", "nmm:whiteBalance-auto");
						break;
					}
					case TRACKER_MINER_FLICKR_EXIF_WHITE_BALANCE_MANUAL:
					{
						tracker_miner_flickr_update_triple_object (self, builder, graph, urn, "nmm:whiteBalance", "nmm:whiteBalance-manual");
						break;
					}
				}
				break;
			}
			default:
			{
				break;
			}
		}
		exif_node = (_tmp5_ = _rest_xml_node_ref0 (exif_node->next), _rest_xml_node_unref0 (exif_node), _tmp5_);
	}
	_g_object_unref0 (exif_call);
	_rest_xml_node_unref0 (root_node);
	_rest_xml_node_unref0 (exif_node);
	_g_free0 (exif_value);
}


static void tracker_miner_flickr_add_tags (TrackerMinerFlickr* self, const char* photo_id, char** tags, int tags_length1) {
	GError * _inner_error_;
	RestProxyCall* tag_call;
	RestProxyCall* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo_id != NULL);
	_inner_error_ = NULL;
	tag_call = NULL;
	tag_call = (_tmp0_ = rest_proxy_new_call (self->priv->rest), _g_object_unref0 (tag_call), _tmp0_);
	rest_proxy_call_add_params (tag_call, "method", "flickr.photos.addTags", "photo_id", photo_id, "tags", _tmp1_ = g_strjoinv (",", tags), NULL);
	_g_free0 (_tmp1_);
	{
		RestXmlNode* _tmp2_;
		_tmp2_ = tracker_miner_flickr_run_call (self, tag_call, &_inner_error_);
		_rest_xml_node_unref0 (_tmp2_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * call_error;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		{
			char* error_message;
			error_message = g_strdup_printf ("Couldn't add tags for photo %s: %s", photo_id, call_error->message);
			g_object_set ((TrackerMiner*) self, "status", error_message, NULL);
			g_warning ("tracker-miner-flickr.vala:436: %s", error_message);
			_g_error_free0 (call_error);
			_g_free0 (error_message);
			_g_object_unref0 (tag_call);
			return;
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (tag_call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (tag_call);
}


static void tracker_miner_flickr_remove_tag (TrackerMinerFlickr* self, const char* tag_id) {
	GError * _inner_error_;
	RestProxyCall* tag_call;
	RestProxyCall* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag_id != NULL);
	_inner_error_ = NULL;
	tag_call = NULL;
	tag_call = (_tmp0_ = rest_proxy_new_call (self->priv->rest), _g_object_unref0 (tag_call), _tmp0_);
	rest_proxy_call_add_params (tag_call, "method", "flickr.photos.removeTag", "tag_id", tag_id, NULL);
	{
		RestXmlNode* _tmp1_;
		_tmp1_ = tracker_miner_flickr_run_call (self, tag_call, &_inner_error_);
		_rest_xml_node_unref0 (_tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * call_error;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		{
			char* error_message;
			error_message = g_strdup_printf ("Couldn't remove tag: %s", call_error->message);
			g_object_set ((TrackerMiner*) self, "status", error_message, NULL);
			g_warning ("tracker-miner-flickr.vala:453: %s", error_message);
			_g_error_free0 (call_error);
			_g_free0 (error_message);
			_g_object_unref0 (tag_call);
			return;
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (tag_call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (tag_call);
}


static void tracker_miner_flickr_writeback_photo_data_free (gpointer _data) {
	TrackerMinerFlickrWritebackPhotoData* data;
	data = _data;
	_g_free0 (data->uri);
	g_object_unref (data->self);
	g_slice_free (TrackerMinerFlickrWritebackPhotoData, data);
}


static void tracker_miner_flickr_writeback_photo (TrackerMinerFlickr* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerMinerFlickrWritebackPhotoData* _data_;
	_data_ = g_slice_new0 (TrackerMinerFlickrWritebackPhotoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_miner_flickr_writeback_photo);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_miner_flickr_writeback_photo_data_free);
	_data_->self = g_object_ref (self);
	_data_->uri = g_strdup (uri);
	tracker_miner_flickr_writeback_photo_co (_data_);
}


static void tracker_miner_flickr_writeback_photo_finish (TrackerMinerFlickr* self, GAsyncResult* _res_) {
	TrackerMinerFlickrWritebackPhotoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_miner_flickr_writeback_photo_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerMinerFlickrWritebackPhotoData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_miner_flickr_writeback_photo_co (data);
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean tracker_miner_flickr_writeback_photo_co (TrackerMinerFlickrWritebackPhotoData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = NULL;
		data->local_tags = (data->_tmp1_ = (data->_tmp0_ = g_new0 (char*, 0 + 1), data->_tmp0_), data->local_tags_length1 = 0, data->_local_tags_size_ = data->local_tags_length1, data->_tmp1_);
		data->flickr_tags = g_hash_table_new (g_str_hash, g_str_equal);
		data->_tmp2_ = NULL;
		data->tags_to_add = (data->_tmp3_ = (data->_tmp2_ = g_new0 (char*, 0 + 1), data->_tmp2_), data->tags_to_add_length1 = 0, data->_tags_to_add_size_ = data->tags_to_add_length1, data->_tmp3_);
		data->_tmp4_ = NULL;
		data->tags_to_remove = (data->_tmp5_ = (data->_tmp4_ = g_new0 (char*, 0 + 1), data->_tmp4_), data->tags_to_remove_length1 = 0, data->_tags_to_remove_size_ = data->tags_to_remove_length1, data->_tmp5_);
		{
			data->_state_ = 2;
			tracker_miner_execute_sparql ((TrackerMiner*) data->self, data->_tmp6_ = g_strdup_printf ("select ?photo_id ?tag where { <%s> nie:dataSource <%s> ;" "nao:identifier ?photo_id ;" "nao:hasTag ?t ." "?t nao:prefLabel ?tag }", data->uri, TRACKER_MINER_FLICKR_DATASOURCE_URN), NULL, tracker_miner_flickr_writeback_photo_ready, data);
			return FALSE;
			_state_2:
			data->_tmp8_ = (data->_tmp7_ = tracker_miner_execute_sparql_finish ((TrackerMiner*) data->self, data->_res_, &data->_inner_error_), _g_free0 (data->_tmp6_), data->_tmp7_);
			if (data->_inner_error_ != NULL) {
				goto __catch8_g_error;
			}
			data->results = data->_tmp8_;
		}
		goto __finally8;
		__catch8_g_error:
		{
			data->tracker_error = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_warning ("tracker-miner-flickr.vala:476: Tracker error when doing writeback for " \
"photo %s: %s", data->uri, data->tracker_error->message);
				_g_error_free0 (data->tracker_error);
				_g_free0 (data->photo_id);
				data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
				_g_hash_table_unref0 (data->flickr_tags);
				data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
				data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (data->tag_call);
				_rest_xml_node_unref0 (data->root_node);
				_rest_xml_node_unref0 (data->tag_node);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->tracker_error);
			}
		}
		__finally8:
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->photo_id);
			data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
			_g_hash_table_unref0 (data->flickr_tags);
			data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
			data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data->tag_call);
			_rest_xml_node_unref0 (data->root_node);
			_rest_xml_node_unref0 (data->tag_node);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		if (data->results->len == 0) {
			_g_free0 (data->photo_id);
			data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
			_g_hash_table_unref0 (data->flickr_tags);
			data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
			data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data->tag_call);
			_rest_xml_node_unref0 (data->root_node);
			_rest_xml_node_unref0 (data->tag_node);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->triples = (data->_tmp9_ = (char***) data->results->pdata, data->triples_length1 = -1, data->_triples_size_ = data->triples_length1, data->_tmp9_);
		data->photo_id = (data->_tmp10_ = g_strdup (data->triples[0][0]), _g_free0 (data->photo_id), data->_tmp10_);
		{
			data->i = (guint) 0;
			{
				data->_tmp11_ = TRUE;
				while (TRUE) {
					if (!data->_tmp11_) {
						data->i = data->i + 1;
					}
					data->_tmp11_ = FALSE;
					if (!(data->i < data->results->len)) {
						break;
					}
					_vala_array_add1 (&data->local_tags, &data->local_tags_length1, &data->_local_tags_size_, g_strdup (data->triples[data->i][1]));
				}
			}
		}
		data->tag_call = (data->_tmp12_ = rest_proxy_new_call (data->self->priv->rest), _g_object_unref0 (data->tag_call), data->_tmp12_);
		rest_proxy_call_add_params (data->tag_call, "method", "flickr.tags.getListPhoto", "photo_id", data->photo_id, NULL);
		{
			data->_tmp13_ = tracker_miner_flickr_run_call (data->self, data->tag_call, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			data->root_node = (data->_tmp14_ = data->_tmp13_, _rest_xml_node_unref0 (data->root_node), data->_tmp14_);
		}
		goto __finally9;
		__catch9_g_error:
		{
			data->get_tags_error = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				data->error_message = g_strdup_printf ("Couldn't get tags for photo %s: %s", data->uri, data->get_tags_error->message);
				g_object_set ((TrackerMiner*) data->self, "status", data->error_message, NULL);
				g_warning ("tracker-miner-flickr.vala:499: %s", data->error_message);
				_g_error_free0 (data->get_tags_error);
				_g_free0 (data->error_message);
				_g_free0 (data->photo_id);
				data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
				_g_hash_table_unref0 (data->flickr_tags);
				data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
				data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (data->tag_call);
				_rest_xml_node_unref0 (data->root_node);
				_rest_xml_node_unref0 (data->tag_node);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				_g_error_free0 (data->get_tags_error);
				_g_free0 (data->error_message);
			}
		}
		__finally9:
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->photo_id);
			data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
			_g_hash_table_unref0 (data->flickr_tags);
			data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
			data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data->tag_call);
			_rest_xml_node_unref0 (data->root_node);
			_rest_xml_node_unref0 (data->tag_node);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		data->tag_node = (data->_tmp15_ = _rest_xml_node_ref0 (rest_xml_node_find (rest_xml_node_find (data->root_node, "tags"), "tag")), _rest_xml_node_unref0 (data->tag_node), data->_tmp15_);
		while (TRUE) {
			if (!(data->tag_node != NULL)) {
				break;
			}
			g_hash_table_insert (data->flickr_tags, g_strdup (rest_xml_node_get_attr (data->tag_node, "raw")), g_strdup (rest_xml_node_get_attr (data->tag_node, "id")));
			data->tag_node = (data->_tmp16_ = _rest_xml_node_ref0 (data->tag_node->next), _rest_xml_node_unref0 (data->tag_node), data->_tmp16_);
		}
		{
			data->local_tag_collection = data->local_tags;
			data->local_tag_collection_length1 = data->local_tags_length1;
			for (data->local_tag_it = 0; data->local_tag_it < data->local_tags_length1; data->local_tag_it = data->local_tag_it + 1) {
				data->local_tag = g_strdup (data->local_tag_collection[data->local_tag_it]);
				{
					if (((const char*) g_hash_table_lookup (data->flickr_tags, data->local_tag)) == NULL) {
						_vala_array_add2 (&data->tags_to_add, &data->tags_to_add_length1, &data->_tags_to_add_size_, g_strdup (data->local_tag));
					}
					_g_free0 (data->local_tag);
				}
			}
		}
		{
			data->flickr_tag_collection = g_hash_table_get_keys (data->flickr_tags);
			for (data->flickr_tag_it = data->flickr_tag_collection; data->flickr_tag_it != NULL; data->flickr_tag_it = data->flickr_tag_it->next) {
				data->flickr_tag = (const char*) data->flickr_tag_it->data;
				{
					if (tracker_miner_flickr_array_search_str (data->self, data->flickr_tag, data->local_tags, data->local_tags_length1) == (-1)) {
						_vala_array_add3 (&data->tags_to_remove, &data->tags_to_remove_length1, &data->_tags_to_remove_size_, g_strdup ((const char*) g_hash_table_lookup (data->flickr_tags, data->flickr_tag)));
					}
				}
			}
			_g_list_free0 (data->flickr_tag_collection);
		}
		tracker_miner_flickr_add_tags (data->self, data->photo_id, data->tags_to_add, data->tags_to_add_length1);
		{
			data->tag_collection = data->tags_to_remove;
			data->tag_collection_length1 = data->tags_to_remove_length1;
			for (data->tag_it = 0; data->tag_it < data->tags_to_remove_length1; data->tag_it = data->tag_it + 1) {
				data->tag = g_strdup (data->tag_collection[data->tag_it]);
				{
					tracker_miner_flickr_remove_tag (data->self, data->tag);
					_g_free0 (data->tag);
				}
			}
		}
		_g_free0 (data->photo_id);
		data->local_tags = (_vala_array_free (data->local_tags, data->local_tags_length1, (GDestroyNotify) g_free), NULL);
		_g_hash_table_unref0 (data->flickr_tags);
		data->tags_to_add = (_vala_array_free (data->tags_to_add, data->tags_to_add_length1, (GDestroyNotify) g_free), NULL);
		data->tags_to_remove = (_vala_array_free (data->tags_to_remove, data->tags_to_remove_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (data->tag_call);
		_rest_xml_node_unref0 (data->root_node);
		_rest_xml_node_unref0 (data->tag_node);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static double tracker_miner_flickr_ratio_to_double (TrackerMinerFlickr* self, const char* ratio) {
	double result = 0.0;
	char** _tmp1_;
	gint _tokens_size_;
	gint tokens_length1;
	char** _tmp0_;
	char** tokens;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (ratio != NULL, 0.0);
	tokens = (_tmp1_ = _tmp0_ = g_strsplit (ratio, "/", 0), tokens_length1 = _vala_array_length (_tmp0_), _tokens_size_ = tokens_length1, _tmp1_);
	if (atoi (tokens[1]) == 0) {
		g_critical ("tracker-miner-flickr.vala:531: fracToDouble : divide by zero while par" \
"sing ratio '%s'", ratio);
		result = (double) 0;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = (atoi (tokens[0]) * 1.0) / atoi (tokens[1]);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gint tracker_miner_flickr_array_search_str (TrackerMinerFlickr* self, const char* needle, char** haystack, int haystack_length1) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i = i + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < haystack_length1)) {
					break;
				}
				if (_vala_strcmp0 (haystack[i], needle) == 0) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void tracker_miner_flickr_sign_call (TrackerMinerFlickr* self, RestProxyCall* call) {
	GString* signature;
	GHashTable* parameters;
	GList* parameter_names;
	GString* _tmp0_;
	GHashTable* _tmp1_;
	GList* _tmp3_;
	GList* _tmp2_;
	char* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (call != NULL);
	signature = NULL;
	parameters = NULL;
	parameter_names = NULL;
	rest_proxy_call_add_param (call, "api_key", TRACKER_MINER_FLICKR_API_KEY);
	if (self->priv->auth_token != NULL) {
		rest_proxy_call_add_param (call, "auth_token", self->priv->auth_token);
	}
	signature = (_tmp0_ = g_string_new (TRACKER_MINER_FLICKR_SHARED_SECRET), _g_string_free0 (signature), _tmp0_);
	parameters = (_tmp1_ = _g_hash_table_ref0 (rest_proxy_call_get_params (call)), _g_hash_table_unref0 (parameters), _tmp1_);
	parameter_names = (_tmp3_ = g_list_copy (_tmp2_ = g_hash_table_get_keys (parameters)), _g_list_free0 (parameter_names), _tmp3_);
	_g_list_free0 (_tmp2_);
	parameter_names = g_list_sort (parameter_names, (GCompareFunc) strcmp);
	{
		GList* parameter_collection;
		GList* parameter_it;
		parameter_collection = parameter_names;
		for (parameter_it = parameter_collection; parameter_it != NULL; parameter_it = parameter_it->next) {
			char* parameter;
			parameter = g_strdup ((const char*) parameter_it->data);
			{
				g_string_append (signature, parameter);
				g_string_append (signature, (const char*) g_hash_table_lookup (parameters, parameter));
				_g_free0 (parameter);
			}
		}
	}
	rest_proxy_call_add_param (call, "api_sig", _tmp4_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, signature->str, -1));
	_g_free0 (_tmp4_);
	_g_string_free0 (signature);
	_g_hash_table_unref0 (parameters);
	_g_list_free0 (parameter_names);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static RestXmlNode* tracker_miner_flickr_run_call (TrackerMinerFlickr* self, RestProxyCall* call, GError** error) {
	RestXmlNode* result = NULL;
	GError * _inner_error_;
	RestXmlParser* parser;
	RestXmlNode* root_node;
	RestXmlParser* _tmp0_;
	RestXmlNode* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (call != NULL, NULL);
	_inner_error_ = NULL;
	parser = NULL;
	root_node = NULL;
	tracker_miner_flickr_sign_call (self, call);
	{
		rest_proxy_call_run (call, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * call_error;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = _g_error_copy0 (call_error);
			{
				_g_error_free0 (call_error);
				_g_object_unref0 (parser);
				_rest_xml_node_unref0 (root_node);
				goto __finally10;
			}
			_g_error_free0 (call_error);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (parser);
		_rest_xml_node_unref0 (root_node);
		return NULL;
	}
	parser = (_tmp0_ = rest_xml_parser_new (), _g_object_unref0 (parser), _tmp0_);
	root_node = (_tmp1_ = _rest_xml_node_ref0 (rest_xml_parser_parse_from_data (parser, rest_proxy_call_get_payload (call), rest_proxy_call_get_payload_length (call))), _rest_xml_node_unref0 (root_node), _tmp1_);
	if (root_node == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = _vala_strcmp0 (root_node->name, "rsp") != 0;
	}
	if (_tmp2_) {
		_inner_error_ = g_error_new_literal (TRACKER_REST_CALL_ERROR, TRACKER_REST_CALL_ERROR_INVALID_RESPONSE, "Empty payload or root node not \"rsp\"");
		{
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parser);
			_rest_xml_node_unref0 (root_node);
			return NULL;
		}
	}
	result = root_node;
	_g_object_unref0 (parser);
	return result;
}


static GHashTable* tracker_miner_flickr_real_get_association_data (TrackerMinerWeb* base, GError** error) {
	TrackerMinerFlickr * self;
	GHashTable* result = NULL;
	GError * _inner_error_;
	GHashTable* association_data;
	RestProxyCall* frob_call;
	RestXmlNode* root_node;
	RestXmlNode* frob_node;
	char* api_signature;
	char* url;
	RestXmlNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	char* _tmp4_;
	char* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp10_;
	char* _tmp9_;
	char* _tmp8_;
	self = (TrackerMinerFlickr*) base;
	_inner_error_ = NULL;
	association_data = g_hash_table_new (g_str_hash, g_str_equal);
	frob_call = rest_proxy_new_call (self->priv->rest);
	root_node = NULL;
	frob_node = NULL;
	api_signature = NULL;
	url = NULL;
	rest_proxy_call_add_param (frob_call, "method", "flickr.auth.getFrob");
	{
		RestXmlNode* _tmp0_;
		RestXmlNode* _tmp1_;
		_tmp0_ = tracker_miner_flickr_run_call (self, frob_call, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		root_node = (_tmp1_ = _tmp0_, _rest_xml_node_unref0 (root_node), _tmp1_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * call_error;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_SERVICE, "Error while getting association data: %s", call_error->message);
			{
				_g_error_free0 (call_error);
				_g_hash_table_unref0 (association_data);
				_g_object_unref0 (frob_call);
				_rest_xml_node_unref0 (root_node);
				_rest_xml_node_unref0 (frob_node);
				_g_free0 (api_signature);
				_g_free0 (url);
				goto __finally11;
			}
			_g_error_free0 (call_error);
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (association_data);
			_g_object_unref0 (frob_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (frob_node);
			_g_free0 (api_signature);
			_g_free0 (url);
			return NULL;
		} else {
			_g_hash_table_unref0 (association_data);
			_g_object_unref0 (frob_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (frob_node);
			_g_free0 (api_signature);
			_g_free0 (url);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	frob_node = (_tmp2_ = _rest_xml_node_ref0 (rest_xml_node_find (root_node, "frob")), _rest_xml_node_unref0 (frob_node), _tmp2_);
	if (frob_node == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = frob_node->content == NULL;
	}
	if (_tmp3_) {
		_inner_error_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_SERVICE, "Malformed XML response while getting frob");
		{
			if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_hash_table_unref0 (association_data);
				_g_object_unref0 (frob_call);
				_rest_xml_node_unref0 (root_node);
				_rest_xml_node_unref0 (frob_node);
				_g_free0 (api_signature);
				_g_free0 (url);
				return NULL;
			} else {
				_g_hash_table_unref0 (association_data);
				_g_object_unref0 (frob_call);
				_rest_xml_node_unref0 (root_node);
				_rest_xml_node_unref0 (frob_node);
				_g_free0 (api_signature);
				_g_free0 (url);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	self->priv->frob = (_tmp4_ = g_strdup (frob_node->content), _g_free0 (self->priv->frob), _tmp4_);
	api_signature = (_tmp7_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp6_ = g_strconcat (_tmp5_ = g_strconcat (TRACKER_MINER_FLICKR_SHARED_SECRET "api_key" TRACKER_MINER_FLICKR_API_KEY "frob", self->priv->frob, NULL), "permswrite", NULL), -1), _g_free0 (api_signature), _tmp7_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp5_);
	url = (_tmp10_ = g_strconcat (_tmp9_ = g_strconcat (_tmp8_ = g_strconcat (TRACKER_MINER_FLICKR_FLICKR_AUTH_URL "?api_key=" TRACKER_MINER_FLICKR_API_KEY "&perms=write&frob=", self->priv->frob, NULL), "&api_sig=", NULL), api_signature, NULL), _g_free0 (url), _tmp10_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp8_);
	g_hash_table_insert (association_data, g_strdup ("url"), g_strdup (url));
	result = association_data;
	_g_object_unref0 (frob_call);
	_rest_xml_node_unref0 (root_node);
	_rest_xml_node_unref0 (frob_node);
	_g_free0 (api_signature);
	_g_free0 (url);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_miner_flickr_real_associate (TrackerMinerWeb* base, GHashTable* association_data, GError** error) {
	TrackerMinerFlickr * self;
	GError * _inner_error_;
	TrackerPasswordProvider* password_provider;
	RestProxyCall* token_call;
	RestXmlNode* root_node;
	RestXmlNode* token_node;
	RestXmlNode* user_node;
	RestXmlNode* _tmp2_;
	RestXmlNode* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	self = (TrackerMinerFlickr*) base;
	g_return_if_fail (association_data != NULL);
	_inner_error_ = NULL;
	password_provider = _g_object_ref0 (tracker_password_provider_get ());
	token_call = rest_proxy_new_call (self->priv->rest);
	root_node = NULL;
	token_node = NULL;
	user_node = NULL;
	rest_proxy_call_add_params (token_call, "method", "flickr.auth.getToken", "frob", self->priv->frob, NULL);
	{
		RestXmlNode* _tmp0_;
		RestXmlNode* _tmp1_;
		_tmp0_ = tracker_miner_flickr_run_call (self, token_call, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		root_node = (_tmp1_ = _tmp0_, _rest_xml_node_unref0 (root_node), _tmp1_);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * call_error;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_SERVICE, "Unable to get authentication token: %s", call_error->message);
			{
				_g_error_free0 (call_error);
				_g_object_unref0 (password_provider);
				_g_object_unref0 (token_call);
				_rest_xml_node_unref0 (root_node);
				_rest_xml_node_unref0 (token_node);
				_rest_xml_node_unref0 (user_node);
				goto __finally12;
			}
			_g_error_free0 (call_error);
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (password_provider);
			_g_object_unref0 (token_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (user_node);
			return;
		} else {
			_g_object_unref0 (password_provider);
			_g_object_unref0 (token_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (user_node);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	token_node = (_tmp2_ = _rest_xml_node_ref0 (rest_xml_node_find (root_node, "token")), _rest_xml_node_unref0 (token_node), _tmp2_);
	user_node = (_tmp3_ = _rest_xml_node_ref0 (rest_xml_node_find (root_node, "user")), _rest_xml_node_unref0 (user_node), _tmp3_);
	if (token_node == NULL) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = token_node->content == NULL;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = user_node == NULL;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = rest_xml_node_get_attr (user_node, "username") == NULL;
	}
	if (_tmp4_) {
		_inner_error_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_SERVICE, "Malformed XML response while getting token");
		{
			if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (password_provider);
				_g_object_unref0 (token_call);
				_rest_xml_node_unref0 (root_node);
				_rest_xml_node_unref0 (token_node);
				_rest_xml_node_unref0 (user_node);
				return;
			} else {
				_g_object_unref0 (password_provider);
				_g_object_unref0 (token_call);
				_rest_xml_node_unref0 (root_node);
				_rest_xml_node_unref0 (token_node);
				_rest_xml_node_unref0 (user_node);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	{
		tracker_password_provider_store_password (password_provider, TRACKER_MINER_FLICKR_MINER_NAME, TRACKER_MINER_FLICKR_MINER_DESCRIPTION, rest_xml_node_get_attr (user_node, "username"), token_node->content, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			if (g_error_matches (e, TRACKER_PASSWORD_PROVIDER_ERROR, TRACKER_PASSWORD_PROVIDER_ERROR_SERVICE)) {
				_inner_error_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_KEYRING, e->message);
				{
					_g_error_free0 (e);
					_g_object_unref0 (password_provider);
					_g_object_unref0 (token_call);
					_rest_xml_node_unref0 (root_node);
					_rest_xml_node_unref0 (token_node);
					_rest_xml_node_unref0 (user_node);
					goto __finally13;
				}
			}
			g_critical ("tracker-miner-flickr.vala:655: Internal error: %s", e->message);
			_g_error_free0 (e);
			_g_object_unref0 (password_provider);
			_g_object_unref0 (token_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (user_node);
			return;
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (password_provider);
			_g_object_unref0 (token_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (user_node);
			return;
		} else {
			_g_object_unref0 (password_provider);
			_g_object_unref0 (token_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (token_node);
			_rest_xml_node_unref0 (user_node);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (password_provider);
	_g_object_unref0 (token_call);
	_rest_xml_node_unref0 (root_node);
	_rest_xml_node_unref0 (token_node);
	_rest_xml_node_unref0 (user_node);
}


static void tracker_miner_flickr_real_authenticate (TrackerMinerWeb* base, GError** error) {
	TrackerMinerFlickr * self;
	GError * _inner_error_;
	TrackerPasswordProvider* password_provider;
	RestProxyCall* login_call;
	RestXmlNode* root_node;
	RestXmlNode* user_node;
	TrackerPasswordProvider* _tmp0_;
	RestProxyCall* _tmp3_;
	RestXmlNode* _tmp6_;
	gboolean _tmp7_ = FALSE;
	char* _tmp8_;
	self = (TrackerMinerFlickr*) base;
	_inner_error_ = NULL;
	password_provider = NULL;
	login_call = NULL;
	root_node = NULL;
	user_node = NULL;
	password_provider = (_tmp0_ = _g_object_ref0 (tracker_password_provider_get ()), _g_object_unref0 (password_provider), _tmp0_);
	g_object_set ((TrackerMinerWeb*) self, "associated", FALSE, NULL);
	{
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = tracker_password_provider_get_password (password_provider, TRACKER_MINER_FLICKR_MINER_NAME, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		self->priv->auth_token = (_tmp2_ = _tmp1_, _g_free0 (self->priv->auth_token), _tmp2_);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			if (g_error_matches (e, TRACKER_PASSWORD_PROVIDER_ERROR, TRACKER_PASSWORD_PROVIDER_ERROR_NOTFOUND)) {
				_inner_error_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_NO_CREDENTIALS, "Miner is not associated");
				{
					_g_error_free0 (e);
					_g_object_unref0 (password_provider);
					_g_object_unref0 (login_call);
					_rest_xml_node_unref0 (root_node);
					_rest_xml_node_unref0 (user_node);
					goto __finally14;
				}
			}
			_inner_error_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_KEYRING, e->message);
			{
				_g_error_free0 (e);
				_g_object_unref0 (password_provider);
				_g_object_unref0 (login_call);
				_rest_xml_node_unref0 (root_node);
				_rest_xml_node_unref0 (user_node);
				goto __finally14;
			}
			_g_error_free0 (e);
		}
	}
	__finally14:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (password_provider);
			_g_object_unref0 (login_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (user_node);
			return;
		} else {
			_g_object_unref0 (password_provider);
			_g_object_unref0 (login_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (user_node);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	login_call = (_tmp3_ = rest_proxy_new_call (self->priv->rest), _g_object_unref0 (login_call), _tmp3_);
	rest_proxy_call_add_param (login_call, "method", "flickr.auth.checkToken");
	{
		RestXmlNode* _tmp4_;
		RestXmlNode* _tmp5_;
		_tmp4_ = tracker_miner_flickr_run_call (self, login_call, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		root_node = (_tmp5_ = _tmp4_, _rest_xml_node_unref0 (root_node), _tmp5_);
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError * call_error;
		call_error = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_SERVICE, "Cannot verify login: %s", call_error->message);
			{
				_g_error_free0 (call_error);
				_g_object_unref0 (password_provider);
				_g_object_unref0 (login_call);
				_rest_xml_node_unref0 (root_node);
				_rest_xml_node_unref0 (user_node);
				goto __finally15;
			}
			_g_error_free0 (call_error);
		}
	}
	__finally15:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (password_provider);
			_g_object_unref0 (login_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (user_node);
			return;
		} else {
			_g_object_unref0 (password_provider);
			_g_object_unref0 (login_call);
			_rest_xml_node_unref0 (root_node);
			_rest_xml_node_unref0 (user_node);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	user_node = (_tmp6_ = _rest_xml_node_ref0 (rest_xml_node_find (root_node, "user")), _rest_xml_node_unref0 (user_node), _tmp6_);
	if (user_node == NULL) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = rest_xml_node_get_attr (user_node, "nsid") == NULL;
	}
	if (_tmp7_) {
		_inner_error_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_WRONG_CREDENTIALS, "Stored authentication token is not valid");
		{
			if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (password_provider);
				_g_object_unref0 (login_call);
				_rest_xml_node_unref0 (root_node);
				_rest_xml_node_unref0 (user_node);
				return;
			} else {
				_g_object_unref0 (password_provider);
				_g_object_unref0 (login_call);
				_rest_xml_node_unref0 (root_node);
				_rest_xml_node_unref0 (user_node);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	self->priv->user_id = (_tmp8_ = g_strdup (rest_xml_node_get_attr (user_node, "nsid")), _g_free0 (self->priv->user_id), _tmp8_);
	g_message ("tracker-miner-flickr.vala:695: Authentication successful");
	g_object_set ((TrackerMinerWeb*) self, "associated", TRUE, NULL);
	_g_object_unref0 (password_provider);
	_g_object_unref0 (login_call);
	_rest_xml_node_unref0 (root_node);
	_rest_xml_node_unref0 (user_node);
}


static void tracker_miner_flickr_real_dissociate (TrackerMinerWeb* base, GError** error) {
	TrackerMinerFlickr * self;
	GError * _inner_error_;
	TrackerPasswordProvider* password_provider;
	self = (TrackerMinerFlickr*) base;
	_inner_error_ = NULL;
	password_provider = _g_object_ref0 (tracker_password_provider_get ());
	{
		tracker_password_provider_forget_password (password_provider, TRACKER_MINER_FLICKR_MINER_NAME, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			if (g_error_matches (e, TRACKER_PASSWORD_PROVIDER_ERROR, TRACKER_PASSWORD_PROVIDER_ERROR_SERVICE)) {
				_inner_error_ = g_error_new_literal (TRACKER_MINER_WEB_ERROR, TRACKER_MINER_WEB_ERROR_KEYRING, e->message);
				{
					_g_error_free0 (e);
					_g_object_unref0 (password_provider);
					goto __finally16;
				}
			}
			g_critical ("tracker-miner-flickr.vala:709: Internal error: %s", e->message);
			_g_error_free0 (e);
			_g_object_unref0 (password_provider);
			return;
		}
	}
	__finally16:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_MINER_WEB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (password_provider);
			return;
		} else {
			_g_object_unref0 (password_provider);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_set ((TrackerMinerWeb*) self, "associated", FALSE, NULL);
	_g_object_unref0 (password_provider);
}


void tracker_miner_flickr_writeback (TrackerMinerFlickr* self, GHashTable* properties) {
	GList* uris;
	gint _rdf_classes_size_;
	gint rdf_classes_length1;
	char** rdf_classes;
	g_return_if_fail (self != NULL);
	g_return_if_fail (properties != NULL);
	uris = (GList*) g_hash_table_get_keys (properties);
	rdf_classes = (rdf_classes_length1 = 0, NULL);
	{
		GList* uri_collection;
		GList* uri_it;
		uri_collection = uris;
		for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
			char* uri;
			uri = g_strdup ((const char*) uri_it->data);
			{
				char** _tmp0_;
				rdf_classes = (_tmp0_ = (char**) g_hash_table_lookup (properties, uri), rdf_classes_length1 = -1, _rdf_classes_size_ = rdf_classes_length1, _tmp0_);
				{
					guint i;
					i = (guint) 0;
					{
						gboolean _tmp1_;
						_tmp1_ = TRUE;
						while (TRUE) {
							if (!_tmp1_) {
								i++;
							}
							_tmp1_ = FALSE;
							if (!(rdf_classes[i] != NULL)) {
								break;
							}
							if (_vala_strcmp0 (rdf_classes[i], TRACKER_MINER_FLICKR_NMM_PHOTO) == 0) {
								tracker_miner_flickr_writeback_photo (self, uri, NULL, NULL);
								_g_free0 (uri);
								_g_list_free0 (uris);
								return;
							}
						}
					}
				}
				_g_free0 (uri);
			}
		}
	}
	_g_list_free0 (uris);
}


static char* tracker_miner_flickr_get_resource (TrackerMinerFlickr* self, const char* graph, char** types, int types_length1, const char* identifier, gboolean* created, GError** error) {
	char* result = NULL;
	GError * _inner_error_;
	char* inner_query;
	char* select_query;
	char* insert_query;
	GPtrArray* query_results;
	gint _triples_size_;
	gint triples_length1;
	char*** triples;
	GHashTable* anonymous_nodes;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp5_;
	char* _tmp4_;
	char* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (identifier != NULL, NULL);
	_inner_error_ = NULL;
	inner_query = NULL;
	select_query = NULL;
	insert_query = NULL;
	query_results = NULL;
	triples = (triples_length1 = 0, NULL);
	anonymous_nodes = NULL;
	select_query = (_tmp0_ = g_strdup (""), _g_free0 (select_query), _tmp0_);
	inner_query = (_tmp1_ = g_strdup (""), _g_free0 (inner_query), _tmp1_);
	*created = FALSE;
	{
		char** type_collection;
		int type_collection_length1;
		int type_it;
		type_collection = types;
		type_collection_length1 = types_length1;
		for (type_it = 0; type_it < types_length1; type_it = type_it + 1) {
			char* type;
			type = g_strdup (type_collection[type_it]);
			{
				char* _tmp3_;
				char* _tmp2_;
				inner_query = (_tmp3_ = g_strconcat (inner_query, _tmp2_ = g_strdup_printf (" a %s; ", type), NULL), _g_free0 (inner_query), _tmp3_);
				_g_free0 (_tmp2_);
				_g_free0 (type);
			}
		}
	}
	inner_query = (_tmp5_ = g_strconcat (inner_query, _tmp4_ = g_strdup_printf ("nao:identifier \"%s\"", identifier), NULL), _g_free0 (inner_query), _tmp5_);
	_g_free0 (_tmp4_);
	select_query = (_tmp6_ = g_strdup_printf ("select ?urn where { ?urn %s }", inner_query), _g_free0 (select_query), _tmp6_);
	{
		GPtrArray* _tmp7_;
		GPtrArray* _tmp8_;
		_tmp7_ = tracker_resources_sparql_query (self->priv->tracker_client, select_query, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
		query_results = (_tmp8_ = _tmp7_, _g_ptr_array_free0 (query_results), _tmp8_);
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError * tracker_error;
		tracker_error = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = _g_error_copy0 (tracker_error);
			{
				_g_error_free0 (tracker_error);
				_g_free0 (inner_query);
				_g_free0 (select_query);
				_g_free0 (insert_query);
				_g_ptr_array_free0 (query_results);
				_g_hash_table_unref0 (anonymous_nodes);
				goto __finally17;
			}
			_g_error_free0 (tracker_error);
		}
	}
	__finally17:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (inner_query);
		_g_free0 (select_query);
		_g_free0 (insert_query);
		_g_ptr_array_free0 (query_results);
		_g_hash_table_unref0 (anonymous_nodes);
		return NULL;
	}
	if (query_results->len > 0) {
		char*** _tmp9_;
		triples = (_tmp9_ = (char***) query_results->pdata, triples_length1 = -1, _triples_size_ = triples_length1, _tmp9_);
		result = g_strdup (triples[0][0]);
		_g_free0 (inner_query);
		_g_free0 (select_query);
		_g_free0 (insert_query);
		_g_ptr_array_free0 (query_results);
		_g_hash_table_unref0 (anonymous_nodes);
		return result;
	}
	if (graph == NULL) {
		char* _tmp10_;
		insert_query = (_tmp10_ = g_strdup_printf ("insert { _:res %s }", inner_query), _g_free0 (insert_query), _tmp10_);
	} else {
		char* _tmp11_;
		insert_query = (_tmp11_ = g_strdup_printf ("insert into <%s> { _:res %s }", graph, inner_query), _g_free0 (insert_query), _tmp11_);
	}
	{
		GPtrArray* _tmp12_;
		GPtrArray* _tmp13_;
		GHashTable* _tmp14_;
		*created = TRUE;
		_tmp12_ = tracker_resources_sparql_update_blank (self->priv->tracker_client, insert_query, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		query_results = (_tmp13_ = _tmp12_, _g_ptr_array_free0 (query_results), _tmp13_);
		anonymous_nodes = (_tmp14_ = _g_hash_table_ref0 (((GHashTable**) ((GPtrArray**) query_results->pdata)[0]->pdata)[0]), _g_hash_table_unref0 (anonymous_nodes), _tmp14_);
		result = g_strdup ((const char*) g_hash_table_lookup (anonymous_nodes, "res"));
		_g_free0 (inner_query);
		_g_free0 (select_query);
		_g_free0 (insert_query);
		_g_ptr_array_free0 (query_results);
		_g_hash_table_unref0 (anonymous_nodes);
		return result;
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError * tracker_error;
		tracker_error = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = _g_error_copy0 (tracker_error);
			{
				_g_error_free0 (tracker_error);
				_g_free0 (inner_query);
				_g_free0 (select_query);
				_g_free0 (insert_query);
				_g_ptr_array_free0 (query_results);
				_g_hash_table_unref0 (anonymous_nodes);
				goto __finally18;
			}
			_g_error_free0 (tracker_error);
		}
	}
	__finally18:
	{
		g_propagate_error (error, _inner_error_);
		_g_free0 (inner_query);
		_g_free0 (select_query);
		_g_free0 (insert_query);
		_g_ptr_array_free0 (query_results);
		_g_hash_table_unref0 (anonymous_nodes);
		return NULL;
	}
	_g_free0 (inner_query);
	_g_free0 (select_query);
	_g_free0 (insert_query);
	_g_ptr_array_free0 (query_results);
	_g_hash_table_unref0 (anonymous_nodes);
}


void tracker_miner_flickr_update_triple_string (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const char* graph, const char* urn, const char* property, const char* new_value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	g_return_if_fail (property != NULL);
	g_return_if_fail (new_value != NULL);
	tracker_sparql_builder_delete_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_string (builder, new_value);
	tracker_sparql_builder_delete_close (builder);
	tracker_sparql_builder_insert_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_string (builder, new_value);
	tracker_sparql_builder_insert_close (builder);
}


void tracker_miner_flickr_update_triple_object (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const char* graph, const char* urn, const char* property, const char* new_value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	g_return_if_fail (property != NULL);
	g_return_if_fail (new_value != NULL);
	tracker_sparql_builder_delete_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object (builder, new_value);
	tracker_sparql_builder_delete_close (builder);
	tracker_sparql_builder_insert_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object (builder, new_value);
	tracker_sparql_builder_insert_close (builder);
}


void tracker_miner_flickr_update_triple_double (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const char* graph, const char* urn, const char* property, double new_value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	g_return_if_fail (property != NULL);
	tracker_sparql_builder_delete_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_double (builder, new_value);
	tracker_sparql_builder_delete_close (builder);
	tracker_sparql_builder_insert_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_double (builder, new_value);
	tracker_sparql_builder_insert_close (builder);
}


void tracker_miner_flickr_update_triple_int64 (TrackerMinerFlickr* self, TrackerSparqlBuilder* builder, const char* graph, const char* urn, const char* property, gint64 new_value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (graph != NULL);
	g_return_if_fail (urn != NULL);
	g_return_if_fail (property != NULL);
	tracker_sparql_builder_delete_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_int64 (builder, new_value);
	tracker_sparql_builder_delete_close (builder);
	tracker_sparql_builder_insert_open (builder, graph);
	tracker_sparql_builder_subject_iri (builder, urn);
	tracker_sparql_builder_predicate (builder, property);
	tracker_sparql_builder_object_int64 (builder, new_value);
	tracker_sparql_builder_insert_close (builder);
}


static void tracker_miner_flickr_signal_handler (gint signo) {
	if (tracker_miner_flickr_in_loop) {
		exit (EXIT_FAILURE);
	}
	switch (signo) {
		case SIGINT:
		case SIGTERM:
		{
			tracker_miner_flickr_in_loop = TRUE;
			g_main_loop_quit (tracker_miner_flickr_main_loop);
			break;
		}
	}
	fprintf (stdout, "\nReceived signal:%d\n", signo);
}


static void _tracker_miner_flickr_signal_handler_sighandler_t (gint signal) {
	tracker_miner_flickr_signal_handler (signal);
}


static void tracker_miner_flickr_init_signals (void) {
	struct sigaction act = {0};
	sigset_t empty_mask = {0};
	memset (&act, 0, sizeof (struct sigaction));
	memset (&empty_mask, 0, sizeof (sigset_t));
	sigemptyset (&empty_mask);
	act.sa_handler = _tracker_miner_flickr_signal_handler_sighandler_t;
	act.sa_mask = empty_mask;
	act.sa_flags = 0;
	sigaction (SIGTERM, &act, NULL);
	sigaction (SIGINT, &act, NULL);
}


void tracker_miner_flickr_main (char** args, int args_length1) {
	GObject* _tmp0_;
	GObject* _tmp1_;
	TrackerMinerFlickr* flickr_miner;
	GMainLoop* _tmp2_;
	g_set_application_name ("Flickr tracker miner");
	flickr_miner = (_tmp1_ = (_tmp0_ = g_object_new (TRACKER_TYPE_MINER_FLICKR, NULL), g_object_is_floating (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_), TRACKER_IS_MINER_FLICKR (_tmp1_) ? ((TrackerMinerFlickr*) _tmp1_) : NULL);
	tracker_miner_flickr_init_signals ();
	tracker_miner_flickr_main_loop = (_tmp2_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (tracker_miner_flickr_main_loop), _tmp2_);
	g_main_loop_run (tracker_miner_flickr_main_loop);
	tracker_miner_flickr_shutdown (flickr_miner);
	_g_object_unref0 (flickr_miner);
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	tracker_miner_flickr_main (argv, argc);
	return 0;
}


TrackerMinerFlickr* tracker_miner_flickr_construct (GType object_type) {
	TrackerMinerFlickr * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


TrackerMinerFlickr* tracker_miner_flickr_new (void) {
	return tracker_miner_flickr_construct (TRACKER_TYPE_MINER_FLICKR);
}


static void _tracker_miner_flickr_writeback_tracker_writeback_callback (GHashTable* resources, gpointer self) {
	tracker_miner_flickr_writeback (self, resources);
}


static void _tracker_miner_flickr_association_status_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tracker_miner_flickr_association_status_changed (self, _sender, pspec);
}


static GObject * tracker_miner_flickr_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TrackerMinerFlickr * self;
	parent_class = G_OBJECT_CLASS (tracker_miner_flickr_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TRACKER_MINER_FLICKR (obj);
	{
		RestProxy* _tmp0_;
		TrackerClient* _tmp1_;
		g_object_set ((TrackerMiner*) self, "name", TRACKER_MINER_FLICKR_MINER_NAME, NULL);
		g_object_set ((TrackerMinerWeb*) self, "associated", FALSE, NULL);
		g_object_set ((TrackerMiner*) self, "status", "Not authenticated", NULL);
		g_object_set ((TrackerMiner*) self, "progress", 0.0, NULL);
		self->priv->rest = (_tmp0_ = rest_proxy_new (TRACKER_MINER_FLICKR_FLICKR_REST_URL, FALSE), _g_object_unref0 (self->priv->rest), _tmp0_);
		self->priv->tracker_client = (_tmp1_ = tracker_client_new (0, -1), _g_object_unref0 (self->priv->tracker_client), _tmp1_);
		tracker_resources_writeback_connect (self->priv->tracker_client, _tracker_miner_flickr_writeback_tracker_writeback_callback, self);
		tracker_miner_flickr_init_datasource (self);
		g_signal_connect_object ((GObject*) self, "notify::associated", (GCallback) _tracker_miner_flickr_association_status_changed_g_object_notify, self, 0);
	}
	return obj;
}


static void tracker_miner_flickr_class_init (TrackerMinerFlickrClass * klass) {
	tracker_miner_flickr_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerMinerFlickrPrivate));
	TRACKER_MINER_WEB_CLASS (klass)->get_association_data = tracker_miner_flickr_real_get_association_data;
	TRACKER_MINER_WEB_CLASS (klass)->associate = tracker_miner_flickr_real_associate;
	TRACKER_MINER_WEB_CLASS (klass)->authenticate = tracker_miner_flickr_real_authenticate;
	TRACKER_MINER_WEB_CLASS (klass)->dissociate = tracker_miner_flickr_real_dissociate;
	G_OBJECT_CLASS (klass)->constructor = tracker_miner_flickr_constructor;
	G_OBJECT_CLASS (klass)->finalize = tracker_miner_flickr_finalize;
}


static void tracker_miner_flickr_instance_init (TrackerMinerFlickr * self) {
	self->priv = TRACKER_MINER_FLICKR_GET_PRIVATE (self);
}


static void tracker_miner_flickr_finalize (GObject* obj) {
	TrackerMinerFlickr * self;
	self = TRACKER_MINER_FLICKR (obj);
	_g_object_unref0 (self->priv->tracker_client);
	_g_object_unref0 (self->priv->rest);
	_g_free0 (self->priv->frob);
	_g_free0 (self->priv->auth_token);
	_g_free0 (self->priv->user_id);
	G_OBJECT_CLASS (tracker_miner_flickr_parent_class)->finalize (obj);
}


GType tracker_miner_flickr_get_type (void) {
	static volatile gsize tracker_miner_flickr_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_miner_flickr_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMinerFlickrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_miner_flickr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMinerFlickr), 0, (GInstanceInitFunc) tracker_miner_flickr_instance_init, NULL };
		GType tracker_miner_flickr_type_id;
		tracker_miner_flickr_type_id = g_type_register_static (TRACKER_TYPE_MINER_WEB, "TrackerMinerFlickr", &g_define_type_info, 0);
		g_once_init_leave (&tracker_miner_flickr_type_id__volatile, tracker_miner_flickr_type_id);
	}
	return tracker_miner_flickr_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




