/* valaccodeblock.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodeblock.h"
#include <ccode/valaccodeblock.h>

struct _ValaCCodeBlockPrivate {
	gboolean _suppress_newline;
	GList* statements;
};
#define VALA_CCODE_BLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BLOCK, ValaCCodeBlockPrivate))
enum  {
	VALA_CCODE_BLOCK_DUMMY_PROPERTY,
	VALA_CCODE_BLOCK_SUPPRESS_NEWLINE,
};
static void vala_ccode_block_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_block_parent_class = NULL;
static void vala_ccode_block_dispose (GObject * obj);


/**
 * Prepend the specified statement to the list of statements.
 */
void vala_ccode_block_prepend_statement (ValaCCodeBlock* self, ValaCCodeNode* statement)
{
	g_return_if_fail (VALA_IS_CCODE_BLOCK (self));
	g_return_if_fail (VALA_IS_CCODE_NODE (statement));
	self->priv->statements = g_list_prepend (self->priv->statements, g_object_ref (statement));
}


/**
 * Append the specified statement to the list of statements.
 */
void vala_ccode_block_add_statement (ValaCCodeBlock* self, ValaCCodeNode* statement)
{
	g_return_if_fail (VALA_IS_CCODE_BLOCK (self));
	g_return_if_fail (VALA_IS_CCODE_NODE (statement));
	/* allow generic nodes to include comments */
	self->priv->statements = g_list_append (self->priv->statements, g_object_ref (statement));
}


static void vala_ccode_block_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeBlock * self = VALA_CCODE_BLOCK (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_begin_block (writer);
	{
		GList* __temp0 = NULL;
		__temp0 = self->priv->statements;
		GList* statement_it;
		for (statement_it = __temp0; statement_it != NULL; statement_it = statement_it->next) {
			ValaCCodeNode* statement = statement_it->data;
			{
				vala_ccode_node_write (statement, writer);
			}
		}
	}
	vala_ccode_writer_write_end_block (writer);
	if (!vala_ccode_block_get_suppress_newline (self)) {
		vala_ccode_writer_write_newline (writer);
	}
}


gboolean vala_ccode_block_get_suppress_newline (ValaCCodeBlock* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_BLOCK (self), FALSE);
	return self->priv->_suppress_newline;
}


void vala_ccode_block_set_suppress_newline (ValaCCodeBlock* self, gboolean value)
{
	g_return_if_fail (VALA_IS_CCODE_BLOCK (self));
	self->priv->_suppress_newline = value;
}


static void vala_ccode_block_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeBlock * self = VALA_CCODE_BLOCK (object);
	switch (property_id) {
		case VALA_CCODE_BLOCK_SUPPRESS_NEWLINE:
		g_value_set_boolean (value, vala_ccode_block_get_suppress_newline (self));
		break;
	}
}


static void vala_ccode_block_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeBlock * self = VALA_CCODE_BLOCK (object);
	switch (property_id) {
		case VALA_CCODE_BLOCK_SUPPRESS_NEWLINE:
		vala_ccode_block_set_suppress_newline (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_ccode_block_class_init (ValaCCodeBlockClass * klass)
{
	vala_ccode_block_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeBlockPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_block_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_block_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_block_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_block_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_BLOCK_SUPPRESS_NEWLINE, g_param_spec_boolean ("suppress-newline", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_block_init (ValaCCodeBlock * self)
{
	self->priv = VALA_CCODE_BLOCK_GET_PRIVATE (self);
}


static void vala_ccode_block_dispose (GObject * obj)
{
	ValaCCodeBlock * self = VALA_CCODE_BLOCK (obj);
	(self->priv->statements == NULL ? NULL : (self->priv->statements = (g_list_foreach (self->priv->statements, (GFunc) g_object_unref, NULL), g_list_free (self->priv->statements), NULL)));
	ValaCCodeBlockClass * klass;
	GObjectClass * parent_class;
	klass = VALA_CCODE_BLOCK_CLASS (g_type_class_peek (VALA_TYPE_CCODE_BLOCK));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_block_get_type ()
{
	static GType vala_ccode_block_type_id = 0;
	if (G_UNLIKELY (vala_ccode_block_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBlock), 0, (GInstanceInitFunc) vala_ccode_block_init };
		vala_ccode_block_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeBlock", &g_define_type_info, 0);
	}
	return vala_ccode_block_type_id;
}




