/* valaarrayresizemethod.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaarrayresizemethod.h"
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcereference.h>
#include <vala/valatypereference.h>
#include <vala/valamemberaccessibility.h>
#include <vala/valasourcefile.h>
#include <vala/valacodecontext.h>
#include <vala/valasymbol.h>
#include <vala/valadatatype.h>
#include <vala/valaformalparameter.h>

struct _ValaArrayResizeMethodPrivate {
};
#define VALA_ARRAY_RESIZE_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethodPrivate))
enum  {
	VALA_ARRAY_RESIZE_METHOD_DUMMY_PROPERTY,
};
static GObject * vala_array_resize_method_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_array_resize_method_parent_class = NULL;


/**
 * Creates a new array resize method.
 *
 * @return newly created method
 */
ValaArrayResizeMethod* vala_array_resize_method_new (ValaSourceReference* _source_reference)
{
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (_source_reference), NULL);
	GParameter * __params = g_new0 (GParameter, 3);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, "resize"), __params_it++);
	ValaTypeReference* __temp0 = NULL;
	(__params_it->name = "return-type", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, (__temp0 = vala_type_reference_new ())), __params_it++);
	(__temp0 == NULL ? NULL : (__temp0 = (g_object_unref (__temp0), NULL)));
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, _source_reference), __params_it++);
	ValaArrayResizeMethod * self = g_object_newv (VALA_TYPE_ARRAY_RESIZE_METHOD, __params_it - __params, __params);
	return self;
}


static GObject * vala_array_resize_method_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaArrayResizeMethodClass * klass;
	GObjectClass * parent_class;
	klass = VALA_ARRAY_RESIZE_METHOD_CLASS (g_type_class_peek (VALA_TYPE_ARRAY_RESIZE_METHOD));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	ValaArrayResizeMethod * self = VALA_ARRAY_RESIZE_METHOD (obj);
	{
		VALA_METHOD (self)->access = VALA_MEMBER_ACCESSIBILITY_PUBLIC;
		vala_method_set_cname (VALA_METHOD (self), "g_renew");
		ValaSymbol* root_symbol = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self)))));
		ValaTypeReference* int_type = vala_type_reference_new ();
		ValaSymbol* __temp1 = NULL;
		(vala_type_reference_set_data_type (int_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp1 = vala_symbol_lookup (root_symbol, "int"))))), vala_type_reference_get_data_type (int_type));
		(__temp1 == NULL ? NULL : (__temp1 = (g_object_unref (__temp1), NULL)));
		ValaFormalParameter* __temp2 = NULL;
		vala_method_add_parameter (VALA_METHOD (self), (__temp2 = vala_formal_parameter_new ("length", int_type, NULL)));
		(__temp2 == NULL ? NULL : (__temp2 = (g_object_unref (__temp2), NULL)));
		(vala_method_set_returns_modified_pointer (VALA_METHOD (self), TRUE), vala_method_get_returns_modified_pointer (VALA_METHOD (self)));
		(root_symbol = (g_object_unref (root_symbol), NULL));
		(int_type == NULL ? NULL : (int_type = (g_object_unref (int_type), NULL)));
	}
	return obj;
}


static void vala_array_resize_method_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaArrayResizeMethod * self = VALA_ARRAY_RESIZE_METHOD (object);
	switch (property_id) {
	}
}


static void vala_array_resize_method_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaArrayResizeMethod * self = VALA_ARRAY_RESIZE_METHOD (object);
	switch (property_id) {
	}
}


static void vala_array_resize_method_class_init (ValaArrayResizeMethodClass * klass)
{
	vala_array_resize_method_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = vala_array_resize_method_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_array_resize_method_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_array_resize_method_constructor;
}


static void vala_array_resize_method_init (ValaArrayResizeMethod * self)
{
}


GType vala_array_resize_method_get_type ()
{
	static GType vala_array_resize_method_type_id = 0;
	if (G_UNLIKELY (vala_array_resize_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayResizeMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_resize_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayResizeMethod), 0, (GInstanceInitFunc) vala_array_resize_method_init };
		vala_array_resize_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaArrayResizeMethod", &g_define_type_info, 0);
	}
	return vala_array_resize_method_type_id;
}




