/* valainvocationexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAINVOCATIONEXPRESSION_H__
#define __VALAINVOCATIONEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_INVOCATION_EXPRESSION (vala_invocation_expression_get_type ())
#define VALA_INVOCATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INVOCATION_EXPRESSION, ValaInvocationExpression))
#define VALA_INVOCATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INVOCATION_EXPRESSION, ValaInvocationExpressionClass))
#define VALA_IS_INVOCATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INVOCATION_EXPRESSION))
#define VALA_IS_INVOCATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INVOCATION_EXPRESSION))
#define VALA_INVOCATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INVOCATION_EXPRESSION, ValaInvocationExpressionClass))

typedef struct _ValaInvocationExpressionPrivate ValaInvocationExpressionPrivate;

/**
 * Represents an invocation expression in the source code.
 */
struct _ValaInvocationExpression {
	ValaExpression parent;
	ValaInvocationExpressionPrivate * priv;
	ValaExpression* _call;
};
struct _ValaInvocationExpressionClass {
	ValaExpressionClass parent;
};

ValaInvocationExpression* vala_invocation_expression_new (ValaExpression* _call, ValaSourceReference* source);
void vala_invocation_expression_add_argument (ValaInvocationExpression* self, ValaExpression* arg);
GList* vala_invocation_expression_get_argument_list (ValaInvocationExpression* self);
ValaExpression* vala_invocation_expression_get_call (ValaInvocationExpression* self);
void vala_invocation_expression_set_call (ValaInvocationExpression* self, ValaExpression* value);
GType vala_invocation_expression_get_type ();

G_END_DECLS

#endif
