/* valasymbolbuilder.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valasymbolbuilder.h"
#include <vala/valasymbolbuilder.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valadatatype.h>
#include <vala/valatypereference.h>
#include <vala/valareturnstatement.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valastatement.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaassignment.h>

struct _ValaSymbolBuilderPrivate {
	ValaSymbol* root;
	ValaSymbol* current_type;
	ValaSymbol* current_symbol;
	ValaSourceFile* current_source_file;
};
#define VALA_SYMBOL_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SYMBOL_BUILDER, ValaSymbolBuilderPrivate))
enum  {
	VALA_SYMBOL_BUILDER_DUMMY_PROPERTY,
};
static void vala_symbol_builder_real_visit_begin_source_file (ValaCodeVisitor* base, ValaSourceFile* file);
static void vala_symbol_builder_real_visit_begin_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_symbol_builder_real_visit_end_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static ValaSymbol* vala_symbol_builder_add_symbol (ValaSymbolBuilder* self, const char* name, ValaCodeNode* node);
static void vala_symbol_builder_real_visit_begin_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_symbol_builder_real_visit_end_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_symbol_builder_real_visit_begin_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_symbol_builder_real_visit_end_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_symbol_builder_real_visit_begin_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_symbol_builder_real_visit_end_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_symbol_builder_real_visit_begin_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_symbol_builder_real_visit_end_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_symbol_builder_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void vala_symbol_builder_real_visit_begin_flags (ValaCodeVisitor* base, ValaFlags* fl);
static void vala_symbol_builder_real_visit_end_flags (ValaCodeVisitor* base, ValaFlags* fl);
static void vala_symbol_builder_real_visit_flags_value (ValaCodeVisitor* base, ValaFlagsValue* fv);
static void vala_symbol_builder_real_visit_begin_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_symbol_builder_real_visit_end_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_symbol_builder_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_symbol_builder_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_symbol_builder_real_visit_begin_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_symbol_builder_real_visit_end_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_symbol_builder_real_visit_begin_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_symbol_builder_real_visit_end_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_symbol_builder_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_symbol_builder_real_visit_begin_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_symbol_builder_real_visit_end_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_symbol_builder_real_visit_begin_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_symbol_builder_real_visit_end_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_symbol_builder_real_visit_begin_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void vala_symbol_builder_real_visit_end_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void vala_symbol_builder_real_visit_begin_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_symbol_builder_real_visit_end_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_symbol_builder_real_visit_begin_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_symbol_builder_real_visit_end_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_symbol_builder_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_symbol_builder_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_symbol_builder_real_visit_type_parameter (ValaCodeVisitor* base, ValaTypeParameter* p);
static gpointer vala_symbol_builder_parent_class = NULL;
static void vala_symbol_builder_dispose (GObject * obj);


/**
 * Build the symbol tree for the specified code context.
 *
 * @param context a code context
 */
void vala_symbol_builder_build (ValaSymbolBuilder* self, ValaCodeContext* context)
{
	g_return_if_fail (VALA_IS_SYMBOL_BUILDER (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	ValaSymbol* __temp0 = NULL;
	self->priv->root = (__temp0 = vala_code_context_get_root (context), (self->priv->root == NULL ? NULL : (self->priv->root = (g_object_unref (self->priv->root), NULL))), __temp0);
	vala_code_context_accept (context, VALA_CODE_VISITOR (self));
}


static void vala_symbol_builder_real_visit_begin_source_file (ValaCodeVisitor* base, ValaSourceFile* file)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (file));
	ValaSourceFile* __temp1 = NULL;
	self->priv->current_source_file = (__temp1 = g_object_ref (file), (self->priv->current_source_file == NULL ? NULL : (self->priv->current_source_file = (g_object_unref (self->priv->current_source_file), NULL))), __temp1);
}


static void vala_symbol_builder_real_visit_begin_namespace (ValaCodeVisitor* base, ValaNamespace* ns)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_NAMESPACE (ns));
	if (vala_namespace_get_name (ns) == NULL) {
		(vala_code_node_set_symbol (VALA_CODE_NODE (ns), self->priv->root), vala_code_node_get_symbol (VALA_CODE_NODE (ns)));
	}
	if (vala_code_node_get_symbol (VALA_CODE_NODE (ns)) == NULL) {
		ValaSymbol* __temp2 = NULL;
		(vala_code_node_set_symbol (VALA_CODE_NODE (ns), (__temp2 = vala_symbol_lookup (self->priv->root, vala_namespace_get_name (ns)))), vala_code_node_get_symbol (VALA_CODE_NODE (ns)));
		(__temp2 == NULL ? NULL : (__temp2 = (g_object_unref (__temp2), NULL)));
	}
	if (vala_code_node_get_symbol (VALA_CODE_NODE (ns)) == NULL) {
		ValaSymbol* __temp3 = NULL;
		(vala_code_node_set_symbol (VALA_CODE_NODE (ns), (__temp3 = vala_symbol_new (VALA_CODE_NODE (ns)))), vala_code_node_get_symbol (VALA_CODE_NODE (ns)));
		(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
		vala_symbol_add (self->priv->root, vala_namespace_get_name (ns), vala_code_node_get_symbol (VALA_CODE_NODE (ns)));
	}
	ValaSymbol* __temp5 = NULL;
	ValaSymbol* __temp4 = NULL;
	self->priv->current_symbol = (__temp5 = (__temp4 = vala_code_node_get_symbol (VALA_CODE_NODE (ns)), (__temp4 == NULL ? NULL : g_object_ref (__temp4))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp5);
}


static void vala_symbol_builder_real_visit_end_namespace (ValaCodeVisitor* base, ValaNamespace* ns)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_NAMESPACE (ns));
	ValaSymbol* __temp7 = NULL;
	ValaSymbol* __temp6 = NULL;
	self->priv->current_symbol = (__temp7 = (__temp6 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp6 == NULL ? NULL : g_object_ref (__temp6))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp7);
}


static ValaSymbol* vala_symbol_builder_add_symbol (ValaSymbolBuilder* self, const char* name, ValaCodeNode* node)
{
	g_return_val_if_fail (VALA_IS_SYMBOL_BUILDER (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (node), NULL);
	if (name != NULL) {
		ValaSymbol* __temp8 = NULL;
		gboolean __temp9;
		if ((__temp9 = (__temp8 = vala_symbol_lookup (self->priv->current_symbol, name)) != NULL, (__temp8 == NULL ? NULL : (__temp8 = (g_object_unref (__temp8), NULL))), __temp9)) {
			(vala_code_node_set_error (node, TRUE), vala_code_node_get_error (node));
			char* __temp11 = NULL;
			char* __temp10 = NULL;
			vala_report_error (vala_code_node_get_source_reference (node), (__temp11 = g_strdup_printf ("`%s' already contains a definition for `%s'", (__temp10 = vala_symbol_get_full_name (self->priv->current_symbol)), name)));
			(__temp11 = (g_free (__temp11), NULL));
			(__temp10 = (g_free (__temp10), NULL));
			return VALA_SYMBOL (NULL);
		}
	}
	ValaSymbol* __temp13 = NULL;
	(vala_code_node_set_symbol (node, (__temp13 = vala_symbol_new (node))), vala_code_node_get_symbol (node));
	(__temp13 == NULL ? NULL : (__temp13 = (g_object_unref (__temp13), NULL)));
	if (name != NULL) {
		vala_symbol_add (self->priv->current_symbol, name, vala_code_node_get_symbol (node));
	} else {
		(vala_symbol_set_parent_symbol (vala_code_node_get_symbol (node), self->priv->current_symbol), vala_symbol_get_parent_symbol (vala_code_node_get_symbol (node)));
	}
	return vala_code_node_get_symbol (node);
}


static void vala_symbol_builder_real_visit_begin_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	ValaSymbol* class_symbol = vala_symbol_lookup (self->priv->current_symbol, vala_data_type_get_name (VALA_DATA_TYPE (cl)));
	if (class_symbol == NULL || !(VALA_IS_CLASS (vala_symbol_get_node (class_symbol)))) {
		ValaSymbol* __temp16 = NULL;
		ValaSymbol* __temp15 = NULL;
		class_symbol = (__temp16 = (__temp15 = vala_symbol_builder_add_symbol (self, vala_data_type_get_name (VALA_DATA_TYPE (cl)), VALA_CODE_NODE (cl)), (__temp15 == NULL ? NULL : g_object_ref (__temp15))), (class_symbol == NULL ? NULL : (class_symbol = (g_object_unref (class_symbol), NULL))), __temp16);
	} else {
		/* merge this class declaration with existing class symbol */
		ValaClass* __temp17 = NULL;
		ValaClass* main_class = (__temp17 = VALA_CLASS (vala_symbol_get_node (class_symbol)), (__temp17 == NULL ? NULL : g_object_ref (__temp17)));
		{
			GList* __temp18 = NULL;
			__temp18 = vala_class_get_base_types (cl);
			GList* base_type_it;
			for (base_type_it = __temp18; base_type_it != NULL; base_type_it = base_type_it->next) {
				ValaTypeReference* base_type = base_type_it->data;
				{
					vala_class_add_base_type (main_class, base_type);
				}
			}
			(__temp18 == NULL ? NULL : (__temp18 = (g_list_free (__temp18), NULL)));
		}
		{
			GList* __temp19 = NULL;
			__temp19 = vala_class_get_fields (cl);
			GList* f_it;
			for (f_it = __temp19; f_it != NULL; f_it = f_it->next) {
				ValaField* f = f_it->data;
				{
					vala_class_add_field (main_class, f);
				}
			}
			(__temp19 == NULL ? NULL : (__temp19 = (g_list_free (__temp19), NULL)));
		}
		{
			GList* __temp20 = NULL;
			__temp20 = vala_class_get_methods (cl);
			GList* m_it;
			for (m_it = __temp20; m_it != NULL; m_it = m_it->next) {
				ValaMethod* m = m_it->data;
				{
					vala_class_add_method (main_class, m);
				}
			}
			(__temp20 == NULL ? NULL : (__temp20 = (g_list_free (__temp20), NULL)));
		}
		{
			GList* __temp21 = NULL;
			__temp21 = vala_class_get_properties (cl);
			GList* prop_it;
			for (prop_it = __temp21; prop_it != NULL; prop_it = prop_it->next) {
				ValaProperty* prop = prop_it->data;
				{
					vala_class_add_property (main_class, prop, TRUE);
				}
			}
			(__temp21 == NULL ? NULL : (__temp21 = (g_list_free (__temp21), NULL)));
		}
		{
			GList* __temp22 = NULL;
			__temp22 = vala_class_get_signals (cl);
			GList* sig_it;
			for (sig_it = __temp22; sig_it != NULL; sig_it = sig_it->next) {
				ValaSignal* sig = sig_it->data;
				{
					vala_class_add_signal (main_class, sig);
				}
			}
			(__temp22 == NULL ? NULL : (__temp22 = (g_list_free (__temp22), NULL)));
		}
		if (vala_class_get_constructor (cl) != NULL) {
			if (vala_class_get_constructor (main_class) != NULL) {
				(vala_code_node_set_error (VALA_CODE_NODE (cl), TRUE), vala_code_node_get_error (VALA_CODE_NODE (cl)));
				char* __temp24 = NULL;
				char* __temp23 = NULL;
				vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_class_get_constructor (cl))), (__temp24 = g_strdup_printf ("`%s' already contains a constructor", (__temp23 = vala_symbol_get_full_name (self->priv->current_symbol)))));
				(__temp24 = (g_free (__temp24), NULL));
				(__temp23 = (g_free (__temp23), NULL));
				(main_class == NULL ? NULL : (main_class = (g_object_unref (main_class), NULL)));
				(class_symbol == NULL ? NULL : (class_symbol = (g_object_unref (class_symbol), NULL)));
				return;
			}
			(vala_class_set_constructor (main_class, vala_class_get_constructor (cl)), vala_class_get_constructor (main_class));
		}
		if (vala_class_get_destructor (cl) != NULL) {
			if (vala_class_get_destructor (main_class) != NULL) {
				(vala_code_node_set_error (VALA_CODE_NODE (cl), TRUE), vala_code_node_get_error (VALA_CODE_NODE (cl)));
				char* __temp26 = NULL;
				char* __temp25 = NULL;
				vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_class_get_destructor (cl))), (__temp26 = g_strdup_printf ("`%s' already contains a destructor", (__temp25 = vala_symbol_get_full_name (self->priv->current_symbol)))));
				(__temp26 = (g_free (__temp26), NULL));
				(__temp25 = (g_free (__temp25), NULL));
				(main_class == NULL ? NULL : (main_class = (g_object_unref (main_class), NULL)));
				(class_symbol == NULL ? NULL : (class_symbol = (g_object_unref (class_symbol), NULL)));
				return;
			}
			(vala_class_set_destructor (main_class, vala_class_get_destructor (cl)), vala_class_get_destructor (main_class));
		}
		(main_class == NULL ? NULL : (main_class = (g_object_unref (main_class), NULL)));
	}
	ValaSymbol* __temp28 = NULL;
	ValaSymbol* __temp27 = NULL;
	self->priv->current_symbol = (__temp28 = (__temp27 = class_symbol, (__temp27 == NULL ? NULL : g_object_ref (__temp27))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp28);
	(class_symbol == NULL ? NULL : (class_symbol = (g_object_unref (class_symbol), NULL)));
}


static void vala_symbol_builder_real_visit_end_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	if (vala_code_node_get_error (VALA_CODE_NODE (cl))) {
		return;
	}
	/* skip classes with errors */
	ValaSymbol* __temp30 = NULL;
	ValaSymbol* __temp29 = NULL;
	self->priv->current_symbol = (__temp30 = (__temp29 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp29 == NULL ? NULL : g_object_ref (__temp29))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp30);
	if (vala_code_node_get_symbol (VALA_CODE_NODE (cl)) == NULL) {
		/* remove merged class */
		vala_namespace_remove_class (VALA_DATA_TYPE (cl)->namespace, cl);
	}
}


static void vala_symbol_builder_real_visit_begin_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	if (vala_symbol_builder_add_symbol (self, vala_data_type_get_name (VALA_DATA_TYPE (st)), VALA_CODE_NODE (st)) == NULL) {
		return;
	}
	ValaSymbol* __temp32 = NULL;
	ValaSymbol* __temp31 = NULL;
	self->priv->current_symbol = (__temp32 = (__temp31 = vala_code_node_get_symbol (VALA_CODE_NODE (st)), (__temp31 == NULL ? NULL : g_object_ref (__temp31))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp32);
}


static void vala_symbol_builder_real_visit_end_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	if (vala_code_node_get_error (VALA_CODE_NODE (st))) {
		return;
	}
	/* skip structs with errors */
	ValaSymbol* __temp34 = NULL;
	ValaSymbol* __temp33 = NULL;
	self->priv->current_symbol = (__temp34 = (__temp33 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp33 == NULL ? NULL : g_object_ref (__temp33))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp34);
}


static void vala_symbol_builder_real_visit_begin_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	if (vala_symbol_builder_add_symbol (self, vala_data_type_get_name (VALA_DATA_TYPE (iface)), VALA_CODE_NODE (iface)) == NULL) {
		return;
	}
	ValaSymbol* __temp36 = NULL;
	ValaSymbol* __temp35 = NULL;
	self->priv->current_symbol = (__temp36 = (__temp35 = vala_code_node_get_symbol (VALA_CODE_NODE (iface)), (__temp35 == NULL ? NULL : g_object_ref (__temp35))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp36);
}


static void vala_symbol_builder_real_visit_end_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	if (vala_code_node_get_error (VALA_CODE_NODE (iface))) {
		return;
	}
	/* skip interfaces with errors */
	ValaSymbol* __temp38 = NULL;
	ValaSymbol* __temp37 = NULL;
	self->priv->current_symbol = (__temp38 = (__temp37 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp37 == NULL ? NULL : g_object_ref (__temp37))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp38);
}


static void vala_symbol_builder_real_visit_begin_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_ENUM (en));
	if (vala_symbol_builder_add_symbol (self, vala_data_type_get_name (VALA_DATA_TYPE (en)), VALA_CODE_NODE (en)) == NULL) {
		return;
	}
	ValaSymbol* __temp40 = NULL;
	ValaSymbol* __temp39 = NULL;
	self->priv->current_symbol = (__temp40 = (__temp39 = vala_code_node_get_symbol (VALA_CODE_NODE (en)), (__temp39 == NULL ? NULL : g_object_ref (__temp39))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp40);
}


static void vala_symbol_builder_real_visit_end_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_ENUM (en));
	if (vala_code_node_get_error (VALA_CODE_NODE (en))) {
		return;
	}
	/* skip enums with errors */
	ValaSymbol* __temp42 = NULL;
	ValaSymbol* __temp41 = NULL;
	self->priv->current_symbol = (__temp42 = (__temp41 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp41 == NULL ? NULL : g_object_ref (__temp41))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp42);
}


static void vala_symbol_builder_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_ENUM_VALUE (ev));
	ValaSymbol* __temp43 = NULL;
	(vala_code_node_set_symbol (VALA_CODE_NODE (ev), (__temp43 = vala_symbol_new (VALA_CODE_NODE (ev)))), vala_code_node_get_symbol (VALA_CODE_NODE (ev)));
	(__temp43 == NULL ? NULL : (__temp43 = (g_object_unref (__temp43), NULL)));
	vala_symbol_add (self->priv->current_symbol, vala_enum_value_get_name (ev), vala_code_node_get_symbol (VALA_CODE_NODE (ev)));
}


static void vala_symbol_builder_real_visit_begin_flags (ValaCodeVisitor* base, ValaFlags* fl)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_FLAGS (fl));
	if (vala_symbol_builder_add_symbol (self, vala_data_type_get_name (VALA_DATA_TYPE (fl)), VALA_CODE_NODE (fl)) == NULL) {
		return;
	}
	ValaSymbol* __temp45 = NULL;
	ValaSymbol* __temp44 = NULL;
	self->priv->current_symbol = (__temp45 = (__temp44 = vala_code_node_get_symbol (VALA_CODE_NODE (fl)), (__temp44 == NULL ? NULL : g_object_ref (__temp44))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp45);
}


static void vala_symbol_builder_real_visit_end_flags (ValaCodeVisitor* base, ValaFlags* fl)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_FLAGS (fl));
	if (vala_code_node_get_error (VALA_CODE_NODE (fl))) {
		return;
	}
	/* skip flags with errors */
	ValaSymbol* __temp47 = NULL;
	ValaSymbol* __temp46 = NULL;
	self->priv->current_symbol = (__temp47 = (__temp46 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp46 == NULL ? NULL : g_object_ref (__temp46))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp47);
}


static void vala_symbol_builder_real_visit_flags_value (ValaCodeVisitor* base, ValaFlagsValue* fv)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_FLAGS_VALUE (fv));
	ValaSymbol* __temp48 = NULL;
	(vala_code_node_set_symbol (VALA_CODE_NODE (fv), (__temp48 = vala_symbol_new (VALA_CODE_NODE (fv)))), vala_code_node_get_symbol (VALA_CODE_NODE (fv)));
	(__temp48 == NULL ? NULL : (__temp48 = (g_object_unref (__temp48), NULL)));
	vala_symbol_add (self->priv->current_symbol, vala_flags_value_get_name (fv), vala_code_node_get_symbol (VALA_CODE_NODE (fv)));
}


static void vala_symbol_builder_real_visit_begin_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	if (vala_symbol_builder_add_symbol (self, vala_data_type_get_name (VALA_DATA_TYPE (cb)), VALA_CODE_NODE (cb)) == NULL) {
		return;
	}
	ValaSymbol* __temp50 = NULL;
	ValaSymbol* __temp49 = NULL;
	self->priv->current_symbol = (__temp50 = (__temp49 = vala_code_node_get_symbol (VALA_CODE_NODE (cb)), (__temp49 == NULL ? NULL : g_object_ref (__temp49))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp50);
}


static void vala_symbol_builder_real_visit_end_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	if (vala_code_node_get_error (VALA_CODE_NODE (cb))) {
		return;
	}
	/* skip enums with errors */
	ValaSymbol* __temp52 = NULL;
	ValaSymbol* __temp51 = NULL;
	self->priv->current_symbol = (__temp52 = (__temp51 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp51 == NULL ? NULL : g_object_ref (__temp51))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp52);
}


static void vala_symbol_builder_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_CONSTANT (c));
	vala_symbol_builder_add_symbol (self, vala_constant_get_name (c), VALA_CODE_NODE (c));
}


static void vala_symbol_builder_real_visit_field (ValaCodeVisitor* base, ValaField* f)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_FIELD (f));
	vala_symbol_builder_add_symbol (self, vala_field_get_name (f), VALA_CODE_NODE (f));
}


static void vala_symbol_builder_real_visit_begin_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_METHOD (m));
	if (vala_symbol_builder_add_symbol (self, vala_method_get_name (m), VALA_CODE_NODE (m)) == NULL) {
		return;
	}
	if (vala_method_get_instance (m)) {
		if (!(VALA_IS_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))))) {
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (m)), "instance methods not allowed outside of data types");
			(vala_code_node_set_error (VALA_CODE_NODE (m), TRUE), vala_code_node_get_error (VALA_CODE_NODE (m)));
			return;
		}
		ValaFormalParameter* __temp53 = NULL;
		(vala_method_set_this_parameter (m, (__temp53 = vala_formal_parameter_new ("this", vala_type_reference_new (), NULL))), vala_method_get_this_parameter (m));
		(__temp53 == NULL ? NULL : (__temp53 = (g_object_unref (__temp53), NULL)));
		(vala_type_reference_set_data_type (vala_formal_parameter_get_type_reference (vala_method_get_this_parameter (m)), VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))), vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (vala_method_get_this_parameter (m))));
		ValaSymbol* __temp54 = NULL;
		(vala_code_node_set_symbol (VALA_CODE_NODE (vala_method_get_this_parameter (m)), (__temp54 = vala_symbol_new (VALA_CODE_NODE (vala_method_get_this_parameter (m))))), vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_this_parameter (m))));
		(__temp54 == NULL ? NULL : (__temp54 = (g_object_unref (__temp54), NULL)));
		vala_symbol_add (self->priv->current_symbol, vala_formal_parameter_get_name (vala_method_get_this_parameter (m)), vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_this_parameter (m))));
	}
	ValaSymbol* __temp56 = NULL;
	ValaSymbol* __temp55 = NULL;
	self->priv->current_symbol = (__temp56 = (__temp55 = vala_code_node_get_symbol (VALA_CODE_NODE (m)), (__temp55 == NULL ? NULL : g_object_ref (__temp55))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp56);
}


static void vala_symbol_builder_real_visit_end_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_METHOD (m));
	if (vala_code_node_get_error (VALA_CODE_NODE (m))) {
		return;
	}
	/* skip methods with errors */
	ValaSymbol* __temp58 = NULL;
	ValaSymbol* __temp57 = NULL;
	self->priv->current_symbol = (__temp58 = (__temp57 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp57 == NULL ? NULL : g_object_ref (__temp57))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp58);
}


static void vala_symbol_builder_real_visit_begin_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	if (vala_symbol_builder_add_symbol (self, vala_method_get_name (VALA_METHOD (m)), VALA_CODE_NODE (m)) == NULL) {
		return;
	}
	ValaCodeNode* __temp59 = NULL;
	ValaCodeNode* type_node = (__temp59 = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))), (__temp59 == NULL ? NULL : g_object_ref (__temp59)));
	if (!(VALA_IS_CLASS (type_node) || VALA_IS_STRUCT (type_node))) {
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (m)), "construction methods may only be declared within classes and structs");
		(vala_code_node_set_error (VALA_CODE_NODE (m), TRUE), vala_code_node_get_error (VALA_CODE_NODE (m)));
		(type_node == NULL ? NULL : (type_node = (g_object_unref (type_node), NULL)));
		return;
	}
	if (vala_method_get_name (VALA_METHOD (m)) == NULL) {
		if (VALA_IS_CLASS (type_node)) {
			(vala_class_set_default_construction_method ((VALA_CLASS (type_node)), VALA_METHOD (m)), vala_class_get_default_construction_method ((VALA_CLASS (type_node))));
		} else {
			if (VALA_IS_STRUCT (type_node)) {
				(vala_struct_set_default_construction_method ((VALA_STRUCT (type_node)), VALA_METHOD (m)), vala_struct_get_default_construction_method ((VALA_STRUCT (type_node))));
			}
		}
	}
	ValaSymbol* __temp61 = NULL;
	ValaSymbol* __temp60 = NULL;
	self->priv->current_symbol = (__temp61 = (__temp60 = vala_code_node_get_symbol (VALA_CODE_NODE (m)), (__temp60 == NULL ? NULL : g_object_ref (__temp60))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp61);
	(type_node == NULL ? NULL : (type_node = (g_object_unref (type_node), NULL)));
}


static void vala_symbol_builder_real_visit_end_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	if (vala_code_node_get_error (VALA_CODE_NODE (m))) {
		return;
	}
	/* skip methods with errors */
	ValaSymbol* __temp63 = NULL;
	ValaSymbol* __temp62 = NULL;
	self->priv->current_symbol = (__temp63 = (__temp62 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp62 == NULL ? NULL : g_object_ref (__temp62))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp63);
}


static void vala_symbol_builder_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		vala_symbol_builder_add_symbol (self, vala_formal_parameter_get_name (p), VALA_CODE_NODE (p));
	}
}


static void vala_symbol_builder_real_visit_begin_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	if (vala_symbol_builder_add_symbol (self, vala_property_get_name (prop), VALA_CODE_NODE (prop)) == NULL) {
		return;
	}
	ValaSymbol* __temp65 = NULL;
	ValaSymbol* __temp64 = NULL;
	self->priv->current_symbol = (__temp65 = (__temp64 = vala_code_node_get_symbol (VALA_CODE_NODE (prop)), (__temp64 == NULL ? NULL : g_object_ref (__temp64))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp65);
	ValaFormalParameter* __temp66 = NULL;
	(vala_property_set_this_parameter (prop, (__temp66 = vala_formal_parameter_new ("this", vala_type_reference_new (), NULL))), vala_property_get_this_parameter (prop));
	(__temp66 == NULL ? NULL : (__temp66 = (g_object_unref (__temp66), NULL)));
	(vala_type_reference_set_data_type (vala_formal_parameter_get_type_reference (vala_property_get_this_parameter (prop)), VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop)))))), vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (vala_property_get_this_parameter (prop))));
	ValaSymbol* __temp67 = NULL;
	(vala_code_node_set_symbol (VALA_CODE_NODE (vala_property_get_this_parameter (prop)), (__temp67 = vala_symbol_new (VALA_CODE_NODE (vala_property_get_this_parameter (prop))))), vala_code_node_get_symbol (VALA_CODE_NODE (vala_property_get_this_parameter (prop))));
	(__temp67 == NULL ? NULL : (__temp67 = (g_object_unref (__temp67), NULL)));
	vala_symbol_add (self->priv->current_symbol, vala_formal_parameter_get_name (vala_property_get_this_parameter (prop)), vala_code_node_get_symbol (VALA_CODE_NODE (vala_property_get_this_parameter (prop))));
}


static void vala_symbol_builder_real_visit_end_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	if (vala_code_node_get_error (VALA_CODE_NODE (prop))) {
		return;
	}
	/* skip properties with errors */
	ValaSymbol* __temp69 = NULL;
	ValaSymbol* __temp68 = NULL;
	self->priv->current_symbol = (__temp69 = (__temp68 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp68 == NULL ? NULL : g_object_ref (__temp68))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp69);
}


static void vala_symbol_builder_real_visit_begin_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	ValaSymbol* __temp70 = NULL;
	(vala_code_node_set_symbol (VALA_CODE_NODE (acc), (__temp70 = vala_symbol_new (VALA_CODE_NODE (acc)))), vala_code_node_get_symbol (VALA_CODE_NODE (acc)));
	(__temp70 == NULL ? NULL : (__temp70 = (g_object_unref (__temp70), NULL)));
	(vala_symbol_set_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (acc)), self->priv->current_symbol), vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (acc))));
	ValaSymbol* __temp72 = NULL;
	ValaSymbol* __temp71 = NULL;
	self->priv->current_symbol = (__temp72 = (__temp71 = vala_code_node_get_symbol (VALA_CODE_NODE (acc)), (__temp71 == NULL ? NULL : g_object_ref (__temp71))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp72);
	if (vala_source_file_get_pkg (self->priv->current_source_file)) {
		return;
	}
	if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
		ValaFormalParameter* __temp73 = NULL;
		(vala_property_accessor_set_value_parameter (acc, (__temp73 = vala_formal_parameter_new ("value", vala_property_get_type_reference ((VALA_PROPERTY (vala_symbol_get_node (vala_symbol_get_parent_symbol (self->priv->current_symbol))))), NULL))), vala_property_accessor_get_value_parameter (acc));
		(__temp73 == NULL ? NULL : (__temp73 = (g_object_unref (__temp73), NULL)));
		ValaSymbol* __temp74 = NULL;
		(vala_code_node_set_symbol (VALA_CODE_NODE (vala_property_accessor_get_value_parameter (acc)), (__temp74 = vala_symbol_new (VALA_CODE_NODE (vala_property_accessor_get_value_parameter (acc))))), vala_code_node_get_symbol (VALA_CODE_NODE (vala_property_accessor_get_value_parameter (acc))));
		(__temp74 == NULL ? NULL : (__temp74 = (g_object_unref (__temp74), NULL)));
		vala_symbol_add (self->priv->current_symbol, vala_formal_parameter_get_name (vala_property_accessor_get_value_parameter (acc)), vala_code_node_get_symbol (VALA_CODE_NODE (vala_property_accessor_get_value_parameter (acc))));
	}
	if (vala_property_accessor_get_body (acc) == NULL) {
		/* no accessor body specified, insert default body */
		ValaProperty* __temp75 = NULL;
		ValaProperty* prop = (__temp75 = VALA_PROPERTY (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (acc))))), (__temp75 == NULL ? NULL : g_object_ref (__temp75)));
		if (vala_property_get_interface_only (prop) || vala_property_get_is_abstract (prop)) {
			(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			return;
		}
		ValaBlock* block = vala_block_new (NULL);
		if (vala_property_accessor_get_readable (acc)) {
			ValaReturnStatement* __temp76 = NULL;
			vala_block_add_statement (block, VALA_STATEMENT ((__temp76 = vala_return_statement_new (VALA_EXPRESSION (vala_member_access_new_simple (g_strdup_printf ("_%s", vala_property_get_name (prop)), NULL)), NULL))));
			(__temp76 == NULL ? NULL : (__temp76 = (g_object_unref (__temp76), NULL)));
		} else {
			ValaExpressionStatement* __temp77 = NULL;
			vala_block_add_statement (block, VALA_STATEMENT ((__temp77 = vala_expression_statement_new (VALA_EXPRESSION (vala_assignment_new (VALA_EXPRESSION (vala_member_access_new_simple (g_strdup_printf ("_%s", vala_property_get_name (prop)), NULL)), VALA_EXPRESSION (vala_member_access_new_simple ("value", NULL)), VALA_ASSIGNMENT_OPERATOR_SIMPLE, NULL)), NULL))));
			(__temp77 == NULL ? NULL : (__temp77 = (g_object_unref (__temp77), NULL)));
		}
		(vala_property_accessor_set_body (acc, VALA_STATEMENT (block)), vala_property_accessor_get_body (acc));
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
}


static void vala_symbol_builder_real_visit_end_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	ValaSymbol* __temp79 = NULL;
	ValaSymbol* __temp78 = NULL;
	self->priv->current_symbol = (__temp79 = (__temp78 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp78 == NULL ? NULL : g_object_ref (__temp78))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp79);
}


static void vala_symbol_builder_real_visit_begin_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	if (vala_symbol_builder_add_symbol (self, vala_signal_get_name (sig), VALA_CODE_NODE (sig)) == NULL) {
		return;
	}
	ValaSymbol* __temp81 = NULL;
	ValaSymbol* __temp80 = NULL;
	self->priv->current_symbol = (__temp81 = (__temp80 = vala_code_node_get_symbol (VALA_CODE_NODE (sig)), (__temp80 == NULL ? NULL : g_object_ref (__temp80))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp81);
}


static void vala_symbol_builder_real_visit_end_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	if (vala_code_node_get_error (VALA_CODE_NODE (sig))) {
		return;
	}
	/* skip signals with errors */
	ValaSymbol* __temp83 = NULL;
	ValaSymbol* __temp82 = NULL;
	self->priv->current_symbol = (__temp83 = (__temp82 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp82 == NULL ? NULL : g_object_ref (__temp82))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp83);
}


static void vala_symbol_builder_real_visit_begin_constructor (ValaCodeVisitor* base, ValaConstructor* c)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	ValaSymbol* __temp84 = NULL;
	(vala_code_node_set_symbol (VALA_CODE_NODE (c), (__temp84 = vala_symbol_new (VALA_CODE_NODE (c)))), vala_code_node_get_symbol (VALA_CODE_NODE (c)));
	(__temp84 == NULL ? NULL : (__temp84 = (g_object_unref (__temp84), NULL)));
	(vala_symbol_set_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c)), self->priv->current_symbol), vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c))));
	ValaSymbol* __temp86 = NULL;
	ValaSymbol* __temp85 = NULL;
	self->priv->current_symbol = (__temp86 = (__temp85 = vala_code_node_get_symbol (VALA_CODE_NODE (c)), (__temp85 == NULL ? NULL : g_object_ref (__temp85))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp86);
}


static void vala_symbol_builder_real_visit_end_constructor (ValaCodeVisitor* base, ValaConstructor* c)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	ValaSymbol* __temp88 = NULL;
	ValaSymbol* __temp87 = NULL;
	self->priv->current_symbol = (__temp88 = (__temp87 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp87 == NULL ? NULL : g_object_ref (__temp87))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp88);
}


static void vala_symbol_builder_real_visit_begin_destructor (ValaCodeVisitor* base, ValaDestructor* d)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_DESTRUCTOR (d));
	ValaSymbol* __temp89 = NULL;
	(vala_code_node_set_symbol (VALA_CODE_NODE (d), (__temp89 = vala_symbol_new (VALA_CODE_NODE (d)))), vala_code_node_get_symbol (VALA_CODE_NODE (d)));
	(__temp89 == NULL ? NULL : (__temp89 = (g_object_unref (__temp89), NULL)));
	(vala_symbol_set_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (d)), self->priv->current_symbol), vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (d))));
	ValaSymbol* __temp91 = NULL;
	ValaSymbol* __temp90 = NULL;
	self->priv->current_symbol = (__temp91 = (__temp90 = vala_code_node_get_symbol (VALA_CODE_NODE (d)), (__temp90 == NULL ? NULL : g_object_ref (__temp90))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp91);
}


static void vala_symbol_builder_real_visit_end_destructor (ValaCodeVisitor* base, ValaDestructor* d)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_DESTRUCTOR (d));
	ValaSymbol* __temp93 = NULL;
	ValaSymbol* __temp92 = NULL;
	self->priv->current_symbol = (__temp93 = (__temp92 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp92 == NULL ? NULL : g_object_ref (__temp92))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp93);
}


static void vala_symbol_builder_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	ValaSymbol* __temp94 = NULL;
	(vala_code_node_set_symbol (VALA_CODE_NODE (b), (__temp94 = vala_symbol_new (VALA_CODE_NODE (b)))), vala_code_node_get_symbol (VALA_CODE_NODE (b)));
	(__temp94 == NULL ? NULL : (__temp94 = (g_object_unref (__temp94), NULL)));
	(vala_symbol_set_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (b)), self->priv->current_symbol), vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (b))));
	ValaSymbol* __temp96 = NULL;
	ValaSymbol* __temp95 = NULL;
	self->priv->current_symbol = (__temp96 = (__temp95 = vala_code_node_get_symbol (VALA_CODE_NODE (b)), (__temp95 == NULL ? NULL : g_object_ref (__temp95))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp96);
}


static void vala_symbol_builder_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	ValaSymbol* __temp98 = NULL;
	ValaSymbol* __temp97 = NULL;
	self->priv->current_symbol = (__temp98 = (__temp97 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp97 == NULL ? NULL : g_object_ref (__temp97))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp98);
}


static void vala_symbol_builder_real_visit_type_parameter (ValaCodeVisitor* base, ValaTypeParameter* p)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (base);
	g_return_if_fail (VALA_IS_TYPE_PARAMETER (p));
	vala_symbol_builder_add_symbol (self, vala_type_parameter_get_name (p), VALA_CODE_NODE (p));
}


static void vala_symbol_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (object);
	switch (property_id) {
	}
}


static void vala_symbol_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (object);
	switch (property_id) {
	}
}


static void vala_symbol_builder_class_init (ValaSymbolBuilderClass * klass)
{
	vala_symbol_builder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSymbolBuilderPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_symbol_builder_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_symbol_builder_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_symbol_builder_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_source_file = vala_symbol_builder_real_visit_begin_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_namespace = vala_symbol_builder_real_visit_begin_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_namespace = vala_symbol_builder_real_visit_end_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_class = vala_symbol_builder_real_visit_begin_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_class = vala_symbol_builder_real_visit_end_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_struct = vala_symbol_builder_real_visit_begin_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_struct = vala_symbol_builder_real_visit_end_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_interface = vala_symbol_builder_real_visit_begin_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_interface = vala_symbol_builder_real_visit_end_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_enum = vala_symbol_builder_real_visit_begin_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_enum = vala_symbol_builder_real_visit_end_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_symbol_builder_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_flags = vala_symbol_builder_real_visit_begin_flags;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_flags = vala_symbol_builder_real_visit_end_flags;
	VALA_CODE_VISITOR_CLASS (klass)->visit_flags_value = vala_symbol_builder_real_visit_flags_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_callback = vala_symbol_builder_real_visit_begin_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_callback = vala_symbol_builder_real_visit_end_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_symbol_builder_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_symbol_builder_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_method = vala_symbol_builder_real_visit_begin_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_method = vala_symbol_builder_real_visit_end_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_creation_method = vala_symbol_builder_real_visit_begin_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_creation_method = vala_symbol_builder_real_visit_end_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_symbol_builder_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_property = vala_symbol_builder_real_visit_begin_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_property = vala_symbol_builder_real_visit_end_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_property_accessor = vala_symbol_builder_real_visit_begin_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_property_accessor = vala_symbol_builder_real_visit_end_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_signal = vala_symbol_builder_real_visit_begin_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_signal = vala_symbol_builder_real_visit_end_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_constructor = vala_symbol_builder_real_visit_begin_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_constructor = vala_symbol_builder_real_visit_end_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_destructor = vala_symbol_builder_real_visit_begin_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_destructor = vala_symbol_builder_real_visit_end_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_block = vala_symbol_builder_real_visit_begin_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_block = vala_symbol_builder_real_visit_end_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_parameter = vala_symbol_builder_real_visit_type_parameter;
}


static void vala_symbol_builder_init (ValaSymbolBuilder * self)
{
	self->priv = VALA_SYMBOL_BUILDER_GET_PRIVATE (self);
}


static void vala_symbol_builder_dispose (GObject * obj)
{
	ValaSymbolBuilder * self = VALA_SYMBOL_BUILDER (obj);
	(self->priv->root == NULL ? NULL : (self->priv->root = (g_object_unref (self->priv->root), NULL)));
	(self->priv->current_type == NULL ? NULL : (self->priv->current_type = (g_object_unref (self->priv->current_type), NULL)));
	(self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL)));
	(self->priv->current_source_file == NULL ? NULL : (self->priv->current_source_file = (g_object_unref (self->priv->current_source_file), NULL)));
	ValaSymbolBuilderClass * klass;
	GObjectClass * parent_class;
	klass = VALA_SYMBOL_BUILDER_CLASS (g_type_class_peek (VALA_TYPE_SYMBOL_BUILDER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_symbol_builder_get_type ()
{
	static GType vala_symbol_builder_type_id = 0;
	if (G_UNLIKELY (vala_symbol_builder_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbolBuilder), 0, (GInstanceInitFunc) vala_symbol_builder_init };
		vala_symbol_builder_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSymbolBuilder", &g_define_type_info, 0);
	}
	return vala_symbol_builder_type_id;
}




