/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valamemberaccess.h"
#include <vala/valasourcereference.h>
#include <vala/valamemberaccess.h>
#include <vala/valatypereference.h>
#include <vala/valacodevisitor.h>

struct _ValaMemberAccessPrivate {
	char* _member_name;
	ValaExpression* _inner;
	GList* type_argument_list;
};
#define VALA_MEMBER_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessPrivate))
enum  {
	VALA_MEMBER_ACCESS_DUMMY_PROPERTY,
	VALA_MEMBER_ACCESS_INNER,
	VALA_MEMBER_ACCESS_MEMBER_NAME
};
static void vala_member_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_member_access_parent_class = NULL;
static void vala_member_access_dispose (GObject * obj);


/**
 * Creates a new member access expression.
 *
 * @param inner  parent of the member
 * @param member member name
 * @param source reference to source code
 * @return       newly created member access expression
 */
ValaMemberAccess* vala_member_access_new (ValaExpression* _inner, const char* member, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaMemberAccess * self;
	g_return_val_if_fail (_inner == NULL || VALA_IS_EXPRESSION (_inner), NULL);
	g_return_val_if_fail (member != NULL, NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	(__params_it->name = "inner", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, _inner), __params_it++);
	(__params_it->name = "member-name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, member), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_MEMBER_ACCESS, __params_it - __params, __params);
	return self;
}


ValaMemberAccess* vala_member_access_new_simple (const char* member, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaMemberAccess * self;
	g_return_val_if_fail (member != NULL, NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "member-name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, member), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_MEMBER_ACCESS, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void vala_member_access_add_type_argument (ValaMemberAccess* self, ValaTypeReference* arg)
{
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (self));
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (arg));
	self->priv->type_argument_list = g_list_append (self->priv->type_argument_list, g_object_ref (arg));
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
GList* vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (self), NULL);
	return g_list_copy (self->priv->type_argument_list);
}


static void vala_member_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = VALA_MEMBER_ACCESS (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (vala_member_access_get_inner (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_member_access_get_inner (self)), visitor);
	}
	{
		GList* __temp1;
		GList* type_arg_it;
		__temp1 = NULL;
		__temp1 = self->priv->type_argument_list;
		for (type_arg_it = __temp1; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
			ValaTypeReference* type_arg;
			type_arg = type_arg_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (type_arg), visitor);
			}
		}
	}
	vala_code_visitor_visit_member_access (visitor, self);
}


static char* vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	self = VALA_MEMBER_ACCESS (base);
	if (vala_member_access_get_inner (self) == NULL) {
		return g_strdup (vala_member_access_get_member_name (self));
	} else {
		char* __temp3;
		char* __temp4;
		__temp3 = NULL;
		__temp4 = NULL;
		return (__temp4 = g_strdup_printf ("%s.%s", (__temp3 = vala_code_node_to_string (VALA_CODE_NODE (vala_member_access_get_inner (self)))), vala_member_access_get_member_name (self)), (__temp3 = (g_free (__temp3), NULL)), __temp4);
	}
}


static void vala_member_access_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaMemberAccess * self;
	self = VALA_MEMBER_ACCESS (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_member_access_get_inner (self)) == old_node) {
		(vala_member_access_set_inner (self, VALA_EXPRESSION (new_node)), vala_member_access_get_inner (self));
	}
}


ValaExpression* vala_member_access_get_inner (ValaMemberAccess* self)
{
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (self), NULL);
	return self->priv->_inner;
}


void vala_member_access_set_inner (ValaMemberAccess* self, ValaExpression* value)
{
	ValaExpression* __temp8;
	ValaExpression* __temp7;
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (self));
	__temp8 = NULL;
	__temp7 = NULL;
	self->priv->_inner = (__temp8 = (__temp7 = value, (__temp7 == NULL ? NULL : g_object_ref (__temp7))), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), __temp8);
	if (self->priv->_inner != NULL) {
		(vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_inner), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (self->priv->_inner)));
	}
}


char* vala_member_access_get_member_name (ValaMemberAccess* self)
{
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (self), NULL);
	return self->priv->_member_name;
}


void vala_member_access_set_member_name (ValaMemberAccess* self, const char* value)
{
	char* __temp10;
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (self));
	__temp10 = NULL;
	self->priv->_member_name = (__temp10 = g_strdup (value), (self->priv->_member_name = (g_free (self->priv->_member_name), NULL)), __temp10);
}


static void vala_member_access_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaMemberAccess * self;
	self = VALA_MEMBER_ACCESS (object);
	switch (property_id) {
		case VALA_MEMBER_ACCESS_INNER:
		g_value_set_object (value, vala_member_access_get_inner (self));
		break;
		case VALA_MEMBER_ACCESS_MEMBER_NAME:
		g_value_set_string (value, vala_member_access_get_member_name (self));
		break;
	}
}


static void vala_member_access_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaMemberAccess * self;
	self = VALA_MEMBER_ACCESS (object);
	switch (property_id) {
		case VALA_MEMBER_ACCESS_INNER:
		vala_member_access_set_inner (self, g_value_get_object (value));
		break;
		case VALA_MEMBER_ACCESS_MEMBER_NAME:
		vala_member_access_set_member_name (self, g_value_get_string (value));
		break;
	}
}


static void vala_member_access_class_init (ValaMemberAccessClass * klass)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaMemberAccessPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_member_access_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_member_access_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_member_access_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_member_access_real_accept;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_member_access_real_to_string;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_member_access_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_MEMBER_ACCESS_INNER, g_param_spec_object ("inner", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_MEMBER_ACCESS_MEMBER_NAME, g_param_spec_string ("member-name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_member_access_init (ValaMemberAccess * self)
{
	self->priv = VALA_MEMBER_ACCESS_GET_PRIVATE (self);
}


static void vala_member_access_dispose (GObject * obj)
{
	ValaMemberAccess * self;
	ValaMemberAccessClass * klass;
	GObjectClass * parent_class;
	self = VALA_MEMBER_ACCESS (obj);
	(self->priv->_member_name = (g_free (self->priv->_member_name), NULL));
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	(self->priv->type_argument_list == NULL ? NULL : (self->priv->type_argument_list = (g_list_foreach (self->priv->type_argument_list, (GFunc) g_object_unref, NULL), g_list_free (self->priv->type_argument_list), NULL)));
	klass = VALA_MEMBER_ACCESS_CLASS (g_type_class_peek (VALA_TYPE_MEMBER_ACCESS));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_member_access_get_type ()
{
	static GType vala_member_access_type_id = 0;
	if (G_UNLIKELY (vala_member_access_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_init };
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	}
	return vala_member_access_type_id;
}




