/* valaccodebinaryexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEBINARYEXPRESSION_H__
#define __CCODE_VALACCODEBINARYEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_BINARY_EXPRESSION (vala_ccode_binary_expression_get_type ())
#define VALA_CCODE_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BINARY_EXPRESSION, ValaCCodeBinaryExpression))
#define VALA_CCODE_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BINARY_EXPRESSION, ValaCCodeBinaryExpressionClass))
#define VALA_IS_CCODE_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BINARY_EXPRESSION))
#define VALA_IS_CCODE_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BINARY_EXPRESSION))
#define VALA_CCODE_BINARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BINARY_EXPRESSION, ValaCCodeBinaryExpressionClass))

typedef struct _ValaCCodeBinaryExpression ValaCCodeBinaryExpression;
typedef struct _ValaCCodeBinaryExpressionClass ValaCCodeBinaryExpressionClass;
typedef struct _ValaCCodeBinaryExpressionPrivate ValaCCodeBinaryExpressionPrivate;

/**
 * Represents an expression with two operands in C code.
 */
struct _ValaCCodeBinaryExpression {
	ValaCCodeExpression parent_instance;
	ValaCCodeBinaryExpressionPrivate * priv;
};
struct _ValaCCodeBinaryExpressionClass {
	ValaCCodeExpressionClass parent_class;
};
typedef enum  {
	VALA_CCODE_BINARY_OPERATOR_PLUS,
	VALA_CCODE_BINARY_OPERATOR_MINUS,
	VALA_CCODE_BINARY_OPERATOR_MUL,
	VALA_CCODE_BINARY_OPERATOR_DIV,
	VALA_CCODE_BINARY_OPERATOR_MOD,
	VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT,
	VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT,
	VALA_CCODE_BINARY_OPERATOR_LESS_THAN,
	VALA_CCODE_BINARY_OPERATOR_GREATER_THAN,
	VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL,
	VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL,
	VALA_CCODE_BINARY_OPERATOR_EQUALITY,
	VALA_CCODE_BINARY_OPERATOR_INEQUALITY,
	VALA_CCODE_BINARY_OPERATOR_BITWISE_AND,
	VALA_CCODE_BINARY_OPERATOR_BITWISE_OR,
	VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR,
	VALA_CCODE_BINARY_OPERATOR_AND,
	VALA_CCODE_BINARY_OPERATOR_OR
} ValaCCodeBinaryOperator;

ValaCCodeBinaryExpression* vala_ccode_binary_expression_new (ValaCCodeBinaryOperator op, ValaCCodeExpression* l, ValaCCodeExpression* r);
ValaCCodeBinaryOperator vala_ccode_binary_expression_get_operator (ValaCCodeBinaryExpression* self);
void vala_ccode_binary_expression_set_operator (ValaCCodeBinaryExpression* self, ValaCCodeBinaryOperator value);
ValaCCodeExpression* vala_ccode_binary_expression_get_left (ValaCCodeBinaryExpression* self);
void vala_ccode_binary_expression_set_left (ValaCCodeBinaryExpression* self, ValaCCodeExpression* value);
ValaCCodeExpression* vala_ccode_binary_expression_get_right (ValaCCodeBinaryExpression* self);
void vala_ccode_binary_expression_set_right (ValaCCodeBinaryExpression* self, ValaCCodeExpression* value);
GType vala_ccode_binary_expression_get_type (void);

G_END_DECLS

#endif
