/* valagidlparser.c generated by valac, the Vala compiler
 * generated from valagidlparser.vala, do not modify */

/* valagidlparser.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gidlparser.h>
#include <gidlmodule.h>
#include <gidlnode.h>
#include <float.h>
#include <math.h>
#include <gmetadata.h>
#include <stdio.h>


#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_idl_module_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_idl_module_free0_ (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))

struct _ValaGIdlParser {
	ValaCodeVisitor parent_instance;
	ValaGIdlParserPrivate * priv;
};

struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIdlParserPrivate {
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaSourceReference* current_source_reference;
	ValaNamespace* current_namespace;
	ValaTypeSymbol* current_data_type;
	ValaMap* codenode_attributes_map;
	ValaMap* codenode_attributes_patterns;
	ValaSet* current_type_symbol_set;
	ValaMap* cname_type_map;
};


static gpointer vala_gidl_parser_parent_class = NULL;
static GRegex* vala_gidl_parser_type_from_string_regex;
static GRegex* vala_gidl_parser_type_from_string_regex = NULL;

GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
#define VALA_GIDL_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIDL_PARSER, ValaGIdlParserPrivate))
enum  {
	VALA_GIDL_PARSER_DUMMY_PROPERTY
};
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t);
static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file);
static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module);
static void _g_idl_module_free0_ (gpointer var);
static void _g_list_free__g_idl_module_free0_ (GList* self);
static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const gchar* type_name, ValaSymbol* container);
static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const gchar* codenode, int* result_length1);
static gchar* vala_gidl_parser_eval (ValaGIdlParser* self, const gchar* s);
static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const gchar* const_name, ValaSymbol* container);
static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self, GIdlNode* node, int* result_length1);
static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self, ValaSymbol* container, ValaSymbol* sym);
static void vala_gidl_parser_parse_node (ValaGIdlParser* self, GIdlNode* node, GIdlModule* module, ValaSymbol* container);
static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node);
static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaSymbol* container, GIdlModule* module, gboolean is_flags);
static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module);
static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node);
static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface);
static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self, const gchar* name);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction);
static gboolean vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self, ValaDataType* parent_type, const gchar* type_arguments, ValaSourceReference* source_reference);
static ValaDataType* vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self, const gchar* type_string, gboolean owned_by_default, ValaSourceReference* source_reference);
static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const gchar* cname);
static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const gchar* n);
static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node);
static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction);
static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface);
static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node);
static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node);
static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol);
static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const gchar* type_name);
static ValaUnresolvedSymbol* vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self, const gchar* symbol_string, ValaSourceReference* source_reference);
static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const gchar* name, const gchar* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface);
static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param);
static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const gchar* name);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
static void vala_gidl_parser_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Parse all source files in the specified code context and build a
 * code tree.
 *
 * @param context a code context
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context) {
	ValaHashMap* _tmp0_ = NULL;
	ValaMap* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	ValaMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_str_hash, g_str_equal, g_direct_equal);
	_tmp1_ = (ValaMap*) _tmp0_;
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = _tmp1_;
	_tmp2_ = _vala_code_context_ref0 (context);
	_tmp3_ = _tmp2_;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp3_;
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_tmp4_ = NULL;
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = _tmp4_;
}


static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ns != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
}


static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (cl != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) cl);
}


static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (st != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) st);
}


static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (iface != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) iface);
}


static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (en != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) en);
}


static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ed != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) ed);
}


static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (d != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) d);
}


static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = vala_typesymbol_get_cname (t, FALSE);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_map_contains (self->priv->cname_type_map, _tmp1_);
	if ((_tmp3_ = !_tmp2_, _g_free0 (_tmp1_), _tmp3_)) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = vala_typesymbol_get_cname (t, FALSE);
		_tmp5_ = _tmp4_;
		vala_map_set (self->priv->cname_type_map, _tmp5_, t);
		_g_free0 (_tmp5_);
	}
}


static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGIdlParser * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = g_str_has_suffix (_tmp0_, ".gi");
	if (_tmp1_) {
		vala_gidl_parser_parse_file (self, source_file);
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = strnlen ((gchar*) self, (gsize) (offset + len));
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) (-1), c);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void _g_idl_module_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_idl_module_free (var), NULL));
}


static void _g_list_free__g_idl_module_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_idl_module_free0_, NULL);
	g_list_free (self);
}


static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* metadata_filename;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaHashMap* _tmp10_ = NULL;
	ValaMap* _tmp11_;
	ValaHashMap* _tmp12_ = NULL;
	ValaMap* _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp26_ = NULL;
	GList* _tmp27_ = NULL;
	GList* modules;
	ValaSourceReference* _tmp28_ = NULL;
	ValaSourceReference* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = vala_source_file_get_filename (source_file);
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = strlen (".gi");
	_tmp4_ = string_substring (_tmp0_, (glong) 0, (glong) (_tmp2_ - _tmp3_));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s.metadata", _tmp5_);
	metadata_filename = (_tmp7_ = _tmp6_, _g_free0 (_tmp5_), _tmp7_);
	_tmp8_ = _vala_source_file_ref0 (source_file);
	_tmp9_ = _tmp8_;
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp9_;
	_tmp10_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	_tmp11_ = (ValaMap*) _tmp10_;
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	self->priv->codenode_attributes_map = _tmp11_;
	_tmp12_ = vala_hash_map_new (G_TYPE_POINTER, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_hash, (GEqualFunc) g_pattern_spec_equal, g_direct_equal);
	_tmp13_ = (ValaMap*) _tmp12_;
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	self->priv->codenode_attributes_patterns = _tmp13_;
	_tmp14_ = g_file_test (metadata_filename, G_FILE_TEST_EXISTS);
	if (_tmp14_) {
		gchar* metadata = NULL;
		gchar* _tmp15_ = NULL;
		gchar** _tmp16_;
		gchar** _tmp17_ = NULL;
		g_file_get_contents (metadata_filename, &_tmp15_, NULL, &_inner_error_);
		_g_free0 (metadata);
		metadata = _tmp15_;
		if (_inner_error_ != NULL) {
			_g_free0 (metadata);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (metadata);
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp17_ = _tmp16_ = g_strsplit (metadata, "\n", 0);
		{
			gchar** line_collection;
			int line_collection_length1;
			int line_it;
			line_collection = _tmp17_;
			line_collection_length1 = _vala_array_length (_tmp16_);
			for (line_it = 0; line_it < _vala_array_length (_tmp16_); line_it = line_it + 1) {
				gchar* _tmp18_;
				gchar* line;
				_tmp18_ = g_strdup (line_collection[line_it]);
				line = _tmp18_;
				{
					gboolean _tmp19_;
					gchar** _tmp20_;
					gchar** _tmp21_ = NULL;
					gchar** tokens;
					gint tokens_length1;
					gint _tokens_size_;
					gint _tmp22_;
					_tmp19_ = g_str_has_prefix (line, "#");
					if (_tmp19_) {
						_g_free0 (line);
						continue;
					}
					_tmp21_ = _tmp20_ = g_strsplit (line, " ", 2);
					tokens = _tmp21_;
					tokens_length1 = _vala_array_length (_tmp20_);
					_tokens_size_ = _vala_array_length (_tmp20_);
					if (NULL == tokens[0]) {
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
						continue;
					}
					_tmp22_ = string_index_of_char (tokens[0], (gunichar) '*', 0);
					if ((-1) != _tmp22_) {
						GPatternSpec* _tmp23_ = NULL;
						GPatternSpec* pattern;
						_tmp23_ = g_pattern_spec_new (tokens[0]);
						pattern = _tmp23_;
						vala_map_set (self->priv->codenode_attributes_patterns, pattern, tokens[0]);
					}
					vala_map_set (self->priv->codenode_attributes_map, tokens[0], tokens[1]);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
				}
			}
			line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (metadata);
		goto __finally0;
		__catch0_g_file_error:
		{
			GError * e;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = g_strdup_printf ("Unable to read metadata file: %s", e->message);
			_tmp25_ = _tmp24_;
			vala_report_error (NULL, _tmp25_);
			_g_free0 (_tmp25_);
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp26_ = vala_source_file_get_filename (source_file);
	_tmp27_ = g_idl_parse_file (_tmp26_, &_inner_error_);
	modules = _tmp27_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_MARKUP_ERROR) {
			goto __catch1_g_markup_error;
		}
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp28_ = vala_source_reference_new (source_file, 0, 0, 0, 0);
	_tmp29_ = _tmp28_;
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	self->priv->current_source_reference = _tmp29_;
	{
		GList* module_collection;
		GList* module_it;
		module_collection = modules;
		for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
			GIdlModule* module;
			module = (GIdlModule*) module_it->data;
			{
				ValaNamespace* _tmp30_ = NULL;
				ValaNamespace* ns;
				_tmp30_ = vala_gidl_parser_parse_module (self, module);
				ns = _tmp30_;
				if (ns != NULL) {
					ValaNamespace* _tmp31_ = NULL;
					_tmp31_ = vala_code_context_get_root (self->priv->context);
					vala_symbol_add_namespace ((ValaSymbol*) _tmp31_, ns);
				}
				_vala_code_node_unref0 (ns);
			}
		}
	}
	__g_list_free__g_idl_module_free0_0 (modules);
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError * e;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = g_strdup_printf ("Unable to parse GIDL file: %s", e->message);
		_tmp33_ = _tmp32_;
		vala_report_error (NULL, _tmp33_);
		_g_free0 (_tmp33_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (metadata_filename);
}


static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const gchar* type_name, ValaSymbol* container) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_;
	gchar* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp1_ = vala_gidl_parser_get_attributes (self, type_name, &_tmp0_);
	attributes = _tmp1_;
	attributes_length1 = _tmp0_;
	_attributes_size_ = _tmp0_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp2_;
				gchar* attr;
				_tmp2_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp2_;
				{
					gchar** _tmp3_;
					gchar** _tmp4_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp4_ = _tmp3_ = g_strsplit (attr, "=", 2);
					nv = _tmp4_;
					nv_length1 = _vala_array_length (_tmp3_);
					_nv_size_ = _vala_array_length (_tmp3_);
					if (g_strcmp0 (nv[0], "name") == 0) {
						gchar* _tmp5_ = NULL;
						_tmp5_ = vala_gidl_parser_eval (self, nv[1]);
						result = _tmp5_;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp6_ = vala_symbol_get_name (container);
	_tmp7_ = g_str_has_prefix (type_name, _tmp6_);
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
		_tmp8_ = vala_symbol_get_name (container);
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = string_substring (type_name, (glong) _tmp9_, (glong) (-1));
		result = _tmp10_;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_ = NULL;
		_tmp12_ = vala_symbol_get_name (container);
		if (g_strcmp0 (_tmp12_, "GLib") == 0) {
			gboolean _tmp13_;
			_tmp13_ = g_str_has_prefix (type_name, "G");
			_tmp11_ = _tmp13_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gchar* _tmp14_ = NULL;
			_tmp14_ = string_substring (type_name, (glong) 1, (glong) (-1));
			result = _tmp14_;
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			gchar* best_match;
			best_match = NULL;
			if (VALA_IS_NAMESPACE (container)) {
				{
					ValaList* _tmp15_ = NULL;
					ValaList* _cprefix_list;
					gint _tmp16_;
					gint _cprefix_size;
					gint _cprefix_index;
					_tmp15_ = vala_namespace_get_cprefixes (VALA_NAMESPACE (container));
					_cprefix_list = _tmp15_;
					_tmp16_ = vala_collection_get_size ((ValaCollection*) _cprefix_list);
					_cprefix_size = _tmp16_;
					_cprefix_index = -1;
					while (TRUE) {
						gpointer _tmp17_ = NULL;
						gchar* cprefix;
						gboolean _tmp18_;
						_cprefix_index = _cprefix_index + 1;
						if (!(_cprefix_index < _cprefix_size)) {
							break;
						}
						_tmp17_ = vala_list_get (_cprefix_list, _cprefix_index);
						cprefix = (gchar*) _tmp17_;
						_tmp18_ = g_str_has_prefix (type_name, cprefix);
						if (_tmp18_) {
							gboolean _tmp19_ = FALSE;
							if (best_match == NULL) {
								_tmp19_ = TRUE;
							} else {
								gint _tmp20_;
								gint _tmp21_;
								_tmp20_ = strlen (cprefix);
								_tmp21_ = strlen (best_match);
								_tmp19_ = _tmp20_ > _tmp21_;
							}
							if (_tmp19_) {
								gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp22_ = g_strdup (cprefix);
								_tmp23_ = _tmp22_;
								_g_free0 (best_match);
								best_match = _tmp23_;
							}
						}
						_g_free0 (cprefix);
					}
					_vala_iterable_unref0 (_cprefix_list);
				}
			} else {
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				_tmp24_ = vala_symbol_get_cprefix (container);
				_tmp25_ = _tmp24_;
				_g_free0 (best_match);
				best_match = _tmp25_;
			}
			if (best_match != NULL) {
				gint _tmp26_;
				gchar* _tmp27_ = NULL;
				_tmp26_ = strlen (best_match);
				_tmp27_ = string_substring (type_name, (glong) _tmp26_, (glong) (-1));
				result = _tmp27_;
				_g_free0 (best_match);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
			_g_free0 (best_match);
		}
	}
	_tmp28_ = g_strdup (type_name);
	result = _tmp28_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const gchar* const_name, ValaSymbol* container) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* pref;
	gboolean _tmp4_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp0_ = vala_symbol_get_lower_case_cprefix (container);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strup (_tmp1_, (gssize) (-1));
	pref = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	_tmp4_ = g_str_has_prefix (const_name, pref);
	if (_tmp4_) {
		gint _tmp5_;
		gchar* _tmp6_ = NULL;
		_tmp5_ = strlen (pref);
		_tmp6_ = string_substring (const_name, (glong) _tmp5_, (glong) (-1));
		result = _tmp6_;
		_g_free0 (pref);
		return result;
	}
	_tmp7_ = g_strdup (const_name);
	result = _tmp7_;
	_g_free0 (pref);
	return result;
}


static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self, GIdlNode* node, int* result_length1) {
	gchar** result = NULL;
	gchar* name = NULL;
	gint _tmp16_;
	gchar** _tmp17_ = NULL;
	gchar** _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (node->type == G_IDL_NODE_FUNCTION) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup (((GIdlNodeFunction*) node)->symbol);
		_tmp1_ = _tmp0_;
		_g_free0 (name);
		name = _tmp1_;
	} else {
		if (node->type == G_IDL_NODE_SIGNAL) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp2_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_strdup_printf ("%s::%s", _tmp3_, node->name);
			_tmp5_ = _tmp4_;
			_g_free0 (name);
			name = _tmp5_;
			_g_free0 (_tmp3_);
		} else {
			if (node->type == G_IDL_NODE_PROPERTY) {
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				_tmp6_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strdup_printf ("%s:%s", _tmp7_, node->name);
				_tmp9_ = _tmp8_;
				_g_free0 (name);
				name = _tmp9_;
				_g_free0 (_tmp7_);
			} else {
				if (node->type == G_IDL_NODE_FIELD) {
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp10_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strdup_printf ("%s.%s", _tmp11_, node->name);
					_tmp13_ = _tmp12_;
					_g_free0 (name);
					name = _tmp13_;
					_g_free0 (_tmp11_);
				} else {
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = g_strdup (node->name);
					_tmp15_ = _tmp14_;
					_g_free0 (name);
					name = _tmp15_;
				}
			}
		}
	}
	_tmp17_ = vala_gidl_parser_get_attributes (self, name, &_tmp16_);
	_tmp18_ = _tmp17_;
	*result_length1 = _tmp16_;
	result = _tmp18_;
	_g_free0 (name);
	return result;
}


static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self, ValaSymbol* container, ValaSymbol* sym) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	if (VALA_IS_CLASS (container)) {
		ValaClass* cl;
		cl = VALA_CLASS (container);
		if (VALA_IS_CLASS (sym)) {
			vala_symbol_add_class ((ValaSymbol*) cl, VALA_CLASS (sym));
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				vala_symbol_add_constant ((ValaSymbol*) cl, VALA_CONSTANT (sym));
			} else {
				if (VALA_IS_ENUM (sym)) {
					vala_symbol_add_enum ((ValaSymbol*) cl, VALA_ENUM (sym));
				} else {
					if (VALA_IS_FIELD (sym)) {
						vala_symbol_add_field ((ValaSymbol*) cl, VALA_FIELD (sym));
					} else {
						if (VALA_IS_METHOD (sym)) {
							vala_symbol_add_method ((ValaSymbol*) cl, VALA_METHOD (sym));
						} else {
							if (VALA_IS_PROPERTY (sym)) {
								vala_symbol_add_property ((ValaSymbol*) cl, VALA_PROPERTY (sym));
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									vala_symbol_add_signal ((ValaSymbol*) cl, VALA_SIGNAL (sym));
								} else {
									if (VALA_IS_STRUCT (sym)) {
										vala_symbol_add_struct ((ValaSymbol*) cl, VALA_STRUCT (sym));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (VALA_IS_ENUM (container)) {
			ValaEnum* en;
			en = VALA_ENUM (container);
			if (VALA_IS_ENUM_VALUE (sym)) {
				vala_enum_add_value (en, VALA_ENUM_VALUE (sym));
			} else {
				if (VALA_IS_CONSTANT (sym)) {
					vala_symbol_add_constant ((ValaSymbol*) en, VALA_CONSTANT (sym));
				} else {
					if (VALA_IS_METHOD (sym)) {
						vala_symbol_add_method ((ValaSymbol*) en, VALA_METHOD (sym));
					}
				}
			}
		} else {
			if (VALA_IS_INTERFACE (container)) {
				ValaInterface* iface;
				iface = VALA_INTERFACE (container);
				if (VALA_IS_CLASS (sym)) {
					vala_symbol_add_class ((ValaSymbol*) iface, VALA_CLASS (sym));
				} else {
					if (VALA_IS_CONSTANT (sym)) {
						vala_symbol_add_constant ((ValaSymbol*) iface, VALA_CONSTANT (sym));
					} else {
						if (VALA_IS_ENUM (sym)) {
							vala_symbol_add_enum ((ValaSymbol*) iface, VALA_ENUM (sym));
						} else {
							if (VALA_IS_FIELD (sym)) {
								vala_symbol_add_field ((ValaSymbol*) iface, VALA_FIELD (sym));
							} else {
								if (VALA_IS_METHOD (sym)) {
									vala_symbol_add_method ((ValaSymbol*) iface, VALA_METHOD (sym));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										vala_symbol_add_property ((ValaSymbol*) iface, VALA_PROPERTY (sym));
									} else {
										if (VALA_IS_SIGNAL (sym)) {
											vala_symbol_add_signal ((ValaSymbol*) iface, VALA_SIGNAL (sym));
										} else {
											if (VALA_IS_STRUCT (sym)) {
												vala_symbol_add_struct ((ValaSymbol*) iface, VALA_STRUCT (sym));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (VALA_IS_NAMESPACE (container)) {
					ValaNamespace* ns;
					ns = VALA_NAMESPACE (container);
					if (VALA_IS_NAMESPACE (sym)) {
						vala_symbol_add_namespace ((ValaSymbol*) ns, VALA_NAMESPACE (sym));
					} else {
						if (VALA_IS_CLASS (sym)) {
							vala_symbol_add_class ((ValaSymbol*) ns, VALA_CLASS (sym));
						} else {
							if (VALA_IS_CONSTANT (sym)) {
								vala_symbol_add_constant ((ValaSymbol*) ns, VALA_CONSTANT (sym));
							} else {
								if (VALA_IS_DELEGATE (sym)) {
									vala_symbol_add_delegate ((ValaSymbol*) ns, VALA_DELEGATE (sym));
								} else {
									if (VALA_IS_ENUM (sym)) {
										vala_symbol_add_enum ((ValaSymbol*) ns, VALA_ENUM (sym));
									} else {
										if (VALA_IS_ERROR_DOMAIN (sym)) {
											vala_symbol_add_error_domain ((ValaSymbol*) ns, VALA_ERROR_DOMAIN (sym));
										} else {
											if (VALA_IS_FIELD (sym)) {
												vala_symbol_add_field ((ValaSymbol*) ns, VALA_FIELD (sym));
											} else {
												if (VALA_IS_INTERFACE (sym)) {
													vala_symbol_add_interface ((ValaSymbol*) ns, VALA_INTERFACE (sym));
												} else {
													if (VALA_IS_METHOD (sym)) {
														vala_symbol_add_method ((ValaSymbol*) ns, VALA_METHOD (sym));
													} else {
														if (VALA_IS_NAMESPACE (sym)) {
															vala_symbol_add_namespace ((ValaSymbol*) ns, VALA_NAMESPACE (sym));
														} else {
															if (VALA_IS_STRUCT (sym)) {
																vala_symbol_add_struct ((ValaSymbol*) ns, VALA_STRUCT (sym));
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (VALA_IS_STRUCT (container)) {
						ValaStruct* st;
						st = VALA_STRUCT (container);
						if (VALA_IS_CONSTANT (sym)) {
							vala_symbol_add_constant ((ValaSymbol*) st, VALA_CONSTANT (sym));
						} else {
							if (VALA_IS_FIELD (sym)) {
								vala_symbol_add_field ((ValaSymbol*) st, VALA_FIELD (sym));
							} else {
								if (VALA_IS_METHOD (sym)) {
									vala_symbol_add_method ((ValaSymbol*) st, VALA_METHOD (sym));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										vala_symbol_add_property ((ValaSymbol*) st, VALA_PROPERTY (sym));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_gidl_parser_parse_node (ValaGIdlParser* self, GIdlNode* node, GIdlModule* module, ValaSymbol* container) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (module != NULL);
	g_return_if_fail (container != NULL);
	if (node->type == G_IDL_NODE_CALLBACK) {
		ValaDelegate* _tmp0_ = NULL;
		ValaDelegate* cb;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp0_ = vala_gidl_parser_parse_delegate (self, (GIdlNodeFunction*) node);
		cb = _tmp0_;
		if (cb == NULL) {
			_vala_code_node_unref0 (cb);
			return;
		}
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) cb);
		_tmp2_ = vala_gidl_parser_fix_type_name (self, _tmp1_, container);
		_tmp3_ = _tmp2_;
		vala_symbol_set_name ((ValaSymbol*) cb, _tmp3_);
		_g_free0 (_tmp3_);
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cb);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cb);
		_vala_code_node_unref0 (cb);
	} else {
		if (node->type == G_IDL_NODE_STRUCT) {
			vala_gidl_parser_parse_struct (self, (GIdlNodeStruct*) node, container, module);
		} else {
			if (node->type == G_IDL_NODE_UNION) {
				vala_gidl_parser_parse_union (self, (GIdlNodeUnion*) node, container, module);
			} else {
				if (node->type == G_IDL_NODE_BOXED) {
					vala_gidl_parser_parse_boxed (self, (GIdlNodeBoxed*) node, container, module);
				} else {
					if (node->type == G_IDL_NODE_ENUM) {
						vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, container, module, FALSE);
					} else {
						if (node->type == G_IDL_NODE_FLAGS) {
							vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, container, module, TRUE);
						} else {
							if (node->type == G_IDL_NODE_OBJECT) {
								vala_gidl_parser_parse_object (self, (GIdlNodeInterface*) node, container, module);
							} else {
								if (node->type == G_IDL_NODE_INTERFACE) {
									vala_gidl_parser_parse_interface (self, (GIdlNodeInterface*) node, container, module);
								} else {
									if (node->type == G_IDL_NODE_CONSTANT) {
										ValaConstant* _tmp4_ = NULL;
										ValaConstant* c;
										_tmp4_ = vala_gidl_parser_parse_constant (self, (GIdlNodeConstant*) node);
										c = _tmp4_;
										if (c != NULL) {
											const gchar* _tmp5_ = NULL;
											gchar* _tmp6_ = NULL;
											gchar* _tmp7_;
											_tmp5_ = vala_symbol_get_name ((ValaSymbol*) c);
											_tmp6_ = vala_gidl_parser_fix_const_name (self, _tmp5_, container);
											_tmp7_ = _tmp6_;
											vala_symbol_set_name ((ValaSymbol*) c, _tmp7_);
											_g_free0 (_tmp7_);
											vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) c);
											vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) c);
										}
										_vala_code_node_unref0 (c);
									} else {
										if (node->type == G_IDL_NODE_FUNCTION) {
											ValaMethod* _tmp8_ = NULL;
											ValaMethod* m;
											_tmp8_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) node, FALSE);
											m = _tmp8_;
											if (m != NULL) {
												vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
												vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) m);
												vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) m);
											}
											_vala_code_node_unref0 (m);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self, const gchar* name) {
	ValaSymbol* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** path;
	gint path_length1;
	gint _path_size_;
	ValaSymbol* _tmp2_;
	ValaSymbol* cp;
	ValaSymbol* cc;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (name, ".", 0);
	path = _tmp1_;
	path_length1 = _vala_array_length (_tmp0_);
	_path_size_ = _vala_array_length (_tmp0_);
	_tmp2_ = _vala_code_node_ref0 ((ValaSymbol*) self->priv->current_namespace);
	cp = _tmp2_;
	cc = NULL;
	{
		gchar** tok_collection;
		int tok_collection_length1;
		int tok_it;
		tok_collection = path;
		tok_collection_length1 = path_length1;
		for (tok_it = 0; tok_it < path_length1; tok_it = tok_it + 1) {
			const gchar* tok;
			tok = tok_collection[tok_it];
			{
				ValaScope* _tmp3_ = NULL;
				ValaSymbol* _tmp4_ = NULL;
				ValaSymbol* _tmp5_;
				ValaSymbol* _tmp6_;
				ValaSymbol* _tmp12_;
				ValaSymbol* _tmp13_;
				_tmp3_ = vala_symbol_get_scope (cp);
				_tmp4_ = vala_scope_lookup (_tmp3_, tok);
				_tmp6_ = (_tmp5_ = _tmp4_, VALA_IS_SYMBOL (_tmp5_) ? ((ValaSymbol*) _tmp5_) : NULL);
				_vala_code_node_unref0 (cc);
				cc = _tmp6_;
				if (cc == NULL) {
					ValaNamespace* _tmp7_ = NULL;
					ValaSymbol* _tmp8_;
					gchar* _tmp9_ = NULL;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp7_ = vala_namespace_new (tok, self->priv->current_source_reference);
					_tmp8_ = (ValaSymbol*) _tmp7_;
					_vala_code_node_unref0 (cc);
					cc = _tmp8_;
					_tmp9_ = vala_symbol_get_cprefix (cp);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_strconcat (_tmp10_, tok, NULL);
					vala_namespace_add_cprefix (VALA_NAMESPACE (cc), _tmp11_);
					_g_free0 (_tmp11_);
					_g_free0 (_tmp10_);
					vala_gidl_parser_add_symbol_to_container (self, cp, cc);
				}
				_tmp12_ = _vala_code_node_ref0 (cc);
				_tmp13_ = _tmp12_;
				_vala_code_node_unref0 (cp);
				cp = _tmp13_;
			}
		}
	}
	result = cc;
	_vala_code_node_unref0 (cp);
	path = (_vala_array_free (path, path_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module) {
	ValaNamespace* result = NULL;
	ValaNamespace* _tmp0_ = NULL;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* sym;
	ValaNamespace* ns = NULL;
	ValaNamespace* _tmp9_;
	ValaNamespace* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_;
	gchar** _tmp13_ = NULL;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	ValaArrayList* _tmp35_ = NULL;
	ValaArrayList* deferred;
	ValaNamespace* _tmp52_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (module != NULL, NULL);
	_tmp0_ = vala_code_context_get_root (self->priv->context);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = vala_scope_lookup (_tmp1_, module->name);
	sym = _tmp2_;
	if (VALA_IS_NAMESPACE (sym)) {
		ValaNamespace* _tmp3_;
		ValaNamespace* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = _vala_code_node_ref0 (VALA_NAMESPACE (sym));
		_tmp4_ = _tmp3_;
		_vala_code_node_unref0 (ns);
		ns = _tmp4_;
		_tmp5_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
		if (_tmp5_) {
			GList* _tmp6_;
			_tmp6_ = NULL;
			__g_list_free__vala_code_node_unref0_0 (((ValaCodeNode*) ns)->attributes);
			((ValaCodeNode*) ns)->attributes = _tmp6_;
			vala_code_node_set_source_reference ((ValaCodeNode*) ns, self->priv->current_source_reference);
		}
	} else {
		ValaNamespace* _tmp7_ = NULL;
		ValaNamespace* _tmp8_;
		_tmp7_ = vala_namespace_new (module->name, self->priv->current_source_reference);
		_tmp8_ = _tmp7_;
		_vala_code_node_unref0 (ns);
		ns = _tmp8_;
	}
	_tmp9_ = _vala_code_node_ref0 (ns);
	_tmp10_ = _tmp9_;
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = _tmp10_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp13_ = vala_gidl_parser_get_attributes (self, _tmp11_, &_tmp12_);
	attributes = _tmp13_;
	attributes_length1 = _tmp12_;
	_attributes_size_ = _tmp12_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp14_;
				gchar* attr;
				_tmp14_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp14_;
				{
					gchar** _tmp15_;
					gchar** _tmp16_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp16_ = _tmp15_ = g_strsplit (attr, "=", 2);
					nv = _tmp16_;
					nv_length1 = _vala_array_length (_tmp15_);
					_nv_size_ = _vala_array_length (_tmp15_);
					if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
						gchar* _tmp17_ = NULL;
						gchar* _tmp18_;
						_tmp17_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp18_ = _tmp17_;
						vala_symbol_set_cheader_filename ((ValaSymbol*) ns, _tmp18_);
						_g_free0 (_tmp18_);
					} else {
						if (g_strcmp0 (nv[0], "cprefix") == 0) {
							gchar* _tmp19_ = NULL;
							gchar* _tmp20_;
							gchar** _tmp21_;
							gchar** _tmp22_ = NULL;
							gchar** _tmp23_;
							gchar** cprefixes;
							gint cprefixes_length1;
							gint _cprefixes_size_;
							_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp20_ = _tmp19_;
							_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, ",", 0);
							cprefixes = (_tmp23_ = _tmp22_, _g_free0 (_tmp20_), _tmp23_);
							cprefixes_length1 = _vala_array_length (_tmp21_);
							_cprefixes_size_ = _vala_array_length (_tmp21_);
							{
								gchar** name_collection;
								int name_collection_length1;
								int name_it;
								name_collection = cprefixes;
								name_collection_length1 = cprefixes_length1;
								for (name_it = 0; name_it < cprefixes_length1; name_it = name_it + 1) {
									gchar* _tmp24_;
									gchar* name;
									_tmp24_ = g_strdup (name_collection[name_it]);
									name = _tmp24_;
									{
										vala_namespace_add_cprefix (ns, name);
										_g_free0 (name);
									}
								}
							}
							cprefixes = (_vala_array_free (cprefixes, cprefixes_length1, (GDestroyNotify) g_free), NULL);
						} else {
							if (g_strcmp0 (nv[0], "lower_case_cprefix") == 0) {
								gchar* _tmp25_ = NULL;
								gchar* _tmp26_;
								_tmp25_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp26_ = _tmp25_;
								vala_namespace_set_lower_case_cprefix (ns, _tmp26_);
								_g_free0 (_tmp26_);
							} else {
								if (g_strcmp0 (nv[0], "gir_namespace") == 0) {
									ValaSourceReference* _tmp27_ = NULL;
									ValaSourceFile* _tmp28_ = NULL;
									gchar* _tmp29_ = NULL;
									gchar* _tmp30_;
									_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
									_tmp28_ = vala_source_reference_get_file (_tmp27_);
									_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp30_ = _tmp29_;
									vala_source_file_set_gir_namespace (_tmp28_, _tmp30_);
									_g_free0 (_tmp30_);
								} else {
									if (g_strcmp0 (nv[0], "gir_version") == 0) {
										ValaSourceReference* _tmp31_ = NULL;
										ValaSourceFile* _tmp32_ = NULL;
										gchar* _tmp33_ = NULL;
										gchar* _tmp34_;
										_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
										_tmp32_ = vala_source_reference_get_file (_tmp31_);
										_tmp33_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp34_ = _tmp33_;
										vala_source_file_set_gir_version (_tmp32_, _tmp34_);
										_g_free0 (_tmp34_);
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp35_ = vala_array_list_new (G_TYPE_POINTER, NULL, NULL, g_direct_equal);
	deferred = _tmp35_;
	{
		GList* node_collection;
		GList* node_it;
		node_collection = module->entries;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node;
			node = (GIdlNode*) node_it->data;
			{
				gboolean is_deferred;
				gint _tmp36_;
				gchar** _tmp37_ = NULL;
				gchar** child_attributes;
				gint child_attributes_length1;
				gint _child_attributes_size_;
				is_deferred = FALSE;
				_tmp37_ = vala_gidl_parser_get_attributes_for_node (self, node, &_tmp36_);
				child_attributes = _tmp37_;
				child_attributes_length1 = _tmp36_;
				_child_attributes_size_ = _tmp36_;
				if (child_attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = child_attributes;
						attr_collection_length1 = child_attributes_length1;
						for (attr_it = 0; attr_it < child_attributes_length1; attr_it = attr_it + 1) {
							const gchar* attr;
							attr = attr_collection[attr_it];
							{
								gchar** _tmp38_;
								gchar** _tmp39_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								_tmp39_ = _tmp38_ = g_strsplit (attr, "=", 2);
								nv = _tmp39_;
								nv_length1 = _vala_array_length (_tmp38_);
								_nv_size_ = _vala_array_length (_tmp38_);
								if (g_strcmp0 (nv[0], "parent") == 0) {
									vala_collection_add ((ValaCollection*) deferred, node);
									is_deferred = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							}
						}
					}
				}
				if (!is_deferred) {
					vala_gidl_parser_parse_node (self, node, module, (ValaSymbol*) ns);
				}
				child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	{
		ValaArrayList* _tmp40_;
		ValaArrayList* _node_list;
		gint _tmp41_;
		gint _node_size;
		gint _node_index;
		_tmp40_ = _vala_iterable_ref0 (deferred);
		_node_list = _tmp40_;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _node_list);
		_node_size = _tmp41_;
		_node_index = -1;
		while (TRUE) {
			gpointer _tmp42_ = NULL;
			GIdlNode* node;
			ValaSymbol* _tmp43_;
			ValaSymbol* container;
			gint _tmp44_;
			gchar** _tmp45_ = NULL;
			gchar** child_attributes;
			gint child_attributes_length1;
			gint _child_attributes_size_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp42_ = vala_list_get ((ValaList*) _node_list, _node_index);
			node = (GIdlNode*) _tmp42_;
			_tmp43_ = _vala_code_node_ref0 ((ValaSymbol*) ns);
			container = _tmp43_;
			_tmp45_ = vala_gidl_parser_get_attributes_for_node (self, node, &_tmp44_);
			child_attributes = _tmp45_;
			child_attributes_length1 = _tmp44_;
			_child_attributes_size_ = _tmp44_;
			if (child_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = child_attributes;
					attr_collection_length1 = child_attributes_length1;
					for (attr_it = 0; attr_it < child_attributes_length1; attr_it = attr_it + 1) {
						const gchar* attr;
						attr = attr_collection[attr_it];
						{
							gchar** _tmp46_;
							gchar** _tmp47_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							_tmp47_ = _tmp46_ = g_strsplit (attr, "=", 2);
							nv = _tmp47_;
							nv_length1 = _vala_array_length (_tmp46_);
							_nv_size_ = _vala_array_length (_tmp46_);
							if (g_strcmp0 (nv[0], "parent") == 0) {
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_;
								ValaSymbol* _tmp50_ = NULL;
								ValaSymbol* _tmp51_;
								_tmp48_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp49_ = _tmp48_;
								_tmp50_ = vala_gidl_parser_get_container_from_name (self, _tmp49_);
								_tmp51_ = _tmp50_;
								_vala_code_node_unref0 (container);
								container = _tmp51_;
								_g_free0 (_tmp49_);
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			vala_gidl_parser_parse_node (self, node, module, container);
			child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (container);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_tmp52_ = NULL;
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = _tmp52_;
	if (VALA_IS_NAMESPACE (sym)) {
		result = NULL;
		_vala_iterable_unref0 (deferred);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (ns);
		_vala_code_node_unref0 (sym);
		return result;
	}
	result = ns;
	_vala_iterable_unref0 (deferred);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (sym);
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = g_ascii_strtod (str, NULL);
	result = _tmp0_;
	return result;
}


static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node) {
	ValaDelegate* result = NULL;
	GIdlNode* node;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* return_type;
	ValaDelegate* _tmp1_ = NULL;
	ValaDelegate* cb;
	gboolean check_has_target;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	guint _tmp41_;
	guint remaining_params;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f_node != NULL, NULL);
	node = (GIdlNode*) f_node;
	_tmp0_ = vala_gidl_parser_parse_param (self, f_node->result, NULL);
	return_type = _tmp0_;
	_tmp1_ = vala_delegate_new (node->name, return_type, self->priv->current_source_reference, NULL);
	cb = _tmp1_;
	vala_symbol_set_access ((ValaSymbol*) cb, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	check_has_target = TRUE;
	_tmp3_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp2_);
	attributes = _tmp3_;
	attributes_length1 = _tmp2_;
	_attributes_size_ = _tmp2_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp4_;
				gchar* attr;
				_tmp4_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp4_;
				{
					gchar** _tmp5_;
					gchar** _tmp6_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp6_ = _tmp5_ = g_strsplit (attr, "=", 2);
					nv = _tmp6_;
					nv_length1 = _vala_array_length (_tmp5_);
					_nv_size_ = _vala_array_length (_tmp5_);
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						gchar* _tmp7_ = NULL;
						gchar* _tmp8_;
						gboolean _tmp9_;
						_tmp7_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp8_ = _tmp7_;
						if ((_tmp9_ = g_strcmp0 (_tmp8_, "1") == 0, _g_free0 (_tmp8_), _tmp9_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (return_type);
							return result;
						}
					} else {
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp10_ = NULL;
							gchar* _tmp11_;
							_tmp10_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp11_ = _tmp10_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) cb, _tmp11_);
							_g_free0 (_tmp11_);
						} else {
							if (g_strcmp0 (nv[0], "has_target") == 0) {
								gchar* _tmp12_ = NULL;
								gchar* _tmp13_;
								gboolean _tmp14_;
								_tmp12_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp13_ = _tmp12_;
								if ((_tmp14_ = g_strcmp0 (_tmp13_, "0") == 0, _g_free0 (_tmp13_), _tmp14_)) {
									check_has_target = FALSE;
								} else {
									gchar* _tmp15_ = NULL;
									gchar* _tmp16_;
									gboolean _tmp17_;
									_tmp15_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp16_ = _tmp15_;
									if ((_tmp17_ = g_strcmp0 (_tmp16_, "1") == 0, _g_free0 (_tmp16_), _tmp17_)) {
										vala_delegate_set_has_target (cb, TRUE);
									}
								}
							} else {
								if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
									gchar* _tmp18_ = NULL;
									gchar* _tmp19_;
									gboolean _tmp20_;
									_tmp18_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp19_ = _tmp18_;
									if ((_tmp20_ = g_strcmp0 (_tmp19_, "1") == 0, _g_free0 (_tmp19_), _tmp20_)) {
										vala_data_type_set_value_owned (return_type, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "deprecated") == 0) {
										gchar* _tmp21_ = NULL;
										gchar* _tmp22_;
										gboolean _tmp23_;
										_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp22_ = _tmp21_;
										if ((_tmp23_ = g_strcmp0 (_tmp22_, "1") == 0, _g_free0 (_tmp22_), _tmp23_)) {
											vala_symbol_set_deprecated ((ValaSymbol*) cb, TRUE);
										}
									} else {
										if (g_strcmp0 (nv[0], "replacement") == 0) {
											gchar* _tmp24_ = NULL;
											gchar* _tmp25_;
											_tmp24_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp25_ = _tmp24_;
											vala_symbol_set_replacement ((ValaSymbol*) cb, _tmp25_);
											_g_free0 (_tmp25_);
										} else {
											if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
												gchar* _tmp26_ = NULL;
												gchar* _tmp27_;
												_tmp26_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp27_ = _tmp26_;
												vala_symbol_set_deprecated_since ((ValaSymbol*) cb, _tmp27_);
												_g_free0 (_tmp27_);
											} else {
												if (g_strcmp0 (nv[0], "type_arguments") == 0) {
													gchar* _tmp28_ = NULL;
													gchar* _tmp29_;
													_tmp28_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp29_ = _tmp28_;
													vala_gidl_parser_parse_type_arguments_from_string (self, return_type, _tmp29_, NULL);
													_g_free0 (_tmp29_);
												} else {
													if (g_strcmp0 (nv[0], "instance_pos") == 0) {
														gchar* _tmp30_ = NULL;
														gchar* _tmp31_;
														gdouble _tmp32_;
														_tmp30_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp31_ = _tmp30_;
														_tmp32_ = double_parse (_tmp31_);
														vala_delegate_set_cinstance_parameter_position (cb, _tmp32_);
														_g_free0 (_tmp31_);
													} else {
														if (g_strcmp0 (nv[0], "type_parameters") == 0) {
															gchar* _tmp33_ = NULL;
															gchar* _tmp34_;
															gchar** _tmp35_;
															gchar** _tmp36_ = NULL;
															gchar** _tmp37_;
															_tmp33_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp34_ = _tmp33_;
															_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, ",", 0);
															{
																gchar** type_param_name_collection;
																int type_param_name_collection_length1;
																int type_param_name_it;
																type_param_name_collection = (_tmp37_ = _tmp36_, _g_free0 (_tmp34_), _tmp37_);
																type_param_name_collection_length1 = _vala_array_length (_tmp35_);
																for (type_param_name_it = 0; type_param_name_it < _vala_array_length (_tmp35_); type_param_name_it = type_param_name_it + 1) {
																	gchar* _tmp38_;
																	gchar* type_param_name;
																	_tmp38_ = g_strdup (type_param_name_collection[type_param_name_it]);
																	type_param_name = _tmp38_;
																	{
																		ValaTypeParameter* _tmp39_ = NULL;
																		ValaTypeParameter* _tmp40_;
																		_tmp39_ = vala_typeparameter_new (type_param_name, self->priv->current_source_reference);
																		_tmp40_ = _tmp39_;
																		vala_delegate_add_type_parameter (cb, _tmp40_);
																		_vala_code_node_unref0 (_tmp40_);
																		_g_free0 (type_param_name);
																	}
																}
																type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp41_ = g_list_length (f_node->parameters);
	remaining_params = _tmp41_;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = f_node->parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_ = FALSE;
				param_node = (GIdlNode*) param;
				if (check_has_target) {
					_tmp43_ = remaining_params == 1;
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					gboolean _tmp44_ = FALSE;
					if (g_strcmp0 (param_node->name, "user_data") == 0) {
						_tmp44_ = TRUE;
					} else {
						_tmp44_ = g_strcmp0 (param_node->name, "data") == 0;
					}
					_tmp42_ = _tmp44_;
				} else {
					_tmp42_ = FALSE;
				}
				if (_tmp42_) {
					vala_delegate_set_has_target (cb, TRUE);
				} else {
					gchar* _tmp45_;
					gchar* param_name;
					ValaParameterDirection direction = 0;
					ValaParameterDirection _tmp50_;
					ValaDataType* _tmp51_ = NULL;
					ValaDataType* param_type;
					ValaParameter* _tmp52_ = NULL;
					ValaParameter* p;
					gboolean hide_param;
					gboolean show_param;
					gboolean array_requested;
					gboolean out_requested;
					gchar* _tmp53_ = NULL;
					gchar* _tmp54_;
					gint _tmp55_;
					gchar** _tmp56_ = NULL;
					gchar** _tmp57_;
					gboolean _tmp104_ = FALSE;
					_tmp45_ = g_strdup (param_node->name);
					param_name = _tmp45_;
					if (g_strcmp0 (param_name, "string") == 0) {
						gchar* _tmp46_;
						gchar* _tmp47_;
						_tmp46_ = g_strdup ("str");
						_tmp47_ = _tmp46_;
						_g_free0 (param_name);
						param_name = _tmp47_;
					} else {
						if (g_strcmp0 (param_name, "self") == 0) {
							gchar* _tmp48_;
							gchar* _tmp49_;
							_tmp48_ = g_strdup ("_self");
							_tmp49_ = _tmp48_;
							_g_free0 (param_name);
							param_name = _tmp49_;
						}
					}
					_tmp51_ = vala_gidl_parser_parse_param (self, param, &_tmp50_);
					direction = _tmp50_;
					param_type = _tmp51_;
					_tmp52_ = vala_parameter_new (param_name, param_type, NULL);
					p = _tmp52_;
					vala_parameter_set_direction (p, direction);
					hide_param = FALSE;
					show_param = FALSE;
					array_requested = FALSE;
					out_requested = FALSE;
					_tmp53_ = g_strdup_printf ("%s.%s", node->name, param_node->name);
					_tmp54_ = _tmp53_;
					_tmp56_ = vala_gidl_parser_get_attributes (self, _tmp54_, &_tmp55_);
					_tmp57_ = _tmp56_;
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					attributes_length1 = _tmp55_;
					_attributes_size_ = attributes_length1;
					attributes = _tmp57_;
					_g_free0 (_tmp54_);
					if (attributes != NULL) {
						{
							gchar** attr_collection;
							int attr_collection_length1;
							int attr_it;
							attr_collection = attributes;
							attr_collection_length1 = attributes_length1;
							for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
								gchar* _tmp58_;
								gchar* attr;
								_tmp58_ = g_strdup (attr_collection[attr_it]);
								attr = _tmp58_;
								{
									gchar** _tmp59_;
									gchar** _tmp60_ = NULL;
									gchar** nv;
									gint nv_length1;
									gint _nv_size_;
									_tmp60_ = _tmp59_ = g_strsplit (attr, "=", 2);
									nv = _tmp60_;
									nv_length1 = _vala_array_length (_tmp59_);
									_nv_size_ = _vala_array_length (_tmp59_);
									if (g_strcmp0 (nv[0], "hidden") == 0) {
										gchar* _tmp61_ = NULL;
										gchar* _tmp62_;
										gboolean _tmp63_;
										_tmp61_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp62_ = _tmp61_;
										if ((_tmp63_ = g_strcmp0 (_tmp62_, "1") == 0, _g_free0 (_tmp62_), _tmp63_)) {
											hide_param = TRUE;
										} else {
											gchar* _tmp64_ = NULL;
											gchar* _tmp65_;
											gboolean _tmp66_;
											_tmp64_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp65_ = _tmp64_;
											if ((_tmp66_ = g_strcmp0 (_tmp65_, "0") == 0, _g_free0 (_tmp65_), _tmp66_)) {
												show_param = TRUE;
											}
										}
									} else {
										if (g_strcmp0 (nv[0], "is_array") == 0) {
											gchar* _tmp67_ = NULL;
											gchar* _tmp68_;
											gboolean _tmp69_;
											_tmp67_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp68_ = _tmp67_;
											if ((_tmp69_ = g_strcmp0 (_tmp68_, "1") == 0, _g_free0 (_tmp68_), _tmp69_)) {
												ValaSourceReference* _tmp70_ = NULL;
												ValaArrayType* _tmp71_ = NULL;
												ValaDataType* _tmp72_;
												_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
												_tmp71_ = vala_array_type_new (param_type, 1, _tmp70_);
												_tmp72_ = (ValaDataType*) _tmp71_;
												_vala_code_node_unref0 (param_type);
												param_type = _tmp72_;
												vala_variable_set_variable_type ((ValaVariable*) p, param_type);
												if (!out_requested) {
													vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
												}
												array_requested = TRUE;
											}
										} else {
											if (g_strcmp0 (nv[0], "is_out") == 0) {
												gchar* _tmp73_ = NULL;
												gchar* _tmp74_;
												gboolean _tmp75_;
												_tmp73_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp74_ = _tmp73_;
												if ((_tmp75_ = g_strcmp0 (_tmp74_, "1") == 0, _g_free0 (_tmp74_), _tmp75_)) {
													gboolean _tmp76_ = FALSE;
													vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
													out_requested = TRUE;
													if (!array_requested) {
														_tmp76_ = VALA_IS_ARRAY_TYPE (param_type);
													} else {
														_tmp76_ = FALSE;
													}
													if (_tmp76_) {
														ValaArrayType* _tmp77_;
														ValaArrayType* array_type;
														ValaDataType* _tmp78_ = NULL;
														ValaDataType* _tmp79_;
														ValaDataType* _tmp80_;
														_tmp77_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
														array_type = _tmp77_;
														_tmp78_ = vala_array_type_get_element_type (array_type);
														_tmp79_ = _vala_code_node_ref0 (_tmp78_);
														_tmp80_ = _tmp79_;
														_vala_code_node_unref0 (param_type);
														param_type = _tmp80_;
														vala_variable_set_variable_type ((ValaVariable*) p, param_type);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												if (g_strcmp0 (nv[0], "is_ref") == 0) {
													gchar* _tmp81_ = NULL;
													gchar* _tmp82_;
													gboolean _tmp83_;
													_tmp81_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp82_ = _tmp81_;
													if ((_tmp83_ = g_strcmp0 (_tmp82_, "1") == 0, _g_free0 (_tmp82_), _tmp83_)) {
														gboolean _tmp84_ = FALSE;
														vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
														if (!array_requested) {
															_tmp84_ = VALA_IS_ARRAY_TYPE (param_type);
														} else {
															_tmp84_ = FALSE;
														}
														if (_tmp84_) {
															ValaArrayType* _tmp85_;
															ValaArrayType* array_type;
															ValaDataType* _tmp86_ = NULL;
															ValaDataType* _tmp87_;
															ValaDataType* _tmp88_;
															_tmp85_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
															array_type = _tmp85_;
															_tmp86_ = vala_array_type_get_element_type (array_type);
															_tmp87_ = _vala_code_node_ref0 (_tmp86_);
															_tmp88_ = _tmp87_;
															_vala_code_node_unref0 (param_type);
															param_type = _tmp88_;
															vala_variable_set_variable_type ((ValaVariable*) p, param_type);
															_vala_code_node_unref0 (array_type);
														}
													}
												} else {
													if (g_strcmp0 (nv[0], "takes_ownership") == 0) {
														gchar* _tmp89_ = NULL;
														gchar* _tmp90_;
														gboolean _tmp91_;
														_tmp89_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp90_ = _tmp89_;
														if ((_tmp91_ = g_strcmp0 (_tmp90_, "1") == 0, _g_free0 (_tmp90_), _tmp91_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "nullable") == 0) {
															gchar* _tmp92_ = NULL;
															gchar* _tmp93_;
															gboolean _tmp94_;
															_tmp92_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp93_ = _tmp92_;
															if ((_tmp94_ = g_strcmp0 (_tmp93_, "1") == 0, _g_free0 (_tmp93_), _tmp94_)) {
																vala_data_type_set_nullable (param_type, TRUE);
															}
														} else {
															if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																gchar* _tmp95_ = NULL;
																gchar* _tmp96_;
																_tmp95_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp96_ = _tmp95_;
																vala_gidl_parser_parse_type_arguments_from_string (self, param_type, _tmp96_, NULL);
																_g_free0 (_tmp96_);
															} else {
																if (g_strcmp0 (nv[0], "no_array_length") == 0) {
																	gchar* _tmp97_ = NULL;
																	gchar* _tmp98_;
																	gboolean _tmp99_;
																	_tmp97_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp98_ = _tmp97_;
																	if ((_tmp99_ = g_strcmp0 (_tmp98_, "1") == 0, _g_free0 (_tmp98_), _tmp99_)) {
																		vala_variable_set_no_array_length ((ValaVariable*) p, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "type_name") == 0) {
																		gchar* _tmp100_ = NULL;
																		gchar* _tmp101_;
																		ValaDataType* _tmp102_ = NULL;
																		ValaDataType* _tmp103_;
																		_tmp100_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp101_ = _tmp100_;
																		_tmp102_ = vala_gidl_parser_parse_type_from_string (self, _tmp101_, FALSE, NULL);
																		_tmp103_ = _tmp102_;
																		_vala_code_node_unref0 (param_type);
																		param_type = _tmp103_;
																		vala_variable_set_variable_type ((ValaVariable*) p, param_type);
																		_g_free0 (_tmp101_);
																	}
																}
															}
														}
													}
												}
											}
										}
									}
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
								}
							}
						}
					}
					if (show_param) {
						_tmp104_ = TRUE;
					} else {
						_tmp104_ = !hide_param;
					}
					if (_tmp104_) {
						vala_delegate_add_parameter (cb, p);
					}
					_vala_code_node_unref0 (p);
					_vala_code_node_unref0 (param_type);
					_g_free0 (param_name);
				}
				remaining_params--;
			}
		}
	}
	result = cb;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const gchar* cname) {
	gboolean result = FALSE;
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** st_attributes;
	gint st_attributes_length1;
	gint _st_attributes_size_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cname != NULL, FALSE);
	_tmp1_ = vala_gidl_parser_get_attributes (self, cname, &_tmp0_);
	st_attributes = _tmp1_;
	st_attributes_length1 = _tmp0_;
	_st_attributes_size_ = _tmp0_;
	if (st_attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = st_attributes;
			attr_collection_length1 = st_attributes_length1;
			for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp2_;
				gchar* attr;
				_tmp2_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp2_;
				{
					gchar** _tmp3_;
					gchar** _tmp4_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gboolean _tmp5_ = FALSE;
					_tmp4_ = _tmp3_ = g_strsplit (attr, "=", 2);
					nv = _tmp4_;
					nv_length1 = _vala_array_length (_tmp3_);
					_nv_size_ = _vala_array_length (_tmp3_);
					if (g_strcmp0 (nv[0], "is_value_type") == 0) {
						gchar* _tmp6_ = NULL;
						gchar* _tmp7_;
						_tmp6_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp7_ = _tmp6_;
						_tmp5_ = g_strcmp0 (_tmp7_, "1") == 0;
						_g_free0 (_tmp7_);
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						result = FALSE;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	result = TRUE;
	st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) st_node;
	if (st_node->deprecated) {
		return;
	}
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	_tmp1_ = vala_gidl_parser_is_reference_type (self, node->name);
	if (!_tmp1_) {
		ValaScope* _tmp2_ = NULL;
		ValaSymbol* _tmp3_ = NULL;
		ValaSymbol* _tmp4_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp48_;
		ValaTypeSymbol* _tmp49_;
		ValaTypeSymbol* _tmp52_;
		_tmp2_ = vala_symbol_get_scope (container);
		_tmp3_ = vala_scope_lookup (_tmp2_, name);
		st = (_tmp4_ = _tmp3_, VALA_IS_STRUCT (_tmp4_) ? ((ValaStruct*) _tmp4_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp5_ = NULL;
			ValaStruct* _tmp6_;
			gint _tmp7_;
			gchar** _tmp8_ = NULL;
			gchar** st_attributes;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			_tmp5_ = vala_struct_new (name, self->priv->current_source_reference, NULL);
			_tmp6_ = _tmp5_;
			_vala_code_node_unref0 (st);
			st = _tmp6_;
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp8_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp7_);
			st_attributes = _tmp8_;
			st_attributes_length1 = _tmp7_;
			_st_attributes_size_ = _tmp7_;
			if (st_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp9_;
						gchar* attr;
						_tmp9_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp9_;
						{
							gchar** _tmp10_;
							gchar** _tmp11_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							_tmp11_ = _tmp10_ = g_strsplit (attr, "=", 2);
							nv = _tmp11_;
							nv_length1 = _vala_array_length (_tmp10_);
							_nv_size_ = _vala_array_length (_tmp10_);
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp12_ = NULL;
								gchar* _tmp13_;
								_tmp12_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp13_ = _tmp12_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) st, _tmp13_);
								_g_free0 (_tmp13_);
							} else {
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp14_ = NULL;
									gchar* _tmp15_;
									gboolean _tmp16_;
									_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp15_ = _tmp14_;
									if ((_tmp16_ = g_strcmp0 (_tmp15_, "1") == 0, _g_free0 (_tmp15_), _tmp16_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (st);
										_g_free0 (name);
										return;
									}
								} else {
									if (g_strcmp0 (nv[0], "base_type") == 0) {
										gchar* _tmp17_ = NULL;
										gchar* _tmp18_;
										ValaDataType* _tmp19_ = NULL;
										ValaDataType* _tmp20_;
										_tmp17_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp18_ = _tmp17_;
										_tmp19_ = vala_gidl_parser_parse_type_string (self, _tmp18_);
										_tmp20_ = _tmp19_;
										vala_struct_set_base_type (st, _tmp20_);
										_vala_code_node_unref0 (_tmp20_);
										_g_free0 (_tmp18_);
									} else {
										if (g_strcmp0 (nv[0], "rank") == 0) {
											gchar* _tmp21_ = NULL;
											gchar* _tmp22_;
											gint _tmp23_;
											_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp22_ = _tmp21_;
											_tmp23_ = atoi (_tmp22_);
											vala_struct_set_rank (st, _tmp23_);
											_g_free0 (_tmp22_);
										} else {
											if (g_strcmp0 (nv[0], "simple_type") == 0) {
												gchar* _tmp24_ = NULL;
												gchar* _tmp25_;
												gboolean _tmp26_;
												_tmp24_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp25_ = _tmp24_;
												if ((_tmp26_ = g_strcmp0 (_tmp25_, "1") == 0, _g_free0 (_tmp25_), _tmp26_)) {
													vala_struct_set_simple_type (st, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "immutable") == 0) {
													gchar* _tmp27_ = NULL;
													gchar* _tmp28_;
													gboolean _tmp29_;
													_tmp27_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp28_ = _tmp27_;
													if ((_tmp29_ = g_strcmp0 (_tmp28_, "1") == 0, _g_free0 (_tmp28_), _tmp29_)) {
														vala_struct_set_is_immutable (st, TRUE);
													}
												} else {
													if (g_strcmp0 (nv[0], "has_type_id") == 0) {
														gchar* _tmp30_ = NULL;
														gchar* _tmp31_;
														gboolean _tmp32_;
														_tmp30_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp31_ = _tmp30_;
														if ((_tmp32_ = g_strcmp0 (_tmp31_, "0") == 0, _g_free0 (_tmp31_), _tmp32_)) {
															vala_struct_set_has_type_id (st, FALSE);
														}
													} else {
														if (g_strcmp0 (nv[0], "type_id") == 0) {
															gchar* _tmp33_ = NULL;
															gchar* _tmp34_;
															_tmp33_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp34_ = _tmp33_;
															vala_struct_set_type_id (st, _tmp34_);
															_g_free0 (_tmp34_);
														} else {
															if (g_strcmp0 (nv[0], "has_copy_function") == 0) {
																gchar* _tmp35_ = NULL;
																gchar* _tmp36_;
																gboolean _tmp37_;
																_tmp35_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp36_ = _tmp35_;
																if ((_tmp37_ = g_strcmp0 (_tmp36_, "0") == 0, _g_free0 (_tmp36_), _tmp37_)) {
																	vala_struct_set_has_copy_function (st, FALSE);
																}
															} else {
																if (g_strcmp0 (nv[0], "deprecated") == 0) {
																	gchar* _tmp38_ = NULL;
																	gchar* _tmp39_;
																	gboolean _tmp40_;
																	_tmp38_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp39_ = _tmp38_;
																	if ((_tmp40_ = g_strcmp0 (_tmp39_, "1") == 0, _g_free0 (_tmp39_), _tmp40_)) {
																		vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "replacement") == 0) {
																		gchar* _tmp41_ = NULL;
																		gchar* _tmp42_;
																		_tmp41_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp42_ = _tmp41_;
																		vala_symbol_set_replacement ((ValaSymbol*) st, _tmp42_);
																		_g_free0 (_tmp42_);
																	} else {
																		if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
																			gchar* _tmp43_ = NULL;
																			gchar* _tmp44_;
																			_tmp43_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp44_ = _tmp43_;
																			vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp44_);
																			_g_free0 (_tmp44_);
																		} else {
																			if (g_strcmp0 (nv[0], "has_destroy_function") == 0) {
																				gchar* _tmp45_ = NULL;
																				gchar* _tmp46_;
																				gboolean _tmp47_;
																				_tmp45_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp46_ = _tmp45_;
																				if ((_tmp47_ = g_strcmp0 (_tmp46_, "0") == 0, _g_free0 (_tmp46_), _tmp47_)) {
																					vala_struct_set_has_destroy_function (st, FALSE);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) st);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp48_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp49_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = st_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* _tmp50_ = NULL;
						ValaMethod* m;
						_tmp50_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp50_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp51_ = NULL;
							ValaField* f;
							_tmp51_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp51_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp52_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp52_;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaScope* _tmp53_ = NULL;
		ValaSymbol* _tmp54_ = NULL;
		ValaSymbol* _tmp55_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp109_;
		ValaTypeSymbol* _tmp110_;
		ValaTypeSymbol* _tmp128_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp53_ = vala_symbol_get_scope (container);
		_tmp54_ = vala_scope_lookup (_tmp53_, name);
		cl = (_tmp55_ = _tmp54_, VALA_IS_CLASS (_tmp55_) ? ((ValaClass*) _tmp55_) : NULL);
		if (cl == NULL) {
			gchar* base_class;
			ValaClass* _tmp56_ = NULL;
			ValaClass* _tmp57_;
			gint _tmp58_;
			gchar** _tmp59_ = NULL;
			gchar** cl_attributes;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			base_class = NULL;
			_tmp56_ = vala_class_new (name, self->priv->current_source_reference, NULL);
			_tmp57_ = _tmp56_;
			_vala_code_node_unref0 (cl);
			cl = _tmp57_;
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			_tmp59_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp58_);
			cl_attributes = _tmp59_;
			cl_attributes_length1 = _tmp58_;
			_cl_attributes_size_ = _tmp58_;
			if (cl_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp60_;
						gchar* attr;
						_tmp60_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp60_;
						{
							gchar** _tmp61_;
							gchar** _tmp62_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							_tmp62_ = _tmp61_ = g_strsplit (attr, "=", 2);
							nv = _tmp62_;
							nv_length1 = _vala_array_length (_tmp61_);
							_nv_size_ = _vala_array_length (_tmp61_);
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp63_ = NULL;
								gchar* _tmp64_;
								_tmp63_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp64_ = _tmp63_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp64_);
								_g_free0 (_tmp64_);
							} else {
								if (g_strcmp0 (nv[0], "base_class") == 0) {
									gchar* _tmp65_ = NULL;
									gchar* _tmp66_;
									_tmp65_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp66_ = _tmp65_;
									_g_free0 (base_class);
									base_class = _tmp66_;
								} else {
									if (g_strcmp0 (nv[0], "hidden") == 0) {
										gchar* _tmp67_ = NULL;
										gchar* _tmp68_;
										gboolean _tmp69_;
										_tmp67_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp68_ = _tmp67_;
										if ((_tmp69_ = g_strcmp0 (_tmp68_, "1") == 0, _g_free0 (_tmp68_), _tmp69_)) {
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (base_class);
											_vala_code_node_unref0 (cl);
											_g_free0 (free_function);
											_g_free0 (copy_function);
											_g_free0 (unref_function);
											_g_free0 (ref_function);
											_g_free0 (name);
											return;
										}
									} else {
										if (g_strcmp0 (nv[0], "is_immutable") == 0) {
											gchar* _tmp70_ = NULL;
											gchar* _tmp71_;
											gboolean _tmp72_;
											_tmp70_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp71_ = _tmp70_;
											if ((_tmp72_ = g_strcmp0 (_tmp71_, "1") == 0, _g_free0 (_tmp71_), _tmp72_)) {
												vala_class_set_is_immutable (cl, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "const_cname") == 0) {
												gchar* _tmp73_ = NULL;
												gchar* _tmp74_;
												_tmp73_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp74_ = _tmp73_;
												vala_class_set_const_cname (cl, _tmp74_);
												_g_free0 (_tmp74_);
											} else {
												if (g_strcmp0 (nv[0], "is_fundamental") == 0) {
													gchar* _tmp75_ = NULL;
													gchar* _tmp76_;
													gboolean _tmp77_;
													_tmp75_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp76_ = _tmp75_;
													if ((_tmp77_ = g_strcmp0 (_tmp76_, "1") == 0, _g_free0 (_tmp76_), _tmp77_)) {
														vala_class_set_is_compact (cl, FALSE);
													}
												} else {
													gboolean _tmp78_ = FALSE;
													if (g_strcmp0 (nv[0], "abstract") == 0) {
														_tmp78_ = base_class != NULL;
													} else {
														_tmp78_ = FALSE;
													}
													if (_tmp78_) {
														gchar* _tmp79_ = NULL;
														gchar* _tmp80_;
														gboolean _tmp81_;
														_tmp79_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp80_ = _tmp79_;
														if ((_tmp81_ = g_strcmp0 (_tmp80_, "1") == 0, _g_free0 (_tmp80_), _tmp81_)) {
															vala_class_set_is_abstract (cl, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "free_function") == 0) {
															gchar* _tmp82_ = NULL;
															gchar* _tmp83_;
															_tmp82_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp83_ = _tmp82_;
															_g_free0 (free_function);
															free_function = _tmp83_;
														} else {
															if (g_strcmp0 (nv[0], "ref_function") == 0) {
																gchar* _tmp84_ = NULL;
																gchar* _tmp85_;
																_tmp84_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp85_ = _tmp84_;
																_g_free0 (ref_function);
																ref_function = _tmp85_;
															} else {
																if (g_strcmp0 (nv[0], "unref_function") == 0) {
																	gchar* _tmp86_ = NULL;
																	gchar* _tmp87_;
																	_tmp86_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp87_ = _tmp86_;
																	_g_free0 (unref_function);
																	unref_function = _tmp87_;
																} else {
																	if (g_strcmp0 (nv[0], "copy_function") == 0) {
																		gchar* _tmp88_ = NULL;
																		gchar* _tmp89_;
																		_tmp88_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp89_ = _tmp88_;
																		_g_free0 (copy_function);
																		copy_function = _tmp89_;
																	} else {
																		if (g_strcmp0 (nv[0], "ref_function_void") == 0) {
																			gchar* _tmp90_ = NULL;
																			gchar* _tmp91_;
																			gboolean _tmp92_;
																			_tmp90_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp91_ = _tmp90_;
																			if ((_tmp92_ = g_strcmp0 (_tmp91_, "1") == 0, _g_free0 (_tmp91_), _tmp92_)) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			if (g_strcmp0 (nv[0], "deprecated") == 0) {
																				gchar* _tmp93_ = NULL;
																				gchar* _tmp94_;
																				gboolean _tmp95_;
																				_tmp93_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp94_ = _tmp93_;
																				if ((_tmp95_ = g_strcmp0 (_tmp94_, "1") == 0, _g_free0 (_tmp94_), _tmp95_)) {
																					vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
																				}
																			} else {
																				if (g_strcmp0 (nv[0], "replacement") == 0) {
																					gchar* _tmp96_ = NULL;
																					gchar* _tmp97_;
																					_tmp96_ = vala_gidl_parser_eval (self, nv[1]);
																					_tmp97_ = _tmp96_;
																					vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp97_);
																					_g_free0 (_tmp97_);
																				} else {
																					if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
																						gchar* _tmp98_ = NULL;
																						gchar* _tmp99_;
																						_tmp98_ = vala_gidl_parser_eval (self, nv[1]);
																						_tmp99_ = _tmp98_;
																						vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp99_);
																						_g_free0 (_tmp99_);
																					} else {
																						if (g_strcmp0 (nv[0], "type_parameters") == 0) {
																							gchar* _tmp100_ = NULL;
																							gchar* _tmp101_;
																							gchar** _tmp102_;
																							gchar** _tmp103_ = NULL;
																							gchar** _tmp104_;
																							_tmp100_ = vala_gidl_parser_eval (self, nv[1]);
																							_tmp101_ = _tmp100_;
																							_tmp103_ = _tmp102_ = g_strsplit (_tmp101_, ",", 0);
																							{
																								gchar** type_param_name_collection;
																								int type_param_name_collection_length1;
																								int type_param_name_it;
																								type_param_name_collection = (_tmp104_ = _tmp103_, _g_free0 (_tmp101_), _tmp104_);
																								type_param_name_collection_length1 = _vala_array_length (_tmp102_);
																								for (type_param_name_it = 0; type_param_name_it < _vala_array_length (_tmp102_); type_param_name_it = type_param_name_it + 1) {
																									gchar* _tmp105_;
																									gchar* type_param_name;
																									_tmp105_ = g_strdup (type_param_name_collection[type_param_name_it]);
																									type_param_name = _tmp105_;
																									{
																										ValaTypeParameter* _tmp106_ = NULL;
																										ValaTypeParameter* _tmp107_;
																										_tmp106_ = vala_typeparameter_new (type_param_name, self->priv->current_source_reference);
																										_tmp107_ = _tmp106_;
																										vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) cl, _tmp107_);
																										_vala_code_node_unref0 (_tmp107_);
																										_g_free0 (type_param_name);
																									}
																								}
																								type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			if (base_class != NULL) {
				ValaDataType* _tmp108_ = NULL;
				ValaDataType* parent;
				_tmp108_ = vala_gidl_parser_parse_type_string (self, base_class);
				parent = _tmp108_;
				vala_class_add_base_type (cl, parent);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp109_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
		_tmp110_ = _tmp109_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp110_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = st_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						gboolean _tmp111_ = FALSE;
						if (ref_function == NULL) {
							_tmp111_ = g_strcmp0 (member->name, "ref") == 0;
						} else {
							_tmp111_ = FALSE;
						}
						if (_tmp111_) {
							gchar* _tmp112_;
							gchar* _tmp113_;
							ValaDataType* _tmp114_ = NULL;
							ValaDataType* _tmp115_;
							_tmp112_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
							_tmp113_ = _tmp112_;
							_g_free0 (ref_function);
							ref_function = _tmp113_;
							_tmp114_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL);
							_tmp115_ = _tmp114_;
							ref_function_void = VALA_IS_VOID_TYPE (_tmp115_);
							_vala_code_node_unref0 (_tmp115_);
						} else {
							gboolean _tmp116_ = FALSE;
							if (unref_function == NULL) {
								_tmp116_ = g_strcmp0 (member->name, "unref") == 0;
							} else {
								_tmp116_ = FALSE;
							}
							if (_tmp116_) {
								gchar* _tmp117_;
								gchar* _tmp118_;
								_tmp117_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
								_tmp118_ = _tmp117_;
								_g_free0 (unref_function);
								unref_function = _tmp118_;
							} else {
								gboolean _tmp119_ = FALSE;
								if (free_function == NULL) {
									gboolean _tmp120_ = FALSE;
									if (g_strcmp0 (member->name, "free") == 0) {
										_tmp120_ = TRUE;
									} else {
										_tmp120_ = g_strcmp0 (member->name, "destroy") == 0;
									}
									_tmp119_ = _tmp120_;
								} else {
									_tmp119_ = FALSE;
								}
								if (_tmp119_) {
									gchar* _tmp121_;
									gchar* _tmp122_;
									_tmp121_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
									_tmp122_ = _tmp121_;
									_g_free0 (free_function);
									free_function = _tmp122_;
								} else {
									gboolean _tmp123_ = FALSE;
									ValaMethod* _tmp126_ = NULL;
									ValaMethod* m;
									if (copy_function == NULL) {
										_tmp123_ = g_strcmp0 (member->name, "copy") == 0;
									} else {
										_tmp123_ = FALSE;
									}
									if (_tmp123_) {
										gchar* _tmp124_;
										gchar* _tmp125_;
										_tmp124_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
										_tmp125_ = _tmp124_;
										_g_free0 (copy_function);
										copy_function = _tmp125_;
									}
									_tmp126_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									m = _tmp126_;
									if (m != NULL) {
										vala_symbol_add_method ((ValaSymbol*) cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp127_ = NULL;
							ValaField* f;
							_tmp127_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp127_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		_tmp128_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp128_;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (un_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) un_node;
	if (un_node->deprecated) {
		return;
	}
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	_tmp1_ = vala_gidl_parser_is_reference_type (self, node->name);
	if (!_tmp1_) {
		ValaScope* _tmp2_ = NULL;
		ValaSymbol* _tmp3_ = NULL;
		ValaSymbol* _tmp4_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		ValaTypeSymbol* _tmp28_;
		_tmp2_ = vala_symbol_get_scope (container);
		_tmp3_ = vala_scope_lookup (_tmp2_, name);
		st = (_tmp4_ = _tmp3_, VALA_IS_STRUCT (_tmp4_) ? ((ValaStruct*) _tmp4_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp5_ = NULL;
			ValaStruct* _tmp6_;
			gint _tmp7_;
			gchar** _tmp8_ = NULL;
			gchar** st_attributes;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			_tmp5_ = vala_struct_new (name, self->priv->current_source_reference, NULL);
			_tmp6_ = _tmp5_;
			_vala_code_node_unref0 (st);
			st = _tmp6_;
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp8_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp7_);
			st_attributes = _tmp8_;
			st_attributes_length1 = _tmp7_;
			_st_attributes_size_ = _tmp7_;
			if (st_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp9_;
						gchar* attr;
						_tmp9_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp9_;
						{
							gchar** _tmp10_;
							gchar** _tmp11_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							_tmp11_ = _tmp10_ = g_strsplit (attr, "=", 2);
							nv = _tmp11_;
							nv_length1 = _vala_array_length (_tmp10_);
							_nv_size_ = _vala_array_length (_tmp10_);
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp12_ = NULL;
								gchar* _tmp13_;
								_tmp12_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp13_ = _tmp12_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) st, _tmp13_);
								_g_free0 (_tmp13_);
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp14_ = NULL;
									gchar* _tmp15_;
									gboolean _tmp16_;
									_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp15_ = _tmp14_;
									if ((_tmp16_ = g_strcmp0 (_tmp15_, "1") == 0, _g_free0 (_tmp15_), _tmp16_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp17_ = NULL;
										gchar* _tmp18_;
										_tmp17_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp18_ = _tmp17_;
										vala_symbol_set_replacement ((ValaSymbol*) st, _tmp18_);
										_g_free0 (_tmp18_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp19_ = NULL;
											gchar* _tmp20_;
											_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp20_ = _tmp19_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp20_);
											_g_free0 (_tmp20_);
										} else {
											if (g_strcmp0 (nv[0], "hidden") == 0) {
												gchar* _tmp21_ = NULL;
												gchar* _tmp22_;
												gboolean _tmp23_;
												_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp22_ = _tmp21_;
												if ((_tmp23_ = g_strcmp0 (_tmp22_, "1") == 0, _g_free0 (_tmp22_), _tmp23_)) {
													nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (attr);
													st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
													_vala_code_node_unref0 (st);
													_g_free0 (name);
													return;
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) st);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp24_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st);
		_tmp25_ = _tmp24_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp25_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = un_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* _tmp26_ = NULL;
						ValaMethod* m;
						_tmp26_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp26_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp27_ = NULL;
							ValaField* f;
							_tmp27_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp27_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp28_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp28_;
		_vala_code_node_unref0 (st);
	} else {
		ValaScope* _tmp29_ = NULL;
		ValaSymbol* _tmp30_ = NULL;
		ValaSymbol* _tmp31_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp44_;
		ValaTypeSymbol* _tmp45_;
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaTypeSymbol* _tmp59_;
		_tmp29_ = vala_symbol_get_scope (container);
		_tmp30_ = vala_scope_lookup (_tmp29_, name);
		cl = (_tmp31_ = _tmp30_, VALA_IS_CLASS (_tmp31_) ? ((ValaClass*) _tmp31_) : NULL);
		if (cl == NULL) {
			ValaClass* _tmp32_ = NULL;
			ValaClass* _tmp33_;
			gint _tmp34_;
			gchar** _tmp35_ = NULL;
			gchar** cl_attributes;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			_tmp32_ = vala_class_new (name, self->priv->current_source_reference, NULL);
			_tmp33_ = _tmp32_;
			_vala_code_node_unref0 (cl);
			cl = _tmp33_;
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			_tmp35_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp34_);
			cl_attributes = _tmp35_;
			cl_attributes_length1 = _tmp34_;
			_cl_attributes_size_ = _tmp34_;
			if (cl_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp36_;
						gchar* attr;
						_tmp36_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp36_;
						{
							gchar** _tmp37_;
							gchar** _tmp38_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							_tmp38_ = _tmp37_ = g_strsplit (attr, "=", 2);
							nv = _tmp38_;
							nv_length1 = _vala_array_length (_tmp37_);
							_nv_size_ = _vala_array_length (_tmp37_);
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp39_ = NULL;
								gchar* _tmp40_;
								_tmp39_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp40_ = _tmp39_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp40_);
								_g_free0 (_tmp40_);
							} else {
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp41_ = NULL;
									gchar* _tmp42_;
									gboolean _tmp43_;
									_tmp41_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp42_ = _tmp41_;
									if ((_tmp43_ = g_strcmp0 (_tmp42_, "1") == 0, _g_free0 (_tmp42_), _tmp43_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (name);
										return;
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp44_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
		_tmp45_ = _tmp44_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp45_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = un_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						if (g_strcmp0 (member->name, "ref") == 0) {
							gchar* _tmp46_;
							gchar* _tmp47_;
							ValaDataType* _tmp48_ = NULL;
							ValaDataType* _tmp49_;
							_tmp46_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
							_tmp47_ = _tmp46_;
							_g_free0 (ref_function);
							ref_function = _tmp47_;
							_tmp48_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL);
							_tmp49_ = _tmp48_;
							ref_function_void = VALA_IS_VOID_TYPE (_tmp49_);
							_vala_code_node_unref0 (_tmp49_);
						} else {
							if (g_strcmp0 (member->name, "unref") == 0) {
								gchar* _tmp50_;
								gchar* _tmp51_;
								_tmp50_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
								_tmp51_ = _tmp50_;
								_g_free0 (unref_function);
								unref_function = _tmp51_;
							} else {
								gboolean _tmp52_ = FALSE;
								if (g_strcmp0 (member->name, "free") == 0) {
									_tmp52_ = TRUE;
								} else {
									_tmp52_ = g_strcmp0 (member->name, "destroy") == 0;
								}
								if (_tmp52_) {
									gchar* _tmp53_;
									gchar* _tmp54_;
									_tmp53_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
									_tmp54_ = _tmp53_;
									_g_free0 (free_function);
									free_function = _tmp54_;
								} else {
									ValaMethod* _tmp57_ = NULL;
									ValaMethod* m;
									if (g_strcmp0 (member->name, "copy") == 0) {
										gchar* _tmp55_;
										gchar* _tmp56_;
										_tmp55_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
										_tmp56_ = _tmp55_;
										_g_free0 (copy_function);
										copy_function = _tmp56_;
									}
									_tmp57_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									m = _tmp57_;
									if (m != NULL) {
										vala_symbol_add_method ((ValaSymbol*) cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp58_ = NULL;
							ValaField* f;
							_tmp58_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp58_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		_tmp59_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp59_;
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
		_vala_code_node_unref0 (cl);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gint _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** node_attributes;
	gint node_attributes_length1;
	gint _node_attributes_size_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (boxed_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) boxed_node;
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	_tmp2_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp1_);
	node_attributes = _tmp2_;
	node_attributes_length1 = _tmp1_;
	_node_attributes_size_ = _tmp1_;
	if (node_attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = node_attributes;
			attr_collection_length1 = node_attributes_length1;
			for (attr_it = 0; attr_it < node_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp3_;
				gchar* attr;
				_tmp3_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp3_;
				{
					gchar** _tmp4_;
					gchar** _tmp5_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2);
					nv = _tmp5_;
					nv_length1 = _vala_array_length (_tmp4_);
					_nv_size_ = _vala_array_length (_tmp4_);
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (name);
						return;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp6_ = vala_gidl_parser_is_reference_type (self, node->name);
	if (!_tmp6_) {
		ValaScope* _tmp7_ = NULL;
		ValaSymbol* _tmp8_ = NULL;
		ValaSymbol* _tmp9_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp37_;
		ValaTypeSymbol* _tmp38_;
		ValaTypeSymbol* _tmp41_;
		_tmp7_ = vala_symbol_get_scope (container);
		_tmp8_ = vala_scope_lookup (_tmp7_, name);
		st = (_tmp9_ = _tmp8_, VALA_IS_STRUCT (_tmp9_) ? ((ValaStruct*) _tmp9_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp10_ = NULL;
			ValaStruct* _tmp11_;
			gint _tmp12_;
			gchar** _tmp13_ = NULL;
			gchar** st_attributes;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			_tmp10_ = vala_struct_new (name, self->priv->current_source_reference, NULL);
			_tmp11_ = _tmp10_;
			_vala_code_node_unref0 (st);
			st = _tmp11_;
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp13_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp12_);
			st_attributes = _tmp13_;
			st_attributes_length1 = _tmp12_;
			_st_attributes_size_ = _tmp12_;
			if (st_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp14_;
						gchar* attr;
						_tmp14_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp14_;
						{
							gchar** _tmp15_;
							gchar** _tmp16_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							_tmp16_ = _tmp15_ = g_strsplit (attr, "=", 2);
							nv = _tmp16_;
							nv_length1 = _vala_array_length (_tmp15_);
							_nv_size_ = _vala_array_length (_tmp15_);
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp17_ = NULL;
								gchar* _tmp18_;
								_tmp17_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp18_ = _tmp17_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) st, _tmp18_);
								_g_free0 (_tmp18_);
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp19_ = NULL;
									gchar* _tmp20_;
									gboolean _tmp21_;
									_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp20_ = _tmp19_;
									if ((_tmp21_ = g_strcmp0 (_tmp20_, "1") == 0, _g_free0 (_tmp20_), _tmp21_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp22_ = NULL;
										gchar* _tmp23_;
										_tmp22_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp23_ = _tmp22_;
										vala_symbol_set_replacement ((ValaSymbol*) st, _tmp23_);
										_g_free0 (_tmp23_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp24_ = NULL;
											gchar* _tmp25_;
											_tmp24_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp25_ = _tmp24_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp25_);
											_g_free0 (_tmp25_);
										} else {
											if (g_strcmp0 (nv[0], "immutable") == 0) {
												gchar* _tmp26_ = NULL;
												gchar* _tmp27_;
												gboolean _tmp28_;
												_tmp26_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp27_ = _tmp26_;
												if ((_tmp28_ = g_strcmp0 (_tmp27_, "1") == 0, _g_free0 (_tmp27_), _tmp28_)) {
													vala_struct_set_is_immutable (st, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "has_copy_function") == 0) {
													gchar* _tmp29_ = NULL;
													gchar* _tmp30_;
													gboolean _tmp31_;
													_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp30_ = _tmp29_;
													if ((_tmp31_ = g_strcmp0 (_tmp30_, "0") == 0, _g_free0 (_tmp30_), _tmp31_)) {
														vala_struct_set_has_copy_function (st, FALSE);
													}
												} else {
													if (g_strcmp0 (nv[0], "has_destroy_function") == 0) {
														gchar* _tmp32_ = NULL;
														gchar* _tmp33_;
														gboolean _tmp34_;
														_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp33_ = _tmp32_;
														if ((_tmp34_ = g_strcmp0 (_tmp33_, "0") == 0, _g_free0 (_tmp33_), _tmp34_)) {
															vala_struct_set_has_destroy_function (st, FALSE);
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) st);
			_tmp35_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) st, "TYPE_");
			_tmp36_ = _tmp35_;
			vala_struct_set_type_id (st, _tmp36_);
			_g_free0 (_tmp36_);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp37_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st);
		_tmp38_ = _tmp37_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp38_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = boxed_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* _tmp39_ = NULL;
						ValaMethod* m;
						_tmp39_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp39_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp40_ = NULL;
							ValaField* f;
							_tmp40_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp40_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp41_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp41_;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaScope* _tmp42_ = NULL;
		ValaSymbol* _tmp43_ = NULL;
		ValaSymbol* _tmp44_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp82_;
		ValaTypeSymbol* _tmp83_;
		ValaTypeSymbol* _tmp97_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp42_ = vala_symbol_get_scope (container);
		_tmp43_ = vala_scope_lookup (_tmp42_, name);
		cl = (_tmp44_ = _tmp43_, VALA_IS_CLASS (_tmp44_) ? ((ValaClass*) _tmp44_) : NULL);
		if (cl == NULL) {
			gchar* base_class;
			ValaClass* _tmp45_ = NULL;
			ValaClass* _tmp46_;
			gint _tmp47_;
			gchar** _tmp48_ = NULL;
			gchar** cl_attributes;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_;
			base_class = NULL;
			_tmp45_ = vala_class_new (name, self->priv->current_source_reference, NULL);
			_tmp46_ = _tmp45_;
			_vala_code_node_unref0 (cl);
			cl = _tmp46_;
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			_tmp48_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp47_);
			cl_attributes = _tmp48_;
			cl_attributes_length1 = _tmp47_;
			_cl_attributes_size_ = _tmp47_;
			if (cl_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp49_;
						gchar* attr;
						_tmp49_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp49_;
						{
							gchar** _tmp50_;
							gchar** _tmp51_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							_tmp51_ = _tmp50_ = g_strsplit (attr, "=", 2);
							nv = _tmp51_;
							nv_length1 = _vala_array_length (_tmp50_);
							_nv_size_ = _vala_array_length (_tmp50_);
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp52_ = NULL;
								gchar* _tmp53_;
								_tmp52_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp53_ = _tmp52_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp53_);
								_g_free0 (_tmp53_);
							} else {
								if (g_strcmp0 (nv[0], "base_class") == 0) {
									gchar* _tmp54_ = NULL;
									gchar* _tmp55_;
									_tmp54_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp55_ = _tmp54_;
									_g_free0 (base_class);
									base_class = _tmp55_;
								} else {
									if (g_strcmp0 (nv[0], "is_immutable") == 0) {
										gchar* _tmp56_ = NULL;
										gchar* _tmp57_;
										gboolean _tmp58_;
										_tmp56_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp57_ = _tmp56_;
										if ((_tmp58_ = g_strcmp0 (_tmp57_, "1") == 0, _g_free0 (_tmp57_), _tmp58_)) {
											vala_class_set_is_immutable (cl, TRUE);
										}
									} else {
										if (g_strcmp0 (nv[0], "deprecated") == 0) {
											gchar* _tmp59_ = NULL;
											gchar* _tmp60_;
											gboolean _tmp61_;
											_tmp59_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp60_ = _tmp59_;
											if ((_tmp61_ = g_strcmp0 (_tmp60_, "1") == 0, _g_free0 (_tmp60_), _tmp61_)) {
												vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "replacement") == 0) {
												gchar* _tmp62_ = NULL;
												gchar* _tmp63_;
												_tmp62_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp63_ = _tmp62_;
												vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp63_);
												_g_free0 (_tmp63_);
											} else {
												if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
													gchar* _tmp64_ = NULL;
													gchar* _tmp65_;
													_tmp64_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp65_ = _tmp64_;
													vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp65_);
													_g_free0 (_tmp65_);
												} else {
													if (g_strcmp0 (nv[0], "const_cname") == 0) {
														gchar* _tmp66_ = NULL;
														gchar* _tmp67_;
														_tmp66_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp67_ = _tmp66_;
														vala_class_set_const_cname (cl, _tmp67_);
														_g_free0 (_tmp67_);
													} else {
														if (g_strcmp0 (nv[0], "free_function") == 0) {
															gchar* _tmp68_ = NULL;
															gchar* _tmp69_;
															_tmp68_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp69_ = _tmp68_;
															_g_free0 (free_function);
															free_function = _tmp69_;
														} else {
															if (g_strcmp0 (nv[0], "ref_function") == 0) {
																gchar* _tmp70_ = NULL;
																gchar* _tmp71_;
																_tmp70_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp71_ = _tmp70_;
																_g_free0 (ref_function);
																ref_function = _tmp71_;
															} else {
																if (g_strcmp0 (nv[0], "unref_function") == 0) {
																	gchar* _tmp72_ = NULL;
																	gchar* _tmp73_;
																	_tmp72_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp73_ = _tmp72_;
																	_g_free0 (unref_function);
																	unref_function = _tmp73_;
																} else {
																	if (g_strcmp0 (nv[0], "copy_function") == 0) {
																		gchar* _tmp74_ = NULL;
																		gchar* _tmp75_;
																		_tmp74_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp75_ = _tmp74_;
																		_g_free0 (copy_function);
																		copy_function = _tmp75_;
																	} else {
																		if (g_strcmp0 (nv[0], "ref_function_void") == 0) {
																			gchar* _tmp76_ = NULL;
																			gchar* _tmp77_;
																			gboolean _tmp78_;
																			_tmp76_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp77_ = _tmp76_;
																			if ((_tmp78_ = g_strcmp0 (_tmp77_, "1") == 0, _g_free0 (_tmp77_), _tmp78_)) {
																				ref_function_void = TRUE;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
			_tmp79_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, "TYPE_");
			_tmp80_ = _tmp79_;
			vala_class_set_type_id (cl, _tmp80_);
			_g_free0 (_tmp80_);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			if (base_class != NULL) {
				ValaDataType* _tmp81_ = NULL;
				ValaDataType* parent;
				_tmp81_ = vala_gidl_parser_parse_type_string (self, base_class);
				parent = _tmp81_;
				vala_class_add_base_type (cl, parent);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp82_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
		_tmp83_ = _tmp82_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp83_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = boxed_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						if (g_strcmp0 (member->name, "ref") == 0) {
							gchar* _tmp84_;
							gchar* _tmp85_;
							ValaDataType* _tmp86_ = NULL;
							ValaDataType* _tmp87_;
							_tmp84_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
							_tmp85_ = _tmp84_;
							_g_free0 (ref_function);
							ref_function = _tmp85_;
							_tmp86_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL);
							_tmp87_ = _tmp86_;
							ref_function_void = VALA_IS_VOID_TYPE (_tmp87_);
							_vala_code_node_unref0 (_tmp87_);
						} else {
							if (g_strcmp0 (member->name, "unref") == 0) {
								gchar* _tmp88_;
								gchar* _tmp89_;
								_tmp88_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
								_tmp89_ = _tmp88_;
								_g_free0 (unref_function);
								unref_function = _tmp89_;
							} else {
								gboolean _tmp90_ = FALSE;
								if (g_strcmp0 (member->name, "free") == 0) {
									_tmp90_ = TRUE;
								} else {
									_tmp90_ = g_strcmp0 (member->name, "destroy") == 0;
								}
								if (_tmp90_) {
									gchar* _tmp91_;
									gchar* _tmp92_;
									_tmp91_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
									_tmp92_ = _tmp91_;
									_g_free0 (free_function);
									free_function = _tmp92_;
								} else {
									ValaMethod* _tmp95_ = NULL;
									ValaMethod* m;
									if (g_strcmp0 (member->name, "copy") == 0) {
										gchar* _tmp93_;
										gchar* _tmp94_;
										_tmp93_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
										_tmp94_ = _tmp93_;
										_g_free0 (copy_function);
										copy_function = _tmp94_;
									}
									_tmp95_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									m = _tmp95_;
									if (m != NULL) {
										vala_symbol_add_method ((ValaSymbol*) cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp96_ = NULL;
							ValaField* f;
							_tmp96_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp96_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		_tmp97_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp97_;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaSymbol* container, GIdlModule* module, gboolean is_flags) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gboolean existing;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	ValaEnum* en;
	gboolean _tmp11_ = FALSE;
	gchar* common_prefix;
	gboolean is_errordomain;
	ValaArrayList* _tmp45_ = NULL;
	ValaArrayList* cheader_filenames;
	gint _tmp46_;
	gchar** _tmp47_ = NULL;
	gchar** en_attributes;
	gint en_attributes_length1;
	gint _en_attributes_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (en_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) en_node;
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	existing = TRUE;
	_tmp1_ = vala_symbol_get_scope (container);
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	en = (_tmp3_ = _tmp2_, VALA_IS_ENUM (_tmp3_) ? ((ValaEnum*) _tmp3_) : NULL);
	if (en == NULL) {
		ValaEnum* _tmp4_ = NULL;
		ValaEnum* _tmp5_;
		_tmp4_ = vala_enum_new (name, self->priv->current_source_reference, NULL);
		_tmp5_ = _tmp4_;
		_vala_code_node_unref0 (en);
		en = _tmp5_;
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		existing = FALSE;
	} else {
		ValaScope* _tmp6_ = NULL;
		ValaSymbol* _tmp7_ = NULL;
		ValaEnumValue* dummy;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) en);
		_tmp7_ = vala_scope_lookup (_tmp6_, "__DUMMY__");
		dummy = VALA_ENUM_VALUE (_tmp7_);
		if (dummy != NULL) {
			ValaList* _tmp8_ = NULL;
			ValaList* _tmp9_;
			ValaScope* _tmp10_ = NULL;
			_tmp8_ = vala_enum_get_values (en);
			_tmp9_ = _tmp8_;
			vala_collection_remove ((ValaCollection*) _tmp9_, dummy);
			_vala_iterable_unref0 (_tmp9_);
			_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) en);
			vala_scope_remove (_tmp10_, "__DUMMY__");
		}
		_vala_code_node_unref0 (dummy);
	}
	if (en_node->gtype_name != NULL) {
		_tmp11_ = g_strcmp0 (en_node->gtype_name, "") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	vala_enum_set_has_type_id (en, _tmp11_);
	common_prefix = NULL;
	{
		GList* value_collection;
		GList* value_it;
		value_collection = en_node->values;
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GIdlNode* value;
			value = (GIdlNode*) value_it->data;
			{
				gint _tmp12_;
				gchar** _tmp13_ = NULL;
				gchar** val_attributes;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gboolean is_hidden;
				_tmp13_ = vala_gidl_parser_get_attributes (self, value->name, &_tmp12_);
				val_attributes = _tmp13_;
				val_attributes_length1 = _tmp12_;
				_val_attributes_size_ = _tmp12_;
				is_hidden = FALSE;
				if (val_attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = val_attributes;
						attr_collection_length1 = val_attributes_length1;
						for (attr_it = 0; attr_it < val_attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp14_;
							gchar* attr;
							_tmp14_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp14_;
							{
								gchar** _tmp15_;
								gchar** _tmp16_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								gboolean _tmp17_ = FALSE;
								_tmp16_ = _tmp15_ = g_strsplit (attr, "=", 2);
								nv = _tmp16_;
								nv_length1 = _vala_array_length (_tmp15_);
								_nv_size_ = _vala_array_length (_tmp15_);
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp18_ = NULL;
									gchar* _tmp19_;
									_tmp18_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp19_ = _tmp18_;
									_tmp17_ = g_strcmp0 (_tmp19_, "1") == 0;
									_g_free0 (_tmp19_);
								} else {
									_tmp17_ = FALSE;
								}
								if (_tmp17_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (is_hidden) {
					val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				if (common_prefix == NULL) {
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp20_ = g_strdup (value->name);
					_tmp21_ = _tmp20_;
					_g_free0 (common_prefix);
					common_prefix = _tmp21_;
					while (TRUE) {
						gboolean _tmp22_ = FALSE;
						gint _tmp23_;
						gint _tmp25_;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_;
						_tmp23_ = strlen (common_prefix);
						if (_tmp23_ > 0) {
							gboolean _tmp24_;
							_tmp24_ = g_str_has_suffix (common_prefix, "_");
							_tmp22_ = !_tmp24_;
						} else {
							_tmp22_ = FALSE;
						}
						if (!_tmp22_) {
							break;
						}
						_tmp25_ = strlen (common_prefix);
						_tmp26_ = string_substring (common_prefix, (glong) 0, (glong) (_tmp25_ - 1));
						_tmp27_ = _tmp26_;
						_g_free0 (common_prefix);
						common_prefix = _tmp27_;
					}
				} else {
					while (TRUE) {
						gboolean _tmp28_;
						gint _tmp29_;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_;
						_tmp28_ = g_str_has_prefix (value->name, common_prefix);
						if (!(!_tmp28_)) {
							break;
						}
						_tmp29_ = strlen (common_prefix);
						_tmp30_ = string_substring (common_prefix, (glong) 0, (glong) (_tmp29_ - 1));
						_tmp31_ = _tmp30_;
						_g_free0 (common_prefix);
						common_prefix = _tmp31_;
					}
				}
				while (TRUE) {
					gboolean _tmp32_ = FALSE;
					gint _tmp33_;
					gint _tmp42_;
					gchar* _tmp43_ = NULL;
					gchar* _tmp44_;
					_tmp33_ = strlen (common_prefix);
					if (_tmp33_ > 0) {
						gboolean _tmp34_ = FALSE;
						gboolean _tmp35_;
						_tmp35_ = g_str_has_suffix (common_prefix, "_");
						if (!_tmp35_) {
							_tmp34_ = TRUE;
						} else {
							gboolean _tmp36_ = FALSE;
							gint _tmp37_;
							gunichar _tmp38_;
							gboolean _tmp39_;
							_tmp37_ = strlen (common_prefix);
							_tmp38_ = string_get_char (value->name, (glong) _tmp37_);
							_tmp39_ = g_unichar_isdigit (_tmp38_);
							if (_tmp39_) {
								gint _tmp40_;
								gint _tmp41_;
								_tmp40_ = strlen (value->name);
								_tmp41_ = strlen (common_prefix);
								_tmp36_ = (_tmp40_ - _tmp41_) <= 1;
							} else {
								_tmp36_ = FALSE;
							}
							_tmp34_ = _tmp36_;
						}
						_tmp32_ = _tmp34_;
					} else {
						_tmp32_ = FALSE;
					}
					if (!_tmp32_) {
						break;
					}
					_tmp42_ = strlen (common_prefix);
					_tmp43_ = string_substring (common_prefix, (glong) 0, (glong) (_tmp42_ - 1));
					_tmp44_ = _tmp43_;
					_g_free0 (common_prefix);
					common_prefix = _tmp44_;
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	is_errordomain = FALSE;
	_tmp45_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	cheader_filenames = _tmp45_;
	_tmp47_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp46_);
	en_attributes = _tmp47_;
	en_attributes_length1 = _tmp46_;
	_en_attributes_size_ = _tmp46_;
	if (en_attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = en_attributes;
			attr_collection_length1 = en_attributes_length1;
			for (attr_it = 0; attr_it < en_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp48_;
				gchar* attr;
				_tmp48_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp48_;
				{
					gchar** _tmp49_;
					gchar** _tmp50_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp50_ = _tmp49_ = g_strsplit (attr, "=", 2);
					nv = _tmp50_;
					nv_length1 = _vala_array_length (_tmp49_);
					_nv_size_ = _vala_array_length (_tmp49_);
					if (g_strcmp0 (nv[0], "common_prefix") == 0) {
						gchar* _tmp51_ = NULL;
						gchar* _tmp52_;
						_tmp51_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp52_ = _tmp51_;
						_g_free0 (common_prefix);
						common_prefix = _tmp52_;
					} else {
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp53_ = NULL;
							gchar* _tmp54_;
							gchar* _tmp55_ = NULL;
							gchar* _tmp56_;
							_tmp53_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp54_ = _tmp53_;
							vala_collection_add ((ValaCollection*) cheader_filenames, _tmp54_);
							_g_free0 (_tmp54_);
							_tmp55_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp56_ = _tmp55_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) en, _tmp56_);
							_g_free0 (_tmp56_);
						} else {
							if (g_strcmp0 (nv[0], "hidden") == 0) {
								gchar* _tmp57_ = NULL;
								gchar* _tmp58_;
								gboolean _tmp59_;
								_tmp57_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp58_ = _tmp57_;
								if ((_tmp59_ = g_strcmp0 (_tmp58_, "1") == 0, _g_free0 (_tmp58_), _tmp59_)) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_iterable_unref0 (cheader_filenames);
									_g_free0 (common_prefix);
									_vala_code_node_unref0 (en);
									_g_free0 (name);
									return;
								}
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp60_ = NULL;
									gchar* _tmp61_;
									gboolean _tmp62_;
									_tmp60_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp61_ = _tmp60_;
									if ((_tmp62_ = g_strcmp0 (_tmp61_, "1") == 0, _g_free0 (_tmp61_), _tmp62_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) en, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp63_ = NULL;
										gchar* _tmp64_;
										_tmp63_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp64_ = _tmp63_;
										vala_symbol_set_replacement ((ValaSymbol*) en, _tmp64_);
										_g_free0 (_tmp64_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp65_ = NULL;
											gchar* _tmp66_;
											_tmp65_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp66_ = _tmp65_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) en, _tmp66_);
											_g_free0 (_tmp66_);
										} else {
											if (g_strcmp0 (nv[0], "rename_to") == 0) {
												gchar* _tmp67_ = NULL;
												gchar* _tmp68_;
												_tmp67_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp68_ = _tmp67_;
												vala_symbol_set_name ((ValaSymbol*) en, _tmp68_);
												_g_free0 (_tmp68_);
											} else {
												if (g_strcmp0 (nv[0], "errordomain") == 0) {
													gchar* _tmp69_ = NULL;
													gchar* _tmp70_;
													gboolean _tmp71_;
													_tmp69_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp70_ = _tmp69_;
													if ((_tmp71_ = g_strcmp0 (_tmp70_, "1") == 0, _g_free0 (_tmp70_), _tmp71_)) {
														is_errordomain = TRUE;
													}
												} else {
													if (g_strcmp0 (nv[0], "to_string") == 0) {
														ValaUnresolvedType* _tmp72_ = NULL;
														ValaUnresolvedType* return_type;
														ValaUnresolvedSymbol* _tmp73_ = NULL;
														ValaUnresolvedSymbol* _tmp74_;
														ValaMethod* _tmp75_ = NULL;
														ValaMethod* m;
														gchar* _tmp76_ = NULL;
														gchar* _tmp77_;
														_tmp72_ = vala_unresolved_type_new ();
														return_type = _tmp72_;
														_tmp73_ = vala_unresolved_symbol_new (NULL, "string", NULL);
														_tmp74_ = _tmp73_;
														vala_unresolved_type_set_unresolved_symbol (return_type, _tmp74_);
														_vala_code_node_unref0 (_tmp74_);
														vala_data_type_set_value_owned ((ValaDataType*) return_type, FALSE);
														_tmp75_ = vala_method_new ("to_string", (ValaDataType*) return_type, self->priv->current_source_reference, NULL);
														m = _tmp75_;
														vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
														_tmp76_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp77_ = _tmp76_;
														vala_method_set_cname (m, _tmp77_);
														_g_free0 (_tmp77_);
														vala_symbol_add_method ((ValaSymbol*) en, m);
														_vala_code_node_unref0 (m);
														_vala_code_node_unref0 (return_type);
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_enum_set_cprefix (en, common_prefix);
	{
		GList* value2_collection;
		GList* value2_it;
		value2_collection = en_node->values;
		for (value2_it = value2_collection; value2_it != NULL; value2_it = value2_it->next) {
			GIdlNode* value2;
			value2 = (GIdlNode*) value2_it->data;
			{
				gint _tmp78_;
				gchar** _tmp79_ = NULL;
				gchar** val_attributes;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gboolean is_hidden;
				_tmp79_ = vala_gidl_parser_get_attributes (self, value2->name, &_tmp78_);
				val_attributes = _tmp79_;
				val_attributes_length1 = _tmp78_;
				_val_attributes_size_ = _tmp78_;
				is_hidden = FALSE;
				if (val_attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = val_attributes;
						attr_collection_length1 = val_attributes_length1;
						for (attr_it = 0; attr_it < val_attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp80_;
							gchar* attr;
							_tmp80_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp80_;
							{
								gchar** _tmp81_;
								gchar** _tmp82_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								gboolean _tmp83_ = FALSE;
								_tmp82_ = _tmp81_ = g_strsplit (attr, "=", 2);
								nv = _tmp82_;
								nv_length1 = _vala_array_length (_tmp81_);
								_nv_size_ = _vala_array_length (_tmp81_);
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp84_ = NULL;
									gchar* _tmp85_;
									_tmp84_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp85_ = _tmp84_;
									_tmp83_ = g_strcmp0 (_tmp85_, "1") == 0;
									_g_free0 (_tmp85_);
								} else {
									_tmp83_ = FALSE;
								}
								if (_tmp83_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (!is_hidden) {
					gint _tmp86_;
					gchar* _tmp87_ = NULL;
					gchar* _tmp88_;
					ValaEnumValue* _tmp89_ = NULL;
					ValaEnumValue* _tmp90_;
					ValaEnumValue* ev;
					_tmp86_ = strlen (common_prefix);
					_tmp87_ = string_substring (value2->name, (glong) _tmp86_, (glong) (-1));
					_tmp88_ = _tmp87_;
					_tmp89_ = vala_enum_value_new (_tmp88_, NULL, NULL, NULL);
					ev = (_tmp90_ = _tmp89_, _g_free0 (_tmp88_), _tmp90_);
					vala_enum_add_value (en, ev);
					_vala_code_node_unref0 (ev);
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	if (is_errordomain) {
		const gchar* _tmp91_ = NULL;
		ValaErrorDomain* _tmp92_ = NULL;
		ValaErrorDomain* ed;
		_tmp91_ = vala_symbol_get_name ((ValaSymbol*) en);
		_tmp92_ = vala_error_domain_new (_tmp91_, self->priv->current_source_reference, NULL);
		ed = _tmp92_;
		vala_symbol_set_access ((ValaSymbol*) ed, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_error_domain_set_cprefix (ed, common_prefix);
		{
			ValaArrayList* _tmp93_;
			ValaArrayList* _filename_list;
			gint _tmp94_;
			gint _filename_size;
			gint _filename_index;
			_tmp93_ = _vala_iterable_ref0 (cheader_filenames);
			_filename_list = _tmp93_;
			_tmp94_ = vala_collection_get_size ((ValaCollection*) _filename_list);
			_filename_size = _tmp94_;
			_filename_index = -1;
			while (TRUE) {
				gpointer _tmp95_ = NULL;
				gchar* filename;
				_filename_index = _filename_index + 1;
				if (!(_filename_index < _filename_size)) {
					break;
				}
				_tmp95_ = vala_list_get ((ValaList*) _filename_list, _filename_index);
				filename = (gchar*) _tmp95_;
				vala_symbol_add_cheader_filename ((ValaSymbol*) ed, filename);
				_g_free0 (filename);
			}
			_vala_iterable_unref0 (_filename_list);
		}
		{
			ValaList* _tmp96_ = NULL;
			ValaList* _ev_list;
			gint _tmp97_;
			gint _ev_size;
			gint _ev_index;
			_tmp96_ = vala_enum_get_values (en);
			_ev_list = _tmp96_;
			_tmp97_ = vala_collection_get_size ((ValaCollection*) _ev_list);
			_ev_size = _tmp97_;
			_ev_index = -1;
			while (TRUE) {
				gpointer _tmp98_ = NULL;
				ValaEnumValue* ev;
				const gchar* _tmp99_ = NULL;
				ValaErrorCode* _tmp100_ = NULL;
				ValaErrorCode* _tmp101_;
				_ev_index = _ev_index + 1;
				if (!(_ev_index < _ev_size)) {
					break;
				}
				_tmp98_ = vala_list_get (_ev_list, _ev_index);
				ev = (ValaEnumValue*) _tmp98_;
				_tmp99_ = vala_symbol_get_name ((ValaSymbol*) ev);
				_tmp100_ = vala_error_code_new (_tmp99_, NULL, NULL);
				_tmp101_ = _tmp100_;
				vala_error_domain_add_code (ed, _tmp101_);
				_vala_code_node_unref0 (_tmp101_);
				_vala_code_node_unref0 (ev);
			}
			_vala_iterable_unref0 (_ev_list);
		}
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) ed);
		if (!existing) {
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) ed);
		}
		_vala_code_node_unref0 (ed);
	} else {
		vala_enum_set_is_flags (en, is_flags);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) en);
		if (!existing) {
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) en);
		}
	}
	en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (cheader_filenames);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (en);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module) {
	gchar* _tmp0_ = NULL;
	gchar* name;
	gchar* base_class;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	ValaClass* cl;
	ValaTypeSymbol* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaHashSet* _tmp52_ = NULL;
	ValaSet* _tmp53_;
	ValaHashMap* _tmp54_ = NULL;
	ValaHashMap* current_type_func_map;
	ValaHashMap* _tmp55_ = NULL;
	ValaHashMap* current_type_vfunc_map;
	ValaMethod* _tmp85_ = NULL;
	ValaTypeSymbol* _tmp88_;
	ValaSet* _tmp89_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = vala_gidl_parser_fix_type_name (self, ((GIdlNode*) node)->name, container);
	name = _tmp0_;
	base_class = NULL;
	_tmp1_ = vala_symbol_get_scope (container);
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	cl = (_tmp3_ = _tmp2_, VALA_IS_CLASS (_tmp3_) ? ((ValaClass*) _tmp3_) : NULL);
	if (cl == NULL) {
		ValaClass* _tmp4_ = NULL;
		ValaClass* _tmp5_;
		gint _tmp6_;
		gchar** _tmp7_ = NULL;
		gchar** attributes;
		gint attributes_length1;
		gint _attributes_size_;
		_tmp4_ = vala_class_new (name, self->priv->current_source_reference, NULL);
		_tmp5_ = _tmp4_;
		_vala_code_node_unref0 (cl);
		cl = _tmp5_;
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp7_ = vala_gidl_parser_get_attributes (self, node->gtype_name, &_tmp6_);
		attributes = _tmp7_;
		attributes_length1 = _tmp6_;
		_attributes_size_ = _tmp6_;
		if (attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp8_;
					gchar* attr;
					_tmp8_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp8_;
					{
						gchar** _tmp9_;
						gchar** _tmp10_ = NULL;
						gchar** nv;
						gint nv_length1;
						gint _nv_size_;
						_tmp10_ = _tmp9_ = g_strsplit (attr, "=", 2);
						nv = _tmp10_;
						nv_length1 = _vala_array_length (_tmp9_);
						_nv_size_ = _vala_array_length (_tmp9_);
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp11_ = NULL;
							gchar* _tmp12_;
							_tmp11_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp12_ = _tmp11_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp12_);
							_g_free0 (_tmp12_);
						} else {
							if (g_strcmp0 (nv[0], "base_class") == 0) {
								gchar* _tmp13_ = NULL;
								gchar* _tmp14_;
								_tmp13_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp14_ = _tmp13_;
								_g_free0 (base_class);
								base_class = _tmp14_;
							} else {
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp15_ = NULL;
									gchar* _tmp16_;
									gboolean _tmp17_;
									_tmp15_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp16_ = _tmp15_;
									if ((_tmp17_ = g_strcmp0 (_tmp16_, "1") == 0, _g_free0 (_tmp16_), _tmp17_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (base_class);
										_g_free0 (name);
										return;
									}
								} else {
									if (g_strcmp0 (nv[0], "type_check_function") == 0) {
										gchar* _tmp18_ = NULL;
										gchar* _tmp19_;
										_tmp18_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp19_ = _tmp18_;
										vala_class_set_type_check_function (cl, _tmp19_);
										_g_free0 (_tmp19_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated") == 0) {
											gchar* _tmp20_ = NULL;
											gchar* _tmp21_;
											gboolean _tmp22_;
											_tmp20_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp21_ = _tmp20_;
											if ((_tmp22_ = g_strcmp0 (_tmp21_, "1") == 0, _g_free0 (_tmp21_), _tmp22_)) {
												vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "replacement") == 0) {
												gchar* _tmp23_ = NULL;
												gchar* _tmp24_;
												_tmp23_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp24_ = _tmp23_;
												vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp24_);
												_g_free0 (_tmp24_);
											} else {
												if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
													gchar* _tmp25_ = NULL;
													gchar* _tmp26_;
													_tmp25_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp26_ = _tmp25_;
													vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp26_);
													_g_free0 (_tmp26_);
												} else {
													if (g_strcmp0 (nv[0], "type_id") == 0) {
														gchar* _tmp27_ = NULL;
														gchar* _tmp28_;
														_tmp27_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp28_ = _tmp27_;
														vala_class_set_type_id (cl, _tmp28_);
														_g_free0 (_tmp28_);
													} else {
														if (g_strcmp0 (nv[0], "abstract") == 0) {
															gchar* _tmp29_ = NULL;
															gchar* _tmp30_;
															gboolean _tmp31_;
															_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp30_ = _tmp29_;
															if ((_tmp31_ = g_strcmp0 (_tmp30_, "1") == 0, _g_free0 (_tmp30_), _tmp31_)) {
																vala_class_set_is_abstract (cl, TRUE);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	if (base_class != NULL) {
		ValaDataType* _tmp32_ = NULL;
		ValaDataType* parent;
		_tmp32_ = vala_gidl_parser_parse_type_string (self, base_class);
		parent = _tmp32_;
		vala_class_add_base_type (cl, parent);
		_vala_code_node_unref0 (parent);
	} else {
		if (node->parent != NULL) {
			ValaDataType* _tmp33_ = NULL;
			ValaDataType* parent;
			_tmp33_ = vala_gidl_parser_parse_type_string (self, node->parent);
			parent = _tmp33_;
			vala_class_add_base_type (cl, parent);
			_vala_code_node_unref0 (parent);
		} else {
			ValaUnresolvedSymbol* _tmp34_ = NULL;
			ValaUnresolvedSymbol* _tmp35_;
			ValaUnresolvedSymbol* _tmp36_ = NULL;
			ValaUnresolvedSymbol* _tmp37_;
			ValaUnresolvedSymbol* gobject_symbol;
			ValaUnresolvedType* _tmp38_ = NULL;
			ValaUnresolvedType* _tmp39_;
			_tmp34_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_unresolved_symbol_new (_tmp35_, "Object", NULL);
			gobject_symbol = (_tmp37_ = _tmp36_, _vala_code_node_unref0 (_tmp35_), _tmp37_);
			_tmp38_ = vala_unresolved_type_new_from_symbol (gobject_symbol, NULL);
			_tmp39_ = _tmp38_;
			vala_class_add_base_type (cl, (ValaDataType*) _tmp39_);
			_vala_code_node_unref0 (_tmp39_);
			_vala_code_node_unref0 (gobject_symbol);
		}
	}
	{
		GList* iface_name_collection;
		GList* iface_name_it;
		iface_name_collection = node->interfaces;
		for (iface_name_it = iface_name_collection; iface_name_it != NULL; iface_name_it = iface_name_it->next) {
			gchar* _tmp40_;
			gchar* iface_name;
			_tmp40_ = g_strdup ((const gchar*) iface_name_it->data);
			iface_name = _tmp40_;
			{
				gboolean skip_iface;
				gint _tmp41_;
				gchar** _tmp42_ = NULL;
				gchar** attributes;
				gint attributes_length1;
				gint _attributes_size_;
				ValaDataType* _tmp49_ = NULL;
				ValaDataType* iface;
				skip_iface = FALSE;
				_tmp42_ = vala_gidl_parser_get_attributes (self, iface_name, &_tmp41_);
				attributes = _tmp42_;
				attributes_length1 = _tmp41_;
				_attributes_size_ = _tmp41_;
				if (attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp43_;
							gchar* attr;
							_tmp43_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp43_;
							{
								gchar** _tmp44_;
								gchar** _tmp45_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								_tmp45_ = _tmp44_ = g_strsplit (attr, "=", 2);
								nv = _tmp45_;
								nv_length1 = _vala_array_length (_tmp44_);
								_nv_size_ = _vala_array_length (_tmp44_);
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp46_ = NULL;
									gchar* _tmp47_;
									gboolean _tmp48_;
									_tmp46_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp47_ = _tmp46_;
									if ((_tmp48_ = g_strcmp0 (_tmp47_, "1") == 0, _g_free0 (_tmp47_), _tmp48_)) {
										skip_iface = TRUE;
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (skip_iface) {
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (iface_name);
					continue;
				}
				_tmp49_ = vala_gidl_parser_parse_type_string (self, iface_name);
				iface = _tmp49_;
				vala_class_add_base_type (cl, iface);
				_vala_code_node_unref0 (iface);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (iface_name);
			}
		}
	}
	_tmp50_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
	_tmp51_ = _tmp50_;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp51_;
	_tmp52_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_tmp53_ = (ValaSet*) _tmp52_;
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = _tmp53_;
	_tmp54_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	current_type_func_map = _tmp54_;
	_tmp55_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	current_type_vfunc_map = _tmp55_;
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					vala_map_set ((ValaMap*) current_type_func_map, member->name, (GIdlNodeFunction*) member);
				}
				if (member->type == G_IDL_NODE_VFUNC) {
					vala_map_set ((ValaMap*) current_type_vfunc_map, member->name, "1");
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					gboolean _tmp56_;
					_tmp56_ = vala_map_contains ((ValaMap*) current_type_vfunc_map, member->name);
					if (!_tmp56_) {
						ValaMethod* _tmp57_ = NULL;
						ValaMethod* m;
						_tmp57_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp57_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) cl, m);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					if (member->type == G_IDL_NODE_VFUNC) {
						gpointer _tmp58_ = NULL;
						ValaMethod* _tmp59_ = NULL;
						ValaMethod* m;
						_tmp58_ = vala_map_get ((ValaMap*) current_type_func_map, member->name);
						_tmp59_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) member, (GIdlNodeFunction*) _tmp58_, FALSE);
						m = _tmp59_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) cl, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* _tmp60_ = NULL;
							ValaProperty* prop;
							_tmp60_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) member);
							prop = _tmp60_;
							if (prop != NULL) {
								vala_symbol_add_property ((ValaSymbol*) cl, prop);
							}
							_vala_code_node_unref0 (prop);
						} else {
							if (member->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* _tmp61_ = NULL;
								ValaSignal* sig;
								_tmp61_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) member);
								sig = _tmp61_;
								if (sig != NULL) {
									vala_symbol_add_signal ((ValaSymbol*) cl, sig);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FIELD) {
					gboolean _tmp62_;
					_tmp62_ = vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, member->name);
					if (!_tmp62_) {
						ValaField* _tmp63_ = NULL;
						ValaField* f;
						_tmp63_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
						f = _tmp63_;
						if (f != NULL) {
							vala_symbol_add_field ((ValaSymbol*) cl, f);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
		}
	}
	{
		ValaList* _tmp64_ = NULL;
		ValaList* _prop_list;
		gint _tmp65_;
		gint _prop_size;
		gint _prop_index;
		_tmp64_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_prop_list = _tmp64_;
		_tmp65_ = vala_collection_get_size ((ValaCollection*) _prop_list);
		_prop_size = _tmp65_;
		_prop_index = -1;
		while (TRUE) {
			gpointer _tmp66_ = NULL;
			ValaProperty* prop;
			const gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* getter;
			gboolean _tmp69_ = FALSE;
			ValaPropertyAccessor* _tmp70_ = NULL;
			const gchar* _tmp72_ = NULL;
			gchar* _tmp73_ = NULL;
			gchar* setter;
			gboolean _tmp74_ = FALSE;
			gboolean _tmp75_ = FALSE;
			ValaPropertyAccessor* _tmp76_ = NULL;
			gboolean _tmp80_ = FALSE;
			gboolean _tmp81_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp66_ = vala_list_get (_prop_list, _prop_index);
			prop = (ValaProperty*) _tmp66_;
			_tmp67_ = vala_symbol_get_name ((ValaSymbol*) prop);
			_tmp68_ = g_strdup_printf ("get_%s", _tmp67_);
			getter = _tmp68_;
			_tmp70_ = vala_property_get_get_accessor (prop);
			if (_tmp70_ != NULL) {
				gboolean _tmp71_;
				_tmp71_ = vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, getter);
				_tmp69_ = !_tmp71_;
			} else {
				_tmp69_ = FALSE;
			}
			if (_tmp69_) {
				vala_property_set_no_accessor_method (prop, TRUE);
			}
			_tmp72_ = vala_symbol_get_name ((ValaSymbol*) prop);
			_tmp73_ = g_strdup_printf ("set_%s", _tmp72_);
			setter = _tmp73_;
			_tmp76_ = vala_property_get_set_accessor (prop);
			if (_tmp76_ != NULL) {
				ValaPropertyAccessor* _tmp77_ = NULL;
				gboolean _tmp78_;
				_tmp77_ = vala_property_get_set_accessor (prop);
				_tmp78_ = vala_property_accessor_get_writable (_tmp77_);
				_tmp75_ = _tmp78_;
			} else {
				_tmp75_ = FALSE;
			}
			if (_tmp75_) {
				gboolean _tmp79_;
				_tmp79_ = vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, setter);
				_tmp74_ = !_tmp79_;
			} else {
				_tmp74_ = FALSE;
			}
			if (_tmp74_) {
				vala_property_set_no_accessor_method (prop, TRUE);
			}
			_tmp81_ = vala_property_get_no_accessor_method (prop);
			if (_tmp81_) {
				ValaPropertyAccessor* _tmp82_ = NULL;
				_tmp82_ = vala_property_get_get_accessor (prop);
				_tmp80_ = _tmp82_ != NULL;
			} else {
				_tmp80_ = FALSE;
			}
			if (_tmp80_) {
				ValaPropertyAccessor* _tmp83_ = NULL;
				ValaDataType* _tmp84_ = NULL;
				_tmp83_ = vala_property_get_get_accessor (prop);
				_tmp84_ = vala_property_accessor_get_value_type (_tmp83_);
				vala_data_type_set_value_owned (_tmp84_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) cl);
	_tmp85_ = vala_class_get_default_construction_method (cl);
	if (_tmp85_ == NULL) {
		ValaSourceReference* _tmp86_ = NULL;
		ValaCreationMethod* _tmp87_ = NULL;
		ValaCreationMethod* cm;
		_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
		_tmp87_ = vala_creation_method_new (NULL, NULL, _tmp86_, NULL);
		cm = _tmp87_;
		vala_method_set_has_construct_function ((ValaMethod*) cm, FALSE);
		vala_symbol_set_access ((ValaSymbol*) cm, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		vala_symbol_add_method ((ValaSymbol*) cl, (ValaMethod*) cm);
		_vala_code_node_unref0 (cm);
	}
	_tmp88_ = NULL;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp88_;
	_tmp89_ = NULL;
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = _tmp89_;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (cl);
	_g_free0 (base_class);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module) {
	gchar* _tmp0_ = NULL;
	gchar* name;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	ValaInterface* iface;
	ValaTypeSymbol* _tmp17_;
	ValaTypeSymbol* _tmp18_;
	ValaHashMap* _tmp19_ = NULL;
	ValaHashMap* current_type_func_map;
	ValaHashMap* _tmp20_ = NULL;
	ValaHashMap* current_type_vfunc_map;
	ValaTypeSymbol* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->gtype_name, container);
	name = _tmp0_;
	_tmp1_ = vala_symbol_get_scope (container);
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	iface = (_tmp3_ = _tmp2_, VALA_IS_INTERFACE (_tmp3_) ? ((ValaInterface*) _tmp3_) : NULL);
	if (iface == NULL) {
		ValaInterface* _tmp4_ = NULL;
		ValaInterface* _tmp5_;
		gint _tmp6_;
		gchar** _tmp7_ = NULL;
		gchar** attributes;
		gint attributes_length1;
		gint _attributes_size_;
		_tmp4_ = vala_interface_new (name, self->priv->current_source_reference, NULL);
		_tmp5_ = _tmp4_;
		_vala_code_node_unref0 (iface);
		iface = _tmp5_;
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp7_ = vala_gidl_parser_get_attributes (self, node->gtype_name, &_tmp6_);
		attributes = _tmp7_;
		attributes_length1 = _tmp6_;
		_attributes_size_ = _tmp6_;
		if (attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp8_;
					gchar* attr;
					_tmp8_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp8_;
					{
						gchar** _tmp9_;
						gchar** _tmp10_ = NULL;
						gchar** nv;
						gint nv_length1;
						gint _nv_size_;
						_tmp10_ = _tmp9_ = g_strsplit (attr, "=", 2);
						nv = _tmp10_;
						nv_length1 = _vala_array_length (_tmp9_);
						_nv_size_ = _vala_array_length (_tmp9_);
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp11_ = NULL;
							gchar* _tmp12_;
							_tmp11_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp12_ = _tmp11_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) iface, _tmp12_);
							_g_free0 (_tmp12_);
						} else {
							if (g_strcmp0 (nv[0], "lower_case_csuffix") == 0) {
								gchar* _tmp13_ = NULL;
								gchar* _tmp14_;
								_tmp13_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp14_ = _tmp13_;
								vala_interface_set_lower_case_csuffix (iface, _tmp14_);
								_g_free0 (_tmp14_);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		{
			GList* prereq_name_collection;
			GList* prereq_name_it;
			prereq_name_collection = node->prerequisites;
			for (prereq_name_it = prereq_name_collection; prereq_name_it != NULL; prereq_name_it = prereq_name_it->next) {
				gchar* _tmp15_;
				gchar* prereq_name;
				_tmp15_ = g_strdup ((const gchar*) prereq_name_it->data);
				prereq_name = _tmp15_;
				{
					ValaDataType* _tmp16_ = NULL;
					ValaDataType* prereq;
					_tmp16_ = vala_gidl_parser_parse_type_string (self, prereq_name);
					prereq = _tmp16_;
					vala_interface_add_prerequisite (iface, prereq);
					_vala_code_node_unref0 (prereq);
					_g_free0 (prereq_name);
				}
			}
		}
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) iface);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) iface);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp17_ = _vala_code_node_ref0 ((ValaTypeSymbol*) iface);
	_tmp18_ = _tmp17_;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp18_;
	_tmp19_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	current_type_func_map = _tmp19_;
	_tmp20_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	current_type_vfunc_map = _tmp20_;
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					vala_map_set ((ValaMap*) current_type_func_map, member->name, (GIdlNodeFunction*) member);
				}
				if (member->type == G_IDL_NODE_VFUNC) {
					vala_map_set ((ValaMap*) current_type_vfunc_map, member->name, "1");
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					gboolean _tmp21_;
					_tmp21_ = vala_map_contains ((ValaMap*) current_type_vfunc_map, member->name);
					if (!_tmp21_) {
						ValaMethod* _tmp22_ = NULL;
						ValaMethod* m;
						_tmp22_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, TRUE);
						m = _tmp22_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) iface, m);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					if (member->type == G_IDL_NODE_VFUNC) {
						gpointer _tmp23_ = NULL;
						ValaMethod* _tmp24_ = NULL;
						ValaMethod* m;
						_tmp23_ = vala_map_get ((ValaMap*) current_type_func_map, member->name);
						_tmp24_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) member, (GIdlNodeFunction*) _tmp23_, TRUE);
						m = _tmp24_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) iface, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* _tmp25_ = NULL;
							ValaProperty* prop;
							_tmp25_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) member);
							prop = _tmp25_;
							if (prop != NULL) {
								vala_symbol_add_property ((ValaSymbol*) iface, prop);
							}
							_vala_code_node_unref0 (prop);
						} else {
							if (member->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* _tmp26_ = NULL;
								ValaSignal* sig;
								_tmp26_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) member);
								sig = _tmp26_;
								if (sig != NULL) {
									vala_symbol_add_signal ((ValaSymbol*) iface, sig);
									vala_signal_set_is_virtual (sig, FALSE);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) iface);
	_tmp27_ = NULL;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp27_;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (iface);
	_g_free0 (name);
}


static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol) {
	ValaHashSet* _tmp0_ = NULL;
	ValaSet* finish_methods;
	ValaList* _tmp1_ = NULL;
	ValaList* methods;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_symbol != NULL);
	_tmp0_ = vala_hash_set_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_hash, g_direct_equal);
	finish_methods = (ValaSet*) _tmp0_;
	_tmp1_ = vala_object_type_symbol_get_methods (type_symbol);
	methods = _tmp1_;
	{
		ValaList* _tmp2_;
		ValaList* _m_list;
		gint _tmp3_;
		gint _m_size;
		gint _m_index;
		_tmp2_ = _vala_iterable_ref0 (methods);
		_m_list = _tmp2_;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_size = _tmp3_;
		_m_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			ValaMethod* m;
			gboolean _tmp5_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp4_ = vala_list_get (_m_list, _m_index);
			m = (ValaMethod*) _tmp4_;
			_tmp5_ = vala_method_get_coroutine (m);
			if (_tmp5_) {
				gchar* finish_method_base = NULL;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_;
				ValaScope* _tmp17_ = NULL;
				gchar* _tmp18_;
				ValaSymbol* _tmp19_ = NULL;
				ValaSymbol* _tmp20_;
				ValaMethod* _tmp21_;
				ValaMethod* finish_method;
				_tmp6_ = vala_symbol_get_name ((ValaSymbol*) m);
				_tmp7_ = g_str_has_suffix (_tmp6_, "_async");
				if (_tmp7_) {
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					gint _tmp10_;
					gint _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp8_ = vala_symbol_get_name ((ValaSymbol*) m);
					_tmp9_ = vala_symbol_get_name ((ValaSymbol*) m);
					_tmp10_ = strlen (_tmp9_);
					_tmp11_ = strlen ("_async");
					_tmp12_ = string_substring (_tmp8_, (glong) 0, (glong) (_tmp10_ - _tmp11_));
					_tmp13_ = _tmp12_;
					_g_free0 (finish_method_base);
					finish_method_base = _tmp13_;
				} else {
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = vala_symbol_get_name ((ValaSymbol*) m);
					_tmp15_ = g_strdup (_tmp14_);
					_tmp16_ = _tmp15_;
					_g_free0 (finish_method_base);
					finish_method_base = _tmp16_;
				}
				_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) type_symbol);
				_tmp18_ = g_strconcat (finish_method_base, "_finish", NULL);
				_tmp19_ = vala_scope_lookup (_tmp17_, _tmp18_);
				finish_method = (_tmp21_ = (_tmp20_ = _tmp19_, VALA_IS_METHOD (_tmp20_) ? ((ValaMethod*) _tmp20_) : NULL), _g_free0 (_tmp18_), _tmp21_);
				if (finish_method == NULL) {
					gchar* _tmp22_ = NULL;
					gchar* method_cname;
					_tmp22_ = vala_method_get_finish_cname (m);
					method_cname = _tmp22_;
					{
						ValaList* _tmp23_ = NULL;
						ValaList* _method_list;
						gint _tmp24_;
						gint _method_size;
						gint _method_index;
						_tmp23_ = vala_object_type_symbol_get_methods (type_symbol);
						_method_list = _tmp23_;
						_tmp24_ = vala_collection_get_size ((ValaCollection*) _method_list);
						_method_size = _tmp24_;
						_method_index = -1;
						while (TRUE) {
							gpointer _tmp25_ = NULL;
							ValaMethod* method;
							gchar* _tmp26_ = NULL;
							gchar* _tmp27_;
							gboolean _tmp28_;
							_method_index = _method_index + 1;
							if (!(_method_index < _method_size)) {
								break;
							}
							_tmp25_ = vala_list_get (_method_list, _method_index);
							method = (ValaMethod*) _tmp25_;
							_tmp26_ = vala_method_get_cname (method);
							_tmp27_ = _tmp26_;
							if ((_tmp28_ = g_strcmp0 (_tmp27_, method_cname) == 0, _g_free0 (_tmp27_), _tmp28_)) {
								ValaMethod* _tmp29_;
								ValaMethod* _tmp30_;
								_tmp29_ = _vala_code_node_ref0 (method);
								_tmp30_ = _tmp29_;
								_vala_code_node_unref0 (finish_method);
								finish_method = _tmp30_;
								_vala_code_node_unref0 (method);
								break;
							}
							_vala_code_node_unref0 (method);
						}
						_vala_iterable_unref0 (_method_list);
					}
					_g_free0 (method_cname);
				}
				if (finish_method != NULL) {
					ValaDataType* _tmp31_ = NULL;
					ValaDataType* _tmp32_ = NULL;
					ValaDataType* _tmp33_;
					gboolean _tmp34_;
					gboolean _tmp35_;
					_tmp31_ = vala_method_get_return_type (finish_method);
					_tmp32_ = vala_data_type_copy (_tmp31_);
					_tmp33_ = _tmp32_;
					vala_method_set_return_type (m, _tmp33_);
					_vala_code_node_unref0 (_tmp33_);
					_tmp34_ = vala_method_get_no_array_length (finish_method);
					vala_method_set_no_array_length (m, _tmp34_);
					_tmp35_ = vala_method_get_array_null_terminated (finish_method);
					vala_method_set_array_null_terminated (m, _tmp35_);
					{
						ValaList* _tmp36_ = NULL;
						ValaList* _param_list;
						gint _tmp37_;
						gint _param_size;
						gint _param_index;
						_tmp36_ = vala_method_get_parameters (finish_method);
						_param_list = _tmp36_;
						_tmp37_ = vala_collection_get_size ((ValaCollection*) _param_list);
						_param_size = _tmp37_;
						_param_index = -1;
						while (TRUE) {
							gpointer _tmp38_ = NULL;
							ValaParameter* param;
							ValaParameterDirection _tmp39_;
							_param_index = _param_index + 1;
							if (!(_param_index < _param_size)) {
								break;
							}
							_tmp38_ = vala_list_get (_param_list, _param_index);
							param = (ValaParameter*) _tmp38_;
							_tmp39_ = vala_parameter_get_direction (param);
							if (_tmp39_ == VALA_PARAMETER_DIRECTION_OUT) {
								ValaParameter* _tmp40_ = NULL;
								ValaParameter* async_param;
								ValaScope* _tmp41_ = NULL;
								const gchar* _tmp42_ = NULL;
								ValaSymbol* _tmp43_ = NULL;
								ValaSymbol* _tmp44_;
								gboolean _tmp45_;
								_tmp40_ = vala_parameter_copy (param);
								async_param = _tmp40_;
								_tmp41_ = vala_symbol_get_scope ((ValaSymbol*) m);
								_tmp42_ = vala_symbol_get_name ((ValaSymbol*) param);
								_tmp43_ = vala_scope_lookup (_tmp41_, _tmp42_);
								_tmp44_ = _tmp43_;
								if ((_tmp45_ = _tmp44_ != NULL, _vala_code_node_unref0 (_tmp44_), _tmp45_)) {
									const gchar* _tmp46_ = NULL;
									gchar* _tmp47_;
									_tmp46_ = vala_symbol_get_name ((ValaSymbol*) async_param);
									_tmp47_ = g_strconcat (_tmp46_, "_out", NULL);
									vala_symbol_set_name ((ValaSymbol*) async_param, _tmp47_);
									_g_free0 (_tmp47_);
								}
								vala_method_add_parameter (m, async_param);
								_vala_code_node_unref0 (async_param);
							}
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					{
						ValaList* _tmp48_ = NULL;
						ValaList* _error_type_list;
						gint _tmp49_;
						gint _error_type_size;
						gint _error_type_index;
						_tmp48_ = vala_code_node_get_error_types ((ValaCodeNode*) finish_method);
						_error_type_list = _tmp48_;
						_tmp49_ = vala_collection_get_size ((ValaCollection*) _error_type_list);
						_error_type_size = _tmp49_;
						_error_type_index = -1;
						while (TRUE) {
							gpointer _tmp50_ = NULL;
							ValaDataType* error_type;
							ValaDataType* _tmp51_ = NULL;
							ValaDataType* _tmp52_;
							_error_type_index = _error_type_index + 1;
							if (!(_error_type_index < _error_type_size)) {
								break;
							}
							_tmp50_ = vala_list_get (_error_type_list, _error_type_index);
							error_type = (ValaDataType*) _tmp50_;
							_tmp51_ = vala_data_type_copy (error_type);
							_tmp52_ = _tmp51_;
							vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp52_);
							_vala_code_node_unref0 (_tmp52_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					vala_collection_add ((ValaCollection*) finish_methods, finish_method);
				}
				_vala_code_node_unref0 (finish_method);
				_g_free0 (finish_method_base);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaIterator* _tmp53_ = NULL;
		ValaIterator* _m_it;
		_tmp53_ = vala_iterable_iterator ((ValaIterable*) finish_methods);
		_m_it = _tmp53_;
		while (TRUE) {
			gboolean _tmp54_;
			gpointer _tmp55_ = NULL;
			ValaMethod* m;
			ValaScope* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			_tmp54_ = vala_iterator_next (_m_it);
			if (!_tmp54_) {
				break;
			}
			_tmp55_ = vala_iterator_get (_m_it);
			m = (ValaMethod*) _tmp55_;
			_tmp56_ = vala_symbol_get_scope ((ValaSymbol*) type_symbol);
			_tmp57_ = vala_symbol_get_name ((ValaSymbol*) m);
			vala_scope_remove (_tmp56_, _tmp57_);
			vala_collection_remove ((ValaCollection*) methods, m);
			_vala_code_node_unref0 (m);
		}
		_vala_iterator_unref0 (_m_it);
	}
	_vala_iterable_unref0 (methods);
	_vala_iterable_unref0 (finish_methods);
}


static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction) {
	ValaParameterDirection _direction = 0;
	ValaDataType* result = NULL;
	ValaParameterDirection dir;
	ValaUnresolvedType* _tmp0_ = NULL;
	ValaUnresolvedType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_node != NULL, NULL);
	dir = VALA_PARAMETER_DIRECTION_IN;
	_tmp0_ = vala_unresolved_type_new ();
	type = _tmp0_;
	if (type_node->tag == TYPE_TAG_VOID) {
		if (type_node->is_pointer) {
			ValaVoidType* _tmp1_ = NULL;
			ValaVoidType* _tmp2_;
			ValaPointerType* _tmp3_ = NULL;
			ValaDataType* _tmp4_;
			_tmp1_ = vala_void_type_new (NULL);
			_tmp2_ = _tmp1_;
			_tmp3_ = vala_pointer_type_new ((ValaDataType*) _tmp2_, NULL);
			result = (_tmp4_ = (ValaDataType*) _tmp3_, _vala_code_node_unref0 (_tmp2_), _tmp4_);
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _direction;
			}
			return result;
		} else {
			ValaVoidType* _tmp5_ = NULL;
			_tmp5_ = vala_void_type_new (NULL);
			result = (ValaDataType*) _tmp5_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _direction;
			}
			return result;
		}
	} else {
		if (type_node->tag == TYPE_TAG_BOOLEAN) {
			ValaUnresolvedSymbol* _tmp6_ = NULL;
			ValaUnresolvedSymbol* _tmp7_;
			_tmp6_ = vala_unresolved_symbol_new (NULL, "bool", NULL);
			_tmp7_ = _tmp6_;
			vala_unresolved_type_set_unresolved_symbol (type, _tmp7_);
			_vala_code_node_unref0 (_tmp7_);
		} else {
			if (type_node->tag == TYPE_TAG_INT8) {
				ValaUnresolvedSymbol* _tmp8_ = NULL;
				ValaUnresolvedSymbol* _tmp9_;
				_tmp8_ = vala_unresolved_symbol_new (NULL, "char", NULL);
				_tmp9_ = _tmp8_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp9_);
				_vala_code_node_unref0 (_tmp9_);
			} else {
				if (type_node->tag == TYPE_TAG_UINT8) {
					ValaUnresolvedSymbol* _tmp10_ = NULL;
					ValaUnresolvedSymbol* _tmp11_;
					_tmp10_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
					_tmp11_ = _tmp10_;
					vala_unresolved_type_set_unresolved_symbol (type, _tmp11_);
					_vala_code_node_unref0 (_tmp11_);
				} else {
					if (type_node->tag == TYPE_TAG_INT16) {
						ValaUnresolvedSymbol* _tmp12_ = NULL;
						ValaUnresolvedSymbol* _tmp13_;
						_tmp12_ = vala_unresolved_symbol_new (NULL, "int16", NULL);
						_tmp13_ = _tmp12_;
						vala_unresolved_type_set_unresolved_symbol (type, _tmp13_);
						_vala_code_node_unref0 (_tmp13_);
					} else {
						if (type_node->tag == TYPE_TAG_UINT16) {
							ValaUnresolvedSymbol* _tmp14_ = NULL;
							ValaUnresolvedSymbol* _tmp15_;
							_tmp14_ = vala_unresolved_symbol_new (NULL, "uint16", NULL);
							_tmp15_ = _tmp14_;
							vala_unresolved_type_set_unresolved_symbol (type, _tmp15_);
							_vala_code_node_unref0 (_tmp15_);
						} else {
							if (type_node->tag == TYPE_TAG_INT32) {
								ValaUnresolvedSymbol* _tmp16_ = NULL;
								ValaUnresolvedSymbol* _tmp17_;
								_tmp16_ = vala_unresolved_symbol_new (NULL, "int32", NULL);
								_tmp17_ = _tmp16_;
								vala_unresolved_type_set_unresolved_symbol (type, _tmp17_);
								_vala_code_node_unref0 (_tmp17_);
							} else {
								if (type_node->tag == TYPE_TAG_UINT32) {
									ValaUnresolvedSymbol* _tmp18_ = NULL;
									ValaUnresolvedSymbol* _tmp19_;
									_tmp18_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
									_tmp19_ = _tmp18_;
									vala_unresolved_type_set_unresolved_symbol (type, _tmp19_);
									_vala_code_node_unref0 (_tmp19_);
								} else {
									if (type_node->tag == TYPE_TAG_INT64) {
										ValaUnresolvedSymbol* _tmp20_ = NULL;
										ValaUnresolvedSymbol* _tmp21_;
										_tmp20_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
										_tmp21_ = _tmp20_;
										vala_unresolved_type_set_unresolved_symbol (type, _tmp21_);
										_vala_code_node_unref0 (_tmp21_);
									} else {
										if (type_node->tag == TYPE_TAG_UINT64) {
											ValaUnresolvedSymbol* _tmp22_ = NULL;
											ValaUnresolvedSymbol* _tmp23_;
											_tmp22_ = vala_unresolved_symbol_new (NULL, "uint64", NULL);
											_tmp23_ = _tmp22_;
											vala_unresolved_type_set_unresolved_symbol (type, _tmp23_);
											_vala_code_node_unref0 (_tmp23_);
										} else {
											if (type_node->tag == TYPE_TAG_INT) {
												ValaUnresolvedSymbol* _tmp24_ = NULL;
												ValaUnresolvedSymbol* _tmp25_;
												_tmp24_ = vala_unresolved_symbol_new (NULL, "int", NULL);
												_tmp25_ = _tmp24_;
												vala_unresolved_type_set_unresolved_symbol (type, _tmp25_);
												_vala_code_node_unref0 (_tmp25_);
											} else {
												if (type_node->tag == TYPE_TAG_UINT) {
													ValaUnresolvedSymbol* _tmp26_ = NULL;
													ValaUnresolvedSymbol* _tmp27_;
													_tmp26_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
													_tmp27_ = _tmp26_;
													vala_unresolved_type_set_unresolved_symbol (type, _tmp27_);
													_vala_code_node_unref0 (_tmp27_);
												} else {
													if (type_node->tag == TYPE_TAG_LONG) {
														ValaUnresolvedSymbol* _tmp28_ = NULL;
														ValaUnresolvedSymbol* _tmp29_;
														_tmp28_ = vala_unresolved_symbol_new (NULL, "long", NULL);
														_tmp29_ = _tmp28_;
														vala_unresolved_type_set_unresolved_symbol (type, _tmp29_);
														_vala_code_node_unref0 (_tmp29_);
													} else {
														if (type_node->tag == TYPE_TAG_ULONG) {
															ValaUnresolvedSymbol* _tmp30_ = NULL;
															ValaUnresolvedSymbol* _tmp31_;
															_tmp30_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
															_tmp31_ = _tmp30_;
															vala_unresolved_type_set_unresolved_symbol (type, _tmp31_);
															_vala_code_node_unref0 (_tmp31_);
														} else {
															if (type_node->tag == TYPE_TAG_SSIZE) {
																ValaUnresolvedSymbol* _tmp32_ = NULL;
																ValaUnresolvedSymbol* _tmp33_;
																_tmp32_ = vala_unresolved_symbol_new (NULL, "ssize_t", NULL);
																_tmp33_ = _tmp32_;
																vala_unresolved_type_set_unresolved_symbol (type, _tmp33_);
																_vala_code_node_unref0 (_tmp33_);
															} else {
																if (type_node->tag == TYPE_TAG_SIZE) {
																	ValaUnresolvedSymbol* _tmp34_ = NULL;
																	ValaUnresolvedSymbol* _tmp35_;
																	_tmp34_ = vala_unresolved_symbol_new (NULL, "size_t", NULL);
																	_tmp35_ = _tmp34_;
																	vala_unresolved_type_set_unresolved_symbol (type, _tmp35_);
																	_vala_code_node_unref0 (_tmp35_);
																} else {
																	if (type_node->tag == TYPE_TAG_FLOAT) {
																		ValaUnresolvedSymbol* _tmp36_ = NULL;
																		ValaUnresolvedSymbol* _tmp37_;
																		_tmp36_ = vala_unresolved_symbol_new (NULL, "float", NULL);
																		_tmp37_ = _tmp36_;
																		vala_unresolved_type_set_unresolved_symbol (type, _tmp37_);
																		_vala_code_node_unref0 (_tmp37_);
																	} else {
																		if (type_node->tag == TYPE_TAG_DOUBLE) {
																			ValaUnresolvedSymbol* _tmp38_ = NULL;
																			ValaUnresolvedSymbol* _tmp39_;
																			_tmp38_ = vala_unresolved_symbol_new (NULL, "double", NULL);
																			_tmp39_ = _tmp38_;
																			vala_unresolved_type_set_unresolved_symbol (type, _tmp39_);
																			_vala_code_node_unref0 (_tmp39_);
																		} else {
																			if (type_node->tag == TYPE_TAG_UTF8) {
																				ValaUnresolvedSymbol* _tmp40_ = NULL;
																				ValaUnresolvedSymbol* _tmp41_;
																				_tmp40_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																				_tmp41_ = _tmp40_;
																				vala_unresolved_type_set_unresolved_symbol (type, _tmp41_);
																				_vala_code_node_unref0 (_tmp41_);
																			} else {
																				if (type_node->tag == TYPE_TAG_FILENAME) {
																					ValaUnresolvedSymbol* _tmp42_ = NULL;
																					ValaUnresolvedSymbol* _tmp43_;
																					_tmp42_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																					_tmp43_ = _tmp42_;
																					vala_unresolved_type_set_unresolved_symbol (type, _tmp43_);
																					_vala_code_node_unref0 (_tmp43_);
																				} else {
																					if (type_node->tag == TYPE_TAG_ARRAY) {
																						ValaDataType* _tmp44_ = NULL;
																						ValaDataType* element_type;
																						ValaDataType* _tmp45_;
																						ValaUnresolvedType* _tmp46_;
																						ValaUnresolvedType* _tmp47_;
																						ValaSourceReference* _tmp48_ = NULL;
																						ValaArrayType* _tmp49_ = NULL;
																						_tmp44_ = vala_gidl_parser_parse_type (self, type_node->parameter_type1, NULL);
																						element_type = _tmp44_;
																						_tmp46_ = _vala_code_node_ref0 ((_tmp45_ = element_type, VALA_IS_UNRESOLVED_TYPE (_tmp45_) ? ((ValaUnresolvedType*) _tmp45_) : NULL));
																						_tmp47_ = _tmp46_;
																						_vala_code_node_unref0 (type);
																						type = _tmp47_;
																						if (type == NULL) {
																							result = element_type;
																							_vala_code_node_unref0 (type);
																							if (direction) {
																								*direction = _direction;
																							}
																							return result;
																						}
																						_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) element_type);
																						_tmp49_ = vala_array_type_new (element_type, 1, _tmp48_);
																						result = (ValaDataType*) _tmp49_;
																						_vala_code_node_unref0 (element_type);
																						_vala_code_node_unref0 (type);
																						if (direction) {
																							*direction = _direction;
																						}
																						return result;
																					} else {
																						if (type_node->tag == TYPE_TAG_LIST) {
																							ValaUnresolvedSymbol* _tmp50_ = NULL;
																							ValaUnresolvedSymbol* _tmp51_;
																							ValaUnresolvedSymbol* _tmp52_ = NULL;
																							ValaUnresolvedSymbol* _tmp53_;
																							_tmp50_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																							_tmp51_ = _tmp50_;
																							_tmp52_ = vala_unresolved_symbol_new (_tmp51_, "List", NULL);
																							_tmp53_ = _tmp52_;
																							vala_unresolved_type_set_unresolved_symbol (type, _tmp53_);
																							_vala_code_node_unref0 (_tmp53_);
																							_vala_code_node_unref0 (_tmp51_);
																						} else {
																							if (type_node->tag == TYPE_TAG_SLIST) {
																								ValaUnresolvedSymbol* _tmp54_ = NULL;
																								ValaUnresolvedSymbol* _tmp55_;
																								ValaUnresolvedSymbol* _tmp56_ = NULL;
																								ValaUnresolvedSymbol* _tmp57_;
																								_tmp54_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																								_tmp55_ = _tmp54_;
																								_tmp56_ = vala_unresolved_symbol_new (_tmp55_, "SList", NULL);
																								_tmp57_ = _tmp56_;
																								vala_unresolved_type_set_unresolved_symbol (type, _tmp57_);
																								_vala_code_node_unref0 (_tmp57_);
																								_vala_code_node_unref0 (_tmp55_);
																							} else {
																								if (type_node->tag == TYPE_TAG_HASH) {
																									ValaUnresolvedSymbol* _tmp58_ = NULL;
																									ValaUnresolvedSymbol* _tmp59_;
																									ValaUnresolvedSymbol* _tmp60_ = NULL;
																									ValaUnresolvedSymbol* _tmp61_;
																									_tmp58_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																									_tmp59_ = _tmp58_;
																									_tmp60_ = vala_unresolved_symbol_new (_tmp59_, "HashTable", NULL);
																									_tmp61_ = _tmp60_;
																									vala_unresolved_type_set_unresolved_symbol (type, _tmp61_);
																									_vala_code_node_unref0 (_tmp61_);
																									_vala_code_node_unref0 (_tmp59_);
																								} else {
																									if (type_node->tag == TYPE_TAG_ERROR) {
																										ValaUnresolvedSymbol* _tmp62_ = NULL;
																										ValaUnresolvedSymbol* _tmp63_;
																										ValaUnresolvedSymbol* _tmp64_ = NULL;
																										ValaUnresolvedSymbol* _tmp65_;
																										_tmp62_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																										_tmp63_ = _tmp62_;
																										_tmp64_ = vala_unresolved_symbol_new (_tmp63_, "Error", NULL);
																										_tmp65_ = _tmp64_;
																										vala_unresolved_type_set_unresolved_symbol (type, _tmp65_);
																										_vala_code_node_unref0 (_tmp65_);
																										_vala_code_node_unref0 (_tmp63_);
																									} else {
																										if (type_node->is_interface) {
																											gchar* _tmp66_;
																											gchar* n;
																											gboolean _tmp67_;
																											gboolean _tmp71_ = FALSE;
																											_tmp66_ = g_strdup (type_node->interface);
																											n = _tmp66_;
																											if (g_strcmp0 (n, "") == 0) {
																												result = NULL;
																												_g_free0 (n);
																												_vala_code_node_unref0 (type);
																												if (direction) {
																													*direction = _direction;
																												}
																												return result;
																											}
																											_tmp67_ = g_str_has_prefix (n, "const-");
																											if (_tmp67_) {
																												gint _tmp68_;
																												gchar* _tmp69_ = NULL;
																												gchar* _tmp70_;
																												_tmp68_ = strlen ("const-");
																												_tmp69_ = string_substring (n, (glong) _tmp68_, (glong) (-1));
																												_tmp70_ = _tmp69_;
																												_g_free0 (n);
																												n = _tmp70_;
																											}
																											if (type_node->is_pointer) {
																												gboolean _tmp72_ = FALSE;
																												if (g_strcmp0 (n, "gchar") == 0) {
																													_tmp72_ = TRUE;
																												} else {
																													_tmp72_ = g_strcmp0 (n, "char") == 0;
																												}
																												_tmp71_ = _tmp72_;
																											} else {
																												_tmp71_ = FALSE;
																											}
																											if (_tmp71_) {
																												ValaUnresolvedSymbol* _tmp73_ = NULL;
																												ValaUnresolvedSymbol* _tmp74_;
																												gboolean _tmp75_;
																												_tmp73_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																												_tmp74_ = _tmp73_;
																												vala_unresolved_type_set_unresolved_symbol (type, _tmp74_);
																												_vala_code_node_unref0 (_tmp74_);
																												_tmp75_ = g_str_has_suffix (type_node->unparsed, "**");
																												if (_tmp75_) {
																													dir = VALA_PARAMETER_DIRECTION_OUT;
																												}
																											} else {
																												if (g_strcmp0 (n, "gunichar") == 0) {
																													ValaUnresolvedSymbol* _tmp76_ = NULL;
																													ValaUnresolvedSymbol* _tmp77_;
																													_tmp76_ = vala_unresolved_symbol_new (NULL, "unichar", NULL);
																													_tmp77_ = _tmp76_;
																													vala_unresolved_type_set_unresolved_symbol (type, _tmp77_);
																													_vala_code_node_unref0 (_tmp77_);
																												} else {
																													if (g_strcmp0 (n, "gchar") == 0) {
																														ValaUnresolvedSymbol* _tmp78_ = NULL;
																														ValaUnresolvedSymbol* _tmp79_;
																														_tmp78_ = vala_unresolved_symbol_new (NULL, "char", NULL);
																														_tmp79_ = _tmp78_;
																														vala_unresolved_type_set_unresolved_symbol (type, _tmp79_);
																														_vala_code_node_unref0 (_tmp79_);
																													} else {
																														gboolean _tmp80_ = FALSE;
																														if (g_strcmp0 (n, "guchar") == 0) {
																															_tmp80_ = TRUE;
																														} else {
																															_tmp80_ = g_strcmp0 (n, "guint8") == 0;
																														}
																														if (_tmp80_) {
																															ValaUnresolvedSymbol* _tmp81_ = NULL;
																															ValaUnresolvedSymbol* _tmp82_;
																															_tmp81_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
																															_tmp82_ = _tmp81_;
																															vala_unresolved_type_set_unresolved_symbol (type, _tmp82_);
																															_vala_code_node_unref0 (_tmp82_);
																															if (type_node->is_pointer) {
																																ValaSourceReference* _tmp83_ = NULL;
																																ValaArrayType* _tmp84_ = NULL;
																																_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
																																_tmp84_ = vala_array_type_new ((ValaDataType*) type, 1, _tmp83_);
																																result = (ValaDataType*) _tmp84_;
																																_g_free0 (n);
																																_vala_code_node_unref0 (type);
																																if (direction) {
																																	*direction = _direction;
																																}
																																return result;
																															}
																														} else {
																															if (g_strcmp0 (n, "gushort") == 0) {
																																ValaUnresolvedSymbol* _tmp85_ = NULL;
																																ValaUnresolvedSymbol* _tmp86_;
																																_tmp85_ = vala_unresolved_symbol_new (NULL, "ushort", NULL);
																																_tmp86_ = _tmp85_;
																																vala_unresolved_type_set_unresolved_symbol (type, _tmp86_);
																																_vala_code_node_unref0 (_tmp86_);
																															} else {
																																if (g_strcmp0 (n, "gshort") == 0) {
																																	ValaUnresolvedSymbol* _tmp87_ = NULL;
																																	ValaUnresolvedSymbol* _tmp88_;
																																	_tmp87_ = vala_unresolved_symbol_new (NULL, "short", NULL);
																																	_tmp88_ = _tmp87_;
																																	vala_unresolved_type_set_unresolved_symbol (type, _tmp88_);
																																	_vala_code_node_unref0 (_tmp88_);
																																} else {
																																	gboolean _tmp89_ = FALSE;
																																	if (g_strcmp0 (n, "gconstpointer") == 0) {
																																		_tmp89_ = TRUE;
																																	} else {
																																		_tmp89_ = g_strcmp0 (n, "void") == 0;
																																	}
																																	if (_tmp89_) {
																																		ValaVoidType* _tmp90_ = NULL;
																																		ValaVoidType* _tmp91_;
																																		ValaPointerType* _tmp92_ = NULL;
																																		ValaDataType* _tmp93_;
																																		_tmp90_ = vala_void_type_new (NULL);
																																		_tmp91_ = _tmp90_;
																																		_tmp92_ = vala_pointer_type_new ((ValaDataType*) _tmp91_, NULL);
																																		result = (_tmp93_ = (ValaDataType*) _tmp92_, _vala_code_node_unref0 (_tmp91_), _tmp93_);
																																		_g_free0 (n);
																																		_vala_code_node_unref0 (type);
																																		if (direction) {
																																			*direction = _direction;
																																		}
																																		return result;
																																	} else {
																																		gboolean _tmp94_ = FALSE;
																																		if (g_strcmp0 (n, "goffset") == 0) {
																																			_tmp94_ = TRUE;
																																		} else {
																																			_tmp94_ = g_strcmp0 (n, "off_t") == 0;
																																		}
																																		if (_tmp94_) {
																																			ValaUnresolvedSymbol* _tmp95_ = NULL;
																																			ValaUnresolvedSymbol* _tmp96_;
																																			_tmp95_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
																																			_tmp96_ = _tmp95_;
																																			vala_unresolved_type_set_unresolved_symbol (type, _tmp96_);
																																			_vala_code_node_unref0 (_tmp96_);
																																		} else {
																																			if (g_strcmp0 (n, "value_array") == 0) {
																																				ValaUnresolvedSymbol* _tmp97_ = NULL;
																																				ValaUnresolvedSymbol* _tmp98_;
																																				ValaUnresolvedSymbol* _tmp99_ = NULL;
																																				ValaUnresolvedSymbol* _tmp100_;
																																				_tmp97_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																				_tmp98_ = _tmp97_;
																																				_tmp99_ = vala_unresolved_symbol_new (_tmp98_, "ValueArray", NULL);
																																				_tmp100_ = _tmp99_;
																																				vala_unresolved_type_set_unresolved_symbol (type, _tmp100_);
																																				_vala_code_node_unref0 (_tmp100_);
																																				_vala_code_node_unref0 (_tmp98_);
																																			} else {
																																				if (g_strcmp0 (n, "time_t") == 0) {
																																					ValaUnresolvedSymbol* _tmp101_ = NULL;
																																					ValaUnresolvedSymbol* _tmp102_;
																																					_tmp101_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
																																					_tmp102_ = _tmp101_;
																																					vala_unresolved_type_set_unresolved_symbol (type, _tmp102_);
																																					_vala_code_node_unref0 (_tmp102_);
																																				} else {
																																					if (g_strcmp0 (n, "socklen_t") == 0) {
																																						ValaUnresolvedSymbol* _tmp103_ = NULL;
																																						ValaUnresolvedSymbol* _tmp104_;
																																						_tmp103_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
																																						_tmp104_ = _tmp103_;
																																						vala_unresolved_type_set_unresolved_symbol (type, _tmp104_);
																																						_vala_code_node_unref0 (_tmp104_);
																																					} else {
																																						if (g_strcmp0 (n, "mode_t") == 0) {
																																							ValaUnresolvedSymbol* _tmp105_ = NULL;
																																							ValaUnresolvedSymbol* _tmp106_;
																																							_tmp105_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																							_tmp106_ = _tmp105_;
																																							vala_unresolved_type_set_unresolved_symbol (type, _tmp106_);
																																							_vala_code_node_unref0 (_tmp106_);
																																						} else {
																																							gboolean _tmp107_ = FALSE;
																																							if (g_strcmp0 (n, "gint") == 0) {
																																								_tmp107_ = TRUE;
																																							} else {
																																								_tmp107_ = g_strcmp0 (n, "pid_t") == 0;
																																							}
																																							if (_tmp107_) {
																																								ValaUnresolvedSymbol* _tmp108_ = NULL;
																																								ValaUnresolvedSymbol* _tmp109_;
																																								_tmp108_ = vala_unresolved_symbol_new (NULL, "int", NULL);
																																								_tmp109_ = _tmp108_;
																																								vala_unresolved_type_set_unresolved_symbol (type, _tmp109_);
																																								_vala_code_node_unref0 (_tmp109_);
																																							} else {
																																								gboolean _tmp110_ = FALSE;
																																								if (g_strcmp0 (n, "unsigned") == 0) {
																																									_tmp110_ = TRUE;
																																								} else {
																																									_tmp110_ = g_strcmp0 (n, "unsigned-int") == 0;
																																								}
																																								if (_tmp110_) {
																																									ValaUnresolvedSymbol* _tmp111_ = NULL;
																																									ValaUnresolvedSymbol* _tmp112_;
																																									_tmp111_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																									_tmp112_ = _tmp111_;
																																									vala_unresolved_type_set_unresolved_symbol (type, _tmp112_);
																																									_vala_code_node_unref0 (_tmp112_);
																																								} else {
																																									if (g_strcmp0 (n, "FILE") == 0) {
																																										ValaUnresolvedSymbol* _tmp113_ = NULL;
																																										ValaUnresolvedSymbol* _tmp114_;
																																										ValaUnresolvedSymbol* _tmp115_ = NULL;
																																										ValaUnresolvedSymbol* _tmp116_;
																																										_tmp113_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																										_tmp114_ = _tmp113_;
																																										_tmp115_ = vala_unresolved_symbol_new (_tmp114_, "FileStream", NULL);
																																										_tmp116_ = _tmp115_;
																																										vala_unresolved_type_set_unresolved_symbol (type, _tmp116_);
																																										_vala_code_node_unref0 (_tmp116_);
																																										_vala_code_node_unref0 (_tmp114_);
																																									} else {
																																										if (g_strcmp0 (n, "struct") == 0) {
																																											ValaVoidType* _tmp117_ = NULL;
																																											ValaVoidType* _tmp118_;
																																											ValaPointerType* _tmp119_ = NULL;
																																											ValaDataType* _tmp120_;
																																											_tmp117_ = vala_void_type_new (NULL);
																																											_tmp118_ = _tmp117_;
																																											_tmp119_ = vala_pointer_type_new ((ValaDataType*) _tmp118_, NULL);
																																											result = (_tmp120_ = (ValaDataType*) _tmp119_, _vala_code_node_unref0 (_tmp118_), _tmp120_);
																																											_g_free0 (n);
																																											_vala_code_node_unref0 (type);
																																											if (direction) {
																																												*direction = _direction;
																																											}
																																											return result;
																																										} else {
																																											if (g_strcmp0 (n, "iconv_t") == 0) {
																																												ValaVoidType* _tmp121_ = NULL;
																																												ValaVoidType* _tmp122_;
																																												ValaPointerType* _tmp123_ = NULL;
																																												ValaDataType* _tmp124_;
																																												_tmp121_ = vala_void_type_new (NULL);
																																												_tmp122_ = _tmp121_;
																																												_tmp123_ = vala_pointer_type_new ((ValaDataType*) _tmp122_, NULL);
																																												result = (_tmp124_ = (ValaDataType*) _tmp123_, _vala_code_node_unref0 (_tmp122_), _tmp124_);
																																												_g_free0 (n);
																																												_vala_code_node_unref0 (type);
																																												if (direction) {
																																													*direction = _direction;
																																												}
																																												return result;
																																											} else {
																																												if (g_strcmp0 (n, "GType") == 0) {
																																													ValaUnresolvedSymbol* _tmp125_ = NULL;
																																													ValaUnresolvedSymbol* _tmp126_;
																																													ValaUnresolvedSymbol* _tmp127_ = NULL;
																																													ValaUnresolvedSymbol* _tmp128_;
																																													_tmp125_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																													_tmp126_ = _tmp125_;
																																													_tmp127_ = vala_unresolved_symbol_new (_tmp126_, "Type", NULL);
																																													_tmp128_ = _tmp127_;
																																													vala_unresolved_type_set_unresolved_symbol (type, _tmp128_);
																																													_vala_code_node_unref0 (_tmp128_);
																																													_vala_code_node_unref0 (_tmp126_);
																																													if (type_node->is_pointer) {
																																														ValaSourceReference* _tmp129_ = NULL;
																																														ValaArrayType* _tmp130_ = NULL;
																																														_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
																																														_tmp130_ = vala_array_type_new ((ValaDataType*) type, 1, _tmp129_);
																																														result = (ValaDataType*) _tmp130_;
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														if (direction) {
																																															*direction = _direction;
																																														}
																																														return result;
																																													}
																																												} else {
																																													if (g_strcmp0 (n, "GStrv") == 0) {
																																														ValaUnresolvedSymbol* _tmp131_ = NULL;
																																														ValaUnresolvedSymbol* _tmp132_;
																																														ValaSourceReference* _tmp133_ = NULL;
																																														ValaArrayType* _tmp134_ = NULL;
																																														_tmp131_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																																														_tmp132_ = _tmp131_;
																																														vala_unresolved_type_set_unresolved_symbol (type, _tmp132_);
																																														_vala_code_node_unref0 (_tmp132_);
																																														_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
																																														_tmp134_ = vala_array_type_new ((ValaDataType*) type, 1, _tmp133_);
																																														result = (ValaDataType*) _tmp134_;
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														if (direction) {
																																															*direction = _direction;
																																														}
																																														return result;
																																													} else {
																																														ValaDataType* _tmp135_ = NULL;
																																														ValaDataType* named_type;
																																														ValaDataType* _tmp136_;
																																														ValaUnresolvedType* _tmp137_;
																																														ValaUnresolvedType* _tmp138_;
																																														gboolean _tmp139_;
																																														_tmp135_ = vala_gidl_parser_parse_type_string (self, n);
																																														named_type = _tmp135_;
																																														_tmp137_ = _vala_code_node_ref0 ((_tmp136_ = named_type, VALA_IS_UNRESOLVED_TYPE (_tmp136_) ? ((ValaUnresolvedType*) _tmp136_) : NULL));
																																														_tmp138_ = _tmp137_;
																																														_vala_code_node_unref0 (type);
																																														type = _tmp138_;
																																														if (type == NULL) {
																																															result = named_type;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															if (direction) {
																																																*direction = _direction;
																																															}
																																															return result;
																																														}
																																														_tmp139_ = vala_gidl_parser_is_simple_type (self, n);
																																														if (_tmp139_) {
																																															if (type_node->is_pointer) {
																																																dir = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														} else {
																																															gboolean _tmp140_;
																																															_tmp140_ = g_str_has_suffix (type_node->unparsed, "**");
																																															if (_tmp140_) {
																																																dir = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														}
																																														_vala_code_node_unref0 (named_type);
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																											_g_free0 (n);
																										} else {
																											fprintf (stdout, "%d\n", (gint) type_node->tag);
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if ((&_direction) != NULL) {
		_direction = dir;
	}
	result = (ValaDataType*) type;
	if (direction) {
		*direction = _direction;
	}
	return result;
}


static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const gchar* type_name) {
	gboolean result = FALSE;
	gpointer _tmp0_ = NULL;
	ValaTypeSymbol* _tmp1_;
	ValaStruct* st;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_name != NULL, FALSE);
	_tmp0_ = vala_map_get (self->priv->cname_type_map, type_name);
	st = (_tmp1_ = (ValaTypeSymbol*) _tmp0_, VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL);
	if (st != NULL) {
		gboolean _tmp3_;
		_tmp3_ = vala_struct_is_simple_type (st);
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (st);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const gchar* n) {
	ValaDataType* result = NULL;
	ValaUnresolvedType* _tmp4_ = NULL;
	ValaUnresolvedType* type;
	gpointer _tmp5_ = NULL;
	ValaTypeSymbol* dt;
	gint _tmp15_;
	gchar** _tmp16_ = NULL;
	gchar** type_attributes;
	gint type_attributes_length1;
	gint _type_attributes_size_;
	gchar* ns_name;
	ValaUnresolvedSymbol* _tmp37_ = NULL;
	const gchar* _tmp47_ = NULL;
	gboolean _tmp48_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	if (g_strcmp0 (n, "va_list") == 0) {
		ValaVoidType* _tmp0_ = NULL;
		ValaVoidType* _tmp1_;
		ValaPointerType* _tmp2_ = NULL;
		ValaDataType* _tmp3_;
		_tmp0_ = vala_void_type_new (NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_pointer_type_new ((ValaDataType*) _tmp1_, NULL);
		result = (_tmp3_ = (ValaDataType*) _tmp2_, _vala_code_node_unref0 (_tmp1_), _tmp3_);
		return result;
	}
	_tmp4_ = vala_unresolved_type_new ();
	type = _tmp4_;
	_tmp5_ = vala_map_get (self->priv->cname_type_map, n);
	dt = (ValaTypeSymbol*) _tmp5_;
	if (dt != NULL) {
		ValaUnresolvedSymbol* parent_symbol;
		ValaSymbol* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp12_ = NULL;
		ValaUnresolvedSymbol* _tmp13_ = NULL;
		ValaUnresolvedSymbol* _tmp14_;
		parent_symbol = NULL;
		_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) dt);
		_tmp7_ = vala_symbol_get_name (_tmp6_);
		if (_tmp7_ != NULL) {
			ValaSymbol* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			ValaUnresolvedSymbol* _tmp10_ = NULL;
			ValaUnresolvedSymbol* _tmp11_;
			_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) dt);
			_tmp9_ = vala_symbol_get_name (_tmp8_);
			_tmp10_ = vala_unresolved_symbol_new (NULL, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_vala_code_node_unref0 (parent_symbol);
			parent_symbol = _tmp11_;
		}
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) dt);
		_tmp13_ = vala_unresolved_symbol_new (parent_symbol, _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_unresolved_type_set_unresolved_symbol (type, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		result = (ValaDataType*) type;
		_vala_code_node_unref0 (parent_symbol);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp16_ = vala_gidl_parser_get_attributes (self, n, &_tmp15_);
	type_attributes = _tmp16_;
	type_attributes_length1 = _tmp15_;
	_type_attributes_size_ = _tmp15_;
	ns_name = NULL;
	if (NULL != type_attributes) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = type_attributes;
			attr_collection_length1 = type_attributes_length1;
			for (attr_it = 0; attr_it < type_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp17_;
				gchar* attr;
				_tmp17_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp17_;
				{
					gchar** _tmp18_;
					gchar** _tmp19_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp19_ = _tmp18_ = g_strsplit (attr, "=", 2);
					nv = _tmp19_;
					nv_length1 = _vala_array_length (_tmp18_);
					_nv_size_ = _vala_array_length (_tmp18_);
					if (g_strcmp0 (nv[0], "cprefix") == 0) {
						gchar* _tmp20_ = NULL;
						gchar* _tmp21_;
						gint _tmp22_;
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_;
						ValaUnresolvedSymbol* _tmp25_ = NULL;
						ValaUnresolvedSymbol* _tmp26_;
						_tmp20_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp21_ = _tmp20_;
						_tmp22_ = strlen (_tmp21_);
						_tmp23_ = string_substring (n, (glong) _tmp22_, (glong) (-1));
						_tmp24_ = _tmp23_;
						_tmp25_ = vala_unresolved_symbol_new (NULL, _tmp24_, NULL);
						_tmp26_ = _tmp25_;
						vala_unresolved_type_set_unresolved_symbol (type, _tmp26_);
						_vala_code_node_unref0 (_tmp26_);
						_g_free0 (_tmp24_);
						_g_free0 (_tmp21_);
					} else {
						if (g_strcmp0 (nv[0], "name") == 0) {
							gchar* _tmp27_ = NULL;
							gchar* _tmp28_;
							ValaUnresolvedSymbol* _tmp29_ = NULL;
							ValaUnresolvedSymbol* _tmp30_;
							_tmp27_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp28_ = _tmp27_;
							_tmp29_ = vala_unresolved_symbol_new (NULL, _tmp28_, NULL);
							_tmp30_ = _tmp29_;
							vala_unresolved_type_set_unresolved_symbol (type, _tmp30_);
							_vala_code_node_unref0 (_tmp30_);
							_g_free0 (_tmp28_);
						} else {
							if (g_strcmp0 (nv[0], "namespace") == 0) {
								gchar* _tmp31_ = NULL;
								gchar* _tmp32_;
								_tmp31_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp32_ = _tmp31_;
								_g_free0 (ns_name);
								ns_name = _tmp32_;
							} else {
								if (g_strcmp0 (nv[0], "rename_to") == 0) {
									gchar* _tmp33_ = NULL;
									gchar* _tmp34_;
									ValaUnresolvedSymbol* _tmp35_ = NULL;
									ValaUnresolvedSymbol* _tmp36_;
									_tmp33_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp34_ = _tmp33_;
									_tmp35_ = vala_unresolved_symbol_new (NULL, _tmp34_, NULL);
									_tmp36_ = _tmp35_;
									vala_unresolved_type_set_unresolved_symbol (type, _tmp36_);
									_vala_code_node_unref0 (_tmp36_);
									_g_free0 (_tmp34_);
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp37_ = vala_unresolved_type_get_unresolved_symbol (type);
	if (_tmp37_ != NULL) {
		ValaUnresolvedSymbol* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		_tmp38_ = vala_unresolved_type_get_unresolved_symbol (type);
		_tmp39_ = vala_symbol_get_name ((ValaSymbol*) _tmp38_);
		if (g_strcmp0 (_tmp39_, "pointer") == 0) {
			ValaVoidType* _tmp40_ = NULL;
			ValaVoidType* _tmp41_;
			ValaPointerType* _tmp42_ = NULL;
			ValaDataType* _tmp43_;
			_tmp40_ = vala_void_type_new (NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_pointer_type_new ((ValaDataType*) _tmp41_, NULL);
			result = (_tmp43_ = (ValaDataType*) _tmp42_, _vala_code_node_unref0 (_tmp41_), _tmp43_);
			_g_free0 (ns_name);
			type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (dt);
			_vala_code_node_unref0 (type);
			return result;
		}
		if (ns_name != NULL) {
			ValaUnresolvedSymbol* _tmp44_ = NULL;
			ValaUnresolvedSymbol* _tmp45_ = NULL;
			ValaUnresolvedSymbol* _tmp46_;
			_tmp44_ = vala_unresolved_type_get_unresolved_symbol (type);
			_tmp45_ = vala_unresolved_symbol_new (NULL, ns_name, NULL);
			_tmp46_ = _tmp45_;
			vala_unresolved_symbol_set_inner (_tmp44_, _tmp46_);
			_vala_code_node_unref0 (_tmp46_);
		}
		result = (ValaDataType*) type;
		_g_free0 (ns_name);
		type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp47_ = vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace);
	_tmp48_ = g_str_has_prefix (n, _tmp47_);
	if (_tmp48_) {
		const gchar* _tmp49_ = NULL;
		ValaUnresolvedSymbol* _tmp50_ = NULL;
		ValaUnresolvedSymbol* _tmp51_;
		const gchar* _tmp52_ = NULL;
		gint _tmp53_;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_;
		ValaUnresolvedSymbol* _tmp56_ = NULL;
		ValaUnresolvedSymbol* _tmp57_;
		_tmp49_ = vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace);
		_tmp50_ = vala_unresolved_symbol_new (NULL, _tmp49_, NULL);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace);
		_tmp53_ = strlen (_tmp52_);
		_tmp54_ = string_substring (n, (glong) _tmp53_, (glong) (-1));
		_tmp55_ = _tmp54_;
		_tmp56_ = vala_unresolved_symbol_new (_tmp51_, _tmp55_, NULL);
		_tmp57_ = _tmp56_;
		vala_unresolved_type_set_unresolved_symbol (type, _tmp57_);
		_vala_code_node_unref0 (_tmp57_);
		_g_free0 (_tmp55_);
		_vala_code_node_unref0 (_tmp51_);
	} else {
		gboolean _tmp58_;
		_tmp58_ = g_str_has_prefix (n, "G");
		if (_tmp58_) {
			ValaUnresolvedSymbol* _tmp59_ = NULL;
			ValaUnresolvedSymbol* _tmp60_;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_;
			ValaUnresolvedSymbol* _tmp63_ = NULL;
			ValaUnresolvedSymbol* _tmp64_;
			_tmp59_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp60_ = _tmp59_;
			_tmp61_ = string_substring (n, (glong) 1, (glong) (-1));
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_unresolved_symbol_new (_tmp60_, _tmp62_, NULL);
			_tmp64_ = _tmp63_;
			vala_unresolved_type_set_unresolved_symbol (type, _tmp64_);
			_vala_code_node_unref0 (_tmp64_);
			_g_free0 (_tmp62_);
			_vala_code_node_unref0 (_tmp60_);
		} else {
			gchar** _tmp65_;
			gchar** _tmp66_ = NULL;
			gchar** name_parts;
			gint name_parts_length1;
			gint _name_parts_size_;
			_tmp66_ = _tmp65_ = g_strsplit (n, ".", 2);
			name_parts = _tmp66_;
			name_parts_length1 = _vala_array_length (_tmp65_);
			_name_parts_size_ = _vala_array_length (_tmp65_);
			if (name_parts[1] == NULL) {
				ValaUnresolvedSymbol* _tmp67_ = NULL;
				ValaUnresolvedSymbol* _tmp68_;
				_tmp67_ = vala_unresolved_symbol_new (NULL, name_parts[0], NULL);
				_tmp68_ = _tmp67_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp68_);
				_vala_code_node_unref0 (_tmp68_);
			} else {
				ValaUnresolvedSymbol* _tmp69_ = NULL;
				ValaUnresolvedSymbol* _tmp70_;
				ValaUnresolvedSymbol* _tmp71_ = NULL;
				ValaUnresolvedSymbol* _tmp72_;
				_tmp69_ = vala_unresolved_symbol_new (NULL, name_parts[0], NULL);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_unresolved_symbol_new (_tmp70_, name_parts[1], NULL);
				_tmp72_ = _tmp71_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp72_);
				_vala_code_node_unref0 (_tmp72_);
				_vala_code_node_unref0 (_tmp70_);
			}
			name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	result = (ValaDataType*) type;
	_g_free0 (ns_name);
	type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (dt);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction) {
	ValaParameterDirection _direction = 0;
	ValaDataType* result = NULL;
	ValaParameterDirection _tmp0_;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	_tmp1_ = vala_gidl_parser_parse_type (self, param->type, &_tmp0_);
	_direction = _tmp0_;
	type = _tmp1_;
	result = type;
	if (direction) {
		*direction = _direction;
	}
	return result;
}


static ValaUnresolvedSymbol* vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self, const gchar* symbol_string, ValaSourceReference* source_reference) {
	ValaUnresolvedSymbol* result = NULL;
	ValaUnresolvedSymbol* sym;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (symbol_string, ".", 0);
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = _tmp1_;
		s_collection_length1 = _vala_array_length (_tmp0_);
		for (s_it = 0; s_it < _vala_array_length (_tmp0_); s_it = s_it + 1) {
			const gchar* s;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp2_ = NULL;
				ValaUnresolvedSymbol* _tmp3_;
				_tmp2_ = vala_unresolved_symbol_new (sym, s, source_reference);
				_tmp3_ = _tmp2_;
				_vala_code_node_unref0 (sym);
				sym = _tmp3_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (sym == NULL) {
		vala_report_error (source_reference, "a symbol must be specified");
	}
	result = sym;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gboolean vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self, ValaDataType* parent_type, const gchar* type_arguments, ValaSourceReference* source_reference) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint type_arguments_length;
	GString* _tmp1_ = NULL;
	GString* current;
	gint depth;
	ValaDataType* _tmp15_ = NULL;
	ValaDataType* dt;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = strlen (type_arguments);
	type_arguments_length = (gint) _tmp0_;
	_tmp1_ = g_string_sized_new ((gsize) type_arguments_length);
	current = _tmp1_;
	depth = 0;
	{
		gint c;
		c = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gchar _tmp4_;
				if (!_tmp2_) {
					c++;
				}
				_tmp2_ = FALSE;
				if (!(c < type_arguments_length)) {
					break;
				}
				_tmp4_ = string_get (type_arguments, (glong) c);
				if (_tmp4_ == '<') {
					_tmp3_ = TRUE;
				} else {
					gchar _tmp5_;
					_tmp5_ = string_get (type_arguments, (glong) c);
					_tmp3_ = _tmp5_ == '[';
				}
				if (_tmp3_) {
					gchar _tmp6_;
					depth++;
					_tmp6_ = string_get (type_arguments, (glong) c);
					g_string_append_unichar (current, (gunichar) _tmp6_);
				} else {
					gboolean _tmp7_ = FALSE;
					gchar _tmp8_;
					_tmp8_ = string_get (type_arguments, (glong) c);
					if (_tmp8_ == '>') {
						_tmp7_ = TRUE;
					} else {
						gchar _tmp9_;
						_tmp9_ = string_get (type_arguments, (glong) c);
						_tmp7_ = _tmp9_ == ']';
					}
					if (_tmp7_) {
						gchar _tmp10_;
						depth--;
						_tmp10_ = string_get (type_arguments, (glong) c);
						g_string_append_unichar (current, (gunichar) _tmp10_);
					} else {
						gchar _tmp11_;
						_tmp11_ = string_get (type_arguments, (glong) c);
						if (_tmp11_ == ',') {
							if (depth == 0) {
								ValaDataType* _tmp12_ = NULL;
								ValaDataType* dt;
								_tmp12_ = vala_gidl_parser_parse_type_from_string (self, current->str, TRUE, source_reference);
								dt = _tmp12_;
								if (dt == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								vala_data_type_add_type_argument (parent_type, dt);
								g_string_truncate (current, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								gchar _tmp13_;
								_tmp13_ = string_get (type_arguments, (glong) c);
								g_string_append_unichar (current, (gunichar) _tmp13_);
							}
						} else {
							gchar _tmp14_;
							_tmp14_ = string_get (type_arguments, (glong) c);
							g_string_append_unichar (current, (gunichar) _tmp14_);
						}
					}
				}
			}
		}
	}
	_tmp15_ = vala_gidl_parser_parse_type_from_string (self, current->str, TRUE, source_reference);
	dt = _tmp15_;
	if (dt == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	vala_data_type_add_type_argument (parent_type, dt);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self, const gchar* type_string, gboolean owned_by_default, ValaSourceReference* source_reference) {
	ValaDataType* result = NULL;
	GMatchInfo* match = NULL;
	GMatchInfo* _tmp3_ = NULL;
	gboolean _tmp4_;
	ValaDataType* type;
	gchar* _tmp5_ = NULL;
	gchar* ownership_data;
	gchar* _tmp6_ = NULL;
	gchar* type_name;
	gchar* _tmp7_ = NULL;
	gchar* type_arguments_data;
	gchar* _tmp8_ = NULL;
	gchar* pointers_data;
	gchar* _tmp9_ = NULL;
	gchar* array_data;
	gchar* _tmp10_ = NULL;
	gchar* array_dimension_data;
	gchar* _tmp11_ = NULL;
	gchar* nullable_data;
	gboolean _tmp12_ = FALSE;
	gboolean nullable;
	gboolean _tmp14_ = FALSE;
	gboolean value_owned;
	ValaUnresolvedSymbol* _tmp22_ = NULL;
	ValaUnresolvedSymbol* sym;
	ValaUnresolvedType* _tmp23_ = NULL;
	ValaDataType* _tmp24_;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp32_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	if (vala_gidl_parser_type_from_string_regex == NULL) {
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp0_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[(," \
"*)?\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp1_;
		_g_regex_unref0 (vala_gidl_parser_type_from_string_regex);
		vala_gidl_parser_type_from_string_regex = _tmp2_;
		goto __finally2;
		__catch2_g_regex_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_error ("valagidlparser.vala:1851: Unable to compile regex: %s", e->message);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = g_regex_match (vala_gidl_parser_type_from_string_regex, type_string, 0, &_tmp3_);
	_g_match_info_free0 (match);
	match = _tmp3_;
	if (!_tmp4_) {
		vala_report_error (source_reference, "unable to parse type");
		result = NULL;
		_g_match_info_free0 (match);
		return result;
	}
	type = NULL;
	_tmp5_ = g_match_info_fetch (match, 1);
	ownership_data = _tmp5_;
	_tmp6_ = g_match_info_fetch (match, 2);
	type_name = _tmp6_;
	_tmp7_ = g_match_info_fetch (match, 3);
	type_arguments_data = _tmp7_;
	_tmp8_ = g_match_info_fetch (match, 4);
	pointers_data = _tmp8_;
	_tmp9_ = g_match_info_fetch (match, 5);
	array_data = _tmp9_;
	_tmp10_ = g_match_info_fetch (match, 6);
	array_dimension_data = _tmp10_;
	_tmp11_ = g_match_info_fetch (match, 7);
	nullable_data = _tmp11_;
	if (nullable_data != NULL) {
		gint _tmp13_;
		_tmp13_ = strlen (nullable_data);
		_tmp12_ = _tmp13_ > 0;
	} else {
		_tmp12_ = FALSE;
	}
	nullable = _tmp12_;
	if (ownership_data == NULL) {
		_tmp14_ = g_strcmp0 (type_name, "void") == 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gboolean _tmp15_ = FALSE;
		if (array_data == NULL) {
			_tmp15_ = !nullable;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValaVoidType* _tmp16_ = NULL;
			ValaDataType* _tmp17_;
			_tmp16_ = vala_void_type_new (source_reference);
			_tmp17_ = (ValaDataType*) _tmp16_;
			_vala_code_node_unref0 (type);
			type = _tmp17_;
			if (pointers_data != NULL) {
				{
					gint i;
					i = 0;
					{
						gboolean _tmp18_;
						_tmp18_ = TRUE;
						while (TRUE) {
							gint _tmp19_;
							ValaPointerType* _tmp20_ = NULL;
							ValaDataType* _tmp21_;
							if (!_tmp18_) {
								i++;
							}
							_tmp18_ = FALSE;
							_tmp19_ = strlen (pointers_data);
							if (!(i < _tmp19_)) {
								break;
							}
							_tmp20_ = vala_pointer_type_new (type, NULL);
							_tmp21_ = (ValaDataType*) _tmp20_;
							_vala_code_node_unref0 (type);
							type = _tmp21_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_free0 (match);
			return result;
		} else {
			vala_report_error (source_reference, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_free0 (match);
			return result;
		}
	}
	value_owned = owned_by_default;
	if (g_strcmp0 (ownership_data, "owned") == 0) {
		value_owned = TRUE;
	} else {
		if (g_strcmp0 (ownership_data, "unowned") == 0) {
			value_owned = FALSE;
		}
	}
	_tmp22_ = vala_gidl_parser_parse_symbol_from_string (self, type_name, source_reference);
	sym = _tmp22_;
	if (sym == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_dimension_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_free0 (match);
		return result;
	}
	_tmp23_ = vala_unresolved_type_new_from_symbol (sym, source_reference);
	_tmp24_ = (ValaDataType*) _tmp23_;
	_vala_code_node_unref0 (type);
	type = _tmp24_;
	if (type_arguments_data != NULL) {
		gint _tmp26_;
		_tmp26_ = strlen (type_arguments_data);
		_tmp25_ = _tmp26_ > 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gboolean _tmp27_;
		_tmp27_ = vala_gidl_parser_parse_type_arguments_from_string (self, type, type_arguments_data, source_reference);
		if (!_tmp27_) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_free0 (match);
			return result;
		}
	}
	if (pointers_data != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp28_;
				_tmp28_ = TRUE;
				while (TRUE) {
					gint _tmp29_;
					ValaPointerType* _tmp30_ = NULL;
					ValaDataType* _tmp31_;
					if (!_tmp28_) {
						i++;
					}
					_tmp28_ = FALSE;
					_tmp29_ = strlen (pointers_data);
					if (!(i < _tmp29_)) {
						break;
					}
					_tmp30_ = vala_pointer_type_new (type, NULL);
					_tmp31_ = (ValaDataType*) _tmp30_;
					_vala_code_node_unref0 (type);
					type = _tmp31_;
				}
			}
		}
	}
	if (array_data != NULL) {
		gint _tmp33_;
		_tmp33_ = strlen (array_data);
		_tmp32_ = _tmp33_ > 0;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		gint _tmp34_;
		ValaArrayType* _tmp35_ = NULL;
		ValaDataType* _tmp36_;
		_tmp34_ = strlen (array_dimension_data);
		_tmp35_ = vala_array_type_new (type, _tmp34_ + 1, source_reference);
		_tmp36_ = (ValaDataType*) _tmp35_;
		_vala_code_node_unref0 (type);
		type = _tmp36_;
	}
	vala_data_type_set_nullable (type, nullable);
	vala_data_type_set_value_owned (type, value_owned);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_dimension_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_free0 (match);
	return result;
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, (guint) 0);
	endptr = _tmp0_;
	_result = _tmp1_;
	_tmp2_ = strlen (str);
	if (endptr == (((gchar*) str) + _tmp2_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _result;
	}
}


static gboolean double_try_parse (const gchar* str, gdouble* _result_) {
	gdouble _result = 0.0;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_result = _tmp1_;
	_tmp2_ = strlen (str);
	if (endptr == (((gchar*) str) + _tmp2_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _result;
	}
}


static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const gchar* name, const gchar* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface) {
	ValaMethod* result = NULL;
	ValaDataType* return_type;
	ValaMethod* m = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean add_ellipsis;
	gboolean suppress_throws;
	gchar* error_types;
	gint _tmp35_;
	gchar** _tmp36_ = NULL;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gboolean first;
	ValaParameter* last_param;
	ValaDataType* last_param_type;
	gboolean _tmp280_ = FALSE;
	gboolean _tmp289_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	return_type = NULL;
	if (res != NULL) {
		ValaDataType* _tmp0_ = NULL;
		ValaDataType* _tmp1_;
		_tmp0_ = vala_gidl_parser_parse_param (self, res, NULL);
		_tmp1_ = _tmp0_;
		_vala_code_node_unref0 (return_type);
		return_type = _tmp1_;
	}
	if (!is_interface) {
		gboolean _tmp3_ = FALSE;
		if (is_constructor) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp4_;
			_tmp4_ = g_str_has_prefix (name, "new");
			_tmp3_ = _tmp4_;
		}
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaCreationMethod* _tmp5_ = NULL;
		ValaMethod* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp5_ = vala_creation_method_new (NULL, name, self->priv->current_source_reference, NULL);
		_tmp6_ = (ValaMethod*) _tmp5_;
		_vala_code_node_unref0 (m);
		m = _tmp6_;
		vala_method_set_has_construct_function (m, FALSE);
		_tmp7_ = vala_symbol_get_name ((ValaSymbol*) m);
		if (g_strcmp0 (_tmp7_, "new") == 0) {
			vala_symbol_set_name ((ValaSymbol*) m, NULL);
		} else {
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_;
			_tmp8_ = vala_symbol_get_name ((ValaSymbol*) m);
			_tmp9_ = g_str_has_prefix (_tmp8_, "new_");
			if (_tmp9_) {
				const gchar* _tmp10_ = NULL;
				gint _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp10_ = vala_symbol_get_name ((ValaSymbol*) m);
				_tmp11_ = strlen ("new_");
				_tmp12_ = string_substring (_tmp10_, (glong) _tmp11_, (glong) (-1));
				_tmp13_ = _tmp12_;
				vala_symbol_set_name ((ValaSymbol*) m, _tmp13_);
				_g_free0 (_tmp13_);
			}
		}
		if (VALA_IS_CLASS (self->priv->current_data_type)) {
			_tmp14_ = res != NULL;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gboolean _tmp19_;
			_tmp15_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup_printf ("%s*", _tmp16_);
			_tmp18_ = _tmp17_;
			if ((_tmp19_ = g_strcmp0 (_tmp18_, res->type->unparsed) != 0, _g_free0 (_tmp18_), _g_free0 (_tmp16_), _tmp19_)) {
				vala_creation_method_set_custom_return_type_cname (VALA_CREATION_METHOD (m), res->type->unparsed);
			}
		}
	} else {
		ValaMethod* _tmp20_ = NULL;
		ValaMethod* _tmp21_;
		_tmp20_ = vala_method_new (name, return_type, self->priv->current_source_reference, NULL);
		_tmp21_ = _tmp20_;
		_vala_code_node_unref0 (m);
		m = _tmp21_;
	}
	vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (self->priv->current_type_symbol_set != NULL) {
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, name);
	}
	if (self->priv->current_data_type != NULL) {
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		gint _tmp26_;
		gchar** _tmp27_ = NULL;
		gchar** _tmp28_;
		gchar** sig_attributes;
		gint sig_attributes_length1;
		gint _sig_attributes_size_;
		_tmp22_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("%s::%s", _tmp23_, name);
		_tmp25_ = _tmp24_;
		_tmp27_ = vala_gidl_parser_get_attributes (self, _tmp25_, &_tmp26_);
		sig_attributes = (_tmp28_ = _tmp27_, _g_free0 (_tmp25_), _g_free0 (_tmp23_), _tmp28_);
		sig_attributes_length1 = _tmp26_;
		_sig_attributes_size_ = _tmp26_;
		if (sig_attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = sig_attributes;
				attr_collection_length1 = sig_attributes_length1;
				for (attr_it = 0; attr_it < sig_attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp29_;
					gchar* attr;
					_tmp29_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp29_;
					{
						gchar** _tmp30_;
						gchar** _tmp31_ = NULL;
						gchar** nv;
						gint nv_length1;
						gint _nv_size_;
						gboolean _tmp32_ = FALSE;
						_tmp31_ = _tmp30_ = g_strsplit (attr, "=", 2);
						nv = _tmp31_;
						nv_length1 = _vala_array_length (_tmp30_);
						_nv_size_ = _vala_array_length (_tmp30_);
						if (g_strcmp0 (nv[0], "has_emitter") == 0) {
							gchar* _tmp33_ = NULL;
							gchar* _tmp34_;
							_tmp33_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp34_ = _tmp33_;
							_tmp32_ = g_strcmp0 (_tmp34_, "1") == 0;
							_g_free0 (_tmp34_);
						} else {
							_tmp32_ = FALSE;
						}
						if (_tmp32_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (return_type);
							return result;
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	add_ellipsis = FALSE;
	suppress_throws = FALSE;
	error_types = NULL;
	_tmp36_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp35_);
	attributes = _tmp36_;
	attributes_length1 = _tmp35_;
	_attributes_size_ = _tmp35_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp37_;
				gchar* attr;
				_tmp37_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp37_;
				{
					gchar** _tmp38_;
					gchar** _tmp39_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp39_ = _tmp38_ = g_strsplit (attr, "=", 2);
					nv = _tmp39_;
					nv_length1 = _vala_array_length (_tmp38_);
					_nv_size_ = _vala_array_length (_tmp38_);
					if (g_strcmp0 (nv[0], "name") == 0) {
						const gchar* _tmp40_ = NULL;
						gchar* _tmp41_ = NULL;
						gchar* _tmp42_;
						_tmp40_ = vala_symbol_get_name ((ValaSymbol*) m);
						vala_method_set_cname (m, _tmp40_);
						_tmp41_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp42_ = _tmp41_;
						vala_symbol_set_name ((ValaSymbol*) m, _tmp42_);
						_g_free0 (_tmp42_);
					} else {
						if (g_strcmp0 (nv[0], "hidden") == 0) {
							gchar* _tmp43_ = NULL;
							gchar* _tmp44_;
							gboolean _tmp45_;
							_tmp43_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp44_ = _tmp43_;
							if ((_tmp45_ = g_strcmp0 (_tmp44_, "1") == 0, _g_free0 (_tmp44_), _tmp45_)) {
								result = NULL;
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
								attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (error_types);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (return_type);
								return result;
							}
						} else {
							if (g_strcmp0 (nv[0], "ellipsis") == 0) {
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_;
								gboolean _tmp48_;
								_tmp46_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp47_ = _tmp46_;
								if ((_tmp48_ = g_strcmp0 (_tmp47_, "1") == 0, _g_free0 (_tmp47_), _tmp48_)) {
									add_ellipsis = TRUE;
								}
							} else {
								if (g_strcmp0 (nv[0], "printf_format") == 0) {
									gchar* _tmp49_ = NULL;
									gchar* _tmp50_;
									gboolean _tmp51_;
									_tmp49_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp50_ = _tmp49_;
									if ((_tmp51_ = g_strcmp0 (_tmp50_, "1") == 0, _g_free0 (_tmp50_), _tmp51_)) {
										vala_method_set_printf_format (m, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
										gchar* _tmp52_ = NULL;
										gchar* _tmp53_;
										gboolean _tmp54_;
										_tmp52_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp53_ = _tmp52_;
										if ((_tmp54_ = g_strcmp0 (_tmp53_, "1") == 0, _g_free0 (_tmp53_), _tmp54_)) {
											vala_data_type_set_value_owned (return_type, TRUE);
										}
									} else {
										if (g_strcmp0 (nv[0], "nullable") == 0) {
											gchar* _tmp55_ = NULL;
											gchar* _tmp56_;
											gboolean _tmp57_;
											_tmp55_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp56_ = _tmp55_;
											if ((_tmp57_ = g_strcmp0 (_tmp56_, "1") == 0, _g_free0 (_tmp56_), _tmp57_)) {
												vala_data_type_set_nullable (return_type, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "sentinel") == 0) {
												gchar* _tmp58_ = NULL;
												gchar* _tmp59_;
												_tmp58_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp59_ = _tmp58_;
												vala_method_set_sentinel (m, _tmp59_);
												_g_free0 (_tmp59_);
											} else {
												if (g_strcmp0 (nv[0], "is_array") == 0) {
													gchar* _tmp60_ = NULL;
													gchar* _tmp61_;
													gboolean _tmp62_;
													_tmp60_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp61_ = _tmp60_;
													if ((_tmp62_ = g_strcmp0 (_tmp61_, "1") == 0, _g_free0 (_tmp61_), _tmp62_)) {
														ValaSourceReference* _tmp63_ = NULL;
														ValaArrayType* _tmp64_ = NULL;
														ValaDataType* _tmp65_;
														_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) return_type);
														_tmp64_ = vala_array_type_new (return_type, 1, _tmp63_);
														_tmp65_ = (ValaDataType*) _tmp64_;
														_vala_code_node_unref0 (return_type);
														return_type = _tmp65_;
														vala_method_set_return_type (m, return_type);
													}
												} else {
													if (g_strcmp0 (nv[0], "throws") == 0) {
														gchar* _tmp66_ = NULL;
														gchar* _tmp67_;
														gboolean _tmp68_;
														_tmp66_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp67_ = _tmp66_;
														if ((_tmp68_ = g_strcmp0 (_tmp67_, "0") == 0, _g_free0 (_tmp67_), _tmp68_)) {
															suppress_throws = TRUE;
														}
													} else {
														if (g_strcmp0 (nv[0], "error_types") == 0) {
															gchar* _tmp69_ = NULL;
															gchar* _tmp70_;
															_tmp69_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp70_ = _tmp69_;
															_g_free0 (error_types);
															error_types = _tmp70_;
														} else {
															if (g_strcmp0 (nv[0], "no_array_length") == 0) {
																gchar* _tmp71_ = NULL;
																gchar* _tmp72_;
																gboolean _tmp73_;
																_tmp71_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp72_ = _tmp71_;
																if ((_tmp73_ = g_strcmp0 (_tmp72_, "1") == 0, _g_free0 (_tmp72_), _tmp73_)) {
																	vala_method_set_no_array_length (m, TRUE);
																}
															} else {
																if (g_strcmp0 (nv[0], "array_null_terminated") == 0) {
																	gchar* _tmp74_ = NULL;
																	gchar* _tmp75_;
																	gboolean _tmp76_;
																	_tmp74_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp75_ = _tmp74_;
																	if ((_tmp76_ = g_strcmp0 (_tmp75_, "1") == 0, _g_free0 (_tmp75_), _tmp76_)) {
																		vala_method_set_no_array_length (m, TRUE);
																		vala_method_set_array_null_terminated (m, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "array_length_type") == 0) {
																		gchar* _tmp77_ = NULL;
																		gchar* _tmp78_;
																		_tmp77_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp78_ = _tmp77_;
																		vala_method_set_array_length_type (m, _tmp78_);
																		_g_free0 (_tmp78_);
																	} else {
																		if (g_strcmp0 (nv[0], "type_name") == 0) {
																			gchar* _tmp79_ = NULL;
																			gchar* _tmp80_;
																			gboolean _tmp81_;
																			ValaDataType* _tmp82_ = NULL;
																			ValaDataType* _tmp83_;
																			_tmp79_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp80_ = _tmp79_;
																			_tmp81_ = vala_data_type_get_value_owned (return_type);
																			_tmp82_ = vala_gidl_parser_parse_type_from_string (self, _tmp80_, _tmp81_, NULL);
																			_tmp83_ = _tmp82_;
																			_vala_code_node_unref0 (return_type);
																			return_type = _tmp83_;
																			vala_method_set_return_type (m, return_type);
																			_g_free0 (_tmp80_);
																		} else {
																			if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																				gchar* _tmp84_ = NULL;
																				gchar* _tmp85_;
																				_tmp84_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp85_ = _tmp84_;
																				vala_gidl_parser_parse_type_arguments_from_string (self, return_type, _tmp85_, NULL);
																				_g_free0 (_tmp85_);
																			} else {
																				if (g_strcmp0 (nv[0], "deprecated") == 0) {
																					gchar* _tmp86_ = NULL;
																					gchar* _tmp87_;
																					gboolean _tmp88_;
																					_tmp86_ = vala_gidl_parser_eval (self, nv[1]);
																					_tmp87_ = _tmp86_;
																					if ((_tmp88_ = g_strcmp0 (_tmp87_, "1") == 0, _g_free0 (_tmp87_), _tmp88_)) {
																						vala_symbol_set_deprecated ((ValaSymbol*) m, TRUE);
																					}
																				} else {
																					if (g_strcmp0 (nv[0], "replacement") == 0) {
																						gchar* _tmp89_ = NULL;
																						gchar* _tmp90_;
																						_tmp89_ = vala_gidl_parser_eval (self, nv[1]);
																						_tmp90_ = _tmp89_;
																						vala_symbol_set_replacement ((ValaSymbol*) m, _tmp90_);
																						_g_free0 (_tmp90_);
																					} else {
																						if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
																							gchar* _tmp91_ = NULL;
																							gchar* _tmp92_;
																							_tmp91_ = vala_gidl_parser_eval (self, nv[1]);
																							_tmp92_ = _tmp91_;
																							vala_symbol_set_deprecated_since ((ValaSymbol*) m, _tmp92_);
																							_g_free0 (_tmp92_);
																						} else {
																							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
																								gchar* _tmp93_ = NULL;
																								gchar* _tmp94_;
																								_tmp93_ = vala_gidl_parser_eval (self, nv[1]);
																								_tmp94_ = _tmp93_;
																								vala_symbol_add_cheader_filename ((ValaSymbol*) m, _tmp94_);
																								_g_free0 (_tmp94_);
																							} else {
																								if (g_strcmp0 (nv[0], "abstract") == 0) {
																									gchar* _tmp95_ = NULL;
																									gchar* _tmp96_;
																									gboolean _tmp97_;
																									_tmp95_ = vala_gidl_parser_eval (self, nv[1]);
																									_tmp96_ = _tmp95_;
																									if ((_tmp97_ = g_strcmp0 (_tmp96_, "1") == 0, _g_free0 (_tmp96_), _tmp97_)) {
																										vala_method_set_is_abstract (m, TRUE);
																									}
																								} else {
																									if (g_strcmp0 (nv[0], "virtual") == 0) {
																										gchar* _tmp98_ = NULL;
																										gchar* _tmp99_;
																										gboolean _tmp100_;
																										_tmp98_ = vala_gidl_parser_eval (self, nv[1]);
																										_tmp99_ = _tmp98_;
																										if ((_tmp100_ = g_strcmp0 (_tmp99_, "1") == 0, _g_free0 (_tmp99_), _tmp100_)) {
																											vala_method_set_is_virtual (m, TRUE);
																										}
																									} else {
																										if (g_strcmp0 (nv[0], "vfunc_name") == 0) {
																											gchar* _tmp101_ = NULL;
																											gchar* _tmp102_;
																											_tmp101_ = vala_gidl_parser_eval (self, nv[1]);
																											_tmp102_ = _tmp101_;
																											vala_method_set_vfunc_name (m, _tmp102_);
																											_g_free0 (_tmp102_);
																										} else {
																											if (g_strcmp0 (nv[0], "finish_name") == 0) {
																												gchar* _tmp103_ = NULL;
																												gchar* _tmp104_;
																												_tmp103_ = vala_gidl_parser_eval (self, nv[1]);
																												_tmp104_ = _tmp103_;
																												vala_method_set_finish_cname (m, _tmp104_);
																												_g_free0 (_tmp104_);
																											} else {
																												if (g_strcmp0 (nv[0], "async") == 0) {
																													gchar* _tmp105_ = NULL;
																													gchar* _tmp106_;
																													gboolean _tmp107_;
																													_tmp105_ = vala_gidl_parser_eval (self, nv[1]);
																													_tmp106_ = _tmp105_;
																													if ((_tmp107_ = g_strcmp0 (_tmp106_, "1") == 0, _g_free0 (_tmp106_), _tmp107_)) {
																														vala_method_set_coroutine (m, TRUE);
																													}
																												} else {
																													if (g_strcmp0 (nv[0], "parent") == 0) {
																														gchar* _tmp108_ = NULL;
																														gchar* _tmp109_;
																														ValaSymbol* _tmp110_ = NULL;
																														ValaSymbol* _tmp111_;
																														ValaSymbol* container;
																														gchar* _tmp112_ = NULL;
																														gchar* prefix;
																														gboolean _tmp113_;
																														_tmp108_ = vala_gidl_parser_eval (self, nv[1]);
																														_tmp109_ = _tmp108_;
																														_tmp110_ = vala_gidl_parser_get_container_from_name (self, _tmp109_);
																														container = (_tmp111_ = _tmp110_, _g_free0 (_tmp109_), _tmp111_);
																														_tmp112_ = vala_symbol_get_lower_case_cprefix (container);
																														prefix = _tmp112_;
																														_tmp113_ = g_str_has_prefix (symbol, prefix);
																														if (_tmp113_) {
																															const gchar* _tmp114_ = NULL;
																															gint _tmp115_;
																															gchar* _tmp116_ = NULL;
																															gchar* _tmp117_;
																															_tmp114_ = vala_symbol_get_name ((ValaSymbol*) m);
																															vala_method_set_cname (m, _tmp114_);
																															_tmp115_ = strlen (prefix);
																															_tmp116_ = string_substring (symbol, (glong) _tmp115_, (glong) (-1));
																															_tmp117_ = _tmp116_;
																															vala_symbol_set_name ((ValaSymbol*) m, _tmp117_);
																															_g_free0 (_tmp117_);
																														}
																														_g_free0 (prefix);
																														_vala_code_node_unref0 (container);
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_method_set_cname (m, symbol);
	first = TRUE;
	last_param = NULL;
	last_param_type = NULL;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				gboolean _tmp143_ = FALSE;
				gboolean _tmp147_ = FALSE;
				gchar* _tmp151_;
				gchar* param_name;
				ValaParameterDirection direction = 0;
				ValaParameterDirection _tmp156_;
				ValaDataType* _tmp157_ = NULL;
				ValaDataType* param_type;
				ValaParameter* _tmp158_ = NULL;
				ValaParameter* p;
				gboolean hide_param;
				gboolean show_param;
				gboolean set_array_length_pos;
				gdouble array_length_pos;
				gboolean set_delegate_target_pos;
				gdouble delegate_target_pos;
				gboolean array_requested;
				gboolean out_requested;
				gchar* _tmp159_ = NULL;
				gchar* _tmp160_;
				gint _tmp161_;
				gchar** _tmp162_ = NULL;
				gchar** _tmp163_;
				gboolean _tmp266_ = FALSE;
				gboolean _tmp275_ = FALSE;
				ValaParameter* _tmp276_;
				ValaParameter* _tmp277_;
				ValaDataType* _tmp278_;
				ValaDataType* _tmp279_;
				param_node = (GIdlNode*) param;
				if (first) {
					gboolean _tmp118_ = FALSE;
					gboolean _tmp119_ = FALSE;
					gboolean _tmp120_ = FALSE;
					first = FALSE;
					if (!VALA_IS_CREATION_METHOD (m)) {
						_tmp120_ = self->priv->current_data_type != NULL;
					} else {
						_tmp120_ = FALSE;
					}
					if (_tmp120_) {
						_tmp119_ = param->type->is_interface;
					} else {
						_tmp119_ = FALSE;
					}
					if (_tmp119_) {
						gboolean _tmp121_ = FALSE;
						if (g_strcmp0 (param_node->name, "self") == 0) {
							_tmp121_ = TRUE;
						} else {
							gchar* _tmp122_ = NULL;
							gchar* _tmp123_;
							gboolean _tmp124_;
							_tmp122_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
							_tmp123_ = _tmp122_;
							_tmp124_ = g_str_has_suffix (param->type->interface, _tmp123_);
							_tmp121_ = _tmp124_;
							_g_free0 (_tmp123_);
						}
						_tmp118_ = _tmp121_;
					} else {
						_tmp118_ = FALSE;
					}
					if (_tmp118_) {
						continue;
					} else {
						gboolean _tmp125_ = FALSE;
						gboolean _tmp126_ = FALSE;
						gboolean _tmp127_ = FALSE;
						if (!VALA_IS_CREATION_METHOD (m)) {
							_tmp127_ = self->priv->current_data_type != NULL;
						} else {
							_tmp127_ = FALSE;
						}
						if (_tmp127_) {
							_tmp126_ = param->type->is_interface;
						} else {
							_tmp126_ = FALSE;
						}
						if (_tmp126_) {
							gboolean _tmp128_ = FALSE;
							if (g_strcmp0 (param_node->name, "klass") == 0) {
								_tmp128_ = TRUE;
							} else {
								gchar* _tmp129_ = NULL;
								gchar* _tmp130_;
								gchar* _tmp131_ = NULL;
								gchar* _tmp132_;
								gboolean _tmp133_;
								_tmp129_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
								_tmp130_ = _tmp129_;
								_tmp131_ = g_strdup_printf ("%sClass", _tmp130_);
								_tmp132_ = _tmp131_;
								_tmp133_ = g_str_has_suffix (param->type->interface, _tmp132_);
								_tmp128_ = _tmp133_;
								_g_free0 (_tmp132_);
								_g_free0 (_tmp130_);
							}
							_tmp125_ = _tmp128_;
						} else {
							_tmp125_ = FALSE;
						}
						if (_tmp125_) {
							const gchar* _tmp134_ = NULL;
							gboolean _tmp135_;
							vala_method_set_binding (m, VALA_MEMBER_BINDING_CLASS);
							_tmp134_ = vala_symbol_get_name ((ValaSymbol*) m);
							_tmp135_ = g_str_has_prefix (_tmp134_, "class_");
							if (_tmp135_) {
								const gchar* _tmp136_ = NULL;
								gint _tmp137_;
								const gchar* _tmp138_ = NULL;
								gint _tmp139_;
								gint _tmp140_;
								gchar* _tmp141_ = NULL;
								gchar* _tmp142_;
								_tmp136_ = vala_symbol_get_name ((ValaSymbol*) m);
								_tmp137_ = strlen ("class_");
								_tmp138_ = vala_symbol_get_name ((ValaSymbol*) m);
								_tmp139_ = strlen (_tmp138_);
								_tmp140_ = strlen ("class_");
								_tmp141_ = string_substring (_tmp136_, (glong) _tmp137_, (glong) (_tmp139_ - _tmp140_));
								_tmp142_ = _tmp141_;
								vala_symbol_set_name ((ValaSymbol*) m, _tmp142_);
								_g_free0 (_tmp142_);
							}
							continue;
						} else {
							vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
						}
					}
				}
				if (g_strcmp0 (param->type->interface, "GAsyncReadyCallback") == 0) {
					gboolean _tmp144_ = FALSE;
					gboolean _tmp145_;
					_tmp145_ = g_str_has_suffix (symbol, "_async");
					if (_tmp145_) {
						_tmp144_ = TRUE;
					} else {
						gboolean _tmp146_;
						_tmp146_ = vala_method_get_coroutine (m);
						_tmp144_ = _tmp146_;
					}
					_tmp143_ = _tmp144_;
				} else {
					_tmp143_ = FALSE;
				}
				if (_tmp143_) {
					vala_method_set_coroutine (m, TRUE);
					continue;
				}
				if (suppress_throws == FALSE) {
					gboolean _tmp148_;
					_tmp148_ = vala_gidl_parser_param_is_exception (self, param);
					_tmp147_ = _tmp148_;
				} else {
					_tmp147_ = FALSE;
				}
				if (_tmp147_) {
					if (error_types == NULL) {
						ValaDataType* _tmp149_ = NULL;
						ValaDataType* _tmp150_;
						_tmp149_ = vala_gidl_parser_parse_type (self, param->type, NULL);
						_tmp150_ = _tmp149_;
						vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp150_);
						_vala_code_node_unref0 (_tmp150_);
					}
					continue;
				}
				_tmp151_ = g_strdup (param_node->name);
				param_name = _tmp151_;
				if (g_strcmp0 (param_name, "result") == 0) {
					gchar* _tmp152_;
					gchar* _tmp153_;
					_tmp152_ = g_strdup ("_result");
					_tmp153_ = _tmp152_;
					_g_free0 (param_name);
					param_name = _tmp153_;
				} else {
					if (g_strcmp0 (param_name, "string") == 0) {
						gchar* _tmp154_;
						gchar* _tmp155_;
						_tmp154_ = g_strdup ("str");
						_tmp155_ = _tmp154_;
						_g_free0 (param_name);
						param_name = _tmp155_;
					}
				}
				_tmp157_ = vala_gidl_parser_parse_param (self, param, &_tmp156_);
				direction = _tmp156_;
				param_type = _tmp157_;
				_tmp158_ = vala_parameter_new (param_name, param_type, NULL);
				p = _tmp158_;
				vala_parameter_set_direction (p, direction);
				hide_param = FALSE;
				show_param = FALSE;
				set_array_length_pos = FALSE;
				array_length_pos = (gdouble) 0;
				set_delegate_target_pos = FALSE;
				delegate_target_pos = (gdouble) 0;
				array_requested = FALSE;
				out_requested = FALSE;
				_tmp159_ = g_strdup_printf ("%s.%s", symbol, param_node->name);
				_tmp160_ = _tmp159_;
				_tmp162_ = vala_gidl_parser_get_attributes (self, _tmp160_, &_tmp161_);
				_tmp163_ = _tmp162_;
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes_length1 = _tmp161_;
				_attributes_size_ = attributes_length1;
				attributes = _tmp163_;
				_g_free0 (_tmp160_);
				if (attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp164_;
							gchar* attr;
							_tmp164_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp164_;
							{
								gchar** _tmp165_;
								gchar** _tmp166_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								_tmp166_ = _tmp165_ = g_strsplit (attr, "=", 2);
								nv = _tmp166_;
								nv_length1 = _vala_array_length (_tmp165_);
								_nv_size_ = _vala_array_length (_tmp165_);
								if (g_strcmp0 (nv[0], "is_array") == 0) {
									gchar* _tmp167_ = NULL;
									gchar* _tmp168_;
									gboolean _tmp169_;
									_tmp167_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp168_ = _tmp167_;
									if ((_tmp169_ = g_strcmp0 (_tmp168_, "1") == 0, _g_free0 (_tmp168_), _tmp169_)) {
										ValaSourceReference* _tmp170_ = NULL;
										ValaArrayType* _tmp171_ = NULL;
										ValaDataType* _tmp172_;
										_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
										_tmp171_ = vala_array_type_new (param_type, 1, _tmp170_);
										_tmp172_ = (ValaDataType*) _tmp171_;
										_vala_code_node_unref0 (param_type);
										param_type = _tmp172_;
										vala_variable_set_variable_type ((ValaVariable*) p, param_type);
										if (!out_requested) {
											vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
										}
										array_requested = TRUE;
									}
								} else {
									if (g_strcmp0 (nv[0], "is_out") == 0) {
										gchar* _tmp173_ = NULL;
										gchar* _tmp174_;
										gboolean _tmp175_;
										_tmp173_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp174_ = _tmp173_;
										if ((_tmp175_ = g_strcmp0 (_tmp174_, "1") == 0, _g_free0 (_tmp174_), _tmp175_)) {
											gboolean _tmp176_ = FALSE;
											vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
											out_requested = TRUE;
											if (!array_requested) {
												_tmp176_ = VALA_IS_ARRAY_TYPE (param_type);
											} else {
												_tmp176_ = FALSE;
											}
											if (_tmp176_) {
												ValaArrayType* _tmp177_;
												ValaArrayType* array_type;
												ValaDataType* _tmp178_ = NULL;
												ValaDataType* _tmp179_;
												ValaDataType* _tmp180_;
												_tmp177_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
												array_type = _tmp177_;
												_tmp178_ = vala_array_type_get_element_type (array_type);
												_tmp179_ = _vala_code_node_ref0 (_tmp178_);
												_tmp180_ = _tmp179_;
												_vala_code_node_unref0 (param_type);
												param_type = _tmp180_;
												vala_variable_set_variable_type ((ValaVariable*) p, param_type);
												_vala_code_node_unref0 (array_type);
											}
										}
									} else {
										if (g_strcmp0 (nv[0], "is_ref") == 0) {
											gchar* _tmp181_ = NULL;
											gchar* _tmp182_;
											gboolean _tmp183_;
											_tmp181_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp182_ = _tmp181_;
											if ((_tmp183_ = g_strcmp0 (_tmp182_, "1") == 0, _g_free0 (_tmp182_), _tmp183_)) {
												gboolean _tmp184_ = FALSE;
												vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
												if (!array_requested) {
													_tmp184_ = VALA_IS_ARRAY_TYPE (param_type);
												} else {
													_tmp184_ = FALSE;
												}
												if (_tmp184_) {
													ValaArrayType* _tmp185_;
													ValaArrayType* array_type;
													ValaDataType* _tmp186_ = NULL;
													ValaDataType* _tmp187_;
													ValaDataType* _tmp188_;
													_tmp185_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
													array_type = _tmp185_;
													_tmp186_ = vala_array_type_get_element_type (array_type);
													_tmp187_ = _vala_code_node_ref0 (_tmp186_);
													_tmp188_ = _tmp187_;
													_vala_code_node_unref0 (param_type);
													param_type = _tmp188_;
													vala_variable_set_variable_type ((ValaVariable*) p, param_type);
													_vala_code_node_unref0 (array_type);
												}
											}
										} else {
											if (g_strcmp0 (nv[0], "nullable") == 0) {
												gchar* _tmp189_ = NULL;
												gchar* _tmp190_;
												gboolean _tmp191_;
												_tmp189_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp190_ = _tmp189_;
												if ((_tmp191_ = g_strcmp0 (_tmp190_, "1") == 0, _g_free0 (_tmp190_), _tmp191_)) {
													vala_data_type_set_nullable (param_type, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
													gchar* _tmp192_ = NULL;
													gchar* _tmp193_;
													gboolean _tmp194_;
													_tmp192_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp193_ = _tmp192_;
													if ((_tmp194_ = g_strcmp0 (_tmp193_, "1") == 0, _g_free0 (_tmp193_), _tmp194_)) {
														vala_data_type_set_value_owned (param_type, TRUE);
													}
												} else {
													if (g_strcmp0 (nv[0], "takes_ownership") == 0) {
														gchar* _tmp195_ = NULL;
														gchar* _tmp196_;
														gboolean _tmp197_;
														_tmp195_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp196_ = _tmp195_;
														if ((_tmp197_ = g_strcmp0 (_tmp196_, "1") == 0, _g_free0 (_tmp196_), _tmp197_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "value_owned") == 0) {
															gchar* _tmp198_ = NULL;
															gchar* _tmp199_;
															gboolean _tmp200_;
															_tmp198_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp199_ = _tmp198_;
															if ((_tmp200_ = g_strcmp0 (_tmp199_, "0") == 0, _g_free0 (_tmp199_), _tmp200_)) {
																vala_data_type_set_value_owned (param_type, FALSE);
															} else {
																gchar* _tmp201_ = NULL;
																gchar* _tmp202_;
																gboolean _tmp203_;
																_tmp201_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp202_ = _tmp201_;
																if ((_tmp203_ = g_strcmp0 (_tmp202_, "1") == 0, _g_free0 (_tmp202_), _tmp203_)) {
																	vala_data_type_set_value_owned (param_type, TRUE);
																}
															}
														} else {
															if (g_strcmp0 (nv[0], "hidden") == 0) {
																gchar* _tmp204_ = NULL;
																gchar* _tmp205_;
																gboolean _tmp206_;
																_tmp204_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp205_ = _tmp204_;
																if ((_tmp206_ = g_strcmp0 (_tmp205_, "1") == 0, _g_free0 (_tmp205_), _tmp206_)) {
																	hide_param = TRUE;
																} else {
																	gchar* _tmp207_ = NULL;
																	gchar* _tmp208_;
																	gboolean _tmp209_;
																	_tmp207_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp208_ = _tmp207_;
																	if ((_tmp209_ = g_strcmp0 (_tmp208_, "0") == 0, _g_free0 (_tmp208_), _tmp209_)) {
																		show_param = TRUE;
																	}
																}
															} else {
																if (g_strcmp0 (nv[0], "no_array_length") == 0) {
																	gchar* _tmp210_ = NULL;
																	gchar* _tmp211_;
																	gboolean _tmp212_;
																	_tmp210_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp211_ = _tmp210_;
																	if ((_tmp212_ = g_strcmp0 (_tmp211_, "1") == 0, _g_free0 (_tmp211_), _tmp212_)) {
																		vala_variable_set_no_array_length ((ValaVariable*) p, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "array_length_type") == 0) {
																		gchar* _tmp213_ = NULL;
																		gchar* _tmp214_;
																		_tmp213_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp214_ = _tmp213_;
																		vala_variable_set_array_length_type ((ValaVariable*) p, _tmp214_);
																		_g_free0 (_tmp214_);
																	} else {
																		if (g_strcmp0 (nv[0], "array_null_terminated") == 0) {
																			gchar* _tmp215_ = NULL;
																			gchar* _tmp216_;
																			gboolean _tmp217_;
																			_tmp215_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp216_ = _tmp215_;
																			if ((_tmp217_ = g_strcmp0 (_tmp216_, "1") == 0, _g_free0 (_tmp216_), _tmp217_)) {
																				vala_variable_set_no_array_length ((ValaVariable*) p, TRUE);
																				vala_variable_set_array_null_terminated ((ValaVariable*) p, TRUE);
																			}
																		} else {
																			if (g_strcmp0 (nv[0], "array_length_pos") == 0) {
																				gchar* _tmp218_ = NULL;
																				gchar* _tmp219_;
																				gdouble _tmp220_;
																				set_array_length_pos = TRUE;
																				_tmp218_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp219_ = _tmp218_;
																				_tmp220_ = double_parse (_tmp219_);
																				array_length_pos = _tmp220_;
																				_g_free0 (_tmp219_);
																			} else {
																				if (g_strcmp0 (nv[0], "delegate_target_pos") == 0) {
																					gchar* _tmp221_ = NULL;
																					gchar* _tmp222_;
																					gdouble _tmp223_;
																					set_delegate_target_pos = TRUE;
																					_tmp221_ = vala_gidl_parser_eval (self, nv[1]);
																					_tmp222_ = _tmp221_;
																					_tmp223_ = double_parse (_tmp222_);
																					delegate_target_pos = _tmp223_;
																					_g_free0 (_tmp222_);
																				} else {
																					if (g_strcmp0 (nv[0], "type_name") == 0) {
																						gchar* _tmp224_ = NULL;
																						gchar* _tmp225_;
																						ValaDataType* _tmp226_ = NULL;
																						ValaDataType* _tmp227_;
																						_tmp224_ = vala_gidl_parser_eval (self, nv[1]);
																						_tmp225_ = _tmp224_;
																						_tmp226_ = vala_gidl_parser_parse_type_from_string (self, _tmp225_, FALSE, NULL);
																						_tmp227_ = _tmp226_;
																						_vala_code_node_unref0 (param_type);
																						param_type = _tmp227_;
																						vala_variable_set_variable_type ((ValaVariable*) p, param_type);
																						_g_free0 (_tmp225_);
																					} else {
																						if (g_strcmp0 (nv[0], "ctype") == 0) {
																							gchar* _tmp228_ = NULL;
																							gchar* _tmp229_;
																							_tmp228_ = vala_gidl_parser_eval (self, nv[1]);
																							_tmp229_ = _tmp228_;
																							vala_parameter_set_ctype (p, _tmp229_);
																							_g_free0 (_tmp229_);
																						} else {
																							if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																								gchar* _tmp230_ = NULL;
																								gchar* _tmp231_;
																								_tmp230_ = vala_gidl_parser_eval (self, nv[1]);
																								_tmp231_ = _tmp230_;
																								vala_gidl_parser_parse_type_arguments_from_string (self, param_type, _tmp231_, NULL);
																								_g_free0 (_tmp231_);
																							} else {
																								if (g_strcmp0 (nv[0], "default_value") == 0) {
																									gchar* _tmp232_ = NULL;
																									gchar* val;
																									_tmp232_ = vala_gidl_parser_eval (self, nv[1]);
																									val = _tmp232_;
																									if (g_strcmp0 (val, "null") == 0) {
																										ValaSourceReference* _tmp233_ = NULL;
																										ValaNullLiteral* _tmp234_ = NULL;
																										ValaNullLiteral* _tmp235_;
																										_tmp233_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																										_tmp234_ = vala_null_literal_new (_tmp233_);
																										_tmp235_ = _tmp234_;
																										vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp235_);
																										_vala_code_node_unref0 (_tmp235_);
																									} else {
																										if (g_strcmp0 (val, "true") == 0) {
																											ValaSourceReference* _tmp236_ = NULL;
																											ValaBooleanLiteral* _tmp237_ = NULL;
																											ValaBooleanLiteral* _tmp238_;
																											_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																											_tmp237_ = vala_boolean_literal_new (TRUE, _tmp236_);
																											_tmp238_ = _tmp237_;
																											vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp238_);
																											_vala_code_node_unref0 (_tmp238_);
																										} else {
																											if (g_strcmp0 (val, "false") == 0) {
																												ValaSourceReference* _tmp239_ = NULL;
																												ValaBooleanLiteral* _tmp240_ = NULL;
																												ValaBooleanLiteral* _tmp241_;
																												_tmp239_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																												_tmp240_ = vala_boolean_literal_new (FALSE, _tmp239_);
																												_tmp241_ = _tmp240_;
																												vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp241_);
																												_vala_code_node_unref0 (_tmp241_);
																											} else {
																												if (g_strcmp0 (val, "") == 0) {
																													ValaSourceReference* _tmp242_ = NULL;
																													ValaStringLiteral* _tmp243_ = NULL;
																													ValaStringLiteral* _tmp244_;
																													_tmp242_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																													_tmp243_ = vala_string_literal_new ("\"\"", _tmp242_);
																													_tmp244_ = _tmp243_;
																													vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp244_);
																													_vala_code_node_unref0 (_tmp244_);
																												} else {
																													gboolean _tmp245_;
																													_tmp245_ = int64_try_parse (val, NULL);
																													if (_tmp245_) {
																														ValaSourceReference* _tmp246_ = NULL;
																														ValaIntegerLiteral* _tmp247_ = NULL;
																														ValaIntegerLiteral* _tmp248_;
																														_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																														_tmp247_ = vala_integer_literal_new (val, _tmp246_);
																														_tmp248_ = _tmp247_;
																														vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp248_);
																														_vala_code_node_unref0 (_tmp248_);
																													} else {
																														gboolean _tmp249_;
																														_tmp249_ = double_try_parse (val, NULL);
																														if (_tmp249_) {
																															ValaSourceReference* _tmp250_ = NULL;
																															ValaRealLiteral* _tmp251_ = NULL;
																															ValaRealLiteral* _tmp252_;
																															_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																															_tmp251_ = vala_real_literal_new (val, _tmp250_);
																															_tmp252_ = _tmp251_;
																															vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp252_);
																															_vala_code_node_unref0 (_tmp252_);
																														} else {
																															gboolean _tmp253_ = FALSE;
																															gboolean _tmp254_;
																															_tmp254_ = g_str_has_prefix (val, "\"");
																															if (_tmp254_) {
																																gboolean _tmp255_;
																																_tmp255_ = g_str_has_suffix (val, "\"");
																																_tmp253_ = _tmp255_;
																															} else {
																																_tmp253_ = FALSE;
																															}
																															if (_tmp253_) {
																																ValaSourceReference* _tmp256_ = NULL;
																																ValaStringLiteral* _tmp257_ = NULL;
																																ValaStringLiteral* _tmp258_;
																																_tmp256_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																																_tmp257_ = vala_string_literal_new (val, _tmp256_);
																																_tmp258_ = _tmp257_;
																																vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp258_);
																																_vala_code_node_unref0 (_tmp258_);
																															} else {
																																gchar** _tmp259_;
																																gchar** _tmp260_ = NULL;
																																_tmp260_ = _tmp259_ = g_strsplit (val, ".", 0);
																																{
																																	gchar** member_collection;
																																	int member_collection_length1;
																																	int member_it;
																																	member_collection = _tmp260_;
																																	member_collection_length1 = _vala_array_length (_tmp259_);
																																	for (member_it = 0; member_it < _vala_array_length (_tmp259_); member_it = member_it + 1) {
																																		gchar* _tmp261_;
																																		gchar* member;
																																		_tmp261_ = g_strdup (member_collection[member_it]);
																																		member = _tmp261_;
																																		{
																																			ValaExpression* _tmp262_ = NULL;
																																			ValaSourceReference* _tmp263_ = NULL;
																																			ValaMemberAccess* _tmp264_ = NULL;
																																			ValaMemberAccess* _tmp265_;
																																			_tmp262_ = vala_variable_get_initializer ((ValaVariable*) p);
																																			_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																																			_tmp264_ = vala_member_access_new (_tmp262_, member, _tmp263_);
																																			_tmp265_ = _tmp264_;
																																			vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp265_);
																																			_vala_code_node_unref0 (_tmp265_);
																																			_g_free0 (member);
																																		}
																																	}
																																	member_collection = (_vala_array_free (member_collection, member_collection_length1, (GDestroyNotify) g_free), NULL);
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																									_g_free0 (val);
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (last_param != NULL) {
					const gchar* _tmp267_ = NULL;
					const gchar* _tmp268_ = NULL;
					gchar* _tmp269_;
					_tmp267_ = vala_symbol_get_name ((ValaSymbol*) p);
					_tmp268_ = vala_symbol_get_name ((ValaSymbol*) last_param);
					_tmp269_ = g_strconcat ("n_", _tmp268_, NULL);
					_tmp266_ = g_strcmp0 (_tmp267_, _tmp269_) == 0;
					_g_free0 (_tmp269_);
				} else {
					_tmp266_ = FALSE;
				}
				if (_tmp266_) {
					if (!VALA_IS_ARRAY_TYPE (last_param_type)) {
						ValaSourceReference* _tmp270_ = NULL;
						ValaArrayType* _tmp271_ = NULL;
						ValaDataType* _tmp272_;
						_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) last_param_type);
						_tmp271_ = vala_array_type_new (last_param_type, 1, _tmp270_);
						_tmp272_ = (ValaDataType*) _tmp271_;
						_vala_code_node_unref0 (last_param_type);
						last_param_type = _tmp272_;
						vala_variable_set_variable_type ((ValaVariable*) last_param, last_param_type);
						vala_parameter_set_direction (last_param, VALA_PARAMETER_DIRECTION_IN);
					}
					hide_param = TRUE;
				} else {
					gboolean _tmp273_ = FALSE;
					if (last_param != NULL) {
						const gchar* _tmp274_ = NULL;
						_tmp274_ = vala_symbol_get_name ((ValaSymbol*) p);
						_tmp273_ = g_strcmp0 (_tmp274_, "user_data") == 0;
					} else {
						_tmp273_ = FALSE;
					}
					if (_tmp273_) {
						hide_param = TRUE;
					}
				}
				if (show_param) {
					_tmp275_ = TRUE;
				} else {
					_tmp275_ = !hide_param;
				}
				if (_tmp275_) {
					vala_method_add_parameter (m, p);
					if (set_array_length_pos) {
						vala_parameter_set_carray_length_parameter_position (p, array_length_pos);
					}
					if (set_delegate_target_pos) {
						vala_parameter_set_cdelegate_target_parameter_position (p, delegate_target_pos);
					}
				}
				_tmp276_ = _vala_code_node_ref0 (p);
				_tmp277_ = _tmp276_;
				_vala_code_node_unref0 (last_param);
				last_param = _tmp277_;
				_tmp278_ = _vala_code_node_ref0 (param_type);
				_tmp279_ = _tmp278_;
				_vala_code_node_unref0 (last_param_type);
				last_param_type = _tmp279_;
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
				_g_free0 (param_name);
			}
		}
	}
	if (suppress_throws == FALSE) {
		_tmp280_ = error_types != NULL;
	} else {
		_tmp280_ = FALSE;
	}
	if (_tmp280_) {
		gchar* _tmp281_ = NULL;
		gchar* _tmp282_;
		gchar** _tmp283_;
		gchar** _tmp284_ = NULL;
		gchar** _tmp285_;
		gchar** type_args;
		gint type_args_length1;
		gint _type_args_size_;
		_tmp281_ = vala_gidl_parser_eval (self, error_types);
		_tmp282_ = _tmp281_;
		_tmp284_ = _tmp283_ = g_strsplit (_tmp282_, ",", 0);
		type_args = (_tmp285_ = _tmp284_, _g_free0 (_tmp282_), _tmp285_);
		type_args_length1 = _vala_array_length (_tmp283_);
		_type_args_size_ = _vala_array_length (_tmp283_);
		{
			gchar** type_arg_collection;
			int type_arg_collection_length1;
			int type_arg_it;
			type_arg_collection = type_args;
			type_arg_collection_length1 = type_args_length1;
			for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
				gchar* _tmp286_;
				gchar* type_arg;
				_tmp286_ = g_strdup (type_arg_collection[type_arg_it]);
				type_arg = _tmp286_;
				{
					ValaDataType* _tmp287_ = NULL;
					ValaDataType* _tmp288_;
					_tmp287_ = vala_gidl_parser_parse_type_from_string (self, type_arg, TRUE, NULL);
					_tmp288_ = _tmp287_;
					vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp288_);
					_vala_code_node_unref0 (_tmp288_);
					_g_free0 (type_arg);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	if (first) {
		vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
	}
	if (last_param != NULL) {
		const gchar* _tmp290_ = NULL;
		gboolean _tmp291_;
		_tmp290_ = vala_symbol_get_name ((ValaSymbol*) last_param);
		_tmp291_ = g_str_has_prefix (_tmp290_, "first_");
		_tmp289_ = _tmp291_;
	} else {
		_tmp289_ = FALSE;
	}
	if (_tmp289_) {
		vala_parameter_set_ellipsis (last_param, TRUE);
	} else {
		if (add_ellipsis) {
			ValaParameter* _tmp292_ = NULL;
			ValaParameter* _tmp293_;
			_tmp292_ = vala_parameter_new_with_ellipsis (NULL);
			_tmp293_ = _tmp292_;
			vala_method_add_parameter (m, _tmp293_);
			_vala_code_node_unref0 (_tmp293_);
		}
	}
	result = m;
	_vala_code_node_unref0 (last_param_type);
	_vala_code_node_unref0 (last_param);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* s;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param != NULL, FALSE);
	if (!param->type->is_error) {
		result = FALSE;
		return result;
	}
	_tmp0_ = string_chomp (param->type->unparsed);
	s = _tmp0_;
	_tmp1_ = g_str_has_suffix (s, "**");
	if (_tmp1_) {
		result = TRUE;
		_g_free0 (s);
		return result;
	}
	result = FALSE;
	_g_free0 (s);
	return result;
}


static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNode* node;
	ValaMethod* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	node = (GIdlNode*) f;
	if (f->deprecated) {
		result = NULL;
		return result;
	}
	_tmp0_ = vala_gidl_parser_create_method (self, node->name, f->symbol, f->result, f->parameters, f->is_constructor, is_interface);
	result = _tmp0_;
	return result;
}


static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* symbol;
	GList* _tmp6_ = NULL;
	ValaMethod* _tmp7_ = NULL;
	ValaMethod* m;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	node = (GIdlNode*) v;
	_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self->priv->current_data_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s%s", _tmp1_, node->name);
	symbol = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (func != NULL) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup (func->symbol);
		_tmp5_ = _tmp4_;
		_g_free0 (symbol);
		symbol = _tmp5_;
	}
	if (func != NULL) {
		_tmp6_ = func->parameters;
	} else {
		_tmp6_ = v->parameters;
	}
	_tmp7_ = vala_gidl_parser_create_method (self, node->name, symbol, v->result, _tmp6_, FALSE, is_interface);
	m = _tmp7_;
	if (m != NULL) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gint _tmp12_;
		gchar** _tmp13_ = NULL;
		gchar** attributes;
		gint attributes_length1;
		gint _attributes_size_;
		vala_method_set_binding (m, VALA_MEMBER_BINDING_INSTANCE);
		_tmp9_ = vala_method_get_is_abstract (m);
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = is_interface;
		}
		vala_method_set_is_virtual (m, !_tmp8_);
		_tmp11_ = vala_method_get_is_abstract (m);
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = is_interface;
		}
		vala_method_set_is_abstract (m, _tmp10_);
		_tmp13_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp12_);
		attributes = _tmp13_;
		attributes_length1 = _tmp12_;
		_attributes_size_ = _tmp12_;
		if (attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp14_;
					gchar* attr;
					_tmp14_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp14_;
					{
						gchar** _tmp15_;
						gchar** _tmp16_ = NULL;
						gchar** nv;
						gint nv_length1;
						gint _nv_size_;
						_tmp16_ = _tmp15_ = g_strsplit (attr, "=", 2);
						nv = _tmp16_;
						nv_length1 = _vala_array_length (_tmp15_);
						_nv_size_ = _vala_array_length (_tmp15_);
						if (g_strcmp0 (nv[0], "virtual") == 0) {
							gchar* _tmp17_ = NULL;
							gchar* _tmp18_;
							gboolean _tmp19_;
							_tmp17_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp18_ = _tmp17_;
							if ((_tmp19_ = g_strcmp0 (_tmp18_, "0") == 0, _g_free0 (_tmp18_), _tmp19_)) {
								vala_method_set_is_virtual (m, FALSE);
								vala_method_set_is_abstract (m, FALSE);
							} else {
								vala_method_set_is_virtual (m, TRUE);
								vala_method_set_is_abstract (m, FALSE);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		if (func == NULL) {
			ValaAttribute* _tmp20_ = NULL;
			_tmp20_ = vala_attribute_new ("NoWrapper", NULL);
			((ValaCodeNode*) m)->attributes = g_list_append (((ValaCodeNode*) m)->attributes, _tmp20_);
		}
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	result = m;
	_g_free0 (symbol);
	return result;
}


static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const gchar* name) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* str;
	gchar* _tmp1_;
	gchar* i;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	_tmp1_ = g_strdup (name);
	i = _tmp1_;
	while (TRUE) {
		gint _tmp2_;
		gunichar _tmp3_;
		gunichar c;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = strlen (i);
		if (!(_tmp2_ > 0)) {
			break;
		}
		_tmp3_ = string_get_char (i, (glong) 0);
		c = _tmp3_;
		if (c == '-') {
			g_string_append_c (str, '_');
		} else {
			g_string_append_unichar (str, c);
		}
		_tmp4_ = g_utf8_next_char (i);
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (i);
		i = _tmp6_;
	}
	_tmp7_ = g_strdup (str->str);
	result = _tmp7_;
	_g_free0 (i);
	_g_string_free0 (str);
	return result;
}


static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node) {
	ValaProperty* result = NULL;
	GIdlNode* node;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_;
	ValaProperty* _tmp5_ = NULL;
	ValaProperty* _tmp6_;
	ValaProperty* prop;
	gboolean _tmp7_ = FALSE;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gint _tmp25_;
	gchar** _tmp26_ = NULL;
	gchar** _tmp27_;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	node = (GIdlNode*) prop_node;
	if (prop_node->deprecated) {
		result = NULL;
		return result;
	}
	if (!prop_node->readable) {
		_tmp0_ = !prop_node->writable;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		prop_node->readable = TRUE;
		prop_node->writable = TRUE;
	}
	_tmp1_ = vala_gidl_parser_fix_prop_name (self, node->name);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gidl_parser_parse_type (self, prop_node->type, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_property_new (_tmp2_, _tmp4_, NULL, NULL, self->priv->current_source_reference, NULL);
	prop = (_tmp6_ = _tmp5_, _vala_code_node_unref0 (_tmp4_), _g_free0 (_tmp2_), _tmp6_);
	vala_symbol_set_access ((ValaSymbol*) prop, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_property_set_interface_only (prop, TRUE);
	if (prop_node->type->is_interface) {
		_tmp7_ = g_strcmp0 (prop_node->type->interface, "GStrv") == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		vala_property_set_no_array_length (prop, TRUE);
		vala_property_set_array_null_terminated (prop, TRUE);
	}
	if (prop_node->readable) {
		ValaDataType* _tmp8_ = NULL;
		ValaDataType* _tmp9_ = NULL;
		ValaDataType* _tmp10_;
		ValaPropertyAccessor* _tmp11_ = NULL;
		ValaPropertyAccessor* _tmp12_;
		_tmp8_ = vala_property_get_property_type (prop);
		_tmp9_ = vala_data_type_copy (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp10_, NULL, NULL, NULL);
		_tmp12_ = _tmp11_;
		vala_property_set_get_accessor (prop, _tmp12_);
		_vala_code_node_unref0 (_tmp12_);
		_vala_code_node_unref0 (_tmp10_);
	}
	if (prop_node->writable) {
		ValaDataType* _tmp13_ = NULL;
		ValaDataType* _tmp14_ = NULL;
		ValaDataType* _tmp15_;
		ValaPropertyAccessor* _tmp16_ = NULL;
		ValaPropertyAccessor* _tmp17_;
		_tmp13_ = vala_property_get_property_type (prop);
		_tmp14_ = vala_data_type_copy (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_property_accessor_new (FALSE, FALSE, FALSE, _tmp15_, NULL, NULL, NULL);
		_tmp17_ = _tmp16_;
		vala_property_set_set_accessor (prop, _tmp17_);
		_vala_code_node_unref0 (_tmp17_);
		_vala_code_node_unref0 (_tmp15_);
		if (prop_node->construct_only) {
			ValaPropertyAccessor* _tmp18_ = NULL;
			_tmp18_ = vala_property_get_set_accessor (prop);
			vala_property_accessor_set_construction (_tmp18_, TRUE);
		} else {
			ValaPropertyAccessor* _tmp19_ = NULL;
			ValaPropertyAccessor* _tmp20_ = NULL;
			_tmp19_ = vala_property_get_set_accessor (prop);
			vala_property_accessor_set_writable (_tmp19_, TRUE);
			_tmp20_ = vala_property_get_set_accessor (prop);
			vala_property_accessor_set_construction (_tmp20_, prop_node->construct);
		}
	}
	_tmp21_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup_printf ("%s:%s", _tmp22_, node->name);
	_tmp24_ = _tmp23_;
	_tmp26_ = vala_gidl_parser_get_attributes (self, _tmp24_, &_tmp25_);
	attributes = (_tmp27_ = _tmp26_, _g_free0 (_tmp24_), _g_free0 (_tmp22_), _tmp27_);
	attributes_length1 = _tmp25_;
	_attributes_size_ = _tmp25_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp28_;
				gchar* attr;
				_tmp28_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp28_;
				{
					gchar** _tmp29_;
					gchar** _tmp30_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp30_ = _tmp29_ = g_strsplit (attr, "=", 2);
					nv = _tmp30_;
					nv_length1 = _vala_array_length (_tmp29_);
					_nv_size_ = _vala_array_length (_tmp29_);
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_;
						gboolean _tmp33_;
						_tmp31_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp32_ = _tmp31_;
						if ((_tmp33_ = g_strcmp0 (_tmp32_, "1") == 0, _g_free0 (_tmp32_), _tmp33_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (prop);
							return result;
						}
					} else {
						if (g_strcmp0 (nv[0], "type_arguments") == 0) {
							ValaDataType* _tmp34_ = NULL;
							gchar* _tmp35_ = NULL;
							gchar* _tmp36_;
							_tmp34_ = vala_property_get_property_type (prop);
							_tmp35_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp36_ = _tmp35_;
							vala_gidl_parser_parse_type_arguments_from_string (self, _tmp34_, _tmp36_, NULL);
							_g_free0 (_tmp36_);
						} else {
							if (g_strcmp0 (nv[0], "deprecated") == 0) {
								gchar* _tmp37_ = NULL;
								gchar* _tmp38_;
								gboolean _tmp39_;
								_tmp37_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp38_ = _tmp37_;
								if ((_tmp39_ = g_strcmp0 (_tmp38_, "1") == 0, _g_free0 (_tmp38_), _tmp39_)) {
									vala_symbol_set_deprecated ((ValaSymbol*) prop, TRUE);
								}
							} else {
								if (g_strcmp0 (nv[0], "replacement") == 0) {
									gchar* _tmp40_ = NULL;
									gchar* _tmp41_;
									_tmp40_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp41_ = _tmp40_;
									vala_symbol_set_replacement ((ValaSymbol*) prop, _tmp41_);
									_g_free0 (_tmp41_);
								} else {
									if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
										gchar* _tmp42_ = NULL;
										gchar* _tmp43_;
										_tmp42_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp43_ = _tmp42_;
										vala_symbol_set_deprecated_since ((ValaSymbol*) prop, _tmp43_);
										_g_free0 (_tmp43_);
									} else {
										if (g_strcmp0 (nv[0], "accessor_method") == 0) {
											gchar* _tmp44_ = NULL;
											gchar* _tmp45_;
											gboolean _tmp46_;
											_tmp44_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp45_ = _tmp44_;
											if ((_tmp46_ = g_strcmp0 (_tmp45_, "0") == 0, _g_free0 (_tmp45_), _tmp46_)) {
												vala_property_set_no_accessor_method (prop, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "owned_get") == 0) {
												gchar* _tmp47_ = NULL;
												gchar* _tmp48_;
												gboolean _tmp49_;
												_tmp47_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp48_ = _tmp47_;
												if ((_tmp49_ = g_strcmp0 (_tmp48_, "1") == 0, _g_free0 (_tmp48_), _tmp49_)) {
													ValaPropertyAccessor* _tmp50_ = NULL;
													ValaDataType* _tmp51_ = NULL;
													_tmp50_ = vala_property_get_get_accessor (prop);
													_tmp51_ = vala_property_accessor_get_value_type (_tmp50_);
													vala_data_type_set_value_owned (_tmp51_, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "type_name") == 0) {
													gchar* _tmp52_ = NULL;
													gchar* _tmp53_;
													ValaDataType* _tmp54_ = NULL;
													ValaDataType* _tmp55_;
													_tmp52_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp53_ = _tmp52_;
													_tmp54_ = vala_gidl_parser_parse_type_from_string (self, _tmp53_, FALSE, NULL);
													_tmp55_ = _tmp54_;
													vala_property_set_property_type (prop, _tmp55_);
													_vala_code_node_unref0 (_tmp55_);
													_g_free0 (_tmp53_);
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	if (self->priv->current_type_symbol_set != NULL) {
		const gchar* _tmp56_ = NULL;
		_tmp56_ = vala_symbol_get_name ((ValaSymbol*) prop);
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, _tmp56_);
	}
	result = prop;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node) {
	ValaConstant* result = NULL;
	GIdlNode* node;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* type;
	ValaConstant* _tmp1_ = NULL;
	ValaConstant* c;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_node != NULL, NULL);
	node = (GIdlNode*) const_node;
	_tmp0_ = vala_gidl_parser_parse_type (self, const_node->type, NULL);
	type = _tmp0_;
	if (type == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp1_ = vala_constant_new (node->name, type, NULL, self->priv->current_source_reference, NULL);
	c = _tmp1_;
	vala_symbol_set_external ((ValaSymbol*) c, TRUE);
	_tmp3_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp2_);
	attributes = _tmp3_;
	attributes_length1 = _tmp2_;
	_attributes_size_ = _tmp2_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp4_;
				gchar* attr;
				_tmp4_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp4_;
				{
					gchar** _tmp5_;
					gchar** _tmp6_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp6_ = _tmp5_ = g_strsplit (attr, "=", 2);
					nv = _tmp6_;
					nv_length1 = _vala_array_length (_tmp5_);
					_nv_size_ = _vala_array_length (_tmp5_);
					if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
						gchar* _tmp7_ = NULL;
						gchar* _tmp8_;
						_tmp7_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp8_ = _tmp7_;
						vala_symbol_add_cheader_filename ((ValaSymbol*) c, _tmp8_);
						_g_free0 (_tmp8_);
					} else {
						if (g_strcmp0 (nv[0], "deprecated") == 0) {
							gchar* _tmp9_ = NULL;
							gchar* _tmp10_;
							gboolean _tmp11_;
							_tmp9_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp10_ = _tmp9_;
							if ((_tmp11_ = g_strcmp0 (_tmp10_, "1") == 0, _g_free0 (_tmp10_), _tmp11_)) {
								vala_symbol_set_deprecated ((ValaSymbol*) c, TRUE);
							}
						} else {
							if (g_strcmp0 (nv[0], "replacement") == 0) {
								gchar* _tmp12_ = NULL;
								gchar* _tmp13_;
								_tmp12_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp13_ = _tmp12_;
								vala_symbol_set_replacement ((ValaSymbol*) c, _tmp13_);
								_g_free0 (_tmp13_);
							} else {
								if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
									gchar* _tmp14_ = NULL;
									gchar* _tmp15_;
									_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp15_ = _tmp14_;
									vala_symbol_set_deprecated_since ((ValaSymbol*) c, _tmp15_);
									_g_free0 (_tmp15_);
								} else {
									if (g_strcmp0 (nv[0], "hidden") == 0) {
										gchar* _tmp16_ = NULL;
										gchar* _tmp17_;
										gboolean _tmp18_;
										_tmp16_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp17_ = _tmp16_;
										if ((_tmp18_ = g_strcmp0 (_tmp17_, "1") == 0, _g_free0 (_tmp17_), _tmp18_)) {
											result = NULL;
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
											_vala_code_node_unref0 (c);
											_vala_code_node_unref0 (type);
											return result;
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_symbol_set_access ((ValaSymbol*) c, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	result = c;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (type);
	return result;
}


static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node) {
	ValaField* result = NULL;
	GIdlNode* node;
	gboolean unhidden;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* type;
	gchar* cheader_filename;
	gchar* ctype;
	gchar* array_length_cname;
	gchar* array_length_type;
	gboolean array_null_terminated;
	gboolean deprecated;
	gchar* deprecated_since;
	gchar* replacement;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gint _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_;
	gchar* _tmp49_;
	gchar* field_name;
	ValaField* _tmp52_ = NULL;
	ValaField* field;
	gboolean _tmp53_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_node != NULL, NULL);
	node = (GIdlNode*) field_node;
	unhidden = FALSE;
	_tmp0_ = vala_gidl_parser_parse_type (self, field_node->type, NULL);
	type = _tmp0_;
	if (type == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	cheader_filename = NULL;
	ctype = NULL;
	array_length_cname = NULL;
	array_length_type = NULL;
	array_null_terminated = FALSE;
	deprecated = FALSE;
	deprecated_since = NULL;
	replacement = NULL;
	_tmp1_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s.%s", _tmp2_, node->name);
	_tmp4_ = _tmp3_;
	_tmp6_ = vala_gidl_parser_get_attributes (self, _tmp4_, &_tmp5_);
	attributes = (_tmp7_ = _tmp6_, _g_free0 (_tmp4_), _g_free0 (_tmp2_), _tmp7_);
	attributes_length1 = _tmp5_;
	_attributes_size_ = _tmp5_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp8_;
				gchar* attr;
				_tmp8_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp8_;
				{
					gchar** _tmp9_;
					gchar** _tmp10_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp10_ = _tmp9_ = g_strsplit (attr, "=", 2);
					nv = _tmp10_;
					nv_length1 = _vala_array_length (_tmp9_);
					_nv_size_ = _vala_array_length (_tmp9_);
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						gchar* _tmp11_ = NULL;
						gchar* _tmp12_;
						gboolean _tmp13_;
						_tmp11_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp12_ = _tmp11_;
						if ((_tmp13_ = g_strcmp0 (_tmp12_, "1") == 0, _g_free0 (_tmp12_), _tmp13_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (replacement);
							_g_free0 (deprecated_since);
							_g_free0 (array_length_type);
							_g_free0 (array_length_cname);
							_g_free0 (ctype);
							_g_free0 (cheader_filename);
							_vala_code_node_unref0 (type);
							return result;
						} else {
							unhidden = TRUE;
						}
					} else {
						if (g_strcmp0 (nv[0], "is_array") == 0) {
							gchar* _tmp14_ = NULL;
							gchar* _tmp15_;
							gboolean _tmp16_;
							_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp15_ = _tmp14_;
							if ((_tmp16_ = g_strcmp0 (_tmp15_, "1") == 0, _g_free0 (_tmp15_), _tmp16_)) {
								ValaSourceReference* _tmp17_ = NULL;
								ValaArrayType* _tmp18_ = NULL;
								ValaDataType* _tmp19_;
								_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
								_tmp18_ = vala_array_type_new (type, 1, _tmp17_);
								_tmp19_ = (ValaDataType*) _tmp18_;
								_vala_code_node_unref0 (type);
								type = _tmp19_;
							}
						} else {
							if (g_strcmp0 (nv[0], "weak") == 0) {
								gchar* _tmp20_ = NULL;
								gchar* _tmp21_;
								gboolean _tmp22_;
								_tmp20_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp21_ = _tmp20_;
								if ((_tmp22_ = g_strcmp0 (_tmp21_, "0") == 0, _g_free0 (_tmp21_), _tmp22_)) {
									vala_data_type_set_value_owned (type, TRUE);
								}
							} else {
								if (g_strcmp0 (nv[0], "type_name") == 0) {
									gchar* _tmp23_ = NULL;
									gchar* _tmp24_;
									ValaDataType* _tmp25_ = NULL;
									ValaDataType* _tmp26_;
									_tmp23_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp24_ = _tmp23_;
									_tmp25_ = vala_gidl_parser_parse_type_from_string (self, _tmp24_, TRUE, NULL);
									_tmp26_ = _tmp25_;
									_vala_code_node_unref0 (type);
									type = _tmp26_;
									_g_free0 (_tmp24_);
								} else {
									if (g_strcmp0 (nv[0], "type_arguments") == 0) {
										gchar* _tmp27_ = NULL;
										gchar* _tmp28_;
										_tmp27_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp28_ = _tmp27_;
										vala_gidl_parser_parse_type_arguments_from_string (self, type, _tmp28_, NULL);
										_g_free0 (_tmp28_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated") == 0) {
											gchar* _tmp29_ = NULL;
											gchar* _tmp30_;
											gboolean _tmp31_;
											_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp30_ = _tmp29_;
											if ((_tmp31_ = g_strcmp0 (_tmp30_, "1") == 0, _g_free0 (_tmp30_), _tmp31_)) {
												deprecated = TRUE;
											}
										} else {
											if (g_strcmp0 (nv[0], "replacement") == 0) {
												gchar* _tmp32_ = NULL;
												gchar* _tmp33_;
												_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp33_ = _tmp32_;
												_g_free0 (replacement);
												replacement = _tmp33_;
											} else {
												if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
													gchar* _tmp34_ = NULL;
													gchar* _tmp35_;
													_tmp34_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp35_ = _tmp34_;
													_g_free0 (deprecated_since);
													deprecated_since = _tmp35_;
												} else {
													if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
														gchar* _tmp36_ = NULL;
														gchar* _tmp37_;
														_tmp36_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp37_ = _tmp36_;
														_g_free0 (cheader_filename);
														cheader_filename = _tmp37_;
													} else {
														if (g_strcmp0 (nv[0], "ctype") == 0) {
															gchar* _tmp38_ = NULL;
															gchar* _tmp39_;
															_tmp38_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp39_ = _tmp38_;
															_g_free0 (ctype);
															ctype = _tmp39_;
														} else {
															if (g_strcmp0 (nv[0], "array_null_terminated") == 0) {
																gchar* _tmp40_ = NULL;
																gchar* _tmp41_;
																gboolean _tmp42_;
																_tmp40_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp41_ = _tmp40_;
																if ((_tmp42_ = g_strcmp0 (_tmp41_, "1") == 0, _g_free0 (_tmp41_), _tmp42_)) {
																	array_null_terminated = TRUE;
																}
															} else {
																if (g_strcmp0 (nv[0], "array_length_cname") == 0) {
																	gchar* _tmp43_ = NULL;
																	gchar* _tmp44_;
																	_tmp43_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp44_ = _tmp43_;
																	_g_free0 (array_length_cname);
																	array_length_cname = _tmp44_;
																} else {
																	if (g_strcmp0 (nv[0], "array_length_type") == 0) {
																		gchar* _tmp45_ = NULL;
																		gchar* _tmp46_;
																		_tmp45_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp46_ = _tmp45_;
																		_g_free0 (array_length_type);
																		array_length_type = _tmp46_;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp48_ = g_str_has_prefix (node->name, "_");
	if (_tmp48_) {
		_tmp47_ = !unhidden;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		result = NULL;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (replacement);
		_g_free0 (deprecated_since);
		_g_free0 (array_length_type);
		_g_free0 (array_length_cname);
		_g_free0 (ctype);
		_g_free0 (cheader_filename);
		_vala_code_node_unref0 (type);
		return result;
	}
	if (self->priv->current_type_symbol_set != NULL) {
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, node->name);
	}
	_tmp49_ = g_strdup (node->name);
	field_name = _tmp49_;
	if (g_strcmp0 (field_name, "string") == 0) {
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = g_strdup ("str");
		_tmp51_ = _tmp50_;
		_g_free0 (field_name);
		field_name = _tmp51_;
	}
	_tmp52_ = vala_field_new (field_name, type, NULL, self->priv->current_source_reference, NULL);
	field = _tmp52_;
	vala_symbol_set_access ((ValaSymbol*) field, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (g_strcmp0 (field_name, node->name) != 0) {
		vala_field_set_cname (field, node->name);
	}
	if (deprecated) {
		vala_symbol_set_deprecated ((ValaSymbol*) field, TRUE);
		if (deprecated_since != NULL) {
			vala_symbol_set_deprecated_since ((ValaSymbol*) field, deprecated_since);
		}
		if (replacement != NULL) {
			vala_symbol_set_replacement ((ValaSymbol*) field, replacement);
		}
	}
	if (ctype != NULL) {
		vala_field_set_ctype (field, ctype);
	}
	if (cheader_filename != NULL) {
		vala_symbol_add_cheader_filename ((ValaSymbol*) field, cheader_filename);
	}
	if (array_null_terminated) {
		vala_variable_set_array_null_terminated ((ValaVariable*) field, TRUE);
	}
	if (array_length_cname != NULL) {
		_tmp53_ = TRUE;
	} else {
		_tmp53_ = array_length_type != NULL;
	}
	if (_tmp53_) {
		if (array_length_cname != NULL) {
			vala_variable_set_array_length_cname ((ValaVariable*) field, array_length_cname);
		}
		if (array_length_type != NULL) {
			vala_variable_set_array_length_type ((ValaVariable*) field, array_length_type);
		}
	} else {
		vala_variable_set_no_array_length ((ValaVariable*) field, TRUE);
	}
	result = field;
	_g_free0 (field_name);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (replacement);
	_g_free0 (deprecated_since);
	_g_free0 (array_length_type);
	_g_free0 (array_length_cname);
	_g_free0 (ctype);
	_g_free0 (cheader_filename);
	_vala_code_node_unref0 (type);
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const gchar* codenode, int* result_length1) {
	gchar** result = NULL;
	gpointer _tmp0_ = NULL;
	gchar* attributes;
	GSList* attr_list;
	gint _tmp18_;
	GString* _tmp19_ = NULL;
	GString* attr;
	gint _tmp20_;
	gint attributes_len;
	const gchar* remaining;
	gboolean quoted;
	gboolean escaped;
	guint _tmp27_;
	gchar** _tmp28_ = NULL;
	gchar** attrs;
	gint attrs_length1;
	gint _attrs_size_;
	GSList* attr_i;
	gchar** _tmp33_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (codenode != NULL, NULL);
	_tmp0_ = vala_map_get (self->priv->codenode_attributes_map, codenode);
	attributes = (gchar*) _tmp0_;
	if (attributes == NULL) {
		gint _tmp1_;
		gboolean dot_required;
		gint _tmp2_;
		gboolean colon_required;
		ValaSet* _tmp3_ = NULL;
		ValaSet* pattern_specs;
		_tmp1_ = string_index_of_char (codenode, (gunichar) '.', 0);
		dot_required = (-1) != _tmp1_;
		_tmp2_ = string_index_of_char (codenode, (gunichar) ':', 0);
		colon_required = (-1) != _tmp2_;
		_tmp3_ = vala_map_get_keys (self->priv->codenode_attributes_patterns);
		pattern_specs = _tmp3_;
		{
			ValaIterator* _tmp4_ = NULL;
			ValaIterator* _pattern_it;
			_tmp4_ = vala_iterable_iterator ((ValaIterable*) pattern_specs);
			_pattern_it = _tmp4_;
			while (TRUE) {
				gboolean _tmp5_;
				gpointer _tmp6_ = NULL;
				GPatternSpec* pattern;
				gpointer _tmp7_ = NULL;
				gchar* pspec;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp13_;
				_tmp5_ = vala_iterator_next (_pattern_it);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = vala_iterator_get (_pattern_it);
				pattern = _tmp6_;
				_tmp7_ = vala_map_get (self->priv->codenode_attributes_patterns, pattern);
				pspec = (gchar*) _tmp7_;
				if (dot_required) {
					gint _tmp10_;
					_tmp10_ = string_index_of_char (pspec, (gunichar) '.', 0);
					_tmp9_ = (-1) == _tmp10_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp11_ = FALSE;
					if (colon_required) {
						gint _tmp12_;
						_tmp12_ = string_index_of_char (pspec, (gunichar) ':', 0);
						_tmp11_ = (-1) == _tmp12_;
					} else {
						_tmp11_ = FALSE;
					}
					_tmp8_ = _tmp11_;
				}
				if (_tmp8_) {
					_g_free0 (pspec);
					continue;
				}
				_tmp13_ = g_pattern_match_string (pattern, codenode);
				if (_tmp13_) {
					gint _tmp14_;
					gchar** _tmp15_ = NULL;
					gchar** _tmp16_;
					_tmp15_ = vala_gidl_parser_get_attributes (self, pspec, &_tmp14_);
					_tmp16_ = _tmp15_;
					*result_length1 = _tmp14_;
					result = _tmp16_;
					_g_free0 (pspec);
					_vala_iterator_unref0 (_pattern_it);
					_vala_iterable_unref0 (pattern_specs);
					_g_free0 (attributes);
					return result;
				}
				_g_free0 (pspec);
			}
			_vala_iterator_unref0 (_pattern_it);
		}
		_vala_iterable_unref0 (pattern_specs);
	}
	if (attributes == NULL) {
		gpointer _tmp17_;
		_tmp17_ = NULL;
		*result_length1 = 0;
		result = _tmp17_;
		_g_free0 (attributes);
		return result;
	}
	attr_list = NULL;
	_tmp18_ = strlen (attributes);
	_tmp19_ = g_string_sized_new ((gsize) _tmp18_);
	attr = _tmp19_;
	_tmp20_ = strlen (attributes);
	attributes_len = _tmp20_;
	remaining = attributes;
	quoted = FALSE;
	escaped = FALSE;
	{
		gint b;
		b = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gunichar _tmp22_;
				gunichar c;
				gint _tmp25_;
				if (!_tmp21_) {
					b++;
				}
				_tmp21_ = FALSE;
				if (!(b < attributes_len)) {
					break;
				}
				_tmp22_ = string_get_char (remaining, (glong) 0);
				c = _tmp22_;
				if (escaped) {
					escaped = FALSE;
					g_string_append_unichar (attr, c);
				} else {
					if (c == '"') {
						g_string_append_unichar (attr, c);
						quoted = !quoted;
					} else {
						if (c == '\\') {
							escaped = TRUE;
						} else {
							gboolean _tmp23_ = FALSE;
							if (!quoted) {
								_tmp23_ = c == ' ';
							} else {
								_tmp23_ = FALSE;
							}
							if (_tmp23_) {
								gchar* _tmp24_;
								_tmp24_ = g_strdup (attr->str);
								attr_list = g_slist_prepend (attr_list, _tmp24_);
								g_string_truncate (attr, (gsize) 0);
							} else {
								g_string_append_unichar (attr, c);
							}
						}
					}
				}
				_tmp25_ = string_index_of_nth_char (remaining, (glong) 1);
				remaining = (const gchar*) (((gchar*) remaining) + _tmp25_);
			}
		}
	}
	if (attr->len > 0) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup (attr->str);
		attr_list = g_slist_prepend (attr_list, _tmp26_);
	}
	_tmp27_ = g_slist_length (attr_list);
	_tmp28_ = g_new0 (gchar*, _tmp27_ + 1);
	attrs = _tmp28_;
	attrs_length1 = _tmp27_;
	_attrs_size_ = _tmp27_;
	attr_i = attr_list;
	{
		gint a;
		a = 0;
		{
			gboolean _tmp29_;
			_tmp29_ = TRUE;
			while (TRUE) {
				gchar* _tmp30_;
				gchar* *_tmp31_;
				gchar* _tmp32_;
				if (!_tmp29_) {
					a++;
					attr_i = attr_i->next;
				}
				_tmp29_ = FALSE;
				if (!(a < attrs_length1)) {
					break;
				}
				_tmp30_ = g_strdup ((const gchar*) attr_i->data);
				_tmp31_ = &attrs[(attrs_length1 - 1) - a];
				_tmp32_ = _tmp30_;
				_g_free0 ((*_tmp31_));
				(*_tmp31_) = _tmp32_;
			}
		}
	}
	_tmp33_ = attrs;
	*result_length1 = attrs_length1;
	result = _tmp33_;
	_g_string_free0 (attr);
	__g_slist_free__g_free0_0 (attr_list);
	_g_free0 (attributes);
	return result;
}


static gchar* vala_gidl_parser_eval (ValaGIdlParser* self, const gchar* s) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp3_ = strlen (s);
	if (_tmp3_ >= 2) {
		gboolean _tmp4_;
		_tmp4_ = g_str_has_prefix (s, "\"");
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_;
		_tmp5_ = g_str_has_suffix (s, "\"");
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp6_ = strlen (s);
		_tmp7_ = string_substring (s, (glong) 1, (glong) (_tmp6_ - 2));
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = g_strdup (s);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp10_;
	}
	result = _tmp0_;
	return result;
}


static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node) {
	ValaSignal* result = NULL;
	GIdlNode* node;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_;
	ValaSignal* _tmp5_ = NULL;
	ValaSignal* _tmp6_;
	ValaSignal* sig;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gint _tmp12_;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gboolean first;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig_node != NULL, NULL);
	node = (GIdlNode*) sig_node;
	if (sig_node->deprecated) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sig_node->result == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = vala_gidl_parser_fix_prop_name (self, node->name);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gidl_parser_parse_param (self, sig_node->result, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_signal_new (_tmp2_, _tmp4_, self->priv->current_source_reference, NULL);
	sig = (_tmp6_ = _tmp5_, _vala_code_node_unref0 (_tmp4_), _g_free0 (_tmp2_), _tmp6_);
	vala_symbol_set_access ((ValaSymbol*) sig, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp7_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_name ((ValaSymbol*) sig);
	_tmp10_ = g_strdup_printf ("%s::%s", _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = vala_gidl_parser_get_attributes (self, _tmp11_, &_tmp12_);
	attributes = (_tmp14_ = _tmp13_, _g_free0 (_tmp11_), _g_free0 (_tmp8_), _tmp14_);
	attributes_length1 = _tmp12_;
	_attributes_size_ = _tmp12_;
	if (attributes != NULL) {
		gchar* ns_name;
		ns_name = NULL;
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp15_;
				gchar* attr;
				_tmp15_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp15_;
				{
					gchar** _tmp16_;
					gchar** _tmp17_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					_tmp17_ = _tmp16_ = g_strsplit (attr, "=", 2);
					nv = _tmp17_;
					nv_length1 = _vala_array_length (_tmp16_);
					_nv_size_ = _vala_array_length (_tmp16_);
					if (g_strcmp0 (nv[0], "name") == 0) {
						const gchar* _tmp18_ = NULL;
						gchar* _tmp19_ = NULL;
						gchar* _tmp20_;
						_tmp18_ = vala_symbol_get_name ((ValaSymbol*) sig);
						vala_signal_set_cname (sig, _tmp18_);
						_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp20_ = _tmp19_;
						vala_symbol_set_name ((ValaSymbol*) sig, _tmp20_);
						_g_free0 (_tmp20_);
					} else {
						gboolean _tmp21_ = FALSE;
						if (g_strcmp0 (nv[0], "has_emitter") == 0) {
							gchar* _tmp22_ = NULL;
							gchar* _tmp23_;
							_tmp22_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp23_ = _tmp22_;
							_tmp21_ = g_strcmp0 (_tmp23_, "1") == 0;
							_g_free0 (_tmp23_);
						} else {
							_tmp21_ = FALSE;
						}
						if (_tmp21_) {
							vala_signal_set_has_emitter (sig, TRUE);
						} else {
							if (g_strcmp0 (nv[0], "hidden") == 0) {
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_;
								gboolean _tmp26_;
								_tmp24_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp25_ = _tmp24_;
								if ((_tmp26_ = g_strcmp0 (_tmp25_, "1") == 0, _g_free0 (_tmp25_), _tmp26_)) {
									result = NULL;
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									_g_free0 (ns_name);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (sig);
									return result;
								}
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp27_ = NULL;
									gchar* _tmp28_;
									gboolean _tmp29_;
									_tmp27_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp28_ = _tmp27_;
									if ((_tmp29_ = g_strcmp0 (_tmp28_, "1") == 0, _g_free0 (_tmp28_), _tmp29_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) sig, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp30_ = NULL;
										gchar* _tmp31_;
										_tmp30_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp31_ = _tmp30_;
										vala_symbol_set_replacement ((ValaSymbol*) sig, _tmp31_);
										_g_free0 (_tmp31_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp32_ = NULL;
											gchar* _tmp33_;
											_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp33_ = _tmp32_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) sig, _tmp33_);
											_g_free0 (_tmp33_);
										} else {
											if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
												gchar* _tmp34_ = NULL;
												gchar* _tmp35_;
												gboolean _tmp36_;
												_tmp34_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp35_ = _tmp34_;
												if ((_tmp36_ = g_strcmp0 (_tmp35_, "1") == 0, _g_free0 (_tmp35_), _tmp36_)) {
													ValaDataType* _tmp37_ = NULL;
													_tmp37_ = vala_signal_get_return_type (sig);
													vala_data_type_set_value_owned (_tmp37_, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "namespace_name") == 0) {
													gchar* _tmp38_ = NULL;
													gchar* _tmp39_;
													_tmp38_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp39_ = _tmp38_;
													_g_free0 (ns_name);
													ns_name = _tmp39_;
												} else {
													if (g_strcmp0 (nv[0], "type_name") == 0) {
														gchar* _tmp40_ = NULL;
														gchar* _tmp41_;
														ValaDataType* _tmp42_ = NULL;
														ValaDataType* _tmp43_;
														_tmp40_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp41_ = _tmp40_;
														_tmp42_ = vala_gidl_parser_parse_type_from_string (self, _tmp41_, FALSE, NULL);
														_tmp43_ = _tmp42_;
														vala_signal_set_return_type (sig, _tmp43_);
														_vala_code_node_unref0 (_tmp43_);
														_g_free0 (_tmp41_);
													} else {
														if (g_strcmp0 (nv[0], "type_arguments") == 0) {
															ValaDataType* _tmp44_ = NULL;
															gchar* _tmp45_ = NULL;
															gchar* _tmp46_;
															_tmp44_ = vala_signal_get_return_type (sig);
															_tmp45_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp46_ = _tmp45_;
															vala_gidl_parser_parse_type_arguments_from_string (self, _tmp44_, _tmp46_, NULL);
															_g_free0 (_tmp46_);
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
		if (ns_name != NULL) {
			ValaDataType* _tmp47_ = NULL;
			ValaUnresolvedSymbol* _tmp48_ = NULL;
			ValaUnresolvedSymbol* _tmp49_ = NULL;
			ValaUnresolvedSymbol* _tmp50_;
			_tmp47_ = vala_signal_get_return_type (sig);
			_tmp48_ = vala_unresolved_type_get_unresolved_symbol (VALA_UNRESOLVED_TYPE (_tmp47_));
			_tmp49_ = vala_unresolved_symbol_new (NULL, ns_name, NULL);
			_tmp50_ = _tmp49_;
			vala_unresolved_symbol_set_inner (_tmp48_, _tmp50_);
			_vala_code_node_unref0 (_tmp50_);
		}
		_g_free0 (ns_name);
	}
	vala_signal_set_is_virtual (sig, TRUE);
	first = TRUE;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = sig_node->parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				ValaParameterDirection direction = 0;
				ValaParameterDirection _tmp51_;
				ValaDataType* _tmp52_ = NULL;
				ValaDataType* param_type;
				ValaParameter* _tmp53_ = NULL;
				ValaParameter* p;
				gboolean hide_param;
				gboolean show_param;
				gchar* _tmp54_ = NULL;
				gchar* _tmp55_;
				const gchar* _tmp56_ = NULL;
				gchar* _tmp57_ = NULL;
				gchar* _tmp58_;
				gint _tmp59_;
				gchar** _tmp60_ = NULL;
				gchar** _tmp61_;
				gboolean _tmp109_ = FALSE;
				if (first) {
					first = FALSE;
					continue;
				}
				param_node = (GIdlNode*) param;
				_tmp52_ = vala_gidl_parser_parse_param (self, param, &_tmp51_);
				direction = _tmp51_;
				param_type = _tmp52_;
				_tmp53_ = vala_parameter_new (param_node->name, param_type, NULL);
				p = _tmp53_;
				vala_parameter_set_direction (p, direction);
				hide_param = FALSE;
				show_param = FALSE;
				_tmp54_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
				_tmp55_ = _tmp54_;
				_tmp56_ = vala_symbol_get_name ((ValaSymbol*) sig);
				_tmp57_ = g_strdup_printf ("%s::%s.%s", _tmp55_, _tmp56_, param_node->name);
				_tmp58_ = _tmp57_;
				_tmp60_ = vala_gidl_parser_get_attributes (self, _tmp58_, &_tmp59_);
				_tmp61_ = _tmp60_;
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes_length1 = _tmp59_;
				_attributes_size_ = attributes_length1;
				attributes = _tmp61_;
				_g_free0 (_tmp58_);
				_g_free0 (_tmp55_);
				if (attributes != NULL) {
					gchar* ns_name;
					ns_name = NULL;
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp62_;
							gchar* attr;
							_tmp62_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp62_;
							{
								gchar** _tmp63_;
								gchar** _tmp64_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								_tmp64_ = _tmp63_ = g_strsplit (attr, "=", 2);
								nv = _tmp64_;
								nv_length1 = _vala_array_length (_tmp63_);
								_nv_size_ = _vala_array_length (_tmp63_);
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp65_ = NULL;
									gchar* _tmp66_;
									gboolean _tmp67_;
									_tmp65_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp66_ = _tmp65_;
									if ((_tmp67_ = g_strcmp0 (_tmp66_, "1") == 0, _g_free0 (_tmp66_), _tmp67_)) {
										hide_param = TRUE;
									} else {
										gchar* _tmp68_ = NULL;
										gchar* _tmp69_;
										gboolean _tmp70_;
										_tmp68_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp69_ = _tmp68_;
										if ((_tmp70_ = g_strcmp0 (_tmp69_, "0") == 0, _g_free0 (_tmp69_), _tmp70_)) {
											show_param = TRUE;
										}
									}
								} else {
									if (g_strcmp0 (nv[0], "is_array") == 0) {
										gchar* _tmp71_ = NULL;
										gchar* _tmp72_;
										gboolean _tmp73_;
										_tmp71_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp72_ = _tmp71_;
										if ((_tmp73_ = g_strcmp0 (_tmp72_, "1") == 0, _g_free0 (_tmp72_), _tmp73_)) {
											ValaSourceReference* _tmp74_ = NULL;
											ValaArrayType* _tmp75_ = NULL;
											ValaDataType* _tmp76_;
											_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
											_tmp75_ = vala_array_type_new (param_type, 1, _tmp74_);
											_tmp76_ = (ValaDataType*) _tmp75_;
											_vala_code_node_unref0 (param_type);
											param_type = _tmp76_;
											vala_variable_set_variable_type ((ValaVariable*) p, param_type);
											vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
										}
									} else {
										if (g_strcmp0 (nv[0], "no_array_length") == 0) {
											gchar* _tmp77_ = NULL;
											gchar* _tmp78_;
											gboolean _tmp79_;
											_tmp77_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp78_ = _tmp77_;
											if ((_tmp79_ = g_strcmp0 (_tmp78_, "1") == 0, _g_free0 (_tmp78_), _tmp79_)) {
												vala_variable_set_no_array_length ((ValaVariable*) p, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "array_length_type") == 0) {
												gchar* _tmp80_ = NULL;
												gchar* _tmp81_;
												_tmp80_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp81_ = _tmp80_;
												vala_variable_set_array_length_type ((ValaVariable*) p, _tmp81_);
												_g_free0 (_tmp81_);
											} else {
												if (g_strcmp0 (nv[0], "array_null_terminated") == 0) {
													gchar* _tmp82_ = NULL;
													gchar* _tmp83_;
													gboolean _tmp84_;
													_tmp82_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp83_ = _tmp82_;
													if ((_tmp84_ = g_strcmp0 (_tmp83_, "1") == 0, _g_free0 (_tmp83_), _tmp84_)) {
														vala_variable_set_no_array_length ((ValaVariable*) p, TRUE);
														vala_variable_set_array_null_terminated ((ValaVariable*) p, TRUE);
													}
												} else {
													if (g_strcmp0 (nv[0], "is_out") == 0) {
														gchar* _tmp85_ = NULL;
														gchar* _tmp86_;
														gboolean _tmp87_;
														_tmp85_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp86_ = _tmp85_;
														if ((_tmp87_ = g_strcmp0 (_tmp86_, "1") == 0, _g_free0 (_tmp86_), _tmp87_)) {
															vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
														}
													} else {
														if (g_strcmp0 (nv[0], "is_ref") == 0) {
															gchar* _tmp88_ = NULL;
															gchar* _tmp89_;
															gboolean _tmp90_;
															_tmp88_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp89_ = _tmp88_;
															if ((_tmp90_ = g_strcmp0 (_tmp89_, "1") == 0, _g_free0 (_tmp89_), _tmp90_)) {
																vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
															}
														} else {
															if (g_strcmp0 (nv[0], "nullable") == 0) {
																gchar* _tmp91_ = NULL;
																gchar* _tmp92_;
																gboolean _tmp93_;
																_tmp91_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp92_ = _tmp91_;
																if ((_tmp93_ = g_strcmp0 (_tmp92_, "1") == 0, _g_free0 (_tmp92_), _tmp93_)) {
																	vala_data_type_set_nullable (param_type, TRUE);
																}
															} else {
																if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
																	gchar* _tmp94_ = NULL;
																	gchar* _tmp95_;
																	gboolean _tmp96_;
																	_tmp94_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp95_ = _tmp94_;
																	if ((_tmp96_ = g_strcmp0 (_tmp95_, "1") == 0, _g_free0 (_tmp95_), _tmp96_)) {
																		vala_data_type_set_value_owned (param_type, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "type_name") == 0) {
																		gchar* _tmp97_ = NULL;
																		gchar* _tmp98_;
																		ValaDataType* _tmp99_ = NULL;
																		ValaDataType* _tmp100_;
																		_tmp97_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp98_ = _tmp97_;
																		_tmp99_ = vala_gidl_parser_parse_type_from_string (self, _tmp98_, FALSE, NULL);
																		_tmp100_ = _tmp99_;
																		_vala_code_node_unref0 (param_type);
																		param_type = _tmp100_;
																		vala_variable_set_variable_type ((ValaVariable*) p, param_type);
																		_g_free0 (_tmp98_);
																	} else {
																		if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																			ValaDataType* _tmp101_ = NULL;
																			gchar* _tmp102_ = NULL;
																			gchar* _tmp103_;
																			_tmp101_ = vala_variable_get_variable_type ((ValaVariable*) p);
																			_tmp102_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp103_ = _tmp102_;
																			vala_gidl_parser_parse_type_arguments_from_string (self, _tmp101_, _tmp103_, NULL);
																			_g_free0 (_tmp103_);
																		} else {
																			if (g_strcmp0 (nv[0], "namespace_name") == 0) {
																				gchar* _tmp104_ = NULL;
																				gchar* _tmp105_;
																				_tmp104_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp105_ = _tmp104_;
																				_g_free0 (ns_name);
																				ns_name = _tmp105_;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
					if (ns_name != NULL) {
						ValaUnresolvedSymbol* _tmp106_ = NULL;
						ValaUnresolvedSymbol* _tmp107_ = NULL;
						ValaUnresolvedSymbol* _tmp108_;
						_tmp106_ = vala_unresolved_type_get_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type));
						_tmp107_ = vala_unresolved_symbol_new (NULL, ns_name, NULL);
						_tmp108_ = _tmp107_;
						vala_unresolved_symbol_set_inner (_tmp106_, _tmp108_);
						_vala_code_node_unref0 (_tmp108_);
					}
					_g_free0 (ns_name);
				}
				if (show_param) {
					_tmp109_ = TRUE;
				} else {
					_tmp109_ = !hide_param;
				}
				if (_tmp109_) {
					vala_signal_add_parameter (sig, p);
				}
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
			}
		}
	}
	result = sig;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ValaGIdlParser* vala_gidl_parser_construct (GType object_type) {
	ValaGIdlParser* self = NULL;
	self = (ValaGIdlParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIdlParser* vala_gidl_parser_new (void) {
	return vala_gidl_parser_construct (VALA_TYPE_GIDL_PARSER);
}


static void vala_gidl_parser_class_init (ValaGIdlParserClass * klass) {
	vala_gidl_parser_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gidl_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIdlParserPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_gidl_parser_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_gidl_parser_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_gidl_parser_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_gidl_parser_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_gidl_parser_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gidl_parser_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_gidl_parser_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_gidl_parser_real_visit_source_file;
}


static void vala_gidl_parser_instance_init (ValaGIdlParser * self) {
	self->priv = VALA_GIDL_PARSER_GET_PRIVATE (self);
}


static void vala_gidl_parser_finalize (ValaCodeVisitor* obj) {
	ValaGIdlParser * self;
	self = VALA_GIDL_PARSER (obj);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	_vala_code_node_unref0 (self->priv->current_namespace);
	_vala_code_node_unref0 (self->priv->current_data_type);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	_vala_map_unref0 (self->priv->cname_type_map);
	VALA_CODE_VISITOR_CLASS (vala_gidl_parser_parent_class)->finalize (obj);
}


/**
 * Code visitor parsing all GIDL files.
 */
GType vala_gidl_parser_get_type (void) {
	static volatile gsize vala_gidl_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gidl_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIdlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gidl_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIdlParser), 0, (GInstanceInitFunc) vala_gidl_parser_instance_init, NULL };
		GType vala_gidl_parser_type_id;
		vala_gidl_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIdlParser", &g_define_type_info, 0);
		g_once_init_leave (&vala_gidl_parser_type_id__volatile, vala_gidl_parser_type_id);
	}
	return vala_gidl_parser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



