/* valaarraymovemethod.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarraymovemethod.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>




enum  {
	VALA_ARRAY_MOVE_METHOD_DUMMY_PROPERTY
};
static gpointer vala_array_move_method_parent_class = NULL;



/**
 * Creates a new array move method.
 *
 * @return newly created method
 */
ValaArrayMoveMethod* vala_array_move_method_new (ValaSourceReference* source_reference) {
	ValaArrayMoveMethod * self;
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_ARRAY_MOVE_METHOD, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), "move");
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static void vala_array_move_method_class_init (ValaArrayMoveMethodClass * klass) {
	vala_array_move_method_parent_class = g_type_class_peek_parent (klass);
}


static void vala_array_move_method_init (ValaArrayMoveMethod * self) {
}


GType vala_array_move_method_get_type (void) {
	static GType vala_array_move_method_type_id = 0;
	if (G_UNLIKELY (vala_array_move_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayMoveMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_move_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayMoveMethod), 0, (GInstanceInitFunc) vala_array_move_method_init };
		vala_array_move_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaArrayMoveMethod", &g_define_type_info, 0);
	}
	return vala_array_move_method_type_id;
}




