/* valaconditionalexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaconditionalexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaConditionalExpressionPrivate {
	ValaExpression* _condition;
	ValaExpression* _true_expression;
	ValaExpression* _false_expression;
};
#define VALA_CONDITIONAL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionPrivate))
enum  {
	VALA_CONDITIONAL_EXPRESSION_DUMMY_PROPERTY,
	VALA_CONDITIONAL_EXPRESSION_CONDITION,
	VALA_CONDITIONAL_EXPRESSION_TRUE_EXPRESSION,
	VALA_CONDITIONAL_EXPRESSION_FALSE_EXPRESSION
};
static void vala_conditional_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_conditional_expression_real_is_pure (ValaExpression* base);
static gpointer vala_conditional_expression_parent_class = NULL;
static void vala_conditional_expression_dispose (GObject * obj);



/**
 * Creates a new conditional expression.
 *
 * @param cond       a condition
 * @param true_expr  expression to be evaluated if condition is true
 * @param false_expr expression to be evaluated if condition is false
 * @return           newly created conditional expression
 */
ValaConditionalExpression* vala_conditional_expression_new (ValaExpression* cond, ValaExpression* true_expr, ValaExpression* false_expr, ValaSourceReference* source) {
	GParameter * __params;
	GParameter * __params_it;
	ValaConditionalExpression * self;
	g_return_val_if_fail (cond == NULL || VALA_IS_EXPRESSION (cond), NULL);
	g_return_val_if_fail (true_expr == NULL || VALA_IS_EXPRESSION (true_expr), NULL);
	g_return_val_if_fail (false_expr == NULL || VALA_IS_EXPRESSION (false_expr), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	__params_it->name = "condition";
	g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION);
	g_value_set_object (&__params_it->value, cond);
	__params_it++;
	__params_it->name = "true-expression";
	g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION);
	g_value_set_object (&__params_it->value, true_expr);
	__params_it++;
	__params_it->name = "false-expression";
	g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION);
	g_value_set_object (&__params_it->value, false_expr);
	__params_it++;
	self = g_object_newv (VALA_TYPE_CONDITIONAL_EXPRESSION, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_conditional_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaConditionalExpression * self;
	self = VALA_CONDITIONAL_EXPRESSION (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_condition), visitor);
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_true_expression), visitor);
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_false_expression), visitor);
	vala_code_visitor_visit_conditional_expression (visitor, self);
}


static gboolean vala_conditional_expression_real_is_pure (ValaExpression* base) {
	ValaConditionalExpression * self;
	self = VALA_CONDITIONAL_EXPRESSION (base);
	return vala_expression_is_pure (self->priv->_condition) && vala_expression_is_pure (self->priv->_true_expression) && vala_expression_is_pure (self->priv->_false_expression);
}


ValaExpression* vala_conditional_expression_get_condition (ValaConditionalExpression* self) {
	g_return_val_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (self), NULL);
	return self->priv->_condition;
}


void vala_conditional_expression_set_condition (ValaConditionalExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_condition = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL))), _tmp2);
}


ValaExpression* vala_conditional_expression_get_true_expression (ValaConditionalExpression* self) {
	g_return_val_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (self), NULL);
	return self->priv->_true_expression;
}


void vala_conditional_expression_set_true_expression (ValaConditionalExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_true_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_true_expression == NULL ? NULL : (self->priv->_true_expression = (g_object_unref (self->priv->_true_expression), NULL))), _tmp2);
}


ValaExpression* vala_conditional_expression_get_false_expression (ValaConditionalExpression* self) {
	g_return_val_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (self), NULL);
	return self->priv->_false_expression;
}


void vala_conditional_expression_set_false_expression (ValaConditionalExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_false_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_false_expression == NULL ? NULL : (self->priv->_false_expression = (g_object_unref (self->priv->_false_expression), NULL))), _tmp2);
}


static void vala_conditional_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaConditionalExpression * self;
	self = VALA_CONDITIONAL_EXPRESSION (object);
	switch (property_id) {
		case VALA_CONDITIONAL_EXPRESSION_CONDITION:
		g_value_set_object (value, vala_conditional_expression_get_condition (self));
		break;
		case VALA_CONDITIONAL_EXPRESSION_TRUE_EXPRESSION:
		g_value_set_object (value, vala_conditional_expression_get_true_expression (self));
		break;
		case VALA_CONDITIONAL_EXPRESSION_FALSE_EXPRESSION:
		g_value_set_object (value, vala_conditional_expression_get_false_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_conditional_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaConditionalExpression * self;
	self = VALA_CONDITIONAL_EXPRESSION (object);
	switch (property_id) {
		case VALA_CONDITIONAL_EXPRESSION_CONDITION:
		vala_conditional_expression_set_condition (self, g_value_get_object (value));
		break;
		case VALA_CONDITIONAL_EXPRESSION_TRUE_EXPRESSION:
		vala_conditional_expression_set_true_expression (self, g_value_get_object (value));
		break;
		case VALA_CONDITIONAL_EXPRESSION_FALSE_EXPRESSION:
		vala_conditional_expression_set_false_expression (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_conditional_expression_class_init (ValaConditionalExpressionClass * klass) {
	vala_conditional_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaConditionalExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_conditional_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_conditional_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_conditional_expression_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_conditional_expression_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_conditional_expression_real_is_pure;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CONDITIONAL_EXPRESSION_CONDITION, g_param_spec_object ("condition", "condition", "condition", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CONDITIONAL_EXPRESSION_TRUE_EXPRESSION, g_param_spec_object ("true-expression", "true-expression", "true-expression", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CONDITIONAL_EXPRESSION_FALSE_EXPRESSION, g_param_spec_object ("false-expression", "false-expression", "false-expression", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_conditional_expression_init (ValaConditionalExpression * self) {
	self->priv = VALA_CONDITIONAL_EXPRESSION_GET_PRIVATE (self);
}


static void vala_conditional_expression_dispose (GObject * obj) {
	ValaConditionalExpression * self;
	self = VALA_CONDITIONAL_EXPRESSION (obj);
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL)));
	(self->priv->_true_expression == NULL ? NULL : (self->priv->_true_expression = (g_object_unref (self->priv->_true_expression), NULL)));
	(self->priv->_false_expression == NULL ? NULL : (self->priv->_false_expression = (g_object_unref (self->priv->_false_expression), NULL)));
	G_OBJECT_CLASS (vala_conditional_expression_parent_class)->dispose (obj);
}


GType vala_conditional_expression_get_type (void) {
	static GType vala_conditional_expression_type_id = 0;
	if (G_UNLIKELY (vala_conditional_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaConditionalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_conditional_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaConditionalExpression), 0, (GInstanceInitFunc) vala_conditional_expression_init };
		vala_conditional_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaConditionalExpression", &g_define_type_info, 0);
	}
	return vala_conditional_expression_type_id;
}




