/* valaccodebinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodebinding.h>
#include <vala/valatypesymbol.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodecommaexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valacodegenerator.h>
#include <gobject/valaccodegenerator.h>
#include <gobject/valaccodemethodbinding.h>
#include <gobject/valaccodearraycreationexpressionbinding.h>
#include <gobject/valaccodeelementaccessbinding.h>
#include <gobject/valaccodeassignmentbinding.h>




struct _ValaCCodeBindingPrivate {
	ValaCCodeGenerator* _codegen;
};
#define VALA_CCODE_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BINDING, ValaCCodeBindingPrivate))
enum  {
	VALA_CCODE_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_BINDING_CODEGEN
};
static void vala_ccode_binding_real_emit (ValaCCodeBinding* self);
static gpointer vala_ccode_binding_parent_class = NULL;
static void vala_ccode_binding_dispose (GObject * obj);



/**
 * Generate code for this source code node.
 */
static void vala_ccode_binding_real_emit (ValaCCodeBinding* self) {
	g_return_if_fail (VALA_IS_CCODE_BINDING (self));
}


void vala_ccode_binding_emit (ValaCCodeBinding* self) {
	VALA_CCODE_BINDING_GET_CLASS (self)->emit (self);
}


ValaCCodeIdentifier* vala_ccode_binding_get_value_setter_function (ValaCCodeBinding* self, ValaDataType* type_reference) {
	g_return_val_if_fail (VALA_IS_CCODE_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type_reference), NULL);
	if (vala_data_type_get_data_type (type_reference) != NULL) {
		char* _tmp0;
		ValaCCodeIdentifier* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (type_reference)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	} else {
		return vala_ccode_identifier_new ("g_value_set_pointer");
	}
}


ValaCCodeExpression* vala_ccode_binding_get_construct_property_assignment (ValaCCodeBinding* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value) {
	ValaCCodeIdentifier* cpointer;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeMemberAccess* cnamemember;
	ValaCCodeAssignment* cnameassign;
	ValaCCodeMemberAccess* _tmp0;
	ValaCCodeUnaryExpression* _tmp1;
	ValaCCodeUnaryExpression* gvaluearg;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* cvalueinit;
	ValaCCodeIdentifier* _tmp5;
	char* _tmp4;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeFunctionCall* _tmp7;
	ValaCCodeFunctionCall* cvalueset;
	ValaCCodeUnaryExpression* _tmp8;
	ValaCCodeCommaExpression* _tmp9;
	g_return_val_if_fail (VALA_IS_CCODE_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_CONSTANT (canonical_cconstant), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (property_type), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (value), NULL);
	/* this property is used as a construction parameter*/
	cpointer = vala_ccode_identifier_new ("__params_it");
	ccomma = vala_ccode_comma_expression_new ();
	/* set name in array for current parameter*/
	cnamemember = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "name");
	cnameassign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cnamemember), VALA_CCODE_EXPRESSION (canonical_cconstant), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cnameassign));
	_tmp0 = NULL;
	_tmp1 = NULL;
	gvaluearg = (_tmp1 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "value")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	/* initialize GValue in array for current parameter*/
	_tmp2 = NULL;
	_tmp3 = NULL;
	cvalueinit = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("g_value_init")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION (gvaluearg));
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_data_type_get_type_id (property_type))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueinit));
	/* set GValue for current parameter*/
	_tmp6 = NULL;
	_tmp7 = NULL;
	cvalueset = (_tmp7 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_binding_get_value_setter_function (self, property_type)))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
	vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (gvaluearg));
	vala_ccode_function_call_add_argument (cvalueset, value);
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueset));
	/* move pointer to next parameter in array*/
	_tmp8 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, VALA_CCODE_EXPRESSION (cpointer)))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	return VALA_CCODE_EXPRESSION ((_tmp9 = ccomma, (cpointer == NULL ? NULL : (cpointer = (g_object_unref (cpointer), NULL))), (cnamemember == NULL ? NULL : (cnamemember = (g_object_unref (cnamemember), NULL))), (cnameassign == NULL ? NULL : (cnameassign = (g_object_unref (cnameassign), NULL))), (gvaluearg == NULL ? NULL : (gvaluearg = (g_object_unref (gvaluearg), NULL))), (cvalueinit == NULL ? NULL : (cvalueinit = (g_object_unref (cvalueinit), NULL))), (cvalueset == NULL ? NULL : (cvalueset = (g_object_unref (cvalueset), NULL))), _tmp9));
}


ValaCCodeBinding* vala_ccode_binding_code_binding (ValaCCodeBinding* self, ValaCodeNode* node) {
	g_return_val_if_fail (VALA_IS_CCODE_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (node), NULL);
	return VALA_CCODE_BINDING (vala_code_node_get_code_binding (node, VALA_CODE_GENERATOR (self->priv->_codegen)));
}


ValaCCodeMethodBinding* vala_ccode_binding_method_binding (ValaCCodeBinding* self, ValaMethod* node) {
	g_return_val_if_fail (VALA_IS_CCODE_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (node), NULL);
	return VALA_CCODE_METHOD_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (node), VALA_CODE_GENERATOR (self->priv->_codegen)));
}


ValaCCodeArrayCreationExpressionBinding* vala_ccode_binding_array_creation_expression_binding (ValaCCodeBinding* self, ValaArrayCreationExpression* node) {
	g_return_val_if_fail (VALA_IS_CCODE_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (node), NULL);
	return VALA_CCODE_ARRAY_CREATION_EXPRESSION_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (node), VALA_CODE_GENERATOR (self->priv->_codegen)));
}


ValaCCodeElementAccessBinding* vala_ccode_binding_element_access_binding (ValaCCodeBinding* self, ValaElementAccess* node) {
	g_return_val_if_fail (VALA_IS_CCODE_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_ELEMENT_ACCESS (node), NULL);
	return VALA_CCODE_ELEMENT_ACCESS_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (node), VALA_CODE_GENERATOR (self->priv->_codegen)));
}


ValaCCodeAssignmentBinding* vala_ccode_binding_assignment_binding (ValaCCodeBinding* self, ValaAssignment* node) {
	g_return_val_if_fail (VALA_IS_CCODE_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_ASSIGNMENT (node), NULL);
	return VALA_CCODE_ASSIGNMENT_BINDING (vala_code_node_get_code_binding (VALA_CODE_NODE (node), VALA_CODE_GENERATOR (self->priv->_codegen)));
}


/**
 * The link between a source code node and generated code.
 */
ValaCCodeBinding* vala_ccode_binding_new (void) {
	ValaCCodeBinding * self;
	self = g_object_newv (VALA_TYPE_CCODE_BINDING, 0, NULL);
	return self;
}


ValaCCodeGenerator* vala_ccode_binding_get_codegen (ValaCCodeBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_BINDING (self), NULL);
	return self->priv->_codegen;
}


void vala_ccode_binding_set_codegen (ValaCCodeBinding* self, ValaCCodeGenerator* value) {
	ValaCCodeGenerator* _tmp2;
	ValaCCodeGenerator* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_codegen = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_codegen == NULL ? NULL : (self->priv->_codegen = (g_object_unref (self->priv->_codegen), NULL))), _tmp2);
}


static void vala_ccode_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeBinding * self;
	self = VALA_CCODE_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_BINDING_CODEGEN:
		g_value_set_object (value, vala_ccode_binding_get_codegen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeBinding * self;
	self = VALA_CCODE_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_BINDING_CODEGEN:
		vala_ccode_binding_set_codegen (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_binding_class_init (ValaCCodeBindingClass * klass) {
	vala_ccode_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_BINDING_CODEGEN, g_param_spec_object ("codegen", "codegen", "codegen", VALA_TYPE_CCODE_GENERATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_binding_init (ValaCCodeBinding * self) {
	self->priv = VALA_CCODE_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_binding_dispose (GObject * obj) {
	ValaCCodeBinding * self;
	self = VALA_CCODE_BINDING (obj);
	(self->priv->_codegen == NULL ? NULL : (self->priv->_codegen = (g_object_unref (self->priv->_codegen), NULL)));
	G_OBJECT_CLASS (vala_ccode_binding_parent_class)->dispose (obj);
}


GType vala_ccode_binding_get_type (void) {
	static GType vala_ccode_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBinding), 0, (GInstanceInitFunc) vala_ccode_binding_init };
		vala_ccode_binding_type_id = g_type_register_static (VALA_TYPE_CODE_BINDING, "ValaCCodeBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_binding_type_id;
}




