/* valaccodeinvocationexpressionbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeinvocationexpressionbinding.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamethod.h>
#include <gee/collection.h>
#include <vala/valamemberaccess.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignaltype.h>
#include <gee/hashmap.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraytype.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valamember.h>
#include <vala/valatypesymbol.h>
#include <vala/valastruct.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valalocalvariable.h>
#include <gee/list.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valasymbol.h>
#include <vala/valaclass.h>
#include <vala/valadynamicmethod.h>
#include <vala/valaunaryexpression.h>
#include <vala/valaformalparameter.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gee/arraylist.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <vala/valanulltype.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valapointertype.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodedynamicmethodbinding.h>




struct _ValaCCodeInvocationExpressionBindingPrivate {
	ValaInvocationExpression* _invocation_expression;
};

#define VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, ValaCCodeInvocationExpressionBindingPrivate))
enum  {
	VALA_CCODE_INVOCATION_EXPRESSION_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION
};
static void vala_ccode_invocation_expression_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_invocation_expression_binding_parent_class = NULL;
static void vala_ccode_invocation_expression_binding_dispose (GObject * obj);



ValaCCodeInvocationExpressionBinding* vala_ccode_invocation_expression_binding_new (ValaCCodeGenerator* codegen, ValaInvocationExpression* invocation_expression) {
	ValaCCodeInvocationExpressionBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_INVOCATION_EXPRESSION (invocation_expression), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, 0, NULL);
	vala_ccode_invocation_expression_binding_set_invocation_expression (self, invocation_expression);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_invocation_expression_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeInvocationExpressionBinding * self;
	ValaInvocationExpression* _tmp0;
	ValaInvocationExpression* expr;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeCollection* params;
	ValaMemberAccess* _tmp1;
	ValaMemberAccess* ma;
	ValaDataType* _tmp2;
	ValaDataType* itype;
	GeeCollection* _tmp3;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeExpression* ccall_expr;
	GeeHashMap* carg_map;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	gint last_pos;
	gint min_pos;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (base);
	_tmp0 = NULL;
	expr = (_tmp0 = self->priv->_invocation_expression, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))));
	m = NULL;
	params = NULL;
	if (!(VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)))) {
		vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "unsupported method invocation");
		(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		return;
	}
	_tmp1 = NULL;
	ma = (_tmp1 = VALA_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	itype = (_tmp2 = vala_expression_get_static_type (vala_invocation_expression_get_call (expr)), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	params = (_tmp3 = vala_data_type_get_parameters (itype), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp3);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp5;
		ValaMethod* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		m = (_tmp5 = (_tmp4 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (itype))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), _tmp5);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaCCodeFunctionCall* _tmp7;
			ValaCCodeFunctionCall* _tmp6;
			_tmp7 = NULL;
			_tmp6 = NULL;
			ccall = (_tmp7 = (_tmp6 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp7);
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp8 = NULL;
	ccall_expr = VALA_CCODE_EXPRESSION ((_tmp8 = ccall, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))));
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp9;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp11;
		char* _tmp10;
		_tmp9 = NULL;
		array_type = (_tmp9 = VALA_ARRAY_TYPE (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
		_tmp11 = NULL;
		_tmp10 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) 0), FALSE)), (_tmp11 = vala_ccode_identifier_new ((_tmp10 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type))))));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		_tmp10 = (g_free (_tmp10), NULL);
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaMethod* _tmp12;
		ValaMethod* base_method;
		ValaDataType* instance_expression_type;
		_tmp12 = NULL;
		base_method = (_tmp12 = m, (_tmp12 == NULL ? NULL : g_object_ref (_tmp12)));
		if (vala_method_get_base_method (m) != NULL) {
			ValaMethod* _tmp14;
			ValaMethod* _tmp13;
			_tmp14 = NULL;
			_tmp13 = NULL;
			base_method = (_tmp14 = (_tmp13 = vala_method_get_base_method (m), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp14);
		} else {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaMethod* _tmp16;
				ValaMethod* _tmp15;
				_tmp16 = NULL;
				_tmp15 = NULL;
				base_method = (_tmp16 = (_tmp15 = vala_method_get_base_interface_method (m), (_tmp15 == NULL ? NULL : g_object_ref (_tmp15))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp16);
			}
		}
		instance_expression_type = NULL;
		if (vala_member_access_get_inner (ma) == NULL) {
			ValaCCodeExpression* _tmp17;
			ValaDataType* _tmp18;
			_tmp17 = NULL;
			instance = (_tmp17 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp17);
			_tmp18 = NULL;
			instance_expression_type = (_tmp18 = vala_ccode_generator_get_data_type_for_symbol (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), (instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL))), _tmp18);
		} else {
			ValaCCodeExpression* _tmp20;
			ValaCCodeExpression* _tmp19;
			ValaDataType* _tmp22;
			ValaDataType* _tmp21;
			_tmp20 = NULL;
			_tmp19 = NULL;
			instance = (_tmp20 = (_tmp19 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp19 == NULL ? NULL : g_object_ref (_tmp19))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp20);
			_tmp22 = NULL;
			_tmp21 = NULL;
			instance_expression_type = (_tmp22 = (_tmp21 = vala_expression_get_static_type (vala_member_access_get_inner (ma)), (_tmp21 == NULL ? NULL : g_object_ref (_tmp21))), (instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL))), _tmp22);
		}
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (instance_expression_type)) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (instance_expression_type)))) && vala_data_type_get_data_type (instance_expression_type) != vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol) {
			if (VALA_IS_CCODE_IDENTIFIER (instance) || VALA_IS_CCODE_MEMBER_ACCESS (instance)) {
				ValaCCodeExpression* _tmp23;
				_tmp23 = NULL;
				instance = (_tmp23 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp23);
			} else {
				ValaCCodeCommaExpression* ccomma;
				ValaLocalVariable* temp_var;
				ValaCCodeAssignment* _tmp25;
				ValaCCodeIdentifier* _tmp24;
				ValaCCodeUnaryExpression* _tmp27;
				ValaCCodeIdentifier* _tmp26;
				ValaCCodeExpression* _tmp29;
				ValaCCodeCommaExpression* _tmp28;
				/* if instance is e.g. a function call, we can't take the address of the expression
				 (tmp = expr, &tmp)*/
				ccomma = vala_ccode_comma_expression_new ();
				temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), instance_expression_type, TRUE, NULL);
				gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
				_tmp25 = NULL;
				_tmp24 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				_tmp27 = NULL;
				_tmp26 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)))))))));
				(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
				(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
				_tmp29 = NULL;
				_tmp28 = NULL;
				instance = (_tmp29 = VALA_CCODE_EXPRESSION ((_tmp28 = ccomma, (_tmp28 == NULL ? NULL : g_object_ref (_tmp28)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp29);
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
			}
		}
		/* parent_symbol may be null for late bound methods*/
		if (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method)) != NULL) {
			ValaDataType* instance_target_type;
			ValaCCodeExpression* _tmp30;
			instance_target_type = vala_data_type_copy (vala_expression_get_static_type (VALA_EXPRESSION (ma)));
			vala_data_type_set_data_type (instance_target_type, VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method))));
			_tmp30 = NULL;
			instance = (_tmp30 = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), instance, instance_expression_type, instance_target_type), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp30);
			(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
		(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
	} else {
		if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
			ValaClass* _tmp31;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp34;
			char* _tmp33;
			char* _tmp32;
			ValaCCodeFunctionCall* _tmp35;
			ValaCCodeFunctionCall* cast;
			ValaCCodeIdentifier* _tmp36;
			_tmp31 = NULL;
			cl = (_tmp31 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp31 == NULL ? NULL : g_object_ref (_tmp31)));
			_tmp34 = NULL;
			_tmp33 = NULL;
			_tmp32 = NULL;
			_tmp35 = NULL;
			cast = (_tmp35 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ((_tmp33 = g_strconcat ((_tmp32 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)), "_CLASS", NULL)))))), (_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL))), (_tmp33 = (g_free (_tmp33), NULL)), (_tmp32 = (g_free (_tmp32), NULL)), _tmp35);
			_tmp36 = NULL;
			vala_ccode_function_call_add_argument (cast, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("klass"))));
			(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), cast);
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			(cast == NULL ? NULL : (cast = (g_object_unref (cast), NULL)));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp37;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp38;
		ValaCCodeFunctionCall* _tmp39;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp41;
		char* _tmp40;
		_tmp37 = NULL;
		array_type = (_tmp37 = VALA_ARRAY_TYPE (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (_tmp37 == NULL ? NULL : g_object_ref (_tmp37)));
		_tmp38 = NULL;
		_tmp39 = NULL;
		csizeof = (_tmp39 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("sizeof")))), (_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL))), _tmp39);
		_tmp41 = NULL;
		_tmp40 = NULL;
		vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ((_tmp40 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
		(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
		_tmp40 = (g_free (_tmp40), NULL);
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1, FALSE)), csizeof);
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			ValaCCodeDynamicMethodBinding* _tmp50;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeCollection* arg_collection;
				GeeIterator* arg_it;
				arg_collection = vala_invocation_expression_get_argument_list (expr);
				arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = ((ValaExpression*) gee_iterator_get (arg_it));
					{
						ValaUnaryExpression* _tmp43;
						ValaExpression* _tmp42;
						ValaUnaryExpression* unary;
						_tmp43 = NULL;
						_tmp42 = NULL;
						unary = (_tmp43 = (_tmp42 = arg, (VALA_IS_UNARY_EXPRESSION (_tmp42) ? ((ValaUnaryExpression*) _tmp42) : NULL)), (_tmp43 == NULL ? NULL : g_object_ref (_tmp43)));
						if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT) {
							char* _tmp44;
							ValaFormalParameter* _tmp45;
							ValaFormalParameter* param;
							/* out argument*/
							_tmp44 = NULL;
							_tmp45 = NULL;
							param = (_tmp45 = vala_formal_parameter_new ((_tmp44 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_static_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp44 = (g_free (_tmp44), NULL)), _tmp45);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
							vala_method_add_parameter (m, param);
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						} else {
							if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF) {
								char* _tmp46;
								ValaFormalParameter* _tmp47;
								ValaFormalParameter* param;
								/* ref argument*/
								_tmp46 = NULL;
								_tmp47 = NULL;
								param = (_tmp47 = vala_formal_parameter_new ((_tmp46 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_static_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp46 = (g_free (_tmp46), NULL)), _tmp47);
								vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
								vala_method_add_parameter (m, param);
								(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
							} else {
								ValaFormalParameter* _tmp49;
								char* _tmp48;
								/* in argument*/
								_tmp49 = NULL;
								_tmp48 = NULL;
								vala_method_add_parameter (m, (_tmp49 = vala_formal_parameter_new ((_tmp48 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_static_type (arg), NULL)));
								(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
								_tmp48 = (g_free (_tmp48), NULL);
							}
						}
						param_nr++;
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
				(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
			}
			{
				GeeCollection* param_collection;
				GeeIterator* param_it;
				param_collection = vala_method_get_parameters (m);
				param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
				while (gee_iterator_next (param_it)) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) gee_iterator_get (param_it));
					{
						vala_code_node_accept (VALA_CODE_NODE (param), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
				(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
			}
			_tmp50 = NULL;
			vala_ccode_dynamic_method_binding_generate_wrapper ((_tmp50 = vala_ccode_generator_dynamic_method_binding (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DYNAMIC_METHOD (m))));
			(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	{
		GeeCollection* arg_collection;
		GeeIterator* arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaExpression* arg;
			arg = ((ValaExpression*) gee_iterator_get (arg_it));
			{
				ValaCCodeExpression* _tmp51;
				ValaCCodeExpression* cexpr;
				GeeList* extra_args;
				_tmp51 = NULL;
				cexpr = (_tmp51 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (_tmp51 == NULL ? NULL : g_object_ref (_tmp51)));
				extra_args = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
				if (gee_iterator_next (params_it)) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) gee_iterator_get (params_it));
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						gboolean multiple_cargs;
						/* if the vala argument expands to multiple C arguments,
						 we have to make sure that the C arguments don't depend
						 on each other as there is no guaranteed argument
						 evaluation order
						 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
						multiple_cargs = FALSE;
						if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))) {
							ValaArrayType* _tmp52;
							ValaArrayType* array_type;
							_tmp52 = NULL;
							array_type = (_tmp52 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp52 == NULL ? NULL : g_object_ref (_tmp52)));
							{
								gint dim;
								dim = 1;
								for (; dim <= vala_array_type_get_rank (array_type); dim++) {
									ValaCCodeExpression* _tmp53;
									_tmp53 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp53 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg, dim)));
									(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
								}
							}
							multiple_cargs = TRUE;
							(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
						} else {
							if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param))) {
								ValaDelegateType* _tmp54;
								ValaDelegateType* deleg_type;
								ValaDelegate* _tmp55;
								ValaDelegate* d;
								_tmp54 = NULL;
								deleg_type = (_tmp54 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp54 == NULL ? NULL : g_object_ref (_tmp54)));
								_tmp55 = NULL;
								d = (_tmp55 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp55 == NULL ? NULL : g_object_ref (_tmp55)));
								if (vala_delegate_get_has_target (d)) {
									ValaCCodeExpression* _tmp56;
									_tmp56 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (_tmp56 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg)));
									(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
									multiple_cargs = TRUE;
								}
								(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
								(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
							} else {
								if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_type_reference (param))) {
									ValaCCodeExpression* _tmp57;
									_tmp57 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (_tmp57 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg)));
									(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
									multiple_cargs = TRUE;
								}
							}
						}
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
							ValaCCodeExpression* _tmp58;
							/* don't cast arguments passed by reference*/
							_tmp58 = NULL;
							cexpr = (_tmp58 = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cexpr, vala_expression_get_static_type (arg), vala_formal_parameter_get_type_reference (param)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp58);
						}
						/* pass non-simple struct instances always by reference*/
						if (!(VALA_IS_NULL_TYPE (vala_expression_get_static_type (arg))) && VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)))))) {
							/* we already use a reference for arguments of ref and out parameters*/
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
								if (VALA_IS_CCODE_IDENTIFIER (cexpr)) {
									ValaCCodeExpression* _tmp59;
									_tmp59 = NULL;
									cexpr = (_tmp59 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp59);
								} else {
									ValaCCodeCommaExpression* ccomma;
									ValaLocalVariable* temp_var;
									ValaCCodeAssignment* _tmp61;
									ValaCCodeIdentifier* _tmp60;
									ValaCCodeUnaryExpression* _tmp63;
									ValaCCodeIdentifier* _tmp62;
									ValaCCodeExpression* _tmp65;
									ValaCCodeCommaExpression* _tmp64;
									/* if cexpr is e.g. a function call, we can't take the address of the expression
									 (tmp = expr, &tmp)*/
									ccomma = vala_ccode_comma_expression_new ();
									temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_static_type (arg), TRUE, NULL);
									gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
									_tmp61 = NULL;
									_tmp60 = NULL;
									vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
									(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
									(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
									_tmp63 = NULL;
									_tmp62 = NULL;
									vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)))))))));
									(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
									(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
									_tmp65 = NULL;
									_tmp64 = NULL;
									cexpr = (_tmp65 = VALA_CCODE_EXPRESSION ((_tmp64 = ccomma, (_tmp64 == NULL ? NULL : g_object_ref (_tmp64)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp65);
									(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
									(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
								}
							}
						}
						if (multiple_cargs && VALA_IS_INVOCATION_EXPRESSION (arg)) {
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_decl;
							ValaCCodeAssignment* _tmp67;
							ValaCCodeIdentifier* _tmp66;
							ValaCCodeExpression* _tmp68;
							ValaCCodeExpression* _tmp70;
							ValaCCodeCommaExpression* _tmp69;
							/* if vala argument is invocation expression
							 the auxiliary C argument(s) will depend on the main C argument
							 (tmp = arg1, call (tmp, arg2, arg3,...))*/
							ccomma = vala_ccode_comma_expression_new ();
							temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_static_type (arg), TRUE, NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
							_tmp67 = NULL;
							_tmp66 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
							(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
							_tmp68 = NULL;
							cexpr = (_tmp68 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp68);
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							_tmp70 = NULL;
							_tmp69 = NULL;
							ccall_expr = (_tmp70 = VALA_CCODE_EXPRESSION ((_tmp69 = ccomma, (_tmp69 == NULL ? NULL : g_object_ref (_tmp69)))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp70);
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
						}
						/* unref old value for non-null non-weak out arguments*/
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT && vala_data_type_get_takes_ownership (vala_formal_parameter_get_type_reference (param)) && !(VALA_IS_NULL_TYPE (vala_expression_get_static_type (arg)))) {
							ValaUnaryExpression* _tmp71;
							ValaUnaryExpression* unary;
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_var;
							ValaCCodeExpression* _tmp73;
							ValaCCodeIdentifier* _tmp72;
							ValaLocalVariable* ret_temp_var;
							ValaCCodeExpression* _tmp77;
							ValaCCodeAssignment* _tmp79;
							ValaCCodeIdentifier* _tmp78;
							ValaCCodeExpression* _tmp82;
							ValaCCodeCommaExpression* _tmp81;
							_tmp71 = NULL;
							unary = (_tmp71 = VALA_UNARY_EXPRESSION (arg), (_tmp71 == NULL ? NULL : g_object_ref (_tmp71)));
							/* (ret_tmp = call (&tmp), free (var1), var1 = tmp, ret_tmp)*/
							ccomma = vala_ccode_comma_expression_new ();
							temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_static_type (vala_unary_expression_get_inner (unary)), TRUE, NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
							_tmp73 = NULL;
							_tmp72 = NULL;
							cexpr = (_tmp73 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp73);
							(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
							/* call function*/
							ret_temp_var = NULL;
							if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
								vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							} else {
								ValaLocalVariable* _tmp74;
								ValaCCodeAssignment* _tmp76;
								ValaCCodeIdentifier* _tmp75;
								_tmp74 = NULL;
								ret_temp_var = (_tmp74 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_return_type (m), TRUE, NULL), (ret_temp_var == NULL ? NULL : (ret_temp_var = (g_object_unref (ret_temp_var), NULL))), _tmp74);
								gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, ret_temp_var);
								_tmp76 = NULL;
								_tmp75 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_var))))), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
								(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
							}
							/* unref old value*/
							_tmp77 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (_tmp77 = vala_ccode_generator_get_unref_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), vala_expression_get_static_type (arg), arg)));
							(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
							/* assign new value*/
							_tmp79 = NULL;
							_tmp78 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
							(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
							/* return value*/
							if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
								ValaCCodeIdentifier* _tmp80;
								_tmp80 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_var))))));
								(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
							}
							_tmp82 = NULL;
							_tmp81 = NULL;
							ccall_expr = (_tmp82 = VALA_CCODE_EXPRESSION ((_tmp81 = ccomma, (_tmp81 == NULL ? NULL : g_object_ref (_tmp81)))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp82);
							(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
							(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
							(ret_temp_var == NULL ? NULL : (ret_temp_var = (g_object_unref (ret_temp_var), NULL)));
						}
					}
					arg_pos = vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), ellipsis);
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				} else {
					/* default argument position*/
					arg_pos = vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) i), ellipsis);
				}
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (arg_pos), cexpr);
				i++;
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
				(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
				(extra_args == NULL ? NULL : (extra_args = (g_object_unref (extra_args), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	while (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		param = ((ValaFormalParameter*) gee_iterator_get (params_it));
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* _tmp83;
			_tmp83 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (_tmp83 = g_strdup_printf ("no default expression for argument %d", i)));
			_tmp83 = (g_free (_tmp83), NULL);
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
			(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
			(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
			(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_type_reference (param) != NULL && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))) {
			ValaArrayType* _tmp84;
			ValaArrayType* array_type;
			_tmp84 = NULL;
			array_type = (_tmp84 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp84 == NULL ? NULL : g_object_ref (_tmp84)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeExpression* _tmp85;
					_tmp85 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp85 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_default_expression (param), dim)));
					(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
		i++;
		(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m))) {
		ValaArrayType* _tmp86;
		ValaArrayType* array_type;
		_tmp86 = NULL;
		array_type = (_tmp86 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp86 == NULL ? NULL : g_object_ref (_tmp86)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* _tmp87;
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					_tmp87 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), (_tmp87 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref))));
					(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (temp_ref));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* _tmp88;
					_tmp88 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_constant_new ("-1"))));
					(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
				}
			}
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (m != NULL && VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
			ValaDelegateType* _tmp89;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp90;
			ValaDelegate* d;
			_tmp89 = NULL;
			deleg_type = (_tmp89 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp89 == NULL ? NULL : g_object_ref (_tmp89)));
			_tmp90 = NULL;
			d = (_tmp90 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp90 == NULL ? NULL : g_object_ref (_tmp90)));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp92;
				ValaVoidType* _tmp91;
				ValaLocalVariable* _tmp93;
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp94;
				_tmp92 = NULL;
				_tmp91 = NULL;
				_tmp93 = NULL;
				temp_var = (_tmp93 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DATA_TYPE ((_tmp92 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp91 = vala_void_type_new ()))))), TRUE, NULL), (_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL))), (_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL))), _tmp93);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
				gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
				_tmp94 = NULL;
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (_tmp94 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref))));
				(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
				vala_invocation_expression_set_delegate_target (expr, VALA_CCODE_EXPRESSION (temp_ref));
				(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
				(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	if (vala_expression_get_can_fail (VALA_EXPRESSION (expr))) {
		ValaCCodeUnaryExpression* _tmp96;
		ValaCCodeIdentifier* _tmp95;
		/* method can fail*/
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = TRUE;
		/* add &inner_error before the ellipsis arguments*/
		_tmp96 = NULL;
		_tmp95 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) -2), FALSE)), (_tmp96 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_identifier_new ("inner_error"))))));
		(_tmp96 == NULL ? NULL : (_tmp96 = (g_object_unref (_tmp96), NULL)));
		(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
	}
	if (ellipsis) {
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if ((m == NULL || !vala_method_get_printf_format (m))) {
			ValaCCodeConstant* _tmp97;
			_tmp97 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) -1), TRUE)), (_tmp97 = vala_ccode_constant_new (vala_method_get_sentinel (m))));
			(_tmp97 == NULL ? NULL : (_tmp97 = (g_object_unref (_tmp97), NULL)));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp98;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp99;
			ValaDelegate* d;
			_tmp98 = NULL;
			deleg_type = (_tmp98 = VALA_DELEGATE_TYPE (itype), (_tmp98 == NULL ? NULL : g_object_ref (_tmp98)));
			_tmp99 = NULL;
			d = (_tmp99 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp99 == NULL ? NULL : g_object_ref (_tmp99)));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp100;
				_tmp100 = NULL;
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_delegate_get_cinstance_parameter_position (d), FALSE)), (_tmp100 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_invocation_expression_get_call (expr))));
				(_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	/* append C arguments in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeExpression* _tmp101;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (GEE_MAP (carg_map));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp101 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp101 = ((ValaCCodeExpression*) gee_map_get (GEE_MAP (carg_map), GINT_TO_POINTER (min_pos)))));
		(_tmp101 == NULL ? NULL : (_tmp101 = (g_object_unref (_tmp101), NULL)));
		last_pos = min_pos;
	}
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* _tmp102;
		_tmp102 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp102 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_data_type_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_data_type_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))) != NULL) {
			ValaCCodeExpression* _tmp103;
			_tmp103 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp103 = vala_ccode_generator_convert_from_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ccall_expr, vala_expression_get_static_type (VALA_EXPRESSION (expr))))));
			(_tmp103 == NULL ? NULL : (_tmp103 = (g_object_unref (_tmp103), NULL)));
		} else {
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall_expr));
		}
		vala_ccode_generator_visit_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_EXPRESSION (expr));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeCollection* _tmp104;
		GeeIterator* _tmp105;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp107;
		ValaExpression* _tmp106;
		ValaCCodeExpression* _tmp108;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp109;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp110;
		ValaArrayType* array_type;
		char* _tmp112;
		char* _tmp111;
		ValaCCodeIdentifier* _tmp113;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* _tmp114;
		ValaCCodeParenthesizedExpression* _tmp115;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp116;
		ValaCCodeFunctionCall* _tmp117;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp118;
		ValaCCodeConstant* _tmp119;
		ValaCCodeBinaryExpression* _tmp120;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp121;
		ValaCCodeConditionalExpression* _tmp123;
		ValaCCodeConstant* _tmp122;
		ValaCCodeAssignment* _tmp125;
		ValaCCodeExpression* _tmp124;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp104 = NULL;
		_tmp105 = NULL;
		arg_it = (_tmp105 = gee_iterable_iterator (GEE_ITERABLE ((_tmp104 = vala_invocation_expression_get_argument_list (expr)))), (_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL))), _tmp105);
		gee_iterator_next (arg_it);
		_tmp107 = NULL;
		_tmp106 = NULL;
		_tmp108 = NULL;
		new_size = (_tmp108 = (_tmp107 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp106 = ((ValaExpression*) gee_iterator_get (arg_it)))))), (_tmp107 == NULL ? NULL : g_object_ref (_tmp107))), (_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL))), _tmp108);
		temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
		gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
		/* memset needs string.h */
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_h_needed = TRUE;
		clen = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (ma), 1);
		_tmp109 = NULL;
		celems = (_tmp109 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp109 == NULL ? NULL : g_object_ref (_tmp109)));
		_tmp110 = NULL;
		array_type = (_tmp110 = VALA_ARRAY_TYPE (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (_tmp110 == NULL ? NULL : g_object_ref (_tmp110)));
		_tmp112 = NULL;
		_tmp111 = NULL;
		_tmp113 = NULL;
		csizeof = (_tmp113 = vala_ccode_identifier_new ((_tmp112 = g_strdup_printf ("sizeof (%s)", (_tmp111 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))), (_tmp112 = (g_free (_tmp112), NULL)), (_tmp111 = (g_free (_tmp111), NULL)), _tmp113);
		_tmp114 = NULL;
		_tmp115 = NULL;
		cdelta = (_tmp115 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp114 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)))), (_tmp114 == NULL ? NULL : (_tmp114 = (g_object_unref (_tmp114), NULL))), _tmp115);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		_tmp116 = NULL;
		_tmp117 = NULL;
		czero = (_tmp117 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp116 = vala_ccode_identifier_new ("memset")))), (_tmp116 == NULL ? NULL : (_tmp116 = (g_object_unref (_tmp116), NULL))), _tmp117);
		_tmp118 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp118 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(_tmp118 == NULL ? NULL : (_tmp118 = (g_object_unref (_tmp118), NULL)));
		_tmp119 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp119 = vala_ccode_constant_new ("0"))));
		(_tmp119 == NULL ? NULL : (_tmp119 = (g_object_unref (_tmp119), NULL)));
		_tmp120 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp120 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(_tmp120 == NULL ? NULL : (_tmp120 = (g_object_unref (_tmp120), NULL)));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp121 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp121 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp121 == NULL ? NULL : (_tmp121 = (g_object_unref (_tmp121), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		_tmp123 = NULL;
		_tmp122 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp123 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION ((_tmp122 = vala_ccode_constant_new ("NULL")))))));
		(_tmp123 == NULL ? NULL : (_tmp123 = (g_object_unref (_tmp123), NULL)));
		(_tmp122 == NULL ? NULL : (_tmp122 = (g_object_unref (_tmp122), NULL)));
		_tmp125 = NULL;
		_tmp124 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp125 = vala_ccode_assignment_new ((_tmp124 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (ma), 1)), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp125 == NULL ? NULL : (_tmp125 = (g_object_unref (_tmp125), NULL)));
		(_tmp124 == NULL ? NULL : (_tmp124 = (g_object_unref (_tmp124), NULL)));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
		(new_size == NULL ? NULL : (new_size = (g_object_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
		(clen == NULL ? NULL : (clen = (g_object_unref (clen), NULL)));
		(celems == NULL ? NULL : (celems = (g_object_unref (celems), NULL)));
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (g_object_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (m == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->substring_method) {
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			GeeList* args;
			ValaCCodeIdentifier* _tmp126;
			ValaCCodeFunctionCall* _tmp127;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeExpression* _tmp128;
			ValaCCodeExpression* _tmp129;
			ValaCCodeIdentifier* _tmp130;
			ValaCCodeFunctionCall* _tmp131;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeExpression* _tmp132;
			ValaCCodeIdentifier* _tmp133;
			ValaCCodeFunctionCall* _tmp134;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* _tmp135;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp136;
			temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type, TRUE, NULL);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
			args = vala_ccode_function_call_get_arguments (ccall);
			_tmp126 = NULL;
			_tmp127 = NULL;
			coffsetcall = (_tmp127 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL))), _tmp127);
			/* full string*/
			_tmp128 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp128 = ((ValaCCodeExpression*) gee_list_get (((GeeList*) args), 0))));
			(_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL)));
			/* offset*/
			_tmp129 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp129 = ((ValaCCodeExpression*) gee_list_get (((GeeList*) args), 1))));
			(_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL)));
			_tmp130 = NULL;
			_tmp131 = NULL;
			coffsetcall2 = (_tmp131 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp130 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp130 == NULL ? NULL : (_tmp130 = (g_object_unref (_tmp130), NULL))), _tmp131);
			vala_ccode_function_call_add_argument (coffsetcall2, VALA_CCODE_EXPRESSION (temp_ref));
			/* len*/
			_tmp132 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall2, (_tmp132 = ((ValaCCodeExpression*) gee_list_get (((GeeList*) args), 2))));
			(_tmp132 == NULL ? NULL : (_tmp132 = (g_object_unref (_tmp132), NULL)));
			_tmp133 = NULL;
			_tmp134 = NULL;
			cndupcall = (_tmp134 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp133 = vala_ccode_identifier_new ("g_strndup")))), (_tmp133 == NULL ? NULL : (_tmp133 = (g_object_unref (_tmp133), NULL))), _tmp134);
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp135 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION ((_tmp135 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (coffsetcall2), VALA_CCODE_EXPRESSION (temp_ref)))));
			(_tmp135 == NULL ? NULL : (_tmp135 = (g_object_unref (_tmp135), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp136 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp136 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_EXPRESSION (coffsetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cndupcall));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			(args == NULL ? NULL : (args = (g_object_unref (args), NULL)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
			(coffsetcall2 == NULL ? NULL : (coffsetcall2 = (g_object_unref (coffsetcall2), NULL)));
			(cndupcall == NULL ? NULL : (cndupcall = (g_object_unref (cndupcall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
	}
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
	(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
	(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
	(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
}


ValaInvocationExpression* vala_ccode_invocation_expression_binding_get_invocation_expression (ValaCCodeInvocationExpressionBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING (self), NULL);
	return self->priv->_invocation_expression;
}


void vala_ccode_invocation_expression_binding_set_invocation_expression (ValaCCodeInvocationExpressionBinding* self, ValaInvocationExpression* value) {
	ValaInvocationExpression* _tmp2;
	ValaInvocationExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_invocation_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_invocation_expression == NULL ? NULL : (self->priv->_invocation_expression = (g_object_unref (self->priv->_invocation_expression), NULL))), _tmp2);
}


static void vala_ccode_invocation_expression_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION:
		g_value_set_object (value, vala_ccode_invocation_expression_binding_get_invocation_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_invocation_expression_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION:
		vala_ccode_invocation_expression_binding_set_invocation_expression (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_invocation_expression_binding_class_init (ValaCCodeInvocationExpressionBindingClass * klass) {
	vala_ccode_invocation_expression_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeInvocationExpressionBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_invocation_expression_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_invocation_expression_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_invocation_expression_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_invocation_expression_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_INVOCATION_EXPRESSION_BINDING_INVOCATION_EXPRESSION, g_param_spec_object ("invocation-expression", "invocation-expression", "invocation-expression", VALA_TYPE_INVOCATION_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_invocation_expression_binding_init (ValaCCodeInvocationExpressionBinding * self) {
	self->priv = VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_invocation_expression_binding_dispose (GObject * obj) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (obj);
	(self->priv->_invocation_expression == NULL ? NULL : (self->priv->_invocation_expression = (g_object_unref (self->priv->_invocation_expression), NULL)));
	G_OBJECT_CLASS (vala_ccode_invocation_expression_binding_parent_class)->dispose (obj);
}


GType vala_ccode_invocation_expression_binding_get_type (void) {
	static GType vala_ccode_invocation_expression_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_invocation_expression_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeInvocationExpressionBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_invocation_expression_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeInvocationExpressionBinding), 0, (GInstanceInitFunc) vala_ccode_invocation_expression_binding_init };
		vala_ccode_invocation_expression_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeInvocationExpressionBinding", &g_define_type_info, 0);
	}
	return vala_ccode_invocation_expression_binding_type_id;
}




