/* valaclassinstancetype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALACLASSINSTANCETYPE_H__
#define __VALA_VALACLASSINSTANCETYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valareferencetype.h>
#include <vala/valaclass.h>
#include <vala/valadatatype.h>

G_BEGIN_DECLS


#define VALA_TYPE_CLASS_INSTANCE_TYPE (vala_class_instance_type_get_type ())
#define VALA_CLASS_INSTANCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS_INSTANCE_TYPE, ValaClassInstanceType))
#define VALA_CLASS_INSTANCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS_INSTANCE_TYPE, ValaClassInstanceTypeClass))
#define VALA_IS_CLASS_INSTANCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS_INSTANCE_TYPE))
#define VALA_IS_CLASS_INSTANCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS_INSTANCE_TYPE))
#define VALA_CLASS_INSTANCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS_INSTANCE_TYPE, ValaClassInstanceTypeClass))

typedef struct _ValaClassInstanceType ValaClassInstanceType;
typedef struct _ValaClassInstanceTypeClass ValaClassInstanceTypeClass;
typedef struct _ValaClassInstanceTypePrivate ValaClassInstanceTypePrivate;

/**
 * A class type.
 */
struct _ValaClassInstanceType {
	ValaReferenceType parent_instance;
	ValaClassInstanceTypePrivate * priv;
};

struct _ValaClassInstanceTypeClass {
	ValaReferenceTypeClass parent_class;
};


ValaClassInstanceType* vala_class_instance_type_new (ValaClass* class_symbol);
ValaClass* vala_class_instance_type_get_class_symbol (ValaClassInstanceType* self);
void vala_class_instance_type_set_class_symbol (ValaClassInstanceType* self, ValaClass* value);
GType vala_class_instance_type_get_type (void);


G_END_DECLS

#endif
