/* valaccodefragment.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodefragment.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>




struct _ValaCCodeFragmentPrivate {
	GeeList* children;
};

#define VALA_CCODE_FRAGMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FRAGMENT, ValaCCodeFragmentPrivate))
enum  {
	VALA_CCODE_FRAGMENT_DUMMY_PROPERTY
};
static void vala_ccode_fragment_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_fragment_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_fragment_real_write_combined (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_fragment_parent_class = NULL;
static void vala_ccode_fragment_finalize (ValaCCodeNode* obj);



/**
 * Appends the specified code node to this code fragment.
 *
 * @param node a C code node
 */
void vala_ccode_fragment_append (ValaCCodeFragment* self, ValaCCodeNode* node) {
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (self));
	g_return_if_fail (VALA_IS_CCODE_NODE (node));
	gee_collection_add (GEE_COLLECTION (self->priv->children), node);
}


/**
 * Returns a copy of the list of children.
 *
 * @return children list
 */
GeeList* vala_ccode_fragment_get_children (ValaCCodeFragment* self) {
	g_return_val_if_fail (VALA_IS_CCODE_FRAGMENT (self), NULL);
	return GEE_LIST (gee_read_only_list_new (VALA_TYPE_CCODE_NODE, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, self->priv->children));
}


static void vala_ccode_fragment_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	{
		GeeList* node_collection;
		int node_it;
		node_collection = self->priv->children;
		for (node_it = 0; node_it < gee_collection_get_size (GEE_COLLECTION (node_collection)); node_it = node_it + 1) {
			ValaCCodeNode* node;
			node = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (node_collection), node_it)));
			{
				vala_ccode_node_write (node, writer);
				(node == NULL ? NULL : (node = (vala_ccode_node_unref (node), NULL)));
			}
		}
	}
}


static void vala_ccode_fragment_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	{
		GeeList* node_collection;
		int node_it;
		node_collection = self->priv->children;
		for (node_it = 0; node_it < gee_collection_get_size (GEE_COLLECTION (node_collection)); node_it = node_it + 1) {
			ValaCCodeNode* node;
			node = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (node_collection), node_it)));
			{
				vala_ccode_node_write_declaration (node, writer);
				(node == NULL ? NULL : (node = (vala_ccode_node_unref (node), NULL)));
			}
		}
	}
}


static void vala_ccode_fragment_real_write_combined (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	{
		GeeList* node_collection;
		int node_it;
		node_collection = self->priv->children;
		for (node_it = 0; node_it < gee_collection_get_size (GEE_COLLECTION (node_collection)); node_it = node_it + 1) {
			ValaCCodeNode* node;
			node = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (node_collection), node_it)));
			{
				vala_ccode_node_write_combined (node, writer);
				(node == NULL ? NULL : (node = (vala_ccode_node_unref (node), NULL)));
			}
		}
	}
}


/**
 * Represents a container for C code nodes.
 */
ValaCCodeFragment* vala_ccode_fragment_construct (GType object_type) {
	ValaCCodeFragment* self;
	self = ((ValaCCodeFragment*) (g_type_create_instance (object_type)));
	return self;
}


ValaCCodeFragment* vala_ccode_fragment_new (void) {
	return vala_ccode_fragment_construct (VALA_TYPE_CCODE_FRAGMENT);
}


static void vala_ccode_fragment_class_init (ValaCCodeFragmentClass * klass) {
	vala_ccode_fragment_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_fragment_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeFragmentPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_fragment_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_fragment_real_write_declaration;
	VALA_CCODE_NODE_CLASS (klass)->write_combined = vala_ccode_fragment_real_write_combined;
}


static void vala_ccode_fragment_instance_init (ValaCCodeFragment * self) {
	self->priv = VALA_CCODE_FRAGMENT_GET_PRIVATE (self);
	self->priv->children = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_NODE, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_equal));
}


static void vala_ccode_fragment_finalize (ValaCCodeNode* obj) {
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (obj);
	(self->priv->children == NULL ? NULL : (self->priv->children = (gee_collection_object_unref (self->priv->children), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_fragment_parent_class)->finalize (obj);
}


GType vala_ccode_fragment_get_type (void) {
	static GType vala_ccode_fragment_type_id = 0;
	if (vala_ccode_fragment_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFragmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_fragment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFragment), 0, (GInstanceInitFunc) vala_ccode_fragment_instance_init, NULL };
		vala_ccode_fragment_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeFragment", &g_define_type_info, 0);
	}
	return vala_ccode_fragment_type_id;
}




