/* valaccodemethodmodule.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodemethodmodule.h>
#include <vala/valacodenode.h>
#include <vala/valaattribute.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeblock.h>
#include <vala/valablock.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <gee/collection.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodemodifiers.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <float.h>
#include <math.h>
#include <vala/valamember.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valavaluetype.h>
#include <ccode/valaccodestruct.h>
#include <vala/valaclasstype.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <vala/valareferencetype.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodestatement.h>
#include <vala/valaformalparameter.h>
#include <vala/valacodecontext.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <vala/valatypeparameter.h>
#include <vala/valapointertype.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodewhilestatement.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <vala/valamethodtype.h>
#include <gee/list.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valastatement.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_METHOD_MODULE_DUMMY_PROPERTY
};
static gboolean vala_ccode_method_module_real_method_has_wrapper (ValaCCodeModule* base, ValaMethod* method);
static char* vala_ccode_method_module_real_get_custom_creturn_type (ValaCCodeModule* base, ValaMethod* m);
static char* vala_ccode_method_module_get_creturn_type (ValaCCodeMethodModule* self, ValaMethod* m, const char* default_value);
static void vala_ccode_method_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m);
static void vala_ccode_method_module_real_generate_cparameters (ValaCCodeModule* base, ValaMethod* m, ValaDataType* creturn_type, gboolean in_gtypeinstance_creation_method, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
static ValaCCodeStatement* vala_ccode_method_module_create_method_type_check_statement (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_method_module_create_precondition_statement (ValaCCodeMethodModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition);
static ValaCCodeStatement* vala_ccode_method_module_create_postcondition_statement (ValaCCodeMethodModule* self, ValaExpression* postcondition);
static ValaTypeSymbol* vala_ccode_method_module_find_parent_type (ValaCCodeMethodModule* self, ValaSymbol* sym);
static gboolean vala_ccode_method_module_is_possible_entry_point (ValaCCodeMethodModule* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static void vala_ccode_method_module_add_object_creation (ValaCCodeMethodModule* self, ValaCCodeBlock* b, gboolean has_params);
static void vala_ccode_method_module_real_visit_creation_method (ValaCCodeModule* base, ValaCreationMethod* m);
static gpointer vala_ccode_method_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMethodModule* vala_ccode_method_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaCCodeMethodModule*) (g_type_create_instance (object_type)));
	self = ((ValaCCodeMethodModule*) (vala_ccode_struct_module_construct (object_type, codegen, next)));
	return self;
}


ValaCCodeMethodModule* vala_ccode_method_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_module_construct (VALA_TYPE_CCODE_METHOD_MODULE, codegen, next);
}


static gboolean vala_ccode_method_module_real_method_has_wrapper (ValaCCodeModule* base, ValaMethod* method) {
	ValaCCodeMethodModule * self;
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	self = ((ValaCCodeMethodModule*) (base));
	g_return_val_if_fail (method != NULL, FALSE);
	_tmp0 = NULL;
	return (_tmp1 = ((_tmp0 = vala_code_node_get_attribute (((ValaCodeNode*) (method)), "NoWrapper")) == NULL), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL))), _tmp1);
}


static char* vala_ccode_method_module_real_get_custom_creturn_type (ValaCCodeModule* base, ValaMethod* m) {
	ValaCCodeMethodModule * self;
	ValaAttribute* attr;
	char* _tmp2;
	self = ((ValaCCodeMethodModule*) (base));
	g_return_val_if_fail (m != NULL, NULL);
	if (vala_method_get_coroutine (m)) {
		return g_strdup ("gboolean");
	}
	attr = vala_code_node_get_attribute (((ValaCodeNode*) (m)), "CCode");
	if (attr != NULL) {
		char* type;
		type = vala_attribute_get_string (attr, "type");
		if (type != NULL) {
			char* _tmp1;
			_tmp1 = NULL;
			return (_tmp1 = type, (attr == NULL ? NULL : (attr = (vala_code_node_unref (attr), NULL))), _tmp1);
		}
		type = (g_free (type), NULL);
	}
	_tmp2 = NULL;
	return (_tmp2 = NULL, (attr == NULL ? NULL : (attr = (vala_code_node_unref (attr), NULL))), _tmp2);
}


static char* vala_ccode_method_module_get_creturn_type (ValaCCodeMethodModule* self, ValaMethod* m, const char* default_value) {
	char* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	type = vala_ccode_module_get_custom_creturn_type (((ValaCCodeModule*) (self)), m);
	if (type == NULL) {
		const char* _tmp0;
		char* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = (_tmp0 = default_value, (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (type = (g_free (type), NULL)), _tmp1);
	}
	return type;
}


static void vala_ccode_method_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m) {
	ValaCCodeMethodModule * self;
	ValaMethod* _tmp0;
	ValaMethod* old_method;
	ValaDataType* _tmp1;
	ValaDataType* old_return_type;
	gboolean old_method_inner_error;
	gint old_next_temp_var_id;
	ValaSymbol* _tmp3;
	ValaSymbol* _tmp2;
	ValaMethod* _tmp5;
	ValaMethod* _tmp4;
	ValaDataType* _tmp7;
	ValaDataType* _tmp6;
	gboolean in_gtypeinstance_creation_method;
	gboolean in_gobject_creation_method;
	gboolean in_fundamental_creation_method;
	ValaDataType* _tmp8;
	ValaDataType* creturn_type;
	gboolean inner_error;
	ValaSymbol* _tmp22;
	ValaSymbol* _tmp21;
	ValaMethod* _tmp24;
	ValaMethod* _tmp23;
	ValaDataType* _tmp26;
	ValaDataType* _tmp25;
	ValaCCodeFunction* _tmp30;
	char* _tmp29;
	char* _tmp28;
	char* _tmp27;
	GeeHashMap* cparam_map;
	ValaCCodeFunctionDeclarator* vdeclarator;
	gboolean visible;
	gboolean return_value;
	gboolean args_parameter;
	self = ((ValaCCodeMethodModule*) (base));
	g_return_if_fail (m != NULL);
	_tmp0 = NULL;
	old_method = (_tmp0 = ((ValaCCodeBaseModule*) (self))->current_method, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	old_return_type = (_tmp1 = ((ValaCCodeBaseModule*) (self))->current_return_type, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	old_method_inner_error = ((ValaCCodeBaseModule*) (self))->current_method_inner_error;
	old_next_temp_var_id = ((ValaCCodeBaseModule*) (self))->next_temp_var_id;
	_tmp3 = NULL;
	_tmp2 = NULL;
	((ValaCCodeBaseModule*) (self))->current_symbol = (_tmp3 = (_tmp2 = ((ValaSymbol*) (m)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (((ValaCCodeBaseModule*) (self))->current_symbol == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) (self))->current_symbol), NULL))), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	((ValaCCodeBaseModule*) (self))->current_method = (_tmp5 = (_tmp4 = m, (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4))), (((ValaCCodeBaseModule*) (self))->current_method == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) (self))->current_method), NULL))), _tmp5);
	_tmp7 = NULL;
	_tmp6 = NULL;
	((ValaCCodeBaseModule*) (self))->current_return_type = (_tmp7 = (_tmp6 = vala_method_get_return_type (m), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6))), (((ValaCCodeBaseModule*) (self))->current_return_type == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->current_return_type = (vala_code_node_unref (((ValaCCodeBaseModule*) (self))->current_return_type), NULL))), _tmp7);
	((ValaCCodeBaseModule*) (self))->current_method_inner_error = FALSE;
	((ValaCCodeBaseModule*) (self))->next_temp_var_id = 0;
	in_gtypeinstance_creation_method = FALSE;
	in_gobject_creation_method = FALSE;
	in_fundamental_creation_method = FALSE;
	_tmp8 = NULL;
	creturn_type = (_tmp8 = ((ValaCCodeBaseModule*) (self))->current_return_type, (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8)));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp10;
		ValaTypeSymbol* _tmp9;
		ValaClass* cl;
		((ValaCCodeBaseModule*) (self))->in_creation_method = TRUE;
		_tmp10 = NULL;
		_tmp9 = NULL;
		cl = (_tmp10 = (_tmp9 = ((ValaCCodeBaseModule*) (self))->current_type_symbol, (VALA_IS_CLASS (_tmp9) ? ((ValaClass*) (_tmp9)) : NULL)), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10)));
		if (cl != NULL && !vala_class_get_is_compact (cl)) {
			in_gtypeinstance_creation_method = TRUE;
			if (vala_class_get_base_class (cl) == NULL) {
				in_fundamental_creation_method = TRUE;
			} else {
				if (vala_typesymbol_is_subtype_of (((ValaTypeSymbol*) (cl)), ((ValaCCodeBaseModule*) (self))->gobject_type)) {
					in_gobject_creation_method = TRUE;
				}
			}
		}
		if (cl != NULL) {
			ValaDataType* _tmp11;
			_tmp11 = NULL;
			creturn_type = (_tmp11 = ((ValaDataType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (cl))))), (creturn_type == NULL ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL))), _tmp11);
		}
		(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	}
	vala_code_node_accept_children (((ValaCodeNode*) (m)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (VALA_IS_CREATION_METHOD (m)) {
		if (in_gobject_creation_method && vala_method_get_body (m) != NULL) {
			ValaCCodeBlock* cblock;
			cblock = vala_ccode_block_new ();
			if (!vala_creation_method_get_chain_up ((VALA_CREATION_METHOD (m)))) {
				GeeList* _tmp14;
				/* set construct properties*/
				{
					GeeList* stmt_collection;
					int stmt_it;
					stmt_collection = vala_block_get_statements (vala_method_get_body (m));
					for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
						ValaCodeNode* stmt;
						stmt = ((ValaCodeNode*) (((ValaCodeNode*) (gee_list_get (GEE_LIST (stmt_collection), stmt_it)))));
						{
							ValaExpressionStatement* _tmp13;
							ValaCodeNode* _tmp12;
							ValaExpressionStatement* expr_stmt;
							_tmp13 = NULL;
							_tmp12 = NULL;
							expr_stmt = (_tmp13 = (_tmp12 = stmt, (VALA_IS_EXPRESSION_STATEMENT (_tmp12) ? ((ValaExpressionStatement*) (_tmp12)) : NULL)), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13)));
							if (expr_stmt != NULL) {
								ValaProperty* prop;
								prop = vala_expression_statement_assigned_property (expr_stmt);
								if (prop != NULL && vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
									if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
										{
											GeeList* cstmt_collection;
											int cstmt_it;
											cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
											for (cstmt_it = 0; cstmt_it < gee_collection_get_size (GEE_COLLECTION (cstmt_collection)); cstmt_it = cstmt_it + 1) {
												ValaCCodeNode* cstmt;
												cstmt = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (cstmt_collection), cstmt_it)));
												{
													vala_ccode_block_add_statement (cblock, cstmt);
													(cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)));
												}
											}
											(cstmt_collection == NULL ? NULL : (cstmt_collection = (gee_collection_object_unref (cstmt_collection), NULL)));
										}
									} else {
										vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
									}
								}
								(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
							}
							(stmt == NULL ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)));
							(expr_stmt == NULL ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL)));
						}
					}
					(stmt_collection == NULL ? NULL : (stmt_collection = (gee_collection_object_unref (stmt_collection), NULL)));
				}
				_tmp14 = NULL;
				vala_ccode_method_module_add_object_creation (self, cblock, vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0 || gee_collection_get_size (((GeeCollection*) ((_tmp14 = vala_class_get_type_parameters (((ValaCCodeBaseModule*) (self))->current_class))))) > 0);
				(_tmp14 == NULL ? NULL : (_tmp14 = (gee_collection_object_unref (_tmp14), NULL)));
			} else {
				char* _tmp16;
				char* _tmp15;
				ValaCCodeDeclaration* _tmp17;
				ValaCCodeDeclaration* cdeclaration;
				ValaCCodeVariableDeclarator* _tmp18;
				_tmp16 = NULL;
				_tmp15 = NULL;
				_tmp17 = NULL;
				cdeclaration = (_tmp17 = vala_ccode_declaration_new ((_tmp16 = g_strdup_printf ("%s *", (_tmp15 = vala_typesymbol_get_cname (((ValaTypeSymbol*) ((VALA_CLASS (((ValaCCodeBaseModule*) (self))->current_type_symbol)))), FALSE))))), (_tmp16 = (g_free (_tmp16), NULL)), (_tmp15 = (g_free (_tmp15), NULL)), _tmp17);
				_tmp18 = NULL;
				vala_ccode_declaration_add_declarator (cdeclaration, ((ValaCCodeDeclarator*) ((_tmp18 = vala_ccode_variable_declarator_new ("self")))));
				(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
				vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) (cdeclaration)));
				(cdeclaration == NULL ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL)));
			}
			/* other initialization code*/
			{
				GeeList* stmt_collection;
				int stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
					ValaCodeNode* stmt;
					stmt = ((ValaCodeNode*) (((ValaCodeNode*) (gee_list_get (GEE_LIST (stmt_collection), stmt_it)))));
					{
						ValaExpressionStatement* _tmp20;
						ValaCodeNode* _tmp19;
						ValaExpressionStatement* expr_stmt;
						_tmp20 = NULL;
						_tmp19 = NULL;
						expr_stmt = (_tmp20 = (_tmp19 = stmt, (VALA_IS_EXPRESSION_STATEMENT (_tmp19) ? ((ValaExpressionStatement*) (_tmp19)) : NULL)), (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20)));
						if (expr_stmt != NULL) {
							ValaProperty* prop;
							prop = vala_expression_statement_assigned_property (expr_stmt);
							if (prop != NULL && vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
								(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
								(stmt == NULL ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)));
								(expr_stmt == NULL ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL)));
								continue;
							}
							(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
						}
						if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
							{
								GeeList* cstmt_collection;
								int cstmt_it;
								cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
								for (cstmt_it = 0; cstmt_it < gee_collection_get_size (GEE_COLLECTION (cstmt_collection)); cstmt_it = cstmt_it + 1) {
									ValaCCodeNode* cstmt;
									cstmt = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (cstmt_collection), cstmt_it)));
									{
										vala_ccode_block_add_statement (cblock, cstmt);
										(cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)));
									}
								}
								(cstmt_collection == NULL ? NULL : (cstmt_collection = (gee_collection_object_unref (cstmt_collection), NULL)));
							}
						} else {
							vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
						}
						(stmt == NULL ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)));
						(expr_stmt == NULL ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (gee_collection_object_unref (stmt_collection), NULL)));
			}
			vala_code_node_set_ccodenode (((ValaCodeNode*) (vala_method_get_body (m))), ((ValaCCodeNode*) (cblock)));
			(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
		}
		((ValaCCodeBaseModule*) (self))->in_creation_method = FALSE;
	}
	inner_error = ((ValaCCodeBaseModule*) (self))->current_method_inner_error;
	_tmp22 = NULL;
	_tmp21 = NULL;
	((ValaCCodeBaseModule*) (self))->current_symbol = (_tmp22 = (_tmp21 = vala_symbol_get_parent_symbol (((ValaCCodeBaseModule*) (self))->current_symbol), (_tmp21 == NULL ? NULL : vala_code_node_ref (_tmp21))), (((ValaCCodeBaseModule*) (self))->current_symbol == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) (self))->current_symbol), NULL))), _tmp22);
	_tmp24 = NULL;
	_tmp23 = NULL;
	((ValaCCodeBaseModule*) (self))->current_method = (_tmp24 = (_tmp23 = old_method, (_tmp23 == NULL ? NULL : vala_code_node_ref (_tmp23))), (((ValaCCodeBaseModule*) (self))->current_method == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) (self))->current_method), NULL))), _tmp24);
	_tmp26 = NULL;
	_tmp25 = NULL;
	((ValaCCodeBaseModule*) (self))->current_return_type = (_tmp26 = (_tmp25 = old_return_type, (_tmp25 == NULL ? NULL : vala_code_node_ref (_tmp25))), (((ValaCCodeBaseModule*) (self))->current_return_type == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->current_return_type = (vala_code_node_unref (((ValaCCodeBaseModule*) (self))->current_return_type), NULL))), _tmp26);
	((ValaCCodeBaseModule*) (self))->current_method_inner_error = old_method_inner_error;
	((ValaCCodeBaseModule*) (self))->next_temp_var_id = old_next_temp_var_id;
	_tmp30 = NULL;
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	((ValaCCodeBaseModule*) (self))->function = (_tmp30 = vala_ccode_function_new ((_tmp27 = vala_method_get_real_cname (m)), (_tmp29 = vala_ccode_method_module_get_creturn_type (self, m, (_tmp28 = vala_data_type_get_cname (creturn_type))))), (((ValaCCodeBaseModule*) (self))->function == NULL ? NULL : (((ValaCCodeBaseModule*) (self))->function = (vala_ccode_node_unref (((ValaCCodeBaseModule*) (self))->function), NULL))), _tmp30);
	_tmp29 = (g_free (_tmp29), NULL);
	_tmp28 = (g_free (_tmp28), NULL);
	_tmp27 = (g_free (_tmp27), NULL);
	vala_code_node_set_ccodenode (((ValaCodeNode*) (m)), ((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function)));
	if (vala_method_get_is_inline (m)) {
		vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) (self))->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) (self))->function) | (VALA_CCODE_MODIFIERS_INLINE));
	}
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vdeclarator = NULL;
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))) && VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp31;
		ValaClass* cl;
		_tmp31 = NULL;
		cl = (_tmp31 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp31 == NULL ? NULL : vala_code_node_ref (_tmp31)));
		if (!vala_class_get_is_compact (cl)) {
			ValaCCodeFormalParameter* _tmp32;
			_tmp32 = NULL;
			gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), (_tmp32 = vala_ccode_formal_parameter_new ("object_type", "GType")));
			(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
		}
		(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	} else {
		if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE || (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))) && VALA_IS_CREATION_METHOD (m))) {
			ValaTypeSymbol* parent_type;
			ValaDataType* this_type;
			ValaCCodeFormalParameter* instance_param;
			parent_type = vala_ccode_method_module_find_parent_type (self, ((ValaSymbol*) (m)));
			this_type = NULL;
			if (VALA_IS_CLASS (parent_type)) {
				ValaDataType* _tmp33;
				_tmp33 = NULL;
				this_type = (_tmp33 = ((ValaDataType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_CLASS (parent_type)))))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp33);
			} else {
				if (VALA_IS_INTERFACE (parent_type)) {
					ValaDataType* _tmp34;
					_tmp34 = NULL;
					this_type = (_tmp34 = ((ValaDataType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_INTERFACE (parent_type)))))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp34);
				} else {
					ValaDataType* _tmp35;
					_tmp35 = NULL;
					this_type = (_tmp35 = ((ValaDataType*) (vala_value_type_new (parent_type))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp35);
				}
			}
			instance_param = NULL;
			if (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m)) {
				ValaObjectType* base_type;
				ValaCCodeFormalParameter* _tmp37;
				char* _tmp36;
				base_type = vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_method_get_base_interface_method (m))))))));
				_tmp37 = NULL;
				_tmp36 = NULL;
				instance_param = (_tmp37 = vala_ccode_formal_parameter_new ("base", (_tmp36 = vala_data_type_get_cname (((ValaDataType*) (base_type))))), (instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL))), _tmp37);
				_tmp36 = (g_free (_tmp36), NULL);
				(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
			} else {
				if (vala_method_get_overrides (m)) {
					ValaObjectType* base_type;
					ValaCCodeFormalParameter* _tmp39;
					char* _tmp38;
					base_type = vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_method_get_base_method (m))))))));
					_tmp39 = NULL;
					_tmp38 = NULL;
					instance_param = (_tmp39 = vala_ccode_formal_parameter_new ("base", (_tmp38 = vala_data_type_get_cname (((ValaDataType*) (base_type))))), (instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL))), _tmp39);
					_tmp38 = (g_free (_tmp38), NULL);
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				} else {
					if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_symbol_get_parent_symbol (((ValaSymbol*) (m))))))) {
						ValaCCodeFormalParameter* _tmp41;
						char* _tmp40;
						_tmp41 = NULL;
						_tmp40 = NULL;
						instance_param = (_tmp41 = vala_ccode_formal_parameter_new ("*self", (_tmp40 = vala_data_type_get_cname (this_type))), (instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL))), _tmp41);
						_tmp40 = (g_free (_tmp40), NULL);
					} else {
						ValaCCodeFormalParameter* _tmp43;
						char* _tmp42;
						_tmp43 = NULL;
						_tmp42 = NULL;
						instance_param = (_tmp43 = vala_ccode_formal_parameter_new ("self", (_tmp42 = vala_data_type_get_cname (this_type))), (instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL))), _tmp43);
						_tmp42 = (g_free (_tmp42), NULL);
					}
				}
			}
			gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance_param);
			if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
				char* _tmp45;
				char* _tmp44;
				ValaCCodeDeclaration* _tmp46;
				ValaCCodeDeclaration* vdecl;
				ValaCCodeFunctionDeclarator* _tmp47;
				_tmp45 = NULL;
				_tmp44 = NULL;
				_tmp46 = NULL;
				vdecl = (_tmp46 = vala_ccode_declaration_new ((_tmp45 = vala_ccode_method_module_get_creturn_type (self, m, (_tmp44 = vala_data_type_get_cname (creturn_type))))), (_tmp45 = (g_free (_tmp45), NULL)), (_tmp44 = (g_free (_tmp44), NULL)), _tmp46);
				_tmp47 = NULL;
				vdeclarator = (_tmp47 = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m)), (vdeclarator == NULL ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL))), _tmp47);
				vala_ccode_declaration_add_declarator (vdecl, ((ValaCCodeDeclarator*) (vdeclarator)));
				vala_ccode_struct_add_declaration (((ValaCCodeBaseModule*) (self))->type_struct, vdecl);
				(vdecl == NULL ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL)));
			}
			(parent_type == NULL ? NULL : (parent_type = (vala_code_node_unref (parent_type), NULL)));
			(this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)));
			(instance_param == NULL ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)));
		} else {
			if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
				ValaTypeSymbol* parent_type;
				ValaDataType* this_type;
				ValaDataType* _tmp48;
				char* _tmp49;
				ValaCCodeFormalParameter* _tmp50;
				ValaCCodeFormalParameter* class_param;
				parent_type = vala_ccode_method_module_find_parent_type (self, ((ValaSymbol*) (m)));
				this_type = NULL;
				_tmp48 = NULL;
				this_type = (_tmp48 = ((ValaDataType*) (vala_class_type_new (VALA_CLASS (parent_type)))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp48);
				_tmp49 = NULL;
				_tmp50 = NULL;
				class_param = (_tmp50 = vala_ccode_formal_parameter_new ("klass", (_tmp49 = vala_data_type_get_cname (this_type))), (_tmp49 = (g_free (_tmp49), NULL)), _tmp50);
				gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), class_param);
				(parent_type == NULL ? NULL : (parent_type = (vala_code_node_unref (parent_type), NULL)));
				(this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)));
				(class_param == NULL ? NULL : (class_param = (vala_ccode_node_unref (class_param), NULL)));
			}
		}
	}
	if (!vala_method_get_coroutine (m)) {
		vala_ccode_module_generate_cparameters (((ValaCCodeModule*) (self)), m, creturn_type, in_gtypeinstance_creation_method, ((GeeMap*) (cparam_map)), ((ValaCCodeBaseModule*) (self))->function, vdeclarator, NULL, NULL, 3);
	} else {
		ValaCCodeFormalParameter* _tmp54;
		char* _tmp53;
		char* _tmp52;
		char* _tmp51;
		/* data struct to hold parameters, local variables, and the return value*/
		_tmp54 = NULL;
		_tmp53 = NULL;
		_tmp52 = NULL;
		_tmp51 = NULL;
		gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (0)), FALSE)), (_tmp54 = vala_ccode_formal_parameter_new ("data", (_tmp53 = g_strconcat ((_tmp52 = vala_symbol_lower_case_to_camel_case ((_tmp51 = vala_method_get_cname (m)))), "Data*", NULL)))));
		(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
		_tmp53 = (g_free (_tmp53), NULL);
		_tmp52 = (g_free (_tmp52), NULL);
		_tmp51 = (g_free (_tmp51), NULL);
		vala_ccode_module_generate_cparameters (((ValaCCodeModule*) (self)), m, creturn_type, in_gtypeinstance_creation_method, ((GeeMap*) (cparam_map)), ((ValaCCodeBaseModule*) (self))->function, vdeclarator, NULL, NULL, 0);
	}
	visible = !vala_symbol_is_internal_symbol (((ValaSymbol*) (m)));
	/* generate *_real_* functions for virtual methods
	 also generate them for abstract methods of classes to prevent faulty subclassing*/
	if (!vala_method_get_is_abstract (m) || (vala_method_get_is_abstract (m) && VALA_IS_CLASS (((ValaCCodeBaseModule*) (self))->current_type_symbol))) {
		if (visible && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			ValaCCodeFunction* _tmp55;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			_tmp55 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->header_type_member_declaration, ((ValaCCodeNode*) ((_tmp55 = vala_ccode_function_copy (((ValaCCodeBaseModule*) (self))->function)))));
			(_tmp55 == NULL ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)));
		} else {
			ValaCCodeFunction* _tmp56;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) (self))->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) (self))->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp56 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp56 = vala_ccode_function_copy (((ValaCCodeBaseModule*) (self))->function)))));
			(_tmp56 == NULL ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			vala_ccode_function_set_block (((ValaCCodeBaseModule*) (self))->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_method_get_body (m))))));
			vala_ccode_node_set_line (((ValaCCodeNode*) (vala_ccode_function_get_block (((ValaCCodeBaseModule*) (self))->function))), vala_ccode_node_get_line (((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function))));
			cinit = vala_ccode_fragment_new ();
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) (self))->function), ((ValaCCodeNode*) (cinit)));
			if (vala_method_get_coroutine (m)) {
				ValaCCodeMemberAccess* _tmp58;
				ValaCCodeIdentifier* _tmp57;
				ValaCCodeSwitchStatement* _tmp59;
				ValaCCodeSwitchStatement* cswitch;
				ValaCCodeCaseStatement* _tmp61;
				ValaCCodeConstant* _tmp60;
				ValaCCodeIdentifier* _tmp62;
				ValaCCodeFunctionCall* _tmp63;
				ValaCCodeFunctionCall* object_creation;
				ValaCCodeConstant* _tmp64;
				ValaCCodeConstant* _tmp65;
				ValaCCodeConstant* _tmp66;
				ValaCCodeIdentifier* _tmp67;
				ValaCCodeFunctionCall* _tmp68;
				ValaCCodeFunctionCall* async_result_creation;
				ValaCCodeMemberAccess* _tmp70;
				ValaCCodeIdentifier* _tmp69;
				ValaCCodeMemberAccess* _tmp72;
				ValaCCodeIdentifier* _tmp71;
				ValaCCodeIdentifier* _tmp73;
				ValaCCodeIdentifier* _tmp74;
				ValaCCodeFunctionCall* _tmp75;
				ValaCCodeFunctionCall* completecall;
				ValaCCodeExpressionStatement* _tmp76;
				ValaCCodeReturnStatement* _tmp78;
				ValaCCodeConstant* _tmp77;
				ValaCCodeBlock* _tmp79;
				_tmp58 = NULL;
				_tmp57 = NULL;
				_tmp59 = NULL;
				cswitch = (_tmp59 = vala_ccode_switch_statement_new (((ValaCCodeExpression*) ((_tmp58 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp57 = vala_ccode_identifier_new ("data")))), "state"))))), (_tmp58 == NULL ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL))), (_tmp57 == NULL ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL))), _tmp59);
				/* initial coroutine state*/
				_tmp61 = NULL;
				_tmp60 = NULL;
				vala_ccode_block_add_statement (((ValaCCodeBlock*) (cswitch)), ((ValaCCodeNode*) ((_tmp61 = vala_ccode_case_statement_new (((ValaCCodeExpression*) ((_tmp60 = vala_ccode_constant_new ("0")))))))));
				(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
				(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
				/* coroutine body*/
				vala_ccode_block_add_statement (((ValaCCodeBlock*) (cswitch)), ((ValaCCodeNode*) (vala_ccode_function_get_block (((ValaCCodeBaseModule*) (self))->function))));
				/* complete async call by invoking callback*/
				_tmp62 = NULL;
				_tmp63 = NULL;
				object_creation = (_tmp63 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp62 = vala_ccode_identifier_new ("g_object_newv"))))), (_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL))), _tmp63);
				_tmp64 = NULL;
				vala_ccode_function_call_add_argument (object_creation, ((ValaCCodeExpression*) ((_tmp64 = vala_ccode_constant_new ("G_TYPE_OBJECT")))));
				(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
				_tmp65 = NULL;
				vala_ccode_function_call_add_argument (object_creation, ((ValaCCodeExpression*) ((_tmp65 = vala_ccode_constant_new ("0")))));
				(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
				_tmp66 = NULL;
				vala_ccode_function_call_add_argument (object_creation, ((ValaCCodeExpression*) ((_tmp66 = vala_ccode_constant_new ("NULL")))));
				(_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)));
				_tmp67 = NULL;
				_tmp68 = NULL;
				async_result_creation = (_tmp68 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp67 = vala_ccode_identifier_new ("g_simple_async_result_new"))))), (_tmp67 == NULL ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL))), _tmp68);
				vala_ccode_function_call_add_argument (async_result_creation, ((ValaCCodeExpression*) (object_creation)));
				_tmp70 = NULL;
				_tmp69 = NULL;
				vala_ccode_function_call_add_argument (async_result_creation, ((ValaCCodeExpression*) ((_tmp70 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp69 = vala_ccode_identifier_new ("data")))), "callback")))));
				(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
				(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
				_tmp72 = NULL;
				_tmp71 = NULL;
				vala_ccode_function_call_add_argument (async_result_creation, ((ValaCCodeExpression*) ((_tmp72 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp71 = vala_ccode_identifier_new ("data")))), "user_data")))));
				(_tmp72 == NULL ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)));
				(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
				_tmp73 = NULL;
				vala_ccode_function_call_add_argument (async_result_creation, ((ValaCCodeExpression*) ((_tmp73 = vala_ccode_identifier_new ("data")))));
				(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
				_tmp74 = NULL;
				_tmp75 = NULL;
				completecall = (_tmp75 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp74 = vala_ccode_identifier_new ("g_simple_async_result_complete"))))), (_tmp74 == NULL ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL))), _tmp75);
				vala_ccode_function_call_add_argument (completecall, ((ValaCCodeExpression*) (async_result_creation)));
				_tmp76 = NULL;
				vala_ccode_block_add_statement (((ValaCCodeBlock*) (cswitch)), ((ValaCCodeNode*) ((_tmp76 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (completecall)))))));
				(_tmp76 == NULL ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)));
				_tmp78 = NULL;
				_tmp77 = NULL;
				vala_ccode_block_add_statement (((ValaCCodeBlock*) (cswitch)), ((ValaCCodeNode*) ((_tmp78 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp77 = vala_ccode_constant_new ("FALSE")))))))));
				(_tmp78 == NULL ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)));
				(_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)));
				_tmp79 = NULL;
				vala_ccode_function_set_block (((ValaCCodeBaseModule*) (self))->function, (_tmp79 = vala_ccode_block_new ()));
				(_tmp79 == NULL ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL)));
				vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) (self))->function), ((ValaCCodeNode*) (cswitch)));
				(cswitch == NULL ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL)));
				(object_creation == NULL ? NULL : (object_creation = (vala_ccode_node_unref (object_creation), NULL)));
				(async_result_creation == NULL ? NULL : (async_result_creation = (vala_ccode_node_unref (async_result_creation), NULL)));
				(completecall == NULL ? NULL : (completecall = (vala_ccode_node_unref (completecall), NULL)));
			}
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m))))) {
				ValaClass* _tmp80;
				ValaClass* cl;
				_tmp80 = NULL;
				cl = (_tmp80 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp80 == NULL ? NULL : vala_code_node_ref (_tmp80)));
				if (vala_method_get_overrides (m) || (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m))) {
					ValaMethod* base_method;
					ValaReferenceType* base_expression_type;
					ValaObjectType* self_target_type;
					ValaCCodeIdentifier* _tmp87;
					ValaCCodeExpression* _tmp88;
					ValaCCodeExpression* cself;
					char* _tmp90;
					char* _tmp89;
					ValaCCodeDeclaration* _tmp91;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp92;
					base_method = NULL;
					base_expression_type = NULL;
					if (vala_method_get_overrides (m)) {
						ValaMethod* _tmp82;
						ValaMethod* _tmp81;
						ValaReferenceType* _tmp83;
						_tmp82 = NULL;
						_tmp81 = NULL;
						base_method = (_tmp82 = (_tmp81 = vala_method_get_base_method (m), (_tmp81 == NULL ? NULL : vala_code_node_ref (_tmp81))), (base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL))), _tmp82);
						_tmp83 = NULL;
						base_expression_type = (_tmp83 = ((ValaReferenceType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (base_method))))))))), (base_expression_type == NULL ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL))), _tmp83);
					} else {
						ValaMethod* _tmp85;
						ValaMethod* _tmp84;
						ValaReferenceType* _tmp86;
						_tmp85 = NULL;
						_tmp84 = NULL;
						base_method = (_tmp85 = (_tmp84 = vala_method_get_base_interface_method (m), (_tmp84 == NULL ? NULL : vala_code_node_ref (_tmp84))), (base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL))), _tmp85);
						_tmp86 = NULL;
						base_expression_type = (_tmp86 = ((ValaReferenceType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (base_method))))))))), (base_expression_type == NULL ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL))), _tmp86);
					}
					self_target_type = vala_object_type_new (((ValaObjectTypeSymbol*) (cl)));
					_tmp87 = NULL;
					_tmp88 = NULL;
					cself = (_tmp88 = vala_ccode_base_module_transform_expression (((ValaCCodeBaseModule*) (self)), ((ValaCCodeExpression*) ((_tmp87 = vala_ccode_identifier_new ("base")))), ((ValaDataType*) (base_expression_type)), ((ValaDataType*) (self_target_type)), NULL), (_tmp87 == NULL ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL))), _tmp88);
					_tmp90 = NULL;
					_tmp89 = NULL;
					_tmp91 = NULL;
					cdecl_ = (_tmp91 = vala_ccode_declaration_new ((_tmp90 = g_strdup_printf ("%s *", (_tmp89 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE))))), (_tmp90 = (g_free (_tmp90), NULL)), (_tmp89 = (g_free (_tmp89), NULL)), _tmp91);
					_tmp92 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp92 = vala_ccode_variable_declarator_new_with_initializer ("self", cself)))));
					(_tmp92 == NULL ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL)));
					vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) (cdecl_)));
					(base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)));
					(base_expression_type == NULL ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL)));
					(self_target_type == NULL ? NULL : (self_target_type = (vala_code_node_unref (self_target_type), NULL)));
					(cself == NULL ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
				} else {
					if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE && !(VALA_IS_CREATION_METHOD (m))) {
						ValaCCodeStatement* ccheckstmt;
						ccheckstmt = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, ((ValaTypeSymbol*) (cl)), TRUE, "self");
						vala_ccode_node_set_line (((ValaCCodeNode*) (ccheckstmt)), vala_ccode_node_get_line (((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function))));
						vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) (ccheckstmt)));
						(ccheckstmt == NULL ? NULL : (ccheckstmt = (vala_ccode_node_unref (ccheckstmt), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			}
			{
				GeeList* param_collection;
				int param_it;
				param_collection = vala_method_get_parameters (m);
				for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
					{
						ValaTypeSymbol* _tmp93;
						ValaTypeSymbol* t;
						if (vala_formal_parameter_get_ellipsis (param)) {
							(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
							break;
						}
						_tmp93 = NULL;
						t = (_tmp93 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)), (_tmp93 == NULL ? NULL : vala_code_node_ref (_tmp93)));
						if (t != NULL && vala_typesymbol_is_reference_type (t)) {
							if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
								ValaCCodeStatement* type_check;
								type_check = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, t, (vala_code_context_get_non_null (vala_ccode_base_module_get_context (((ValaCCodeBaseModule*) (self)))) && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param))), vala_symbol_get_name (((ValaSymbol*) (param))));
								if (type_check != NULL) {
									vala_ccode_node_set_line (((ValaCCodeNode*) (type_check)), vala_ccode_node_get_line (((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function))));
									vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) (type_check)));
								}
								(type_check == NULL ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL)));
							} else {
								ValaCCodeConstant* _tmp96;
								ValaCCodeUnaryExpression* _tmp95;
								ValaCCodeIdentifier* _tmp94;
								ValaCCodeAssignment* _tmp97;
								ValaCCodeAssignment* a;
								ValaCCodeExpressionStatement* _tmp98;
								/* ensure that the passed reference for output parameter is cleared*/
								_tmp96 = NULL;
								_tmp95 = NULL;
								_tmp94 = NULL;
								_tmp97 = NULL;
								a = (_tmp97 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp95 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, ((ValaCCodeExpression*) ((_tmp94 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))))))), ((ValaCCodeExpression*) ((_tmp96 = vala_ccode_constant_new ("NULL")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp96 == NULL ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL))), (_tmp95 == NULL ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL))), (_tmp94 == NULL ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL))), _tmp97);
								_tmp98 = NULL;
								vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) ((_tmp98 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (a)))))));
								(_tmp98 == NULL ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL)));
								(a == NULL ? NULL : (a = (vala_ccode_node_unref (a), NULL)));
							}
						}
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						(t == NULL ? NULL : (t = (vala_code_node_unref (t), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
			}
			if (inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp100;
				ValaCCodeConstant* _tmp99;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp100 = NULL;
				_tmp99 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp100 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", ((ValaCCodeExpression*) ((_tmp99 = vala_ccode_constant_new ("NULL")))))))));
				(_tmp100 == NULL ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL)));
				(_tmp99 == NULL ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL)));
				vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) (cdecl_)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			}
			if (vala_code_node_get_source_reference (((ValaCodeNode*) (m))) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) (m)))) != NULL) {
				ValaCCodeComment* _tmp101;
				_tmp101 = NULL;
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) ((_tmp101 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) (m)))))))));
				(_tmp101 == NULL ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL)));
			}
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function)));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (in_gobject_creation_method) {
					gint n_params;
					GeeList* _tmp102;
					gboolean _tmp103;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					_tmp102 = NULL;
					if ((_tmp103 = n_params > 0 || gee_collection_get_size (((GeeCollection*) ((_tmp102 = vala_class_get_type_parameters (((ValaCCodeBaseModule*) (self))->current_class))))) > 0, (_tmp102 == NULL ? NULL : (_tmp102 = (gee_collection_object_unref (_tmp102), NULL))), _tmp103)) {
						ValaCCodeIdentifier* _tmp104;
						ValaCCodeFunctionCall* _tmp105;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* _tmp106;
						ValaCCodeConstant* _tmp109;
						char* _tmp108;
						GeeList* _tmp107;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp110;
						ValaCCodeDeclaration* _tmp111;
						ValaCCodeVariableDeclarator* _tmp113;
						ValaCCodeIdentifier* _tmp112;
						/* declare construction parameter array*/
						_tmp104 = NULL;
						_tmp105 = NULL;
						cparamsinit = (_tmp105 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp104 = vala_ccode_identifier_new ("g_new0"))))), (_tmp104 == NULL ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL))), _tmp105);
						_tmp106 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, ((ValaCCodeExpression*) ((_tmp106 = vala_ccode_identifier_new ("GParameter")))));
						(_tmp106 == NULL ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL)));
						_tmp109 = NULL;
						_tmp108 = NULL;
						_tmp107 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, ((ValaCCodeExpression*) ((_tmp109 = vala_ccode_constant_new ((_tmp108 = g_strdup_printf ("%i", (n_params + 3 * gee_collection_get_size (((GeeCollection*) ((_tmp107 = vala_class_get_type_parameters (((ValaCCodeBaseModule*) (self))->current_class)))))))))))));
						(_tmp109 == NULL ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL)));
						_tmp108 = (g_free (_tmp108), NULL);
						(_tmp107 == NULL ? NULL : (_tmp107 = (gee_collection_object_unref (_tmp107), NULL)));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						_tmp110 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp110 = vala_ccode_variable_declarator_new_with_initializer ("__params", ((ValaCCodeExpression*) (cparamsinit)))))));
						(_tmp110 == NULL ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL)));
						vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) (cdecl_)));
						_tmp111 = NULL;
						cdecl_ = (_tmp111 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp111);
						_tmp113 = NULL;
						_tmp112 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp113 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", ((ValaCCodeExpression*) ((_tmp112 = vala_ccode_identifier_new ("__params")))))))));
						(_tmp113 == NULL ? NULL : (_tmp113 = (vala_ccode_node_unref (_tmp113), NULL)));
						(_tmp112 == NULL ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL)));
						vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) (cdecl_)));
						(cparamsinit == NULL ? NULL : (cparamsinit = (vala_ccode_node_unref (cparamsinit), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
					}
					/* type, dup func, and destroy func properties for generic types */
					{
						GeeList* type_param_collection;
						int type_param_it;
						type_param_collection = vala_class_get_type_parameters (((ValaCCodeBaseModule*) (self))->current_class);
						for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
							ValaTypeParameter* type_param;
							type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
							{
								ValaCCodeConstant* prop_name;
								ValaCCodeIdentifier* param_name;
								ValaCCodeConstant* _tmp116;
								char* _tmp115;
								char* _tmp114;
								ValaCCodeIdentifier* _tmp119;
								char* _tmp118;
								char* _tmp117;
								ValaCCodeExpressionStatement* _tmp122;
								ValaCCodeExpression* _tmp121;
								ValaValueType* _tmp120;
								ValaCCodeConstant* _tmp125;
								char* _tmp124;
								char* _tmp123;
								ValaCCodeIdentifier* _tmp128;
								char* _tmp127;
								char* _tmp126;
								ValaCCodeExpressionStatement* _tmp132;
								ValaCCodeExpression* _tmp131;
								ValaPointerType* _tmp130;
								ValaVoidType* _tmp129;
								ValaCCodeConstant* _tmp135;
								char* _tmp134;
								char* _tmp133;
								ValaCCodeIdentifier* _tmp138;
								char* _tmp137;
								char* _tmp136;
								ValaCCodeExpressionStatement* _tmp142;
								ValaCCodeExpression* _tmp141;
								ValaPointerType* _tmp140;
								ValaVoidType* _tmp139;
								prop_name = NULL;
								param_name = NULL;
								_tmp116 = NULL;
								_tmp115 = NULL;
								_tmp114 = NULL;
								prop_name = (_tmp116 = vala_ccode_constant_new ((_tmp115 = g_strdup_printf ("\"%s-type\"", (_tmp114 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1))))), (prop_name == NULL ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL))), _tmp116);
								_tmp115 = (g_free (_tmp115), NULL);
								_tmp114 = (g_free (_tmp114), NULL);
								_tmp119 = NULL;
								_tmp118 = NULL;
								_tmp117 = NULL;
								param_name = (_tmp119 = vala_ccode_identifier_new ((_tmp118 = g_strdup_printf ("%s_type", (_tmp117 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp119);
								_tmp118 = (g_free (_tmp118), NULL);
								_tmp117 = (g_free (_tmp117), NULL);
								_tmp122 = NULL;
								_tmp121 = NULL;
								_tmp120 = NULL;
								vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) ((_tmp122 = vala_ccode_expression_statement_new ((_tmp121 = vala_ccode_module_get_construct_property_assignment (((ValaCCodeModule*) (self)), prop_name, ((ValaDataType*) ((_tmp120 = vala_value_type_new (((ValaCCodeBaseModule*) (self))->gtype_type)))), ((ValaCCodeExpression*) (param_name)))))))));
								(_tmp122 == NULL ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL)));
								(_tmp121 == NULL ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL)));
								(_tmp120 == NULL ? NULL : (_tmp120 = (vala_code_node_unref (_tmp120), NULL)));
								_tmp125 = NULL;
								_tmp124 = NULL;
								_tmp123 = NULL;
								prop_name = (_tmp125 = vala_ccode_constant_new ((_tmp124 = g_strdup_printf ("\"%s-dup-func\"", (_tmp123 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1))))), (prop_name == NULL ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL))), _tmp125);
								_tmp124 = (g_free (_tmp124), NULL);
								_tmp123 = (g_free (_tmp123), NULL);
								_tmp128 = NULL;
								_tmp127 = NULL;
								_tmp126 = NULL;
								param_name = (_tmp128 = vala_ccode_identifier_new ((_tmp127 = g_strdup_printf ("%s_dup_func", (_tmp126 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp128);
								_tmp127 = (g_free (_tmp127), NULL);
								_tmp126 = (g_free (_tmp126), NULL);
								_tmp132 = NULL;
								_tmp131 = NULL;
								_tmp130 = NULL;
								_tmp129 = NULL;
								vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) ((_tmp132 = vala_ccode_expression_statement_new ((_tmp131 = vala_ccode_module_get_construct_property_assignment (((ValaCCodeModule*) (self)), prop_name, ((ValaDataType*) ((_tmp130 = vala_pointer_type_new (((ValaDataType*) ((_tmp129 = vala_void_type_new ()))), NULL)))), ((ValaCCodeExpression*) (param_name)))))))));
								(_tmp132 == NULL ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL)));
								(_tmp131 == NULL ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL)));
								(_tmp130 == NULL ? NULL : (_tmp130 = (vala_code_node_unref (_tmp130), NULL)));
								(_tmp129 == NULL ? NULL : (_tmp129 = (vala_code_node_unref (_tmp129), NULL)));
								_tmp135 = NULL;
								_tmp134 = NULL;
								_tmp133 = NULL;
								prop_name = (_tmp135 = vala_ccode_constant_new ((_tmp134 = g_strdup_printf ("\"%s-destroy-func\"", (_tmp133 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1))))), (prop_name == NULL ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL))), _tmp135);
								_tmp134 = (g_free (_tmp134), NULL);
								_tmp133 = (g_free (_tmp133), NULL);
								_tmp138 = NULL;
								_tmp137 = NULL;
								_tmp136 = NULL;
								param_name = (_tmp138 = vala_ccode_identifier_new ((_tmp137 = g_strdup_printf ("%s_destroy_func", (_tmp136 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp138);
								_tmp137 = (g_free (_tmp137), NULL);
								_tmp136 = (g_free (_tmp136), NULL);
								_tmp142 = NULL;
								_tmp141 = NULL;
								_tmp140 = NULL;
								_tmp139 = NULL;
								vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) ((_tmp142 = vala_ccode_expression_statement_new ((_tmp141 = vala_ccode_module_get_construct_property_assignment (((ValaCCodeModule*) (self)), prop_name, ((ValaDataType*) ((_tmp140 = vala_pointer_type_new (((ValaDataType*) ((_tmp139 = vala_void_type_new ()))), NULL)))), ((ValaCCodeExpression*) (param_name)))))))));
								(_tmp142 == NULL ? NULL : (_tmp142 = (vala_ccode_node_unref (_tmp142), NULL)));
								(_tmp141 == NULL ? NULL : (_tmp141 = (vala_ccode_node_unref (_tmp141), NULL)));
								(_tmp140 == NULL ? NULL : (_tmp140 = (vala_code_node_unref (_tmp140), NULL)));
								(_tmp139 == NULL ? NULL : (_tmp139 = (vala_code_node_unref (_tmp139), NULL)));
								(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
								(prop_name == NULL ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)));
								(param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)));
							}
						}
						(type_param_collection == NULL ? NULL : (type_param_collection = (gee_collection_object_unref (type_param_collection), NULL)));
					}
				} else {
					if (in_gtypeinstance_creation_method) {
						ValaClass* _tmp143;
						ValaClass* cl;
						char* _tmp145;
						char* _tmp144;
						ValaCCodeDeclaration* _tmp146;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeIdentifier* _tmp147;
						ValaCCodeFunctionCall* _tmp148;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeIdentifier* _tmp149;
						ValaCCodeVariableDeclarator* _tmp153;
						ValaCCodeCastExpression* _tmp152;
						char* _tmp151;
						char* _tmp150;
						_tmp143 = NULL;
						cl = (_tmp143 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp143 == NULL ? NULL : vala_code_node_ref (_tmp143)));
						_tmp145 = NULL;
						_tmp144 = NULL;
						_tmp146 = NULL;
						cdecl_ = (_tmp146 = vala_ccode_declaration_new ((_tmp145 = g_strconcat ((_tmp144 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)), "*", NULL))), (_tmp145 = (g_free (_tmp145), NULL)), (_tmp144 = (g_free (_tmp144), NULL)), _tmp146);
						_tmp147 = NULL;
						_tmp148 = NULL;
						ccall = (_tmp148 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp147 = vala_ccode_identifier_new ("g_type_create_instance"))))), (_tmp147 == NULL ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL))), _tmp148);
						_tmp149 = NULL;
						vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp149 = vala_ccode_identifier_new ("object_type")))));
						(_tmp149 == NULL ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL)));
						_tmp153 = NULL;
						_tmp152 = NULL;
						_tmp151 = NULL;
						_tmp150 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp153 = vala_ccode_variable_declarator_new_with_initializer ("self", ((ValaCCodeExpression*) ((_tmp152 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) (ccall)), (_tmp151 = g_strconcat ((_tmp150 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)), "*", NULL)))))))))));
						(_tmp153 == NULL ? NULL : (_tmp153 = (vala_ccode_node_unref (_tmp153), NULL)));
						(_tmp152 == NULL ? NULL : (_tmp152 = (vala_ccode_node_unref (_tmp152), NULL)));
						_tmp151 = (g_free (_tmp151), NULL);
						_tmp150 = (g_free (_tmp150), NULL);
						vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) (cdecl_)));
						/* type, dup func, and destroy func fields for generic types */
						{
							GeeList* type_param_collection;
							int type_param_it;
							type_param_collection = vala_class_get_type_parameters (((ValaCCodeBaseModule*) (self))->current_class);
							for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
								ValaTypeParameter* type_param;
								type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
								{
									ValaCCodeIdentifier* param_name;
									ValaCCodeAssignment* assign;
									ValaCCodeIdentifier* _tmp154;
									ValaCCodeMemberAccess* _tmp155;
									ValaCCodeMemberAccess* priv_access;
									ValaCCodeIdentifier* _tmp158;
									char* _tmp157;
									char* _tmp156;
									ValaCCodeAssignment* _tmp160;
									ValaCCodeMemberAccess* _tmp159;
									ValaCCodeExpressionStatement* _tmp161;
									ValaCCodeIdentifier* _tmp164;
									char* _tmp163;
									char* _tmp162;
									ValaCCodeAssignment* _tmp166;
									ValaCCodeMemberAccess* _tmp165;
									ValaCCodeExpressionStatement* _tmp167;
									ValaCCodeIdentifier* _tmp170;
									char* _tmp169;
									char* _tmp168;
									ValaCCodeAssignment* _tmp172;
									ValaCCodeMemberAccess* _tmp171;
									ValaCCodeExpressionStatement* _tmp173;
									param_name = NULL;
									assign = NULL;
									_tmp154 = NULL;
									_tmp155 = NULL;
									priv_access = (_tmp155 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp154 = vala_ccode_identifier_new ("self")))), "priv"), (_tmp154 == NULL ? NULL : (_tmp154 = (vala_ccode_node_unref (_tmp154), NULL))), _tmp155);
									_tmp158 = NULL;
									_tmp157 = NULL;
									_tmp156 = NULL;
									param_name = (_tmp158 = vala_ccode_identifier_new ((_tmp157 = g_strdup_printf ("%s_type", (_tmp156 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp158);
									_tmp157 = (g_free (_tmp157), NULL);
									_tmp156 = (g_free (_tmp156), NULL);
									_tmp160 = NULL;
									_tmp159 = NULL;
									assign = (_tmp160 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp159 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (priv_access)), vala_ccode_identifier_get_name (param_name))))), ((ValaCCodeExpression*) (param_name)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL))), _tmp160);
									(_tmp159 == NULL ? NULL : (_tmp159 = (vala_ccode_node_unref (_tmp159), NULL)));
									_tmp161 = NULL;
									vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) ((_tmp161 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (assign)))))));
									(_tmp161 == NULL ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL)));
									_tmp164 = NULL;
									_tmp163 = NULL;
									_tmp162 = NULL;
									param_name = (_tmp164 = vala_ccode_identifier_new ((_tmp163 = g_strdup_printf ("%s_dup_func", (_tmp162 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp164);
									_tmp163 = (g_free (_tmp163), NULL);
									_tmp162 = (g_free (_tmp162), NULL);
									_tmp166 = NULL;
									_tmp165 = NULL;
									assign = (_tmp166 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp165 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (priv_access)), vala_ccode_identifier_get_name (param_name))))), ((ValaCCodeExpression*) (param_name)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL))), _tmp166);
									(_tmp165 == NULL ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL)));
									_tmp167 = NULL;
									vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) ((_tmp167 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (assign)))))));
									(_tmp167 == NULL ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL)));
									_tmp170 = NULL;
									_tmp169 = NULL;
									_tmp168 = NULL;
									param_name = (_tmp170 = vala_ccode_identifier_new ((_tmp169 = g_strdup_printf ("%s_destroy_func", (_tmp168 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1))))), (param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL))), _tmp170);
									_tmp169 = (g_free (_tmp169), NULL);
									_tmp168 = (g_free (_tmp168), NULL);
									_tmp172 = NULL;
									_tmp171 = NULL;
									assign = (_tmp172 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp171 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (priv_access)), vala_ccode_identifier_get_name (param_name))))), ((ValaCCodeExpression*) (param_name)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL))), _tmp172);
									(_tmp171 == NULL ? NULL : (_tmp171 = (vala_ccode_node_unref (_tmp171), NULL)));
									_tmp173 = NULL;
									vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) ((_tmp173 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (assign)))))));
									(_tmp173 == NULL ? NULL : (_tmp173 = (vala_ccode_node_unref (_tmp173), NULL)));
									(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
									(param_name == NULL ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)));
									(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
									(priv_access == NULL ? NULL : (priv_access = (vala_ccode_node_unref (priv_access), NULL)));
								}
							}
							(type_param_collection == NULL ? NULL : (type_param_collection = (gee_collection_object_unref (type_param_collection), NULL)));
						}
						(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
						(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
					} else {
						if (VALA_IS_CLASS (((ValaCCodeBaseModule*) (self))->current_type_symbol)) {
							ValaClass* _tmp174;
							ValaClass* cl;
							char* _tmp176;
							char* _tmp175;
							ValaCCodeDeclaration* _tmp177;
							ValaCCodeDeclaration* cdecl_;
							ValaCCodeIdentifier* _tmp178;
							ValaCCodeFunctionCall* _tmp179;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp181;
							char* _tmp180;
							ValaCCodeVariableDeclarator* _tmp182;
							ValaCCodeIdentifier* _tmp185;
							char* _tmp184;
							char* _tmp183;
							ValaCCodeFunctionCall* _tmp186;
							ValaCCodeFunctionCall* cinitcall;
							ValaCCodeIdentifier* _tmp187;
							ValaCCodeExpressionStatement* _tmp188;
							_tmp174 = NULL;
							cl = (_tmp174 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp174 == NULL ? NULL : vala_code_node_ref (_tmp174)));
							_tmp176 = NULL;
							_tmp175 = NULL;
							_tmp177 = NULL;
							cdecl_ = (_tmp177 = vala_ccode_declaration_new ((_tmp176 = g_strconcat ((_tmp175 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)), "*", NULL))), (_tmp176 = (g_free (_tmp176), NULL)), (_tmp175 = (g_free (_tmp175), NULL)), _tmp177);
							_tmp178 = NULL;
							_tmp179 = NULL;
							ccall = (_tmp179 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp178 = vala_ccode_identifier_new ("g_slice_new0"))))), (_tmp178 == NULL ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL))), _tmp179);
							_tmp181 = NULL;
							_tmp180 = NULL;
							vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp181 = vala_ccode_identifier_new ((_tmp180 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)))))));
							(_tmp181 == NULL ? NULL : (_tmp181 = (vala_ccode_node_unref (_tmp181), NULL)));
							_tmp180 = (g_free (_tmp180), NULL);
							_tmp182 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp182 = vala_ccode_variable_declarator_new_with_initializer ("self", ((ValaCCodeExpression*) (ccall)))))));
							(_tmp182 == NULL ? NULL : (_tmp182 = (vala_ccode_node_unref (_tmp182), NULL)));
							vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) (cdecl_)));
							_tmp185 = NULL;
							_tmp184 = NULL;
							_tmp183 = NULL;
							_tmp186 = NULL;
							cinitcall = (_tmp186 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp185 = vala_ccode_identifier_new ((_tmp184 = g_strdup_printf ("%s_instance_init", (_tmp183 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (cl)), NULL))))))))), (_tmp185 == NULL ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL))), (_tmp184 = (g_free (_tmp184), NULL)), (_tmp183 = (g_free (_tmp183), NULL)), _tmp186);
							_tmp187 = NULL;
							vala_ccode_function_call_add_argument (cinitcall, ((ValaCCodeExpression*) ((_tmp187 = vala_ccode_identifier_new ("self")))));
							(_tmp187 == NULL ? NULL : (_tmp187 = (vala_ccode_node_unref (_tmp187), NULL)));
							_tmp188 = NULL;
							vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) ((_tmp188 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cinitcall)))))));
							(_tmp188 == NULL ? NULL : (_tmp188 = (vala_ccode_node_unref (_tmp188), NULL)));
							(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
							(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
							(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							(cinitcall == NULL ? NULL : (cinitcall = (vala_ccode_node_unref (cinitcall), NULL)));
						} else {
							ValaStruct* _tmp189;
							ValaStruct* st;
							ValaCCodeIdentifier* _tmp190;
							ValaCCodeFunctionCall* _tmp191;
							ValaCCodeFunctionCall* czero;
							ValaCCodeIdentifier* _tmp192;
							ValaCCodeConstant* _tmp193;
							ValaCCodeIdentifier* _tmp196;
							char* _tmp195;
							char* _tmp194;
							ValaCCodeExpressionStatement* _tmp197;
							_tmp189 = NULL;
							st = (_tmp189 = VALA_STRUCT (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp189 == NULL ? NULL : vala_code_node_ref (_tmp189)));
							/* memset needs string.h*/
							((ValaCCodeBaseModule*) (self))->string_h_needed = TRUE;
							_tmp190 = NULL;
							_tmp191 = NULL;
							czero = (_tmp191 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp190 = vala_ccode_identifier_new ("memset"))))), (_tmp190 == NULL ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL))), _tmp191);
							_tmp192 = NULL;
							vala_ccode_function_call_add_argument (czero, ((ValaCCodeExpression*) ((_tmp192 = vala_ccode_identifier_new ("self")))));
							(_tmp192 == NULL ? NULL : (_tmp192 = (vala_ccode_node_unref (_tmp192), NULL)));
							_tmp193 = NULL;
							vala_ccode_function_call_add_argument (czero, ((ValaCCodeExpression*) ((_tmp193 = vala_ccode_constant_new ("0")))));
							(_tmp193 == NULL ? NULL : (_tmp193 = (vala_ccode_node_unref (_tmp193), NULL)));
							_tmp196 = NULL;
							_tmp195 = NULL;
							_tmp194 = NULL;
							vala_ccode_function_call_add_argument (czero, ((ValaCCodeExpression*) ((_tmp196 = vala_ccode_identifier_new ((_tmp195 = g_strdup_printf ("sizeof (%s)", (_tmp194 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (st)), FALSE)))))))));
							(_tmp196 == NULL ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL)));
							_tmp195 = (g_free (_tmp195), NULL);
							_tmp194 = (g_free (_tmp194), NULL);
							_tmp197 = NULL;
							vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) ((_tmp197 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (czero)))))));
							(_tmp197 == NULL ? NULL : (_tmp197 = (vala_ccode_node_unref (_tmp197), NULL)));
							(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
							(czero == NULL ? NULL : (czero = (vala_ccode_node_unref (czero), NULL)));
						}
					}
				}
			}
			if (vala_code_context_get_module_init_method (vala_ccode_base_module_get_context (((ValaCCodeBaseModule*) (self)))) == m && ((ValaCCodeBaseModule*) (self))->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->module_init_fragment)));
			}
			{
				GeeList* precondition_collection;
				int precondition_it;
				precondition_collection = vala_method_get_preconditions (m);
				for (precondition_it = 0; precondition_it < gee_collection_get_size (GEE_COLLECTION (precondition_collection)); precondition_it = precondition_it + 1) {
					ValaExpression* precondition;
					precondition = ((ValaExpression*) (gee_list_get (GEE_LIST (precondition_collection), precondition_it)));
					{
						ValaCCodeStatement* _tmp198;
						_tmp198 = NULL;
						vala_ccode_fragment_append (cinit, ((ValaCCodeNode*) ((_tmp198 = vala_ccode_method_module_create_precondition_statement (self, ((ValaCodeNode*) (m)), creturn_type, precondition)))));
						(_tmp198 == NULL ? NULL : (_tmp198 = (vala_ccode_node_unref (_tmp198), NULL)));
						(precondition == NULL ? NULL : (precondition = (vala_code_node_unref (precondition), NULL)));
					}
				}
				(precondition_collection == NULL ? NULL : (precondition_collection = (gee_collection_object_unref (precondition_collection), NULL)));
			}
			(cinit == NULL ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)));
		} else {
			if (vala_method_get_is_abstract (m)) {
				ValaCCodeBlock* cblock;
				ValaCCodeStatement* _tmp199;
				ValaCCodeIdentifier* _tmp200;
				ValaCCodeFunctionCall* _tmp201;
				ValaCCodeFunctionCall* type_from_instance_call;
				ValaCCodeIdentifier* _tmp202;
				ValaCCodeIdentifier* _tmp203;
				ValaCCodeFunctionCall* _tmp204;
				ValaCCodeFunctionCall* type_name_call;
				char* _tmp205;
				char* _tmp206;
				char* error_string;
				ValaCCodeIdentifier* _tmp207;
				ValaCCodeFunctionCall* _tmp208;
				ValaCCodeFunctionCall* cerrorcall;
				ValaCCodeConstant* _tmp209;
				ValaCCodeExpressionStatement* _tmp210;
				ValaCCodeReturnStatement* _tmp212;
				ValaCCodeExpression* _tmp211;
				/* generate helpful error message if a sublcass does not implement an abstract method.
				 This is only meaningful for subclasses implemented in C since the vala compiler would
				 complain during compile time of such en error.*/
				cblock = vala_ccode_block_new ();
				/* add a typecheck statement for "self"*/
				_tmp199 = NULL;
				vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp199 = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, ((ValaCCodeBaseModule*) (self))->current_type_symbol, TRUE, "self")))));
				(_tmp199 == NULL ? NULL : (_tmp199 = (vala_ccode_node_unref (_tmp199), NULL)));
				/* add critical warning that this method should not have been called*/
				_tmp200 = NULL;
				_tmp201 = NULL;
				type_from_instance_call = (_tmp201 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp200 = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE"))))), (_tmp200 == NULL ? NULL : (_tmp200 = (vala_ccode_node_unref (_tmp200), NULL))), _tmp201);
				_tmp202 = NULL;
				vala_ccode_function_call_add_argument (type_from_instance_call, ((ValaCCodeExpression*) ((_tmp202 = vala_ccode_identifier_new ("self")))));
				(_tmp202 == NULL ? NULL : (_tmp202 = (vala_ccode_node_unref (_tmp202), NULL)));
				_tmp203 = NULL;
				_tmp204 = NULL;
				type_name_call = (_tmp204 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp203 = vala_ccode_identifier_new ("g_type_name"))))), (_tmp203 == NULL ? NULL : (_tmp203 = (vala_ccode_node_unref (_tmp203), NULL))), _tmp204);
				vala_ccode_function_call_add_argument (type_name_call, ((ValaCCodeExpression*) (type_from_instance_call)));
				_tmp205 = NULL;
				_tmp206 = NULL;
				error_string = (_tmp206 = g_strdup_printf ("\"Type `%%s' does not implement abstract method `%s'\"", (_tmp205 = vala_method_get_cname (m))), (_tmp205 = (g_free (_tmp205), NULL)), _tmp206);
				_tmp207 = NULL;
				_tmp208 = NULL;
				cerrorcall = (_tmp208 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp207 = vala_ccode_identifier_new ("g_critical"))))), (_tmp207 == NULL ? NULL : (_tmp207 = (vala_ccode_node_unref (_tmp207), NULL))), _tmp208);
				_tmp209 = NULL;
				vala_ccode_function_call_add_argument (cerrorcall, ((ValaCCodeExpression*) ((_tmp209 = vala_ccode_constant_new (error_string)))));
				(_tmp209 == NULL ? NULL : (_tmp209 = (vala_ccode_node_unref (_tmp209), NULL)));
				vala_ccode_function_call_add_argument (cerrorcall, ((ValaCCodeExpression*) (type_name_call)));
				_tmp210 = NULL;
				vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp210 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cerrorcall)))))));
				(_tmp210 == NULL ? NULL : (_tmp210 = (vala_ccode_node_unref (_tmp210), NULL)));
				/* add return statement*/
				_tmp212 = NULL;
				_tmp211 = NULL;
				vala_ccode_block_add_statement (cblock, ((ValaCCodeNode*) ((_tmp212 = vala_ccode_return_statement_new ((_tmp211 = vala_ccode_base_module_default_value_for_type (((ValaCCodeBaseModule*) (self)), creturn_type, FALSE)))))));
				(_tmp212 == NULL ? NULL : (_tmp212 = (vala_ccode_node_unref (_tmp212), NULL)));
				(_tmp211 == NULL ? NULL : (_tmp211 = (vala_ccode_node_unref (_tmp211), NULL)));
				vala_ccode_function_set_block (((ValaCCodeBaseModule*) (self))->function, cblock);
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function)));
				(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
				(type_from_instance_call == NULL ? NULL : (type_from_instance_call = (vala_ccode_node_unref (type_from_instance_call), NULL)));
				(type_name_call == NULL ? NULL : (type_name_call = (vala_ccode_node_unref (type_name_call), NULL)));
				error_string = (g_free (error_string), NULL);
				(cerrorcall == NULL ? NULL : (cerrorcall = (vala_ccode_node_unref (cerrorcall), NULL)));
			}
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		char* _tmp214;
		char* _tmp213;
		ValaCCodeFunction* _tmp215;
		ValaCCodeFunction* vfunc;
		ValaReferenceType* this_type;
		GeeHashMap* _tmp218;
		GeeHashMap* carg_map;
		char* _tmp219;
		ValaCCodeFormalParameter* _tmp220;
		ValaCCodeFormalParameter* cparam;
		ValaCCodeBlock* vblock;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp232;
		ValaCCodeMemberAccess* _tmp233;
		ValaCCodeFunctionCall* _tmp234;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp235;
		ValaCCodeStatement* cstmt;
		GeeList* _tmp246;
		gboolean _tmp247;
		_tmp214 = NULL;
		_tmp213 = NULL;
		_tmp215 = NULL;
		vfunc = (_tmp215 = vala_ccode_function_new ((_tmp213 = vala_method_get_cname (m)), (_tmp214 = vala_data_type_get_cname (creturn_type))), (_tmp214 = (g_free (_tmp214), NULL)), (_tmp213 = (g_free (_tmp213), NULL)), _tmp215);
		vala_ccode_node_set_line (((ValaCCodeNode*) (vfunc)), vala_ccode_node_get_line (((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function))));
		this_type = NULL;
		if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m))))) {
			ValaReferenceType* _tmp216;
			_tmp216 = NULL;
			this_type = (_tmp216 = ((ValaReferenceType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m))))))))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp216);
		} else {
			ValaReferenceType* _tmp217;
			_tmp217 = NULL;
			this_type = (_tmp217 = ((ValaReferenceType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (m))))))))), (this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL))), _tmp217);
		}
		_tmp218 = NULL;
		cparam_map = (_tmp218 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL))), _tmp218);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		_tmp219 = NULL;
		_tmp220 = NULL;
		cparam = (_tmp220 = vala_ccode_formal_parameter_new ("self", (_tmp219 = vala_data_type_get_cname (((ValaDataType*) (this_type))))), (_tmp219 = (g_free (_tmp219), NULL)), _tmp220);
		gee_map_set (((GeeMap*) (cparam_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), cparam);
		vblock = vala_ccode_block_new ();
		{
			GeeList* precondition_collection;
			int precondition_it;
			precondition_collection = vala_method_get_preconditions (m);
			for (precondition_it = 0; precondition_it < gee_collection_get_size (GEE_COLLECTION (precondition_collection)); precondition_it = precondition_it + 1) {
				ValaExpression* precondition;
				precondition = ((ValaExpression*) (gee_list_get (GEE_LIST (precondition_collection), precondition_it)));
				{
					ValaCCodeStatement* _tmp221;
					_tmp221 = NULL;
					vala_ccode_block_add_statement (vblock, ((ValaCCodeNode*) ((_tmp221 = vala_ccode_method_module_create_precondition_statement (self, ((ValaCodeNode*) (m)), creturn_type, precondition)))));
					(_tmp221 == NULL ? NULL : (_tmp221 = (vala_ccode_node_unref (_tmp221), NULL)));
					(precondition == NULL ? NULL : (precondition = (vala_code_node_unref (precondition), NULL)));
				}
			}
			(precondition_collection == NULL ? NULL : (precondition_collection = (gee_collection_object_unref (precondition_collection), NULL)));
		}
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (m))))) {
			ValaInterface* _tmp222;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp226;
			ValaCCodeIdentifier* _tmp225;
			char* _tmp224;
			char* _tmp223;
			_tmp222 = NULL;
			iface = (_tmp222 = VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp222 == NULL ? NULL : vala_code_node_ref (_tmp222)));
			_tmp226 = NULL;
			_tmp225 = NULL;
			_tmp224 = NULL;
			_tmp223 = NULL;
			vcast = (_tmp226 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp225 = vala_ccode_identifier_new ((_tmp224 = g_strdup_printf ("%s_GET_INTERFACE", (_tmp223 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (iface)), NULL))))))))), (vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL))), _tmp226);
			(_tmp225 == NULL ? NULL : (_tmp225 = (vala_ccode_node_unref (_tmp225), NULL)));
			_tmp224 = (g_free (_tmp224), NULL);
			_tmp223 = (g_free (_tmp223), NULL);
			(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
		} else {
			ValaClass* _tmp227;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp231;
			ValaCCodeIdentifier* _tmp230;
			char* _tmp229;
			char* _tmp228;
			_tmp227 = NULL;
			cl = (_tmp227 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp227 == NULL ? NULL : vala_code_node_ref (_tmp227)));
			_tmp231 = NULL;
			_tmp230 = NULL;
			_tmp229 = NULL;
			_tmp228 = NULL;
			vcast = (_tmp231 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp230 = vala_ccode_identifier_new ((_tmp229 = g_strdup_printf ("%s_GET_CLASS", (_tmp228 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (cl)), NULL))))))))), (vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL))), _tmp231);
			(_tmp230 == NULL ? NULL : (_tmp230 = (vala_ccode_node_unref (_tmp230), NULL)));
			_tmp229 = (g_free (_tmp229), NULL);
			_tmp228 = (g_free (_tmp228), NULL);
			(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
		}
		_tmp232 = NULL;
		vala_ccode_function_call_add_argument (vcast, ((ValaCCodeExpression*) ((_tmp232 = vala_ccode_identifier_new ("self")))));
		(_tmp232 == NULL ? NULL : (_tmp232 = (vala_ccode_node_unref (_tmp232), NULL)));
		_tmp233 = NULL;
		_tmp234 = NULL;
		vcall = (_tmp234 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp233 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (vcast)), vala_method_get_vfunc_name (m)))))), (_tmp233 == NULL ? NULL : (_tmp233 = (vala_ccode_node_unref (_tmp233), NULL))), _tmp234);
		_tmp235 = NULL;
		gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), ((ValaCCodeExpression*) ((_tmp235 = vala_ccode_identifier_new ("self")))));
		(_tmp235 == NULL ? NULL : (_tmp235 = (vala_ccode_node_unref (_tmp235), NULL)));
		vala_ccode_module_generate_cparameters (((ValaCCodeModule*) (self)), m, creturn_type, in_gtypeinstance_creation_method, ((GeeMap*) (cparam_map)), vfunc, NULL, ((GeeMap*) (carg_map)), vcall, 3);
		cstmt = NULL;
		if (VALA_IS_VOID_TYPE (creturn_type)) {
			ValaCCodeStatement* _tmp236;
			_tmp236 = NULL;
			cstmt = (_tmp236 = ((ValaCCodeStatement*) (vala_ccode_expression_statement_new (((ValaCCodeExpression*) (vcall))))), (cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL))), _tmp236);
		} else {
			GeeList* _tmp237;
			gboolean _tmp238;
			_tmp237 = NULL;
			if ((_tmp238 = gee_collection_get_size (((GeeCollection*) ((_tmp237 = vala_method_get_postconditions (m))))) == 0, (_tmp237 == NULL ? NULL : (_tmp237 = (gee_collection_object_unref (_tmp237), NULL))), _tmp238)) {
				ValaCCodeStatement* _tmp239;
				/* pass method return value */
				_tmp239 = NULL;
				cstmt = (_tmp239 = ((ValaCCodeStatement*) (vala_ccode_return_statement_new (((ValaCCodeExpression*) (vcall))))), (cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL))), _tmp239);
			} else {
				char* _tmp241;
				char* _tmp240;
				ValaCCodeDeclaration* _tmp242;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp243;
				ValaCCodeStatement* _tmp245;
				ValaCCodeStatement* _tmp244;
				/* store method return value for postconditions */
				_tmp241 = NULL;
				_tmp240 = NULL;
				_tmp242 = NULL;
				cdecl_ = (_tmp242 = vala_ccode_declaration_new ((_tmp241 = vala_ccode_method_module_get_creturn_type (self, m, (_tmp240 = vala_data_type_get_cname (creturn_type))))), (_tmp241 = (g_free (_tmp241), NULL)), (_tmp240 = (g_free (_tmp240), NULL)), _tmp242);
				_tmp243 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp243 = vala_ccode_variable_declarator_new_with_initializer ("result", ((ValaCCodeExpression*) (vcall)))))));
				(_tmp243 == NULL ? NULL : (_tmp243 = (vala_ccode_node_unref (_tmp243), NULL)));
				_tmp245 = NULL;
				_tmp244 = NULL;
				cstmt = (_tmp245 = (_tmp244 = ((ValaCCodeStatement*) (cdecl_)), (_tmp244 == NULL ? NULL : vala_ccode_node_ref (_tmp244))), (cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL))), _tmp245);
				(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			}
		}
		vala_ccode_node_set_line (((ValaCCodeNode*) (cstmt)), vala_ccode_node_get_line (((ValaCCodeNode*) (vfunc))));
		vala_ccode_block_add_statement (vblock, ((ValaCCodeNode*) (cstmt)));
		_tmp246 = NULL;
		if ((_tmp247 = gee_collection_get_size (((GeeCollection*) ((_tmp246 = vala_method_get_postconditions (m))))) > 0, (_tmp246 == NULL ? NULL : (_tmp246 = (gee_collection_object_unref (_tmp246), NULL))), _tmp247)) {
			{
				GeeList* postcondition_collection;
				int postcondition_it;
				postcondition_collection = vala_method_get_postconditions (m);
				for (postcondition_it = 0; postcondition_it < gee_collection_get_size (GEE_COLLECTION (postcondition_collection)); postcondition_it = postcondition_it + 1) {
					ValaExpression* postcondition;
					postcondition = ((ValaExpression*) (gee_list_get (GEE_LIST (postcondition_collection), postcondition_it)));
					{
						ValaCCodeStatement* _tmp248;
						_tmp248 = NULL;
						vala_ccode_block_add_statement (vblock, ((ValaCCodeNode*) ((_tmp248 = vala_ccode_method_module_create_postcondition_statement (self, postcondition)))));
						(_tmp248 == NULL ? NULL : (_tmp248 = (vala_ccode_node_unref (_tmp248), NULL)));
						(postcondition == NULL ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL)));
					}
				}
				(postcondition_collection == NULL ? NULL : (postcondition_collection = (gee_collection_object_unref (postcondition_collection), NULL)));
			}
			if (!(VALA_IS_VOID_TYPE (creturn_type))) {
				ValaCCodeIdentifier* _tmp249;
				ValaCCodeReturnStatement* _tmp250;
				ValaCCodeReturnStatement* cret_stmt;
				_tmp249 = NULL;
				_tmp250 = NULL;
				cret_stmt = (_tmp250 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp249 = vala_ccode_identifier_new ("result"))))), (_tmp249 == NULL ? NULL : (_tmp249 = (vala_ccode_node_unref (_tmp249), NULL))), _tmp250);
				vala_ccode_node_set_line (((ValaCCodeNode*) (cret_stmt)), vala_ccode_node_get_line (((ValaCCodeNode*) (vfunc))));
				vala_ccode_block_add_statement (vblock, ((ValaCCodeNode*) (cret_stmt)));
				(cret_stmt == NULL ? NULL : (cret_stmt = (vala_ccode_node_unref (cret_stmt), NULL)));
			}
		}
		if (visible) {
			ValaCCodeFunction* _tmp251;
			_tmp251 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->header_type_member_declaration, ((ValaCCodeNode*) ((_tmp251 = vala_ccode_function_copy (vfunc)))));
			(_tmp251 == NULL ? NULL : (_tmp251 = (vala_ccode_node_unref (_tmp251), NULL)));
		} else {
			ValaCCodeFunction* _tmp252;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp252 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp252 = vala_ccode_function_copy (vfunc)))));
			(_tmp252 == NULL ? NULL : (_tmp252 = (vala_ccode_node_unref (_tmp252), NULL)));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		if (vala_method_get_is_abstract (m) && vala_code_node_get_source_reference (((ValaCodeNode*) (m))) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) (m)))) != NULL) {
			ValaCCodeComment* _tmp253;
			_tmp253 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) ((_tmp253 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) (m)))))))));
			(_tmp253 == NULL ? NULL : (_tmp253 = (vala_ccode_node_unref (_tmp253), NULL)));
		}
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (vfunc)));
		(vfunc == NULL ? NULL : (vfunc = (vala_ccode_node_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)));
		(carg_map == NULL ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)));
		(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (vala_ccode_node_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL)));
		(cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		GeeList* _tmp265;
		gboolean _tmp266;
		if (((ValaCCodeBaseModule*) (self))->current_class != NULL && !vala_class_get_is_compact (((ValaCCodeBaseModule*) (self))->current_class)) {
			char* _tmp255;
			char* _tmp254;
			ValaCCodeFunction* _tmp256;
			ValaCCodeFunction* vfunc;
			ValaReferenceType* this_type;
			GeeHashMap* _tmp257;
			GeeHashMap* carg_map;
			ValaCCodeBlock* vblock;
			ValaCCodeIdentifier* _tmp259;
			char* _tmp258;
			ValaCCodeFunctionCall* _tmp260;
			ValaCCodeFunctionCall* vcall;
			ValaCCodeIdentifier* _tmp262;
			char* _tmp261;
			ValaCCodeStatement* cstmt;
			_tmp255 = NULL;
			_tmp254 = NULL;
			_tmp256 = NULL;
			vfunc = (_tmp256 = vala_ccode_function_new ((_tmp254 = vala_method_get_cname (m)), (_tmp255 = vala_data_type_get_cname (creturn_type))), (_tmp255 = (g_free (_tmp255), NULL)), (_tmp254 = (g_free (_tmp254), NULL)), _tmp256);
			vala_ccode_node_set_line (((ValaCCodeNode*) (vfunc)), vala_ccode_node_get_line (((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function))));
			this_type = ((ValaReferenceType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))))))));
			_tmp257 = NULL;
			cparam_map = (_tmp257 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL))), _tmp257);
			carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
			vblock = vala_ccode_block_new ();
			_tmp259 = NULL;
			_tmp258 = NULL;
			_tmp260 = NULL;
			vcall = (_tmp260 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp259 = vala_ccode_identifier_new ((_tmp258 = vala_method_get_real_cname (m))))))), (_tmp259 == NULL ? NULL : (_tmp259 = (vala_ccode_node_unref (_tmp259), NULL))), (_tmp258 = (g_free (_tmp258), NULL)), _tmp260);
			_tmp262 = NULL;
			_tmp261 = NULL;
			vala_ccode_function_call_add_argument (vcall, ((ValaCCodeExpression*) ((_tmp262 = vala_ccode_identifier_new ((_tmp261 = vala_typesymbol_get_type_id (((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->current_class)))))))));
			(_tmp262 == NULL ? NULL : (_tmp262 = (vala_ccode_node_unref (_tmp262), NULL)));
			_tmp261 = (g_free (_tmp261), NULL);
			vala_ccode_module_generate_cparameters (((ValaCCodeModule*) (self)), m, creturn_type, in_gtypeinstance_creation_method, ((GeeMap*) (cparam_map)), vfunc, NULL, ((GeeMap*) (carg_map)), vcall, 3);
			cstmt = ((ValaCCodeStatement*) (vala_ccode_return_statement_new (((ValaCCodeExpression*) (vcall)))));
			vala_ccode_node_set_line (((ValaCCodeNode*) (cstmt)), vala_ccode_node_get_line (((ValaCCodeNode*) (vfunc))));
			vala_ccode_block_add_statement (vblock, ((ValaCCodeNode*) (cstmt)));
			if (visible) {
				ValaCCodeFunction* _tmp263;
				_tmp263 = NULL;
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->header_type_member_declaration, ((ValaCCodeNode*) ((_tmp263 = vala_ccode_function_copy (vfunc)))));
				(_tmp263 == NULL ? NULL : (_tmp263 = (vala_ccode_node_unref (_tmp263), NULL)));
			} else {
				ValaCCodeFunction* _tmp264;
				vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp264 = NULL;
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_declaration, ((ValaCCodeNode*) ((_tmp264 = vala_ccode_function_copy (vfunc)))));
				(_tmp264 == NULL ? NULL : (_tmp264 = (vala_ccode_node_unref (_tmp264), NULL)));
			}
			vala_ccode_function_set_block (vfunc, vblock);
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (vfunc)));
			(vfunc == NULL ? NULL : (vfunc = (vala_ccode_node_unref (vfunc), NULL)));
			(this_type == NULL ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)));
			(carg_map == NULL ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)));
			(vblock == NULL ? NULL : (vblock = (vala_ccode_node_unref (vblock), NULL)));
			(vcall == NULL ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL)));
			(cstmt == NULL ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)));
		}
		_tmp265 = NULL;
		if ((_tmp266 = ((ValaCCodeBaseModule*) (self))->current_class != NULL && vala_typesymbol_is_subtype_of (((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->current_class)), ((ValaCCodeBaseModule*) (self))->gobject_type) && (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0 || gee_collection_get_size (((GeeCollection*) ((_tmp265 = vala_class_get_type_parameters (((ValaCCodeBaseModule*) (self))->current_class))))) > 0), (_tmp265 == NULL ? NULL : (_tmp265 = (gee_collection_object_unref (_tmp265), NULL))), _tmp266)) {
			ValaCCodeIdentifier* _tmp268;
			ValaCCodeIdentifier* _tmp267;
			ValaCCodeBinaryExpression* _tmp269;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeBlock* cdofreeparam;
			ValaCCodeExpressionStatement* _tmp272;
			ValaCCodeUnaryExpression* _tmp271;
			ValaCCodeIdentifier* _tmp270;
			ValaCCodeIdentifier* _tmp273;
			ValaCCodeFunctionCall* _tmp274;
			ValaCCodeFunctionCall* cunsetcall;
			ValaCCodeUnaryExpression* _tmp277;
			ValaCCodeMemberAccess* _tmp276;
			ValaCCodeIdentifier* _tmp275;
			ValaCCodeExpressionStatement* _tmp278;
			ValaCCodeWhileStatement* _tmp279;
			ValaCCodeIdentifier* _tmp280;
			ValaCCodeFunctionCall* _tmp281;
			ValaCCodeFunctionCall* cfreeparams;
			ValaCCodeIdentifier* _tmp282;
			ValaCCodeExpressionStatement* _tmp283;
			_tmp268 = NULL;
			_tmp267 = NULL;
			_tmp269 = NULL;
			ccond = (_tmp269 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, ((ValaCCodeExpression*) ((_tmp267 = vala_ccode_identifier_new ("__params_it")))), ((ValaCCodeExpression*) ((_tmp268 = vala_ccode_identifier_new ("__params"))))), (_tmp268 == NULL ? NULL : (_tmp268 = (vala_ccode_node_unref (_tmp268), NULL))), (_tmp267 == NULL ? NULL : (_tmp267 = (vala_ccode_node_unref (_tmp267), NULL))), _tmp269);
			cdofreeparam = vala_ccode_block_new ();
			_tmp272 = NULL;
			_tmp271 = NULL;
			_tmp270 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, ((ValaCCodeNode*) ((_tmp272 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp271 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, ((ValaCCodeExpression*) ((_tmp270 = vala_ccode_identifier_new ("__params_it")))))))))))));
			(_tmp272 == NULL ? NULL : (_tmp272 = (vala_ccode_node_unref (_tmp272), NULL)));
			(_tmp271 == NULL ? NULL : (_tmp271 = (vala_ccode_node_unref (_tmp271), NULL)));
			(_tmp270 == NULL ? NULL : (_tmp270 = (vala_ccode_node_unref (_tmp270), NULL)));
			_tmp273 = NULL;
			_tmp274 = NULL;
			cunsetcall = (_tmp274 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp273 = vala_ccode_identifier_new ("g_value_unset"))))), (_tmp273 == NULL ? NULL : (_tmp273 = (vala_ccode_node_unref (_tmp273), NULL))), _tmp274);
			_tmp277 = NULL;
			_tmp276 = NULL;
			_tmp275 = NULL;
			vala_ccode_function_call_add_argument (cunsetcall, ((ValaCCodeExpression*) ((_tmp277 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp276 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp275 = vala_ccode_identifier_new ("__params_it")))), "value")))))))));
			(_tmp277 == NULL ? NULL : (_tmp277 = (vala_ccode_node_unref (_tmp277), NULL)));
			(_tmp276 == NULL ? NULL : (_tmp276 = (vala_ccode_node_unref (_tmp276), NULL)));
			(_tmp275 == NULL ? NULL : (_tmp275 = (vala_ccode_node_unref (_tmp275), NULL)));
			_tmp278 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, ((ValaCCodeNode*) ((_tmp278 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cunsetcall)))))));
			(_tmp278 == NULL ? NULL : (_tmp278 = (vala_ccode_node_unref (_tmp278), NULL)));
			_tmp279 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) (self))->function), ((ValaCCodeNode*) ((_tmp279 = vala_ccode_while_statement_new (((ValaCCodeExpression*) (ccond)), ((ValaCCodeStatement*) (cdofreeparam)))))));
			(_tmp279 == NULL ? NULL : (_tmp279 = (vala_ccode_node_unref (_tmp279), NULL)));
			_tmp280 = NULL;
			_tmp281 = NULL;
			cfreeparams = (_tmp281 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp280 = vala_ccode_identifier_new ("g_free"))))), (_tmp280 == NULL ? NULL : (_tmp280 = (vala_ccode_node_unref (_tmp280), NULL))), _tmp281);
			_tmp282 = NULL;
			vala_ccode_function_call_add_argument (cfreeparams, ((ValaCCodeExpression*) ((_tmp282 = vala_ccode_identifier_new ("__params")))));
			(_tmp282 == NULL ? NULL : (_tmp282 = (vala_ccode_node_unref (_tmp282), NULL)));
			_tmp283 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) (self))->function), ((ValaCCodeNode*) ((_tmp283 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cfreeparams)))))));
			(_tmp283 == NULL ? NULL : (_tmp283 = (vala_ccode_node_unref (_tmp283), NULL)));
			(ccond == NULL ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)));
			(cdofreeparam == NULL ? NULL : (cdofreeparam = (vala_ccode_node_unref (cdofreeparam), NULL)));
			(cunsetcall == NULL ? NULL : (cunsetcall = (vala_ccode_node_unref (cunsetcall), NULL)));
			(cfreeparams == NULL ? NULL : (cfreeparams = (vala_ccode_node_unref (cfreeparams), NULL)));
		}
		if (VALA_IS_CLASS (((ValaCCodeBaseModule*) (self))->current_type_symbol)) {
			ValaCCodeExpression* cresult;
			char* _tmp284;
			gboolean _tmp285;
			ValaCCodeReturnStatement* creturn;
			cresult = ((ValaCCodeExpression*) (vala_ccode_identifier_new ("self")));
			_tmp284 = NULL;
			if ((_tmp285 = (_tmp284 = vala_ccode_module_get_custom_creturn_type (((ValaCCodeModule*) (self)), m)) != NULL, (_tmp284 = (g_free (_tmp284), NULL)), _tmp285)) {
				ValaCCodeExpression* _tmp287;
				char* _tmp286;
				_tmp287 = NULL;
				_tmp286 = NULL;
				cresult = (_tmp287 = ((ValaCCodeExpression*) (vala_ccode_cast_expression_new (cresult, (_tmp286 = vala_ccode_module_get_custom_creturn_type (((ValaCCodeModule*) (self)), m))))), (cresult == NULL ? NULL : (cresult = (vala_ccode_node_unref (cresult), NULL))), _tmp287);
				_tmp286 = (g_free (_tmp286), NULL);
			}
			creturn = vala_ccode_return_statement_new (NULL);
			vala_ccode_return_statement_set_return_expression (creturn, cresult);
			vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) (self))->function), ((ValaCCodeNode*) (creturn)));
			(cresult == NULL ? NULL : (cresult = (vala_ccode_node_unref (cresult), NULL)));
			(creturn == NULL ? NULL : (creturn = (vala_ccode_node_unref (creturn), NULL)));
		}
	}
	return_value = TRUE;
	args_parameter = TRUE;
	if (vala_ccode_method_module_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp288;
		ValaCCodeFormalParameter* _tmp289;
		ValaCCodeBlock* main_block;
		ValaCCodeFunctionCall* _tmp295;
		ValaCCodeIdentifier* _tmp294;
		ValaCCodeExpressionStatement* _tmp296;
		ValaCCodeExpressionStatement* type_init_call;
		ValaCCodeIdentifier* _tmp297;
		ValaCCodeFunctionCall* _tmp298;
		ValaCCodeFunctionCall* main_call;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		vala_ccode_node_set_line (((ValaCCodeNode*) (cmain)), vala_ccode_node_get_line (((ValaCCodeNode*) (((ValaCCodeBaseModule*) (self))->function))));
		_tmp288 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp288 = vala_ccode_formal_parameter_new ("argc", "int")));
		(_tmp288 == NULL ? NULL : (_tmp288 = (vala_ccode_node_unref (_tmp288), NULL)));
		_tmp289 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp289 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(_tmp289 == NULL ? NULL : (_tmp289 = (vala_ccode_node_unref (_tmp289), NULL)));
		main_block = vala_ccode_block_new ();
		if (vala_code_context_get_thread (vala_ccode_base_module_get_context (((ValaCCodeBaseModule*) (self))))) {
			ValaCCodeIdentifier* _tmp290;
			ValaCCodeFunctionCall* _tmp291;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* _tmp292;
			ValaCCodeExpressionStatement* _tmp293;
			_tmp290 = NULL;
			_tmp291 = NULL;
			thread_init_call = (_tmp291 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp290 = vala_ccode_identifier_new ("g_thread_init"))))), (_tmp290 == NULL ? NULL : (_tmp290 = (vala_ccode_node_unref (_tmp290), NULL))), _tmp291);
			vala_ccode_node_set_line (((ValaCCodeNode*) (thread_init_call)), vala_ccode_node_get_line (((ValaCCodeNode*) (cmain))));
			_tmp292 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, ((ValaCCodeExpression*) ((_tmp292 = vala_ccode_constant_new ("NULL")))));
			(_tmp292 == NULL ? NULL : (_tmp292 = (vala_ccode_node_unref (_tmp292), NULL)));
			_tmp293 = NULL;
			vala_ccode_block_add_statement (main_block, ((ValaCCodeNode*) ((_tmp293 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (thread_init_call)))))));
			(_tmp293 == NULL ? NULL : (_tmp293 = (vala_ccode_node_unref (_tmp293), NULL)));
			(thread_init_call == NULL ? NULL : (thread_init_call = (vala_ccode_node_unref (thread_init_call), NULL)));
		}
		_tmp295 = NULL;
		_tmp294 = NULL;
		_tmp296 = NULL;
		type_init_call = (_tmp296 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp295 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp294 = vala_ccode_identifier_new ("g_type_init"))))))))), (_tmp295 == NULL ? NULL : (_tmp295 = (vala_ccode_node_unref (_tmp295), NULL))), (_tmp294 == NULL ? NULL : (_tmp294 = (vala_ccode_node_unref (_tmp294), NULL))), _tmp296);
		vala_ccode_node_set_line (((ValaCCodeNode*) (type_init_call)), vala_ccode_node_get_line (((ValaCCodeNode*) (cmain))));
		vala_ccode_block_add_statement (main_block, ((ValaCCodeNode*) (type_init_call)));
		_tmp297 = NULL;
		_tmp298 = NULL;
		main_call = (_tmp298 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp297 = vala_ccode_identifier_new (vala_ccode_function_get_name (((ValaCCodeBaseModule*) (self))->function)))))), (_tmp297 == NULL ? NULL : (_tmp297 = (vala_ccode_node_unref (_tmp297), NULL))), _tmp298);
		if (args_parameter) {
			ValaCCodeIdentifier* _tmp299;
			ValaCCodeIdentifier* _tmp300;
			_tmp299 = NULL;
			vala_ccode_function_call_add_argument (main_call, ((ValaCCodeExpression*) ((_tmp299 = vala_ccode_identifier_new ("argv")))));
			(_tmp299 == NULL ? NULL : (_tmp299 = (vala_ccode_node_unref (_tmp299), NULL)));
			_tmp300 = NULL;
			vala_ccode_function_call_add_argument (main_call, ((ValaCCodeExpression*) ((_tmp300 = vala_ccode_identifier_new ("argc")))));
			(_tmp300 == NULL ? NULL : (_tmp300 = (vala_ccode_node_unref (_tmp300), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* main_stmt;
			main_stmt = vala_ccode_return_statement_new (((ValaCCodeExpression*) (main_call)));
			vala_ccode_node_set_line (((ValaCCodeNode*) (main_stmt)), vala_ccode_node_get_line (((ValaCCodeNode*) (cmain))));
			vala_ccode_block_add_statement (main_block, ((ValaCCodeNode*) (main_stmt)));
			(main_stmt == NULL ? NULL : (main_stmt = (vala_ccode_node_unref (main_stmt), NULL)));
		} else {
			ValaCCodeExpressionStatement* main_stmt;
			ValaCCodeConstant* _tmp301;
			ValaCCodeReturnStatement* _tmp302;
			ValaCCodeReturnStatement* ret_stmt;
			/* method returns void, always use 0 as exit code*/
			main_stmt = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (main_call)));
			vala_ccode_node_set_line (((ValaCCodeNode*) (main_stmt)), vala_ccode_node_get_line (((ValaCCodeNode*) (cmain))));
			vala_ccode_block_add_statement (main_block, ((ValaCCodeNode*) (main_stmt)));
			_tmp301 = NULL;
			_tmp302 = NULL;
			ret_stmt = (_tmp302 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp301 = vala_ccode_constant_new ("0"))))), (_tmp301 == NULL ? NULL : (_tmp301 = (vala_ccode_node_unref (_tmp301), NULL))), _tmp302);
			vala_ccode_node_set_line (((ValaCCodeNode*) (ret_stmt)), vala_ccode_node_get_line (((ValaCCodeNode*) (cmain))));
			vala_ccode_block_add_statement (main_block, ((ValaCCodeNode*) (ret_stmt)));
			(main_stmt == NULL ? NULL : (main_stmt = (vala_ccode_node_unref (main_stmt), NULL)));
			(ret_stmt == NULL ? NULL : (ret_stmt = (vala_ccode_node_unref (ret_stmt), NULL)));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_member_definition, ((ValaCCodeNode*) (cmain)));
		(cmain == NULL ? NULL : (cmain = (vala_ccode_node_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (vala_ccode_node_unref (main_block), NULL)));
		(type_init_call == NULL ? NULL : (type_init_call = (vala_ccode_node_unref (type_init_call), NULL)));
		(main_call == NULL ? NULL : (main_call = (vala_ccode_node_unref (main_call), NULL)));
	}
	(old_method == NULL ? NULL : (old_method = (vala_code_node_unref (old_method), NULL)));
	(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
	(creturn_type == NULL ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)));
	(cparam_map == NULL ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)));
	(vdeclarator == NULL ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)));
}


static void vala_ccode_method_module_real_generate_cparameters (ValaCCodeModule* base, ValaMethod* m, ValaDataType* creturn_type, gboolean in_gtypeinstance_creation_method, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction) {
	ValaCCodeMethodModule * self;
	gint last_pos;
	gint min_pos;
	self = ((ValaCCodeMethodModule*) (base));
	g_return_if_fail (m != NULL);
	g_return_if_fail (creturn_type != NULL);
	g_return_if_fail (cparam_map != NULL);
	g_return_if_fail (func != NULL);
	if (in_gtypeinstance_creation_method) {
		gint type_param_index;
		/* memory management for generic types*/
		type_param_index = 0;
		{
			GeeList* type_param_collection;
			int type_param_it;
			type_param_collection = vala_class_get_type_parameters (((ValaCCodeBaseModule*) (self))->current_class);
			for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
				ValaTypeParameter* type_param;
				type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
				{
					ValaCCodeFormalParameter* _tmp2;
					char* _tmp1;
					char* _tmp0;
					ValaCCodeFormalParameter* _tmp5;
					char* _tmp4;
					char* _tmp3;
					ValaCCodeFormalParameter* _tmp8;
					char* _tmp7;
					char* _tmp6;
					_tmp2 = NULL;
					_tmp1 = NULL;
					_tmp0 = NULL;
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), 0.1 * type_param_index + 0.01, FALSE)), (_tmp2 = vala_ccode_formal_parameter_new ((_tmp1 = g_strdup_printf ("%s_type", (_tmp0 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1)))), "GType")));
					(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
					_tmp1 = (g_free (_tmp1), NULL);
					_tmp0 = (g_free (_tmp0), NULL);
					_tmp5 = NULL;
					_tmp4 = NULL;
					_tmp3 = NULL;
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), 0.1 * type_param_index + 0.02, FALSE)), (_tmp5 = vala_ccode_formal_parameter_new ((_tmp4 = g_strdup_printf ("%s_dup_func", (_tmp3 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1)))), "GBoxedCopyFunc")));
					(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
					_tmp4 = (g_free (_tmp4), NULL);
					_tmp3 = (g_free (_tmp3), NULL);
					_tmp8 = NULL;
					_tmp7 = NULL;
					_tmp6 = NULL;
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), 0.1 * type_param_index + 0.03, FALSE)), (_tmp8 = vala_ccode_formal_parameter_new ((_tmp7 = g_strdup_printf ("%s_destroy_func", (_tmp6 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1)))), "GDestroyNotify")));
					(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
					_tmp7 = (g_free (_tmp7), NULL);
					_tmp6 = (g_free (_tmp6), NULL);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp11;
						char* _tmp10;
						char* _tmp9;
						ValaCCodeIdentifier* _tmp14;
						char* _tmp13;
						char* _tmp12;
						ValaCCodeIdentifier* _tmp17;
						char* _tmp16;
						char* _tmp15;
						_tmp11 = NULL;
						_tmp10 = NULL;
						_tmp9 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), 0.1 * type_param_index + 0.01, FALSE)), ((ValaCCodeExpression*) ((_tmp11 = vala_ccode_identifier_new ((_tmp10 = g_strdup_printf ("%s_type", (_tmp9 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1)))))))));
						(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
						_tmp10 = (g_free (_tmp10), NULL);
						_tmp9 = (g_free (_tmp9), NULL);
						_tmp14 = NULL;
						_tmp13 = NULL;
						_tmp12 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), 0.1 * type_param_index + 0.02, FALSE)), ((ValaCCodeExpression*) ((_tmp14 = vala_ccode_identifier_new ((_tmp13 = g_strdup_printf ("%s_dup_func", (_tmp12 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1)))))))));
						(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
						_tmp13 = (g_free (_tmp13), NULL);
						_tmp12 = (g_free (_tmp12), NULL);
						_tmp17 = NULL;
						_tmp16 = NULL;
						_tmp15 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), 0.1 * type_param_index + 0.03, FALSE)), ((ValaCCodeExpression*) ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = g_strdup_printf ("%s_destroy_func", (_tmp15 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) (type_param))), -1)))))))));
						(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
						_tmp16 = (g_free (_tmp16), NULL);
						_tmp15 = (g_free (_tmp15), NULL);
					}
					type_param_index++;
					(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (gee_collection_object_unref (type_param_collection), NULL)));
		}
	}
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
					if ((direction & 1) == 0) {
						/* no in paramters*/
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						continue;
					}
				} else {
					if ((direction & 2) == 0) {
						/* no out paramters*/
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						continue;
					}
				}
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaArrayType* _tmp18;
					ValaArrayType* array_type;
					char* length_ctype;
					_tmp18 = NULL;
					array_type = (_tmp18 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18)));
					length_ctype = g_strdup ("int");
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						char* _tmp19;
						_tmp19 = NULL;
						length_ctype = (_tmp19 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp19);
					}
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp20;
							ValaCCodeFormalParameter* _tmp21;
							ValaCCodeFormalParameter* cparam;
							_tmp20 = NULL;
							_tmp21 = NULL;
							cparam = (_tmp21 = vala_ccode_formal_parameter_new ((_tmp20 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (param))), dim)), length_ctype), (_tmp20 = (g_free (_tmp20), NULL)), _tmp21);
							gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), cparam);
							if (carg_map != NULL) {
								ValaCCodeIdentifier* _tmp22;
								_tmp22 = NULL;
								gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), ((ValaCCodeExpression*) ((_tmp22 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))))));
								(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
							}
							(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
						}
					}
					(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
					length_ctype = (g_free (length_ctype), NULL);
				}
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) (param)))));
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp23;
					_tmp23 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (param))))))));
					(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
				}
				if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaDelegateType* _tmp24;
					ValaDelegateType* deleg_type;
					ValaDelegate* _tmp25;
					ValaDelegate* d;
					_tmp24 = NULL;
					deleg_type = (_tmp24 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp24 == NULL ? NULL : vala_code_node_ref (_tmp24)));
					_tmp25 = NULL;
					d = (_tmp25 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp25 == NULL ? NULL : vala_code_node_ref (_tmp25)));
					if (vala_delegate_get_has_target (d)) {
						char* _tmp26;
						ValaCCodeFormalParameter* _tmp27;
						ValaCCodeFormalParameter* cparam;
						_tmp26 = NULL;
						_tmp27 = NULL;
						cparam = (_tmp27 = vala_ccode_formal_parameter_new ((_tmp26 = vala_ccode_base_module_get_delegate_target_cname (((ValaCCodeBaseModule*) (self)), vala_symbol_get_name (((ValaSymbol*) (param))))), "void*"), (_tmp26 = (g_free (_tmp26), NULL)), _tmp27);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
						if (carg_map != NULL) {
							ValaCCodeIdentifier* _tmp28;
							_tmp28 = NULL;
							gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), ((ValaCCodeExpression*) ((_tmp28 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))))));
							(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
						}
						if (vala_data_type_get_value_owned (((ValaDataType*) (deleg_type)))) {
							ValaCCodeFormalParameter* _tmp30;
							char* _tmp29;
							_tmp30 = NULL;
							_tmp29 = NULL;
							cparam = (_tmp30 = vala_ccode_formal_parameter_new ((_tmp29 = vala_ccode_base_module_get_delegate_target_destroy_notify_cname (((ValaCCodeBaseModule*) (self)), vala_symbol_get_name (((ValaSymbol*) (param))))), "GDestroyNotify"), (cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL))), _tmp30);
							_tmp29 = (g_free (_tmp29), NULL);
							gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), cparam);
							if (carg_map != NULL) {
								ValaCCodeIdentifier* _tmp31;
								_tmp31 = NULL;
								gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), ((ValaCCodeExpression*) ((_tmp31 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))))));
								(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
							}
						}
						(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
					}
					(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
					(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
				} else {
					if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						char* _tmp32;
						ValaCCodeFormalParameter* _tmp33;
						ValaCCodeFormalParameter* cparam;
						_tmp32 = NULL;
						_tmp33 = NULL;
						cparam = (_tmp33 = vala_ccode_formal_parameter_new ((_tmp32 = vala_ccode_base_module_get_delegate_target_cname (((ValaCCodeBaseModule*) (self)), vala_symbol_get_name (((ValaSymbol*) (param))))), "void*"), (_tmp32 = (g_free (_tmp32), NULL)), _tmp33);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
						if (carg_map != NULL) {
							ValaCCodeIdentifier* _tmp34;
							_tmp34 = NULL;
							gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), ((ValaCCodeExpression*) ((_tmp34 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))))));
							(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
						}
						(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
					}
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	if ((direction & 2) != 0) {
		GeeList* _tmp44;
		gboolean _tmp45;
		if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY_TYPE (creturn_type)) {
			ValaArrayType* _tmp35;
			ValaArrayType* array_type;
			/* return array length if appropriate*/
			_tmp35 = NULL;
			array_type = (_tmp35 = VALA_ARRAY_TYPE (creturn_type), (_tmp35 == NULL ? NULL : vala_code_node_ref (_tmp35)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp36;
					ValaCCodeFormalParameter* _tmp37;
					ValaCCodeFormalParameter* cparam;
					_tmp36 = NULL;
					_tmp37 = NULL;
					cparam = (_tmp37 = vala_ccode_formal_parameter_new ((_tmp36 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), "result", dim)), "int*"), (_tmp36 = (g_free (_tmp36), NULL)), _tmp37);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp38;
						_tmp38 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), ((ValaCCodeExpression*) ((_tmp38 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))))));
						(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
					}
					(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
				ValaDelegateType* _tmp39;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp40;
				ValaDelegate* d;
				/* return delegate target if appropriate*/
				_tmp39 = NULL;
				deleg_type = (_tmp39 = VALA_DELEGATE_TYPE (creturn_type), (_tmp39 == NULL ? NULL : vala_code_node_ref (_tmp39)));
				_tmp40 = NULL;
				d = (_tmp40 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp40 == NULL ? NULL : vala_code_node_ref (_tmp40)));
				if (vala_delegate_get_has_target (d)) {
					char* _tmp41;
					ValaCCodeFormalParameter* _tmp42;
					ValaCCodeFormalParameter* cparam;
					_tmp41 = NULL;
					_tmp42 = NULL;
					cparam = (_tmp42 = vala_ccode_formal_parameter_new ((_tmp41 = vala_ccode_base_module_get_delegate_target_cname (((ValaCCodeBaseModule*) (self)), "result")), "void*"), (_tmp41 = (g_free (_tmp41), NULL)), _tmp42);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp43;
						_tmp43 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), ((ValaCCodeExpression*) ((_tmp43 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))))));
						(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
					}
					(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
				}
				(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
				(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
			}
		}
		_tmp44 = NULL;
		if ((_tmp45 = gee_collection_get_size (((GeeCollection*) ((_tmp44 = vala_code_node_get_error_types (((ValaCodeNode*) (m))))))) > 0, (_tmp44 == NULL ? NULL : (_tmp44 = (gee_collection_object_unref (_tmp44), NULL))), _tmp45)) {
			ValaCCodeFormalParameter* cparam;
			cparam = vala_ccode_formal_parameter_new ("error", "GError**");
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (-1)), FALSE)), cparam);
			if (carg_map != NULL) {
				ValaCCodeIdentifier* _tmp46;
				_tmp46 = NULL;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (-1)), FALSE)), ((ValaCCodeExpression*) ((_tmp46 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))))));
				(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
			}
			(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
		}
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp47;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (cparam_map);
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_it == NULL ? NULL : (pos_it = (gee_collection_object_unref (pos_it), NULL)));
			(pos_collection == NULL ? NULL : (pos_collection = (gee_collection_object_unref (pos_collection), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp47 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp47 = ((ValaCCodeFormalParameter*) (gee_map_get (cparam_map, GINT_TO_POINTER (min_pos))))));
		(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
		if (vdeclarator != NULL) {
			ValaCCodeFormalParameter* _tmp48;
			_tmp48 = NULL;
			vala_ccode_function_declarator_add_parameter (vdeclarator, (_tmp48 = ((ValaCCodeFormalParameter*) (gee_map_get (cparam_map, GINT_TO_POINTER (min_pos))))));
			(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
		}
		if (vcall != NULL) {
			ValaCCodeExpression* _tmp49;
			_tmp49 = NULL;
			vala_ccode_function_call_add_argument (vcall, (_tmp49 = ((ValaCCodeExpression*) (gee_map_get (carg_map, GINT_TO_POINTER (min_pos))))));
			(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
		}
		last_pos = min_pos;
	}
}


static ValaCCodeStatement* vala_ccode_method_module_create_method_type_check_statement (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_ccode_base_module_create_type_check_statement (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (m)), return_type, t, non_null, var_name);
}


static ValaCCodeStatement* vala_ccode_method_module_create_precondition_statement (ValaCCodeMethodModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeStatement* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (method_node != NULL, NULL);
	g_return_val_if_fail (ret_type != NULL, NULL);
	g_return_val_if_fail (precondition != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (precondition)))));
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp0;
		/* void function */
		_tmp0 = NULL;
		vala_ccode_function_call_set_call (ccheck, ((ValaCCodeExpression*) ((_tmp0 = vala_ccode_identifier_new ("g_return_if_fail")))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeExpression* cdefault;
		_tmp1 = NULL;
		vala_ccode_function_call_set_call (ccheck, ((ValaCCodeExpression*) ((_tmp1 = vala_ccode_identifier_new ("g_return_val_if_fail")))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
		cdefault = vala_ccode_base_module_default_value_for_type (((ValaCCodeBaseModule*) (self)), ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp2;
			ValaCCodeStatement* _tmp3;
			ValaCCodeStatement* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return (_tmp4 = (_tmp3 = ((ValaCCodeStatement*) (vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp2 = vala_ccode_constant_new ("0"))))))), (_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL))), _tmp3), (cdefault == NULL ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL))), _tmp4);
		}
		(cdefault == NULL ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL)));
	}
	_tmp5 = NULL;
	return (_tmp5 = ((ValaCCodeStatement*) (vala_ccode_expression_statement_new (((ValaCCodeExpression*) (ccheck))))), (ccheck == NULL ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL))), _tmp5);
}


static ValaCCodeStatement* vala_ccode_method_module_create_postcondition_statement (ValaCCodeMethodModule* self, ValaExpression* postcondition) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cassert;
	ValaCCodeStatement* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (postcondition != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassert = (_tmp1 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp0 = vala_ccode_identifier_new ("g_assert"))))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (postcondition)))));
	_tmp2 = NULL;
	return (_tmp2 = ((ValaCCodeStatement*) (vala_ccode_expression_statement_new (((ValaCCodeExpression*) (cassert))))), (cassert == NULL ? NULL : (cassert = (vala_ccode_node_unref (cassert), NULL))), _tmp2);
}


static ValaTypeSymbol* vala_ccode_method_module_find_parent_type (ValaCCodeMethodModule* self, ValaSymbol* sym) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	while (sym != NULL) {
		if (VALA_IS_TYPESYMBOL (sym)) {
			ValaTypeSymbol* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = VALA_TYPESYMBOL (sym), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return NULL;
}


static gboolean vala_ccode_method_module_is_possible_entry_point (ValaCCodeMethodModule* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter) {
	GeeList* params;
	GeeIterator* params_it;
	ValaFormalParameter* param;
	ValaArrayType* _tmp7;
	ValaArrayType* array_type;
	gboolean _tmp9;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	if (vala_symbol_get_name (((ValaSymbol*) (m))) == NULL || _vala_strcmp0 (vala_symbol_get_name (((ValaSymbol*) (m))), "main") != 0) {
		/* method must be called "main"*/
		return FALSE;
	}
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		/* method must be static*/
		return FALSE;
	}
	if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->int_type)) {
			(*return_value) = TRUE;
		} else {
			/* return type must be void or int*/
			return FALSE;
		}
	}
	params = vala_method_get_parameters (m);
	if (gee_collection_get_size (((GeeCollection*) (params))) == 0) {
		gboolean _tmp3;
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		return (_tmp3 = TRUE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), _tmp3);
	}
	if (gee_collection_get_size (((GeeCollection*) (params))) > 1) {
		gboolean _tmp4;
		/* method must not have more than one parameter*/
		return (_tmp4 = FALSE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), _tmp4);
	}
	params_it = gee_iterable_iterator (((GeeIterable*) (params)));
	gee_iterator_next (params_it);
	param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
	if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
		gboolean _tmp5;
		/* parameter must not be an out parameter*/
		return (_tmp5 = FALSE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), _tmp5);
	}
	if (!(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) {
		gboolean _tmp6;
		/* parameter must be an array*/
		return (_tmp6 = FALSE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), _tmp6);
	}
	_tmp7 = NULL;
	array_type = (_tmp7 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7)));
	if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) (self))->string_type)) {
		gboolean _tmp8;
		/* parameter must be an array of strings*/
		return (_tmp8 = FALSE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL))), _tmp8);
	}
	(*args_parameter) = TRUE;
	return (_tmp9 = TRUE, (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL))), _tmp9);
}


static void vala_ccode_method_module_add_object_creation (ValaCCodeMethodModule* self, ValaCCodeBlock* b, gboolean has_params) {
	ValaClass* _tmp0;
	ValaClass* cl;
	gboolean chain_up;
	ValaCreationMethod* cm;
	ValaCCodeVariableDeclarator* cdecl_;
	char* _tmp21;
	char* _tmp20;
	ValaCCodeDeclaration* _tmp22;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (((ValaCCodeBaseModule*) (self))->current_type_symbol), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	chain_up = FALSE;
	cm = NULL;
	if (vala_class_get_base_class (cl) != NULL) {
		ValaCreationMethod* _tmp3;
		ValaCreationMethod* _tmp2;
		ValaMethod* _tmp1;
		GeeList* _tmp4;
		gboolean _tmp5;
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		cm = (_tmp3 = (_tmp2 = (_tmp1 = vala_class_get_default_construction_method (vala_class_get_base_class (cl)), (VALA_IS_CREATION_METHOD (_tmp1) ? ((ValaCreationMethod*) (_tmp1)) : NULL)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (cm == NULL ? NULL : (cm = (vala_code_node_unref (cm), NULL))), _tmp3);
		_tmp4 = NULL;
		if ((_tmp5 = cm != NULL && gee_collection_get_size (((GeeCollection*) ((_tmp4 = vala_method_get_parameters (((ValaMethod*) (cm))))))) == 0 && vala_method_get_has_construct_function (((ValaMethod*) (cm))), (_tmp4 == NULL ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL))), _tmp5)) {
			if (!has_params) {
				chain_up = TRUE;
			}
		}
	}
	if (!has_params && !chain_up && VALA_TYPESYMBOL (vala_class_get_base_class (cl)) != ((ValaCCodeBaseModule*) (self))->gobject_type) {
	}
	/* possibly report warning or error about missing base call*/
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	if (chain_up) {
		ValaCCodeIdentifier* _tmp7;
		char* _tmp6;
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeCastExpression* _tmp12;
		char* _tmp11;
		char* _tmp10;
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp8 = NULL;
		ccall = (_tmp8 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_method_get_real_cname (((ValaMethod*) (cm))))))))), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL))), (_tmp6 = (g_free (_tmp6), NULL)), _tmp8);
		_tmp9 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_identifier_new ("object_type")))));
		(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		vala_ccode_variable_declarator_set_initializer (cdecl_, ((ValaCCodeExpression*) ((_tmp12 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) (ccall)), (_tmp11 = g_strdup_printf ("%s*", (_tmp10 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE)))))))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
		_tmp11 = (g_free (_tmp11), NULL);
		_tmp10 = (g_free (_tmp10), NULL);
		(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp13;
		ValaCCodeFunctionCall* _tmp14;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp15;
		_tmp13 = NULL;
		_tmp14 = NULL;
		ccall = (_tmp14 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp13 = vala_ccode_identifier_new ("g_object_newv"))))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), _tmp14);
		_tmp15 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_identifier_new ("object_type")))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
		if (has_params) {
			ValaCCodeConstant* _tmp16;
			ValaCCodeConstant* _tmp17;
			_tmp16 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_constant_new ("__params_it - __params")))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
			_tmp17 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp17 = vala_ccode_constant_new ("__params")))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
		} else {
			ValaCCodeConstant* _tmp18;
			ValaCCodeConstant* _tmp19;
			_tmp18 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp18 = vala_ccode_constant_new ("0")))));
			(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
			_tmp19 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_constant_new ("NULL")))));
			(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
		}
		vala_ccode_variable_declarator_set_initializer (cdecl_, ((ValaCCodeExpression*) (ccall)));
		(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	}
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp22 = NULL;
	cdeclaration = (_tmp22 = vala_ccode_declaration_new ((_tmp21 = g_strdup_printf ("%s *", (_tmp20 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (cl)), FALSE))))), (_tmp21 = (g_free (_tmp21), NULL)), (_tmp20 = (g_free (_tmp20), NULL)), _tmp22);
	vala_ccode_declaration_add_declarator (cdeclaration, ((ValaCCodeDeclarator*) (cdecl_)));
	vala_ccode_block_add_statement (b, ((ValaCCodeNode*) (cdeclaration)));
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	(cm == NULL ? NULL : (cm = (vala_code_node_unref (cm), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL)));
}


static void vala_ccode_method_module_real_visit_creation_method (ValaCCodeModule* base, ValaCreationMethod* m) {
	ValaCCodeMethodModule * self;
	self = ((ValaCCodeMethodModule*) (base));
	g_return_if_fail (m != NULL);
	if (vala_method_get_body (((ValaMethod*) (m))) != NULL && VALA_IS_CLASS (((ValaCCodeBaseModule*) (self))->current_type_symbol) && vala_typesymbol_is_subtype_of (((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->current_class)), ((ValaCCodeBaseModule*) (self))->gobject_type)) {
		gint n_params;
		n_params = 0;
		{
			GeeList* stmt_collection;
			int stmt_it;
			stmt_collection = vala_block_get_statements (vala_method_get_body (((ValaMethod*) (m))));
			for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
				ValaStatement* stmt;
				stmt = ((ValaStatement*) (gee_list_get (GEE_LIST (stmt_collection), stmt_it)));
				{
					ValaExpressionStatement* _tmp1;
					ValaStatement* _tmp0;
					ValaExpressionStatement* expr_stmt;
					_tmp1 = NULL;
					_tmp0 = NULL;
					expr_stmt = (_tmp1 = (_tmp0 = stmt, (VALA_IS_EXPRESSION_STATEMENT (_tmp0) ? ((ValaExpressionStatement*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
					if (expr_stmt != NULL) {
						ValaProperty* prop;
						prop = vala_expression_statement_assigned_property (expr_stmt);
						if (prop != NULL && vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
							n_params++;
						}
						(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					}
					(stmt == NULL ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)));
					(expr_stmt == NULL ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL)));
				}
			}
			(stmt_collection == NULL ? NULL : (stmt_collection = (gee_collection_object_unref (stmt_collection), NULL)));
		}
		vala_creation_method_set_n_construction_params (m, n_params);
	}
	vala_ccode_module_visit_method (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), ((ValaMethod*) (m)));
}


static void vala_ccode_method_module_class_init (ValaCCodeMethodModuleClass * klass) {
	vala_ccode_method_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->method_has_wrapper = vala_ccode_method_module_real_method_has_wrapper;
	VALA_CCODE_MODULE_CLASS (klass)->get_custom_creturn_type = vala_ccode_method_module_real_get_custom_creturn_type;
	VALA_CCODE_MODULE_CLASS (klass)->visit_method = vala_ccode_method_module_real_visit_method;
	VALA_CCODE_MODULE_CLASS (klass)->generate_cparameters = vala_ccode_method_module_real_generate_cparameters;
	VALA_CCODE_MODULE_CLASS (klass)->visit_creation_method = vala_ccode_method_module_real_visit_creation_method;
}


static void vala_ccode_method_module_instance_init (ValaCCodeMethodModule * self) {
}


GType vala_ccode_method_module_get_type (void) {
	static GType vala_ccode_method_module_type_id = 0;
	if (vala_ccode_method_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodModule), 0, (GInstanceInitFunc) vala_ccode_method_module_instance_init, NULL };
		vala_ccode_method_module_type_id = g_type_register_static (VALA_TYPE_CCODE_STRUCT_MODULE, "ValaCCodeMethodModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




