/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodemethodcallmodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamethod.h>
#include <gee/list.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignaltype.h>
#include <vala/valabaseaccess.h>
#include <vala/valasignal.h>
#include <vala/valaobjecttype.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <gee/hashmap.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraytype.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valamember.h>
#include <vala/valacreationmethod.h>
#include <vala/valasymbol.h>
#include <vala/valastruct.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valatypesymbol.h>
#include <vala/valadynamicmethod.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaunaryexpression.h>
#include <vala/valaformalparameter.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valavoidtype.h>
#include <vala/valapointertype.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_METHOD_CALL_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static gpointer vala_ccode_method_call_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodCallModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE, codegen, next);
}


static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeList* params;
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaDataType* _tmp2;
	ValaDataType* itype;
	GeeList* _tmp3;
	ValaCCodeExpression* _tmp19;
	ValaCCodeExpression* ccall_expr;
	GeeHashMap* carg_map;
	ValaCCodeExpression* instance;
	gboolean _tmp23;
	gboolean _tmp24;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	gboolean _tmp142;
	gboolean _tmp153;
	gboolean _tmp173;
	gint last_pos;
	gint min_pos;
	gboolean _tmp188;
	gboolean _tmp189;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))));
	m = NULL;
	params = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_method_call_get_call (expr), VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = NULL;
	itype = (_tmp2 = vala_expression_get_value_type (vala_method_call_get_call (expr)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = NULL;
	params = (_tmp3 = vala_data_type_get_parameters (itype), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp3);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp5;
		ValaMethod* _tmp4;
		g_assert (ma != NULL);
		_tmp5 = NULL;
		_tmp4 = NULL;
		m = (_tmp5 = (_tmp4 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (itype))), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp5);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaSignalType* _tmp6;
			ValaSignalType* sig_type;
			gboolean _tmp7;
			gboolean _tmp8;
			_tmp6 = NULL;
			sig_type = (_tmp6 = VALA_SIGNAL_TYPE (itype), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
			_tmp7 = FALSE;
			_tmp8 = FALSE;
			if (ma != NULL) {
				_tmp8 = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
			} else {
				_tmp8 = FALSE;
			}
			if (_tmp8) {
				_tmp7 = vala_signal_get_is_virtual (vala_signal_type_get_signal_symbol (sig_type));
			} else {
				_tmp7 = FALSE;
			}
			if (_tmp7) {
				ValaMethod* _tmp9;
				_tmp9 = NULL;
				m = (_tmp9 = vala_signal_get_method_handler (vala_signal_type_get_signal_symbol (sig_type)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp9);
			} else {
				ValaCCodeFunctionCall* _tmp11;
				ValaCCodeFunctionCall* _tmp10;
				_tmp11 = NULL;
				_tmp10 = NULL;
				ccall = (_tmp11 = (_tmp10 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))), (_tmp10 == NULL) ? NULL : vala_ccode_node_ref (_tmp10)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp11);
			}
			(sig_type == NULL) ? NULL : (sig_type = (vala_code_node_unref (sig_type), NULL));
		} else {
			if (VALA_IS_OBJECT_TYPE (itype)) {
				ValaClass* _tmp12;
				ValaClass* cl;
				ValaMethod* _tmp14;
				ValaMethod* _tmp13;
				ValaCCodeFunctionCall* _tmp17;
				ValaCCodeIdentifier* _tmp16;
				char* _tmp15;
				ValaCCodeIdentifier* _tmp18;
				/* constructor*/
				_tmp12 = NULL;
				cl = (_tmp12 = VALA_CLASS (vala_object_type_get_type_symbol ((VALA_OBJECT_TYPE (itype)))), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
				_tmp14 = NULL;
				_tmp13 = NULL;
				m = (_tmp14 = (_tmp13 = vala_class_get_default_construction_method (cl), (_tmp13 == NULL) ? NULL : vala_code_node_ref (_tmp13)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp14);
				_tmp17 = NULL;
				_tmp16 = NULL;
				_tmp15 = NULL;
				ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new (_tmp15 = vala_method_get_real_cname (m)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp17);
				(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
				_tmp15 = (g_free (_tmp15), NULL);
				_tmp18 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("object_type")));
				(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			}
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp19 = NULL;
	ccall_expr = (_tmp19 = (ValaCCodeExpression*) ccall, (_tmp19 == NULL) ? NULL : vala_ccode_node_ref (_tmp19));
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp20;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp22;
		char* _tmp21;
		_tmp20 = NULL;
		array_type = (_tmp20 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp20 == NULL) ? NULL : vala_code_node_ref (_tmp20));
		_tmp22 = NULL;
		_tmp21 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) 0, FALSE)), (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new (_tmp21 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		_tmp21 = (g_free (_tmp21), NULL);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	_tmp23 = FALSE;
	_tmp24 = FALSE;
	if (m != NULL) {
		_tmp24 = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp24 = FALSE;
	}
	if (_tmp24) {
		_tmp23 = !(VALA_IS_CREATION_METHOD (m));
	} else {
		_tmp23 = FALSE;
	}
	if (_tmp23) {
		ValaCCodeExpression* _tmp26;
		ValaCCodeExpression* _tmp25;
		ValaStruct* _tmp28;
		ValaSymbol* _tmp27;
		ValaStruct* st;
		gboolean _tmp29;
		_tmp26 = NULL;
		_tmp25 = NULL;
		instance = (_tmp26 = (_tmp25 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp25 == NULL) ? NULL : vala_ccode_node_ref (_tmp25)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp26);
		_tmp28 = NULL;
		_tmp27 = NULL;
		st = (_tmp28 = (_tmp27 = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_STRUCT (_tmp27) ? ((ValaStruct*) _tmp27) : NULL), (_tmp28 == NULL) ? NULL : vala_code_node_ref (_tmp28));
		_tmp29 = FALSE;
		if (st != NULL) {
			_tmp29 = !vala_struct_is_simple_type (st);
		} else {
			_tmp29 = FALSE;
		}
		if (_tmp29) {
			ValaCCodeUnaryExpression* _tmp31;
			ValaCCodeExpression* _tmp30;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp32;
			/* we need to pass struct instance by reference*/
			_tmp31 = NULL;
			_tmp30 = NULL;
			unary = (_tmp31 = (_tmp30 = instance, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp30) ? ((ValaCCodeUnaryExpression*) _tmp30) : NULL), (_tmp31 == NULL) ? NULL : vala_ccode_node_ref (_tmp31));
			_tmp32 = FALSE;
			if (unary != NULL) {
				_tmp32 = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp32 = FALSE;
			}
			if (_tmp32) {
				ValaCCodeExpression* _tmp34;
				ValaCCodeExpression* _tmp33;
				/* *expr => expr*/
				_tmp34 = NULL;
				_tmp33 = NULL;
				instance = (_tmp34 = (_tmp33 = vala_ccode_unary_expression_get_inner (unary), (_tmp33 == NULL) ? NULL : vala_ccode_node_ref (_tmp33)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp34);
			} else {
				gboolean _tmp35;
				_tmp35 = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (instance)) {
					_tmp35 = TRUE;
				} else {
					_tmp35 = VALA_IS_CCODE_MEMBER_ACCESS (instance);
				}
				if (_tmp35) {
					ValaCCodeExpression* _tmp36;
					_tmp36 = NULL;
					instance = (_tmp36 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp36);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp38;
					ValaCCodeIdentifier* _tmp37;
					ValaCCodeUnaryExpression* _tmp40;
					ValaCCodeIdentifier* _tmp39;
					ValaCCodeExpression* _tmp42;
					ValaCCodeExpression* _tmp41;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp38 = NULL;
					_tmp37 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp38 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
					(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
					_tmp40 = NULL;
					_tmp39 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp40 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))))));
					(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
					(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
					_tmp42 = NULL;
					_tmp41 = NULL;
					instance = (_tmp42 = (_tmp41 = (ValaCCodeExpression*) ccomma, (_tmp41 == NULL) ? NULL : vala_ccode_node_ref (_tmp41)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp42);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		}
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	} else {
		gboolean _tmp43;
		_tmp43 = FALSE;
		if (m != NULL) {
			_tmp43 = vala_method_get_binding (m) == MEMBER_BINDING_CLASS;
		} else {
			_tmp43 = FALSE;
		}
		if (_tmp43) {
			ValaClass* _tmp44;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp47;
			char* _tmp46;
			char* _tmp45;
			ValaCCodeFunctionCall* _tmp48;
			ValaCCodeFunctionCall* cast;
			ValaCCodeExpression* klass;
			ValaMemberAccess* _tmp50;
			ValaExpression* _tmp49;
			ValaMemberAccess* ma;
			_tmp44 = NULL;
			cl = (_tmp44 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp44 == NULL) ? NULL : vala_code_node_ref (_tmp44));
			_tmp47 = NULL;
			_tmp46 = NULL;
			_tmp45 = NULL;
			_tmp48 = NULL;
			cast = (_tmp48 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new (_tmp46 = g_strconcat (_tmp45 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)), _tmp46 = (g_free (_tmp46), NULL), _tmp45 = (g_free (_tmp45), NULL), _tmp48);
			klass = NULL;
			_tmp50 = NULL;
			_tmp49 = NULL;
			ma = (_tmp50 = (_tmp49 = vala_method_call_get_call (expr), VALA_IS_MEMBER_ACCESS (_tmp49) ? ((ValaMemberAccess*) _tmp49) : NULL), (_tmp50 == NULL) ? NULL : vala_code_node_ref (_tmp50));
			if (vala_member_access_get_inner (ma) == NULL) {
				if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
					ValaCCodeExpression* _tmp51;
					/* Accessing the method from a static or class constructor*/
					_tmp51 = NULL;
					klass = (_tmp51 = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp51);
				} else {
					ValaCCodeIdentifier* _tmp52;
					ValaCCodeFunctionCall* _tmp53;
					ValaCCodeFunctionCall* k;
					ValaCCodeIdentifier* _tmp54;
					ValaCCodeExpression* _tmp56;
					ValaCCodeExpression* _tmp55;
					/* Accessing the method from within an instance method*/
					_tmp52 = NULL;
					_tmp53 = NULL;
					k = (_tmp53 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)), _tmp53);
					_tmp54 = NULL;
					vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new ("self")));
					(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
					_tmp56 = NULL;
					_tmp55 = NULL;
					klass = (_tmp56 = (_tmp55 = (ValaCCodeExpression*) k, (_tmp55 == NULL) ? NULL : vala_ccode_node_ref (_tmp55)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp56);
					(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
				}
			} else {
				ValaCCodeIdentifier* _tmp57;
				ValaCCodeFunctionCall* _tmp58;
				ValaCCodeFunctionCall* k;
				ValaCCodeExpression* _tmp60;
				ValaCCodeExpression* _tmp59;
				/* Accessing the method of an instance*/
				_tmp57 = NULL;
				_tmp58 = NULL;
				k = (_tmp58 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)), _tmp58);
				vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))));
				_tmp60 = NULL;
				_tmp59 = NULL;
				klass = (_tmp60 = (_tmp59 = (ValaCCodeExpression*) k, (_tmp59 == NULL) ? NULL : vala_ccode_node_ref (_tmp59)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp60);
				(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
			}
			vala_ccode_function_call_add_argument (cast, klass);
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
			(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp61;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp62;
		ValaCCodeFunctionCall* _tmp63;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp65;
		char* _tmp64;
		_tmp61 = NULL;
		array_type = (_tmp61 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp61 == NULL) ? NULL : vala_code_node_ref (_tmp61));
		_tmp62 = NULL;
		_tmp63 = NULL;
		csizeof = (_tmp63 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp62 = vala_ccode_identifier_new ("sizeof"))), (_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)), _tmp63);
		_tmp65 = NULL;
		_tmp64 = NULL;
		vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp65 = vala_ccode_identifier_new (_tmp64 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
		_tmp64 = (g_free (_tmp64), NULL);
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) csizeof);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* _tmp66;
				GeeIterator* _tmp67;
				GeeIterator* arg_it;
				_tmp66 = NULL;
				_tmp67 = NULL;
				arg_it = (_tmp67 = gee_iterable_iterator ((GeeIterable*) (_tmp66 = vala_method_call_get_argument_list (expr))), (_tmp66 == NULL) ? NULL : (_tmp66 = (gee_collection_object_unref (_tmp66), NULL)), _tmp67);
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					ValaUnaryExpression* _tmp69;
					ValaExpression* _tmp68;
					ValaUnaryExpression* unary;
					gboolean _tmp70;
					arg = (ValaExpression*) gee_iterator_get (arg_it);
					_tmp69 = NULL;
					_tmp68 = NULL;
					unary = (_tmp69 = (_tmp68 = arg, VALA_IS_UNARY_EXPRESSION (_tmp68) ? ((ValaUnaryExpression*) _tmp68) : NULL), (_tmp69 == NULL) ? NULL : vala_code_node_ref (_tmp69));
					_tmp70 = FALSE;
					if (unary != NULL) {
						_tmp70 = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp70 = FALSE;
					}
					if (_tmp70) {
						char* _tmp71;
						ValaFormalParameter* _tmp72;
						ValaFormalParameter* param;
						/* out argument*/
						_tmp71 = NULL;
						_tmp72 = NULL;
						param = (_tmp72 = vala_formal_parameter_new (_tmp71 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp71 = (g_free (_tmp71), NULL), _tmp72);
						vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
						vala_method_add_parameter (m, param);
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					} else {
						gboolean _tmp73;
						_tmp73 = FALSE;
						if (unary != NULL) {
							_tmp73 = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp73 = FALSE;
						}
						if (_tmp73) {
							char* _tmp74;
							ValaFormalParameter* _tmp75;
							ValaFormalParameter* param;
							/* ref argument*/
							_tmp74 = NULL;
							_tmp75 = NULL;
							param = (_tmp75 = vala_formal_parameter_new (_tmp74 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp74 = (g_free (_tmp74), NULL), _tmp75);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
							vala_method_add_parameter (m, param);
							(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						} else {
							ValaFormalParameter* _tmp77;
							char* _tmp76;
							/* in argument*/
							_tmp77 = NULL;
							_tmp76 = NULL;
							vala_method_add_parameter (m, _tmp77 = vala_formal_parameter_new (_tmp76 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (arg), NULL));
							(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_code_node_unref (_tmp77), NULL));
							_tmp76 = (g_free (_tmp76), NULL);
						}
					}
					param_nr++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
				}
				(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
			}
			{
				GeeList* _tmp78;
				GeeIterator* _tmp79;
				GeeIterator* param_it;
				_tmp78 = NULL;
				_tmp79 = NULL;
				param_it = (_tmp79 = gee_iterable_iterator ((GeeIterable*) (_tmp78 = vala_method_get_parameters (m))), (_tmp78 == NULL) ? NULL : (_tmp78 = (gee_collection_object_unref (_tmp78), NULL)), _tmp79);
				while (gee_iterator_next (param_it)) {
					ValaFormalParameter* param;
					param = (ValaFormalParameter*) gee_iterator_get (param_it);
					vala_code_node_accept ((ValaCodeNode*) param, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
			}
			vala_ccode_module_generate_dynamic_method_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_METHOD (m));
		} else {
			if (VALA_IS_CREATION_METHOD (m)) {
				ValaCCodeExpression* _tmp84;
				ValaCCodeCastExpression* _tmp83;
				char* _tmp82;
				char* _tmp81;
				ValaCCodeIdentifier* _tmp80;
				_tmp84 = NULL;
				_tmp83 = NULL;
				_tmp82 = NULL;
				_tmp81 = NULL;
				_tmp80 = NULL;
				ccall_expr = (_tmp84 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp80 = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp83 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp82 = g_strconcat (_tmp81 = vala_typesymbol_get_cname ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, FALSE), "*", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp84);
				(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
				_tmp82 = (g_free (_tmp82), NULL);
				_tmp81 = (g_free (_tmp81), NULL);
				(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator ((GeeIterable*) params);
	{
		GeeList* _tmp85;
		GeeIterator* _tmp86;
		GeeIterator* arg_it;
		_tmp85 = NULL;
		_tmp86 = NULL;
		arg_it = (_tmp86 = gee_iterable_iterator ((GeeIterable*) (_tmp85 = vala_method_call_get_argument_list (expr))), (_tmp85 == NULL) ? NULL : (_tmp85 = (gee_collection_object_unref (_tmp85), NULL)), _tmp86);
		while (gee_iterator_next (arg_it)) {
			ValaExpression* arg;
			ValaCCodeExpression* _tmp87;
			ValaCCodeExpression* cexpr;
			arg = (ValaExpression*) gee_iterator_get (arg_it);
			_tmp87 = NULL;
			cexpr = (_tmp87 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)), (_tmp87 == NULL) ? NULL : vala_ccode_node_ref (_tmp87));
			if (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				gboolean _tmp88;
				param = (ValaFormalParameter*) gee_iterator_get (params_it);
				_tmp88 = FALSE;
				if (vala_formal_parameter_get_params_array (param)) {
					_tmp88 = TRUE;
				} else {
					_tmp88 = vala_formal_parameter_get_ellipsis (param);
				}
				ellipsis = _tmp88;
				if (!ellipsis) {
					gboolean multiple_cargs;
					gboolean _tmp89;
					ValaCCodeExpression* _tmp109;
					gboolean _tmp110;
					gboolean _tmp116;
					gboolean _tmp117;
					gboolean _tmp118;
					/* if the vala argument expands to multiple C arguments,
					 we have to make sure that the C arguments don't depend
					 on each other as there is no guaranteed argument
					 evaluation order
					 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
					multiple_cargs = FALSE;
					_tmp89 = FALSE;
					if (!vala_formal_parameter_get_no_array_length (param)) {
						_tmp89 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp89 = FALSE;
					}
					if (_tmp89) {
						ValaArrayType* _tmp90;
						ValaArrayType* array_type;
						_tmp90 = NULL;
						array_type = (_tmp90 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp90 == NULL) ? NULL : vala_code_node_ref (_tmp90));
						{
							gint dim;
							dim = 1;
							for (; dim <= vala_array_type_get_rank (array_type); dim++) {
								ValaCCodeExpression* _tmp91;
								_tmp91 = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp91 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), arg, dim));
								(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
							}
						}
						multiple_cargs = TRUE;
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					} else {
						if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaDelegateType* _tmp92;
							ValaDelegateType* deleg_type;
							ValaDelegate* _tmp93;
							ValaDelegate* d;
							_tmp92 = NULL;
							deleg_type = (_tmp92 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp92 == NULL) ? NULL : vala_code_node_ref (_tmp92));
							_tmp93 = NULL;
							d = (_tmp93 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp93 == NULL) ? NULL : vala_code_node_ref (_tmp93));
							if (vala_delegate_get_has_target (d)) {
								ValaCCodeExpression* delegate_target;
								delegate_target = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg);
								if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
									ValaCCodeExpression* delegate_target_destroy_notify;
									ValaMethod* _tmp95;
									ValaSymbol* _tmp94;
									ValaMethod* delegate_method;
									ValaMemberAccess* _tmp97;
									ValaExpression* _tmp96;
									ValaMemberAccess* ma;
									gboolean _tmp98;
									gboolean _tmp99;
									gboolean _tmp100;
									gboolean _tmp101;
									delegate_target_destroy_notify = NULL;
									_tmp95 = NULL;
									_tmp94 = NULL;
									delegate_method = (_tmp95 = (_tmp94 = vala_expression_get_symbol_reference (arg), VALA_IS_METHOD (_tmp94) ? ((ValaMethod*) _tmp94) : NULL), (_tmp95 == NULL) ? NULL : vala_code_node_ref (_tmp95));
									_tmp97 = NULL;
									_tmp96 = NULL;
									ma = (_tmp97 = (_tmp96 = arg, VALA_IS_MEMBER_ACCESS (_tmp96) ? ((ValaMemberAccess*) _tmp96) : NULL), (_tmp97 == NULL) ? NULL : vala_code_node_ref (_tmp97));
									_tmp98 = FALSE;
									_tmp99 = FALSE;
									_tmp100 = FALSE;
									_tmp101 = FALSE;
									if (delegate_method != NULL) {
										_tmp101 = vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE;
									} else {
										_tmp101 = FALSE;
									}
									if (_tmp101) {
										_tmp100 = vala_member_access_get_inner (ma) != NULL;
									} else {
										_tmp100 = FALSE;
									}
									if (_tmp100) {
										_tmp99 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))) != NULL;
									} else {
										_tmp99 = FALSE;
									}
									if (_tmp99) {
										_tmp98 = vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))));
									} else {
										_tmp98 = FALSE;
									}
									if (_tmp98) {
										ValaCCodeExpression* _tmp102;
										ValaCCodeFunctionCall* _tmp103;
										ValaCCodeFunctionCall* ref_call;
										ValaCCodeExpression* _tmp105;
										ValaCCodeExpression* _tmp104;
										ValaCCodeExpression* _tmp106;
										_tmp102 = NULL;
										_tmp103 = NULL;
										ref_call = (_tmp103 = vala_ccode_function_call_new (_tmp102 = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (ma)), vala_code_node_get_source_reference ((ValaCodeNode*) arg))), (_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)), _tmp103);
										vala_ccode_function_call_add_argument (ref_call, delegate_target);
										_tmp105 = NULL;
										_tmp104 = NULL;
										delegate_target = (_tmp105 = (_tmp104 = (ValaCCodeExpression*) ref_call, (_tmp104 == NULL) ? NULL : vala_ccode_node_ref (_tmp104)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp105);
										_tmp106 = NULL;
										delegate_target_destroy_notify = (_tmp106 = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (ma))), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp106);
										(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
									} else {
										ValaCCodeExpression* _tmp107;
										_tmp107 = NULL;
										delegate_target_destroy_notify = (_tmp107 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp107);
									}
									gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
									(delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL));
									(delegate_method == NULL) ? NULL : (delegate_method = (vala_code_node_unref (delegate_method), NULL));
									(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
								}
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
								multiple_cargs = TRUE;
								(delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL));
							}
							(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
							(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
						} else {
							if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaCCodeExpression* _tmp108;
								_tmp108 = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp108 = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg));
								(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
								multiple_cargs = TRUE;
							}
						}
					}
					_tmp109 = NULL;
					cexpr = (_tmp109 = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, param, arg, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp109);
					_tmp110 = FALSE;
					if (multiple_cargs) {
						_tmp110 = VALA_IS_METHOD_CALL (arg);
					} else {
						_tmp110 = FALSE;
					}
					if (_tmp110) {
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_decl;
						ValaCCodeAssignment* _tmp112;
						ValaCCodeIdentifier* _tmp111;
						ValaCCodeExpression* _tmp113;
						ValaCCodeExpression* _tmp115;
						ValaCCodeExpression* _tmp114;
						/* if vala argument is invocation expression
						 the auxiliary C argument(s) will depend on the main C argument
						 (tmp = arg1, call (tmp, arg2, arg3,...))*/
						ccomma = vala_ccode_comma_expression_new ();
						temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg), TRUE, NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
						_tmp112 = NULL;
						_tmp111 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp112 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp111 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
						(_tmp111 == NULL) ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL));
						_tmp113 = NULL;
						cexpr = (_tmp113 = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp113);
						vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						_tmp115 = NULL;
						_tmp114 = NULL;
						ccall_expr = (_tmp115 = (_tmp114 = (ValaCCodeExpression*) ccomma, (_tmp114 == NULL) ? NULL : vala_ccode_node_ref (_tmp114)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp115);
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
					}
					_tmp116 = FALSE;
					_tmp117 = FALSE;
					_tmp118 = FALSE;
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						_tmp118 = vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg));
					} else {
						_tmp118 = FALSE;
					}
					if (_tmp118) {
						gboolean _tmp119;
						_tmp119 = FALSE;
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
							_tmp119 = TRUE;
						} else {
							_tmp119 = !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param));
						}
						_tmp117 = (_tmp119);
					} else {
						_tmp117 = FALSE;
					}
					if (_tmp117) {
						_tmp116 = !(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)));
					} else {
						_tmp116 = FALSE;
					}
					/* unref old value for non-null non-weak ref/out arguments
					 disabled for arrays for now as that requires special handling
					 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
					if (_tmp116) {
						ValaUnaryExpression* _tmp120;
						ValaUnaryExpression* unary;
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* _tmp122;
						ValaCCodeIdentifier* _tmp121;
						ValaLocalVariable* ret_temp_var;
						ValaCCodeCommaExpression* cassign_comma;
						ValaLocalVariable* assign_temp_var;
						ValaCCodeAssignment* _tmp133;
						ValaCCodeExpression* _tmp132;
						ValaCCodeIdentifier* _tmp131;
						ValaCCodeIdentifier* _tmp130;
						ValaCCodeExpression* _tmp134;
						ValaCCodeIdentifier* _tmp135;
						ValaCCodeAssignment* _tmp136;
						ValaCCodeExpression* _tmp139;
						ValaCCodeExpression* _tmp138;
						_tmp120 = NULL;
						unary = (_tmp120 = VALA_UNARY_EXPRESSION (arg), (_tmp120 == NULL) ? NULL : vala_code_node_ref (_tmp120));
						ccomma = vala_ccode_comma_expression_new ();
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp122 = NULL;
						_tmp121 = NULL;
						cexpr = (_tmp122 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp121 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var)))), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp122);
						(_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL));
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
							ValaCCodeCommaExpression* crefcomma;
							ValaCCodeAssignment* _tmp124;
							ValaCCodeIdentifier* _tmp123;
							ValaCCodeExpression* _tmp126;
							ValaCCodeExpression* _tmp125;
							crefcomma = vala_ccode_comma_expression_new ();
							_tmp124 = NULL;
							_tmp123 = NULL;
							vala_ccode_comma_expression_append_expression (crefcomma, (ValaCCodeExpression*) (_tmp124 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp123 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp124 == NULL) ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL));
							(_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL));
							vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
							_tmp126 = NULL;
							_tmp125 = NULL;
							cexpr = (_tmp126 = (_tmp125 = (ValaCCodeExpression*) crefcomma, (_tmp125 == NULL) ? NULL : vala_ccode_node_ref (_tmp125)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp126);
							(crefcomma == NULL) ? NULL : (crefcomma = (vala_ccode_node_unref (crefcomma), NULL));
						}
						/* call function*/
						ret_temp_var = NULL;
						if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						} else {
							ValaLocalVariable* _tmp127;
							ValaCCodeAssignment* _tmp129;
							ValaCCodeIdentifier* _tmp128;
							_tmp127 = NULL;
							ret_temp_var = (_tmp127 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_method_get_return_type (m), TRUE, NULL), (ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL)), _tmp127);
							gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, ret_temp_var);
							_tmp129 = NULL;
							_tmp128 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp129 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp128 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) ret_temp_var))), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp129 == NULL) ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL));
							(_tmp128 == NULL) ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL));
						}
						cassign_comma = vala_ccode_comma_expression_new ();
						assign_temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, assign_temp_var);
						_tmp133 = NULL;
						_tmp132 = NULL;
						_tmp131 = NULL;
						_tmp130 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, (ValaCCodeExpression*) (_tmp133 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp130 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) assign_temp_var))), _tmp132 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp131 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp133 == NULL) ? NULL : (_tmp133 = (vala_ccode_node_unref (_tmp133), NULL));
						(_tmp132 == NULL) ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL));
						(_tmp131 == NULL) ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL));
						(_tmp130 == NULL) ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL));
						/* unref old value*/
						_tmp134 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp134 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), vala_expression_get_value_type (arg), arg));
						(_tmp134 == NULL) ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL));
						_tmp135 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, (ValaCCodeExpression*) (_tmp135 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) assign_temp_var))));
						(_tmp135 == NULL) ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL));
						/* assign new value*/
						_tmp136 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp136 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), (ValaCCodeExpression*) cassign_comma, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp136 == NULL) ? NULL : (_tmp136 = (vala_ccode_node_unref (_tmp136), NULL));
						/* return value*/
						if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
							ValaCCodeIdentifier* _tmp137;
							_tmp137 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp137 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) ret_temp_var))));
							(_tmp137 == NULL) ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL));
						}
						_tmp139 = NULL;
						_tmp138 = NULL;
						ccall_expr = (_tmp139 = (_tmp138 = (ValaCCodeExpression*) ccomma, (_tmp138 == NULL) ? NULL : vala_ccode_node_ref (_tmp138)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp139);
						(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL));
						(cassign_comma == NULL) ? NULL : (cassign_comma = (vala_ccode_node_unref (cassign_comma), NULL));
						(assign_temp_var == NULL) ? NULL : (assign_temp_var = (vala_code_node_unref (assign_temp_var), NULL));
					}
					if (vala_formal_parameter_get_ctype (param) != NULL) {
						ValaCCodeExpression* _tmp140;
						_tmp140 = NULL;
						cexpr = (_tmp140 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, vala_formal_parameter_get_ctype (param)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp140);
					}
				}
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			} else {
				/* default argument position*/
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) i, ellipsis);
			}
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (arg_pos), cexpr);
			i++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
		}
		(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
	}
	if (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		gboolean _tmp141;
		param = (ValaFormalParameter*) gee_iterator_get (params_it);
		_tmp141 = FALSE;
		if (vala_formal_parameter_get_params_array (param)) {
			_tmp141 = TRUE;
		} else {
			_tmp141 = vala_formal_parameter_get_ellipsis (param);
		}
		/* if there are more parameters than arguments,
		 * the additional parameter is an ellipsis parameter
		 * otherwise there is a bug in the semantic analyzer
		 */
		g_assert (_tmp141);
		ellipsis = TRUE;
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
	}
	_tmp142 = FALSE;
	if (m != NULL) {
		_tmp142 = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp142 = FALSE;
	}
	/* add length argument for methods returning arrays */
	if (_tmp142) {
		ValaArrayType* _tmp143;
		ValaArrayType* array_type;
		_tmp143 = NULL;
		array_type = (_tmp143 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp143 == NULL) ? NULL : vala_code_node_ref (_tmp143));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* _tmp144;
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp144 = NULL;
					gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp144 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) temp_ref)));
					(_tmp144 == NULL) ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL));
					vala_method_call_append_array_size (expr, (ValaCCodeExpression*) temp_ref);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
				} else {
					ValaCCodeConstant* _tmp145;
					_tmp145 = NULL;
					vala_method_call_append_array_size (expr, (ValaCCodeExpression*) (_tmp145 = vala_ccode_constant_new ("-1")));
					(_tmp145 == NULL) ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL));
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		gboolean _tmp146;
		_tmp146 = FALSE;
		if (m != NULL) {
			_tmp146 = VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m));
		} else {
			_tmp146 = FALSE;
		}
		if (_tmp146) {
			ValaDelegateType* _tmp147;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp148;
			ValaDelegate* d;
			_tmp147 = NULL;
			deleg_type = (_tmp147 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp147 == NULL) ? NULL : vala_code_node_ref (_tmp147));
			_tmp148 = NULL;
			d = (_tmp148 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp148 == NULL) ? NULL : vala_code_node_ref (_tmp148));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp150;
				ValaVoidType* _tmp149;
				ValaLocalVariable* _tmp151;
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp152;
				_tmp150 = NULL;
				_tmp149 = NULL;
				_tmp151 = NULL;
				temp_var = (_tmp151 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp150 = vala_pointer_type_new ((ValaDataType*) (_tmp149 = vala_void_type_new ()), NULL)), TRUE, NULL), (_tmp150 == NULL) ? NULL : (_tmp150 = (vala_code_node_unref (_tmp150), NULL)), (_tmp149 == NULL) ? NULL : (_tmp149 = (vala_code_node_unref (_tmp149), NULL)), _tmp151);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp152 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp152 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) temp_ref)));
				(_tmp152 == NULL) ? NULL : (_tmp152 = (vala_ccode_node_unref (_tmp152), NULL));
				vala_method_call_set_delegate_target (expr, (ValaCCodeExpression*) temp_ref);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp153 = FALSE;
	if (m != NULL) {
		_tmp153 = vala_method_get_coroutine (m);
	} else {
		_tmp153 = FALSE;
	}
	if (_tmp153) {
		gboolean _tmp154;
		gboolean _tmp155;
		_tmp154 = FALSE;
		_tmp155 = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp155 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp155 = FALSE;
		}
		if ((_tmp155)) {
			_tmp154 = TRUE;
		} else {
			gboolean _tmp156;
			_tmp156 = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp156 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp156 = FALSE;
			}
			_tmp154 = (_tmp156);
		}
		if (_tmp154) {
			ValaCCodeIdentifier* _tmp157;
			ValaCCodeIdentifier* cid;
			char* _tmp158;
			gboolean _tmp159;
			/* asynchronous call*/
			_tmp157 = NULL;
			cid = (_tmp157 = VALA_CCODE_IDENTIFIER (vala_ccode_function_call_get_call (ccall)), (_tmp157 == NULL) ? NULL : vala_ccode_node_ref (_tmp157));
			_tmp158 = NULL;
			vala_ccode_identifier_set_name (cid, _tmp158 = g_strconcat (vala_ccode_identifier_get_name (cid), ("_async"), NULL));
			_tmp158 = (g_free (_tmp158), NULL);
			_tmp159 = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp159 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp159 = FALSE;
			}
			if (_tmp159) {
				ValaCCodeConstant* _tmp160;
				ValaCCodeConstant* _tmp161;
				_tmp160 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp160 = vala_ccode_constant_new ("NULL")));
				(_tmp160 == NULL) ? NULL : (_tmp160 = (vala_ccode_node_unref (_tmp160), NULL));
				_tmp161 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp161 = vala_ccode_constant_new ("NULL")));
				(_tmp161 == NULL) ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL));
			} else {
				ValaCCodeIdentifier* _tmp164;
				char* _tmp163;
				char* _tmp162;
				ValaCCodeIdentifier* _tmp165;
				_tmp164 = NULL;
				_tmp163 = NULL;
				_tmp162 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp164 = vala_ccode_identifier_new (_tmp163 = g_strconcat (_tmp162 = vala_method_get_cname (((ValaCCodeBaseModule*) self)->current_method), "_ready", NULL))));
				(_tmp164 == NULL) ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL));
				_tmp163 = (g_free (_tmp163), NULL);
				_tmp162 = (g_free (_tmp162), NULL);
				_tmp165 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp165 = vala_ccode_identifier_new ("data")));
				(_tmp165 == NULL) ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL));
			}
			(cid == NULL) ? NULL : (cid = (vala_ccode_node_unref (cid), NULL));
		}
	}
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr)) {
		ValaCCodeUnaryExpression* _tmp167;
		ValaCCodeIdentifier* _tmp166;
		/* method can fail*/
		((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
		/* add &inner_error before the ellipsis arguments*/
		_tmp167 = NULL;
		_tmp166 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp167 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp166 = vala_ccode_identifier_new ("inner_error")))));
		(_tmp167 == NULL) ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL));
		(_tmp166 == NULL) ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL));
	}
	if (ellipsis) {
		gboolean _tmp168;
		_tmp168 = FALSE;
		if (!vala_method_get_printf_format (m)) {
			_tmp168 = _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0;
		} else {
			_tmp168 = FALSE;
		}
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if (_tmp168) {
			ValaCCodeConstant* _tmp169;
			_tmp169 = NULL;
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp169 = vala_ccode_constant_new (vala_method_get_sentinel (m))));
			(_tmp169 == NULL) ? NULL : (_tmp169 = (vala_ccode_node_unref (_tmp169), NULL));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp170;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp171;
			ValaDelegate* d;
			_tmp170 = NULL;
			deleg_type = (_tmp170 = VALA_DELEGATE_TYPE (itype), (_tmp170 == NULL) ? NULL : vala_code_node_ref (_tmp170));
			_tmp171 = NULL;
			d = (_tmp171 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp171 == NULL) ? NULL : vala_code_node_ref (_tmp171));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp172;
				_tmp172 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp172 = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp172 == NULL) ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp173 = FALSE;
	if (VALA_IS_SIGNAL_TYPE (itype)) {
		ValaDataType* _tmp174;
		_tmp174 = NULL;
		_tmp173 = !(VALA_IS_VOID_TYPE (_tmp174 = vala_data_type_get_return_type (itype)));
		(_tmp174 == NULL) ? NULL : (_tmp174 = (vala_code_node_unref (_tmp174), NULL));
	} else {
		_tmp173 = FALSE;
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	if (_tmp173) {
		ValaSignal* _tmp175;
		ValaSignal* sig;
		gboolean _tmp176;
		gboolean _tmp177;
		_tmp175 = NULL;
		sig = (_tmp175 = vala_signal_type_get_signal_symbol ((VALA_SIGNAL_TYPE (itype))), (_tmp175 == NULL) ? NULL : vala_code_node_ref (_tmp175));
		_tmp176 = FALSE;
		_tmp177 = FALSE;
		if (ma != NULL) {
			_tmp177 = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
		} else {
			_tmp177 = FALSE;
		}
		if (_tmp177) {
			_tmp176 = vala_signal_get_is_virtual (sig);
		} else {
			_tmp176 = FALSE;
		}
		if (_tmp176) {
		} else {
			if (!vala_signal_get_has_emitter (sig)) {
				ValaDataType* _tmp178;
				ValaLocalVariable* _tmp179;
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp180;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp182;
				ValaCCodeExpression* _tmp181;
				_tmp178 = NULL;
				_tmp179 = NULL;
				temp_var = (_tmp179 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp178 = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp178 == NULL) ? NULL : (_tmp178 = (vala_code_node_unref (_tmp178), NULL)), _tmp179);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp180 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp180 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) temp_ref)));
				(_tmp180 == NULL) ? NULL : (_tmp180 = (vala_ccode_node_unref (_tmp180), NULL));
				ccomma = vala_ccode_comma_expression_new ();
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
				_tmp182 = NULL;
				_tmp181 = NULL;
				ccall_expr = (_tmp182 = (_tmp181 = (ValaCCodeExpression*) ccomma, (_tmp181 == NULL) ? NULL : vala_ccode_node_ref (_tmp181)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp182);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
	}
	/* append C arguments in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeExpression* _tmp187;
		min_pos = -1;
		{
			GeeSet* _tmp183;
			GeeIterator* _tmp184;
			GeeIterator* pos_it;
			_tmp183 = NULL;
			_tmp184 = NULL;
			pos_it = (_tmp184 = gee_iterable_iterator ((GeeIterable*) (_tmp183 = gee_map_get_keys ((GeeMap*) carg_map))), (_tmp183 == NULL) ? NULL : (_tmp183 = (gee_collection_object_unref (_tmp183), NULL)), _tmp184);
			while (gee_iterator_next (pos_it)) {
				gint pos;
				gboolean _tmp185;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				_tmp185 = FALSE;
				if (pos > last_pos) {
					gboolean _tmp186;
					_tmp186 = FALSE;
					if (min_pos == (-1)) {
						_tmp186 = TRUE;
					} else {
						_tmp186 = pos < min_pos;
					}
					_tmp185 = (_tmp186);
				} else {
					_tmp185 = FALSE;
				}
				if (_tmp185) {
					min_pos = pos;
				}
			}
			(pos_it == NULL) ? NULL : (pos_it = (gee_collection_object_unref (pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp187 = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp187 = (ValaCCodeExpression*) gee_map_get ((GeeMap*) carg_map, GINT_TO_POINTER (min_pos)));
		(_tmp187 == NULL) ? NULL : (_tmp187 = (vala_ccode_node_unref (_tmp187), NULL));
		last_pos = min_pos;
	}
	_tmp188 = FALSE;
	_tmp189 = FALSE;
	if (m != NULL) {
		_tmp189 = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp189 = FALSE;
	}
	if (_tmp189) {
		_tmp188 = vala_method_get_returns_modified_pointer (m);
	} else {
		_tmp188 = FALSE;
	}
	if (_tmp188) {
		ValaCCodeAssignment* _tmp190;
		_tmp190 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp190 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp190 == NULL) ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL));
	} else {
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall_expr);
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp191;
		GeeIterator* _tmp192;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp194;
		ValaExpression* _tmp193;
		ValaCCodeExpression* _tmp195;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp196;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp197;
		ValaArrayType* array_type;
		char* _tmp199;
		char* _tmp198;
		ValaCCodeIdentifier* _tmp200;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp201;
		ValaCCodeFunctionCall* _tmp202;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp203;
		ValaCCodeConstant* _tmp204;
		ValaCCodeBinaryExpression* _tmp205;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp206;
		ValaCCodeConditionalExpression* _tmp208;
		ValaCCodeConstant* _tmp207;
		ValaCCodeAssignment* _tmp210;
		ValaCCodeExpression* _tmp209;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp191 = NULL;
		_tmp192 = NULL;
		arg_it = (_tmp192 = gee_iterable_iterator ((GeeIterable*) (_tmp191 = vala_method_call_get_argument_list (expr))), (_tmp191 == NULL) ? NULL : (_tmp191 = (gee_collection_object_unref (_tmp191), NULL)), _tmp192);
		gee_iterator_next (arg_it);
		_tmp194 = NULL;
		_tmp193 = NULL;
		_tmp195 = NULL;
		new_size = (_tmp195 = (_tmp194 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp193 = (ValaExpression*) gee_iterator_get (arg_it)))), (_tmp194 == NULL) ? NULL : vala_ccode_node_ref (_tmp194)), (_tmp193 == NULL) ? NULL : (_tmp193 = (vala_code_node_unref (_tmp193), NULL)), _tmp195);
		temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl));
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
		/* memset needs string.h */
		((ValaCCodeBaseModule*) self)->string_h_needed = TRUE;
		clen = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1);
		_tmp196 = NULL;
		celems = (_tmp196 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp196 == NULL) ? NULL : vala_ccode_node_ref (_tmp196));
		_tmp197 = NULL;
		array_type = (_tmp197 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp197 == NULL) ? NULL : vala_code_node_ref (_tmp197));
		_tmp199 = NULL;
		_tmp198 = NULL;
		_tmp200 = NULL;
		csizeof = (_tmp200 = vala_ccode_identifier_new (_tmp199 = g_strdup_printf ("sizeof (%s)", _tmp198 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))), _tmp199 = (g_free (_tmp199), NULL), _tmp198 = (g_free (_tmp198), NULL), _tmp200);
		cdelta = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) temp_ref, clen);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, (ValaCCodeExpression*) temp_ref, clen);
		_tmp201 = NULL;
		_tmp202 = NULL;
		czero = (_tmp202 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp201 = vala_ccode_identifier_new ("memset"))), (_tmp201 == NULL) ? NULL : (_tmp201 = (vala_ccode_node_unref (_tmp201), NULL)), _tmp202);
		_tmp203 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp203 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen)));
		(_tmp203 == NULL) ? NULL : (_tmp203 = (vala_ccode_node_unref (_tmp203), NULL));
		_tmp204 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp204 = vala_ccode_constant_new ("0")));
		(_tmp204 == NULL) ? NULL : (_tmp204 = (vala_ccode_node_unref (_tmp204), NULL));
		_tmp205 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp205 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) csizeof, (ValaCCodeExpression*) cdelta)));
		(_tmp205 == NULL) ? NULL : (_tmp205 = (vala_ccode_node_unref (_tmp205), NULL));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp206 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp206 = vala_ccode_assignment_new ((ValaCCodeExpression*) temp_ref, new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp206 == NULL) ? NULL : (_tmp206 = (vala_ccode_node_unref (_tmp206), NULL));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
		_tmp208 = NULL;
		_tmp207 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp208 = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccheck, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) (_tmp207 = vala_ccode_constant_new ("NULL")))));
		(_tmp208 == NULL) ? NULL : (_tmp208 = (vala_ccode_node_unref (_tmp208), NULL));
		(_tmp207 == NULL) ? NULL : (_tmp207 = (vala_ccode_node_unref (_tmp207), NULL));
		_tmp210 = NULL;
		_tmp209 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp210 = vala_ccode_assignment_new (_tmp209 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1), (ValaCCodeExpression*) temp_ref, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp210 == NULL) ? NULL : (_tmp210 = (vala_ccode_node_unref (_tmp210), NULL));
		(_tmp209 == NULL) ? NULL : (_tmp209 = (vala_ccode_node_unref (_tmp209), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
		(new_size == NULL) ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
		(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
		(clen == NULL) ? NULL : (clen = (vala_ccode_node_unref (clen), NULL));
		(celems == NULL) ? NULL : (celems = (vala_ccode_node_unref (celems), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
		(cdelta == NULL) ? NULL : (cdelta = (vala_ccode_node_unref (cdelta), NULL));
		(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
		(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	} else {
		if (m == ((ValaCCodeBaseModule*) self)->substring_method) {
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			GeeList* args;
			ValaCCodeIdentifier* _tmp211;
			ValaCCodeFunctionCall* _tmp212;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeExpression* _tmp213;
			ValaCCodeExpression* _tmp214;
			ValaCCodeIdentifier* _tmp215;
			ValaCCodeFunctionCall* _tmp216;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeExpression* _tmp217;
			ValaCCodeIdentifier* _tmp218;
			ValaCCodeFunctionCall* _tmp219;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* _tmp220;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp221;
			temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->string_type, TRUE, NULL);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl));
			gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
			args = vala_ccode_function_call_get_arguments (ccall);
			_tmp211 = NULL;
			_tmp212 = NULL;
			coffsetcall = (_tmp212 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp211 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer"))), (_tmp211 == NULL) ? NULL : (_tmp211 = (vala_ccode_node_unref (_tmp211), NULL)), _tmp212);
			/* full string*/
			_tmp213 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, _tmp213 = (ValaCCodeExpression*) gee_list_get ((GeeList*) args, 0));
			(_tmp213 == NULL) ? NULL : (_tmp213 = (vala_ccode_node_unref (_tmp213), NULL));
			/* offset*/
			_tmp214 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, _tmp214 = (ValaCCodeExpression*) gee_list_get ((GeeList*) args, 1));
			(_tmp214 == NULL) ? NULL : (_tmp214 = (vala_ccode_node_unref (_tmp214), NULL));
			_tmp215 = NULL;
			_tmp216 = NULL;
			coffsetcall2 = (_tmp216 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp215 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer"))), (_tmp215 == NULL) ? NULL : (_tmp215 = (vala_ccode_node_unref (_tmp215), NULL)), _tmp216);
			vala_ccode_function_call_add_argument (coffsetcall2, (ValaCCodeExpression*) temp_ref);
			/* len*/
			_tmp217 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall2, _tmp217 = (ValaCCodeExpression*) gee_list_get ((GeeList*) args, 2));
			(_tmp217 == NULL) ? NULL : (_tmp217 = (vala_ccode_node_unref (_tmp217), NULL));
			_tmp218 = NULL;
			_tmp219 = NULL;
			cndupcall = (_tmp219 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp218 = vala_ccode_identifier_new ("g_strndup"))), (_tmp218 == NULL) ? NULL : (_tmp218 = (vala_ccode_node_unref (_tmp218), NULL)), _tmp219);
			vala_ccode_function_call_add_argument (cndupcall, (ValaCCodeExpression*) temp_ref);
			_tmp220 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, (ValaCCodeExpression*) (_tmp220 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) coffsetcall2, (ValaCCodeExpression*) temp_ref)));
			(_tmp220 == NULL) ? NULL : (_tmp220 = (vala_ccode_node_unref (_tmp220), NULL));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp221 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp221 = vala_ccode_assignment_new ((ValaCCodeExpression*) temp_ref, (ValaCCodeExpression*) coffsetcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp221 == NULL) ? NULL : (_tmp221 = (vala_ccode_node_unref (_tmp221), NULL));
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cndupcall);
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
			(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
			(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
			(args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL));
			(coffsetcall == NULL) ? NULL : (coffsetcall = (vala_ccode_node_unref (coffsetcall), NULL));
			(coffsetcall2 == NULL) ? NULL : (coffsetcall2 = (vala_ccode_node_unref (coffsetcall2), NULL));
			(cndupcall == NULL) ? NULL : (cndupcall = (vala_ccode_node_unref (cndupcall), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
		}
	}
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(itype == NULL) ? NULL : (itype = (vala_code_node_unref (itype), NULL));
	(ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL));
	(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
	(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
}


static void vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass) {
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_ccode_method_call_module_real_visit_method_call;
}


static void vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self) {
}


GType vala_ccode_method_call_module_get_type (void) {
	static GType vala_ccode_method_call_module_type_id = 0;
	if (vala_ccode_method_call_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_call_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




