/* valacodegenerator.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacodegenerator.h>
#include <vala/valacodecontext.h>




enum  {
	VALA_CODE_GENERATOR_DUMMY_PROPERTY
};
static void vala_code_generator_real_emit (ValaCodeGenerator* self, ValaCodeContext* context);
static gpointer vala_code_generator_parent_class = NULL;



/**
 * Generate and emit C code for the specified code context.
 *
 * @param context a code context
 */
static void vala_code_generator_real_emit (ValaCodeGenerator* self, ValaCodeContext* context) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
}


void vala_code_generator_emit (ValaCodeGenerator* self, ValaCodeContext* context) {
	VALA_CODE_GENERATOR_GET_CLASS (self)->emit (self, context);
}


/**
 * Abstract code visitor generating code.
 */
ValaCodeGenerator* vala_code_generator_construct (GType object_type) {
	ValaCodeGenerator* self;
	self = (ValaCodeGenerator*) g_type_create_instance (object_type);
	return self;
}


ValaCodeGenerator* vala_code_generator_new (void) {
	return vala_code_generator_construct (VALA_TYPE_CODE_GENERATOR);
}


static void vala_code_generator_class_init (ValaCodeGeneratorClass * klass) {
	vala_code_generator_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_GENERATOR_CLASS (klass)->emit = vala_code_generator_real_emit;
}


static void vala_code_generator_instance_init (ValaCodeGenerator * self) {
}


GType vala_code_generator_get_type (void) {
	static GType vala_code_generator_type_id = 0;
	if (vala_code_generator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeGenerator), 0, (GInstanceInitFunc) vala_code_generator_instance_init, NULL };
		vala_code_generator_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaCodeGenerator", &g_define_type_info, 0);
	}
	return vala_code_generator_type_id;
}




