/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodemethodcallmodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamethod.h>
#include <gee/list.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignaltype.h>
#include <vala/valabaseaccess.h>
#include <vala/valasignal.h>
#include <vala/valaobjecttype.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <gee/hashmap.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valacreationmethod.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraytype.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valamember.h>
#include <vala/valasymbol.h>
#include <vala/valastruct.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valatypesymbol.h>
#include <vala/valadynamicmethod.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaunaryexpression.h>
#include <vala/valaformalparameter.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valavoidtype.h>
#include <vala/valapointertype.h>
#include <gee/collection.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_METHOD_CALL_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static gpointer vala_ccode_method_call_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodCallModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE, codegen, next);
}


static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeFunctionCall* async_call;
	ValaMethod* m;
	GeeList* params;
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaDataType* _tmp2;
	ValaDataType* itype;
	GeeList* _tmp3;
	GeeHashMap* in_arg_map;
	GeeHashMap* out_arg_map;
	gboolean _tmp18;
	gboolean _tmp19;
	ValaCCodeExpression* _tmp42;
	ValaCCodeExpression* ccall_expr;
	ValaCCodeExpression* instance;
	gboolean _tmp46;
	gboolean _tmp47;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	gboolean _tmp175;
	gboolean _tmp191;
	gboolean _tmp202;
	gboolean _tmp213;
	gint last_pos;
	gint min_pos;
	gboolean _tmp233;
	gboolean _tmp234;
	gboolean _tmp236;
	gboolean _tmp237;
	gboolean _tmp238;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))));
	async_call = NULL;
	m = NULL;
	params = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_method_call_get_call (expr), VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = NULL;
	itype = (_tmp2 = vala_expression_get_value_type (vala_method_call_get_call (expr)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = NULL;
	params = (_tmp3 = vala_data_type_get_parameters (itype), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp3);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp5;
		ValaMethod* _tmp4;
		g_assert (ma != NULL);
		_tmp5 = NULL;
		_tmp4 = NULL;
		m = (_tmp5 = (_tmp4 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (itype))), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp5);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaSignalType* _tmp6;
			ValaSignalType* sig_type;
			gboolean _tmp7;
			gboolean _tmp8;
			_tmp6 = NULL;
			sig_type = (_tmp6 = VALA_SIGNAL_TYPE (itype), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
			_tmp7 = FALSE;
			_tmp8 = FALSE;
			if (ma != NULL) {
				_tmp8 = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
			} else {
				_tmp8 = FALSE;
			}
			if (_tmp8) {
				_tmp7 = vala_signal_get_is_virtual (vala_signal_type_get_signal_symbol (sig_type));
			} else {
				_tmp7 = FALSE;
			}
			if (_tmp7) {
				ValaMethod* _tmp9;
				_tmp9 = NULL;
				m = (_tmp9 = vala_signal_get_method_handler (vala_signal_type_get_signal_symbol (sig_type)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp9);
			} else {
				ValaCCodeFunctionCall* _tmp11;
				ValaCCodeFunctionCall* _tmp10;
				_tmp11 = NULL;
				_tmp10 = NULL;
				ccall = (_tmp11 = (_tmp10 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))), (_tmp10 == NULL) ? NULL : vala_ccode_node_ref (_tmp10)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp11);
			}
			(sig_type == NULL) ? NULL : (sig_type = (vala_code_node_unref (sig_type), NULL));
		} else {
			if (VALA_IS_OBJECT_TYPE (itype)) {
				ValaClass* _tmp12;
				ValaClass* cl;
				ValaMethod* _tmp14;
				ValaMethod* _tmp13;
				ValaCCodeFunctionCall* _tmp17;
				ValaCCodeIdentifier* _tmp16;
				char* _tmp15;
				/* constructor*/
				_tmp12 = NULL;
				cl = (_tmp12 = VALA_CLASS (vala_object_type_get_type_symbol ((VALA_OBJECT_TYPE (itype)))), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
				_tmp14 = NULL;
				_tmp13 = NULL;
				m = (_tmp14 = (_tmp13 = vala_class_get_default_construction_method (cl), (_tmp13 == NULL) ? NULL : vala_code_node_ref (_tmp13)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp14);
				_tmp17 = NULL;
				_tmp16 = NULL;
				_tmp15 = NULL;
				ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new (_tmp15 = vala_method_get_real_cname (m)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp17);
				(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
				_tmp15 = (g_free (_tmp15), NULL);
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			}
		}
	}
	in_arg_map = NULL;
	out_arg_map = NULL;
	_tmp18 = FALSE;
	_tmp19 = FALSE;
	if (m != NULL) {
		_tmp19 = vala_method_get_coroutine (m);
	} else {
		_tmp19 = FALSE;
	}
	if (_tmp19) {
		gboolean _tmp20;
		gboolean _tmp21;
		_tmp20 = FALSE;
		_tmp21 = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp21 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp21 = FALSE;
		}
		if ((_tmp21)) {
			_tmp20 = TRUE;
		} else {
			gboolean _tmp22;
			_tmp22 = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp22 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp22 = FALSE;
			}
			_tmp20 = (_tmp22);
		}
		_tmp18 = (_tmp20);
	} else {
		_tmp18 = FALSE;
	}
	if (_tmp18) {
		GeeHashMap* _tmp23;
		GeeHashMap* _tmp24;
		ValaCCodeFunctionCall* _tmp28;
		ValaCCodeIdentifier* _tmp27;
		char* _tmp26;
		char* _tmp25;
		gboolean _tmp29;
		/* async call*/
		_tmp23 = NULL;
		in_arg_map = (_tmp23 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL)), _tmp23);
		_tmp24 = NULL;
		out_arg_map = (_tmp24 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL)), _tmp24);
		_tmp28 = NULL;
		_tmp27 = NULL;
		_tmp26 = NULL;
		_tmp25 = NULL;
		async_call = (_tmp28 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new (_tmp26 = g_strconcat (_tmp25 = vala_method_get_cname (m), "_async", NULL)))), (async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL)), _tmp28);
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		_tmp26 = (g_free (_tmp26), NULL);
		_tmp25 = (g_free (_tmp25), NULL);
		_tmp29 = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
			_tmp29 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
		} else {
			_tmp29 = FALSE;
		}
		if (_tmp29) {
			ValaCCodeFunctionCall* _tmp31;
			ValaCCodeFunctionCall* _tmp30;
			/* no finish call*/
			_tmp31 = NULL;
			_tmp30 = NULL;
			ccall = (_tmp31 = (_tmp30 = async_call, (_tmp30 == NULL) ? NULL : vala_ccode_node_ref (_tmp30)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp31);
		} else {
			ValaCCodeFunctionCall* _tmp35;
			ValaCCodeIdentifier* _tmp34;
			char* _tmp33;
			char* _tmp32;
			ValaCCodeMemberAccess* _tmp37;
			ValaCCodeIdentifier* _tmp36;
			_tmp35 = NULL;
			_tmp34 = NULL;
			_tmp33 = NULL;
			_tmp32 = NULL;
			ccall = (_tmp35 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new (_tmp33 = g_strconcat (_tmp32 = vala_method_get_cname (m), "_finish", NULL)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp35);
			(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
			_tmp33 = (g_free (_tmp33), NULL);
			_tmp32 = (g_free (_tmp32), NULL);
			/* pass GAsyncResult stored in closure to finish function*/
			_tmp37 = NULL;
			_tmp36 = NULL;
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) (_tmp37 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("data")), "res")));
			(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
			(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
		}
	} else {
		GeeHashMap* _tmp38;
		GeeHashMap* _tmp40;
		GeeHashMap* _tmp39;
		_tmp38 = NULL;
		in_arg_map = (_tmp38 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL)), _tmp38);
		_tmp40 = NULL;
		_tmp39 = NULL;
		out_arg_map = (_tmp40 = (_tmp39 = in_arg_map, (_tmp39 == NULL) ? NULL : gee_collection_object_ref (_tmp39)), (out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL)), _tmp40);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCCodeIdentifier* _tmp41;
		_tmp41 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new ("object_type")));
		(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp42 = NULL;
	ccall_expr = (_tmp42 = (ValaCCodeExpression*) ccall, (_tmp42 == NULL) ? NULL : vala_ccode_node_ref (_tmp42));
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp43;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp45;
		char* _tmp44;
		_tmp43 = NULL;
		array_type = (_tmp43 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp43 == NULL) ? NULL : vala_code_node_ref (_tmp43));
		_tmp45 = NULL;
		_tmp44 = NULL;
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) 0, FALSE)), (ValaCCodeExpression*) (_tmp45 = vala_ccode_identifier_new (_tmp44 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
		_tmp44 = (g_free (_tmp44), NULL);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	_tmp46 = FALSE;
	_tmp47 = FALSE;
	if (m != NULL) {
		_tmp47 = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp47 = FALSE;
	}
	if (_tmp47) {
		_tmp46 = !(VALA_IS_CREATION_METHOD (m));
	} else {
		_tmp46 = FALSE;
	}
	if (_tmp46) {
		ValaCCodeExpression* _tmp49;
		ValaCCodeExpression* _tmp48;
		gboolean _tmp50;
		ValaStruct* _tmp55;
		ValaSymbol* _tmp54;
		ValaStruct* st;
		gboolean _tmp56;
		_tmp49 = NULL;
		_tmp48 = NULL;
		instance = (_tmp49 = (_tmp48 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp48 == NULL) ? NULL : vala_ccode_node_ref (_tmp48)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp49);
		_tmp50 = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
			_tmp50 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
		} else {
			_tmp50 = FALSE;
		}
		if (_tmp50) {
			ValaMemberAccess* _tmp51;
			ValaMemberAccess* inner_ma;
			ValaCCodeExpression* _tmp53;
			ValaCCodeExpression* _tmp52;
			_tmp51 = NULL;
			inner_ma = (_tmp51 = VALA_MEMBER_ACCESS (vala_member_access_get_inner (ma)), (_tmp51 == NULL) ? NULL : vala_code_node_ref (_tmp51));
			_tmp53 = NULL;
			_tmp52 = NULL;
			instance = (_tmp53 = (_tmp52 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (inner_ma))), (_tmp52 == NULL) ? NULL : vala_ccode_node_ref (_tmp52)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp53);
			(inner_ma == NULL) ? NULL : (inner_ma = (vala_code_node_unref (inner_ma), NULL));
		}
		_tmp55 = NULL;
		_tmp54 = NULL;
		st = (_tmp55 = (_tmp54 = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_STRUCT (_tmp54) ? ((ValaStruct*) _tmp54) : NULL), (_tmp55 == NULL) ? NULL : vala_code_node_ref (_tmp55));
		_tmp56 = FALSE;
		if (st != NULL) {
			_tmp56 = !vala_struct_is_simple_type (st);
		} else {
			_tmp56 = FALSE;
		}
		if (_tmp56) {
			ValaCCodeUnaryExpression* _tmp58;
			ValaCCodeExpression* _tmp57;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp59;
			/* we need to pass struct instance by reference*/
			_tmp58 = NULL;
			_tmp57 = NULL;
			unary = (_tmp58 = (_tmp57 = instance, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp57) ? ((ValaCCodeUnaryExpression*) _tmp57) : NULL), (_tmp58 == NULL) ? NULL : vala_ccode_node_ref (_tmp58));
			_tmp59 = FALSE;
			if (unary != NULL) {
				_tmp59 = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp59 = FALSE;
			}
			if (_tmp59) {
				ValaCCodeExpression* _tmp61;
				ValaCCodeExpression* _tmp60;
				/* *expr => expr*/
				_tmp61 = NULL;
				_tmp60 = NULL;
				instance = (_tmp61 = (_tmp60 = vala_ccode_unary_expression_get_inner (unary), (_tmp60 == NULL) ? NULL : vala_ccode_node_ref (_tmp60)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp61);
			} else {
				gboolean _tmp62;
				_tmp62 = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (instance)) {
					_tmp62 = TRUE;
				} else {
					_tmp62 = VALA_IS_CCODE_MEMBER_ACCESS (instance);
				}
				if (_tmp62) {
					ValaCCodeExpression* _tmp63;
					_tmp63 = NULL;
					instance = (_tmp63 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp63);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp65;
					ValaCCodeExpression* _tmp64;
					ValaCCodeUnaryExpression* _tmp67;
					ValaCCodeExpression* _tmp66;
					ValaCCodeExpression* _tmp69;
					ValaCCodeExpression* _tmp68;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp65 = NULL;
					_tmp64 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp65 = vala_ccode_assignment_new (_tmp64 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
					(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
					_tmp67 = NULL;
					_tmp66 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp67 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp66 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)))));
					(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
					(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
					_tmp69 = NULL;
					_tmp68 = NULL;
					instance = (_tmp69 = (_tmp68 = (ValaCCodeExpression*) ccomma, (_tmp68 == NULL) ? NULL : vala_ccode_node_ref (_tmp68)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp69);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		}
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	} else {
		gboolean _tmp70;
		_tmp70 = FALSE;
		if (m != NULL) {
			_tmp70 = vala_method_get_binding (m) == MEMBER_BINDING_CLASS;
		} else {
			_tmp70 = FALSE;
		}
		if (_tmp70) {
			ValaClass* _tmp71;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp74;
			char* _tmp73;
			char* _tmp72;
			ValaCCodeFunctionCall* _tmp75;
			ValaCCodeFunctionCall* cast;
			ValaCCodeExpression* klass;
			_tmp71 = NULL;
			cl = (_tmp71 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp71 == NULL) ? NULL : vala_code_node_ref (_tmp71));
			_tmp74 = NULL;
			_tmp73 = NULL;
			_tmp72 = NULL;
			_tmp75 = NULL;
			cast = (_tmp75 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp74 = vala_ccode_identifier_new (_tmp73 = g_strconcat (_tmp72 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)), _tmp73 = (g_free (_tmp73), NULL), _tmp72 = (g_free (_tmp72), NULL), _tmp75);
			klass = NULL;
			if (vala_member_access_get_inner (ma) == NULL) {
				if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
					ValaCCodeExpression* _tmp76;
					/* Accessing the method from a static or class constructor*/
					_tmp76 = NULL;
					klass = (_tmp76 = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp76);
				} else {
					ValaCCodeIdentifier* _tmp77;
					ValaCCodeFunctionCall* _tmp78;
					ValaCCodeFunctionCall* k;
					ValaCCodeIdentifier* _tmp79;
					ValaCCodeExpression* _tmp81;
					ValaCCodeExpression* _tmp80;
					/* Accessing the method from within an instance method*/
					_tmp77 = NULL;
					_tmp78 = NULL;
					k = (_tmp78 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp77 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)), _tmp78);
					_tmp79 = NULL;
					vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp79 = vala_ccode_identifier_new ("self")));
					(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
					_tmp81 = NULL;
					_tmp80 = NULL;
					klass = (_tmp81 = (_tmp80 = (ValaCCodeExpression*) k, (_tmp80 == NULL) ? NULL : vala_ccode_node_ref (_tmp80)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp81);
					(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
				}
			} else {
				ValaCCodeIdentifier* _tmp82;
				ValaCCodeFunctionCall* _tmp83;
				ValaCCodeFunctionCall* k;
				ValaCCodeExpression* _tmp85;
				ValaCCodeExpression* _tmp84;
				/* Accessing the method of an instance*/
				_tmp82 = NULL;
				_tmp83 = NULL;
				k = (_tmp83 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp82 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL)), _tmp83);
				vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))));
				_tmp85 = NULL;
				_tmp84 = NULL;
				klass = (_tmp85 = (_tmp84 = (ValaCCodeExpression*) k, (_tmp84 == NULL) ? NULL : vala_ccode_node_ref (_tmp84)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp85);
				(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
			}
			vala_ccode_function_call_add_argument (cast, klass);
			gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
			(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp86;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp87;
		ValaCCodeFunctionCall* _tmp88;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp90;
		char* _tmp89;
		_tmp86 = NULL;
		array_type = (_tmp86 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp86 == NULL) ? NULL : vala_code_node_ref (_tmp86));
		_tmp87 = NULL;
		_tmp88 = NULL;
		csizeof = (_tmp88 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp87 = vala_ccode_identifier_new ("sizeof"))), (_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL)), _tmp88);
		_tmp90 = NULL;
		_tmp89 = NULL;
		vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp90 = vala_ccode_identifier_new (_tmp89 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
		_tmp89 = (g_free (_tmp89), NULL);
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) csizeof);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* _tmp91;
				GeeIterator* _tmp92;
				GeeIterator* _arg_it;
				_tmp91 = NULL;
				_tmp92 = NULL;
				_arg_it = (_tmp92 = gee_iterable_iterator ((GeeIterable*) (_tmp91 = vala_method_call_get_argument_list (expr))), (_tmp91 == NULL) ? NULL : (_tmp91 = (gee_collection_object_unref (_tmp91), NULL)), _tmp92);
				while (gee_iterator_next (_arg_it)) {
					ValaExpression* arg;
					ValaUnaryExpression* _tmp94;
					ValaExpression* _tmp93;
					ValaUnaryExpression* unary;
					gboolean _tmp95;
					arg = (ValaExpression*) gee_iterator_get (_arg_it);
					_tmp94 = NULL;
					_tmp93 = NULL;
					unary = (_tmp94 = (_tmp93 = arg, VALA_IS_UNARY_EXPRESSION (_tmp93) ? ((ValaUnaryExpression*) _tmp93) : NULL), (_tmp94 == NULL) ? NULL : vala_code_node_ref (_tmp94));
					_tmp95 = FALSE;
					if (unary != NULL) {
						_tmp95 = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp95 = FALSE;
					}
					if (_tmp95) {
						char* _tmp96;
						ValaFormalParameter* _tmp97;
						ValaFormalParameter* param;
						/* out argument*/
						_tmp96 = NULL;
						_tmp97 = NULL;
						param = (_tmp97 = vala_formal_parameter_new (_tmp96 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp96 = (g_free (_tmp96), NULL), _tmp97);
						vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
						vala_method_add_parameter (m, param);
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					} else {
						gboolean _tmp98;
						_tmp98 = FALSE;
						if (unary != NULL) {
							_tmp98 = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp98 = FALSE;
						}
						if (_tmp98) {
							char* _tmp99;
							ValaFormalParameter* _tmp100;
							ValaFormalParameter* param;
							/* ref argument*/
							_tmp99 = NULL;
							_tmp100 = NULL;
							param = (_tmp100 = vala_formal_parameter_new (_tmp99 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp99 = (g_free (_tmp99), NULL), _tmp100);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
							vala_method_add_parameter (m, param);
							(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						} else {
							ValaFormalParameter* _tmp102;
							char* _tmp101;
							/* in argument*/
							_tmp102 = NULL;
							_tmp101 = NULL;
							vala_method_add_parameter (m, _tmp102 = vala_formal_parameter_new (_tmp101 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (arg), NULL));
							(_tmp102 == NULL) ? NULL : (_tmp102 = (vala_code_node_unref (_tmp102), NULL));
							_tmp101 = (g_free (_tmp101), NULL);
						}
					}
					param_nr++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
				}
				(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
			}
			{
				GeeList* _tmp103;
				GeeIterator* _tmp104;
				GeeIterator* _param_it;
				_tmp103 = NULL;
				_tmp104 = NULL;
				_param_it = (_tmp104 = gee_iterable_iterator ((GeeIterable*) (_tmp103 = vala_method_get_parameters (m))), (_tmp103 == NULL) ? NULL : (_tmp103 = (gee_collection_object_unref (_tmp103), NULL)), _tmp104);
				while (gee_iterator_next (_param_it)) {
					ValaFormalParameter* param;
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					vala_code_node_accept ((ValaCodeNode*) param, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
			}
			vala_ccode_module_generate_dynamic_method_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_METHOD (m));
		} else {
			if (VALA_IS_CREATION_METHOD (m)) {
				ValaCCodeExpression* _tmp109;
				ValaCCodeCastExpression* _tmp108;
				char* _tmp107;
				char* _tmp106;
				ValaCCodeIdentifier* _tmp105;
				_tmp109 = NULL;
				_tmp108 = NULL;
				_tmp107 = NULL;
				_tmp106 = NULL;
				_tmp105 = NULL;
				ccall_expr = (_tmp109 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp105 = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp108 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp107 = g_strconcat (_tmp106 = vala_typesymbol_get_cname ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, FALSE), "*", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp109);
				(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
				_tmp107 = (g_free (_tmp107), NULL);
				_tmp106 = (g_free (_tmp106), NULL);
				(_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL));
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator ((GeeIterable*) params);
	{
		GeeList* _tmp110;
		GeeIterator* _tmp111;
		GeeIterator* _arg_it;
		_tmp110 = NULL;
		_tmp111 = NULL;
		_arg_it = (_tmp111 = gee_iterable_iterator ((GeeIterable*) (_tmp110 = vala_method_call_get_argument_list (expr))), (_tmp110 == NULL) ? NULL : (_tmp110 = (gee_collection_object_unref (_tmp110), NULL)), _tmp111);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			ValaCCodeExpression* _tmp112;
			ValaCCodeExpression* cexpr;
			GeeHashMap* _tmp113;
			GeeHashMap* carg_map;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			_tmp112 = NULL;
			cexpr = (_tmp112 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)), (_tmp112 == NULL) ? NULL : vala_ccode_node_ref (_tmp112));
			_tmp113 = NULL;
			carg_map = (_tmp113 = in_arg_map, (_tmp113 == NULL) ? NULL : gee_collection_object_ref (_tmp113));
			if (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				gboolean _tmp114;
				param = (ValaFormalParameter*) gee_iterator_get (params_it);
				_tmp114 = FALSE;
				if (vala_formal_parameter_get_params_array (param)) {
					_tmp114 = TRUE;
				} else {
					_tmp114 = vala_formal_parameter_get_ellipsis (param);
				}
				ellipsis = _tmp114;
				if (!ellipsis) {
					gboolean multiple_cargs;
					gboolean _tmp117;
					ValaCCodeExpression* _tmp137;
					gboolean _tmp138;
					gboolean _tmp144;
					gboolean _tmp145;
					gboolean _tmp146;
					/* if the vala argument expands to multiple C arguments,
					 we have to make sure that the C arguments don't depend
					 on each other as there is no guaranteed argument
					 evaluation order
					 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
					multiple_cargs = FALSE;
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
						GeeHashMap* _tmp116;
						GeeHashMap* _tmp115;
						_tmp116 = NULL;
						_tmp115 = NULL;
						carg_map = (_tmp116 = (_tmp115 = out_arg_map, (_tmp115 == NULL) ? NULL : gee_collection_object_ref (_tmp115)), (carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)), _tmp116);
					}
					_tmp117 = FALSE;
					if (!vala_formal_parameter_get_no_array_length (param)) {
						_tmp117 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp117 = FALSE;
					}
					if (_tmp117) {
						ValaArrayType* _tmp118;
						ValaArrayType* array_type;
						_tmp118 = NULL;
						array_type = (_tmp118 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp118 == NULL) ? NULL : vala_code_node_ref (_tmp118));
						{
							gint dim;
							dim = 1;
							for (; dim <= vala_array_type_get_rank (array_type); dim++) {
								ValaCCodeExpression* _tmp119;
								_tmp119 = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp119 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), arg, dim));
								(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
							}
						}
						multiple_cargs = TRUE;
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					} else {
						if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaDelegateType* _tmp120;
							ValaDelegateType* deleg_type;
							ValaDelegate* _tmp121;
							ValaDelegate* d;
							_tmp120 = NULL;
							deleg_type = (_tmp120 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp120 == NULL) ? NULL : vala_code_node_ref (_tmp120));
							_tmp121 = NULL;
							d = (_tmp121 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp121 == NULL) ? NULL : vala_code_node_ref (_tmp121));
							if (vala_delegate_get_has_target (d)) {
								ValaCCodeExpression* delegate_target;
								delegate_target = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg);
								if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
									ValaCCodeExpression* delegate_target_destroy_notify;
									ValaMethod* _tmp123;
									ValaSymbol* _tmp122;
									ValaMethod* delegate_method;
									ValaMemberAccess* _tmp125;
									ValaExpression* _tmp124;
									ValaMemberAccess* arg_ma;
									gboolean _tmp126;
									gboolean _tmp127;
									gboolean _tmp128;
									gboolean _tmp129;
									delegate_target_destroy_notify = NULL;
									_tmp123 = NULL;
									_tmp122 = NULL;
									delegate_method = (_tmp123 = (_tmp122 = vala_expression_get_symbol_reference (arg), VALA_IS_METHOD (_tmp122) ? ((ValaMethod*) _tmp122) : NULL), (_tmp123 == NULL) ? NULL : vala_code_node_ref (_tmp123));
									_tmp125 = NULL;
									_tmp124 = NULL;
									arg_ma = (_tmp125 = (_tmp124 = arg, VALA_IS_MEMBER_ACCESS (_tmp124) ? ((ValaMemberAccess*) _tmp124) : NULL), (_tmp125 == NULL) ? NULL : vala_code_node_ref (_tmp125));
									_tmp126 = FALSE;
									_tmp127 = FALSE;
									_tmp128 = FALSE;
									_tmp129 = FALSE;
									if (delegate_method != NULL) {
										_tmp129 = vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE;
									} else {
										_tmp129 = FALSE;
									}
									if (_tmp129) {
										_tmp128 = vala_member_access_get_inner (arg_ma) != NULL;
									} else {
										_tmp128 = FALSE;
									}
									if (_tmp128) {
										_tmp127 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))) != NULL;
									} else {
										_tmp127 = FALSE;
									}
									if (_tmp127) {
										_tmp126 = vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))));
									} else {
										_tmp126 = FALSE;
									}
									if (_tmp126) {
										ValaCCodeExpression* _tmp130;
										ValaCCodeFunctionCall* _tmp131;
										ValaCCodeFunctionCall* ref_call;
										ValaCCodeExpression* _tmp133;
										ValaCCodeExpression* _tmp132;
										ValaCCodeExpression* _tmp134;
										_tmp130 = NULL;
										_tmp131 = NULL;
										ref_call = (_tmp131 = vala_ccode_function_call_new (_tmp130 = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma)), vala_code_node_get_source_reference ((ValaCodeNode*) arg))), (_tmp130 == NULL) ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL)), _tmp131);
										vala_ccode_function_call_add_argument (ref_call, delegate_target);
										_tmp133 = NULL;
										_tmp132 = NULL;
										delegate_target = (_tmp133 = (_tmp132 = (ValaCCodeExpression*) ref_call, (_tmp132 == NULL) ? NULL : vala_ccode_node_ref (_tmp132)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp133);
										_tmp134 = NULL;
										delegate_target_destroy_notify = (_tmp134 = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp134);
										(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
									} else {
										ValaCCodeExpression* _tmp135;
										_tmp135 = NULL;
										delegate_target_destroy_notify = (_tmp135 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp135);
									}
									gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
									(delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL));
									(delegate_method == NULL) ? NULL : (delegate_method = (vala_code_node_unref (delegate_method), NULL));
									(arg_ma == NULL) ? NULL : (arg_ma = (vala_code_node_unref (arg_ma), NULL));
								}
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
								multiple_cargs = TRUE;
								(delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL));
							}
							(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
							(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
						} else {
							if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaCCodeExpression* _tmp136;
								_tmp136 = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp136 = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg));
								(_tmp136 == NULL) ? NULL : (_tmp136 = (vala_ccode_node_unref (_tmp136), NULL));
								multiple_cargs = TRUE;
							}
						}
					}
					_tmp137 = NULL;
					cexpr = (_tmp137 = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, param, arg, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp137);
					_tmp138 = FALSE;
					if (multiple_cargs) {
						_tmp138 = VALA_IS_METHOD_CALL (arg);
					} else {
						_tmp138 = FALSE;
					}
					if (_tmp138) {
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_decl;
						ValaCCodeAssignment* _tmp140;
						ValaCCodeExpression* _tmp139;
						ValaCCodeExpression* _tmp141;
						ValaCCodeExpression* _tmp143;
						ValaCCodeExpression* _tmp142;
						/* if vala argument is invocation expression
						 the auxiliary C argument(s) will depend on the main C argument
						 (tmp = arg1, call (tmp, arg2, arg3,...))*/
						ccomma = vala_ccode_comma_expression_new ();
						temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg), TRUE, NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
						_tmp140 = NULL;
						_tmp139 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp140 = vala_ccode_assignment_new (_tmp139 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp140 == NULL) ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL));
						(_tmp139 == NULL) ? NULL : (_tmp139 = (vala_ccode_node_unref (_tmp139), NULL));
						_tmp141 = NULL;
						cexpr = (_tmp141 = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp141);
						vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						_tmp143 = NULL;
						_tmp142 = NULL;
						ccall_expr = (_tmp143 = (_tmp142 = (ValaCCodeExpression*) ccomma, (_tmp142 == NULL) ? NULL : vala_ccode_node_ref (_tmp142)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp143);
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
					}
					_tmp144 = FALSE;
					_tmp145 = FALSE;
					_tmp146 = FALSE;
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						_tmp146 = vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg));
					} else {
						_tmp146 = FALSE;
					}
					if (_tmp146) {
						gboolean _tmp147;
						_tmp147 = FALSE;
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
							_tmp147 = TRUE;
						} else {
							_tmp147 = !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param));
						}
						_tmp145 = (_tmp147);
					} else {
						_tmp145 = FALSE;
					}
					if (_tmp145) {
						_tmp144 = !(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)));
					} else {
						_tmp144 = FALSE;
					}
					/* unref old value for non-null non-weak ref/out arguments
					 disabled for arrays for now as that requires special handling
					 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
					if (_tmp144) {
						ValaUnaryExpression* _tmp148;
						ValaUnaryExpression* unary;
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* _tmp150;
						ValaCCodeExpression* _tmp149;
						ValaLocalVariable* ret_temp_var;
						ValaDataType* _tmp155;
						gboolean _tmp156;
						ValaCCodeCommaExpression* cassign_comma;
						ValaLocalVariable* assign_temp_var;
						ValaCCodeAssignment* _tmp164;
						ValaCCodeExpression* _tmp163;
						ValaCCodeExpression* _tmp162;
						ValaCCodeExpression* _tmp161;
						ValaCCodeExpression* _tmp165;
						ValaCCodeExpression* _tmp166;
						ValaCCodeAssignment* _tmp167;
						ValaDataType* _tmp168;
						gboolean _tmp169;
						ValaCCodeExpression* _tmp172;
						ValaCCodeExpression* _tmp171;
						_tmp148 = NULL;
						unary = (_tmp148 = VALA_UNARY_EXPRESSION (arg), (_tmp148 == NULL) ? NULL : vala_code_node_ref (_tmp148));
						ccomma = vala_ccode_comma_expression_new ();
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp150 = NULL;
						_tmp149 = NULL;
						cexpr = (_tmp150 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp149 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var))), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp150);
						(_tmp149 == NULL) ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL));
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
							ValaCCodeCommaExpression* crefcomma;
							ValaCCodeAssignment* _tmp152;
							ValaCCodeExpression* _tmp151;
							ValaCCodeExpression* _tmp154;
							ValaCCodeExpression* _tmp153;
							crefcomma = vala_ccode_comma_expression_new ();
							_tmp152 = NULL;
							_tmp151 = NULL;
							vala_ccode_comma_expression_append_expression (crefcomma, (ValaCCodeExpression*) (_tmp152 = vala_ccode_assignment_new (_tmp151 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp152 == NULL) ? NULL : (_tmp152 = (vala_ccode_node_unref (_tmp152), NULL));
							(_tmp151 == NULL) ? NULL : (_tmp151 = (vala_ccode_node_unref (_tmp151), NULL));
							vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
							_tmp154 = NULL;
							_tmp153 = NULL;
							cexpr = (_tmp154 = (_tmp153 = (ValaCCodeExpression*) crefcomma, (_tmp153 == NULL) ? NULL : vala_ccode_node_ref (_tmp153)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp154);
							(crefcomma == NULL) ? NULL : (crefcomma = (vala_ccode_node_unref (crefcomma), NULL));
						}
						/* call function*/
						ret_temp_var = NULL;
						_tmp155 = NULL;
						if ((_tmp156 = VALA_IS_VOID_TYPE (_tmp155 = vala_data_type_get_return_type (itype)), (_tmp155 == NULL) ? NULL : (_tmp155 = (vala_code_node_unref (_tmp155), NULL)), _tmp156)) {
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						} else {
							ValaLocalVariable* _tmp158;
							ValaDataType* _tmp157;
							ValaCCodeAssignment* _tmp160;
							ValaCCodeExpression* _tmp159;
							_tmp158 = NULL;
							_tmp157 = NULL;
							ret_temp_var = (_tmp158 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp157 = vala_data_type_get_return_type (itype), TRUE, NULL), (ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL)), _tmp158);
							(_tmp157 == NULL) ? NULL : (_tmp157 = (vala_code_node_unref (_tmp157), NULL));
							gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, ret_temp_var);
							_tmp160 = NULL;
							_tmp159 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp160 = vala_ccode_assignment_new (_tmp159 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) ret_temp_var)), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp160 == NULL) ? NULL : (_tmp160 = (vala_ccode_node_unref (_tmp160), NULL));
							(_tmp159 == NULL) ? NULL : (_tmp159 = (vala_ccode_node_unref (_tmp159), NULL));
						}
						cassign_comma = vala_ccode_comma_expression_new ();
						assign_temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, assign_temp_var);
						_tmp164 = NULL;
						_tmp163 = NULL;
						_tmp162 = NULL;
						_tmp161 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, (ValaCCodeExpression*) (_tmp164 = vala_ccode_assignment_new (_tmp161 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) assign_temp_var)), _tmp163 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, _tmp162 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp164 == NULL) ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL));
						(_tmp163 == NULL) ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL));
						(_tmp162 == NULL) ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL));
						(_tmp161 == NULL) ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL));
						/* unref old value*/
						_tmp165 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp165 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), vala_expression_get_value_type (arg), arg));
						(_tmp165 == NULL) ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL));
						_tmp166 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp166 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) assign_temp_var)));
						(_tmp166 == NULL) ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL));
						/* assign new value*/
						_tmp167 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp167 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), (ValaCCodeExpression*) cassign_comma, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp167 == NULL) ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL));
						/* return value*/
						_tmp168 = NULL;
						if ((_tmp169 = !(VALA_IS_VOID_TYPE (_tmp168 = vala_data_type_get_return_type (itype))), (_tmp168 == NULL) ? NULL : (_tmp168 = (vala_code_node_unref (_tmp168), NULL)), _tmp169)) {
							ValaCCodeExpression* _tmp170;
							_tmp170 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, _tmp170 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) ret_temp_var)));
							(_tmp170 == NULL) ? NULL : (_tmp170 = (vala_ccode_node_unref (_tmp170), NULL));
						}
						_tmp172 = NULL;
						_tmp171 = NULL;
						ccall_expr = (_tmp172 = (_tmp171 = (ValaCCodeExpression*) ccomma, (_tmp171 == NULL) ? NULL : vala_ccode_node_ref (_tmp171)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp172);
						(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL));
						(cassign_comma == NULL) ? NULL : (cassign_comma = (vala_ccode_node_unref (cassign_comma), NULL));
						(assign_temp_var == NULL) ? NULL : (assign_temp_var = (vala_code_node_unref (assign_temp_var), NULL));
					}
					if (vala_formal_parameter_get_ctype (param) != NULL) {
						ValaCCodeExpression* _tmp173;
						_tmp173 = NULL;
						cexpr = (_tmp173 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, vala_formal_parameter_get_ctype (param)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp173);
					}
				}
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			} else {
				/* default argument position*/
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) i, ellipsis);
			}
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (arg_pos), cexpr);
			i++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
			(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	if (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		gboolean _tmp174;
		param = (ValaFormalParameter*) gee_iterator_get (params_it);
		_tmp174 = FALSE;
		if (vala_formal_parameter_get_params_array (param)) {
			_tmp174 = TRUE;
		} else {
			_tmp174 = vala_formal_parameter_get_ellipsis (param);
		}
		/* if there are more parameters than arguments,
		 * the additional parameter is an ellipsis parameter
		 * otherwise there is a bug in the semantic analyzer
		 */
		g_assert (_tmp174);
		ellipsis = TRUE;
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
	}
	_tmp175 = FALSE;
	if (m != NULL) {
		_tmp175 = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp175 = FALSE;
	}
	/* add length argument for methods returning arrays */
	if (_tmp175) {
		ValaArrayType* _tmp176;
		ValaArrayType* array_type;
		_tmp176 = NULL;
		array_type = (_tmp176 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp176 == NULL) ? NULL : vala_code_node_ref (_tmp176));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (vala_method_get_array_null_terminated (m)) {
					ValaDataType* _tmp177;
					ValaLocalVariable* _tmp178;
					ValaLocalVariable* temp_var;
					ValaCCodeExpression* temp_ref;
					ValaCCodeExpression* _tmp179;
					ValaCCodeIdentifier* _tmp180;
					ValaCCodeFunctionCall* _tmp181;
					ValaCCodeFunctionCall* len_call;
					/* handle calls to methods returning null-terminated arrays*/
					_tmp177 = NULL;
					_tmp178 = NULL;
					temp_var = (_tmp178 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp177 = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp177 == NULL) ? NULL : (_tmp177 = (vala_code_node_unref (_tmp177), NULL)), _tmp178);
					temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp179 = NULL;
					ccall_expr = (_tmp179 = (ValaCCodeExpression*) vala_ccode_assignment_new (temp_ref, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp179);
					((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
					_tmp180 = NULL;
					_tmp181 = NULL;
					len_call = (_tmp181 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp180 = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp180 == NULL) ? NULL : (_tmp180 = (vala_ccode_node_unref (_tmp180), NULL)), _tmp181);
					vala_ccode_function_call_add_argument (len_call, temp_ref);
					vala_method_call_append_array_size (expr, (ValaCCodeExpression*) len_call);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
					(len_call == NULL) ? NULL : (len_call = (vala_ccode_node_unref (len_call), NULL));
				} else {
					if (!vala_method_get_no_array_length (m)) {
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* temp_ref;
						ValaCCodeUnaryExpression* _tmp182;
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
						temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp182 = NULL;
						gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp182 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
						(_tmp182 == NULL) ? NULL : (_tmp182 = (vala_ccode_node_unref (_tmp182), NULL));
						vala_method_call_append_array_size (expr, temp_ref);
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
					} else {
						ValaCCodeConstant* _tmp183;
						_tmp183 = NULL;
						vala_method_call_append_array_size (expr, (ValaCCodeExpression*) (_tmp183 = vala_ccode_constant_new ("-1")));
						(_tmp183 == NULL) ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL));
					}
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		gboolean _tmp184;
		_tmp184 = FALSE;
		if (m != NULL) {
			_tmp184 = VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m));
		} else {
			_tmp184 = FALSE;
		}
		if (_tmp184) {
			ValaDelegateType* _tmp185;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp186;
			ValaDelegate* d;
			_tmp185 = NULL;
			deleg_type = (_tmp185 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp185 == NULL) ? NULL : vala_code_node_ref (_tmp185));
			_tmp186 = NULL;
			d = (_tmp186 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp186 == NULL) ? NULL : vala_code_node_ref (_tmp186));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp188;
				ValaVoidType* _tmp187;
				ValaLocalVariable* _tmp189;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp190;
				_tmp188 = NULL;
				_tmp187 = NULL;
				_tmp189 = NULL;
				temp_var = (_tmp189 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp188 = vala_pointer_type_new ((ValaDataType*) (_tmp187 = vala_void_type_new (NULL)), NULL)), TRUE, NULL), (_tmp188 == NULL) ? NULL : (_tmp188 = (vala_code_node_unref (_tmp188), NULL)), (_tmp187 == NULL) ? NULL : (_tmp187 = (vala_code_node_unref (_tmp187), NULL)), _tmp189);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp190 = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp190 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp190 == NULL) ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL));
				vala_method_call_set_delegate_target (expr, temp_ref);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp191 = FALSE;
	if (m != NULL) {
		_tmp191 = vala_method_get_coroutine (m);
	} else {
		_tmp191 = FALSE;
	}
	if (_tmp191) {
		gboolean _tmp192;
		gboolean _tmp193;
		_tmp192 = FALSE;
		_tmp193 = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp193 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp193 = FALSE;
		}
		if ((_tmp193)) {
			_tmp192 = TRUE;
		} else {
			gboolean _tmp194;
			_tmp194 = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp194 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp194 = FALSE;
			}
			_tmp192 = (_tmp194);
		}
		if (_tmp192) {
			gboolean _tmp195;
			_tmp195 = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp195 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp195 = FALSE;
			}
			/* asynchronous call*/
			if (_tmp195) {
				ValaCCodeConstant* _tmp196;
				ValaCCodeConstant* _tmp197;
				_tmp196 = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp196 = vala_ccode_constant_new ("NULL")));
				(_tmp196 == NULL) ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL));
				_tmp197 = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp197 = vala_ccode_constant_new ("NULL")));
				(_tmp197 == NULL) ? NULL : (_tmp197 = (vala_ccode_node_unref (_tmp197), NULL));
			} else {
				ValaCCodeIdentifier* _tmp200;
				char* _tmp199;
				char* _tmp198;
				ValaCCodeIdentifier* _tmp201;
				_tmp200 = NULL;
				_tmp199 = NULL;
				_tmp198 = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp200 = vala_ccode_identifier_new (_tmp199 = g_strconcat (_tmp198 = vala_method_get_cname (((ValaCCodeBaseModule*) self)->current_method), "_ready", NULL))));
				(_tmp200 == NULL) ? NULL : (_tmp200 = (vala_ccode_node_unref (_tmp200), NULL));
				_tmp199 = (g_free (_tmp199), NULL);
				_tmp198 = (g_free (_tmp198), NULL);
				_tmp201 = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp201 = vala_ccode_identifier_new ("data")));
				(_tmp201 == NULL) ? NULL : (_tmp201 = (vala_ccode_node_unref (_tmp201), NULL));
			}
		}
	}
	_tmp202 = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		GeeList* _tmp203;
		_tmp203 = NULL;
		_tmp202 = gee_collection_get_size ((GeeCollection*) (_tmp203 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0;
		(_tmp203 == NULL) ? NULL : (_tmp203 = (gee_collection_object_unref (_tmp203), NULL));
	} else {
		_tmp202 = FALSE;
	}
	if (_tmp202) {
		ValaCCodeIdentifier* _tmp204;
		_tmp204 = NULL;
		gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp204 = vala_ccode_identifier_new ("error")));
		(_tmp204 == NULL) ? NULL : (_tmp204 = (vala_ccode_node_unref (_tmp204), NULL));
	} else {
		if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr)) {
			ValaCCodeUnaryExpression* _tmp206;
			ValaCCodeExpression* _tmp205;
			/* method can fail*/
			((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
			/* add &inner_error before the ellipsis arguments*/
			_tmp206 = NULL;
			_tmp205 = NULL;
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp206 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp205 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "inner_error"))));
			(_tmp206 == NULL) ? NULL : (_tmp206 = (vala_ccode_node_unref (_tmp206), NULL));
			(_tmp205 == NULL) ? NULL : (_tmp205 = (vala_ccode_node_unref (_tmp205), NULL));
		}
	}
	if (ellipsis) {
		gboolean _tmp207;
		_tmp207 = FALSE;
		if (!vala_method_get_printf_format (m)) {
			_tmp207 = _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0;
		} else {
			_tmp207 = FALSE;
		}
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if (_tmp207) {
			ValaCCodeConstant* _tmp208;
			_tmp208 = NULL;
			gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp208 = vala_ccode_constant_new (vala_method_get_sentinel (m))));
			(_tmp208 == NULL) ? NULL : (_tmp208 = (vala_ccode_node_unref (_tmp208), NULL));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp209;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp210;
			ValaDelegate* d;
			_tmp209 = NULL;
			deleg_type = (_tmp209 = VALA_DELEGATE_TYPE (itype), (_tmp209 == NULL) ? NULL : vala_code_node_ref (_tmp209));
			_tmp210 = NULL;
			d = (_tmp210 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp210 == NULL) ? NULL : vala_code_node_ref (_tmp210));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp211;
				ValaCCodeExpression* _tmp212;
				_tmp211 = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp211 = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp211 == NULL) ? NULL : (_tmp211 = (vala_ccode_node_unref (_tmp211), NULL));
				_tmp212 = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp212 = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp212 == NULL) ? NULL : (_tmp212 = (vala_ccode_node_unref (_tmp212), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp213 = FALSE;
	if (VALA_IS_SIGNAL_TYPE (itype)) {
		ValaDataType* _tmp214;
		_tmp214 = NULL;
		_tmp213 = !(VALA_IS_VOID_TYPE (_tmp214 = vala_data_type_get_return_type (itype)));
		(_tmp214 == NULL) ? NULL : (_tmp214 = (vala_code_node_unref (_tmp214), NULL));
	} else {
		_tmp213 = FALSE;
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	if (_tmp213) {
		ValaSignal* _tmp215;
		ValaSignal* sig;
		gboolean _tmp216;
		gboolean _tmp217;
		_tmp215 = NULL;
		sig = (_tmp215 = vala_signal_type_get_signal_symbol ((VALA_SIGNAL_TYPE (itype))), (_tmp215 == NULL) ? NULL : vala_code_node_ref (_tmp215));
		_tmp216 = FALSE;
		_tmp217 = FALSE;
		if (ma != NULL) {
			_tmp217 = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
		} else {
			_tmp217 = FALSE;
		}
		if (_tmp217) {
			_tmp216 = vala_signal_get_is_virtual (sig);
		} else {
			_tmp216 = FALSE;
		}
		if (_tmp216) {
		} else {
			if (!vala_signal_get_has_emitter (sig)) {
				ValaDataType* _tmp218;
				ValaLocalVariable* _tmp219;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp220;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp222;
				ValaCCodeExpression* _tmp221;
				_tmp218 = NULL;
				_tmp219 = NULL;
				temp_var = (_tmp219 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp218 = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp218 == NULL) ? NULL : (_tmp218 = (vala_code_node_unref (_tmp218), NULL)), _tmp219);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp220 = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp220 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp220 == NULL) ? NULL : (_tmp220 = (vala_ccode_node_unref (_tmp220), NULL));
				ccomma = vala_ccode_comma_expression_new ();
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
				_tmp222 = NULL;
				_tmp221 = NULL;
				ccall_expr = (_tmp222 = (_tmp221 = (ValaCCodeExpression*) ccomma, (_tmp221 == NULL) ? NULL : vala_ccode_node_ref (_tmp221)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp222);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
	}
	/* append C arguments in the right order*/
	last_pos = 0;
	min_pos = 0;
	if (async_call != ccall) {
		/* don't append out arguments for .begin() calls*/
		last_pos = -1;
		while (TRUE) {
			ValaCCodeExpression* _tmp227;
			min_pos = -1;
			{
				GeeSet* _tmp223;
				GeeIterator* _tmp224;
				GeeIterator* _pos_it;
				_tmp223 = NULL;
				_tmp224 = NULL;
				_pos_it = (_tmp224 = gee_iterable_iterator ((GeeIterable*) (_tmp223 = gee_map_get_keys ((GeeMap*) out_arg_map))), (_tmp223 == NULL) ? NULL : (_tmp223 = (gee_collection_object_unref (_tmp223), NULL)), _tmp224);
				while (gee_iterator_next (_pos_it)) {
					gint pos;
					gboolean _tmp225;
					pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
					_tmp225 = FALSE;
					if (pos > last_pos) {
						gboolean _tmp226;
						_tmp226 = FALSE;
						if (min_pos == (-1)) {
							_tmp226 = TRUE;
						} else {
							_tmp226 = pos < min_pos;
						}
						_tmp225 = (_tmp226);
					} else {
						_tmp225 = FALSE;
					}
					if (_tmp225) {
						min_pos = pos;
					}
				}
				(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
			}
			if (min_pos == (-1)) {
				break;
			}
			_tmp227 = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp227 = (ValaCCodeExpression*) gee_map_get ((GeeMap*) out_arg_map, GINT_TO_POINTER (min_pos)));
			(_tmp227 == NULL) ? NULL : (_tmp227 = (vala_ccode_node_unref (_tmp227), NULL));
			last_pos = min_pos;
		}
	}
	if (async_call != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeExpression* _tmp232;
			min_pos = -1;
			{
				GeeSet* _tmp228;
				GeeIterator* _tmp229;
				GeeIterator* _pos_it;
				_tmp228 = NULL;
				_tmp229 = NULL;
				_pos_it = (_tmp229 = gee_iterable_iterator ((GeeIterable*) (_tmp228 = gee_map_get_keys ((GeeMap*) in_arg_map))), (_tmp228 == NULL) ? NULL : (_tmp228 = (gee_collection_object_unref (_tmp228), NULL)), _tmp229);
				while (gee_iterator_next (_pos_it)) {
					gint pos;
					gboolean _tmp230;
					pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
					_tmp230 = FALSE;
					if (pos > last_pos) {
						gboolean _tmp231;
						_tmp231 = FALSE;
						if (min_pos == (-1)) {
							_tmp231 = TRUE;
						} else {
							_tmp231 = pos < min_pos;
						}
						_tmp230 = (_tmp231);
					} else {
						_tmp230 = FALSE;
					}
					if (_tmp230) {
						min_pos = pos;
					}
				}
				(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
			}
			if (min_pos == (-1)) {
				break;
			}
			_tmp232 = NULL;
			vala_ccode_function_call_add_argument (async_call, _tmp232 = (ValaCCodeExpression*) gee_map_get ((GeeMap*) in_arg_map, GINT_TO_POINTER (min_pos)));
			(_tmp232 == NULL) ? NULL : (_tmp232 = (vala_ccode_node_unref (_tmp232), NULL));
			last_pos = min_pos;
		}
	}
	_tmp233 = FALSE;
	_tmp234 = FALSE;
	if (m != NULL) {
		_tmp234 = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp234 = FALSE;
	}
	if (_tmp234) {
		_tmp233 = vala_method_get_returns_modified_pointer (m);
	} else {
		_tmp233 = FALSE;
	}
	if (_tmp233) {
		ValaCCodeAssignment* _tmp235;
		_tmp235 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp235 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp235 == NULL) ? NULL : (_tmp235 = (vala_ccode_node_unref (_tmp235), NULL));
	} else {
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall_expr);
	}
	_tmp236 = FALSE;
	_tmp237 = FALSE;
	_tmp238 = FALSE;
	if (m != NULL) {
		_tmp238 = vala_method_get_coroutine (m);
	} else {
		_tmp238 = FALSE;
	}
	if (_tmp238) {
		_tmp237 = ((ValaCCodeBaseModule*) self)->current_method != NULL;
	} else {
		_tmp237 = FALSE;
	}
	if (_tmp237) {
		_tmp236 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	} else {
		_tmp236 = FALSE;
	}
	if (_tmp236) {
		gboolean _tmp239;
		_tmp239 = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0) {
			_tmp239 = TRUE;
		} else {
			_tmp239 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) != vala_expression_get_symbol_reference ((ValaExpression*) ma);
		}
		if (_tmp239) {
			ValaCCodeExpressionStatement* _tmp241;
			gint state;
			ValaCCodeExpressionStatement* _tmp247;
			ValaCCodeAssignment* _tmp246;
			ValaCCodeConstant* _tmp245;
			char* _tmp244;
			ValaCCodeMemberAccess* _tmp243;
			ValaCCodeIdentifier* _tmp242;
			ValaCCodeReturnStatement* _tmp249;
			ValaCCodeConstant* _tmp248;
			ValaCCodeCaseStatement* _tmp252;
			ValaCCodeConstant* _tmp251;
			char* _tmp250;
			if (((ValaCCodeBaseModule*) self)->pre_statement_fragment == NULL) {
				ValaCCodeFragment* _tmp240;
				_tmp240 = NULL;
				((ValaCCodeBaseModule*) self)->pre_statement_fragment = (_tmp240 = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->pre_statement_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->pre_statement_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->pre_statement_fragment), NULL)), _tmp240);
			}
			_tmp241 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp241 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) async_call)));
			(_tmp241 == NULL) ? NULL : (_tmp241 = (vala_ccode_node_unref (_tmp241), NULL));
			state = ((ValaCCodeBaseModule*) self)->next_coroutine_state++;
			_tmp247 = NULL;
			_tmp246 = NULL;
			_tmp245 = NULL;
			_tmp244 = NULL;
			_tmp243 = NULL;
			_tmp242 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp247 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp246 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp243 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp242 = vala_ccode_identifier_new ("data")), "state")), (ValaCCodeExpression*) (_tmp245 = vala_ccode_constant_new (_tmp244 = g_strdup_printf ("%i", state))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp247 == NULL) ? NULL : (_tmp247 = (vala_ccode_node_unref (_tmp247), NULL));
			(_tmp246 == NULL) ? NULL : (_tmp246 = (vala_ccode_node_unref (_tmp246), NULL));
			(_tmp245 == NULL) ? NULL : (_tmp245 = (vala_ccode_node_unref (_tmp245), NULL));
			_tmp244 = (g_free (_tmp244), NULL);
			(_tmp243 == NULL) ? NULL : (_tmp243 = (vala_ccode_node_unref (_tmp243), NULL));
			(_tmp242 == NULL) ? NULL : (_tmp242 = (vala_ccode_node_unref (_tmp242), NULL));
			_tmp249 = NULL;
			_tmp248 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp249 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp248 = vala_ccode_constant_new ("FALSE")))));
			(_tmp249 == NULL) ? NULL : (_tmp249 = (vala_ccode_node_unref (_tmp249), NULL));
			(_tmp248 == NULL) ? NULL : (_tmp248 = (vala_ccode_node_unref (_tmp248), NULL));
			_tmp252 = NULL;
			_tmp251 = NULL;
			_tmp250 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp252 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp251 = vala_ccode_constant_new (_tmp250 = g_strdup_printf ("%i", state))))));
			(_tmp252 == NULL) ? NULL : (_tmp252 = (vala_ccode_node_unref (_tmp252), NULL));
			(_tmp251 == NULL) ? NULL : (_tmp251 = (vala_ccode_node_unref (_tmp251), NULL));
			_tmp250 = (g_free (_tmp250), NULL);
		}
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp253;
		GeeIterator* _tmp254;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp256;
		ValaExpression* _tmp255;
		ValaCCodeExpression* _tmp257;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeExpression* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp258;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp259;
		ValaArrayType* array_type;
		char* _tmp261;
		char* _tmp260;
		ValaCCodeIdentifier* _tmp262;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp263;
		ValaCCodeFunctionCall* _tmp264;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp265;
		ValaCCodeConstant* _tmp266;
		ValaCCodeBinaryExpression* _tmp267;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp268;
		ValaCCodeConditionalExpression* _tmp270;
		ValaCCodeConstant* _tmp269;
		ValaCCodeAssignment* _tmp272;
		ValaCCodeExpression* _tmp271;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp253 = NULL;
		_tmp254 = NULL;
		arg_it = (_tmp254 = gee_iterable_iterator ((GeeIterable*) (_tmp253 = vala_method_call_get_argument_list (expr))), (_tmp253 == NULL) ? NULL : (_tmp253 = (gee_collection_object_unref (_tmp253), NULL)), _tmp254);
		gee_iterator_next (arg_it);
		_tmp256 = NULL;
		_tmp255 = NULL;
		_tmp257 = NULL;
		new_size = (_tmp257 = (_tmp256 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp255 = (ValaExpression*) gee_iterator_get (arg_it)))), (_tmp256 == NULL) ? NULL : vala_ccode_node_ref (_tmp256)), (_tmp255 == NULL) ? NULL : (_tmp255 = (vala_code_node_unref (_tmp255), NULL)), _tmp257);
		temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
		temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
		/* memset needs string.h */
		((ValaCCodeBaseModule*) self)->string_h_needed = TRUE;
		clen = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1);
		_tmp258 = NULL;
		celems = (_tmp258 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp258 == NULL) ? NULL : vala_ccode_node_ref (_tmp258));
		_tmp259 = NULL;
		array_type = (_tmp259 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp259 == NULL) ? NULL : vala_code_node_ref (_tmp259));
		_tmp261 = NULL;
		_tmp260 = NULL;
		_tmp262 = NULL;
		csizeof = (_tmp262 = vala_ccode_identifier_new (_tmp261 = g_strdup_printf ("sizeof (%s)", _tmp260 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))), _tmp261 = (g_free (_tmp261), NULL), _tmp260 = (g_free (_tmp260), NULL), _tmp262);
		cdelta = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, temp_ref, clen);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, temp_ref, clen);
		_tmp263 = NULL;
		_tmp264 = NULL;
		czero = (_tmp264 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp263 = vala_ccode_identifier_new ("memset"))), (_tmp263 == NULL) ? NULL : (_tmp263 = (vala_ccode_node_unref (_tmp263), NULL)), _tmp264);
		_tmp265 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp265 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen)));
		(_tmp265 == NULL) ? NULL : (_tmp265 = (vala_ccode_node_unref (_tmp265), NULL));
		_tmp266 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp266 = vala_ccode_constant_new ("0")));
		(_tmp266 == NULL) ? NULL : (_tmp266 = (vala_ccode_node_unref (_tmp266), NULL));
		_tmp267 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp267 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) csizeof, (ValaCCodeExpression*) cdelta)));
		(_tmp267 == NULL) ? NULL : (_tmp267 = (vala_ccode_node_unref (_tmp267), NULL));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp268 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp268 = vala_ccode_assignment_new (temp_ref, new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp268 == NULL) ? NULL : (_tmp268 = (vala_ccode_node_unref (_tmp268), NULL));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
		_tmp270 = NULL;
		_tmp269 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp270 = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccheck, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) (_tmp269 = vala_ccode_constant_new ("NULL")))));
		(_tmp270 == NULL) ? NULL : (_tmp270 = (vala_ccode_node_unref (_tmp270), NULL));
		(_tmp269 == NULL) ? NULL : (_tmp269 = (vala_ccode_node_unref (_tmp269), NULL));
		_tmp272 = NULL;
		_tmp271 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp272 = vala_ccode_assignment_new (_tmp271 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1), temp_ref, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp272 == NULL) ? NULL : (_tmp272 = (vala_ccode_node_unref (_tmp272), NULL));
		(_tmp271 == NULL) ? NULL : (_tmp271 = (vala_ccode_node_unref (_tmp271), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
		(new_size == NULL) ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
		(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
		(clen == NULL) ? NULL : (clen = (vala_ccode_node_unref (clen), NULL));
		(celems == NULL) ? NULL : (celems = (vala_ccode_node_unref (celems), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
		(cdelta == NULL) ? NULL : (cdelta = (vala_ccode_node_unref (cdelta), NULL));
		(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
		(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	}
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(itype == NULL) ? NULL : (itype = (vala_code_node_unref (itype), NULL));
	(in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL));
	(out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL));
	(ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL));
	(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
	(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
}


static void vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass) {
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_ccode_method_call_module_real_visit_method_call;
}


static void vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self) {
}


GType vala_ccode_method_call_module_get_type (void) {
	static GType vala_ccode_method_call_module_type_id = 0;
	if (vala_ccode_method_call_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_call_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




