/* valaenumvaluetype.vala
 *
 * Copyright (C) 2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaenumvaluetype.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>




enum  {
	VALA_ENUM_VALUE_TYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_enum_value_type_real_copy (ValaDataType* base);
static gpointer vala_enum_value_type_parent_class = NULL;



ValaEnumValueType* vala_enum_value_type_construct (GType object_type, ValaEnum* type_symbol) {
	ValaEnumValueType* self;
	g_return_val_if_fail (type_symbol != NULL, NULL);
	self = (ValaEnumValueType*) vala_value_type_construct (object_type, (ValaTypeSymbol*) type_symbol);
	return self;
}


ValaEnumValueType* vala_enum_value_type_new (ValaEnum* type_symbol) {
	return vala_enum_value_type_construct (VALA_TYPE_ENUM_VALUE_TYPE, type_symbol);
}


static ValaDataType* vala_enum_value_type_real_copy (ValaDataType* base) {
	ValaEnumValueType * self;
	ValaEnumValueType* result;
	self = (ValaEnumValueType*) base;
	result = vala_enum_value_type_new (VALA_ENUM (vala_value_type_get_type_symbol ((ValaValueType*) self)));
	vala_code_node_set_source_reference ((ValaCodeNode*) result, vala_code_node_get_source_reference ((ValaCodeNode*) self));
	vala_data_type_set_value_owned ((ValaDataType*) result, vala_data_type_get_value_owned ((ValaDataType*) self));
	vala_data_type_set_nullable ((ValaDataType*) result, vala_data_type_get_nullable ((ValaDataType*) self));
	return (ValaDataType*) result;
}


static void vala_enum_value_type_class_init (ValaEnumValueTypeClass * klass) {
	vala_enum_value_type_parent_class = g_type_class_peek_parent (klass);
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_enum_value_type_real_copy;
}


static void vala_enum_value_type_instance_init (ValaEnumValueType * self) {
}


GType vala_enum_value_type_get_type (void) {
	static GType vala_enum_value_type_type_id = 0;
	if (vala_enum_value_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaEnumValueTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_enum_value_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaEnumValueType), 0, (GInstanceInitFunc) vala_enum_value_type_instance_init, NULL };
		vala_enum_value_type_type_id = g_type_register_static (VALA_TYPE_VALUE_TYPE, "ValaEnumValueType", &g_define_type_info, 0);
	}
	return vala_enum_value_type_type_id;
}




