/* valaswitchsection.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaswitchsection.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaswitchlabel.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valastatement.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valasymbol.h>
#include <vala/valalocalvariable.h>




struct _ValaSwitchSectionPrivate {
	GeeList* labels;
};

#define VALA_SWITCH_SECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionPrivate))
enum  {
	VALA_SWITCH_SECTION_DUMMY_PROPERTY
};
static void vala_switch_section_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_switch_section_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_switch_section_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_switch_section_parent_class = NULL;
static void vala_switch_section_finalize (ValaCodeNode* obj);



/**
 * Creates a new switch section.
 *
 * @param source_reference reference to source code
 * @return                 newly created switch section
 */
ValaSwitchSection* vala_switch_section_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaSwitchSection* self;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaSwitchSection*) vala_block_construct (object_type, source_reference);
	return self;
}


ValaSwitchSection* vala_switch_section_new (ValaSourceReference* source_reference) {
	return vala_switch_section_construct (VALA_TYPE_SWITCH_SECTION, source_reference);
}


/**
 * Appends the specified label to the list of switch labels.
 *
 * @param label a switch label
 */
void vala_switch_section_add_label (ValaSwitchSection* self, ValaSwitchLabel* label) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	gee_collection_add ((GeeCollection*) self->priv->labels, label);
}


/**
 * Returns a copy of the list of switch labels.
 *
 * @return switch label list
 */
GeeList* vala_switch_section_get_labels (ValaSwitchSection* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return (GeeList*) gee_read_only_list_new (VALA_TYPE_SWITCH_LABEL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->labels);
}


gboolean vala_switch_section_has_default_label (ValaSwitchSection* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeIterator* _label_it;
		_label_it = gee_iterable_iterator ((GeeIterable*) self->priv->labels);
		while (gee_iterator_next (_label_it)) {
			ValaSwitchLabel* label;
			label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
			if (vala_switch_label_get_expression (label) == NULL) {
				gboolean _tmp0;
				return (_tmp0 = TRUE, (label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL)), (_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL)), _tmp0);
			}
			(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
		}
		(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
	}
	return FALSE;
}


static void vala_switch_section_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_switch_section (visitor, self);
}


static void vala_switch_section_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (visitor != NULL);
	{
		GeeIterator* _label_it;
		_label_it = gee_iterable_iterator ((GeeIterable*) self->priv->labels);
		while (gee_iterator_next (_label_it)) {
			ValaSwitchLabel* label;
			label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
			vala_code_node_accept ((ValaCodeNode*) label, visitor);
			(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
		}
		(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
	}
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _st_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_st_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_block_get_statements ((ValaBlock*) self))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_st_it)) {
			ValaStatement* st;
			st = (ValaStatement*) gee_iterator_get (_st_it);
			vala_code_node_accept ((ValaCodeNode*) st, visitor);
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		(_st_it == NULL) ? NULL : (_st_it = (gee_collection_object_unref (_st_it), NULL));
	}
}


static gboolean vala_switch_section_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaSwitchSection * self;
	ValaSymbol* _tmp3;
	ValaSymbol* old_symbol;
	ValaBlock* _tmp4;
	ValaBlock* old_insert_block;
	ValaBlock* _tmp6;
	ValaBlock* _tmp5;
	ValaBlock* _tmp12;
	ValaBlock* _tmp11;
	gboolean _tmp13;
	self = (ValaSwitchSection*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	{
		GeeList* _tmp1;
		GeeIterator* _tmp2;
		GeeIterator* _label_it;
		_tmp1 = NULL;
		_tmp2 = NULL;
		_label_it = (_tmp2 = gee_iterable_iterator ((GeeIterable*) (_tmp1 = vala_switch_section_get_labels (self))), (_tmp1 == NULL) ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL)), _tmp2);
		while (gee_iterator_next (_label_it)) {
			ValaSwitchLabel* label;
			label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
			vala_code_node_check ((ValaCodeNode*) label, analyzer);
			(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
		}
		(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
	}
	vala_symbol_set_owner ((ValaSymbol*) self, vala_symbol_get_scope (vala_semantic_analyzer_get_current_symbol (analyzer)));
	_tmp3 = NULL;
	old_symbol = (_tmp3 = vala_semantic_analyzer_get_current_symbol (analyzer), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	_tmp4 = NULL;
	old_insert_block = (_tmp4 = analyzer->insert_block, (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	_tmp6 = NULL;
	_tmp5 = NULL;
	analyzer->insert_block = (_tmp6 = (_tmp5 = (ValaBlock*) self, (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5)), (analyzer->insert_block == NULL) ? NULL : (analyzer->insert_block = (vala_code_node_unref (analyzer->insert_block), NULL)), _tmp6);
	{
		GeeList* _tmp7;
		GeeIterator* _tmp8;
		GeeIterator* _st_it;
		_tmp7 = NULL;
		_tmp8 = NULL;
		_st_it = (_tmp8 = gee_iterable_iterator ((GeeIterable*) (_tmp7 = vala_block_get_statements ((ValaBlock*) self))), (_tmp7 == NULL) ? NULL : (_tmp7 = (gee_collection_object_unref (_tmp7), NULL)), _tmp8);
		while (gee_iterator_next (_st_it)) {
			ValaStatement* st;
			st = (ValaStatement*) gee_iterator_get (_st_it);
			vala_code_node_check ((ValaCodeNode*) st, analyzer);
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		(_st_it == NULL) ? NULL : (_st_it = (gee_collection_object_unref (_st_it), NULL));
	}
	{
		GeeList* _tmp9;
		GeeIterator* _tmp10;
		GeeIterator* _local_it;
		_tmp9 = NULL;
		_tmp10 = NULL;
		_local_it = (_tmp10 = gee_iterable_iterator ((GeeIterable*) (_tmp9 = vala_block_get_local_variables ((ValaBlock*) self))), (_tmp9 == NULL) ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL)), _tmp10);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			vala_symbol_set_active ((ValaSymbol*) local, FALSE);
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	_tmp12 = NULL;
	_tmp11 = NULL;
	analyzer->insert_block = (_tmp12 = (_tmp11 = old_insert_block, (_tmp11 == NULL) ? NULL : vala_code_node_ref (_tmp11)), (analyzer->insert_block == NULL) ? NULL : (analyzer->insert_block = (vala_code_node_unref (analyzer->insert_block), NULL)), _tmp12);
	return (_tmp13 = !vala_code_node_get_error ((ValaCodeNode*) self), (old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)), (old_insert_block == NULL) ? NULL : (old_insert_block = (vala_code_node_unref (old_insert_block), NULL)), _tmp13);
}


static void vala_switch_section_class_init (ValaSwitchSectionClass * klass) {
	vala_switch_section_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_switch_section_finalize;
	g_type_class_add_private (klass, sizeof (ValaSwitchSectionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_switch_section_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_switch_section_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->check = vala_switch_section_real_check;
}


static void vala_switch_section_instance_init (ValaSwitchSection * self) {
	self->priv = VALA_SWITCH_SECTION_GET_PRIVATE (self);
	self->priv->labels = (GeeList*) gee_array_list_new (VALA_TYPE_SWITCH_LABEL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_switch_section_finalize (ValaCodeNode* obj) {
	ValaSwitchSection * self;
	self = VALA_SWITCH_SECTION (obj);
	(self->priv->labels == NULL) ? NULL : (self->priv->labels = (gee_collection_object_unref (self->priv->labels), NULL));
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->finalize (obj);
}


GType vala_switch_section_get_type (void) {
	static GType vala_switch_section_type_id = 0;
	if (vala_switch_section_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchSection), 0, (GInstanceInitFunc) vala_switch_section_instance_init, NULL };
		vala_switch_section_type_id = g_type_register_static (VALA_TYPE_BLOCK, "ValaSwitchSection", &g_define_type_info, 0);
	}
	return vala_switch_section_type_id;
}




