/* valadbusclientmodule.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
*  Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;
typedef struct _ValaGObjectModulePrivate ValaGObjectModulePrivate;

#define VALA_TYPE_GSIGNAL_MODULE (vala_gsignal_module_get_type ())
#define VALA_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule))
#define VALA_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))
#define VALA_IS_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_IS_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_GSIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))

typedef struct _ValaGSignalModule ValaGSignalModule;
typedef struct _ValaGSignalModuleClass ValaGSignalModuleClass;
typedef struct _ValaGSignalModulePrivate ValaGSignalModulePrivate;

#define VALA_TYPE_GASYNC_MODULE (vala_gasync_module_get_type ())
#define VALA_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModule))
#define VALA_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))
#define VALA_IS_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GASYNC_MODULE))
#define VALA_IS_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GASYNC_MODULE))
#define VALA_GASYNC_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))

typedef struct _ValaGAsyncModule ValaGAsyncModule;
typedef struct _ValaGAsyncModuleClass ValaGAsyncModuleClass;
typedef struct _ValaGAsyncModulePrivate ValaGAsyncModulePrivate;

#define VALA_TYPE_DBUS_MODULE (vala_dbus_module_get_type ())
#define VALA_DBUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_MODULE, ValaDBusModule))
#define VALA_DBUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_MODULE, ValaDBusModuleClass))
#define VALA_IS_DBUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_MODULE))
#define VALA_IS_DBUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_MODULE))
#define VALA_DBUS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_MODULE, ValaDBusModuleClass))

typedef struct _ValaDBusModule ValaDBusModule;
typedef struct _ValaDBusModuleClass ValaDBusModuleClass;
typedef struct _ValaDBusModulePrivate ValaDBusModulePrivate;

#define VALA_TYPE_DBUS_CLIENT_MODULE (vala_dbus_client_module_get_type ())
#define VALA_DBUS_CLIENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModule))
#define VALA_DBUS_CLIENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModuleClass))
#define VALA_IS_DBUS_CLIENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_CLIENT_MODULE))
#define VALA_IS_DBUS_CLIENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_CLIENT_MODULE))
#define VALA_DBUS_CLIENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModuleClass))

typedef struct _ValaDBusClientModule ValaDBusClientModule;
typedef struct _ValaDBusClientModuleClass ValaDBusClientModuleClass;
typedef struct _ValaDBusClientModulePrivate ValaDBusClientModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	GeeSet* c_keywords;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	ValaCCodeStatement* (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
};

struct _ValaGObjectModule {
	ValaGTypeModule parent_instance;
	ValaGObjectModulePrivate * priv;
};

struct _ValaGObjectModuleClass {
	ValaGTypeModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGObjectModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
};

struct _ValaGSignalModule {
	ValaGObjectModule parent_instance;
	ValaGSignalModulePrivate * priv;
};

struct _ValaGSignalModuleClass {
	ValaGObjectModuleClass parent_class;
	ValaCCodeExpression* (*get_dbus_g_type) (ValaGSignalModule* self, ValaDataType* data_type);
};

struct _ValaGAsyncModule {
	ValaGSignalModule parent_instance;
	ValaGAsyncModulePrivate * priv;
};

struct _ValaGAsyncModuleClass {
	ValaGSignalModuleClass parent_class;
};

struct _ValaDBusModule {
	ValaGAsyncModule parent_instance;
	ValaDBusModulePrivate * priv;
};

struct _ValaDBusModuleClass {
	ValaGAsyncModuleClass parent_class;
};

/**
 * The link between a dynamic method and generated code.
 */
struct _ValaDBusClientModule {
	ValaDBusModule parent_instance;
	ValaDBusClientModulePrivate * priv;
};

struct _ValaDBusClientModuleClass {
	ValaDBusModuleClass parent_class;
};

struct _ValaDBusClientModulePrivate {
	gint dynamic_property_id;
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
GType vala_gerror_module_get_type (void);
GType vala_gtype_module_get_type (void);
GType vala_gobject_module_get_type (void);
GType vala_gsignal_module_get_type (void);
GType vala_gasync_module_get_type (void);
GType vala_dbus_module_get_type (void);
GType vala_dbus_client_module_get_type (void);
#define VALA_DBUS_CLIENT_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModulePrivate))
enum  {
	VALA_DBUS_CLIENT_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaDBusModule* vala_dbus_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusModule* vala_dbus_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusClientModule* vala_dbus_client_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusClientModule* vala_dbus_client_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusClientModule* vala_dbus_client_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
static char* vala_dbus_client_module_get_dynamic_dbus_name (ValaDBusClientModule* self, const char* vala_name);
void vala_ccode_base_module_generate_cparameters (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
static void vala_dbus_client_module_generate_dbus_method_wrapper (ValaDBusClientModule* self, ValaMethod* method, ValaCCodeBlock* block);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_dbus_client_module_real_generate_dynamic_method_wrapper (ValaCCodeModule* base, ValaDynamicMethod* method);
gboolean vala_dbus_client_module_dbus_use_ptr_array (ValaDBusClientModule* self, ValaArrayType* array_type);
ValaCCodeExpression* vala_gsignal_module_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
ValaCCodeExpression* vala_ccode_base_module_default_value_for_type (ValaCCodeBaseModule* self, ValaDataType* type, gboolean initializer_expression);
static ValaCCodeExpression* vala_dbus_client_module_real_get_dbus_g_type (ValaGSignalModule* base, ValaDataType* data_type);
char* vala_ccode_module_get_dynamic_property_getter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
static void vala_dbus_client_module_generate_dbus_property_getter_wrapper (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static char* vala_dbus_client_module_real_get_dynamic_property_getter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop);
char* vala_ccode_module_get_dynamic_property_setter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
static void vala_dbus_client_module_generate_dbus_property_setter_wrapper (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static char* vala_dbus_client_module_real_get_dynamic_property_setter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop);
static void vala_dbus_client_module_create_dbus_property_proxy (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
char* vala_ccode_module_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
char* vala_ccode_module_get_dynamic_signal_cname (ValaCCodeModule* self, ValaDynamicSignal* node);
static void vala_dbus_client_module_generate_dbus_connect_wrapper (ValaDBusClientModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block);
static char* vala_dbus_client_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig);
char* vala_ccode_module_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
static void vala_dbus_client_module_generate_dbus_disconnect_wrapper (ValaDBusClientModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block);
static char* vala_dbus_client_module_real_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_module_generate_marshaller (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
char* vala_ccode_module_get_marshaller_function (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
void vala_ccode_module_visit_cast_expression (ValaCCodeModule* self, ValaCastExpression* expr);
static void vala_dbus_client_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr);
void vala_ccode_module_visit_interface (ValaCCodeModule* self, ValaInterface* iface);
void vala_ccode_declaration_space_add_type_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_dbus_client_module_generate_proxy_filter_function (ValaDBusClientModule* self, ValaInterface* iface);
static char* vala_dbus_client_module_generate_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m);
static char* vala_dbus_client_module_generate_async_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m);
static char* vala_dbus_client_module_generate_finish_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m);
static void vala_dbus_client_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface);
static void vala_dbus_client_module_handle_signals (ValaDBusClientModule* self, ValaInterface* iface, ValaCCodeBlock* block);
ValaCCodeExpression* vala_dbus_module_read_expression (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static char* vala_dbus_client_module_generate_dbus_signal_handler (ValaDBusClientModule* self, ValaSignal* sig, ValaObjectTypeSymbol* sym);
static void vala_dbus_client_module_handle_signal (ValaDBusClientModule* self, const char* dbus_iface_name, const char* dbus_signal_name, const char* handler_name, ValaCCodeBlock* block, ValaCCodeIfStatement** clastif);
void vala_dbus_module_write_expression (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static void vala_dbus_client_module_generate_marshalling (ValaDBusClientModule* self, ValaMethod* m, const char* dbus_iface_name, ValaCCodeFragment* prefragment, ValaCCodeFragment* postfragment);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
static gpointer vala_dbus_client_module_parent_class = NULL;
static void vala_dbus_client_module_finalize (ValaCCodeModule* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaDBusClientModule* vala_dbus_client_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaDBusClientModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaDBusClientModule*) vala_dbus_module_construct (object_type, codegen, next);
	return self;
}


ValaDBusClientModule* vala_dbus_client_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_dbus_client_module_construct (VALA_TYPE_DBUS_CLIENT_MODULE, codegen, next);
}


static char* vala_dbus_client_module_get_dynamic_dbus_name (ValaDBusClientModule* self, const char* vala_name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (vala_name != NULL, NULL);
	/* TODO switch default to no transformation as soon as we have static D-Bus client support
	 keep transformation by default for static D-Bus client and server support*/
	if (vala_code_context_get_dbus_transformation (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self))) {
		return vala_symbol_lower_case_to_camel_case (vala_name);
	} else {
		const char* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = vala_name, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	}
}


static void vala_dbus_client_module_real_generate_dynamic_method_wrapper (ValaCCodeModule* base, ValaDynamicMethod* method) {
	ValaDBusClientModule * self;
	ValaDynamicMethod* _tmp0;
	ValaDynamicMethod* dynamic_method;
	char* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* func;
	GeeHashMap* cparam_map;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp5;
	self = (ValaDBusClientModule*) base;
	g_return_if_fail (method != NULL);
	_tmp0 = NULL;
	dynamic_method = (_tmp0 = VALA_DYNAMIC_METHOD (method), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	_tmp2 = NULL;
	func = (_tmp2 = vala_ccode_function_new (_tmp1 = vala_method_get_cname ((ValaMethod*) method), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, (ValaMethod*) method, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, func, NULL, NULL, NULL, 3);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_method_get_dynamic_type (dynamic_method)) == ((ValaCCodeBaseModule*) self)->dbus_object_type) {
		vala_dbus_client_module_generate_dbus_method_wrapper (self, (ValaMethod*) method, block);
	} else {
		char* _tmp4;
		char* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) method), _tmp4 = g_strdup_printf ("dynamic methods are not supported for `%s'", _tmp3 = vala_code_node_to_string ((ValaCodeNode*) vala_dynamic_method_get_dynamic_type (dynamic_method))));
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp3 = (g_free (_tmp3), NULL);
	}
	/* append to C source file*/
	_tmp5 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp5 = vala_ccode_function_copy (func)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
	(func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
}


static void vala_dbus_client_module_generate_dbus_method_wrapper (ValaDBusClientModule* self, ValaMethod* method, ValaCCodeBlock* block) {
	ValaDynamicMethod* _tmp0;
	ValaDynamicMethod* dynamic_method;
	ValaMethodCall* _tmp1;
	ValaMethodCall* expr;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp4;
	gboolean found_out;
	ValaExpression* callback;
	gint callback_index;
	gint arg_index;
	ValaCCodeConstant* _tmp13;
	char* _tmp12;
	char* _tmp11;
	ValaCCodeIdentifier* _tmp155;
	ValaCCodeFragment* out_marshalling_fragment;
	g_return_if_fail (self != NULL);
	g_return_if_fail (method != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	dynamic_method = (_tmp0 = VALA_DYNAMIC_METHOD (method), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	expr = (_tmp1 = vala_dynamic_method_get_invocation (dynamic_method), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = NULL;
	_tmp3 = NULL;
	ccall = (_tmp3 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("dbus_g_proxy_begin_call"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("self")));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	found_out = FALSE;
	callback = NULL;
	callback_index = -1;
	arg_index = 1;
	{
		GeeList* _tmp5;
		GeeIterator* _tmp6;
		GeeIterator* _arg_it;
		_tmp5 = NULL;
		_tmp6 = NULL;
		_arg_it = (_tmp6 = gee_iterable_iterator ((GeeIterable*) (_tmp5 = vala_method_call_get_argument_list (expr))), (_tmp5 == NULL) ? NULL : (_tmp5 = (gee_collection_object_unref (_tmp5), NULL)), _tmp6);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			if (VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
				ValaExpression* _tmp8;
				ValaExpression* _tmp7;
				/* callback*/
				if (callback != NULL) {
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "only one reply callback may be specified in invocation of DBus method");
					vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
					(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
					(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
					return;
				} else {
					if (found_out) {
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "out argument and reply callback conflict in invocation of DBus method");
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
						(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
						(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
						return;
					}
				}
				_tmp8 = NULL;
				_tmp7 = NULL;
				callback = (_tmp8 = (_tmp7 = arg, (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7)), (callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL)), _tmp8);
				callback_index = arg_index;
			} else {
				gboolean _tmp9;
				_tmp9 = FALSE;
				if (VALA_IS_UNARY_EXPRESSION (arg)) {
					_tmp9 = vala_unary_expression_get_operator (VALA_UNARY_EXPRESSION (arg)) == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp9 = FALSE;
				}
				if (_tmp9) {
					/* out arg*/
					if (callback != NULL) {
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "out argument and reply callback conflict in invocation of DBus method");
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
						(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
						(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
						return;
					}
					found_out = TRUE;
				} else {
					gboolean _tmp10;
					_tmp10 = FALSE;
					if (callback != NULL) {
						_tmp10 = TRUE;
					} else {
						_tmp10 = found_out;
					}
					/* in arg*/
					if (_tmp10) {
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "in argument must not follow out argument or reply callback in invocation of DBus method");
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
						(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
						(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
						return;
					}
				}
			}
			arg_index++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp13 = vala_ccode_constant_new (_tmp12 = g_strdup_printf ("\"%s\"", _tmp11 = vala_dbus_client_module_get_dynamic_dbus_name (self, vala_symbol_get_name ((ValaSymbol*) method))))));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp12 = (g_free (_tmp12), NULL);
	_tmp11 = (g_free (_tmp11), NULL);
	if (callback != NULL) {
		ValaMethod* _tmp14;
		ValaMethod* reply_method;
		char* _tmp16;
		char* _tmp15;
		ValaCCodeFunction* _tmp17;
		ValaCCodeFunction* cb_fun;
		ValaCCodeFormalParameter* _tmp18;
		ValaCCodeFormalParameter* _tmp19;
		ValaCCodeFormalParameter* _tmp20;
		ValaCCodeBlock* _tmp21;
		ValaCCodeDeclaration* cerrdecl;
		ValaCCodeVariableDeclarator* _tmp23;
		ValaCCodeConstant* _tmp22;
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeFunctionCall* _tmp25;
		ValaCCodeFunctionCall* cend_call;
		ValaCCodeIdentifier* _tmp26;
		ValaCCodeIdentifier* _tmp27;
		ValaCCodeUnaryExpression* _tmp29;
		ValaCCodeIdentifier* _tmp28;
		ValaCCodeFunctionCall* creply_call;
		ValaCCodeIdentifier* _tmp30;
		GeeList* _tmp31;
		gint _tmp32;
		gint param_count;
		gint i;
		ValaCCodeIdentifier* _tmp59;
		ValaCCodeExpressionStatement* _tmp60;
		ValaCCodeIdentifier* _tmp61;
		ValaCCodeExpressionStatement* _tmp62;
		ValaCCodeIdentifier* _tmp63;
		ValaCCodeConstant* _tmp65;
		char* _tmp64;
		ValaCCodeConstant* _tmp66;
		_tmp14 = NULL;
		reply_method = (_tmp14 = VALA_METHOD (vala_expression_get_symbol_reference (callback)), (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14));
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp17 = NULL;
		cb_fun = (_tmp17 = vala_ccode_function_new (_tmp16 = g_strdup_printf ("_%s_cb", _tmp15 = vala_method_get_cname (reply_method)), "void"), _tmp16 = (g_free (_tmp16), NULL), _tmp15 = (g_free (_tmp15), NULL), _tmp17);
		vala_ccode_function_set_modifiers (cb_fun, VALA_CCODE_MODIFIERS_STATIC);
		_tmp18 = NULL;
		vala_ccode_function_add_parameter (cb_fun, _tmp18 = vala_ccode_formal_parameter_new ("proxy", "DBusGProxy*"));
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		_tmp19 = NULL;
		vala_ccode_function_add_parameter (cb_fun, _tmp19 = vala_ccode_formal_parameter_new ("call", "DBusGProxyCall*"));
		(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
		_tmp20 = NULL;
		vala_ccode_function_add_parameter (cb_fun, _tmp20 = vala_ccode_formal_parameter_new ("user_data", "void*"));
		(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
		_tmp21 = NULL;
		vala_ccode_function_set_block (cb_fun, _tmp21 = vala_ccode_block_new ());
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
		cerrdecl = vala_ccode_declaration_new ("GError*");
		_tmp23 = NULL;
		_tmp22 = NULL;
		vala_ccode_declaration_add_declarator (cerrdecl, (ValaCCodeDeclarator*) (_tmp23 = vala_ccode_variable_declarator_new ("error", (ValaCCodeExpression*) (_tmp22 = vala_ccode_constant_new ("NULL")))));
		(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), (ValaCCodeNode*) cerrdecl);
		_tmp24 = NULL;
		_tmp25 = NULL;
		cend_call = (_tmp25 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("dbus_g_proxy_end_call"))), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp25);
		_tmp26 = NULL;
		vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("proxy")));
		(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
		_tmp27 = NULL;
		vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("call")));
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		_tmp29 = NULL;
		_tmp28 = NULL;
		vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp29 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("error")))));
		(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
		(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
		creply_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) callback)));
		_tmp30 = NULL;
		vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("user_data")));
		(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
		_tmp31 = NULL;
		param_count = (_tmp32 = gee_collection_get_size ((GeeCollection*) (_tmp31 = vala_method_get_parameters (reply_method))), (_tmp31 == NULL) ? NULL : (_tmp31 = (gee_collection_object_unref (_tmp31), NULL)), _tmp32);
		i = 0;
		{
			GeeList* _tmp33;
			GeeIterator* _tmp34;
			GeeIterator* _param_it;
			_tmp33 = NULL;
			_tmp34 = NULL;
			_param_it = (_tmp34 = gee_iterable_iterator ((GeeIterable*) (_tmp33 = vala_method_get_parameters (reply_method))), (_tmp33 == NULL) ? NULL : (_tmp33 = (gee_collection_object_unref (_tmp33), NULL)), _tmp34);
			while (gee_iterator_next (_param_it)) {
				ValaFormalParameter* param;
				gboolean _tmp35;
				param = (ValaFormalParameter*) gee_iterator_get (_param_it);
				if ((i = i + 1) == param_count) {
					if (!VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						vala_report_error (NULL, "DBus reply callbacks must end with GLib.Error argument");
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
						(reply_method == NULL) ? NULL : (reply_method = (vala_code_node_unref (reply_method), NULL));
						(cb_fun == NULL) ? NULL : (cb_fun = (vala_ccode_node_unref (cb_fun), NULL));
						(cerrdecl == NULL) ? NULL : (cerrdecl = (vala_ccode_node_unref (cerrdecl), NULL));
						(cend_call == NULL) ? NULL : (cend_call = (vala_ccode_node_unref (cend_call), NULL));
						(creply_call == NULL) ? NULL : (creply_call = (vala_ccode_node_unref (creply_call), NULL));
						(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
						return;
					}
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					break;
				}
				_tmp35 = FALSE;
				if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					_tmp35 = vala_data_type_get_data_type (vala_array_type_get_element_type (VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
				} else {
					_tmp35 = FALSE;
				}
				if (_tmp35) {
					ValaArrayType* _tmp36;
					ValaArrayType* array_type;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp39;
					ValaCCodeExpression* _tmp40;
					ValaCCodeUnaryExpression* _tmp42;
					ValaCCodeIdentifier* _tmp41;
					const char* _tmp43;
					ValaCCodeMemberAccess* _tmp45;
					ValaCCodeIdentifier* _tmp44;
					ValaCCodeMemberAccess* _tmp47;
					ValaCCodeIdentifier* _tmp46;
					_tmp36 = NULL;
					array_type = (_tmp36 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp36 == NULL) ? NULL : vala_code_node_ref (_tmp36));
					cdecl_ = NULL;
					if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
						ValaCCodeDeclaration* _tmp37;
						_tmp37 = NULL;
						cdecl_ = (_tmp37 = vala_ccode_declaration_new ("GPtrArray*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp37);
					} else {
						ValaCCodeDeclaration* _tmp38;
						_tmp38 = NULL;
						cdecl_ = (_tmp38 = vala_ccode_declaration_new ("GArray*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp38);
					}
					_tmp39 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp39 = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) param), NULL)));
					(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
					vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), (ValaCCodeNode*) cdecl_);
					_tmp40 = NULL;
					vala_ccode_function_call_add_argument (cend_call, _tmp40 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, (ValaDataType*) array_type));
					(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
					_tmp42 = NULL;
					_tmp41 = NULL;
					vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp42 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))));
					(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
					(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
					_tmp43 = NULL;
					if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
						_tmp43 = "pdata";
					} else {
						_tmp43 = "data";
					}
					_tmp45 = NULL;
					_tmp44 = NULL;
					vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) (_tmp45 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp44 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), _tmp43)));
					(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
					(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
					_tmp47 = NULL;
					_tmp46 = NULL;
					vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) (_tmp47 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), "len")));
					(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
					(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				} else {
					char* _tmp48;
					ValaCCodeDeclaration* _tmp49;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp50;
					ValaCCodeExpression* _tmp51;
					ValaCCodeUnaryExpression* _tmp53;
					ValaCCodeIdentifier* _tmp52;
					ValaCCodeIdentifier* _tmp54;
					gboolean _tmp55;
					_tmp48 = NULL;
					_tmp49 = NULL;
					cdecl_ = (_tmp49 = vala_ccode_declaration_new (_tmp48 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param))), _tmp48 = (g_free (_tmp48), NULL), _tmp49);
					_tmp50 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp50 = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) param), NULL)));
					(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
					vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), (ValaCCodeNode*) cdecl_);
					_tmp51 = NULL;
					vala_ccode_function_call_add_argument (cend_call, _tmp51 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
					(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
					_tmp53 = NULL;
					_tmp52 = NULL;
					vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp53 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))));
					(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
					(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
					_tmp54 = NULL;
					vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
					(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
					_tmp55 = FALSE;
					if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						_tmp55 = vala_data_type_get_data_type (vala_array_type_get_element_type (VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
					} else {
						_tmp55 = FALSE;
					}
					if (_tmp55) {
						ValaCCodeIdentifier* _tmp56;
						ValaCCodeFunctionCall* _tmp57;
						ValaCCodeFunctionCall* cstrvlen;
						ValaCCodeIdentifier* _tmp58;
						_tmp56 = NULL;
						_tmp57 = NULL;
						cstrvlen = (_tmp57 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new ("g_strv_length"))), (_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)), _tmp57);
						_tmp58 = NULL;
						vala_ccode_function_call_add_argument (cstrvlen, (ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
						vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) cstrvlen);
						(cstrvlen == NULL) ? NULL : (cstrvlen = (vala_ccode_node_unref (cstrvlen), NULL));
					}
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				}
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
		}
		_tmp59 = NULL;
		vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
		(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
		_tmp60 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), (ValaCCodeNode*) (_tmp60 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cend_call)));
		(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
		_tmp61 = NULL;
		vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new ("error")));
		(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
		_tmp62 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), (ValaCCodeNode*) (_tmp62 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) creply_call)));
		(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cb_fun);
		_tmp63 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new (vala_ccode_function_get_name (cb_fun))));
		(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
		_tmp65 = NULL;
		_tmp64 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp65 = vala_ccode_constant_new (_tmp64 = g_strdup_printf ("param%d_target", callback_index))));
		(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
		_tmp64 = (g_free (_tmp64), NULL);
		_tmp66 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp66 = vala_ccode_constant_new ("NULL")));
		(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
		(reply_method == NULL) ? NULL : (reply_method = (vala_code_node_unref (reply_method), NULL));
		(cb_fun == NULL) ? NULL : (cb_fun = (vala_ccode_node_unref (cb_fun), NULL));
		(cerrdecl == NULL) ? NULL : (cerrdecl = (vala_ccode_node_unref (cerrdecl), NULL));
		(cend_call == NULL) ? NULL : (cend_call = (vala_ccode_node_unref (cend_call), NULL));
		(creply_call == NULL) ? NULL : (creply_call = (vala_ccode_node_unref (creply_call), NULL));
	} else {
		ValaCCodeIdentifier* _tmp67;
		ValaCCodeIdentifier* _tmp68;
		_tmp67 = NULL;
		vala_ccode_function_call_set_call (ccall, (ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new ("dbus_g_proxy_call")));
		(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
		_tmp68 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp68 = vala_ccode_identifier_new ("error")));
		(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
	}
	{
		GeeList* _tmp69;
		GeeIterator* _tmp70;
		GeeIterator* _param_it;
		_tmp69 = NULL;
		_tmp70 = NULL;
		_param_it = (_tmp70 = gee_iterable_iterator ((GeeIterable*) (_tmp69 = vala_method_get_parameters (method))), (_tmp69 == NULL) ? NULL : (_tmp69 = (gee_collection_object_unref (_tmp69), NULL)), _tmp70);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp71;
			ValaArrayType* _tmp73;
			ValaDataType* _tmp72;
			ValaArrayType* array_type;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp71 = FALSE;
			if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				_tmp71 = TRUE;
			} else {
				_tmp71 = VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param));
			}
			if (_tmp71) {
				/* callback parameter*/
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				break;
			}
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			_tmp73 = NULL;
			_tmp72 = NULL;
			array_type = (_tmp73 = (_tmp72 = vala_formal_parameter_get_parameter_type (param), VALA_IS_ARRAY_TYPE (_tmp72) ? ((ValaArrayType*) _tmp72) : NULL), (_tmp73 == NULL) ? NULL : vala_code_node_ref (_tmp73));
			if (array_type != NULL) {
				/* array parameter*/
				if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
					ValaCCodeExpression* _tmp74;
					ValaCCodeIdentifier* _tmp75;
					ValaCCodeFunctionCall* _tmp76;
					ValaCCodeFunctionCall* sizeof_call;
					ValaCCodeIdentifier* _tmp78;
					char* _tmp77;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeFunctionCall* array_construct;
					ValaCCodeVariableDeclarator* _tmp90;
					char* _tmp89;
					ValaCCodeIdentifier* _tmp117;
					char* _tmp116;
					/* non-string arrays (use GArray)*/
					_tmp74 = NULL;
					vala_ccode_function_call_add_argument (ccall, _tmp74 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, (ValaDataType*) array_type));
					(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
					_tmp75 = NULL;
					_tmp76 = NULL;
					sizeof_call = (_tmp76 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp75 = vala_ccode_identifier_new ("sizeof"))), (_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)), _tmp76);
					_tmp78 = NULL;
					_tmp77 = NULL;
					vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp78 = vala_ccode_identifier_new (_tmp77 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
					(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
					_tmp77 = (g_free (_tmp77), NULL);
					cdecl_ = NULL;
					array_construct = NULL;
					if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
						ValaCCodeDeclaration* _tmp79;
						ValaCCodeFunctionCall* _tmp81;
						ValaCCodeIdentifier* _tmp80;
						ValaCCodeIdentifier* _tmp83;
						char* _tmp82;
						_tmp79 = NULL;
						cdecl_ = (_tmp79 = vala_ccode_declaration_new ("GPtrArray*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp79);
						_tmp81 = NULL;
						_tmp80 = NULL;
						array_construct = (_tmp81 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp80 = vala_ccode_identifier_new ("g_ptr_array_sized_new"))), (array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)), _tmp81);
						(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
						_tmp83 = NULL;
						_tmp82 = NULL;
						vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp83 = vala_ccode_identifier_new (_tmp82 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), 1))));
						(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
						_tmp82 = (g_free (_tmp82), NULL);
					} else {
						ValaCCodeDeclaration* _tmp84;
						ValaCCodeFunctionCall* _tmp86;
						ValaCCodeIdentifier* _tmp85;
						ValaCCodeConstant* _tmp87;
						ValaCCodeConstant* _tmp88;
						_tmp84 = NULL;
						cdecl_ = (_tmp84 = vala_ccode_declaration_new ("GArray*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp84);
						_tmp86 = NULL;
						_tmp85 = NULL;
						array_construct = (_tmp86 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp85 = vala_ccode_identifier_new ("g_array_new"))), (array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)), _tmp86);
						(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
						_tmp87 = NULL;
						vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp87 = vala_ccode_constant_new ("TRUE")));
						(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
						_tmp88 = NULL;
						vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp88 = vala_ccode_constant_new ("TRUE")));
						(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
						vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) sizeof_call);
					}
					_tmp90 = NULL;
					_tmp89 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp90 = vala_ccode_variable_declarator_new (_tmp89 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)), (ValaCCodeExpression*) array_construct)));
					(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
					_tmp89 = (g_free (_tmp89), NULL);
					vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
					if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
						ValaCCodeIdentifier* _tmp91;
						ValaCCodeFunctionCall* _tmp92;
						ValaCCodeFunctionCall* memcpy_call;
						ValaCCodeMemberAccess* _tmp95;
						ValaCCodeIdentifier* _tmp94;
						char* _tmp93;
						ValaCCodeIdentifier* _tmp96;
						ValaCCodeBinaryExpression* _tmp99;
						ValaCCodeIdentifier* _tmp98;
						char* _tmp97;
						ValaCCodeExpressionStatement* _tmp100;
						ValaCCodeIdentifier* _tmp105;
						char* _tmp104;
						ValaCCodeMemberAccess* _tmp103;
						ValaCCodeIdentifier* _tmp102;
						char* _tmp101;
						ValaCCodeAssignment* _tmp106;
						ValaCCodeAssignment* len_assignment;
						ValaCCodeExpressionStatement* _tmp107;
						_tmp91 = NULL;
						_tmp92 = NULL;
						memcpy_call = (_tmp92 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp91 = vala_ccode_identifier_new ("memcpy"))), (_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL)), _tmp92);
						_tmp95 = NULL;
						_tmp94 = NULL;
						_tmp93 = NULL;
						vala_ccode_function_call_add_argument (memcpy_call, (ValaCCodeExpression*) (_tmp95 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new (_tmp93 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "pdata")));
						(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
						(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
						_tmp93 = (g_free (_tmp93), NULL);
						_tmp96 = NULL;
						vala_ccode_function_call_add_argument (memcpy_call, (ValaCCodeExpression*) (_tmp96 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
						_tmp99 = NULL;
						_tmp98 = NULL;
						_tmp97 = NULL;
						vala_ccode_function_call_add_argument (memcpy_call, (ValaCCodeExpression*) (_tmp99 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp98 = vala_ccode_identifier_new (_tmp97 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), 1))), (ValaCCodeExpression*) sizeof_call)));
						(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
						(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
						_tmp97 = (g_free (_tmp97), NULL);
						_tmp100 = NULL;
						vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp100 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) memcpy_call)));
						(_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL));
						_tmp105 = NULL;
						_tmp104 = NULL;
						_tmp103 = NULL;
						_tmp102 = NULL;
						_tmp101 = NULL;
						_tmp106 = NULL;
						len_assignment = (_tmp106 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp103 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp102 = vala_ccode_identifier_new (_tmp101 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "len")), (ValaCCodeExpression*) (_tmp105 = vala_ccode_identifier_new (_tmp104 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), 1))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)), _tmp104 = (g_free (_tmp104), NULL), (_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)), (_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)), _tmp101 = (g_free (_tmp101), NULL), _tmp106);
						_tmp107 = NULL;
						vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp107 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) len_assignment)));
						(_tmp107 == NULL) ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL));
						(memcpy_call == NULL) ? NULL : (memcpy_call = (vala_ccode_node_unref (memcpy_call), NULL));
						(len_assignment == NULL) ? NULL : (len_assignment = (vala_ccode_node_unref (len_assignment), NULL));
					} else {
						ValaCCodeIdentifier* _tmp108;
						ValaCCodeFunctionCall* _tmp109;
						ValaCCodeFunctionCall* cappend_call;
						ValaCCodeIdentifier* _tmp111;
						char* _tmp110;
						ValaCCodeIdentifier* _tmp112;
						ValaCCodeIdentifier* _tmp114;
						char* _tmp113;
						ValaCCodeExpressionStatement* _tmp115;
						_tmp108 = NULL;
						_tmp109 = NULL;
						cappend_call = (_tmp109 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp108 = vala_ccode_identifier_new ("g_array_append_vals"))), (_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL)), _tmp109);
						_tmp111 = NULL;
						_tmp110 = NULL;
						vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) (_tmp111 = vala_ccode_identifier_new (_tmp110 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))));
						(_tmp111 == NULL) ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL));
						_tmp110 = (g_free (_tmp110), NULL);
						_tmp112 = NULL;
						vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) (_tmp112 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
						_tmp114 = NULL;
						_tmp113 = NULL;
						vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) (_tmp114 = vala_ccode_identifier_new (_tmp113 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), 1))));
						(_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL));
						_tmp113 = (g_free (_tmp113), NULL);
						_tmp115 = NULL;
						vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp115 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cappend_call)));
						(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
						(cappend_call == NULL) ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL));
					}
					_tmp117 = NULL;
					_tmp116 = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp117 = vala_ccode_identifier_new (_tmp116 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))));
					(_tmp117 == NULL) ? NULL : (_tmp117 = (vala_ccode_node_unref (_tmp117), NULL));
					_tmp116 = (g_free (_tmp116), NULL);
					(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					(array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL));
				} else {
					ValaCCodeIdentifier* _tmp118;
					ValaCCodeIdentifier* _tmp119;
					/* string arrays*/
					_tmp118 = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp118 = vala_ccode_identifier_new ("G_TYPE_STRV")));
					(_tmp118 == NULL) ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL));
					_tmp119 = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp119 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
					(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
				}
			} else {
				char* _tmp120;
				gboolean _tmp121;
				_tmp120 = NULL;
				if ((_tmp121 = g_str_has_prefix (_tmp120 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "("), _tmp120 = (g_free (_tmp120), NULL), _tmp121)) {
					ValaStruct* _tmp122;
					ValaStruct* st;
					ValaCCodeIdentifier* _tmp123;
					ValaCCodeFunctionCall* _tmp124;
					ValaCCodeFunctionCall* array_construct;
					ValaCCodeConstant* _tmp125;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp127;
					char* _tmp126;
					ValaCCodeExpression* _tmp150;
					ValaCCodeIdentifier* _tmp152;
					char* _tmp151;
					/* struct parameter*/
					_tmp122 = NULL;
					st = (_tmp122 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp122 == NULL) ? NULL : vala_code_node_ref (_tmp122));
					_tmp123 = NULL;
					_tmp124 = NULL;
					array_construct = (_tmp124 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp123 = vala_ccode_identifier_new ("g_value_array_new"))), (_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)), _tmp124);
					_tmp125 = NULL;
					vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp125 = vala_ccode_constant_new ("0")));
					(_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL));
					cdecl_ = vala_ccode_declaration_new ("GValueArray*");
					_tmp127 = NULL;
					_tmp126 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp127 = vala_ccode_variable_declarator_new (_tmp126 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)), (ValaCCodeExpression*) array_construct)));
					(_tmp127 == NULL) ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL));
					_tmp126 = (g_free (_tmp126), NULL);
					vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
					{
						GeeList* _tmp128;
						GeeIterator* _tmp129;
						GeeIterator* _f_it;
						_tmp128 = NULL;
						_tmp129 = NULL;
						_f_it = (_tmp129 = gee_iterable_iterator ((GeeIterable*) (_tmp128 = vala_struct_get_fields (st))), (_tmp128 == NULL) ? NULL : (_tmp128 = (gee_collection_object_unref (_tmp128), NULL)), _tmp129);
						while (gee_iterator_next (_f_it)) {
							ValaField* f;
							char* val_name;
							ValaCCodeInitializerList* cvalinit;
							ValaCCodeConstant* _tmp130;
							ValaCCodeDeclaration* cval_decl;
							ValaCCodeVariableDeclarator* _tmp131;
							ValaCCodeIdentifier* _tmp132;
							ValaCCodeUnaryExpression* _tmp133;
							ValaCCodeUnaryExpression* val_ptr;
							ValaCCodeIdentifier* _tmp134;
							ValaCCodeFunctionCall* _tmp135;
							ValaCCodeFunctionCall* cinit_call;
							ValaCCodeIdentifier* _tmp137;
							char* _tmp136;
							ValaCCodeExpressionStatement* _tmp138;
							ValaCCodeIdentifier* _tmp140;
							char* _tmp139;
							ValaCCodeFunctionCall* _tmp141;
							ValaCCodeFunctionCall* cset_call;
							ValaCCodeMemberAccess* _tmp143;
							ValaCCodeIdentifier* _tmp142;
							ValaCCodeExpressionStatement* _tmp144;
							ValaCCodeIdentifier* _tmp145;
							ValaCCodeFunctionCall* _tmp146;
							ValaCCodeFunctionCall* cappend_call;
							ValaCCodeIdentifier* _tmp148;
							char* _tmp147;
							ValaCCodeExpressionStatement* _tmp149;
							f = (ValaField*) gee_iterator_get (_f_it);
							if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
								(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
								continue;
							}
							val_name = g_strdup_printf ("val_%s_%s", vala_symbol_get_name ((ValaSymbol*) param), vala_symbol_get_name ((ValaSymbol*) f));
							/* 0-initialize struct with struct initializer { 0 }*/
							cvalinit = vala_ccode_initializer_list_new ();
							_tmp130 = NULL;
							vala_ccode_initializer_list_append (cvalinit, (ValaCCodeExpression*) (_tmp130 = vala_ccode_constant_new ("0")));
							(_tmp130 == NULL) ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL));
							cval_decl = vala_ccode_declaration_new ("GValue");
							_tmp131 = NULL;
							vala_ccode_declaration_add_declarator (cval_decl, (ValaCCodeDeclarator*) (_tmp131 = vala_ccode_variable_declarator_new (val_name, (ValaCCodeExpression*) cvalinit)));
							(_tmp131 == NULL) ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL));
							vala_ccode_block_add_statement (block, (ValaCCodeNode*) cval_decl);
							_tmp132 = NULL;
							_tmp133 = NULL;
							val_ptr = (_tmp133 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp132 = vala_ccode_identifier_new (val_name))), (_tmp132 == NULL) ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL)), _tmp133);
							_tmp134 = NULL;
							_tmp135 = NULL;
							cinit_call = (_tmp135 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp134 = vala_ccode_identifier_new ("g_value_init"))), (_tmp134 == NULL) ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL)), _tmp135);
							vala_ccode_function_call_add_argument (cinit_call, (ValaCCodeExpression*) val_ptr);
							_tmp137 = NULL;
							_tmp136 = NULL;
							vala_ccode_function_call_add_argument (cinit_call, (ValaCCodeExpression*) (_tmp137 = vala_ccode_identifier_new (_tmp136 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))));
							(_tmp137 == NULL) ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL));
							_tmp136 = (g_free (_tmp136), NULL);
							_tmp138 = NULL;
							vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp138 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit_call)));
							(_tmp138 == NULL) ? NULL : (_tmp138 = (vala_ccode_node_unref (_tmp138), NULL));
							_tmp140 = NULL;
							_tmp139 = NULL;
							_tmp141 = NULL;
							cset_call = (_tmp141 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp140 = vala_ccode_identifier_new (_tmp139 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))), (_tmp140 == NULL) ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL)), _tmp139 = (g_free (_tmp139), NULL), _tmp141);
							vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) val_ptr);
							_tmp143 = NULL;
							_tmp142 = NULL;
							vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) (_tmp143 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp142 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), vala_symbol_get_name ((ValaSymbol*) f))));
							(_tmp143 == NULL) ? NULL : (_tmp143 = (vala_ccode_node_unref (_tmp143), NULL));
							(_tmp142 == NULL) ? NULL : (_tmp142 = (vala_ccode_node_unref (_tmp142), NULL));
							_tmp144 = NULL;
							vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp144 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cset_call)));
							(_tmp144 == NULL) ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL));
							_tmp145 = NULL;
							_tmp146 = NULL;
							cappend_call = (_tmp146 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp145 = vala_ccode_identifier_new ("g_value_array_append"))), (_tmp145 == NULL) ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL)), _tmp146);
							_tmp148 = NULL;
							_tmp147 = NULL;
							vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) (_tmp148 = vala_ccode_identifier_new (_tmp147 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))));
							(_tmp148 == NULL) ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL));
							_tmp147 = (g_free (_tmp147), NULL);
							vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) val_ptr);
							_tmp149 = NULL;
							vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp149 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cappend_call)));
							(_tmp149 == NULL) ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL));
							(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
							val_name = (g_free (val_name), NULL);
							(cvalinit == NULL) ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL));
							(cval_decl == NULL) ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL));
							(val_ptr == NULL) ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL));
							(cinit_call == NULL) ? NULL : (cinit_call = (vala_ccode_node_unref (cinit_call), NULL));
							(cset_call == NULL) ? NULL : (cset_call = (vala_ccode_node_unref (cset_call), NULL));
							(cappend_call == NULL) ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL));
						}
						(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
					}
					_tmp150 = NULL;
					vala_ccode_function_call_add_argument (ccall, _tmp150 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
					(_tmp150 == NULL) ? NULL : (_tmp150 = (vala_ccode_node_unref (_tmp150), NULL));
					_tmp152 = NULL;
					_tmp151 = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp152 = vala_ccode_identifier_new (_tmp151 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))));
					(_tmp152 == NULL) ? NULL : (_tmp152 = (vala_ccode_node_unref (_tmp152), NULL));
					_tmp151 = (g_free (_tmp151), NULL);
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					(array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL));
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				} else {
					ValaCCodeExpression* _tmp153;
					ValaCCodeIdentifier* _tmp154;
					_tmp153 = NULL;
					vala_ccode_function_call_add_argument (ccall, _tmp153 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
					(_tmp153 == NULL) ? NULL : (_tmp153 = (vala_ccode_node_unref (_tmp153), NULL));
					_tmp154 = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp154 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
					(_tmp154 == NULL) ? NULL : (_tmp154 = (vala_ccode_node_unref (_tmp154), NULL));
				}
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp155 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp155 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp155 == NULL) ? NULL : (_tmp155 = (vala_ccode_node_unref (_tmp155), NULL));
	out_marshalling_fragment = vala_ccode_fragment_new ();
	{
		GeeList* _tmp156;
		GeeIterator* _tmp157;
		GeeIterator* _param_it;
		_tmp156 = NULL;
		_tmp157 = NULL;
		_param_it = (_tmp157 = gee_iterable_iterator ((GeeIterable*) (_tmp156 = vala_method_get_parameters (method))), (_tmp156 == NULL) ? NULL : (_tmp156 = (gee_collection_object_unref (_tmp156), NULL)), _tmp157);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			char* _tmp158;
			gboolean _tmp159;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				/* callback parameter*/
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				break;
			}
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			_tmp158 = NULL;
			if ((_tmp159 = g_str_has_prefix (_tmp158 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "("), _tmp158 = (g_free (_tmp158), NULL), _tmp159)) {
				ValaStruct* _tmp160;
				ValaStruct* st;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp162;
				char* _tmp161;
				gint i;
				ValaCCodeExpression* _tmp181;
				ValaCCodeUnaryExpression* _tmp184;
				ValaCCodeIdentifier* _tmp183;
				char* _tmp182;
				/* struct output parameter*/
				_tmp160 = NULL;
				st = (_tmp160 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp160 == NULL) ? NULL : vala_code_node_ref (_tmp160));
				cdecl_ = vala_ccode_declaration_new ("GValueArray*");
				_tmp162 = NULL;
				_tmp161 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp162 = vala_ccode_variable_declarator_new (_tmp161 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)), NULL)));
				(_tmp162 == NULL) ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL));
				_tmp161 = (g_free (_tmp161), NULL);
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
				i = 0;
				{
					GeeList* _tmp163;
					GeeIterator* _tmp164;
					GeeIterator* _f_it;
					_tmp163 = NULL;
					_tmp164 = NULL;
					_f_it = (_tmp164 = gee_iterable_iterator ((GeeIterable*) (_tmp163 = vala_struct_get_fields (st))), (_tmp163 == NULL) ? NULL : (_tmp163 = (gee_collection_object_unref (_tmp163), NULL)), _tmp164);
					while (gee_iterator_next (_f_it)) {
						ValaField* f;
						ValaCCodeIdentifier* _tmp166;
						char* _tmp165;
						ValaCCodeFunctionCall* _tmp167;
						ValaCCodeFunctionCall* cget_call;
						ValaCCodeUnaryExpression* _tmp174;
						ValaCCodeElementAccess* _tmp173;
						ValaCCodeConstant* _tmp172;
						char* _tmp171;
						ValaCCodeMemberAccess* _tmp170;
						ValaCCodeIdentifier* _tmp169;
						char* _tmp168;
						ValaCCodeFunctionCall* _tmp175;
						ValaCCodeFunctionCall* converted_value;
						ValaCCodeMemberAccess* _tmp178;
						ValaCCodeIdentifier* _tmp177;
						ValaCCodeAssignment* _tmp179;
						ValaCCodeAssignment* assign;
						ValaCCodeExpressionStatement* _tmp180;
						f = (ValaField*) gee_iterator_get (_f_it);
						if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
							(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
							continue;
						}
						_tmp166 = NULL;
						_tmp165 = NULL;
						_tmp167 = NULL;
						cget_call = (_tmp167 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp166 = vala_ccode_identifier_new (_tmp165 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))), (_tmp166 == NULL) ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL)), _tmp165 = (g_free (_tmp165), NULL), _tmp167);
						_tmp174 = NULL;
						_tmp173 = NULL;
						_tmp172 = NULL;
						_tmp171 = NULL;
						_tmp170 = NULL;
						_tmp169 = NULL;
						_tmp168 = NULL;
						vala_ccode_function_call_add_argument (cget_call, (ValaCCodeExpression*) (_tmp174 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp173 = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp170 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp169 = vala_ccode_identifier_new (_tmp168 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "values")), (ValaCCodeExpression*) (_tmp172 = vala_ccode_constant_new (_tmp171 = g_strdup_printf ("%i", i))))))));
						(_tmp174 == NULL) ? NULL : (_tmp174 = (vala_ccode_node_unref (_tmp174), NULL));
						(_tmp173 == NULL) ? NULL : (_tmp173 = (vala_ccode_node_unref (_tmp173), NULL));
						(_tmp172 == NULL) ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL));
						_tmp171 = (g_free (_tmp171), NULL);
						(_tmp170 == NULL) ? NULL : (_tmp170 = (vala_ccode_node_unref (_tmp170), NULL));
						(_tmp169 == NULL) ? NULL : (_tmp169 = (vala_ccode_node_unref (_tmp169), NULL));
						_tmp168 = (g_free (_tmp168), NULL);
						_tmp175 = NULL;
						converted_value = (_tmp175 = cget_call, (_tmp175 == NULL) ? NULL : vala_ccode_node_ref (_tmp175));
						if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f))) {
							ValaCCodeExpression* dupexpr;
							ValaCCodeFunctionCall* _tmp176;
							dupexpr = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f), vala_code_node_get_source_reference ((ValaCodeNode*) expr));
							_tmp176 = NULL;
							converted_value = (_tmp176 = vala_ccode_function_call_new (dupexpr), (converted_value == NULL) ? NULL : (converted_value = (vala_ccode_node_unref (converted_value), NULL)), _tmp176);
							vala_ccode_function_call_add_argument (converted_value, (ValaCCodeExpression*) cget_call);
							(dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL));
						}
						_tmp178 = NULL;
						_tmp177 = NULL;
						_tmp179 = NULL;
						assign = (_tmp179 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp178 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp177 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), vala_symbol_get_name ((ValaSymbol*) f))), (ValaCCodeExpression*) converted_value, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp178 == NULL) ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL)), (_tmp177 == NULL) ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL)), _tmp179);
						_tmp180 = NULL;
						vala_ccode_fragment_append (out_marshalling_fragment, (ValaCCodeNode*) (_tmp180 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
						(_tmp180 == NULL) ? NULL : (_tmp180 = (vala_ccode_node_unref (_tmp180), NULL));
						i++;
						(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
						(cget_call == NULL) ? NULL : (cget_call = (vala_ccode_node_unref (cget_call), NULL));
						(converted_value == NULL) ? NULL : (converted_value = (vala_ccode_node_unref (converted_value), NULL));
						(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
					}
					(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
				}
				_tmp181 = NULL;
				vala_ccode_function_call_add_argument (ccall, _tmp181 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
				(_tmp181 == NULL) ? NULL : (_tmp181 = (vala_ccode_node_unref (_tmp181), NULL));
				_tmp184 = NULL;
				_tmp183 = NULL;
				_tmp182 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp184 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp183 = vala_ccode_identifier_new (_tmp182 = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))))));
				(_tmp184 == NULL) ? NULL : (_tmp184 = (vala_ccode_node_unref (_tmp184), NULL));
				(_tmp183 == NULL) ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL));
				_tmp182 = (g_free (_tmp182), NULL);
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			} else {
				ValaCCodeExpression* _tmp185;
				ValaCCodeIdentifier* _tmp186;
				_tmp185 = NULL;
				vala_ccode_function_call_add_argument (ccall, _tmp185 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
				(_tmp185 == NULL) ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL));
				_tmp186 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp186 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
				(_tmp186 == NULL) ? NULL : (_tmp186 = (vala_ccode_node_unref (_tmp186), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (method))) {
		ValaArrayType* _tmp188;
		ValaDataType* _tmp187;
		ValaArrayType* array_type;
		gboolean _tmp189;
		/* synchronous D-Bus method call with reply*/
		_tmp188 = NULL;
		_tmp187 = NULL;
		array_type = (_tmp188 = (_tmp187 = vala_method_get_return_type (method), VALA_IS_ARRAY_TYPE (_tmp187) ? ((ValaArrayType*) _tmp187) : NULL), (_tmp188 == NULL) ? NULL : vala_code_node_ref (_tmp188));
		_tmp189 = FALSE;
		if (array_type != NULL) {
			_tmp189 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
		} else {
			_tmp189 = FALSE;
		}
		if (_tmp189) {
			ValaCCodeExpression* _tmp190;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp193;
			ValaCCodeUnaryExpression* _tmp195;
			ValaCCodeIdentifier* _tmp194;
			ValaCCodeIdentifier* _tmp196;
			ValaCCodeExpressionStatement* _tmp197;
			ValaCCodeBlock* creturnblock;
			ValaCCodeReturnStatement* _tmp199;
			ValaCCodeExpression* _tmp198;
			ValaCCodeUnaryExpression* _tmp201;
			ValaCCodeIdentifier* _tmp200;
			ValaCCodeIfStatement* _tmp202;
			ValaCCodeIfStatement* cerrorif;
			ValaCCodeIdentifier* _tmp203;
			ValaCCodeMemberAccess* _tmp204;
			ValaCCodeMemberAccess* garray_length;
			ValaCCodeIdentifier* _tmp205;
			ValaCCodeUnaryExpression* _tmp206;
			ValaCCodeUnaryExpression* result_length;
			ValaCCodeAssignment* assign;
			ValaCCodeExpressionStatement* _tmp207;
			const char* _tmp208;
			ValaCCodeReturnStatement* _tmp213;
			ValaCCodeCastExpression* _tmp212;
			char* _tmp211;
			ValaCCodeMemberAccess* _tmp210;
			ValaCCodeIdentifier* _tmp209;
			/* non-string arrays (use GArray)*/
			_tmp190 = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp190 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, (ValaDataType*) array_type));
			(_tmp190 == NULL) ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL));
			cdecl_ = NULL;
			if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
				ValaCCodeDeclaration* _tmp191;
				_tmp191 = NULL;
				cdecl_ = (_tmp191 = vala_ccode_declaration_new ("GPtrArray*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp191);
			} else {
				ValaCCodeDeclaration* _tmp192;
				_tmp192 = NULL;
				cdecl_ = (_tmp192 = vala_ccode_declaration_new ("GArray*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp192);
			}
			_tmp193 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp193 = vala_ccode_variable_declarator_new ("result", NULL)));
			(_tmp193 == NULL) ? NULL : (_tmp193 = (vala_ccode_node_unref (_tmp193), NULL));
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
			_tmp195 = NULL;
			_tmp194 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp195 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp194 = vala_ccode_identifier_new ("result")))));
			(_tmp195 == NULL) ? NULL : (_tmp195 = (vala_ccode_node_unref (_tmp195), NULL));
			(_tmp194 == NULL) ? NULL : (_tmp194 = (vala_ccode_node_unref (_tmp194), NULL));
			_tmp196 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp196 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
			(_tmp196 == NULL) ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL));
			_tmp197 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp197 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp197 == NULL) ? NULL : (_tmp197 = (vala_ccode_node_unref (_tmp197), NULL));
			/* don't access result when error occured*/
			creturnblock = vala_ccode_block_new ();
			_tmp199 = NULL;
			_tmp198 = NULL;
			vala_ccode_block_add_statement (creturnblock, (ValaCCodeNode*) (_tmp199 = vala_ccode_return_statement_new (_tmp198 = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, vala_method_get_return_type (method), FALSE))));
			(_tmp199 == NULL) ? NULL : (_tmp199 = (vala_ccode_node_unref (_tmp199), NULL));
			(_tmp198 == NULL) ? NULL : (_tmp198 = (vala_ccode_node_unref (_tmp198), NULL));
			_tmp201 = NULL;
			_tmp200 = NULL;
			_tmp202 = NULL;
			cerrorif = (_tmp202 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp201 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp200 = vala_ccode_identifier_new ("error")))), (ValaCCodeStatement*) creturnblock, NULL), (_tmp201 == NULL) ? NULL : (_tmp201 = (vala_ccode_node_unref (_tmp201), NULL)), (_tmp200 == NULL) ? NULL : (_tmp200 = (vala_ccode_node_unref (_tmp200), NULL)), _tmp202);
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) cerrorif);
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) out_marshalling_fragment);
			/* *result_length1 = result->len;*/
			_tmp203 = NULL;
			_tmp204 = NULL;
			garray_length = (_tmp204 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp203 = vala_ccode_identifier_new ("result")), "len"), (_tmp203 == NULL) ? NULL : (_tmp203 = (vala_ccode_node_unref (_tmp203), NULL)), _tmp204);
			_tmp205 = NULL;
			_tmp206 = NULL;
			result_length = (_tmp206 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp205 = vala_ccode_identifier_new ("result_length1"))), (_tmp205 == NULL) ? NULL : (_tmp205 = (vala_ccode_node_unref (_tmp205), NULL)), _tmp206);
			assign = vala_ccode_assignment_new ((ValaCCodeExpression*) result_length, (ValaCCodeExpression*) garray_length, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_tmp207 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp207 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
			(_tmp207 == NULL) ? NULL : (_tmp207 = (vala_ccode_node_unref (_tmp207), NULL));
			_tmp208 = NULL;
			if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
				_tmp208 = "pdata";
			} else {
				_tmp208 = "data";
			}
			/* return result->data;*/
			_tmp213 = NULL;
			_tmp212 = NULL;
			_tmp211 = NULL;
			_tmp210 = NULL;
			_tmp209 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp213 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp212 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp210 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp209 = vala_ccode_identifier_new ("result")), _tmp208)), _tmp211 = vala_data_type_get_cname (vala_method_get_return_type (method)))))));
			(_tmp213 == NULL) ? NULL : (_tmp213 = (vala_ccode_node_unref (_tmp213), NULL));
			(_tmp212 == NULL) ? NULL : (_tmp212 = (vala_ccode_node_unref (_tmp212), NULL));
			_tmp211 = (g_free (_tmp211), NULL);
			(_tmp210 == NULL) ? NULL : (_tmp210 = (vala_ccode_node_unref (_tmp210), NULL));
			(_tmp209 == NULL) ? NULL : (_tmp209 = (vala_ccode_node_unref (_tmp209), NULL));
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			(creturnblock == NULL) ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL));
			(cerrorif == NULL) ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL));
			(garray_length == NULL) ? NULL : (garray_length = (vala_ccode_node_unref (garray_length), NULL));
			(result_length == NULL) ? NULL : (result_length = (vala_ccode_node_unref (result_length), NULL));
			(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
		} else {
			ValaCCodeExpression* _tmp214;
			char* _tmp215;
			ValaCCodeDeclaration* _tmp216;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp217;
			ValaCCodeUnaryExpression* _tmp219;
			ValaCCodeIdentifier* _tmp218;
			ValaCCodeIdentifier* _tmp220;
			ValaCCodeExpressionStatement* _tmp221;
			ValaCCodeBlock* creturnblock;
			ValaCCodeReturnStatement* _tmp223;
			ValaCCodeExpression* _tmp222;
			ValaCCodeUnaryExpression* _tmp225;
			ValaCCodeIdentifier* _tmp224;
			ValaCCodeIfStatement* _tmp226;
			ValaCCodeIfStatement* cerrorif;
			ValaCCodeReturnStatement* _tmp234;
			ValaCCodeIdentifier* _tmp233;
			/* string arrays or other datatypes*/
			_tmp214 = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp214 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_method_get_return_type (method)));
			(_tmp214 == NULL) ? NULL : (_tmp214 = (vala_ccode_node_unref (_tmp214), NULL));
			_tmp215 = NULL;
			_tmp216 = NULL;
			cdecl_ = (_tmp216 = vala_ccode_declaration_new (_tmp215 = vala_data_type_get_cname (vala_method_get_return_type (method))), _tmp215 = (g_free (_tmp215), NULL), _tmp216);
			_tmp217 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp217 = vala_ccode_variable_declarator_new ("result", NULL)));
			(_tmp217 == NULL) ? NULL : (_tmp217 = (vala_ccode_node_unref (_tmp217), NULL));
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
			_tmp219 = NULL;
			_tmp218 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp219 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp218 = vala_ccode_identifier_new ("result")))));
			(_tmp219 == NULL) ? NULL : (_tmp219 = (vala_ccode_node_unref (_tmp219), NULL));
			(_tmp218 == NULL) ? NULL : (_tmp218 = (vala_ccode_node_unref (_tmp218), NULL));
			_tmp220 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp220 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
			(_tmp220 == NULL) ? NULL : (_tmp220 = (vala_ccode_node_unref (_tmp220), NULL));
			_tmp221 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp221 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp221 == NULL) ? NULL : (_tmp221 = (vala_ccode_node_unref (_tmp221), NULL));
			/* don't access result when error occured*/
			creturnblock = vala_ccode_block_new ();
			_tmp223 = NULL;
			_tmp222 = NULL;
			vala_ccode_block_add_statement (creturnblock, (ValaCCodeNode*) (_tmp223 = vala_ccode_return_statement_new (_tmp222 = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, vala_method_get_return_type (method), FALSE))));
			(_tmp223 == NULL) ? NULL : (_tmp223 = (vala_ccode_node_unref (_tmp223), NULL));
			(_tmp222 == NULL) ? NULL : (_tmp222 = (vala_ccode_node_unref (_tmp222), NULL));
			_tmp225 = NULL;
			_tmp224 = NULL;
			_tmp226 = NULL;
			cerrorif = (_tmp226 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp225 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp224 = vala_ccode_identifier_new ("error")))), (ValaCCodeStatement*) creturnblock, NULL), (_tmp225 == NULL) ? NULL : (_tmp225 = (vala_ccode_node_unref (_tmp225), NULL)), (_tmp224 == NULL) ? NULL : (_tmp224 = (vala_ccode_node_unref (_tmp224), NULL)), _tmp226);
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) cerrorif);
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) out_marshalling_fragment);
			if (array_type != NULL) {
				ValaCCodeIdentifier* _tmp227;
				ValaCCodeFunctionCall* _tmp228;
				ValaCCodeFunctionCall* cstrvlen;
				ValaCCodeIdentifier* _tmp229;
				ValaCCodeIdentifier* _tmp230;
				ValaCCodeUnaryExpression* _tmp231;
				ValaCCodeUnaryExpression* result_length;
				ValaCCodeAssignment* assign;
				ValaCCodeExpressionStatement* _tmp232;
				/* special case string array
				 *result_length1 = g_strv_length (result);*/
				_tmp227 = NULL;
				_tmp228 = NULL;
				cstrvlen = (_tmp228 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp227 = vala_ccode_identifier_new ("g_strv_length"))), (_tmp227 == NULL) ? NULL : (_tmp227 = (vala_ccode_node_unref (_tmp227), NULL)), _tmp228);
				_tmp229 = NULL;
				vala_ccode_function_call_add_argument (cstrvlen, (ValaCCodeExpression*) (_tmp229 = vala_ccode_identifier_new ("result")));
				(_tmp229 == NULL) ? NULL : (_tmp229 = (vala_ccode_node_unref (_tmp229), NULL));
				_tmp230 = NULL;
				_tmp231 = NULL;
				result_length = (_tmp231 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp230 = vala_ccode_identifier_new ("result_length1"))), (_tmp230 == NULL) ? NULL : (_tmp230 = (vala_ccode_node_unref (_tmp230), NULL)), _tmp231);
				assign = vala_ccode_assignment_new ((ValaCCodeExpression*) result_length, (ValaCCodeExpression*) cstrvlen, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
				_tmp232 = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp232 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
				(_tmp232 == NULL) ? NULL : (_tmp232 = (vala_ccode_node_unref (_tmp232), NULL));
				(cstrvlen == NULL) ? NULL : (cstrvlen = (vala_ccode_node_unref (cstrvlen), NULL));
				(result_length == NULL) ? NULL : (result_length = (vala_ccode_node_unref (result_length), NULL));
				(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
			}
			_tmp234 = NULL;
			_tmp233 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp234 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp233 = vala_ccode_identifier_new ("result")))));
			(_tmp234 == NULL) ? NULL : (_tmp234 = (vala_ccode_node_unref (_tmp234), NULL));
			(_tmp233 == NULL) ? NULL : (_tmp233 = (vala_ccode_node_unref (_tmp233), NULL));
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			(creturnblock == NULL) ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL));
			(cerrorif == NULL) ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL));
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		ValaCCodeIdentifier* _tmp235;
		ValaCCodeExpressionStatement* _tmp236;
		ValaCCodeBlock* creturnblock;
		ValaCCodeReturnStatement* _tmp237;
		ValaCCodeUnaryExpression* _tmp239;
		ValaCCodeIdentifier* _tmp238;
		ValaCCodeIfStatement* _tmp240;
		ValaCCodeIfStatement* cerrorif;
		_tmp235 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp235 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
		(_tmp235 == NULL) ? NULL : (_tmp235 = (vala_ccode_node_unref (_tmp235), NULL));
		_tmp236 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp236 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp236 == NULL) ? NULL : (_tmp236 = (vala_ccode_node_unref (_tmp236), NULL));
		/* don't access result when error occured*/
		creturnblock = vala_ccode_block_new ();
		_tmp237 = NULL;
		vala_ccode_block_add_statement (creturnblock, (ValaCCodeNode*) (_tmp237 = vala_ccode_return_statement_new (NULL)));
		(_tmp237 == NULL) ? NULL : (_tmp237 = (vala_ccode_node_unref (_tmp237), NULL));
		_tmp239 = NULL;
		_tmp238 = NULL;
		_tmp240 = NULL;
		cerrorif = (_tmp240 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp239 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp238 = vala_ccode_identifier_new ("error")))), (ValaCCodeStatement*) creturnblock, NULL), (_tmp239 == NULL) ? NULL : (_tmp239 = (vala_ccode_node_unref (_tmp239), NULL)), (_tmp238 == NULL) ? NULL : (_tmp238 = (vala_ccode_node_unref (_tmp238), NULL)), _tmp240);
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cerrorif);
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) out_marshalling_fragment);
		(creturnblock == NULL) ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL));
		(cerrorif == NULL) ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL));
	}
	(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
	(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
	(out_marshalling_fragment == NULL) ? NULL : (out_marshalling_fragment = (vala_ccode_node_unref (out_marshalling_fragment), NULL));
}


static ValaCCodeExpression* vala_dbus_client_module_real_get_dbus_g_type (ValaGSignalModule* base, ValaDataType* data_type) {
	ValaDBusClientModule * self;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (data_type != NULL, NULL);
	if (VALA_IS_ARRAY_TYPE (data_type)) {
		ValaArrayType* _tmp1;
		ValaDataType* _tmp0;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeFunctionCall* _tmp4;
		ValaCCodeFunctionCall* carray_type;
		ValaCCodeExpression* _tmp7;
		ValaCCodeExpression* _tmp8;
		_tmp1 = NULL;
		_tmp0 = NULL;
		array_type = (_tmp1 = (_tmp0 = data_type, VALA_IS_ARRAY_TYPE (_tmp0) ? ((ValaArrayType*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
			ValaCCodeExpression* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = (ValaCCodeExpression*) vala_ccode_identifier_new ("G_TYPE_STRV"), (array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)), _tmp2);
		}
		_tmp3 = NULL;
		_tmp4 = NULL;
		carray_type = (_tmp4 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("dbus_g_type_get_collection"))), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), _tmp4);
		if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
			ValaCCodeConstant* _tmp5;
			_tmp5 = NULL;
			vala_ccode_function_call_add_argument (carray_type, (ValaCCodeExpression*) (_tmp5 = vala_ccode_constant_new ("\"GPtrArray\"")));
			(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
		} else {
			ValaCCodeConstant* _tmp6;
			_tmp6 = NULL;
			vala_ccode_function_call_add_argument (carray_type, (ValaCCodeExpression*) (_tmp6 = vala_ccode_constant_new ("\"GArray\"")));
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		}
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (carray_type, _tmp7 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_array_type_get_element_type (array_type)));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		_tmp8 = NULL;
		return (_tmp8 = (ValaCCodeExpression*) carray_type, (array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)), _tmp8);
	} else {
		if (VALA_IS_ENUM (vala_data_type_get_data_type (data_type))) {
			ValaEnum* _tmp9;
			ValaEnum* en;
			_tmp9 = NULL;
			en = (_tmp9 = VALA_ENUM (vala_data_type_get_data_type (data_type)), (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9));
			if (vala_enum_get_is_flags (en)) {
				ValaCCodeExpression* _tmp10;
				_tmp10 = NULL;
				return (_tmp10 = (ValaCCodeExpression*) vala_ccode_identifier_new ("G_TYPE_UINT"), (en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL)), _tmp10);
			} else {
				ValaCCodeExpression* _tmp11;
				_tmp11 = NULL;
				return (_tmp11 = (ValaCCodeExpression*) vala_ccode_identifier_new ("G_TYPE_INT"), (en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL)), _tmp11);
			}
			(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
		} else {
			if (vala_data_type_get_data_type (data_type) == NULL) {
				char* _tmp12;
				_tmp12 = NULL;
				g_critical ("valadbusclientmodule.vala:471: Internal error during DBus type generation with: %s", _tmp12 = vala_code_node_to_string ((ValaCodeNode*) data_type));
				_tmp12 = (g_free (_tmp12), NULL);
				return (ValaCCodeExpression*) vala_ccode_identifier_new ("G_TYPE_NONE");
			} else {
				char* _tmp14;
				gboolean _tmp15;
				_tmp14 = NULL;
				if ((_tmp15 = _vala_strcmp0 (_tmp14 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (data_type)), "GLib.HashTable") == 0, _tmp14 = (g_free (_tmp14), NULL), _tmp15)) {
					ValaCCodeIdentifier* _tmp16;
					ValaCCodeFunctionCall* _tmp17;
					ValaCCodeFunctionCall* cmap_type;
					GeeList* type_args;
					ValaCCodeConstant* _tmp18;
					ValaCCodeExpression* _tmp20;
					_tmp16 = NULL;
					_tmp17 = NULL;
					cmap_type = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("dbus_g_type_get_map"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
					type_args = vala_data_type_get_type_arguments (data_type);
					_tmp18 = NULL;
					vala_ccode_function_call_add_argument (cmap_type, (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new ("\"GHashTable\"")));
					(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
					{
						GeeIterator* _type_arg_it;
						_type_arg_it = gee_iterable_iterator ((GeeIterable*) type_args);
						while (gee_iterator_next (_type_arg_it)) {
							ValaDataType* type_arg;
							ValaCCodeExpression* _tmp19;
							type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
							_tmp19 = NULL;
							vala_ccode_function_call_add_argument (cmap_type, _tmp19 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, type_arg));
							(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
							(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
						}
						(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
					}
					_tmp20 = NULL;
					return (_tmp20 = (ValaCCodeExpression*) cmap_type, (type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL)), _tmp20);
				} else {
					char* _tmp21;
					gboolean _tmp22;
					_tmp21 = NULL;
					if ((_tmp22 = g_str_has_prefix (_tmp21 = vala_typesymbol_get_type_signature (vala_data_type_get_data_type (data_type)), "("), _tmp21 = (g_free (_tmp21), NULL), _tmp22)) {
						ValaStruct* _tmp23;
						ValaStruct* st;
						ValaCCodeIdentifier* _tmp24;
						ValaCCodeFunctionCall* _tmp25;
						ValaCCodeFunctionCall* type_call;
						ValaCCodeConstant* _tmp26;
						ValaCCodeConstant* _tmp30;
						ValaCCodeExpression* _tmp31;
						/* struct parameter*/
						_tmp23 = NULL;
						st = (_tmp23 = VALA_STRUCT (vala_data_type_get_data_type (data_type)), (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23));
						_tmp24 = NULL;
						_tmp25 = NULL;
						type_call = (_tmp25 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("dbus_g_type_get_struct"))), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp25);
						_tmp26 = NULL;
						vala_ccode_function_call_add_argument (type_call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_constant_new ("\"GValueArray\"")));
						(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
						{
							GeeList* _tmp27;
							GeeIterator* _tmp28;
							GeeIterator* _f_it;
							_tmp27 = NULL;
							_tmp28 = NULL;
							_f_it = (_tmp28 = gee_iterable_iterator ((GeeIterable*) (_tmp27 = vala_struct_get_fields (st))), (_tmp27 == NULL) ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL)), _tmp28);
							while (gee_iterator_next (_f_it)) {
								ValaField* f;
								ValaCCodeExpression* _tmp29;
								f = (ValaField*) gee_iterator_get (_f_it);
								if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
									(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
									continue;
								}
								_tmp29 = NULL;
								vala_ccode_function_call_add_argument (type_call, _tmp29 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_field_get_field_type (f)));
								(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
								(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
							}
							(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
						}
						_tmp30 = NULL;
						vala_ccode_function_call_add_argument (type_call, (ValaCCodeExpression*) (_tmp30 = vala_ccode_constant_new ("G_TYPE_INVALID")));
						(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
						_tmp31 = NULL;
						return (_tmp31 = (ValaCCodeExpression*) type_call, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp31);
					} else {
						char* _tmp32;
						ValaCCodeExpression* _tmp33;
						_tmp32 = NULL;
						_tmp33 = NULL;
						return (_tmp33 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp32 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (data_type))), _tmp32 = (g_free (_tmp32), NULL), _tmp33);
					}
				}
			}
		}
	}
}


gboolean vala_dbus_client_module_dbus_use_ptr_array (ValaDBusClientModule* self, ValaArrayType* array_type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (array_type != NULL, FALSE);
	if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
		/* use char***/
		return FALSE;
	} else {
		gboolean _tmp1;
		gboolean _tmp2;
		gboolean _tmp3;
		gboolean _tmp4;
		gboolean _tmp5;
		gboolean _tmp6;
		gboolean _tmp7;
		gboolean _tmp8;
		gboolean _tmp9;
		gboolean _tmp10;
		gboolean _tmp11;
		gboolean _tmp12;
		gboolean _tmp13;
		_tmp1 = FALSE;
		_tmp2 = FALSE;
		_tmp3 = FALSE;
		_tmp4 = FALSE;
		_tmp5 = FALSE;
		_tmp6 = FALSE;
		_tmp7 = FALSE;
		_tmp8 = FALSE;
		_tmp9 = FALSE;
		_tmp10 = FALSE;
		_tmp11 = FALSE;
		_tmp12 = FALSE;
		_tmp13 = FALSE;
		if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->bool_type)) {
			_tmp13 = TRUE;
		} else {
			_tmp13 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->char_type);
		}
		if (_tmp13) {
			_tmp12 = TRUE;
		} else {
			_tmp12 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->uchar_type);
		}
		if (_tmp12) {
			_tmp11 = TRUE;
		} else {
			_tmp11 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->int_type);
		}
		if (_tmp11) {
			_tmp10 = TRUE;
		} else {
			_tmp10 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->uint_type);
		}
		if (_tmp10) {
			_tmp9 = TRUE;
		} else {
			_tmp9 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->long_type);
		}
		if (_tmp9) {
			_tmp8 = TRUE;
		} else {
			_tmp8 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->ulong_type);
		}
		if (_tmp8) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->int8_type);
		}
		if (_tmp7) {
			_tmp6 = TRUE;
		} else {
			_tmp6 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->uint8_type);
		}
		if (_tmp6) {
			_tmp5 = TRUE;
		} else {
			_tmp5 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->int32_type);
		}
		if (_tmp5) {
			_tmp4 = TRUE;
		} else {
			_tmp4 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->uint32_type);
		}
		if (_tmp4) {
			_tmp3 = TRUE;
		} else {
			_tmp3 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->int64_type);
		}
		if (_tmp3) {
			_tmp2 = TRUE;
		} else {
			_tmp2 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->uint64_type);
		}
		if (_tmp2) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->double_type);
		}
		if (_tmp1) {
			/* use GArray*/
			return FALSE;
		} else {
			/* use GPtrArray*/
			return TRUE;
		}
	}
}


static char* vala_dbus_client_module_real_get_dynamic_property_getter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop) {
	ValaDBusClientModule * self;
	char* getter_cname;
	char* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp5;
	char* _tmp6;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)) != ((ValaCCodeBaseModule*) self)->dbus_object_type) {
		return VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->get_dynamic_property_getter_cname ((ValaCCodeModule*) VALA_DBUS_MODULE (self), prop);
	}
	getter_cname = g_strdup_printf ("_dynamic_get_%s%d", vala_symbol_get_name ((ValaSymbol*) prop), self->priv->dynamic_property_id++);
	_tmp1 = NULL;
	_tmp2 = NULL;
	func = (_tmp2 = vala_ccode_function_new (getter_cname, _tmp1 = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) prop))), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	vala_ccode_function_set_modifiers (func, vala_ccode_function_get_modifiers (func) | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (func, _tmp4 = vala_ccode_formal_parameter_new ("obj", _tmp3 = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (prop))));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	block = vala_ccode_block_new ();
	vala_dbus_client_module_generate_dbus_property_getter_wrapper (self, prop, block);
	/* append to C source file*/
	_tmp5 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp5 = vala_ccode_function_copy (func)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	_tmp6 = NULL;
	return (_tmp6 = getter_cname, (func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp6);
}


static char* vala_dbus_client_module_real_get_dynamic_property_setter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop) {
	ValaDBusClientModule * self;
	char* setter_cname;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp2;
	char* _tmp1;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp5;
	char* _tmp6;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)) != ((ValaCCodeBaseModule*) self)->dbus_object_type) {
		return VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->get_dynamic_property_setter_cname ((ValaCCodeModule*) VALA_DBUS_MODULE (self), prop);
	}
	setter_cname = g_strdup_printf ("_dynamic_set_%s%d", vala_symbol_get_name ((ValaSymbol*) prop), self->priv->dynamic_property_id++);
	func = vala_ccode_function_new (setter_cname, "void");
	vala_ccode_function_set_modifiers (func, vala_ccode_function_get_modifiers (func) | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (func, _tmp2 = vala_ccode_formal_parameter_new ("obj", _tmp1 = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (prop))));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (func, _tmp4 = vala_ccode_formal_parameter_new ("value", _tmp3 = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) prop))));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	block = vala_ccode_block_new ();
	vala_dbus_client_module_generate_dbus_property_setter_wrapper (self, prop, block);
	/* append to C source file*/
	_tmp5 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp5 = vala_ccode_function_copy (func)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	_tmp6 = NULL;
	return (_tmp6 = setter_cname, (func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp6);
}


static void vala_dbus_client_module_create_dbus_property_proxy (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* prop_proxy_call;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeConstant* _tmp4;
	ValaCCodeDeclaration* prop_proxy_decl;
	ValaCCodeVariableDeclarator* _tmp5;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	prop_proxy_call = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("dbus_g_proxy_new_from_proxy"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("obj")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, (ValaCCodeExpression*) (_tmp3 = vala_ccode_constant_new ("DBUS_INTERFACE_PROPERTIES")));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, (ValaCCodeExpression*) (_tmp4 = vala_ccode_constant_new ("NULL")));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	prop_proxy_decl = vala_ccode_declaration_new ("DBusGProxy*");
	_tmp5 = NULL;
	vala_ccode_declaration_add_declarator (prop_proxy_decl, (ValaCCodeDeclarator*) (_tmp5 = vala_ccode_variable_declarator_new ("property_proxy", (ValaCCodeExpression*) prop_proxy_call)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prop_proxy_decl);
	(prop_proxy_call == NULL) ? NULL : (prop_proxy_call = (vala_ccode_node_unref (prop_proxy_call), NULL));
	(prop_proxy_decl == NULL) ? NULL : (prop_proxy_decl = (vala_ccode_node_unref (prop_proxy_decl), NULL));
}


static void vala_dbus_client_module_generate_dbus_property_getter_wrapper (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeInitializerList* cvalinit;
	ValaCCodeConstant* _tmp0;
	ValaCCodeDeclaration* cval_decl;
	ValaCCodeVariableDeclarator* _tmp1;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeUnaryExpression* _tmp3;
	ValaCCodeUnaryExpression* val_ptr;
	char* _tmp4;
	ValaCCodeDeclaration* _tmp5;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp6;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeConstant* _tmp10;
	ValaCCodeConstant* _tmp11;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* get_iface;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeConstant* _tmp19;
	char* _tmp18;
	char* _tmp17;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeExpressionStatement* _tmp23;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeFunctionCall* _tmp25;
	ValaCCodeFunctionCall* prop_proxy_unref;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeExpressionStatement* _tmp27;
	ValaCCodeIdentifier* _tmp29;
	char* _tmp28;
	ValaCCodeFunctionCall* _tmp30;
	ValaCCodeFunctionCall* cget_call;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeAssignment* _tmp32;
	ValaCCodeAssignment* assign;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeReturnStatement* _tmp35;
	ValaCCodeIdentifier* _tmp34;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	vala_dbus_client_module_create_dbus_property_proxy (self, node, block);
	/* initialize GValue*/
	cvalinit = vala_ccode_initializer_list_new ();
	_tmp0 = NULL;
	vala_ccode_initializer_list_append (cvalinit, (ValaCCodeExpression*) (_tmp0 = vala_ccode_constant_new ("0")));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	cval_decl = vala_ccode_declaration_new ("GValue");
	_tmp1 = NULL;
	vala_ccode_declaration_add_declarator (cval_decl, (ValaCCodeDeclarator*) (_tmp1 = vala_ccode_variable_declarator_new ("gvalue", (ValaCCodeExpression*) cvalinit)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cval_decl);
	_tmp2 = NULL;
	_tmp3 = NULL;
	val_ptr = (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("gvalue"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
	/* call Get method on property proxy*/
	_tmp4 = NULL;
	_tmp5 = NULL;
	cdecl_ = (_tmp5 = vala_ccode_declaration_new (_tmp4 = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) node))), _tmp4 = (g_free (_tmp4), NULL), _tmp5);
	_tmp6 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp6 = vala_ccode_variable_declarator_new ("result", NULL)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("dbus_g_proxy_call"))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("property_proxy")));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp10 = vala_ccode_constant_new ("\"Get\"")));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new ("NULL")));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("G_TYPE_STRING")));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp13 = NULL;
	_tmp14 = NULL;
	get_iface = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("dbus_g_proxy_get_interface"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (get_iface, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("obj")));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) get_iface);
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("G_TYPE_STRING")));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new (_tmp18 = g_strdup_printf ("\"%s\"", _tmp17 = vala_dbus_client_module_get_dynamic_dbus_name (self, vala_symbol_get_name ((ValaSymbol*) node))))));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp18 = (g_free (_tmp18), NULL);
	_tmp17 = (g_free (_tmp17), NULL);
	_tmp20 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("G_TYPE_VALUE")));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) val_ptr);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	_tmp23 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp23 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	/* unref property proxy*/
	_tmp24 = NULL;
	_tmp25 = NULL;
	prop_proxy_unref = (_tmp25 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("g_object_unref"))), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp25);
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_unref, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("property_proxy")));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp27 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp27 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) prop_proxy_unref)));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	/* assign value to result variable*/
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp30 = NULL;
	cget_call = (_tmp30 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new (_tmp28 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_property_get_property_type ((ValaProperty*) node)))))), (_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)), _tmp28 = (g_free (_tmp28), NULL), _tmp30);
	vala_ccode_function_call_add_argument (cget_call, (ValaCCodeExpression*) val_ptr);
	_tmp31 = NULL;
	_tmp32 = NULL;
	assign = (_tmp32 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("result")), (ValaCCodeExpression*) cget_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)), _tmp32);
	_tmp33 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp33 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	/* return result*/
	_tmp35 = NULL;
	_tmp34 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp35 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("result")))));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	(cvalinit == NULL) ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL));
	(cval_decl == NULL) ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL));
	(val_ptr == NULL) ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(get_iface == NULL) ? NULL : (get_iface = (vala_ccode_node_unref (get_iface), NULL));
	(prop_proxy_unref == NULL) ? NULL : (prop_proxy_unref = (vala_ccode_node_unref (prop_proxy_unref), NULL));
	(cget_call == NULL) ? NULL : (cget_call = (vala_ccode_node_unref (cget_call), NULL));
	(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
}


static void vala_dbus_client_module_generate_dbus_property_setter_wrapper (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeInitializerList* cvalinit;
	ValaCCodeConstant* _tmp0;
	ValaCCodeDeclaration* cval_decl;
	ValaCCodeVariableDeclarator* _tmp1;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeUnaryExpression* _tmp3;
	ValaCCodeUnaryExpression* val_ptr;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* cinit_call;
	ValaCCodeIdentifier* _tmp7;
	char* _tmp6;
	ValaCCodeExpressionStatement* _tmp8;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* cset_call;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeExpressionStatement* _tmp13;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeConstant* _tmp17;
	ValaCCodeConstant* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* get_iface;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeConstant* _tmp26;
	char* _tmp25;
	char* _tmp24;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeExpressionStatement* _tmp30;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeFunctionCall* _tmp32;
	ValaCCodeFunctionCall* prop_proxy_unref;
	ValaCCodeIdentifier* _tmp33;
	ValaCCodeExpressionStatement* _tmp34;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	vala_dbus_client_module_create_dbus_property_proxy (self, node, block);
	/* initialize GValue*/
	cvalinit = vala_ccode_initializer_list_new ();
	_tmp0 = NULL;
	vala_ccode_initializer_list_append (cvalinit, (ValaCCodeExpression*) (_tmp0 = vala_ccode_constant_new ("0")));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	cval_decl = vala_ccode_declaration_new ("GValue");
	_tmp1 = NULL;
	vala_ccode_declaration_add_declarator (cval_decl, (ValaCCodeDeclarator*) (_tmp1 = vala_ccode_variable_declarator_new ("gvalue", (ValaCCodeExpression*) cvalinit)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cval_decl);
	_tmp2 = NULL;
	_tmp3 = NULL;
	val_ptr = (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("gvalue"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	cinit_call = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("g_value_init"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
	vala_ccode_function_call_add_argument (cinit_call, (ValaCCodeExpression*) val_ptr);
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (cinit_call, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (_tmp6 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_property_get_property_type ((ValaProperty*) node))))));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp8 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp8 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit_call)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cset_call = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new (_tmp9 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_property_get_property_type ((ValaProperty*) node)))))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp9 = (g_free (_tmp9), NULL), _tmp11);
	vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) val_ptr);
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("value")));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp13 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp13 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cset_call)));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	/* call Set method on property proxy*/
	_tmp14 = NULL;
	_tmp15 = NULL;
	ccall = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("dbus_g_proxy_call"))), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), _tmp15);
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("property_proxy")));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new ("\"Set\"")));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new ("NULL")));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("G_TYPE_STRING")));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp20 = NULL;
	_tmp21 = NULL;
	get_iface = (_tmp21 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("dbus_g_proxy_get_interface"))), (_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (get_iface, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("obj")));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) get_iface);
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("G_TYPE_STRING")));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp26 = vala_ccode_constant_new (_tmp25 = g_strdup_printf ("\"%s\"", _tmp24 = vala_dbus_client_module_get_dynamic_dbus_name (self, vala_symbol_get_name ((ValaSymbol*) node))))));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp25 = (g_free (_tmp25), NULL);
	_tmp24 = (g_free (_tmp24), NULL);
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("G_TYPE_VALUE")));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) val_ptr);
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	_tmp30 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp30 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	/* unref property proxy*/
	_tmp31 = NULL;
	_tmp32 = NULL;
	prop_proxy_unref = (_tmp32 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("g_object_unref"))), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)), _tmp32);
	_tmp33 = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_unref, (ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new ("property_proxy")));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	_tmp34 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp34 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) prop_proxy_unref)));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	(cvalinit == NULL) ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL));
	(cval_decl == NULL) ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL));
	(val_ptr == NULL) ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL));
	(cinit_call == NULL) ? NULL : (cinit_call = (vala_ccode_node_unref (cinit_call), NULL));
	(cset_call == NULL) ? NULL : (cset_call = (vala_ccode_node_unref (cset_call), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(get_iface == NULL) ? NULL : (get_iface = (vala_ccode_node_unref (get_iface), NULL));
	(prop_proxy_unref == NULL) ? NULL : (prop_proxy_unref = (vala_ccode_node_unref (prop_proxy_unref), NULL));
}


static char* vala_dbus_client_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig) {
	ValaDBusClientModule * self;
	char* _tmp1;
	char* _tmp2;
	char* connect_wrapper_name;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp7;
	char* _tmp8;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (sig)) != ((ValaCCodeBaseModule*) self)->dbus_object_type) {
		return VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeModule*) VALA_DBUS_MODULE (self), sig);
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	connect_wrapper_name = (_tmp2 = g_strdup_printf ("_%sconnect", _tmp1 = vala_ccode_module_get_dynamic_signal_cname ((ValaCCodeModule*) self, sig)), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	func = vala_ccode_function_new (connect_wrapper_name, "void");
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (func, _tmp3 = vala_ccode_formal_parameter_new ("obj", "gpointer"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (func, _tmp4 = vala_ccode_formal_parameter_new ("signal_name", "const char *"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (func, _tmp5 = vala_ccode_formal_parameter_new ("handler", "GCallback"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (func, _tmp6 = vala_ccode_formal_parameter_new ("data", "gpointer"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	block = vala_ccode_block_new ();
	vala_dbus_client_module_generate_dbus_connect_wrapper (self, sig, block);
	/* append to C source file*/
	_tmp7 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp7 = vala_ccode_function_copy (func)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	_tmp8 = NULL;
	return (_tmp8 = connect_wrapper_name, (func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp8);
}


static char* vala_dbus_client_module_real_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig) {
	ValaDBusClientModule * self;
	char* _tmp1;
	char* _tmp2;
	char* disconnect_wrapper_name;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp7;
	char* _tmp8;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (sig)) != ((ValaCCodeBaseModule*) self)->dbus_object_type) {
		return VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->get_dynamic_signal_disconnect_wrapper_name ((ValaCCodeModule*) VALA_DBUS_MODULE (self), sig);
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	disconnect_wrapper_name = (_tmp2 = g_strdup_printf ("_%sdisconnect", _tmp1 = vala_ccode_module_get_dynamic_signal_cname ((ValaCCodeModule*) self, sig)), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	func = vala_ccode_function_new (disconnect_wrapper_name, "void");
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (func, _tmp3 = vala_ccode_formal_parameter_new ("obj", "gpointer"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (func, _tmp4 = vala_ccode_formal_parameter_new ("signal_name", "const char *"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (func, _tmp5 = vala_ccode_formal_parameter_new ("handler", "GCallback"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (func, _tmp6 = vala_ccode_formal_parameter_new ("data", "gpointer"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	block = vala_ccode_block_new ();
	vala_dbus_client_module_generate_dbus_disconnect_wrapper (self, sig, block);
	/* append to C source file*/
	_tmp7 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp7 = vala_ccode_function_copy (func)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	_tmp8 = NULL;
	return (_tmp8 = disconnect_wrapper_name, (func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp8);
}


static void vala_dbus_client_module_generate_dbus_connect_wrapper (ValaDBusClientModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block) {
	ValaMethod* _tmp0;
	ValaMethod* m;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* register_call;
	GeeList* _tmp3;
	ValaCCodeIdentifier* _tmp6;
	char* _tmp5;
	GeeList* _tmp4;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* add_call;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeConstant* _tmp13;
	char* _tmp12;
	char* _tmp11;
	gboolean first;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeExpressionStatement* _tmp20;
	ValaCCodeExpressionStatement* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeFunctionCall* _tmp23;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeConstant* _tmp28;
	ValaCCodeExpressionStatement* _tmp29;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	m = (_tmp0 = VALA_METHOD (vala_expression_get_symbol_reference (vala_dynamic_signal_get_handler (sig))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	vala_code_node_accept ((ValaCodeNode*) sig, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* FIXME should only be done once per marshaller*/
	_tmp1 = NULL;
	_tmp2 = NULL;
	register_call = (_tmp2 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("dbus_g_object_register_marshaller"))), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_module_generate_marshaller (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp3 = vala_signal_get_parameters ((ValaSignal*) sig), vala_signal_get_return_type ((ValaSignal*) sig), TRUE);
	(_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL));
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new (_tmp5 = vala_ccode_module_get_marshaller_function (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp4 = vala_signal_get_parameters ((ValaSignal*) sig), vala_signal_get_return_type ((ValaSignal*) sig), NULL, TRUE))));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp5 = (g_free (_tmp5), NULL);
	(_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL));
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("G_TYPE_NONE")));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp8 = NULL;
	_tmp9 = NULL;
	add_call = (_tmp9 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new ("dbus_g_proxy_add_signal"))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp9);
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (add_call, (ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("obj")));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (add_call, (ValaCCodeExpression*) (_tmp13 = vala_ccode_constant_new (_tmp12 = g_strdup_printf ("\"%s\"", _tmp11 = vala_dbus_client_module_get_dynamic_dbus_name (self, vala_symbol_get_name ((ValaSymbol*) sig))))));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp12 = (g_free (_tmp12), NULL);
	_tmp11 = (g_free (_tmp11), NULL);
	first = TRUE;
	{
		GeeList* _tmp14;
		GeeIterator* _tmp15;
		GeeIterator* _param_it;
		_tmp14 = NULL;
		_tmp15 = NULL;
		_param_it = (_tmp15 = gee_iterable_iterator ((GeeIterable*) (_tmp14 = vala_method_get_parameters (m))), (_tmp14 == NULL) ? NULL : (_tmp14 = (gee_collection_object_unref (_tmp14), NULL)), _tmp15);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			ValaCCodeExpression* _tmp16;
			ValaCCodeExpression* _tmp17;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (first) {
				/* skip sender parameter*/
				first = FALSE;
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			_tmp16 = NULL;
			vala_ccode_function_call_add_argument (register_call, _tmp16 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
			(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
			_tmp17 = NULL;
			vala_ccode_function_call_add_argument (add_call, _tmp17 = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
			(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (add_call, (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp20 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp20 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) register_call)));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp21 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp21 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) add_call)));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp22 = NULL;
	_tmp23 = NULL;
	call = (_tmp23 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("dbus_g_proxy_connect_signal"))), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)), _tmp23);
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("obj")));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("signal_name")));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("handler")));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("data")));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp28 = vala_ccode_constant_new ("NULL")));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp29 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp29 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) call)));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(register_call == NULL) ? NULL : (register_call = (vala_ccode_node_unref (register_call), NULL));
	(add_call == NULL) ? NULL : (add_call = (vala_ccode_node_unref (add_call), NULL));
	(call == NULL) ? NULL : (call = (vala_ccode_node_unref (call), NULL));
}


static void vala_dbus_client_module_generate_dbus_disconnect_wrapper (ValaDBusClientModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeExpressionStatement* _tmp6;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	call = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("dbus_g_proxy_disconnect_signal"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("obj")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("signal_name")));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("handler")));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("data")));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp6 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) call)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	(call == NULL) ? NULL : (call = (vala_ccode_node_unref (call), NULL));
}


static void vala_dbus_client_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr) {
	ValaDBusClientModule * self;
	ValaObjectType* _tmp1;
	ValaDataType* _tmp0;
	ValaObjectType* type;
	ValaMethodCall* _tmp3;
	ValaExpression* _tmp2;
	ValaMethodCall* call;
	gboolean _tmp4;
	gboolean _tmp5;
	gboolean _tmp6;
	ValaMethodType* _tmp9;
	ValaDataType* _tmp8;
	ValaMethodType* mtype;
	gboolean _tmp10;
	GeeList* args;
	ValaExpression* _tmp12;
	ValaExpression* connection;
	ValaExpression* bus_name;
	ValaExpression* object_path;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	char* _tmp13;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeFunctionCall* ccall;
	self = (ValaDBusClientModule*) base;
	g_return_if_fail (expr != NULL);
	/* handles casting DBus.Object instances to DBus interfaces*/
	_tmp1 = NULL;
	_tmp0 = NULL;
	type = (_tmp1 = (_tmp0 = vala_cast_expression_get_type_reference (expr), VALA_IS_OBJECT_TYPE (_tmp0) ? ((ValaObjectType*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp3 = NULL;
	_tmp2 = NULL;
	call = (_tmp3 = (_tmp2 = vala_cast_expression_get_inner (expr), VALA_IS_METHOD_CALL (_tmp2) ? ((ValaMethodCall*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	_tmp4 = FALSE;
	_tmp5 = FALSE;
	_tmp6 = FALSE;
	if (type == NULL) {
		_tmp6 = TRUE;
	} else {
		_tmp6 = !VALA_IS_INTERFACE (vala_object_type_get_type_symbol (type));
	}
	if (_tmp6) {
		_tmp5 = TRUE;
	} else {
		ValaAttribute* _tmp7;
		_tmp7 = NULL;
		_tmp5 = (_tmp7 = vala_code_node_get_attribute ((ValaCodeNode*) vala_object_type_get_type_symbol (type), "DBus")) == NULL;
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_code_node_unref (_tmp7), NULL));
	}
	if (_tmp5) {
		_tmp4 = TRUE;
	} else {
		_tmp4 = call == NULL;
	}
	if (_tmp4) {
		VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->visit_cast_expression ((ValaCCodeModule*) VALA_DBUS_MODULE (self), expr);
		(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		(call == NULL) ? NULL : (call = (vala_code_node_unref (call), NULL));
		return;
	}
	_tmp9 = NULL;
	_tmp8 = NULL;
	mtype = (_tmp9 = (_tmp8 = vala_expression_get_value_type (vala_method_call_get_call (call)), VALA_IS_METHOD_TYPE (_tmp8) ? ((ValaMethodType*) _tmp8) : NULL), (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9));
	_tmp10 = FALSE;
	if (mtype == NULL) {
		_tmp10 = TRUE;
	} else {
		char* _tmp11;
		_tmp11 = NULL;
		_tmp10 = _vala_strcmp0 (_tmp11 = vala_method_get_cname (vala_method_type_get_method_symbol (mtype)), "dbus_g_proxy_new_for_name") != 0;
		_tmp11 = (g_free (_tmp11), NULL);
	}
	if (_tmp10) {
		VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->visit_cast_expression ((ValaCCodeModule*) VALA_DBUS_MODULE (self), expr);
		(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		(call == NULL) ? NULL : (call = (vala_code_node_unref (call), NULL));
		(mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL));
		return;
	}
	args = vala_method_call_get_argument_list (call);
	_tmp12 = NULL;
	connection = (_tmp12 = vala_member_access_get_inner (VALA_MEMBER_ACCESS (vala_method_call_get_call (call))), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
	bus_name = (ValaExpression*) gee_list_get (args, 0);
	object_path = (ValaExpression*) gee_list_get (args, 1);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp16 = NULL;
	ccall = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (_tmp14 = g_strconcat (_tmp13 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) vala_object_type_get_type_symbol (type)), "dbus_proxy_new", NULL)))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp14 = (g_free (_tmp14), NULL), _tmp13 = (g_free (_tmp13), NULL), _tmp16);
	vala_code_node_accept ((ValaCodeNode*) connection, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) connection)));
	vala_code_node_accept ((ValaCodeNode*) bus_name, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) bus_name)));
	vala_code_node_accept ((ValaCodeNode*) object_path, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) object_path)));
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
	(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
	(call == NULL) ? NULL : (call = (vala_code_node_unref (call), NULL));
	(mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL));
	(args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL));
	(connection == NULL) ? NULL : (connection = (vala_code_node_unref (connection), NULL));
	(bus_name == NULL) ? NULL : (bus_name = (vala_code_node_unref (bus_name), NULL));
	(object_path == NULL) ? NULL : (object_path = (vala_code_node_unref (object_path), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_dbus_client_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface) {
	ValaDBusClientModule * self;
	ValaAttribute* dbus;
	char* dbus_iface_name;
	char* _tmp0;
	char* _tmp1;
	char* cname;
	char* _tmp2;
	char* _tmp3;
	char* lower_cname;
	ValaCCodeTypeDefinition* _tmp5;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeTypeDefinition* _tmp8;
	ValaCCodeVariableDeclarator* _tmp7;
	char* _tmp6;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeFunctionCall* _tmp10;
	ValaCCodeFunctionCall* implement;
	ValaCCodeIdentifier* _tmp12;
	char* _tmp11;
	ValaCCodeIdentifier* _tmp14;
	char* _tmp13;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeFunctionCall* define_type;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeConstant* _tmp20;
	ValaCCodeExpressionStatement* _tmp21;
	char* _tmp24;
	char* _tmp23;
	char* _tmp22;
	ValaCCodeFunction* _tmp25;
	ValaCCodeFunction* proxy_new;
	ValaCCodeFormalParameter* _tmp26;
	ValaCCodeFormalParameter* _tmp27;
	ValaCCodeFormalParameter* _tmp28;
	ValaCCodeBlock* new_block;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeFunctionCall* _tmp30;
	ValaCCodeFunctionCall* new_call;
	ValaCCodeFunctionCall* _tmp33;
	ValaCCodeIdentifier* _tmp32;
	char* _tmp31;
	ValaCCodeConstant* _tmp34;
	ValaCCodeIdentifier* _tmp35;
	ValaCCodeConstant* _tmp36;
	ValaCCodeIdentifier* _tmp37;
	ValaCCodeConstant* _tmp38;
	ValaCCodeIdentifier* _tmp39;
	ValaCCodeConstant* _tmp40;
	ValaCCodeConstant* _tmp42;
	char* _tmp41;
	ValaCCodeConstant* _tmp43;
	char* _tmp45;
	char* _tmp44;
	ValaCCodeDeclaration* _tmp46;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp47;
	ValaCCodeIdentifier* _tmp48;
	ValaCCodeFunctionCall* _tmp49;
	ValaCCodeFunctionCall* raw_connection;
	ValaCCodeIdentifier* _tmp50;
	ValaCCodeIdentifier* _tmp51;
	ValaCCodeFunctionCall* _tmp52;
	ValaCCodeFunctionCall* filter_call;
	ValaCCodeIdentifier* _tmp54;
	char* _tmp53;
	ValaCCodeIdentifier* _tmp55;
	ValaCCodeConstant* _tmp56;
	ValaCCodeExpressionStatement* _tmp57;
	ValaCCodeIdentifier* _tmp58;
	ValaCCodeFunctionCall* _tmp59;
	ValaCCodeFunctionCall* filter_printf;
	ValaCCodeConstant* _tmp60;
	ValaCCodeIdentifier* _tmp61;
	ValaCCodeDeclaration* _tmp62;
	ValaCCodeVariableDeclarator* _tmp63;
	ValaCCodeIdentifier* _tmp64;
	ValaCCodeFunctionCall* _tmp65;
	ValaCCodeFunctionCall* match_call;
	ValaCCodeIdentifier* _tmp66;
	ValaCCodeConstant* _tmp67;
	ValaCCodeExpressionStatement* _tmp68;
	ValaCCodeIdentifier* _tmp69;
	ValaCCodeFunctionCall* _tmp70;
	ValaCCodeFunctionCall* filter_free;
	ValaCCodeIdentifier* _tmp71;
	ValaCCodeExpressionStatement* _tmp72;
	ValaCCodeReturnStatement* _tmp74;
	ValaCCodeIdentifier* _tmp73;
	ValaCCodeFunction* _tmp75;
	char* _tmp76;
	ValaCCodeFunction* _tmp77;
	ValaCCodeFunction* proxy_dispose;
	ValaCCodeFormalParameter* _tmp78;
	ValaCCodeBlock* _tmp79;
	ValaCCodeDeclaration* _tmp80;
	ValaCCodeVariableDeclarator* _tmp81;
	ValaCCodeIdentifier* _tmp82;
	ValaCCodeFunctionCall* _tmp83;
	ValaCCodeFunctionCall* gconnection;
	ValaCCodeIdentifier* _tmp84;
	ValaCCodeConstant* _tmp85;
	ValaCCodeUnaryExpression* _tmp87;
	ValaCCodeIdentifier* _tmp86;
	ValaCCodeConstant* _tmp88;
	ValaCCodeExpressionStatement* _tmp89;
	ValaCCodeFunctionCall* _tmp91;
	ValaCCodeIdentifier* _tmp90;
	ValaCCodeIdentifier* _tmp93;
	char* _tmp92;
	ValaCCodeIdentifier* _tmp94;
	ValaCCodeExpressionStatement* _tmp95;
	ValaCCodeIdentifier* _tmp96;
	ValaCCodeFunctionCall* _tmp97;
	ValaCCodeFunctionCall* parent_class;
	ValaCCodeIdentifier* _tmp99;
	char* _tmp98;
	ValaCCodeMemberAccess* _tmp100;
	ValaCCodeFunctionCall* _tmp101;
	ValaCCodeFunctionCall* chainup;
	ValaCCodeIdentifier* _tmp102;
	ValaCCodeExpressionStatement* _tmp103;
	char* _tmp104;
	ValaCCodeFunction* _tmp105;
	ValaCCodeFunction* proxy_class_init;
	ValaCCodeFormalParameter* _tmp107;
	char* _tmp106;
	ValaCCodeBlock* _tmp108;
	ValaCCodeIdentifier* _tmp109;
	ValaCCodeFunctionCall* _tmp110;
	ValaCCodeFunctionCall* gobject_class;
	ValaCCodeIdentifier* _tmp111;
	ValaCCodeExpressionStatement* _tmp116;
	ValaCCodeAssignment* _tmp115;
	ValaCCodeIdentifier* _tmp114;
	char* _tmp113;
	ValaCCodeMemberAccess* _tmp112;
	char* _tmp117;
	ValaCCodeFunction* _tmp118;
	ValaCCodeFunction* proxy_instance_init;
	ValaCCodeFormalParameter* _tmp120;
	char* _tmp119;
	ValaCCodeBlock* _tmp121;
	char* _tmp122;
	ValaCCodeFunction* _tmp123;
	ValaCCodeFunction* proxy_iface_init;
	ValaCCodeFormalParameter* _tmp126;
	char* _tmp125;
	char* _tmp124;
	ValaCCodeBlock* iface_block;
	ValaCCodeFunction* _tmp149;
	self = (ValaDBusClientModule*) base;
	g_return_if_fail (iface != NULL);
	VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->visit_interface ((ValaCCodeModule*) VALA_DBUS_MODULE (self), iface);
	dbus = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus");
	if (dbus == NULL) {
		(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
		return;
	}
	dbus_iface_name = vala_attribute_get_string (dbus, "name");
	if (dbus_iface_name == NULL) {
		(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
		dbus_iface_name = (g_free (dbus_iface_name), NULL);
		return;
	}
	/* create proxy class*/
	_tmp0 = NULL;
	_tmp1 = NULL;
	cname = (_tmp1 = g_strconcat (_tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "DBusProxy", NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	lower_cname = (_tmp3 = g_strconcat (_tmp2 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), "dbus_proxy", NULL), _tmp2 = (g_free (_tmp2), NULL), _tmp3);
	if (vala_symbol_get_access ((ValaSymbol*) iface) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		((ValaCCodeBaseModule*) self)->dbus_glib_h_needed_in_header = TRUE;
	} else {
		((ValaCCodeBaseModule*) self)->dbus_glib_h_needed = TRUE;
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_declaration_space_add_type_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp5 = vala_ccode_type_definition_new ("DBusGProxy", (ValaCCodeDeclarator*) (_tmp4 = vala_ccode_variable_declarator_new (cname, NULL)))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_declaration_space_add_type_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp8 = vala_ccode_type_definition_new ("DBusGProxyClass", (ValaCCodeDeclarator*) (_tmp7 = vala_ccode_variable_declarator_new (_tmp6 = g_strconcat (cname, "Class", NULL), NULL)))));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp9 = NULL;
	_tmp10 = NULL;
	implement = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("G_IMPLEMENT_INTERFACE"))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp10);
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (implement, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (_tmp11 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, "TYPE_"))));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp11 = (g_free (_tmp11), NULL);
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_function_call_add_argument (implement, (ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new (_tmp13 = g_strconcat (lower_cname, "_interface_init", NULL))));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp13 = (g_free (_tmp13), NULL);
	_tmp15 = NULL;
	_tmp16 = NULL;
	define_type = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("G_DEFINE_TYPE_EXTENDED"))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp16);
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (define_type, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (cname)));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (define_type, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (lower_cname)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (define_type, (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("DBUS_TYPE_G_PROXY")));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp20 = NULL;
	vala_ccode_function_call_add_argument (define_type, (ValaCCodeExpression*) (_tmp20 = vala_ccode_constant_new ("0")));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	vala_ccode_function_call_add_argument (define_type, (ValaCCodeExpression*) implement);
	_tmp21 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp21 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) define_type)));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	/* generate proxy_new function*/
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp22 = NULL;
	_tmp25 = NULL;
	proxy_new = (_tmp25 = vala_ccode_function_new (_tmp22 = g_strconcat (lower_cname, "_new", NULL), _tmp24 = g_strconcat (_tmp23 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "*", NULL)), _tmp24 = (g_free (_tmp24), NULL), _tmp23 = (g_free (_tmp23), NULL), _tmp22 = (g_free (_tmp22), NULL), _tmp25);
	_tmp26 = NULL;
	vala_ccode_function_add_parameter (proxy_new, _tmp26 = vala_ccode_formal_parameter_new ("connection", "DBusGConnection*"));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp27 = NULL;
	vala_ccode_function_add_parameter (proxy_new, _tmp27 = vala_ccode_formal_parameter_new ("name", "const char*"));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp28 = NULL;
	vala_ccode_function_add_parameter (proxy_new, _tmp28 = vala_ccode_formal_parameter_new ("path", "const char*"));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	new_block = vala_ccode_block_new ();
	/* create proxy object*/
	_tmp29 = NULL;
	_tmp30 = NULL;
	new_call = (_tmp30 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("g_object_new"))), (_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)), _tmp30);
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp33 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new (_tmp31 = g_strconcat (lower_cname, "_get_type", NULL))))));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	_tmp31 = (g_free (_tmp31), NULL);
	_tmp34 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp34 = vala_ccode_constant_new ("\"connection\"")));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	_tmp35 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("connection")));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	_tmp36 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp36 = vala_ccode_constant_new ("\"name\"")));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	_tmp37 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("name")));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	_tmp38 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp38 = vala_ccode_constant_new ("\"path\"")));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("path")));
	(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	_tmp40 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp40 = vala_ccode_constant_new ("\"interface\"")));
	(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
	_tmp42 = NULL;
	_tmp41 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp42 = vala_ccode_constant_new (_tmp41 = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	_tmp41 = (g_free (_tmp41), NULL);
	_tmp43 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp43 = vala_ccode_constant_new ("NULL")));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp46 = NULL;
	cdecl_ = (_tmp46 = vala_ccode_declaration_new (_tmp45 = g_strconcat (_tmp44 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "*", NULL)), _tmp45 = (g_free (_tmp45), NULL), _tmp44 = (g_free (_tmp44), NULL), _tmp46);
	_tmp47 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp47 = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) new_call)));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	vala_ccode_block_add_statement (new_block, (ValaCCodeNode*) cdecl_);
	_tmp48 = NULL;
	_tmp49 = NULL;
	raw_connection = (_tmp49 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new ("dbus_g_connection_get_connection"))), (_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)), _tmp49);
	_tmp50 = NULL;
	vala_ccode_function_call_add_argument (raw_connection, (ValaCCodeExpression*) (_tmp50 = vala_ccode_identifier_new ("connection")));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	/* add filter to handle signals from the remote object*/
	_tmp51 = NULL;
	_tmp52 = NULL;
	filter_call = (_tmp52 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new ("dbus_connection_add_filter"))), (_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)), _tmp52);
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) raw_connection);
	_tmp54 = NULL;
	_tmp53 = NULL;
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new (_tmp53 = g_strconcat (lower_cname, "_filter", NULL))));
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	_tmp53 = (g_free (_tmp53), NULL);
	_tmp55 = NULL;
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) (_tmp55 = vala_ccode_identifier_new ("self")));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	_tmp56 = NULL;
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) (_tmp56 = vala_ccode_constant_new ("NULL")));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	_tmp57 = NULL;
	vala_ccode_block_add_statement (new_block, (ValaCCodeNode*) (_tmp57 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) filter_call)));
	(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	_tmp58 = NULL;
	_tmp59 = NULL;
	filter_printf = (_tmp59 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new ("g_strdup_printf"))), (_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)), _tmp59);
	_tmp60 = NULL;
	vala_ccode_function_call_add_argument (filter_printf, (ValaCCodeExpression*) (_tmp60 = vala_ccode_constant_new ("\"type='signal',path='%s'\"")));
	(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
	_tmp61 = NULL;
	vala_ccode_function_call_add_argument (filter_printf, (ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new ("path")));
	(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
	_tmp62 = NULL;
	cdecl_ = (_tmp62 = vala_ccode_declaration_new ("char*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp62);
	_tmp63 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp63 = vala_ccode_variable_declarator_new ("filter", (ValaCCodeExpression*) filter_printf)));
	(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
	vala_ccode_block_add_statement (new_block, (ValaCCodeNode*) cdecl_);
	/* ensure we receive signals from the remote object*/
	_tmp64 = NULL;
	_tmp65 = NULL;
	match_call = (_tmp65 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new ("dbus_bus_add_match"))), (_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)), _tmp65);
	vala_ccode_function_call_add_argument (match_call, (ValaCCodeExpression*) raw_connection);
	_tmp66 = NULL;
	vala_ccode_function_call_add_argument (match_call, (ValaCCodeExpression*) (_tmp66 = vala_ccode_identifier_new ("filter")));
	(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
	_tmp67 = NULL;
	vala_ccode_function_call_add_argument (match_call, (ValaCCodeExpression*) (_tmp67 = vala_ccode_constant_new ("NULL")));
	(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
	_tmp68 = NULL;
	vala_ccode_block_add_statement (new_block, (ValaCCodeNode*) (_tmp68 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) match_call)));
	(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
	_tmp69 = NULL;
	_tmp70 = NULL;
	filter_free = (_tmp70 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp69 = vala_ccode_identifier_new ("g_free"))), (_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)), _tmp70);
	_tmp71 = NULL;
	vala_ccode_function_call_add_argument (filter_free, (ValaCCodeExpression*) (_tmp71 = vala_ccode_identifier_new ("filter")));
	(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
	_tmp72 = NULL;
	vala_ccode_block_add_statement (new_block, (ValaCCodeNode*) (_tmp72 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) filter_free)));
	(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
	_tmp74 = NULL;
	_tmp73 = NULL;
	vala_ccode_block_add_statement (new_block, (ValaCCodeNode*) (_tmp74 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp73 = vala_ccode_identifier_new ("self")))));
	(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
	(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
	_tmp75 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp75 = vala_ccode_function_copy (proxy_new)));
	(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
	vala_ccode_function_set_block (proxy_new, new_block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_new);
	vala_dbus_client_module_generate_proxy_filter_function (self, iface);
	/* dbus proxy dispose*/
	_tmp76 = NULL;
	_tmp77 = NULL;
	proxy_dispose = (_tmp77 = vala_ccode_function_new (_tmp76 = g_strconcat (lower_cname, "_dispose", NULL), "void"), _tmp76 = (g_free (_tmp76), NULL), _tmp77);
	_tmp78 = NULL;
	vala_ccode_function_add_parameter (proxy_dispose, _tmp78 = vala_ccode_formal_parameter_new ("self", "GObject*"));
	(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
	vala_ccode_function_set_modifiers (proxy_dispose, VALA_CCODE_MODIFIERS_STATIC);
	_tmp79 = NULL;
	vala_ccode_function_set_block (proxy_dispose, _tmp79 = vala_ccode_block_new ());
	(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
	_tmp80 = NULL;
	cdecl_ = (_tmp80 = vala_ccode_declaration_new ("DBusGConnection"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp80);
	_tmp81 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp81 = vala_ccode_variable_declarator_new ("*connection", NULL)));
	(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_dispose), (ValaCCodeNode*) cdecl_);
	_tmp82 = NULL;
	_tmp83 = NULL;
	gconnection = (_tmp83 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp82 = vala_ccode_identifier_new ("g_object_get"))), (_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL)), _tmp83);
	_tmp84 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp84 = vala_ccode_identifier_new ("self")));
	(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
	_tmp85 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp85 = vala_ccode_constant_new ("\"connection\"")));
	(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
	_tmp87 = NULL;
	_tmp86 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp87 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp86 = vala_ccode_identifier_new ("connection")))));
	(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
	(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
	_tmp88 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp88 = vala_ccode_constant_new ("NULL")));
	(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
	_tmp89 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_dispose), (ValaCCodeNode*) (_tmp89 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) gconnection)));
	(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
	/* remove filter*/
	_tmp91 = NULL;
	_tmp90 = NULL;
	filter_call = (_tmp91 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp90 = vala_ccode_identifier_new ("dbus_connection_remove_filter"))), (filter_call == NULL) ? NULL : (filter_call = (vala_ccode_node_unref (filter_call), NULL)), _tmp91);
	(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) raw_connection);
	_tmp93 = NULL;
	_tmp92 = NULL;
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) (_tmp93 = vala_ccode_identifier_new (_tmp92 = g_strconcat (lower_cname, "_filter", NULL))));
	(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
	_tmp92 = (g_free (_tmp92), NULL);
	_tmp94 = NULL;
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new ("self")));
	(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
	_tmp95 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_dispose), (ValaCCodeNode*) (_tmp95 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) filter_call)));
	(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
	/* chain up*/
	_tmp96 = NULL;
	_tmp97 = NULL;
	parent_class = (_tmp97 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp96 = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL)), _tmp97);
	_tmp99 = NULL;
	_tmp98 = NULL;
	vala_ccode_function_call_add_argument (parent_class, (ValaCCodeExpression*) (_tmp99 = vala_ccode_identifier_new (_tmp98 = g_strconcat (lower_cname, "_parent_class", NULL))));
	(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
	_tmp98 = (g_free (_tmp98), NULL);
	_tmp100 = NULL;
	_tmp101 = NULL;
	chainup = (_tmp101 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp100 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) parent_class, "dispose"))), (_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL)), _tmp101);
	_tmp102 = NULL;
	vala_ccode_function_call_add_argument (chainup, (ValaCCodeExpression*) (_tmp102 = vala_ccode_identifier_new ("self")));
	(_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL));
	_tmp103 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_dispose), (ValaCCodeNode*) (_tmp103 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) chainup)));
	(_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_dispose);
	_tmp104 = NULL;
	_tmp105 = NULL;
	proxy_class_init = (_tmp105 = vala_ccode_function_new (_tmp104 = g_strconcat (lower_cname, "_class_init", NULL), "void"), _tmp104 = (g_free (_tmp104), NULL), _tmp105);
	_tmp107 = NULL;
	_tmp106 = NULL;
	vala_ccode_function_add_parameter (proxy_class_init, _tmp107 = vala_ccode_formal_parameter_new ("klass", _tmp106 = g_strconcat (cname, "Class*", NULL)));
	(_tmp107 == NULL) ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL));
	_tmp106 = (g_free (_tmp106), NULL);
	vala_ccode_function_set_modifiers (proxy_class_init, VALA_CCODE_MODIFIERS_STATIC);
	_tmp108 = NULL;
	vala_ccode_function_set_block (proxy_class_init, _tmp108 = vala_ccode_block_new ());
	(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
	_tmp109 = NULL;
	_tmp110 = NULL;
	gobject_class = (_tmp110 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp109 = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (_tmp109 == NULL) ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL)), _tmp110);
	_tmp111 = NULL;
	vala_ccode_function_call_add_argument (gobject_class, (ValaCCodeExpression*) (_tmp111 = vala_ccode_identifier_new ("klass")));
	(_tmp111 == NULL) ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL));
	_tmp116 = NULL;
	_tmp115 = NULL;
	_tmp114 = NULL;
	_tmp113 = NULL;
	_tmp112 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_class_init), (ValaCCodeNode*) (_tmp116 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp115 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp112 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) gobject_class, "dispose")), (ValaCCodeExpression*) (_tmp114 = vala_ccode_identifier_new (_tmp113 = g_strconcat (lower_cname, "_dispose", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp116 == NULL) ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL));
	(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
	(_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL));
	_tmp113 = (g_free (_tmp113), NULL);
	(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_class_init);
	_tmp117 = NULL;
	_tmp118 = NULL;
	proxy_instance_init = (_tmp118 = vala_ccode_function_new (_tmp117 = g_strconcat (lower_cname, "_init", NULL), "void"), _tmp117 = (g_free (_tmp117), NULL), _tmp118);
	_tmp120 = NULL;
	_tmp119 = NULL;
	vala_ccode_function_add_parameter (proxy_instance_init, _tmp120 = vala_ccode_formal_parameter_new ("self", _tmp119 = g_strconcat (cname, "*", NULL)));
	(_tmp120 == NULL) ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL));
	_tmp119 = (g_free (_tmp119), NULL);
	vala_ccode_function_set_modifiers (proxy_instance_init, VALA_CCODE_MODIFIERS_STATIC);
	_tmp121 = NULL;
	vala_ccode_function_set_block (proxy_instance_init, _tmp121 = vala_ccode_block_new ());
	(_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_instance_init);
	_tmp122 = NULL;
	_tmp123 = NULL;
	proxy_iface_init = (_tmp123 = vala_ccode_function_new (_tmp122 = g_strconcat (lower_cname, "_interface_init", NULL), "void"), _tmp122 = (g_free (_tmp122), NULL), _tmp123);
	_tmp126 = NULL;
	_tmp125 = NULL;
	_tmp124 = NULL;
	vala_ccode_function_add_parameter (proxy_iface_init, _tmp126 = vala_ccode_formal_parameter_new ("iface", _tmp125 = g_strconcat (_tmp124 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "Iface*", NULL)));
	(_tmp126 == NULL) ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL));
	_tmp125 = (g_free (_tmp125), NULL);
	_tmp124 = (g_free (_tmp124), NULL);
	iface_block = vala_ccode_block_new ();
	{
		GeeList* _tmp127;
		GeeIterator* _tmp128;
		GeeIterator* _m_it;
		_tmp127 = NULL;
		_tmp128 = NULL;
		_m_it = (_tmp128 = gee_iterable_iterator ((GeeIterable*) (_tmp127 = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), (_tmp127 == NULL) ? NULL : (_tmp127 = (gee_collection_object_unref (_tmp127), NULL)), _tmp128);
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			ValaCCodeIdentifier* _tmp129;
			ValaCCodeMemberAccess* _tmp130;
			ValaCCodeMemberAccess* vfunc_entry;
			ValaCCodeExpressionStatement* _tmp134;
			ValaCCodeAssignment* _tmp133;
			ValaCCodeIdentifier* _tmp132;
			char* _tmp131;
			m = (ValaMethod*) gee_iterator_get (_m_it);
			_tmp129 = NULL;
			_tmp130 = NULL;
			vfunc_entry = (_tmp130 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp129 = vala_ccode_identifier_new ("iface")), vala_method_get_vfunc_name (m)), (_tmp129 == NULL) ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL)), _tmp130);
			_tmp134 = NULL;
			_tmp133 = NULL;
			_tmp132 = NULL;
			_tmp131 = NULL;
			vala_ccode_block_add_statement (iface_block, (ValaCCodeNode*) (_tmp134 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp133 = vala_ccode_assignment_new ((ValaCCodeExpression*) vfunc_entry, (ValaCCodeExpression*) (_tmp132 = vala_ccode_identifier_new (_tmp131 = vala_dbus_client_module_generate_dbus_proxy_method (self, iface, m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp134 == NULL) ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL));
			(_tmp133 == NULL) ? NULL : (_tmp133 = (vala_ccode_node_unref (_tmp133), NULL));
			(_tmp132 == NULL) ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL));
			_tmp131 = (g_free (_tmp131), NULL);
			if (vala_method_get_coroutine (m)) {
				ValaCCodeMemberAccess* _tmp137;
				char* _tmp136;
				ValaCCodeIdentifier* _tmp135;
				ValaCCodeExpressionStatement* _tmp141;
				ValaCCodeAssignment* _tmp140;
				ValaCCodeIdentifier* _tmp139;
				char* _tmp138;
				ValaCCodeMemberAccess* _tmp144;
				char* _tmp143;
				ValaCCodeIdentifier* _tmp142;
				ValaCCodeExpressionStatement* _tmp148;
				ValaCCodeAssignment* _tmp147;
				ValaCCodeIdentifier* _tmp146;
				char* _tmp145;
				_tmp137 = NULL;
				_tmp136 = NULL;
				_tmp135 = NULL;
				vfunc_entry = (_tmp137 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp135 = vala_ccode_identifier_new ("iface")), _tmp136 = g_strconcat (vala_method_get_vfunc_name (m), "_async", NULL)), (vfunc_entry == NULL) ? NULL : (vfunc_entry = (vala_ccode_node_unref (vfunc_entry), NULL)), _tmp137);
				_tmp136 = (g_free (_tmp136), NULL);
				(_tmp135 == NULL) ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL));
				_tmp141 = NULL;
				_tmp140 = NULL;
				_tmp139 = NULL;
				_tmp138 = NULL;
				vala_ccode_block_add_statement (iface_block, (ValaCCodeNode*) (_tmp141 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp140 = vala_ccode_assignment_new ((ValaCCodeExpression*) vfunc_entry, (ValaCCodeExpression*) (_tmp139 = vala_ccode_identifier_new (_tmp138 = vala_dbus_client_module_generate_async_dbus_proxy_method (self, iface, m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp141 == NULL) ? NULL : (_tmp141 = (vala_ccode_node_unref (_tmp141), NULL));
				(_tmp140 == NULL) ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL));
				(_tmp139 == NULL) ? NULL : (_tmp139 = (vala_ccode_node_unref (_tmp139), NULL));
				_tmp138 = (g_free (_tmp138), NULL);
				_tmp144 = NULL;
				_tmp143 = NULL;
				_tmp142 = NULL;
				vfunc_entry = (_tmp144 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp142 = vala_ccode_identifier_new ("iface")), _tmp143 = g_strconcat (vala_method_get_vfunc_name (m), "_finish", NULL)), (vfunc_entry == NULL) ? NULL : (vfunc_entry = (vala_ccode_node_unref (vfunc_entry), NULL)), _tmp144);
				_tmp143 = (g_free (_tmp143), NULL);
				(_tmp142 == NULL) ? NULL : (_tmp142 = (vala_ccode_node_unref (_tmp142), NULL));
				_tmp148 = NULL;
				_tmp147 = NULL;
				_tmp146 = NULL;
				_tmp145 = NULL;
				vala_ccode_block_add_statement (iface_block, (ValaCCodeNode*) (_tmp148 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp147 = vala_ccode_assignment_new ((ValaCCodeExpression*) vfunc_entry, (ValaCCodeExpression*) (_tmp146 = vala_ccode_identifier_new (_tmp145 = vala_dbus_client_module_generate_finish_dbus_proxy_method (self, iface, m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp148 == NULL) ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL));
				(_tmp147 == NULL) ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL));
				(_tmp146 == NULL) ? NULL : (_tmp146 = (vala_ccode_node_unref (_tmp146), NULL));
				_tmp145 = (g_free (_tmp145), NULL);
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(vfunc_entry == NULL) ? NULL : (vfunc_entry = (vala_ccode_node_unref (vfunc_entry), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	vala_ccode_function_set_modifiers (proxy_iface_init, VALA_CCODE_MODIFIERS_STATIC);
	_tmp149 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp149 = vala_ccode_function_copy (proxy_iface_init)));
	(_tmp149 == NULL) ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL));
	vala_ccode_function_set_block (proxy_iface_init, iface_block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_iface_init);
	(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
	cname = (g_free (cname), NULL);
	lower_cname = (g_free (lower_cname), NULL);
	(implement == NULL) ? NULL : (implement = (vala_ccode_node_unref (implement), NULL));
	(define_type == NULL) ? NULL : (define_type = (vala_ccode_node_unref (define_type), NULL));
	(proxy_new == NULL) ? NULL : (proxy_new = (vala_ccode_node_unref (proxy_new), NULL));
	(new_block == NULL) ? NULL : (new_block = (vala_ccode_node_unref (new_block), NULL));
	(new_call == NULL) ? NULL : (new_call = (vala_ccode_node_unref (new_call), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(raw_connection == NULL) ? NULL : (raw_connection = (vala_ccode_node_unref (raw_connection), NULL));
	(filter_call == NULL) ? NULL : (filter_call = (vala_ccode_node_unref (filter_call), NULL));
	(filter_printf == NULL) ? NULL : (filter_printf = (vala_ccode_node_unref (filter_printf), NULL));
	(match_call == NULL) ? NULL : (match_call = (vala_ccode_node_unref (match_call), NULL));
	(filter_free == NULL) ? NULL : (filter_free = (vala_ccode_node_unref (filter_free), NULL));
	(proxy_dispose == NULL) ? NULL : (proxy_dispose = (vala_ccode_node_unref (proxy_dispose), NULL));
	(gconnection == NULL) ? NULL : (gconnection = (vala_ccode_node_unref (gconnection), NULL));
	(parent_class == NULL) ? NULL : (parent_class = (vala_ccode_node_unref (parent_class), NULL));
	(chainup == NULL) ? NULL : (chainup = (vala_ccode_node_unref (chainup), NULL));
	(proxy_class_init == NULL) ? NULL : (proxy_class_init = (vala_ccode_node_unref (proxy_class_init), NULL));
	(gobject_class == NULL) ? NULL : (gobject_class = (vala_ccode_node_unref (gobject_class), NULL));
	(proxy_instance_init == NULL) ? NULL : (proxy_instance_init = (vala_ccode_node_unref (proxy_instance_init), NULL));
	(proxy_iface_init == NULL) ? NULL : (proxy_iface_init = (vala_ccode_node_unref (proxy_iface_init), NULL));
	(iface_block == NULL) ? NULL : (iface_block = (vala_ccode_node_unref (iface_block), NULL));
}


static void vala_dbus_client_module_generate_proxy_filter_function (ValaDBusClientModule* self, ValaInterface* iface) {
	char* _tmp0;
	char* _tmp1;
	char* lower_cname;
	char* _tmp2;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* proxy_filter;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* filter_block;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* path;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeBlock* object_filter_block;
	ValaCCodeIfStatement* _tmp13;
	ValaCCodeReturnStatement* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeFunction* _tmp16;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	lower_cname = (_tmp1 = g_strconcat (_tmp0 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), "dbus_proxy", NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	proxy_filter = (_tmp3 = vala_ccode_function_new (_tmp2 = g_strconcat (lower_cname, "_filter", NULL), "DBusHandlerResult"), _tmp2 = (g_free (_tmp2), NULL), _tmp3);
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (proxy_filter, _tmp4 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (proxy_filter, _tmp5 = vala_ccode_formal_parameter_new ("message", "DBusMessage*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (proxy_filter, _tmp6 = vala_ccode_formal_parameter_new ("user_data", "void*"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	filter_block = vala_ccode_block_new ();
	/* only handle signals concering the object path*/
	_tmp7 = NULL;
	_tmp8 = NULL;
	path = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("dbus_g_proxy_get_path"))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("user_data")));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	_tmp11 = NULL;
	ccheck = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("dbus_message_has_path"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("message")));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) path);
	object_filter_block = vala_ccode_block_new ();
	_tmp13 = NULL;
	vala_ccode_block_add_statement (filter_block, (ValaCCodeNode*) (_tmp13 = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccheck, (ValaCCodeStatement*) object_filter_block, NULL)));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	vala_dbus_client_module_handle_signals (self, iface, object_filter_block);
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_block_add_statement (filter_block, (ValaCCodeNode*) (_tmp15 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("DBUS_HANDLER_RESULT_NOT_YET_HANDLED")))));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp16 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp16 = vala_ccode_function_copy (proxy_filter)));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	vala_ccode_function_set_block (proxy_filter, filter_block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_filter);
	lower_cname = (g_free (lower_cname), NULL);
	(proxy_filter == NULL) ? NULL : (proxy_filter = (vala_ccode_node_unref (proxy_filter), NULL));
	(filter_block == NULL) ? NULL : (filter_block = (vala_ccode_node_unref (filter_block), NULL));
	(path == NULL) ? NULL : (path = (vala_ccode_node_unref (path), NULL));
	(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
	(object_filter_block == NULL) ? NULL : (object_filter_block = (vala_ccode_node_unref (object_filter_block), NULL));
}


static char* vala_dbus_client_module_generate_dbus_signal_handler (ValaDBusClientModule* self, ValaSignal* sig, ValaObjectTypeSymbol* sym) {
	char* _tmp1;
	char* _tmp0;
	char* _tmp2;
	char* wrapper_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFormalParameter* _tmp7;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeDeclaration* _tmp8;
	ValaCCodeVariableDeclarator* _tmp9;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* message_signature;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* signature_check;
	ValaCCodeBlock* signature_error_block;
	ValaCCodeReturnStatement* _tmp15;
	ValaCCodeIfStatement* _tmp16;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeFunctionCall* _tmp18;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeUnaryExpression* _tmp21;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeExpressionStatement* _tmp22;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeFunctionCall* _tmp24;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeConstant* _tmp26;
	char* type_signature;
	ValaCCodeConstant* _tmp55;
	char* _tmp54;
	ValaCCodeExpressionStatement* _tmp56;
	ValaCCodeDeclaration* _tmp57;
	ValaCCodeVariableDeclarator* _tmp58;
	ValaCCodeFunction* _tmp59;
	char* _tmp60;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	wrapper_name = (_tmp2 = g_strdup_printf ("_dbus_handle_%s_%s", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) sym, NULL), _tmp1 = vala_signal_get_cname (sig)), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	/* declaration*/
	cdecl_ = NULL;
	function = vala_ccode_function_new (wrapper_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("self", _tmp4 = g_strconcat (_tmp3 = vala_typesymbol_get_cname ((ValaTypeSymbol*) sym, FALSE), "*", NULL)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp6 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp7 = NULL;
	vala_ccode_function_add_parameter (function, _tmp7 = vala_ccode_formal_parameter_new ("message", "DBusMessage*"));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	_tmp8 = NULL;
	cdecl_ = (_tmp8 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp9 = vala_ccode_variable_declarator_new ("iter", NULL)));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	_tmp10 = NULL;
	_tmp11 = NULL;
	message_signature = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("dbus_message_get_signature"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (message_signature, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("message")));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp13 = NULL;
	_tmp14 = NULL;
	signature_check = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("strcmp"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) message_signature);
	signature_error_block = vala_ccode_block_new ();
	_tmp15 = NULL;
	vala_ccode_block_add_statement (signature_error_block, (ValaCCodeNode*) (_tmp15 = vala_ccode_return_statement_new (NULL)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp16 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp16 = vala_ccode_if_statement_new ((ValaCCodeExpression*) signature_check, (ValaCCodeStatement*) signature_error_block, NULL)));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp17 = NULL;
	_tmp18 = NULL;
	iter_call = (_tmp18 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new ("dbus_message_iter_init"))), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), _tmp18);
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("message")));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp21 = NULL;
	_tmp20 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp21 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("iter")))));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp22 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp22 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	_tmp23 = NULL;
	_tmp24 = NULL;
	ccall = (_tmp24 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("g_signal_emit_by_name"))), (_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)), _tmp24);
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("self")));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp26 = vala_signal_get_canonical_cconstant (sig, NULL)));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	/* expected type signature for input parameters*/
	type_signature = g_strdup ("");
	{
		GeeList* _tmp27;
		GeeIterator* _tmp28;
		GeeIterator* _param_it;
		_tmp27 = NULL;
		_tmp28 = NULL;
		_param_it = (_tmp28 = gee_iterable_iterator ((GeeIterable*) (_tmp27 = vala_signal_get_parameters (sig))), (_tmp27 == NULL) ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL)), _tmp28);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			ValaCCodeDeclaration* _tmp30;
			char* _tmp29;
			ValaCCodeVariableDeclarator* _tmp32;
			ValaCCodeExpression* _tmp31;
			char* _tmp33;
			gboolean _tmp34;
			ValaStruct* _tmp38;
			ValaTypeSymbol* _tmp37;
			ValaStruct* st;
			gboolean _tmp39;
			char* _tmp49;
			char* _tmp48;
			ValaCCodeIdentifier* target;
			ValaCCodeIdentifier* _tmp50;
			ValaCCodeExpression* _tmp51;
			ValaCCodeExpression* expr;
			ValaCCodeExpressionStatement* _tmp53;
			ValaCCodeAssignment* _tmp52;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp30 = NULL;
			_tmp29 = NULL;
			cdecl_ = (_tmp30 = vala_ccode_declaration_new (_tmp29 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param))), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp30);
			_tmp29 = (g_free (_tmp29), NULL);
			_tmp32 = NULL;
			_tmp31 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp32 = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) param), _tmp31 = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), TRUE))));
			(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
			(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
			vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
			_tmp33 = NULL;
			if ((_tmp34 = (_tmp33 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))) == NULL, _tmp33 = (g_free (_tmp33), NULL), _tmp34)) {
				char* _tmp36;
				char* _tmp35;
				_tmp36 = NULL;
				_tmp35 = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_formal_parameter_get_parameter_type (param)), _tmp36 = g_strdup_printf ("D-Bus serialization of type `%s' is not supported", _tmp35 = vala_code_node_to_string ((ValaCodeNode*) vala_formal_parameter_get_parameter_type (param))));
				_tmp36 = (g_free (_tmp36), NULL);
				_tmp35 = (g_free (_tmp35), NULL);
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			_tmp38 = NULL;
			_tmp37 = NULL;
			st = (_tmp38 = (_tmp37 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)), VALA_IS_STRUCT (_tmp37) ? ((ValaStruct*) _tmp37) : NULL), (_tmp38 == NULL) ? NULL : vala_code_node_ref (_tmp38));
			_tmp39 = FALSE;
			if (st != NULL) {
				_tmp39 = !vala_struct_is_simple_type (st);
			} else {
				_tmp39 = FALSE;
			}
			if (_tmp39) {
				ValaCCodeUnaryExpression* _tmp41;
				ValaCCodeIdentifier* _tmp40;
				_tmp41 = NULL;
				_tmp40 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp41 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))));
				(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
				(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
			} else {
				ValaCCodeIdentifier* _tmp42;
				_tmp42 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
				(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
			}
			if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				ValaArrayType* _tmp43;
				ValaArrayType* array_type;
				_tmp43 = NULL;
				array_type = (_tmp43 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp43 == NULL) ? NULL : vala_code_node_ref (_tmp43));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						char* length_cname;
						ValaCCodeDeclaration* _tmp44;
						ValaCCodeVariableDeclarator* _tmp46;
						ValaCCodeConstant* _tmp45;
						ValaCCodeIdentifier* _tmp47;
						length_cname = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) param), dim);
						_tmp44 = NULL;
						cdecl_ = (_tmp44 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp44);
						_tmp46 = NULL;
						_tmp45 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp46 = vala_ccode_variable_declarator_new (length_cname, (ValaCCodeExpression*) (_tmp45 = vala_ccode_constant_new ("0")))));
						(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
						(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
						vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
						_tmp47 = NULL;
						vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new (length_cname)));
						(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
						length_cname = (g_free (length_cname), NULL);
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			_tmp49 = NULL;
			_tmp48 = NULL;
			type_signature = (_tmp49 = g_strconcat (type_signature, _tmp48 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), NULL), type_signature = (g_free (type_signature), NULL), _tmp49);
			_tmp48 = (g_free (_tmp48), NULL);
			target = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param));
			_tmp50 = NULL;
			_tmp51 = NULL;
			expr = (_tmp51 = vala_dbus_module_read_expression ((ValaDBusModule*) self, prefragment, vala_formal_parameter_get_parameter_type (param), (ValaCCodeExpression*) (_tmp50 = vala_ccode_identifier_new ("iter")), (ValaCCodeExpression*) target), (_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)), _tmp51);
			_tmp53 = NULL;
			_tmp52 = NULL;
			vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp53 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp52 = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
			(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			(target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL));
			(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp55 = NULL;
	_tmp54 = NULL;
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) (_tmp55 = vala_ccode_constant_new (_tmp54 = g_strdup_printf ("\"%s\"", type_signature))));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	_tmp54 = (g_free (_tmp54), NULL);
	_tmp56 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp56 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	_tmp57 = NULL;
	cdecl_ = (_tmp57 = vala_ccode_declaration_new ("DBusMessage*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp57);
	_tmp58 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp58 = vala_ccode_variable_declarator_new ("reply", NULL)));
	(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp59 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp59 = vala_ccode_function_copy (function)));
	(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp60 = NULL;
	return (_tmp60 = wrapper_name, (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL)), (message_signature == NULL) ? NULL : (message_signature = (vala_ccode_node_unref (message_signature), NULL)), (signature_check == NULL) ? NULL : (signature_check = (vala_ccode_node_unref (signature_check), NULL)), (signature_error_block == NULL) ? NULL : (signature_error_block = (vala_ccode_node_unref (signature_error_block), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), type_signature = (g_free (type_signature), NULL), _tmp60);
}


static void vala_dbus_client_module_handle_signal (ValaDBusClientModule* self, const char* dbus_iface_name, const char* dbus_signal_name, const char* handler_name, ValaCCodeBlock* block, ValaCCodeIfStatement** clastif) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	ValaCCodeConstant* _tmp6;
	char* _tmp5;
	ValaCCodeBlock* callblock;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeExpressionStatement* _tmp12;
	ValaCCodeIfStatement* cif;
	ValaCCodeIfStatement* _tmp14;
	ValaCCodeIfStatement* _tmp13;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_iface_name != NULL);
	g_return_if_fail (dbus_signal_name != NULL);
	g_return_if_fail (handler_name != NULL);
	g_return_if_fail (block != NULL);
	g_return_if_fail (clastif != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	ccheck = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("dbus_message_is_signal"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("message")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp4 = vala_ccode_constant_new (_tmp3 = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp6 = vala_ccode_constant_new (_tmp5 = g_strdup_printf ("\"%s\"", dbus_signal_name))));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp5 = (g_free (_tmp5), NULL);
	callblock = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (handler_name))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("user_data")));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("connection")));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("message")));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp12 = NULL;
	vala_ccode_block_add_statement (callblock, (ValaCCodeNode*) (_tmp12 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccheck, (ValaCCodeStatement*) callblock, NULL);
	if ((*clastif) == NULL) {
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cif);
	} else {
		vala_ccode_if_statement_set_false_statement ((*clastif), (ValaCCodeStatement*) cif);
	}
	_tmp14 = NULL;
	_tmp13 = NULL;
	(*clastif) = (_tmp14 = (_tmp13 = cif, (_tmp13 == NULL) ? NULL : vala_ccode_node_ref (_tmp13)), ((*clastif) == NULL) ? NULL : ((*clastif) = (vala_ccode_node_unref ((*clastif)), NULL)), _tmp14);
	(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
	(callblock == NULL) ? NULL : (callblock = (vala_ccode_node_unref (callblock), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
}


static void vala_dbus_client_module_handle_signals (ValaDBusClientModule* self, ValaInterface* iface, ValaCCodeBlock* block) {
	ValaAttribute* _tmp0;
	char* _tmp1;
	char* dbus_iface_name;
	ValaCCodeIfStatement* clastif;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	dbus_iface_name = (_tmp1 = vala_attribute_get_string (_tmp0 = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus"), "name"), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)), _tmp1);
	clastif = NULL;
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* _sig_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		_sig_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) iface))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (_sig_it)) {
			ValaSignal* sig;
			char* _tmp5;
			char* _tmp4;
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			if (vala_symbol_get_access ((ValaSymbol*) sig) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
				continue;
			}
			_tmp5 = NULL;
			_tmp4 = NULL;
			vala_dbus_client_module_handle_signal (self, dbus_iface_name, _tmp4 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) sig)), _tmp5 = vala_dbus_client_module_generate_dbus_signal_handler (self, sig, (ValaObjectTypeSymbol*) iface), block, &clastif);
			_tmp5 = (g_free (_tmp5), NULL);
			_tmp4 = (g_free (_tmp4), NULL);
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		}
		(_sig_it == NULL) ? NULL : (_sig_it = (gee_collection_object_unref (_sig_it), NULL));
	}
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
	(clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL));
}


static void vala_dbus_client_module_generate_marshalling (ValaDBusClientModule* self, ValaMethod* m, const char* dbus_iface_name, ValaCCodeFragment* prefragment, ValaCCodeFragment* postfragment) {
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* destination;
	ValaCCodeCastExpression* _tmp3;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* path;
	ValaCCodeCastExpression* _tmp7;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* msgcall;
	ValaCCodeConstant* _tmp11;
	char* _tmp10;
	ValaCCodeConstant* _tmp14;
	char* _tmp13;
	char* _tmp12;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeFunctionCall* _tmp19;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeUnaryExpression* _tmp22;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeExpressionStatement* _tmp23;
	ValaCCodeFunctionCall* _tmp25;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeUnaryExpression* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeExpressionStatement* _tmp29;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (dbus_iface_name != NULL);
	g_return_if_fail (prefragment != NULL);
	g_return_if_fail (postfragment != NULL);
	cdecl_ = NULL;
	_tmp0 = NULL;
	_tmp1 = NULL;
	destination = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("dbus_g_proxy_get_bus_name"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (destination, (ValaCCodeExpression*) (_tmp3 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("self")), "DBusGProxy*")));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp4 = NULL;
	_tmp5 = NULL;
	path = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("dbus_g_proxy_get_path"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp7 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("self")), "DBusGProxy*")));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp8 = NULL;
	_tmp9 = NULL;
	msgcall = (_tmp9 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new ("dbus_message_new_method_call"))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp9);
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) destination);
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) path);
	_tmp11 = NULL;
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new (_tmp10 = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp10 = (g_free (_tmp10), NULL);
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new (_tmp13 = g_strdup_printf ("\"%s\"", _tmp12 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) m))))));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp13 = (g_free (_tmp13), NULL);
	_tmp12 = (g_free (_tmp12), NULL);
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp17 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("_message")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp18 = NULL;
	_tmp19 = NULL;
	iter_call = (_tmp19 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("dbus_message_iter_init_append"))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19);
	_tmp20 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("_message")));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp22 = NULL;
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp22 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("_iter")))));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp23 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp23 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp25 = NULL;
	_tmp24 = NULL;
	iter_call = (_tmp25 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("dbus_message_iter_init"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp25);
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("_reply")));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp28 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("_iter")))));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp29 = NULL;
	vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp29 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	{
		GeeList* _tmp30;
		GeeIterator* _tmp31;
		GeeIterator* _param_it;
		_tmp30 = NULL;
		_tmp31 = NULL;
		_param_it = (_tmp31 = gee_iterable_iterator ((GeeIterable*) (_tmp30 = vala_method_get_parameters (m))), (_tmp30 == NULL) ? NULL : (_tmp30 = (gee_collection_object_unref (_tmp30), NULL)), _tmp31);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
				gboolean _tmp32;
				ValaCCodeExpression* expr;
				ValaCCodeIdentifier* _tmp35;
				_tmp32 = FALSE;
				if (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)) != NULL) {
					char* _tmp33;
					_tmp33 = NULL;
					_tmp32 = _vala_strcmp0 (_tmp33 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), "DBus.BusName") == 0;
					_tmp33 = (g_free (_tmp33), NULL);
				} else {
					_tmp32 = FALSE;
				}
				if (_tmp32) {
					/* ignore BusName sender parameters*/
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					continue;
				}
				expr = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param));
				if (vala_data_type_is_real_struct_type (vala_formal_parameter_get_parameter_type (param))) {
					ValaCCodeExpression* _tmp34;
					_tmp34 = NULL;
					expr = (_tmp34 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, expr), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp34);
				}
				_tmp35 = NULL;
				vala_dbus_module_write_expression ((ValaDBusModule*) self, prefragment, vala_formal_parameter_get_parameter_type (param), (ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("_iter")), expr);
				(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
				(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
			} else {
				ValaCCodeDeclaration* _tmp37;
				char* _tmp36;
				ValaCCodeVariableDeclarator* _tmp39;
				char* _tmp38;
				ValaArrayType* _tmp41;
				ValaDataType* _tmp40;
				ValaArrayType* array_type;
				char* _tmp46;
				ValaCCodeIdentifier* _tmp47;
				ValaCCodeIdentifier* target;
				ValaCCodeIdentifier* _tmp48;
				ValaCCodeExpression* _tmp49;
				ValaCCodeExpression* expr;
				ValaCCodeExpressionStatement* _tmp51;
				ValaCCodeAssignment* _tmp50;
				ValaCCodeExpressionStatement* _tmp55;
				ValaCCodeAssignment* _tmp54;
				ValaCCodeUnaryExpression* _tmp53;
				ValaCCodeIdentifier* _tmp52;
				_tmp37 = NULL;
				_tmp36 = NULL;
				cdecl_ = (_tmp37 = vala_ccode_declaration_new (_tmp36 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param))), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp37);
				_tmp36 = (g_free (_tmp36), NULL);
				_tmp39 = NULL;
				_tmp38 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp39 = vala_ccode_variable_declarator_new (_tmp38 = g_strconcat ("_", vala_symbol_get_name ((ValaSymbol*) param), NULL), NULL)));
				(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
				_tmp38 = (g_free (_tmp38), NULL);
				vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) cdecl_);
				_tmp41 = NULL;
				_tmp40 = NULL;
				array_type = (_tmp41 = (_tmp40 = vala_formal_parameter_get_parameter_type (param), VALA_IS_ARRAY_TYPE (_tmp40) ? ((ValaArrayType*) _tmp40) : NULL), (_tmp41 == NULL) ? NULL : vala_code_node_ref (_tmp41));
				if (array_type != NULL) {
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							ValaCCodeDeclaration* _tmp42;
							ValaCCodeVariableDeclarator* _tmp45;
							ValaCCodeConstant* _tmp44;
							char* _tmp43;
							_tmp42 = NULL;
							cdecl_ = (_tmp42 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp42);
							_tmp45 = NULL;
							_tmp44 = NULL;
							_tmp43 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp45 = vala_ccode_variable_declarator_new (_tmp43 = g_strdup_printf ("_%s_length%d", vala_symbol_get_name ((ValaSymbol*) param), dim), (ValaCCodeExpression*) (_tmp44 = vala_ccode_constant_new ("0")))));
							(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
							(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
							_tmp43 = (g_free (_tmp43), NULL);
							vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) cdecl_);
						}
					}
				}
				_tmp46 = NULL;
				_tmp47 = NULL;
				target = (_tmp47 = vala_ccode_identifier_new (_tmp46 = g_strconcat ("_", vala_symbol_get_name ((ValaSymbol*) param), NULL)), _tmp46 = (g_free (_tmp46), NULL), _tmp47);
				_tmp48 = NULL;
				_tmp49 = NULL;
				expr = (_tmp49 = vala_dbus_module_read_expression ((ValaDBusModule*) self, postfragment, vala_formal_parameter_get_parameter_type (param), (ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new ("_iter")), (ValaCCodeExpression*) target), (_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)), _tmp49);
				_tmp51 = NULL;
				_tmp50 = NULL;
				vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp51 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp50 = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
				(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
				/* TODO check that parameter is not NULL (out parameters are optional)
				 free value if parameter is NULL*/
				_tmp55 = NULL;
				_tmp54 = NULL;
				_tmp53 = NULL;
				_tmp52 = NULL;
				vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp55 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp54 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp53 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))), (ValaCCodeExpression*) target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
				(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
				(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
				(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
				if (array_type != NULL) {
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							ValaCCodeExpressionStatement* _tmp62;
							ValaCCodeAssignment* _tmp61;
							ValaCCodeIdentifier* _tmp60;
							char* _tmp59;
							ValaCCodeUnaryExpression* _tmp58;
							ValaCCodeIdentifier* _tmp57;
							char* _tmp56;
							/* TODO check that parameter is not NULL (out parameters are optional)*/
							_tmp62 = NULL;
							_tmp61 = NULL;
							_tmp60 = NULL;
							_tmp59 = NULL;
							_tmp58 = NULL;
							_tmp57 = NULL;
							_tmp56 = NULL;
							vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp62 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp61 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp58 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new (_tmp56 = g_strdup_printf ("%s_length%d", vala_symbol_get_name ((ValaSymbol*) param), dim))))), (ValaCCodeExpression*) (_tmp60 = vala_ccode_identifier_new (_tmp59 = g_strdup_printf ("_%s_length%d", vala_symbol_get_name ((ValaSymbol*) param), dim))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
							(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
							(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
							(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
							_tmp59 = (g_free (_tmp59), NULL);
							(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
							(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
							_tmp56 = (g_free (_tmp56), NULL);
						}
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				(target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL));
				(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeDeclaration* _tmp64;
		char* _tmp63;
		ValaCCodeVariableDeclarator* _tmp65;
		ValaArrayType* _tmp67;
		ValaDataType* _tmp66;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* target;
		ValaCCodeIdentifier* _tmp72;
		ValaCCodeExpression* _tmp73;
		ValaCCodeExpression* expr;
		ValaCCodeExpressionStatement* _tmp75;
		ValaCCodeAssignment* _tmp74;
		_tmp64 = NULL;
		_tmp63 = NULL;
		cdecl_ = (_tmp64 = vala_ccode_declaration_new (_tmp63 = vala_data_type_get_cname (vala_method_get_return_type (m))), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp64);
		_tmp63 = (g_free (_tmp63), NULL);
		_tmp65 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp65 = vala_ccode_variable_declarator_new ("_result", NULL)));
		(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
		vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) cdecl_);
		_tmp67 = NULL;
		_tmp66 = NULL;
		array_type = (_tmp67 = (_tmp66 = vala_method_get_return_type (m), VALA_IS_ARRAY_TYPE (_tmp66) ? ((ValaArrayType*) _tmp66) : NULL), (_tmp67 == NULL) ? NULL : vala_code_node_ref (_tmp67));
		if (array_type != NULL) {
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeDeclaration* _tmp68;
					ValaCCodeVariableDeclarator* _tmp71;
					ValaCCodeConstant* _tmp70;
					char* _tmp69;
					_tmp68 = NULL;
					cdecl_ = (_tmp68 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp68);
					_tmp71 = NULL;
					_tmp70 = NULL;
					_tmp69 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp71 = vala_ccode_variable_declarator_new (_tmp69 = g_strdup_printf ("_result_length%d", dim), (ValaCCodeExpression*) (_tmp70 = vala_ccode_constant_new ("0")))));
					(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
					(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
					_tmp69 = (g_free (_tmp69), NULL);
					vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) cdecl_);
				}
			}
		}
		target = vala_ccode_identifier_new ("_result");
		_tmp72 = NULL;
		_tmp73 = NULL;
		expr = (_tmp73 = vala_dbus_module_read_expression ((ValaDBusModule*) self, postfragment, vala_method_get_return_type (m), (ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new ("_iter")), (ValaCCodeExpression*) target), (_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)), _tmp73);
		_tmp75 = NULL;
		_tmp74 = NULL;
		vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp75 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp74 = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
		(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
		if (array_type != NULL) {
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeExpressionStatement* _tmp82;
					ValaCCodeAssignment* _tmp81;
					ValaCCodeIdentifier* _tmp80;
					char* _tmp79;
					ValaCCodeUnaryExpression* _tmp78;
					ValaCCodeIdentifier* _tmp77;
					char* _tmp76;
					/* TODO check that parameter is not NULL (out parameters are optional)*/
					_tmp82 = NULL;
					_tmp81 = NULL;
					_tmp80 = NULL;
					_tmp79 = NULL;
					_tmp78 = NULL;
					_tmp77 = NULL;
					_tmp76 = NULL;
					vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp82 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp81 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp78 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp77 = vala_ccode_identifier_new (_tmp76 = g_strdup_printf ("result_length%d", dim))))), (ValaCCodeExpression*) (_tmp80 = vala_ccode_identifier_new (_tmp79 = g_strdup_printf ("_result_length%d", dim))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
					(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
					(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
					_tmp79 = (g_free (_tmp79), NULL);
					(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
					(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
					_tmp76 = (g_free (_tmp76), NULL);
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL));
		(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
	}
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(destination == NULL) ? NULL : (destination = (vala_ccode_node_unref (destination), NULL));
	(path == NULL) ? NULL : (path = (vala_ccode_node_unref (path), NULL));
	(msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
}


static char* vala_dbus_client_module_generate_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m) {
	char* _tmp0;
	char* _tmp1;
	char* proxy_name;
	ValaAttribute* _tmp2;
	char* _tmp3;
	char* dbus_iface_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeFragment* postfragment;
	ValaCCodeDeclaration* _tmp4;
	ValaCCodeVariableDeclarator* _tmp5;
	ValaCCodeDeclaration* _tmp6;
	ValaCCodeVariableDeclarator* _tmp7;
	ValaCCodeVariableDeclarator* _tmp8;
	ValaCCodeDeclaration* _tmp9;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeFunctionCall* _tmp12;
	ValaCCodeFunctionCall* gconnection;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeConstant* _tmp14;
	ValaCCodeUnaryExpression* _tmp16;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeConstant* _tmp17;
	ValaCCodeExpressionStatement* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeFunctionCall* connection;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeFunctionCall* _tmp23;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeConstant* _tmp25;
	ValaCCodeConstant* _tmp26;
	ValaCCodeExpressionStatement* _tmp29;
	ValaCCodeAssignment* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeFunctionCall* _tmp31;
	ValaCCodeFunctionCall* conn_unref;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeFunctionCall* _tmp35;
	ValaCCodeFunctionCall* message_unref;
	ValaCCodeIdentifier* _tmp36;
	ValaCCodeExpressionStatement* _tmp37;
	ValaCCodeIdentifier* _tmp38;
	ValaCCodeFunctionCall* _tmp39;
	ValaCCodeFunctionCall* reply_unref;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeExpressionStatement* _tmp41;
	ValaCCodeFunction* _tmp44;
	char* _tmp45;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iface != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	proxy_name = (_tmp1 = g_strdup_printf ("%sdbus_proxy_%s", _tmp0 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	dbus_iface_name = (_tmp3 = vala_attribute_get_string (_tmp2 = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus"), "name"), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)), _tmp3);
	cdecl_ = NULL;
	function = vala_ccode_function_new (proxy_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, function, NULL, NULL, NULL, 3);
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	postfragment = vala_ccode_fragment_new ();
	_tmp4 = NULL;
	cdecl_ = (_tmp4 = vala_ccode_declaration_new ("DBusGConnection"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp4);
	_tmp5 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp5 = vala_ccode_variable_declarator_new ("*_connection", NULL)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp6 = NULL;
	cdecl_ = (_tmp6 = vala_ccode_declaration_new ("DBusMessage"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp6);
	_tmp7 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp7 = vala_ccode_variable_declarator_new ("*_message", NULL)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp8 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp8 = vala_ccode_variable_declarator_new ("*_reply", NULL)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp9 = NULL;
	cdecl_ = (_tmp9 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp9);
	_tmp10 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new ("_iter", NULL)));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	vala_dbus_client_module_generate_marshalling (self, m, dbus_iface_name, prefragment, postfragment);
	_tmp11 = NULL;
	_tmp12 = NULL;
	gconnection = (_tmp12 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("g_object_get"))), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)), _tmp12);
	_tmp13 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("self")));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp14 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("\"connection\"")));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp16 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("_connection")))));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new ("NULL")));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp18 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp18 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) gconnection)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	_tmp20 = NULL;
	connection = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("dbus_g_connection_get_connection"))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp20);
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (connection, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("_connection")));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp22 = NULL;
	_tmp23 = NULL;
	ccall = (_tmp23 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("dbus_connection_send_with_reply_and_block"))), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)), _tmp23);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) connection);
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("_message")));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25 = vala_ccode_constant_new ("-1")));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp26 = vala_ccode_constant_new ("NULL")));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp29 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("_reply")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp30 = NULL;
	_tmp31 = NULL;
	conn_unref = (_tmp31 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("dbus_g_connection_unref"))), (_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)), _tmp31);
	_tmp32 = NULL;
	vala_ccode_function_call_add_argument (conn_unref, (ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new ("_connection")));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	_tmp33 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp33 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) conn_unref)));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	_tmp34 = NULL;
	_tmp35 = NULL;
	message_unref = (_tmp35 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)), _tmp35);
	_tmp36 = NULL;
	vala_ccode_function_call_add_argument (message_unref, (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("_message")));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	_tmp37 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp37 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) message_unref)));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) postfragment);
	_tmp38 = NULL;
	_tmp39 = NULL;
	reply_unref = (_tmp39 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp38 = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)), _tmp39);
	_tmp40 = NULL;
	vala_ccode_function_call_add_argument (reply_unref, (ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("_reply")));
	(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
	_tmp41 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp41 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) reply_unref)));
	(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeReturnStatement* _tmp43;
		ValaCCodeIdentifier* _tmp42;
		_tmp43 = NULL;
		_tmp42 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp43 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("_result")))));
		(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
		(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	}
	_tmp44 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp44 = vala_ccode_function_copy (function)));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp45 = NULL;
	return (_tmp45 = proxy_name, dbus_iface_name = (g_free (dbus_iface_name), NULL), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL)), (postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL)), (gconnection == NULL) ? NULL : (gconnection = (vala_ccode_node_unref (gconnection), NULL)), (connection == NULL) ? NULL : (connection = (vala_ccode_node_unref (connection), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (conn_unref == NULL) ? NULL : (conn_unref = (vala_ccode_node_unref (conn_unref), NULL)), (message_unref == NULL) ? NULL : (message_unref = (vala_ccode_node_unref (message_unref), NULL)), (reply_unref == NULL) ? NULL : (reply_unref = (vala_ccode_node_unref (reply_unref), NULL)), _tmp45);
}


static char* vala_dbus_client_module_generate_async_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m) {
	char* _tmp0;
	char* _tmp1;
	char* proxy_name;
	ValaAttribute* _tmp2;
	char* _tmp3;
	char* dbus_iface_name;
	ValaCCodeDeclaration* cdecl_;
	char* _tmp5;
	char* _tmp4;
	char* _tmp6;
	char* dataname;
	char* _tmp7;
	ValaCCodeStruct* _tmp8;
	ValaCCodeStruct* datastruct;
	ValaCCodeTypeDefinition* _tmp11;
	ValaCCodeVariableDeclarator* _tmp10;
	char* _tmp9;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	ValaCCodeFormalParameter* _tmp12;
	ValaCCodeFormalParameter* _tmp13;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeFragment* postfragment;
	ValaCCodeDeclaration* _tmp14;
	ValaCCodeVariableDeclarator* _tmp15;
	ValaCCodeDeclaration* _tmp16;
	ValaCCodeVariableDeclarator* _tmp17;
	ValaCCodeDeclaration* _tmp18;
	ValaCCodeVariableDeclarator* _tmp19;
	ValaCCodeDeclaration* _tmp20;
	ValaCCodeVariableDeclarator* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeFunctionCall* _tmp23;
	ValaCCodeFunctionCall* gconnection;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeConstant* _tmp25;
	ValaCCodeUnaryExpression* _tmp27;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeConstant* _tmp28;
	ValaCCodeExpressionStatement* _tmp29;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeFunctionCall* _tmp31;
	ValaCCodeFunctionCall* connection;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeIdentifier* _tmp33;
	ValaCCodeFunctionCall* _tmp34;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp35;
	ValaCCodeUnaryExpression* _tmp37;
	ValaCCodeIdentifier* _tmp36;
	ValaCCodeConstant* _tmp38;
	ValaCCodeExpressionStatement* _tmp39;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeFunctionCall* _tmp41;
	ValaCCodeFunctionCall* conn_unref;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeExpressionStatement* _tmp43;
	ValaCCodeIdentifier* _tmp44;
	ValaCCodeFunctionCall* _tmp45;
	ValaCCodeFunctionCall* message_unref;
	ValaCCodeIdentifier* _tmp46;
	ValaCCodeExpressionStatement* _tmp47;
	ValaCCodeIdentifier* _tmp48;
	ValaCCodeFunctionCall* _tmp49;
	ValaCCodeFunctionCall* dataalloc;
	ValaCCodeIdentifier* _tmp50;
	char* _tmp51;
	ValaCCodeDeclaration* _tmp52;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp53;
	ValaCCodeExpressionStatement* _tmp56;
	ValaCCodeAssignment* _tmp55;
	ValaCCodeIdentifier* _tmp54;
	ValaCCodeExpressionStatement* _tmp61;
	ValaCCodeAssignment* _tmp60;
	ValaCCodeIdentifier* _tmp59;
	ValaCCodeMemberAccess* _tmp58;
	ValaCCodeIdentifier* _tmp57;
	ValaCCodeExpressionStatement* _tmp66;
	ValaCCodeAssignment* _tmp65;
	ValaCCodeIdentifier* _tmp64;
	ValaCCodeMemberAccess* _tmp63;
	ValaCCodeIdentifier* _tmp62;
	ValaCCodeExpressionStatement* _tmp71;
	ValaCCodeAssignment* _tmp70;
	ValaCCodeIdentifier* _tmp69;
	ValaCCodeMemberAccess* _tmp68;
	ValaCCodeIdentifier* _tmp67;
	ValaCCodeIdentifier* _tmp72;
	ValaCCodeFunctionCall* _tmp73;
	ValaCCodeFunctionCall* pending;
	ValaCCodeIdentifier* _tmp74;
	ValaCCodeIdentifier* _tmp77;
	char* _tmp76;
	char* _tmp75;
	ValaCCodeIdentifier* _tmp78;
	ValaCCodeConstant* _tmp79;
	ValaCCodeExpressionStatement* _tmp80;
	ValaCCodeFunction* _tmp81;
	ValaCCodeFunction* _tmp84;
	char* _tmp83;
	char* _tmp82;
	ValaCCodeFormalParameter* _tmp85;
	ValaCCodeFormalParameter* _tmp86;
	ValaCCodeBlock* _tmp87;
	ValaCCodeDeclaration* _tmp89;
	char* _tmp88;
	ValaCCodeVariableDeclarator* _tmp90;
	ValaCCodeExpressionStatement* _tmp94;
	ValaCCodeAssignment* _tmp93;
	ValaCCodeIdentifier* _tmp92;
	ValaCCodeIdentifier* _tmp91;
	ValaCCodeIdentifier* _tmp95;
	ValaCCodeFunctionCall* _tmp96;
	ValaCCodeFunctionCall* object_creation;
	ValaCCodeConstant* _tmp97;
	ValaCCodeConstant* _tmp98;
	ValaCCodeConstant* _tmp99;
	ValaCCodeIdentifier* _tmp100;
	ValaCCodeFunctionCall* _tmp101;
	ValaCCodeFunctionCall* async_result_creation;
	ValaCCodeMemberAccess* _tmp103;
	ValaCCodeIdentifier* _tmp102;
	ValaCCodeMemberAccess* _tmp105;
	ValaCCodeIdentifier* _tmp104;
	ValaCCodeIdentifier* _tmp106;
	ValaCCodeIdentifier* _tmp107;
	ValaCCodeFunctionCall* _tmp108;
	ValaCCodeFunctionCall* completecall;
	ValaCCodeExpressionStatement* _tmp109;
	ValaCCodeFunction* _tmp110;
	char* _tmp111;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iface != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	proxy_name = (_tmp1 = g_strdup_printf ("%sdbus_proxy_%s_async", _tmp0 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	dbus_iface_name = (_tmp3 = vala_attribute_get_string (_tmp2 = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus"), "name"), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)), _tmp3);
	cdecl_ = NULL;
	/* generate data struct*/
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp6 = NULL;
	dataname = (_tmp6 = g_strdup_printf ("%sDBusProxy%sData", _tmp4 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), _tmp5 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) m))), _tmp5 = (g_free (_tmp5), NULL), _tmp4 = (g_free (_tmp4), NULL), _tmp6);
	_tmp7 = NULL;
	_tmp8 = NULL;
	datastruct = (_tmp8 = vala_ccode_struct_new (_tmp7 = g_strconcat ("_", dataname, NULL)), _tmp7 = (g_free (_tmp7), NULL), _tmp8);
	vala_ccode_struct_add_field (datastruct, "GAsyncReadyCallback", "callback");
	vala_ccode_struct_add_field (datastruct, "gpointer", "user_data");
	vala_ccode_struct_add_field (datastruct, "DBusPendingCall*", "pending");
	vala_ccode_declaration_space_add_type_definition (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) datastruct);
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_declaration_space_add_type_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp11 = vala_ccode_type_definition_new (_tmp9 = g_strconcat ("struct _", dataname, NULL), (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new (dataname, NULL)))));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp9 = (g_free (_tmp9), NULL);
	/* generate async function*/
	function = vala_ccode_function_new (proxy_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp12 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), _tmp12 = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback"));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp13 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), _tmp13 = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, function, NULL, NULL, NULL, 1);
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	postfragment = vala_ccode_fragment_new ();
	_tmp14 = NULL;
	cdecl_ = (_tmp14 = vala_ccode_declaration_new ("DBusGConnection"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp14);
	_tmp15 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp15 = vala_ccode_variable_declarator_new ("*_connection", NULL)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp16 = NULL;
	cdecl_ = (_tmp16 = vala_ccode_declaration_new ("DBusMessage"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp16);
	_tmp17 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp17 = vala_ccode_variable_declarator_new ("*_message", NULL)));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp18 = NULL;
	cdecl_ = (_tmp18 = vala_ccode_declaration_new ("DBusPendingCall"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp18);
	_tmp19 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp19 = vala_ccode_variable_declarator_new ("*_pending", NULL)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp20 = NULL;
	cdecl_ = (_tmp20 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp20);
	_tmp21 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp21 = vala_ccode_variable_declarator_new ("_iter", NULL)));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	vala_dbus_client_module_generate_marshalling (self, m, dbus_iface_name, prefragment, postfragment);
	_tmp22 = NULL;
	_tmp23 = NULL;
	gconnection = (_tmp23 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("g_object_get"))), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)), _tmp23);
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("self")));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp25 = vala_ccode_constant_new ("\"connection\"")));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp27 = NULL;
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp27 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("_connection")))));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp28 = vala_ccode_constant_new ("NULL")));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp29 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp29 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) gconnection)));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	_tmp30 = NULL;
	_tmp31 = NULL;
	connection = (_tmp31 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("dbus_g_connection_get_connection"))), (_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)), _tmp31);
	_tmp32 = NULL;
	vala_ccode_function_call_add_argument (connection, (ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new ("_connection")));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	_tmp33 = NULL;
	_tmp34 = NULL;
	ccall = (_tmp34 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new ("dbus_connection_send_with_reply"))), (_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)), _tmp34);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) connection);
	_tmp35 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("_message")));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	_tmp37 = NULL;
	_tmp36 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp37 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("_pending")))));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	_tmp38 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp38 = vala_ccode_constant_new ("-1")));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	_tmp39 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp39 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	_tmp40 = NULL;
	_tmp41 = NULL;
	conn_unref = (_tmp41 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("dbus_g_connection_unref"))), (_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)), _tmp41);
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (conn_unref, (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("_connection")));
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	_tmp43 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp43 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) conn_unref)));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	_tmp44 = NULL;
	_tmp45 = NULL;
	message_unref = (_tmp45 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp44 = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)), _tmp45);
	_tmp46 = NULL;
	vala_ccode_function_call_add_argument (message_unref, (ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new ("_message")));
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	_tmp47 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp47 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) message_unref)));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	_tmp48 = NULL;
	_tmp49 = NULL;
	dataalloc = (_tmp49 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new ("g_slice_new0"))), (_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)), _tmp49);
	_tmp50 = NULL;
	vala_ccode_function_call_add_argument (dataalloc, (ValaCCodeExpression*) (_tmp50 = vala_ccode_identifier_new (dataname)));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	_tmp51 = NULL;
	_tmp52 = NULL;
	datadecl = (_tmp52 = vala_ccode_declaration_new (_tmp51 = g_strconcat (dataname, "*", NULL)), _tmp51 = (g_free (_tmp51), NULL), _tmp52);
	_tmp53 = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp53 = vala_ccode_variable_declarator_new ("data", NULL)));
	(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) datadecl);
	_tmp56 = NULL;
	_tmp55 = NULL;
	_tmp54 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp56 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp55 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) dataalloc, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	_tmp61 = NULL;
	_tmp60 = NULL;
	_tmp59 = NULL;
	_tmp58 = NULL;
	_tmp57 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp61 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp60 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp58 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new ("data")), "callback")), (ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("callback")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
	(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
	(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
	(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	_tmp66 = NULL;
	_tmp65 = NULL;
	_tmp64 = NULL;
	_tmp63 = NULL;
	_tmp62 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp66 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp65 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp63 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp62 = vala_ccode_identifier_new ("data")), "user_data")), (ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new ("user_data")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
	(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
	(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
	(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
	(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
	_tmp71 = NULL;
	_tmp70 = NULL;
	_tmp69 = NULL;
	_tmp68 = NULL;
	_tmp67 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp71 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp70 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp68 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new ("data")), "pending")), (ValaCCodeExpression*) (_tmp69 = vala_ccode_identifier_new ("_pending")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
	(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
	(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
	(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
	(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
	_tmp72 = NULL;
	_tmp73 = NULL;
	pending = (_tmp73 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new ("dbus_pending_call_set_notify"))), (_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)), _tmp73);
	_tmp74 = NULL;
	vala_ccode_function_call_add_argument (pending, (ValaCCodeExpression*) (_tmp74 = vala_ccode_identifier_new ("_pending")));
	(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
	_tmp77 = NULL;
	_tmp76 = NULL;
	_tmp75 = NULL;
	vala_ccode_function_call_add_argument (pending, (ValaCCodeExpression*) (_tmp77 = vala_ccode_identifier_new (_tmp76 = g_strdup_printf ("%sdbus_proxy_%s_ready", _tmp75 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m)))));
	(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
	_tmp76 = (g_free (_tmp76), NULL);
	_tmp75 = (g_free (_tmp75), NULL);
	_tmp78 = NULL;
	vala_ccode_function_call_add_argument (pending, (ValaCCodeExpression*) (_tmp78 = vala_ccode_identifier_new ("data")));
	(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
	_tmp79 = NULL;
	vala_ccode_function_call_add_argument (pending, (ValaCCodeExpression*) (_tmp79 = vala_ccode_constant_new ("NULL")));
	(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
	_tmp80 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp80 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) pending)));
	(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
	_tmp81 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp81 = vala_ccode_function_copy (function)));
	(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	/* generate ready function*/
	_tmp84 = NULL;
	_tmp83 = NULL;
	_tmp82 = NULL;
	function = (_tmp84 = vala_ccode_function_new (_tmp83 = g_strdup_printf ("%sdbus_proxy_%s_ready", _tmp82 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m)), "void"), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), _tmp84);
	_tmp83 = (g_free (_tmp83), NULL);
	_tmp82 = (g_free (_tmp82), NULL);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp85 = NULL;
	vala_ccode_function_add_parameter (function, _tmp85 = vala_ccode_formal_parameter_new ("pending", "DBusPendingCall*"));
	(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
	_tmp86 = NULL;
	vala_ccode_function_add_parameter (function, _tmp86 = vala_ccode_formal_parameter_new ("user_data", "void*"));
	(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
	_tmp87 = NULL;
	block = (_tmp87 = vala_ccode_block_new (), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp87);
	_tmp89 = NULL;
	_tmp88 = NULL;
	datadecl = (_tmp89 = vala_ccode_declaration_new (_tmp88 = g_strconcat (dataname, "*", NULL)), (datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL)), _tmp89);
	_tmp88 = (g_free (_tmp88), NULL);
	_tmp90 = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp90 = vala_ccode_variable_declarator_new ("data", NULL)));
	(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) datadecl);
	_tmp94 = NULL;
	_tmp93 = NULL;
	_tmp92 = NULL;
	_tmp91 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp94 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp93 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp91 = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) (_tmp92 = vala_ccode_identifier_new ("user_data")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
	(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
	(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
	(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
	/* complete async call by invoking callback*/
	_tmp95 = NULL;
	_tmp96 = NULL;
	object_creation = (_tmp96 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp95 = vala_ccode_identifier_new ("g_object_newv"))), (_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL)), _tmp96);
	_tmp97 = NULL;
	vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp97 = vala_ccode_constant_new ("G_TYPE_OBJECT")));
	(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
	_tmp98 = NULL;
	vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp98 = vala_ccode_constant_new ("0")));
	(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
	_tmp99 = NULL;
	vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp99 = vala_ccode_constant_new ("NULL")));
	(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
	_tmp100 = NULL;
	_tmp101 = NULL;
	async_result_creation = (_tmp101 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp100 = vala_ccode_identifier_new ("g_simple_async_result_new"))), (_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL)), _tmp101);
	vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) object_creation);
	_tmp103 = NULL;
	_tmp102 = NULL;
	vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp103 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp102 = vala_ccode_identifier_new ("data")), "callback")));
	(_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL));
	(_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL));
	_tmp105 = NULL;
	_tmp104 = NULL;
	vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp105 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp104 = vala_ccode_identifier_new ("data")), "user_data")));
	(_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL));
	(_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL));
	_tmp106 = NULL;
	vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp106 = vala_ccode_identifier_new ("data")));
	(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
	_tmp107 = NULL;
	_tmp108 = NULL;
	completecall = (_tmp108 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp107 = vala_ccode_identifier_new ("g_simple_async_result_complete"))), (_tmp107 == NULL) ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL)), _tmp108);
	vala_ccode_function_call_add_argument (completecall, (ValaCCodeExpression*) async_result_creation);
	_tmp109 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp109 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) completecall)));
	(_tmp109 == NULL) ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL));
	_tmp110 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp110 = vala_ccode_function_copy (function)));
	(_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp111 = NULL;
	return (_tmp111 = proxy_name, dbus_iface_name = (g_free (dbus_iface_name), NULL), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), dataname = (g_free (dataname), NULL), (datastruct == NULL) ? NULL : (datastruct = (vala_ccode_node_unref (datastruct), NULL)), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL)), (postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL)), (gconnection == NULL) ? NULL : (gconnection = (vala_ccode_node_unref (gconnection), NULL)), (connection == NULL) ? NULL : (connection = (vala_ccode_node_unref (connection), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (conn_unref == NULL) ? NULL : (conn_unref = (vala_ccode_node_unref (conn_unref), NULL)), (message_unref == NULL) ? NULL : (message_unref = (vala_ccode_node_unref (message_unref), NULL)), (dataalloc == NULL) ? NULL : (dataalloc = (vala_ccode_node_unref (dataalloc), NULL)), (datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL)), (pending == NULL) ? NULL : (pending = (vala_ccode_node_unref (pending), NULL)), (object_creation == NULL) ? NULL : (object_creation = (vala_ccode_node_unref (object_creation), NULL)), (async_result_creation == NULL) ? NULL : (async_result_creation = (vala_ccode_node_unref (async_result_creation), NULL)), (completecall == NULL) ? NULL : (completecall = (vala_ccode_node_unref (completecall), NULL)), _tmp111);
}


static char* vala_dbus_client_module_generate_finish_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m) {
	char* _tmp0;
	char* _tmp1;
	char* proxy_name;
	ValaAttribute* _tmp2;
	char* _tmp3;
	char* dbus_iface_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeFragment* postfragment;
	char* _tmp6;
	char* _tmp5;
	char* _tmp7;
	char* dataname;
	ValaCCodeDeclaration* _tmp9;
	char* _tmp8;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeDeclaration* _tmp13;
	ValaCCodeVariableDeclarator* _tmp14;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeFunctionCall* get_source_tag;
	ValaCCodeCastExpression* _tmp18;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeExpressionStatement* _tmp21;
	ValaCCodeAssignment* _tmp20;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeFunctionCall* _tmp23;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeMemberAccess* _tmp25;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeExpressionStatement* _tmp28;
	ValaCCodeAssignment* _tmp27;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeFunctionCall* _tmp30;
	ValaCCodeFunctionCall* reply_unref;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeExpressionStatement* _tmp32;
	ValaCCodeFunction* _tmp35;
	char* _tmp36;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iface != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	proxy_name = (_tmp1 = g_strdup_printf ("%sdbus_proxy_%s_finish", _tmp0 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	dbus_iface_name = (_tmp3 = vala_attribute_get_string (_tmp2 = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus"), "name"), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)), _tmp3);
	cdecl_ = NULL;
	function = vala_ccode_function_new (proxy_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp4 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), _tmp4 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, function, NULL, NULL, NULL, 2);
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	postfragment = vala_ccode_fragment_new ();
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	dataname = (_tmp7 = g_strdup_printf ("%sDBusProxy%sData", _tmp5 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), _tmp6 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) m))), _tmp6 = (g_free (_tmp6), NULL), _tmp5 = (g_free (_tmp5), NULL), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	cdecl_ = (_tmp9 = vala_ccode_declaration_new (_tmp8 = g_strconcat (dataname, "*", NULL)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp9);
	_tmp8 = (g_free (_tmp8), NULL);
	_tmp10 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new ("data", NULL)));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ("DBusMessage"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp12 = vala_ccode_variable_declarator_new ("*_reply", NULL)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp13 = NULL;
	cdecl_ = (_tmp13 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp13);
	_tmp14 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp14 = vala_ccode_variable_declarator_new ("_iter", NULL)));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp15 = NULL;
	_tmp16 = NULL;
	get_source_tag = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("g_simple_async_result_get_source_tag"))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp16);
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (get_source_tag, (ValaCCodeExpression*) (_tmp18 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new ("res")), "GSimpleAsyncResult *")));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp21 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) get_source_tag, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp22 = NULL;
	_tmp23 = NULL;
	ccall = (_tmp23 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("dbus_pending_call_steal_reply"))), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)), _tmp23);
	_tmp25 = NULL;
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("data")), "pending")));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp28 = NULL;
	_tmp27 = NULL;
	_tmp26 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp28 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("_reply")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	vala_dbus_client_module_generate_marshalling (self, m, dbus_iface_name, prefragment, postfragment);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) postfragment);
	_tmp29 = NULL;
	_tmp30 = NULL;
	reply_unref = (_tmp30 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)), _tmp30);
	_tmp31 = NULL;
	vala_ccode_function_call_add_argument (reply_unref, (ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("_reply")));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	_tmp32 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp32 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) reply_unref)));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeReturnStatement* _tmp34;
		ValaCCodeIdentifier* _tmp33;
		_tmp34 = NULL;
		_tmp33 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp34 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new ("_result")))));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	}
	_tmp35 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp35 = vala_ccode_function_copy (function)));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp36 = NULL;
	return (_tmp36 = proxy_name, dbus_iface_name = (g_free (dbus_iface_name), NULL), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL)), (postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL)), dataname = (g_free (dataname), NULL), (get_source_tag == NULL) ? NULL : (get_source_tag = (vala_ccode_node_unref (get_source_tag), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (reply_unref == NULL) ? NULL : (reply_unref = (vala_ccode_node_unref (reply_unref), NULL)), _tmp36);
}


static void vala_dbus_client_module_class_init (ValaDBusClientModuleClass * klass) {
	vala_dbus_client_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_dbus_client_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaDBusClientModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->generate_dynamic_method_wrapper = vala_dbus_client_module_real_generate_dynamic_method_wrapper;
	VALA_GSIGNAL_MODULE_CLASS (klass)->get_dbus_g_type = vala_dbus_client_module_real_get_dbus_g_type;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_property_getter_cname = vala_dbus_client_module_real_get_dynamic_property_getter_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_property_setter_cname = vala_dbus_client_module_real_get_dynamic_property_setter_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_signal_connect_wrapper_name = vala_dbus_client_module_real_get_dynamic_signal_connect_wrapper_name;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_signal_disconnect_wrapper_name = vala_dbus_client_module_real_get_dynamic_signal_disconnect_wrapper_name;
	VALA_CCODE_MODULE_CLASS (klass)->visit_cast_expression = vala_dbus_client_module_real_visit_cast_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_interface = vala_dbus_client_module_real_visit_interface;
}


static void vala_dbus_client_module_instance_init (ValaDBusClientModule * self) {
	self->priv = VALA_DBUS_CLIENT_MODULE_GET_PRIVATE (self);
}


static void vala_dbus_client_module_finalize (ValaCCodeModule* obj) {
	ValaDBusClientModule * self;
	self = VALA_DBUS_CLIENT_MODULE (obj);
	VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->finalize (obj);
}


GType vala_dbus_client_module_get_type (void) {
	static GType vala_dbus_client_module_type_id = 0;
	if (vala_dbus_client_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusClientModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_client_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusClientModule), 0, (GInstanceInitFunc) vala_dbus_client_module_instance_init, NULL };
		vala_dbus_client_module_type_id = g_type_register_static (VALA_TYPE_DBUS_MODULE, "ValaDBusClientModule", &g_define_type_info, 0);
	}
	return vala_dbus_client_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




