/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
enum  {
	VALA_CCODE_METHOD_CALL_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeAssignmentModule* vala_ccode_assignment_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeAssignmentModule* vala_ccode_assignment_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
void vala_ccode_module_generate_dynamic_method_wrapper (ValaCCodeModule* self, ValaDynamicMethod* method);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static gpointer vala_ccode_method_call_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodCallModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE, codegen, next);
}


static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeFunctionCall* async_call;
	ValaMethod* m;
	ValaDelegate* deleg;
	GeeList* params;
	ValaMemberAccess* _tmp1_;
	ValaExpression* _tmp0_;
	ValaMemberAccess* ma;
	ValaDataType* _tmp2_;
	ValaDataType* itype;
	GeeList* _tmp3_;
	GeeHashMap* in_arg_map;
	GeeHashMap* out_arg_map;
	gboolean _tmp20_;
	gboolean _tmp21_;
	ValaCCodeExpression* _tmp60_;
	ValaCCodeExpression* ccall_expr;
	ValaCCodeExpression* instance;
	gboolean _tmp64_;
	gboolean _tmp65_;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	gboolean _tmp209_;
	gboolean _tmp225_;
	gboolean _tmp241_;
	gboolean _tmp252_;
	gboolean _tmp263_;
	gint last_pos;
	gint min_pos;
	gboolean _tmp283_;
	gboolean _tmp284_;
	gboolean _tmp286_;
	gboolean _tmp287_;
	gboolean _tmp288_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))));
	async_call = NULL;
	m = NULL;
	deleg = NULL;
	params = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	ma = (_tmp1_ = (_tmp0_ = vala_method_call_get_call (expr), VALA_IS_MEMBER_ACCESS (_tmp0_) ? ((ValaMemberAccess*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = NULL;
	itype = (_tmp2_ = vala_expression_get_value_type (vala_method_call_get_call (expr)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	_tmp3_ = NULL;
	params = (_tmp3_ = vala_data_type_get_parameters (itype), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp3_);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp5_;
		ValaMethod* _tmp4_;
		g_assert (ma != NULL);
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		m = (_tmp5_ = (_tmp4_ = vala_method_type_get_method_symbol (VALA_METHOD_TYPE (itype)), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp5_);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaSignalType* _tmp6_;
			ValaSignalType* sig_type;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = NULL;
			sig_type = (_tmp6_ = VALA_SIGNAL_TYPE (itype), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
			_tmp7_ = FALSE;
			_tmp8_ = FALSE;
			if (ma != NULL) {
				_tmp8_ = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				_tmp7_ = vala_signal_get_is_virtual (vala_signal_type_get_signal_symbol (sig_type));
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				ValaMethod* _tmp9_;
				_tmp9_ = NULL;
				m = (_tmp9_ = vala_signal_get_method_handler (vala_signal_type_get_signal_symbol (sig_type)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp9_);
			} else {
				ValaCCodeFunctionCall* _tmp11_;
				ValaCCodeFunctionCall* _tmp10_;
				_tmp11_ = NULL;
				_tmp10_ = NULL;
				ccall = (_tmp11_ = (_tmp10_ = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))), (_tmp10_ == NULL) ? NULL : vala_ccode_node_ref (_tmp10_)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp11_);
			}
			(sig_type == NULL) ? NULL : (sig_type = (vala_code_node_unref (sig_type), NULL));
		} else {
			if (VALA_IS_OBJECT_TYPE (itype)) {
				ValaClass* _tmp12_;
				ValaClass* cl;
				ValaMethod* _tmp14_;
				ValaMethod* _tmp13_;
				ValaCCodeFunctionCall* _tmp17_;
				ValaCCodeIdentifier* _tmp16_;
				char* _tmp15_;
				/* constructor*/
				_tmp12_ = NULL;
				cl = (_tmp12_ = VALA_CLASS (vala_object_type_get_type_symbol (VALA_OBJECT_TYPE (itype))), (_tmp12_ == NULL) ? NULL : vala_code_node_ref (_tmp12_));
				_tmp14_ = NULL;
				_tmp13_ = NULL;
				m = (_tmp14_ = (_tmp13_ = vala_class_get_default_construction_method (cl), (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp14_);
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations);
				_tmp17_ = NULL;
				_tmp16_ = NULL;
				_tmp15_ = NULL;
				ccall = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new (_tmp15_ = vala_method_get_real_cname (m)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp17_);
				(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
				_tmp15_ = (g_free (_tmp15_), NULL);
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			} else {
				if (VALA_IS_DELEGATE_TYPE (itype)) {
					ValaDelegate* _tmp19_;
					ValaDelegate* _tmp18_;
					_tmp19_ = NULL;
					_tmp18_ = NULL;
					deleg = (_tmp19_ = (_tmp18_ = vala_delegate_type_get_delegate_symbol (VALA_DELEGATE_TYPE (itype)), (_tmp18_ == NULL) ? NULL : vala_code_node_ref (_tmp18_)), (deleg == NULL) ? NULL : (deleg = (vala_code_node_unref (deleg), NULL)), _tmp19_);
				}
			}
		}
	}
	in_arg_map = NULL;
	out_arg_map = NULL;
	_tmp20_ = FALSE;
	_tmp21_ = FALSE;
	if (m != NULL) {
		_tmp21_ = vala_method_get_coroutine (m);
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp22_ = FALSE;
		_tmp23_ = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp23_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			_tmp22_ = TRUE;
		} else {
			gboolean _tmp24_;
			_tmp24_ = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp24_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp24_ = FALSE;
			}
			_tmp22_ = _tmp24_;
		}
		_tmp20_ = _tmp22_;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		GeeHashMap* _tmp25_;
		GeeHashMap* _tmp26_;
		ValaCCodeFunctionCall* _tmp30_;
		ValaCCodeIdentifier* _tmp29_;
		char* _tmp28_;
		char* _tmp27_;
		gboolean _tmp31_;
		/* async call*/
		_tmp25_ = NULL;
		in_arg_map = (_tmp25_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL)), _tmp25_);
		_tmp26_ = NULL;
		out_arg_map = (_tmp26_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL)), _tmp26_);
		_tmp30_ = NULL;
		_tmp29_ = NULL;
		_tmp28_ = NULL;
		_tmp27_ = NULL;
		async_call = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new (_tmp28_ = g_strconcat (_tmp27_ = vala_method_get_cname (m), "_async", NULL)))), (async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL)), _tmp30_);
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
		_tmp28_ = (g_free (_tmp28_), NULL);
		_tmp27_ = (g_free (_tmp27_), NULL);
		_tmp31_ = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
			_tmp31_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			ValaCCodeFunctionCall* _tmp33_;
			ValaCCodeFunctionCall* _tmp32_;
			/* no finish call*/
			_tmp33_ = NULL;
			_tmp32_ = NULL;
			ccall = (_tmp33_ = (_tmp32_ = async_call, (_tmp32_ == NULL) ? NULL : vala_ccode_node_ref (_tmp32_)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp33_);
		} else {
			ValaCCodeFunctionCall* _tmp37_;
			ValaCCodeIdentifier* _tmp36_;
			char* _tmp35_;
			char* _tmp34_;
			ValaCCodeMemberAccess* _tmp39_;
			ValaCCodeIdentifier* _tmp38_;
			_tmp37_ = NULL;
			_tmp36_ = NULL;
			_tmp35_ = NULL;
			_tmp34_ = NULL;
			ccall = (_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new (_tmp35_ = g_strconcat (_tmp34_ = vala_method_get_cname (m), "_finish", NULL)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp37_);
			(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
			_tmp35_ = (g_free (_tmp35_), NULL);
			_tmp34_ = (g_free (_tmp34_), NULL);
			/* pass GAsyncResult stored in closure to finish function*/
			_tmp39_ = NULL;
			_tmp38_ = NULL;
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) (_tmp39_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new ("data")), "res")));
			(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
			(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		}
	} else {
		GeeHashMap* _tmp40_;
		GeeHashMap* _tmp42_;
		GeeHashMap* _tmp41_;
		_tmp40_ = NULL;
		in_arg_map = (_tmp40_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL)), _tmp40_);
		_tmp42_ = NULL;
		_tmp41_ = NULL;
		out_arg_map = (_tmp42_ = (_tmp41_ = in_arg_map, (_tmp41_ == NULL) ? NULL : gee_collection_object_ref (_tmp41_)), (out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL)), _tmp42_);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCCodeIdentifier* _tmp43_;
		_tmp43_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_identifier_new ("object_type")));
		(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
		{
			GeeList* _tmp44_;
			GeeIterator* _tmp45_;
			GeeIterator* _base_type_it;
			_tmp44_ = NULL;
			_tmp45_ = NULL;
			_base_type_it = (_tmp45_ = gee_iterable_iterator ((GeeIterable*) (_tmp44_ = vala_class_get_base_types (((ValaCCodeBaseModule*) self)->current_class))), (_tmp44_ == NULL) ? NULL : (_tmp44_ = (gee_collection_object_unref (_tmp44_), NULL)), _tmp45_);
			while (gee_iterator_next (_base_type_it)) {
				ValaDataType* base_type;
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
					{
						GeeList* _tmp46_;
						GeeIterator* _tmp47_;
						GeeIterator* _type_arg_it;
						_tmp46_ = NULL;
						_tmp47_ = NULL;
						_type_arg_it = (_tmp47_ = gee_iterable_iterator ((GeeIterable*) (_tmp46_ = vala_data_type_get_type_arguments (base_type))), (_tmp46_ == NULL) ? NULL : (_tmp46_ = (gee_collection_object_unref (_tmp46_), NULL)), _tmp47_);
						while (gee_iterator_next (_type_arg_it)) {
							ValaDataType* type_arg;
							type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
							if (VALA_IS_GENERIC_TYPE (type_arg)) {
								char* type_param;
								ValaCCodeIdentifier* _tmp49_;
								char* _tmp48_;
								ValaCCodeIdentifier* _tmp51_;
								char* _tmp50_;
								ValaCCodeIdentifier* _tmp53_;
								char* _tmp52_;
								/* map generic type parameter*/
								type_param = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type_arg)), -1);
								_tmp49_ = NULL;
								_tmp48_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp49_ = vala_ccode_identifier_new (_tmp48_ = g_strdup_printf ("%s_type", type_param))));
								(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
								_tmp48_ = (g_free (_tmp48_), NULL);
								_tmp51_ = NULL;
								_tmp50_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new (_tmp50_ = g_strdup_printf ("%s_dup_func", type_param))));
								(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
								_tmp50_ = (g_free (_tmp50_), NULL);
								_tmp53_ = NULL;
								_tmp52_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new (_tmp52_ = g_strdup_printf ("%s_destroy_func", type_param))));
								(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
								_tmp52_ = (g_free (_tmp52_), NULL);
								type_param = (g_free (type_param), NULL);
							} else {
								ValaCCodeIdentifier* _tmp55_;
								char* _tmp54_;
								_tmp55_ = NULL;
								_tmp54_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp55_ = vala_ccode_identifier_new (_tmp54_ = vala_data_type_get_type_id (type_arg))));
								(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
								_tmp54_ = (g_free (_tmp54_), NULL);
								if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, type_arg)) {
									ValaCCodeExpression* dup_func;
									ValaCCodeCastExpression* _tmp56_;
									ValaCCodeExpression* _tmp57_;
									dup_func = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, type_arg, vala_code_node_get_source_reference ((ValaCodeNode*) type_arg));
									if (dup_func == NULL) {
										/* type doesn't contain a copy function*/
										vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
										(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
										(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
										(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
										(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
										(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
										(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
										(async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL));
										(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
										(deleg == NULL) ? NULL : (deleg = (vala_code_node_unref (deleg), NULL));
										(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
										(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
										(itype == NULL) ? NULL : (itype = (vala_code_node_unref (itype), NULL));
										(in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL));
										(out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL));
										return;
									}
									_tmp56_ = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_cast_expression_new (dup_func, "GBoxedCopyFunc")));
									(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
									_tmp57_ = NULL;
									vala_ccode_function_call_add_argument (ccall, _tmp57_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, type_arg));
									(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
									(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
								} else {
									ValaCCodeConstant* _tmp58_;
									ValaCCodeConstant* _tmp59_;
									_tmp58_ = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp58_ = vala_ccode_constant_new ("NULL")));
									(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
									_tmp59_ = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp59_ = vala_ccode_constant_new ("NULL")));
									(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
								}
							}
							(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
						}
						(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
					}
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					break;
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp60_ = NULL;
	ccall_expr = (_tmp60_ = (ValaCCodeExpression*) ccall, (_tmp60_ == NULL) ? NULL : vala_ccode_node_ref (_tmp60_));
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp61_;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp63_;
		char* _tmp62_;
		_tmp61_ = NULL;
		array_type = (_tmp61_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp61_ == NULL) ? NULL : vala_code_node_ref (_tmp61_));
		_tmp63_ = NULL;
		_tmp62_ = NULL;
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) 0, FALSE)), (ValaCCodeExpression*) (_tmp63_ = vala_ccode_identifier_new (_tmp62_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
		_tmp62_ = (g_free (_tmp62_), NULL);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	_tmp64_ = FALSE;
	_tmp65_ = FALSE;
	if (m != NULL) {
		_tmp65_ = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp65_ = FALSE;
	}
	if (_tmp65_) {
		_tmp64_ = !VALA_IS_CREATION_METHOD (m);
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		ValaCCodeExpression* _tmp67_;
		ValaCCodeExpression* _tmp66_;
		gboolean _tmp68_;
		ValaStruct* _tmp73_;
		ValaSymbol* _tmp72_;
		ValaStruct* st;
		gboolean _tmp74_;
		_tmp67_ = NULL;
		_tmp66_ = NULL;
		instance = (_tmp67_ = (_tmp66_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp66_ == NULL) ? NULL : vala_ccode_node_ref (_tmp66_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp67_);
		_tmp68_ = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
			_tmp68_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
		} else {
			_tmp68_ = FALSE;
		}
		if (_tmp68_) {
			ValaMemberAccess* _tmp69_;
			ValaMemberAccess* inner_ma;
			ValaCCodeExpression* _tmp71_;
			ValaCCodeExpression* _tmp70_;
			_tmp69_ = NULL;
			inner_ma = (_tmp69_ = VALA_MEMBER_ACCESS (vala_member_access_get_inner (ma)), (_tmp69_ == NULL) ? NULL : vala_code_node_ref (_tmp69_));
			_tmp71_ = NULL;
			_tmp70_ = NULL;
			instance = (_tmp71_ = (_tmp70_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (inner_ma))), (_tmp70_ == NULL) ? NULL : vala_ccode_node_ref (_tmp70_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp71_);
			(inner_ma == NULL) ? NULL : (inner_ma = (vala_code_node_unref (inner_ma), NULL));
		}
		_tmp73_ = NULL;
		_tmp72_ = NULL;
		st = (_tmp73_ = (_tmp72_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_STRUCT (_tmp72_) ? ((ValaStruct*) _tmp72_) : NULL), (_tmp73_ == NULL) ? NULL : vala_code_node_ref (_tmp73_));
		_tmp74_ = FALSE;
		if (st != NULL) {
			_tmp74_ = !vala_struct_is_simple_type (st);
		} else {
			_tmp74_ = FALSE;
		}
		if (_tmp74_) {
			ValaCCodeUnaryExpression* _tmp76_;
			ValaCCodeExpression* _tmp75_;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp77_;
			/* we need to pass struct instance by reference*/
			_tmp76_ = NULL;
			_tmp75_ = NULL;
			unary = (_tmp76_ = (_tmp75_ = instance, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp75_) ? ((ValaCCodeUnaryExpression*) _tmp75_) : NULL), (_tmp76_ == NULL) ? NULL : vala_ccode_node_ref (_tmp76_));
			_tmp77_ = FALSE;
			if (unary != NULL) {
				_tmp77_ = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp77_ = FALSE;
			}
			if (_tmp77_) {
				ValaCCodeExpression* _tmp79_;
				ValaCCodeExpression* _tmp78_;
				/* *expr => expr*/
				_tmp79_ = NULL;
				_tmp78_ = NULL;
				instance = (_tmp79_ = (_tmp78_ = vala_ccode_unary_expression_get_inner (unary), (_tmp78_ == NULL) ? NULL : vala_ccode_node_ref (_tmp78_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp79_);
			} else {
				gboolean _tmp80_;
				_tmp80_ = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (instance)) {
					_tmp80_ = TRUE;
				} else {
					_tmp80_ = VALA_IS_CCODE_MEMBER_ACCESS (instance);
				}
				if (_tmp80_) {
					ValaCCodeExpression* _tmp81_;
					_tmp81_ = NULL;
					instance = (_tmp81_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp81_);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp83_;
					ValaCCodeExpression* _tmp82_;
					ValaCCodeUnaryExpression* _tmp85_;
					ValaCCodeExpression* _tmp84_;
					ValaCCodeExpression* _tmp87_;
					ValaCCodeExpression* _tmp86_;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp83_ = NULL;
					_tmp82_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp83_ = vala_ccode_assignment_new (_tmp82_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL));
					(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
					_tmp85_ = NULL;
					_tmp84_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp85_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp84_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)))));
					(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
					(_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL));
					_tmp87_ = NULL;
					_tmp86_ = NULL;
					instance = (_tmp87_ = (_tmp86_ = (ValaCCodeExpression*) ccomma, (_tmp86_ == NULL) ? NULL : vala_ccode_node_ref (_tmp86_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp87_);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		}
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	} else {
		gboolean _tmp88_;
		_tmp88_ = FALSE;
		if (m != NULL) {
			_tmp88_ = vala_method_get_binding (m) == MEMBER_BINDING_CLASS;
		} else {
			_tmp88_ = FALSE;
		}
		if (_tmp88_) {
			ValaClass* _tmp89_;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp92_;
			char* _tmp91_;
			char* _tmp90_;
			ValaCCodeFunctionCall* _tmp93_;
			ValaCCodeFunctionCall* cast;
			ValaCCodeExpression* klass;
			_tmp89_ = NULL;
			cl = (_tmp89_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp89_ == NULL) ? NULL : vala_code_node_ref (_tmp89_));
			_tmp92_ = NULL;
			_tmp91_ = NULL;
			_tmp90_ = NULL;
			_tmp93_ = NULL;
			cast = (_tmp93_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp92_ = vala_ccode_identifier_new (_tmp91_ = g_strconcat (_tmp90_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_ccode_node_unref (_tmp92_), NULL)), _tmp91_ = (g_free (_tmp91_), NULL), _tmp90_ = (g_free (_tmp90_), NULL), _tmp93_);
			klass = NULL;
			if (vala_member_access_get_inner (ma) == NULL) {
				if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
					ValaCCodeExpression* _tmp94_;
					/* Accessing the method from a static or class constructor*/
					_tmp94_ = NULL;
					klass = (_tmp94_ = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp94_);
				} else {
					ValaCCodeIdentifier* _tmp95_;
					ValaCCodeFunctionCall* _tmp96_;
					ValaCCodeFunctionCall* k;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeExpression* _tmp99_;
					ValaCCodeExpression* _tmp98_;
					/* Accessing the method from within an instance method*/
					_tmp95_ = NULL;
					_tmp96_ = NULL;
					k = (_tmp96_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp95_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL)), _tmp96_);
					_tmp97_ = NULL;
					vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp97_ = vala_ccode_identifier_new ("self")));
					(_tmp97_ == NULL) ? NULL : (_tmp97_ = (vala_ccode_node_unref (_tmp97_), NULL));
					_tmp99_ = NULL;
					_tmp98_ = NULL;
					klass = (_tmp99_ = (_tmp98_ = (ValaCCodeExpression*) k, (_tmp98_ == NULL) ? NULL : vala_ccode_node_ref (_tmp98_)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp99_);
					(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
				}
			} else {
				ValaCCodeIdentifier* _tmp100_;
				ValaCCodeFunctionCall* _tmp101_;
				ValaCCodeFunctionCall* k;
				ValaCCodeExpression* _tmp103_;
				ValaCCodeExpression* _tmp102_;
				/* Accessing the method of an instance*/
				_tmp100_ = NULL;
				_tmp101_ = NULL;
				k = (_tmp101_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp100_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp100_ == NULL) ? NULL : (_tmp100_ = (vala_ccode_node_unref (_tmp100_), NULL)), _tmp101_);
				vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))));
				_tmp103_ = NULL;
				_tmp102_ = NULL;
				klass = (_tmp103_ = (_tmp102_ = (ValaCCodeExpression*) k, (_tmp102_ == NULL) ? NULL : vala_ccode_node_ref (_tmp102_)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp103_);
				(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
			}
			vala_ccode_function_call_add_argument (cast, klass);
			gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
			(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp104_;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp105_;
		ValaCCodeFunctionCall* _tmp106_;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp108_;
		char* _tmp107_;
		_tmp104_ = NULL;
		array_type = (_tmp104_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp104_ == NULL) ? NULL : vala_code_node_ref (_tmp104_));
		_tmp105_ = NULL;
		_tmp106_ = NULL;
		csizeof = (_tmp106_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp105_ = vala_ccode_identifier_new ("sizeof"))), (_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_ccode_node_unref (_tmp105_), NULL)), _tmp106_);
		_tmp108_ = NULL;
		_tmp107_ = NULL;
		vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp108_ = vala_ccode_identifier_new (_tmp107_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp108_ == NULL) ? NULL : (_tmp108_ = (vala_ccode_node_unref (_tmp108_), NULL));
		_tmp107_ = (g_free (_tmp107_), NULL);
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) csizeof);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* _tmp109_;
				GeeIterator* _tmp110_;
				GeeIterator* _arg_it;
				_tmp109_ = NULL;
				_tmp110_ = NULL;
				_arg_it = (_tmp110_ = gee_iterable_iterator ((GeeIterable*) (_tmp109_ = vala_method_call_get_argument_list (expr))), (_tmp109_ == NULL) ? NULL : (_tmp109_ = (gee_collection_object_unref (_tmp109_), NULL)), _tmp110_);
				while (gee_iterator_next (_arg_it)) {
					ValaExpression* arg;
					ValaUnaryExpression* _tmp112_;
					ValaExpression* _tmp111_;
					ValaUnaryExpression* unary;
					gboolean _tmp113_;
					arg = (ValaExpression*) gee_iterator_get (_arg_it);
					_tmp112_ = NULL;
					_tmp111_ = NULL;
					unary = (_tmp112_ = (_tmp111_ = arg, VALA_IS_UNARY_EXPRESSION (_tmp111_) ? ((ValaUnaryExpression*) _tmp111_) : NULL), (_tmp112_ == NULL) ? NULL : vala_code_node_ref (_tmp112_));
					_tmp113_ = FALSE;
					if (unary != NULL) {
						_tmp113_ = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp113_ = FALSE;
					}
					if (_tmp113_) {
						char* _tmp114_;
						ValaFormalParameter* _tmp115_;
						ValaFormalParameter* param;
						/* out argument*/
						_tmp114_ = NULL;
						_tmp115_ = NULL;
						param = (_tmp115_ = vala_formal_parameter_new (_tmp114_ = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp114_ = (g_free (_tmp114_), NULL), _tmp115_);
						vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
						vala_method_add_parameter (m, param);
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					} else {
						gboolean _tmp116_;
						_tmp116_ = FALSE;
						if (unary != NULL) {
							_tmp116_ = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp116_ = FALSE;
						}
						if (_tmp116_) {
							char* _tmp117_;
							ValaFormalParameter* _tmp118_;
							ValaFormalParameter* param;
							/* ref argument*/
							_tmp117_ = NULL;
							_tmp118_ = NULL;
							param = (_tmp118_ = vala_formal_parameter_new (_tmp117_ = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp117_ = (g_free (_tmp117_), NULL), _tmp118_);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
							vala_method_add_parameter (m, param);
							(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						} else {
							ValaFormalParameter* _tmp120_;
							char* _tmp119_;
							/* in argument*/
							_tmp120_ = NULL;
							_tmp119_ = NULL;
							vala_method_add_parameter (m, _tmp120_ = vala_formal_parameter_new (_tmp119_ = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (arg), NULL));
							(_tmp120_ == NULL) ? NULL : (_tmp120_ = (vala_code_node_unref (_tmp120_), NULL));
							_tmp119_ = (g_free (_tmp119_), NULL);
						}
					}
					param_nr++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
				}
				(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
			}
			{
				GeeList* _tmp121_;
				GeeIterator* _tmp122_;
				GeeIterator* _param_it;
				_tmp121_ = NULL;
				_tmp122_ = NULL;
				_param_it = (_tmp122_ = gee_iterable_iterator ((GeeIterable*) (_tmp121_ = vala_method_get_parameters (m))), (_tmp121_ == NULL) ? NULL : (_tmp121_ = (gee_collection_object_unref (_tmp121_), NULL)), _tmp122_);
				while (gee_iterator_next (_param_it)) {
					ValaFormalParameter* param;
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					vala_code_node_accept ((ValaCodeNode*) param, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
			}
			vala_ccode_module_generate_dynamic_method_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_METHOD (m));
		} else {
			if (VALA_IS_CREATION_METHOD (m)) {
				ValaCCodeExpression* _tmp127_;
				ValaCCodeCastExpression* _tmp126_;
				char* _tmp125_;
				char* _tmp124_;
				ValaCCodeIdentifier* _tmp123_;
				_tmp127_ = NULL;
				_tmp126_ = NULL;
				_tmp125_ = NULL;
				_tmp124_ = NULL;
				_tmp123_ = NULL;
				ccall_expr = (_tmp127_ = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp123_ = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp126_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp125_ = g_strconcat (_tmp124_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, FALSE), "*", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp127_);
				(_tmp126_ == NULL) ? NULL : (_tmp126_ = (vala_ccode_node_unref (_tmp126_), NULL));
				_tmp125_ = (g_free (_tmp125_), NULL);
				_tmp124_ = (g_free (_tmp124_), NULL);
				(_tmp123_ == NULL) ? NULL : (_tmp123_ = (vala_ccode_node_unref (_tmp123_), NULL));
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator ((GeeIterable*) params);
	{
		GeeList* _tmp128_;
		GeeIterator* _tmp129_;
		GeeIterator* _arg_it;
		_tmp128_ = NULL;
		_tmp129_ = NULL;
		_arg_it = (_tmp129_ = gee_iterable_iterator ((GeeIterable*) (_tmp128_ = vala_method_call_get_argument_list (expr))), (_tmp128_ == NULL) ? NULL : (_tmp128_ = (gee_collection_object_unref (_tmp128_), NULL)), _tmp129_);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			ValaCCodeExpression* _tmp130_;
			ValaCCodeExpression* cexpr;
			GeeHashMap* _tmp131_;
			GeeHashMap* carg_map;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			_tmp130_ = NULL;
			cexpr = (_tmp130_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)), (_tmp130_ == NULL) ? NULL : vala_ccode_node_ref (_tmp130_));
			_tmp131_ = NULL;
			carg_map = (_tmp131_ = in_arg_map, (_tmp131_ == NULL) ? NULL : gee_collection_object_ref (_tmp131_));
			if (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				gboolean _tmp132_;
				param = (ValaFormalParameter*) gee_iterator_get (params_it);
				_tmp132_ = FALSE;
				if (vala_formal_parameter_get_params_array (param)) {
					_tmp132_ = TRUE;
				} else {
					_tmp132_ = vala_formal_parameter_get_ellipsis (param);
				}
				ellipsis = _tmp132_;
				if (!ellipsis) {
					gboolean _tmp133_;
					gboolean _tmp134_;
					gboolean multiple_cargs;
					gboolean _tmp141_;
					ValaCCodeExpression* _tmp171_;
					gboolean _tmp172_;
					gboolean _tmp178_;
					gboolean _tmp179_;
					gboolean _tmp180_;
					_tmp133_ = FALSE;
					_tmp134_ = FALSE;
					if (vala_formal_parameter_get_async_only (param)) {
						gboolean _tmp135_;
						_tmp135_ = FALSE;
						if (((ValaCCodeBaseModule*) self)->current_method == NULL) {
							_tmp135_ = TRUE;
						} else {
							_tmp135_ = !vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
						}
						_tmp134_ = _tmp135_;
					} else {
						_tmp134_ = FALSE;
					}
					if (_tmp134_) {
						gboolean _tmp136_;
						_tmp136_ = FALSE;
						if (ma == NULL) {
							_tmp136_ = TRUE;
						} else {
							_tmp136_ = _vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0;
						}
						_tmp133_ = _tmp136_;
					} else {
						_tmp133_ = FALSE;
					}
					if (_tmp133_) {
						ValaCCodeCommaExpression* comma;
						ValaCCodeExpression* _tmp138_;
						ValaCCodeExpression* _tmp137_;
						/* only skip if we are in a sync function (or property handler) 
						 and not manually starting async 
						 [CCode (async_only = true)] and we're making a
						 * synchronous version of the call.  Emit the arg
						 * at the start of a comma expression so that we
						 * get any side effects but otherwise ignore the
						 * value.
						 */
						comma = vala_ccode_comma_expression_new ();
						vala_ccode_comma_expression_append_expression (comma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)));
						vala_ccode_comma_expression_append_expression (comma, ccall_expr);
						_tmp138_ = NULL;
						_tmp137_ = NULL;
						ccall_expr = (_tmp138_ = (_tmp137_ = (ValaCCodeExpression*) comma, (_tmp137_ == NULL) ? NULL : vala_ccode_node_ref (_tmp137_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp138_);
						(comma == NULL) ? NULL : (comma = (vala_ccode_node_unref (comma), NULL));
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
						(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
						(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
						continue;
					}
					/* if the vala argument expands to multiple C arguments,
					 we have to make sure that the C arguments don't depend
					 on each other as there is no guaranteed argument
					 evaluation order
					 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
					multiple_cargs = FALSE;
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
						GeeHashMap* _tmp140_;
						GeeHashMap* _tmp139_;
						_tmp140_ = NULL;
						_tmp139_ = NULL;
						carg_map = (_tmp140_ = (_tmp139_ = out_arg_map, (_tmp139_ == NULL) ? NULL : gee_collection_object_ref (_tmp139_)), (carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)), _tmp140_);
					}
					_tmp141_ = FALSE;
					if (!vala_formal_parameter_get_no_array_length (param)) {
						_tmp141_ = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp141_ = FALSE;
					}
					if (_tmp141_) {
						ValaArrayType* _tmp142_;
						ValaArrayType* array_type;
						_tmp142_ = NULL;
						array_type = (_tmp142_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp142_ == NULL) ? NULL : vala_code_node_ref (_tmp142_));
						{
							gint dim;
							dim = 1;
							for (; dim <= vala_array_type_get_rank (array_type); dim++) {
								ValaCCodeExpression* _tmp143_;
								_tmp143_ = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp143_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), arg, dim));
								(_tmp143_ == NULL) ? NULL : (_tmp143_ = (vala_ccode_node_unref (_tmp143_), NULL));
							}
						}
						multiple_cargs = TRUE;
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					} else {
						if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaDelegateType* _tmp144_;
							ValaDelegateType* deleg_type;
							ValaDelegate* _tmp145_;
							ValaDelegate* d;
							_tmp144_ = NULL;
							deleg_type = (_tmp144_ = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp144_ == NULL) ? NULL : vala_code_node_ref (_tmp144_));
							_tmp145_ = NULL;
							d = (_tmp145_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp145_ == NULL) ? NULL : vala_code_node_ref (_tmp145_));
							if (vala_delegate_get_has_target (d)) {
								ValaCCodeExpression* delegate_target;
								delegate_target = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg);
								if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
									ValaCCodeExpression* delegate_target_destroy_notify;
									ValaMethod* _tmp147_;
									ValaSymbol* _tmp146_;
									ValaMethod* delegate_method;
									ValaLambdaExpression* _tmp149_;
									ValaExpression* _tmp148_;
									ValaLambdaExpression* lambda;
									ValaMemberAccess* _tmp151_;
									ValaExpression* _tmp150_;
									ValaMemberAccess* arg_ma;
									gboolean _tmp152_;
									gboolean _tmp153_;
									delegate_target_destroy_notify = NULL;
									_tmp147_ = NULL;
									_tmp146_ = NULL;
									delegate_method = (_tmp147_ = (_tmp146_ = vala_expression_get_symbol_reference (arg), VALA_IS_METHOD (_tmp146_) ? ((ValaMethod*) _tmp146_) : NULL), (_tmp147_ == NULL) ? NULL : vala_code_node_ref (_tmp147_));
									_tmp149_ = NULL;
									_tmp148_ = NULL;
									lambda = (_tmp149_ = (_tmp148_ = arg, VALA_IS_LAMBDA_EXPRESSION (_tmp148_) ? ((ValaLambdaExpression*) _tmp148_) : NULL), (_tmp149_ == NULL) ? NULL : vala_code_node_ref (_tmp149_));
									_tmp151_ = NULL;
									_tmp150_ = NULL;
									arg_ma = (_tmp151_ = (_tmp150_ = arg, VALA_IS_MEMBER_ACCESS (_tmp150_) ? ((ValaMemberAccess*) _tmp150_) : NULL), (_tmp151_ == NULL) ? NULL : vala_code_node_ref (_tmp151_));
									_tmp152_ = FALSE;
									_tmp153_ = FALSE;
									if (lambda != NULL) {
										_tmp153_ = ((ValaCCodeBaseModule*) self)->current_method != NULL;
									} else {
										_tmp153_ = FALSE;
									}
									if (_tmp153_) {
										_tmp152_ = vala_method_get_binding (((ValaCCodeBaseModule*) self)->current_method) == MEMBER_BINDING_INSTANCE;
									} else {
										_tmp152_ = FALSE;
									}
									if (_tmp152_) {
										ValaCCodeExpression* _tmp154_;
										ValaCCodeFunctionCall* _tmp155_;
										ValaCCodeFunctionCall* ref_call;
										ValaCCodeExpression* _tmp157_;
										ValaCCodeExpression* _tmp156_;
										ValaCCodeExpression* _tmp158_;
										/* type of delegate target is same as `this'
										 for lambda expressions in instance methods*/
										_tmp154_ = NULL;
										_tmp155_ = NULL;
										ref_call = (_tmp155_ = vala_ccode_function_call_new (_tmp154_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (vala_method_get_this_parameter (((ValaCCodeBaseModule*) self)->current_method)), vala_code_node_get_source_reference ((ValaCodeNode*) arg))), (_tmp154_ == NULL) ? NULL : (_tmp154_ = (vala_ccode_node_unref (_tmp154_), NULL)), _tmp155_);
										vala_ccode_function_call_add_argument (ref_call, delegate_target);
										_tmp157_ = NULL;
										_tmp156_ = NULL;
										delegate_target = (_tmp157_ = (_tmp156_ = (ValaCCodeExpression*) ref_call, (_tmp156_ == NULL) ? NULL : vala_ccode_node_ref (_tmp156_)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp157_);
										_tmp158_ = NULL;
										delegate_target_destroy_notify = (_tmp158_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (vala_method_get_this_parameter (((ValaCCodeBaseModule*) self)->current_method))), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp158_);
										(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
									} else {
										gboolean _tmp159_;
										gboolean _tmp160_;
										gboolean _tmp161_;
										gboolean _tmp162_;
										gboolean _tmp163_;
										_tmp159_ = FALSE;
										_tmp160_ = FALSE;
										_tmp161_ = FALSE;
										_tmp162_ = FALSE;
										_tmp163_ = FALSE;
										if (delegate_method != NULL) {
											_tmp163_ = vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE;
										} else {
											_tmp163_ = FALSE;
										}
										if (_tmp163_) {
											_tmp162_ = arg_ma != NULL;
										} else {
											_tmp162_ = FALSE;
										}
										if (_tmp162_) {
											_tmp161_ = vala_member_access_get_inner (arg_ma) != NULL;
										} else {
											_tmp161_ = FALSE;
										}
										if (_tmp161_) {
											_tmp160_ = vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))) != NULL;
										} else {
											_tmp160_ = FALSE;
										}
										if (_tmp160_) {
											_tmp159_ = vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))));
										} else {
											_tmp159_ = FALSE;
										}
										if (_tmp159_) {
											ValaCCodeExpression* _tmp164_;
											ValaCCodeFunctionCall* _tmp165_;
											ValaCCodeFunctionCall* ref_call;
											ValaCCodeExpression* _tmp167_;
											ValaCCodeExpression* _tmp166_;
											ValaCCodeExpression* _tmp168_;
											_tmp164_ = NULL;
											_tmp165_ = NULL;
											ref_call = (_tmp165_ = vala_ccode_function_call_new (_tmp164_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma)), vala_code_node_get_source_reference ((ValaCodeNode*) arg))), (_tmp164_ == NULL) ? NULL : (_tmp164_ = (vala_ccode_node_unref (_tmp164_), NULL)), _tmp165_);
											vala_ccode_function_call_add_argument (ref_call, delegate_target);
											_tmp167_ = NULL;
											_tmp166_ = NULL;
											delegate_target = (_tmp167_ = (_tmp166_ = (ValaCCodeExpression*) ref_call, (_tmp166_ == NULL) ? NULL : vala_ccode_node_ref (_tmp166_)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp167_);
											_tmp168_ = NULL;
											delegate_target_destroy_notify = (_tmp168_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp168_);
											(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
										} else {
											ValaCCodeExpression* _tmp169_;
											_tmp169_ = NULL;
											delegate_target_destroy_notify = (_tmp169_ = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp169_);
										}
									}
									gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
									(delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL));
									(delegate_method == NULL) ? NULL : (delegate_method = (vala_code_node_unref (delegate_method), NULL));
									(lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL));
									(arg_ma == NULL) ? NULL : (arg_ma = (vala_code_node_unref (arg_ma), NULL));
								}
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
								multiple_cargs = TRUE;
								(delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL));
							}
							(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
							(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
						} else {
							if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaCCodeExpression* _tmp170_;
								_tmp170_ = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp170_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg));
								(_tmp170_ == NULL) ? NULL : (_tmp170_ = (vala_ccode_node_unref (_tmp170_), NULL));
								multiple_cargs = TRUE;
							}
						}
					}
					_tmp171_ = NULL;
					cexpr = (_tmp171_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, param, arg, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp171_);
					_tmp172_ = FALSE;
					if (multiple_cargs) {
						_tmp172_ = VALA_IS_METHOD_CALL (arg);
					} else {
						_tmp172_ = FALSE;
					}
					if (_tmp172_) {
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_decl;
						ValaCCodeAssignment* _tmp174_;
						ValaCCodeExpression* _tmp173_;
						ValaCCodeExpression* _tmp175_;
						ValaCCodeExpression* _tmp177_;
						ValaCCodeExpression* _tmp176_;
						/* if vala argument is invocation expression
						 the auxiliary C argument(s) will depend on the main C argument
						 (tmp = arg1, call (tmp, arg2, arg3,...))*/
						ccomma = vala_ccode_comma_expression_new ();
						temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg), TRUE, NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
						_tmp174_ = NULL;
						_tmp173_ = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp174_ = vala_ccode_assignment_new (_tmp173_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp174_ == NULL) ? NULL : (_tmp174_ = (vala_ccode_node_unref (_tmp174_), NULL));
						(_tmp173_ == NULL) ? NULL : (_tmp173_ = (vala_ccode_node_unref (_tmp173_), NULL));
						_tmp175_ = NULL;
						cexpr = (_tmp175_ = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp175_);
						vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						_tmp177_ = NULL;
						_tmp176_ = NULL;
						ccall_expr = (_tmp177_ = (_tmp176_ = (ValaCCodeExpression*) ccomma, (_tmp176_ == NULL) ? NULL : vala_ccode_node_ref (_tmp176_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp177_);
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
					}
					_tmp178_ = FALSE;
					_tmp179_ = FALSE;
					_tmp180_ = FALSE;
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						_tmp180_ = vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg));
					} else {
						_tmp180_ = FALSE;
					}
					if (_tmp180_) {
						gboolean _tmp181_;
						_tmp181_ = FALSE;
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
							_tmp181_ = TRUE;
						} else {
							_tmp181_ = !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param));
						}
						_tmp179_ = _tmp181_;
					} else {
						_tmp179_ = FALSE;
					}
					if (_tmp179_) {
						_tmp178_ = !VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp178_ = FALSE;
					}
					/* unref old value for non-null non-weak ref/out arguments
					 disabled for arrays for now as that requires special handling
					 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
					if (_tmp178_) {
						ValaUnaryExpression* _tmp182_;
						ValaUnaryExpression* unary;
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* _tmp184_;
						ValaCCodeExpression* _tmp183_;
						ValaLocalVariable* ret_temp_var;
						ValaDataType* _tmp189_;
						gboolean _tmp190_;
						ValaCCodeCommaExpression* cassign_comma;
						ValaLocalVariable* assign_temp_var;
						ValaCCodeAssignment* _tmp198_;
						ValaCCodeExpression* _tmp197_;
						ValaCCodeExpression* _tmp196_;
						ValaCCodeExpression* _tmp195_;
						ValaCCodeExpression* _tmp199_;
						ValaCCodeExpression* _tmp200_;
						ValaCCodeAssignment* _tmp201_;
						ValaDataType* _tmp202_;
						gboolean _tmp203_;
						ValaCCodeExpression* _tmp206_;
						ValaCCodeExpression* _tmp205_;
						_tmp182_ = NULL;
						unary = (_tmp182_ = VALA_UNARY_EXPRESSION (arg), (_tmp182_ == NULL) ? NULL : vala_code_node_ref (_tmp182_));
						ccomma = vala_ccode_comma_expression_new ();
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp184_ = NULL;
						_tmp183_ = NULL;
						cexpr = (_tmp184_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp183_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var))), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp184_);
						(_tmp183_ == NULL) ? NULL : (_tmp183_ = (vala_ccode_node_unref (_tmp183_), NULL));
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
							ValaCCodeCommaExpression* crefcomma;
							ValaCCodeAssignment* _tmp186_;
							ValaCCodeExpression* _tmp185_;
							ValaCCodeExpression* _tmp188_;
							ValaCCodeExpression* _tmp187_;
							crefcomma = vala_ccode_comma_expression_new ();
							_tmp186_ = NULL;
							_tmp185_ = NULL;
							vala_ccode_comma_expression_append_expression (crefcomma, (ValaCCodeExpression*) (_tmp186_ = vala_ccode_assignment_new (_tmp185_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp186_ == NULL) ? NULL : (_tmp186_ = (vala_ccode_node_unref (_tmp186_), NULL));
							(_tmp185_ == NULL) ? NULL : (_tmp185_ = (vala_ccode_node_unref (_tmp185_), NULL));
							vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
							_tmp188_ = NULL;
							_tmp187_ = NULL;
							cexpr = (_tmp188_ = (_tmp187_ = (ValaCCodeExpression*) crefcomma, (_tmp187_ == NULL) ? NULL : vala_ccode_node_ref (_tmp187_)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp188_);
							(crefcomma == NULL) ? NULL : (crefcomma = (vala_ccode_node_unref (crefcomma), NULL));
						}
						/* call function*/
						ret_temp_var = NULL;
						_tmp189_ = NULL;
						if ((_tmp190_ = VALA_IS_VOID_TYPE (_tmp189_ = vala_data_type_get_return_type (itype)), (_tmp189_ == NULL) ? NULL : (_tmp189_ = (vala_code_node_unref (_tmp189_), NULL)), _tmp190_)) {
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						} else {
							ValaLocalVariable* _tmp192_;
							ValaDataType* _tmp191_;
							ValaCCodeAssignment* _tmp194_;
							ValaCCodeExpression* _tmp193_;
							_tmp192_ = NULL;
							_tmp191_ = NULL;
							ret_temp_var = (_tmp192_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp191_ = vala_data_type_get_return_type (itype), TRUE, NULL), (ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL)), _tmp192_);
							(_tmp191_ == NULL) ? NULL : (_tmp191_ = (vala_code_node_unref (_tmp191_), NULL));
							gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, ret_temp_var);
							_tmp194_ = NULL;
							_tmp193_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp194_ = vala_ccode_assignment_new (_tmp193_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) ret_temp_var)), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp194_ == NULL) ? NULL : (_tmp194_ = (vala_ccode_node_unref (_tmp194_), NULL));
							(_tmp193_ == NULL) ? NULL : (_tmp193_ = (vala_ccode_node_unref (_tmp193_), NULL));
						}
						cassign_comma = vala_ccode_comma_expression_new ();
						assign_temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, assign_temp_var);
						_tmp198_ = NULL;
						_tmp197_ = NULL;
						_tmp196_ = NULL;
						_tmp195_ = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, (ValaCCodeExpression*) (_tmp198_ = vala_ccode_assignment_new (_tmp195_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) assign_temp_var)), _tmp197_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, _tmp196_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp198_ == NULL) ? NULL : (_tmp198_ = (vala_ccode_node_unref (_tmp198_), NULL));
						(_tmp197_ == NULL) ? NULL : (_tmp197_ = (vala_ccode_node_unref (_tmp197_), NULL));
						(_tmp196_ == NULL) ? NULL : (_tmp196_ = (vala_ccode_node_unref (_tmp196_), NULL));
						(_tmp195_ == NULL) ? NULL : (_tmp195_ = (vala_ccode_node_unref (_tmp195_), NULL));
						/* unref old value*/
						_tmp199_ = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp199_ = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), vala_expression_get_value_type (arg), arg));
						(_tmp199_ == NULL) ? NULL : (_tmp199_ = (vala_ccode_node_unref (_tmp199_), NULL));
						_tmp200_ = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp200_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) assign_temp_var)));
						(_tmp200_ == NULL) ? NULL : (_tmp200_ = (vala_ccode_node_unref (_tmp200_), NULL));
						/* assign new value*/
						_tmp201_ = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp201_ = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), (ValaCCodeExpression*) cassign_comma, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp201_ == NULL) ? NULL : (_tmp201_ = (vala_ccode_node_unref (_tmp201_), NULL));
						/* return value*/
						_tmp202_ = NULL;
						if ((_tmp203_ = !VALA_IS_VOID_TYPE (_tmp202_ = vala_data_type_get_return_type (itype)), (_tmp202_ == NULL) ? NULL : (_tmp202_ = (vala_code_node_unref (_tmp202_), NULL)), _tmp203_)) {
							ValaCCodeExpression* _tmp204_;
							_tmp204_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, _tmp204_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) ret_temp_var)));
							(_tmp204_ == NULL) ? NULL : (_tmp204_ = (vala_ccode_node_unref (_tmp204_), NULL));
						}
						_tmp206_ = NULL;
						_tmp205_ = NULL;
						ccall_expr = (_tmp206_ = (_tmp205_ = (ValaCCodeExpression*) ccomma, (_tmp205_ == NULL) ? NULL : vala_ccode_node_ref (_tmp205_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp206_);
						(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL));
						(cassign_comma == NULL) ? NULL : (cassign_comma = (vala_ccode_node_unref (cassign_comma), NULL));
						(assign_temp_var == NULL) ? NULL : (assign_temp_var = (vala_code_node_unref (assign_temp_var), NULL));
					}
					if (vala_formal_parameter_get_ctype (param) != NULL) {
						ValaCCodeExpression* _tmp207_;
						_tmp207_ = NULL;
						cexpr = (_tmp207_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, vala_formal_parameter_get_ctype (param)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp207_);
					}
				}
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			} else {
				/* default argument position*/
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) i, ellipsis);
			}
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (arg_pos), cexpr);
			i++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
			(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	if (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		gboolean _tmp208_;
		param = (ValaFormalParameter*) gee_iterator_get (params_it);
		_tmp208_ = FALSE;
		if (vala_formal_parameter_get_params_array (param)) {
			_tmp208_ = TRUE;
		} else {
			_tmp208_ = vala_formal_parameter_get_ellipsis (param);
		}
		/* if there are more parameters than arguments,
		 * the additional parameter is an ellipsis parameter
		 * otherwise there is a bug in the semantic analyzer
		 */
		g_assert (_tmp208_);
		ellipsis = TRUE;
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
	}
	_tmp209_ = FALSE;
	if (m != NULL) {
		_tmp209_ = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp209_ = FALSE;
	}
	/* add length argument for methods returning arrays */
	if (_tmp209_) {
		ValaArrayType* _tmp210_;
		ValaArrayType* array_type;
		_tmp210_ = NULL;
		array_type = (_tmp210_ = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp210_ == NULL) ? NULL : vala_code_node_ref (_tmp210_));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (vala_method_get_array_null_terminated (m)) {
					ValaDataType* _tmp211_;
					ValaLocalVariable* _tmp212_;
					ValaLocalVariable* temp_var;
					ValaCCodeExpression* temp_ref;
					ValaCCodeExpression* _tmp213_;
					ValaCCodeIdentifier* _tmp214_;
					ValaCCodeFunctionCall* _tmp215_;
					ValaCCodeFunctionCall* len_call;
					/* handle calls to methods returning null-terminated arrays*/
					_tmp211_ = NULL;
					_tmp212_ = NULL;
					temp_var = (_tmp212_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp211_ = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp211_ == NULL) ? NULL : (_tmp211_ = (vala_code_node_unref (_tmp211_), NULL)), _tmp212_);
					temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp213_ = NULL;
					ccall_expr = (_tmp213_ = (ValaCCodeExpression*) vala_ccode_assignment_new (temp_ref, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp213_);
					((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
					_tmp214_ = NULL;
					_tmp215_ = NULL;
					len_call = (_tmp215_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp214_ = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp214_ == NULL) ? NULL : (_tmp214_ = (vala_ccode_node_unref (_tmp214_), NULL)), _tmp215_);
					vala_ccode_function_call_add_argument (len_call, temp_ref);
					vala_method_call_append_array_size (expr, (ValaCCodeExpression*) len_call);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
					(len_call == NULL) ? NULL : (len_call = (vala_ccode_node_unref (len_call), NULL));
				} else {
					if (!vala_method_get_no_array_length (m)) {
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* temp_ref;
						ValaCCodeUnaryExpression* _tmp216_;
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
						temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp216_ = NULL;
						gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp216_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
						(_tmp216_ == NULL) ? NULL : (_tmp216_ = (vala_ccode_node_unref (_tmp216_), NULL));
						vala_method_call_append_array_size (expr, temp_ref);
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
					} else {
						ValaCCodeConstant* _tmp217_;
						_tmp217_ = NULL;
						vala_method_call_append_array_size (expr, (ValaCCodeExpression*) (_tmp217_ = vala_ccode_constant_new ("-1")));
						(_tmp217_ == NULL) ? NULL : (_tmp217_ = (vala_ccode_node_unref (_tmp217_), NULL));
					}
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		gboolean _tmp218_;
		_tmp218_ = FALSE;
		if (m != NULL) {
			_tmp218_ = VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m));
		} else {
			_tmp218_ = FALSE;
		}
		if (_tmp218_) {
			ValaDelegateType* _tmp219_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp220_;
			ValaDelegate* d;
			_tmp219_ = NULL;
			deleg_type = (_tmp219_ = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp219_ == NULL) ? NULL : vala_code_node_ref (_tmp219_));
			_tmp220_ = NULL;
			d = (_tmp220_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp220_ == NULL) ? NULL : vala_code_node_ref (_tmp220_));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp222_;
				ValaVoidType* _tmp221_;
				ValaLocalVariable* _tmp223_;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp224_;
				_tmp222_ = NULL;
				_tmp221_ = NULL;
				_tmp223_ = NULL;
				temp_var = (_tmp223_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp222_ = vala_pointer_type_new ((ValaDataType*) (_tmp221_ = vala_void_type_new (NULL)), NULL)), TRUE, NULL), (_tmp222_ == NULL) ? NULL : (_tmp222_ = (vala_code_node_unref (_tmp222_), NULL)), (_tmp221_ == NULL) ? NULL : (_tmp221_ = (vala_code_node_unref (_tmp221_), NULL)), _tmp223_);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp224_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp224_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp224_ == NULL) ? NULL : (_tmp224_ = (vala_ccode_node_unref (_tmp224_), NULL));
				vala_method_call_set_delegate_target (expr, temp_ref);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp225_ = FALSE;
	if (deleg != NULL) {
		_tmp225_ = VALA_IS_ARRAY_TYPE (vala_delegate_get_return_type (deleg));
	} else {
		_tmp225_ = FALSE;
	}
	/* add length argument for delegates returning arrays
	 TODO: avoid code duplication with methods returning arrays, see above*/
	if (_tmp225_) {
		ValaArrayType* _tmp226_;
		ValaArrayType* array_type;
		_tmp226_ = NULL;
		array_type = (_tmp226_ = VALA_ARRAY_TYPE (vala_delegate_get_return_type (deleg)), (_tmp226_ == NULL) ? NULL : vala_code_node_ref (_tmp226_));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (vala_delegate_get_array_null_terminated (deleg)) {
					ValaDataType* _tmp227_;
					ValaLocalVariable* _tmp228_;
					ValaLocalVariable* temp_var;
					ValaCCodeExpression* temp_ref;
					ValaCCodeExpression* _tmp229_;
					ValaCCodeIdentifier* _tmp230_;
					ValaCCodeFunctionCall* _tmp231_;
					ValaCCodeFunctionCall* len_call;
					/* handle calls to methods returning null-terminated arrays*/
					_tmp227_ = NULL;
					_tmp228_ = NULL;
					temp_var = (_tmp228_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp227_ = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp227_ == NULL) ? NULL : (_tmp227_ = (vala_code_node_unref (_tmp227_), NULL)), _tmp228_);
					temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp229_ = NULL;
					ccall_expr = (_tmp229_ = (ValaCCodeExpression*) vala_ccode_assignment_new (temp_ref, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp229_);
					((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
					_tmp230_ = NULL;
					_tmp231_ = NULL;
					len_call = (_tmp231_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp230_ = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp230_ == NULL) ? NULL : (_tmp230_ = (vala_ccode_node_unref (_tmp230_), NULL)), _tmp231_);
					vala_ccode_function_call_add_argument (len_call, temp_ref);
					vala_method_call_append_array_size (expr, (ValaCCodeExpression*) len_call);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
					(len_call == NULL) ? NULL : (len_call = (vala_ccode_node_unref (len_call), NULL));
				} else {
					if (!vala_delegate_get_no_array_length (deleg)) {
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* temp_ref;
						ValaCCodeUnaryExpression* _tmp232_;
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
						temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp232_ = NULL;
						gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_carray_length_parameter_position (deleg) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp232_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
						(_tmp232_ == NULL) ? NULL : (_tmp232_ = (vala_ccode_node_unref (_tmp232_), NULL));
						vala_method_call_append_array_size (expr, temp_ref);
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
					} else {
						ValaCCodeConstant* _tmp233_;
						_tmp233_ = NULL;
						vala_method_call_append_array_size (expr, (ValaCCodeExpression*) (_tmp233_ = vala_ccode_constant_new ("-1")));
						(_tmp233_ == NULL) ? NULL : (_tmp233_ = (vala_ccode_node_unref (_tmp233_), NULL));
					}
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		gboolean _tmp234_;
		_tmp234_ = FALSE;
		if (deleg != NULL) {
			_tmp234_ = VALA_IS_DELEGATE_TYPE (vala_delegate_get_return_type (deleg));
		} else {
			_tmp234_ = FALSE;
		}
		if (_tmp234_) {
			ValaDelegateType* _tmp235_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp236_;
			ValaDelegate* d;
			_tmp235_ = NULL;
			deleg_type = (_tmp235_ = VALA_DELEGATE_TYPE (vala_delegate_get_return_type (deleg)), (_tmp235_ == NULL) ? NULL : vala_code_node_ref (_tmp235_));
			_tmp236_ = NULL;
			d = (_tmp236_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp236_ == NULL) ? NULL : vala_code_node_ref (_tmp236_));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp238_;
				ValaVoidType* _tmp237_;
				ValaLocalVariable* _tmp239_;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp240_;
				_tmp238_ = NULL;
				_tmp237_ = NULL;
				_tmp239_ = NULL;
				temp_var = (_tmp239_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp238_ = vala_pointer_type_new ((ValaDataType*) (_tmp237_ = vala_void_type_new (NULL)), NULL)), TRUE, NULL), (_tmp238_ == NULL) ? NULL : (_tmp238_ = (vala_code_node_unref (_tmp238_), NULL)), (_tmp237_ == NULL) ? NULL : (_tmp237_ = (vala_code_node_unref (_tmp237_), NULL)), _tmp239_);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp240_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cdelegate_target_parameter_position (deleg), FALSE)), (ValaCCodeExpression*) (_tmp240_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp240_ == NULL) ? NULL : (_tmp240_ = (vala_ccode_node_unref (_tmp240_), NULL));
				vala_method_call_set_delegate_target (expr, temp_ref);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp241_ = FALSE;
	if (m != NULL) {
		_tmp241_ = vala_method_get_coroutine (m);
	} else {
		_tmp241_ = FALSE;
	}
	if (_tmp241_) {
		gboolean _tmp242_;
		gboolean _tmp243_;
		_tmp242_ = FALSE;
		_tmp243_ = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp243_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp243_ = FALSE;
		}
		if (_tmp243_) {
			_tmp242_ = TRUE;
		} else {
			gboolean _tmp244_;
			_tmp244_ = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp244_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp244_ = FALSE;
			}
			_tmp242_ = _tmp244_;
		}
		if (_tmp242_) {
			gboolean _tmp245_;
			_tmp245_ = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp245_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp245_ = FALSE;
			}
			/* asynchronous call*/
			if (_tmp245_) {
				ValaCCodeConstant* _tmp246_;
				ValaCCodeConstant* _tmp247_;
				_tmp246_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp246_ = vala_ccode_constant_new ("NULL")));
				(_tmp246_ == NULL) ? NULL : (_tmp246_ = (vala_ccode_node_unref (_tmp246_), NULL));
				_tmp247_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp247_ = vala_ccode_constant_new ("NULL")));
				(_tmp247_ == NULL) ? NULL : (_tmp247_ = (vala_ccode_node_unref (_tmp247_), NULL));
			} else {
				ValaCCodeIdentifier* _tmp250_;
				char* _tmp249_;
				char* _tmp248_;
				ValaCCodeIdentifier* _tmp251_;
				_tmp250_ = NULL;
				_tmp249_ = NULL;
				_tmp248_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp250_ = vala_ccode_identifier_new (_tmp249_ = g_strconcat (_tmp248_ = vala_method_get_cname (((ValaCCodeBaseModule*) self)->current_method), "_ready", NULL))));
				(_tmp250_ == NULL) ? NULL : (_tmp250_ = (vala_ccode_node_unref (_tmp250_), NULL));
				_tmp249_ = (g_free (_tmp249_), NULL);
				_tmp248_ = (g_free (_tmp248_), NULL);
				_tmp251_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp251_ = vala_ccode_identifier_new ("data")));
				(_tmp251_ == NULL) ? NULL : (_tmp251_ = (vala_ccode_node_unref (_tmp251_), NULL));
			}
		}
	}
	_tmp252_ = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		GeeList* _tmp253_;
		_tmp253_ = NULL;
		_tmp252_ = gee_collection_get_size ((GeeCollection*) (_tmp253_ = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0;
		(_tmp253_ == NULL) ? NULL : (_tmp253_ = (gee_collection_object_unref (_tmp253_), NULL));
	} else {
		_tmp252_ = FALSE;
	}
	if (_tmp252_) {
		ValaCCodeIdentifier* _tmp254_;
		_tmp254_ = NULL;
		gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp254_ = vala_ccode_identifier_new ("error")));
		(_tmp254_ == NULL) ? NULL : (_tmp254_ = (vala_ccode_node_unref (_tmp254_), NULL));
	} else {
		if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr)) {
			ValaCCodeUnaryExpression* _tmp256_;
			ValaCCodeExpression* _tmp255_;
			/* method can fail*/
			((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
			/* add &inner_error before the ellipsis arguments*/
			_tmp256_ = NULL;
			_tmp255_ = NULL;
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp256_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp255_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_"))));
			(_tmp256_ == NULL) ? NULL : (_tmp256_ = (vala_ccode_node_unref (_tmp256_), NULL));
			(_tmp255_ == NULL) ? NULL : (_tmp255_ = (vala_ccode_node_unref (_tmp255_), NULL));
		}
	}
	if (ellipsis) {
		gboolean _tmp257_;
		_tmp257_ = FALSE;
		if (!vala_method_get_printf_format (m)) {
			_tmp257_ = _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0;
		} else {
			_tmp257_ = FALSE;
		}
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if (_tmp257_) {
			ValaCCodeConstant* _tmp258_;
			_tmp258_ = NULL;
			gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp258_ = vala_ccode_constant_new (vala_method_get_sentinel (m))));
			(_tmp258_ == NULL) ? NULL : (_tmp258_ = (vala_ccode_node_unref (_tmp258_), NULL));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp259_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp260_;
			ValaDelegate* d;
			_tmp259_ = NULL;
			deleg_type = (_tmp259_ = VALA_DELEGATE_TYPE (itype), (_tmp259_ == NULL) ? NULL : vala_code_node_ref (_tmp259_));
			_tmp260_ = NULL;
			d = (_tmp260_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp260_ == NULL) ? NULL : vala_code_node_ref (_tmp260_));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp261_;
				ValaCCodeExpression* _tmp262_;
				_tmp261_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp261_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp261_ == NULL) ? NULL : (_tmp261_ = (vala_ccode_node_unref (_tmp261_), NULL));
				_tmp262_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp262_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp262_ == NULL) ? NULL : (_tmp262_ = (vala_ccode_node_unref (_tmp262_), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp263_ = FALSE;
	if (VALA_IS_SIGNAL_TYPE (itype)) {
		ValaDataType* _tmp264_;
		_tmp264_ = NULL;
		_tmp263_ = !VALA_IS_VOID_TYPE (_tmp264_ = vala_data_type_get_return_type (itype));
		(_tmp264_ == NULL) ? NULL : (_tmp264_ = (vala_code_node_unref (_tmp264_), NULL));
	} else {
		_tmp263_ = FALSE;
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	if (_tmp263_) {
		ValaSignal* _tmp265_;
		ValaSignal* sig;
		gboolean _tmp266_;
		gboolean _tmp267_;
		_tmp265_ = NULL;
		sig = (_tmp265_ = vala_signal_type_get_signal_symbol (VALA_SIGNAL_TYPE (itype)), (_tmp265_ == NULL) ? NULL : vala_code_node_ref (_tmp265_));
		_tmp266_ = FALSE;
		_tmp267_ = FALSE;
		if (ma != NULL) {
			_tmp267_ = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
		} else {
			_tmp267_ = FALSE;
		}
		if (_tmp267_) {
			_tmp266_ = vala_signal_get_is_virtual (sig);
		} else {
			_tmp266_ = FALSE;
		}
		if (_tmp266_) {
		} else {
			if (!vala_signal_get_has_emitter (sig)) {
				ValaDataType* _tmp268_;
				ValaLocalVariable* _tmp269_;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp270_;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp272_;
				ValaCCodeExpression* _tmp271_;
				_tmp268_ = NULL;
				_tmp269_ = NULL;
				temp_var = (_tmp269_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp268_ = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp268_ == NULL) ? NULL : (_tmp268_ = (vala_code_node_unref (_tmp268_), NULL)), _tmp269_);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp270_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp270_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp270_ == NULL) ? NULL : (_tmp270_ = (vala_ccode_node_unref (_tmp270_), NULL));
				ccomma = vala_ccode_comma_expression_new ();
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
				_tmp272_ = NULL;
				_tmp271_ = NULL;
				ccall_expr = (_tmp272_ = (_tmp271_ = (ValaCCodeExpression*) ccomma, (_tmp271_ == NULL) ? NULL : vala_ccode_node_ref (_tmp271_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp272_);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
	}
	/* append C arguments in the right order*/
	last_pos = 0;
	min_pos = 0;
	if (async_call != ccall) {
		/* don't append out arguments for .begin() calls*/
		last_pos = -1;
		while (TRUE) {
			ValaCCodeExpression* _tmp277_;
			min_pos = -1;
			{
				GeeSet* _tmp273_;
				GeeIterator* _tmp274_;
				GeeIterator* _pos_it;
				_tmp273_ = NULL;
				_tmp274_ = NULL;
				_pos_it = (_tmp274_ = gee_iterable_iterator ((GeeIterable*) (_tmp273_ = gee_map_get_keys ((GeeMap*) out_arg_map))), (_tmp273_ == NULL) ? NULL : (_tmp273_ = (gee_collection_object_unref (_tmp273_), NULL)), _tmp274_);
				while (gee_iterator_next (_pos_it)) {
					gint pos;
					gboolean _tmp275_;
					pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
					_tmp275_ = FALSE;
					if (pos > last_pos) {
						gboolean _tmp276_;
						_tmp276_ = FALSE;
						if (min_pos == (-1)) {
							_tmp276_ = TRUE;
						} else {
							_tmp276_ = pos < min_pos;
						}
						_tmp275_ = _tmp276_;
					} else {
						_tmp275_ = FALSE;
					}
					if (_tmp275_) {
						min_pos = pos;
					}
				}
				(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
			}
			if (min_pos == (-1)) {
				break;
			}
			_tmp277_ = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp277_ = (ValaCCodeExpression*) gee_map_get ((GeeMap*) out_arg_map, GINT_TO_POINTER (min_pos)));
			(_tmp277_ == NULL) ? NULL : (_tmp277_ = (vala_ccode_node_unref (_tmp277_), NULL));
			last_pos = min_pos;
		}
	}
	if (async_call != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeExpression* _tmp282_;
			min_pos = -1;
			{
				GeeSet* _tmp278_;
				GeeIterator* _tmp279_;
				GeeIterator* _pos_it;
				_tmp278_ = NULL;
				_tmp279_ = NULL;
				_pos_it = (_tmp279_ = gee_iterable_iterator ((GeeIterable*) (_tmp278_ = gee_map_get_keys ((GeeMap*) in_arg_map))), (_tmp278_ == NULL) ? NULL : (_tmp278_ = (gee_collection_object_unref (_tmp278_), NULL)), _tmp279_);
				while (gee_iterator_next (_pos_it)) {
					gint pos;
					gboolean _tmp280_;
					pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
					_tmp280_ = FALSE;
					if (pos > last_pos) {
						gboolean _tmp281_;
						_tmp281_ = FALSE;
						if (min_pos == (-1)) {
							_tmp281_ = TRUE;
						} else {
							_tmp281_ = pos < min_pos;
						}
						_tmp280_ = _tmp281_;
					} else {
						_tmp280_ = FALSE;
					}
					if (_tmp280_) {
						min_pos = pos;
					}
				}
				(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
			}
			if (min_pos == (-1)) {
				break;
			}
			_tmp282_ = NULL;
			vala_ccode_function_call_add_argument (async_call, _tmp282_ = (ValaCCodeExpression*) gee_map_get ((GeeMap*) in_arg_map, GINT_TO_POINTER (min_pos)));
			(_tmp282_ == NULL) ? NULL : (_tmp282_ = (vala_ccode_node_unref (_tmp282_), NULL));
			last_pos = min_pos;
		}
	}
	_tmp283_ = FALSE;
	_tmp284_ = FALSE;
	if (m != NULL) {
		_tmp284_ = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp284_ = FALSE;
	}
	if (_tmp284_) {
		_tmp283_ = vala_method_get_returns_modified_pointer (m);
	} else {
		_tmp283_ = FALSE;
	}
	if (_tmp283_) {
		ValaCCodeAssignment* _tmp285_;
		_tmp285_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp285_ = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp285_ == NULL) ? NULL : (_tmp285_ = (vala_ccode_node_unref (_tmp285_), NULL));
	} else {
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall_expr);
	}
	_tmp286_ = FALSE;
	_tmp287_ = FALSE;
	_tmp288_ = FALSE;
	if (m != NULL) {
		_tmp288_ = vala_method_get_coroutine (m);
	} else {
		_tmp288_ = FALSE;
	}
	if (_tmp288_) {
		_tmp287_ = ((ValaCCodeBaseModule*) self)->current_method != NULL;
	} else {
		_tmp287_ = FALSE;
	}
	if (_tmp287_) {
		_tmp286_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	} else {
		_tmp286_ = FALSE;
	}
	if (_tmp286_) {
		gboolean _tmp289_;
		_tmp289_ = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0) {
			_tmp289_ = TRUE;
		} else {
			_tmp289_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) != vala_expression_get_symbol_reference ((ValaExpression*) ma);
		}
		if (_tmp289_) {
			ValaCCodeExpressionStatement* _tmp291_;
			gint state;
			ValaCCodeExpressionStatement* _tmp297_;
			ValaCCodeAssignment* _tmp296_;
			ValaCCodeConstant* _tmp295_;
			char* _tmp294_;
			ValaCCodeMemberAccess* _tmp293_;
			ValaCCodeIdentifier* _tmp292_;
			ValaCCodeReturnStatement* _tmp299_;
			ValaCCodeConstant* _tmp298_;
			ValaCCodeCaseStatement* _tmp302_;
			ValaCCodeConstant* _tmp301_;
			char* _tmp300_;
			if (((ValaCCodeBaseModule*) self)->pre_statement_fragment == NULL) {
				ValaCCodeFragment* _tmp290_;
				_tmp290_ = NULL;
				((ValaCCodeBaseModule*) self)->pre_statement_fragment = (_tmp290_ = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->pre_statement_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->pre_statement_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->pre_statement_fragment), NULL)), _tmp290_);
			}
			_tmp291_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp291_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) async_call)));
			(_tmp291_ == NULL) ? NULL : (_tmp291_ = (vala_ccode_node_unref (_tmp291_), NULL));
			state = ((ValaCCodeBaseModule*) self)->next_coroutine_state++;
			_tmp297_ = NULL;
			_tmp296_ = NULL;
			_tmp295_ = NULL;
			_tmp294_ = NULL;
			_tmp293_ = NULL;
			_tmp292_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp297_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp296_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp293_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp292_ = vala_ccode_identifier_new ("data")), "state")), (ValaCCodeExpression*) (_tmp295_ = vala_ccode_constant_new (_tmp294_ = g_strdup_printf ("%i", state))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp297_ == NULL) ? NULL : (_tmp297_ = (vala_ccode_node_unref (_tmp297_), NULL));
			(_tmp296_ == NULL) ? NULL : (_tmp296_ = (vala_ccode_node_unref (_tmp296_), NULL));
			(_tmp295_ == NULL) ? NULL : (_tmp295_ = (vala_ccode_node_unref (_tmp295_), NULL));
			_tmp294_ = (g_free (_tmp294_), NULL);
			(_tmp293_ == NULL) ? NULL : (_tmp293_ = (vala_ccode_node_unref (_tmp293_), NULL));
			(_tmp292_ == NULL) ? NULL : (_tmp292_ = (vala_ccode_node_unref (_tmp292_), NULL));
			_tmp299_ = NULL;
			_tmp298_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp299_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp298_ = vala_ccode_constant_new ("FALSE")))));
			(_tmp299_ == NULL) ? NULL : (_tmp299_ = (vala_ccode_node_unref (_tmp299_), NULL));
			(_tmp298_ == NULL) ? NULL : (_tmp298_ = (vala_ccode_node_unref (_tmp298_), NULL));
			_tmp302_ = NULL;
			_tmp301_ = NULL;
			_tmp300_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp302_ = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp301_ = vala_ccode_constant_new (_tmp300_ = g_strdup_printf ("%i", state))))));
			(_tmp302_ == NULL) ? NULL : (_tmp302_ = (vala_ccode_node_unref (_tmp302_), NULL));
			(_tmp301_ == NULL) ? NULL : (_tmp301_ = (vala_ccode_node_unref (_tmp301_), NULL));
			_tmp300_ = (g_free (_tmp300_), NULL);
		}
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp303_;
		GeeIterator* _tmp304_;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp306_;
		ValaExpression* _tmp305_;
		ValaCCodeExpression* _tmp307_;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeExpression* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp308_;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp309_;
		ValaArrayType* array_type;
		char* _tmp311_;
		char* _tmp310_;
		ValaCCodeIdentifier* _tmp312_;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp313_;
		ValaCCodeFunctionCall* _tmp314_;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp315_;
		ValaCCodeConstant* _tmp316_;
		ValaCCodeBinaryExpression* _tmp317_;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp318_;
		ValaCCodeConditionalExpression* _tmp320_;
		ValaCCodeConstant* _tmp319_;
		ValaCCodeAssignment* _tmp322_;
		ValaCCodeExpression* _tmp321_;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp303_ = NULL;
		_tmp304_ = NULL;
		arg_it = (_tmp304_ = gee_iterable_iterator ((GeeIterable*) (_tmp303_ = vala_method_call_get_argument_list (expr))), (_tmp303_ == NULL) ? NULL : (_tmp303_ = (gee_collection_object_unref (_tmp303_), NULL)), _tmp304_);
		gee_iterator_next (arg_it);
		_tmp306_ = NULL;
		_tmp305_ = NULL;
		_tmp307_ = NULL;
		new_size = (_tmp307_ = (_tmp306_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp305_ = (ValaExpression*) gee_iterator_get (arg_it)))), (_tmp306_ == NULL) ? NULL : vala_ccode_node_ref (_tmp306_)), (_tmp305_ == NULL) ? NULL : (_tmp305_ = (vala_code_node_unref (_tmp305_), NULL)), _tmp307_);
		temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
		temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
		/* memset needs string.h */
		vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "string.h", FALSE);
		clen = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1);
		_tmp308_ = NULL;
		celems = (_tmp308_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp308_ == NULL) ? NULL : vala_ccode_node_ref (_tmp308_));
		_tmp309_ = NULL;
		array_type = (_tmp309_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp309_ == NULL) ? NULL : vala_code_node_ref (_tmp309_));
		_tmp311_ = NULL;
		_tmp310_ = NULL;
		_tmp312_ = NULL;
		csizeof = (_tmp312_ = vala_ccode_identifier_new (_tmp311_ = g_strdup_printf ("sizeof (%s)", _tmp310_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))), _tmp311_ = (g_free (_tmp311_), NULL), _tmp310_ = (g_free (_tmp310_), NULL), _tmp312_);
		cdelta = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, temp_ref, clen);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, temp_ref, clen);
		_tmp313_ = NULL;
		_tmp314_ = NULL;
		czero = (_tmp314_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp313_ = vala_ccode_identifier_new ("memset"))), (_tmp313_ == NULL) ? NULL : (_tmp313_ = (vala_ccode_node_unref (_tmp313_), NULL)), _tmp314_);
		_tmp315_ = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp315_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen)));
		(_tmp315_ == NULL) ? NULL : (_tmp315_ = (vala_ccode_node_unref (_tmp315_), NULL));
		_tmp316_ = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp316_ = vala_ccode_constant_new ("0")));
		(_tmp316_ == NULL) ? NULL : (_tmp316_ = (vala_ccode_node_unref (_tmp316_), NULL));
		_tmp317_ = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp317_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) csizeof, (ValaCCodeExpression*) cdelta)));
		(_tmp317_ == NULL) ? NULL : (_tmp317_ = (vala_ccode_node_unref (_tmp317_), NULL));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp318_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp318_ = vala_ccode_assignment_new (temp_ref, new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp318_ == NULL) ? NULL : (_tmp318_ = (vala_ccode_node_unref (_tmp318_), NULL));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
		_tmp320_ = NULL;
		_tmp319_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp320_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccheck, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) (_tmp319_ = vala_ccode_constant_new ("NULL")))));
		(_tmp320_ == NULL) ? NULL : (_tmp320_ = (vala_ccode_node_unref (_tmp320_), NULL));
		(_tmp319_ == NULL) ? NULL : (_tmp319_ = (vala_ccode_node_unref (_tmp319_), NULL));
		_tmp322_ = NULL;
		_tmp321_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp322_ = vala_ccode_assignment_new (_tmp321_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1), temp_ref, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp322_ == NULL) ? NULL : (_tmp322_ = (vala_ccode_node_unref (_tmp322_), NULL));
		(_tmp321_ == NULL) ? NULL : (_tmp321_ = (vala_ccode_node_unref (_tmp321_), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
		(new_size == NULL) ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
		(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
		(clen == NULL) ? NULL : (clen = (vala_ccode_node_unref (clen), NULL));
		(celems == NULL) ? NULL : (celems = (vala_ccode_node_unref (celems), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
		(cdelta == NULL) ? NULL : (cdelta = (vala_ccode_node_unref (cdelta), NULL));
		(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
		(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	}
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(deleg == NULL) ? NULL : (deleg = (vala_code_node_unref (deleg), NULL));
	(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(itype == NULL) ? NULL : (itype = (vala_code_node_unref (itype), NULL));
	(in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL));
	(out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL));
	(ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL));
	(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
	(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
}


static void vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass) {
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_ccode_method_call_module_real_visit_method_call;
}


static void vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self) {
}


GType vala_ccode_method_call_module_get_type (void) {
	static GType vala_ccode_method_call_module_type_id = 0;
	if (vala_ccode_method_call_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_call_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




