/* valaarraytype.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaDataTypePrivate ValaDataTypePrivate;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;
typedef struct _ValaReferenceTypePrivate ValaReferenceTypePrivate;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;
typedef struct _ValaArrayTypePrivate ValaArrayTypePrivate;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_ARRAY_LENGTH_FIELD (vala_array_length_field_get_type ())
#define VALA_ARRAY_LENGTH_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_LENGTH_FIELD, ValaArrayLengthField))
#define VALA_ARRAY_LENGTH_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_LENGTH_FIELD, ValaArrayLengthFieldClass))
#define VALA_IS_ARRAY_LENGTH_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_LENGTH_FIELD))
#define VALA_IS_ARRAY_LENGTH_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_LENGTH_FIELD))
#define VALA_ARRAY_LENGTH_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_LENGTH_FIELD, ValaArrayLengthFieldClass))

typedef struct _ValaArrayLengthField ValaArrayLengthField;
typedef struct _ValaArrayLengthFieldClass ValaArrayLengthFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_ARRAY_RESIZE_METHOD (vala_array_resize_method_get_type ())
#define VALA_ARRAY_RESIZE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethod))
#define VALA_ARRAY_RESIZE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethodClass))
#define VALA_IS_ARRAY_RESIZE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD))
#define VALA_IS_ARRAY_RESIZE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_RESIZE_METHOD))
#define VALA_ARRAY_RESIZE_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethodClass))

typedef struct _ValaArrayResizeMethod ValaArrayResizeMethod;
typedef struct _ValaArrayResizeMethodClass ValaArrayResizeMethodClass;

#define VALA_TYPE_ARRAY_MOVE_METHOD (vala_array_move_method_get_type ())
#define VALA_ARRAY_MOVE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethod))
#define VALA_ARRAY_MOVE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethodClass))
#define VALA_IS_ARRAY_MOVE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_MOVE_METHOD))
#define VALA_IS_ARRAY_MOVE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_MOVE_METHOD))
#define VALA_ARRAY_MOVE_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethodClass))

typedef struct _ValaArrayMoveMethod ValaArrayMoveMethod;
typedef struct _ValaArrayMoveMethodClass ValaArrayMoveMethodClass;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_INTEGER_TYPE (vala_integer_type_get_type ())
#define VALA_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerType))
#define VALA_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))
#define VALA_IS_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_TYPE))
#define VALA_IS_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_TYPE))
#define VALA_INTEGER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))

typedef struct _ValaIntegerType ValaIntegerType;
typedef struct _ValaIntegerTypeClass ValaIntegerTypeClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_POINTER_TYPE (vala_pointer_type_get_type ())
#define VALA_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerType))
#define VALA_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))
#define VALA_IS_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_TYPE))
#define VALA_IS_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_TYPE))
#define VALA_POINTER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))

typedef struct _ValaPointerType ValaPointerType;
typedef struct _ValaPointerTypeClass ValaPointerTypeClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

/**
 * Represents a part of the parsed source code.
 *
 * Code nodes get created by the parser and are used throughout the whole
 * compilation process.
 */
struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, GeeCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, GeeCollection* collection);
};

/**
 * A reference to a data type. This is used to specify static types of
 * expressions.
 */
struct _ValaDataType {
	ValaCodeNode parent_instance;
	ValaDataTypePrivate * priv;
};

struct _ValaDataTypeClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cname) (ValaDataType* self);
	char* (*get_cdeclarator_suffix) (ValaDataType* self);
	char* (*get_lower_case_cname) (ValaDataType* self, const char* infix);
	char* (*to_qualified_string) (ValaDataType* self, ValaScope* scope);
	ValaDataType* (*copy) (ValaDataType* self);
	gboolean (*equals) (ValaDataType* self, ValaDataType* type2);
	gboolean (*stricter) (ValaDataType* self, ValaDataType* type2);
	gboolean (*compatible) (ValaDataType* self, ValaDataType* target_type);
	gboolean (*is_invokable) (ValaDataType* self);
	ValaDataType* (*get_return_type) (ValaDataType* self);
	GeeList* (*get_parameters) (ValaDataType* self);
	gboolean (*is_reference_type_or_type_parameter) (ValaDataType* self);
	gboolean (*is_array) (ValaDataType* self);
	GeeList* (*get_symbols) (ValaDataType* self);
	ValaSymbol* (*get_member) (ValaDataType* self, const char* member_name);
	ValaSymbol* (*get_pointer_member) (ValaDataType* self, const char* member_name);
	gboolean (*is_real_struct_type) (ValaDataType* self);
	char* (*get_type_id) (ValaDataType* self);
	char* (*get_type_signature) (ValaDataType* self);
	gboolean (*is_disposable) (ValaDataType* self);
};

/**
 * A reference type, i.e. a class, interface, or array type.
 */
struct _ValaReferenceType {
	ValaDataType parent_instance;
	ValaReferenceTypePrivate * priv;
};

struct _ValaReferenceTypeClass {
	ValaDataTypeClass parent_class;
};

/**
 * An array type.
 */
struct _ValaArrayType {
	ValaReferenceType parent_instance;
	ValaArrayTypePrivate * priv;
};

struct _ValaArrayTypeClass {
	ValaReferenceTypeClass parent_class;
};

struct _ValaArrayTypePrivate {
	gboolean _fixed_length;
	gint _length;
	gint _rank;
	ValaDataType* _element_type;
	ValaArrayLengthField* length_field;
	ValaArrayResizeMethod* resize_method;
	ValaArrayMoveMethod* move_method;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_array_type_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
GType vala_formal_parameter_get_type (void);
GType vala_reference_type_get_type (void);
GType vala_array_type_get_type (void);
GType vala_member_get_type (void);
GType vala_field_get_type (void);
GType vala_array_length_field_get_type (void);
GType vala_method_get_type (void);
GType vala_array_resize_method_get_type (void);
GType vala_array_move_method_get_type (void);
#define VALA_ARRAY_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_TYPE, ValaArrayTypePrivate))
enum  {
	VALA_ARRAY_TYPE_DUMMY_PROPERTY
};
void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value);
void vala_array_type_set_rank (ValaArrayType* self, gint value);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
ValaArrayType* vala_array_type_construct (GType object_type, ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self);
static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self);
static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self);
static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const char* member_name);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaArrayLengthField* vala_array_length_field_new (ValaSourceReference* source_reference);
ValaArrayLengthField* vala_array_length_field_construct (GType object_type, ValaSourceReference* source_reference);
GType vala_symbol_accessibility_get_type (void);
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void);
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
GType vala_namespace_get_type (void);
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
gint vala_array_type_get_rank (ValaArrayType* self);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
GType vala_typesymbol_get_type (void);
GType vala_struct_get_type (void);
ValaIntegerType* vala_integer_type_new (ValaStruct* type_symbol, const char* literal_value, const char* literal_type_name);
ValaIntegerType* vala_integer_type_construct (GType object_type, ValaStruct* type_symbol, const char* literal_value, const char* literal_type_name);
GType vala_value_type_get_type (void);
GType vala_integer_type_get_type (void);
void vala_field_set_field_type (ValaField* self, ValaDataType* value);
ValaArrayResizeMethod* vala_array_resize_method_new (ValaSourceReference* source_reference);
ValaArrayResizeMethod* vala_array_resize_method_construct (GType object_type, ValaSourceReference* source_reference);
ValaVoidType* vala_void_type_new (ValaSourceReference* source_reference);
ValaVoidType* vala_void_type_construct (GType object_type, ValaSourceReference* source_reference);
GType vala_void_type_get_type (void);
void vala_method_set_return_type (ValaMethod* self, ValaDataType* value);
void vala_method_set_cname (ValaMethod* self, const char* cname);
void vala_method_add_parameter (ValaMethod* self, ValaFormalParameter* param);
ValaFormalParameter* vala_formal_parameter_new (const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct (GType object_type, const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
void vala_method_set_returns_modified_pointer (ValaMethod* self, gboolean value);
ValaArrayMoveMethod* vala_array_move_method_new (ValaSourceReference* source_reference);
ValaArrayMoveMethod* vala_array_move_method_construct (GType object_type, ValaSourceReference* source_reference);
ValaDataType* vala_array_type_get_element_type (ValaArrayType* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
gboolean vala_data_type_get_nullable (ValaDataType* self);
void vala_data_type_set_nullable (ValaDataType* self, gboolean value);
gboolean vala_data_type_get_floating_reference (ValaDataType* self);
void vala_data_type_set_floating_reference (ValaDataType* self, gboolean value);
gboolean vala_array_type_get_fixed_length (ValaArrayType* self);
void vala_array_type_set_fixed_length (ValaArrayType* self, gboolean value);
gint vala_array_type_get_length (ValaArrayType* self);
void vala_array_type_set_length (ValaArrayType* self, gint value);
static ValaDataType* vala_array_type_real_copy (ValaDataType* base);
char* vala_data_type_get_cname (ValaDataType* self);
static char* vala_array_type_real_get_cname (ValaDataType* base);
static char* vala_array_type_real_get_cdeclarator_suffix (ValaDataType* base);
static gboolean vala_array_type_real_is_array (ValaDataType* base);
char* vala_data_type_to_qualified_string (ValaDataType* self, ValaScope* scope);
static char* vala_array_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
GType vala_pointer_type_get_type (void);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name);
GType vala_typeparameter_get_type (void);
ValaTypeParameter* vala_data_type_get_type_parameter (ValaDataType* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base);
char* vala_data_type_get_type_signature (ValaDataType* self);
static char* vala_array_type_real_get_type_signature (ValaDataType* base);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_array_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_array_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
GeeList* vala_data_type_get_symbols (ValaDataType* self);
static GeeList* vala_array_type_real_get_symbols (ValaDataType* base);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
static void vala_array_type_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaArrayType* vala_array_type_construct (GType object_type, ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	ValaArrayType* self;
	g_return_val_if_fail (element_type != NULL, NULL);
	self = (ValaArrayType*) g_type_create_instance (object_type);
	vala_array_type_set_element_type (self, element_type);
	vala_array_type_set_rank (self, rank);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	return vala_array_type_construct (VALA_TYPE_ARRAY_TYPE, element_type, rank, source_reference);
}


static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const char* member_name) {
	ValaArrayType * self;
	ValaSymbol* result;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (member_name != NULL, NULL);
	if (_vala_strcmp0 (member_name, "length") == 0) {
		result = (ValaSymbol*) vala_array_type_get_length_field (self);
		return result;
	} else {
		if (_vala_strcmp0 (member_name, "move") == 0) {
			result = (ValaSymbol*) vala_array_type_get_move_method (self);
			return result;
		} else {
			if (_vala_strcmp0 (member_name, "resize") == 0) {
				result = (ValaSymbol*) vala_array_type_get_resize_method (self);
				return result;
			}
		}
	}
	result = NULL;
	return result;
}


static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self) {
	ValaArrayLengthField* result;
	ValaArrayLengthField* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->length_field == NULL) {
		ValaArrayLengthField* _tmp0_;
		ValaNamespace* _tmp1_;
		ValaNamespace* root_symbol;
		_tmp0_ = NULL;
		self->priv->length_field = (_tmp0_ = vala_array_length_field_new (vala_code_node_get_source_reference ((ValaCodeNode*) self)), (self->priv->length_field == NULL) ? NULL : (self->priv->length_field = (vala_code_node_unref (self->priv->length_field), NULL)), _tmp0_);
		vala_symbol_set_access ((ValaSymbol*) self->priv->length_field, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp1_ = NULL;
		root_symbol = (_tmp1_ = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)))), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		if (self->priv->_rank > 1) {
			ValaStruct* _tmp2_;
			ValaValueType* _tmp3_;
			ValaValueType* integer;
			ValaArrayType* _tmp4_;
			/* length is an int[] containing the dimensions of the array, starting at 0*/
			_tmp2_ = NULL;
			_tmp3_ = NULL;
			integer = (_tmp3_ = (ValaValueType*) vala_integer_type_new (_tmp2_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int")), NULL, NULL), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL)), _tmp3_);
			_tmp4_ = NULL;
			vala_field_set_field_type ((ValaField*) self->priv->length_field, (ValaDataType*) (_tmp4_ = vala_array_type_new ((ValaDataType*) integer, 1, vala_code_node_get_source_reference ((ValaCodeNode*) self))));
			(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_code_node_unref (_tmp4_), NULL));
			(integer == NULL) ? NULL : (integer = (vala_code_node_unref (integer), NULL));
		} else {
			ValaIntegerType* _tmp6_;
			ValaStruct* _tmp5_;
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			vala_field_set_field_type ((ValaField*) self->priv->length_field, (ValaDataType*) (_tmp6_ = vala_integer_type_new (_tmp5_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int")), NULL, NULL)));
			(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
			(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_code_node_unref (_tmp5_), NULL));
		}
		(root_symbol == NULL) ? NULL : (root_symbol = (vala_code_node_unref (root_symbol), NULL));
	}
	_tmp7_ = NULL;
	result = (_tmp7_ = self->priv->length_field, (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
	return result;
}


static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self) {
	ValaArrayResizeMethod* result;
	ValaArrayResizeMethod* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->resize_method == NULL) {
		ValaArrayResizeMethod* _tmp0_;
		ValaVoidType* _tmp1_;
		ValaNamespace* _tmp2_;
		ValaNamespace* root_symbol;
		ValaStruct* _tmp3_;
		ValaIntegerType* _tmp4_;
		ValaIntegerType* int_type;
		ValaFormalParameter* _tmp5_;
		_tmp0_ = NULL;
		self->priv->resize_method = (_tmp0_ = vala_array_resize_method_new (vala_code_node_get_source_reference ((ValaCodeNode*) self)), (self->priv->resize_method == NULL) ? NULL : (self->priv->resize_method = (vala_code_node_unref (self->priv->resize_method), NULL)), _tmp0_);
		_tmp1_ = NULL;
		vala_method_set_return_type ((ValaMethod*) self->priv->resize_method, (ValaDataType*) (_tmp1_ = vala_void_type_new (NULL)));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
		vala_symbol_set_access ((ValaSymbol*) self->priv->resize_method, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname ((ValaMethod*) self->priv->resize_method, "g_renew");
		_tmp2_ = NULL;
		root_symbol = (_tmp2_ = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)))), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		int_type = (_tmp4_ = vala_integer_type_new (_tmp3_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int")), NULL, NULL), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_code_node_unref (_tmp3_), NULL)), _tmp4_);
		_tmp5_ = NULL;
		vala_method_add_parameter ((ValaMethod*) self->priv->resize_method, _tmp5_ = vala_formal_parameter_new ("length", (ValaDataType*) int_type, NULL));
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_code_node_unref (_tmp5_), NULL));
		vala_method_set_returns_modified_pointer ((ValaMethod*) self->priv->resize_method, TRUE);
		(root_symbol == NULL) ? NULL : (root_symbol = (vala_code_node_unref (root_symbol), NULL));
		(int_type == NULL) ? NULL : (int_type = (vala_code_node_unref (int_type), NULL));
	}
	_tmp6_ = NULL;
	result = (_tmp6_ = self->priv->resize_method, (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
	return result;
}


static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self) {
	ValaArrayMoveMethod* result;
	ValaArrayMoveMethod* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->move_method == NULL) {
		ValaArrayMoveMethod* _tmp0_;
		ValaVoidType* _tmp1_;
		ValaNamespace* _tmp2_;
		ValaNamespace* root_symbol;
		ValaStruct* _tmp3_;
		ValaIntegerType* _tmp4_;
		ValaIntegerType* int_type;
		ValaFormalParameter* _tmp5_;
		ValaFormalParameter* _tmp6_;
		ValaFormalParameter* _tmp7_;
		_tmp0_ = NULL;
		self->priv->move_method = (_tmp0_ = vala_array_move_method_new (vala_code_node_get_source_reference ((ValaCodeNode*) self)), (self->priv->move_method == NULL) ? NULL : (self->priv->move_method = (vala_code_node_unref (self->priv->move_method), NULL)), _tmp0_);
		_tmp1_ = NULL;
		vala_method_set_return_type ((ValaMethod*) self->priv->move_method, (ValaDataType*) (_tmp1_ = vala_void_type_new (NULL)));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
		vala_symbol_set_access ((ValaSymbol*) self->priv->move_method, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname ((ValaMethod*) self->priv->move_method, "_vala_array_move");
		_tmp2_ = NULL;
		root_symbol = (_tmp2_ = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)))), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		int_type = (_tmp4_ = vala_integer_type_new (_tmp3_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int")), NULL, NULL), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_code_node_unref (_tmp3_), NULL)), _tmp4_);
		_tmp5_ = NULL;
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp5_ = vala_formal_parameter_new ("src", (ValaDataType*) int_type, NULL));
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_code_node_unref (_tmp5_), NULL));
		_tmp6_ = NULL;
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp6_ = vala_formal_parameter_new ("dest", (ValaDataType*) int_type, NULL));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
		_tmp7_ = NULL;
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp7_ = vala_formal_parameter_new ("length", (ValaDataType*) int_type, NULL));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_code_node_unref (_tmp7_), NULL));
		(root_symbol == NULL) ? NULL : (root_symbol = (vala_code_node_unref (root_symbol), NULL));
		(int_type == NULL) ? NULL : (int_type = (vala_code_node_unref (int_type), NULL));
	}
	_tmp8_ = NULL;
	result = (_tmp8_ = self->priv->move_method, (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_));
	return result;
}


static ValaDataType* vala_array_type_real_copy (ValaDataType* base) {
	ValaArrayType * self;
	ValaDataType* result;
	ValaDataType* _tmp0_;
	ValaArrayType* _tmp1_;
	ValaArrayType* _result_;
	self = (ValaArrayType*) base;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_result_ = (_tmp1_ = vala_array_type_new (_tmp0_ = vala_data_type_copy (vala_array_type_get_element_type (self)), self->priv->_rank, vala_code_node_get_source_reference ((ValaCodeNode*) self)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_code_node_unref (_tmp0_), NULL)), _tmp1_);
	vala_data_type_set_value_owned ((ValaDataType*) _result_, vala_data_type_get_value_owned ((ValaDataType*) self));
	vala_data_type_set_nullable ((ValaDataType*) _result_, vala_data_type_get_nullable ((ValaDataType*) self));
	vala_data_type_set_floating_reference ((ValaDataType*) _result_, vala_data_type_get_floating_reference ((ValaDataType*) self));
	if (self->priv->_fixed_length) {
		vala_array_type_set_fixed_length (_result_, TRUE);
		vala_array_type_set_length (_result_, self->priv->_length);
	}
	result = (ValaDataType*) _result_;
	return result;
}


static char* vala_array_type_real_get_cname (ValaDataType* base) {
	ValaArrayType * self;
	char* result;
	self = (ValaArrayType*) base;
	/* FIXME add support for [Immutable] or [Const] attribute to support arrays to const data*/
	if (self->priv->_fixed_length) {
		result = vala_data_type_get_cname (vala_array_type_get_element_type (self));
		return result;
	} else {
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		result = (_tmp1_ = g_strconcat (_tmp0_ = vala_data_type_get_cname (vala_array_type_get_element_type (self)), "*", NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
		return result;
	}
}


static char* vala_array_type_real_get_cdeclarator_suffix (ValaDataType* base) {
	ValaArrayType * self;
	char* result;
	self = (ValaArrayType*) base;
	if (self->priv->_fixed_length) {
		result = g_strdup_printf ("[%d]", self->priv->_length);
		return result;
	} else {
		result = g_strdup ("");
		return result;
	}
}


static gboolean vala_array_type_real_is_array (ValaDataType* base) {
	ValaArrayType * self;
	gboolean result;
	self = (ValaArrayType*) base;
	result = TRUE;
	return result;
}


static char* vala_array_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaArrayType * self;
	char* result;
	const char* _tmp0_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp3_;
	self = (ValaArrayType*) base;
	_tmp0_ = NULL;
	if (vala_data_type_get_nullable ((ValaDataType*) self)) {
		_tmp0_ = "?";
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	_tmp3_ = NULL;
	result = (_tmp3_ = g_strdup_printf ("%s[%s]%s", _tmp1_ = vala_data_type_to_qualified_string (vala_array_type_get_element_type (self), scope), _tmp2_ = g_strnfill ((gulong) (self->priv->_rank - 1), ','), _tmp0_), _tmp2_ = (g_free (_tmp2_), NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp3_);
	return result;
}


static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaArrayType * self;
	gboolean result;
	gboolean _tmp0_;
	ValaArrayType* _tmp4_;
	ValaDataType* _tmp3_;
	ValaArrayType* target_array_type;
	gboolean _tmp5_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp0_ = FALSE;
	if (VALA_IS_POINTER_TYPE (target_type)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		_tmp1_ = FALSE;
		if (vala_data_type_get_data_type (target_type) != NULL) {
			ValaAttribute* _tmp2_;
			_tmp2_ = NULL;
			_tmp1_ = (_tmp2_ = vala_code_node_get_attribute ((ValaCodeNode*) vala_data_type_get_data_type (target_type), "PointerType")) != NULL;
			(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL));
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		/* any array type can be cast to a generic pointer */
		result = TRUE;
		return result;
	}
	/* temporarily ignore type parameters */
	if (vala_data_type_get_type_parameter (target_type) != NULL) {
		result = TRUE;
		return result;
	}
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	target_array_type = (_tmp4_ = (_tmp3_ = target_type, VALA_IS_ARRAY_TYPE (_tmp3_) ? ((ValaArrayType*) _tmp3_) : NULL), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
	if (target_array_type == NULL) {
		result = FALSE;
		(target_array_type == NULL) ? NULL : (target_array_type = (vala_code_node_unref (target_array_type), NULL));
		return result;
	}
	_tmp5_ = FALSE;
	if (vala_data_type_compatible (vala_array_type_get_element_type (self), vala_array_type_get_element_type (target_array_type))) {
		_tmp5_ = vala_data_type_compatible (vala_array_type_get_element_type (target_array_type), vala_array_type_get_element_type (self));
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = TRUE;
		(target_array_type == NULL) ? NULL : (target_array_type = (vala_code_node_unref (target_array_type), NULL));
		return result;
	}
	result = FALSE;
	(target_array_type == NULL) ? NULL : (target_array_type = (vala_code_node_unref (target_array_type), NULL));
	return result;
}


static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base) {
	ValaArrayType * self;
	gboolean result;
	self = (ValaArrayType*) base;
	result = TRUE;
	return result;
}


static char* vala_array_type_real_get_type_signature (ValaDataType* base) {
	ValaArrayType * self;
	char* result;
	char* element_type_signature;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaArrayType*) base;
	element_type_signature = vala_data_type_get_type_signature (vala_array_type_get_element_type (self));
	if (element_type_signature == NULL) {
		result = NULL;
		element_type_signature = (g_free (element_type_signature), NULL);
		return result;
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_strconcat (_tmp0_ = g_strnfill ((gulong) self->priv->_rank, 'a'), element_type_signature, NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	element_type_signature = (g_free (element_type_signature), NULL);
	return result;
	element_type_signature = (g_free (element_type_signature), NULL);
}


static void vala_array_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayType * self;
	self = (ValaArrayType*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_array_type_get_element_type (self), visitor);
}


static void vala_array_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaArrayType * self;
	self = (ValaArrayType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_array_type_get_element_type (self) == old_type) {
		vala_array_type_set_element_type (self, new_type);
	}
}


static GeeList* vala_array_type_real_get_symbols (ValaDataType* base) {
	ValaArrayType * self;
	GeeList* result;
	self = (ValaArrayType*) base;
	result = vala_data_type_get_symbols (vala_array_type_get_element_type (self));
	return result;
}


ValaDataType* vala_array_type_get_element_type (ValaArrayType* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_element_type;
	return result;
}


void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value) {
	ValaDataType* _tmp1_;
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_element_type = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_element_type == NULL) ? NULL : (self->priv->_element_type = (vala_code_node_unref (self->priv->_element_type), NULL)), _tmp1_);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_element_type, (ValaCodeNode*) self);
}


gboolean vala_array_type_get_fixed_length (ValaArrayType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fixed_length;
	return result;
}


void vala_array_type_set_fixed_length (ValaArrayType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_fixed_length = value;
}


gint vala_array_type_get_length (ValaArrayType* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_length;
	return result;
}


void vala_array_type_set_length (ValaArrayType* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_length = value;
}


gint vala_array_type_get_rank (ValaArrayType* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rank;
	return result;
}


void vala_array_type_set_rank (ValaArrayType* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}


static void vala_array_type_class_init (ValaArrayTypeClass * klass) {
	vala_array_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_array_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->get_member = vala_array_type_real_get_member;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_array_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_array_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_cdeclarator_suffix = vala_array_type_real_get_cdeclarator_suffix;
	VALA_DATA_TYPE_CLASS (klass)->is_array = vala_array_type_real_is_array;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_array_type_real_to_qualified_string;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_array_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->is_reference_type_or_type_parameter = vala_array_type_real_is_reference_type_or_type_parameter;
	VALA_DATA_TYPE_CLASS (klass)->get_type_signature = vala_array_type_real_get_type_signature;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_array_type_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_array_type_real_replace_type;
	VALA_DATA_TYPE_CLASS (klass)->get_symbols = vala_array_type_real_get_symbols;
}


static void vala_array_type_instance_init (ValaArrayType * self) {
	self->priv = VALA_ARRAY_TYPE_GET_PRIVATE (self);
}


static void vala_array_type_finalize (ValaCodeNode* obj) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (obj);
	(self->priv->_element_type == NULL) ? NULL : (self->priv->_element_type = (vala_code_node_unref (self->priv->_element_type), NULL));
	(self->priv->length_field == NULL) ? NULL : (self->priv->length_field = (vala_code_node_unref (self->priv->length_field), NULL));
	(self->priv->resize_method == NULL) ? NULL : (self->priv->resize_method = (vala_code_node_unref (self->priv->resize_method), NULL));
	(self->priv->move_method == NULL) ? NULL : (self->priv->move_method = (vala_code_node_unref (self->priv->move_method), NULL));
	VALA_CODE_NODE_CLASS (vala_array_type_parent_class)->finalize (obj);
}


GType vala_array_type_get_type (void) {
	static GType vala_array_type_type_id = 0;
	if (vala_array_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayType), 0, (GInstanceInitFunc) vala_array_type_instance_init, NULL };
		vala_array_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaArrayType", &g_define_type_info, 0);
	}
	return vala_array_type_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




