/* valaclass.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;
typedef struct _ValaObjectTypeSymbolPrivate ValaObjectTypeSymbolPrivate;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;
typedef struct _ValaClassPrivate ValaClassPrivate;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gee_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (gee_collection_object_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_GENERIC_TYPE (vala_generic_type_get_type ())
#define VALA_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericType))
#define VALA_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))
#define VALA_IS_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GENERIC_TYPE))
#define VALA_IS_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GENERIC_TYPE))
#define VALA_GENERIC_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))

typedef struct _ValaGenericType ValaGenericType;
typedef struct _ValaGenericTypeClass ValaGenericTypeClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, GeeCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, GeeCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	GeeList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	char* (*get_cname) (ValaTypeSymbol* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	char* (*get_dup_function) (ValaTypeSymbol* self);
	char* (*get_free_function) (ValaTypeSymbol* self);
	char* (*get_copy_function) (ValaTypeSymbol* self);
	char* (*get_destroy_function) (ValaTypeSymbol* self);
	gboolean (*is_reference_counting) (ValaTypeSymbol* self);
	char* (*get_ref_function) (ValaTypeSymbol* self);
	char* (*get_unref_function) (ValaTypeSymbol* self);
	char* (*get_ref_sink_function) (ValaTypeSymbol* self);
	char* (*get_type_id) (ValaTypeSymbol* self);
	char* (*get_marshaller_type_name) (ValaTypeSymbol* self);
	char* (*get_param_spec_function) (ValaTypeSymbol* self);
	char* (*get_get_value_function) (ValaTypeSymbol* self);
	char* (*get_set_value_function) (ValaTypeSymbol* self);
	char* (*get_upper_case_cname) (ValaTypeSymbol* self, const char* infix);
	char* (*get_default_value) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const char* name);
	char* (*get_type_signature) (ValaTypeSymbol* self);
};

struct _ValaObjectTypeSymbol {
	ValaTypeSymbol parent_instance;
	ValaObjectTypeSymbolPrivate * priv;
};

struct _ValaObjectTypeSymbolClass {
	ValaTypeSymbolClass parent_class;
	GeeList* (*get_methods) (ValaObjectTypeSymbol* self);
	GeeList* (*get_signals) (ValaObjectTypeSymbol* self);
	GeeList* (*get_properties) (ValaObjectTypeSymbol* self);
};

struct _ValaClass {
	ValaObjectTypeSymbol parent_instance;
	ValaClassPrivate * priv;
};

struct _ValaClassClass {
	ValaObjectTypeSymbolClass parent_class;
};

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	char* _type_check_function;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean _free_function_address_of;
	char* cname;
	char* const_cname;
	char* lower_case_cprefix;
	char* lower_case_csuffix;
	char* type_id;
	char* ref_function;
	char* unref_function;
	gboolean _ref_function_void;
	char* ref_sink_function;
	char* param_spec_function;
	char* copy_function;
	char* free_function;
	char* marshaller_type_name;
	char* get_value_function;
	char* set_value_function;
	char* type_signature;
	gboolean _is_compact;
	gboolean _is_immutable;
	GeeList* base_types;
	GeeList* constants;
	GeeList* fields;
	GeeList* methods;
	GeeList* properties;
	GeeList* signals;
	GeeList* classes;
	GeeList* structs;
	GeeList* enums;
	GeeList* delegates;
	ValaMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _static_destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _destructor;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;


static gpointer vala_class_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_typesymbol_get_type (void);
GType vala_object_type_symbol_get_type (void);
GType vala_member_get_type (void);
GType vala_method_get_type (void);
GType vala_signal_get_type (void);
GType vala_property_get_type (void);
GType vala_class_get_type (void);
GType vala_constant_get_type (void);
GType vala_field_get_type (void);
GType vala_struct_get_type (void);
GType vala_enum_get_type (void);
GType vala_delegate_get_type (void);
GType vala_constructor_get_type (void);
GType vala_destructor_get_type (void);
#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
enum  {
	VALA_CLASS_DUMMY_PROPERTY
};
GeeList* vala_class_get_classes (ValaClass* self);
GeeList* vala_class_get_structs (ValaClass* self);
GeeList* vala_class_get_enums (ValaClass* self);
GeeList* vala_class_get_delegates (ValaClass* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void);
ValaObjectTypeSymbol* vala_object_type_symbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaClass* vala_class_new (const char* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaClass* vala_class_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_class_add_base_type (ValaClass* self, ValaDataType* type);
GeeList* vala_class_get_base_types (ValaClass* self);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
const char* vala_symbol_get_name (ValaSymbol* self);
void vala_class_add_constant (ValaClass* self, ValaConstant* c);
GType vala_symbol_accessibility_get_type (void);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
GType member_binding_get_type (void);
MemberBinding vala_field_get_binding (ValaField* self);
static void vala_class_set_has_private_fields (ValaClass* self, gboolean value);
static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value);
void vala_class_add_field (ValaClass* self, ValaField* f);
GeeList* vala_class_get_fields (ValaClass* self);
GeeList* vala_class_get_constants (ValaClass* self);
ValaObjectType* vala_object_type_new (ValaObjectTypeSymbol* type_symbol);
ValaObjectType* vala_object_type_construct (GType object_type, ValaObjectTypeSymbol* type_symbol);
GType vala_reference_type_get_type (void);
GType vala_object_type_get_type (void);
GType vala_typeparameter_get_type (void);
GeeList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self);
ValaGenericType* vala_generic_type_new (ValaTypeParameter* type_parameter);
ValaGenericType* vala_generic_type_construct (GType object_type, ValaTypeParameter* type_parameter);
GType vala_generic_type_get_type (void);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
void vala_data_type_add_type_argument (ValaDataType* self, ValaDataType* arg);
static ValaObjectType* vala_class_get_this_type (ValaClass* self);
MemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_creation_method_get_type (void);
GType vala_formal_parameter_get_type (void);
ValaFormalParameter* vala_method_get_this_parameter (ValaMethod* self);
void vala_scope_remove (ValaScope* self, const char* name);
ValaFormalParameter* vala_formal_parameter_new (const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct (GType object_type, const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
void vala_method_set_this_parameter (ValaMethod* self, ValaFormalParameter* value);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void);
GeeList* vala_method_get_postconditions (ValaMethod* self);
ValaLocalVariable* vala_method_get_result_var (ValaMethod* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value);
void vala_symbol_set_name (ValaSymbol* self, const char* value);
const char* vala_creation_method_get_class_name (ValaCreationMethod* self);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_class_add_method (ValaClass* self, ValaMethod* m);
void vala_class_add_hidden_method (ValaClass* self, ValaMethod* m);
static GeeList* vala_class_real_get_methods (ValaObjectTypeSymbol* base);
void vala_property_set_this_parameter (ValaProperty* self, ValaFormalParameter* value);
ValaFormalParameter* vala_property_get_this_parameter (ValaProperty* self);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_class_add_property (ValaClass* self, ValaProperty* prop);
static GeeList* vala_class_real_get_properties (ValaObjectTypeSymbol* base);
void vala_class_add_signal (ValaClass* self, ValaSignal* sig);
static GeeList* vala_class_real_get_signals (ValaObjectTypeSymbol* base);
void vala_class_add_class (ValaClass* self, ValaClass* cl);
void vala_class_add_struct (ValaClass* self, ValaStruct* st);
void vala_class_add_enum (ValaClass* self, ValaEnum* en);
void vala_class_add_delegate (ValaClass* self, ValaDelegate* d);
void vala_code_visitor_visit_class (ValaCodeVisitor* self, ValaClass* cl);
static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaConstructor* vala_class_get_constructor (ValaClass* self);
ValaConstructor* vala_class_get_class_constructor (ValaClass* self);
ValaConstructor* vala_class_get_static_constructor (ValaClass* self);
ValaDestructor* vala_class_get_destructor (ValaClass* self);
ValaDestructor* vala_class_get_static_destructor (ValaClass* self);
ValaDestructor* vala_class_get_class_destructor (ValaClass* self);
static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
char* vala_typesymbol_get_cname (ValaTypeSymbol* self, gboolean const_type);
static char* vala_class_real_get_cprefix (ValaSymbol* base);
gboolean vala_class_get_is_immutable (ValaClass* self);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
char* vala_class_get_default_cname (ValaClass* self);
static char* vala_class_real_get_cname (ValaTypeSymbol* base, gboolean const_type);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
void vala_class_set_cname (ValaClass* self, const char* cname);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
static char* vala_class_get_lower_case_csuffix (ValaClass* self);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
static char* vala_class_real_get_lower_case_cname (ValaSymbol* base, const char* infix);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
static char* vala_class_real_get_lower_case_cprefix (ValaSymbol* base);
static char* vala_class_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix);
static char* vala_class_real_get_type_signature (ValaTypeSymbol* base);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
void vala_class_set_ref_function (ValaClass* self, const char* name);
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name);
void vala_class_set_ref_function_void (ValaClass* self, gboolean value);
void vala_class_set_unref_function (ValaClass* self, const char* name);
void vala_class_set_ref_sink_function (ValaClass* self, const char* name);
void vala_class_set_dup_function (ValaClass* self, const char* name);
void vala_class_set_free_function (ValaClass* self, const char* name);
static void vala_class_set_free_function_address_of (ValaClass* self, gboolean value);
void vala_typesymbol_add_cheader_filename (ValaTypeSymbol* self, const char* filename);
void vala_class_set_type_check_function (ValaClass* self, const char* value);
static void vala_class_process_ccode_attribute (ValaClass* self, ValaAttribute* a);
const char* vala_attribute_get_name (ValaAttribute* self);
void vala_class_set_is_compact (ValaClass* self, gboolean value);
void vala_class_set_is_immutable (ValaClass* self, gboolean value);
void vala_class_process_attributes (ValaClass* self);
gboolean vala_class_get_is_compact (ValaClass* self);
char* vala_typesymbol_get_upper_case_cname (ValaTypeSymbol* self, const char* infix);
static char* vala_class_real_get_type_id (ValaTypeSymbol* base);
void vala_class_set_type_id (ValaClass* self, const char* type_id);
ValaClass* vala_class_get_base_class (ValaClass* self);
char* vala_typesymbol_get_marshaller_type_name (ValaTypeSymbol* self);
static char* vala_class_real_get_marshaller_type_name (ValaTypeSymbol* base);
char* vala_class_get_default_param_spec_function (ValaClass* self);
static char* vala_class_real_get_param_spec_function (ValaTypeSymbol* base);
gboolean vala_class_is_fundamental (ValaClass* self);
char* vala_typesymbol_get_param_spec_function (ValaTypeSymbol* self);
char* vala_typesymbol_get_type_id (ValaTypeSymbol* self);
char* vala_typesymbol_get_get_value_function (ValaTypeSymbol* self);
static char* vala_class_real_get_get_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_set_value_function (ValaTypeSymbol* self);
static char* vala_class_real_get_set_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_ref_function (ValaTypeSymbol* self);
static gboolean vala_class_real_is_reference_counting (ValaTypeSymbol* base);
static char* vala_class_real_get_ref_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_unref_function (ValaTypeSymbol* self);
static char* vala_class_real_get_unref_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_ref_sink_function (ValaTypeSymbol* self);
static char* vala_class_real_get_ref_sink_function (ValaTypeSymbol* base);
static char* vala_class_real_get_dup_function (ValaTypeSymbol* base);
char* vala_class_get_default_free_function (ValaClass* self);
char* vala_typesymbol_get_free_function (ValaTypeSymbol* self);
static char* vala_class_real_get_free_function (ValaTypeSymbol* base);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_typesymbol_is_subtype_of (ValaTypeSymbol* self, ValaTypeSymbol* t);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
GType vala_interface_get_type (void);
GeeList* vala_interface_get_prerequisites (ValaInterface* self);
static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, GeeList* list);
static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
char* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
GeeList* vala_object_type_symbol_get_methods (ValaObjectTypeSymbol* self);
gboolean vala_method_get_is_abstract (ValaMethod* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
void vala_symbol_set_used (ValaSymbol* self, gboolean value);
GeeList* vala_object_type_symbol_get_properties (ValaObjectTypeSymbol* self);
gboolean vala_property_get_is_abstract (ValaProperty* self);
gboolean vala_class_get_is_abstract (ValaClass* self);
ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const char* name);
gboolean vala_method_get_overrides (ValaMethod* self);
gboolean vala_property_get_overrides (ValaProperty* self);
static gboolean vala_class_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
void vala_class_set_base_class (ValaClass* self, ValaClass* value);
void vala_class_set_is_abstract (ValaClass* self, gboolean value);
gboolean vala_class_get_ref_function_void (ValaClass* self);
const char* vala_class_get_type_check_function (ValaClass* self);
gboolean vala_class_get_has_private_fields (ValaClass* self);
gboolean vala_class_get_has_class_private_fields (ValaClass* self);
gboolean vala_class_get_free_function_address_of (ValaClass* self);
ValaMethod* vala_class_get_default_construction_method (ValaClass* self);
void vala_class_set_constructor (ValaClass* self, ValaConstructor* value);
void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value);
void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value);
ValaFormalParameter* vala_destructor_get_this_parameter (ValaDestructor* self);
void vala_destructor_set_this_parameter (ValaDestructor* self, ValaFormalParameter* value);
void vala_class_set_destructor (ValaClass* self, ValaDestructor* value);
void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value);
void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value);
gboolean vala_class_get_is_error_base (ValaClass* self);
static void vala_class_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GeeList* vala_class_get_classes (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->classes);
	return result;
}


GeeList* vala_class_get_structs (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->structs);
	return result;
}


GeeList* vala_class_get_enums (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->enums);
	return result;
}


GeeList* vala_class_get_delegates (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->delegates);
	return result;
}


ValaClass* vala_class_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaClass* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaClass* vala_class_new (const char* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


void vala_class_add_base_type (ValaClass* self, ValaDataType* type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	gee_collection_add ((GeeCollection*) self->priv->base_types, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


GeeList* vala_class_get_base_types (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->base_types);
	return result;
}


void vala_class_add_constant (ValaClass* self, ValaConstant* c) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	gee_collection_add ((GeeCollection*) self->priv->constants, c);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) c), (ValaSymbol*) c);
}


void vala_class_add_field (ValaClass* self, ValaField* f) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	gee_collection_add ((GeeCollection*) self->priv->fields, f);
	_tmp0_ = FALSE;
	if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		_tmp0_ = vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp1_;
		_tmp1_ = FALSE;
		if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			_tmp1_ = vala_field_get_binding (f) == MEMBER_BINDING_CLASS;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) f), (ValaSymbol*) f);
}


GeeList* vala_class_get_fields (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->fields);
	return result;
}


GeeList* vala_class_get_constants (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->constants);
	return result;
}


static ValaObjectType* vala_class_get_this_type (ValaClass* self) {
	ValaObjectType* result;
	ValaObjectType* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _type_parameter_it;
		_type_parameter_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self))), _gee_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaTypeParameter* type_parameter;
			ValaGenericType* type_arg;
			if (!gee_iterator_next (_type_parameter_it)) {
				break;
			}
			type_parameter = (ValaTypeParameter*) gee_iterator_get (_type_parameter_it);
			type_arg = vala_generic_type_new (type_parameter);
			vala_data_type_set_value_owned ((ValaDataType*) type_arg, TRUE);
			vala_data_type_add_type_argument ((ValaDataType*) _result_, (ValaDataType*) type_arg);
			_vala_code_node_unref0 (type_parameter);
			_vala_code_node_unref0 (type_arg);
		}
		_gee_collection_object_unref0 (_type_parameter_it);
	}
	result = _result_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_class_add_method (ValaClass* self, ValaMethod* m) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = FALSE;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaFormalParameter* _tmp2_;
		ValaObjectType* _tmp1_;
		if (vala_method_get_this_parameter (m) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_this_parameter (m)));
		}
		vala_method_set_this_parameter (m, _tmp2_ = vala_formal_parameter_new ("this", (ValaDataType*) (_tmp1_ = vala_class_get_this_type (self)), NULL));
		_vala_code_node_unref0 (_tmp2_);
		_vala_code_node_unref0 (_tmp1_);
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_this_parameter (m)), (ValaSymbol*) vala_method_get_this_parameter (m));
	}
	_tmp3_ = FALSE;
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		GeeList* _tmp4_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) (_tmp4_ = vala_method_get_postconditions (m))) > 0;
		_gee_collection_object_unref0 (_tmp4_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaLocalVariable* _tmp6_;
		ValaDataType* _tmp5_;
		if (vala_method_get_result_var (m) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_result_var (m)));
		}
		vala_method_set_result_var (m, _tmp6_ = vala_local_variable_new (_tmp5_ = vala_data_type_copy (vala_method_get_return_type (m)), "result", NULL, NULL));
		_vala_code_node_unref0 (_tmp6_);
		_vala_code_node_unref0 (_tmp5_);
		vala_local_variable_set_is_result (vala_method_get_result_var (m), TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCreationMethod* cm;
		gboolean _tmp7_;
		if (vala_symbol_get_name ((ValaSymbol*) m) == NULL) {
			vala_class_set_default_construction_method (self, m);
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = _vala_code_node_ref0 (VALA_CREATION_METHOD (m));
		_tmp7_ = FALSE;
		if (vala_creation_method_get_class_name (cm) != NULL) {
			_tmp7_ = _vala_strcmp0 (vala_creation_method_get_class_name (cm), vala_symbol_get_name ((ValaSymbol*) self)) != 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			char* _tmp9_;
			char* _tmp8_;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), _tmp9_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) self), vala_creation_method_get_class_name (cm)));
			_g_free0 (_tmp9_);
			_g_free0 (_tmp8_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	gee_collection_add ((GeeCollection*) self->priv->methods, m);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) m), (ValaSymbol*) m);
}


void vala_class_add_hidden_method (ValaClass* self, ValaMethod* m) {
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaFormalParameter* _tmp1_;
		ValaObjectType* _tmp0_;
		if (vala_method_get_this_parameter (m) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_this_parameter (m)));
		}
		vala_method_set_this_parameter (m, _tmp1_ = vala_formal_parameter_new ("this", (ValaDataType*) (_tmp0_ = vala_class_get_this_type (self)), NULL));
		_vala_code_node_unref0 (_tmp1_);
		_vala_code_node_unref0 (_tmp0_);
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_this_parameter (m)), (ValaSymbol*) vala_method_get_this_parameter (m));
	}
	_tmp2_ = FALSE;
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		GeeList* _tmp3_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) (_tmp3_ = vala_method_get_postconditions (m))) > 0;
		_gee_collection_object_unref0 (_tmp3_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaLocalVariable* _tmp5_;
		ValaDataType* _tmp4_;
		if (vala_method_get_result_var (m) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_result_var (m)));
		}
		vala_method_set_result_var (m, _tmp5_ = vala_local_variable_new (_tmp4_ = vala_data_type_copy (vala_method_get_return_type (m)), "result", NULL, NULL));
		_vala_code_node_unref0 (_tmp5_);
		_vala_code_node_unref0 (_tmp4_);
		vala_local_variable_set_is_result (vala_method_get_result_var (m), TRUE);
	}
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), NULL, (ValaSymbol*) m);
}


static GeeList* vala_class_real_get_methods (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	GeeList* result;
	self = (ValaClass*) base;
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->methods);
	return result;
}


void vala_class_add_property (ValaClass* self, ValaProperty* prop) {
	ValaFormalParameter* _tmp1_;
	ValaObjectType* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	gee_collection_add ((GeeCollection*) self->priv->properties, prop);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) prop), (ValaSymbol*) prop);
	vala_property_set_this_parameter (prop, _tmp1_ = vala_formal_parameter_new ("this", (ValaDataType*) (_tmp0_ = vala_class_get_this_type (self)), NULL));
	_vala_code_node_unref0 (_tmp1_);
	_vala_code_node_unref0 (_tmp0_);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) prop), vala_symbol_get_name ((ValaSymbol*) vala_property_get_this_parameter (prop)), (ValaSymbol*) vala_property_get_this_parameter (prop));
	if (vala_property_get_field (prop) != NULL) {
		vala_class_add_field (self, vala_property_get_field (prop));
	}
}


static GeeList* vala_class_real_get_properties (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	GeeList* result;
	self = (ValaClass*) base;
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->properties);
	return result;
}


void vala_class_add_signal (ValaClass* self, ValaSignal* sig) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	gee_collection_add ((GeeCollection*) self->priv->signals, sig);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) sig), (ValaSymbol*) sig);
}


static GeeList* vala_class_real_get_signals (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	GeeList* result;
	self = (ValaClass*) base;
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->signals);
	return result;
}


void vala_class_add_class (ValaClass* self, ValaClass* cl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	gee_collection_add ((GeeCollection*) self->priv->classes, cl);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) cl), (ValaSymbol*) cl);
}


void vala_class_add_struct (ValaClass* self, ValaStruct* st) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	gee_collection_add ((GeeCollection*) self->priv->structs, st);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) st), (ValaSymbol*) st);
}


void vala_class_add_enum (ValaClass* self, ValaEnum* en) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (en != NULL);
	gee_collection_add ((GeeCollection*) self->priv->enums, en);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) en), (ValaSymbol*) en);
}


void vala_class_add_delegate (ValaClass* self, ValaDelegate* d) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	gee_collection_add ((GeeCollection*) self->priv->delegates, d);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) d), (ValaSymbol*) d);
}


static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}


static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		GeeIterator* _type_it;
		_type_it = gee_iterable_iterator ((GeeIterable*) self->priv->base_types);
		while (TRUE) {
			ValaDataType* type;
			if (!gee_iterator_next (_type_it)) {
				break;
			}
			type = (ValaDataType*) gee_iterator_get (_type_it);
			vala_code_node_accept ((ValaCodeNode*) type, visitor);
			_vala_code_node_unref0 (type);
		}
		_gee_collection_object_unref0 (_type_it);
	}
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _p_it;
		_p_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self))), _gee_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!gee_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) gee_iterator_get (_p_it);
			vala_code_node_accept ((ValaCodeNode*) p, visitor);
			_vala_code_node_unref0 (p);
		}
		_gee_collection_object_unref0 (_p_it);
	}
	{
		GeeIterator* _en_it;
		_en_it = gee_iterable_iterator ((GeeIterable*) self->priv->enums);
		while (TRUE) {
			ValaEnum* en;
			if (!gee_iterator_next (_en_it)) {
				break;
			}
			en = (ValaEnum*) gee_iterator_get (_en_it);
			vala_code_node_accept ((ValaCodeNode*) en, visitor);
			_vala_code_node_unref0 (en);
		}
		_gee_collection_object_unref0 (_en_it);
	}
	{
		GeeIterator* _f_it;
		_f_it = gee_iterable_iterator ((GeeIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			if (!gee_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) gee_iterator_get (_f_it);
			vala_code_node_accept ((ValaCodeNode*) f, visitor);
			_vala_code_node_unref0 (f);
		}
		_gee_collection_object_unref0 (_f_it);
	}
	{
		GeeIterator* _c_it;
		_c_it = gee_iterable_iterator ((GeeIterable*) self->priv->constants);
		while (TRUE) {
			ValaConstant* c;
			if (!gee_iterator_next (_c_it)) {
				break;
			}
			c = (ValaConstant*) gee_iterator_get (_c_it);
			vala_code_node_accept ((ValaCodeNode*) c, visitor);
			_vala_code_node_unref0 (c);
		}
		_gee_collection_object_unref0 (_c_it);
	}
	{
		GeeIterator* _m_it;
		_m_it = gee_iterable_iterator ((GeeIterable*) self->priv->methods);
		while (TRUE) {
			ValaMethod* m;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			vala_code_node_accept ((ValaCodeNode*) m, visitor);
			_vala_code_node_unref0 (m);
		}
		_gee_collection_object_unref0 (_m_it);
	}
	{
		GeeIterator* _prop_it;
		_prop_it = gee_iterable_iterator ((GeeIterable*) self->priv->properties);
		while (TRUE) {
			ValaProperty* prop;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			vala_code_node_accept ((ValaCodeNode*) prop, visitor);
			_vala_code_node_unref0 (prop);
		}
		_gee_collection_object_unref0 (_prop_it);
	}
	{
		GeeIterator* _sig_it;
		_sig_it = gee_iterable_iterator ((GeeIterable*) self->priv->signals);
		while (TRUE) {
			ValaSignal* sig;
			if (!gee_iterator_next (_sig_it)) {
				break;
			}
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			vala_code_node_accept ((ValaCodeNode*) sig, visitor);
			_vala_code_node_unref0 (sig);
		}
		_gee_collection_object_unref0 (_sig_it);
	}
	if (self->priv->_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_constructor, visitor);
	}
	if (self->priv->_class_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_class_constructor, visitor);
	}
	if (self->priv->_static_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_static_constructor, visitor);
	}
	if (vala_class_get_destructor (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_class_get_destructor (self), visitor);
	}
	if (self->priv->_static_destructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_static_destructor, visitor);
	}
	if (self->priv->_class_destructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_class_destructor, visitor);
	}
	{
		GeeIterator* _cl_it;
		_cl_it = gee_iterable_iterator ((GeeIterable*) self->priv->classes);
		while (TRUE) {
			ValaClass* cl;
			if (!gee_iterator_next (_cl_it)) {
				break;
			}
			cl = (ValaClass*) gee_iterator_get (_cl_it);
			vala_code_node_accept ((ValaCodeNode*) cl, visitor);
			_vala_code_node_unref0 (cl);
		}
		_gee_collection_object_unref0 (_cl_it);
	}
	{
		GeeIterator* _st_it;
		_st_it = gee_iterable_iterator ((GeeIterable*) self->priv->structs);
		while (TRUE) {
			ValaStruct* st;
			if (!gee_iterator_next (_st_it)) {
				break;
			}
			st = (ValaStruct*) gee_iterator_get (_st_it);
			vala_code_node_accept ((ValaCodeNode*) st, visitor);
			_vala_code_node_unref0 (st);
		}
		_gee_collection_object_unref0 (_st_it);
	}
	{
		GeeIterator* _d_it;
		_d_it = gee_iterable_iterator ((GeeIterable*) self->priv->delegates);
		while (TRUE) {
			ValaDelegate* d;
			if (!gee_iterator_next (_d_it)) {
				break;
			}
			d = (ValaDelegate*) gee_iterator_get (_d_it);
			vala_code_node_accept ((ValaCodeNode*) d, visitor);
			_vala_code_node_unref0 (d);
		}
		_gee_collection_object_unref0 (_d_it);
	}
}


static char* vala_class_real_get_cprefix (ValaSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	result = vala_typesymbol_get_cname ((ValaTypeSymbol*) self, FALSE);
	return result;
}


static char* vala_class_real_get_cname (ValaTypeSymbol* base, gboolean const_type) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	if (const_type) {
		if (self->priv->const_cname != NULL) {
			result = g_strdup (self->priv->const_cname);
			return result;
		} else {
			if (vala_class_get_is_immutable (self)) {
				char* _tmp0_;
				char* _tmp1_;
				result = (_tmp1_ = g_strconcat ("const ", _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) self, FALSE), NULL), _g_free0 (_tmp0_), _tmp1_);
				return result;
			}
		}
	}
	if (self->priv->cname == NULL) {
		ValaAttribute* attr;
		attr = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
		if (attr != NULL) {
			char* _tmp2_;
			self->priv->cname = (_tmp2_ = vala_attribute_get_string (attr, "cname"), _g_free0 (self->priv->cname), _tmp2_);
		}
		if (self->priv->cname == NULL) {
			char* _tmp3_;
			self->priv->cname = (_tmp3_ = vala_class_get_default_cname (self), _g_free0 (self->priv->cname), _tmp3_);
		}
		_vala_code_node_unref0 (attr);
	}
	result = g_strdup (self->priv->cname);
	return result;
}


char* vala_class_get_default_cname (ValaClass* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strdup_printf ("%s%s", _tmp0_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), vala_symbol_get_name ((ValaSymbol*) self)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


void vala_class_set_cname (ValaClass* self, const char* cname) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	self->priv->cname = (_tmp0_ = g_strdup (cname), _g_free0 (self->priv->cname), _tmp0_);
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static char* vala_class_get_lower_case_csuffix (ValaClass* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->lower_case_csuffix == NULL) {
		char* _tmp0_;
		self->priv->lower_case_csuffix = (_tmp0_ = vala_symbol_camel_case_to_lower_case (vala_symbol_get_name ((ValaSymbol*) self)), _g_free0 (self->priv->lower_case_csuffix), _tmp0_);
		if (g_str_has_prefix (self->priv->lower_case_csuffix, "type_")) {
			char* _tmp1_;
			self->priv->lower_case_csuffix = (_tmp1_ = g_strconcat ("type", g_utf8_offset_to_pointer (self->priv->lower_case_csuffix, g_utf8_strlen ("type_", -1)), NULL), _g_free0 (self->priv->lower_case_csuffix), _tmp1_);
		} else {
			if (g_str_has_prefix (self->priv->lower_case_csuffix, "is_")) {
				char* _tmp2_;
				self->priv->lower_case_csuffix = (_tmp2_ = g_strconcat ("is", g_utf8_offset_to_pointer (self->priv->lower_case_csuffix, g_utf8_strlen ("is_", -1)), NULL), _g_free0 (self->priv->lower_case_csuffix), _tmp2_);
			}
		}
		if (g_str_has_suffix (self->priv->lower_case_csuffix, "_class")) {
			char* _tmp4_;
			char* _tmp3_;
			self->priv->lower_case_csuffix = (_tmp4_ = g_strconcat (_tmp3_ = string_substring (self->priv->lower_case_csuffix, (glong) 0, g_utf8_strlen (self->priv->lower_case_csuffix, -1) - g_utf8_strlen ("_class", -1)), "class", NULL), _g_free0 (self->priv->lower_case_csuffix), _tmp4_);
			_g_free0 (_tmp3_);
		}
	}
	result = g_strdup (self->priv->lower_case_csuffix);
	return result;
}


static char* vala_class_real_get_lower_case_cname (ValaSymbol* base, const char* infix) {
	ValaClass * self;
	char* result;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	self = (ValaClass*) base;
	if (infix == NULL) {
		infix = "";
	}
	result = (_tmp2_ = g_strdup_printf ("%s%s%s", _tmp0_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), infix, _tmp1_ = vala_class_get_lower_case_csuffix (self)), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	return result;
}


static char* vala_class_real_get_lower_case_cprefix (ValaSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	if (self->priv->lower_case_cprefix == NULL) {
		char* _tmp1_;
		char* _tmp0_;
		self->priv->lower_case_cprefix = (_tmp1_ = g_strdup_printf ("%s_", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, NULL)), _g_free0 (self->priv->lower_case_cprefix), _tmp1_);
		_g_free0 (_tmp0_);
	}
	result = g_strdup (self->priv->lower_case_cprefix);
	return result;
}


static char* vala_class_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix) {
	ValaClass * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaClass*) base;
	result = (_tmp1_ = g_utf8_strup (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, infix), -1), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* vala_class_real_get_type_signature (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	result = g_strdup (self->priv->type_signature);
	return result;
}


static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base) {
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


static void vala_class_process_ccode_attribute (ValaClass* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "ref_function")) {
		char* _tmp0_;
		vala_class_set_ref_function (self, _tmp0_ = vala_attribute_get_string (a, "ref_function"));
		_g_free0 (_tmp0_);
	}
	if (vala_attribute_has_argument (a, "ref_function_void")) {
		vala_class_set_ref_function_void (self, vala_attribute_get_bool (a, "ref_function_void"));
	}
	if (vala_attribute_has_argument (a, "unref_function")) {
		char* _tmp1_;
		vala_class_set_unref_function (self, _tmp1_ = vala_attribute_get_string (a, "unref_function"));
		_g_free0 (_tmp1_);
	}
	if (vala_attribute_has_argument (a, "ref_sink_function")) {
		char* _tmp2_;
		vala_class_set_ref_sink_function (self, _tmp2_ = vala_attribute_get_string (a, "ref_sink_function"));
		_g_free0 (_tmp2_);
	}
	if (vala_attribute_has_argument (a, "copy_function")) {
		char* _tmp3_;
		vala_class_set_dup_function (self, _tmp3_ = vala_attribute_get_string (a, "copy_function"));
		_g_free0 (_tmp3_);
	}
	if (vala_attribute_has_argument (a, "free_function")) {
		char* _tmp4_;
		vala_class_set_free_function (self, _tmp4_ = vala_attribute_get_string (a, "free_function"));
		_g_free0 (_tmp4_);
	}
	if (vala_attribute_has_argument (a, "free_function_address_of")) {
		vala_class_set_free_function_address_of (self, vala_attribute_get_bool (a, "free_function_address_of"));
	}
	if (vala_attribute_has_argument (a, "type_id")) {
		char* _tmp5_;
		self->priv->type_id = (_tmp5_ = vala_attribute_get_string (a, "type_id"), _g_free0 (self->priv->type_id), _tmp5_);
	}
	if (vala_attribute_has_argument (a, "marshaller_type_name")) {
		char* _tmp6_;
		self->priv->marshaller_type_name = (_tmp6_ = vala_attribute_get_string (a, "marshaller_type_name"), _g_free0 (self->priv->marshaller_type_name), _tmp6_);
	}
	if (vala_attribute_has_argument (a, "get_value_function")) {
		char* _tmp7_;
		self->priv->get_value_function = (_tmp7_ = vala_attribute_get_string (a, "get_value_function"), _g_free0 (self->priv->get_value_function), _tmp7_);
	}
	if (vala_attribute_has_argument (a, "set_value_function")) {
		char* _tmp8_;
		self->priv->set_value_function = (_tmp8_ = vala_attribute_get_string (a, "set_value_function"), _g_free0 (self->priv->set_value_function), _tmp8_);
	}
	if (vala_attribute_has_argument (a, "const_cname")) {
		char* _tmp9_;
		self->priv->const_cname = (_tmp9_ = vala_attribute_get_string (a, "const_cname"), _g_free0 (self->priv->const_cname), _tmp9_);
	}
	if (vala_attribute_has_argument (a, "cprefix")) {
		char* _tmp10_;
		self->priv->lower_case_cprefix = (_tmp10_ = vala_attribute_get_string (a, "cprefix"), _g_free0 (self->priv->lower_case_cprefix), _tmp10_);
	}
	if (vala_attribute_has_argument (a, "lower_case_csuffix")) {
		char* _tmp11_;
		self->priv->lower_case_csuffix = (_tmp11_ = vala_attribute_get_string (a, "lower_case_csuffix"), _g_free0 (self->priv->lower_case_csuffix), _tmp11_);
	}
	if (vala_attribute_has_argument (a, "cheader_filename")) {
		char* val;
		val = vala_attribute_get_string (a, "cheader_filename");
		{
			char** _tmp12_;
			char** filename_collection;
			int filename_collection_length1;
			int filename_it;
			filename_collection = _tmp12_ = g_strsplit (val, ",", 0);
			filename_collection_length1 = _vala_array_length (_tmp12_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp12_); filename_it = filename_it + 1) {
				char* filename;
				filename = g_strdup (filename_collection[filename_it]);
				{
					vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) self, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
	if (vala_attribute_has_argument (a, "type_signature")) {
		char* _tmp13_;
		self->priv->type_signature = (_tmp13_ = vala_attribute_get_string (a, "type_signature"), _g_free0 (self->priv->type_signature), _tmp13_);
	}
	if (vala_attribute_has_argument (a, "type_check_function")) {
		char* _tmp14_;
		vala_class_set_type_check_function (self, _tmp14_ = vala_attribute_get_string (a, "type_check_function"));
		_g_free0 (_tmp14_);
	}
	if (vala_attribute_has_argument (a, "param_spec_function")) {
		char* _tmp15_;
		self->priv->param_spec_function = (_tmp15_ = vala_attribute_get_string (a, "param_spec_function"), _g_free0 (self->priv->param_spec_function), _tmp15_);
	}
}


void vala_class_process_attributes (ValaClass* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a;
			a = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), "CCode") == 0) {
					vala_class_process_ccode_attribute (self, a);
				} else {
					if (_vala_strcmp0 (vala_attribute_get_name (a), "Compact") == 0) {
						vala_class_set_is_compact (self, TRUE);
					} else {
						if (_vala_strcmp0 (vala_attribute_get_name (a), "Immutable") == 0) {
							vala_class_set_is_immutable (self, TRUE);
						}
					}
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static char* vala_class_real_get_type_id (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	if (self->priv->type_id == NULL) {
		if (!vala_class_get_is_compact (self)) {
			char* _tmp0_;
			self->priv->type_id = (_tmp0_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) self, "TYPE_"), _g_free0 (self->priv->type_id), _tmp0_);
		} else {
			char* _tmp1_;
			self->priv->type_id = (_tmp1_ = g_strdup ("G_TYPE_POINTER"), _g_free0 (self->priv->type_id), _tmp1_);
		}
	}
	result = g_strdup (self->priv->type_id);
	return result;
}


void vala_class_set_type_id (ValaClass* self, const char* type_id) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_id != NULL);
	self->priv->type_id = (_tmp0_ = g_strdup (type_id), _g_free0 (self->priv->type_id), _tmp0_);
}


static char* vala_class_real_get_marshaller_type_name (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	if (self->priv->marshaller_type_name == NULL) {
		if (self->priv->_base_class != NULL) {
			char* _tmp0_;
			self->priv->marshaller_type_name = (_tmp0_ = vala_typesymbol_get_marshaller_type_name ((ValaTypeSymbol*) self->priv->_base_class), _g_free0 (self->priv->marshaller_type_name), _tmp0_);
		} else {
			char* _tmp1_;
			self->priv->marshaller_type_name = (_tmp1_ = g_strdup ("POINTER"), _g_free0 (self->priv->marshaller_type_name), _tmp1_);
		}
	}
	result = g_strdup (self->priv->marshaller_type_name);
	return result;
}


static char* vala_class_real_get_param_spec_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	if (self->priv->param_spec_function == NULL) {
		char* _tmp0_;
		self->priv->param_spec_function = (_tmp0_ = vala_class_get_default_param_spec_function (self), _g_free0 (self->priv->param_spec_function), _tmp0_);
	}
	result = g_strdup (self->priv->param_spec_function);
	return result;
}


char* vala_class_get_default_param_spec_function (ValaClass* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_class_is_fundamental (self)) {
		result = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "param_spec_");
		return result;
	} else {
		if (self->priv->_base_class != NULL) {
			result = vala_typesymbol_get_param_spec_function ((ValaTypeSymbol*) self->priv->_base_class);
			return result;
		} else {
			char* _tmp0_;
			gboolean _tmp1_;
			if ((_tmp1_ = _vala_strcmp0 (_tmp0_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self), "G_TYPE_POINTER") == 0, _g_free0 (_tmp0_), _tmp1_)) {
				result = g_strdup ("g_param_spec_pointer");
				return result;
			} else {
				result = g_strdup ("g_param_spec_boxed");
				return result;
			}
		}
	}
}


static char* vala_class_real_get_get_value_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	if (self->priv->get_value_function == NULL) {
		if (vala_class_is_fundamental (self)) {
			char* _tmp0_;
			self->priv->get_value_function = (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "value_get_"), _g_free0 (self->priv->get_value_function), _tmp0_);
		} else {
			if (self->priv->_base_class != NULL) {
				char* _tmp1_;
				self->priv->get_value_function = (_tmp1_ = vala_typesymbol_get_get_value_function ((ValaTypeSymbol*) self->priv->_base_class), _g_free0 (self->priv->get_value_function), _tmp1_);
			} else {
				char* _tmp2_;
				gboolean _tmp3_;
				if ((_tmp3_ = _vala_strcmp0 (_tmp2_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self), "G_TYPE_POINTER") == 0, _g_free0 (_tmp2_), _tmp3_)) {
					char* _tmp4_;
					self->priv->get_value_function = (_tmp4_ = g_strdup ("g_value_get_pointer"), _g_free0 (self->priv->get_value_function), _tmp4_);
				} else {
					char* _tmp5_;
					self->priv->get_value_function = (_tmp5_ = g_strdup ("g_value_get_boxed"), _g_free0 (self->priv->get_value_function), _tmp5_);
				}
			}
		}
	}
	result = g_strdup (self->priv->get_value_function);
	return result;
}


static char* vala_class_real_get_set_value_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	if (self->priv->set_value_function == NULL) {
		if (vala_class_is_fundamental (self)) {
			char* _tmp0_;
			self->priv->set_value_function = (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "value_set_"), _g_free0 (self->priv->set_value_function), _tmp0_);
		} else {
			if (self->priv->_base_class != NULL) {
				char* _tmp1_;
				self->priv->set_value_function = (_tmp1_ = vala_typesymbol_get_set_value_function ((ValaTypeSymbol*) self->priv->_base_class), _g_free0 (self->priv->set_value_function), _tmp1_);
			} else {
				char* _tmp2_;
				gboolean _tmp3_;
				if ((_tmp3_ = _vala_strcmp0 (_tmp2_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self), "G_TYPE_POINTER") == 0, _g_free0 (_tmp2_), _tmp3_)) {
					char* _tmp4_;
					self->priv->set_value_function = (_tmp4_ = g_strdup ("g_value_set_pointer"), _g_free0 (self->priv->set_value_function), _tmp4_);
				} else {
					char* _tmp5_;
					self->priv->set_value_function = (_tmp5_ = g_strdup ("g_value_set_boxed"), _g_free0 (self->priv->set_value_function), _tmp5_);
				}
			}
		}
	}
	result = g_strdup (self->priv->set_value_function);
	return result;
}


static gboolean vala_class_real_is_reference_counting (ValaTypeSymbol* base) {
	ValaClass * self;
	gboolean result;
	char* _tmp0_;
	gboolean _tmp1_;
	self = (ValaClass*) base;
	result = (_tmp1_ = (_tmp0_ = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) self)) != NULL, _g_free0 (_tmp0_), _tmp1_);
	return result;
}


gboolean vala_class_is_fundamental (ValaClass* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = FALSE;
	if (!vala_class_get_is_compact (self)) {
		_tmp0_ = self->priv->_base_class == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static char* vala_class_real_get_ref_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	gboolean _tmp0_;
	gboolean _tmp3_;
	self = (ValaClass*) base;
	_tmp0_ = FALSE;
	if (self->priv->ref_function == NULL) {
		_tmp0_ = vala_class_is_fundamental (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp2_;
		char* _tmp1_;
		self->priv->ref_function = (_tmp2_ = g_strconcat (_tmp1_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "ref", NULL), _g_free0 (self->priv->ref_function), _tmp2_);
		_g_free0 (_tmp1_);
	}
	_tmp3_ = FALSE;
	if (self->priv->ref_function == NULL) {
		_tmp3_ = self->priv->_base_class != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) self->priv->_base_class);
		return result;
	} else {
		result = g_strdup (self->priv->ref_function);
		return result;
	}
}


void vala_class_set_ref_function (ValaClass* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->ref_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->ref_function), _tmp0_);
}


static char* vala_class_real_get_unref_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	gboolean _tmp0_;
	gboolean _tmp3_;
	self = (ValaClass*) base;
	_tmp0_ = FALSE;
	if (self->priv->unref_function == NULL) {
		_tmp0_ = vala_class_is_fundamental (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp2_;
		char* _tmp1_;
		self->priv->unref_function = (_tmp2_ = g_strconcat (_tmp1_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "unref", NULL), _g_free0 (self->priv->unref_function), _tmp2_);
		_g_free0 (_tmp1_);
	}
	_tmp3_ = FALSE;
	if (self->priv->unref_function == NULL) {
		_tmp3_ = self->priv->_base_class != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = vala_typesymbol_get_unref_function ((ValaTypeSymbol*) self->priv->_base_class);
		return result;
	} else {
		result = g_strdup (self->priv->unref_function);
		return result;
	}
}


void vala_class_set_unref_function (ValaClass* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->unref_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->unref_function), _tmp0_);
}


static char* vala_class_real_get_ref_sink_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	gboolean _tmp0_;
	self = (ValaClass*) base;
	_tmp0_ = FALSE;
	if (self->priv->ref_sink_function == NULL) {
		_tmp0_ = self->priv->_base_class != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = vala_typesymbol_get_ref_sink_function ((ValaTypeSymbol*) self->priv->_base_class);
		return result;
	} else {
		result = g_strdup (self->priv->ref_sink_function);
		return result;
	}
}


void vala_class_set_ref_sink_function (ValaClass* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->ref_sink_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->ref_sink_function), _tmp0_);
}


static char* vala_class_real_get_dup_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	result = g_strdup (self->priv->copy_function);
	return result;
}


void vala_class_set_dup_function (ValaClass* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->copy_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->copy_function), _tmp0_);
}


char* vala_class_get_default_free_function (ValaClass* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "free", NULL), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* vala_class_real_get_free_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	if (self->priv->free_function == NULL) {
		char* _tmp0_;
		if (self->priv->_base_class != NULL) {
			result = vala_typesymbol_get_free_function ((ValaTypeSymbol*) self->priv->_base_class);
			return result;
		}
		self->priv->free_function = (_tmp0_ = vala_class_get_default_free_function (self), _g_free0 (self->priv->free_function), _tmp0_);
	}
	result = g_strdup (self->priv->free_function);
	return result;
}


void vala_class_set_free_function (ValaClass* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	self->priv->free_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->free_function), _tmp0_);
}


static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (self) == t) {
		result = TRUE;
		return result;
	}
	{
		GeeIterator* _base_type_it;
		_base_type_it = gee_iterable_iterator ((GeeIterable*) self->priv->base_types);
		while (TRUE) {
			ValaDataType* base_type;
			gboolean _tmp0_;
			if (!gee_iterator_next (_base_type_it)) {
				break;
			}
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			_tmp0_ = FALSE;
			if (vala_data_type_get_data_type (base_type) != NULL) {
				_tmp0_ = vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (base_type), t);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_gee_collection_object_unref0 (_base_type_it);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_gee_collection_object_unref0 (_base_type_it);
	}
	result = FALSE;
	return result;
}


static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp1_;
				gboolean _tmp2_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < gee_collection_get_size ((GeeCollection*) self->priv->base_types))) {
					break;
				}
				if ((_tmp2_ = (_tmp1_ = (ValaDataType*) gee_list_get (self->priv->base_types, i)) == old_type, _vala_code_node_unref0 (_tmp1_), _tmp2_)) {
					gee_list_set (self->priv->base_types, i, new_type);
					return;
				}
			}
		}
	}
}


static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, GeeList* list) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _prereq_it;
		_prereq_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_interface_get_prerequisites (iface))), _gee_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaDataType* prereq;
			ValaTypeSymbol* type;
			if (!gee_iterator_next (_prereq_it)) {
				break;
			}
			prereq = (ValaDataType*) gee_iterator_get (_prereq_it);
			type = _vala_code_node_ref0 (vala_data_type_get_data_type (prereq));
			if (type == NULL) {
				_vala_code_node_unref0 (prereq);
				_vala_code_node_unref0 (type);
				continue;
			}
			gee_collection_add ((GeeCollection*) list, type);
			if (VALA_IS_INTERFACE (type)) {
				vala_class_get_all_prerequisites (self, VALA_INTERFACE (type), list);
			}
			_vala_code_node_unref0 (prereq);
			_vala_code_node_unref0 (type);
		}
		_gee_collection_object_unref0 (_prereq_it);
	}
}


static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (cl) == t) {
		result = TRUE;
		return result;
	}
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _base_type_it;
		_base_type_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_class_get_base_types (cl))), _gee_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaDataType* base_type;
			if (!gee_iterator_next (_base_type_it)) {
				break;
			}
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
				if (vala_class_class_is_a (self, VALA_CLASS (vala_data_type_get_data_type (base_type)), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_gee_collection_object_unref0 (_base_type_it);
					return result;
				}
			} else {
				if (vala_data_type_get_data_type (base_type) == t) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_gee_collection_object_unref0 (_base_type_it);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_gee_collection_object_unref0 (_base_type_it);
	}
	result = FALSE;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_class_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaClass * self;
	gboolean result;
	ValaSourceFile* old_source_file;
	ValaSymbol* old_symbol;
	GeeList* prerequisites;
	GeeList* missing_prereqs;
	self = (ValaClass*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_class_process_attributes (self);
	old_source_file = _vala_source_file_ref0 (vala_semantic_analyzer_get_current_source_file (analyzer));
	old_symbol = _vala_code_node_ref0 (vala_semantic_analyzer_get_current_symbol (analyzer));
	if (vala_code_node_get_source_reference ((ValaCodeNode*) self) != NULL) {
		vala_semantic_analyzer_set_current_source_file (analyzer, vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)));
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _base_type_reference_it;
		_base_type_reference_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_class_get_base_types (self))), _gee_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaDataType* base_type_reference;
			if (!gee_iterator_next (_base_type_reference_it)) {
				break;
			}
			base_type_reference = (ValaDataType*) gee_iterator_get (_base_type_reference_it);
			if (!vala_code_node_check ((ValaCodeNode*) base_type_reference, analyzer)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_gee_collection_object_unref0 (_base_type_reference_it);
				_vala_source_file_unref0 (old_source_file);
				_vala_code_node_unref0 (old_symbol);
				return result;
			}
			if (!VALA_IS_OBJECT_TYPE (base_type_reference)) {
				char* _tmp4_;
				char* _tmp3_;
				char* _tmp2_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp4_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp2_ = vala_code_node_to_string ((ValaCodeNode*) base_type_reference), _tmp3_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
				_g_free0 (_tmp4_);
				_g_free0 (_tmp3_);
				_g_free0 (_tmp2_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_gee_collection_object_unref0 (_base_type_reference_it);
				_vala_source_file_unref0 (old_source_file);
				_vala_code_node_unref0 (old_symbol);
				return result;
			}
			if (!vala_semantic_analyzer_is_type_accessible (analyzer, (ValaSymbol*) self, base_type_reference)) {
				char* _tmp7_;
				char* _tmp6_;
				char* _tmp5_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp7_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp5_ = vala_code_node_to_string ((ValaCodeNode*) base_type_reference), _tmp6_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
				_g_free0 (_tmp7_);
				_g_free0 (_tmp6_);
				_g_free0 (_tmp5_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_gee_collection_object_unref0 (_base_type_reference_it);
				_vala_source_file_unref0 (old_source_file);
				_vala_code_node_unref0 (old_symbol);
				return result;
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_gee_collection_object_unref0 (_base_type_reference_it);
	}
	{
		GeeIterator* _type_it;
		_type_it = gee_iterable_iterator ((GeeIterable*) self->priv->base_types);
		while (TRUE) {
			ValaDataType* type;
			if (!gee_iterator_next (_type_it)) {
				break;
			}
			type = (ValaDataType*) gee_iterator_get (_type_it);
			vala_code_node_check ((ValaCodeNode*) type, analyzer);
			_vala_code_node_unref0 (type);
		}
		_gee_collection_object_unref0 (_type_it);
	}
	{
		GeeList* _tmp8_;
		GeeIterator* _tmp9_;
		GeeIterator* _p_it;
		_p_it = (_tmp9_ = gee_iterable_iterator ((GeeIterable*) (_tmp8_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self))), _gee_collection_object_unref0 (_tmp8_), _tmp9_);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!gee_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) gee_iterator_get (_p_it);
			vala_code_node_check ((ValaCodeNode*) p, analyzer);
			_vala_code_node_unref0 (p);
		}
		_gee_collection_object_unref0 (_p_it);
	}
	{
		GeeIterator* _en_it;
		_en_it = gee_iterable_iterator ((GeeIterable*) self->priv->enums);
		while (TRUE) {
			ValaEnum* en;
			if (!gee_iterator_next (_en_it)) {
				break;
			}
			en = (ValaEnum*) gee_iterator_get (_en_it);
			vala_code_node_check ((ValaCodeNode*) en, analyzer);
			_vala_code_node_unref0 (en);
		}
		_gee_collection_object_unref0 (_en_it);
	}
	{
		GeeIterator* _f_it;
		_f_it = gee_iterable_iterator ((GeeIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			if (!gee_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) gee_iterator_get (_f_it);
			vala_code_node_check ((ValaCodeNode*) f, analyzer);
			_vala_code_node_unref0 (f);
		}
		_gee_collection_object_unref0 (_f_it);
	}
	{
		GeeIterator* _c_it;
		_c_it = gee_iterable_iterator ((GeeIterable*) self->priv->constants);
		while (TRUE) {
			ValaConstant* c;
			if (!gee_iterator_next (_c_it)) {
				break;
			}
			c = (ValaConstant*) gee_iterator_get (_c_it);
			vala_code_node_check ((ValaCodeNode*) c, analyzer);
			_vala_code_node_unref0 (c);
		}
		_gee_collection_object_unref0 (_c_it);
	}
	{
		GeeIterator* _m_it;
		_m_it = gee_iterable_iterator ((GeeIterable*) self->priv->methods);
		while (TRUE) {
			ValaMethod* m;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			vala_code_node_check ((ValaCodeNode*) m, analyzer);
			_vala_code_node_unref0 (m);
		}
		_gee_collection_object_unref0 (_m_it);
	}
	{
		GeeIterator* _prop_it;
		_prop_it = gee_iterable_iterator ((GeeIterable*) self->priv->properties);
		while (TRUE) {
			ValaProperty* prop;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			vala_code_node_check ((ValaCodeNode*) prop, analyzer);
			_vala_code_node_unref0 (prop);
		}
		_gee_collection_object_unref0 (_prop_it);
	}
	{
		GeeIterator* _sig_it;
		_sig_it = gee_iterable_iterator ((GeeIterable*) self->priv->signals);
		while (TRUE) {
			ValaSignal* sig;
			if (!gee_iterator_next (_sig_it)) {
				break;
			}
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			vala_code_node_check ((ValaCodeNode*) sig, analyzer);
			_vala_code_node_unref0 (sig);
		}
		_gee_collection_object_unref0 (_sig_it);
	}
	if (self->priv->_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_constructor, analyzer);
	}
	if (self->priv->_class_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_class_constructor, analyzer);
	}
	if (self->priv->_static_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_static_constructor, analyzer);
	}
	if (vala_class_get_destructor (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_class_get_destructor (self), analyzer);
	}
	if (self->priv->_static_destructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_static_destructor, analyzer);
	}
	if (self->priv->_class_destructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_class_destructor, analyzer);
	}
	{
		GeeIterator* _cl_it;
		_cl_it = gee_iterable_iterator ((GeeIterable*) self->priv->classes);
		while (TRUE) {
			ValaClass* cl;
			if (!gee_iterator_next (_cl_it)) {
				break;
			}
			cl = (ValaClass*) gee_iterator_get (_cl_it);
			vala_code_node_check ((ValaCodeNode*) cl, analyzer);
			_vala_code_node_unref0 (cl);
		}
		_gee_collection_object_unref0 (_cl_it);
	}
	{
		GeeIterator* _st_it;
		_st_it = gee_iterable_iterator ((GeeIterable*) self->priv->structs);
		while (TRUE) {
			ValaStruct* st;
			if (!gee_iterator_next (_st_it)) {
				break;
			}
			st = (ValaStruct*) gee_iterator_get (_st_it);
			vala_code_node_check ((ValaCodeNode*) st, analyzer);
			_vala_code_node_unref0 (st);
		}
		_gee_collection_object_unref0 (_st_it);
	}
	{
		GeeIterator* _d_it;
		_d_it = gee_iterable_iterator ((GeeIterable*) self->priv->delegates);
		while (TRUE) {
			ValaDelegate* d;
			if (!gee_iterator_next (_d_it)) {
				break;
			}
			d = (ValaDelegate*) gee_iterator_get (_d_it);
			vala_code_node_check ((ValaCodeNode*) d, analyzer);
			_vala_code_node_unref0 (d);
		}
		_gee_collection_object_unref0 (_d_it);
	}
	if (vala_class_get_is_compact (self)) {
		gboolean _tmp14_;
		gboolean _tmp15_;
		{
			GeeList* _tmp10_;
			GeeIterator* _tmp11_;
			GeeIterator* _base_type_it;
			_base_type_it = (_tmp11_ = gee_iterable_iterator ((GeeIterable*) (_tmp10_ = vala_class_get_base_types (self))), _gee_collection_object_unref0 (_tmp10_), _tmp11_);
			while (TRUE) {
				ValaDataType* base_type;
				if (!gee_iterator_next (_base_type_it)) {
					break;
				}
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					char* _tmp13_;
					char* _tmp12_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp13_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp12_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
					_g_free0 (_tmp13_);
					_g_free0 (_tmp12_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_gee_collection_object_unref0 (_base_type_it);
		}
		_tmp14_ = FALSE;
		_tmp15_ = FALSE;
		if (!vala_symbol_get_external ((ValaSymbol*) self)) {
			_tmp15_ = !vala_symbol_get_external_package ((ValaSymbol*) self);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			_tmp14_ = self->priv->_base_class != NULL;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			{
				GeeIterator* _f_it;
				_f_it = gee_iterable_iterator ((GeeIterable*) self->priv->fields);
				while (TRUE) {
					ValaField* f;
					if (!gee_iterator_next (_f_it)) {
						break;
					}
					f = (ValaField*) gee_iterator_get (_f_it);
					if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "derived compact classes may not have instance fields");
					}
					_vala_code_node_unref0 (f);
				}
				_gee_collection_object_unref0 (_f_it);
			}
		}
	}
	prerequisites = (GeeList*) gee_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	{
		GeeList* _tmp16_;
		GeeIterator* _tmp17_;
		GeeIterator* _base_type_it;
		_base_type_it = (_tmp17_ = gee_iterable_iterator ((GeeIterable*) (_tmp16_ = vala_class_get_base_types (self))), _gee_collection_object_unref0 (_tmp16_), _tmp17_);
		while (TRUE) {
			ValaDataType* base_type;
			if (!gee_iterator_next (_base_type_it)) {
				break;
			}
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
				vala_class_get_all_prerequisites (self, VALA_INTERFACE (vala_data_type_get_data_type (base_type)), prerequisites);
			}
			_vala_code_node_unref0 (base_type);
		}
		_gee_collection_object_unref0 (_base_type_it);
	}
	missing_prereqs = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	{
		GeeIterator* _prereq_it;
		_prereq_it = gee_iterable_iterator ((GeeIterable*) prerequisites);
		while (TRUE) {
			ValaTypeSymbol* prereq;
			if (!gee_iterator_next (_prereq_it)) {
				break;
			}
			prereq = (ValaTypeSymbol*) gee_iterator_get (_prereq_it);
			if (!vala_class_class_is_a (self, self, prereq)) {
				char* _tmp18_;
				gee_list_insert (missing_prereqs, 0, _tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) prereq));
				_g_free0 (_tmp18_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_gee_collection_object_unref0 (_prereq_it);
	}
	if (gee_collection_get_size ((GeeCollection*) missing_prereqs) > 0) {
		char* _tmp19_;
		char* _tmp20_;
		char* error_string;
		gboolean first;
		char* _tmp23_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		error_string = (_tmp20_ = g_strdup_printf ("%s: some prerequisites (", _tmp19_ = vala_symbol_get_full_name ((ValaSymbol*) self)), _g_free0 (_tmp19_), _tmp20_);
		first = TRUE;
		{
			GeeIterator* _s_it;
			_s_it = gee_iterable_iterator ((GeeIterable*) missing_prereqs);
			while (TRUE) {
				char* s;
				if (!gee_iterator_next (_s_it)) {
					break;
				}
				s = (char*) gee_iterator_get (_s_it);
				if (first) {
					char* _tmp21_;
					error_string = (_tmp21_ = g_strdup_printf ("%s`%s'", error_string, s), _g_free0 (error_string), _tmp21_);
					first = FALSE;
				} else {
					char* _tmp22_;
					error_string = (_tmp22_ = g_strdup_printf ("%s, `%s'", error_string, s), _g_free0 (error_string), _tmp22_);
				}
				_g_free0 (s);
			}
			_gee_collection_object_unref0 (_s_it);
		}
		error_string = (_tmp23_ = g_strconcat (error_string, ") are not met", NULL), _g_free0 (error_string), _tmp23_);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), error_string);
		_g_free0 (error_string);
	}
	if (!vala_symbol_get_external_package ((ValaSymbol*) self)) {
		{
			GeeList* _tmp24_;
			GeeIterator* _tmp25_;
			GeeIterator* _base_type_it;
			_base_type_it = (_tmp25_ = gee_iterable_iterator ((GeeIterable*) (_tmp24_ = vala_class_get_base_types (self))), _gee_collection_object_unref0 (_tmp24_), _tmp25_);
			while (TRUE) {
				ValaDataType* base_type;
				if (!gee_iterator_next (_base_type_it)) {
					break;
				}
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					ValaInterface* iface;
					gboolean _tmp26_;
					iface = _vala_code_node_ref0 (VALA_INTERFACE (vala_data_type_get_data_type (base_type)));
					_tmp26_ = FALSE;
					if (self->priv->_base_class != NULL) {
						_tmp26_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self->priv->_base_class, (ValaTypeSymbol*) iface);
					} else {
						_tmp26_ = FALSE;
					}
					if (_tmp26_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						GeeList* _tmp27_;
						GeeIterator* _tmp28_;
						GeeIterator* _m_it;
						_m_it = (_tmp28_ = gee_iterable_iterator ((GeeIterable*) (_tmp27_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), _gee_collection_object_unref0 (_tmp27_), _tmp28_);
						while (TRUE) {
							ValaMethod* m;
							if (!gee_iterator_next (_m_it)) {
								break;
							}
							m = (ValaMethod*) gee_iterator_get (_m_it);
							if (vala_method_get_is_abstract (m)) {
								ValaSymbol* sym;
								ValaClass* base_class;
								sym = NULL;
								base_class = _vala_code_node_ref0 (self);
								while (TRUE) {
									gboolean _tmp29_;
									ValaSymbol* _tmp30_;
									ValaClass* _tmp31_;
									_tmp29_ = FALSE;
									if (base_class != NULL) {
										_tmp29_ = !VALA_IS_METHOD (sym);
									} else {
										_tmp29_ = FALSE;
									}
									if (!_tmp29_) {
										break;
									}
									sym = (_tmp30_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) base_class), vala_symbol_get_name ((ValaSymbol*) m)), _vala_code_node_unref0 (sym), _tmp30_);
									base_class = (_tmp31_ = _vala_code_node_ref0 (base_class->priv->_base_class), _vala_code_node_unref0 (base_class), _tmp31_);
								}
								if (VALA_IS_METHOD (sym)) {
									vala_symbol_set_used (sym, TRUE);
								} else {
									char* _tmp34_;
									char* _tmp33_;
									char* _tmp32_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp34_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp33_ = vala_symbol_get_full_name ((ValaSymbol*) m)));
									_g_free0 (_tmp34_);
									_g_free0 (_tmp33_);
									_g_free0 (_tmp32_);
								}
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (m);
						}
						_gee_collection_object_unref0 (_m_it);
					}
					{
						GeeList* _tmp35_;
						GeeIterator* _tmp36_;
						GeeIterator* _prop_it;
						_prop_it = (_tmp36_ = gee_iterable_iterator ((GeeIterable*) (_tmp35_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface))), _gee_collection_object_unref0 (_tmp35_), _tmp36_);
						while (TRUE) {
							ValaProperty* prop;
							if (!gee_iterator_next (_prop_it)) {
								break;
							}
							prop = (ValaProperty*) gee_iterator_get (_prop_it);
							if (vala_property_get_is_abstract (prop)) {
								ValaSymbol* sym;
								ValaClass* base_class;
								sym = NULL;
								base_class = _vala_code_node_ref0 (self);
								while (TRUE) {
									gboolean _tmp37_;
									ValaSymbol* _tmp38_;
									ValaClass* _tmp39_;
									_tmp37_ = FALSE;
									if (base_class != NULL) {
										_tmp37_ = !VALA_IS_PROPERTY (sym);
									} else {
										_tmp37_ = FALSE;
									}
									if (!_tmp37_) {
										break;
									}
									sym = (_tmp38_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) base_class), vala_symbol_get_name ((ValaSymbol*) prop)), _vala_code_node_unref0 (sym), _tmp38_);
									base_class = (_tmp39_ = _vala_code_node_ref0 (base_class->priv->_base_class), _vala_code_node_unref0 (base_class), _tmp39_);
								}
								if (VALA_IS_PROPERTY (sym)) {
									vala_symbol_set_used (sym, TRUE);
								} else {
									char* _tmp42_;
									char* _tmp41_;
									char* _tmp40_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp42_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) prop)));
									_g_free0 (_tmp42_);
									_g_free0 (_tmp41_);
									_g_free0 (_tmp40_);
								}
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (prop);
						}
						_gee_collection_object_unref0 (_prop_it);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_gee_collection_object_unref0 (_base_type_it);
		}
		if (!self->priv->_is_abstract) {
			ValaClass* base_class;
			base_class = _vala_code_node_ref0 (self->priv->_base_class);
			while (TRUE) {
				gboolean _tmp43_;
				ValaClass* _tmp58_;
				_tmp43_ = FALSE;
				if (base_class != NULL) {
					_tmp43_ = base_class->priv->_is_abstract;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				{
					GeeList* _tmp44_;
					GeeIterator* _tmp45_;
					GeeIterator* _base_method_it;
					_base_method_it = (_tmp45_ = gee_iterable_iterator ((GeeIterable*) (_tmp44_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) base_class))), _gee_collection_object_unref0 (_tmp44_), _tmp45_);
					while (TRUE) {
						ValaMethod* base_method;
						if (!gee_iterator_next (_base_method_it)) {
							break;
						}
						base_method = (ValaMethod*) gee_iterator_get (_base_method_it);
						if (vala_method_get_is_abstract (base_method)) {
							ValaSymbol* _tmp46_;
							ValaMethod* override_method;
							gboolean _tmp47_;
							override_method = (_tmp46_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, vala_symbol_get_name ((ValaSymbol*) base_method)), VALA_IS_METHOD (_tmp46_) ? ((ValaMethod*) _tmp46_) : NULL);
							_tmp47_ = FALSE;
							if (override_method == NULL) {
								_tmp47_ = TRUE;
							} else {
								_tmp47_ = !vala_method_get_overrides (override_method);
							}
							if (_tmp47_) {
								char* _tmp50_;
								char* _tmp49_;
								char* _tmp48_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp50_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp48_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp49_ = vala_symbol_get_full_name ((ValaSymbol*) base_method)));
								_g_free0 (_tmp50_);
								_g_free0 (_tmp49_);
								_g_free0 (_tmp48_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_gee_collection_object_unref0 (_base_method_it);
				}
				{
					GeeList* _tmp51_;
					GeeIterator* _tmp52_;
					GeeIterator* _base_property_it;
					_base_property_it = (_tmp52_ = gee_iterable_iterator ((GeeIterable*) (_tmp51_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) base_class))), _gee_collection_object_unref0 (_tmp51_), _tmp52_);
					while (TRUE) {
						ValaProperty* base_property;
						if (!gee_iterator_next (_base_property_it)) {
							break;
						}
						base_property = (ValaProperty*) gee_iterator_get (_base_property_it);
						if (vala_property_get_is_abstract (base_property)) {
							ValaSymbol* _tmp53_;
							ValaProperty* override_property;
							gboolean _tmp54_;
							override_property = (_tmp53_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, vala_symbol_get_name ((ValaSymbol*) base_property)), VALA_IS_PROPERTY (_tmp53_) ? ((ValaProperty*) _tmp53_) : NULL);
							_tmp54_ = FALSE;
							if (override_property == NULL) {
								_tmp54_ = TRUE;
							} else {
								_tmp54_ = !vala_property_get_overrides (override_property);
							}
							if (_tmp54_) {
								char* _tmp57_;
								char* _tmp56_;
								char* _tmp55_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp57_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp55_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp56_ = vala_symbol_get_full_name ((ValaSymbol*) base_property)));
								_g_free0 (_tmp57_);
								_g_free0 (_tmp56_);
								_g_free0 (_tmp55_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_gee_collection_object_unref0 (_base_property_it);
				}
				base_class = (_tmp58_ = _vala_code_node_ref0 (base_class->priv->_base_class), _vala_code_node_unref0 (base_class), _tmp58_);
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	_vala_source_file_unref0 (old_source_file);
	_vala_code_node_unref0 (old_symbol);
	_gee_collection_object_unref0 (prerequisites);
	_gee_collection_object_unref0 (missing_prereqs);
	return result;
}


ValaClass* vala_class_get_base_class (ValaClass* self) {
	ValaClass* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_base_class;
	return result;
}


void vala_class_set_base_class (ValaClass* self, ValaClass* value) {
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_base_class = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_base_class), _tmp0_);
}


gboolean vala_class_get_is_abstract (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}


void vala_class_set_is_abstract (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean vala_class_get_is_compact (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		result = vala_class_get_is_compact (self->priv->_base_class);
		return result;
	}
	result = self->priv->_is_compact;
	return result;
}


void vala_class_set_is_compact (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_compact = value;
}


gboolean vala_class_get_is_immutable (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		result = vala_class_get_is_immutable (self->priv->_base_class);
		return result;
	}
	result = self->priv->_is_immutable;
	return result;
}


void vala_class_set_is_immutable (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_immutable = value;
}


gboolean vala_class_get_ref_function_void (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		result = vala_class_get_ref_function_void (self->priv->_base_class);
		return result;
	}
	result = self->priv->_ref_function_void;
	return result;
}


void vala_class_set_ref_function_void (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_ref_function_void = value;
}


const char* vala_class_get_type_check_function (ValaClass* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_type_check_function;
	return result;
}


void vala_class_set_type_check_function (ValaClass* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_type_check_function = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_type_check_function), _tmp0_);
}


gboolean vala_class_get_has_private_fields (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}


static void vala_class_set_has_private_fields (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}


gboolean vala_class_get_has_class_private_fields (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}


static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}


gboolean vala_class_get_free_function_address_of (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_free_function_address_of;
	return result;
}


static void vala_class_set_free_function_address_of (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_free_function_address_of = value;
}


ValaMethod* vala_class_get_default_construction_method (ValaClass* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_default_construction_method;
	return result;
}


void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_default_construction_method = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_default_construction_method), _tmp0_);
}


ValaConstructor* vala_class_get_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_constructor;
	return result;
}


void vala_class_set_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_constructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_constructor), _tmp0_);
}


ValaConstructor* vala_class_get_class_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_class_constructor;
	return result;
}


void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_class_constructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_class_constructor), _tmp0_);
}


ValaConstructor* vala_class_get_static_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_static_constructor;
	return result;
}


void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_static_constructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_static_constructor), _tmp0_);
}


ValaDestructor* vala_class_get_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_destructor;
	return result;
}


void vala_class_set_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_destructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_destructor), _tmp0_);
	if (self->priv->_destructor != NULL) {
		ValaFormalParameter* _tmp2_;
		ValaObjectType* _tmp1_;
		if (vala_destructor_get_this_parameter (self->priv->_destructor) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) self->priv->_destructor), vala_symbol_get_name ((ValaSymbol*) vala_destructor_get_this_parameter (self->priv->_destructor)));
		}
		vala_destructor_set_this_parameter (self->priv->_destructor, _tmp2_ = vala_formal_parameter_new ("this", (ValaDataType*) (_tmp1_ = vala_class_get_this_type (self)), NULL));
		_vala_code_node_unref0 (_tmp2_);
		_vala_code_node_unref0 (_tmp1_);
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self->priv->_destructor), vala_symbol_get_name ((ValaSymbol*) vala_destructor_get_this_parameter (self->priv->_destructor)), (ValaSymbol*) vala_destructor_get_this_parameter (self->priv->_destructor));
	}
}


ValaDestructor* vala_class_get_static_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_static_destructor;
	return result;
}


void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_static_destructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_static_destructor), _tmp0_);
}


ValaDestructor* vala_class_get_class_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_class_destructor;
	return result;
}


void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_class_destructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_class_destructor), _tmp0_);
}


gboolean vala_class_get_is_error_base (ValaClass* self) {
	gboolean result;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (_tmp1_ = (_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase")) != NULL, _vala_code_node_unref0 (_tmp0_), _tmp1_);
	return result;
}


static void vala_class_class_init (ValaClassClass * klass) {
	vala_class_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_methods = vala_class_real_get_methods;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_properties = vala_class_real_get_properties;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_signals = vala_class_real_get_signals;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_class_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_class_real_accept_children;
	VALA_SYMBOL_CLASS (klass)->get_cprefix = vala_class_real_get_cprefix;
	VALA_TYPESYMBOL_CLASS (klass)->get_cname = vala_class_real_get_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_class_real_get_lower_case_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_class_real_get_lower_case_cprefix;
	VALA_TYPESYMBOL_CLASS (klass)->get_upper_case_cname = vala_class_real_get_upper_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_signature = vala_class_real_get_type_signature;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_type = vala_class_real_is_reference_type;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_id = vala_class_real_get_type_id;
	VALA_TYPESYMBOL_CLASS (klass)->get_marshaller_type_name = vala_class_real_get_marshaller_type_name;
	VALA_TYPESYMBOL_CLASS (klass)->get_param_spec_function = vala_class_real_get_param_spec_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_get_value_function = vala_class_real_get_get_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_set_value_function = vala_class_real_get_set_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_counting = vala_class_real_is_reference_counting;
	VALA_TYPESYMBOL_CLASS (klass)->get_ref_function = vala_class_real_get_ref_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_unref_function = vala_class_real_get_unref_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_ref_sink_function = vala_class_real_get_ref_sink_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_dup_function = vala_class_real_get_dup_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_free_function = vala_class_real_get_free_function;
	VALA_TYPESYMBOL_CLASS (klass)->is_subtype_of = vala_class_real_is_subtype_of;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_class_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_class_real_check;
}


static void vala_class_instance_init (ValaClass * self) {
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	self->priv->base_types = (GeeList*) gee_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->constants = (GeeList*) gee_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->fields = (GeeList*) gee_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->methods = (GeeList*) gee_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->properties = (GeeList*) gee_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->signals = (GeeList*) gee_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->classes = (GeeList*) gee_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->structs = (GeeList*) gee_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->enums = (GeeList*) gee_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->delegates = (GeeList*) gee_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_class_finalize (ValaCodeNode* obj) {
	ValaClass * self;
	self = VALA_CLASS (obj);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_type_check_function);
	_g_free0 (self->priv->cname);
	_g_free0 (self->priv->const_cname);
	_g_free0 (self->priv->lower_case_cprefix);
	_g_free0 (self->priv->lower_case_csuffix);
	_g_free0 (self->priv->type_id);
	_g_free0 (self->priv->ref_function);
	_g_free0 (self->priv->unref_function);
	_g_free0 (self->priv->ref_sink_function);
	_g_free0 (self->priv->param_spec_function);
	_g_free0 (self->priv->copy_function);
	_g_free0 (self->priv->free_function);
	_g_free0 (self->priv->marshaller_type_name);
	_g_free0 (self->priv->get_value_function);
	_g_free0 (self->priv->set_value_function);
	_g_free0 (self->priv->type_signature);
	_gee_collection_object_unref0 (self->priv->base_types);
	_gee_collection_object_unref0 (self->priv->constants);
	_gee_collection_object_unref0 (self->priv->fields);
	_gee_collection_object_unref0 (self->priv->methods);
	_gee_collection_object_unref0 (self->priv->properties);
	_gee_collection_object_unref0 (self->priv->signals);
	_gee_collection_object_unref0 (self->priv->classes);
	_gee_collection_object_unref0 (self->priv->structs);
	_gee_collection_object_unref0 (self->priv->enums);
	_gee_collection_object_unref0 (self->priv->delegates);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


GType vala_class_get_type (void) {
	static GType vala_class_type_id = 0;
	if (vala_class_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	}
	return vala_class_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




