/* arraylist.c generated by valac, the Vala compiler
 * generated from arraylist.vala, do not modify */

/* arraylist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_COLLECTION_OBJECT (gee_collection_object_get_type ())
#define GEE_COLLECTION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION_OBJECT, GeeCollectionObject))
#define GEE_COLLECTION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_COLLECTION_OBJECT, GeeCollectionObjectClass))
#define GEE_IS_COLLECTION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION_OBJECT))
#define GEE_IS_COLLECTION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_COLLECTION_OBJECT))
#define GEE_COLLECTION_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_COLLECTION_OBJECT, GeeCollectionObjectClass))

typedef struct _GeeCollectionObject GeeCollectionObject;
typedef struct _GeeCollectionObjectClass GeeCollectionObjectClass;
typedef struct _GeeCollectionObjectPrivate GeeCollectionObjectPrivate;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
typedef struct _GeeArrayListPrivate GeeArrayListPrivate;

#define GEE_ARRAY_LIST_TYPE_ITERATOR (gee_array_list_iterator_get_type ())
#define GEE_ARRAY_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIterator))
#define GEE_ARRAY_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorClass))
#define GEE_ARRAY_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR))
#define GEE_ARRAY_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_ARRAY_LIST_TYPE_ITERATOR))
#define GEE_ARRAY_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorClass))

typedef struct _GeeArrayListIterator GeeArrayListIterator;
typedef struct _GeeArrayListIteratorClass GeeArrayListIteratorClass;
typedef struct _GeeArrayListIteratorPrivate GeeArrayListIteratorPrivate;
#define _gee_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (gee_collection_object_unref (var), NULL)))

struct _GeeCollectionObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeCollectionObjectPrivate * priv;
};

struct _GeeCollectionObjectClass {
	GTypeClass parent_class;
	void (*finalize) (GeeCollectionObject *self);
};

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_element_type) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gint (*get_size) (GeeCollection* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	void (*remove_at) (GeeList* self, gint index);
};

struct _GeeArrayList {
	GeeCollectionObject parent_instance;
	GeeArrayListPrivate * priv;
};

struct _GeeArrayListClass {
	GeeCollectionObjectClass parent_class;
};

struct _GeeArrayListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gpointer* _items;
	gint _items_length1;
	gint _items_size;
	gint _size;
	GEqualFunc _equal_func;
	gint _stamp;
};

struct _GeeArrayListIterator {
	GeeCollectionObject parent_instance;
	GeeArrayListIteratorPrivate * priv;
	gint _stamp;
};

struct _GeeArrayListIteratorClass {
	GeeCollectionObjectClass parent_class;
};

struct _GeeArrayListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeArrayList* _list;
	gint _index;
};


static gpointer gee_array_list_iterator_parent_class = NULL;
static GeeIteratorIface* gee_array_list_iterator_gee_iterator_parent_iface = NULL;
static gpointer gee_array_list_parent_class = NULL;
static GeeIterableIface* gee_array_list_gee_iterable_parent_iface = NULL;
static GeeCollectionIface* gee_array_list_gee_collection_parent_iface = NULL;
static GeeListIface* gee_array_list_gee_list_parent_iface = NULL;

gpointer gee_collection_object_ref (gpointer instance);
void gee_collection_object_unref (gpointer instance);
GParamSpec* gee_param_spec_collection_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_collection_object (GValue* value, gpointer v_object);
gpointer gee_value_get_collection_object (const GValue* value);
GType gee_collection_object_get_type (void);
GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_list_get_type (void);
GType gee_array_list_get_type (void);
#define GEE_ARRAY_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ARRAY_LIST, GeeArrayListPrivate))
enum  {
	GEE_ARRAY_LIST_DUMMY_PROPERTY
};
GeeCollectionObject* gee_collection_object_new (void);
GeeCollectionObject* gee_collection_object_construct (GType object_type);
void gee_array_list_set_equal_func (GeeArrayList* self, GEqualFunc value);
GeeArrayList* gee_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeArrayList* gee_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
static GType gee_array_list_real_get_element_type (GeeIterable* base);
static GeeArrayListIterator* gee_array_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list);
static GeeArrayListIterator* gee_array_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list);
static GType gee_array_list_iterator_get_type (void);
static GeeIterator* gee_array_list_real_iterator (GeeIterable* base);
gint gee_list_index_of (GeeList* self, gconstpointer item);
static gboolean gee_array_list_real_contains (GeeCollection* base, gconstpointer item);
static gint gee_array_list_real_index_of (GeeList* base, gconstpointer item);
static gpointer gee_array_list_real_get (GeeList* base, gint index);
static void gee_array_list_real_set (GeeList* base, gint index, gconstpointer item);
static void gee_array_list_grow_if_needed (GeeArrayList* self, gint new_count);
static gboolean gee_array_list_real_add (GeeCollection* base, gconstpointer item);
static void gee_array_list_shift (GeeArrayList* self, gint start, gint delta);
static void gee_array_list_real_insert (GeeList* base, gint index, gconstpointer item);
void gee_list_remove_at (GeeList* self, gint index);
static gboolean gee_array_list_real_remove (GeeCollection* base, gconstpointer item);
static void gee_array_list_real_remove_at (GeeList* base, gint index);
static void gee_array_list_real_clear (GeeCollection* base);
static void gee_array_list_set_capacity (GeeArrayList* self, gint value);
#define GEE_ARRAY_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorPrivate))
enum  {
	GEE_ARRAY_LIST_ITERATOR_DUMMY_PROPERTY
};
static void gee_array_list_iterator_set_list (GeeArrayListIterator* self, GeeArrayList* value);
static gboolean gee_array_list_iterator_real_next (GeeIterator* base);
gpointer gee_list_get (GeeList* self, gint index);
static gpointer gee_array_list_iterator_real_get (GeeIterator* base);
static void gee_array_list_iterator_finalize (GeeCollectionObject* obj);
static void gee_array_list_finalize (GeeCollectionObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);



GeeArrayList* gee_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	GeeArrayList* self;
	self = (GeeArrayList*) gee_collection_object_construct (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	gee_array_list_set_equal_func (self, equal_func);
	return self;
}


GeeArrayList* gee_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	return gee_array_list_construct (GEE_TYPE_ARRAY_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
}


static GType gee_array_list_real_get_element_type (GeeIterable* base) {
	GeeArrayList * self;
	GType result;
	self = (GeeArrayList*) base;
	result = self->priv->g_type;
	return result;
}


static GeeIterator* gee_array_list_real_iterator (GeeIterable* base) {
	GeeArrayList * self;
	GeeIterator* result;
	self = (GeeArrayList*) base;
	result = (GeeIterator*) gee_array_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	return result;
}


static gboolean gee_array_list_real_contains (GeeCollection* base, gconstpointer item) {
	GeeArrayList * self;
	gboolean result;
	self = (GeeArrayList*) base;
	result = gee_list_index_of ((GeeList*) self, item) != (-1);
	return result;
}


static gint gee_array_list_real_index_of (GeeList* base, gconstpointer item) {
	GeeArrayList * self;
	gint result;
	self = (GeeArrayList*) base;
	{
		gint index;
		index = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					index++;
				}
				_tmp0_ = FALSE;
				if (!(index < self->priv->_size)) {
					break;
				}
				if (self->priv->_equal_func (self->priv->_items[index], item)) {
					result = index;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


static gpointer gee_array_list_real_get (GeeList* base, gint index) {
	GeeArrayList * self;
	gpointer result;
	gboolean _tmp0_ = FALSE;
	gconstpointer _tmp1_;
	self = (GeeArrayList*) base;
	if (index >= 0) {
		_tmp0_ = index < self->priv->_size;
	} else {
		_tmp0_ = FALSE;
	}
	g_assert (_tmp0_);
	result = (_tmp1_ = self->priv->_items[index], ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
	return result;
}


static void gee_array_list_real_set (GeeList* base, gint index, gconstpointer item) {
	GeeArrayList * self;
	gboolean _tmp0_ = FALSE;
	gpointer _tmp2_;
	gconstpointer _tmp1_;
	self = (GeeArrayList*) base;
	if (index >= 0) {
		_tmp0_ = index < self->priv->_size;
	} else {
		_tmp0_ = FALSE;
	}
	g_assert (_tmp0_);
	self->priv->_items[index] = (_tmp2_ = (_tmp1_ = item, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_)), ((self->priv->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_items[index] = (self->priv->g_destroy_func (self->priv->_items[index]), NULL)), _tmp2_);
}


static gboolean gee_array_list_real_add (GeeCollection* base, gconstpointer item) {
	GeeArrayList * self;
	gboolean result;
	gpointer _tmp2_;
	gpointer *_tmp1_;
	gconstpointer _tmp0_;
	self = (GeeArrayList*) base;
	if (self->priv->_size == self->priv->_items_length1) {
		gee_array_list_grow_if_needed (self, 1);
	}
	_tmp1_ = &self->priv->_items[self->priv->_size++];
	(*_tmp1_) = (_tmp2_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), (((*_tmp1_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp1_) = (self->priv->g_destroy_func ((*_tmp1_)), NULL)), _tmp2_);
	self->priv->_stamp++;
	result = TRUE;
	return result;
}


static void gee_array_list_real_insert (GeeList* base, gint index, gconstpointer item) {
	GeeArrayList * self;
	gboolean _tmp0_ = FALSE;
	gpointer _tmp2_;
	gconstpointer _tmp1_;
	self = (GeeArrayList*) base;
	if (index >= 0) {
		_tmp0_ = index <= self->priv->_size;
	} else {
		_tmp0_ = FALSE;
	}
	g_assert (_tmp0_);
	if (self->priv->_size == self->priv->_items_length1) {
		gee_array_list_grow_if_needed (self, 1);
	}
	gee_array_list_shift (self, index, 1);
	self->priv->_items[index] = (_tmp2_ = (_tmp1_ = item, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_)), ((self->priv->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_items[index] = (self->priv->g_destroy_func (self->priv->_items[index]), NULL)), _tmp2_);
	self->priv->_stamp++;
}


static gboolean gee_array_list_real_remove (GeeCollection* base, gconstpointer item) {
	GeeArrayList * self;
	gboolean result;
	self = (GeeArrayList*) base;
	{
		gint index;
		index = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					index++;
				}
				_tmp0_ = FALSE;
				if (!(index < self->priv->_size)) {
					break;
				}
				if (self->priv->_equal_func (self->priv->_items[index], item)) {
					gee_list_remove_at ((GeeList*) self, index);
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void gee_array_list_real_remove_at (GeeList* base, gint index) {
	GeeArrayList * self;
	gboolean _tmp0_ = FALSE;
	gpointer _tmp1_;
	self = (GeeArrayList*) base;
	if (index >= 0) {
		_tmp0_ = index < self->priv->_size;
	} else {
		_tmp0_ = FALSE;
	}
	g_assert (_tmp0_);
	self->priv->_items[index] = (_tmp1_ = NULL, ((self->priv->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_items[index] = (self->priv->g_destroy_func (self->priv->_items[index]), NULL)), _tmp1_);
	gee_array_list_shift (self, index + 1, -1);
	self->priv->_stamp++;
}


static void gee_array_list_real_clear (GeeCollection* base) {
	GeeArrayList * self;
	self = (GeeArrayList*) base;
	{
		gint index;
		index = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer _tmp1_;
				if (!_tmp0_) {
					index++;
				}
				_tmp0_ = FALSE;
				if (!(index < self->priv->_size)) {
					break;
				}
				self->priv->_items[index] = (_tmp1_ = NULL, ((self->priv->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_items[index] = (self->priv->g_destroy_func (self->priv->_items[index]), NULL)), _tmp1_);
			}
		}
	}
	self->priv->_size = 0;
	self->priv->_stamp++;
}


static void gee_array_list_shift (GeeArrayList* self, gint start, gint delta) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (start >= 0) {
		_tmp1_ = start <= self->priv->_size;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = start >= (-delta);
	} else {
		_tmp0_ = FALSE;
	}
	g_assert (_tmp0_);
	_vala_array_move (self->priv->_items, sizeof (gpointer), start, start + delta, self->priv->_size - start);
	self->priv->_size = self->priv->_size + delta;
}


static void gee_array_list_grow_if_needed (GeeArrayList* self, gint new_count) {
	gint minimum_size;
	g_return_if_fail (self != NULL);
	g_assert (new_count >= 0);
	minimum_size = self->priv->_size + new_count;
	if (minimum_size > self->priv->_items_length1) {
		gint _tmp0_ = 0;
		if (new_count > self->priv->_items_length1) {
			_tmp0_ = minimum_size;
		} else {
			_tmp0_ = 2 * self->priv->_items_length1;
		}
		gee_array_list_set_capacity (self, _tmp0_);
	}
}


static void gee_array_list_set_capacity (GeeArrayList* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_assert (value >= self->priv->_size);
	_tmp0_ = value;
	self->priv->_items = g_renew (gpointer, self->priv->_items, value);
	(_tmp0_ > self->priv->_items_length1) ? memset (self->priv->_items + self->priv->_items_length1, 0, sizeof (gpointer) * (_tmp0_ - self->priv->_items_length1)) : NULL;
	self->priv->_items_length1 = _tmp0_;
}


static gint gee_array_list_real_get_size (GeeCollection* base) {
	gint result;
	GeeArrayList* self;
	self = (GeeArrayList*) base;
	result = self->priv->_size;
	return result;
}


void gee_array_list_set_equal_func (GeeArrayList* self, GEqualFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_equal_func = value;
}


static GeeArrayListIterator* gee_array_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list) {
	GeeArrayListIterator* self;
	g_return_val_if_fail (list != NULL, NULL);
	self = (GeeArrayListIterator*) gee_collection_object_construct (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	gee_array_list_iterator_set_list (self, list);
	return self;
}


static GeeArrayListIterator* gee_array_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list) {
	return gee_array_list_iterator_construct (GEE_ARRAY_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
}


static gboolean gee_array_list_iterator_real_next (GeeIterator* base) {
	GeeArrayListIterator * self;
	gboolean result;
	self = (GeeArrayListIterator*) base;
	g_assert (self->_stamp == self->priv->_list->priv->_stamp);
	if (self->priv->_index < self->priv->_list->priv->_size) {
		self->priv->_index++;
	}
	result = self->priv->_index < self->priv->_list->priv->_size;
	return result;
}


static gpointer gee_array_list_iterator_real_get (GeeIterator* base) {
	GeeArrayListIterator * self;
	gpointer result;
	gboolean _tmp0_ = FALSE;
	self = (GeeArrayListIterator*) base;
	g_assert (self->_stamp == self->priv->_list->priv->_stamp);
	if (self->priv->_index < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_index >= self->priv->_list->priv->_size;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	result = gee_list_get ((GeeList*) self->priv->_list, self->priv->_index);
	return result;
}


static gpointer _gee_collection_object_ref0 (gpointer self) {
	return self ? gee_collection_object_ref (self) : NULL;
}


static void gee_array_list_iterator_set_list (GeeArrayListIterator* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_list = (_tmp0_ = _gee_collection_object_ref0 (value), _gee_collection_object_unref0 (self->priv->_list), _tmp0_);
	self->_stamp = self->priv->_list->priv->_stamp;
}


static void gee_array_list_iterator_class_init (GeeArrayListIteratorClass * klass) {
	gee_array_list_iterator_parent_class = g_type_class_peek_parent (klass);
	GEE_COLLECTION_OBJECT_CLASS (klass)->finalize = gee_array_list_iterator_finalize;
	g_type_class_add_private (klass, sizeof (GeeArrayListIteratorPrivate));
}


static void gee_array_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_array_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_array_list_iterator_real_next;
	iface->get = gee_array_list_iterator_real_get;
}


static void gee_array_list_iterator_instance_init (GeeArrayListIterator * self) {
	self->priv = GEE_ARRAY_LIST_ITERATOR_GET_PRIVATE (self);
	self->priv->_index = -1;
	self->_stamp = 0;
}


static void gee_array_list_iterator_finalize (GeeCollectionObject* obj) {
	GeeArrayListIterator * self;
	self = GEE_ARRAY_LIST_ITERATOR (obj);
	_gee_collection_object_unref0 (self->priv->_list);
	GEE_COLLECTION_OBJECT_CLASS (gee_array_list_iterator_parent_class)->finalize (obj);
}


static GType gee_array_list_iterator_get_type (void) {
	static GType gee_array_list_iterator_type_id = 0;
	if (gee_array_list_iterator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayListIterator), 0, (GInstanceInitFunc) gee_array_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_array_list_iterator_type_id = g_type_register_static (GEE_TYPE_COLLECTION_OBJECT, "GeeArrayListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	}
	return gee_array_list_iterator_type_id;
}


static void gee_array_list_class_init (GeeArrayListClass * klass) {
	gee_array_list_parent_class = g_type_class_peek_parent (klass);
	GEE_COLLECTION_OBJECT_CLASS (klass)->finalize = gee_array_list_finalize;
	g_type_class_add_private (klass, sizeof (GeeArrayListPrivate));
}


static void gee_array_list_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_array_list_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_element_type = gee_array_list_real_get_element_type;
	iface->iterator = gee_array_list_real_iterator;
}


static void gee_array_list_gee_collection_interface_init (GeeCollectionIface * iface) {
	gee_array_list_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = gee_array_list_real_contains;
	iface->add = gee_array_list_real_add;
	iface->remove = gee_array_list_real_remove;
	iface->clear = gee_array_list_real_clear;
	iface->get_size = gee_array_list_real_get_size;
}


static void gee_array_list_gee_list_interface_init (GeeListIface * iface) {
	gee_array_list_gee_list_parent_iface = g_type_interface_peek_parent (iface);
	iface->index_of = gee_array_list_real_index_of;
	iface->get = gee_array_list_real_get;
	iface->set = gee_array_list_real_set;
	iface->insert = gee_array_list_real_insert;
	iface->remove_at = gee_array_list_real_remove_at;
}


static void gee_array_list_instance_init (GeeArrayList * self) {
	self->priv = GEE_ARRAY_LIST_GET_PRIVATE (self);
	self->priv->_items = g_new0 (gpointer, 4);
	self->priv->_items_length1 = 4;
	self->priv->_stamp = 0;
}


static void gee_array_list_finalize (GeeCollectionObject* obj) {
	GeeArrayList * self;
	self = GEE_ARRAY_LIST (obj);
	self->priv->_items = (_vala_array_free (self->priv->_items, self->priv->_items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	GEE_COLLECTION_OBJECT_CLASS (gee_array_list_parent_class)->finalize (obj);
}


GType gee_array_list_get_type (void) {
	static GType gee_array_list_type_id = 0;
	if (gee_array_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayList), 0, (GInstanceInitFunc) gee_array_list_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_array_list_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) gee_array_list_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_list_info = { (GInterfaceInitFunc) gee_array_list_gee_list_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_array_list_type_id = g_type_register_static (GEE_TYPE_COLLECTION_OBJECT, "GeeArrayList", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_list_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_array_list_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
		g_type_add_interface_static (gee_array_list_type_id, GEE_TYPE_LIST, &gee_list_info);
	}
	return gee_array_list_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if (src < dest) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	}
}




