/* gstreamer-0.10.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gst", lower_case_cprefix = "gst_")]
namespace Gst {
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class AllocTrace {
		public int flags;
		public int live;
		public weak GLib.SList<weak void*> mem_live;
		public weak string name;
		public static bool available ();
		public static unowned Gst.AllocTrace @get (string name);
		public static unowned GLib.List<Gst.AllocTrace> list ();
		public static int live_all ();
		public void print ();
		public static void print_all ();
		public static void print_live ();
		public void set_flags (Gst.AllocTraceFlags flags);
		public static void set_flags_all (Gst.AllocTraceFlags flags);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class Bin : Gst.Element, Gst.ChildProxy {
		public weak Gst.Bus child_bus;
		public weak GLib.List<Gst.Element> children;
		public uint32 children_cookie;
		public bool clock_dirty;
		public weak Gst.Element clock_provider;
		public weak GLib.List<Gst.Message> messages;
		public int numchildren;
		public bool polling;
		public weak Gst.Clock provided_clock;
		public bool state_dirty;
		[CCode (type = "GstElement*", has_construct_function = false)]
		public Bin (string? name);
		public bool add (owned Gst.Element element);
		[NoWrapper]
		public virtual bool add_element (Gst.Element element);
		public void add_many (params owned Gst.Element[] elements);
		public Gst.Pad? find_unconnected_pad (Gst.PadDirection direction);
		public Gst.Pad? find_unlinked_pad (Gst.PadDirection direction);
		public Gst.Element? get_by_interface (GLib.Type iface);
		public Gst.Element? get_by_name (string name);
		public Gst.Element? get_by_name_recurse_up (string name);
		[NoWrapper]
		public virtual void handle_message (Gst.Message message);
		public Gst.Iterator<Gst.Element> iterate_all_by_interface (GLib.Type iface);
		public Gst.Iterator<Gst.Element> iterate_elements ();
		public Gst.Iterator<Gst.Element> iterate_recurse ();
		public Gst.Iterator<Gst.Element> iterate_sinks ();
		public Gst.Iterator<Gst.Element> iterate_sorted ();
		public Gst.Iterator<Gst.Element> iterate_sources ();
		public bool recalculate_latency ();
		public bool remove (Gst.Element element);
		[NoWrapper]
		public virtual bool remove_element (Gst.Element element);
		public void remove_many (params Gst.Element[] elements);
		[NoAccessorMethod]
		public bool async_handling { get; set; }
		public virtual signal bool do_latency ();
		public virtual signal void element_added (Gst.Element child);
		public virtual signal void element_removed (Gst.Element child);
	}
	[CCode (ref_function = "gst_buffer_ref", unref_function = "gst_buffer_unref", cheader_filename = "gst/gst.h")]
	public class Buffer : Gst.MiniObject {
		public weak Gst.Caps caps;
		[CCode (array_length_cname = "size", array_length_type = "guint")]
		public weak uint8[] data;
		public Gst.ClockTime duration;
		public weak GLib.FreeFunc free_func;
		public void* malloc_data;
		public uint64 offset;
		public uint64 offset_end;
		public weak Gst.Buffer parent;
		public uint size;
		public Gst.ClockTime timestamp;
		[CCode (has_construct_function = false)]
		public Buffer ();
		[CCode (has_construct_function = false)]
		public Buffer.and_alloc (uint size);
		public Gst.Buffer copy ();
		public void copy_metadata (Gst.Buffer src, Gst.BufferCopyFlags flags);
		public Gst.Buffer create_sub (uint offset, uint size);
		[CCode (cname = "GST_BUFFER_DURATION_IS_VALID")]
		public bool duration_is_valid ();
		[CCode (cname = "GST_BUFFER_FLAG_IS_SET")]
		public bool flag_is_set (Gst.BufferFlag flag);
		[CCode (cname = "GST_BUFFER_FLAG_SET")]
		public void flag_set (Gst.BufferFlag flag);
		[CCode (cname = "GST_BUFFER_FLAG_UNSET")]
		public void flag_unset (Gst.BufferFlag flag);
		public Gst.Caps get_caps ();
		[CCode (cname = "GST_BUFFER_IS_DISCONT")]
		public bool is_discont ();
		public bool is_metadata_writable ();
		public bool is_span_fast (Gst.Buffer buf2);
		[ReturnsModifiedPointer]
		public void join (owned Gst.Buffer buf2);
		[ReturnsModifiedPointer]
		public void make_metadata_writable ();
		[ReturnsModifiedPointer]
		public void make_writable ();
		public Gst.Buffer merge (Gst.Buffer buf2);
		[CCode (cname = "GST_BUFFER_OFFSET_END_IS_VALID")]
		public bool offset_end_is_valid ();
		[CCode (cname = "GST_BUFFER_OFFSET_IS_VALID")]
		public bool offset_is_valid ();
		public Gst.Buffer @ref ();
		public static void replace (ref Gst.Buffer? oldobj, Gst.Buffer? newobj);
		public void set_caps (Gst.Caps caps);
		public Gst.Buffer span (uint32 offset, Gst.Buffer buf2, uint32 len);
		public void stamp (Gst.Buffer src);
		[CCode (cname = "GST_BUFFER_TIMESTAMP_IS_VALID")]
		public bool timestamp_is_valid ();
		public static Gst.Buffer? try_new_and_alloc (uint size);
		public void unref ();
	}
	[CCode (ref_function = "gst_buffer_list_ref", unref_function = "gst_buffer_list_unref", cheader_filename = "gst/gst.h")]
	public class BufferList : Gst.MiniObject {
		[CCode (has_construct_function = false)]
		public BufferList ();
		public Gst.BufferList copy ();
		public void @foreach (Gst.BufferListFunc func);
		public unowned Gst.Buffer? @get (uint group, uint idx);
		public Gst.BufferListIterator iterate ();
		[ReturnsModifiedPointer]
		public void make_writable ();
		public uint n_groups ();
		public Gst.BufferList @ref ();
		public void unref ();
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class BufferListIterator {
		public void add (owned Gst.Buffer buffer);
		public void add_group ();
		public unowned Gst.Buffer? @do (Gst.BufferListDoFunction do_func);
		public Gst.Buffer? merge_group ();
		public uint n_buffers ();
		public unowned Gst.Buffer? next ();
		public bool next_group ();
		public void remove ();
		public unowned Gst.Buffer? steal ();
		public void take (owned Gst.Buffer buffer);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class Bus : Gst.Object {
		[CCode (has_construct_function = false)]
		public Bus ();
		public void add_signal_watch ();
		public void add_signal_watch_full (int priority);
		[CCode (cname = "gst_bus_add_watch_full")]
		public uint add_watch (owned Gst.BusFunc func, [CCode (pos = 0.1)] int priority = GLib.Priority.DEFAULT);
		public uint add_watch_full (int priority, owned Gst.BusFunc func);
		[CCode (instance_pos = -1)]
		public bool async_signal_func (Gst.Bus bus, Gst.Message message);
		public GLib.TimeoutSource create_watch ();
		public void disable_sync_message_emission ();
		public void enable_sync_message_emission ();
		public bool have_pending ();
		public Gst.Message? peek ();
		public Gst.Message? poll (Gst.MessageType events, Gst.ClockTimeDiff timeout);
		public Gst.Message? pop ();
		public Gst.Message? pop_filtered (Gst.MessageType types);
		public bool post (owned Gst.Message message);
		public void remove_signal_watch ();
		public void set_flushing (bool flushing);
		public void set_sync_handler (Gst.BusSyncHandler? func);
		[CCode (instance_pos = -1)]
		public Gst.BusSyncReply sync_signal_handler (Gst.Bus bus, Gst.Message message);
		public Gst.Message? timed_pop (Gst.ClockTime timeout);
		public Gst.Message? timed_pop_filtered (Gst.ClockTime timeout, Gst.MessageType types);
		public virtual signal void message (Gst.Message message);
		public virtual signal void sync_message (Gst.Message message);
	}
	[CCode (ref_function = "gst_caps_ref", unref_function = "gst_caps_unref", cheader_filename = "gst/gst.h")]
	public class Caps {
		public Gst.CapsFlags flags;
		[CCode (has_construct_function = false)]
		public Caps.any ();
		public void append (owned Gst.Caps caps2);
		public void append_structure (owned Gst.Structure structure);
		public bool can_intersect (Gst.Caps caps2);
		public Gst.Caps copy ();
		public Gst.Caps copy_nth (uint nth);
		public bool do_simplify ();
		[CCode (has_construct_function = false)]
		public Caps.empty ();
		public static Gst.Caps from_string (string str);
		[CCode (has_construct_function = false)]
		public Caps.full (Gst.Structure struct1, ...);
		[CCode (has_construct_function = false)]
		public Caps.full_valist (Gst.Structure structure, void* var_args);
		public uint get_size ();
		public unowned Gst.Structure get_structure (uint index);
		public Gst.Caps intersect (Gst.Caps caps2);
		public bool is_always_compatible (Gst.Caps caps2);
		public bool is_any ();
		public bool is_empty ();
		public bool is_equal (Gst.Caps caps2);
		public bool is_equal_fixed (Gst.Caps caps2);
		public bool is_fixed ();
		[CCode (cname = "GST_CAPS_IS_SIMPLE")]
		public bool is_simple ();
		public bool is_subset (Gst.Caps superset);
		public static Gst.Caps load_thyself (void* parent);
		[ReturnsModifiedPointer]
		public void make_writable ();
		public void merge (owned Gst.Caps caps2);
		public void merge_structure (owned Gst.Structure structure);
		public Gst.Caps normalize ();
		public Gst.Caps @ref ();
		public void remove_structure (uint idx);
		public static void replace (ref Gst.Caps? oldobj, Gst.Caps? newobj);
		public void* save_thyself (void* parent);
		public void set_simple (string field, ...);
		public void set_simple_valist (string field, void* varargs);
		public void set_value (string field, Gst.Value value);
		[CCode (has_construct_function = false)]
		public Caps.simple (string media_type, string fieldname, ...);
		public Gst.Caps subtract (Gst.Caps subtrahend);
		public string to_string ();
		public void truncate ();
		public Gst.Caps union (Gst.Caps caps2);
		public void unref ();
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public abstract class Clock : Gst.Object {
		public weak Gst.ClockID clockid;
		public weak GLib.List<Gst.ClockEntry> entries;
		public weak GLib.Cond entries_changed;
		public Gst.ClockTime external_calibration;
		public bool filling;
		public Gst.ClockTime internal_calibration;
		public Gst.ClockTime last_time;
		public weak Gst.Clock master;
		public Gst.ClockTime rate_denominator;
		public Gst.ClockTime rate_numerator;
		public Gst.ClockTime resolution;
		public weak GLib.Mutex slave_lock;
		public int time_index;
		[CCode (array_length = false)]
		public weak Gst.ClockTime[] times;
		public bool add_observation (Gst.ClockTime slave, Gst.ClockTime master, out double r_squared);
		public Gst.ClockTime adjust_unlocked (Gst.ClockTime @internal);
		[NoWrapper]
		public virtual Gst.ClockTime change_resolution (Gst.ClockTime old_resolution, Gst.ClockTime new_resolution);
		public void get_calibration (out Gst.ClockTime @internal, out Gst.ClockTime external, out Gst.ClockTime rate_num, out Gst.ClockTime rate_denom);
		public virtual Gst.ClockTime get_internal_time ();
		public Gst.Clock? get_master ();
		public virtual Gst.ClockTime get_resolution ();
		public Gst.ClockTime get_time ();
		public void set_calibration (Gst.ClockTime @internal, Gst.ClockTime external, Gst.ClockTime rate_num, Gst.ClockTime rate_denom);
		public bool set_master (Gst.Clock? master);
		public Gst.ClockTime set_resolution (Gst.ClockTime resolution);
		public Gst.ClockTime unadjust_unlocked (Gst.ClockTime external);
		[NoWrapper]
		public virtual void unschedule (Gst.ClockEntry entry);
		[NoWrapper]
		public virtual Gst.ClockReturn wait (Gst.ClockEntry entry);
		[NoWrapper]
		public virtual Gst.ClockReturn wait_async (Gst.ClockEntry entry);
		[NoWrapper]
		public virtual Gst.ClockReturn wait_jitter (Gst.ClockEntry entry, out Gst.ClockTimeDiff jitter);
		[NoAccessorMethod]
		public bool stats { get; set; }
		[NoAccessorMethod]
		public uint64 timeout { get; set; }
		[NoAccessorMethod]
		public int window_size { get; set; }
		[NoAccessorMethod]
		public int window_threshold { get; set; }
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class ClockEntry {
		public weak Gst.Clock clock;
		public weak Gst.ClockCallback func;
		public Gst.ClockTime interval;
		public int refcount;
		public Gst.ClockReturn status;
		public Gst.ClockTime time;
		public Gst.ClockEntryType type;
		public void* user_data;
	}
	[Compact]
	[CCode (ref_function = "gst_clock_id_ref", unref_function = "gst_clock_id_unref", cheader_filename = "gst/gst.h")]
	public class ClockID {
		public static int compare_func (void* id1, void* id2);
		public Gst.ClockTime get_time ();
		[CCode (cname = "gst_clock_new_periodic_id")]
		public ClockID.periodic (Gst.Clock clock, Gst.ClockTime start_time, Gst.ClockTime interval);
		[CCode (cname = "gst_clock_new_single_shot_id")]
		public ClockID.single_shot (Gst.Clock clock, Gst.ClockTime time);
		public void unschedule ();
		public Gst.ClockReturn wait (Gst.ClockTimeDiff jitter);
		public Gst.ClockReturn wait_async (Gst.ClockCallback func);
	}
	[Compact]
	[CCode (type_id = "GST_TYPE_DATE", cheader_filename = "gst/gst.h")]
	public class Date {
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class DebugCategory {
		[CCode (cname = "GST_CAT_DEBUG")]
		public void debug (string format, ...);
		[CCode (cname = "GST_CAT_DEBUG_OBJECT")]
		public void debug_object (GLib.Object obj, string format, ...);
		[CCode (cname = "GST_CAT_ERROR")]
		public void error (string format, ...);
		[CCode (cname = "GST_CAT_ERROR_OBJECT")]
		public void error_object (GLib.Object obj, string format, ...);
		[CCode (cname = "GST_DEBUG_CATEGORY_GET")]
		public static unowned Gst.DebugCategory @get (string name);
		public uint get_color ();
		public unowned string get_description ();
		public unowned string get_name ();
		public Gst.DebugLevel get_threshold ();
		[CCode (cname = "GST_CAT_INFO")]
		public void info (string format, ...);
		[CCode (cname = "GST_CAT_INFO_OBJECT")]
		public void info_object (GLib.Object obj, string format, ...);
		[CCode (cname = "GST_DEBUG_CATEGORY_INIT")]
		public void init (string name, uint color, string description);
		[CCode (cname = "GST_CAT_LOG")]
		public void log (string format, ...);
		[CCode (cname = "GST_CAT_LOG_OBJECT")]
		public void log_object (GLib.Object obj, string format, ...);
		public void reset_threshold ();
		public void set_threshold (Gst.DebugLevel level);
		[CCode (cname = "GST_CAT_WARNING")]
		public void warning (string format, ...);
		[CCode (cname = "GST_CAT_WARNING_OBJECT")]
		public void warning_object (GLib.Object obj, string format, ...);
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class DebugMessage {
		public unowned string @get ();
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public abstract class Element : Gst.Object {
		public Gst.ClockTimeDiff base_time;
		public weak Gst.Bus bus;
		public weak Gst.Clock clock;
		public Gst.State current_state;
		public Gst.StateChangeReturn last_return;
		public Gst.State next_state;
		public uint16 numpads;
		public uint16 numsinkpads;
		public uint16 numsrcpads;
		public weak GLib.List<Gst.Pad> pads;
		public uint32 pads_cookie;
		public Gst.State pending_state;
		public weak GLib.List<Gst.Pad> sinkpads;
		public weak GLib.List<Gst.Pad> srcpads;
		public weak GLib.Cond state_cond;
		public uint32 state_cookie;
		public void* state_lock;
		[CCode (cname = "abidata.ABI.target_state")]
		public Gst.State target_state;
		public void abort_state ();
		public bool add_pad (owned Gst.Pad pad);
		[CCode (cname = "gst_element_class_add_pad_template")]
		public class void add_pad_template (Gst.PadTemplate templ);
		public virtual Gst.StateChangeReturn change_state (Gst.StateChange transition);
		public Gst.StateChangeReturn continue_state (Gst.StateChangeReturn ret);
		public void create_all_pads ();
		public void found_tags (owned Gst.TagList list);
		public void found_tags_for_pad (Gst.Pad pad, owned Gst.TagList list);
		public Gst.ClockTime get_base_time ();
		public Gst.Bus? get_bus ();
		public Gst.Clock? get_clock ();
		public Gst.Pad? get_compatible_pad (Gst.Pad pad, Gst.Caps? caps);
		public unowned Gst.PadTemplate? get_compatible_pad_template (Gst.PadTemplate compattempl);
		public unowned Gst.ElementFactory? get_factory ();
		public virtual Gst.Index? get_index ();
		public Gst.Pad? get_pad (string name);
		[CCode (cname = "gst_element_class_get_pad_template")]
		public class unowned Gst.PadTemplate? get_pad_template (string name);
		[CCode (cname = "gst_element_class_get_pad_template_list")]
		public class unowned GLib.List<Gst.PadTemplate> get_pad_template_list ();
		[CCode (array_length = false)]
		public virtual unowned Gst.QueryType[]? get_query_types ();
		public Gst.Pad? get_request_pad (string name);
		public Gst.ClockTime get_start_time ();
		public virtual Gst.StateChangeReturn get_state (out Gst.State state, out Gst.State pending, Gst.ClockTime timeout);
		public Gst.Pad? get_static_pad (string name);
		public bool implements_interface (GLib.Type iface_type);
		[CCode (cname = "gst_element_class_install_std_props")]
		public class void install_std_props (...);
		public bool is_indexable ();
		public bool is_locked_state ();
		public Gst.Iterator<Gst.Pad> iterate_pads ();
		public Gst.Iterator<Gst.Pad> iterate_sink_pads ();
		public Gst.Iterator<Gst.Pad> iterate_src_pads ();
		public bool link (Gst.Element dest);
		public bool link_filtered (Gst.Element dest, Gst.Caps filter);
		public bool link_many (Gst.Element element_2, ...);
		public bool link_pads (string srcpadname, Gst.Element dest, string destpadname);
		public bool link_pads_filtered (string srcpadname, Gst.Element dest, string destpadname, Gst.Caps filter);
		public void lost_state ();
		public void lost_state_full (bool new_base_time);
		public static Gst.Element? make_from_uri (Gst.URIType type, string uri, string? elementname);
		public void message_full (Gst.MessageType type, GLib.Quark domain, int code, string? text, string? debug, string file, string function, int line);
		public bool post_message (owned Gst.Message message);
		public virtual Gst.Clock? provide_clock ();
		public bool provides_clock ();
		public virtual bool query (Gst.Query query);
		public bool query_convert (Gst.Format src_format, int64 src_val, ref Gst.Format dest_format, out int64 dest_val);
		public bool query_duration (ref Gst.Format format, out int64 duration);
		public bool query_position (ref Gst.Format format, out int64 cur);
		public static bool register (Gst.Plugin? plugin, string name, uint rank, GLib.Type type);
		[NoWrapper]
		public virtual void release_pad (Gst.Pad pad);
		public void release_request_pad (Gst.Pad pad);
		public bool remove_pad (Gst.Pad pad);
		[NoWrapper]
		public virtual unowned Gst.Pad request_new_pad (Gst.PadTemplate templ, string? name);
		public bool requires_clock ();
		public bool seek (double rate, Gst.Format format, Gst.SeekFlags flags, Gst.SeekType cur_type, int64 cur, Gst.SeekType stop_type, int64 stop);
		public bool seek_simple (Gst.Format format, Gst.SeekFlags seek_flags, int64 seek_pos);
		public virtual bool send_event (owned Gst.Event event);
		public void set_base_time (Gst.ClockTime time);
		public virtual void set_bus (Gst.Bus? bus);
		public virtual bool set_clock (Gst.Clock? clock);
		[CCode (cname = "gst_element_class_set_details")]
		public class void set_details (Gst.ElementDetails details);
		[CCode (cname = "gst_element_class_set_details_simple")]
		public class void set_details_simple (string longname, string classification, string description, string author);
		public virtual void set_index (Gst.Index? index);
		public bool set_locked_state (bool locked_state);
		public void set_start_time (Gst.ClockTime time);
		public virtual Gst.StateChangeReturn set_state (Gst.State state);
		public bool sync_state_with_parent ();
		public void unlink (Gst.Element dest);
		public void unlink_many (Gst.Element element_2, ...);
		public void unlink_pads (string srcpadname, Gst.Element dest, string destpadname);
		[HasEmitter]
		public virtual signal void no_more_pads ();
		public virtual signal void pad_added (Gst.Pad pad);
		public virtual signal void pad_removed (Gst.Pad pad);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class ElementFactory : Gst.PluginFeature {
		public bool can_sink_caps (Gst.Caps caps);
		public bool can_src_caps (Gst.Caps caps);
		public Gst.Element? create (string? name);
		public static Gst.ElementFactory? find (string name);
		public unowned string get_author ();
		public unowned string get_description ();
		public GLib.Type get_element_type ();
		public unowned string get_klass ();
		public unowned string get_longname ();
		public uint get_num_pad_templates ();
		public unowned GLib.List<Gst.StaticPadTemplate> get_static_pad_templates ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? get_uri_protocols ();
		public int get_uri_type ();
		public bool has_interface (string interfacename);
		public static Gst.Element? make (string factoryname, string? name);
	}
	[CCode (ref_function = "gst_event_ref", unref_function = "gst_event_unref", cheader_filename = "gst/gst.h")]
	public class Event : Gst.MiniObject {
		public weak Gst.Object src;
		public uint64 timestamp;
		public Gst.EventType type;
		[CCode (has_construct_function = false)]
		public Event.buffer_size (Gst.Format format, int64 minsize, int64 maxsize, bool @async);
		public Gst.Event copy ();
		[CCode (has_construct_function = false)]
		public Event.custom (Gst.EventType type, owned Gst.Structure structure);
		[CCode (has_construct_function = false)]
		public Event.eos ();
		[CCode (has_construct_function = false)]
		public Event.flush_start ();
		[CCode (has_construct_function = false)]
		public Event.flush_stop ();
		public uint32 get_seqnum ();
		public unowned Gst.Structure get_structure ();
		public bool has_name (string name);
		[CCode (cname = "GST_EVENT_IS_DOWNSTREAM")]
		public bool is_downstream ();
		[CCode (cname = "GST_EVENT_IS_SERIALIZED")]
		public bool is_serialized ();
		[CCode (cname = "GST_EVENT_IS_UPSTREAM")]
		public bool is_upstream ();
		[CCode (has_construct_function = false)]
		public Event.latency (Gst.ClockTime latency);
		[CCode (has_construct_function = false)]
		public Event.navigation (owned Gst.Structure structure);
		[CCode (has_construct_function = false)]
		public Event.new_segment (bool update, double rate, Gst.Format format, int64 start, int64 stop, int64 position);
		[CCode (has_construct_function = false)]
		public Event.new_segment_full (bool update, double rate, double applied_rate, Gst.Format format, int64 start, int64 stop, int64 position);
		public void parse_buffer_size (out Gst.Format format, out int64 minsize, out int64 maxsize, out bool @async);
		public void parse_latency (out Gst.ClockTime latency);
		public void parse_new_segment (out bool update, out double rate, out Gst.Format format, out int64 start, out int64 stop, out int64 position);
		public void parse_new_segment_full (out bool update, out double rate, out double applied_rate, out Gst.Format format, out int64 start, out int64 stop, out int64 position);
		public void parse_qos (out double proportion, out Gst.ClockTimeDiff diff, out Gst.ClockTime timestamp);
		public void parse_seek (out double rate, out Gst.Format format, out Gst.SeekFlags flags, out Gst.SeekType start_type, out int64 start, out Gst.SeekType stop_type, out int64 stop);
		public void parse_sink_message (out unowned Gst.Message msg);
		public void parse_step (out Gst.Format format, out uint64 amount, out double rate, out bool flush, out bool intermediate);
		public void parse_tag (out unowned Gst.TagList taglist);
		[CCode (has_construct_function = false)]
		public Event.qos (double proportion, Gst.ClockTimeDiff diff, Gst.ClockTime timestamp);
		public Gst.Event @ref ();
		public static void replace (ref Gst.Event? oldobj, Gst.Event? newobj);
		[CCode (has_construct_function = false)]
		public Event.seek (double rate, Gst.Format format, Gst.SeekFlags flags, Gst.SeekType start_type, int64 start, Gst.SeekType stop_type, int64 stop);
		public void set_seqnum (uint32 seqnum);
		[CCode (has_construct_function = false)]
		public Event.sink_message (owned Gst.Message msg);
		[CCode (has_construct_function = false)]
		public Event.step (Gst.Format format, uint64 amount, double rate, bool flush, bool intermediate);
		[CCode (has_construct_function = false)]
		public Event.tag (owned Gst.TagList taglist);
		public static Gst.EventTypeFlags type_get_flags (Gst.EventType type);
		public static unowned string type_get_name (Gst.EventType type);
		public static GLib.Quark type_to_quark (Gst.EventType type);
		public void unref ();
	}
	[Compact]
	[CCode (type_id = "GST_TYPE_GERROR", cheader_filename = "gst/gst.h")]
	public class GError {
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class GhostPad : Gst.Pad {
		[CCode (type = "GstPad*", has_construct_function = false)]
		public GhostPad (string? name, Gst.Pad target);
		[CCode (type = "GstPad*", has_construct_function = false)]
		public GhostPad.from_template (string? name, Gst.Pad target, Gst.PadTemplate templ);
		public Gst.Pad? get_target ();
		[CCode (type = "GstPad*", has_construct_function = false)]
		public GhostPad.no_target (string? name, Gst.PadDirection dir);
		[CCode (type = "GstPad*", has_construct_function = false)]
		public GhostPad.no_target_from_template (string? name, Gst.PadTemplate templ);
		public bool set_target (Gst.Pad? newtarget);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class Index : Gst.Object {
		[CCode (has_construct_function = false)]
		public Index ();
		public unowned Gst.IndexEntry add_association (int id, Gst.AssocFlags flags, Gst.Format format, int64 value, ...);
		public unowned Gst.IndexEntry? add_associationv (int id, Gst.AssocFlags flags, [CCode (array_length_pos = 2.9)] Gst.IndexAssociation[] list);
		[NoWrapper]
		public virtual void add_entry (Gst.IndexEntry entry);
		public unowned Gst.IndexEntry? add_format (int id, Gst.Format format);
		public unowned Gst.IndexEntry? add_id (int id, string description);
		public unowned Gst.IndexEntry? add_object (int id, string key, GLib.Type type, void* object);
		public virtual void commit (int id);
		public virtual unowned Gst.IndexEntry? get_assoc_entry (int id, Gst.IndexLookupMethod method, Gst.AssocFlags flags, Gst.Format format, int64 value);
		public unowned Gst.IndexEntry? get_assoc_entry_full (int id, Gst.IndexLookupMethod method, Gst.AssocFlags flags, Gst.Format format, int64 value, GLib.CompareDataFunc func);
		public Gst.IndexCertainty get_certainty ();
		public int get_group ();
		public virtual bool get_writer_id (Gst.Object writer, out int id);
		[CCode (cname = "GST_INDEX_IS_READABLE")]
		public bool is_readable ();
		[CCode (cname = "GST_INDEX_IS_WRITABLE")]
		public bool is_writable ();
		public int new_group ();
		public void set_certainty (Gst.IndexCertainty certainty);
		[CCode (cname = "gst_index_set_filter_full")]
		public void set_filter (owned Gst.IndexFilter filter);
		public bool set_group (int groupnum);
		[CCode (cname = "gst_index_set_resolver_full")]
		public void set_resolver (owned Gst.IndexResolver resolver);
		[NoAccessorMethod]
		public Gst.IndexResolver resolver { owned get; set; }
		public virtual signal void entry_added (Gst.IndexEntry entry);
	}
	[Compact]
	[CCode (copy_function = "gst_index_entry_copy", cheader_filename = "gst/gst.h")]
	public class IndexEntry {
		public Gst.IndexEntryType type;
		[CCode (cname = "GST_INDEX_ASSOC_FLAGS")]
		public Gst.AssocFlags assoc_flags ();
		[CCode (cname = "GST_INDEX_ASSOC_FORMAT")]
		public Gst.Format assoc_format (int i);
		public bool assoc_map (Gst.Format format, out int64 value);
		[CCode (cname = "GST_INDEX_ASSOC_VALUE")]
		public Gst.IndexAssociation assoc_value (int i);
		public Gst.IndexEntry copy ();
		[CCode (cname = "GST_INDEX_FORMAT_FORMAT")]
		public Gst.Format format_format ();
		[CCode (cname = "GST_INDEX_FORMAT_KEY")]
		public unowned string format_key ();
		[CCode (cname = "GST_INDEX_ID_DESCRIPTION")]
		public unowned string id_description ();
		[CCode (cname = "GST_INDEX_NASSOCS")]
		public int n_assocs ();
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class IndexFactory : Gst.PluginFeature {
		public weak string longdesc;
		public GLib.Type type;
		[CCode (has_construct_function = false)]
		public IndexFactory (string name, string longdesc, GLib.Type type);
		public Gst.Index create ();
		public void destroy ();
		public static Gst.IndexFactory? find (string name);
		public static Gst.Index? make (string name);
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class Iterator<T> {
		public uint32 cookie;
		public weak GLib.Mutex @lock;
		public void* master_cookie;
		public weak Gst.Iterator pushed;
		public GLib.Type type;
		[CCode (has_construct_function = false)]
		public Iterator (uint size, GLib.Type type, GLib.Mutex @lock, ref uint32 master_cookie, Gst.IteratorNextFunction next, Gst.IteratorItemFunction item, Gst.IteratorResyncFunction resync, Gst.IteratorFreeFunction free);
		public T find_custom (GLib.CompareFunc func, T user_data);
		public Gst.IteratorResult fold ([CCode (delegate_target_pos = 2.1)] Gst.IteratorFoldFunction func, Gst.Value? ret);
		public Gst.IteratorResult @foreach (GLib.Func func);
		[CCode (has_construct_function = false)]
		public Iterator.list (GLib.Type type, GLib.Mutex @lock, ref uint32 master_cookie, GLib.List<T> list, void* owner, Gst.IteratorItemFunction item, Gst.IteratorDisposeFunction free);
		public Gst.IteratorResult next (out T elem);
		public void push (Gst.Iterator other);
		public void resync ();
		[CCode (has_construct_function = false)]
		public Iterator.single (GLib.Type type, T object, Gst.CopyFunction copy, GLib.FreeFunc free);
	}
	[CCode (ref_function = "gst_message_ref", unref_function = "gst_message_unref", cheader_filename = "gst/gst.h")]
	public class Message : Gst.MiniObject {
		public weak Gst.Object src;
		public uint64 timestamp;
		public Gst.MessageType type;
		[CCode (has_construct_function = false)]
		public Message.application (Gst.Object src, owned Gst.Structure? structure);
		[CCode (has_construct_function = false)]
		public Message.async_done (Gst.Object src);
		[CCode (has_construct_function = false)]
		public Message.async_start (Gst.Object src, bool new_base_time);
		[CCode (has_construct_function = false)]
		public Message.buffering (Gst.Object src, int percent);
		[CCode (has_construct_function = false)]
		public Message.clock_lost (Gst.Object src, Gst.Clock clock);
		[CCode (has_construct_function = false)]
		public Message.clock_provide (Gst.Object src, Gst.Clock clock, bool ready);
		public Gst.Message copy ();
		[CCode (has_construct_function = false)]
		public Message.custom (Gst.MessageType type, Gst.Object src, owned Gst.Structure? structure);
		[CCode (has_construct_function = false)]
		public Message.duration (Gst.Object src, Gst.Format format, int64 duration);
		[CCode (has_construct_function = false)]
		public Message.element (Gst.Object src, owned Gst.Structure? structure);
		[CCode (has_construct_function = false)]
		public Message.eos (Gst.Object src);
		[CCode (has_construct_function = false)]
		public Message.error (Gst.Object src, GLib.Error error, string? debug);
		public uint32 get_seqnum ();
		public unowned Gst.Value? get_stream_status_object ();
		public unowned Gst.Structure? get_structure ();
		[CCode (has_construct_function = false)]
		public Message.info (Gst.Object src, GLib.Error error, string? debug);
		[CCode (has_construct_function = false)]
		public Message.latency (Gst.Object src);
		[ReturnsModifiedPointer]
		public void make_writable ();
		[CCode (has_construct_function = false)]
		public Message.new_clock (Gst.Object src, Gst.Clock clock);
		public void parse_async_start (out bool new_base_time);
		public void parse_buffering (out int percent);
		public void parse_buffering_stats (out Gst.BufferingMode mode, out int avg_in, out int avg_out, out int64 buffering_left);
		public void parse_clock_lost (out unowned Gst.Clock clock);
		public void parse_clock_provide (out unowned Gst.Clock clock, out bool ready);
		public void parse_duration (out Gst.Format format, out int64 duration);
		public void parse_error (out GLib.Error gerror, out string? debug);
		public void parse_info (out GLib.Error gerror, out string? debug);
		public void parse_new_clock (out unowned Gst.Clock clock);
		public void parse_request_state (out Gst.State state);
		public void parse_segment_done (out Gst.Format format, out int64 position);
		public void parse_segment_start (out Gst.Format format, out int64 position);
		public void parse_state_changed (out Gst.State oldstate, out Gst.State newstate, out Gst.State pending);
		public void parse_step_done (out Gst.Format format, out uint64 amount, out double rate, out bool flush, out bool intermediate, out uint64 duration, out bool eos);
		public void parse_step_start (out bool active, out Gst.Format format, out uint64 amount, out double rate, out bool flush, out bool intermediate);
		public void parse_stream_status (out Gst.StreamStatusType type, out unowned Gst.Element owner);
		public void parse_structure_change (out Gst.StructureChangeType type, out unowned Gst.Element owner, out bool busy);
		public void parse_tag (out Gst.TagList tag_list);
		public void parse_tag_full (out unowned Gst.Pad pad, out unowned Gst.TagList tag_list);
		public void parse_warning (out GLib.Error gerror, out string? debug);
		public Gst.Message @ref ();
		[CCode (has_construct_function = false)]
		public Message.request_state (Gst.Object src, Gst.State state);
		[CCode (has_construct_function = false)]
		public Message.segment_done (Gst.Object src, Gst.Format format, int64 position);
		[CCode (has_construct_function = false)]
		public Message.segment_start (Gst.Object src, Gst.Format format, int64 position);
		public void set_buffering_stats (Gst.BufferingMode mode, int avg_in, int avg_out, int64 buffering_left);
		public void set_seqnum (uint32 seqnum);
		public void set_stream_status_object (ref unowned Gst.Value? object);
		[CCode (has_construct_function = false)]
		public Message.state_changed (Gst.Object src, Gst.State oldstate, Gst.State newstate, Gst.State pending);
		[CCode (has_construct_function = false)]
		public Message.state_dirty (Gst.Object src);
		[CCode (has_construct_function = false)]
		public Message.step_done (Gst.Object src, Gst.Format format, uint64 amount, double rate, bool flush, bool intermediate, uint64 duration, bool eos);
		[CCode (has_construct_function = false)]
		public Message.step_start (Gst.Object src, bool active, Gst.Format format, uint64 amount, double rate, bool flush, bool intermediate);
		[CCode (has_construct_function = false)]
		public Message.stream_status (Gst.Object src, Gst.StreamStatusType type, Gst.Element owner);
		[CCode (has_construct_function = false)]
		public Message.structure_change (Gst.Object src, Gst.StructureChangeType type, Gst.Element owner, bool busy);
		[CCode (has_construct_function = false)]
		public Message.tag (Gst.Object src, Gst.TagList tag_list);
		[CCode (has_construct_function = false)]
		public Message.tag_full (Gst.Object src, Gst.Pad pad, Gst.TagList tag_list);
		public static GLib.Quark type_to_quark (Gst.MessageType type);
		public void unref ();
		[CCode (has_construct_function = false)]
		public Message.warning (Gst.Object src, GLib.Error error, string? debug);
	}
	[CCode (ref_function = "gst_mini_object_ref", unref_function = "gst_mini_object_unref", cheader_filename = "gst/gst.h")]
	public abstract class MiniObject {
		public Gst.MiniObjectFlags flags;
		[CCode (has_construct_function = false)]
		public MiniObject (GLib.Type type);
		public virtual Gst.MiniObject copy ();
		public virtual void finalize ();
		[CCode (cname = "GST_MINI_OBJECT_FLAG_IS_SET")]
		public bool flag_is_set (Gst.MiniObjectFlags flag);
		[CCode (cname = "GST_MINI_OBJECT_FLAG_SET")]
		public void flag_set (Gst.MiniObjectFlags flag);
		[CCode (cname = "GST_MINI_OBJECT_FLAG_UNSET")]
		public void flag_unset (Gst.MiniObjectFlags flag);
		public bool is_writable ();
		[ReturnsModifiedPointer]
		public void make_writable ();
		public Gst.MiniObject @ref ();
		public static void replace (ref Gst.MiniObject? oldobj, Gst.MiniObject? newobj);
		public void unref ();
	}
	[CCode (ref_function = "gst_object_ref", unref_function = "gst_object_unref", cheader_filename = "gst/gst.h")]
	public abstract class Object : GLib.Object {
		public Gst.ObjectFlags flags;
		public weak GLib.Mutex @lock;
		public weak string name_prefix;
		public weak Gst.Object parent;
		public static bool check_uniqueness (GLib.List<Gst.Object> list, string name);
		public static void default_deep_notify (GLib.Object object, Gst.Object orig, GLib.ParamSpec pspec, string? excluded_props);
		public void default_error (GLib.Error error, string? debug);
		[CCode (cname = "GST_OBJECT_FLAG_IS_SET")]
		public bool flag_is_set (Gst.ObjectFlags flag);
		[CCode (cname = "GST_OBJECT_FLAG_SET")]
		public void flag_set (Gst.ObjectFlags flag);
		[CCode (cname = "GST_OBJECT_FLAG_UNSET")]
		public void flag_unset (Gst.ObjectFlags flag);
		public string get_name ();
		public string get_name_prefix ();
		public Gst.Object get_parent ();
		public string get_path_string ();
		public bool has_ancestor (Gst.Object ancestor);
		[CCode (cname = "GST_OBJECT_IS_DISPOSING")]
		public bool is_disposing ();
		[CCode (cname = "GST_OBJECT_IS_FLOATING")]
		public bool is_floating ();
		public Gst.Object @ref ();
		public void ref_sink ();
		public static void replace (ref Gst.Object? oldobj, Gst.Object? newobj);
		public virtual void restore_thyself (void* self);
		public virtual void* save_thyself (void* parent);
		public bool set_name (string name);
		public void set_name_prefix (string name_prefix);
		public bool set_parent (Gst.Object parent);
		public void sink ();
		public void unparent ();
		public void unref ();
		public string name { get; set construct; }
		public virtual signal void deep_notify (Gst.Object orig, GLib.ParamSpec pspec);
		public virtual signal void object_saved (void* parent);
		public virtual signal void parent_set (Gst.Object parent);
		public virtual signal void parent_unset (Gst.Object parent);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class Pad : Gst.Object {
		public void* abidata;
		public weak Gst.PadAcceptCapsFunction acceptcapsfunc;
		public weak Gst.PadActivateFunction activatefunc;
		public weak Gst.PadActivateModeFunction activatepullfunc;
		public weak Gst.PadActivateModeFunction activatepushfunc;
		public weak Gst.PadBlockCallback block_callback;
		public weak GLib.Cond block_cond;
		public void* block_data;
		public weak GLib.DestroyNotify block_destroy_data;
		public weak Gst.PadBufferAllocFunction bufferallocfunc;
		public weak Gst.PadChainFunction chainfunc;
		public weak Gst.PadCheckGetRangeFunction checkgetrangefunc;
		public int do_buffer_signals;
		public int do_event_signals;
		public void* element_private;
		public weak Gst.PadEventFunction eventfunc;
		public weak Gst.PadFixateCapsFunction fixatecapsfunc;
		public weak Gst.PadGetCapsFunction getcapsfunc;
		public weak Gst.PadGetRangeFunction getrangefunc;
		public weak Gst.PadIntLinkFunction intlinkfunc;
		public weak Gst.PadIterIntLinkFunction iterintlinkfunc;
		public weak Gst.PadLinkFunction linkfunc;
		public Gst.ActivateMode mode;
		public weak Gst.PadTemplate padtemplate;
		public weak Gst.Pad peer;
		public weak GLib.Cond preroll_cond;
		public weak GLib.Mutex preroll_lock;
		public weak Gst.PadQueryFunction queryfunc;
		public void* sched_private;
		public weak Gst.PadSetCapsFunction setcapsfunc;
		public void* stream_rec_lock;
		public weak Gst.Task task;
		public weak Gst.PadUnlinkFunction unlinkfunc;
		[CCode (array_length_pos = 0, delegate_target_pos = 0)]
		public Pad (string name, Gst.PadDirection direction);
		public bool accept_caps (Gst.Caps caps);
		public bool activate_pull (bool active);
		public bool activate_push (bool active);
		public uint add_buffer_probe (Gst.BufferProbeCallback handler);
		public uint add_buffer_probe_full (Gst.BufferProbeCallback handler, GLib.DestroyNotify notify);
		public uint add_data_probe (Gst.DataProbeCallback handler);
		public uint add_data_probe_full (Gst.DataProbeCallback handler, GLib.DestroyNotify notify);
		public uint add_event_probe (Gst.EventProbeCallback handler);
		public uint add_event_probe_full (Gst.EventProbeCallback handler, GLib.DestroyNotify notify);
		public Gst.FlowReturn alloc_buffer (uint64 offset, int size, Gst.Caps caps, out unowned Gst.Buffer buf);
		public Gst.FlowReturn alloc_buffer_and_set_caps (uint64 offset, int size, Gst.Caps caps, out unowned Gst.Buffer buf);
		public bool can_link (Gst.Pad sinkpad);
		public Gst.FlowReturn chain (owned Gst.Buffer buffer);
		public Gst.FlowReturn chain_list (Gst.BufferList list);
		public bool check_pull_range ();
		public bool dispatcher (Gst.PadDispatcherFunction dispatch, void* data);
		public bool event_default (Gst.Event event);
		public void fixate_caps (Gst.Caps caps);
		[CCode (has_construct_function = false)]
		public Pad.from_static_template (Gst.StaticPadTemplate templ, string name);
		[CCode (has_construct_function = false)]
		public Pad.from_template (Gst.PadTemplate templ, string name);
		public Gst.Caps get_allowed_caps ();
		public Gst.Caps get_caps ();
		public unowned Gst.Caps get_caps_reffed ();
		public Gst.PadDirection get_direction ();
		public void* get_element_private ();
		public unowned Gst.Caps get_fixed_caps_func ();
		public unowned GLib.List get_internal_links ();
		public unowned GLib.List get_internal_links_default ();
		public Gst.Caps get_negotiated_caps ();
		public unowned Gst.PadTemplate get_pad_template ();
		public unowned Gst.Caps get_pad_template_caps ();
		public unowned Gst.Element get_parent_element ();
		public Gst.Pad get_peer ();
		public Gst.QueryType get_query_types ();
		public Gst.QueryType get_query_types_default ();
		public Gst.FlowReturn get_range (uint64 offset, uint size, out unowned Gst.Buffer buffer);
		public bool is_active ();
		public bool is_blocked ();
		public bool is_blocking ();
		public bool is_linked ();
		public Gst.Iterator<Gst.Pad> iterate_internal_links ();
		public Gst.Iterator<Gst.Pad> iterate_internal_links_default ();
		public Gst.PadLinkReturn link (Gst.Pad sinkpad);
		public void load_and_link (Gst.Object parent);
		public bool pause_task ();
		public bool peer_accept_caps (Gst.Caps caps);
		public Gst.Caps peer_get_caps ();
		public unowned Gst.Caps peer_get_caps_reffed ();
		public bool peer_query (Gst.Query query);
		public unowned Gst.Caps proxy_getcaps ();
		public bool proxy_setcaps (Gst.Caps caps);
		public Gst.FlowReturn pull_range (uint64 offset, uint size, out unowned Gst.Buffer buffer);
		public Gst.FlowReturn push (owned Gst.Buffer buffer);
		public bool push_event (owned Gst.Event event);
		public Gst.FlowReturn push_list (Gst.BufferList list);
		public bool query (Gst.Query query);
		public bool query_convert (Gst.Format src_format, int64 src_val, ref Gst.Format dest_format, out int64 dest_val);
		public bool query_default (Gst.Query query);
		public bool query_duration (ref Gst.Format format, out int64 duration);
		public bool query_peer_convert (Gst.Format src_format, int64 src_val, ref Gst.Format dest_format, out int64 dest_val);
		public bool query_peer_duration (ref Gst.Format format, out int64 duration);
		public bool query_peer_position (ref Gst.Format format, out int64 cur);
		public bool query_position (ref Gst.Format format, out int64 cur);
		public void remove_buffer_probe (uint handler_id);
		public void remove_data_probe (uint handler_id);
		public void remove_event_probe (uint handler_id);
		public bool send_event (owned Gst.Event event);
		public void set_acceptcaps_function (Gst.PadAcceptCapsFunction acceptcaps);
		public void set_activate_function (Gst.PadActivateFunction activate);
		public void set_activatepull_function (Gst.PadActivateModeFunction activatepull);
		public void set_activatepush_function (Gst.PadActivateModeFunction activatepush);
		public bool set_active (bool active);
		public bool set_blocked (bool blocked);
		public bool set_blocked_async (bool blocked, Gst.PadBlockCallback callback);
		public bool set_blocked_async_full (bool blocked, Gst.PadBlockCallback callback, GLib.DestroyNotify destroy_data);
		public void set_bufferalloc_function (Gst.PadBufferAllocFunction bufalloc);
		public bool set_caps (Gst.Caps? caps);
		public void set_chain_function (Gst.PadChainFunction chain);
		public void set_chain_list_function (Gst.PadChainListFunction chainlist);
		public void set_checkgetrange_function (Gst.PadCheckGetRangeFunction check);
		public void set_element_private (void* priv);
		public void set_event_function (Gst.PadEventFunction event);
		public void set_fixatecaps_function (Gst.PadFixateCapsFunction fixatecaps);
		public void set_getcaps_function (Gst.PadGetCapsFunction getcaps);
		public void set_getrange_function (Gst.PadGetRangeFunction @get);
		public void set_internal_link_function (Gst.PadIntLinkFunction intlink);
		public void set_iterate_internal_links_function (Gst.PadIterIntLinkFunction iterintlink);
		public void set_link_function (Gst.PadLinkFunction link);
		public void set_query_function (Gst.PadQueryFunction query);
		public void set_setcaps_function (Gst.PadSetCapsFunction setcaps);
		public void set_unlink_function (Gst.PadUnlinkFunction unlink);
		public bool start_task (Gst.TaskFunction func);
		public bool stop_task ();
		public bool unlink (Gst.Pad sinkpad);
		public void use_fixed_caps ();
		[NoAccessorMethod]
		public Gst.Caps caps { owned get; }
		public Gst.PadDirection direction { get; construct; }
		[NoAccessorMethod]
		public Gst.PadTemplate template { owned get; set; }
		public virtual signal bool have_data (Gst.MiniObject data);
		public virtual signal void linked (Gst.Pad peer);
		public virtual signal void request_link ();
		public virtual signal void unlinked (Gst.Pad peer);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class PadTemplate : Gst.Object {
		[CCode (has_construct_function = false)]
		public PadTemplate (string name_template, Gst.PadDirection direction, Gst.PadPresence presence, owned Gst.Caps caps);
		public unowned Gst.Caps get_caps ();
		public Gst.Caps caps { get; construct; }
		[NoAccessorMethod]
		public Gst.PadDirection direction { get; construct; }
		[NoAccessorMethod]
		public string name_template { owned get; construct; }
		[NoAccessorMethod]
		public Gst.PadPresence presence { get; construct; }
		[HasEmitter]
		public virtual signal void pad_created (Gst.Pad pad);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class ParamSpecFraction : GLib.ParamSpec {
		public int def_den;
		public int def_num;
		public int max_den;
		public int max_num;
		public int min_den;
		public int min_num;
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class ParamSpecMiniObject : GLib.ParamSpec {
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class ParseContext {
		[CCode (has_construct_function = false)]
		public ParseContext ();
		public unowned string get_missing_elements ();
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class Pipeline : Gst.Bin, Gst.ChildProxy {
		public weak Gst.Clock fixed_clock;
		public Gst.ClockTime stream_time;
		[CCode (type = "GstElement*", has_construct_function = false)]
		public Pipeline (string? name);
		public void auto_clock ();
		public bool get_auto_flush_bus ();
		public Gst.Bus get_bus ();
		public unowned Gst.Clock get_clock ();
		public Gst.ClockTime get_delay ();
		public Gst.ClockTime get_last_stream_time ();
		public void set_auto_flush_bus (bool auto_flush);
		public bool set_clock (Gst.Clock clock);
		public void set_delay (Gst.ClockTime delay);
		public void set_new_stream_time (Gst.ClockTime time);
		public void use_clock (Gst.Clock clock);
		public bool auto_flush_bus { get; set; }
		public uint64 delay { get; set; }
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class Plugin : Gst.Object {
		public weak string basename;
		public Gst.PluginDesc desc;
		public ulong file_mtime;
		public int64 file_size;
		public weak string filename;
		public uint flags;
		public weak GLib.Module module;
		public Gst.PluginDesc orig_desc;
		public bool registered;
		public void add_dependency (string env_vars, string paths, string names, Gst.PluginDependencyFlags flags);
		public void add_dependency_simple (string env_vars, string paths, string names, Gst.PluginDependencyFlags flags);
		public static GLib.Quark error_quark ();
		public unowned Gst.Structure get_cache_data ();
		public unowned string get_description ();
		public unowned string get_filename ();
		public unowned string get_license ();
		public unowned GLib.Module get_module ();
		public unowned string get_name ();
		public unowned string get_origin ();
		public unowned string get_package ();
		public unowned string get_source ();
		public unowned string get_version ();
		public bool is_loaded ();
		public static void list_free (GLib.List list);
		public unowned Gst.Plugin load ();
		public static unowned Gst.Plugin load_by_name (string name);
		public static unowned Gst.Plugin load_file (string filename) throws GLib.Error;
		public bool name_filter (string name);
		public static bool register_static (int major_version, int minor_version, string name, string description, Gst.PluginInitFunc init_func, string version, string license, string source, string package, string origin);
		public static bool register_static_full (int major_version, int minor_version, string name, string description, Gst.PluginInitFullFunc init_full_func, string version, string license, string source, string package, string origin);
		public void set_cache_data (Gst.Structure cache_data);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class PluginFeature : Gst.Object {
		public bool loaded;
		public weak string name;
		public weak string plugin_name;
		public uint rank;
		public bool check_version (uint min_major, uint min_minor, uint min_micro);
		public unowned string get_name ();
		public uint get_rank ();
		public static unowned GLib.List list_copy (GLib.List list);
		public static void list_free (GLib.List list);
		public unowned Gst.PluginFeature load ();
		public void set_name (string name);
		public void set_rank (uint rank);
		public bool type_name_filter (Gst.TypeNameData data);
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class Poll {
		[CCode (has_construct_function = false)]
		public Poll (bool controllable);
		public bool add_fd (Gst.PollFD fd);
		public bool read_control ();
		public bool remove_fd (Gst.PollFD fd);
		public void restart ();
		public bool set_controllable (bool controllable);
		public void set_flushing (bool flushing);
		[CCode (has_construct_function = false)]
		public Poll.timer ();
		public int wait (Gst.ClockTime timeout);
		public bool write_control ();
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class PollFD {
		public int fd;
		public int idx;
		public static bool can_read (Gst.Poll @set, Gst.PollFD fd);
		public static bool can_write (Gst.Poll @set, Gst.PollFD fd);
		public static bool ctl_read (Gst.Poll @set, Gst.PollFD fd, bool active);
		public static bool ctl_write (Gst.Poll @set, Gst.PollFD fd, bool active);
		public static bool has_closed (Gst.Poll @set, Gst.PollFD fd);
		public static bool has_error (Gst.Poll @set, Gst.PollFD fd);
		public static void ignored (Gst.Poll @set, Gst.PollFD fd);
		public void init ();
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class ProxyPad : Gst.Pad {
	}
	[CCode (ref_function = "gst_query_ref", unref_function = "gst_query_unref", cheader_filename = "gst/gst.h")]
	public class Query : Gst.MiniObject {
		public weak Gst.Structure structure;
		public Gst.QueryType type;
		[CCode (has_construct_function = false)]
		public Query.application (Gst.QueryType type, Gst.Structure structure);
		[CCode (has_construct_function = false)]
		public Query.buffering (Gst.Format format);
		[CCode (has_construct_function = false)]
		public Query.convert (Gst.Format src_format, int64 value, Gst.Format dest_format);
		public Gst.Query copy ();
		[CCode (has_construct_function = false)]
		public Query.duration (Gst.Format format);
		[CCode (has_construct_function = false)]
		public Query.formats ();
		public unowned Gst.Structure get_structure ();
		[CCode (has_construct_function = false)]
		public Query.latency ();
		[ReturnsModifiedPointer]
		public void make_writable ();
		public void parse_buffering_percent (bool busy, int percent);
		public void parse_buffering_range (Gst.Format format, int64 start, int64 stop, int64 estimated_total);
		public void parse_buffering_stats (Gst.BufferingMode mode, int avg_in, int avg_out, int64 buffering_left);
		public void parse_convert (out Gst.Format src_format, out int64 src_value, out Gst.Format dest_format, out int64 dest_value);
		public void parse_duration (out Gst.Format format, out int64 duration);
		public void parse_formats_length (out uint n_formats);
		public void parse_formats_nth (uint nth, out Gst.Format format);
		public void parse_latency (out bool live, out Gst.ClockTime min_latency, out Gst.ClockTime max_latency);
		public void parse_position (out Gst.Format format, out int64 cur);
		public void parse_seeking (out Gst.Format format, out bool seekable, out int64 segment_start, out int64 segment_end);
		public void parse_segment (out double rate, out Gst.Format format, out int64 start_value, out int64 stop_value);
		public void parse_uri (string uri);
		[CCode (has_construct_function = false)]
		public Query.position (Gst.Format format);
		public Gst.Query @ref ();
		[CCode (has_construct_function = false)]
		public Query.seeking (Gst.Format format);
		[CCode (has_construct_function = false)]
		public Query.segment (Gst.Format format);
		public void set_buffering_percent (bool busy, int percent);
		public void set_buffering_range (Gst.Format format, int64 start, int64 stop, int64 estimated_total);
		public void set_buffering_stats (Gst.BufferingMode mode, int avg_in, int avg_out, int64 buffering_left);
		public void set_convert (Gst.Format src_format, int64 src_value, Gst.Format dest_format, int64 dest_value);
		public void set_duration (Gst.Format format, int64 duration);
		public void set_formats (int n_formats);
		public void set_formatsv (int n_formats, Gst.Format formats);
		public void set_latency (bool live, Gst.ClockTime min_latency, Gst.ClockTime max_latency);
		public void set_position (Gst.Format format, int64 cur);
		public void set_seeking (Gst.Format format, bool seekable, int64 segment_start, int64 segment_end);
		public void set_segment (double rate, Gst.Format format, int64 start_value, int64 stop_value);
		public void set_uri (string uri);
		public static Gst.QueryType type_get_by_nick (string nick);
		public static unowned Gst.QueryTypeDefinition type_get_details (Gst.QueryType type);
		public static Gst.Iterator<Gst.QueryTypeDefinition> type_iterate_definitions ();
		public static Gst.QueryType type_register (string nick, string description);
		public static GLib.Quark type_to_quark (Gst.QueryType query);
		public static bool types_contains (Gst.QueryType types, Gst.QueryType type);
		public void unref ();
		[CCode (has_construct_function = false)]
		public Query.uri ();
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class QueryTypeDefinition {
		public weak string description;
		public weak string nick;
		public GLib.Quark quark;
		public Gst.QueryType value;
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class Registry : Gst.Object {
		public weak GLib.HashTable basename_hash;
		public int cache_file;
		public weak GLib.HashTable feature_hash;
		public weak GLib.List features;
		public weak GLib.List paths;
		public weak GLib.List plugins;
		public bool add_feature (Gst.PluginFeature feature);
		public void add_path (string path);
		public bool add_plugin (Gst.Plugin plugin);
		public GLib.List<Gst.PluginFeature> feature_filter ([CCode (delegate_target_pos = 2.1)] Gst.PluginFeatureFilter filter, bool first);
		public Gst.PluginFeature find_feature (string name, GLib.Type type);
		public Gst.Plugin find_plugin (string name);
		public static bool fork_is_enabled ();
		public static void fork_set_enabled (bool enabled);
		public static unowned Gst.Registry get_default ();
		public GLib.List<Gst.PluginFeature> get_feature_list (GLib.Type type);
		public GLib.List<Gst.PluginFeature> get_feature_list_by_plugin (string name);
		public uint32 get_feature_list_cookie ();
		public GLib.List<string> get_path_list ();
		public GLib.List<Gst.Plugin> get_plugin_list ();
		public Gst.Plugin lookup (string filename);
		public Gst.PluginFeature lookup_feature (string name);
		public GLib.List<Gst.Plugin> plugin_filter (Gst.PluginFilter filter, bool first);
		public void remove_feature (Gst.PluginFeature feature);
		public void remove_plugin (Gst.Plugin plugin);
		public bool scan_path (string path);
		public bool xml_read_cache (string location);
		public bool xml_write_cache (string location);
		public virtual signal void feature_added (void* feature);
		public virtual signal void plugin_added (void* plugin);
	}
	[Compact]
	[CCode (copy_function = "gst_segment_copy", type_id = "GST_TYPE_SEGMENT", cheader_filename = "gst/gst.h")]
	public class Segment {
		public double abs_rate;
		public int64 accum;
		public double applied_rate;
		public int64 duration;
		public Gst.SeekFlags flags;
		public Gst.Format format;
		public int64 last_stop;
		public double rate;
		public int64 start;
		public int64 stop;
		public int64 time;
		[CCode (has_construct_function = false)]
		public Segment ();
		public bool clip (Gst.Format format, int64 start, int64 stop, out int64 clip_start, out int64 clip_stop);
		public Gst.Segment copy ();
		public void init (Gst.Format format);
		public void set_duration (Gst.Format format, int64 duration);
		public void set_last_stop (Gst.Format format, int64 position);
		public void set_newsegment (bool update, double rate, Gst.Format format, int64 start, int64 stop, int64 time);
		public void set_newsegment_full (bool update, double rate, double applied_rate, Gst.Format format, int64 start, int64 stop, int64 time);
		public bool set_running_time (Gst.Format format, int64 running_time);
		public void set_seek (double rate, Gst.Format format, Gst.SeekFlags flags, Gst.SeekType start_type, int64 start, Gst.SeekType stop_type, int64 stop, bool update);
		public int64 to_position (Gst.Format format, int64 running_time);
		public int64 to_running_time (Gst.Format format, int64 position);
		public int64 to_stream_time (Gst.Format format, int64 position);
	}
	[Compact]
	[Immutable]
	[CCode (copy_function = "gst_structure_copy", type_id = "GST_TYPE_STRUCTURE", cheader_filename = "gst/gst.h")]
	public class Structure {
		public weak GLib.Array fields;
		public GLib.Quark name;
		public int parent_refcount;
		public GLib.Type type;
		[CCode (has_construct_function = false)]
		public Structure (string name, string firstfield, ...);
		public Gst.Structure copy ();
		[CCode (cname = "gst_structure_empty_new", has_construct_function = false)]
		public Structure.empty (string name);
		public bool fixate_field_boolean (string field_name, bool target);
		public bool fixate_field_nearest_double (string field_name, double target);
		public bool fixate_field_nearest_fraction (string field_name, int target_numerator, int target_denominator);
		public bool fixate_field_nearest_int (string field_name, int target);
		public bool @foreach (Gst.StructureForeachFunc func);
		public static Gst.Structure? from_string (string str, out unowned string end);
		public bool @get (...);
		public bool get_boolean (string fieldname, out bool value);
		public bool get_clock_time (string fieldname, out Gst.ClockTime value);
		public bool get_date (string fieldname, out GLib.Date value);
		public bool get_double (string fieldname, out double value);
		public bool get_enum (string fieldname, GLib.Type enumtype, out int value);
		public GLib.Type get_field_type (string fieldname);
		public bool get_fourcc (string fieldname, out uint32 value);
		public bool get_fraction (string fieldname, out int value_numerator, out int value_denominator);
		public bool get_int (string fieldname, out int value);
		public unowned string get_name ();
		public GLib.Quark get_name_id ();
		public unowned string get_string (string fieldname);
		public bool get_uint (string fieldname, out uint value);
		public bool get_valist (string first_fieldname, void* args);
		public unowned Gst.Value? get_value (string fieldname);
		public bool has_field (string fieldname);
		public bool has_field_typed (string fieldname, GLib.Type type);
		public bool has_name (string name);
		[CCode (cname = "gst_structure_id_empty_new", has_construct_function = false)]
		public Structure.id_empty (GLib.Quark quark);
		public bool id_get (...);
		public bool id_get_valist (GLib.Quark first_field_id, void* args);
		public unowned Gst.Value? id_get_value (GLib.Quark field);
		public bool id_has_field (GLib.Quark field);
		public bool id_has_field_typed (GLib.Quark field, GLib.Type type);
		public static unowned Gst.Structure id_new (GLib.Quark name_quark, GLib.Quark field_quark);
		public void id_set (GLib.Quark fieldname, ...);
		public void id_set_valist (GLib.Quark fieldname, void* varargs);
		public void id_set_value (GLib.Quark field, Gst.Value value);
		public bool map_in_place (Gst.StructureMapFunc func);
		public int n_fields ();
		public unowned string nth_field_name (uint index);
		public void remove_all_fields ();
		public void remove_field (string fieldname);
		public void remove_fields (string fieldname, ...);
		public void remove_fields_valist (string fieldname, void* varargs);
		public void @set (string fieldname, ...);
		public void set_name (string name);
		public void set_parent_refcount (int refcount);
		public void set_valist (string fieldname, void* varargs);
		public void set_value (string fieldname, Gst.Value value);
		public string to_string ();
		[CCode (has_construct_function = false)]
		public Structure.valist (string name, string firstfield, void* varargs);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class SystemClock : Gst.Clock {
		public bool stopping;
		public weak GLib.Thread thread;
		public static unowned Gst.Clock obtain ();
		[NoAccessorMethod]
		public Gst.ClockType clock_type { get; set; }
	}
	[Compact]
	[CCode (copy_function = "gst_tag_list_copy", cheader_filename = "gst/gst.h")]
	public class TagList {
		[CCode (has_construct_function = false)]
		public TagList ();
		public void add (Gst.TagMergeMode mode, string tag, ...);
		public void add_valist (Gst.TagMergeMode mode, string tag, void* var_args);
		public void add_valist_values (Gst.TagMergeMode mode, string tag, void* var_args);
		public void add_value (Gst.TagMergeMode mode, string tag, Gst.Value value);
		public void add_values (Gst.TagMergeMode mode, string tag, ...);
		public Gst.TagList copy ();
		public static bool copy_value (out Gst.Value dest, Gst.TagList list, string tag);
		public void @foreach (Gst.TagForeachFunc func);
		[CCode (has_construct_function = false)]
		public TagList.full (string tag);
		[CCode (has_construct_function = false)]
		public TagList.full_valist (void* var_args);
		public bool get_boolean (string tag, out bool value);
		public bool get_boolean_index (string tag, uint index, out bool value);
		public bool get_buffer (string tag, out unowned Gst.Buffer value);
		public bool get_buffer_index (string tag, uint index, out unowned Gst.Buffer value);
		public bool get_char (string tag, out char value);
		public bool get_char_index (string tag, uint index, out char value);
		public bool get_date (string tag, out GLib.Date? value);
		public bool get_date_index (string tag, uint index, out GLib.Date? value);
		public bool get_double (string tag, out double value);
		public bool get_double_index (string tag, uint index, out double value);
		public bool get_float (string tag, out float value);
		public bool get_float_index (string tag, uint index, out float value);
		public bool get_int (string tag, out int value);
		public bool get_int64 (string tag, out int64 value);
		public bool get_int64_index (string tag, uint index, out int64 value);
		public bool get_int_index (string tag, uint index, out int value);
		public bool get_long (string tag, out long value);
		public bool get_long_index (string tag, uint index, out long value);
		public bool get_pointer (string tag, out void* value);
		public bool get_pointer_index (string tag, uint index, out void* value);
		public bool get_string (string tag, out string value);
		public bool get_string_index (string tag, uint index, out string value);
		public uint get_tag_size (string tag);
		public bool get_uchar (string tag, out uchar value);
		public bool get_uchar_index (string tag, uint index, out uchar value);
		public bool get_uint (string tag, out uint value);
		public bool get_uint64 (string tag, out uint64 value);
		public bool get_uint64_index (string tag, uint index, out uint64 value);
		public bool get_uint_index (string tag, uint index, out uint value);
		public bool get_ulong (string tag, out ulong value);
		public bool get_ulong_index (string tag, uint index, out ulong value);
		public unowned Gst.Value? get_value_index (string tag, uint index);
		public void insert (Gst.TagList from, Gst.TagMergeMode mode);
		public bool is_empty ();
		public Gst.TagList merge (Gst.TagList list2, Gst.TagMergeMode mode);
		public void remove_tag (string tag);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class Task : Gst.Object {
		public void* abidata;
		public weak GLib.Cond cond;
		public void* data;
		public weak Gst.TaskFunction func;
		public void* @lock;
		public bool running;
		public Gst.TaskState state;
		public static void cleanup_all ();
		public static unowned Gst.Task create (Gst.TaskFunction func, void* data);
		public unowned Gst.TaskPool get_pool ();
		public Gst.TaskState get_state ();
		public bool join ();
		public bool pause ();
		public void set_lock (void* mutex);
		public void set_pool (Gst.TaskPool pool);
		public void set_priority (GLib.ThreadPriority priority);
		public bool set_state (Gst.TaskState state);
		public void set_thread_callbacks (Gst.TaskThreadCallbacks callbacks, GLib.DestroyNotify notify);
		public bool start ();
		public bool stop ();
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class TaskPool : Gst.Object {
		public weak GLib.ThreadPool pool;
		[CCode (has_construct_function = false)]
		public TaskPool ();
		public virtual void cleanup ();
		public virtual void join (void* id);
		public virtual void prepare () throws GLib.Error;
		public virtual void* push (Gst.TaskPoolFunction func) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class TaskThreadCallbacks {
		public weak GLib.Callback enter_thread;
		public weak GLib.Callback leave_thread;
	}
	[Compact]
	[CCode (free_function = "gst_trace_destroy", cheader_filename = "gst/gst.h")]
	public class Trace {
		public weak Gst.TraceEntry buf;
		public int bufoffset;
		public int bufsize;
		public int fd;
		public weak string filename;
		[CCode (has_construct_function = false)]
		public Trace (string filename, int size);
		public void flush ();
		public static void read_tsc (int64 dst);
		public void set_default ();
		public void text_flush ();
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class TraceEntry {
		public uint32 data;
		[CCode (array_length = false)]
		public weak char[] message;
		public uint32 sequence;
		public int64 timestamp;
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class TypeFind {
		public void* data;
		[CCode (cname = "gst_type_find_get_length")]
		public uint64 get_length ();
		[CCode (cname = "gst_type_find_peek")]
		public uchar peek (int64 offset, uint size);
		[CCode (cname = "gst_type_find_register")]
		public static bool register (Gst.Plugin plugin, string name, uint rank, Gst.TypeFindFunction func, string extensions, Gst.Caps possible_caps, void* data, GLib.DestroyNotify data_notify);
		[CCode (cname = "gst_type_find_suggest")]
		public void suggest (uint probability, Gst.Caps caps);
		[CCode (cname = "gst_type_find_suggest_simple")]
		public void suggest_simple (uint probability, string media_type, string fieldname);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class TypeFindFactory : Gst.PluginFeature {
		public weak Gst.Caps caps;
		public weak string extensions;
		public weak Gst.TypeFindFunction function;
		public void* user_data;
		public weak GLib.DestroyNotify user_data_notify;
		[CCode (cname = "gst_type_find_factory_call_function")]
		public void call_function (Gst.TypeFind find);
		[CCode (cname = "gst_type_find_factory_get_caps")]
		public unowned Gst.Caps get_caps ();
		[CCode (cname = "gst_type_find_factory_get_extensions")]
		public unowned string get_extensions ();
		[CCode (cname = "gst_type_find_factory_get_list")]
		public static unowned GLib.List get_list ();
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class TypeNameData {
		public weak string name;
		public GLib.Type type;
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class ValueTable {
		public weak Gst.ValueCompareFunc compare;
		public weak Gst.ValueDeserializeFunc deserialize;
		public weak Gst.ValueSerializeFunc serialize;
		public GLib.Type type;
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class XML : Gst.Object {
		public void* ns;
		public weak GLib.List topelements;
		[CCode (has_construct_function = false)]
		public XML ();
		public unowned Gst.Element get_element (string name);
		public unowned GLib.List get_topelements ();
		public static unowned Gst.Element make_element (void* cur, Gst.Object parent);
		[NoWrapper]
		public virtual void object_saved (Gst.Object object, void* self);
		public bool parse_doc (void* doc, string root);
		public bool parse_file (string fname, string root);
		public bool parse_memory (uchar[] buffer, uint size, string root);
		public static void* write (Gst.Element element);
		public static int write_file (Gst.Element element, GLib.FileStream @out);
		public virtual signal void object_loaded (Gst.Object object, void* self);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public interface ChildProxy : Gst.Object {
		public void @get (string first_property_name, ...);
		public abstract Gst.Object? get_child_by_index (uint index);
		public Gst.Object? get_child_by_name (string name);
		public abstract uint get_children_count ();
		public void get_property (string name, ref Gst.Value value);
		public void get_valist (string first_property_name, void* var_args);
		public bool lookup (string name, out Gst.Object? target, out unowned GLib.ParamSpec? pspec);
		public void @set (string first_property_name, ...);
		public void set_property (string name, Gst.Value value);
		public void set_valist (string first_property_name, void* var_args);
		[HasEmitter]
		public signal void child_added (GLib.Object child);
		[HasEmitter]
		public signal void child_removed (GLib.Object child);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public interface ImplementsInterface : Gst.Element {
		public unowned Gst.Element? cast (GLib.Type type);
		public bool check (GLib.Type type);
		[NoWrapper]
		public abstract bool supported (GLib.Type iface_type);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public interface Preset {
		public abstract bool delete_preset (string name);
		public abstract bool get_meta (string name, string tag, string value);
		public abstract unowned string get_preset_names ();
		public abstract unowned string get_property_names ();
		public abstract bool load_preset (string name);
		public abstract bool rename_preset (string old_name, string new_name);
		public abstract bool save_preset (string name);
		public abstract bool set_meta (string name, string tag, string value);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public interface TagSetter : Gst.Element {
		public void add_tag_valist (Gst.TagMergeMode mode, string tag, void* var_args);
		public void add_tag_valist_values (Gst.TagMergeMode mode, string tag, void* var_args);
		public void add_tag_value (Gst.TagMergeMode mode, string tag, Gst.Value value);
		public void add_tag_values (Gst.TagMergeMode mode, string tag, ...);
		public void add_tags (Gst.TagMergeMode mode, string tag, ...);
		public unowned Gst.TagList get_tag_list ();
		public Gst.TagMergeMode get_tag_merge_mode ();
		public void merge_tags (Gst.TagList list, Gst.TagMergeMode mode);
		public void reset_tags ();
		public void set_tag_merge_mode (Gst.TagMergeMode mode);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public interface URIHandler {
		public abstract unowned string[] get_protocols ();
		[NoWrapper]
		public abstract unowned string[] get_protocols_full (GLib.Type type);
		[NoWrapper]
		public abstract Gst.URIType get_type ();
		[NoWrapper]
		public abstract Gst.URIType get_type_full (GLib.Type type);
		public abstract unowned string get_uri ();
		public uint get_uri_type ();
		public abstract bool set_uri (string uri);
		[HasEmitter]
		public signal void new_uri (string uri);
	}
	[CCode (type_id = "GST_TYPE_ARRAY", cheader_filename = "gst/gst.h")]
	public struct Array {
	}
	[CCode (cheader_filename = "gst/gst.h")]
	[SimpleType]
	[IntegerType (rank = 0)]
	public struct ClockTime : uint64 {
		[CCode (cname = "GST_TIME_ARGS")]
		public unowned string args ();
		[CCode (cname = "GST_CLOCK_TIME_IS_VALID")]
		public bool is_valid ();
	}
	[CCode (cheader_filename = "gst/gst.h")]
	[SimpleType]
	[IntegerType (rank = 0)]
	public struct ClockTimeDiff : int64 {
	}
	[CCode (type_id = "GST_TYPE_DOUBLE_RANGE", cheader_filename = "gst/gst.h")]
	public struct DoubleRange {
	}
	[CCode (type_id = "GST_TYPE_ELEMENT_DETAILS", cheader_filename = "gst/gst.h")]
	public struct ElementDetails {
		public weak string longname;
		public weak string klass;
		public weak string description;
		public weak string author;
	}
	[CCode (type_id = "GST_TYPE_FORMAT_DEFINITION", cheader_filename = "gst/gst.h")]
	public struct FormatDefinition {
		public Gst.Format value;
		public weak string nick;
		public weak string description;
		public GLib.Quark quark;
	}
	[CCode (type_id = "GST_TYPE_FRACTION", cheader_filename = "gst/gst.h")]
	public struct Fraction {
	}
	[CCode (type_id = "GST_TYPE_FRACTION_RANGE", cheader_filename = "gst/gst.h")]
	public struct FractionRange {
	}
	[CCode (type_id = "GST_TYPE_INDEX_ASSOCIATION", cheader_filename = "gst/gst.h")]
	public struct IndexAssociation {
		public Gst.Format format;
		public int64 value;
	}
	[CCode (type_id = "GST_TYPE_INT_RANGE", cheader_filename = "gst/gst.h")]
	public struct IntRange {
	}
	[CCode (type_id = "GST_TYPE_LIST", cheader_filename = "gst/gst.h")]
	public struct List {
	}
	[CCode (type_id = "GST_TYPE_PLUGIN_DESC", cheader_filename = "gst/gst.h")]
	public struct PluginDesc {
		public int major_version;
		public int minor_version;
		public weak string name;
		public weak string description;
		public weak Gst.PluginInitFunc plugin_init;
		public weak string version;
		public weak string license;
		public weak string source;
		public weak string package;
		public weak string origin;
		public weak void*[] _gst_reserved;
	}
	[CCode (type_id = "GST_TYPE_STATIC_CAPS", cheader_filename = "gst/gst.h")]
	public struct StaticCaps {
		[CCode (cname = "string")]
		public weak string str;
		public Gst.Caps @get ();
	}
	[CCode (type_id = "GST_TYPE_STATIC_PAD_TEMPLATE", cheader_filename = "gst/gst.h")]
	public struct StaticPadTemplate {
		public weak string name_template;
		public Gst.PadDirection direction;
		public Gst.PadPresence presence;
		public Gst.StaticCaps static_caps;
		public Gst.PadTemplate @get ();
		public Gst.Caps get_caps ();
	}
	[CCode (cname = "GValue", type_id = "G_TYPE_VALUE", cheader_filename = "gst/gst.h")]
	public struct Value : GLib.Value {
		public void array_append_value (Gst.Value append_value);
		public uint array_get_size ();
		public static GLib.Type array_get_type ();
		public unowned Gst.Value? array_get_value (uint index);
		public void array_prepend_value (Gst.Value prepend_value);
		public static bool can_compare (Gst.Value value1, Gst.Value value2);
		public static bool can_intersect (Gst.Value value1, Gst.Value value2);
		public static bool can_subtract (Gst.Value minuend, Gst.Value subtrahend);
		public static bool can_union (Gst.Value value1, Gst.Value value2);
		public static int compare (Gst.Value value1, Gst.Value value2);
		public bool deserialize (string src);
		public static bool fraction_multiply (GLib.Value product, GLib.Value factor1, GLib.Value factor2);
		public static bool fraction_subtract (GLib.Value dest, GLib.Value minuend, GLib.Value subtrahend);
		public unowned Gst.Buffer get_buffer ();
		public Gst.Caps get_caps ();
		public GLib.Date get_date ();
		public double get_double_range_max ();
		public double get_double_range_min ();
		public uint get_fourcc ();
		public int get_fraction_denominator ();
		public int get_fraction_numerator ();
		public unowned Gst.Value? get_fraction_range_max ();
		public unowned Gst.Value? get_fraction_range_min ();
		public int get_int_range_max ();
		public int get_int_range_min ();
		public unowned Gst.Structure get_structure ();
		public void init_and_copy (Gst.Value src);
		public static bool intersect (Gst.Value dest, Gst.Value value1, Gst.Value value2);
		public bool is_fixed ();
		public void list_append_value (Gst.Value append_value);
		public void list_concat (Gst.Value value1, Gst.Value value2);
		public uint list_get_size ();
		public static GLib.Type list_get_type ();
		public unowned Gst.Value? list_get_value (uint index);
		public void list_prepend_value (Gst.Value prepend_value);
		[CCode (cname = "GST_MAKE_FOURCC")]
		public static uint make_fourcc (char a, char b, char c, char d);
		public static void register (Gst.ValueTable table);
		public static void register_intersect_func (GLib.Type type1, GLib.Type type2, Gst.ValueIntersectFunc func);
		public static void register_subtract_func (GLib.Type minuend_type, GLib.Type subtrahend_type, Gst.ValueSubtractFunc func);
		public static void register_union_func (GLib.Type type1, GLib.Type type2, Gst.ValueUnionFunc func);
		public string serialize ();
		public void set_buffer (Gst.Buffer b);
		public void set_caps (Gst.Caps caps);
		public void set_date (GLib.Date date);
		public void set_double_range (double start, double end);
		public void set_fourcc (uint fourcc);
		public void set_fraction (int numerator, int denominator);
		public void set_fraction_range (Gst.Value start, Gst.Value end);
		public void set_fraction_range_full (int numerator_start, int denominator_start, int numerator_end, int denominator_end);
		public void set_int_range (int start, int end);
		public void set_structure (Gst.Structure structure);
		[CCode (cname = "GST_STR_FOURCC")]
		public static uint str_fourcc (string str);
		public static bool subtract (Gst.Value dest, Gst.Value minuend, Gst.Value subtrahend);
		public void take_buffer (Gst.Buffer b);
		public static bool union (Gst.Value dest, Gst.Value value1, Gst.Value value2);
	}
	[CCode (cprefix = "GST_ACTIVATE_", cheader_filename = "gst/gst.h")]
	public enum ActivateMode {
		NONE,
		PUSH,
		PULL
	}
	[CCode (cprefix = "GST_ALLOC_TRACE_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum AllocTraceFlags {
		LIVE,
		MEM_LIVE
	}
	[CCode (cprefix = "GST_ASSOCIATION_FLAG_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum AssocFlags {
		NONE,
		KEY_UNIT,
		DELTA_UNIT,
		LAST
	}
	[CCode (cprefix = "GST_BIN_FLAG_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum BinFlags {
		LAST
	}
	[CCode (cprefix = "GST_BUFFER_COPY_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum BufferCopyFlags {
		FLAGS,
		TIMESTAMPS,
		CAPS
	}
	[CCode (cprefix = "GST_BUFFER_FLAG_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum BufferFlag {
		READONLY,
		PREROLL,
		DISCONT,
		IN_CAPS,
		GAP,
		DELTA_UNIT,
		MEDIA1,
		MEDIA2,
		MEDIA3,
		LAST
	}
	[CCode (cprefix = "GST_BUFFER_LIST_", cheader_filename = "gst/gst.h")]
	public enum BufferListItem {
		CONTINUE,
		SKIP_GROUP,
		END
	}
	[CCode (cprefix = "GST_BUFFERING_", cheader_filename = "gst/gst.h")]
	public enum BufferingMode {
		STREAM,
		DOWNLOAD,
		TIMESHIFT,
		LIVE
	}
	[CCode (cprefix = "GST_BUS_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum BusFlags {
		FLUSHING,
		FLAG_LAST
	}
	[CCode (cprefix = "GST_BUS_", cheader_filename = "gst/gst.h")]
	public enum BusSyncReply {
		DROP,
		PASS,
		ASYNC
	}
	[CCode (cprefix = "GST_CAPS_FLAGS_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum CapsFlags {
		ANY
	}
	[CCode (cprefix = "GST_CLOCK_ENTRY_", cheader_filename = "gst/gst.h")]
	public enum ClockEntryType {
		SINGLE,
		PERIODIC
	}
	[CCode (cprefix = "GST_CLOCK_FLAG_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum ClockFlags {
		CAN_DO_SINGLE_SYNC,
		CAN_DO_SINGLE_ASYNC,
		CAN_DO_PERIODIC_SYNC,
		CAN_DO_PERIODIC_ASYNC,
		CAN_SET_RESOLUTION,
		CAN_SET_MASTER,
		LAST
	}
	[CCode (cprefix = "GST_CLOCK_", cheader_filename = "gst/gst.h")]
	public enum ClockReturn {
		OK,
		EARLY,
		UNSCHEDULED,
		BUSY,
		BADTIME,
		ERROR,
		UNSUPPORTED
	}
	[CCode (cprefix = "GST_CLOCK_TYPE_", cheader_filename = "gst/gst.h")]
	public enum ClockType {
		REALTIME,
		MONOTONIC
	}
	[CCode (cprefix = "GST_DEBUG_", cheader_filename = "gst/gst.h")]
	public enum DebugColorFlags {
		FG_BLACK,
		FG_RED,
		FG_GREEN,
		FG_YELLOW,
		FG_BLUE,
		FG_MAGENTA,
		FG_CYAN,
		FG_WHITE,
		BG_BLACK,
		BG_RED,
		BG_GREEN,
		BG_YELLOW,
		BG_BLUE,
		BG_MAGENTA,
		BG_CYAN,
		BG_WHITE,
		BOLD,
		UNDERLINE
	}
	[CCode (cprefix = "GST_DEBUG_GRAPH_SHOW_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum DebugGraphDetails {
		MEDIA_TYPE,
		CAPS_DETAILS,
		NON_DEFAULT_PARAMS,
		STATES,
		ALL
	}
	[CCode (cprefix = "GST_LEVEL_", cheader_filename = "gst/gst.h")]
	public enum DebugLevel {
		NONE,
		ERROR,
		WARNING,
		INFO,
		DEBUG,
		LOG,
		FIXME,
		MEMDUMP,
		COUNT;
		[CCode (cname = "gst_debug_level_get_name")]
		public unowned string to_string ();
	}
	[CCode (cprefix = "GST_ELEMENT_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum ElementFlags {
		LOCKED_STATE,
		IS_SINK,
		UNPARENTING,
		FLAG_LAST
	}
	[CCode (cprefix = "GST_EVENT_", cheader_filename = "gst/gst.h")]
	public enum EventType {
		UNKNOWN,
		FLUSH_START,
		FLUSH_STOP,
		EOS,
		NEWSEGMENT,
		TAG,
		BUFFERSIZE,
		SINK_MESSAGE,
		QOS,
		SEEK,
		NAVIGATION,
		LATENCY,
		STEP,
		CUSTOM_UPSTREAM,
		CUSTOM_DOWNSTREAM,
		CUSTOM_DOWNSTREAM_OOB,
		CUSTOM_BOTH,
		CUSTOM_BOTH_OOB;
		public Gst.EventTypeFlags get_flags ();
		public GLib.Quark to_quark ();
		public unowned string get_name ();
		[CCode (cname = "gst_event_type_get_name")]
		public unowned string to_string ();
	}
	[CCode (cprefix = "GST_EVENT_TYPE_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum EventTypeFlags {
		UPSTREAM,
		DOWNSTREAM,
		SERIALIZED
	}
	[CCode (cprefix = "GST_FLOW_", cheader_filename = "gst/gst.h")]
	public enum FlowReturn {
		CUSTOM_SUCCESS,
		RESEND,
		OK,
		NOT_LINKED,
		WRONG_STATE,
		UNEXPECTED,
		NOT_NEGOTIATED,
		ERROR,
		NOT_SUPPORTED,
		CUSTOM_ERROR;
		[CCode (cname = "gst_flow_get_name")]
		public unowned string to_string ();
	}
	[CCode (cprefix = "GST_FORMAT_", cheader_filename = "gst/gst.h")]
	public enum Format {
		UNDEFINED,
		DEFAULT,
		BYTES,
		TIME,
		BUFFERS,
		PERCENT;
		public Gst.FormatDefinition get_details ();
		public GLib.Quark to_quark ();
		public unowned string get_name ();
		[CCode (cname = "gst_format_get_name")]
		public unowned string to_string ();
		public const int64 PERCENT_MAX;
		public const int64 PERCENT_SCALE;
	}
	[CCode (cprefix = "GST_INDEX_", cheader_filename = "gst/gst.h")]
	public enum IndexCertainty {
		UNKNOWN,
		CERTAIN,
		FUZZY
	}
	[CCode (cprefix = "GST_INDEX_ENTRY_", cheader_filename = "gst/gst.h")]
	public enum IndexEntryType {
		ID,
		ASSOCIATION,
		OBJECT,
		FORMAT
	}
	[CCode (cprefix = "GST_INDEX_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum IndexFlags {
		WRITABLE,
		READABLE,
		FLAG_LAST
	}
	[CCode (cprefix = "GST_INDEX_LOOKUP_", cheader_filename = "gst/gst.h")]
	public enum IndexLookupMethod {
		EXACT,
		BEFORE,
		AFTER
	}
	[CCode (cprefix = "GST_INDEX_RESOLVER_", cheader_filename = "gst/gst.h")]
	public enum IndexResolverMethod {
		CUSTOM,
		GTYPE,
		PATH
	}
	[CCode (cprefix = "GST_ITERATOR_ITEM_", cheader_filename = "gst/gst.h")]
	public enum IteratorItem {
		SKIP,
		PASS,
		END
	}
	[CCode (cprefix = "GST_ITERATOR_", cheader_filename = "gst/gst.h")]
	public enum IteratorResult {
		DONE,
		OK,
		RESYNC,
		ERROR
	}
	[CCode (cprefix = "GST_LIBRARY_ERROR_", cheader_filename = "gst/gst.h")]
	public enum LibraryError {
		FAILED,
		TOO_LAZY,
		INIT,
		SHUTDOWN,
		SETTINGS,
		ENCODE,
		NUM_ERRORS
	}
	[CCode (cprefix = "GST_MESSAGE_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum MessageType {
		UNKNOWN,
		EOS,
		ERROR,
		WARNING,
		INFO,
		TAG,
		BUFFERING,
		STATE_CHANGED,
		STATE_DIRTY,
		STEP_DONE,
		CLOCK_PROVIDE,
		CLOCK_LOST,
		NEW_CLOCK,
		STRUCTURE_CHANGE,
		STREAM_STATUS,
		APPLICATION,
		ELEMENT,
		SEGMENT_START,
		SEGMENT_DONE,
		DURATION,
		LATENCY,
		ASYNC_START,
		ASYNC_DONE,
		REQUEST_STATE,
		STEP_START,
		ANY;
		public GLib.Quark to_quark ();
		public unowned string get_name ();
		[CCode (cname = "gst_message_type_get_name")]
		public unowned string to_string ();
	}
	[CCode (cprefix = "GST_MINI_OBJECT_FLAG_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum MiniObjectFlags {
		READONLY,
		LAST
	}
	[CCode (cprefix = "GST_OBJECT_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum ObjectFlags {
		DISPOSING,
		FLOATING,
		FLAG_LAST
	}
	[CCode (cprefix = "GST_PAD_", cheader_filename = "gst/gst.h")]
	public enum PadDirection {
		UNKNOWN,
		SRC,
		SINK
	}
	[CCode (cprefix = "GST_PAD_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum PadFlags {
		BLOCKED,
		FLUSHING,
		IN_GETCAPS,
		IN_SETCAPS,
		BLOCKING,
		FLAG_LAST
	}
	[CCode (cprefix = "GST_PAD_LINK_", cheader_filename = "gst/gst.h")]
	public enum PadLinkReturn {
		OK,
		WRONG_HIERARCHY,
		WAS_LINKED,
		WRONG_DIRECTION,
		NOFORMAT,
		NOSCHED,
		REFUSED
	}
	[CCode (cprefix = "GST_PAD_", cheader_filename = "gst/gst.h")]
	public enum PadPresence {
		ALWAYS,
		SOMETIMES,
		REQUEST
	}
	[CCode (cprefix = "GST_PAD_TEMPLATE_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum PadTemplateFlags {
		FIXED,
		FLAG_LAST
	}
	[CCode (cprefix = "GST_PARSE_ERROR_", cheader_filename = "gst/gst.h")]
	public enum ParseError {
		SYNTAX,
		NO_SUCH_ELEMENT,
		NO_SUCH_PROPERTY,
		LINK,
		COULD_NOT_SET_PROPERTY,
		EMPTY_BIN,
		EMPTY
	}
	[CCode (cprefix = "GST_PARSE_FLAG_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum ParseFlags {
		NONE,
		FATAL_ERRORS
	}
	[CCode (cprefix = "GST_PIPELINE_FLAG_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum PipelineFlags {
		FIXED_CLOCK,
		LAST
	}
	[CCode (cprefix = "GST_PLUGIN_DEPENDENCY_FLAG_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum PluginDependencyFlags {
		NONE,
		RECURSE,
		PATHS_ARE_DEFAULT_ONLY,
		FILE_NAME_IS_SUFFIX
	}
	[CCode (cprefix = "GST_PLUGIN_ERROR_", cheader_filename = "gst/gst.h")]
	public enum PluginError {
		MODULE,
		DEPENDENCIES,
		NAME_MISMATCH
	}
	[CCode (cprefix = "GST_PLUGIN_FLAG_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum PluginFlags {
		CACHED,
		BLACKLISTED
	}
	[CCode (cprefix = "GST_QUERY_", cheader_filename = "gst/gst.h")]
	public enum QueryType {
		NONE,
		POSITION,
		DURATION,
		LATENCY,
		JITTER,
		RATE,
		SEEKING,
		SEGMENT,
		CONVERT,
		FORMATS,
		BUFFERING,
		CUSTOM,
		URI;
		[CCode (cname = "gst_query_type_get_name")]
		public unowned string to_string ();
	}
	[CCode (cprefix = "GST_RANK_", cheader_filename = "gst/gst.h")]
	public enum Rank {
		NONE,
		MARGINAL,
		SECONDARY,
		PRIMARY
	}
	[CCode (cprefix = "GST_RESOURCE_ERROR_", cheader_filename = "gst/gst.h")]
	public enum ResourceError {
		FAILED,
		TOO_LAZY,
		NOT_FOUND,
		BUSY,
		OPEN_READ,
		OPEN_WRITE,
		OPEN_READ_WRITE,
		CLOSE,
		READ,
		WRITE,
		SEEK,
		SYNC,
		SETTINGS,
		NO_SPACE_LEFT,
		NUM_ERRORS
	}
	[CCode (cprefix = "GST_SEARCH_MODE_", cheader_filename = "gst/gst.h")]
	public enum SearchMode {
		EXACT,
		BEFORE,
		AFTER
	}
	[CCode (cprefix = "GST_SEEK_FLAG_", cheader_filename = "gst/gst.h")]
	[Flags]
	public enum SeekFlags {
		NONE,
		FLUSH,
		ACCURATE,
		KEY_UNIT,
		SEGMENT,
		SKIP
	}
	[CCode (cprefix = "GST_SEEK_TYPE_", cheader_filename = "gst/gst.h")]
	public enum SeekType {
		NONE,
		CUR,
		SET,
		END
	}
	[CCode (cprefix = "GST_STATE_", cheader_filename = "gst/gst.h")]
	public enum State {
		VOID_PENDING,
		NULL,
		READY,
		PAUSED,
		PLAYING;
		[CCode (cname = "GST_STATE_GET_NEXT")]
		public Gst.State get_next (Gst.State pending);
		[CCode (cname = "gst_element_state_get_name")]
		public unowned string to_string ();
	}
	[CCode (cprefix = "GST_STATE_CHANGE_", cheader_filename = "gst/gst.h")]
	public enum StateChange {
		NULL_TO_READY,
		READY_TO_PAUSED,
		PAUSED_TO_PLAYING,
		PLAYING_TO_PAUSED,
		PAUSED_TO_READY,
		READY_TO_NULL;
		[CCode (cname = "GST_STATE_TRANSITION")]
		public static Gst.StateChange transition (Gst.State cur, Gst.State next);
		[CCode (cname = "GST_STATE_TRANSITION_CURRENT")]
		public static Gst.State transition_current ();
		[CCode (cname = "GST_STATE_TRANSITION_NEXT")]
		public static Gst.State transition_next ();
	}
	[CCode (cprefix = "GST_STATE_CHANGE_", cheader_filename = "gst/gst.h")]
	public enum StateChangeReturn {
		FAILURE,
		SUCCESS,
		ASYNC,
		NO_PREROLL;
		[CCode (cname = "gst_element_state_change_return_get_name")]
		public unowned string to_string ();
	}
	[CCode (cprefix = "GST_STREAM_ERROR_", cheader_filename = "gst/gst.h")]
	public enum StreamError {
		FAILED,
		TOO_LAZY,
		NOT_IMPLEMENTED,
		TYPE_NOT_FOUND,
		WRONG_TYPE,
		CODEC_NOT_FOUND,
		DECODE,
		ENCODE,
		DEMUX,
		MUX,
		FORMAT,
		DECRYPT,
		DECRYPT_NOKEY,
		NUM_ERRORS
	}
	[CCode (cprefix = "GST_STREAM_STATUS_TYPE_", cheader_filename = "gst/gst.h")]
	public enum StreamStatusType {
		CREATE,
		ENTER,
		LEAVE,
		DESTROY,
		START,
		PAUSE,
		STOP
	}
	[CCode (cprefix = "GST_STRUCTURE_CHANGE_TYPE_PAD_", cheader_filename = "gst/gst.h")]
	public enum StructureChangeType {
		LINK,
		UNLINK
	}
	[CCode (cprefix = "GST_TAG_FLAG_", cheader_filename = "gst/gst.h")]
	public enum TagFlag {
		UNDEFINED,
		META,
		ENCODED,
		DECODED,
		COUNT
	}
	[CCode (cprefix = "GST_TAG_MERGE_", cheader_filename = "gst/gst.h")]
	public enum TagMergeMode {
		UNDEFINED,
		REPLACE_ALL,
		REPLACE,
		APPEND,
		PREPEND,
		KEEP,
		KEEP_ALL,
		COUNT
	}
	[CCode (cprefix = "GST_TASK_", cheader_filename = "gst/gst.h")]
	public enum TaskState {
		STARTED,
		STOPPED,
		PAUSED
	}
	[CCode (cprefix = "GST_TYPE_FIND_", cheader_filename = "gst/gst.h")]
	public enum TypeFindProbability {
		MINIMUM,
		POSSIBLE,
		LIKELY,
		NEARLY_CERTAIN,
		MAXIMUM
	}
	[CCode (cprefix = "GST_URI_", cheader_filename = "gst/gst.h")]
	public enum URIType {
		UNKNOWN,
		SINK,
		SRC
	}
	[CCode (cprefix = "GST_CORE_ERROR_", cheader_filename = "gst/gst.h")]
	public errordomain CoreError {
		FAILED,
		TOO_LAZY,
		NOT_IMPLEMENTED,
		STATE_CHANGE,
		PAD,
		THREAD,
		NEGOTIATION,
		EVENT,
		SEEK,
		CAPS,
		TAG,
		MISSING_PLUGIN,
		CLOCK,
		DISABLED,
		NUM_ERRORS,
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate unowned Gst.Buffer BufferListDoFunction (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate Gst.BufferListItem BufferListFunc (out unowned Gst.Buffer buffer, uint group, uint idx);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool BufferProbeCallback (Gst.Pad pad, Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool BusFunc (Gst.Bus bus, Gst.Message message);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate Gst.BusSyncReply BusSyncHandler (Gst.Bus bus, Gst.Message message);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool ClockCallback (Gst.Clock clock, Gst.ClockTime time, Gst.ClockID id);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate void* CopyFunction (void* object);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool DataProbeCallback (Gst.Pad pad, Gst.MiniObject data);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate void DebugFuncPtr ();
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool EventProbeCallback (Gst.Pad pad, Gst.Event event);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool FilterFunc (void* obj);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool IndexFilter (Gst.Index index, Gst.IndexEntry entry);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool IndexResolver (Gst.Index index, Gst.Object writer, string writer_string);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate void IteratorDisposeFunction (void* owner);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool IteratorFoldFunction (void* item, ref Gst.Value ret);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate void IteratorFreeFunction (Gst.Iterator it);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate Gst.IteratorItem IteratorItemFunction (Gst.Iterator it, void* item);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate Gst.IteratorResult IteratorNextFunction (Gst.Iterator it, out void* result);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate void IteratorResyncFunction (Gst.Iterator it);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate void LogFunction (Gst.DebugCategory category, Gst.DebugLevel level, string file, string function, int line, GLib.Object object, Gst.DebugMessage message);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate unowned Gst.MiniObject MiniObjectCopyFunction (Gst.MiniObject obj);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate void MiniObjectFinalizeFunction (Gst.MiniObject obj);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool PadAcceptCapsFunction (Gst.Pad pad, Gst.Caps caps);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool PadActivateFunction (Gst.Pad pad);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool PadActivateModeFunction (Gst.Pad pad, bool active);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate void PadBlockCallback (Gst.Pad pad, bool blocked);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate Gst.FlowReturn PadBufferAllocFunction (Gst.Pad pad, uint64 offset, uint size, Gst.Caps caps, out Gst.Buffer buf);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate Gst.FlowReturn PadChainFunction (Gst.Pad pad, owned Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate Gst.FlowReturn PadChainListFunction (Gst.Pad pad, Gst.BufferList list);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool PadCheckGetRangeFunction (Gst.Pad pad);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool PadDispatcherFunction (Gst.Pad pad);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool PadEventFunction (Gst.Pad pad, owned Gst.Event event);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate void PadFixateCapsFunction (Gst.Pad pad, Gst.Caps caps);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate unowned Gst.Caps PadGetCapsFunction (Gst.Pad pad);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate Gst.FlowReturn PadGetRangeFunction (Gst.Pad pad, uint64 offset, uint length, out Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate unowned GLib.List PadIntLinkFunction (Gst.Pad pad);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate unowned Gst.Iterator PadIterIntLinkFunction (Gst.Pad pad);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate Gst.PadLinkReturn PadLinkFunction (Gst.Pad pad, Gst.Pad peer);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool PadQueryFunction (Gst.Pad pad, Gst.Query query);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate Gst.QueryType PadQueryTypeFunction (Gst.Pad pad);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool PadSetCapsFunction (Gst.Pad pad, Gst.Caps caps);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate void PadUnlinkFunction (Gst.Pad pad);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool PluginFeatureFilter (Gst.PluginFeature feature);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool PluginFilter (Gst.Plugin plugin);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool PluginInitFullFunc (Gst.Plugin plugin);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool PluginInitFunc (Gst.Plugin plugin);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool StructureForeachFunc (GLib.Quark field_id, Gst.Value value);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate bool StructureMapFunc (GLib.Quark field_id, Gst.Value value);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate void TagForeachFunc (Gst.TagList list, string tag);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate void TagMergeFunc (Gst.Value dest, Gst.Value src);
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate void TaskFunction ();
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate void TaskPoolFunction ();
	[CCode (cheader_filename = "gst/gst.h")]
	public delegate void TypeFindFunction (Gst.TypeFind find);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate int ValueCompareFunc (Gst.Value value1, Gst.Value value2);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool ValueDeserializeFunc (Gst.Value dest, string s);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool ValueIntersectFunc (Gst.Value dest, Gst.Value value1, Gst.Value value2);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate unowned string ValueSerializeFunc (Gst.Value value1);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool ValueSubtractFunc (Gst.Value dest, Gst.Value minuend, Gst.Value subtrahend);
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate bool ValueUnionFunc (Gst.Value dest, Gst.Value value1, Gst.Value value2);
	[CCode (cheader_filename = "gst/gst.h")]
	public const int BUFFER_COPY_ALL;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int BUFFER_OFFSET_NONE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string BUFFER_TRACE_NAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string CLOCK_ENTRY_TRACE_NAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int CLOCK_TIME_NONE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int DEBUG_BG_MASK;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int DEBUG_FG_MASK;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int DEBUG_FORMAT_MASK;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string EVENT_TRACE_NAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int EVENT_TYPE_BOTH;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int EVENT_TYPE_SHIFT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string FOURCC_FORMAT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string LICENSE_UNKNOWN;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string MESSAGE_TRACE_NAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int MSECOND;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int NSECOND;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int PARAM_CONTROLLABLE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int PARAM_MUTABLE_PAUSED;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int PARAM_MUTABLE_PLAYING;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int PARAM_MUTABLE_READY;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int PARAM_USER_SHIFT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int SECOND;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ALBUM;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ALBUM_ARTIST;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ALBUM_ARTIST_SORTNAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ALBUM_GAIN;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ALBUM_PEAK;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ALBUM_SORTNAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ALBUM_VOLUME_COUNT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ALBUM_VOLUME_NUMBER;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ARTIST;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ARTIST_SORTNAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ATTACHMENT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_AUDIO_CODEC;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_BEATS_PER_MINUTE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_BITRATE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_CODEC;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_COMMENT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_COMPOSER;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_COMPOSER_SORTNAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_CONTACT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_CONTAINER_FORMAT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_COPYRIGHT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_COPYRIGHT_URI;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_DATE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_DESCRIPTION;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_DURATION;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ENCODER;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ENCODER_VERSION;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_EXTENDED_COMMENT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_GENRE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_GEO_LOCATION_ELEVATION;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_GEO_LOCATION_LATITUDE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_GEO_LOCATION_LONGITUDE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_GEO_LOCATION_NAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_GROUPING;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_HOMEPAGE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_IMAGE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ISRC;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_KEYWORDS;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_LANGUAGE_CODE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_LICENSE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_LICENSE_URI;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_LOCATION;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_LYRICS;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_MAXIMUM_BITRATE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_MINIMUM_BITRATE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_NOMINAL_BITRATE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_ORGANIZATION;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_PERFORMER;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_PREVIEW_IMAGE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_REFERENCE_LEVEL;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_SERIAL;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_SHOW_EPISODE_NUMBER;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_SHOW_NAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_SHOW_SEASON_NUMBER;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_SHOW_SORTNAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_SUBTITLE_CODEC;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_TITLE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_TITLE_SORTNAME;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_TRACK_COUNT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_TRACK_GAIN;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_TRACK_NUMBER;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_TRACK_PEAK;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_VERSION;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TAG_VIDEO_CODEC;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string TIME_FORMAT;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int USECOND;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int VALUE_EQUAL;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int VALUE_GREATER_THAN;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int VALUE_LESS_THAN;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int VALUE_UNORDERED;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int VERSION_MAJOR;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int VERSION_MICRO;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int VERSION_MINOR;
	[CCode (cheader_filename = "gst/gst.h")]
	public const int VERSION_NANO;
	[CCode (cheader_filename = "gst/gst.h")]
	public static void atomic_int_set (int atomic_int, int value);
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Quark core_error_quark ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static void debug_add_log_function (Gst.LogFunction func, void* data);
	[CCode (cname = "GST_DEBUG_BIN_TO_DOT_FILE", cheader_filename = "gst/gst.h")]
	public static void debug_bin_to_dot_file (Gst.Bin bin, Gst.DebugGraphDetails details, string prefix);
	[CCode (cname = "GST_DEBUG_BIN_TO_DOT_FILE_WITH_TS", cheader_filename = "gst/gst.h")]
	public static void debug_bin_to_dot_file_with_ts (Gst.Bin bin, Gst.DebugGraphDetails details, string prefix);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned string debug_construct_term_color (uint colorinfo);
	[CCode (cheader_filename = "gst/gst.h")]
	public static int debug_construct_win_color (uint colorinfo);
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.SList<Gst.DebugCategory> debug_get_all_categories ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.DebugLevel debug_get_default_threshold ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool debug_is_active ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool debug_is_colored ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static void debug_log (Gst.DebugCategory category, Gst.DebugLevel level, string file, string function, int line, GLib.Object object, string format);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void debug_log_default (Gst.DebugCategory category, Gst.DebugLevel level, string file, string function, int line, GLib.Object object, Gst.DebugMessage message, void* unused);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void debug_log_valist (Gst.DebugCategory category, Gst.DebugLevel level, string file, string function, int line, GLib.Object object, string format, void* args);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void debug_print_stack_trace ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint debug_remove_log_function (Gst.LogFunction func);
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint debug_remove_log_function_by_data (void* data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void debug_set_active (bool active);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void debug_set_colored (bool colored);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void debug_set_default_threshold (Gst.DebugLevel level);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void debug_set_threshold_for_name (string name, Gst.DebugLevel level);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void debug_unset_threshold_for_name (string name);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool default_registry_check_feature_version (string feature_name, uint min_major, uint min_minor, uint min_micro);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void deinit ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type double_range_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static string error_get_message (GLib.Quark domain, int code);
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.List filter_run (GLib.List list, Gst.FilterFunc func, bool first);
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Quark flow_to_quark (Gst.FlowReturn ret);
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.Format format_get_by_nick (string nick);
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.FormatDefinition format_get_details (Gst.Format format);
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.Iterator<Gst.FormatDefinition> format_iterate_definitions ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.Format format_register (string nick, string description);
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Quark format_to_quark (Gst.Format format);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool formats_contains (Gst.Format formats, Gst.Format format);
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type fourcc_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type fraction_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type fraction_range_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static void init ([CCode (array_length_pos = 0.9)] ref unowned string[] args);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool init_check (int argc, string argv) throws GLib.Error;
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.OptionGroup init_get_option_group ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type int_range_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool is_tag_list (void* p);
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Quark library_error_quark ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_BOOLEAN__POINTER (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_BOOLEAN__VOID (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_BOXED__BOXED (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_POINTER__POINTER (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__BOXED_OBJECT (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__INT64 (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__INT_INT (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__OBJECT_BOXED (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__OBJECT_BOXED_STRING (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__OBJECT_OBJECT (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__OBJECT_OBJECT_STRING (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__OBJECT_PARAM (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__OBJECT_POINTER (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__OBJECT_STRING (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__POINTER_OBJECT (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void marshal_VOID__UINT_BOXED (GLib.Closure closure, Gst.Value return_value, uint n_param_values, Gst.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned GLib.ParamSpec param_spec_fraction (string name, string nick, string blurb, int min_num, int min_denom, int max_num, int max_denom, int default_num, int default_denom, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned GLib.ParamSpec param_spec_mini_object (string name, string nick, string blurb, GLib.Type object_type, GLib.ParamFlags flags);
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.Element? parse_bin_from_description (string bin_description, bool ghost_unlinked_pads) throws GLib.Error;
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned Gst.Element parse_bin_from_description_full (string bin_description, bool ghost_unlinked_pads, Gst.ParseContext context, Gst.ParseFlags flags) throws GLib.Error;
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Quark parse_error_quark ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.Element? parse_launch (string pipeline_description) throws GLib.Error;
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned Gst.Element parse_launch_full (string pipeline_description, Gst.ParseContext context, Gst.ParseFlags flags) throws GLib.Error;
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.Element? parse_launchv ([CCode (array_length = false)] string[] argv) throws GLib.Error;
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned Gst.Element parse_launchv_full (string argv, Gst.ParseContext context, Gst.ParseFlags flags) throws GLib.Error;
	[CCode (cheader_filename = "gst/gst.h")]
	public static void print_element_args (GLib.StringBuilder buf, int indent, Gst.Element element);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void print_pad_caps (GLib.StringBuilder buf, int indent, Gst.Pad pad);
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Quark resource_error_quark ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool segtrap_is_enabled ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static void segtrap_set_enabled (bool enabled);
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Quark stream_error_quark ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool tag_exists (string tag);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned string tag_get_description (string tag);
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.TagFlag tag_get_flag (string tag);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned string tag_get_nick (string tag);
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type tag_get_type (string tag);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool tag_is_fixed (string tag);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void tag_merge_strings_with_comma (Gst.Value dest, Gst.Value src);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void tag_merge_use_first (Gst.Value dest, Gst.Value src);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void tag_register (string name, Gst.TagFlag flag, GLib.Type type, string nick, string blurb, Gst.TagMergeFunc func);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool update_registry ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned string uri_construct (string protocol, string location);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned string uri_get_location (string uri);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned string uri_get_protocol (string uri);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool uri_has_protocol (string uri, string protocol);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool uri_is_valid (string uri);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool uri_protocol_is_supported (Gst.URIType type, string protocol);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool uri_protocol_is_valid (string protocol);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void* util_array_binary_search (void* array, uint num_elements, size_t element_size, GLib.CompareDataFunc search_func, Gst.SearchMode mode, void* search_data);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void util_double_to_fraction (double src, int dest_n, int dest_d);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void util_dump_mem (uchar[] mem, uint size);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool util_fraction_add (int a_n, int a_d, int b_n, int b_d, int res_n, int res_d);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool util_fraction_multiply (int a_n, int a_d, int b_n, int b_d, int res_n, int res_d);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void util_fraction_to_double (int src_n, int src_d, double dest);
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint64 util_gdouble_to_guint64 (double value);
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.ClockTime util_get_timestamp ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static int util_greatest_common_divisor (int a, int b);
	[CCode (cheader_filename = "gst/gst.h")]
	public static double util_guint64_to_gdouble (uint64 value);
	[CCode (cheader_filename = "gst/gst.h")]
	public static int32 util_seqnum_compare (uint32 s1, uint32 s2);
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint32 util_seqnum_next ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static void util_set_object_arg (GLib.Object object, string name, string value);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void util_set_value_from_string (Gst.Value value, string value_str);
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint64 util_uint64_scale (uint64 val, uint64 num, uint64 denom);
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint64 util_uint64_scale_ceil (uint64 val, uint64 num, uint64 denom);
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint64 util_uint64_scale_int (uint64 val, int num, int denom);
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint64 util_uint64_scale_int_ceil (uint64 val, int num, int denom);
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint64 util_uint64_scale_int_round (uint64 val, int num, int denom);
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint64 util_uint64_scale_round (uint64 val, uint64 num, uint64 denom);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned Gst.MiniObject value_dup_mini_object (Gst.Value value);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void version (out uint major, out uint minor, out uint micro, out uint nano);
	[CCode (cheader_filename = "gst/gst.h")]
	public static string version_string ();
}
