/* valagidlparser.c generated by valac, the Vala compiler
 * generated from valagidlparser.vala, do not modify */

/* valagidlparser.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gidlparser.h>
#include <gidlmodule.h>
#include <stdio.h>
#include <gidlnode.h>
#include <gmetadata.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free_g_idl_module_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_idl_module_free (var), NULL)))
#define __g_list_free_vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_vala_code_node_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __g_slist_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_free (var), NULL)))

struct _ValaGIdlParser {
	ValaCodeVisitor parent_instance;
	ValaGIdlParserPrivate * priv;
};

struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIdlParserPrivate {
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaSourceReference* current_source_reference;
	ValaNamespace* current_namespace;
	ValaTypeSymbol* current_data_type;
	ValaMap* codenode_attributes_map;
	ValaMap* codenode_attributes_patterns;
	ValaSet* current_type_symbol_set;
	ValaMap* cname_type_map;
};


static gpointer vala_gidl_parser_parent_class = NULL;

GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
#define VALA_GIDL_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIDL_PARSER, ValaGIdlParserPrivate))
enum  {
	VALA_GIDL_PARSER_DUMMY_PROPERTY
};
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t);
static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file);
static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module);
static void _g_list_free_g_idl_module_free (GList* self);
static char** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const char* codenode, int* result_length1);
static char* vala_gidl_parser_eval (ValaGIdlParser* self, const char* s);
static char* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const char* type_name, ValaNamespace* ns);
static char* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const char* const_name, ValaNamespace* ns);
static void _g_list_free_vala_code_node_unref (GList* self);
static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node);
static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaNamespace* ns, GIdlModule* module);
static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaNamespace* ns, GIdlModule* module);
static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaNamespace* ns, GIdlModule* module);
static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaNamespace* ns, GIdlModule* module, gboolean is_flags);
static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaNamespace* ns, GIdlModule* module);
static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaNamespace* ns, GIdlModule* module);
static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node);
static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface);
static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction);
ValaDataType* vala_gidl_parser_get_type_from_string (ValaGIdlParser* self, const char* type_arg);
static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const char* cname);
static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const char* n);
static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node);
static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction);
static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface);
static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node);
static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node);
static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol);
static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const char* type_name);
static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param);
static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const char* name, const char* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface);
static char* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const char* name);
static void _g_slist_free_g_free (GSList* self);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
static void vala_gidl_parser_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context) {
	ValaMap* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaMap* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	self->priv->cname_type_map = (_tmp0_ = (ValaMap*) vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_str_hash, g_str_equal, g_direct_equal), _vala_collection_object_unref0 (self->priv->cname_type_map), _tmp0_);
	self->priv->context = (_tmp1_ = _vala_code_context_ref0 (context), _vala_code_context_unref0 (self->priv->context), _tmp1_);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	self->priv->cname_type_map = (_tmp2_ = NULL, _vala_collection_object_unref0 (self->priv->cname_type_map), _tmp2_);
}


static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ns != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
}


static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (cl != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) cl);
}


static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (st != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) st);
}


static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (iface != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) iface);
}


static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (en != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) en);
}


static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ed != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) ed);
}


static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (d != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) d);
}


static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t) {
	char* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	if ((_tmp1_ = !vala_map_contains (self->priv->cname_type_map, _tmp0_ = vala_typesymbol_get_cname (t, FALSE)), _g_free0 (_tmp0_), _tmp1_)) {
		char* _tmp2_;
		vala_map_set (self->priv->cname_type_map, _tmp2_ = vala_typesymbol_get_cname (t, FALSE), t);
		_g_free0 (_tmp2_);
	}
}


static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (source_file != NULL);
	if (g_str_has_suffix (vala_source_file_get_filename (source_file), ".gi")) {
		vala_gidl_parser_parse_file (self, source_file);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void _g_list_free_g_idl_module_free (GList* self) {
	g_list_foreach (self, (GFunc) g_idl_module_free, NULL);
	g_list_free (self);
}


static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file) {
	GError * _inner_error_;
	char* _tmp0_;
	char* _tmp1_;
	char* metadata_filename;
	ValaSourceFile* _tmp2_;
	ValaMap* _tmp3_;
	ValaMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_inner_error_ = NULL;
	metadata_filename = (_tmp1_ = g_strdup_printf ("%s.metadata", _tmp0_ = g_strndup (vala_source_file_get_filename (source_file), strlen (vala_source_file_get_filename (source_file)) - strlen (".gi"))), _g_free0 (_tmp0_), _tmp1_);
	self->priv->current_source_file = (_tmp2_ = _vala_source_file_ref0 (source_file), _vala_source_file_unref0 (self->priv->current_source_file), _tmp2_);
	self->priv->codenode_attributes_map = (_tmp3_ = (ValaMap*) vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal), _vala_collection_object_unref0 (self->priv->codenode_attributes_map), _tmp3_);
	self->priv->codenode_attributes_patterns = (_tmp4_ = (ValaMap*) vala_hash_map_new (G_TYPE_POINTER, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_hash, (GEqualFunc) g_pattern_spec_equal, g_direct_equal), _vala_collection_object_unref0 (self->priv->codenode_attributes_patterns), _tmp4_);
	if (g_file_test (metadata_filename, G_FILE_TEST_EXISTS)) {
		{
			char* metadata;
			char* _tmp6_;
			char* _tmp5_ = NULL;
			metadata = NULL;
			g_file_get_contents (metadata_filename, &_tmp5_, NULL, &_inner_error_);
			metadata = (_tmp6_ = _tmp5_, _g_free0 (metadata), _tmp6_);
			if (_inner_error_ != NULL) {
				_g_free0 (metadata);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (metadata);
				_g_free0 (metadata_filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			{
				char** _tmp7_;
				char** line_collection;
				int line_collection_length1;
				int line_it;
				line_collection = _tmp7_ = g_strsplit (metadata, "\n", 0);
				line_collection_length1 = _vala_array_length (_tmp7_);
				for (line_it = 0; line_it < _vala_array_length (_tmp7_); line_it = line_it + 1) {
					char* line;
					line = g_strdup (line_collection[line_it]);
					{
						char** _tmp9_;
						gint _tokens_size_;
						gint tokens_length1;
						char** _tmp8_;
						char** tokens;
						if (g_str_has_prefix (line, "#")) {
							_g_free0 (line);
							continue;
						}
						tokens = (_tmp9_ = _tmp8_ = g_strsplit (line, " ", 2), tokens_length1 = _vala_array_length (_tmp8_), _tokens_size_ = tokens_length1, _tmp9_);
						if (NULL == tokens[0]) {
							tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (line);
							continue;
						}
						if (NULL != g_utf8_strchr (tokens[0], (gssize) (-1), (gunichar) '*')) {
							GPatternSpec* pattern;
							pattern = g_pattern_spec_new (tokens[0]);
							vala_map_set (self->priv->codenode_attributes_patterns, pattern, tokens[0]);
						}
						vala_map_set (self->priv->codenode_attributes_map, tokens[0], tokens[1]);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
					}
				}
				line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (metadata);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp10_;
				vala_report_error (NULL, _tmp10_ = g_strdup_printf ("Unable to read metadata file: %s", e->message));
				_g_free0 (_tmp10_);
				_g_error_free0 (e);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		GList* modules;
		ValaSourceReference* _tmp11_;
		modules = g_idl_parse_file (vala_source_file_get_filename (source_file), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_MARKUP_ERROR) {
				goto __catch1_g_markup_error;
			}
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->current_source_reference = (_tmp11_ = vala_source_reference_new (source_file, 0, 0, 0, 0), _vala_source_reference_unref0 (self->priv->current_source_reference), _tmp11_);
		{
			GList* module_collection;
			GList* module_it;
			module_collection = modules;
			for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
				GIdlModule* module;
				module = (GIdlModule*) module_it->data;
				{
					ValaNamespace* ns;
					ns = vala_gidl_parser_parse_module (self, module);
					if (ns != NULL) {
						vala_namespace_add_namespace (vala_code_context_get_root (self->priv->context), ns);
					}
					_vala_code_node_unref0 (ns);
				}
			}
		}
		__g_list_free_g_idl_module_free0 (modules);
	}
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "error parsing GIDL file: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (metadata_filename);
}


static char* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const char* type_name, ValaNamespace* ns) {
	char* result = NULL;
	char** _tmp1_;
	gint _attributes_size_;
	gint attributes_length1;
	gint _tmp0_;
	char** attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	attributes = (_tmp1_ = vala_gidl_parser_get_attributes (self, type_name, &_tmp0_), attributes_length1 = _tmp0_, _attributes_size_ = attributes_length1, _tmp1_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp3_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp2_;
					char** nv;
					nv = (_tmp3_ = _tmp2_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp2_), _nv_size_ = nv_length1, _tmp3_);
					if (_vala_strcmp0 (nv[0], "name") == 0) {
						result = vala_gidl_parser_eval (self, nv[1]);
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	if (g_str_has_prefix (type_name, vala_symbol_get_name ((ValaSymbol*) ns))) {
		result = g_strdup (g_utf8_offset_to_pointer (type_name, g_utf8_strlen (vala_symbol_get_name ((ValaSymbol*) ns), -1)));
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) ns), "GLib") == 0) {
			_tmp4_ = g_str_has_prefix (type_name, "G");
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = g_strdup (g_utf8_offset_to_pointer (type_name, (glong) 1));
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			char* best_match;
			best_match = NULL;
			{
				ValaList* _tmp5_;
				ValaIterator* _tmp6_;
				ValaIterator* _cprefix_it;
				_cprefix_it = (_tmp6_ = vala_iterable_iterator ((ValaIterable*) (_tmp5_ = vala_namespace_get_cprefixes (ns))), _vala_collection_object_unref0 (_tmp5_), _tmp6_);
				while (TRUE) {
					char* cprefix;
					if (!vala_iterator_next (_cprefix_it)) {
						break;
					}
					cprefix = (char*) vala_iterator_get (_cprefix_it);
					if (g_str_has_prefix (type_name, cprefix)) {
						gboolean _tmp7_ = FALSE;
						if (best_match == NULL) {
							_tmp7_ = TRUE;
						} else {
							_tmp7_ = g_utf8_strlen (cprefix, -1) > g_utf8_strlen (best_match, -1);
						}
						if (_tmp7_) {
							char* _tmp8_;
							best_match = (_tmp8_ = g_strdup (cprefix), _g_free0 (best_match), _tmp8_);
						}
					}
					_g_free0 (cprefix);
				}
				_vala_collection_object_unref0 (_cprefix_it);
			}
			if (best_match != NULL) {
				result = g_strdup (g_utf8_offset_to_pointer (type_name, g_utf8_strlen (best_match, -1)));
				_g_free0 (best_match);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
			_g_free0 (best_match);
		}
	}
	result = g_strdup (type_name);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static char* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const char* const_name, ValaNamespace* ns) {
	char* result = NULL;
	char* _tmp1_;
	char* _tmp0_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_name != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	if ((_tmp2_ = g_str_has_prefix (const_name, _tmp1_ = g_strconcat (_tmp0_ = g_utf8_strup (vala_symbol_get_name ((ValaSymbol*) ns), -1), "_", NULL)), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_)) {
		result = g_strdup (g_utf8_offset_to_pointer (const_name, g_utf8_strlen (vala_symbol_get_name ((ValaSymbol*) ns), -1) + 1));
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) ns), "GLib") == 0) {
			_tmp3_ = g_str_has_prefix (const_name, "G_");
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = g_strdup (g_utf8_offset_to_pointer (const_name, (glong) 2));
			return result;
		}
	}
	result = g_strdup (const_name);
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void _g_list_free_vala_code_node_unref (GList* self) {
	g_list_foreach (self, (GFunc) vala_code_node_unref, NULL);
	g_list_free (self);
}


static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module) {
	ValaNamespace* result = NULL;
	ValaSymbol* sym;
	ValaNamespace* ns;
	ValaNamespace* _tmp3_;
	char** _tmp5_;
	gint _attributes_size_;
	gint attributes_length1;
	gint _tmp4_;
	char** attributes;
	ValaNamespace* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (module != NULL, NULL);
	sym = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_code_context_get_root (self->priv->context)), module->name);
	ns = NULL;
	if (VALA_IS_NAMESPACE (sym)) {
		ValaNamespace* _tmp0_;
		ns = (_tmp0_ = _vala_code_node_ref0 (VALA_NAMESPACE (sym)), _vala_code_node_unref0 (ns), _tmp0_);
		if (vala_symbol_get_external_package ((ValaSymbol*) ns)) {
			GList* _tmp1_;
			((ValaCodeNode*) ns)->attributes = (_tmp1_ = NULL, __g_list_free_vala_code_node_unref0 (((ValaCodeNode*) ns)->attributes), _tmp1_);
			vala_code_node_set_source_reference ((ValaCodeNode*) ns, self->priv->current_source_reference);
		}
	} else {
		ValaNamespace* _tmp2_;
		ns = (_tmp2_ = vala_namespace_new (module->name, self->priv->current_source_reference), _vala_code_node_unref0 (ns), _tmp2_);
	}
	self->priv->current_namespace = (_tmp3_ = _vala_code_node_ref0 (ns), _vala_code_node_unref0 (self->priv->current_namespace), _tmp3_);
	attributes = (_tmp5_ = vala_gidl_parser_get_attributes (self, vala_symbol_get_name ((ValaSymbol*) ns), &_tmp4_), attributes_length1 = _tmp4_, _attributes_size_ = attributes_length1, _tmp5_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp7_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp6_;
					char** nv;
					nv = (_tmp7_ = _tmp6_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp6_), _nv_size_ = nv_length1, _tmp7_);
					if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
						char* _tmp8_;
						vala_namespace_set_cheader_filename (ns, _tmp8_ = vala_gidl_parser_eval (self, nv[1]));
						_g_free0 (_tmp8_);
					} else {
						if (_vala_strcmp0 (nv[0], "cprefix") == 0) {
							char** _tmp12_;
							gint _cprefixes_size_;
							gint cprefixes_length1;
							char** _tmp10_;
							char* _tmp9_;
							char** _tmp11_;
							char** cprefixes;
							cprefixes = (_tmp12_ = (_tmp11_ = _tmp10_ = g_strsplit (_tmp9_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp9_), _tmp11_), cprefixes_length1 = _vala_array_length (_tmp10_), _cprefixes_size_ = cprefixes_length1, _tmp12_);
							{
								char** name_collection;
								int name_collection_length1;
								int name_it;
								name_collection = cprefixes;
								name_collection_length1 = cprefixes_length1;
								for (name_it = 0; name_it < cprefixes_length1; name_it = name_it + 1) {
									char* name;
									name = g_strdup (name_collection[name_it]);
									{
										vala_namespace_add_cprefix (ns, name);
										_g_free0 (name);
									}
								}
							}
							cprefixes = (_vala_array_free (cprefixes, cprefixes_length1, (GDestroyNotify) g_free), NULL);
						} else {
							if (_vala_strcmp0 (nv[0], "lower_case_cprefix") == 0) {
								char* _tmp13_;
								vala_namespace_set_lower_case_cprefix (ns, _tmp13_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp13_);
							} else {
								if (_vala_strcmp0 (nv[0], "gir_namespace") == 0) {
									char* _tmp14_;
									vala_source_file_set_gir_namespace (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) ns)), _tmp14_ = vala_gidl_parser_eval (self, nv[1]));
									_g_free0 (_tmp14_);
								} else {
									if (_vala_strcmp0 (nv[0], "gir_version") == 0) {
										char* _tmp15_;
										vala_source_file_set_gir_version (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) ns)), _tmp15_ = vala_gidl_parser_eval (self, nv[1]));
										_g_free0 (_tmp15_);
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	{
		GList* node_collection;
		GList* node_it;
		node_collection = module->entries;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node;
			node = (GIdlNode*) node_it->data;
			{
				if (node->type == G_IDL_NODE_CALLBACK) {
					ValaDelegate* cb;
					char* _tmp16_;
					cb = vala_gidl_parser_parse_delegate (self, (GIdlNodeFunction*) node);
					if (cb == NULL) {
						_vala_code_node_unref0 (cb);
						continue;
					}
					vala_symbol_set_name ((ValaSymbol*) cb, _tmp16_ = vala_gidl_parser_fix_type_name (self, vala_symbol_get_name ((ValaSymbol*) cb), ns));
					_g_free0 (_tmp16_);
					vala_namespace_add_delegate (ns, cb);
					vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cb);
					_vala_code_node_unref0 (cb);
				} else {
					if (node->type == G_IDL_NODE_STRUCT) {
						vala_gidl_parser_parse_struct (self, (GIdlNodeStruct*) node, ns, module);
					} else {
						if (node->type == G_IDL_NODE_UNION) {
							vala_gidl_parser_parse_union (self, (GIdlNodeUnion*) node, ns, module);
						} else {
							if (node->type == G_IDL_NODE_BOXED) {
								vala_gidl_parser_parse_boxed (self, (GIdlNodeBoxed*) node, ns, module);
							} else {
								if (node->type == G_IDL_NODE_ENUM) {
									vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, ns, module, FALSE);
								} else {
									if (node->type == G_IDL_NODE_FLAGS) {
										vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, ns, module, TRUE);
									} else {
										if (node->type == G_IDL_NODE_OBJECT) {
											vala_gidl_parser_parse_object (self, (GIdlNodeInterface*) node, ns, module);
										} else {
											if (node->type == G_IDL_NODE_INTERFACE) {
												vala_gidl_parser_parse_interface (self, (GIdlNodeInterface*) node, ns, module);
											} else {
												if (node->type == G_IDL_NODE_CONSTANT) {
													ValaConstant* c;
													c = vala_gidl_parser_parse_constant (self, (GIdlNodeConstant*) node);
													if (c != NULL) {
														char* _tmp17_;
														vala_symbol_set_name ((ValaSymbol*) c, _tmp17_ = vala_gidl_parser_fix_const_name (self, vala_symbol_get_name ((ValaSymbol*) c), ns));
														_g_free0 (_tmp17_);
														vala_namespace_add_constant (ns, c);
														vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) c);
													}
													_vala_code_node_unref0 (c);
												} else {
													if (node->type == G_IDL_NODE_FUNCTION) {
														ValaMethod* m;
														m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) node, FALSE);
														if (m != NULL) {
															vala_method_set_binding (m, MEMBER_BINDING_STATIC);
															vala_namespace_add_method (ns, m);
															vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) m);
														}
														_vala_code_node_unref0 (m);
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	self->priv->current_namespace = (_tmp18_ = NULL, _vala_code_node_unref0 (self->priv->current_namespace), _tmp18_);
	if (VALA_IS_NAMESPACE (sym)) {
		result = NULL;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (ns);
		_vala_code_node_unref0 (sym);
		return result;
	}
	result = ns;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (sym);
	return result;
}


static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node) {
	ValaDelegate* result = NULL;
	GIdlNode* node;
	ValaDataType* return_type;
	ValaDelegate* cb;
	gboolean check_has_target;
	char** _tmp1_;
	gint _attributes_size_;
	gint attributes_length1;
	gint _tmp0_;
	char** attributes;
	guint remaining_params;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f_node != NULL, NULL);
	node = (GIdlNode*) f_node;
	return_type = vala_gidl_parser_parse_param (self, f_node->result, NULL);
	cb = vala_delegate_new (node->name, return_type, self->priv->current_source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) cb, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	check_has_target = TRUE;
	attributes = (_tmp1_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp0_), attributes_length1 = _tmp0_, _attributes_size_ = attributes_length1, _tmp1_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp3_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp2_;
					char** nv;
					nv = (_tmp3_ = _tmp2_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp2_), _nv_size_ = nv_length1, _tmp3_);
					if (_vala_strcmp0 (nv[0], "hidden") == 0) {
						char* _tmp4_;
						gboolean _tmp5_;
						if ((_tmp5_ = _vala_strcmp0 (_tmp4_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp4_), _tmp5_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (return_type);
							return result;
						}
					} else {
						if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
							char* _tmp6_;
							vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) cb, _tmp6_ = vala_gidl_parser_eval (self, nv[1]));
							_g_free0 (_tmp6_);
						} else {
							if (_vala_strcmp0 (nv[0], "has_target") == 0) {
								char* _tmp7_;
								gboolean _tmp8_;
								if ((_tmp8_ = _vala_strcmp0 (_tmp7_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp7_), _tmp8_)) {
									check_has_target = FALSE;
								} else {
									char* _tmp9_;
									gboolean _tmp10_;
									if ((_tmp10_ = _vala_strcmp0 (_tmp9_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp9_), _tmp10_)) {
										vala_delegate_set_has_target (cb, TRUE);
									}
								}
							} else {
								if (_vala_strcmp0 (nv[0], "transfer_ownership") == 0) {
									char* _tmp11_;
									gboolean _tmp12_;
									if ((_tmp12_ = _vala_strcmp0 (_tmp11_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp11_), _tmp12_)) {
										vala_data_type_set_value_owned (return_type, TRUE);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
										char* _tmp13_;
										gboolean _tmp14_;
										if ((_tmp14_ = _vala_strcmp0 (_tmp13_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp13_), _tmp14_)) {
											vala_symbol_set_deprecated ((ValaSymbol*) cb, TRUE);
										}
									} else {
										if (_vala_strcmp0 (nv[0], "replacement") == 0) {
											char* _tmp15_;
											vala_symbol_set_replacement ((ValaSymbol*) cb, _tmp15_ = vala_gidl_parser_eval (self, nv[1]));
											_g_free0 (_tmp15_);
										} else {
											if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
												char* _tmp16_;
												vala_symbol_set_deprecated_since ((ValaSymbol*) cb, _tmp16_ = vala_gidl_parser_eval (self, nv[1]));
												_g_free0 (_tmp16_);
											} else {
												if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
													char** _tmp20_;
													gint _type_args_size_;
													gint type_args_length1;
													char** _tmp18_;
													char* _tmp17_;
													char** _tmp19_;
													char** type_args;
													type_args = (_tmp20_ = (_tmp19_ = _tmp18_ = g_strsplit (_tmp17_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp17_), _tmp19_), type_args_length1 = _vala_array_length (_tmp18_), _type_args_size_ = type_args_length1, _tmp20_);
													{
														char** type_arg_collection;
														int type_arg_collection_length1;
														int type_arg_it;
														type_arg_collection = type_args;
														type_arg_collection_length1 = type_args_length1;
														for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
															char* type_arg;
															type_arg = g_strdup (type_arg_collection[type_arg_it]);
															{
																ValaDataType* _tmp21_;
																vala_data_type_add_type_argument (return_type, _tmp21_ = vala_gidl_parser_get_type_from_string (self, type_arg));
																_vala_code_node_unref0 (_tmp21_);
																_g_free0 (type_arg);
															}
														}
													}
													type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
												} else {
													if (_vala_strcmp0 (nv[0], "instance_pos") == 0) {
														char* _tmp22_;
														vala_delegate_set_cinstance_parameter_position (cb, g_ascii_strtod (_tmp22_ = vala_gidl_parser_eval (self, nv[1]), NULL));
														_g_free0 (_tmp22_);
													} else {
														if (_vala_strcmp0 (nv[0], "type_parameters") == 0) {
															{
																char** _tmp24_;
																char* _tmp23_;
																char** _tmp25_;
																char** type_param_name_collection;
																int type_param_name_collection_length1;
																int type_param_name_it;
																type_param_name_collection = (_tmp25_ = _tmp24_ = g_strsplit (_tmp23_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp23_), _tmp25_);
																type_param_name_collection_length1 = _vala_array_length (_tmp24_);
																for (type_param_name_it = 0; type_param_name_it < _vala_array_length (_tmp24_); type_param_name_it = type_param_name_it + 1) {
																	char* type_param_name;
																	type_param_name = g_strdup (type_param_name_collection[type_param_name_it]);
																	{
																		ValaTypeParameter* _tmp26_;
																		vala_delegate_add_type_parameter (cb, _tmp26_ = vala_typeparameter_new (type_param_name, self->priv->current_source_reference));
																		_vala_code_node_unref0 (_tmp26_);
																		_g_free0 (type_param_name);
																	}
																}
																type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	remaining_params = g_list_length (f_node->parameters);
	{
		GList* param_collection;
		GList* param_it;
		param_collection = f_node->parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				param_node = (GIdlNode*) param;
				if (check_has_target) {
					_tmp28_ = remaining_params == 1;
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					gboolean _tmp29_ = FALSE;
					if (_vala_strcmp0 (param_node->name, "user_data") == 0) {
						_tmp29_ = TRUE;
					} else {
						_tmp29_ = _vala_strcmp0 (param_node->name, "data") == 0;
					}
					_tmp27_ = _tmp29_;
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					vala_delegate_set_has_target (cb, TRUE);
				} else {
					char* param_name;
					ValaParameterDirection direction = 0;
					ValaDataType* param_type;
					ValaFormalParameter* p;
					gboolean hide_param;
					gboolean show_param;
					gboolean array_requested;
					gboolean out_requested;
					char** _tmp34_;
					gint _tmp33_;
					char* _tmp32_;
					gboolean _tmp66_ = FALSE;
					param_name = g_strdup (param_node->name);
					if (_vala_strcmp0 (param_name, "string") == 0) {
						char* _tmp30_;
						param_name = (_tmp30_ = g_strdup ("str"), _g_free0 (param_name), _tmp30_);
					} else {
						if (_vala_strcmp0 (param_name, "self") == 0) {
							char* _tmp31_;
							param_name = (_tmp31_ = g_strdup ("_self"), _g_free0 (param_name), _tmp31_);
						}
					}
					param_type = vala_gidl_parser_parse_param (self, param, &direction);
					p = vala_formal_parameter_new (param_name, param_type, NULL);
					vala_formal_parameter_set_direction (p, direction);
					hide_param = FALSE;
					show_param = FALSE;
					array_requested = FALSE;
					out_requested = FALSE;
					attributes = (_tmp34_ = vala_gidl_parser_get_attributes (self, _tmp32_ = g_strdup_printf ("%s.%s", node->name, param_node->name), &_tmp33_), attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL), attributes_length1 = _tmp33_, _attributes_size_ = attributes_length1, _tmp34_);
					_g_free0 (_tmp32_);
					if (attributes != NULL) {
						{
							char** attr_collection;
							int attr_collection_length1;
							int attr_it;
							attr_collection = attributes;
							attr_collection_length1 = attributes_length1;
							for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
								char* attr;
								attr = g_strdup (attr_collection[attr_it]);
								{
									char** _tmp36_;
									gint _nv_size_;
									gint nv_length1;
									char** _tmp35_;
									char** nv;
									nv = (_tmp36_ = _tmp35_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp35_), _nv_size_ = nv_length1, _tmp36_);
									if (_vala_strcmp0 (nv[0], "hidden") == 0) {
										char* _tmp37_;
										gboolean _tmp38_;
										if ((_tmp38_ = _vala_strcmp0 (_tmp37_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp37_), _tmp38_)) {
											hide_param = TRUE;
										} else {
											char* _tmp39_;
											gboolean _tmp40_;
											if ((_tmp40_ = _vala_strcmp0 (_tmp39_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp39_), _tmp40_)) {
												show_param = TRUE;
											}
										}
									} else {
										if (_vala_strcmp0 (nv[0], "is_array") == 0) {
											char* _tmp41_;
											gboolean _tmp42_;
											if ((_tmp42_ = _vala_strcmp0 (_tmp41_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp41_), _tmp42_)) {
												ValaDataType* _tmp43_;
												param_type = (_tmp43_ = (ValaDataType*) vala_array_type_new (param_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) param_type)), _vala_code_node_unref0 (param_type), _tmp43_);
												vala_formal_parameter_set_parameter_type (p, param_type);
												if (!out_requested) {
													vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
												}
												array_requested = TRUE;
											}
										} else {
											if (_vala_strcmp0 (nv[0], "is_out") == 0) {
												char* _tmp44_;
												gboolean _tmp45_;
												if ((_tmp45_ = _vala_strcmp0 (_tmp44_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp44_), _tmp45_)) {
													gboolean _tmp46_ = FALSE;
													vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
													out_requested = TRUE;
													if (!array_requested) {
														_tmp46_ = VALA_IS_ARRAY_TYPE (param_type);
													} else {
														_tmp46_ = FALSE;
													}
													if (_tmp46_) {
														ValaArrayType* array_type;
														ValaDataType* _tmp47_;
														array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
														param_type = (_tmp47_ = _vala_code_node_ref0 (vala_array_type_get_element_type (array_type)), _vala_code_node_unref0 (param_type), _tmp47_);
														vala_formal_parameter_set_parameter_type (p, param_type);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												if (_vala_strcmp0 (nv[0], "is_ref") == 0) {
													char* _tmp48_;
													gboolean _tmp49_;
													if ((_tmp49_ = _vala_strcmp0 (_tmp48_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp48_), _tmp49_)) {
														gboolean _tmp50_ = FALSE;
														vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
														if (!array_requested) {
															_tmp50_ = VALA_IS_ARRAY_TYPE (param_type);
														} else {
															_tmp50_ = FALSE;
														}
														if (_tmp50_) {
															ValaArrayType* array_type;
															ValaDataType* _tmp51_;
															array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
															param_type = (_tmp51_ = _vala_code_node_ref0 (vala_array_type_get_element_type (array_type)), _vala_code_node_unref0 (param_type), _tmp51_);
															vala_formal_parameter_set_parameter_type (p, param_type);
															_vala_code_node_unref0 (array_type);
														}
													}
												} else {
													if (_vala_strcmp0 (nv[0], "takes_ownership") == 0) {
														char* _tmp52_;
														gboolean _tmp53_;
														if ((_tmp53_ = _vala_strcmp0 (_tmp52_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp52_), _tmp53_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (_vala_strcmp0 (nv[0], "nullable") == 0) {
															char* _tmp54_;
															gboolean _tmp55_;
															if ((_tmp55_ = _vala_strcmp0 (_tmp54_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp54_), _tmp55_)) {
																vala_data_type_set_nullable (param_type, TRUE);
															}
														} else {
															if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
																char** _tmp59_;
																gint _type_args_size_;
																gint type_args_length1;
																char** _tmp57_;
																char* _tmp56_;
																char** _tmp58_;
																char** type_args;
																type_args = (_tmp59_ = (_tmp58_ = _tmp57_ = g_strsplit (_tmp56_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp56_), _tmp58_), type_args_length1 = _vala_array_length (_tmp57_), _type_args_size_ = type_args_length1, _tmp59_);
																{
																	char** type_arg_collection;
																	int type_arg_collection_length1;
																	int type_arg_it;
																	type_arg_collection = type_args;
																	type_arg_collection_length1 = type_args_length1;
																	for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																		char* type_arg;
																		type_arg = g_strdup (type_arg_collection[type_arg_it]);
																		{
																			ValaDataType* _tmp60_;
																			vala_data_type_add_type_argument (param_type, _tmp60_ = vala_gidl_parser_get_type_from_string (self, type_arg));
																			_vala_code_node_unref0 (_tmp60_);
																			_g_free0 (type_arg);
																		}
																	}
																}
																type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
															} else {
																if (_vala_strcmp0 (nv[0], "no_array_length") == 0) {
																	char* _tmp61_;
																	gboolean _tmp62_;
																	if ((_tmp62_ = _vala_strcmp0 (_tmp61_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp61_), _tmp62_)) {
																		vala_formal_parameter_set_no_array_length (p, TRUE);
																	}
																} else {
																	if (_vala_strcmp0 (nv[0], "type_name") == 0) {
																		char* _tmp63_;
																		ValaUnresolvedSymbol* _tmp64_;
																		ValaUnresolvedSymbol* sym;
																		sym = (_tmp64_ = vala_unresolved_symbol_new (NULL, _tmp63_ = vala_gidl_parser_eval (self, nv[1]), NULL), _g_free0 (_tmp63_), _tmp64_);
																		if (VALA_IS_UNRESOLVED_TYPE (param_type)) {
																			vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type), sym);
																		} else {
																			ValaDataType* _tmp65_;
																			vala_formal_parameter_set_parameter_type (p, param_type = (_tmp65_ = (ValaDataType*) vala_unresolved_type_new_from_symbol (sym, vala_code_node_get_source_reference ((ValaCodeNode*) return_type)), _vala_code_node_unref0 (param_type), _tmp65_));
																		}
																		_vala_code_node_unref0 (sym);
																	}
																}
															}
														}
													}
												}
											}
										}
									}
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
								}
							}
						}
					}
					if (show_param) {
						_tmp66_ = TRUE;
					} else {
						_tmp66_ = !hide_param;
					}
					if (_tmp66_) {
						vala_delegate_add_parameter (cb, p);
					}
					_vala_code_node_unref0 (p);
					_vala_code_node_unref0 (param_type);
					_g_free0 (param_name);
				}
				remaining_params--;
			}
		}
	}
	result = cb;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const char* cname) {
	gboolean result = FALSE;
	char** _tmp1_;
	gint _st_attributes_size_;
	gint st_attributes_length1;
	gint _tmp0_;
	char** st_attributes;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cname != NULL, FALSE);
	st_attributes = (_tmp1_ = vala_gidl_parser_get_attributes (self, cname, &_tmp0_), st_attributes_length1 = _tmp0_, _st_attributes_size_ = st_attributes_length1, _tmp1_);
	if (st_attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = st_attributes;
			attr_collection_length1 = st_attributes_length1;
			for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp3_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp2_;
					char** nv;
					gboolean _tmp4_ = FALSE;
					nv = (_tmp3_ = _tmp2_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp2_), _nv_size_ = nv_length1, _tmp3_);
					if (_vala_strcmp0 (nv[0], "is_value_type") == 0) {
						char* _tmp5_;
						_tmp4_ = _vala_strcmp0 (_tmp5_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0;
						_g_free0 (_tmp5_);
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						result = FALSE;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	result = TRUE;
	st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaNamespace* ns, GIdlModule* module) {
	GIdlNode* node;
	char* name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st_node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) st_node;
	if (st_node->deprecated) {
		return;
	}
	name = vala_gidl_parser_fix_type_name (self, node->name, ns);
	if (!vala_gidl_parser_is_reference_type (self, node->name)) {
		ValaSymbol* _tmp0_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp27_;
		ValaTypeSymbol* _tmp28_;
		st = (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp1_;
			char** _tmp3_;
			gint _st_attributes_size_;
			gint st_attributes_length1;
			gint _tmp2_;
			char** st_attributes;
			st = (_tmp1_ = vala_struct_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (st), _tmp1_);
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			st_attributes = (_tmp3_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp2_), st_attributes_length1 = _tmp2_, _st_attributes_size_ = st_attributes_length1, _tmp3_);
			if (st_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp5_;
							gint _nv_size_;
							gint nv_length1;
							char** _tmp4_;
							char** nv;
							nv = (_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp4_), _nv_size_ = nv_length1, _tmp5_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp6_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) st, _tmp6_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp6_);
							} else {
								if (_vala_strcmp0 (nv[0], "hidden") == 0) {
									char* _tmp7_;
									gboolean _tmp8_;
									if ((_tmp8_ = _vala_strcmp0 (_tmp7_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp7_), _tmp8_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (st);
										_g_free0 (name);
										return;
									}
								} else {
									if (_vala_strcmp0 (nv[0], "base_type") == 0) {
										ValaDataType* _tmp10_;
										char* _tmp9_;
										vala_struct_set_base_type (st, _tmp10_ = vala_gidl_parser_parse_type_string (self, _tmp9_ = vala_gidl_parser_eval (self, nv[1])));
										_vala_code_node_unref0 (_tmp10_);
										_g_free0 (_tmp9_);
									} else {
										if (_vala_strcmp0 (nv[0], "rank") == 0) {
											char* _tmp11_;
											vala_struct_set_rank (st, atoi (_tmp11_ = vala_gidl_parser_eval (self, nv[1])));
											_g_free0 (_tmp11_);
										} else {
											if (_vala_strcmp0 (nv[0], "simple_type") == 0) {
												char* _tmp12_;
												gboolean _tmp13_;
												if ((_tmp13_ = _vala_strcmp0 (_tmp12_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp12_), _tmp13_)) {
													vala_struct_set_simple_type (st, TRUE);
												}
											} else {
												if (_vala_strcmp0 (nv[0], "immutable") == 0) {
													char* _tmp14_;
													gboolean _tmp15_;
													if ((_tmp15_ = _vala_strcmp0 (_tmp14_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp14_), _tmp15_)) {
														vala_struct_set_is_immutable (st, TRUE);
													}
												} else {
													if (_vala_strcmp0 (nv[0], "has_type_id") == 0) {
														char* _tmp16_;
														gboolean _tmp17_;
														if ((_tmp17_ = _vala_strcmp0 (_tmp16_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp16_), _tmp17_)) {
															vala_struct_set_has_type_id (st, FALSE);
														}
													} else {
														if (_vala_strcmp0 (nv[0], "type_id") == 0) {
															char* _tmp18_;
															vala_struct_set_type_id (st, _tmp18_ = vala_gidl_parser_eval (self, nv[1]));
															_g_free0 (_tmp18_);
														} else {
															if (_vala_strcmp0 (nv[0], "has_copy_function") == 0) {
																char* _tmp19_;
																gboolean _tmp20_;
																if ((_tmp20_ = _vala_strcmp0 (_tmp19_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp19_), _tmp20_)) {
																	vala_struct_set_has_copy_function (st, FALSE);
																}
															} else {
																if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
																	char* _tmp21_;
																	gboolean _tmp22_;
																	if ((_tmp22_ = _vala_strcmp0 (_tmp21_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp21_), _tmp22_)) {
																		vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
																	}
																} else {
																	if (_vala_strcmp0 (nv[0], "replacement") == 0) {
																		char* _tmp23_;
																		vala_symbol_set_replacement ((ValaSymbol*) st, _tmp23_ = vala_gidl_parser_eval (self, nv[1]));
																		_g_free0 (_tmp23_);
																	} else {
																		if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
																			char* _tmp24_;
																			vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp24_ = vala_gidl_parser_eval (self, nv[1]));
																			_g_free0 (_tmp24_);
																		} else {
																			if (_vala_strcmp0 (nv[0], "has_destroy_function") == 0) {
																				char* _tmp25_;
																				gboolean _tmp26_;
																				if ((_tmp26_ = _vala_strcmp0 (_tmp25_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp25_), _tmp26_)) {
																					vala_struct_set_has_destroy_function (st, FALSE);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_namespace_add_struct (ns, st);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->current_data_type = (_tmp27_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st), _vala_code_node_unref0 (self->priv->current_data_type), _tmp27_);
		{
			GList* member_collection;
			GList* member_it;
			member_collection = st_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						if (m != NULL) {
							vala_struct_add_method (st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_struct_add_field (st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		self->priv->current_data_type = (_tmp28_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp28_);
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		char* ref_function;
		char* unref_function;
		char* copy_function;
		char* free_function;
		ValaSymbol* _tmp29_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp61_;
		ValaTypeSymbol* _tmp72_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		cl = (_tmp29_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_CLASS (_tmp29_) ? ((ValaClass*) _tmp29_) : NULL);
		if (cl == NULL) {
			char* base_class;
			ValaClass* _tmp30_;
			char** _tmp32_;
			gint _cl_attributes_size_;
			gint cl_attributes_length1;
			gint _tmp31_;
			char** cl_attributes;
			base_class = NULL;
			cl = (_tmp30_ = vala_class_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (cl), _tmp30_);
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			cl_attributes = (_tmp32_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp31_), cl_attributes_length1 = _tmp31_, _cl_attributes_size_ = cl_attributes_length1, _tmp32_);
			if (cl_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp34_;
							gint _nv_size_;
							gint nv_length1;
							char** _tmp33_;
							char** nv;
							nv = (_tmp34_ = _tmp33_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp33_), _nv_size_ = nv_length1, _tmp34_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp35_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) cl, _tmp35_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp35_);
							} else {
								if (_vala_strcmp0 (nv[0], "base_class") == 0) {
									char* _tmp36_;
									base_class = (_tmp36_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (base_class), _tmp36_);
								} else {
									if (_vala_strcmp0 (nv[0], "hidden") == 0) {
										char* _tmp37_;
										gboolean _tmp38_;
										if ((_tmp38_ = _vala_strcmp0 (_tmp37_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp37_), _tmp38_)) {
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (base_class);
											_vala_code_node_unref0 (cl);
											_g_free0 (free_function);
											_g_free0 (copy_function);
											_g_free0 (unref_function);
											_g_free0 (ref_function);
											_g_free0 (name);
											return;
										}
									} else {
										if (_vala_strcmp0 (nv[0], "is_immutable") == 0) {
											char* _tmp39_;
											gboolean _tmp40_;
											if ((_tmp40_ = _vala_strcmp0 (_tmp39_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp39_), _tmp40_)) {
												vala_class_set_is_immutable (cl, TRUE);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "const_cname") == 0) {
												char* _tmp41_;
												vala_class_set_const_cname (cl, _tmp41_ = vala_gidl_parser_eval (self, nv[1]));
												_g_free0 (_tmp41_);
											} else {
												if (_vala_strcmp0 (nv[0], "is_fundamental") == 0) {
													char* _tmp42_;
													gboolean _tmp43_;
													if ((_tmp43_ = _vala_strcmp0 (_tmp42_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp42_), _tmp43_)) {
														vala_class_set_is_compact (cl, FALSE);
													}
												} else {
													gboolean _tmp44_ = FALSE;
													if (_vala_strcmp0 (nv[0], "abstract") == 0) {
														_tmp44_ = base_class != NULL;
													} else {
														_tmp44_ = FALSE;
													}
													if (_tmp44_) {
														char* _tmp45_;
														gboolean _tmp46_;
														if ((_tmp46_ = _vala_strcmp0 (_tmp45_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp45_), _tmp46_)) {
															vala_class_set_is_abstract (cl, TRUE);
														}
													} else {
														if (_vala_strcmp0 (nv[0], "free_function") == 0) {
															char* _tmp47_;
															free_function = (_tmp47_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (free_function), _tmp47_);
														} else {
															if (_vala_strcmp0 (nv[0], "ref_function") == 0) {
																char* _tmp48_;
																ref_function = (_tmp48_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (ref_function), _tmp48_);
															} else {
																if (_vala_strcmp0 (nv[0], "unref_function") == 0) {
																	char* _tmp49_;
																	unref_function = (_tmp49_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (unref_function), _tmp49_);
																} else {
																	if (_vala_strcmp0 (nv[0], "copy_function") == 0) {
																		char* _tmp50_;
																		copy_function = (_tmp50_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (copy_function), _tmp50_);
																	} else {
																		if (_vala_strcmp0 (nv[0], "ref_function_void") == 0) {
																			char* _tmp51_;
																			gboolean _tmp52_;
																			if ((_tmp52_ = _vala_strcmp0 (_tmp51_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp51_), _tmp52_)) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
																				char* _tmp53_;
																				gboolean _tmp54_;
																				if ((_tmp54_ = _vala_strcmp0 (_tmp53_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp53_), _tmp54_)) {
																					vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
																				}
																			} else {
																				if (_vala_strcmp0 (nv[0], "replacement") == 0) {
																					char* _tmp55_;
																					vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp55_ = vala_gidl_parser_eval (self, nv[1]));
																					_g_free0 (_tmp55_);
																				} else {
																					if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
																						char* _tmp56_;
																						vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp56_ = vala_gidl_parser_eval (self, nv[1]));
																						_g_free0 (_tmp56_);
																					} else {
																						if (_vala_strcmp0 (nv[0], "type_parameters") == 0) {
																							{
																								char** _tmp58_;
																								char* _tmp57_;
																								char** _tmp59_;
																								char** type_param_name_collection;
																								int type_param_name_collection_length1;
																								int type_param_name_it;
																								type_param_name_collection = (_tmp59_ = _tmp58_ = g_strsplit (_tmp57_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp57_), _tmp59_);
																								type_param_name_collection_length1 = _vala_array_length (_tmp58_);
																								for (type_param_name_it = 0; type_param_name_it < _vala_array_length (_tmp58_); type_param_name_it = type_param_name_it + 1) {
																									char* type_param_name;
																									type_param_name = g_strdup (type_param_name_collection[type_param_name_it]);
																									{
																										ValaTypeParameter* _tmp60_;
																										vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) cl, _tmp60_ = vala_typeparameter_new (type_param_name, self->priv->current_source_reference));
																										_vala_code_node_unref0 (_tmp60_);
																										_g_free0 (type_param_name);
																									}
																								}
																								type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_namespace_add_class (ns, cl);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			if (base_class != NULL) {
				ValaDataType* parent;
				parent = vala_gidl_parser_parse_type_string (self, base_class);
				vala_class_add_base_type (cl, parent);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		self->priv->current_data_type = (_tmp61_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl), _vala_code_node_unref0 (self->priv->current_data_type), _tmp61_);
		{
			GList* member_collection;
			GList* member_it;
			member_collection = st_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						gboolean _tmp62_ = FALSE;
						if (ref_function == NULL) {
							_tmp62_ = _vala_strcmp0 (member->name, "ref") == 0;
						} else {
							_tmp62_ = FALSE;
						}
						if (_tmp62_) {
							char* _tmp63_;
							ValaDataType* _tmp64_;
							ref_function = (_tmp63_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (ref_function), _tmp63_);
							ref_function_void = VALA_IS_VOID_TYPE (_tmp64_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL));
							_vala_code_node_unref0 (_tmp64_);
						} else {
							gboolean _tmp65_ = FALSE;
							if (unref_function == NULL) {
								_tmp65_ = _vala_strcmp0 (member->name, "unref") == 0;
							} else {
								_tmp65_ = FALSE;
							}
							if (_tmp65_) {
								char* _tmp66_;
								unref_function = (_tmp66_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (unref_function), _tmp66_);
							} else {
								gboolean _tmp67_ = FALSE;
								if (free_function == NULL) {
									gboolean _tmp68_ = FALSE;
									if (_vala_strcmp0 (member->name, "free") == 0) {
										_tmp68_ = TRUE;
									} else {
										_tmp68_ = _vala_strcmp0 (member->name, "destroy") == 0;
									}
									_tmp67_ = _tmp68_;
								} else {
									_tmp67_ = FALSE;
								}
								if (_tmp67_) {
									char* _tmp69_;
									free_function = (_tmp69_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (free_function), _tmp69_);
								} else {
									gboolean _tmp70_ = FALSE;
									ValaMethod* m;
									if (copy_function == NULL) {
										_tmp70_ = _vala_strcmp0 (member->name, "copy") == 0;
									} else {
										_tmp70_ = FALSE;
									}
									if (_tmp70_) {
										char* _tmp71_;
										copy_function = (_tmp71_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (copy_function), _tmp71_);
									}
									m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									if (m != NULL) {
										vala_class_add_method (cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_class_add_field (cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		self->priv->current_data_type = (_tmp72_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp72_);
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaNamespace* ns, GIdlModule* module) {
	GIdlNode* node;
	char* name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (un_node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) un_node;
	if (un_node->deprecated) {
		return;
	}
	name = vala_gidl_parser_fix_type_name (self, node->name, ns);
	if (!vala_gidl_parser_is_reference_type (self, node->name)) {
		ValaSymbol* _tmp0_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp13_;
		ValaTypeSymbol* _tmp14_;
		st = (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp1_;
			char** _tmp3_;
			gint _st_attributes_size_;
			gint st_attributes_length1;
			gint _tmp2_;
			char** st_attributes;
			st = (_tmp1_ = vala_struct_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (st), _tmp1_);
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			st_attributes = (_tmp3_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp2_), st_attributes_length1 = _tmp2_, _st_attributes_size_ = st_attributes_length1, _tmp3_);
			if (st_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp5_;
							gint _nv_size_;
							gint nv_length1;
							char** _tmp4_;
							char** nv;
							nv = (_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp4_), _nv_size_ = nv_length1, _tmp5_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp6_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) st, _tmp6_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp6_);
							} else {
								if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
									char* _tmp7_;
									gboolean _tmp8_;
									if ((_tmp8_ = _vala_strcmp0 (_tmp7_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp7_), _tmp8_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "replacement") == 0) {
										char* _tmp9_;
										vala_symbol_set_replacement ((ValaSymbol*) st, _tmp9_ = vala_gidl_parser_eval (self, nv[1]));
										_g_free0 (_tmp9_);
									} else {
										if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
											char* _tmp10_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp10_ = vala_gidl_parser_eval (self, nv[1]));
											_g_free0 (_tmp10_);
										} else {
											if (_vala_strcmp0 (nv[0], "hidden") == 0) {
												char* _tmp11_;
												gboolean _tmp12_;
												if ((_tmp12_ = _vala_strcmp0 (_tmp11_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp11_), _tmp12_)) {
													nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (attr);
													st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
													_vala_code_node_unref0 (st);
													_g_free0 (name);
													return;
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_namespace_add_struct (ns, st);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->current_data_type = (_tmp13_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st), _vala_code_node_unref0 (self->priv->current_data_type), _tmp13_);
		{
			GList* member_collection;
			GList* member_it;
			member_collection = un_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						if (m != NULL) {
							vala_struct_add_method (st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_struct_add_field (st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		self->priv->current_data_type = (_tmp14_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp14_);
		_vala_code_node_unref0 (st);
	} else {
		ValaSymbol* _tmp15_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp24_;
		gboolean ref_function_void;
		char* ref_function;
		char* unref_function;
		char* copy_function;
		char* free_function;
		ValaTypeSymbol* _tmp31_;
		cl = (_tmp15_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_CLASS (_tmp15_) ? ((ValaClass*) _tmp15_) : NULL);
		if (cl == NULL) {
			ValaClass* _tmp16_;
			char** _tmp18_;
			gint _cl_attributes_size_;
			gint cl_attributes_length1;
			gint _tmp17_;
			char** cl_attributes;
			cl = (_tmp16_ = vala_class_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (cl), _tmp16_);
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			cl_attributes = (_tmp18_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp17_), cl_attributes_length1 = _tmp17_, _cl_attributes_size_ = cl_attributes_length1, _tmp18_);
			if (cl_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp20_;
							gint _nv_size_;
							gint nv_length1;
							char** _tmp19_;
							char** nv;
							nv = (_tmp20_ = _tmp19_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp19_), _nv_size_ = nv_length1, _tmp20_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp21_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) cl, _tmp21_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp21_);
							} else {
								if (_vala_strcmp0 (nv[0], "hidden") == 0) {
									char* _tmp22_;
									gboolean _tmp23_;
									if ((_tmp23_ = _vala_strcmp0 (_tmp22_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp22_), _tmp23_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (name);
										return;
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_namespace_add_class (ns, cl);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->current_data_type = (_tmp24_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl), _vala_code_node_unref0 (self->priv->current_data_type), _tmp24_);
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = un_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						if (_vala_strcmp0 (member->name, "ref") == 0) {
							char* _tmp25_;
							ValaDataType* _tmp26_;
							ref_function = (_tmp25_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (ref_function), _tmp25_);
							ref_function_void = VALA_IS_VOID_TYPE (_tmp26_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL));
							_vala_code_node_unref0 (_tmp26_);
						} else {
							if (_vala_strcmp0 (member->name, "unref") == 0) {
								char* _tmp27_;
								unref_function = (_tmp27_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (unref_function), _tmp27_);
							} else {
								gboolean _tmp28_ = FALSE;
								if (_vala_strcmp0 (member->name, "free") == 0) {
									_tmp28_ = TRUE;
								} else {
									_tmp28_ = _vala_strcmp0 (member->name, "destroy") == 0;
								}
								if (_tmp28_) {
									char* _tmp29_;
									free_function = (_tmp29_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (free_function), _tmp29_);
								} else {
									ValaMethod* m;
									if (_vala_strcmp0 (member->name, "copy") == 0) {
										char* _tmp30_;
										copy_function = (_tmp30_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (copy_function), _tmp30_);
									}
									m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									if (m != NULL) {
										vala_class_add_method (cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_class_add_field (cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		self->priv->current_data_type = (_tmp31_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp31_);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
		_vala_code_node_unref0 (cl);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaNamespace* ns, GIdlModule* module) {
	GIdlNode* node;
	char* name;
	char** _tmp1_;
	gint _node_attributes_size_;
	gint node_attributes_length1;
	gint _tmp0_;
	char** node_attributes;
	g_return_if_fail (self != NULL);
	g_return_if_fail (boxed_node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) boxed_node;
	name = vala_gidl_parser_fix_type_name (self, node->name, ns);
	node_attributes = (_tmp1_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp0_), node_attributes_length1 = _tmp0_, _node_attributes_size_ = node_attributes_length1, _tmp1_);
	if (node_attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = node_attributes;
			attr_collection_length1 = node_attributes_length1;
			for (attr_it = 0; attr_it < node_attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp3_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp2_;
					char** nv;
					nv = (_tmp3_ = _tmp2_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp2_), _nv_size_ = nv_length1, _tmp3_);
					if (_vala_strcmp0 (nv[0], "hidden") == 0) {
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (name);
						return;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	if (!vala_gidl_parser_is_reference_type (self, node->name)) {
		ValaSymbol* _tmp4_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp22_;
		ValaTypeSymbol* _tmp23_;
		st = (_tmp4_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_STRUCT (_tmp4_) ? ((ValaStruct*) _tmp4_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp5_;
			char** _tmp7_;
			gint _st_attributes_size_;
			gint st_attributes_length1;
			gint _tmp6_;
			char** st_attributes;
			char* _tmp21_;
			st = (_tmp5_ = vala_struct_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (st), _tmp5_);
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			st_attributes = (_tmp7_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp6_), st_attributes_length1 = _tmp6_, _st_attributes_size_ = st_attributes_length1, _tmp7_);
			if (st_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp9_;
							gint _nv_size_;
							gint nv_length1;
							char** _tmp8_;
							char** nv;
							nv = (_tmp9_ = _tmp8_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp8_), _nv_size_ = nv_length1, _tmp9_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp10_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) st, _tmp10_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp10_);
							} else {
								if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
									char* _tmp11_;
									gboolean _tmp12_;
									if ((_tmp12_ = _vala_strcmp0 (_tmp11_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp11_), _tmp12_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "replacement") == 0) {
										char* _tmp13_;
										vala_symbol_set_replacement ((ValaSymbol*) st, _tmp13_ = vala_gidl_parser_eval (self, nv[1]));
										_g_free0 (_tmp13_);
									} else {
										if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
											char* _tmp14_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp14_ = vala_gidl_parser_eval (self, nv[1]));
											_g_free0 (_tmp14_);
										} else {
											if (_vala_strcmp0 (nv[0], "immutable") == 0) {
												char* _tmp15_;
												gboolean _tmp16_;
												if ((_tmp16_ = _vala_strcmp0 (_tmp15_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp15_), _tmp16_)) {
													vala_struct_set_is_immutable (st, TRUE);
												}
											} else {
												if (_vala_strcmp0 (nv[0], "has_copy_function") == 0) {
													char* _tmp17_;
													gboolean _tmp18_;
													if ((_tmp18_ = _vala_strcmp0 (_tmp17_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp17_), _tmp18_)) {
														vala_struct_set_has_copy_function (st, FALSE);
													}
												} else {
													if (_vala_strcmp0 (nv[0], "has_destroy_function") == 0) {
														char* _tmp19_;
														gboolean _tmp20_;
														if ((_tmp20_ = _vala_strcmp0 (_tmp19_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp19_), _tmp20_)) {
															vala_struct_set_has_destroy_function (st, FALSE);
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_namespace_add_struct (ns, st);
			vala_struct_set_type_id (st, _tmp21_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) st, "TYPE_"));
			_g_free0 (_tmp21_);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->current_data_type = (_tmp22_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st), _vala_code_node_unref0 (self->priv->current_data_type), _tmp22_);
		{
			GList* member_collection;
			GList* member_it;
			member_collection = boxed_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						if (m != NULL) {
							vala_struct_add_method (st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_struct_add_field (st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		self->priv->current_data_type = (_tmp23_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp23_);
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		char* ref_function;
		char* unref_function;
		char* copy_function;
		char* free_function;
		ValaSymbol* _tmp24_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp46_;
		ValaTypeSymbol* _tmp53_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		cl = (_tmp24_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_CLASS (_tmp24_) ? ((ValaClass*) _tmp24_) : NULL);
		if (cl == NULL) {
			char* base_class;
			ValaClass* _tmp25_;
			char** _tmp27_;
			gint _cl_attributes_size_;
			gint cl_attributes_length1;
			gint _tmp26_;
			char** cl_attributes;
			char* _tmp45_;
			base_class = NULL;
			cl = (_tmp25_ = vala_class_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (cl), _tmp25_);
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			cl_attributes = (_tmp27_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp26_), cl_attributes_length1 = _tmp26_, _cl_attributes_size_ = cl_attributes_length1, _tmp27_);
			if (cl_attributes != NULL) {
				{
					char** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						char* attr;
						attr = g_strdup (attr_collection[attr_it]);
						{
							char** _tmp29_;
							gint _nv_size_;
							gint nv_length1;
							char** _tmp28_;
							char** nv;
							nv = (_tmp29_ = _tmp28_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp28_), _nv_size_ = nv_length1, _tmp29_);
							if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
								char* _tmp30_;
								vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) cl, _tmp30_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp30_);
							} else {
								if (_vala_strcmp0 (nv[0], "base_class") == 0) {
									char* _tmp31_;
									base_class = (_tmp31_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (base_class), _tmp31_);
								} else {
									if (_vala_strcmp0 (nv[0], "is_immutable") == 0) {
										char* _tmp32_;
										gboolean _tmp33_;
										if ((_tmp33_ = _vala_strcmp0 (_tmp32_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp32_), _tmp33_)) {
											vala_class_set_is_immutable (cl, TRUE);
										}
									} else {
										if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
											char* _tmp34_;
											gboolean _tmp35_;
											if ((_tmp35_ = _vala_strcmp0 (_tmp34_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp34_), _tmp35_)) {
												vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "replacement") == 0) {
												char* _tmp36_;
												vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp36_ = vala_gidl_parser_eval (self, nv[1]));
												_g_free0 (_tmp36_);
											} else {
												if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
													char* _tmp37_;
													vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp37_ = vala_gidl_parser_eval (self, nv[1]));
													_g_free0 (_tmp37_);
												} else {
													if (_vala_strcmp0 (nv[0], "const_cname") == 0) {
														char* _tmp38_;
														vala_class_set_const_cname (cl, _tmp38_ = vala_gidl_parser_eval (self, nv[1]));
														_g_free0 (_tmp38_);
													} else {
														if (_vala_strcmp0 (nv[0], "free_function") == 0) {
															char* _tmp39_;
															free_function = (_tmp39_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (free_function), _tmp39_);
														} else {
															if (_vala_strcmp0 (nv[0], "ref_function") == 0) {
																char* _tmp40_;
																ref_function = (_tmp40_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (ref_function), _tmp40_);
															} else {
																if (_vala_strcmp0 (nv[0], "unref_function") == 0) {
																	char* _tmp41_;
																	unref_function = (_tmp41_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (unref_function), _tmp41_);
																} else {
																	if (_vala_strcmp0 (nv[0], "copy_function") == 0) {
																		char* _tmp42_;
																		copy_function = (_tmp42_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (copy_function), _tmp42_);
																	} else {
																		if (_vala_strcmp0 (nv[0], "ref_function_void") == 0) {
																			char* _tmp43_;
																			gboolean _tmp44_;
																			if ((_tmp44_ = _vala_strcmp0 (_tmp43_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp43_), _tmp44_)) {
																				ref_function_void = TRUE;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_namespace_add_class (ns, cl);
			vala_class_set_type_id (cl, _tmp45_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, "TYPE_"));
			_g_free0 (_tmp45_);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			if (base_class != NULL) {
				ValaDataType* parent;
				parent = vala_gidl_parser_parse_type_string (self, base_class);
				vala_class_add_base_type (cl, parent);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		self->priv->current_data_type = (_tmp46_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl), _vala_code_node_unref0 (self->priv->current_data_type), _tmp46_);
		{
			GList* member_collection;
			GList* member_it;
			member_collection = boxed_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						if (_vala_strcmp0 (member->name, "ref") == 0) {
							char* _tmp47_;
							ValaDataType* _tmp48_;
							ref_function = (_tmp47_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (ref_function), _tmp47_);
							ref_function_void = VALA_IS_VOID_TYPE (_tmp48_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL));
							_vala_code_node_unref0 (_tmp48_);
						} else {
							if (_vala_strcmp0 (member->name, "unref") == 0) {
								char* _tmp49_;
								unref_function = (_tmp49_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (unref_function), _tmp49_);
							} else {
								gboolean _tmp50_ = FALSE;
								if (_vala_strcmp0 (member->name, "free") == 0) {
									_tmp50_ = TRUE;
								} else {
									_tmp50_ = _vala_strcmp0 (member->name, "destroy") == 0;
								}
								if (_tmp50_) {
									char* _tmp51_;
									free_function = (_tmp51_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (free_function), _tmp51_);
								} else {
									ValaMethod* m;
									if (_vala_strcmp0 (member->name, "copy") == 0) {
										char* _tmp52_;
										copy_function = (_tmp52_ = g_strdup (((GIdlNodeFunction*) member)->symbol), _g_free0 (copy_function), _tmp52_);
									}
									m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									if (m != NULL) {
										vala_class_add_method (cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* f;
							f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							if (f != NULL) {
								vala_class_add_field (cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		self->priv->current_data_type = (_tmp53_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp53_);
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaNamespace* ns, GIdlModule* module, gboolean is_flags) {
	GIdlNode* node;
	char* name;
	gboolean existing;
	ValaSymbol* _tmp0_;
	ValaEnum* en;
	gboolean _tmp2_ = FALSE;
	char* common_prefix;
	gboolean is_errordomain;
	ValaArrayList* cheader_filenames;
	char** _tmp18_;
	gint _en_attributes_size_;
	gint en_attributes_length1;
	gint _tmp17_;
	char** en_attributes;
	g_return_if_fail (self != NULL);
	g_return_if_fail (en_node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) en_node;
	name = vala_gidl_parser_fix_type_name (self, node->name, ns);
	existing = TRUE;
	en = (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_ENUM (_tmp0_) ? ((ValaEnum*) _tmp0_) : NULL);
	if (en == NULL) {
		ValaEnum* _tmp1_;
		en = (_tmp1_ = vala_enum_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (en), _tmp1_);
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		existing = FALSE;
	} else {
		vala_enum_remove_all_values (en);
	}
	if (en_node->gtype_name != NULL) {
		_tmp2_ = _vala_strcmp0 (en_node->gtype_name, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	vala_enum_set_has_type_id (en, _tmp2_);
	common_prefix = NULL;
	{
		GList* value_collection;
		GList* value_it;
		value_collection = en_node->values;
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GIdlNode* value;
			value = (GIdlNode*) value_it->data;
			{
				char** _tmp4_;
				gint _val_attributes_size_;
				gint val_attributes_length1;
				gint _tmp3_;
				char** val_attributes;
				gboolean is_hidden;
				val_attributes = (_tmp4_ = vala_gidl_parser_get_attributes (self, value->name, &_tmp3_), val_attributes_length1 = _tmp3_, _val_attributes_size_ = val_attributes_length1, _tmp4_);
				is_hidden = FALSE;
				if (val_attributes != NULL) {
					{
						char** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = val_attributes;
						attr_collection_length1 = val_attributes_length1;
						for (attr_it = 0; attr_it < val_attributes_length1; attr_it = attr_it + 1) {
							char* attr;
							attr = g_strdup (attr_collection[attr_it]);
							{
								char** _tmp6_;
								gint _nv_size_;
								gint nv_length1;
								char** _tmp5_;
								char** nv;
								gboolean _tmp7_ = FALSE;
								nv = (_tmp6_ = _tmp5_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp5_), _nv_size_ = nv_length1, _tmp6_);
								if (_vala_strcmp0 (nv[0], "hidden") == 0) {
									char* _tmp8_;
									_tmp7_ = _vala_strcmp0 (_tmp8_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0;
									_g_free0 (_tmp8_);
								} else {
									_tmp7_ = FALSE;
								}
								if (_tmp7_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (is_hidden) {
					val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				if (common_prefix == NULL) {
					char* _tmp9_;
					common_prefix = (_tmp9_ = g_strdup (value->name), _g_free0 (common_prefix), _tmp9_);
					while (TRUE) {
						gboolean _tmp10_ = FALSE;
						char* _tmp11_;
						if (g_utf8_strlen (common_prefix, -1) > 0) {
							_tmp10_ = !g_str_has_suffix (common_prefix, "_");
						} else {
							_tmp10_ = FALSE;
						}
						if (!_tmp10_) {
							break;
						}
						common_prefix = (_tmp11_ = g_strndup (common_prefix, strlen (common_prefix) - 1), _g_free0 (common_prefix), _tmp11_);
					}
				} else {
					while (TRUE) {
						char* _tmp12_;
						if (!(!g_str_has_prefix (value->name, common_prefix))) {
							break;
						}
						common_prefix = (_tmp12_ = g_strndup (common_prefix, strlen (common_prefix) - 1), _g_free0 (common_prefix), _tmp12_);
					}
				}
				while (TRUE) {
					gboolean _tmp13_ = FALSE;
					char* _tmp16_;
					if (g_utf8_strlen (common_prefix, -1) > 0) {
						gboolean _tmp14_ = FALSE;
						if (!g_str_has_suffix (common_prefix, "_")) {
							_tmp14_ = TRUE;
						} else {
							gboolean _tmp15_ = FALSE;
							if (g_unichar_isdigit (g_utf8_get_char (g_utf8_offset_to_pointer (value->name, string_get_length (common_prefix))))) {
								_tmp15_ = (g_utf8_strlen (value->name, -1) - g_utf8_strlen (common_prefix, -1)) <= 1;
							} else {
								_tmp15_ = FALSE;
							}
							_tmp14_ = _tmp15_;
						}
						_tmp13_ = _tmp14_;
					} else {
						_tmp13_ = FALSE;
					}
					if (!_tmp13_) {
						break;
					}
					common_prefix = (_tmp16_ = g_strndup (common_prefix, strlen (common_prefix) - 1), _g_free0 (common_prefix), _tmp16_);
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	is_errordomain = FALSE;
	cheader_filenames = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	en_attributes = (_tmp18_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp17_), en_attributes_length1 = _tmp17_, _en_attributes_size_ = en_attributes_length1, _tmp18_);
	if (en_attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = en_attributes;
			attr_collection_length1 = en_attributes_length1;
			for (attr_it = 0; attr_it < en_attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp20_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp19_;
					char** nv;
					nv = (_tmp20_ = _tmp19_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp19_), _nv_size_ = nv_length1, _tmp20_);
					if (_vala_strcmp0 (nv[0], "common_prefix") == 0) {
						char* _tmp21_;
						common_prefix = (_tmp21_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (common_prefix), _tmp21_);
					} else {
						if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
							char* _tmp22_;
							char* _tmp23_;
							vala_collection_add ((ValaCollection*) cheader_filenames, _tmp22_ = vala_gidl_parser_eval (self, nv[1]));
							_g_free0 (_tmp22_);
							vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) en, _tmp23_ = vala_gidl_parser_eval (self, nv[1]));
							_g_free0 (_tmp23_);
						} else {
							if (_vala_strcmp0 (nv[0], "hidden") == 0) {
								char* _tmp24_;
								gboolean _tmp25_;
								if ((_tmp25_ = _vala_strcmp0 (_tmp24_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp24_), _tmp25_)) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_collection_object_unref0 (cheader_filenames);
									_g_free0 (common_prefix);
									_vala_code_node_unref0 (en);
									_g_free0 (name);
									return;
								}
							} else {
								if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
									char* _tmp26_;
									gboolean _tmp27_;
									if ((_tmp27_ = _vala_strcmp0 (_tmp26_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp26_), _tmp27_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) en, TRUE);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "replacement") == 0) {
										char* _tmp28_;
										vala_symbol_set_replacement ((ValaSymbol*) en, _tmp28_ = vala_gidl_parser_eval (self, nv[1]));
										_g_free0 (_tmp28_);
									} else {
										if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
											char* _tmp29_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) en, _tmp29_ = vala_gidl_parser_eval (self, nv[1]));
											_g_free0 (_tmp29_);
										} else {
											if (_vala_strcmp0 (nv[0], "rename_to") == 0) {
												char* _tmp30_;
												vala_symbol_set_name ((ValaSymbol*) en, _tmp30_ = vala_gidl_parser_eval (self, nv[1]));
												_g_free0 (_tmp30_);
											} else {
												if (_vala_strcmp0 (nv[0], "errordomain") == 0) {
													char* _tmp31_;
													gboolean _tmp32_;
													if ((_tmp32_ = _vala_strcmp0 (_tmp31_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp31_), _tmp32_)) {
														is_errordomain = TRUE;
													}
												} else {
													if (_vala_strcmp0 (nv[0], "to_string") == 0) {
														ValaUnresolvedType* return_type;
														ValaUnresolvedSymbol* _tmp33_;
														ValaMethod* m;
														char* _tmp34_;
														return_type = vala_unresolved_type_new ();
														vala_unresolved_type_set_unresolved_symbol (return_type, _tmp33_ = vala_unresolved_symbol_new (NULL, "string", NULL));
														_vala_code_node_unref0 (_tmp33_);
														vala_data_type_set_value_owned ((ValaDataType*) return_type, FALSE);
														m = vala_method_new ("to_string", (ValaDataType*) return_type, self->priv->current_source_reference, NULL);
														vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
														vala_method_set_cname (m, _tmp34_ = vala_gidl_parser_eval (self, nv[1]));
														_g_free0 (_tmp34_);
														vala_enum_add_method (en, m);
														_vala_code_node_unref0 (m);
														_vala_code_node_unref0 (return_type);
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_enum_set_cprefix (en, common_prefix);
	{
		GList* value2_collection;
		GList* value2_it;
		value2_collection = en_node->values;
		for (value2_it = value2_collection; value2_it != NULL; value2_it = value2_it->next) {
			GIdlNode* value2;
			value2 = (GIdlNode*) value2_it->data;
			{
				char** _tmp36_;
				gint _val_attributes_size_;
				gint val_attributes_length1;
				gint _tmp35_;
				char** val_attributes;
				gboolean is_hidden;
				val_attributes = (_tmp36_ = vala_gidl_parser_get_attributes (self, value2->name, &_tmp35_), val_attributes_length1 = _tmp35_, _val_attributes_size_ = val_attributes_length1, _tmp36_);
				is_hidden = FALSE;
				if (val_attributes != NULL) {
					{
						char** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = val_attributes;
						attr_collection_length1 = val_attributes_length1;
						for (attr_it = 0; attr_it < val_attributes_length1; attr_it = attr_it + 1) {
							char* attr;
							attr = g_strdup (attr_collection[attr_it]);
							{
								char** _tmp38_;
								gint _nv_size_;
								gint nv_length1;
								char** _tmp37_;
								char** nv;
								gboolean _tmp39_ = FALSE;
								nv = (_tmp38_ = _tmp37_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp37_), _nv_size_ = nv_length1, _tmp38_);
								if (_vala_strcmp0 (nv[0], "hidden") == 0) {
									char* _tmp40_;
									_tmp39_ = _vala_strcmp0 (_tmp40_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0;
									_g_free0 (_tmp40_);
								} else {
									_tmp39_ = FALSE;
								}
								if (_tmp39_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (!is_hidden) {
					ValaEnumValue* ev;
					ev = vala_enum_value_new (g_utf8_offset_to_pointer (value2->name, g_utf8_strlen (common_prefix, -1)), NULL, NULL);
					vala_enum_add_value (en, ev);
					_vala_code_node_unref0 (ev);
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	if (is_errordomain) {
		ValaErrorDomain* ed;
		ed = vala_error_domain_new (vala_symbol_get_name ((ValaSymbol*) en), self->priv->current_source_reference, NULL);
		vala_symbol_set_access ((ValaSymbol*) ed, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_error_domain_set_cprefix (ed, common_prefix);
		{
			ValaIterator* _filename_it;
			_filename_it = vala_iterable_iterator ((ValaIterable*) cheader_filenames);
			while (TRUE) {
				char* filename;
				if (!vala_iterator_next (_filename_it)) {
					break;
				}
				filename = (char*) vala_iterator_get (_filename_it);
				vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) ed, filename);
				_g_free0 (filename);
			}
			_vala_collection_object_unref0 (_filename_it);
		}
		{
			ValaList* _tmp41_;
			ValaIterator* _tmp42_;
			ValaIterator* _ev_it;
			_ev_it = (_tmp42_ = vala_iterable_iterator ((ValaIterable*) (_tmp41_ = vala_enum_get_values (en))), _vala_collection_object_unref0 (_tmp41_), _tmp42_);
			while (TRUE) {
				ValaEnumValue* ev;
				ValaErrorCode* _tmp43_;
				if (!vala_iterator_next (_ev_it)) {
					break;
				}
				ev = (ValaEnumValue*) vala_iterator_get (_ev_it);
				vala_error_domain_add_code (ed, _tmp43_ = vala_error_code_new (vala_symbol_get_name ((ValaSymbol*) ev), NULL, NULL));
				_vala_code_node_unref0 (_tmp43_);
				_vala_code_node_unref0 (ev);
			}
			_vala_collection_object_unref0 (_ev_it);
		}
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) ed);
		if (!existing) {
			vala_namespace_add_error_domain (ns, ed);
		}
		_vala_code_node_unref0 (ed);
	} else {
		vala_enum_set_is_flags (en, is_flags);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) en);
		if (!existing) {
			vala_namespace_add_enum (ns, en);
		}
	}
	en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_collection_object_unref0 (cheader_filenames);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (en);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaNamespace* ns, GIdlModule* module) {
	char* name;
	char* base_class;
	ValaSymbol* _tmp0_;
	ValaClass* cl;
	ValaTypeSymbol* _tmp21_;
	ValaSet* _tmp22_;
	ValaHashMap* current_type_func_map;
	ValaHashMap* current_type_vfunc_map;
	ValaTypeSymbol* _tmp29_;
	ValaSet* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	name = vala_gidl_parser_fix_type_name (self, ((GIdlNode*) node)->name, ns);
	base_class = NULL;
	cl = (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL);
	if (cl == NULL) {
		ValaClass* _tmp1_;
		char** _tmp3_;
		gint _attributes_size_;
		gint attributes_length1;
		gint _tmp2_;
		char** attributes;
		cl = (_tmp1_ = vala_class_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (cl), _tmp1_);
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		attributes = (_tmp3_ = vala_gidl_parser_get_attributes (self, node->gtype_name, &_tmp2_), attributes_length1 = _tmp2_, _attributes_size_ = attributes_length1, _tmp3_);
		if (attributes != NULL) {
			{
				char** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					char* attr;
					attr = g_strdup (attr_collection[attr_it]);
					{
						char** _tmp5_;
						gint _nv_size_;
						gint nv_length1;
						char** _tmp4_;
						char** nv;
						nv = (_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp4_), _nv_size_ = nv_length1, _tmp5_);
						if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
							char* _tmp6_;
							vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) cl, _tmp6_ = vala_gidl_parser_eval (self, nv[1]));
							_g_free0 (_tmp6_);
						} else {
							if (_vala_strcmp0 (nv[0], "base_class") == 0) {
								char* _tmp7_;
								base_class = (_tmp7_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (base_class), _tmp7_);
							} else {
								if (_vala_strcmp0 (nv[0], "hidden") == 0) {
									char* _tmp8_;
									gboolean _tmp9_;
									if ((_tmp9_ = _vala_strcmp0 (_tmp8_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp8_), _tmp9_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (base_class);
										_g_free0 (name);
										return;
									}
								} else {
									if (_vala_strcmp0 (nv[0], "type_check_function") == 0) {
										char* _tmp10_;
										vala_class_set_type_check_function (cl, _tmp10_ = vala_gidl_parser_eval (self, nv[1]));
										_g_free0 (_tmp10_);
									} else {
										if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
											char* _tmp11_;
											gboolean _tmp12_;
											if ((_tmp12_ = _vala_strcmp0 (_tmp11_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp11_), _tmp12_)) {
												vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "replacement") == 0) {
												char* _tmp13_;
												vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp13_ = vala_gidl_parser_eval (self, nv[1]));
												_g_free0 (_tmp13_);
											} else {
												if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
													char* _tmp14_;
													vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp14_ = vala_gidl_parser_eval (self, nv[1]));
													_g_free0 (_tmp14_);
												} else {
													if (_vala_strcmp0 (nv[0], "type_id") == 0) {
														char* _tmp15_;
														vala_class_set_type_id (cl, _tmp15_ = vala_gidl_parser_eval (self, nv[1]));
														_g_free0 (_tmp15_);
													} else {
														if (_vala_strcmp0 (nv[0], "abstract") == 0) {
															char* _tmp16_;
															gboolean _tmp17_;
															if ((_tmp17_ = _vala_strcmp0 (_tmp16_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp16_), _tmp17_)) {
																vala_class_set_is_abstract (cl, TRUE);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		vala_namespace_add_class (ns, cl);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	if (base_class != NULL) {
		ValaDataType* parent;
		parent = vala_gidl_parser_parse_type_string (self, base_class);
		vala_class_add_base_type (cl, parent);
		_vala_code_node_unref0 (parent);
	} else {
		if (node->parent != NULL) {
			ValaDataType* parent;
			parent = vala_gidl_parser_parse_type_string (self, node->parent);
			vala_class_add_base_type (cl, parent);
			_vala_code_node_unref0 (parent);
		} else {
			ValaUnresolvedSymbol* _tmp18_;
			ValaUnresolvedSymbol* _tmp19_;
			ValaUnresolvedSymbol* gobject_symbol;
			ValaUnresolvedType* _tmp20_;
			gobject_symbol = (_tmp19_ = vala_unresolved_symbol_new (_tmp18_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "Object", NULL), _vala_code_node_unref0 (_tmp18_), _tmp19_);
			vala_class_add_base_type (cl, (ValaDataType*) (_tmp20_ = vala_unresolved_type_new_from_symbol (gobject_symbol, NULL)));
			_vala_code_node_unref0 (_tmp20_);
			_vala_code_node_unref0 (gobject_symbol);
		}
	}
	{
		GList* iface_name_collection;
		GList* iface_name_it;
		iface_name_collection = node->interfaces;
		for (iface_name_it = iface_name_collection; iface_name_it != NULL; iface_name_it = iface_name_it->next) {
			char* iface_name;
			iface_name = g_strdup ((const char*) iface_name_it->data);
			{
				ValaDataType* iface;
				iface = vala_gidl_parser_parse_type_string (self, iface_name);
				vala_class_add_base_type (cl, iface);
				_vala_code_node_unref0 (iface);
				_g_free0 (iface_name);
			}
		}
	}
	self->priv->current_data_type = (_tmp21_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl), _vala_code_node_unref0 (self->priv->current_data_type), _tmp21_);
	self->priv->current_type_symbol_set = (_tmp22_ = (ValaSet*) vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), _vala_collection_object_unref0 (self->priv->current_type_symbol_set), _tmp22_);
	current_type_func_map = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	current_type_vfunc_map = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					vala_map_set ((ValaMap*) current_type_func_map, member->name, (GIdlNodeFunction*) member);
				}
				if (member->type == G_IDL_NODE_VFUNC) {
					vala_map_set ((ValaMap*) current_type_vfunc_map, member->name, "1");
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					if (!vala_map_contains ((ValaMap*) current_type_vfunc_map, member->name)) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						if (m != NULL) {
							vala_class_add_method (cl, m);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					if (member->type == G_IDL_NODE_VFUNC) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) member, (GIdlNodeFunction*) vala_map_get ((ValaMap*) current_type_func_map, member->name), FALSE);
						if (m != NULL) {
							vala_class_add_method (cl, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* prop;
							prop = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) member);
							if (prop != NULL) {
								vala_class_add_property (cl, prop);
							}
							_vala_code_node_unref0 (prop);
						} else {
							if (member->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* sig;
								sig = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) member);
								if (sig != NULL) {
									vala_class_add_signal (cl, sig);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FIELD) {
					if (!vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, member->name)) {
						ValaField* f;
						f = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
						if (f != NULL) {
							vala_class_add_field (cl, f);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
		}
	}
	{
		ValaList* _tmp23_;
		ValaIterator* _tmp24_;
		ValaIterator* _prop_it;
		_prop_it = (_tmp24_ = vala_iterable_iterator ((ValaIterable*) (_tmp23_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), _vala_collection_object_unref0 (_tmp23_), _tmp24_);
		while (TRUE) {
			ValaProperty* prop;
			char* getter;
			gboolean _tmp25_ = FALSE;
			char* setter;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			if (!vala_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) vala_iterator_get (_prop_it);
			getter = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop));
			if (vala_property_get_get_accessor (prop) != NULL) {
				_tmp25_ = !vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, getter);
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				vala_property_set_no_accessor_method (prop, TRUE);
			}
			setter = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop));
			if (vala_property_get_set_accessor (prop) != NULL) {
				_tmp27_ = vala_property_accessor_get_writable (vala_property_get_set_accessor (prop));
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				_tmp26_ = !vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, setter);
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				vala_property_set_no_accessor_method (prop, TRUE);
			}
			if (vala_property_get_no_accessor_method (prop)) {
				_tmp28_ = vala_property_get_get_accessor (prop) != NULL;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				vala_data_type_set_value_owned (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)), TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
		_vala_collection_object_unref0 (_prop_it);
	}
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) cl);
	self->priv->current_data_type = (_tmp29_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp29_);
	self->priv->current_type_symbol_set = (_tmp30_ = NULL, _vala_collection_object_unref0 (self->priv->current_type_symbol_set), _tmp30_);
	_vala_collection_object_unref0 (current_type_vfunc_map);
	_vala_collection_object_unref0 (current_type_func_map);
	_vala_code_node_unref0 (cl);
	_g_free0 (base_class);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaNamespace* ns, GIdlModule* module) {
	char* name;
	ValaSymbol* _tmp0_;
	ValaInterface* iface;
	ValaTypeSymbol* _tmp8_;
	ValaHashMap* current_type_func_map;
	ValaHashMap* current_type_vfunc_map;
	ValaTypeSymbol* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (module != NULL);
	name = vala_gidl_parser_fix_type_name (self, node->gtype_name, ns);
	iface = (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) ns), name), VALA_IS_INTERFACE (_tmp0_) ? ((ValaInterface*) _tmp0_) : NULL);
	if (iface == NULL) {
		ValaInterface* _tmp1_;
		char** _tmp3_;
		gint _attributes_size_;
		gint attributes_length1;
		gint _tmp2_;
		char** attributes;
		iface = (_tmp1_ = vala_interface_new (name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (iface), _tmp1_);
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		attributes = (_tmp3_ = vala_gidl_parser_get_attributes (self, node->gtype_name, &_tmp2_), attributes_length1 = _tmp2_, _attributes_size_ = attributes_length1, _tmp3_);
		if (attributes != NULL) {
			{
				char** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					char* attr;
					attr = g_strdup (attr_collection[attr_it]);
					{
						char** _tmp5_;
						gint _nv_size_;
						gint nv_length1;
						char** _tmp4_;
						char** nv;
						nv = (_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp4_), _nv_size_ = nv_length1, _tmp5_);
						if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
							char* _tmp6_;
							vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) iface, _tmp6_ = vala_gidl_parser_eval (self, nv[1]));
							_g_free0 (_tmp6_);
						} else {
							if (_vala_strcmp0 (nv[0], "lower_case_csuffix") == 0) {
								char* _tmp7_;
								vala_interface_set_lower_case_csuffix (iface, _tmp7_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp7_);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		{
			GList* prereq_name_collection;
			GList* prereq_name_it;
			prereq_name_collection = node->prerequisites;
			for (prereq_name_it = prereq_name_collection; prereq_name_it != NULL; prereq_name_it = prereq_name_it->next) {
				char* prereq_name;
				prereq_name = g_strdup ((const char*) prereq_name_it->data);
				{
					ValaDataType* prereq;
					prereq = vala_gidl_parser_parse_type_string (self, prereq_name);
					vala_interface_add_prerequisite (iface, prereq);
					_vala_code_node_unref0 (prereq);
					_g_free0 (prereq_name);
				}
			}
		}
		vala_namespace_add_interface (ns, iface);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) iface);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	self->priv->current_data_type = (_tmp8_ = _vala_code_node_ref0 ((ValaTypeSymbol*) iface), _vala_code_node_unref0 (self->priv->current_data_type), _tmp8_);
	current_type_func_map = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	current_type_vfunc_map = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					vala_map_set ((ValaMap*) current_type_func_map, member->name, (GIdlNodeFunction*) member);
				}
				if (member->type == G_IDL_NODE_VFUNC) {
					vala_map_set ((ValaMap*) current_type_vfunc_map, member->name, "1");
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					if (!vala_map_contains ((ValaMap*) current_type_vfunc_map, member->name)) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, TRUE);
						if (m != NULL) {
							vala_interface_add_method (iface, m);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					if (member->type == G_IDL_NODE_VFUNC) {
						ValaMethod* m;
						m = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) member, (GIdlNodeFunction*) vala_map_get ((ValaMap*) current_type_func_map, member->name), TRUE);
						if (m != NULL) {
							vala_interface_add_method (iface, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* prop;
							prop = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) member);
							if (prop != NULL) {
								vala_interface_add_property (iface, prop);
							}
							_vala_code_node_unref0 (prop);
						} else {
							if (member->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* sig;
								sig = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) member);
								if (sig != NULL) {
									vala_interface_add_signal (iface, sig);
									vala_signal_set_is_virtual (sig, FALSE);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) iface);
	self->priv->current_data_type = (_tmp9_ = NULL, _vala_code_node_unref0 (self->priv->current_data_type), _tmp9_);
	_vala_collection_object_unref0 (current_type_vfunc_map);
	_vala_collection_object_unref0 (current_type_func_map);
	_vala_code_node_unref0 (iface);
	_g_free0 (name);
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol) {
	ValaList* methods;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_symbol != NULL);
	methods = vala_object_type_symbol_get_methods (type_symbol);
	{
		gint method_n;
		method_n = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaMethod* m;
				if (!_tmp0_) {
					method_n++;
				}
				_tmp0_ = FALSE;
				if (!(method_n < vala_collection_get_size ((ValaCollection*) methods))) {
					break;
				}
				m = (ValaMethod*) vala_list_get (methods, method_n);
				if (vala_method_get_coroutine (m)) {
					char* finish_method_base;
					char* _tmp3_;
					ValaSymbol* _tmp4_;
					ValaMethod* _tmp5_;
					ValaMethod* finish_method;
					finish_method_base = NULL;
					if (g_str_has_suffix (vala_symbol_get_name ((ValaSymbol*) m), "_async")) {
						char* _tmp1_;
						finish_method_base = (_tmp1_ = string_substring (vala_symbol_get_name ((ValaSymbol*) m), (glong) 0, string_get_length (vala_symbol_get_name ((ValaSymbol*) m)) - string_get_length ("_async")), _g_free0 (finish_method_base), _tmp1_);
					} else {
						char* _tmp2_;
						finish_method_base = (_tmp2_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) m)), _g_free0 (finish_method_base), _tmp2_);
					}
					finish_method = (_tmp5_ = (_tmp4_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) type_symbol), _tmp3_ = g_strconcat (finish_method_base, "_finish", NULL)), VALA_IS_METHOD (_tmp4_) ? ((ValaMethod*) _tmp4_) : NULL), _g_free0 (_tmp3_), _tmp5_);
					if (finish_method == NULL) {
						char* method_cname;
						method_cname = vala_method_get_finish_cname (m);
						{
							ValaList* _tmp6_;
							ValaIterator* _tmp7_;
							ValaIterator* _method_it;
							_method_it = (_tmp7_ = vala_iterable_iterator ((ValaIterable*) (_tmp6_ = vala_object_type_symbol_get_methods (type_symbol))), _vala_collection_object_unref0 (_tmp6_), _tmp7_);
							while (TRUE) {
								ValaMethod* method;
								char* _tmp8_;
								gboolean _tmp9_;
								if (!vala_iterator_next (_method_it)) {
									break;
								}
								method = (ValaMethod*) vala_iterator_get (_method_it);
								if ((_tmp9_ = _vala_strcmp0 (_tmp8_ = vala_method_get_cname (method), method_cname) == 0, _g_free0 (_tmp8_), _tmp9_)) {
									ValaMethod* _tmp10_;
									finish_method = (_tmp10_ = _vala_code_node_ref0 (method), _vala_code_node_unref0 (finish_method), _tmp10_);
									_vala_code_node_unref0 (method);
									break;
								}
								_vala_code_node_unref0 (method);
							}
							_vala_collection_object_unref0 (_method_it);
						}
						_g_free0 (method_cname);
					}
					if (finish_method != NULL) {
						ValaDataType* _tmp11_;
						vala_method_set_return_type (m, _tmp11_ = vala_data_type_copy (vala_method_get_return_type (finish_method)));
						_vala_code_node_unref0 (_tmp11_);
						vala_method_set_no_array_length (m, vala_method_get_no_array_length (finish_method));
						vala_method_set_array_null_terminated (m, vala_method_get_array_null_terminated (finish_method));
						{
							ValaList* _tmp12_;
							ValaIterator* _tmp13_;
							ValaIterator* _param_it;
							_param_it = (_tmp13_ = vala_iterable_iterator ((ValaIterable*) (_tmp12_ = vala_method_get_parameters (finish_method))), _vala_collection_object_unref0 (_tmp12_), _tmp13_);
							while (TRUE) {
								ValaFormalParameter* param;
								if (!vala_iterator_next (_param_it)) {
									break;
								}
								param = (ValaFormalParameter*) vala_iterator_get (_param_it);
								if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
									ValaFormalParameter* async_param;
									ValaSymbol* _tmp14_;
									gboolean _tmp15_;
									async_param = vala_formal_parameter_copy (param);
									if ((_tmp15_ = (_tmp14_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) param))) != NULL, _vala_code_node_unref0 (_tmp14_), _tmp15_)) {
										char* _tmp16_;
										vala_symbol_set_name ((ValaSymbol*) async_param, _tmp16_ = g_strconcat (vala_symbol_get_name ((ValaSymbol*) async_param), "_out", NULL));
										_g_free0 (_tmp16_);
									}
									vala_method_add_parameter (m, async_param);
									_vala_code_node_unref0 (async_param);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_collection_object_unref0 (_param_it);
						}
						{
							ValaList* _tmp17_;
							ValaIterator* _tmp18_;
							ValaIterator* _error_type_it;
							_error_type_it = (_tmp18_ = vala_iterable_iterator ((ValaIterable*) (_tmp17_ = vala_code_node_get_error_types ((ValaCodeNode*) finish_method))), _vala_collection_object_unref0 (_tmp17_), _tmp18_);
							while (TRUE) {
								ValaDataType* error_type;
								ValaDataType* _tmp19_;
								if (!vala_iterator_next (_error_type_it)) {
									break;
								}
								error_type = (ValaDataType*) vala_iterator_get (_error_type_it);
								vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp19_ = vala_data_type_copy (error_type));
								_vala_code_node_unref0 (_tmp19_);
								_vala_code_node_unref0 (error_type);
							}
							_vala_collection_object_unref0 (_error_type_it);
						}
						if (vala_list_index_of (methods, finish_method) < method_n) {
							method_n--;
						}
						vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) type_symbol), vala_symbol_get_name ((ValaSymbol*) finish_method));
						vala_collection_remove ((ValaCollection*) methods, finish_method);
					}
					_vala_code_node_unref0 (finish_method);
					_g_free0 (finish_method_base);
				}
				_vala_code_node_unref0 (m);
			}
		}
	}
	_vala_collection_object_unref0 (methods);
}


static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction) {
	ValaDataType* result = NULL;
	ValaParameterDirection dir;
	ValaUnresolvedType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_node != NULL, NULL);
	dir = VALA_PARAMETER_DIRECTION_IN;
	type = vala_unresolved_type_new ();
	if (type_node->tag == TYPE_TAG_VOID) {
		if (type_node->is_pointer) {
			ValaVoidType* _tmp0_;
			ValaDataType* _tmp1_;
			result = (_tmp1_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp0_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp0_), _tmp1_);
			_vala_code_node_unref0 (type);
			return result;
		} else {
			result = (ValaDataType*) vala_void_type_new (NULL);
			_vala_code_node_unref0 (type);
			return result;
		}
	} else {
		if (type_node->tag == TYPE_TAG_BOOLEAN) {
			ValaUnresolvedSymbol* _tmp2_;
			vala_unresolved_type_set_unresolved_symbol (type, _tmp2_ = vala_unresolved_symbol_new (NULL, "bool", NULL));
			_vala_code_node_unref0 (_tmp2_);
		} else {
			if (type_node->tag == TYPE_TAG_INT8) {
				ValaUnresolvedSymbol* _tmp3_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp3_ = vala_unresolved_symbol_new (NULL, "char", NULL));
				_vala_code_node_unref0 (_tmp3_);
			} else {
				if (type_node->tag == TYPE_TAG_UINT8) {
					ValaUnresolvedSymbol* _tmp4_;
					vala_unresolved_type_set_unresolved_symbol (type, _tmp4_ = vala_unresolved_symbol_new (NULL, "uchar", NULL));
					_vala_code_node_unref0 (_tmp4_);
				} else {
					if (type_node->tag == TYPE_TAG_INT16) {
						ValaUnresolvedSymbol* _tmp5_;
						vala_unresolved_type_set_unresolved_symbol (type, _tmp5_ = vala_unresolved_symbol_new (NULL, "int16", NULL));
						_vala_code_node_unref0 (_tmp5_);
					} else {
						if (type_node->tag == TYPE_TAG_UINT16) {
							ValaUnresolvedSymbol* _tmp6_;
							vala_unresolved_type_set_unresolved_symbol (type, _tmp6_ = vala_unresolved_symbol_new (NULL, "uint16", NULL));
							_vala_code_node_unref0 (_tmp6_);
						} else {
							if (type_node->tag == TYPE_TAG_INT32) {
								ValaUnresolvedSymbol* _tmp7_;
								vala_unresolved_type_set_unresolved_symbol (type, _tmp7_ = vala_unresolved_symbol_new (NULL, "int32", NULL));
								_vala_code_node_unref0 (_tmp7_);
							} else {
								if (type_node->tag == TYPE_TAG_UINT32) {
									ValaUnresolvedSymbol* _tmp8_;
									vala_unresolved_type_set_unresolved_symbol (type, _tmp8_ = vala_unresolved_symbol_new (NULL, "uint32", NULL));
									_vala_code_node_unref0 (_tmp8_);
								} else {
									if (type_node->tag == TYPE_TAG_INT64) {
										ValaUnresolvedSymbol* _tmp9_;
										vala_unresolved_type_set_unresolved_symbol (type, _tmp9_ = vala_unresolved_symbol_new (NULL, "int64", NULL));
										_vala_code_node_unref0 (_tmp9_);
									} else {
										if (type_node->tag == TYPE_TAG_UINT64) {
											ValaUnresolvedSymbol* _tmp10_;
											vala_unresolved_type_set_unresolved_symbol (type, _tmp10_ = vala_unresolved_symbol_new (NULL, "uint64", NULL));
											_vala_code_node_unref0 (_tmp10_);
										} else {
											if (type_node->tag == TYPE_TAG_INT) {
												ValaUnresolvedSymbol* _tmp11_;
												vala_unresolved_type_set_unresolved_symbol (type, _tmp11_ = vala_unresolved_symbol_new (NULL, "int", NULL));
												_vala_code_node_unref0 (_tmp11_);
											} else {
												if (type_node->tag == TYPE_TAG_UINT) {
													ValaUnresolvedSymbol* _tmp12_;
													vala_unresolved_type_set_unresolved_symbol (type, _tmp12_ = vala_unresolved_symbol_new (NULL, "uint", NULL));
													_vala_code_node_unref0 (_tmp12_);
												} else {
													if (type_node->tag == TYPE_TAG_LONG) {
														ValaUnresolvedSymbol* _tmp13_;
														vala_unresolved_type_set_unresolved_symbol (type, _tmp13_ = vala_unresolved_symbol_new (NULL, "long", NULL));
														_vala_code_node_unref0 (_tmp13_);
													} else {
														if (type_node->tag == TYPE_TAG_ULONG) {
															ValaUnresolvedSymbol* _tmp14_;
															vala_unresolved_type_set_unresolved_symbol (type, _tmp14_ = vala_unresolved_symbol_new (NULL, "ulong", NULL));
															_vala_code_node_unref0 (_tmp14_);
														} else {
															if (type_node->tag == TYPE_TAG_SSIZE) {
																ValaUnresolvedSymbol* _tmp15_;
																vala_unresolved_type_set_unresolved_symbol (type, _tmp15_ = vala_unresolved_symbol_new (NULL, "ssize_t", NULL));
																_vala_code_node_unref0 (_tmp15_);
															} else {
																if (type_node->tag == TYPE_TAG_SIZE) {
																	ValaUnresolvedSymbol* _tmp16_;
																	vala_unresolved_type_set_unresolved_symbol (type, _tmp16_ = vala_unresolved_symbol_new (NULL, "size_t", NULL));
																	_vala_code_node_unref0 (_tmp16_);
																} else {
																	if (type_node->tag == TYPE_TAG_FLOAT) {
																		ValaUnresolvedSymbol* _tmp17_;
																		vala_unresolved_type_set_unresolved_symbol (type, _tmp17_ = vala_unresolved_symbol_new (NULL, "float", NULL));
																		_vala_code_node_unref0 (_tmp17_);
																	} else {
																		if (type_node->tag == TYPE_TAG_DOUBLE) {
																			ValaUnresolvedSymbol* _tmp18_;
																			vala_unresolved_type_set_unresolved_symbol (type, _tmp18_ = vala_unresolved_symbol_new (NULL, "double", NULL));
																			_vala_code_node_unref0 (_tmp18_);
																		} else {
																			if (type_node->tag == TYPE_TAG_UTF8) {
																				ValaUnresolvedSymbol* _tmp19_;
																				vala_unresolved_type_set_unresolved_symbol (type, _tmp19_ = vala_unresolved_symbol_new (NULL, "string", NULL));
																				_vala_code_node_unref0 (_tmp19_);
																			} else {
																				if (type_node->tag == TYPE_TAG_FILENAME) {
																					ValaUnresolvedSymbol* _tmp20_;
																					vala_unresolved_type_set_unresolved_symbol (type, _tmp20_ = vala_unresolved_symbol_new (NULL, "string", NULL));
																					_vala_code_node_unref0 (_tmp20_);
																				} else {
																					if (type_node->tag == TYPE_TAG_ARRAY) {
																						ValaDataType* element_type;
																						ValaUnresolvedType* _tmp22_;
																						ValaDataType* _tmp21_;
																						element_type = vala_gidl_parser_parse_type (self, type_node->parameter_type1, NULL);
																						type = (_tmp22_ = _vala_code_node_ref0 ((_tmp21_ = element_type, VALA_IS_UNRESOLVED_TYPE (_tmp21_) ? ((ValaUnresolvedType*) _tmp21_) : NULL)), _vala_code_node_unref0 (type), _tmp22_);
																						if (type == NULL) {
																							result = element_type;
																							_vala_code_node_unref0 (type);
																							return result;
																						}
																						result = (ValaDataType*) vala_array_type_new (element_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) element_type));
																						_vala_code_node_unref0 (element_type);
																						_vala_code_node_unref0 (type);
																						return result;
																					} else {
																						if (type_node->tag == TYPE_TAG_LIST) {
																							ValaUnresolvedSymbol* _tmp24_;
																							ValaUnresolvedSymbol* _tmp23_;
																							vala_unresolved_type_set_unresolved_symbol (type, _tmp24_ = vala_unresolved_symbol_new (_tmp23_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "List", NULL));
																							_vala_code_node_unref0 (_tmp24_);
																							_vala_code_node_unref0 (_tmp23_);
																						} else {
																							if (type_node->tag == TYPE_TAG_SLIST) {
																								ValaUnresolvedSymbol* _tmp26_;
																								ValaUnresolvedSymbol* _tmp25_;
																								vala_unresolved_type_set_unresolved_symbol (type, _tmp26_ = vala_unresolved_symbol_new (_tmp25_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "SList", NULL));
																								_vala_code_node_unref0 (_tmp26_);
																								_vala_code_node_unref0 (_tmp25_);
																							} else {
																								if (type_node->tag == TYPE_TAG_HASH) {
																									ValaUnresolvedSymbol* _tmp28_;
																									ValaUnresolvedSymbol* _tmp27_;
																									vala_unresolved_type_set_unresolved_symbol (type, _tmp28_ = vala_unresolved_symbol_new (_tmp27_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "HashTable", NULL));
																									_vala_code_node_unref0 (_tmp28_);
																									_vala_code_node_unref0 (_tmp27_);
																								} else {
																									if (type_node->tag == TYPE_TAG_ERROR) {
																										ValaUnresolvedSymbol* _tmp30_;
																										ValaUnresolvedSymbol* _tmp29_;
																										vala_unresolved_type_set_unresolved_symbol (type, _tmp30_ = vala_unresolved_symbol_new (_tmp29_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "Error", NULL));
																										_vala_code_node_unref0 (_tmp30_);
																										_vala_code_node_unref0 (_tmp29_);
																									} else {
																										if (type_node->is_interface) {
																											char* n;
																											gboolean _tmp32_ = FALSE;
																											n = g_strdup (type_node->interface);
																											if (_vala_strcmp0 (n, "") == 0) {
																												result = NULL;
																												_g_free0 (n);
																												_vala_code_node_unref0 (type);
																												return result;
																											}
																											if (g_str_has_prefix (n, "const-")) {
																												char* _tmp31_;
																												n = (_tmp31_ = g_strdup (g_utf8_offset_to_pointer (n, g_utf8_strlen ("const-", -1))), _g_free0 (n), _tmp31_);
																											}
																											if (type_node->is_pointer) {
																												gboolean _tmp33_ = FALSE;
																												if (_vala_strcmp0 (n, "gchar") == 0) {
																													_tmp33_ = TRUE;
																												} else {
																													_tmp33_ = _vala_strcmp0 (n, "char") == 0;
																												}
																												_tmp32_ = _tmp33_;
																											} else {
																												_tmp32_ = FALSE;
																											}
																											if (_tmp32_) {
																												ValaUnresolvedSymbol* _tmp34_;
																												vala_unresolved_type_set_unresolved_symbol (type, _tmp34_ = vala_unresolved_symbol_new (NULL, "string", NULL));
																												_vala_code_node_unref0 (_tmp34_);
																												if (g_str_has_suffix (type_node->unparsed, "**")) {
																													dir = VALA_PARAMETER_DIRECTION_OUT;
																												}
																											} else {
																												if (_vala_strcmp0 (n, "gunichar") == 0) {
																													ValaUnresolvedSymbol* _tmp35_;
																													vala_unresolved_type_set_unresolved_symbol (type, _tmp35_ = vala_unresolved_symbol_new (NULL, "unichar", NULL));
																													_vala_code_node_unref0 (_tmp35_);
																												} else {
																													if (_vala_strcmp0 (n, "gchar") == 0) {
																														ValaUnresolvedSymbol* _tmp36_;
																														vala_unresolved_type_set_unresolved_symbol (type, _tmp36_ = vala_unresolved_symbol_new (NULL, "char", NULL));
																														_vala_code_node_unref0 (_tmp36_);
																													} else {
																														gboolean _tmp37_ = FALSE;
																														if (_vala_strcmp0 (n, "guchar") == 0) {
																															_tmp37_ = TRUE;
																														} else {
																															_tmp37_ = _vala_strcmp0 (n, "guint8") == 0;
																														}
																														if (_tmp37_) {
																															ValaUnresolvedSymbol* _tmp38_;
																															vala_unresolved_type_set_unresolved_symbol (type, _tmp38_ = vala_unresolved_symbol_new (NULL, "uchar", NULL));
																															_vala_code_node_unref0 (_tmp38_);
																															if (type_node->is_pointer) {
																																result = (ValaDataType*) vala_array_type_new ((ValaDataType*) type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) type));
																																_g_free0 (n);
																																_vala_code_node_unref0 (type);
																																return result;
																															}
																														} else {
																															if (_vala_strcmp0 (n, "gushort") == 0) {
																																ValaUnresolvedSymbol* _tmp39_;
																																vala_unresolved_type_set_unresolved_symbol (type, _tmp39_ = vala_unresolved_symbol_new (NULL, "ushort", NULL));
																																_vala_code_node_unref0 (_tmp39_);
																															} else {
																																if (_vala_strcmp0 (n, "gshort") == 0) {
																																	ValaUnresolvedSymbol* _tmp40_;
																																	vala_unresolved_type_set_unresolved_symbol (type, _tmp40_ = vala_unresolved_symbol_new (NULL, "short", NULL));
																																	_vala_code_node_unref0 (_tmp40_);
																																} else {
																																	gboolean _tmp41_ = FALSE;
																																	if (_vala_strcmp0 (n, "gconstpointer") == 0) {
																																		_tmp41_ = TRUE;
																																	} else {
																																		_tmp41_ = _vala_strcmp0 (n, "void") == 0;
																																	}
																																	if (_tmp41_) {
																																		ValaVoidType* _tmp42_;
																																		ValaDataType* _tmp43_;
																																		result = (_tmp43_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp42_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp42_), _tmp43_);
																																		_g_free0 (n);
																																		_vala_code_node_unref0 (type);
																																		return result;
																																	} else {
																																		gboolean _tmp44_ = FALSE;
																																		if (_vala_strcmp0 (n, "goffset") == 0) {
																																			_tmp44_ = TRUE;
																																		} else {
																																			_tmp44_ = _vala_strcmp0 (n, "off_t") == 0;
																																		}
																																		if (_tmp44_) {
																																			ValaUnresolvedSymbol* _tmp45_;
																																			vala_unresolved_type_set_unresolved_symbol (type, _tmp45_ = vala_unresolved_symbol_new (NULL, "int64", NULL));
																																			_vala_code_node_unref0 (_tmp45_);
																																		} else {
																																			if (_vala_strcmp0 (n, "value_array") == 0) {
																																				ValaUnresolvedSymbol* _tmp47_;
																																				ValaUnresolvedSymbol* _tmp46_;
																																				vala_unresolved_type_set_unresolved_symbol (type, _tmp47_ = vala_unresolved_symbol_new (_tmp46_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "ValueArray", NULL));
																																				_vala_code_node_unref0 (_tmp47_);
																																				_vala_code_node_unref0 (_tmp46_);
																																			} else {
																																				if (_vala_strcmp0 (n, "time_t") == 0) {
																																					ValaUnresolvedSymbol* _tmp48_;
																																					vala_unresolved_type_set_unresolved_symbol (type, _tmp48_ = vala_unresolved_symbol_new (NULL, "ulong", NULL));
																																					_vala_code_node_unref0 (_tmp48_);
																																				} else {
																																					if (_vala_strcmp0 (n, "socklen_t") == 0) {
																																						ValaUnresolvedSymbol* _tmp49_;
																																						vala_unresolved_type_set_unresolved_symbol (type, _tmp49_ = vala_unresolved_symbol_new (NULL, "uint32", NULL));
																																						_vala_code_node_unref0 (_tmp49_);
																																					} else {
																																						if (_vala_strcmp0 (n, "mode_t") == 0) {
																																							ValaUnresolvedSymbol* _tmp50_;
																																							vala_unresolved_type_set_unresolved_symbol (type, _tmp50_ = vala_unresolved_symbol_new (NULL, "uint", NULL));
																																							_vala_code_node_unref0 (_tmp50_);
																																						} else {
																																							gboolean _tmp51_ = FALSE;
																																							if (_vala_strcmp0 (n, "gint") == 0) {
																																								_tmp51_ = TRUE;
																																							} else {
																																								_tmp51_ = _vala_strcmp0 (n, "pid_t") == 0;
																																							}
																																							if (_tmp51_) {
																																								ValaUnresolvedSymbol* _tmp52_;
																																								vala_unresolved_type_set_unresolved_symbol (type, _tmp52_ = vala_unresolved_symbol_new (NULL, "int", NULL));
																																								_vala_code_node_unref0 (_tmp52_);
																																							} else {
																																								gboolean _tmp53_ = FALSE;
																																								if (_vala_strcmp0 (n, "unsigned") == 0) {
																																									_tmp53_ = TRUE;
																																								} else {
																																									_tmp53_ = _vala_strcmp0 (n, "unsigned-int") == 0;
																																								}
																																								if (_tmp53_) {
																																									ValaUnresolvedSymbol* _tmp54_;
																																									vala_unresolved_type_set_unresolved_symbol (type, _tmp54_ = vala_unresolved_symbol_new (NULL, "uint", NULL));
																																									_vala_code_node_unref0 (_tmp54_);
																																								} else {
																																									if (_vala_strcmp0 (n, "FILE") == 0) {
																																										ValaUnresolvedSymbol* _tmp56_;
																																										ValaUnresolvedSymbol* _tmp55_;
																																										vala_unresolved_type_set_unresolved_symbol (type, _tmp56_ = vala_unresolved_symbol_new (_tmp55_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "FileStream", NULL));
																																										_vala_code_node_unref0 (_tmp56_);
																																										_vala_code_node_unref0 (_tmp55_);
																																									} else {
																																										if (_vala_strcmp0 (n, "struct") == 0) {
																																											ValaVoidType* _tmp57_;
																																											ValaDataType* _tmp58_;
																																											result = (_tmp58_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp57_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp57_), _tmp58_);
																																											_g_free0 (n);
																																											_vala_code_node_unref0 (type);
																																											return result;
																																										} else {
																																											if (_vala_strcmp0 (n, "iconv_t") == 0) {
																																												ValaVoidType* _tmp59_;
																																												ValaDataType* _tmp60_;
																																												result = (_tmp60_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp59_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp59_), _tmp60_);
																																												_g_free0 (n);
																																												_vala_code_node_unref0 (type);
																																												return result;
																																											} else {
																																												if (_vala_strcmp0 (n, "GType") == 0) {
																																													ValaUnresolvedSymbol* _tmp62_;
																																													ValaUnresolvedSymbol* _tmp61_;
																																													vala_unresolved_type_set_unresolved_symbol (type, _tmp62_ = vala_unresolved_symbol_new (_tmp61_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), "Type", NULL));
																																													_vala_code_node_unref0 (_tmp62_);
																																													_vala_code_node_unref0 (_tmp61_);
																																													if (type_node->is_pointer) {
																																														result = (ValaDataType*) vala_array_type_new ((ValaDataType*) type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) type));
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														return result;
																																													}
																																												} else {
																																													if (_vala_strcmp0 (n, "GStrv") == 0) {
																																														ValaUnresolvedSymbol* _tmp63_;
																																														vala_unresolved_type_set_unresolved_symbol (type, _tmp63_ = vala_unresolved_symbol_new (NULL, "string", NULL));
																																														_vala_code_node_unref0 (_tmp63_);
																																														result = (ValaDataType*) vala_array_type_new ((ValaDataType*) type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) type));
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														return result;
																																													} else {
																																														ValaDataType* named_type;
																																														ValaUnresolvedType* _tmp65_;
																																														ValaDataType* _tmp64_;
																																														named_type = vala_gidl_parser_parse_type_string (self, n);
																																														type = (_tmp65_ = _vala_code_node_ref0 ((_tmp64_ = named_type, VALA_IS_UNRESOLVED_TYPE (_tmp64_) ? ((ValaUnresolvedType*) _tmp64_) : NULL)), _vala_code_node_unref0 (type), _tmp65_);
																																														if (type == NULL) {
																																															result = named_type;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															return result;
																																														}
																																														if (vala_gidl_parser_is_simple_type (self, n)) {
																																															if (type_node->is_pointer) {
																																																dir = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														} else {
																																															if (g_str_has_suffix (type_node->unparsed, "**")) {
																																																dir = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														}
																																														_vala_code_node_unref0 (named_type);
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																											_g_free0 (n);
																										} else {
																											fprintf (stdout, "%d\n", (gint) type_node->tag);
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if ((direction) != NULL) {
		*direction = dir;
	}
	result = (ValaDataType*) type;
	return result;
}


static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const char* type_name) {
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	ValaStruct* st;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_name != NULL, FALSE);
	st = (_tmp0_ = (ValaTypeSymbol*) vala_map_get (self->priv->cname_type_map, type_name), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL);
	if (st != NULL) {
		_tmp1_ = vala_struct_is_simple_type (st);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (st);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const char* n) {
	ValaDataType* result = NULL;
	ValaUnresolvedType* type;
	ValaTypeSymbol* dt;
	char** _tmp5_;
	gint _type_attributes_size_;
	gint type_attributes_length1;
	gint _tmp4_;
	char** type_attributes;
	char* ns_name;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	if (_vala_strcmp0 (n, "va_list") == 0) {
		ValaVoidType* _tmp0_;
		ValaDataType* _tmp1_;
		result = (_tmp1_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp0_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp0_), _tmp1_);
		return result;
	}
	type = vala_unresolved_type_new ();
	dt = (ValaTypeSymbol*) vala_map_get (self->priv->cname_type_map, n);
	if (dt != NULL) {
		ValaUnresolvedSymbol* parent_symbol;
		ValaUnresolvedSymbol* _tmp3_;
		parent_symbol = NULL;
		if (vala_symbol_get_name (vala_symbol_get_parent_symbol ((ValaSymbol*) dt)) != NULL) {
			ValaUnresolvedSymbol* _tmp2_;
			parent_symbol = (_tmp2_ = vala_unresolved_symbol_new (NULL, vala_symbol_get_name (vala_symbol_get_parent_symbol ((ValaSymbol*) dt)), NULL), _vala_code_node_unref0 (parent_symbol), _tmp2_);
		}
		vala_unresolved_type_set_unresolved_symbol (type, _tmp3_ = vala_unresolved_symbol_new (parent_symbol, vala_symbol_get_name ((ValaSymbol*) dt), NULL));
		_vala_code_node_unref0 (_tmp3_);
		result = (ValaDataType*) type;
		_vala_code_node_unref0 (parent_symbol);
		_vala_code_node_unref0 (dt);
		return result;
	}
	type_attributes = (_tmp5_ = vala_gidl_parser_get_attributes (self, n, &_tmp4_), type_attributes_length1 = _tmp4_, _type_attributes_size_ = type_attributes_length1, _tmp5_);
	ns_name = NULL;
	if (NULL != type_attributes) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = type_attributes;
			attr_collection_length1 = type_attributes_length1;
			for (attr_it = 0; attr_it < type_attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp7_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp6_;
					char** nv;
					nv = (_tmp7_ = _tmp6_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp6_), _nv_size_ = nv_length1, _tmp7_);
					if (_vala_strcmp0 (nv[0], "cprefix") == 0) {
						ValaUnresolvedSymbol* _tmp9_;
						char* _tmp8_;
						vala_unresolved_type_set_unresolved_symbol (type, _tmp9_ = vala_unresolved_symbol_new (NULL, g_utf8_offset_to_pointer (n, g_utf8_strlen (_tmp8_ = vala_gidl_parser_eval (self, nv[1]), -1)), NULL));
						_vala_code_node_unref0 (_tmp9_);
						_g_free0 (_tmp8_);
					} else {
						if (_vala_strcmp0 (nv[0], "name") == 0) {
							ValaUnresolvedSymbol* _tmp11_;
							char* _tmp10_;
							vala_unresolved_type_set_unresolved_symbol (type, _tmp11_ = vala_unresolved_symbol_new (NULL, _tmp10_ = vala_gidl_parser_eval (self, nv[1]), NULL));
							_vala_code_node_unref0 (_tmp11_);
							_g_free0 (_tmp10_);
						} else {
							if (_vala_strcmp0 (nv[0], "namespace") == 0) {
								char* _tmp12_;
								ns_name = (_tmp12_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (ns_name), _tmp12_);
							} else {
								if (_vala_strcmp0 (nv[0], "rename_to") == 0) {
									ValaUnresolvedSymbol* _tmp14_;
									char* _tmp13_;
									vala_unresolved_type_set_unresolved_symbol (type, _tmp14_ = vala_unresolved_symbol_new (NULL, _tmp13_ = vala_gidl_parser_eval (self, nv[1]), NULL));
									_vala_code_node_unref0 (_tmp14_);
									_g_free0 (_tmp13_);
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	if (vala_unresolved_type_get_unresolved_symbol (type) != NULL) {
		if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) vala_unresolved_type_get_unresolved_symbol (type)), "pointer") == 0) {
			ValaVoidType* _tmp15_;
			ValaDataType* _tmp16_;
			result = (_tmp16_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp15_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp15_), _tmp16_);
			_g_free0 (ns_name);
			type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (dt);
			_vala_code_node_unref0 (type);
			return result;
		}
		if (ns_name != NULL) {
			ValaUnresolvedSymbol* _tmp17_;
			vala_unresolved_symbol_set_inner (vala_unresolved_type_get_unresolved_symbol (type), _tmp17_ = vala_unresolved_symbol_new (NULL, ns_name, NULL));
			_vala_code_node_unref0 (_tmp17_);
		}
		result = (ValaDataType*) type;
		_g_free0 (ns_name);
		type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (dt);
		return result;
	}
	if (g_str_has_prefix (n, vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace))) {
		ValaUnresolvedSymbol* _tmp19_;
		ValaUnresolvedSymbol* _tmp18_;
		vala_unresolved_type_set_unresolved_symbol (type, _tmp19_ = vala_unresolved_symbol_new (_tmp18_ = vala_unresolved_symbol_new (NULL, vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace), NULL), g_utf8_offset_to_pointer (n, g_utf8_strlen (vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace), -1)), NULL));
		_vala_code_node_unref0 (_tmp19_);
		_vala_code_node_unref0 (_tmp18_);
	} else {
		if (g_str_has_prefix (n, "G")) {
			ValaUnresolvedSymbol* _tmp21_;
			ValaUnresolvedSymbol* _tmp20_;
			vala_unresolved_type_set_unresolved_symbol (type, _tmp21_ = vala_unresolved_symbol_new (_tmp20_ = vala_unresolved_symbol_new (NULL, "GLib", NULL), g_utf8_offset_to_pointer (n, (glong) 1), NULL));
			_vala_code_node_unref0 (_tmp21_);
			_vala_code_node_unref0 (_tmp20_);
		} else {
			char** _tmp23_;
			gint _name_parts_size_;
			gint name_parts_length1;
			char** _tmp22_;
			char** name_parts;
			name_parts = (_tmp23_ = _tmp22_ = g_strsplit (n, ".", 2), name_parts_length1 = _vala_array_length (_tmp22_), _name_parts_size_ = name_parts_length1, _tmp23_);
			if (name_parts[1] == NULL) {
				ValaUnresolvedSymbol* _tmp24_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp24_ = vala_unresolved_symbol_new (NULL, name_parts[0], NULL));
				_vala_code_node_unref0 (_tmp24_);
			} else {
				ValaUnresolvedSymbol* _tmp26_;
				ValaUnresolvedSymbol* _tmp25_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp26_ = vala_unresolved_symbol_new (_tmp25_ = vala_unresolved_symbol_new (NULL, name_parts[0], NULL), name_parts[1], NULL));
				_vala_code_node_unref0 (_tmp26_);
				_vala_code_node_unref0 (_tmp25_);
			}
			name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	result = (ValaDataType*) type;
	_g_free0 (ns_name);
	type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (dt);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction) {
	ValaDataType* result = NULL;
	ValaDataType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	type = vala_gidl_parser_parse_type (self, param->type, direction);
	result = type;
	return result;
}


ValaDataType* vala_gidl_parser_get_type_from_string (ValaGIdlParser* self, const char* type_arg) {
	ValaDataType* result = NULL;
	gboolean is_unowned;
	ValaUnresolvedSymbol* sym;
	ValaUnresolvedType* arg_type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_arg != NULL, NULL);
	is_unowned = FALSE;
	sym = NULL;
	if (_vala_strcmp0 (type_arg, "pointer") == 0) {
		ValaVoidType* _tmp0_;
		ValaDataType* _tmp1_;
		result = (_tmp1_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp0_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (_tmp0_), _tmp1_);
		_vala_code_node_unref0 (sym);
		return result;
	}
	if (g_str_has_prefix (type_arg, "unowned ")) {
		type_arg = g_utf8_offset_to_pointer (type_arg, g_utf8_strlen ("unowned ", -1));
		is_unowned = TRUE;
	}
	{
		char** _tmp2_;
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = _tmp2_ = g_strsplit (type_arg, ".", 0);
		s_collection_length1 = _vala_array_length (_tmp2_);
		for (s_it = 0; s_it < _vala_array_length (_tmp2_); s_it = s_it + 1) {
			const char* s;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp3_;
				sym = (_tmp3_ = vala_unresolved_symbol_new (sym, s, NULL), _vala_code_node_unref0 (sym), _tmp3_);
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	arg_type = vala_unresolved_type_new_from_symbol (sym, NULL);
	vala_data_type_set_value_owned ((ValaDataType*) arg_type, !is_unowned);
	result = (ValaDataType*) arg_type;
	_vala_code_node_unref0 (sym);
	return result;
}


static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const char* name, const char* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface) {
	ValaMethod* result = NULL;
	ValaDataType* return_type;
	ValaMethod* m;
	gboolean _tmp1_ = FALSE;
	gboolean add_ellipsis;
	gboolean suppress_throws;
	char** _tmp19_;
	gint _attributes_size_;
	gint attributes_length1;
	gint _tmp18_;
	char** attributes;
	gboolean first;
	ValaFormalParameter* last_param;
	ValaDataType* last_param_type;
	gboolean _tmp145_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	return_type = NULL;
	if (res != NULL) {
		ValaDataType* _tmp0_;
		return_type = (_tmp0_ = vala_gidl_parser_parse_param (self, res, NULL), _vala_code_node_unref0 (return_type), _tmp0_);
	}
	m = NULL;
	if (!is_interface) {
		gboolean _tmp2_ = FALSE;
		if (is_constructor) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = g_str_has_prefix (name, "new");
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaMethod* _tmp3_;
		gboolean _tmp4_ = FALSE;
		m = (_tmp3_ = (ValaMethod*) vala_creation_method_new (NULL, name, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (m), _tmp3_);
		vala_method_set_has_construct_function (m, FALSE);
		if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) m), "new") == 0) {
			vala_symbol_set_name ((ValaSymbol*) m, NULL);
		} else {
			if (g_str_has_prefix (vala_symbol_get_name ((ValaSymbol*) m), "new_")) {
				vala_symbol_set_name ((ValaSymbol*) m, g_utf8_offset_to_pointer (vala_symbol_get_name ((ValaSymbol*) m), g_utf8_strlen ("new_", -1)));
			}
		}
		if (VALA_IS_CLASS (self->priv->current_data_type)) {
			_tmp4_ = res != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			char* _tmp6_;
			char* _tmp5_;
			gboolean _tmp7_;
			if ((_tmp7_ = _vala_strcmp0 (_tmp6_ = g_strdup_printf ("%s*", _tmp5_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE)), res->type->unparsed) != 0, _g_free0 (_tmp6_), _g_free0 (_tmp5_), _tmp7_)) {
				vala_creation_method_set_custom_return_type_cname (VALA_CREATION_METHOD (m), res->type->unparsed);
			}
		}
	} else {
		ValaMethod* _tmp8_;
		m = (_tmp8_ = vala_method_new (name, return_type, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (m), _tmp8_);
	}
	vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (self->priv->current_type_symbol_set != NULL) {
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, name);
	}
	if (self->priv->current_data_type != NULL) {
		char** _tmp13_;
		gint _sig_attributes_size_;
		gint sig_attributes_length1;
		gint _tmp11_;
		char* _tmp10_;
		char* _tmp9_;
		char** _tmp12_;
		char** sig_attributes;
		sig_attributes = (_tmp13_ = (_tmp12_ = vala_gidl_parser_get_attributes (self, _tmp10_ = g_strdup_printf ("%s::%s", _tmp9_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE), name), &_tmp11_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _tmp12_), sig_attributes_length1 = _tmp11_, _sig_attributes_size_ = sig_attributes_length1, _tmp13_);
		if (sig_attributes != NULL) {
			{
				char** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = sig_attributes;
				attr_collection_length1 = sig_attributes_length1;
				for (attr_it = 0; attr_it < sig_attributes_length1; attr_it = attr_it + 1) {
					char* attr;
					attr = g_strdup (attr_collection[attr_it]);
					{
						char** _tmp15_;
						gint _nv_size_;
						gint nv_length1;
						char** _tmp14_;
						char** nv;
						gboolean _tmp16_ = FALSE;
						nv = (_tmp15_ = _tmp14_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp14_), _nv_size_ = nv_length1, _tmp15_);
						if (_vala_strcmp0 (nv[0], "has_emitter") == 0) {
							char* _tmp17_;
							_tmp16_ = _vala_strcmp0 (_tmp17_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0;
							_g_free0 (_tmp17_);
						} else {
							_tmp16_ = FALSE;
						}
						if (_tmp16_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (return_type);
							return result;
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	add_ellipsis = FALSE;
	suppress_throws = FALSE;
	attributes = (_tmp19_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp18_), attributes_length1 = _tmp18_, _attributes_size_ = attributes_length1, _tmp19_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp21_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp20_;
					char** nv;
					nv = (_tmp21_ = _tmp20_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp20_), _nv_size_ = nv_length1, _tmp21_);
					if (_vala_strcmp0 (nv[0], "name") == 0) {
						char* _tmp22_;
						vala_method_set_cname (m, vala_symbol_get_name ((ValaSymbol*) m));
						vala_symbol_set_name ((ValaSymbol*) m, _tmp22_ = vala_gidl_parser_eval (self, nv[1]));
						_g_free0 (_tmp22_);
					} else {
						if (_vala_strcmp0 (nv[0], "hidden") == 0) {
							char* _tmp23_;
							gboolean _tmp24_;
							if ((_tmp24_ = _vala_strcmp0 (_tmp23_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp23_), _tmp24_)) {
								result = NULL;
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
								attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (return_type);
								return result;
							}
						} else {
							if (_vala_strcmp0 (nv[0], "ellipsis") == 0) {
								char* _tmp25_;
								gboolean _tmp26_;
								if ((_tmp26_ = _vala_strcmp0 (_tmp25_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp25_), _tmp26_)) {
									add_ellipsis = TRUE;
								}
							} else {
								if (_vala_strcmp0 (nv[0], "printf_format") == 0) {
									char* _tmp27_;
									gboolean _tmp28_;
									if ((_tmp28_ = _vala_strcmp0 (_tmp27_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp27_), _tmp28_)) {
										vala_method_set_printf_format (m, TRUE);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "transfer_ownership") == 0) {
										char* _tmp29_;
										gboolean _tmp30_;
										if ((_tmp30_ = _vala_strcmp0 (_tmp29_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp29_), _tmp30_)) {
											vala_data_type_set_value_owned (return_type, TRUE);
										}
									} else {
										if (_vala_strcmp0 (nv[0], "nullable") == 0) {
											char* _tmp31_;
											gboolean _tmp32_;
											if ((_tmp32_ = _vala_strcmp0 (_tmp31_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp31_), _tmp32_)) {
												vala_data_type_set_nullable (return_type, TRUE);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "sentinel") == 0) {
												char* _tmp33_;
												vala_method_set_sentinel (m, _tmp33_ = vala_gidl_parser_eval (self, nv[1]));
												_g_free0 (_tmp33_);
											} else {
												if (_vala_strcmp0 (nv[0], "is_array") == 0) {
													char* _tmp34_;
													gboolean _tmp35_;
													if ((_tmp35_ = _vala_strcmp0 (_tmp34_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp34_), _tmp35_)) {
														ValaDataType* _tmp36_;
														return_type = (_tmp36_ = (ValaDataType*) vala_array_type_new (return_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) return_type)), _vala_code_node_unref0 (return_type), _tmp36_);
														vala_method_set_return_type (m, return_type);
													}
												} else {
													if (_vala_strcmp0 (nv[0], "throws") == 0) {
														char* _tmp37_;
														gboolean _tmp38_;
														if ((_tmp38_ = _vala_strcmp0 (_tmp37_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp37_), _tmp38_)) {
															suppress_throws = TRUE;
														}
													} else {
														if (_vala_strcmp0 (nv[0], "no_array_length") == 0) {
															char* _tmp39_;
															gboolean _tmp40_;
															if ((_tmp40_ = _vala_strcmp0 (_tmp39_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp39_), _tmp40_)) {
																vala_method_set_no_array_length (m, TRUE);
															}
														} else {
															if (_vala_strcmp0 (nv[0], "array_null_terminated") == 0) {
																char* _tmp41_;
																gboolean _tmp42_;
																if ((_tmp42_ = _vala_strcmp0 (_tmp41_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp41_), _tmp42_)) {
																	vala_method_set_no_array_length (m, TRUE);
																	vala_method_set_array_null_terminated (m, TRUE);
																}
															} else {
																if (_vala_strcmp0 (nv[0], "type_name") == 0) {
																	char* _tmp43_;
																	ValaUnresolvedSymbol* _tmp44_;
																	ValaUnresolvedSymbol* sym;
																	sym = (_tmp44_ = vala_unresolved_symbol_new (NULL, _tmp43_ = vala_gidl_parser_eval (self, nv[1]), NULL), _g_free0 (_tmp43_), _tmp44_);
																	if (VALA_IS_UNRESOLVED_TYPE (return_type)) {
																		vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (return_type), sym);
																	} else {
																		ValaDataType* _tmp45_;
																		vala_method_set_return_type (m, return_type = (_tmp45_ = (ValaDataType*) vala_unresolved_type_new_from_symbol (sym, vala_code_node_get_source_reference ((ValaCodeNode*) return_type)), _vala_code_node_unref0 (return_type), _tmp45_));
																	}
																	_vala_code_node_unref0 (sym);
																} else {
																	if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
																		char** _tmp49_;
																		gint _type_args_size_;
																		gint type_args_length1;
																		char** _tmp47_;
																		char* _tmp46_;
																		char** _tmp48_;
																		char** type_args;
																		type_args = (_tmp49_ = (_tmp48_ = _tmp47_ = g_strsplit (_tmp46_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp46_), _tmp48_), type_args_length1 = _vala_array_length (_tmp47_), _type_args_size_ = type_args_length1, _tmp49_);
																		{
																			char** type_arg_collection;
																			int type_arg_collection_length1;
																			int type_arg_it;
																			type_arg_collection = type_args;
																			type_arg_collection_length1 = type_args_length1;
																			for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																				char* type_arg;
																				type_arg = g_strdup (type_arg_collection[type_arg_it]);
																				{
																					ValaDataType* _tmp50_;
																					vala_data_type_add_type_argument (return_type, _tmp50_ = vala_gidl_parser_get_type_from_string (self, type_arg));
																					_vala_code_node_unref0 (_tmp50_);
																					_g_free0 (type_arg);
																				}
																			}
																		}
																		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
																	} else {
																		if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
																			char* _tmp51_;
																			gboolean _tmp52_;
																			if ((_tmp52_ = _vala_strcmp0 (_tmp51_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp51_), _tmp52_)) {
																				vala_symbol_set_deprecated ((ValaSymbol*) m, TRUE);
																			}
																		} else {
																			if (_vala_strcmp0 (nv[0], "replacement") == 0) {
																				char* _tmp53_;
																				vala_symbol_set_replacement ((ValaSymbol*) m, _tmp53_ = vala_gidl_parser_eval (self, nv[1]));
																				_g_free0 (_tmp53_);
																			} else {
																				if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
																					char* _tmp54_;
																					vala_symbol_set_deprecated_since ((ValaSymbol*) m, _tmp54_ = vala_gidl_parser_eval (self, nv[1]));
																					_g_free0 (_tmp54_);
																				} else {
																					if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
																						char* _tmp55_;
																						vala_member_add_cheader_filename ((ValaMember*) m, _tmp55_ = vala_gidl_parser_eval (self, nv[1]));
																						_g_free0 (_tmp55_);
																					} else {
																						if (_vala_strcmp0 (nv[0], "abstract") == 0) {
																							char* _tmp56_;
																							gboolean _tmp57_;
																							if ((_tmp57_ = _vala_strcmp0 (_tmp56_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp56_), _tmp57_)) {
																								vala_method_set_is_abstract (m, TRUE);
																							}
																						} else {
																							if (_vala_strcmp0 (nv[0], "virtual") == 0) {
																								char* _tmp58_;
																								gboolean _tmp59_;
																								if ((_tmp59_ = _vala_strcmp0 (_tmp58_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp58_), _tmp59_)) {
																									vala_method_set_is_virtual (m, TRUE);
																								}
																							} else {
																								if (_vala_strcmp0 (nv[0], "vfunc_name") == 0) {
																									char* _tmp60_;
																									vala_method_set_vfunc_name (m, _tmp60_ = vala_gidl_parser_eval (self, nv[1]));
																									_g_free0 (_tmp60_);
																								} else {
																									if (_vala_strcmp0 (nv[0], "finish_name") == 0) {
																										char* _tmp61_;
																										vala_method_set_finish_cname (m, _tmp61_ = vala_gidl_parser_eval (self, nv[1]));
																										_g_free0 (_tmp61_);
																									} else {
																										if (_vala_strcmp0 (nv[0], "async") == 0) {
																											char* _tmp62_;
																											gboolean _tmp63_;
																											if ((_tmp63_ = _vala_strcmp0 (_tmp62_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp62_), _tmp63_)) {
																												vala_method_set_coroutine (m, TRUE);
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_method_set_cname (m, symbol);
	first = TRUE;
	last_param = NULL;
	last_param_type = NULL;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				gboolean _tmp76_ = FALSE;
				gboolean _tmp78_ = FALSE;
				char* param_name;
				ValaParameterDirection direction = 0;
				ValaDataType* param_type;
				ValaFormalParameter* p;
				gboolean hide_param;
				gboolean show_param;
				gboolean set_array_length_pos;
				double array_length_pos;
				gboolean set_delegate_target_pos;
				double delegate_target_pos;
				gboolean array_requested;
				gboolean out_requested;
				char** _tmp84_;
				gint _tmp83_;
				char* _tmp82_;
				gboolean _tmp138_ = FALSE;
				gboolean _tmp142_ = FALSE;
				ValaFormalParameter* _tmp143_;
				ValaDataType* _tmp144_;
				param_node = (GIdlNode*) param;
				if (first) {
					gboolean _tmp64_ = FALSE;
					gboolean _tmp65_ = FALSE;
					gboolean _tmp66_ = FALSE;
					first = FALSE;
					if (!VALA_IS_CREATION_METHOD (m)) {
						_tmp66_ = self->priv->current_data_type != NULL;
					} else {
						_tmp66_ = FALSE;
					}
					if (_tmp66_) {
						_tmp65_ = param->type->is_interface;
					} else {
						_tmp65_ = FALSE;
					}
					if (_tmp65_) {
						gboolean _tmp67_ = FALSE;
						if (_vala_strcmp0 (param_node->name, "self") == 0) {
							_tmp67_ = TRUE;
						} else {
							char* _tmp68_;
							_tmp67_ = g_str_has_suffix (param->type->interface, _tmp68_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE));
							_g_free0 (_tmp68_);
						}
						_tmp64_ = _tmp67_;
					} else {
						_tmp64_ = FALSE;
					}
					if (_tmp64_) {
						continue;
					} else {
						gboolean _tmp69_ = FALSE;
						gboolean _tmp70_ = FALSE;
						gboolean _tmp71_ = FALSE;
						if (!VALA_IS_CREATION_METHOD (m)) {
							_tmp71_ = self->priv->current_data_type != NULL;
						} else {
							_tmp71_ = FALSE;
						}
						if (_tmp71_) {
							_tmp70_ = param->type->is_interface;
						} else {
							_tmp70_ = FALSE;
						}
						if (_tmp70_) {
							gboolean _tmp72_ = FALSE;
							if (_vala_strcmp0 (param_node->name, "klass") == 0) {
								_tmp72_ = TRUE;
							} else {
								char* _tmp74_;
								char* _tmp73_;
								_tmp72_ = g_str_has_suffix (param->type->interface, _tmp74_ = g_strdup_printf ("%sClass", _tmp73_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE)));
								_g_free0 (_tmp74_);
								_g_free0 (_tmp73_);
							}
							_tmp69_ = _tmp72_;
						} else {
							_tmp69_ = FALSE;
						}
						if (_tmp69_) {
							vala_method_set_binding (m, MEMBER_BINDING_CLASS);
							if (g_str_has_prefix (vala_symbol_get_name ((ValaSymbol*) m), "class_")) {
								char* _tmp75_;
								vala_symbol_set_name ((ValaSymbol*) m, _tmp75_ = string_substring (vala_symbol_get_name ((ValaSymbol*) m), g_utf8_strlen ("class_", -1), g_utf8_strlen (vala_symbol_get_name ((ValaSymbol*) m), -1) - g_utf8_strlen ("class_", -1)));
								_g_free0 (_tmp75_);
							}
							continue;
						} else {
							vala_method_set_binding (m, MEMBER_BINDING_STATIC);
						}
					}
				}
				if (_vala_strcmp0 (param->type->interface, "GAsyncReadyCallback") == 0) {
					gboolean _tmp77_ = FALSE;
					if (g_str_has_suffix (symbol, "_async")) {
						_tmp77_ = TRUE;
					} else {
						_tmp77_ = vala_method_get_coroutine (m);
					}
					_tmp76_ = _tmp77_;
				} else {
					_tmp76_ = FALSE;
				}
				if (_tmp76_) {
					vala_method_set_coroutine (m, TRUE);
					continue;
				}
				if (suppress_throws == FALSE) {
					_tmp78_ = vala_gidl_parser_param_is_exception (self, param);
				} else {
					_tmp78_ = FALSE;
				}
				if (_tmp78_) {
					ValaDataType* _tmp79_;
					vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp79_ = vala_gidl_parser_parse_type (self, param->type, NULL));
					_vala_code_node_unref0 (_tmp79_);
					continue;
				}
				param_name = g_strdup (param_node->name);
				if (_vala_strcmp0 (param_name, "result") == 0) {
					char* _tmp80_;
					param_name = (_tmp80_ = g_strdup ("_result"), _g_free0 (param_name), _tmp80_);
				} else {
					if (_vala_strcmp0 (param_name, "string") == 0) {
						char* _tmp81_;
						param_name = (_tmp81_ = g_strdup ("str"), _g_free0 (param_name), _tmp81_);
					}
				}
				param_type = vala_gidl_parser_parse_param (self, param, &direction);
				p = vala_formal_parameter_new (param_name, param_type, NULL);
				vala_formal_parameter_set_direction (p, direction);
				hide_param = FALSE;
				show_param = FALSE;
				set_array_length_pos = FALSE;
				array_length_pos = (double) 0;
				set_delegate_target_pos = FALSE;
				delegate_target_pos = (double) 0;
				array_requested = FALSE;
				out_requested = FALSE;
				attributes = (_tmp84_ = vala_gidl_parser_get_attributes (self, _tmp82_ = g_strdup_printf ("%s.%s", symbol, param_node->name), &_tmp83_), attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL), attributes_length1 = _tmp83_, _attributes_size_ = attributes_length1, _tmp84_);
				_g_free0 (_tmp82_);
				if (attributes != NULL) {
					{
						char** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							char* attr;
							attr = g_strdup (attr_collection[attr_it]);
							{
								char** _tmp86_;
								gint _nv_size_;
								gint nv_length1;
								char** _tmp85_;
								char** nv;
								nv = (_tmp86_ = _tmp85_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp85_), _nv_size_ = nv_length1, _tmp86_);
								if (_vala_strcmp0 (nv[0], "is_array") == 0) {
									char* _tmp87_;
									gboolean _tmp88_;
									if ((_tmp88_ = _vala_strcmp0 (_tmp87_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp87_), _tmp88_)) {
										ValaDataType* _tmp89_;
										param_type = (_tmp89_ = (ValaDataType*) vala_array_type_new (param_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) param_type)), _vala_code_node_unref0 (param_type), _tmp89_);
										vala_formal_parameter_set_parameter_type (p, param_type);
										if (!out_requested) {
											vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
										}
										array_requested = TRUE;
									}
								} else {
									if (_vala_strcmp0 (nv[0], "is_out") == 0) {
										char* _tmp90_;
										gboolean _tmp91_;
										if ((_tmp91_ = _vala_strcmp0 (_tmp90_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp90_), _tmp91_)) {
											gboolean _tmp92_ = FALSE;
											vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
											out_requested = TRUE;
											if (!array_requested) {
												_tmp92_ = VALA_IS_ARRAY_TYPE (param_type);
											} else {
												_tmp92_ = FALSE;
											}
											if (_tmp92_) {
												ValaArrayType* array_type;
												ValaDataType* _tmp93_;
												array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
												param_type = (_tmp93_ = _vala_code_node_ref0 (vala_array_type_get_element_type (array_type)), _vala_code_node_unref0 (param_type), _tmp93_);
												vala_formal_parameter_set_parameter_type (p, param_type);
												_vala_code_node_unref0 (array_type);
											}
										}
									} else {
										if (_vala_strcmp0 (nv[0], "is_ref") == 0) {
											char* _tmp94_;
											gboolean _tmp95_;
											if ((_tmp95_ = _vala_strcmp0 (_tmp94_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp94_), _tmp95_)) {
												gboolean _tmp96_ = FALSE;
												vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
												if (!array_requested) {
													_tmp96_ = VALA_IS_ARRAY_TYPE (param_type);
												} else {
													_tmp96_ = FALSE;
												}
												if (_tmp96_) {
													ValaArrayType* array_type;
													ValaDataType* _tmp97_;
													array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
													param_type = (_tmp97_ = _vala_code_node_ref0 (vala_array_type_get_element_type (array_type)), _vala_code_node_unref0 (param_type), _tmp97_);
													vala_formal_parameter_set_parameter_type (p, param_type);
													_vala_code_node_unref0 (array_type);
												}
											}
										} else {
											if (_vala_strcmp0 (nv[0], "nullable") == 0) {
												char* _tmp98_;
												gboolean _tmp99_;
												if ((_tmp99_ = _vala_strcmp0 (_tmp98_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp98_), _tmp99_)) {
													vala_data_type_set_nullable (param_type, TRUE);
												}
											} else {
												if (_vala_strcmp0 (nv[0], "transfer_ownership") == 0) {
													char* _tmp100_;
													gboolean _tmp101_;
													if ((_tmp101_ = _vala_strcmp0 (_tmp100_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp100_), _tmp101_)) {
														vala_data_type_set_value_owned (param_type, TRUE);
													}
												} else {
													if (_vala_strcmp0 (nv[0], "takes_ownership") == 0) {
														char* _tmp102_;
														gboolean _tmp103_;
														if ((_tmp103_ = _vala_strcmp0 (_tmp102_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp102_), _tmp103_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (_vala_strcmp0 (nv[0], "value_owned") == 0) {
															char* _tmp104_;
															gboolean _tmp105_;
															if ((_tmp105_ = _vala_strcmp0 (_tmp104_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp104_), _tmp105_)) {
																vala_data_type_set_value_owned (param_type, FALSE);
															} else {
																char* _tmp106_;
																gboolean _tmp107_;
																if ((_tmp107_ = _vala_strcmp0 (_tmp106_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp106_), _tmp107_)) {
																	vala_data_type_set_value_owned (param_type, TRUE);
																}
															}
														} else {
															if (_vala_strcmp0 (nv[0], "hidden") == 0) {
																char* _tmp108_;
																gboolean _tmp109_;
																if ((_tmp109_ = _vala_strcmp0 (_tmp108_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp108_), _tmp109_)) {
																	hide_param = TRUE;
																} else {
																	char* _tmp110_;
																	gboolean _tmp111_;
																	if ((_tmp111_ = _vala_strcmp0 (_tmp110_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp110_), _tmp111_)) {
																		show_param = TRUE;
																	}
																}
															} else {
																if (_vala_strcmp0 (nv[0], "no_array_length") == 0) {
																	char* _tmp112_;
																	gboolean _tmp113_;
																	if ((_tmp113_ = _vala_strcmp0 (_tmp112_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp112_), _tmp113_)) {
																		vala_formal_parameter_set_no_array_length (p, TRUE);
																	}
																} else {
																	if (_vala_strcmp0 (nv[0], "array_length_type") == 0) {
																		char* _tmp114_;
																		vala_formal_parameter_set_array_length_type (p, _tmp114_ = vala_gidl_parser_eval (self, nv[1]));
																		_g_free0 (_tmp114_);
																	} else {
																		if (_vala_strcmp0 (nv[0], "array_null_terminated") == 0) {
																			char* _tmp115_;
																			gboolean _tmp116_;
																			if ((_tmp116_ = _vala_strcmp0 (_tmp115_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp115_), _tmp116_)) {
																				vala_formal_parameter_set_no_array_length (p, TRUE);
																				vala_formal_parameter_set_array_null_terminated (p, TRUE);
																			}
																		} else {
																			if (_vala_strcmp0 (nv[0], "array_length_pos") == 0) {
																				char* _tmp117_;
																				set_array_length_pos = TRUE;
																				array_length_pos = g_ascii_strtod (_tmp117_ = vala_gidl_parser_eval (self, nv[1]), NULL);
																				_g_free0 (_tmp117_);
																			} else {
																				if (_vala_strcmp0 (nv[0], "delegate_target_pos") == 0) {
																					char* _tmp118_;
																					set_delegate_target_pos = TRUE;
																					delegate_target_pos = g_ascii_strtod (_tmp118_ = vala_gidl_parser_eval (self, nv[1]), NULL);
																					_g_free0 (_tmp118_);
																				} else {
																					if (_vala_strcmp0 (nv[0], "type_name") == 0) {
																						char* _tmp119_;
																						ValaUnresolvedSymbol* _tmp120_;
																						ValaUnresolvedSymbol* sym;
																						sym = (_tmp120_ = vala_unresolved_symbol_new (NULL, _tmp119_ = vala_gidl_parser_eval (self, nv[1]), NULL), _g_free0 (_tmp119_), _tmp120_);
																						if (VALA_IS_UNRESOLVED_TYPE (param_type)) {
																							vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type), sym);
																						} else {
																							ValaDataType* _tmp121_;
																							vala_formal_parameter_set_parameter_type (p, param_type = (_tmp121_ = (ValaDataType*) vala_unresolved_type_new_from_symbol (sym, vala_code_node_get_source_reference ((ValaCodeNode*) return_type)), _vala_code_node_unref0 (param_type), _tmp121_));
																						}
																						_vala_code_node_unref0 (sym);
																					} else {
																						if (_vala_strcmp0 (nv[0], "ctype") == 0) {
																							char* _tmp122_;
																							vala_formal_parameter_set_ctype (p, _tmp122_ = vala_gidl_parser_eval (self, nv[1]));
																							_g_free0 (_tmp122_);
																						} else {
																							if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
																								char** _tmp126_;
																								gint _type_args_size_;
																								gint type_args_length1;
																								char** _tmp124_;
																								char* _tmp123_;
																								char** _tmp125_;
																								char** type_args;
																								type_args = (_tmp126_ = (_tmp125_ = _tmp124_ = g_strsplit (_tmp123_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp123_), _tmp125_), type_args_length1 = _vala_array_length (_tmp124_), _type_args_size_ = type_args_length1, _tmp126_);
																								{
																									char** type_arg_collection;
																									int type_arg_collection_length1;
																									int type_arg_it;
																									type_arg_collection = type_args;
																									type_arg_collection_length1 = type_args_length1;
																									for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																										char* type_arg;
																										type_arg = g_strdup (type_arg_collection[type_arg_it]);
																										{
																											ValaDataType* _tmp127_;
																											vala_data_type_add_type_argument (param_type, _tmp127_ = vala_gidl_parser_get_type_from_string (self, type_arg));
																											_vala_code_node_unref0 (_tmp127_);
																											_g_free0 (type_arg);
																										}
																									}
																								}
																								type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
																							} else {
																								if (_vala_strcmp0 (nv[0], "default_value") == 0) {
																									char* val;
																									val = vala_gidl_parser_eval (self, nv[1]);
																									if (_vala_strcmp0 (val, "null") == 0) {
																										ValaNullLiteral* _tmp128_;
																										vala_formal_parameter_set_default_expression (p, (ValaExpression*) (_tmp128_ = vala_null_literal_new (vala_code_node_get_source_reference ((ValaCodeNode*) param_type))));
																										_vala_code_node_unref0 (_tmp128_);
																									} else {
																										if (_vala_strcmp0 (val, "true") == 0) {
																											ValaBooleanLiteral* _tmp129_;
																											vala_formal_parameter_set_default_expression (p, (ValaExpression*) (_tmp129_ = vala_boolean_literal_new (TRUE, vala_code_node_get_source_reference ((ValaCodeNode*) param_type))));
																											_vala_code_node_unref0 (_tmp129_);
																										} else {
																											if (_vala_strcmp0 (val, "false") == 0) {
																												ValaBooleanLiteral* _tmp130_;
																												vala_formal_parameter_set_default_expression (p, (ValaExpression*) (_tmp130_ = vala_boolean_literal_new (FALSE, vala_code_node_get_source_reference ((ValaCodeNode*) param_type))));
																												_vala_code_node_unref0 (_tmp130_);
																											} else {
																												if (_vala_strcmp0 (val, "") == 0) {
																													ValaStringLiteral* _tmp131_;
																													vala_formal_parameter_set_default_expression (p, (ValaExpression*) (_tmp131_ = vala_string_literal_new ("\"\"", vala_code_node_get_source_reference ((ValaCodeNode*) param_type))));
																													_vala_code_node_unref0 (_tmp131_);
																												} else {
																													const char* endptr;
																													const char* val_end;
																													endptr = NULL;
																													val_end = g_utf8_offset_to_pointer (val, g_utf8_strlen (val, -1));
																													strtol (val, &endptr, 0);
																													if (((glong) endptr) == ((glong) val_end)) {
																														ValaIntegerLiteral* _tmp132_;
																														vala_formal_parameter_set_default_expression (p, (ValaExpression*) (_tmp132_ = vala_integer_literal_new (val, vala_code_node_get_source_reference ((ValaCodeNode*) param_type))));
																														_vala_code_node_unref0 (_tmp132_);
																													} else {
																														g_ascii_strtod (val, &endptr);
																														if (((glong) endptr) == ((glong) val_end)) {
																															ValaRealLiteral* _tmp133_;
																															vala_formal_parameter_set_default_expression (p, (ValaExpression*) (_tmp133_ = vala_real_literal_new (val, vala_code_node_get_source_reference ((ValaCodeNode*) param_type))));
																															_vala_code_node_unref0 (_tmp133_);
																														} else {
																															gboolean _tmp134_ = FALSE;
																															if (g_str_has_prefix (val, "\"")) {
																																_tmp134_ = g_str_has_suffix (val, "\"");
																															} else {
																																_tmp134_ = FALSE;
																															}
																															if (_tmp134_) {
																																ValaStringLiteral* _tmp135_;
																																vala_formal_parameter_set_default_expression (p, (ValaExpression*) (_tmp135_ = vala_string_literal_new (val, vala_code_node_get_source_reference ((ValaCodeNode*) param_type))));
																																_vala_code_node_unref0 (_tmp135_);
																															} else {
																																{
																																	char** _tmp136_;
																																	char** member_collection;
																																	int member_collection_length1;
																																	int member_it;
																																	member_collection = _tmp136_ = g_strsplit (val, ".", 0);
																																	member_collection_length1 = _vala_array_length (_tmp136_);
																																	for (member_it = 0; member_it < _vala_array_length (_tmp136_); member_it = member_it + 1) {
																																		char* member;
																																		member = g_strdup (member_collection[member_it]);
																																		{
																																			ValaMemberAccess* _tmp137_;
																																			vala_formal_parameter_set_default_expression (p, (ValaExpression*) (_tmp137_ = vala_member_access_new (vala_formal_parameter_get_default_expression (p), member, vala_code_node_get_source_reference ((ValaCodeNode*) param_type))));
																																			_vala_code_node_unref0 (_tmp137_);
																																			_g_free0 (member);
																																		}
																																	}
																																	member_collection = (_vala_array_free (member_collection, member_collection_length1, (GDestroyNotify) g_free), NULL);
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																									_g_free0 (val);
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (last_param != NULL) {
					char* _tmp139_;
					_tmp138_ = _vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), _tmp139_ = g_strconcat ("n_", vala_symbol_get_name ((ValaSymbol*) last_param), NULL)) == 0;
					_g_free0 (_tmp139_);
				} else {
					_tmp138_ = FALSE;
				}
				if (_tmp138_) {
					if (!VALA_IS_ARRAY_TYPE (last_param_type)) {
						ValaDataType* _tmp140_;
						last_param_type = (_tmp140_ = (ValaDataType*) vala_array_type_new (last_param_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) last_param_type)), _vala_code_node_unref0 (last_param_type), _tmp140_);
						vala_formal_parameter_set_parameter_type (last_param, last_param_type);
						vala_formal_parameter_set_direction (last_param, VALA_PARAMETER_DIRECTION_IN);
					}
					hide_param = TRUE;
				} else {
					gboolean _tmp141_ = FALSE;
					if (last_param != NULL) {
						_tmp141_ = _vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), "user_data") == 0;
					} else {
						_tmp141_ = FALSE;
					}
					if (_tmp141_) {
						hide_param = TRUE;
					}
				}
				if (show_param) {
					_tmp142_ = TRUE;
				} else {
					_tmp142_ = !hide_param;
				}
				if (_tmp142_) {
					vala_method_add_parameter (m, p);
					if (set_array_length_pos) {
						vala_formal_parameter_set_carray_length_parameter_position (p, array_length_pos);
					}
					if (set_delegate_target_pos) {
						vala_formal_parameter_set_cdelegate_target_parameter_position (p, delegate_target_pos);
					}
				}
				last_param = (_tmp143_ = _vala_code_node_ref0 (p), _vala_code_node_unref0 (last_param), _tmp143_);
				last_param_type = (_tmp144_ = _vala_code_node_ref0 (param_type), _vala_code_node_unref0 (last_param_type), _tmp144_);
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
				_g_free0 (param_name);
			}
		}
	}
	if (first) {
		vala_method_set_binding (m, MEMBER_BINDING_STATIC);
	}
	if (last_param != NULL) {
		_tmp145_ = g_str_has_prefix (vala_symbol_get_name ((ValaSymbol*) last_param), "first_");
	} else {
		_tmp145_ = FALSE;
	}
	if (_tmp145_) {
		vala_formal_parameter_set_ellipsis (last_param, TRUE);
	} else {
		if (add_ellipsis) {
			ValaFormalParameter* _tmp146_;
			vala_method_add_parameter (m, _tmp146_ = vala_formal_parameter_new_with_ellipsis (NULL));
			_vala_code_node_unref0 (_tmp146_);
		}
	}
	result = m;
	_vala_code_node_unref0 (last_param_type);
	_vala_code_node_unref0 (last_param);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (return_type);
	return result;
}


static char* string_chomp (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param) {
	gboolean result = FALSE;
	char* s;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param != NULL, FALSE);
	if (!param->type->is_error) {
		result = FALSE;
		return result;
	}
	s = string_chomp (param->type->unparsed);
	if (g_str_has_suffix (s, "**")) {
		result = TRUE;
		_g_free0 (s);
		return result;
	}
	result = FALSE;
	_g_free0 (s);
	return result;
}


static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNode* node;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	node = (GIdlNode*) f;
	if (f->deprecated) {
		result = NULL;
		return result;
	}
	result = vala_gidl_parser_create_method (self, node->name, f->symbol, f->result, f->parameters, f->is_constructor, is_interface);
	return result;
}


static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNode* node;
	char* _tmp0_;
	char* _tmp1_;
	char* symbol;
	GList* _tmp3_;
	ValaMethod* m;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	node = (GIdlNode*) v;
	symbol = (_tmp1_ = g_strdup_printf ("%s%s", _tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self->priv->current_data_type), node->name), _g_free0 (_tmp0_), _tmp1_);
	if (func != NULL) {
		char* _tmp2_;
		symbol = (_tmp2_ = g_strdup (func->symbol), _g_free0 (symbol), _tmp2_);
	}
	_tmp3_ = NULL;
	if (func != NULL) {
		_tmp3_ = func->parameters;
	} else {
		_tmp3_ = v->parameters;
	}
	m = vala_gidl_parser_create_method (self, node->name, symbol, v->result, _tmp3_, FALSE, is_interface);
	if (m != NULL) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		char** _tmp7_;
		gint _attributes_size_;
		gint attributes_length1;
		gint _tmp6_;
		char** attributes;
		vala_method_set_binding (m, MEMBER_BINDING_INSTANCE);
		if (vala_method_get_is_abstract (m)) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = is_interface;
		}
		vala_method_set_is_virtual (m, !_tmp4_);
		if (vala_method_get_is_abstract (m)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = is_interface;
		}
		vala_method_set_is_abstract (m, _tmp5_);
		attributes = (_tmp7_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp6_), attributes_length1 = _tmp6_, _attributes_size_ = attributes_length1, _tmp7_);
		if (attributes != NULL) {
			{
				char** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					char* attr;
					attr = g_strdup (attr_collection[attr_it]);
					{
						char** _tmp9_;
						gint _nv_size_;
						gint nv_length1;
						char** _tmp8_;
						char** nv;
						nv = (_tmp9_ = _tmp8_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp8_), _nv_size_ = nv_length1, _tmp9_);
						if (_vala_strcmp0 (nv[0], "virtual") == 0) {
							char* _tmp10_;
							gboolean _tmp11_;
							if ((_tmp11_ = _vala_strcmp0 (_tmp10_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp10_), _tmp11_)) {
								vala_method_set_is_virtual (m, FALSE);
								vala_method_set_is_abstract (m, FALSE);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		if (func == NULL) {
			((ValaCodeNode*) m)->attributes = g_list_append (((ValaCodeNode*) m)->attributes, vala_attribute_new ("NoWrapper", NULL));
		}
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	result = m;
	_g_free0 (symbol);
	return result;
}


static char* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const char* name) {
	char* result = NULL;
	GString* str;
	char* i;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	str = g_string_new ("");
	i = g_strdup (name);
	while (TRUE) {
		gunichar c;
		char* _tmp0_;
		if (!(g_utf8_strlen (i, -1) > 0)) {
			break;
		}
		c = g_utf8_get_char (i);
		if (c == '-') {
			g_string_append_c (str, '_');
		} else {
			g_string_append_unichar (str, c);
		}
		i = (_tmp0_ = g_strdup (g_utf8_next_char (i)), _g_free0 (i), _tmp0_);
	}
	result = g_strdup (str->str);
	_g_free0 (i);
	_g_string_free0 (str);
	return result;
}


static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node) {
	ValaProperty* result = NULL;
	GIdlNode* node;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp2_;
	char* _tmp1_;
	ValaProperty* _tmp3_;
	ValaProperty* prop;
	gboolean _tmp4_ = FALSE;
	char** _tmp13_;
	gint _attributes_size_;
	gint attributes_length1;
	gint _tmp11_;
	char* _tmp10_;
	char* _tmp9_;
	char** _tmp12_;
	char** attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	node = (GIdlNode*) prop_node;
	if (prop_node->deprecated) {
		result = NULL;
		return result;
	}
	if (!prop_node->readable) {
		_tmp0_ = !prop_node->writable;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		prop_node->readable = TRUE;
		prop_node->writable = TRUE;
	}
	prop = (_tmp3_ = vala_property_new (_tmp1_ = vala_gidl_parser_fix_prop_name (self, node->name), _tmp2_ = vala_gidl_parser_parse_type (self, prop_node->type, NULL), NULL, NULL, self->priv->current_source_reference, NULL), _vala_code_node_unref0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	vala_symbol_set_access ((ValaSymbol*) prop, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_property_set_interface_only (prop, TRUE);
	if (prop_node->type->is_interface) {
		_tmp4_ = _vala_strcmp0 (prop_node->type->interface, "GStrv") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		vala_property_set_no_array_length (prop, TRUE);
		vala_property_set_array_null_terminated (prop, TRUE);
	}
	if (prop_node->readable) {
		ValaPropertyAccessor* _tmp6_;
		ValaDataType* _tmp5_;
		vala_property_set_get_accessor (prop, _tmp6_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp5_ = vala_data_type_copy (vala_property_get_property_type (prop)), NULL, NULL));
		_vala_code_node_unref0 (_tmp6_);
		_vala_code_node_unref0 (_tmp5_);
	}
	if (prop_node->writable) {
		ValaPropertyAccessor* _tmp8_;
		ValaDataType* _tmp7_;
		vala_property_set_set_accessor (prop, _tmp8_ = vala_property_accessor_new (FALSE, FALSE, FALSE, _tmp7_ = vala_data_type_copy (vala_property_get_property_type (prop)), NULL, NULL));
		_vala_code_node_unref0 (_tmp8_);
		_vala_code_node_unref0 (_tmp7_);
		if (prop_node->construct_only) {
			vala_property_accessor_set_construction (vala_property_get_set_accessor (prop), TRUE);
		} else {
			vala_property_accessor_set_writable (vala_property_get_set_accessor (prop), TRUE);
			vala_property_accessor_set_construction (vala_property_get_set_accessor (prop), prop_node->construct);
		}
	}
	attributes = (_tmp13_ = (_tmp12_ = vala_gidl_parser_get_attributes (self, _tmp10_ = g_strdup_printf ("%s:%s", _tmp9_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE), node->name), &_tmp11_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _tmp12_), attributes_length1 = _tmp11_, _attributes_size_ = attributes_length1, _tmp13_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp15_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp14_;
					char** nv;
					nv = (_tmp15_ = _tmp14_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp14_), _nv_size_ = nv_length1, _tmp15_);
					if (_vala_strcmp0 (nv[0], "hidden") == 0) {
						char* _tmp16_;
						gboolean _tmp17_;
						if ((_tmp17_ = _vala_strcmp0 (_tmp16_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp16_), _tmp17_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (prop);
							return result;
						}
					} else {
						if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
							char** _tmp21_;
							gint _type_args_size_;
							gint type_args_length1;
							char** _tmp19_;
							char* _tmp18_;
							char** _tmp20_;
							char** type_args;
							type_args = (_tmp21_ = (_tmp20_ = _tmp19_ = g_strsplit (_tmp18_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp18_), _tmp20_), type_args_length1 = _vala_array_length (_tmp19_), _type_args_size_ = type_args_length1, _tmp21_);
							{
								char** type_arg_collection;
								int type_arg_collection_length1;
								int type_arg_it;
								type_arg_collection = type_args;
								type_arg_collection_length1 = type_args_length1;
								for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
									char* type_arg;
									type_arg = g_strdup (type_arg_collection[type_arg_it]);
									{
										ValaDataType* _tmp22_;
										vala_data_type_add_type_argument (vala_property_get_property_type (prop), _tmp22_ = vala_gidl_parser_get_type_from_string (self, type_arg));
										_vala_code_node_unref0 (_tmp22_);
										_g_free0 (type_arg);
									}
								}
							}
							type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
						} else {
							if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
								char* _tmp23_;
								gboolean _tmp24_;
								if ((_tmp24_ = _vala_strcmp0 (_tmp23_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp23_), _tmp24_)) {
									vala_symbol_set_deprecated ((ValaSymbol*) prop, TRUE);
								}
							} else {
								if (_vala_strcmp0 (nv[0], "replacement") == 0) {
									char* _tmp25_;
									vala_symbol_set_replacement ((ValaSymbol*) prop, _tmp25_ = vala_gidl_parser_eval (self, nv[1]));
									_g_free0 (_tmp25_);
								} else {
									if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
										char* _tmp26_;
										vala_symbol_set_deprecated_since ((ValaSymbol*) prop, _tmp26_ = vala_gidl_parser_eval (self, nv[1]));
										_g_free0 (_tmp26_);
									} else {
										if (_vala_strcmp0 (nv[0], "accessor_method") == 0) {
											char* _tmp27_;
											gboolean _tmp28_;
											if ((_tmp28_ = _vala_strcmp0 (_tmp27_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp27_), _tmp28_)) {
												vala_property_set_no_accessor_method (prop, TRUE);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "owned_get") == 0) {
												char* _tmp29_;
												gboolean _tmp30_;
												if ((_tmp30_ = _vala_strcmp0 (_tmp29_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp29_), _tmp30_)) {
													vala_data_type_set_value_owned (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)), TRUE);
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	if (self->priv->current_type_symbol_set != NULL) {
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, vala_symbol_get_name ((ValaSymbol*) prop));
	}
	result = prop;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node) {
	ValaConstant* result = NULL;
	GIdlNode* node;
	ValaDataType* type;
	ValaConstant* c;
	char** _tmp1_;
	gint _attributes_size_;
	gint attributes_length1;
	gint _tmp0_;
	char** attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_node != NULL, NULL);
	node = (GIdlNode*) const_node;
	type = vala_gidl_parser_parse_type (self, const_node->type, NULL);
	if (type == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	c = vala_constant_new (node->name, type, NULL, self->priv->current_source_reference, NULL);
	vala_symbol_set_external ((ValaSymbol*) c, TRUE);
	attributes = (_tmp1_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp0_), attributes_length1 = _tmp0_, _attributes_size_ = attributes_length1, _tmp1_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp3_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp2_;
					char** nv;
					nv = (_tmp3_ = _tmp2_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp2_), _nv_size_ = nv_length1, _tmp3_);
					if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
						char* _tmp4_;
						vala_member_add_cheader_filename ((ValaMember*) c, _tmp4_ = vala_gidl_parser_eval (self, nv[1]));
						_g_free0 (_tmp4_);
					} else {
						if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
							char* _tmp5_;
							gboolean _tmp6_;
							if ((_tmp6_ = _vala_strcmp0 (_tmp5_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp5_), _tmp6_)) {
								vala_symbol_set_deprecated ((ValaSymbol*) c, TRUE);
							}
						} else {
							if (_vala_strcmp0 (nv[0], "replacement") == 0) {
								char* _tmp7_;
								vala_symbol_set_replacement ((ValaSymbol*) c, _tmp7_ = vala_gidl_parser_eval (self, nv[1]));
								_g_free0 (_tmp7_);
							} else {
								if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
									char* _tmp8_;
									vala_symbol_set_deprecated_since ((ValaSymbol*) c, _tmp8_ = vala_gidl_parser_eval (self, nv[1]));
									_g_free0 (_tmp8_);
								} else {
									if (_vala_strcmp0 (nv[0], "hidden") == 0) {
										char* _tmp9_;
										gboolean _tmp10_;
										if ((_tmp10_ = _vala_strcmp0 (_tmp9_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp9_), _tmp10_)) {
											result = NULL;
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
											_vala_code_node_unref0 (c);
											_vala_code_node_unref0 (type);
											return result;
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_symbol_set_access ((ValaSymbol*) c, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	result = c;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (type);
	return result;
}


static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node) {
	ValaField* result = NULL;
	GIdlNode* node;
	gboolean unhidden;
	ValaDataType* type;
	char* cheader_filename;
	char* ctype;
	char* array_length_cname;
	char* array_length_type;
	gboolean array_null_terminated;
	gboolean deprecated;
	char* deprecated_since;
	char* replacement;
	char** _tmp4_;
	gint _attributes_size_;
	gint attributes_length1;
	gint _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char** _tmp3_;
	char** attributes;
	gboolean _tmp35_ = FALSE;
	char* field_name;
	ValaField* field;
	gboolean _tmp37_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_node != NULL, NULL);
	node = (GIdlNode*) field_node;
	unhidden = FALSE;
	type = vala_gidl_parser_parse_type (self, field_node->type, NULL);
	if (type == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	cheader_filename = NULL;
	ctype = NULL;
	array_length_cname = NULL;
	array_length_type = NULL;
	array_null_terminated = FALSE;
	deprecated = FALSE;
	deprecated_since = NULL;
	replacement = NULL;
	attributes = (_tmp4_ = (_tmp3_ = vala_gidl_parser_get_attributes (self, _tmp1_ = g_strdup_printf ("%s.%s", _tmp0_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE), node->name), &_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_), attributes_length1 = _tmp2_, _attributes_size_ = attributes_length1, _tmp4_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp6_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp5_;
					char** nv;
					nv = (_tmp6_ = _tmp5_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp5_), _nv_size_ = nv_length1, _tmp6_);
					if (_vala_strcmp0 (nv[0], "hidden") == 0) {
						char* _tmp7_;
						gboolean _tmp8_;
						if ((_tmp8_ = _vala_strcmp0 (_tmp7_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp7_), _tmp8_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (replacement);
							_g_free0 (deprecated_since);
							_g_free0 (array_length_type);
							_g_free0 (array_length_cname);
							_g_free0 (ctype);
							_g_free0 (cheader_filename);
							_vala_code_node_unref0 (type);
							return result;
						} else {
							unhidden = TRUE;
						}
					} else {
						if (_vala_strcmp0 (nv[0], "is_array") == 0) {
							char* _tmp9_;
							gboolean _tmp10_;
							if ((_tmp10_ = _vala_strcmp0 (_tmp9_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp9_), _tmp10_)) {
								ValaDataType* _tmp11_;
								type = (_tmp11_ = (ValaDataType*) vala_array_type_new (type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) type)), _vala_code_node_unref0 (type), _tmp11_);
							}
						} else {
							if (_vala_strcmp0 (nv[0], "weak") == 0) {
								char* _tmp12_;
								gboolean _tmp13_;
								if ((_tmp13_ = _vala_strcmp0 (_tmp12_ = vala_gidl_parser_eval (self, nv[1]), "0") == 0, _g_free0 (_tmp12_), _tmp13_)) {
									vala_data_type_set_value_owned (type, TRUE);
								}
							} else {
								if (_vala_strcmp0 (nv[0], "type_name") == 0) {
									char* _tmp14_;
									gboolean _tmp15_;
									if ((_tmp15_ = _vala_strcmp0 (_tmp14_ = vala_gidl_parser_eval (self, nv[1]), "pointer") == 0, _g_free0 (_tmp14_), _tmp15_)) {
										ValaDataType* _tmp17_;
										ValaVoidType* _tmp16_;
										type = (_tmp17_ = (ValaDataType*) vala_pointer_type_new ((ValaDataType*) (_tmp16_ = vala_void_type_new (NULL)), NULL), _vala_code_node_unref0 (type), _tmp17_);
										_vala_code_node_unref0 (_tmp16_);
									} else {
										char* _tmp18_;
										ValaUnresolvedSymbol* _tmp19_;
										ValaUnresolvedSymbol* unresolved_sym;
										unresolved_sym = (_tmp19_ = vala_unresolved_symbol_new (NULL, _tmp18_ = vala_gidl_parser_eval (self, nv[1]), NULL), _g_free0 (_tmp18_), _tmp19_);
										if (VALA_IS_ARRAY_TYPE (type)) {
											vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (vala_array_type_get_element_type (VALA_ARRAY_TYPE (type))), unresolved_sym);
										} else {
											vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (type), unresolved_sym);
										}
										_vala_code_node_unref0 (unresolved_sym);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
										char** _tmp23_;
										gint _type_args_size_;
										gint type_args_length1;
										char** _tmp21_;
										char* _tmp20_;
										char** _tmp22_;
										char** type_args;
										type_args = (_tmp23_ = (_tmp22_ = _tmp21_ = g_strsplit (_tmp20_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp20_), _tmp22_), type_args_length1 = _vala_array_length (_tmp21_), _type_args_size_ = type_args_length1, _tmp23_);
										{
											char** type_arg_collection;
											int type_arg_collection_length1;
											int type_arg_it;
											type_arg_collection = type_args;
											type_arg_collection_length1 = type_args_length1;
											for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
												char* type_arg;
												type_arg = g_strdup (type_arg_collection[type_arg_it]);
												{
													ValaDataType* _tmp24_;
													vala_data_type_add_type_argument (type, _tmp24_ = vala_gidl_parser_get_type_from_string (self, type_arg));
													_vala_code_node_unref0 (_tmp24_);
													_g_free0 (type_arg);
												}
											}
										}
										type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
									} else {
										if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
											char* _tmp25_;
											gboolean _tmp26_;
											if ((_tmp26_ = _vala_strcmp0 (_tmp25_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp25_), _tmp26_)) {
												deprecated = TRUE;
											}
										} else {
											if (_vala_strcmp0 (nv[0], "replacement") == 0) {
												char* _tmp27_;
												replacement = (_tmp27_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (replacement), _tmp27_);
											} else {
												if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
													char* _tmp28_;
													deprecated_since = (_tmp28_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (deprecated_since), _tmp28_);
												} else {
													if (_vala_strcmp0 (nv[0], "cheader_filename") == 0) {
														char* _tmp29_;
														cheader_filename = (_tmp29_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (cheader_filename), _tmp29_);
													} else {
														if (_vala_strcmp0 (nv[0], "ctype") == 0) {
															char* _tmp30_;
															ctype = (_tmp30_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (ctype), _tmp30_);
														} else {
															if (_vala_strcmp0 (nv[0], "array_null_terminated") == 0) {
																char* _tmp31_;
																gboolean _tmp32_;
																if ((_tmp32_ = _vala_strcmp0 (_tmp31_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp31_), _tmp32_)) {
																	array_null_terminated = TRUE;
																}
															} else {
																if (_vala_strcmp0 (nv[0], "array_length_cname") == 0) {
																	char* _tmp33_;
																	array_length_cname = (_tmp33_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (array_length_cname), _tmp33_);
																} else {
																	if (_vala_strcmp0 (nv[0], "array_length_type") == 0) {
																		char* _tmp34_;
																		array_length_type = (_tmp34_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (array_length_type), _tmp34_);
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	if (g_str_has_prefix (node->name, "_")) {
		_tmp35_ = !unhidden;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		result = NULL;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (replacement);
		_g_free0 (deprecated_since);
		_g_free0 (array_length_type);
		_g_free0 (array_length_cname);
		_g_free0 (ctype);
		_g_free0 (cheader_filename);
		_vala_code_node_unref0 (type);
		return result;
	}
	if (self->priv->current_type_symbol_set != NULL) {
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, node->name);
	}
	field_name = g_strdup (node->name);
	if (_vala_strcmp0 (field_name, "string") == 0) {
		char* _tmp36_;
		field_name = (_tmp36_ = g_strdup ("str"), _g_free0 (field_name), _tmp36_);
	}
	field = vala_field_new (field_name, type, NULL, self->priv->current_source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) field, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (_vala_strcmp0 (field_name, node->name) != 0) {
		vala_field_set_cname (field, node->name);
	}
	if (deprecated) {
		vala_symbol_set_deprecated ((ValaSymbol*) field, TRUE);
		if (deprecated_since != NULL) {
			vala_symbol_set_deprecated_since ((ValaSymbol*) field, deprecated_since);
		}
		if (replacement != NULL) {
			vala_symbol_set_replacement ((ValaSymbol*) field, replacement);
		}
	}
	if (ctype != NULL) {
		vala_field_set_ctype (field, ctype);
	}
	if (cheader_filename != NULL) {
		vala_member_add_cheader_filename ((ValaMember*) field, cheader_filename);
	}
	if (array_null_terminated) {
		vala_field_set_array_null_terminated (field, TRUE);
	}
	if (array_length_cname != NULL) {
		_tmp37_ = TRUE;
	} else {
		_tmp37_ = array_length_type != NULL;
	}
	if (_tmp37_) {
		if (array_length_cname != NULL) {
			vala_field_set_array_length_cname (field, array_length_cname);
		}
		if (array_length_type != NULL) {
			vala_field_set_array_length_type (field, array_length_type);
		}
	} else {
		vala_field_set_no_array_length (field, TRUE);
	}
	result = field;
	_g_free0 (field_name);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (replacement);
	_g_free0 (deprecated_since);
	_g_free0 (array_length_type);
	_g_free0 (array_length_cname);
	_g_free0 (ctype);
	_g_free0 (cheader_filename);
	_vala_code_node_unref0 (type);
	return result;
}


static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


static char** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const char* codenode, int* result_length1) {
	char** result = NULL;
	char* attributes;
	GSList* attr_list;
	GString* attr;
	glong attributes_len;
	const char* remaining;
	gboolean quoted;
	gboolean escaped;
	char** _tmp9_;
	gint _attrs_size_;
	gint attrs_length1;
	gint _tmp8_;
	char** attrs;
	GSList* attr_i;
	char** _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (codenode != NULL, NULL);
	attributes = (char*) vala_map_get (self->priv->codenode_attributes_map, codenode);
	if (attributes == NULL) {
		gboolean dot_required;
		gboolean colon_required;
		ValaSet* pattern_specs;
		dot_required = NULL != g_utf8_strchr (codenode, (gssize) (-1), (gunichar) '.');
		colon_required = NULL != g_utf8_strchr (codenode, (gssize) (-1), (gunichar) ':');
		pattern_specs = vala_map_get_keys (self->priv->codenode_attributes_patterns);
		{
			ValaIterator* _pattern_it;
			_pattern_it = vala_iterable_iterator ((ValaIterable*) pattern_specs);
			while (TRUE) {
				GPatternSpec* pattern;
				char* pspec;
				gboolean _tmp0_ = FALSE;
				gboolean _tmp1_ = FALSE;
				if (!vala_iterator_next (_pattern_it)) {
					break;
				}
				pattern = vala_iterator_get (_pattern_it);
				pspec = (char*) vala_map_get (self->priv->codenode_attributes_patterns, pattern);
				if (dot_required) {
					_tmp1_ = NULL == g_utf8_strchr (pspec, (gssize) (-1), (gunichar) '.');
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					_tmp0_ = TRUE;
				} else {
					gboolean _tmp2_ = FALSE;
					if (colon_required) {
						_tmp2_ = NULL == g_utf8_strchr (pspec, (gssize) (-1), (gunichar) ':');
					} else {
						_tmp2_ = FALSE;
					}
					_tmp0_ = _tmp2_;
				}
				if (_tmp0_) {
					_g_free0 (pspec);
					continue;
				}
				if (g_pattern_match_string (pattern, codenode)) {
					gint _tmp3_;
					char** _tmp4_;
					result = (_tmp4_ = vala_gidl_parser_get_attributes (self, pspec, &_tmp3_), *result_length1 = _tmp3_, _tmp4_);
					_g_free0 (pspec);
					_vala_collection_object_unref0 (_pattern_it);
					_vala_collection_object_unref0 (pattern_specs);
					_g_free0 (attributes);
					return result;
				}
				_g_free0 (pspec);
			}
			_vala_collection_object_unref0 (_pattern_it);
		}
		_vala_collection_object_unref0 (pattern_specs);
	}
	if (attributes == NULL) {
		gpointer _tmp5_;
		result = (_tmp5_ = NULL, *result_length1 = 0, _tmp5_);
		_g_free0 (attributes);
		return result;
	}
	attr_list = NULL;
	attr = g_string_sized_new (strlen (attributes));
	attributes_len = g_utf8_strlen (attributes, -1);
	remaining = attributes;
	quoted = FALSE;
	escaped = FALSE;
	{
		gint b;
		b = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gunichar c;
				if (!_tmp6_) {
					b++;
				}
				_tmp6_ = FALSE;
				if (!(b < attributes_len)) {
					break;
				}
				c = g_utf8_get_char (remaining);
				if (escaped) {
					escaped = FALSE;
					g_string_append_unichar (attr, c);
				} else {
					if (c == '"') {
						g_string_append_unichar (attr, c);
						quoted = !quoted;
					} else {
						if (c == '\\') {
							escaped = TRUE;
						} else {
							gboolean _tmp7_ = FALSE;
							if (!quoted) {
								_tmp7_ = c == ' ';
							} else {
								_tmp7_ = FALSE;
							}
							if (_tmp7_) {
								attr_list = g_slist_prepend (attr_list, g_strdup (attr->str));
								g_string_truncate (attr, (gsize) 0);
							} else {
								g_string_append_unichar (attr, c);
							}
						}
					}
				}
				remaining = g_utf8_offset_to_pointer (remaining, (glong) 1);
			}
		}
	}
	if (attr->len > 0) {
		attr_list = g_slist_prepend (attr_list, g_strdup (attr->str));
	}
	attrs = (_tmp9_ = g_new0 (char*, (_tmp8_ = g_slist_length (attr_list)) + 1), attrs_length1 = _tmp8_, _attrs_size_ = attrs_length1, _tmp9_);
	attr_i = attr_list;
	{
		gint a;
		a = 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				char* _tmp12_;
				char* *_tmp11_;
				if (!_tmp10_) {
					a++;
					attr_i = attr_i->next;
				}
				_tmp10_ = FALSE;
				if (!(a < attrs_length1)) {
					break;
				}
				_tmp11_ = &attrs[(attrs_length1 - 1) - a];
				(*_tmp11_) = (_tmp12_ = g_strdup ((const char*) attr_i->data), _g_free0 ((*_tmp11_)), _tmp12_);
			}
		}
	}
	result = (_tmp13_ = attrs, *result_length1 = attrs_length1, _tmp13_);
	_g_string_free0 (attr);
	__g_slist_free_g_free0 (attr_list);
	_g_free0 (attributes);
	return result;
	attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (attr);
	__g_slist_free_g_free0 (attr_list);
	_g_free0 (attributes);
}


static char* vala_gidl_parser_eval (ValaGIdlParser* self, const char* s) {
	char* result = NULL;
	char* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = NULL;
	if (strlen (s) >= 2) {
		_tmp2_ = g_str_has_prefix (s, "\"");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_str_has_suffix (s, "\"");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		char* _tmp3_;
		_tmp0_ = (_tmp3_ = g_strndup (g_utf8_offset_to_pointer (s, (glong) 1), strlen (s) - 2), _g_free0 (_tmp0_), _tmp3_);
	} else {
		char* _tmp4_;
		_tmp0_ = (_tmp4_ = g_strdup (s), _g_free0 (_tmp0_), _tmp4_);
	}
	result = _tmp0_;
	return result;
}


static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node) {
	ValaSignal* result = NULL;
	GIdlNode* node;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp2_;
	char* _tmp1_;
	ValaSignal* _tmp3_;
	ValaSignal* sig;
	char** _tmp8_;
	gint _attributes_size_;
	gint attributes_length1;
	gint _tmp6_;
	char* _tmp5_;
	char* _tmp4_;
	char** _tmp7_;
	char** attributes;
	gboolean first;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig_node != NULL, NULL);
	node = (GIdlNode*) sig_node;
	if (sig_node->deprecated) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sig_node->result == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	sig = (_tmp3_ = vala_signal_new (_tmp1_ = vala_gidl_parser_fix_prop_name (self, node->name), _tmp2_ = vala_gidl_parser_parse_param (self, sig_node->result, NULL), self->priv->current_source_reference, NULL), _vala_code_node_unref0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	vala_symbol_set_access ((ValaSymbol*) sig, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	attributes = (_tmp8_ = (_tmp7_ = vala_gidl_parser_get_attributes (self, _tmp5_ = g_strdup_printf ("%s::%s", _tmp4_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE), vala_symbol_get_name ((ValaSymbol*) sig)), &_tmp6_), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _tmp7_), attributes_length1 = _tmp6_, _attributes_size_ = attributes_length1, _tmp8_);
	if (attributes != NULL) {
		{
			char** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				char* attr;
				attr = g_strdup (attr_collection[attr_it]);
				{
					char** _tmp10_;
					gint _nv_size_;
					gint nv_length1;
					char** _tmp9_;
					char** nv;
					nv = (_tmp10_ = _tmp9_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp9_), _nv_size_ = nv_length1, _tmp10_);
					if (_vala_strcmp0 (nv[0], "name") == 0) {
						char* _tmp11_;
						vala_signal_set_cname (sig, vala_symbol_get_name ((ValaSymbol*) sig));
						vala_symbol_set_name ((ValaSymbol*) sig, _tmp11_ = vala_gidl_parser_eval (self, nv[1]));
						_g_free0 (_tmp11_);
					} else {
						gboolean _tmp12_ = FALSE;
						if (_vala_strcmp0 (nv[0], "has_emitter") == 0) {
							char* _tmp13_;
							_tmp12_ = _vala_strcmp0 (_tmp13_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0;
							_g_free0 (_tmp13_);
						} else {
							_tmp12_ = FALSE;
						}
						if (_tmp12_) {
							vala_signal_set_has_emitter (sig, TRUE);
						} else {
							if (_vala_strcmp0 (nv[0], "hidden") == 0) {
								char* _tmp14_;
								gboolean _tmp15_;
								if ((_tmp15_ = _vala_strcmp0 (_tmp14_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp14_), _tmp15_)) {
									result = NULL;
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (sig);
									return result;
								}
							} else {
								if (_vala_strcmp0 (nv[0], "deprecated") == 0) {
									char* _tmp16_;
									gboolean _tmp17_;
									if ((_tmp17_ = _vala_strcmp0 (_tmp16_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp16_), _tmp17_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) sig, TRUE);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "replacement") == 0) {
										char* _tmp18_;
										vala_symbol_set_replacement ((ValaSymbol*) sig, _tmp18_ = vala_gidl_parser_eval (self, nv[1]));
										_g_free0 (_tmp18_);
									} else {
										if (_vala_strcmp0 (nv[0], "deprecated_since") == 0) {
											char* _tmp19_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) sig, _tmp19_ = vala_gidl_parser_eval (self, nv[1]));
											_g_free0 (_tmp19_);
										} else {
											if (_vala_strcmp0 (nv[0], "transfer_ownership") == 0) {
												char* _tmp20_;
												gboolean _tmp21_;
												if ((_tmp21_ = _vala_strcmp0 (_tmp20_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp20_), _tmp21_)) {
													vala_data_type_set_value_owned (vala_signal_get_return_type (sig), TRUE);
												}
											} else {
												if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
													char** _tmp25_;
													gint _type_args_size_;
													gint type_args_length1;
													char** _tmp23_;
													char* _tmp22_;
													char** _tmp24_;
													char** type_args;
													type_args = (_tmp25_ = (_tmp24_ = _tmp23_ = g_strsplit (_tmp22_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp22_), _tmp24_), type_args_length1 = _vala_array_length (_tmp23_), _type_args_size_ = type_args_length1, _tmp25_);
													{
														char** type_arg_collection;
														int type_arg_collection_length1;
														int type_arg_it;
														type_arg_collection = type_args;
														type_arg_collection_length1 = type_args_length1;
														for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
															char* type_arg;
															type_arg = g_strdup (type_arg_collection[type_arg_it]);
															{
																ValaDataType* _tmp26_;
																vala_data_type_add_type_argument (vala_signal_get_return_type (sig), _tmp26_ = vala_gidl_parser_get_type_from_string (self, type_arg));
																_vala_code_node_unref0 (_tmp26_);
																_g_free0 (type_arg);
															}
														}
													}
													type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_signal_set_is_virtual (sig, TRUE);
	first = TRUE;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = sig_node->parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				ValaParameterDirection direction = 0;
				ValaDataType* param_type;
				ValaFormalParameter* p;
				char** _tmp30_;
				gint _tmp29_;
				char* _tmp28_;
				char* _tmp27_;
				if (first) {
					first = FALSE;
					continue;
				}
				param_node = (GIdlNode*) param;
				param_type = vala_gidl_parser_parse_param (self, param, &direction);
				p = vala_formal_parameter_new (param_node->name, param_type, NULL);
				vala_formal_parameter_set_direction (p, direction);
				vala_signal_add_parameter (sig, p);
				attributes = (_tmp30_ = vala_gidl_parser_get_attributes (self, _tmp28_ = g_strdup_printf ("%s::%s.%s", _tmp27_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE), vala_symbol_get_name ((ValaSymbol*) sig), param_node->name), &_tmp29_), attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL), attributes_length1 = _tmp29_, _attributes_size_ = attributes_length1, _tmp30_);
				_g_free0 (_tmp28_);
				_g_free0 (_tmp27_);
				if (attributes != NULL) {
					char* ns_name;
					ns_name = NULL;
					{
						char** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							char* attr;
							attr = g_strdup (attr_collection[attr_it]);
							{
								char** _tmp32_;
								gint _nv_size_;
								gint nv_length1;
								char** _tmp31_;
								char** nv;
								nv = (_tmp32_ = _tmp31_ = g_strsplit (attr, "=", 2), nv_length1 = _vala_array_length (_tmp31_), _nv_size_ = nv_length1, _tmp32_);
								if (_vala_strcmp0 (nv[0], "is_array") == 0) {
									char* _tmp33_;
									gboolean _tmp34_;
									if ((_tmp34_ = _vala_strcmp0 (_tmp33_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp33_), _tmp34_)) {
										ValaDataType* _tmp35_;
										param_type = (_tmp35_ = (ValaDataType*) vala_array_type_new (param_type, 1, vala_code_node_get_source_reference ((ValaCodeNode*) param_type)), _vala_code_node_unref0 (param_type), _tmp35_);
										vala_formal_parameter_set_parameter_type (p, param_type);
										vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
									}
								} else {
									if (_vala_strcmp0 (nv[0], "is_out") == 0) {
										char* _tmp36_;
										gboolean _tmp37_;
										if ((_tmp37_ = _vala_strcmp0 (_tmp36_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp36_), _tmp37_)) {
											vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
										}
									} else {
										if (_vala_strcmp0 (nv[0], "is_ref") == 0) {
											char* _tmp38_;
											gboolean _tmp39_;
											if ((_tmp39_ = _vala_strcmp0 (_tmp38_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp38_), _tmp39_)) {
												vala_formal_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
											}
										} else {
											if (_vala_strcmp0 (nv[0], "nullable") == 0) {
												char* _tmp40_;
												gboolean _tmp41_;
												if ((_tmp41_ = _vala_strcmp0 (_tmp40_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp40_), _tmp41_)) {
													vala_data_type_set_nullable (param_type, TRUE);
												}
											} else {
												if (_vala_strcmp0 (nv[0], "transfer_ownership") == 0) {
													char* _tmp42_;
													gboolean _tmp43_;
													if ((_tmp43_ = _vala_strcmp0 (_tmp42_ = vala_gidl_parser_eval (self, nv[1]), "1") == 0, _g_free0 (_tmp42_), _tmp43_)) {
														vala_data_type_set_value_owned (param_type, TRUE);
													}
												} else {
													if (_vala_strcmp0 (nv[0], "type_name") == 0) {
														ValaUnresolvedSymbol* _tmp46_;
														char* _tmp45_;
														if (!VALA_IS_UNRESOLVED_TYPE (param_type)) {
															ValaDataType* _tmp44_;
															param_type = (_tmp44_ = (ValaDataType*) vala_unresolved_type_new (), _vala_code_node_unref0 (param_type), _tmp44_);
															vala_formal_parameter_set_parameter_type (p, param_type);
														}
														vala_unresolved_type_set_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type), _tmp46_ = vala_unresolved_symbol_new (NULL, _tmp45_ = vala_gidl_parser_eval (self, nv[1]), NULL));
														_vala_code_node_unref0 (_tmp46_);
														_g_free0 (_tmp45_);
													} else {
														if (_vala_strcmp0 (nv[0], "type_arguments") == 0) {
															char** _tmp50_;
															gint _type_args_size_;
															gint type_args_length1;
															char** _tmp48_;
															char* _tmp47_;
															char** _tmp49_;
															char** type_args;
															type_args = (_tmp50_ = (_tmp49_ = _tmp48_ = g_strsplit (_tmp47_ = vala_gidl_parser_eval (self, nv[1]), ",", 0), _g_free0 (_tmp47_), _tmp49_), type_args_length1 = _vala_array_length (_tmp48_), _type_args_size_ = type_args_length1, _tmp50_);
															{
																char** type_arg_collection;
																int type_arg_collection_length1;
																int type_arg_it;
																type_arg_collection = type_args;
																type_arg_collection_length1 = type_args_length1;
																for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
																	char* type_arg;
																	type_arg = g_strdup (type_arg_collection[type_arg_it]);
																	{
																		ValaDataType* _tmp51_;
																		vala_data_type_add_type_argument (vala_formal_parameter_get_parameter_type (p), _tmp51_ = vala_gidl_parser_get_type_from_string (self, type_arg));
																		_vala_code_node_unref0 (_tmp51_);
																		_g_free0 (type_arg);
																	}
																}
															}
															type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
														} else {
															if (_vala_strcmp0 (nv[0], "namespace_name") == 0) {
																char* _tmp52_;
																ns_name = (_tmp52_ = vala_gidl_parser_eval (self, nv[1]), _g_free0 (ns_name), _tmp52_);
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
					if (ns_name != NULL) {
						ValaUnresolvedSymbol* _tmp53_;
						vala_unresolved_symbol_set_inner (vala_unresolved_type_get_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type)), _tmp53_ = vala_unresolved_symbol_new (NULL, ns_name, NULL));
						_vala_code_node_unref0 (_tmp53_);
					}
					_g_free0 (ns_name);
				}
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
			}
		}
	}
	result = sig;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ValaGIdlParser* vala_gidl_parser_construct (GType object_type) {
	ValaGIdlParser* self;
	self = (ValaGIdlParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIdlParser* vala_gidl_parser_new (void) {
	return vala_gidl_parser_construct (VALA_TYPE_GIDL_PARSER);
}


static void vala_gidl_parser_class_init (ValaGIdlParserClass * klass) {
	vala_gidl_parser_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gidl_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIdlParserPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_gidl_parser_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_gidl_parser_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_gidl_parser_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_gidl_parser_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_gidl_parser_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gidl_parser_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_gidl_parser_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_gidl_parser_real_visit_source_file;
}


static void vala_gidl_parser_instance_init (ValaGIdlParser * self) {
	self->priv = VALA_GIDL_PARSER_GET_PRIVATE (self);
}


static void vala_gidl_parser_finalize (ValaCodeVisitor* obj) {
	ValaGIdlParser * self;
	self = VALA_GIDL_PARSER (obj);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	_vala_code_node_unref0 (self->priv->current_namespace);
	_vala_code_node_unref0 (self->priv->current_data_type);
	_vala_collection_object_unref0 (self->priv->codenode_attributes_map);
	_vala_collection_object_unref0 (self->priv->codenode_attributes_patterns);
	_vala_collection_object_unref0 (self->priv->current_type_symbol_set);
	_vala_collection_object_unref0 (self->priv->cname_type_map);
	VALA_CODE_VISITOR_CLASS (vala_gidl_parser_parent_class)->finalize (obj);
}


GType vala_gidl_parser_get_type (void) {
	static volatile gsize vala_gidl_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gidl_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIdlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gidl_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIdlParser), 0, (GInstanceInitFunc) vala_gidl_parser_instance_init, NULL };
		GType vala_gidl_parser_type_id;
		vala_gidl_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIdlParser", &g_define_type_info, 0);
		g_once_init_leave (&vala_gidl_parser_type_id__volatile, vala_gidl_parser_type_id);
	}
	return vala_gidl_parser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




