/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* callbacks.h: this file is part of users-admin, a ximian-setup-tool frontend 
 * for user administration.
 * 
 * Copyright (C) 2000-2001 Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Tambet Ingo <tambet@ximian.com> and Arturo Espinosa <arturo@ximian.com>.
 */

#ifndef __CALLBACKS_H
#define __CALLBACKS_H

#include <gnome.h>
#include <gnome-xml/tree.h>
#include "xst.h"

BEGIN_GNOME_DECLS

void on_notebook_switch_page (GtkNotebook *notebook, GtkNotebookPage *page,
			      guint page_num, gpointer user_data);

void on_showall_toggled (GtkToggleButton *toggle, gpointer user_data);
void on_settings_clicked (GtkButton *button, gpointer user_data);

void on_user_new_clicked (GtkButton *button, gpointer user_data);
void on_user_delete_clicked (GtkButton *button, gpointer user_data);
void on_user_profiles_clicked (GtkButton *button, gpointer user_data);

void on_group_new_clicked (GtkButton *button, gpointer user_data);
void on_group_delete_clicked (GtkButton *button, gpointer user_data);

#ifdef NIS
void on_network_delete_clicked (GtkWidget *button, gpointer user_data);
void on_network_user_new_clicked (GtkButton *button, gpointer user_data);
void on_network_group_new_clicked (GtkButton *button, gpointer user_data);
#endif

void on_user_settings_clicked (GtkButton *button, gpointer data);

void on_group_settings_dialog_show (GtkWidget *widget, gpointer user_data);
void on_group_settings_cancel_clicked (GtkButton *button, gpointer user_data);
void on_group_settings_dialog_delete_event (GtkWidget *w, gpointer user_data);
void on_group_settings_ok_clicked (GtkButton *button, gpointer user_data);
void on_group_settings_add_clicked (GtkButton *button, gpointer user_data);
void on_group_settings_remove_clicked (GtkButton *button, gpointer user_data);
void on_group_settings_all_select_row (GtkCList *clist, gint row, gint column,
				       GdkEventButton *event, gpointer user_data);

void on_group_settings_members_select_row (GtkCList *clist, gint row, gint column,
					   GdkEventButton *event, gpointer user_data);

void actions_set_sensitive (gint table, gboolean state);

void on_user_passwd_dialog_delete_event (GtkWidget *w, gpointer data);

END_GNOME_DECLS

#endif /* CALLBACKS_H */

