/*
 * Decompiled with CFR 0.152.
 */
package org.domterm;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.domterm.Backend;
import org.domterm.ClassBackend;
import org.domterm.ProcessBackend;
import org.domterm.pty.PTY;
import org.domterm.pty.PtyBackend;
import org.domterm.util.StringBufferedWriter;
import org.domterm.util.WTDebug;

public class DomHttpServer
implements HttpHandler {
    static int verbose = 0;
    Map<String, Session> sessionMap = new HashMap<String, Session>();
    Set<Backend> pendingBackends = new HashSet<Backend>();
    public static int serverBacklog = 0;
    HttpServer httpServer = HttpServer.create();
    int port;
    Object endMonitor;
    String[] backendArgs;
    static String domtermPath;
    static int runBrowser;

    public DomHttpServer(int n, String[] stringArray) throws IOException, UnknownHostException {
        this.httpServer.bind(new InetSocketAddress(n), serverBacklog);
        this.httpServer.setExecutor(null);
        this.backendArgs = stringArray;
        this.httpServer.createContext("/", this);
    }

    public static void setExitOnClose(boolean bl) {
        runBrowser = bl ? 0 : -1;
    }

    private static String readAll(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while (true) {
            int n2;
            int n3;
            if ((n3 = byArray.length - n) == 0) {
                byte[] byArray2 = new byte[3 * byArray.length >> 1];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
                n3 = byArray.length - n;
            }
            if ((n2 = inputStream.read(byArray, n, n3)) <= 0) break;
            n += n2;
        }
        return new String(byArray, 0, n, StandardCharsets.UTF_8);
    }

    private static String readAll(HttpExchange httpExchange) throws IOException {
        InputStream inputStream = httpExchange.getRequestBody();
        String string = DomHttpServer.readAll(inputStream);
        inputStream.close();
        return string;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        Closeable closeable;
        Object object;
        Object object2;
        URI uRI = httpExchange.getRequestURI();
        String string = uRI.toString();
        Headers headers = httpExchange.getResponseHeaders();
        if ("/".equals(string)) {
            string = "/domterm/#ajax";
            headers.add("Location", string);
            httpExchange.sendResponseHeaders(307, -1L);
            return;
        }
        if (string.startsWith("/domterm/")) {
            if ((string = string.substring(8)).equals("/")) {
                string = "/repl-client.html";
            }
            if ("/open.txt".equals(string)) {
                String string2 = DomHttpServer.readAll(httpExchange);
                Session session = new Session(this, httpExchange);
                Backend backend = session.backend;
                if (string2.startsWith("VERSION=")) {
                    backend.addVersionInfo(string2.substring(8));
                }
                backend.versionInfo = backend.versionInfo + ";DomHttpServer";
                try {
                    session.termWriter = new ReplWriter(session);
                    backend.run(session.termWriter);
                    backend.sendSessionName();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                String string3 = "key=" + session.key;
                byte[] byArray = string3.getBytes();
                httpExchange.sendResponseHeaders(200, byArray.length);
                OutputStream outputStream = httpExchange.getResponseBody();
                outputStream.write(byArray);
                outputStream.close();
                return;
            }
            if (string.startsWith("/io-")) {
                String string4 = string.substring(4);
                Session session = this.sessionMap.get(string4);
                String string5 = DomHttpServer.readAll(httpExchange);
                Backend backend = session.backend;
                this.processInput(session, string5);
                CharSequence charSequence = session.termWriter.removeStrings();
                byte[] byArray = charSequence.toString().getBytes();
                httpExchange.sendResponseHeaders(200, byArray.length);
                OutputStream outputStream = httpExchange.getResponseBody();
                outputStream.write(byArray);
                outputStream.close();
                if (session.termWriter.closed) {
                    session.close();
                }
                return;
            }
            if (string.startsWith("/close-")) {
                object2 = string.substring(7);
                object = this.sessionMap.get(object2);
                ((Session)object).close();
            } else {
                object2 = this.getClass().getResource(string);
                if (object2 != null) {
                    URLConnection uRLConnection = ((URL)object2).openConnection();
                    object = uRLConnection;
                    if (uRLConnection != null && (closeable = ((URLConnection)object).getInputStream()) != null) {
                        int n;
                        int n2 = ((URLConnection)object).getContentLength();
                        String string6 = ((URLConnection)object).getContentType();
                        if (string6 == null || string6.equals("content/unknown")) {
                            if (string.endsWith(".js")) {
                                string6 = "application/javascript";
                            } else if (string.endsWith(".css")) {
                                string6 = "text/css";
                            }
                        }
                        headers.add("Content-Type", string6);
                        httpExchange.sendResponseHeaders(200, n2);
                        OutputStream outputStream = httpExchange.getResponseBody();
                        byte[] byArray = new byte[2048];
                        while ((n = ((InputStream)closeable).read(byArray)) >= 0) {
                            outputStream.write(byArray, 0, n);
                        }
                        outputStream.close();
                        return;
                    }
                }
            }
        }
        object2 = "The requested URL " + string + " was not found on this server.\r\n";
        object = ((String)object2).getBytes();
        httpExchange.sendResponseHeaders(404, ((byte[])object).length);
        closeable = httpExchange.getResponseBody();
        ((OutputStream)closeable).write((byte[])object);
        ((OutputStream)closeable).close();
    }

    public void start() {
        this.httpServer.start();
        this.port = this.httpServer.getAddress().getPort();
    }

    public void stop() {
        this.httpServer.stop(0);
        this.httpServer = null;
    }

    public int getPort() {
        return this.port;
    }

    public static void fatal(String string) {
        System.err.println(string);
        System.exit(-1);
    }

    protected Backend createBackend(Object object) {
        return this.createBackend();
    }

    protected Backend createBackend() {
        String[] stringArray;
        int n;
        WTDebug.init();
        Backend backend = null;
        String[] stringArray2 = this.backendArgs;
        int n2 = 32;
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray = stringArray2[n];
            if (stringArray.equals("--pty") || stringArray.equals("-e")) {
                n2 = 84;
                continue;
            }
            if (stringArray.equals("--shell") || stringArray.equals("--pipe") || stringArray.equals("--process")) {
                n2 = 83;
                continue;
            }
            if (stringArray.equals("--class")) {
                if (n + 1 == stringArray2.length) {
                    DomHttpServer.fatal("missing class name");
                }
                Method method = null;
                String string = stringArray2[n + 1];
                try {
                    method = ClassBackend.getMainMethod(string);
                }
                catch (Throwable throwable) {
                    DomHttpServer.fatal("caught " + throwable + " trying to load class " + string);
                }
                String[] stringArray3 = new String[stringArray2.length - n - 2];
                System.arraycopy(stringArray2, n + 2, stringArray3, 0, stringArray3.length);
                backend = new ClassBackend(method, stringArray3);
                break;
            }
            if (stringArray.length() != 0 && stringArray.charAt(0) != '-') break;
            DomHttpServer.fatal("unknown argument '" + (String)stringArray + "'");
        }
        if (backend == null) {
            stringArray = new String[stringArray2.length - n];
            System.arraycopy(stringArray2, n, stringArray, 0, stringArray.length);
            if (n2 == 84 || n2 == 32) {
                try {
                    PTY.checkLoaded();
                    n2 = 84;
                }
                catch (Throwable throwable) {
                    if (n2 == 32) {
                        n2 = 83;
                        System.err.println("(no pty in java.library.path - using --process)");
                    }
                    DomHttpServer.fatal("caught " + throwable);
                }
            }
            try {
                backend = n2 == 83 ? new ProcessBackend(stringArray) : new PtyBackend(stringArray, domtermPath);
            }
            catch (Throwable throwable) {
                DomHttpServer.fatal("caught " + throwable);
            }
        }
        return backend;
    }

    public void processInput(Session session, String string) {
        Backend backend = session.backend;
        if (verbose > 0) {
            WTDebug.println("received msg [" + WTDebug.toQuoted(string) + "]");
        }
        if (session.pending != null) {
            string = session.pending + string;
            session.pending = null;
        }
        int n = string.length();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\u0092') continue;
            backend.processInputCharacters(string.substring(0, i));
            int n3 = string.indexOf(10, i + 1);
            if (n3 >= 0) {
                int n4;
                for (n4 = i + 1; n4 < n3 && string.charAt(n4) != ' '; ++n4) {
                }
                String string2 = string.substring(i + 1, n4);
                while (n4 < n3 && string.charAt(n4) == ' ') {
                    ++n4;
                }
                session.reportEvent(string2, string.substring(n4, n3));
                string = string.substring(n3 + 1);
                i = -1;
                n = string.length();
                continue;
            }
            session.pending = string.substring(i);
            string = "";
            i = -1;
            n = 0;
        }
        backend.processInputCharacters(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String[] stringArray2;
        int n;
        int n2 = 32;
        String string = null;
        domtermPath = System.getProperty("java.library.path");
        if (domtermPath != null && domtermPath.endsWith("/lib")) {
            domtermPath = domtermPath.substring(0, domtermPath.length() - 4);
        }
        int n3 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2 = stringArray[n];
            if (stringArray2.equals("--port")) {
                if (n + 1 == stringArray.length) {
                    DomHttpServer.fatal("missing port number");
                }
                stringArray2 = stringArray[++n];
                try {
                    n3 = Integer.parseInt((String)stringArray2);
                }
                catch (Exception exception) {
                    DomHttpServer.fatal("bad port number '" + (String)stringArray2 + "'");
                }
                continue;
            }
            if (stringArray2.startsWith("--domterm-path=")) {
                domtermPath = stringArray2.substring(15);
                continue;
            }
            if (stringArray2.equals("--browser")) {
                runBrowser = 0;
                continue;
            }
            if (stringArray2.startsWith("--browser=")) {
                runBrowser = 0;
                string = stringArray2.substring(10);
                continue;
            }
            if (stringArray2.equals("--firefox")) {
                runBrowser = 1;
                continue;
            }
            if (stringArray2.equals("--chrome")) {
                runBrowser = 2;
                continue;
            }
            if (!stringArray2.equals("--qtdomterm") && !stringArray2.equals("--qtwebengine")) break;
            runBrowser = 3;
        }
        stringArray2 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
        if (n3 == -1) {
            n3 = runBrowser >= 0 ? 0 : 8025;
        }
        try {
            Object object;
            DomHttpServer domHttpServer = new DomHttpServer(n3, stringArray2);
            domHttpServer.start();
            n3 = domHttpServer.getPort();
            String string2 = "http://localhost:" + n3 + "/domterm/#ajax";
            if (runBrowser == 0) {
                if (string == null) {
                    Desktop.getDesktop().browse(new URI(string2));
                } else {
                    object = Runtime.getRuntime().exec(new String[]{string, string2});
                }
            } else if (runBrowser == 1) {
                object = DomHttpServer.firefoxCommand();
                Process process = Runtime.getRuntime().exec(new String[]{object, "-app", domtermPath + "/share/domterm/application.ini", "-ajax", "http://localhost:" + n3 + "/domterm/"});
            } else if (runBrowser == 2) {
                object = DomHttpServer.chromeCommand();
                String string3 = "--app=" + string2;
                Process process = Runtime.getRuntime().exec(new String[]{object, string3});
            } else if (runBrowser == 3) {
                object = domtermPath + "/bin/qtdomterm";
                Process process = Runtime.getRuntime().exec(new String[]{object, "--connect", "localhost:" + n3});
                process.waitFor();
            } else {
                System.out.println("DomTerm server started on port: " + n3 + ".");
                System.out.println("Point your browser at " + string2);
                object = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Please press a key to stop the server.");
                ((BufferedReader)object).readLine();
            }
            if (runBrowser >= 0) {
                object = domHttpServer.endMonitor = new Object();
                synchronized (object) {
                    domHttpServer.endMonitor.wait();
                }
            }
            domHttpServer.stop();
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    public static String chromeCommand() {
        String string = "google-chrome";
        String string2 = System.getenv("CHROME_BIN");
        if (string2 != null && new File(string2).exists()) {
            string = string2;
        }
        return string;
    }

    public static String firefoxCommand() {
        String string = "firefox";
        String string2 = "/Applications/Firefox.app/Contents/MacOS/firefox";
        if (new File(string2).exists()) {
            string = string2;
        }
        return string;
    }

    static {
        runBrowser = -1;
    }

    static class ReplWriter
    extends StringBufferedWriter {
        Session session;
        List<String> strings = new ArrayList<String>();
        int numChars = 0;
        boolean closed;
        int limit = 2000;
        public static final int MASK28 = 0xFFFFFFF;
        int countWritten;
        int countConfirmed;

        ReplWriter(Session session) {
            super(true);
            this.session = session;
        }

        @Override
        protected synchronized void writeRaw(String string) throws IOException {
            this.strings.add(string);
            int n = string.length();
            this.numChars += n;
            this.countWritten = this.countWritten + n & 0xFFFFFFF;
            while ((this.countWritten - this.countConfirmed & 0xFFFFFFF) > 3000) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void updateConfirmed(int n) {
            this.countConfirmed = n;
            this.notifyAll();
        }

        public synchronized CharSequence removeStrings() {
            StringBuilder stringBuilder = new StringBuilder(this.numChars);
            int n = this.strings.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.strings.get(i));
            }
            this.numChars = 0;
            this.strings.clear();
            return stringBuilder;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.session != null) {
                this.write("\u001b[99;99u");
                super.close();
                this.session = null;
            }
        }
    }

    static class Session {
        String key;
        Backend backend;
        static int counter;
        ReplWriter termWriter;
        String pending = null;
        DomHttpServer server;

        public Session(DomHttpServer domHttpServer, HttpExchange httpExchange) {
            this.server = domHttpServer;
            this.key = Integer.toString(++counter);
            this.backend = domHttpServer.createBackend();
            domHttpServer.sessionMap.put(this.key, this);
        }

        public void reportEvent(String string, String string2) {
            if (string.equals("RECEIVED")) {
                try {
                    int n = Integer.parseInt(string2);
                    this.termWriter.updateConfirmed(n);
                }
                catch (Throwable throwable) {}
            } else {
                this.backend.reportEvent(string, string2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.server.sessionMap.remove(this.key);
            this.backend.close(this.server.sessionMap.isEmpty());
            if (this.server.endMonitor != null) {
                Object object = this.server.endMonitor;
                synchronized (object) {
                    this.server.endMonitor.notifyAll();
                }
            } else if (runBrowser >= 0) {
                this.server.stop();
            }
        }

        public String toString() {
            return "Session-" + this.key;
        }
    }
}

