from SCons.Debug import logInstanceCreation
import SCons.Util
class Executor:
    def __init__(self, action, env=None, overridelist=[], targets=[], sources=[]):
        if __debug__: logInstanceCreation(self)
        self.action=action
        self.env=env
        self.overridelist=overridelist
        self.targets=targets
        self.sources=sources[:]
    def get_build_env(self):
        try:
            return self.build_env
        except AttributeError:
            overrides={}
            for odict in self.overridelist:
                overrides.update(odict)
            try:
                generate_build_dict=self.targets[0].generate_build_dict
            except (AttributeError, IndexError):
                pass
            else:
                overrides.update(generate_build_dict())
            import SCons.Defaults
            env=self.env or SCons.Defaults.DefaultEnvironment()
            self.build_env=env.Override(overrides)
            self.build_env._update(SCons.Util.subst_dict(self.targets, self.sources))
            return self.build_env
    def get_action_list(self, target):
        try:
            al=self.action_list
        except AttributeError:
            al=self.action.get_actions()
            self.action_list=al
        try:
            return target.pre_actions + al + target.post_actions
        except AttributeError:
            return al
    def __call__(self, target, errfunc, **kw):
        action_list=self.get_action_list(target)
        if not action_list:
            return
        env=self.get_build_env()
        for action in action_list:
            apply(action, (self.targets, self.sources, env, errfunc), kw)
    def cleanup(self):
        try:
            del self.build_env
        except AttributeError:
            pass
    def add_sources(self, sources):
        slist=filter(lambda x, s=self.sources: x not in s, sources)
        self.sources.extend(slist)
    def __str__(self):
        try:
            return self.string
        except AttributeError:
            action=self.action
            self.string=action.genstring(self.targets, self.sources, self.get_build_env())
            return self.string
    def get_raw_contents(self):
        try:
            return self.raw_contents
        except AttributeError:
            action=self.action
            self.raw_contents=action.get_raw_contents(self.targets, self.sources, self.get_build_env())
            return self.raw_contents
    def get_contents(self):
        try:
            return self.contents
        except AttributeError:
            action=self.action
            self.contents=action.get_contents(self.targets, self.sources, self.get_build_env())
            return self.contents
    def get_timestamp(self):
        return 0
