/* This file is part of the KDE libraries
   Copyright (C) 1999,2000 Kurt Granroth <granroth@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KSTANDARDACTION_PRIVATE_H
#define KSTANDARDACTION_PRIVATE_H

#include <QtGui/QApplication>

#include <kaction.h>
#include <klocale.h>
#include <kstandardshortcut.h>

namespace KStandardAction
{

struct KStandardActionInfo
{
  StandardAction id;
  KStandardShortcut::StandardShortcut idAccel;
  const char* psName;
  const char* psLabel;
  const char* psWhatsThis;
  const char* psIconName;
};

static const KStandardActionInfo g_rgActionInfo[] =
{
  { New,           KStandardShortcut::New, "file_new", I18N_NOOP("&New"), 0, "document-new" },
  { Open,          KStandardShortcut::Open, "file_open", I18N_NOOP("&Open..."), 0, "document-open" },
  { OpenRecent,    KStandardShortcut::AccelNone, "file_open_recent", I18N_NOOP("Open &Recent"), 0, "document-open" },
  { Save,          KStandardShortcut::Save, "file_save", I18N_NOOP("&Save"), 0, "document-save" },
  { SaveAs,        KStandardShortcut::AccelNone, "file_save_as", I18N_NOOP("Save &As..."), 0, "document-save-as" },
  { Revert,        KStandardShortcut::AccelNone, "file_revert", I18N_NOOP("Re&vert"), 0, "document-revert" },
  { Close,         KStandardShortcut::Close, "file_close", I18N_NOOP("&Close"), 0, "window-close" },
  { Print,         KStandardShortcut::Print, "file_print", I18N_NOOP("&Print..."), 0, "document-print" },
  { PrintPreview,  KStandardShortcut::AccelNone, "file_print_preview", I18N_NOOP("Print Previe&w"), 0, "document-print-preview" },
  { Mail,          KStandardShortcut::AccelNone, "file_mail", I18N_NOOP("&Mail..."), 0, "mail-send" },
  { Quit,          KStandardShortcut::Quit, "file_quit", I18N_NOOP("&Quit"), 0, "application-exit" },

  { Undo,          KStandardShortcut::Undo, "edit_undo", I18N_NOOP("&Undo"), 0, "edit-undo" },
  { Redo,          KStandardShortcut::Redo, "edit_redo", I18N_NOOP("Re&do"), 0, "edit-redo" },
  { Cut,           KStandardShortcut::Cut, "edit_cut", I18N_NOOP("Cu&t"), 0, "edit-cut" },
  { Copy,          KStandardShortcut::Copy, "edit_copy", I18N_NOOP("&Copy"), 0, "edit-copy" },
  { Paste,         KStandardShortcut::Paste, "edit_paste", I18N_NOOP("&Paste"), 0, "edit-paste" },
  { PasteText,     KStandardShortcut::Paste, "edit_paste", I18N_NOOP("&Paste"), 0, "edit-paste" },
  { Clear,         KStandardShortcut::AccelNone, "edit_clear", I18N_NOOP("C&lear"), 0, "edit-clear" },
  { SelectAll,     KStandardShortcut::SelectAll, "edit_select_all", I18N_NOOP("Select &All"), 0, "edit-select-all" },
  { Deselect,      KStandardShortcut::Deselect, "edit_deselect", I18N_NOOP("Dese&lect"), 0, 0 },
  { Find,          KStandardShortcut::Find, "edit_find", I18N_NOOP("&Find..."), 0, "edit-find" },
  { FindNext,      KStandardShortcut::FindNext, "edit_find_next", I18N_NOOP("Find &Next"), 0, "go-down-search" },
  { FindPrev,      KStandardShortcut::FindPrev, "edit_find_prev", I18N_NOOP("Find Pre&vious"), 0, "go-up-search" },
  { Replace,       KStandardShortcut::Replace, "edit_replace", I18N_NOOP("&Replace..."), 0, 0 },

  { ActualSize,    KStandardShortcut::AccelNone, "view_actual_size", I18N_NOOP("&Actual Size"), 0, "zoom-original" },
  { FitToPage,     KStandardShortcut::AccelNone, "view_fit_to_page", I18N_NOOP("&Fit to Page"), 0, 0 },
  { FitToWidth,    KStandardShortcut::AccelNone, "view_fit_to_width", I18N_NOOP("Fit to Page &Width"), 0, 0 },
  { FitToHeight,   KStandardShortcut::AccelNone, "view_fit_to_height", I18N_NOOP("Fit to Page &Height"), 0, 0 },
  { ZoomIn,        KStandardShortcut::ZoomIn, "view_zoom_in", I18N_NOOP("Zoom &In"), 0, "zoom-in" },
  { ZoomOut,       KStandardShortcut::ZoomOut, "view_zoom_out", I18N_NOOP("Zoom &Out"), 0, "zoom-out" },
  { Zoom,          KStandardShortcut::AccelNone, "view_zoom", I18N_NOOP("&Zoom..."), 0, 0 },
  { Redisplay,     KStandardShortcut::Reload, "view_redisplay", I18N_NOOP("&Redisplay"), 0, "view-refresh" },

  { Up,            KStandardShortcut::Up, "go_up", I18N_NOOP("&Up"), 0, "go-up" },
  // The following three have special i18n() needs for sLabel
  { Back,          KStandardShortcut::Back, "go_back", 0, 0, "go-previous" },
  { Forward,       KStandardShortcut::Forward, "go_forward", 0, 0, "go-next" },
  { Home,          KStandardShortcut::Home, "go_home", 0, 0, "go-home" },
  { Prior,         KStandardShortcut::Prior, "go_previous", I18N_NOOP("&Previous Page"), 0, "go-previous-page" },
  { Next,          KStandardShortcut::Next, "go_next", I18N_NOOP("&Next Page"), 0, "go-next-page" },
  { Goto,          KStandardShortcut::AccelNone, "go_goto", I18N_NOOP("&Go To..."), 0, 0 },
  { GotoPage,      KStandardShortcut::AccelNone, "go_goto_page", I18N_NOOP("&Go to Page..."), 0, "go-jump" },
  { GotoLine,      KStandardShortcut::GotoLine, "go_goto_line", I18N_NOOP("&Go to Line..."), 0, 0 },
  { FirstPage,     KStandardShortcut::Begin, "go_first", I18N_NOOP("&First Page"), 0, "go-first-page" },
  { LastPage,      KStandardShortcut::End, "go_last", I18N_NOOP("&Last Page"), 0, "go-last-page" },
  { DocumentBack,  KStandardShortcut::AccelNone, "go_document_back", I18N_NOOP("&Back in the Document"), 0, "go-previous" },
  { DocumentForward, KStandardShortcut::AccelNone, "go_document_forward", I18N_NOOP("&Forward in the Document"), 0, "go-next" },

  { AddBookmark,   KStandardShortcut::AddBookmark, "bookmark_add", I18N_NOOP("&Add Bookmark"), 0, "bookmark-new" },
  { EditBookmarks, KStandardShortcut::AccelNone, "bookmark_edit", I18N_NOOP("&Edit Bookmarks"), 0, "bookmarks" },

  { Spelling,      KStandardShortcut::AccelNone, "tools_spelling", I18N_NOOP("&Spelling..."), 0, "tools-check-spelling" },

  { ShowMenubar,   KStandardShortcut::ShowMenubar, "options_show_menubar", I18N_NOOP("Show &Menubar"), 0, "show-menu" },
  { ShowToolbar,   KStandardShortcut::AccelNone, "options_show_toolbar", I18N_NOOP("Show &Toolbar"), 0, 0 },
  { ShowStatusbar, KStandardShortcut::AccelNone, "options_show_statusbar", I18N_NOOP("Show St&atusbar"), 0, 0 },
  { FullScreen,    KStandardShortcut::FullScreen, "fullscreen", I18N_NOOP("F&ull Screen Mode"), 0, "view-fullscreen" },
  { SaveOptions,   KStandardShortcut::AccelNone, "options_save_options", I18N_NOOP("&Save Settings"), 0, 0 },
  { KeyBindings,   KStandardShortcut::AccelNone, "options_configure_keybinding", I18N_NOOP("Configure S&hortcuts..."), 0,"configure-shortcuts" },
  { Preferences,   KStandardShortcut::AccelNone, "options_configure", I18N_NOOP("&Configure %1..."), 0, "configure" },
  { ConfigureToolbars, KStandardShortcut::AccelNone, "options_configure_toolbars", I18N_NOOP("Configure Tool&bars..."), 0,"configure-toolbars" },
  { ConfigureNotifications, KStandardShortcut::AccelNone, "options_configure_notifications", I18N_NOOP("Configure &Notifications..."), 0, "preferences-desktop-notification" },

  // the idea here is that Contents is used in menus, and Help in dialogs, so both share the same
  // shortcut
  { Help,          KStandardShortcut::Help, "help", 0, 0, "help-contents" },
  { HelpContents,  KStandardShortcut::Help, "help_contents", I18N_NOOP("%1 &Handbook"), 0, "help-contents" },
  { WhatsThis,     KStandardShortcut::WhatsThis, "help_whats_this", I18N_NOOP("What's &This?"), 0, "help-contextual" },
  { TipofDay,      KStandardShortcut::AccelNone, "help_show_tip", I18N_NOOP("Tip of the &Day"), 0, "help-hint" },
  { ReportBug,     KStandardShortcut::AccelNone, "help_report_bug", I18N_NOOP("&Report Bug..."), 0, "tools-report-bug" },
  { SwitchApplicationLanguage, KStandardShortcut::AccelNone, "switch_application_language", I18N_NOOP("Switch Application &Language..."), 0, 0 },
  { AboutApp,      KStandardShortcut::AccelNone, "help_about_app", I18N_NOOP("&About %1"), 0, 0 },
  { AboutKDE,      KStandardShortcut::AccelNone, "help_about_kde", I18N_NOOP("About &KDE"), 0, "kde" },
  { ActionNone, KStandardShortcut::AccelNone, 0, 0, 0, 0 }
};

inline const KStandardActionInfo* infoPtr( StandardAction id )
{
  for ( uint i = 0; g_rgActionInfo[i].id != ActionNone; i++ ) {
    if( g_rgActionInfo[i].id == id )
      return &g_rgActionInfo[i];
  }

  return 0;
}

static inline QStringList internal_stdNames()
{
  QStringList result;

  for ( uint i = 0; g_rgActionInfo[i].id != ActionNone; i++ )
    if (g_rgActionInfo[i].psLabel) {
      if (QString(g_rgActionInfo[i].psLabel).indexOf("%1") >= 0)
        // Prevents i18n from complaining about unsubstituted placeholder.
        result.append(i18n(g_rgActionInfo[i].psLabel, QString()));
      else
        result.append(i18n(g_rgActionInfo[i].psLabel));
    }

  return result;
}

class AutomaticAction : public KAction
{
  Q_OBJECT

  public:
    AutomaticAction(const KIcon &icon, const QString &text, const KShortcut &shortcut, const char *slot,
                    QObject *parent);
  public Q_SLOTS:
    inline void cut() { invokeEditSlot( "cut" ); }
    inline void copy() { invokeEditSlot( "copy" ); }
    inline void paste() { invokeEditSlot( "paste" ); }
    inline void clear() { invokeEditSlot( "clear" ); }
    inline void selectAll() { invokeEditSlot( "selectAll" ); }

    void invokeEditSlot( const char *slot )
    {
      if ( qApp->focusWidget() )
        QMetaObject::invokeMethod( qApp->focusWidget(), slot );
    }

};

}

#endif
