#include <qwmatrix.h>

#include <kiconloader.h>

#include "camera_iconviewitem.h"
#include "camera_iconview.h"

Camera_IconViewItem::Camera_IconViewItem(Camera_IconView* parent)
   : QIconViewItem(parent)
{

    setDropEnabled(false);
    setDragEnabled(false);

    m_thumbNailed = false;
    m_stateThumbNailed = false;
    m_isGlobalItem = false;

    m_thumbNail = NULL;
    m_fileInfo = NULL;
    m_globalItem = NULL;
    m_actualItem = NULL;

}

Camera_IconViewItem::Camera_IconViewItem(Camera_IconView* parent,
                                         const Camera_FileInfo& info,
                                         Camera_IconView* globalIconView)
    : QIconViewItem(parent)
{
    setDropEnabled(false);
    setDragEnabled(false);

    m_thumbNailed = false;
    m_stateThumbNailed = false;
    m_isGlobalItem = false;

    m_thumbNail  = NULL;
    m_globalItem = NULL;
    m_actualItem = NULL;


    m_fileInfo = new Camera_FileInfo(info);
    setText(m_fileInfo->getName());

    if (globalIconView)
        m_globalItem = new Camera_IconViewItem(globalIconView, this);

}

Camera_IconViewItem::Camera_IconViewItem(Camera_IconView* parent,
                                         Camera_IconViewItem* actualItem)
    : QIconViewItem(parent), m_actualItem(actualItem)
{
    setDropEnabled(false);
    setDragEnabled(false);

    m_thumbNailed = false;
    m_stateThumbNailed = false;
    m_isGlobalItem = true;

    m_thumbNail  = NULL;
    m_globalItem = NULL;

    m_fileInfo = NULL;
    setText(fileInfo().getName());
}

Camera_IconViewItem::~Camera_IconViewItem() {

    if (!m_isGlobalItem) {

        if (m_globalItem)
            delete (Camera_IconViewItem*) m_globalItem;
        if (m_thumbNailed)
            delete m_thumbNail;
        if (m_fileInfo)
            delete m_fileInfo;
    }
}

Camera_FileInfo& Camera_IconViewItem::fileInfo() const {

    if (m_isGlobalItem)
        return m_actualItem->fileInfo();
    else
        return *m_fileInfo;
}




void Camera_IconViewItem::setThumbNail(const QPixmap& icon,
				       const ThumbnailSize& thumbSize) {

  if (icon.isNull()) return;
  if (m_thumbNailed)
      delete m_thumbNail;
  m_thumbNailed=true;
  m_thumbNail= new QPixmap(icon);

  QPixmap thumbNailShow(*m_thumbNail);
  if (thumbSize.mySize() != ThumbnailSize::Large) {
      QWMatrix matrix;
      matrix.scale(thumbSize.scaleFactor(),thumbSize.scaleFactor());
      thumbNailShow = thumbNailShow.xForm(matrix);
  }

  setPixmap(thumbNailShow);
  syncItemWithGlobal();

  m_stateThumbNailed = true;

}

void Camera_IconViewItem::setThumbNail(const ThumbnailSize& thumbSize) {

  if (m_thumbNail) {

      QPixmap thumbNailShow(*m_thumbNail);
      if (thumbSize.mySize() != ThumbnailSize::Large) {
          QWMatrix matrix;
          matrix.scale(thumbSize.scaleFactor(),thumbSize.scaleFactor());
          thumbNailShow = thumbNailShow.xForm(matrix);
      }

      setPixmap(thumbNailShow);
      syncItemWithGlobal();

      m_stateThumbNailed = true;
  }

}


void Camera_IconViewItem::setPixmapForMime(const ThumbnailSize& thumbSize) {

  int iconSize;

  switch(thumbSize.mySize()) {
  case ThumbnailSize::Small:
    iconSize = KIcon::SizeSmall;
    break;
  case ThumbnailSize::Med:
    iconSize = KIcon::SizeMedium;
    break;
  default:
    iconSize = KIcon::SizeLarge;
    break;
  }

  if (fileInfo().getMime().contains("image"))
      setPixmap(BarIcon("image", iconSize));
  else if (fileInfo().getMime().contains("audio") )
      setPixmap(BarIcon("sound", iconSize));
  else if (fileInfo().getMime().contains("video"))
      setPixmap(BarIcon("video", iconSize));
  else
      setPixmap(BarIcon("document", iconSize));

  syncItemWithGlobal();
  m_stateThumbNailed = false;

}

void Camera_IconViewItem::syncItemWithGlobal()
{
    m_globalItem->setPixmap(*pixmap());

}
