#ifndef SAVEFILE_DIALOG_H
#define SAVEFILE_DIALOG_H

#include <qdialog.h>

class QString;
class QLineEdit;
class QPushButton;

enum Operation {Rename, Skip, SkipAll, Overwrite, OverwriteAll, None};

class SaveFile_Dialog : public QDialog {

    Q_OBJECT

public:

    SaveFile_Dialog(const QString& file, QWidget *parent=0,
                    const char* name=0, bool modal=true);
    ~SaveFile_Dialog();

    Operation saveFileOperation();
    QString   renameFile();

private slots:

    void slot_rename() {op=Rename; accept();}
    void slot_skip() {op=Skip; accept();}
    void slot_skipAll() {op=SkipAll; accept();}
    void slot_overwrite() {op=Overwrite; accept();}
    void slot_overwriteAll() {op=OverwriteAll; accept();}
    void slot_renameEnabled(const QString &str);

private:

    QLineEdit *renameEdit;
    QPushButton *renameBtn;
    Operation op;

};


#endif
