%feature("docstring") OT::LinearEvaluation
"Linear numerical math evaluation implementation.

Available constructors:
   LinearEvaluation(*center, constant, linear*)

Parameters
----------
center : sequence of float
    Vector :math:`\\vect{b}`.
constant : sequence of float
    Vector :math:`\\vect{c}`.
linear : :class:`~openturns.Matrix`
    Matrix :math:`\\mat{A}`.

See also
--------
Function

Notes
-----
This implements a linear :class:`~openturns.Function` :math:`f` 
defined as :

.. math::

    f : & \\Rset^n \\rightarrow \\Rset^p  \\\\
        & \\vect{X} \\mapsto \\mat{A} ( \\vect{X} - \\vect{b} ) + \\vect{c}

where:

- :math:`\\mat{A}` is the :math:`\\Rset^p \\times \\Rset^n` matrix defined by the
  input *linear*
- :math:`\\vect{b}` is the :math:`\\Rset^n` vector defined by the object *center*
- :math:`\\vect{c}` is the :math:`\\Rset^p` vector defined by the object *constant*."

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearEvaluation::getCenter
"Accessor to the center.

Returns
-------
center : :class:`~openturns.Point`
    The center :math:`\\vect{b}`."

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearEvaluation::getConstant
"Accessor to the constant.

Returns
-------
constant : :class:`~openturns.Point`
    The constant :math:`\\vect{c}`."

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearEvaluation::getLinear
"Accessor to the matrix.

Returns
-------
linear : :class:`~openturns.Matrix`
    The matrix :math:`\\mat{A}`."
