// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#pragma once

#include <utils/filepath.h>
#include <utils/wizard.h>

namespace ProjectExplorer { class BuildSystem; }

namespace Android::Internal {

class CreateAndroidManifestWizard : public Utils::Wizard
{
public:
    CreateAndroidManifestWizard(ProjectExplorer::BuildSystem *buildSystem);

    QString buildKey() const;
    void setBuildKey(const QString &buildKey);

    void accept() override;
    bool copyGradleTemplates() const;
    bool allowGradleTemplates() const;

    void setDirectory(const Utils::FilePath &directory);
    void setCopyGradleTemplates(bool copy);

    ProjectExplorer::BuildSystem *buildSystem() const;

private:
    void createAndroidManifestFile();
    void createAndroidTemplateFiles();
    ProjectExplorer::BuildSystem *m_buildSystem;
    QString m_buildKey;
    Utils::FilePath m_directory;
    bool m_allowGradleTemplates;
    bool m_copyGradleTemplates;
};

} // Android::Internal
