#ifndef _CEGOADMINTHREAD_H_INCLUDED_
#define _CEGOADMINTHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdminThread.h  
// -----------------
// Cego admin thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAdminThread
// 
// Description: Handling all database admin requests
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/Thread.h>
#include <lfcbase/NetHandler.h>
#include <lfcbase/NanoTimer.h>
#include <lfcbase/OutStream.h>

// CEGO INCLUDES
#include "CegoAdminHandler.h"
#include "CegoDatabaseManager.h"
#include "CegoDistManager.h"
#include "CegoDbThreadPool.h"
#include "CegoLogThreadPool.h"

class CegoAdminThreadPool;

class CegoAdminThread : public Thread {
    
public:
    
    CegoAdminThread();
    CegoAdminThread(CegoAdminThreadPool *pPool, CegoDatabaseManager *pDBMng, CegoDbThreadPool *pDbPool, CegoLogThreadPool *pLogPool);
    ~CegoAdminThread();
    
    const Chain& lastAction() const;
    void* job(void* arg);
    
private:
    
    class BackupStream : public OutStream {
    
    public:
	
	BackupStream(CegoAdminHandler* pAH)
	{
	    _pAH = pAH;
	}
	
	~BackupStream()
	{
	}
	
	bool nextLine(const Chain& line)
	{
	    return _pAH->syncWithInfo(Chain("local"), Chain("local"), line, 0);
	}
	
	
    private:
	
	CegoAdminHandler* _pAH;
	
    };
    
    void copyTableSet(int copyId, const Chain& tableSet, const Chain& secondary, const Chain& mediator, const Chain& user, const Chain& passwd, bool copyOnline);
    
    void serveSession(CegoAdminHandler *pAH);
    bool serveRequest(CegoAdminHandler *pAH, CegoAdminHandler::RequestType reqType);
    
    void srvRetrieveTableSet(CegoAdminHandler *pAH);
    void srvLockInfo(CegoAdminHandler *pAH);
    void srvLockStat(CegoAdminHandler *pAH);
    void srvParameterInfo(CegoAdminHandler *pAH);
    void srvPoolInfo(CegoAdminHandler *pAH);
    void srvPoolEntryList(CegoAdminHandler *pAH);
    void srvThreadInfo(CegoAdminHandler *pAH);

    void srvDbThreadInfo(CegoAdminHandler *pAH);
    void srvAdmThreadInfo(CegoAdminHandler *pAH);
    void srvLogThreadInfo(CegoAdminHandler *pAH);
    void srvDbThreadAbort(CegoAdminHandler *pAH);
    void srvDbSessionInfo(CegoAdminHandler *pAH);
    void srvCopyInfo(CegoAdminHandler *pAH);

    void srvShowQueryCache(CegoAdminHandler *pAH);
    void srvListQueryCache(CegoAdminHandler *pAH);
    void srvCleanQueryCache(CegoAdminHandler *pAH);
    void srvSetQueryCacheEntry(CegoAdminHandler *pAH);
    void srvSetQueryCacheSize(CegoAdminHandler *pAH);

    void srvShowTableCache(CegoAdminHandler *pAH);
    void srvListTableCache(CegoAdminHandler *pAH);
    void srvCleanTableCache(CegoAdminHandler *pAH);
    void srvSetTableCacheEntry(CegoAdminHandler *pAH);
    void srvSetTableCacheSize(CegoAdminHandler *pAH);

    void srvDefineTableSet(CegoAdminHandler *pAH);
    void srvRemoveTableSet(CegoAdminHandler *pAH);
    void srvResetTableSet(CegoAdminHandler *pAH);
    void srvCreateTableSet(CegoAdminHandler *pAH);
    void srvDropTableSet(CegoAdminHandler *pAH);
    void srvStartTableSet(CegoAdminHandler *pAH);
    void srvStopTableSet(CegoAdminHandler *pAH);
    void srvVerifyTableSet(CegoAdminHandler *pAH);
    void srvCorrectTableSet(CegoAdminHandler *pAH);
    void srvDumpObject(CegoAdminHandler *pAH);
    void srvSetLogMng(CegoAdminHandler *pAH);
    void srvShowLogMng(CegoAdminHandler *pAH);
    void srvSetBackupMng(CegoAdminHandler *pAH);
    void srvShowBackupMng(CegoAdminHandler *pAH);
    void srvSetCheckpoint(CegoAdminHandler *pAH);
    void srvSetTSInitFile(CegoAdminHandler *pAH);
    void srvSetTSSysSize(CegoAdminHandler *pAH);
    void srvSetTSTmpSize(CegoAdminHandler *pAH);
    void srvSetTSAppSize(CegoAdminHandler *pAH);
    void srvSetTSRootPath(CegoAdminHandler *pAH);
    void srvSetTSLogNum(CegoAdminHandler *pAH);
    void srvSetTSLogSize(CegoAdminHandler *pAH);
    void srvSetTSSortAreaSize(CegoAdminHandler *pAH);
    void srvSetTSLogUser(CegoAdminHandler *pAH);

    void srvStartRecovery(CegoAdminHandler *pAH);	      	
    void srvStopRecovery(CegoAdminHandler *pAH);
    void srvGetDbSpec(CegoAdminHandler *pAH);
    void srvGetDbInfo(CegoAdminHandler *pAH);
    void srvGetTSInfo(CegoAdminHandler *pAH);

    void srvGetDetailedTSInfo(CegoAdminHandler *pAH);
    void srvGetTransactionInfo(CegoAdminHandler *pAH);
    void srvGetBUStatInfo(CegoAdminHandler *pAH);

    void srvPropTSInfo(CegoAdminHandler *pAH);
    void srvCopyTableSet(CegoAdminHandler *pAH);
    void srvCopyFile(CegoAdminHandler *pAH);
    void srvGetNodeList(CegoAdminHandler *pAH);
    void srvSetTableSetNode(CegoAdminHandler *pAH);
    void srvSetLSN(CegoAdminHandler *pAH);
    void srvSetRunState(CegoAdminHandler *pAH);
    void srvSetSyncState(CegoAdminHandler *pAH);
    void srvExportTableSet(CegoAdminHandler *pAH);
    void srvImportTableSet(CegoAdminHandler *pAH);
    void srvExportTable(CegoAdminHandler *pAH);
    void srvImportTable(CegoAdminHandler *pAH);
    void srvAddDatafile(CegoAdminHandler *pAH);

    void srvUserInfo(CegoAdminHandler *pAH);
    void srvAddUser(CegoAdminHandler *pAH);
    void srvRemoveUser(CegoAdminHandler *pAH);
    void srvChangePwd(CegoAdminHandler *pAH);
    void srvListRole(CegoAdminHandler *pAH);
    void srvShowRole(CegoAdminHandler *pAH);
    void srvCreateRole(CegoAdminHandler *pAH);
    void srvDropRole(CegoAdminHandler *pAH);
    void srvAssignRole(CegoAdminHandler *pAH);
    void srvRemoveRole(CegoAdminHandler *pAH);
    void srvSetPerm(CegoAdminHandler *pAH);
    void srvRemovePerm(CegoAdminHandler *pAH);
    void srvUserTrace(CegoAdminHandler *pAH);

    void srvSyncTableSet(CegoAdminHandler *pAH);
    void srvInitLogs(CegoAdminHandler *pAH);

    void srvAddArchLog(CegoAdminHandler *pAH);
    void srvRemoveArchLog(CegoAdminHandler *pAH);

    void srvBeginBackup(CegoAdminHandler *pAH);
    void srvExecuteBackup(CegoAdminHandler *pAH);
    void srvEndBackup(CegoAdminHandler *pAH);
    void srvListBackup(CegoAdminHandler *pAH);
    
    void srvRestore(CegoAdminHandler *pAH);
    void srvRecover(CegoAdminHandler *pAH);
    void srvSecSwitch(CegoAdminHandler *pAH);

    void srvEnableTableCache(CegoAdminHandler *pAH);
    void srvDisableTableCache(CegoAdminHandler *pAH);

    void srvEnableQueryCache(CegoAdminHandler *pAH);
    void srvDisableQueryCache(CegoAdminHandler *pAH);

    // mediator services
    void medNotify(CegoAdminHandler *pAH);
    void medDefineTableSet(CegoAdminHandler *pAH);
    void medRemoveTableSet(CegoAdminHandler *pAH);
    void medResetTableSet(CegoAdminHandler *pAH);

    void medCreateTableSet(CegoAdminHandler *pAH);
    void medDropTableSet(CegoAdminHandler *pAH);

    void medStartTableSet(CegoAdminHandler *pAH);
    void medStopTableSet(CegoAdminHandler *pAH);

    void medCopyTableSet(CegoAdminHandler *pAH);
    void medSwitchTableSet(CegoAdminHandler *pAH);

    void medAddArchLog(CegoAdminHandler *pAH);
    void medRemoveArchLog(CegoAdminHandler *pAH);
    void medAddDatafile(CegoAdminHandler *pAH);
    void medVerifyTableSet(CegoAdminHandler *pAH);
    void medCorrectTableSet(CegoAdminHandler *pAH);

    void medGetTableSetList(CegoAdminHandler *pAH);
    void medGetDetailedTableSetInfo(CegoAdminHandler *pAH);

    void medGetObjectInfo(CegoAdminHandler *pAH);
    void medGetTransactionInfo(CegoAdminHandler *pAH);
    void medGetBUStatInfo(CegoAdminHandler *pAH);
    void medResetBUStat(CegoAdminHandler *pAH);

    void medBeginBackup(CegoAdminHandler *pAH);
    void medExecuteBackup(CegoAdminHandler *pAH);
    void medEndBackup(CegoAdminHandler *pAH);
    void medListBackup(CegoAdminHandler *pAH);
    void medRestore(CegoAdminHandler *pAH);
    void medRecover(CegoAdminHandler *pAH);
    void medSecSwitch(CegoAdminHandler *pAH);

    void medSecRelocate(CegoAdminHandler *pAH);

    void medCheckTableSet(CegoAdminHandler *pAH);

    void medEnableArchLog(CegoAdminHandler *pAH);
    void medDisableArchLog(CegoAdminHandler *pAH);

    void medEnableAutoCorrect(CegoAdminHandler *pAH);
    void medDisableAutoCorrect(CegoAdminHandler *pAH);

    // secondary services
    void secMedSwitch(CegoAdminHandler *pAH);
    void secMedRelocate(CegoAdminHandler *pAH);

    CegoAdminHandler* getSession(const Chain& role, const Chain& hostname, const Chain& user, const Chain& pwd);
    void closeSession(CegoAdminHandler* pAH);

    void addTableSetUsage(Element *pTSE);

    Element* getDetailedTSInfo(const Chain& tableSet);
    Element* getObjectInfo(const Chain& tableSet);
    Element* getTransactionInfo(const Chain& tableSet);
    Element* getBUStatInfo(const Chain& tableSet);

    Element* getBackupInfo(const Chain& tableSet);
    
    Element* checkTS(const Chain& hostType, const Chain& hostName, Element *pInfo, CegoAdminHandler *pPAH, CegoAdminHandler *pSAH);

    Chain executeBackup(CegoAdminHandler* pAH, const Chain& tableSet, const Chain& msg);
    ListT<Chain> executeListBackup(const Chain& tableSet);
    Chain executeRestore(CegoAdminHandler* pAH, const Chain& tableSet, const Chain& backupId);
    
    unsigned long long _idx;

    CegoDatabaseManager* _pDBMng;
    CegoAdminThreadPool* _pPool;
    NetHandler* _pRequest;
    CegoDistManager* _pTabMng;

    CegoDbThreadPool* _pDbPool;
    CegoLogThreadPool* _pLogPool;

    Chain _lastAction;

    Chain _user;
    Chain _password;

    NanoTimer* _pTim;

    unsigned long _modId;
};

#endif
