#ifndef _CEGOFIELD_H_INCLUDED_
#define _CEGOFIELD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoField.h
// -----------
// Cego data Field class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//         
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoField
// 
// Description: Cego data field container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcxml/Element.h>

// CEGO INCLUDES
#include "CegoDataType.h"
#include "CegoFieldValue.h"

class CegoField {
    
public:

    CegoField();
    CegoField(const CegoField& f);
    CegoField(const Chain& tableName, const Chain& attrName);
    
    CegoField(const Chain& tableName, const Chain& tableAlias, const Chain& attrName, CegoDataType type, int len, int dim = 0,
	      const CegoFieldValue& defVal = CegoFieldValue(),
	      bool isNullable = false, int id = 0);
    
    CegoField(const CegoFieldValue& fv);

    ~CegoField();

    void setNullable(bool isNullable);
    bool isNullable() const;

    void setTableName(const Chain& tableName);
    const Chain& getTableName() const;

    void setTableAlias(const Chain& tableAlias);
    const Chain& getTableAlias() const;

    void setId(int id);
    int getId() const;

    void setAttrName(const Chain& attrName);
    const Chain& getAttrName() const;

    const CegoDataType& getType() const;
    void setType(const CegoDataType t);

    int getLength() const;
    void setLength(int l);

    int getDim() const;
    void setDim(int d);

    const CegoFieldValue& getValue() const;
    void setValue(const CegoFieldValue& fv);

    // performance critical setup
    void setupNull();
    void setupValue(CegoDataType type, void* pValue, int len);

    int size() const;
    CegoField& operator = ( const CegoField& f);
    bool operator == ( const CegoField& f);
    bool operator != ( const CegoField& f);

    Chain typeToChain() const;

    Element* toElement() const;
    void fromElement(Element *pFieldElement);
    
private:
    
    Chain _tableName;
    Chain _tableAlias;
    Chain _attrName;
    int _id;    
    CegoFieldValue _fv;
    bool _isNullable;
    
    CegoDataType _type;
    int _len;
    int _dim;
};

#endif
