_ruff() {
    local i cur prev opts cmd
    COMPREPLY=()
    cur="${COMP_WORDS[COMP_CWORD]}"
    prev="${COMP_WORDS[COMP_CWORD-1]}"
    cmd=""
    opts=""

    for i in ${COMP_WORDS[@]}
    do
        case "${cmd},${i}" in
            ",$1")
                cmd="ruff"
                ;;
            ruff,check)
                cmd="ruff__check"
                ;;
            ruff,clean)
                cmd="ruff__clean"
                ;;
            ruff,config)
                cmd="ruff__config"
                ;;
            ruff,format)
                cmd="ruff__format"
                ;;
            ruff,generate-shell-completion)
                cmd="ruff__generate__shell__completion"
                ;;
            ruff,help)
                cmd="ruff__help"
                ;;
            ruff,linter)
                cmd="ruff__linter"
                ;;
            ruff,rule)
                cmd="ruff__rule"
                ;;
            ruff,server)
                cmd="ruff__server"
                ;;
            ruff,version)
                cmd="ruff__version"
                ;;
            ruff__help,check)
                cmd="ruff__help__check"
                ;;
            ruff__help,clean)
                cmd="ruff__help__clean"
                ;;
            ruff__help,config)
                cmd="ruff__help__config"
                ;;
            ruff__help,format)
                cmd="ruff__help__format"
                ;;
            ruff__help,generate-shell-completion)
                cmd="ruff__help__generate__shell__completion"
                ;;
            ruff__help,help)
                cmd="ruff__help__help"
                ;;
            ruff__help,linter)
                cmd="ruff__help__linter"
                ;;
            ruff__help,rule)
                cmd="ruff__help__rule"
                ;;
            ruff__help,server)
                cmd="ruff__help__server"
                ;;
            ruff__help,version)
                cmd="ruff__help__version"
                ;;
            *)
                ;;
        esac
    done

    case "${cmd}" in
        ruff)
            opts="-v -q -s -h -V --verbose --quiet --silent --config --isolated --help --version check rule config linter clean generate-shell-completion format server version help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 1 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__check)
            opts="-w -o -n -e -v -q -s -h --fix --no-fix --unsafe-fixes --no-unsafe-fixes --show-source --no-show-source --show-fixes --no-show-fixes --diff --watch --fix-only --no-fix-only --ignore-noqa --output-format --output-file --target-version --preview --no-preview --select --ignore --extend-select --extend-ignore --per-file-ignores --extend-per-file-ignores --exclude --extend-exclude --fixable --unfixable --extend-fixable --extend-unfixable --respect-gitignore --no-respect-gitignore --force-exclude --no-force-exclude --line-length --dummy-variable-rgx --no-cache --cache-dir --stdin-filename --extension --exit-zero --exit-non-zero-on-fix --statistics --add-noqa --show-files --show-settings --ecosystem-ci --verbose --quiet --silent --config --isolated --help [FILES]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --output-format)
                    COMPREPLY=($(compgen -W "text concise full json json-lines junit grouped github gitlab pylint azure sarif" -- "${cur}"))
                    return 0
                    ;;
                --output-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -o)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --target-version)
                    COMPREPLY=($(compgen -W "py37 py38 py39 py310 py311 py312" -- "${cur}"))
                    return 0
                    ;;
                --select)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN ASYNC TRIO S BLE FBT B A COM CPY C4 DTZ T10 DJ EM EXE FA ISC ICN LOG G INP PIE T20 PYI PT Q RSE RET SLF SLOT SIM TID TCH INT ARG PTH TD FIX ERA PD PGH PL TRY FLY NPY AIR PERF FURB RUF AIR001 ERA001 YTT101 YTT102 YTT103 YTT201 YTT202 YTT203 YTT204 YTT301 YTT302 YTT303 ANN001 ANN002 ANN003 ANN101 ANN102 ANN201 ANN202 ANN204 ANN205 ANN206 ANN401 ASYNC100 ASYNC101 ASYNC102 S101 S102 S103 S104 S105 S106 S107 S108 S110 S112 S113 S201 S202 S301 S302 S303 S304 S305 S306 S307 S308 S310 S311 S312 S313 S314 S315 S316 S317 S318 S319 S320 S321 S323 S324 S401 S402 S403 S404 S405 S406 S407 S408 S409 S410 S411 S412 S413 S415 S501 S502 S503 S504 S505 S506 S507 S508 S509 S601 S602 S603 S604 S605 S606 S607 S608 S609 S610 S611 S612 S701 S702 BLE001 FBT001 FBT002 FBT003 B002 B003 B004 B005 B006 B007 B008 B009 B010 B011 B012 B013 B014 B015 B016 B017 B018 B019 B020 B021 B022 B023 B024 B025 B026 B027 B028 B029 B030 B031 B032 B033 B034 B035 B904 B905 B909 A001 A002 A003 COM812 COM818 COM819 C400 C401 C402 C403 C404 C405 C406 C408 C409 C410 C411 C413 C414 C415 C416 C417 C418 C419 CPY001 DTZ001 DTZ002 DTZ003 DTZ004 DTZ005 DTZ006 DTZ007 DTZ011 DTZ012 T100 DJ001 DJ003 DJ006 DJ007 DJ008 DJ012 DJ013 EM101 EM102 EM103 EXE001 EXE002 EXE003 EXE004 EXE005 FIX001 FIX002 FIX003 FIX004 FA100 FA102 INT001 INT002 INT003 ISC001 ISC002 ISC003 ICN001 ICN002 ICN003 LOG001 LOG002 LOG007 LOG009 G001 G002 G003 G004 G010 G101 G201 G202 INP001 PIE790 PIE794 PIE796 PIE800 PIE804 PIE807 PIE808 PIE810 T201 T203 PYI001 PYI002 PYI003 PYI004 PYI005 PYI006 PYI007 PYI008 PYI009 PYI010 PYI011 PYI012 PYI013 PYI014 PYI015 PYI016 PYI017 PYI018 PYI019 PYI020 PYI021 PYI024 PYI025 PYI026 PYI029 PYI030 PYI032 PYI033 PYI034 PYI035 PYI036 PYI041 PYI042 PYI043 PYI044 PYI045 PYI046 PYI047 PYI048 PYI049 PYI050 PYI051 PYI052 PYI053 PYI054 PYI055 PYI056 PYI058 PT001 PT002 PT003 PT004 PT005 PT006 PT007 PT008 PT009 PT010 PT011 PT012 PT013 PT014 PT015 PT016 PT017 PT018 PT019 PT020 PT021 PT022 PT023 PT024 PT025 PT026 PT027 Q000 Q001 Q002 Q003 Q004 RSE102 RET501 RET502 RET503 RET504 RET505 RET506 RET507 RET508 SLF001 SIM101 SIM102 SIM103 SIM105 SIM107 SIM108 SIM109 SIM110 SIM112 SIM113 SIM114 SIM115 SIM116 SIM117 SIM118 SIM201 SIM202 SIM208 SIM210 SIM211 SIM212 SIM220 SIM221 SIM222 SIM223 SIM300 SIM401 SIM910 SIM911 SLOT000 SLOT001 SLOT002 TID251 TID252 TID253 TD001 TD002 TD003 TD004 TD005 TD006 TD007 TRIO100 TRIO105 TRIO109 TRIO110 TRIO115 TCH001 TCH002 TCH003 TCH004 TCH005 TCH010 ARG001 ARG002 ARG003 ARG004 ARG005 PTH100 PTH101 PTH102 PTH103 PTH104 PTH105 PTH106 PTH107 PTH108 PTH109 PTH110 PTH111 PTH112 PTH113 PTH114 PTH115 PTH116 PTH117 PTH118 PTH119 PTH120 PTH121 PTH122 PTH123 PTH124 PTH201 PTH202 PTH203 PTH204 PTH205 PTH206 PTH207 FLY002 I001 I002 C901 NPY001 NPY002 NPY003 NPY201 N801 N802 N803 N804 N805 N806 N807 N811 N812 N813 N814 N815 N816 N817 N818 N999 PD002 PD003 PD004 PD007 PD008 PD009 PD010 PD011 PD012 PD013 PD015 PD101 PD901 PERF101 PERF102 PERF203 PERF401 PERF402 PERF403 E101 E111 E112 E113 E114 E115 E116 E117 E201 E202 E203 E211 E221 E222 E223 E224 E225 E226 E227 E228 E231 E241 E242 E251 E252 E261 E262 E265 E266 E271 E272 E273 E274 E275 E301 E302 E303 E304 E305 E306 E401 E402 E501 E502 E701 E702 E703 E711 E712 E713 E714 E721 E722 E731 E741 E742 E743 E902 E999 W191 W291 W292 W293 W391 W505 W605 D100 D101 D102 D103 D104 D105 D106 D107 D200 D201 D202 D203 D204 D205 D206 D207 D208 D209 D210 D211 D212 D213 D214 D215 D300 D301 D400 D401 D402 D403 D404 D405 D406 D407 D408 D409 D410 D411 D412 D413 D414 D415 D416 D417 D418 D419 F401 F402 F403 F404 F405 F406 F407 F501 F502 F503 F504 F505 F506 F507 F508 F509 F521 F522 F523 F524 F525 F541 F601 F602 F621 F622 F631 F632 F633 F634 F701 F702 F704 F706 F707 F722 F811 F821 F822 F823 F841 F842 F901 PGH001 PGH002 PGH003 PGH004 PGH005 PLC0105 PLC0131 PLC0132 PLC0205 PLC0208 PLC0414 PLC0415 PLC1901 PLC2401 PLC2403 PLC2701 PLC2801 PLC3002 PLE0100 PLE0101 PLE0115 PLE0116 PLE0117 PLE0118 PLE0237 PLE0241 PLE0302 PLE0303 PLE0304 PLE0305 PLE0307 PLE0308 PLE0309 PLE0604 PLE0605 PLE0643 PLE0704 PLE1132 PLE1141 PLE1142 PLE1205 PLE1206 PLE1300 PLE1307 PLE1310 PLE1507 PLE1519 PLE1520 PLE1700 PLE2502 PLE2510 PLE2512 PLE2513 PLE2514 PLE2515 PLE4703 PLR0124 PLR0133 PLR0202 PLR0203 PLR0206 PLR0402 PLR0904 PLR0911 PLR0912 PLR0913 PLR0914 PLR0915 PLR0916 PLR0917 PLR1701 PLR1702 PLR1704 PLR1706 PLR1711 PLR1714 PLR1722 PLR1730 PLR1733 PLR1736 PLR2004 PLR2044 PLR5501 PLR6104 PLR6201 PLR6301 PLW0108 PLW0120 PLW0127 PLW0128 PLW0129 PLW0131 PLW0133 PLW0177 PLW0211 PLW0245 PLW0406 PLW0602 PLW0603 PLW0604 PLW0642 PLW0711 PLW1501 PLW1508 PLW1509 PLW1510 PLW1514 PLW1641 PLW2101 PLW2901 PLW3201 PLW3301 UP001 UP003 UP004 UP005 UP006 UP007 UP008 UP009 UP010 UP011 UP012 UP013 UP014 UP015 UP017 UP018 UP019 UP020 UP021 UP022 UP023 UP024 UP025 UP026 UP027 UP028 UP029 UP030 UP031 UP032 UP033 UP034 UP035 UP036 UP037 UP038 UP039 UP040 UP041 UP042 FURB101 FURB103 FURB105 FURB110 FURB113 FURB116 FURB118 FURB129 FURB131 FURB132 FURB136 FURB140 FURB142 FURB145 FURB148 FURB152 FURB157 FURB161 FURB163 FURB164 FURB166 FURB167 FURB168 FURB169 FURB171 FURB177 FURB180 FURB181 FURB187 FURB192 RUF001 RUF002 RUF003 RUF005 RUF006 RUF007 RUF008 RUF009 RUF010 RUF011 RUF012 RUF013 RUF015 RUF016 RUF017 RUF018 RUF019 RUF020 RUF021 RUF022 RUF023 RUF024 RUF025 RUF026 RUF027 RUF028 RUF029 RUF100 RUF101 RUF200 TRY002 TRY003 TRY004 TRY200 TRY201 TRY300 TRY301 TRY302 TRY400 TRY401" -- "${cur}"))
                    return 0
                    ;;
                --ignore)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN ASYNC TRIO S BLE FBT B A COM CPY C4 DTZ T10 DJ EM EXE FA ISC ICN LOG G INP PIE T20 PYI PT Q RSE RET SLF SLOT SIM TID TCH INT ARG PTH TD FIX ERA PD PGH PL TRY FLY NPY AIR PERF FURB RUF AIR001 ERA001 YTT101 YTT102 YTT103 YTT201 YTT202 YTT203 YTT204 YTT301 YTT302 YTT303 ANN001 ANN002 ANN003 ANN101 ANN102 ANN201 ANN202 ANN204 ANN205 ANN206 ANN401 ASYNC100 ASYNC101 ASYNC102 S101 S102 S103 S104 S105 S106 S107 S108 S110 S112 S113 S201 S202 S301 S302 S303 S304 S305 S306 S307 S308 S310 S311 S312 S313 S314 S315 S316 S317 S318 S319 S320 S321 S323 S324 S401 S402 S403 S404 S405 S406 S407 S408 S409 S410 S411 S412 S413 S415 S501 S502 S503 S504 S505 S506 S507 S508 S509 S601 S602 S603 S604 S605 S606 S607 S608 S609 S610 S611 S612 S701 S702 BLE001 FBT001 FBT002 FBT003 B002 B003 B004 B005 B006 B007 B008 B009 B010 B011 B012 B013 B014 B015 B016 B017 B018 B019 B020 B021 B022 B023 B024 B025 B026 B027 B028 B029 B030 B031 B032 B033 B034 B035 B904 B905 B909 A001 A002 A003 COM812 COM818 COM819 C400 C401 C402 C403 C404 C405 C406 C408 C409 C410 C411 C413 C414 C415 C416 C417 C418 C419 CPY001 DTZ001 DTZ002 DTZ003 DTZ004 DTZ005 DTZ006 DTZ007 DTZ011 DTZ012 T100 DJ001 DJ003 DJ006 DJ007 DJ008 DJ012 DJ013 EM101 EM102 EM103 EXE001 EXE002 EXE003 EXE004 EXE005 FIX001 FIX002 FIX003 FIX004 FA100 FA102 INT001 INT002 INT003 ISC001 ISC002 ISC003 ICN001 ICN002 ICN003 LOG001 LOG002 LOG007 LOG009 G001 G002 G003 G004 G010 G101 G201 G202 INP001 PIE790 PIE794 PIE796 PIE800 PIE804 PIE807 PIE808 PIE810 T201 T203 PYI001 PYI002 PYI003 PYI004 PYI005 PYI006 PYI007 PYI008 PYI009 PYI010 PYI011 PYI012 PYI013 PYI014 PYI015 PYI016 PYI017 PYI018 PYI019 PYI020 PYI021 PYI024 PYI025 PYI026 PYI029 PYI030 PYI032 PYI033 PYI034 PYI035 PYI036 PYI041 PYI042 PYI043 PYI044 PYI045 PYI046 PYI047 PYI048 PYI049 PYI050 PYI051 PYI052 PYI053 PYI054 PYI055 PYI056 PYI058 PT001 PT002 PT003 PT004 PT005 PT006 PT007 PT008 PT009 PT010 PT011 PT012 PT013 PT014 PT015 PT016 PT017 PT018 PT019 PT020 PT021 PT022 PT023 PT024 PT025 PT026 PT027 Q000 Q001 Q002 Q003 Q004 RSE102 RET501 RET502 RET503 RET504 RET505 RET506 RET507 RET508 SLF001 SIM101 SIM102 SIM103 SIM105 SIM107 SIM108 SIM109 SIM110 SIM112 SIM113 SIM114 SIM115 SIM116 SIM117 SIM118 SIM201 SIM202 SIM208 SIM210 SIM211 SIM212 SIM220 SIM221 SIM222 SIM223 SIM300 SIM401 SIM910 SIM911 SLOT000 SLOT001 SLOT002 TID251 TID252 TID253 TD001 TD002 TD003 TD004 TD005 TD006 TD007 TRIO100 TRIO105 TRIO109 TRIO110 TRIO115 TCH001 TCH002 TCH003 TCH004 TCH005 TCH010 ARG001 ARG002 ARG003 ARG004 ARG005 PTH100 PTH101 PTH102 PTH103 PTH104 PTH105 PTH106 PTH107 PTH108 PTH109 PTH110 PTH111 PTH112 PTH113 PTH114 PTH115 PTH116 PTH117 PTH118 PTH119 PTH120 PTH121 PTH122 PTH123 PTH124 PTH201 PTH202 PTH203 PTH204 PTH205 PTH206 PTH207 FLY002 I001 I002 C901 NPY001 NPY002 NPY003 NPY201 N801 N802 N803 N804 N805 N806 N807 N811 N812 N813 N814 N815 N816 N817 N818 N999 PD002 PD003 PD004 PD007 PD008 PD009 PD010 PD011 PD012 PD013 PD015 PD101 PD901 PERF101 PERF102 PERF203 PERF401 PERF402 PERF403 E101 E111 E112 E113 E114 E115 E116 E117 E201 E202 E203 E211 E221 E222 E223 E224 E225 E226 E227 E228 E231 E241 E242 E251 E252 E261 E262 E265 E266 E271 E272 E273 E274 E275 E301 E302 E303 E304 E305 E306 E401 E402 E501 E502 E701 E702 E703 E711 E712 E713 E714 E721 E722 E731 E741 E742 E743 E902 E999 W191 W291 W292 W293 W391 W505 W605 D100 D101 D102 D103 D104 D105 D106 D107 D200 D201 D202 D203 D204 D205 D206 D207 D208 D209 D210 D211 D212 D213 D214 D215 D300 D301 D400 D401 D402 D403 D404 D405 D406 D407 D408 D409 D410 D411 D412 D413 D414 D415 D416 D417 D418 D419 F401 F402 F403 F404 F405 F406 F407 F501 F502 F503 F504 F505 F506 F507 F508 F509 F521 F522 F523 F524 F525 F541 F601 F602 F621 F622 F631 F632 F633 F634 F701 F702 F704 F706 F707 F722 F811 F821 F822 F823 F841 F842 F901 PGH001 PGH002 PGH003 PGH004 PGH005 PLC0105 PLC0131 PLC0132 PLC0205 PLC0208 PLC0414 PLC0415 PLC1901 PLC2401 PLC2403 PLC2701 PLC2801 PLC3002 PLE0100 PLE0101 PLE0115 PLE0116 PLE0117 PLE0118 PLE0237 PLE0241 PLE0302 PLE0303 PLE0304 PLE0305 PLE0307 PLE0308 PLE0309 PLE0604 PLE0605 PLE0643 PLE0704 PLE1132 PLE1141 PLE1142 PLE1205 PLE1206 PLE1300 PLE1307 PLE1310 PLE1507 PLE1519 PLE1520 PLE1700 PLE2502 PLE2510 PLE2512 PLE2513 PLE2514 PLE2515 PLE4703 PLR0124 PLR0133 PLR0202 PLR0203 PLR0206 PLR0402 PLR0904 PLR0911 PLR0912 PLR0913 PLR0914 PLR0915 PLR0916 PLR0917 PLR1701 PLR1702 PLR1704 PLR1706 PLR1711 PLR1714 PLR1722 PLR1730 PLR1733 PLR1736 PLR2004 PLR2044 PLR5501 PLR6104 PLR6201 PLR6301 PLW0108 PLW0120 PLW0127 PLW0128 PLW0129 PLW0131 PLW0133 PLW0177 PLW0211 PLW0245 PLW0406 PLW0602 PLW0603 PLW0604 PLW0642 PLW0711 PLW1501 PLW1508 PLW1509 PLW1510 PLW1514 PLW1641 PLW2101 PLW2901 PLW3201 PLW3301 UP001 UP003 UP004 UP005 UP006 UP007 UP008 UP009 UP010 UP011 UP012 UP013 UP014 UP015 UP017 UP018 UP019 UP020 UP021 UP022 UP023 UP024 UP025 UP026 UP027 UP028 UP029 UP030 UP031 UP032 UP033 UP034 UP035 UP036 UP037 UP038 UP039 UP040 UP041 UP042 FURB101 FURB103 FURB105 FURB110 FURB113 FURB116 FURB118 FURB129 FURB131 FURB132 FURB136 FURB140 FURB142 FURB145 FURB148 FURB152 FURB157 FURB161 FURB163 FURB164 FURB166 FURB167 FURB168 FURB169 FURB171 FURB177 FURB180 FURB181 FURB187 FURB192 RUF001 RUF002 RUF003 RUF005 RUF006 RUF007 RUF008 RUF009 RUF010 RUF011 RUF012 RUF013 RUF015 RUF016 RUF017 RUF018 RUF019 RUF020 RUF021 RUF022 RUF023 RUF024 RUF025 RUF026 RUF027 RUF028 RUF029 RUF100 RUF101 RUF200 TRY002 TRY003 TRY004 TRY200 TRY201 TRY300 TRY301 TRY302 TRY400 TRY401" -- "${cur}"))
                    return 0
                    ;;
                --extend-select)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN ASYNC TRIO S BLE FBT B A COM CPY C4 DTZ T10 DJ EM EXE FA ISC ICN LOG G INP PIE T20 PYI PT Q RSE RET SLF SLOT SIM TID TCH INT ARG PTH TD FIX ERA PD PGH PL TRY FLY NPY AIR PERF FURB RUF AIR001 ERA001 YTT101 YTT102 YTT103 YTT201 YTT202 YTT203 YTT204 YTT301 YTT302 YTT303 ANN001 ANN002 ANN003 ANN101 ANN102 ANN201 ANN202 ANN204 ANN205 ANN206 ANN401 ASYNC100 ASYNC101 ASYNC102 S101 S102 S103 S104 S105 S106 S107 S108 S110 S112 S113 S201 S202 S301 S302 S303 S304 S305 S306 S307 S308 S310 S311 S312 S313 S314 S315 S316 S317 S318 S319 S320 S321 S323 S324 S401 S402 S403 S404 S405 S406 S407 S408 S409 S410 S411 S412 S413 S415 S501 S502 S503 S504 S505 S506 S507 S508 S509 S601 S602 S603 S604 S605 S606 S607 S608 S609 S610 S611 S612 S701 S702 BLE001 FBT001 FBT002 FBT003 B002 B003 B004 B005 B006 B007 B008 B009 B010 B011 B012 B013 B014 B015 B016 B017 B018 B019 B020 B021 B022 B023 B024 B025 B026 B027 B028 B029 B030 B031 B032 B033 B034 B035 B904 B905 B909 A001 A002 A003 COM812 COM818 COM819 C400 C401 C402 C403 C404 C405 C406 C408 C409 C410 C411 C413 C414 C415 C416 C417 C418 C419 CPY001 DTZ001 DTZ002 DTZ003 DTZ004 DTZ005 DTZ006 DTZ007 DTZ011 DTZ012 T100 DJ001 DJ003 DJ006 DJ007 DJ008 DJ012 DJ013 EM101 EM102 EM103 EXE001 EXE002 EXE003 EXE004 EXE005 FIX001 FIX002 FIX003 FIX004 FA100 FA102 INT001 INT002 INT003 ISC001 ISC002 ISC003 ICN001 ICN002 ICN003 LOG001 LOG002 LOG007 LOG009 G001 G002 G003 G004 G010 G101 G201 G202 INP001 PIE790 PIE794 PIE796 PIE800 PIE804 PIE807 PIE808 PIE810 T201 T203 PYI001 PYI002 PYI003 PYI004 PYI005 PYI006 PYI007 PYI008 PYI009 PYI010 PYI011 PYI012 PYI013 PYI014 PYI015 PYI016 PYI017 PYI018 PYI019 PYI020 PYI021 PYI024 PYI025 PYI026 PYI029 PYI030 PYI032 PYI033 PYI034 PYI035 PYI036 PYI041 PYI042 PYI043 PYI044 PYI045 PYI046 PYI047 PYI048 PYI049 PYI050 PYI051 PYI052 PYI053 PYI054 PYI055 PYI056 PYI058 PT001 PT002 PT003 PT004 PT005 PT006 PT007 PT008 PT009 PT010 PT011 PT012 PT013 PT014 PT015 PT016 PT017 PT018 PT019 PT020 PT021 PT022 PT023 PT024 PT025 PT026 PT027 Q000 Q001 Q002 Q003 Q004 RSE102 RET501 RET502 RET503 RET504 RET505 RET506 RET507 RET508 SLF001 SIM101 SIM102 SIM103 SIM105 SIM107 SIM108 SIM109 SIM110 SIM112 SIM113 SIM114 SIM115 SIM116 SIM117 SIM118 SIM201 SIM202 SIM208 SIM210 SIM211 SIM212 SIM220 SIM221 SIM222 SIM223 SIM300 SIM401 SIM910 SIM911 SLOT000 SLOT001 SLOT002 TID251 TID252 TID253 TD001 TD002 TD003 TD004 TD005 TD006 TD007 TRIO100 TRIO105 TRIO109 TRIO110 TRIO115 TCH001 TCH002 TCH003 TCH004 TCH005 TCH010 ARG001 ARG002 ARG003 ARG004 ARG005 PTH100 PTH101 PTH102 PTH103 PTH104 PTH105 PTH106 PTH107 PTH108 PTH109 PTH110 PTH111 PTH112 PTH113 PTH114 PTH115 PTH116 PTH117 PTH118 PTH119 PTH120 PTH121 PTH122 PTH123 PTH124 PTH201 PTH202 PTH203 PTH204 PTH205 PTH206 PTH207 FLY002 I001 I002 C901 NPY001 NPY002 NPY003 NPY201 N801 N802 N803 N804 N805 N806 N807 N811 N812 N813 N814 N815 N816 N817 N818 N999 PD002 PD003 PD004 PD007 PD008 PD009 PD010 PD011 PD012 PD013 PD015 PD101 PD901 PERF101 PERF102 PERF203 PERF401 PERF402 PERF403 E101 E111 E112 E113 E114 E115 E116 E117 E201 E202 E203 E211 E221 E222 E223 E224 E225 E226 E227 E228 E231 E241 E242 E251 E252 E261 E262 E265 E266 E271 E272 E273 E274 E275 E301 E302 E303 E304 E305 E306 E401 E402 E501 E502 E701 E702 E703 E711 E712 E713 E714 E721 E722 E731 E741 E742 E743 E902 E999 W191 W291 W292 W293 W391 W505 W605 D100 D101 D102 D103 D104 D105 D106 D107 D200 D201 D202 D203 D204 D205 D206 D207 D208 D209 D210 D211 D212 D213 D214 D215 D300 D301 D400 D401 D402 D403 D404 D405 D406 D407 D408 D409 D410 D411 D412 D413 D414 D415 D416 D417 D418 D419 F401 F402 F403 F404 F405 F406 F407 F501 F502 F503 F504 F505 F506 F507 F508 F509 F521 F522 F523 F524 F525 F541 F601 F602 F621 F622 F631 F632 F633 F634 F701 F702 F704 F706 F707 F722 F811 F821 F822 F823 F841 F842 F901 PGH001 PGH002 PGH003 PGH004 PGH005 PLC0105 PLC0131 PLC0132 PLC0205 PLC0208 PLC0414 PLC0415 PLC1901 PLC2401 PLC2403 PLC2701 PLC2801 PLC3002 PLE0100 PLE0101 PLE0115 PLE0116 PLE0117 PLE0118 PLE0237 PLE0241 PLE0302 PLE0303 PLE0304 PLE0305 PLE0307 PLE0308 PLE0309 PLE0604 PLE0605 PLE0643 PLE0704 PLE1132 PLE1141 PLE1142 PLE1205 PLE1206 PLE1300 PLE1307 PLE1310 PLE1507 PLE1519 PLE1520 PLE1700 PLE2502 PLE2510 PLE2512 PLE2513 PLE2514 PLE2515 PLE4703 PLR0124 PLR0133 PLR0202 PLR0203 PLR0206 PLR0402 PLR0904 PLR0911 PLR0912 PLR0913 PLR0914 PLR0915 PLR0916 PLR0917 PLR1701 PLR1702 PLR1704 PLR1706 PLR1711 PLR1714 PLR1722 PLR1730 PLR1733 PLR1736 PLR2004 PLR2044 PLR5501 PLR6104 PLR6201 PLR6301 PLW0108 PLW0120 PLW0127 PLW0128 PLW0129 PLW0131 PLW0133 PLW0177 PLW0211 PLW0245 PLW0406 PLW0602 PLW0603 PLW0604 PLW0642 PLW0711 PLW1501 PLW1508 PLW1509 PLW1510 PLW1514 PLW1641 PLW2101 PLW2901 PLW3201 PLW3301 UP001 UP003 UP004 UP005 UP006 UP007 UP008 UP009 UP010 UP011 UP012 UP013 UP014 UP015 UP017 UP018 UP019 UP020 UP021 UP022 UP023 UP024 UP025 UP026 UP027 UP028 UP029 UP030 UP031 UP032 UP033 UP034 UP035 UP036 UP037 UP038 UP039 UP040 UP041 UP042 FURB101 FURB103 FURB105 FURB110 FURB113 FURB116 FURB118 FURB129 FURB131 FURB132 FURB136 FURB140 FURB142 FURB145 FURB148 FURB152 FURB157 FURB161 FURB163 FURB164 FURB166 FURB167 FURB168 FURB169 FURB171 FURB177 FURB180 FURB181 FURB187 FURB192 RUF001 RUF002 RUF003 RUF005 RUF006 RUF007 RUF008 RUF009 RUF010 RUF011 RUF012 RUF013 RUF015 RUF016 RUF017 RUF018 RUF019 RUF020 RUF021 RUF022 RUF023 RUF024 RUF025 RUF026 RUF027 RUF028 RUF029 RUF100 RUF101 RUF200 TRY002 TRY003 TRY004 TRY200 TRY201 TRY300 TRY301 TRY302 TRY400 TRY401" -- "${cur}"))
                    return 0
                    ;;
                --extend-ignore)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN ASYNC TRIO S BLE FBT B A COM CPY C4 DTZ T10 DJ EM EXE FA ISC ICN LOG G INP PIE T20 PYI PT Q RSE RET SLF SLOT SIM TID TCH INT ARG PTH TD FIX ERA PD PGH PL TRY FLY NPY AIR PERF FURB RUF AIR001 ERA001 YTT101 YTT102 YTT103 YTT201 YTT202 YTT203 YTT204 YTT301 YTT302 YTT303 ANN001 ANN002 ANN003 ANN101 ANN102 ANN201 ANN202 ANN204 ANN205 ANN206 ANN401 ASYNC100 ASYNC101 ASYNC102 S101 S102 S103 S104 S105 S106 S107 S108 S110 S112 S113 S201 S202 S301 S302 S303 S304 S305 S306 S307 S308 S310 S311 S312 S313 S314 S315 S316 S317 S318 S319 S320 S321 S323 S324 S401 S402 S403 S404 S405 S406 S407 S408 S409 S410 S411 S412 S413 S415 S501 S502 S503 S504 S505 S506 S507 S508 S509 S601 S602 S603 S604 S605 S606 S607 S608 S609 S610 S611 S612 S701 S702 BLE001 FBT001 FBT002 FBT003 B002 B003 B004 B005 B006 B007 B008 B009 B010 B011 B012 B013 B014 B015 B016 B017 B018 B019 B020 B021 B022 B023 B024 B025 B026 B027 B028 B029 B030 B031 B032 B033 B034 B035 B904 B905 B909 A001 A002 A003 COM812 COM818 COM819 C400 C401 C402 C403 C404 C405 C406 C408 C409 C410 C411 C413 C414 C415 C416 C417 C418 C419 CPY001 DTZ001 DTZ002 DTZ003 DTZ004 DTZ005 DTZ006 DTZ007 DTZ011 DTZ012 T100 DJ001 DJ003 DJ006 DJ007 DJ008 DJ012 DJ013 EM101 EM102 EM103 EXE001 EXE002 EXE003 EXE004 EXE005 FIX001 FIX002 FIX003 FIX004 FA100 FA102 INT001 INT002 INT003 ISC001 ISC002 ISC003 ICN001 ICN002 ICN003 LOG001 LOG002 LOG007 LOG009 G001 G002 G003 G004 G010 G101 G201 G202 INP001 PIE790 PIE794 PIE796 PIE800 PIE804 PIE807 PIE808 PIE810 T201 T203 PYI001 PYI002 PYI003 PYI004 PYI005 PYI006 PYI007 PYI008 PYI009 PYI010 PYI011 PYI012 PYI013 PYI014 PYI015 PYI016 PYI017 PYI018 PYI019 PYI020 PYI021 PYI024 PYI025 PYI026 PYI029 PYI030 PYI032 PYI033 PYI034 PYI035 PYI036 PYI041 PYI042 PYI043 PYI044 PYI045 PYI046 PYI047 PYI048 PYI049 PYI050 PYI051 PYI052 PYI053 PYI054 PYI055 PYI056 PYI058 PT001 PT002 PT003 PT004 PT005 PT006 PT007 PT008 PT009 PT010 PT011 PT012 PT013 PT014 PT015 PT016 PT017 PT018 PT019 PT020 PT021 PT022 PT023 PT024 PT025 PT026 PT027 Q000 Q001 Q002 Q003 Q004 RSE102 RET501 RET502 RET503 RET504 RET505 RET506 RET507 RET508 SLF001 SIM101 SIM102 SIM103 SIM105 SIM107 SIM108 SIM109 SIM110 SIM112 SIM113 SIM114 SIM115 SIM116 SIM117 SIM118 SIM201 SIM202 SIM208 SIM210 SIM211 SIM212 SIM220 SIM221 SIM222 SIM223 SIM300 SIM401 SIM910 SIM911 SLOT000 SLOT001 SLOT002 TID251 TID252 TID253 TD001 TD002 TD003 TD004 TD005 TD006 TD007 TRIO100 TRIO105 TRIO109 TRIO110 TRIO115 TCH001 TCH002 TCH003 TCH004 TCH005 TCH010 ARG001 ARG002 ARG003 ARG004 ARG005 PTH100 PTH101 PTH102 PTH103 PTH104 PTH105 PTH106 PTH107 PTH108 PTH109 PTH110 PTH111 PTH112 PTH113 PTH114 PTH115 PTH116 PTH117 PTH118 PTH119 PTH120 PTH121 PTH122 PTH123 PTH124 PTH201 PTH202 PTH203 PTH204 PTH205 PTH206 PTH207 FLY002 I001 I002 C901 NPY001 NPY002 NPY003 NPY201 N801 N802 N803 N804 N805 N806 N807 N811 N812 N813 N814 N815 N816 N817 N818 N999 PD002 PD003 PD004 PD007 PD008 PD009 PD010 PD011 PD012 PD013 PD015 PD101 PD901 PERF101 PERF102 PERF203 PERF401 PERF402 PERF403 E101 E111 E112 E113 E114 E115 E116 E117 E201 E202 E203 E211 E221 E222 E223 E224 E225 E226 E227 E228 E231 E241 E242 E251 E252 E261 E262 E265 E266 E271 E272 E273 E274 E275 E301 E302 E303 E304 E305 E306 E401 E402 E501 E502 E701 E702 E703 E711 E712 E713 E714 E721 E722 E731 E741 E742 E743 E902 E999 W191 W291 W292 W293 W391 W505 W605 D100 D101 D102 D103 D104 D105 D106 D107 D200 D201 D202 D203 D204 D205 D206 D207 D208 D209 D210 D211 D212 D213 D214 D215 D300 D301 D400 D401 D402 D403 D404 D405 D406 D407 D408 D409 D410 D411 D412 D413 D414 D415 D416 D417 D418 D419 F401 F402 F403 F404 F405 F406 F407 F501 F502 F503 F504 F505 F506 F507 F508 F509 F521 F522 F523 F524 F525 F541 F601 F602 F621 F622 F631 F632 F633 F634 F701 F702 F704 F706 F707 F722 F811 F821 F822 F823 F841 F842 F901 PGH001 PGH002 PGH003 PGH004 PGH005 PLC0105 PLC0131 PLC0132 PLC0205 PLC0208 PLC0414 PLC0415 PLC1901 PLC2401 PLC2403 PLC2701 PLC2801 PLC3002 PLE0100 PLE0101 PLE0115 PLE0116 PLE0117 PLE0118 PLE0237 PLE0241 PLE0302 PLE0303 PLE0304 PLE0305 PLE0307 PLE0308 PLE0309 PLE0604 PLE0605 PLE0643 PLE0704 PLE1132 PLE1141 PLE1142 PLE1205 PLE1206 PLE1300 PLE1307 PLE1310 PLE1507 PLE1519 PLE1520 PLE1700 PLE2502 PLE2510 PLE2512 PLE2513 PLE2514 PLE2515 PLE4703 PLR0124 PLR0133 PLR0202 PLR0203 PLR0206 PLR0402 PLR0904 PLR0911 PLR0912 PLR0913 PLR0914 PLR0915 PLR0916 PLR0917 PLR1701 PLR1702 PLR1704 PLR1706 PLR1711 PLR1714 PLR1722 PLR1730 PLR1733 PLR1736 PLR2004 PLR2044 PLR5501 PLR6104 PLR6201 PLR6301 PLW0108 PLW0120 PLW0127 PLW0128 PLW0129 PLW0131 PLW0133 PLW0177 PLW0211 PLW0245 PLW0406 PLW0602 PLW0603 PLW0604 PLW0642 PLW0711 PLW1501 PLW1508 PLW1509 PLW1510 PLW1514 PLW1641 PLW2101 PLW2901 PLW3201 PLW3301 UP001 UP003 UP004 UP005 UP006 UP007 UP008 UP009 UP010 UP011 UP012 UP013 UP014 UP015 UP017 UP018 UP019 UP020 UP021 UP022 UP023 UP024 UP025 UP026 UP027 UP028 UP029 UP030 UP031 UP032 UP033 UP034 UP035 UP036 UP037 UP038 UP039 UP040 UP041 UP042 FURB101 FURB103 FURB105 FURB110 FURB113 FURB116 FURB118 FURB129 FURB131 FURB132 FURB136 FURB140 FURB142 FURB145 FURB148 FURB152 FURB157 FURB161 FURB163 FURB164 FURB166 FURB167 FURB168 FURB169 FURB171 FURB177 FURB180 FURB181 FURB187 FURB192 RUF001 RUF002 RUF003 RUF005 RUF006 RUF007 RUF008 RUF009 RUF010 RUF011 RUF012 RUF013 RUF015 RUF016 RUF017 RUF018 RUF019 RUF020 RUF021 RUF022 RUF023 RUF024 RUF025 RUF026 RUF027 RUF028 RUF029 RUF100 RUF101 RUF200 TRY002 TRY003 TRY004 TRY200 TRY201 TRY300 TRY301 TRY302 TRY400 TRY401" -- "${cur}"))
                    return 0
                    ;;
                --per-file-ignores)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --extend-per-file-ignores)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --exclude)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --extend-exclude)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --fixable)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN ASYNC TRIO S BLE FBT B A COM CPY C4 DTZ T10 DJ EM EXE FA ISC ICN LOG G INP PIE T20 PYI PT Q RSE RET SLF SLOT SIM TID TCH INT ARG PTH TD FIX ERA PD PGH PL TRY FLY NPY AIR PERF FURB RUF AIR001 ERA001 YTT101 YTT102 YTT103 YTT201 YTT202 YTT203 YTT204 YTT301 YTT302 YTT303 ANN001 ANN002 ANN003 ANN101 ANN102 ANN201 ANN202 ANN204 ANN205 ANN206 ANN401 ASYNC100 ASYNC101 ASYNC102 S101 S102 S103 S104 S105 S106 S107 S108 S110 S112 S113 S201 S202 S301 S302 S303 S304 S305 S306 S307 S308 S310 S311 S312 S313 S314 S315 S316 S317 S318 S319 S320 S321 S323 S324 S401 S402 S403 S404 S405 S406 S407 S408 S409 S410 S411 S412 S413 S415 S501 S502 S503 S504 S505 S506 S507 S508 S509 S601 S602 S603 S604 S605 S606 S607 S608 S609 S610 S611 S612 S701 S702 BLE001 FBT001 FBT002 FBT003 B002 B003 B004 B005 B006 B007 B008 B009 B010 B011 B012 B013 B014 B015 B016 B017 B018 B019 B020 B021 B022 B023 B024 B025 B026 B027 B028 B029 B030 B031 B032 B033 B034 B035 B904 B905 B909 A001 A002 A003 COM812 COM818 COM819 C400 C401 C402 C403 C404 C405 C406 C408 C409 C410 C411 C413 C414 C415 C416 C417 C418 C419 CPY001 DTZ001 DTZ002 DTZ003 DTZ004 DTZ005 DTZ006 DTZ007 DTZ011 DTZ012 T100 DJ001 DJ003 DJ006 DJ007 DJ008 DJ012 DJ013 EM101 EM102 EM103 EXE001 EXE002 EXE003 EXE004 EXE005 FIX001 FIX002 FIX003 FIX004 FA100 FA102 INT001 INT002 INT003 ISC001 ISC002 ISC003 ICN001 ICN002 ICN003 LOG001 LOG002 LOG007 LOG009 G001 G002 G003 G004 G010 G101 G201 G202 INP001 PIE790 PIE794 PIE796 PIE800 PIE804 PIE807 PIE808 PIE810 T201 T203 PYI001 PYI002 PYI003 PYI004 PYI005 PYI006 PYI007 PYI008 PYI009 PYI010 PYI011 PYI012 PYI013 PYI014 PYI015 PYI016 PYI017 PYI018 PYI019 PYI020 PYI021 PYI024 PYI025 PYI026 PYI029 PYI030 PYI032 PYI033 PYI034 PYI035 PYI036 PYI041 PYI042 PYI043 PYI044 PYI045 PYI046 PYI047 PYI048 PYI049 PYI050 PYI051 PYI052 PYI053 PYI054 PYI055 PYI056 PYI058 PT001 PT002 PT003 PT004 PT005 PT006 PT007 PT008 PT009 PT010 PT011 PT012 PT013 PT014 PT015 PT016 PT017 PT018 PT019 PT020 PT021 PT022 PT023 PT024 PT025 PT026 PT027 Q000 Q001 Q002 Q003 Q004 RSE102 RET501 RET502 RET503 RET504 RET505 RET506 RET507 RET508 SLF001 SIM101 SIM102 SIM103 SIM105 SIM107 SIM108 SIM109 SIM110 SIM112 SIM113 SIM114 SIM115 SIM116 SIM117 SIM118 SIM201 SIM202 SIM208 SIM210 SIM211 SIM212 SIM220 SIM221 SIM222 SIM223 SIM300 SIM401 SIM910 SIM911 SLOT000 SLOT001 SLOT002 TID251 TID252 TID253 TD001 TD002 TD003 TD004 TD005 TD006 TD007 TRIO100 TRIO105 TRIO109 TRIO110 TRIO115 TCH001 TCH002 TCH003 TCH004 TCH005 TCH010 ARG001 ARG002 ARG003 ARG004 ARG005 PTH100 PTH101 PTH102 PTH103 PTH104 PTH105 PTH106 PTH107 PTH108 PTH109 PTH110 PTH111 PTH112 PTH113 PTH114 PTH115 PTH116 PTH117 PTH118 PTH119 PTH120 PTH121 PTH122 PTH123 PTH124 PTH201 PTH202 PTH203 PTH204 PTH205 PTH206 PTH207 FLY002 I001 I002 C901 NPY001 NPY002 NPY003 NPY201 N801 N802 N803 N804 N805 N806 N807 N811 N812 N813 N814 N815 N816 N817 N818 N999 PD002 PD003 PD004 PD007 PD008 PD009 PD010 PD011 PD012 PD013 PD015 PD101 PD901 PERF101 PERF102 PERF203 PERF401 PERF402 PERF403 E101 E111 E112 E113 E114 E115 E116 E117 E201 E202 E203 E211 E221 E222 E223 E224 E225 E226 E227 E228 E231 E241 E242 E251 E252 E261 E262 E265 E266 E271 E272 E273 E274 E275 E301 E302 E303 E304 E305 E306 E401 E402 E501 E502 E701 E702 E703 E711 E712 E713 E714 E721 E722 E731 E741 E742 E743 E902 E999 W191 W291 W292 W293 W391 W505 W605 D100 D101 D102 D103 D104 D105 D106 D107 D200 D201 D202 D203 D204 D205 D206 D207 D208 D209 D210 D211 D212 D213 D214 D215 D300 D301 D400 D401 D402 D403 D404 D405 D406 D407 D408 D409 D410 D411 D412 D413 D414 D415 D416 D417 D418 D419 F401 F402 F403 F404 F405 F406 F407 F501 F502 F503 F504 F505 F506 F507 F508 F509 F521 F522 F523 F524 F525 F541 F601 F602 F621 F622 F631 F632 F633 F634 F701 F702 F704 F706 F707 F722 F811 F821 F822 F823 F841 F842 F901 PGH001 PGH002 PGH003 PGH004 PGH005 PLC0105 PLC0131 PLC0132 PLC0205 PLC0208 PLC0414 PLC0415 PLC1901 PLC2401 PLC2403 PLC2701 PLC2801 PLC3002 PLE0100 PLE0101 PLE0115 PLE0116 PLE0117 PLE0118 PLE0237 PLE0241 PLE0302 PLE0303 PLE0304 PLE0305 PLE0307 PLE0308 PLE0309 PLE0604 PLE0605 PLE0643 PLE0704 PLE1132 PLE1141 PLE1142 PLE1205 PLE1206 PLE1300 PLE1307 PLE1310 PLE1507 PLE1519 PLE1520 PLE1700 PLE2502 PLE2510 PLE2512 PLE2513 PLE2514 PLE2515 PLE4703 PLR0124 PLR0133 PLR0202 PLR0203 PLR0206 PLR0402 PLR0904 PLR0911 PLR0912 PLR0913 PLR0914 PLR0915 PLR0916 PLR0917 PLR1701 PLR1702 PLR1704 PLR1706 PLR1711 PLR1714 PLR1722 PLR1730 PLR1733 PLR1736 PLR2004 PLR2044 PLR5501 PLR6104 PLR6201 PLR6301 PLW0108 PLW0120 PLW0127 PLW0128 PLW0129 PLW0131 PLW0133 PLW0177 PLW0211 PLW0245 PLW0406 PLW0602 PLW0603 PLW0604 PLW0642 PLW0711 PLW1501 PLW1508 PLW1509 PLW1510 PLW1514 PLW1641 PLW2101 PLW2901 PLW3201 PLW3301 UP001 UP003 UP004 UP005 UP006 UP007 UP008 UP009 UP010 UP011 UP012 UP013 UP014 UP015 UP017 UP018 UP019 UP020 UP021 UP022 UP023 UP024 UP025 UP026 UP027 UP028 UP029 UP030 UP031 UP032 UP033 UP034 UP035 UP036 UP037 UP038 UP039 UP040 UP041 UP042 FURB101 FURB103 FURB105 FURB110 FURB113 FURB116 FURB118 FURB129 FURB131 FURB132 FURB136 FURB140 FURB142 FURB145 FURB148 FURB152 FURB157 FURB161 FURB163 FURB164 FURB166 FURB167 FURB168 FURB169 FURB171 FURB177 FURB180 FURB181 FURB187 FURB192 RUF001 RUF002 RUF003 RUF005 RUF006 RUF007 RUF008 RUF009 RUF010 RUF011 RUF012 RUF013 RUF015 RUF016 RUF017 RUF018 RUF019 RUF020 RUF021 RUF022 RUF023 RUF024 RUF025 RUF026 RUF027 RUF028 RUF029 RUF100 RUF101 RUF200 TRY002 TRY003 TRY004 TRY200 TRY201 TRY300 TRY301 TRY302 TRY400 TRY401" -- "${cur}"))
                    return 0
                    ;;
                --unfixable)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN ASYNC TRIO S BLE FBT B A COM CPY C4 DTZ T10 DJ EM EXE FA ISC ICN LOG G INP PIE T20 PYI PT Q RSE RET SLF SLOT SIM TID TCH INT ARG PTH TD FIX ERA PD PGH PL TRY FLY NPY AIR PERF FURB RUF AIR001 ERA001 YTT101 YTT102 YTT103 YTT201 YTT202 YTT203 YTT204 YTT301 YTT302 YTT303 ANN001 ANN002 ANN003 ANN101 ANN102 ANN201 ANN202 ANN204 ANN205 ANN206 ANN401 ASYNC100 ASYNC101 ASYNC102 S101 S102 S103 S104 S105 S106 S107 S108 S110 S112 S113 S201 S202 S301 S302 S303 S304 S305 S306 S307 S308 S310 S311 S312 S313 S314 S315 S316 S317 S318 S319 S320 S321 S323 S324 S401 S402 S403 S404 S405 S406 S407 S408 S409 S410 S411 S412 S413 S415 S501 S502 S503 S504 S505 S506 S507 S508 S509 S601 S602 S603 S604 S605 S606 S607 S608 S609 S610 S611 S612 S701 S702 BLE001 FBT001 FBT002 FBT003 B002 B003 B004 B005 B006 B007 B008 B009 B010 B011 B012 B013 B014 B015 B016 B017 B018 B019 B020 B021 B022 B023 B024 B025 B026 B027 B028 B029 B030 B031 B032 B033 B034 B035 B904 B905 B909 A001 A002 A003 COM812 COM818 COM819 C400 C401 C402 C403 C404 C405 C406 C408 C409 C410 C411 C413 C414 C415 C416 C417 C418 C419 CPY001 DTZ001 DTZ002 DTZ003 DTZ004 DTZ005 DTZ006 DTZ007 DTZ011 DTZ012 T100 DJ001 DJ003 DJ006 DJ007 DJ008 DJ012 DJ013 EM101 EM102 EM103 EXE001 EXE002 EXE003 EXE004 EXE005 FIX001 FIX002 FIX003 FIX004 FA100 FA102 INT001 INT002 INT003 ISC001 ISC002 ISC003 ICN001 ICN002 ICN003 LOG001 LOG002 LOG007 LOG009 G001 G002 G003 G004 G010 G101 G201 G202 INP001 PIE790 PIE794 PIE796 PIE800 PIE804 PIE807 PIE808 PIE810 T201 T203 PYI001 PYI002 PYI003 PYI004 PYI005 PYI006 PYI007 PYI008 PYI009 PYI010 PYI011 PYI012 PYI013 PYI014 PYI015 PYI016 PYI017 PYI018 PYI019 PYI020 PYI021 PYI024 PYI025 PYI026 PYI029 PYI030 PYI032 PYI033 PYI034 PYI035 PYI036 PYI041 PYI042 PYI043 PYI044 PYI045 PYI046 PYI047 PYI048 PYI049 PYI050 PYI051 PYI052 PYI053 PYI054 PYI055 PYI056 PYI058 PT001 PT002 PT003 PT004 PT005 PT006 PT007 PT008 PT009 PT010 PT011 PT012 PT013 PT014 PT015 PT016 PT017 PT018 PT019 PT020 PT021 PT022 PT023 PT024 PT025 PT026 PT027 Q000 Q001 Q002 Q003 Q004 RSE102 RET501 RET502 RET503 RET504 RET505 RET506 RET507 RET508 SLF001 SIM101 SIM102 SIM103 SIM105 SIM107 SIM108 SIM109 SIM110 SIM112 SIM113 SIM114 SIM115 SIM116 SIM117 SIM118 SIM201 SIM202 SIM208 SIM210 SIM211 SIM212 SIM220 SIM221 SIM222 SIM223 SIM300 SIM401 SIM910 SIM911 SLOT000 SLOT001 SLOT002 TID251 TID252 TID253 TD001 TD002 TD003 TD004 TD005 TD006 TD007 TRIO100 TRIO105 TRIO109 TRIO110 TRIO115 TCH001 TCH002 TCH003 TCH004 TCH005 TCH010 ARG001 ARG002 ARG003 ARG004 ARG005 PTH100 PTH101 PTH102 PTH103 PTH104 PTH105 PTH106 PTH107 PTH108 PTH109 PTH110 PTH111 PTH112 PTH113 PTH114 PTH115 PTH116 PTH117 PTH118 PTH119 PTH120 PTH121 PTH122 PTH123 PTH124 PTH201 PTH202 PTH203 PTH204 PTH205 PTH206 PTH207 FLY002 I001 I002 C901 NPY001 NPY002 NPY003 NPY201 N801 N802 N803 N804 N805 N806 N807 N811 N812 N813 N814 N815 N816 N817 N818 N999 PD002 PD003 PD004 PD007 PD008 PD009 PD010 PD011 PD012 PD013 PD015 PD101 PD901 PERF101 PERF102 PERF203 PERF401 PERF402 PERF403 E101 E111 E112 E113 E114 E115 E116 E117 E201 E202 E203 E211 E221 E222 E223 E224 E225 E226 E227 E228 E231 E241 E242 E251 E252 E261 E262 E265 E266 E271 E272 E273 E274 E275 E301 E302 E303 E304 E305 E306 E401 E402 E501 E502 E701 E702 E703 E711 E712 E713 E714 E721 E722 E731 E741 E742 E743 E902 E999 W191 W291 W292 W293 W391 W505 W605 D100 D101 D102 D103 D104 D105 D106 D107 D200 D201 D202 D203 D204 D205 D206 D207 D208 D209 D210 D211 D212 D213 D214 D215 D300 D301 D400 D401 D402 D403 D404 D405 D406 D407 D408 D409 D410 D411 D412 D413 D414 D415 D416 D417 D418 D419 F401 F402 F403 F404 F405 F406 F407 F501 F502 F503 F504 F505 F506 F507 F508 F509 F521 F522 F523 F524 F525 F541 F601 F602 F621 F622 F631 F632 F633 F634 F701 F702 F704 F706 F707 F722 F811 F821 F822 F823 F841 F842 F901 PGH001 PGH002 PGH003 PGH004 PGH005 PLC0105 PLC0131 PLC0132 PLC0205 PLC0208 PLC0414 PLC0415 PLC1901 PLC2401 PLC2403 PLC2701 PLC2801 PLC3002 PLE0100 PLE0101 PLE0115 PLE0116 PLE0117 PLE0118 PLE0237 PLE0241 PLE0302 PLE0303 PLE0304 PLE0305 PLE0307 PLE0308 PLE0309 PLE0604 PLE0605 PLE0643 PLE0704 PLE1132 PLE1141 PLE1142 PLE1205 PLE1206 PLE1300 PLE1307 PLE1310 PLE1507 PLE1519 PLE1520 PLE1700 PLE2502 PLE2510 PLE2512 PLE2513 PLE2514 PLE2515 PLE4703 PLR0124 PLR0133 PLR0202 PLR0203 PLR0206 PLR0402 PLR0904 PLR0911 PLR0912 PLR0913 PLR0914 PLR0915 PLR0916 PLR0917 PLR1701 PLR1702 PLR1704 PLR1706 PLR1711 PLR1714 PLR1722 PLR1730 PLR1733 PLR1736 PLR2004 PLR2044 PLR5501 PLR6104 PLR6201 PLR6301 PLW0108 PLW0120 PLW0127 PLW0128 PLW0129 PLW0131 PLW0133 PLW0177 PLW0211 PLW0245 PLW0406 PLW0602 PLW0603 PLW0604 PLW0642 PLW0711 PLW1501 PLW1508 PLW1509 PLW1510 PLW1514 PLW1641 PLW2101 PLW2901 PLW3201 PLW3301 UP001 UP003 UP004 UP005 UP006 UP007 UP008 UP009 UP010 UP011 UP012 UP013 UP014 UP015 UP017 UP018 UP019 UP020 UP021 UP022 UP023 UP024 UP025 UP026 UP027 UP028 UP029 UP030 UP031 UP032 UP033 UP034 UP035 UP036 UP037 UP038 UP039 UP040 UP041 UP042 FURB101 FURB103 FURB105 FURB110 FURB113 FURB116 FURB118 FURB129 FURB131 FURB132 FURB136 FURB140 FURB142 FURB145 FURB148 FURB152 FURB157 FURB161 FURB163 FURB164 FURB166 FURB167 FURB168 FURB169 FURB171 FURB177 FURB180 FURB181 FURB187 FURB192 RUF001 RUF002 RUF003 RUF005 RUF006 RUF007 RUF008 RUF009 RUF010 RUF011 RUF012 RUF013 RUF015 RUF016 RUF017 RUF018 RUF019 RUF020 RUF021 RUF022 RUF023 RUF024 RUF025 RUF026 RUF027 RUF028 RUF029 RUF100 RUF101 RUF200 TRY002 TRY003 TRY004 TRY200 TRY201 TRY300 TRY301 TRY302 TRY400 TRY401" -- "${cur}"))
                    return 0
                    ;;
                --extend-fixable)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN ASYNC TRIO S BLE FBT B A COM CPY C4 DTZ T10 DJ EM EXE FA ISC ICN LOG G INP PIE T20 PYI PT Q RSE RET SLF SLOT SIM TID TCH INT ARG PTH TD FIX ERA PD PGH PL TRY FLY NPY AIR PERF FURB RUF AIR001 ERA001 YTT101 YTT102 YTT103 YTT201 YTT202 YTT203 YTT204 YTT301 YTT302 YTT303 ANN001 ANN002 ANN003 ANN101 ANN102 ANN201 ANN202 ANN204 ANN205 ANN206 ANN401 ASYNC100 ASYNC101 ASYNC102 S101 S102 S103 S104 S105 S106 S107 S108 S110 S112 S113 S201 S202 S301 S302 S303 S304 S305 S306 S307 S308 S310 S311 S312 S313 S314 S315 S316 S317 S318 S319 S320 S321 S323 S324 S401 S402 S403 S404 S405 S406 S407 S408 S409 S410 S411 S412 S413 S415 S501 S502 S503 S504 S505 S506 S507 S508 S509 S601 S602 S603 S604 S605 S606 S607 S608 S609 S610 S611 S612 S701 S702 BLE001 FBT001 FBT002 FBT003 B002 B003 B004 B005 B006 B007 B008 B009 B010 B011 B012 B013 B014 B015 B016 B017 B018 B019 B020 B021 B022 B023 B024 B025 B026 B027 B028 B029 B030 B031 B032 B033 B034 B035 B904 B905 B909 A001 A002 A003 COM812 COM818 COM819 C400 C401 C402 C403 C404 C405 C406 C408 C409 C410 C411 C413 C414 C415 C416 C417 C418 C419 CPY001 DTZ001 DTZ002 DTZ003 DTZ004 DTZ005 DTZ006 DTZ007 DTZ011 DTZ012 T100 DJ001 DJ003 DJ006 DJ007 DJ008 DJ012 DJ013 EM101 EM102 EM103 EXE001 EXE002 EXE003 EXE004 EXE005 FIX001 FIX002 FIX003 FIX004 FA100 FA102 INT001 INT002 INT003 ISC001 ISC002 ISC003 ICN001 ICN002 ICN003 LOG001 LOG002 LOG007 LOG009 G001 G002 G003 G004 G010 G101 G201 G202 INP001 PIE790 PIE794 PIE796 PIE800 PIE804 PIE807 PIE808 PIE810 T201 T203 PYI001 PYI002 PYI003 PYI004 PYI005 PYI006 PYI007 PYI008 PYI009 PYI010 PYI011 PYI012 PYI013 PYI014 PYI015 PYI016 PYI017 PYI018 PYI019 PYI020 PYI021 PYI024 PYI025 PYI026 PYI029 PYI030 PYI032 PYI033 PYI034 PYI035 PYI036 PYI041 PYI042 PYI043 PYI044 PYI045 PYI046 PYI047 PYI048 PYI049 PYI050 PYI051 PYI052 PYI053 PYI054 PYI055 PYI056 PYI058 PT001 PT002 PT003 PT004 PT005 PT006 PT007 PT008 PT009 PT010 PT011 PT012 PT013 PT014 PT015 PT016 PT017 PT018 PT019 PT020 PT021 PT022 PT023 PT024 PT025 PT026 PT027 Q000 Q001 Q002 Q003 Q004 RSE102 RET501 RET502 RET503 RET504 RET505 RET506 RET507 RET508 SLF001 SIM101 SIM102 SIM103 SIM105 SIM107 SIM108 SIM109 SIM110 SIM112 SIM113 SIM114 SIM115 SIM116 SIM117 SIM118 SIM201 SIM202 SIM208 SIM210 SIM211 SIM212 SIM220 SIM221 SIM222 SIM223 SIM300 SIM401 SIM910 SIM911 SLOT000 SLOT001 SLOT002 TID251 TID252 TID253 TD001 TD002 TD003 TD004 TD005 TD006 TD007 TRIO100 TRIO105 TRIO109 TRIO110 TRIO115 TCH001 TCH002 TCH003 TCH004 TCH005 TCH010 ARG001 ARG002 ARG003 ARG004 ARG005 PTH100 PTH101 PTH102 PTH103 PTH104 PTH105 PTH106 PTH107 PTH108 PTH109 PTH110 PTH111 PTH112 PTH113 PTH114 PTH115 PTH116 PTH117 PTH118 PTH119 PTH120 PTH121 PTH122 PTH123 PTH124 PTH201 PTH202 PTH203 PTH204 PTH205 PTH206 PTH207 FLY002 I001 I002 C901 NPY001 NPY002 NPY003 NPY201 N801 N802 N803 N804 N805 N806 N807 N811 N812 N813 N814 N815 N816 N817 N818 N999 PD002 PD003 PD004 PD007 PD008 PD009 PD010 PD011 PD012 PD013 PD015 PD101 PD901 PERF101 PERF102 PERF203 PERF401 PERF402 PERF403 E101 E111 E112 E113 E114 E115 E116 E117 E201 E202 E203 E211 E221 E222 E223 E224 E225 E226 E227 E228 E231 E241 E242 E251 E252 E261 E262 E265 E266 E271 E272 E273 E274 E275 E301 E302 E303 E304 E305 E306 E401 E402 E501 E502 E701 E702 E703 E711 E712 E713 E714 E721 E722 E731 E741 E742 E743 E902 E999 W191 W291 W292 W293 W391 W505 W605 D100 D101 D102 D103 D104 D105 D106 D107 D200 D201 D202 D203 D204 D205 D206 D207 D208 D209 D210 D211 D212 D213 D214 D215 D300 D301 D400 D401 D402 D403 D404 D405 D406 D407 D408 D409 D410 D411 D412 D413 D414 D415 D416 D417 D418 D419 F401 F402 F403 F404 F405 F406 F407 F501 F502 F503 F504 F505 F506 F507 F508 F509 F521 F522 F523 F524 F525 F541 F601 F602 F621 F622 F631 F632 F633 F634 F701 F702 F704 F706 F707 F722 F811 F821 F822 F823 F841 F842 F901 PGH001 PGH002 PGH003 PGH004 PGH005 PLC0105 PLC0131 PLC0132 PLC0205 PLC0208 PLC0414 PLC0415 PLC1901 PLC2401 PLC2403 PLC2701 PLC2801 PLC3002 PLE0100 PLE0101 PLE0115 PLE0116 PLE0117 PLE0118 PLE0237 PLE0241 PLE0302 PLE0303 PLE0304 PLE0305 PLE0307 PLE0308 PLE0309 PLE0604 PLE0605 PLE0643 PLE0704 PLE1132 PLE1141 PLE1142 PLE1205 PLE1206 PLE1300 PLE1307 PLE1310 PLE1507 PLE1519 PLE1520 PLE1700 PLE2502 PLE2510 PLE2512 PLE2513 PLE2514 PLE2515 PLE4703 PLR0124 PLR0133 PLR0202 PLR0203 PLR0206 PLR0402 PLR0904 PLR0911 PLR0912 PLR0913 PLR0914 PLR0915 PLR0916 PLR0917 PLR1701 PLR1702 PLR1704 PLR1706 PLR1711 PLR1714 PLR1722 PLR1730 PLR1733 PLR1736 PLR2004 PLR2044 PLR5501 PLR6104 PLR6201 PLR6301 PLW0108 PLW0120 PLW0127 PLW0128 PLW0129 PLW0131 PLW0133 PLW0177 PLW0211 PLW0245 PLW0406 PLW0602 PLW0603 PLW0604 PLW0642 PLW0711 PLW1501 PLW1508 PLW1509 PLW1510 PLW1514 PLW1641 PLW2101 PLW2901 PLW3201 PLW3301 UP001 UP003 UP004 UP005 UP006 UP007 UP008 UP009 UP010 UP011 UP012 UP013 UP014 UP015 UP017 UP018 UP019 UP020 UP021 UP022 UP023 UP024 UP025 UP026 UP027 UP028 UP029 UP030 UP031 UP032 UP033 UP034 UP035 UP036 UP037 UP038 UP039 UP040 UP041 UP042 FURB101 FURB103 FURB105 FURB110 FURB113 FURB116 FURB118 FURB129 FURB131 FURB132 FURB136 FURB140 FURB142 FURB145 FURB148 FURB152 FURB157 FURB161 FURB163 FURB164 FURB166 FURB167 FURB168 FURB169 FURB171 FURB177 FURB180 FURB181 FURB187 FURB192 RUF001 RUF002 RUF003 RUF005 RUF006 RUF007 RUF008 RUF009 RUF010 RUF011 RUF012 RUF013 RUF015 RUF016 RUF017 RUF018 RUF019 RUF020 RUF021 RUF022 RUF023 RUF024 RUF025 RUF026 RUF027 RUF028 RUF029 RUF100 RUF101 RUF200 TRY002 TRY003 TRY004 TRY200 TRY201 TRY300 TRY301 TRY302 TRY400 TRY401" -- "${cur}"))
                    return 0
                    ;;
                --extend-unfixable)
                    COMPREPLY=($(compgen -W "ALL F C90 I N D UP YTT ANN ASYNC TRIO S BLE FBT B A COM CPY C4 DTZ T10 DJ EM EXE FA ISC ICN LOG G INP PIE T20 PYI PT Q RSE RET SLF SLOT SIM TID TCH INT ARG PTH TD FIX ERA PD PGH PL TRY FLY NPY AIR PERF FURB RUF AIR001 ERA001 YTT101 YTT102 YTT103 YTT201 YTT202 YTT203 YTT204 YTT301 YTT302 YTT303 ANN001 ANN002 ANN003 ANN101 ANN102 ANN201 ANN202 ANN204 ANN205 ANN206 ANN401 ASYNC100 ASYNC101 ASYNC102 S101 S102 S103 S104 S105 S106 S107 S108 S110 S112 S113 S201 S202 S301 S302 S303 S304 S305 S306 S307 S308 S310 S311 S312 S313 S314 S315 S316 S317 S318 S319 S320 S321 S323 S324 S401 S402 S403 S404 S405 S406 S407 S408 S409 S410 S411 S412 S413 S415 S501 S502 S503 S504 S505 S506 S507 S508 S509 S601 S602 S603 S604 S605 S606 S607 S608 S609 S610 S611 S612 S701 S702 BLE001 FBT001 FBT002 FBT003 B002 B003 B004 B005 B006 B007 B008 B009 B010 B011 B012 B013 B014 B015 B016 B017 B018 B019 B020 B021 B022 B023 B024 B025 B026 B027 B028 B029 B030 B031 B032 B033 B034 B035 B904 B905 B909 A001 A002 A003 COM812 COM818 COM819 C400 C401 C402 C403 C404 C405 C406 C408 C409 C410 C411 C413 C414 C415 C416 C417 C418 C419 CPY001 DTZ001 DTZ002 DTZ003 DTZ004 DTZ005 DTZ006 DTZ007 DTZ011 DTZ012 T100 DJ001 DJ003 DJ006 DJ007 DJ008 DJ012 DJ013 EM101 EM102 EM103 EXE001 EXE002 EXE003 EXE004 EXE005 FIX001 FIX002 FIX003 FIX004 FA100 FA102 INT001 INT002 INT003 ISC001 ISC002 ISC003 ICN001 ICN002 ICN003 LOG001 LOG002 LOG007 LOG009 G001 G002 G003 G004 G010 G101 G201 G202 INP001 PIE790 PIE794 PIE796 PIE800 PIE804 PIE807 PIE808 PIE810 T201 T203 PYI001 PYI002 PYI003 PYI004 PYI005 PYI006 PYI007 PYI008 PYI009 PYI010 PYI011 PYI012 PYI013 PYI014 PYI015 PYI016 PYI017 PYI018 PYI019 PYI020 PYI021 PYI024 PYI025 PYI026 PYI029 PYI030 PYI032 PYI033 PYI034 PYI035 PYI036 PYI041 PYI042 PYI043 PYI044 PYI045 PYI046 PYI047 PYI048 PYI049 PYI050 PYI051 PYI052 PYI053 PYI054 PYI055 PYI056 PYI058 PT001 PT002 PT003 PT004 PT005 PT006 PT007 PT008 PT009 PT010 PT011 PT012 PT013 PT014 PT015 PT016 PT017 PT018 PT019 PT020 PT021 PT022 PT023 PT024 PT025 PT026 PT027 Q000 Q001 Q002 Q003 Q004 RSE102 RET501 RET502 RET503 RET504 RET505 RET506 RET507 RET508 SLF001 SIM101 SIM102 SIM103 SIM105 SIM107 SIM108 SIM109 SIM110 SIM112 SIM113 SIM114 SIM115 SIM116 SIM117 SIM118 SIM201 SIM202 SIM208 SIM210 SIM211 SIM212 SIM220 SIM221 SIM222 SIM223 SIM300 SIM401 SIM910 SIM911 SLOT000 SLOT001 SLOT002 TID251 TID252 TID253 TD001 TD002 TD003 TD004 TD005 TD006 TD007 TRIO100 TRIO105 TRIO109 TRIO110 TRIO115 TCH001 TCH002 TCH003 TCH004 TCH005 TCH010 ARG001 ARG002 ARG003 ARG004 ARG005 PTH100 PTH101 PTH102 PTH103 PTH104 PTH105 PTH106 PTH107 PTH108 PTH109 PTH110 PTH111 PTH112 PTH113 PTH114 PTH115 PTH116 PTH117 PTH118 PTH119 PTH120 PTH121 PTH122 PTH123 PTH124 PTH201 PTH202 PTH203 PTH204 PTH205 PTH206 PTH207 FLY002 I001 I002 C901 NPY001 NPY002 NPY003 NPY201 N801 N802 N803 N804 N805 N806 N807 N811 N812 N813 N814 N815 N816 N817 N818 N999 PD002 PD003 PD004 PD007 PD008 PD009 PD010 PD011 PD012 PD013 PD015 PD101 PD901 PERF101 PERF102 PERF203 PERF401 PERF402 PERF403 E101 E111 E112 E113 E114 E115 E116 E117 E201 E202 E203 E211 E221 E222 E223 E224 E225 E226 E227 E228 E231 E241 E242 E251 E252 E261 E262 E265 E266 E271 E272 E273 E274 E275 E301 E302 E303 E304 E305 E306 E401 E402 E501 E502 E701 E702 E703 E711 E712 E713 E714 E721 E722 E731 E741 E742 E743 E902 E999 W191 W291 W292 W293 W391 W505 W605 D100 D101 D102 D103 D104 D105 D106 D107 D200 D201 D202 D203 D204 D205 D206 D207 D208 D209 D210 D211 D212 D213 D214 D215 D300 D301 D400 D401 D402 D403 D404 D405 D406 D407 D408 D409 D410 D411 D412 D413 D414 D415 D416 D417 D418 D419 F401 F402 F403 F404 F405 F406 F407 F501 F502 F503 F504 F505 F506 F507 F508 F509 F521 F522 F523 F524 F525 F541 F601 F602 F621 F622 F631 F632 F633 F634 F701 F702 F704 F706 F707 F722 F811 F821 F822 F823 F841 F842 F901 PGH001 PGH002 PGH003 PGH004 PGH005 PLC0105 PLC0131 PLC0132 PLC0205 PLC0208 PLC0414 PLC0415 PLC1901 PLC2401 PLC2403 PLC2701 PLC2801 PLC3002 PLE0100 PLE0101 PLE0115 PLE0116 PLE0117 PLE0118 PLE0237 PLE0241 PLE0302 PLE0303 PLE0304 PLE0305 PLE0307 PLE0308 PLE0309 PLE0604 PLE0605 PLE0643 PLE0704 PLE1132 PLE1141 PLE1142 PLE1205 PLE1206 PLE1300 PLE1307 PLE1310 PLE1507 PLE1519 PLE1520 PLE1700 PLE2502 PLE2510 PLE2512 PLE2513 PLE2514 PLE2515 PLE4703 PLR0124 PLR0133 PLR0202 PLR0203 PLR0206 PLR0402 PLR0904 PLR0911 PLR0912 PLR0913 PLR0914 PLR0915 PLR0916 PLR0917 PLR1701 PLR1702 PLR1704 PLR1706 PLR1711 PLR1714 PLR1722 PLR1730 PLR1733 PLR1736 PLR2004 PLR2044 PLR5501 PLR6104 PLR6201 PLR6301 PLW0108 PLW0120 PLW0127 PLW0128 PLW0129 PLW0131 PLW0133 PLW0177 PLW0211 PLW0245 PLW0406 PLW0602 PLW0603 PLW0604 PLW0642 PLW0711 PLW1501 PLW1508 PLW1509 PLW1510 PLW1514 PLW1641 PLW2101 PLW2901 PLW3201 PLW3301 UP001 UP003 UP004 UP005 UP006 UP007 UP008 UP009 UP010 UP011 UP012 UP013 UP014 UP015 UP017 UP018 UP019 UP020 UP021 UP022 UP023 UP024 UP025 UP026 UP027 UP028 UP029 UP030 UP031 UP032 UP033 UP034 UP035 UP036 UP037 UP038 UP039 UP040 UP041 UP042 FURB101 FURB103 FURB105 FURB110 FURB113 FURB116 FURB118 FURB129 FURB131 FURB132 FURB136 FURB140 FURB142 FURB145 FURB148 FURB152 FURB157 FURB161 FURB163 FURB164 FURB166 FURB167 FURB168 FURB169 FURB171 FURB177 FURB180 FURB181 FURB187 FURB192 RUF001 RUF002 RUF003 RUF005 RUF006 RUF007 RUF008 RUF009 RUF010 RUF011 RUF012 RUF013 RUF015 RUF016 RUF017 RUF018 RUF019 RUF020 RUF021 RUF022 RUF023 RUF024 RUF025 RUF026 RUF027 RUF028 RUF029 RUF100 RUF101 RUF200 TRY002 TRY003 TRY004 TRY200 TRY201 TRY300 TRY301 TRY302 TRY400 TRY401" -- "${cur}"))
                    return 0
                    ;;
                --line-length)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --dummy-variable-rgx)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --cache-dir)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --stdin-filename)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --extension)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__clean)
            opts="-v -q -s -h --verbose --quiet --silent --config --isolated --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__config)
            opts="-v -q -s -h --verbose --quiet --silent --config --isolated --help [OPTION]"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__format)
            opts="-n -v -q -s -h --check --diff --no-cache --cache-dir --respect-gitignore --no-respect-gitignore --exclude --force-exclude --no-force-exclude --line-length --stdin-filename --extension --target-version --preview --no-preview --range --verbose --quiet --silent --config --isolated --help [FILES]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --cache-dir)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --exclude)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --line-length)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --stdin-filename)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --extension)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --target-version)
                    COMPREPLY=($(compgen -W "py37 py38 py39 py310 py311 py312" -- "${cur}"))
                    return 0
                    ;;
                --range)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__generate__shell__completion)
            opts="-v -q -s -h --verbose --quiet --silent --config --isolated --help bash elvish fig fish nushell powershell zsh"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help)
            opts="check rule config linter clean generate-shell-completion format server version help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__check)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__clean)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__config)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__format)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__generate__shell__completion)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__help)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__linter)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__rule)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__server)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__help__version)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__linter)
            opts="-v -q -s -h --output-format --verbose --quiet --silent --config --isolated --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --output-format)
                    COMPREPLY=($(compgen -W "text json" -- "${cur}"))
                    return 0
                    ;;
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__rule)
            opts="-v -q -s -h --all --output-format --verbose --quiet --silent --config --isolated --help AIR001 ERA001 YTT101 YTT102 YTT103 YTT201 YTT202 YTT203 YTT204 YTT301 YTT302 YTT303 ANN001 ANN002 ANN003 ANN101 ANN102 ANN201 ANN202 ANN204 ANN205 ANN206 ANN401 ASYNC100 ASYNC101 ASYNC102 S101 S102 S103 S104 S105 S106 S107 S108 S110 S112 S113 S201 S202 S301 S302 S303 S304 S305 S306 S307 S308 S310 S311 S312 S313 S314 S315 S316 S317 S318 S319 S320 S321 S323 S324 S401 S402 S403 S404 S405 S406 S407 S408 S409 S410 S411 S412 S413 S415 S501 S502 S503 S504 S505 S506 S507 S508 S509 S601 S602 S603 S604 S605 S606 S607 S608 S609 S610 S611 S612 S701 S702 BLE001 FBT001 FBT002 FBT003 B002 B003 B004 B005 B006 B007 B008 B009 B010 B011 B012 B013 B014 B015 B016 B017 B018 B019 B020 B021 B022 B023 B024 B025 B026 B027 B028 B029 B030 B031 B032 B033 B034 B035 B904 B905 B909 A001 A002 A003 COM812 COM818 COM819 C400 C401 C402 C403 C404 C405 C406 C408 C409 C410 C411 C413 C414 C415 C416 C417 C418 C419 CPY001 DTZ001 DTZ002 DTZ003 DTZ004 DTZ005 DTZ006 DTZ007 DTZ011 DTZ012 T100 DJ001 DJ003 DJ006 DJ007 DJ008 DJ012 DJ013 EM101 EM102 EM103 EXE001 EXE002 EXE003 EXE004 EXE005 FIX001 FIX002 FIX003 FIX004 FA100 FA102 INT001 INT002 INT003 ISC001 ISC002 ISC003 ICN001 ICN002 ICN003 LOG001 LOG002 LOG007 LOG009 G001 G002 G003 G004 G010 G101 G201 G202 INP001 PIE790 PIE794 PIE796 PIE800 PIE804 PIE807 PIE808 PIE810 T201 T203 PYI001 PYI002 PYI003 PYI004 PYI005 PYI006 PYI007 PYI008 PYI009 PYI010 PYI011 PYI012 PYI013 PYI014 PYI015 PYI016 PYI017 PYI018 PYI019 PYI020 PYI021 PYI024 PYI025 PYI026 PYI029 PYI030 PYI032 PYI033 PYI034 PYI035 PYI036 PYI041 PYI042 PYI043 PYI044 PYI045 PYI046 PYI047 PYI048 PYI049 PYI050 PYI051 PYI052 PYI053 PYI054 PYI055 PYI056 PYI058 PT001 PT002 PT003 PT004 PT005 PT006 PT007 PT008 PT009 PT010 PT011 PT012 PT013 PT014 PT015 PT016 PT017 PT018 PT019 PT020 PT021 PT022 PT023 PT024 PT025 PT026 PT027 Q000 Q001 Q002 Q003 Q004 RSE102 RET501 RET502 RET503 RET504 RET505 RET506 RET507 RET508 SLF001 SIM101 SIM102 SIM103 SIM105 SIM107 SIM108 SIM109 SIM110 SIM112 SIM113 SIM114 SIM115 SIM116 SIM117 SIM118 SIM201 SIM202 SIM208 SIM210 SIM211 SIM212 SIM220 SIM221 SIM222 SIM223 SIM300 SIM401 SIM910 SIM911 SLOT000 SLOT001 SLOT002 TID251 TID252 TID253 TD001 TD002 TD003 TD004 TD005 TD006 TD007 TRIO100 TRIO105 TRIO109 TRIO110 TRIO115 TCH001 TCH002 TCH003 TCH004 TCH005 TCH010 ARG001 ARG002 ARG003 ARG004 ARG005 PTH100 PTH101 PTH102 PTH103 PTH104 PTH105 PTH106 PTH107 PTH108 PTH109 PTH110 PTH111 PTH112 PTH113 PTH114 PTH115 PTH116 PTH117 PTH118 PTH119 PTH120 PTH121 PTH122 PTH123 PTH124 PTH201 PTH202 PTH203 PTH204 PTH205 PTH206 PTH207 FLY002 I001 I002 C901 NPY001 NPY002 NPY003 NPY201 N801 N802 N803 N804 N805 N806 N807 N811 N812 N813 N814 N815 N816 N817 N818 N999 PD002 PD003 PD004 PD007 PD008 PD009 PD010 PD011 PD012 PD013 PD015 PD101 PD901 PERF101 PERF102 PERF203 PERF401 PERF402 PERF403 E101 E111 E112 E113 E114 E115 E116 E117 E201 E202 E203 E211 E221 E222 E223 E224 E225 E226 E227 E228 E231 E241 E242 E251 E252 E261 E262 E265 E266 E271 E272 E273 E274 E275 E301 E302 E303 E304 E305 E306 E401 E402 E501 E502 E701 E702 E703 E711 E712 E713 E714 E721 E722 E731 E741 E742 E743 E902 E999 W191 W291 W292 W293 W391 W505 W605 D100 D101 D102 D103 D104 D105 D106 D107 D200 D201 D202 D203 D204 D205 D206 D207 D208 D209 D210 D211 D212 D213 D214 D215 D300 D301 D400 D401 D402 D403 D404 D405 D406 D407 D408 D409 D410 D411 D412 D413 D414 D415 D416 D417 D418 D419 F401 F402 F403 F404 F405 F406 F407 F501 F502 F503 F504 F505 F506 F507 F508 F509 F521 F522 F523 F524 F525 F541 F601 F602 F621 F622 F631 F632 F633 F634 F701 F702 F704 F706 F707 F722 F811 F821 F822 F823 F841 F842 F901 PGH001 PGH002 PGH003 PGH004 PGH005 PLC0105 PLC0131 PLC0132 PLC0205 PLC0208 PLC0414 PLC0415 PLC1901 PLC2401 PLC2403 PLC2701 PLC2801 PLC3002 PLE0100 PLE0101 PLE0115 PLE0116 PLE0117 PLE0118 PLE0237 PLE0241 PLE0302 PLE0303 PLE0304 PLE0305 PLE0307 PLE0308 PLE0309 PLE0604 PLE0605 PLE0643 PLE0704 PLE1132 PLE1141 PLE1142 PLE1205 PLE1206 PLE1300 PLE1307 PLE1310 PLE1507 PLE1519 PLE1520 PLE1700 PLE2502 PLE2510 PLE2512 PLE2513 PLE2514 PLE2515 PLE4703 PLR0124 PLR0133 PLR0202 PLR0203 PLR0206 PLR0402 PLR0904 PLR0911 PLR0912 PLR0913 PLR0914 PLR0915 PLR0916 PLR0917 PLR1701 PLR1702 PLR1704 PLR1706 PLR1711 PLR1714 PLR1722 PLR1730 PLR1733 PLR1736 PLR2004 PLR2044 PLR5501 PLR6104 PLR6201 PLR6301 PLW0108 PLW0120 PLW0127 PLW0128 PLW0129 PLW0131 PLW0133 PLW0177 PLW0211 PLW0245 PLW0406 PLW0602 PLW0603 PLW0604 PLW0642 PLW0711 PLW1501 PLW1508 PLW1509 PLW1510 PLW1514 PLW1641 PLW2101 PLW2901 PLW3201 PLW3301 UP001 UP003 UP004 UP005 UP006 UP007 UP008 UP009 UP010 UP011 UP012 UP013 UP014 UP015 UP017 UP018 UP019 UP020 UP021 UP022 UP023 UP024 UP025 UP026 UP027 UP028 UP029 UP030 UP031 UP032 UP033 UP034 UP035 UP036 UP037 UP038 UP039 UP040 UP041 UP042 FURB101 FURB103 FURB105 FURB110 FURB113 FURB116 FURB118 FURB129 FURB131 FURB132 FURB136 FURB140 FURB142 FURB145 FURB148 FURB152 FURB157 FURB161 FURB163 FURB164 FURB166 FURB167 FURB168 FURB169 FURB171 FURB177 FURB180 FURB181 FURB187 FURB192 RUF001 RUF002 RUF003 RUF005 RUF006 RUF007 RUF008 RUF009 RUF010 RUF011 RUF012 RUF013 RUF015 RUF016 RUF017 RUF018 RUF019 RUF020 RUF021 RUF022 RUF023 RUF024 RUF025 RUF026 RUF027 RUF028 RUF029 RUF100 RUF101 RUF200 TRY002 TRY003 TRY004 TRY200 TRY201 TRY300 TRY301 TRY302 TRY400 TRY401"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --output-format)
                    COMPREPLY=($(compgen -W "text json" -- "${cur}"))
                    return 0
                    ;;
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__server)
            opts="-v -q -s -h --preview --verbose --quiet --silent --config --isolated --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        ruff__version)
            opts="-v -q -s -h --output-format --verbose --quiet --silent --config --isolated --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --output-format)
                    COMPREPLY=($(compgen -W "text json" -- "${cur}"))
                    return 0
                    ;;
                --config)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
    esac
}

if [[ "${BASH_VERSINFO[0]}" -eq 4 && "${BASH_VERSINFO[1]}" -ge 4 || "${BASH_VERSINFO[0]}" -gt 4 ]]; then
    complete -F _ruff -o nosort -o bashdefault -o default ruff
else
    complete -F _ruff -o bashdefault -o default ruff
fi
