// Copyright 2024 The Khronos Group
// SPDX-License-Identifier: Apache-2.0

// This file was generated by generate_queries.py
// Don't make changes to this directly

#include <stdint.h>
#include <math.h>
#include <anari/anari.h>
namespace helide {
static int subtype_hash(const char *str) {
   static const uint32_t table[] = {0x7a6f0012u,0x6665002bu,0x0u,0x0u,0x0u,0x0u,0x6e6d0032u,0x0u,0x0u,0x0u,0x6261003fu,0x0u,0x73720044u,0x73650050u,0x76750070u,0x0u,0x75700074u,0x7372008eu,0x6f6e001du,0x0u,0x0u,0x0u,0x0u,0x0u,0x73720020u,0x0u,0x0u,0x0u,0x6d6c0024u,0x6665001eu,0x100001fu,0x80000000u,0x77760021u,0x66650022u,0x1000023u,0x80000001u,0x6a690025u,0x6f6e0026u,0x65640027u,0x66650028u,0x73720029u,0x100002au,0x80000002u,0x6766002cu,0x6261002du,0x7675002eu,0x6d6c002fu,0x75740030u,0x1000031u,0x80000003u,0x62610033u,0x68670034u,0x66650035u,0x34310036u,0x45440039u,0x4544003bu,0x4544003du,0x100003au,0x80000004u,0x100003cu,0x80000005u,0x100003eu,0x80000006u,0x75740040u,0x75740041u,0x66650042u,0x1000043u,0x80000007u,0x75740045u,0x69680046u,0x706f0047u,0x68670048u,0x73720049u,0x6261004au,0x7170004bu,0x6968004cu,0x6a69004du,0x6463004eu,0x100004fu,0x80000008u,0x7372005eu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6a690068u,0x7473005fu,0x71700060u,0x66650061u,0x64630062u,0x75740063u,0x6a690064u,0x77760065u,0x66650066u,0x1000067u,0x80000009u,0x6e6d0069u,0x6a69006au,0x7574006bu,0x6a69006cu,0x7776006du,0x6665006eu,0x100006fu,0x8000000au,0x62610071u,0x65640072u,0x1000073u,0x8000000bu,0x69680079u,0x0u,0x0u,0x0u,0x7372007eu,0x6665007au,0x7372007bu,0x6665007cu,0x100007du,0x8000000cu,0x7675007fu,0x64630080u,0x75740081u,0x76750082u,0x73720083u,0x66650084u,0x65640085u,0x53520086u,0x66650087u,0x68670088u,0x76750089u,0x6d6c008au,0x6261008bu,0x7372008cu,0x100008du,0x8000000du,0x6a61008fu,0x6f6e0098u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x626100b5u,0x74730099u,0x6766009au,0x7065009bu,0x737200a6u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x737200b2u,0x474600a7u,0x767500a8u,0x6f6e00a9u,0x646300aau,0x757400abu,0x6a6900acu,0x706f00adu,0x6f6e00aeu,0x323100afu,0x454400b0u,0x10000b1u,0x8000000eu,0x6e6d00b3u,0x10000b4u,0x8000000fu,0x6f6e00b6u,0x686700b7u,0x6d6c00b8u,0x666500b9u,0x10000bau,0x80000010u};
   uint32_t cur = 0x75630000u;
   for(int i = 0;cur!=0;++i) {
      uint32_t idx = cur&0xFFFFu;
      uint32_t low = (cur>>16u)&0xFFu;
      uint32_t high = (cur>>24u)&0xFFu;
      uint32_t c = (uint32_t)str[i];
      if(c>=low && c<high) {
         cur = table[idx+c-low];
      } else {
         break;
      }
      if(cur&0x80000000u) {
         return cur&0xFFFFu;
      }
      if(str[i]==0) {
         break;
      }
   }
   return -1;
}
static int param_hash(const char *str) {
   static const uint32_t table[] = {0x756c0017u,0x62610089u,0x70610093u,0x6a6100ebu,0x7a7900ffu,0x73610111u,0x736501a0u,0x666501b9u,0x6f6401bfu,0x0u,0x0u,0x6a69028du,0x70610292u,0x666102abu,0x767002b6u,0x736f02ddu,0x0u,0x6661032du,0x7669033eu,0x736103c4u,0x716e0404u,0x70610413u,0x736f04dbu,0x716c0020u,0x6362004fu,0x0u,0x0u,0x0u,0x0u,0x73720071u,0x71700075u,0x7574007au,0x706f0025u,0x0u,0x0u,0x0u,0x69680038u,0x78770026u,0x4a490027u,0x6f6e0028u,0x77760029u,0x6261002au,0x6d6c002bu,0x6a69002cu,0x6564002du,0x4e4d002eu,0x6261002fu,0x75740030u,0x66650031u,0x73720032u,0x6a690033u,0x62610034u,0x6d6c0035u,0x74730036u,0x1000037u,0x80000000u,0x62610039u,0x4e43003au,0x76750045u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x706f004bu,0x75740046u,0x706f0047u,0x67660048u,0x67660049u,0x100004au,0x80000001u,0x6564004cu,0x6665004du,0x100004eu,0x80000002u,0x6a690050u,0x66650051u,0x6f6e0052u,0x75740053u,0x53430054u,0x706f0064u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x62610069u,0x6d6c0065u,0x706f0066u,0x73720067u,0x1000068u,0x80000003u,0x6564006au,0x6a69006bu,0x6261006cu,0x6f6e006du,0x6463006eu,0x6665006fu,0x1000070u,0x80000004u,0x62610072u,0x7a790073u,0x1000074u,0x80000005u,0x66650076u,0x64630077u,0x75740078u,0x1000079u,0x80000006u,0x7372007bu,0x6a69007cu,0x6362007du,0x7675007eu,0x7574007fu,0x66650080u,0x34300081u,0x1000085u,0x1000086u,0x1000087u,0x1000088u,0x80000007u,0x80000008u,0x80000009u,0x8000000au,0x6463008au,0x6c6b008bu,0x6867008cu,0x7372008du,0x706f008eu,0x7675008fu,0x6f6e0090u,0x65640091u,0x1000092u,0x8000000bu,0x716d00a2u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x626100acu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6d6c00e7u,0x666500a6u,0x0u,0x0u,0x747300aau,0x737200a7u,0x626100a8u,0x10000a9u,0x8000000cu,0x10000abu,0x8000000du,0x6f6e00adu,0x6f6e00aeu,0x666500afu,0x6d6c00b0u,0x2f2e00b1u,0x716300b2u,0x706f00c0u,0x666500c5u,0x0u,0x0u,0x0u,0x0u,0x6f6e00cau,0x0u,0x0u,0x0u,0x0u,0x0u,0x636200d4u,0x737200dcu,0x6d6c00c1u,0x706f00c2u,0x737200c3u,0x10000c4u,0x8000000eu,0x717000c6u,0x757400c7u,0x696800c8u,0x10000c9u,0x8000000fu,0x747300cbu,0x757400ccu,0x626100cdu,0x6f6e00ceu,0x646300cfu,0x666500d0u,0x4a4900d1u,0x656400d2u,0x10000d3u,0x80000010u,0x6b6a00d5u,0x666500d6u,0x646300d7u,0x757400d8u,0x4a4900d9u,0x656400dau,0x10000dbu,0x80000011u,0x6a6900ddu,0x6e6d00deu,0x6a6900dfu,0x757400e0u,0x6a6900e1u,0x777600e2u,0x666500e3u,0x4a4900e4u,0x656400e5u,0x10000e6u,0x80000012u,0x706f00e8u,0x737200e9u,0x10000eau,0x80000013u,0x757400f4u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x737200f7u,0x626100f5u,0x10000f6u,0x80000014u,0x666500f8u,0x646300f9u,0x757400fau,0x6a6900fbu,0x706f00fcu,0x6f6e00fdu,0x10000feu,0x80000015u,0x66650100u,0x4d4c0101u,0x6a690102u,0x68670103u,0x69680104u,0x75740105u,0x43420106u,0x6d6c0107u,0x66650108u,0x6f6e0109u,0x6564010au,0x5352010bu,0x6261010cu,0x7574010du,0x6a69010eu,0x706f010fu,0x1000110u,0x80000016u,0x73720123u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6d6c0125u,0x0u,0x0u,0x0u,0x0u,0x0u,0x7776012au,0x0u,0x0u,0x6261012du,0x1000124u,0x80000017u,0x75740126u,0x66650127u,0x73720128u,0x1000129u,0x80000018u,0x7a79012bu,0x100012cu,0x80000019u,0x6e6d012eu,0x6665012fu,0x44430130u,0x706f0131u,0x6e6d0132u,0x71700133u,0x6d6c0134u,0x66650135u,0x75740136u,0x6a690137u,0x706f0138u,0x6f6e0139u,0x4443013au,0x6261013bu,0x6d6c013cu,0x6d6c013du,0x6362013eu,0x6261013fu,0x64630140u,0x6c6b0141u,0x56000142u,0x8000001au,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x74730198u,0x66650199u,0x7372019au,0x4544019bu,0x6261019cu,0x7574019du,0x6261019eu,0x100019fu,0x8000001bu,0x706f01aeu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x706f01b5u,0x6e6d01afu,0x666501b0u,0x757401b1u,0x737201b2u,0x7a7901b3u,0x10001b4u,0x8000001cu,0x767501b6u,0x717001b7u,0x10001b8u,0x8000001du,0x6a6901bau,0x686701bbu,0x696801bcu,0x757401bdu,0x10001beu,0x8000001eu,0x10001cau,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x626101cbu,0x77410227u,0x8000001fu,0x686701ccu,0x666501cdu,0x530001ceu,0x80000020u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x66650221u,0x68670222u,0x6a690223u,0x706f0224u,0x6f6e0225u,0x1000226u,0x80000021u,0x7574025du,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x67660266u,0x0u,0x0u,0x0u,0x0u,0x7372026cu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x75740275u,0x0u,0x0u,0x6261027bu,0x7574025eu,0x7372025fu,0x6a690260u,0x63620261u,0x76750262u,0x75740263u,0x66650264u,0x1000265u,0x80000022u,0x67660267u,0x74730268u,0x66650269u,0x7574026au,0x100026bu,0x80000023u,0x6261026du,0x6f6e026eu,0x7473026fu,0x67660270u,0x706f0271u,0x73720272u,0x6e6d0273u,0x1000274u,0x80000024u,0x62610276u,0x6f6e0277u,0x64630278u,0x66650279u,0x100027au,0x80000025u,0x6d6c027cu,0x6a69027du,0x6564027eu,0x4e4d027fu,0x62610280u,0x75740281u,0x66650282u,0x73720283u,0x6a690284u,0x62610285u,0x6d6c0286u,0x44430287u,0x706f0288u,0x6d6c0289u,0x706f028au,0x7372028bu,0x100028cu,0x80000026u,0x6867028eu,0x6968028fu,0x75740290u,0x1000291u,0x80000027u,0x757402a1u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x656402a8u,0x666502a2u,0x737202a3u,0x6a6902a4u,0x626102a5u,0x6d6c02a6u,0x10002a7u,0x80000028u,0x666502a9u,0x10002aau,0x80000029u,0x6e6d02b0u,0x0u,0x0u,0x0u,0x626102b3u,0x666502b1u,0x10002b2u,0x8000002au,0x737202b4u,0x10002b5u,0x8000002bu,0x626102bcu,0x0u,0x6a6902c2u,0x0u,0x0u,0x757402c7u,0x646302bdu,0x6a6902beu,0x757402bfu,0x7a7902c0u,0x10002c1u,0x8000002cu,0x686702c3u,0x6a6902c4u,0x6f6e02c5u,0x10002c6u,0x8000002du,0x554f02c8u,0x676602ceu,0x0u,0x0u,0x0u,0x0u,0x737202d4u,0x676602cfu,0x747302d0u,0x666502d1u,0x757402d2u,0x10002d3u,0x8000002eu,0x626102d5u,0x6f6e02d6u,0x747302d7u,0x676602d8u,0x706f02d9u,0x737202dau,0x6e6d02dbu,0x10002dcu,0x8000002fu,0x747302e1u,0x0u,0x0u,0x6a6902e8u,0x6a6902e2u,0x757402e3u,0x6a6902e4u,0x706f02e5u,0x6f6e02e6u,0x10002e7u,0x80000030u,0x6e6d02e9u,0x6a6902eau,0x757402ebu,0x6a6902ecu,0x777602edu,0x666502eeu,0x2f2e02efu,0x736102f0u,0x75740302u,0x0u,0x706f0312u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6f640317u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x62610327u,0x75740303u,0x73720304u,0x6a690305u,0x63620306u,0x76750307u,0x75740308u,0x66650309u,0x3430030au,0x100030eu,0x100030fu,0x1000310u,0x1000311u,0x80000031u,0x80000032u,0x80000033u,0x80000034u,0x6d6c0313u,0x706f0314u,0x73720315u,0x1000316u,0x80000035u,0x1000322u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x65640323u,0x80000036u,0x66650324u,0x79780325u,0x1000326u,0x80000037u,0x65640328u,0x6a690329u,0x7675032au,0x7473032bu,0x100032cu,0x80000038u,0x65640332u,0x0u,0x0u,0x0u,0x6f6e0337u,0x6a690333u,0x76750334u,0x74730335u,0x1000336u,0x80000039u,0x65640338u,0x66650339u,0x7372033au,0x6665033bu,0x7372033cu,0x100033du,0x8000003au,0x7b7a034bu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6261034eu,0x0u,0x0u,0x0u,0x62610354u,0x737203beu,0x6665034cu,0x100034du,0x8000003bu,0x6463034fu,0x6a690350u,0x6f6e0351u,0x68670352u,0x1000353u,0x8000003cu,0x75740355u,0x76750356u,0x74730357u,0x44430358u,0x62610359u,0x6d6c035au,0x6d6c035bu,0x6362035cu,0x6261035du,0x6463035eu,0x6c6b035fu,0x56000360u,0x8000003du,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x747303b6u,0x666503b7u,0x737203b8u,0x454403b9u,0x626103bau,0x757403bbu,0x626103bcu,0x10003bdu,0x8000003eu,0x676603bfu,0x626103c0u,0x646303c1u,0x666503c2u,0x10003c3u,0x8000003fu,0x747303d6u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x626103fcu,0x6c6b03d7u,0x484703d8u,0x737203d9u,0x626103dau,0x6a6903dbu,0x6f6e03dcu,0x545303ddu,0x6a6903deu,0x7b7a03dfu,0x666503e0u,0x584803e1u,0x666503f1u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6a6903f7u,0x6a6903f2u,0x686703f3u,0x696803f4u,0x757403f5u,0x10003f6u,0x80000040u,0x656403f8u,0x757403f9u,0x696803fau,0x10003fbu,0x80000041u,0x6f6e03fdu,0x747303feu,0x676603ffu,0x706f0400u,0x73720401u,0x6e6d0402u,0x1000403u,0x80000042u,0x6a690407u,0x0u,0x1000412u,0x75740408u,0x45440409u,0x6a69040au,0x7473040bu,0x7574040cu,0x6261040du,0x6f6e040eu,0x6463040fu,0x66650410u,0x1000411u,0x80000043u,0x80000044u,0x6d6c0422u,0x0u,0x0u,0x0u,0x7372047du,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6d6c04d6u,0x76750423u,0x66650424u,0x53000425u,0x80000045u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x62610478u,0x6f6e0479u,0x6867047au,0x6665047bu,0x100047cu,0x80000046u,0x7574047eu,0x6665047fu,0x79780480u,0x2f2e0481u,0x75610482u,0x75740496u,0x0u,0x706104a6u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x706f04bbu,0x0u,0x706f04c1u,0x0u,0x626104c9u,0x0u,0x626104cfu,0x75740497u,0x73720498u,0x6a690499u,0x6362049au,0x7675049bu,0x7574049cu,0x6665049du,0x3430049eu,0x10004a2u,0x10004a3u,0x10004a4u,0x10004a5u,0x80000047u,0x80000048u,0x80000049u,0x8000004au,0x717004b5u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6d6c04b7u,0x10004b6u,0x8000004bu,0x706f04b8u,0x737204b9u,0x10004bau,0x8000004cu,0x737204bcu,0x6e6d04bdu,0x626104beu,0x6d6c04bfu,0x10004c0u,0x8000004du,0x747304c2u,0x6a6904c3u,0x757404c4u,0x6a6904c5u,0x706f04c6u,0x6f6e04c7u,0x10004c8u,0x8000004eu,0x656404cau,0x6a6904cbu,0x767504ccu,0x747304cdu,0x10004ceu,0x8000004fu,0x6f6e04d0u,0x686704d1u,0x666504d2u,0x6f6e04d3u,0x757404d4u,0x10004d5u,0x80000050u,0x767504d7u,0x6e6d04d8u,0x666504d9u,0x10004dau,0x80000051u,0x737204dfu,0x0u,0x0u,0x626104e3u,0x6d6c04e0u,0x656404e1u,0x10004e2u,0x80000052u,0x717004e4u,0x4e4d04e5u,0x706f04e6u,0x656404e7u,0x666504e8u,0x343104e9u,0x10004ecu,0x10004edu,0x10004eeu,0x80000053u,0x80000054u,0x80000055u};
   uint32_t cur = 0x78610000u;
   for(int i = 0;cur!=0;++i) {
      uint32_t idx = cur&0xFFFFu;
      uint32_t low = (cur>>16u)&0xFFu;
      uint32_t high = (cur>>24u)&0xFFu;
      uint32_t c = (uint32_t)str[i];
      if(c>=low && c<high) {
         cur = table[idx+c-low];
      } else {
         break;
      }
      if(cur&0x80000000u) {
         return cur&0xFFFFu;
      }
      if(str[i]==0) {
         break;
      }
   }
   return -1;
}
static int info_hash(const char *str) {
   static const uint32_t table[] = {0x69680014u,0x6665001bu,0x796c0038u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6a610057u,0x0u,0x0u,0x6261006cu,0x0u,0x66650075u,0x706f007du,0x0u,0x7473008cu,0x6261008fu,0x62610015u,0x6f6e0016u,0x6f6e0017u,0x66650018u,0x6d6c0019u,0x100001au,0x8000000au,0x7466001cu,0x6261002au,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6463002fu,0x7675002bu,0x6d6c002cu,0x7574002du,0x100002eu,0x80000001u,0x73720030u,0x6a690031u,0x71700032u,0x75740033u,0x6a690034u,0x706f0035u,0x6f6e0036u,0x1000037u,0x80000004u,0x66650045u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x7574004fu,0x6e6d0046u,0x66650047u,0x6f6e0048u,0x75740049u,0x5554004au,0x7a79004bu,0x7170004cu,0x6665004du,0x100004eu,0x80000005u,0x66650050u,0x6f6e0051u,0x74730052u,0x6a690053u,0x706f0054u,0x6f6e0055u,0x1000056u,0x80000008u,0x79780060u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6f6e0066u,0x6a690061u,0x6e6d0062u,0x76750063u,0x6e6d0064u,0x1000065u,0x80000003u,0x6a690067u,0x6e6d0068u,0x76750069u,0x6e6d006au,0x100006bu,0x80000002u,0x7372006du,0x6261006eu,0x6e6d006fu,0x66650070u,0x75740071u,0x66650072u,0x73720073u,0x1000074u,0x80000009u,0x72710076u,0x76750077u,0x6a690078u,0x73720079u,0x6665007au,0x6564007bu,0x100007cu,0x80000000u,0x7675007eu,0x7372007fu,0x64630080u,0x66650081u,0x46450082u,0x79780083u,0x75740084u,0x66650085u,0x6f6e0086u,0x74730087u,0x6a690088u,0x706f0089u,0x6f6e008au,0x100008bu,0x80000007u,0x6665008du,0x100008eu,0x8000000bu,0x6d6c0090u,0x76750091u,0x66650092u,0x1000093u,0x80000006u};
   uint32_t cur = 0x77630000u;
   for(int i = 0;cur!=0;++i) {
      uint32_t idx = cur&0xFFFFu;
      uint32_t low = (cur>>16u)&0xFFu;
      uint32_t high = (cur>>24u)&0xFFu;
      uint32_t c = (uint32_t)str[i];
      if(c>=low && c<high) {
         cur = table[idx+c-low];
      } else {
         break;
      }
      if(cur&0x80000000u) {
         return cur&0xFFFFu;
      }
      if(str[i]==0) {
         break;
      }
   }
   return -1;
}
static const int32_t anari_true = 1;
static const int32_t anari_false = 0;
const char ** query_extensions() {
   static const char *extensions[] = {
      "ANARI_KHR_INSTANCE_TRANSFORM",
      "ANARI_KHR_VOLUME_TRANSFER_FUNCTION1D",
      "ANARI_KHR_CAMERA_ORTHOGRAPHIC",
      "ANARI_KHR_CAMERA_PERSPECTIVE",
      "ANARI_KHR_DEVICE_SYNCHRONIZATION",
      "ANARI_KHR_FRAME_CHANNEL_PRIMITIVE_ID",
      "ANARI_KHR_FRAME_CHANNEL_OBJECT_ID",
      "ANARI_KHR_FRAME_CHANNEL_INSTANCE_ID",
      "ANARI_KHR_FRAME_COMPLETION_CALLBACK",
      "ANARI_KHR_GEOMETRY_CONE",
      "ANARI_KHR_GEOMETRY_CURVE",
      "ANARI_KHR_GEOMETRY_CYLINDER",
      "ANARI_KHR_GEOMETRY_QUAD",
      "ANARI_KHR_GEOMETRY_SPHERE",
      "ANARI_KHR_GEOMETRY_TRIANGLE",
      "ANARI_KHR_INSTANCE_TRANSFORM_ARRAY",
      "ANARI_KHR_MATERIAL_MATTE",
      "ANARI_KHR_RENDERER_AMBIENT_LIGHT",
      "ANARI_KHR_RENDERER_BACKGROUND_COLOR",
      "ANARI_KHR_RENDERER_BACKGROUND_IMAGE",
      "ANARI_KHR_SAMPLER_IMAGE1D",
      "ANARI_KHR_SAMPLER_IMAGE2D",
      "ANARI_KHR_SAMPLER_IMAGE3D",
      "ANARI_KHR_SAMPLER_PRIMITIVE",
      "ANARI_KHR_SAMPLER_TRANSFORM",
      "ANARI_KHR_SPATIAL_FIELD_STRUCTURED_REGULAR",
      0
   };
   return extensions;
}
const char ** query_object_types(ANARIDataType type) {
   switch(type) {
      case ANARI_RENDERER:
      {
         static const char *ANARI_RENDERER_subtypes[] = {"default", 0};
         return ANARI_RENDERER_subtypes;
      }
      case ANARI_INSTANCE:
      {
         static const char *ANARI_INSTANCE_subtypes[] = {"transform", 0};
         return ANARI_INSTANCE_subtypes;
      }
      case ANARI_VOLUME:
      {
         static const char *ANARI_VOLUME_subtypes[] = {"transferFunction1D", 0};
         return ANARI_VOLUME_subtypes;
      }
      case ANARI_CAMERA:
      {
         static const char *ANARI_CAMERA_subtypes[] = {"orthographic", "perspective", 0};
         return ANARI_CAMERA_subtypes;
      }
      case ANARI_GEOMETRY:
      {
         static const char *ANARI_GEOMETRY_subtypes[] = {"cone", "curve", "cylinder", "quad", "sphere", "triangle", 0};
         return ANARI_GEOMETRY_subtypes;
      }
      case ANARI_MATERIAL:
      {
         static const char *ANARI_MATERIAL_subtypes[] = {"matte", 0};
         return ANARI_MATERIAL_subtypes;
      }
      case ANARI_SAMPLER:
      {
         static const char *ANARI_SAMPLER_subtypes[] = {"image1D", "image2D", "image3D", "primitive", "transform", 0};
         return ANARI_SAMPLER_subtypes;
      }
      case ANARI_SPATIAL_FIELD:
      {
         static const char *ANARI_SPATIAL_FIELD_subtypes[] = {"structuredRegular", 0};
         return ANARI_SPATIAL_FIELD_subtypes;
      }
      default:
      {
         static const char *none_subtypes[] = {0};
         return none_subtypes;
      }
   }
}
static const void * ANARI_DEVICE_allowInvalidMaterials_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_BOOL && infoType == ANARI_BOOL) {
            static const int8_t default_value[1] = {INT8_C(1)};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "show surfaces with invalid materials";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_DEVICE_invalidMaterialColor_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC4 && infoType == ANARI_FLOAT32_VEC4) {
            static const float default_value[4] = {1.000000f, 0.000000f, 1.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "color to identify surfaces with invalid materials";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_DEVICE_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_DEVICE_statusCallback_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "callback used to report information to the application";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_DEVICE_statusCallbackUserData_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional pointer passed as the first argument of the status callback";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_DEVICE_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 0:
         return ANARI_DEVICE_allowInvalidMaterials_info(paramType, infoName, infoType);
      case 38:
         return ANARI_DEVICE_invalidMaterialColor_info(paramType, infoName, infoType);
      case 42:
         return ANARI_DEVICE_name_info(paramType, infoName, infoType);
      case 61:
         return ANARI_DEVICE_statusCallback_info(paramType, infoName, infoType);
      case 62:
         return ANARI_DEVICE_statusCallbackUserData_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_RENDERER_default_mode_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "default";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "visualization modes (most for debugging)";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"default", "primID", "geomID", "instID", "Ng", "Ng.abs", "uvw", "backface", "hitSurface", "hitVolume", "geometry.attribute0", "geometry.attribute1", "geometry.attribute2", "geometry.attribute3", "geometry.color", "opacityHeatmap", nullptr};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_eyeLightBlendRatio_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {0.500000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 2: // minimum
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 3: // maximum
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "how much eye lighting factor should be used in default render mode";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_taskGrainSizeWidth_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_INT32 && infoType == ANARI_INT32) {
            static const int32_t default_value[1] = {INT32_C(4)};
            return default_value;
         } else {
            return nullptr;
         }
      case 2: // minimum
         if(paramType == ANARI_INT32 && infoType == ANARI_INT32) {
            static const int32_t default_value[1] = {INT32_C(1)};
            return default_value;
         } else {
            return nullptr;
         }
      case 3: // maximum
         if(paramType == ANARI_INT32 && infoType == ANARI_INT32) {
            static const int32_t default_value[1] = {INT32_C(128)};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "grain size of the render task along the width of the frame";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_taskGrainSizeHeight_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_INT32 && infoType == ANARI_INT32) {
            static const int32_t default_value[1] = {INT32_C(4)};
            return default_value;
         } else {
            return nullptr;
         }
      case 2: // minimum
         if(paramType == ANARI_INT32 && infoType == ANARI_INT32) {
            static const int32_t default_value[1] = {INT32_C(1)};
            return default_value;
         } else {
            return nullptr;
         }
      case 3: // maximum
         if(paramType == ANARI_INT32 && infoType == ANARI_INT32) {
            static const int32_t default_value[1] = {INT32_C(128)};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "grain size of the render task along the height of the frame";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_ambientColor_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC3 && infoType == ANARI_FLOAT32_VEC3) {
            static const float default_value[3] = {1.000000f, 1.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 11: // use
         if(infoType == ANARI_STRING) {
            return "color";
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "ambient light color";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_RENDERER_AMBIENT_LIGHT";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 17;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_ambientRadiance_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "the amount of light emitted by a point on the ambient light source in a direction, in W/sr/m^2";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_RENDERER_AMBIENT_LIGHT";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 17;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_background_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC4 && infoType == ANARI_FLOAT32_VEC4) {
            static const float default_value[4] = {0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 11: // use
         if(infoType == ANARI_STRING) {
            return "color";
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "the background color";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_RENDERER_BACKGROUND_COLOR";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 18;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 41:
         return ANARI_RENDERER_default_mode_info(paramType, infoName, infoType);
      case 22:
         return ANARI_RENDERER_default_eyeLightBlendRatio_info(paramType, infoName, infoType);
      case 65:
         return ANARI_RENDERER_default_taskGrainSizeWidth_info(paramType, infoName, infoType);
      case 64:
         return ANARI_RENDERER_default_taskGrainSizeHeight_info(paramType, infoName, infoType);
      case 42:
         return ANARI_RENDERER_default_name_info(paramType, infoName, infoType);
      case 3:
         return ANARI_RENDERER_default_ambientColor_info(paramType, infoName, infoType);
      case 4:
         return ANARI_RENDERER_default_ambientRadiance_info(paramType, infoName, infoType);
      case 11:
         return ANARI_RENDERER_default_background_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_INSTANCE_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 0;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_transform_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_MAT4 && infoType == ANARI_FLOAT32_MAT4) {
            static const float default_value[16] = {1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "transform applied to objects in the instance";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_INSTANCE_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 0;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_group_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "group object being instanced";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_INSTANCE_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 0;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_id_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "user id for instanceId channel";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_FRAME_CHANNEL_INSTANCE_ID";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 7;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_INSTANCE_transform_name_info(paramType, infoName, infoType);
      case 66:
         return ANARI_INSTANCE_transform_transform_info(paramType, infoName, infoType);
      case 29:
         return ANARI_INSTANCE_transform_group_info(paramType, infoName, infoType);
      case 31:
         return ANARI_INSTANCE_transform_id_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_ARRAY1D_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY1D_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_ARRAY1D_name_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_ARRAY2D_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY2D_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_ARRAY2D_name_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_ARRAY3D_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY3D_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_ARRAY3D_name_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_FRAME_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_world_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "world to be rendererd";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_renderer_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "renderer which renders the frame";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_camera_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "camera used to render the world";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_size_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "size of the frame in pixels (width, height)";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_channel_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "enables mapping the color channel as the type specified";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_DATA_TYPE && infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8_VEC4, ANARI_UFIXED8_RGBA_SRGB, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_channel_depth_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "enables mapping the color channel as the type specified";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_DATA_TYPE && infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_channel_primitiveId_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "enables mapping the primitiveId channel as the type specified";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_DATA_TYPE && infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_FRAME_CHANNEL_PRIMITIVE_ID";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 5;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_channel_objectId_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "enables mapping the objectId channel as the type specified";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_DATA_TYPE && infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_FRAME_CHANNEL_OBJECT_ID";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 6;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_channel_instanceId_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "enables mapping the instanceId channel as the type specified";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_DATA_TYPE && infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_FRAME_CHANNEL_INSTANCE_ID";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 7;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_frameCompletionCallback_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "function called on frame render completion";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_FRAME_COMPLETION_CALLBACK";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 8;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_frameCompletionCallbackUserData_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional pointer passed as the first argument of the frame continuation callback";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_FRAME_COMPLETION_CALLBACK";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 8;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_FRAME_name_info(paramType, infoName, infoType);
      case 82:
         return ANARI_FRAME_world_info(paramType, infoName, infoType);
      case 58:
         return ANARI_FRAME_renderer_info(paramType, infoName, infoType);
      case 12:
         return ANARI_FRAME_camera_info(paramType, infoName, infoType);
      case 59:
         return ANARI_FRAME_size_info(paramType, infoName, infoType);
      case 14:
         return ANARI_FRAME_channel_color_info(paramType, infoName, infoType);
      case 15:
         return ANARI_FRAME_channel_depth_info(paramType, infoName, infoType);
      case 18:
         return ANARI_FRAME_channel_primitiveId_info(paramType, infoName, infoType);
      case 17:
         return ANARI_FRAME_channel_objectId_info(paramType, infoName, infoType);
      case 16:
         return ANARI_FRAME_channel_instanceId_info(paramType, infoName, infoType);
      case 26:
         return ANARI_FRAME_frameCompletionCallback_info(paramType, infoName, infoType);
      case 27:
         return ANARI_FRAME_frameCompletionCallbackUserData_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_GROUP_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GROUP_surface_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of surface objects";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_SURFACE, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GROUP_volume_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of volume objects";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_VOLUME, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GROUP_light_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of light objects";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_LIGHT, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GROUP_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_GROUP_name_info(paramType, infoName, infoType);
      case 63:
         return ANARI_GROUP_surface_info(paramType, infoName, infoType);
      case 81:
         return ANARI_GROUP_volume_info(paramType, infoName, infoType);
      case 39:
         return ANARI_GROUP_light_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_WORLD_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_instance_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of instance objects in the world";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_INSTANCE, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_surface_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of non-instanced surface objects in the world";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_SURFACE, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_volume_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of non-instanced volume objects in the world";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_LIGHT, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_light_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of non-instanced light objects in the world";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_LIGHT, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_WORLD_name_info(paramType, infoName, infoType);
      case 37:
         return ANARI_WORLD_instance_info(paramType, infoName, infoType);
      case 63:
         return ANARI_WORLD_surface_info(paramType, infoName, infoType);
      case 81:
         return ANARI_WORLD_volume_info(paramType, infoName, infoType);
      case 39:
         return ANARI_WORLD_light_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SURFACE_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SURFACE_geometry_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "geometry object defining the surface geometry";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SURFACE_material_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "material object defining the surface appearance";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SURFACE_id_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "user id for objectId channel";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_FRAME_CHANNEL_OBJECT_ID";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 6;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SURFACE_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_SURFACE_name_info(paramType, infoName, infoType);
      case 28:
         return ANARI_SURFACE_geometry_info(paramType, infoName, infoType);
      case 40:
         return ANARI_SURFACE_material_info(paramType, infoName, infoType);
      case 31:
         return ANARI_SURFACE_id_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_VOLUME_transferFunction1D_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_VOLUME_TRANSFER_FUNCTION1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 1;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_VOLUME_transferFunction1D_value_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "spatial field used for the field values of the volume";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_VOLUME_TRANSFER_FUNCTION1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 1;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_VOLUME_transferFunction1D_valueRange_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_BOX1 && infoType == ANARI_FLOAT32_BOX1) {
            static const float default_value[2] = {0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "sampled values of field are clamped to this range";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_VOLUME_TRANSFER_FUNCTION1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 1;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_VOLUME_transferFunction1D_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "sampled color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_VOLUME_TRANSFER_FUNCTION1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 1;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_VOLUME_transferFunction1D_opacity_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "sampled opacity";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_VOLUME_TRANSFER_FUNCTION1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 1;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_VOLUME_transferFunction1D_unitDistance_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "makes volumes uniformly thinner or thicker";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_VOLUME_TRANSFER_FUNCTION1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 1;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_VOLUME_transferFunction1D_id_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "user id for objectId channel";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_FRAME_CHANNEL_OBJECT_ID";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 6;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_VOLUME_transferFunction1D_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_VOLUME_transferFunction1D_name_info(paramType, infoName, infoType);
      case 69:
         return ANARI_VOLUME_transferFunction1D_value_info(paramType, infoName, infoType);
      case 70:
         return ANARI_VOLUME_transferFunction1D_valueRange_info(paramType, infoName, infoType);
      case 19:
         return ANARI_VOLUME_transferFunction1D_color_info(paramType, infoName, infoType);
      case 44:
         return ANARI_VOLUME_transferFunction1D_opacity_info(paramType, infoName, infoType);
      case 67:
         return ANARI_VOLUME_transferFunction1D_unitDistance_info(paramType, infoName, infoType);
      case 31:
         return ANARI_VOLUME_transferFunction1D_id_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_ORTHOGRAPHIC";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 2;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_position_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC3 && infoType == ANARI_FLOAT32_VEC3) {
            static const float default_value[3] = {0.000000f, 0.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 11: // use
         if(infoType == ANARI_STRING) {
            return "point";
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "camera position";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_ORTHOGRAPHIC";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 2;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_direction_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC3 && infoType == ANARI_FLOAT32_VEC3) {
            static const float default_value[3] = {0.000000f, 0.000000f, -1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 11: // use
         if(infoType == ANARI_STRING) {
            return "direction";
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "main viewing direction";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_ORTHOGRAPHIC";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 2;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_up_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC3 && infoType == ANARI_FLOAT32_VEC3) {
            static const float default_value[3] = {0.000000f, 1.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 11: // use
         if(infoType == ANARI_STRING) {
            return "direction";
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "camera up direction";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_ORTHOGRAPHIC";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 2;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_imageRegion_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_BOX2 && infoType == ANARI_FLOAT32_BOX2) {
            static const float default_value[4] = {0.000000f, 0.000000f, 1.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "region mapped to the frame";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_ORTHOGRAPHIC";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 2;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_aspect_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "aspect ratio";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_ORTHOGRAPHIC";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 2;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_height_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "height of image plane";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_ORTHOGRAPHIC";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 2;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_near_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "near plane clip distance";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_ORTHOGRAPHIC";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 2;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_far_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "far plane clip distance";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_ORTHOGRAPHIC";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 2;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_CAMERA_orthographic_name_info(paramType, infoName, infoType);
      case 48:
         return ANARI_CAMERA_orthographic_position_info(paramType, infoName, infoType);
      case 21:
         return ANARI_CAMERA_orthographic_direction_info(paramType, infoName, infoType);
      case 68:
         return ANARI_CAMERA_orthographic_up_info(paramType, infoName, infoType);
      case 33:
         return ANARI_CAMERA_orthographic_imageRegion_info(paramType, infoName, infoType);
      case 6:
         return ANARI_CAMERA_orthographic_aspect_info(paramType, infoName, infoType);
      case 30:
         return ANARI_CAMERA_orthographic_height_info(paramType, infoName, infoType);
      case 43:
         return ANARI_CAMERA_orthographic_near_info(paramType, infoName, infoType);
      case 23:
         return ANARI_CAMERA_orthographic_far_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_PERSPECTIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 3;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_position_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC3 && infoType == ANARI_FLOAT32_VEC3) {
            static const float default_value[3] = {0.000000f, 0.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 11: // use
         if(infoType == ANARI_STRING) {
            return "point";
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "camera position";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_PERSPECTIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 3;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_direction_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC3 && infoType == ANARI_FLOAT32_VEC3) {
            static const float default_value[3] = {0.000000f, 0.000000f, -1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 11: // use
         if(infoType == ANARI_STRING) {
            return "direction";
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "main viewing direction";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_PERSPECTIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 3;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_up_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC3 && infoType == ANARI_FLOAT32_VEC3) {
            static const float default_value[3] = {0.000000f, 1.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 11: // use
         if(infoType == ANARI_STRING) {
            return "direction";
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "camera up direction";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_PERSPECTIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 3;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_imageRegion_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_BOX2 && infoType == ANARI_FLOAT32_BOX2) {
            static const float default_value[4] = {0.000000f, 0.000000f, 1.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "region mapped to the frame";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_PERSPECTIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 3;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_fovy_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {1.047198f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertical field of view in radians";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_PERSPECTIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 3;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_aspect_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "aspect ratio";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_PERSPECTIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 3;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_near_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "near plane clip distance";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_PERSPECTIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 3;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_far_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "far plane clip distance";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_PERSPECTIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 3;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_CAMERA_perspective_name_info(paramType, infoName, infoType);
      case 48:
         return ANARI_CAMERA_perspective_position_info(paramType, infoName, infoType);
      case 21:
         return ANARI_CAMERA_perspective_direction_info(paramType, infoName, infoType);
      case 68:
         return ANARI_CAMERA_perspective_up_info(paramType, infoName, infoType);
      case 33:
         return ANARI_CAMERA_perspective_imageRegion_info(paramType, infoName, infoType);
      case 25:
         return ANARI_CAMERA_perspective_fovy_info(paramType, infoName, infoType);
      case 6:
         return ANARI_CAMERA_perspective_aspect_info(paramType, infoName, infoType);
      case 43:
         return ANARI_CAMERA_perspective_near_info(paramType, infoName, infoType);
      case 23:
         return ANARI_CAMERA_perspective_far_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform color";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute0";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute1";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute2";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute3";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_primitive_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_primitive_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_primitive_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_primitive_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_primitive_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_primitive_id_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "primitive id";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UINT64, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_vertex_position_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex position";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32_VEC3, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_vertex_radius_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex radius";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_vertex_cap_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex cap type";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT8, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_vertex_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_vertex_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_vertex_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_vertex_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_vertex_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_primitive_index_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "index array";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32_VEC2, ANARI_UINT64_VEC2, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_caps_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "none";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "global cap type";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"none", "first", "second", "both", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 9;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_GEOMETRY_cone_name_info(paramType, infoName, infoType);
      case 19:
         return ANARI_GEOMETRY_cone_color_info(paramType, infoName, infoType);
      case 7:
         return ANARI_GEOMETRY_cone_attribute0_info(paramType, infoName, infoType);
      case 8:
         return ANARI_GEOMETRY_cone_attribute1_info(paramType, infoName, infoType);
      case 9:
         return ANARI_GEOMETRY_cone_attribute2_info(paramType, infoName, infoType);
      case 10:
         return ANARI_GEOMETRY_cone_attribute3_info(paramType, infoName, infoType);
      case 53:
         return ANARI_GEOMETRY_cone_primitive_color_info(paramType, infoName, infoType);
      case 49:
         return ANARI_GEOMETRY_cone_primitive_attribute0_info(paramType, infoName, infoType);
      case 50:
         return ANARI_GEOMETRY_cone_primitive_attribute1_info(paramType, infoName, infoType);
      case 51:
         return ANARI_GEOMETRY_cone_primitive_attribute2_info(paramType, infoName, infoType);
      case 52:
         return ANARI_GEOMETRY_cone_primitive_attribute3_info(paramType, infoName, infoType);
      case 54:
         return ANARI_GEOMETRY_cone_primitive_id_info(paramType, infoName, infoType);
      case 78:
         return ANARI_GEOMETRY_cone_vertex_position_info(paramType, infoName, infoType);
      case 79:
         return ANARI_GEOMETRY_cone_vertex_radius_info(paramType, infoName, infoType);
      case 75:
         return ANARI_GEOMETRY_cone_vertex_cap_info(paramType, infoName, infoType);
      case 76:
         return ANARI_GEOMETRY_cone_vertex_color_info(paramType, infoName, infoType);
      case 71:
         return ANARI_GEOMETRY_cone_vertex_attribute0_info(paramType, infoName, infoType);
      case 72:
         return ANARI_GEOMETRY_cone_vertex_attribute1_info(paramType, infoName, infoType);
      case 73:
         return ANARI_GEOMETRY_cone_vertex_attribute2_info(paramType, infoName, infoType);
      case 74:
         return ANARI_GEOMETRY_cone_vertex_attribute3_info(paramType, infoName, infoType);
      case 55:
         return ANARI_GEOMETRY_cone_primitive_index_info(paramType, infoName, infoType);
      case 13:
         return ANARI_GEOMETRY_cone_caps_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform color";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute0";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute1";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute2";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute3";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_primitive_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_primitive_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_primitive_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_primitive_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_primitive_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_primitive_id_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "primitive id";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UINT64, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_vertex_position_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex position";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32_VEC3, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_vertex_radius_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex radius";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_vertex_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_vertex_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_vertex_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_vertex_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_vertex_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_primitive_index_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "index array";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UINT64, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_radius_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "global radius";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 10;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_GEOMETRY_curve_name_info(paramType, infoName, infoType);
      case 19:
         return ANARI_GEOMETRY_curve_color_info(paramType, infoName, infoType);
      case 7:
         return ANARI_GEOMETRY_curve_attribute0_info(paramType, infoName, infoType);
      case 8:
         return ANARI_GEOMETRY_curve_attribute1_info(paramType, infoName, infoType);
      case 9:
         return ANARI_GEOMETRY_curve_attribute2_info(paramType, infoName, infoType);
      case 10:
         return ANARI_GEOMETRY_curve_attribute3_info(paramType, infoName, infoType);
      case 53:
         return ANARI_GEOMETRY_curve_primitive_color_info(paramType, infoName, infoType);
      case 49:
         return ANARI_GEOMETRY_curve_primitive_attribute0_info(paramType, infoName, infoType);
      case 50:
         return ANARI_GEOMETRY_curve_primitive_attribute1_info(paramType, infoName, infoType);
      case 51:
         return ANARI_GEOMETRY_curve_primitive_attribute2_info(paramType, infoName, infoType);
      case 52:
         return ANARI_GEOMETRY_curve_primitive_attribute3_info(paramType, infoName, infoType);
      case 54:
         return ANARI_GEOMETRY_curve_primitive_id_info(paramType, infoName, infoType);
      case 78:
         return ANARI_GEOMETRY_curve_vertex_position_info(paramType, infoName, infoType);
      case 79:
         return ANARI_GEOMETRY_curve_vertex_radius_info(paramType, infoName, infoType);
      case 76:
         return ANARI_GEOMETRY_curve_vertex_color_info(paramType, infoName, infoType);
      case 71:
         return ANARI_GEOMETRY_curve_vertex_attribute0_info(paramType, infoName, infoType);
      case 72:
         return ANARI_GEOMETRY_curve_vertex_attribute1_info(paramType, infoName, infoType);
      case 73:
         return ANARI_GEOMETRY_curve_vertex_attribute2_info(paramType, infoName, infoType);
      case 74:
         return ANARI_GEOMETRY_curve_vertex_attribute3_info(paramType, infoName, infoType);
      case 55:
         return ANARI_GEOMETRY_curve_primitive_index_info(paramType, infoName, infoType);
      case 57:
         return ANARI_GEOMETRY_curve_radius_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform color";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute0";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute1";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute2";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute3";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_primitive_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_primitive_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_primitive_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_primitive_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_primitive_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_primitive_id_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "primitive id";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UINT64, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_vertex_position_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex position";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32_VEC3, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_vertex_cap_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "cylinder cap type";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT8, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_vertex_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_vertex_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_vertex_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_vertex_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_vertex_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_primitive_index_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "index array";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32_VEC2, ANARI_UINT64_VEC2, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_primitive_radius_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "cylinder radius";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_radius_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "global cylinder radius";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_caps_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "none";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "global cylinder cap type";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"none", "first", "second", "both", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 11;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_GEOMETRY_cylinder_name_info(paramType, infoName, infoType);
      case 19:
         return ANARI_GEOMETRY_cylinder_color_info(paramType, infoName, infoType);
      case 7:
         return ANARI_GEOMETRY_cylinder_attribute0_info(paramType, infoName, infoType);
      case 8:
         return ANARI_GEOMETRY_cylinder_attribute1_info(paramType, infoName, infoType);
      case 9:
         return ANARI_GEOMETRY_cylinder_attribute2_info(paramType, infoName, infoType);
      case 10:
         return ANARI_GEOMETRY_cylinder_attribute3_info(paramType, infoName, infoType);
      case 53:
         return ANARI_GEOMETRY_cylinder_primitive_color_info(paramType, infoName, infoType);
      case 49:
         return ANARI_GEOMETRY_cylinder_primitive_attribute0_info(paramType, infoName, infoType);
      case 50:
         return ANARI_GEOMETRY_cylinder_primitive_attribute1_info(paramType, infoName, infoType);
      case 51:
         return ANARI_GEOMETRY_cylinder_primitive_attribute2_info(paramType, infoName, infoType);
      case 52:
         return ANARI_GEOMETRY_cylinder_primitive_attribute3_info(paramType, infoName, infoType);
      case 54:
         return ANARI_GEOMETRY_cylinder_primitive_id_info(paramType, infoName, infoType);
      case 78:
         return ANARI_GEOMETRY_cylinder_vertex_position_info(paramType, infoName, infoType);
      case 75:
         return ANARI_GEOMETRY_cylinder_vertex_cap_info(paramType, infoName, infoType);
      case 76:
         return ANARI_GEOMETRY_cylinder_vertex_color_info(paramType, infoName, infoType);
      case 71:
         return ANARI_GEOMETRY_cylinder_vertex_attribute0_info(paramType, infoName, infoType);
      case 72:
         return ANARI_GEOMETRY_cylinder_vertex_attribute1_info(paramType, infoName, infoType);
      case 73:
         return ANARI_GEOMETRY_cylinder_vertex_attribute2_info(paramType, infoName, infoType);
      case 74:
         return ANARI_GEOMETRY_cylinder_vertex_attribute3_info(paramType, infoName, infoType);
      case 55:
         return ANARI_GEOMETRY_cylinder_primitive_index_info(paramType, infoName, infoType);
      case 56:
         return ANARI_GEOMETRY_cylinder_primitive_radius_info(paramType, infoName, infoType);
      case 57:
         return ANARI_GEOMETRY_cylinder_radius_info(paramType, infoName, infoType);
      case 13:
         return ANARI_GEOMETRY_cylinder_caps_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform color";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute0";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute1";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute2";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute3";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_primitive_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_primitive_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_primitive_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_primitive_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_primitive_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_primitive_id_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "primitive id";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UINT64, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_vertex_position_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex position";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32_VEC3, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_vertex_normal_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex normal";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32_VEC3, ANARI_FIXED16_VEC3, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_vertex_tangent_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex normal";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32_VEC3, ANARI_FIXED16_VEC3, ANARI_FLOAT32_VEC4, ANARI_FIXED16_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_vertex_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_vertex_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_vertex_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_vertex_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_vertex_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_primitive_index_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "index array";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32_VEC4, ANARI_UINT64_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 12;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_GEOMETRY_quad_name_info(paramType, infoName, infoType);
      case 19:
         return ANARI_GEOMETRY_quad_color_info(paramType, infoName, infoType);
      case 7:
         return ANARI_GEOMETRY_quad_attribute0_info(paramType, infoName, infoType);
      case 8:
         return ANARI_GEOMETRY_quad_attribute1_info(paramType, infoName, infoType);
      case 9:
         return ANARI_GEOMETRY_quad_attribute2_info(paramType, infoName, infoType);
      case 10:
         return ANARI_GEOMETRY_quad_attribute3_info(paramType, infoName, infoType);
      case 53:
         return ANARI_GEOMETRY_quad_primitive_color_info(paramType, infoName, infoType);
      case 49:
         return ANARI_GEOMETRY_quad_primitive_attribute0_info(paramType, infoName, infoType);
      case 50:
         return ANARI_GEOMETRY_quad_primitive_attribute1_info(paramType, infoName, infoType);
      case 51:
         return ANARI_GEOMETRY_quad_primitive_attribute2_info(paramType, infoName, infoType);
      case 52:
         return ANARI_GEOMETRY_quad_primitive_attribute3_info(paramType, infoName, infoType);
      case 54:
         return ANARI_GEOMETRY_quad_primitive_id_info(paramType, infoName, infoType);
      case 78:
         return ANARI_GEOMETRY_quad_vertex_position_info(paramType, infoName, infoType);
      case 77:
         return ANARI_GEOMETRY_quad_vertex_normal_info(paramType, infoName, infoType);
      case 80:
         return ANARI_GEOMETRY_quad_vertex_tangent_info(paramType, infoName, infoType);
      case 76:
         return ANARI_GEOMETRY_quad_vertex_color_info(paramType, infoName, infoType);
      case 71:
         return ANARI_GEOMETRY_quad_vertex_attribute0_info(paramType, infoName, infoType);
      case 72:
         return ANARI_GEOMETRY_quad_vertex_attribute1_info(paramType, infoName, infoType);
      case 73:
         return ANARI_GEOMETRY_quad_vertex_attribute2_info(paramType, infoName, infoType);
      case 74:
         return ANARI_GEOMETRY_quad_vertex_attribute3_info(paramType, infoName, infoType);
      case 55:
         return ANARI_GEOMETRY_quad_primitive_index_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform color";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute0";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute1";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute2";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute3";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_primitive_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_primitive_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_primitive_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_primitive_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_primitive_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_primitive_id_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "primitive id";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UINT64, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_vertex_position_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "sphere position";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32_VEC3, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_vertex_radius_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "sphere radius";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_vertex_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_vertex_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_vertex_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_vertex_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_vertex_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_primitive_index_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "index array";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UINT64, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_radius_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "global sphere radius";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 13;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_GEOMETRY_sphere_name_info(paramType, infoName, infoType);
      case 19:
         return ANARI_GEOMETRY_sphere_color_info(paramType, infoName, infoType);
      case 7:
         return ANARI_GEOMETRY_sphere_attribute0_info(paramType, infoName, infoType);
      case 8:
         return ANARI_GEOMETRY_sphere_attribute1_info(paramType, infoName, infoType);
      case 9:
         return ANARI_GEOMETRY_sphere_attribute2_info(paramType, infoName, infoType);
      case 10:
         return ANARI_GEOMETRY_sphere_attribute3_info(paramType, infoName, infoType);
      case 53:
         return ANARI_GEOMETRY_sphere_primitive_color_info(paramType, infoName, infoType);
      case 49:
         return ANARI_GEOMETRY_sphere_primitive_attribute0_info(paramType, infoName, infoType);
      case 50:
         return ANARI_GEOMETRY_sphere_primitive_attribute1_info(paramType, infoName, infoType);
      case 51:
         return ANARI_GEOMETRY_sphere_primitive_attribute2_info(paramType, infoName, infoType);
      case 52:
         return ANARI_GEOMETRY_sphere_primitive_attribute3_info(paramType, infoName, infoType);
      case 54:
         return ANARI_GEOMETRY_sphere_primitive_id_info(paramType, infoName, infoType);
      case 78:
         return ANARI_GEOMETRY_sphere_vertex_position_info(paramType, infoName, infoType);
      case 79:
         return ANARI_GEOMETRY_sphere_vertex_radius_info(paramType, infoName, infoType);
      case 76:
         return ANARI_GEOMETRY_sphere_vertex_color_info(paramType, infoName, infoType);
      case 71:
         return ANARI_GEOMETRY_sphere_vertex_attribute0_info(paramType, infoName, infoType);
      case 72:
         return ANARI_GEOMETRY_sphere_vertex_attribute1_info(paramType, infoName, infoType);
      case 73:
         return ANARI_GEOMETRY_sphere_vertex_attribute2_info(paramType, infoName, infoType);
      case 74:
         return ANARI_GEOMETRY_sphere_vertex_attribute3_info(paramType, infoName, infoType);
      case 55:
         return ANARI_GEOMETRY_sphere_primitive_index_info(paramType, infoName, infoType);
      case 57:
         return ANARI_GEOMETRY_sphere_radius_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform color";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute0";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute1";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute2";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "uniform attribute3";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_primitive_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_primitive_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_primitive_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_primitive_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_primitive_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "per primitive attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_primitive_id_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "primitive id";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32, ANARI_UINT64, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_vertex_position_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex position";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32_VEC3, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_vertex_normal_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex normal";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32_VEC3, ANARI_FIXED16_VEC3, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_vertex_tangent_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex normal";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32_VEC3, ANARI_FIXED16_VEC3, ANARI_FLOAT32_VEC4, ANARI_FIXED16_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_vertex_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex color";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_vertex_attribute0_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute0";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_vertex_attribute1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute1";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_vertex_attribute2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute2";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_vertex_attribute3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "vertex attribute3";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_primitive_index_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "index array";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT32_VEC3, ANARI_UINT64_VEC3, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 14;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_GEOMETRY_triangle_name_info(paramType, infoName, infoType);
      case 19:
         return ANARI_GEOMETRY_triangle_color_info(paramType, infoName, infoType);
      case 7:
         return ANARI_GEOMETRY_triangle_attribute0_info(paramType, infoName, infoType);
      case 8:
         return ANARI_GEOMETRY_triangle_attribute1_info(paramType, infoName, infoType);
      case 9:
         return ANARI_GEOMETRY_triangle_attribute2_info(paramType, infoName, infoType);
      case 10:
         return ANARI_GEOMETRY_triangle_attribute3_info(paramType, infoName, infoType);
      case 53:
         return ANARI_GEOMETRY_triangle_primitive_color_info(paramType, infoName, infoType);
      case 49:
         return ANARI_GEOMETRY_triangle_primitive_attribute0_info(paramType, infoName, infoType);
      case 50:
         return ANARI_GEOMETRY_triangle_primitive_attribute1_info(paramType, infoName, infoType);
      case 51:
         return ANARI_GEOMETRY_triangle_primitive_attribute2_info(paramType, infoName, infoType);
      case 52:
         return ANARI_GEOMETRY_triangle_primitive_attribute3_info(paramType, infoName, infoType);
      case 54:
         return ANARI_GEOMETRY_triangle_primitive_id_info(paramType, infoName, infoType);
      case 78:
         return ANARI_GEOMETRY_triangle_vertex_position_info(paramType, infoName, infoType);
      case 77:
         return ANARI_GEOMETRY_triangle_vertex_normal_info(paramType, infoName, infoType);
      case 80:
         return ANARI_GEOMETRY_triangle_vertex_tangent_info(paramType, infoName, infoType);
      case 76:
         return ANARI_GEOMETRY_triangle_vertex_color_info(paramType, infoName, infoType);
      case 71:
         return ANARI_GEOMETRY_triangle_vertex_attribute0_info(paramType, infoName, infoType);
      case 72:
         return ANARI_GEOMETRY_triangle_vertex_attribute1_info(paramType, infoName, infoType);
      case 73:
         return ANARI_GEOMETRY_triangle_vertex_attribute2_info(paramType, infoName, infoType);
      case 74:
         return ANARI_GEOMETRY_triangle_vertex_attribute3_info(paramType, infoName, infoType);
      case 55:
         return ANARI_GEOMETRY_triangle_primitive_index_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_MATERIAL_matte_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_MATERIAL_MATTE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 16;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_MATERIAL_matte_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC3 && infoType == ANARI_FLOAT32_VEC3) {
            static const float default_value[3] = {0.800000f, 0.800000f, 0.800000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 11: // use
         if(infoType == ANARI_STRING) {
            return "color";
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "diffuse color";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"color", "worldPosition", "worldNormal", "objectPosition", "objectNormal", "attribute0", "attribute1", "attribute2", "attribute3", "primitiveId", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_MATERIAL_MATTE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 16;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_MATERIAL_matte_opacity_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "opacity";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"color", "worldPosition", "worldNormal", "objectPosition", "objectNormal", "attribute0", "attribute1", "attribute2", "attribute3", "primitiveId", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_MATERIAL_MATTE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 16;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_MATERIAL_matte_alphaMode_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "opaque";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "alpha mode";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"opaque", "blend", "mask", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_MATERIAL_MATTE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 16;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_MATERIAL_matte_alphaCutoff_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {0.500000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "cutoff for alpha mask mode";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_MATERIAL_MATTE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 16;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_MATERIAL_matte_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_MATERIAL_matte_name_info(paramType, infoName, infoType);
      case 19:
         return ANARI_MATERIAL_matte_color_info(paramType, infoName, infoType);
      case 44:
         return ANARI_MATERIAL_matte_opacity_info(paramType, infoName, infoType);
      case 2:
         return ANARI_MATERIAL_matte_alphaMode_info(paramType, infoName, infoType);
      case 1:
         return ANARI_MATERIAL_matte_alphaCutoff_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 20;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_image_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array backing the sampler";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 20;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_inAttribute_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "attribute0";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "input surface attribute (texture coordinate)";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"color", "worldPosition", "worldNormal", "objectPosition", "objectNormal", "attribute0", "attribute1", "attribute2", "attribute3", "primitiveId", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 20;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_filter_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "nearest";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "filter mode";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"nearest", "linear", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 20;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_wrapMode1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "clampToEdge";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "wrap mode for the 1st dimension";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"clampToEdge", "repeat", "mirrorRepeat", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 20;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_inTransform_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_MAT4 && infoType == ANARI_FLOAT32_MAT4) {
            static const float default_value[16] = {1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "transform applied to the input attribute before sampling";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 20;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_inOffset_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC4 && infoType == ANARI_FLOAT32_VEC4) {
            static const float default_value[4] = {0.000000f, 0.000000f, 0.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "offset added to output inTransform result";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 20;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_outTransform_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_MAT4 && infoType == ANARI_FLOAT32_MAT4) {
            static const float default_value[16] = {1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "transform applied to the sampled values";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 20;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_outOffset_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC4 && infoType == ANARI_FLOAT32_VEC4) {
            static const float default_value[4] = {0.000000f, 0.000000f, 0.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "offset added to output outTransform result";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 20;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_SAMPLER_image1D_name_info(paramType, infoName, infoType);
      case 32:
         return ANARI_SAMPLER_image1D_image_info(paramType, infoName, infoType);
      case 34:
         return ANARI_SAMPLER_image1D_inAttribute_info(paramType, infoName, infoType);
      case 24:
         return ANARI_SAMPLER_image1D_filter_info(paramType, infoName, infoType);
      case 83:
         return ANARI_SAMPLER_image1D_wrapMode1_info(paramType, infoName, infoType);
      case 36:
         return ANARI_SAMPLER_image1D_inTransform_info(paramType, infoName, infoType);
      case 35:
         return ANARI_SAMPLER_image1D_inOffset_info(paramType, infoName, infoType);
      case 47:
         return ANARI_SAMPLER_image1D_outTransform_info(paramType, infoName, infoType);
      case 46:
         return ANARI_SAMPLER_image1D_outOffset_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 21;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_image_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array backing the sampler";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 21;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_inAttribute_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "attribute0";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "input surface attribute (texture coordinate)";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"color", "worldPosition", "worldNormal", "objectPosition", "objectNormal", "attribute0", "attribute1", "attribute2", "attribute3", "primitiveId", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 21;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_filter_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "nearest";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "filter mode";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"nearest", "linear", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 21;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_wrapMode1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "clampToEdge";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "wrap mode for the 1st dimension";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"clampToEdge", "repeat", "mirrorRepeat", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 21;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_wrapMode2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "clampToEdge";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "wrap mode for the 2nd dimension";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"clampToEdge", "repeat", "mirrorRepeat", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 21;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_inTransform_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_MAT4 && infoType == ANARI_FLOAT32_MAT4) {
            static const float default_value[16] = {1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "transform applied to the input attribute before sampling";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 21;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_inOffset_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC4 && infoType == ANARI_FLOAT32_VEC4) {
            static const float default_value[4] = {0.000000f, 0.000000f, 0.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "offset added to output inTransform result";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 21;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_outTransform_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_MAT4 && infoType == ANARI_FLOAT32_MAT4) {
            static const float default_value[16] = {1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "transform applied to the sampled values";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 21;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_outOffset_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC4 && infoType == ANARI_FLOAT32_VEC4) {
            static const float default_value[4] = {0.000000f, 0.000000f, 0.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "offset added to output outTransform result";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 21;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_SAMPLER_image2D_name_info(paramType, infoName, infoType);
      case 32:
         return ANARI_SAMPLER_image2D_image_info(paramType, infoName, infoType);
      case 34:
         return ANARI_SAMPLER_image2D_inAttribute_info(paramType, infoName, infoType);
      case 24:
         return ANARI_SAMPLER_image2D_filter_info(paramType, infoName, infoType);
      case 83:
         return ANARI_SAMPLER_image2D_wrapMode1_info(paramType, infoName, infoType);
      case 84:
         return ANARI_SAMPLER_image2D_wrapMode2_info(paramType, infoName, infoType);
      case 36:
         return ANARI_SAMPLER_image2D_inTransform_info(paramType, infoName, infoType);
      case 35:
         return ANARI_SAMPLER_image2D_inOffset_info(paramType, infoName, infoType);
      case 47:
         return ANARI_SAMPLER_image2D_outTransform_info(paramType, infoName, infoType);
      case 46:
         return ANARI_SAMPLER_image2D_outOffset_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_image_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array backing the sampler";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_inAttribute_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "attribute0";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "input surface attribute (texture coordinate)";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"color", "worldPosition", "worldNormal", "objectPosition", "objectNormal", "attribute0", "attribute1", "attribute2", "attribute3", "primitiveId", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_filter_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "nearest";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "filter mode";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"nearest", "linear", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_wrapMode1_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "clampToEdge";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "wrap mode for the 1st dimension";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"clampToEdge", "repeat", "mirrorRepeat", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_wrapMode2_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "clampToEdge";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "wrap mode for the 2nd dimension";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"clampToEdge", "repeat", "mirrorRepeat", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_wrapMode3_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "clampToEdge";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "wrap mode for the 3rd dimension";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"clampToEdge", "repeat", "mirrorRepeat", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_inTransform_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_MAT4 && infoType == ANARI_FLOAT32_MAT4) {
            static const float default_value[16] = {1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "transform applied to the input attribute before sampling";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_inOffset_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC4 && infoType == ANARI_FLOAT32_VEC4) {
            static const float default_value[4] = {0.000000f, 0.000000f, 0.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "offset added to output inTransform result";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_outTransform_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_MAT4 && infoType == ANARI_FLOAT32_MAT4) {
            static const float default_value[16] = {1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "transform applied to the sampled values";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_outOffset_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC4 && infoType == ANARI_FLOAT32_VEC4) {
            static const float default_value[4] = {0.000000f, 0.000000f, 0.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "offset added to output outTransform result";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 22;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_SAMPLER_image3D_name_info(paramType, infoName, infoType);
      case 32:
         return ANARI_SAMPLER_image3D_image_info(paramType, infoName, infoType);
      case 34:
         return ANARI_SAMPLER_image3D_inAttribute_info(paramType, infoName, infoType);
      case 24:
         return ANARI_SAMPLER_image3D_filter_info(paramType, infoName, infoType);
      case 83:
         return ANARI_SAMPLER_image3D_wrapMode1_info(paramType, infoName, infoType);
      case 84:
         return ANARI_SAMPLER_image3D_wrapMode2_info(paramType, infoName, infoType);
      case 85:
         return ANARI_SAMPLER_image3D_wrapMode3_info(paramType, infoName, infoType);
      case 36:
         return ANARI_SAMPLER_image3D_inTransform_info(paramType, infoName, infoType);
      case 35:
         return ANARI_SAMPLER_image3D_inOffset_info(paramType, infoName, infoType);
      case 47:
         return ANARI_SAMPLER_image3D_outTransform_info(paramType, infoName, infoType);
      case 46:
         return ANARI_SAMPLER_image3D_outOffset_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SAMPLER_primitive_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_PRIMITIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 23;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_primitive_array_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "backing array of the sampler";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8, ANARI_UFIXED8_VEC2, ANARI_UFIXED8_VEC3, ANARI_UFIXED8_VEC4, ANARI_UFIXED8_R_SRGB, ANARI_UFIXED8_RA_SRGB, ANARI_UFIXED8_RGB_SRGB, ANARI_UFIXED8_RGBA_SRGB, ANARI_UFIXED16, ANARI_UFIXED16_VEC2, ANARI_UFIXED16_VEC3, ANARI_UFIXED16_VEC4, ANARI_UFIXED32, ANARI_UFIXED32_VEC2, ANARI_UFIXED32_VEC3, ANARI_UFIXED32_VEC4, ANARI_FLOAT32, ANARI_FLOAT32_VEC2, ANARI_FLOAT32_VEC3, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_PRIMITIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 23;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_primitive_inOffset_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_UINT64 && infoType == ANARI_UINT64) {
            static const uint64_t default_value[1] = {UINT64_C(0)};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "offset added to primitiveId";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_PRIMITIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 23;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_primitive_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_SAMPLER_primitive_name_info(paramType, infoName, infoType);
      case 5:
         return ANARI_SAMPLER_primitive_array_info(paramType, infoName, infoType);
      case 35:
         return ANARI_SAMPLER_primitive_inOffset_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SAMPLER_transform_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 24;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_transform_inAttribute_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "attribute0";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "input surface attribute (texture coordinate)";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"color", "worldPosition", "worldNormal", "objectPosition", "objectNormal", "attribute0", "attribute1", "attribute2", "attribute3", "primitiveId", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 24;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_transform_outTransform_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_MAT4 && infoType == ANARI_FLOAT32_MAT4) {
            static const float default_value[16] = {1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "transform applied to the input attribute";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 24;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_transform_outOffset_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC4 && infoType == ANARI_FLOAT32_VEC4) {
            static const float default_value[4] = {0.000000f, 0.000000f, 0.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "offset added to output outTransform result";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 24;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_transform_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_SAMPLER_transform_name_info(paramType, infoName, infoType);
      case 34:
         return ANARI_SAMPLER_transform_inAttribute_info(paramType, infoName, infoType);
      case 47:
         return ANARI_SAMPLER_transform_outTransform_info(paramType, infoName, infoType);
      case 46:
         return ANARI_SAMPLER_transform_outOffset_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SPATIAL_FIELD_structuredRegular_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SPATIAL_FIELD_STRUCTURED_REGULAR";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 25;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SPATIAL_FIELD_structuredRegular_data_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of vertex centered scalar values";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UINT8, ANARI_INT16, ANARI_UINT16, ANARI_FLOAT32, ANARI_FLOAT64, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SPATIAL_FIELD_STRUCTURED_REGULAR";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 25;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SPATIAL_FIELD_structuredRegular_origin_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC3 && infoType == ANARI_FLOAT32_VEC3) {
            static const float default_value[3] = {0.000000f, 0.000000f, 0.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "origin of the grid in object-space";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SPATIAL_FIELD_STRUCTURED_REGULAR";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 25;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SPATIAL_FIELD_structuredRegular_spacing_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC3 && infoType == ANARI_FLOAT32_VEC3) {
            static const float default_value[3] = {1.000000f, 1.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "size of the grid cells in object-space";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SPATIAL_FIELD_STRUCTURED_REGULAR";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 25;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SPATIAL_FIELD_structuredRegular_filter_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_STRING && infoType == ANARI_STRING) {
            static const char *default_value = "linear";
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "filter mode used to interpolate the grid";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_STRING && infoType == ANARI_STRING_LIST) {
            static const char *values[] = {"nearest", "linear", nullptr};
            return values;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SPATIAL_FIELD_STRUCTURED_REGULAR";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 25;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SPATIAL_FIELD_structuredRegular_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 42:
         return ANARI_SPATIAL_FIELD_structuredRegular_name_info(paramType, infoName, infoType);
      case 20:
         return ANARI_SPATIAL_FIELD_structuredRegular_data_info(paramType, infoName, infoType);
      case 45:
         return ANARI_SPATIAL_FIELD_structuredRegular_origin_info(paramType, infoName, infoType);
      case 60:
         return ANARI_SPATIAL_FIELD_structuredRegular_spacing_info(paramType, infoName, infoType);
      case 24:
         return ANARI_SPATIAL_FIELD_structuredRegular_filter_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_CAMERA_param_info(const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 8:
         return ANARI_CAMERA_orthographic_param_info(paramName, paramType, infoName, infoType);
      case 9:
         return ANARI_CAMERA_perspective_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_GEOMETRY_param_info(const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 0:
         return ANARI_GEOMETRY_cone_param_info(paramName, paramType, infoName, infoType);
      case 1:
         return ANARI_GEOMETRY_curve_param_info(paramName, paramType, infoName, infoType);
      case 2:
         return ANARI_GEOMETRY_cylinder_param_info(paramName, paramType, infoName, infoType);
      case 11:
         return ANARI_GEOMETRY_quad_param_info(paramName, paramType, infoName, infoType);
      case 12:
         return ANARI_GEOMETRY_sphere_param_info(paramName, paramType, infoName, infoType);
      case 16:
         return ANARI_GEOMETRY_triangle_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_INSTANCE_param_info(const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 15:
         return ANARI_INSTANCE_transform_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_MATERIAL_param_info(const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 7:
         return ANARI_MATERIAL_matte_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_RENDERER_param_info(const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 3:
         return ANARI_RENDERER_default_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SAMPLER_param_info(const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 4:
         return ANARI_SAMPLER_image1D_param_info(paramName, paramType, infoName, infoType);
      case 5:
         return ANARI_SAMPLER_image2D_param_info(paramName, paramType, infoName, infoType);
      case 6:
         return ANARI_SAMPLER_image3D_param_info(paramName, paramType, infoName, infoType);
      case 10:
         return ANARI_SAMPLER_primitive_param_info(paramName, paramType, infoName, infoType);
      case 15:
         return ANARI_SAMPLER_transform_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SPATIAL_FIELD_param_info(const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 13:
         return ANARI_SPATIAL_FIELD_structuredRegular_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_VOLUME_param_info(const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 14:
         return ANARI_VOLUME_transferFunction1D_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
const void * query_param_info_enum(ANARIDataType type, const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(type) {
      case ANARI_CAMERA:
         return ANARI_CAMERA_param_info(subtype, paramName, paramType, infoName, infoType);
      case ANARI_GEOMETRY:
         return ANARI_GEOMETRY_param_info(subtype, paramName, paramType, infoName, infoType);
      case ANARI_INSTANCE:
         return ANARI_INSTANCE_param_info(subtype, paramName, paramType, infoName, infoType);
      case ANARI_MATERIAL:
         return ANARI_MATERIAL_param_info(subtype, paramName, paramType, infoName, infoType);
      case ANARI_RENDERER:
         return ANARI_RENDERER_param_info(subtype, paramName, paramType, infoName, infoType);
      case ANARI_SAMPLER:
         return ANARI_SAMPLER_param_info(subtype, paramName, paramType, infoName, infoType);
      case ANARI_SPATIAL_FIELD:
         return ANARI_SPATIAL_FIELD_param_info(subtype, paramName, paramType, infoName, infoType);
      case ANARI_VOLUME:
         return ANARI_VOLUME_param_info(subtype, paramName, paramType, infoName, infoType);
      case ANARI_DEVICE:
         return ANARI_DEVICE_param_info(paramName, paramType, infoName, infoType);
      case ANARI_ARRAY1D:
         return ANARI_ARRAY1D_param_info(paramName, paramType, infoName, infoType);
      case ANARI_ARRAY2D:
         return ANARI_ARRAY2D_param_info(paramName, paramType, infoName, infoType);
      case ANARI_ARRAY3D:
         return ANARI_ARRAY3D_param_info(paramName, paramType, infoName, infoType);
      case ANARI_FRAME:
         return ANARI_FRAME_param_info(paramName, paramType, infoName, infoType);
      case ANARI_GROUP:
         return ANARI_GROUP_param_info(paramName, paramType, infoName, infoType);
      case ANARI_WORLD:
         return ANARI_WORLD_param_info(paramName, paramType, infoName, infoType);
      case ANARI_SURFACE:
         return ANARI_SURFACE_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
const void * query_param_info(ANARIDataType type, const char *subtype, const char *paramName, ANARIDataType paramType, const char *infoNameString, ANARIDataType infoType) {
   int infoName = info_hash(infoNameString);
   return query_param_info_enum(type, subtype, paramName, paramType, infoName, infoType);
}
static const void * ANARI_DEVICE_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "device object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"allowInvalidMaterials", ANARI_BOOL},
               {"invalidMaterialColor", ANARI_FLOAT32_VEC4},
               {"name", ANARI_STRING},
               {"statusCallback", ANARI_STATUS_CALLBACK},
               {"statusCallbackUserData", ANARI_VOID_POINTER},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 8: // extension
         if(infoType == ANARI_STRING_LIST) {
            static const char *extensions[] = {
               "ANARI_KHR_INSTANCE_TRANSFORM",
               "ANARI_KHR_VOLUME_TRANSFER_FUNCTION1D",
               "ANARI_KHR_CAMERA_ORTHOGRAPHIC",
               "ANARI_KHR_CAMERA_PERSPECTIVE",
               "ANARI_KHR_DEVICE_SYNCHRONIZATION",
               "ANARI_KHR_FRAME_CHANNEL_PRIMITIVE_ID",
               "ANARI_KHR_FRAME_CHANNEL_OBJECT_ID",
               "ANARI_KHR_FRAME_CHANNEL_INSTANCE_ID",
               "ANARI_KHR_FRAME_COMPLETION_CALLBACK",
               "ANARI_KHR_GEOMETRY_CONE",
               "ANARI_KHR_GEOMETRY_CURVE",
               "ANARI_KHR_GEOMETRY_CYLINDER",
               "ANARI_KHR_GEOMETRY_QUAD",
               "ANARI_KHR_GEOMETRY_SPHERE",
               "ANARI_KHR_GEOMETRY_TRIANGLE",
               "ANARI_KHR_INSTANCE_TRANSFORM_ARRAY",
               "ANARI_KHR_MATERIAL_MATTE",
               "ANARI_KHR_RENDERER_AMBIENT_LIGHT",
               "ANARI_KHR_RENDERER_BACKGROUND_COLOR",
               "ANARI_KHR_RENDERER_BACKGROUND_IMAGE",
               "ANARI_KHR_SAMPLER_IMAGE1D",
               "ANARI_KHR_SAMPLER_IMAGE2D",
               "ANARI_KHR_SAMPLER_IMAGE3D",
               "ANARI_KHR_SAMPLER_PRIMITIVE",
               "ANARI_KHR_SAMPLER_TRANSFORM",
               "ANARI_KHR_SPATIAL_FIELD_STRUCTURED_REGULAR",
               0
            };
            return extensions;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "default renderer";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"mode", ANARI_STRING},
               {"eyeLightBlendRatio", ANARI_FLOAT32},
               {"taskGrainSizeWidth", ANARI_INT32},
               {"taskGrainSizeHeight", ANARI_INT32},
               {"name", ANARI_STRING},
               {"ambientColor", ANARI_FLOAT32_VEC3},
               {"ambientRadiance", ANARI_FLOAT32},
               {"background", ANARI_FLOAT32_VEC4},
               {"background", ANARI_ARRAY2D},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 8: // extension
         if(infoType == ANARI_STRING_LIST) {
            static const char *extensions[] = {
               "ANARI_KHR_INSTANCE_TRANSFORM",
               "ANARI_KHR_VOLUME_TRANSFER_FUNCTION1D",
               "ANARI_KHR_CAMERA_ORTHOGRAPHIC",
               "ANARI_KHR_CAMERA_PERSPECTIVE",
               "ANARI_KHR_DEVICE_SYNCHRONIZATION",
               "ANARI_KHR_FRAME_CHANNEL_PRIMITIVE_ID",
               "ANARI_KHR_FRAME_CHANNEL_OBJECT_ID",
               "ANARI_KHR_FRAME_CHANNEL_INSTANCE_ID",
               "ANARI_KHR_FRAME_COMPLETION_CALLBACK",
               "ANARI_KHR_GEOMETRY_CONE",
               "ANARI_KHR_GEOMETRY_CURVE",
               "ANARI_KHR_GEOMETRY_CYLINDER",
               "ANARI_KHR_GEOMETRY_QUAD",
               "ANARI_KHR_GEOMETRY_SPHERE",
               "ANARI_KHR_GEOMETRY_TRIANGLE",
               "ANARI_KHR_INSTANCE_TRANSFORM_ARRAY",
               "ANARI_KHR_MATERIAL_MATTE",
               "ANARI_KHR_RENDERER_AMBIENT_LIGHT",
               "ANARI_KHR_RENDERER_BACKGROUND_COLOR",
               "ANARI_KHR_RENDERER_BACKGROUND_IMAGE",
               "ANARI_KHR_SAMPLER_IMAGE1D",
               "ANARI_KHR_SAMPLER_IMAGE2D",
               "ANARI_KHR_SAMPLER_IMAGE3D",
               "ANARI_KHR_SAMPLER_PRIMITIVE",
               "ANARI_KHR_SAMPLER_TRANSFORM",
               "ANARI_KHR_SPATIAL_FIELD_STRUCTURED_REGULAR",
               0
            };
            return extensions;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "instance object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"transform", ANARI_FLOAT32_MAT4},
               {"transform", ANARI_ARRAY1D},
               {"group", ANARI_GROUP},
               {"id", ANARI_UINT32},
               {"id", ANARI_ARRAY1D},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_INSTANCE_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 0;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY1D_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "one dimensional array object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY2D_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "two dimensional array object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY3D_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "three dimensional array object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "frame object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"world", ANARI_WORLD},
               {"renderer", ANARI_RENDERER},
               {"camera", ANARI_CAMERA},
               {"size", ANARI_UINT32_VEC2},
               {"channel.color", ANARI_DATA_TYPE},
               {"channel.depth", ANARI_DATA_TYPE},
               {"channel.primitiveId", ANARI_DATA_TYPE},
               {"channel.objectId", ANARI_DATA_TYPE},
               {"channel.instanceId", ANARI_DATA_TYPE},
               {"frameCompletionCallback", ANARI_FRAME_COMPLETION_CALLBACK},
               {"frameCompletionCallbackUserData", ANARI_VOID_POINTER},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 10: // channel
         if(infoType == ANARI_STRING_LIST) {
            static const char *channel[] = {
               "channel.color",
               "channel.depth",
               "channel.primitiveId",
               "channel.objectId",
               "channel.instanceId",
               0
            };
            return channel;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GROUP_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "group object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"surface", ANARI_ARRAY1D},
               {"volume", ANARI_ARRAY1D},
               {"light", ANARI_ARRAY1D},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "world object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"instance", ANARI_ARRAY1D},
               {"surface", ANARI_ARRAY1D},
               {"volume", ANARI_ARRAY1D},
               {"light", ANARI_ARRAY1D},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SURFACE_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "surface object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"geometry", ANARI_GEOMETRY},
               {"material", ANARI_MATERIAL},
               {"id", ANARI_UINT32},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_VOLUME_transferFunction1D_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "transferFunction1D volume object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"value", ANARI_SPATIAL_FIELD},
               {"valueRange", ANARI_FLOAT32_BOX1},
               {"valueRange", ANARI_FLOAT64_BOX1},
               {"color", ANARI_FLOAT32_VEC4},
               {"color", ANARI_FLOAT32_VEC3},
               {"color", ANARI_ARRAY1D},
               {"opacity", ANARI_FLOAT32},
               {"opacity", ANARI_ARRAY1D},
               {"unitDistance", ANARI_FLOAT32},
               {"id", ANARI_UINT32},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_VOLUME_TRANSFER_FUNCTION1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 1;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_orthographic_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "orthographic camera object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"position", ANARI_FLOAT32_VEC3},
               {"direction", ANARI_FLOAT32_VEC3},
               {"up", ANARI_FLOAT32_VEC3},
               {"imageRegion", ANARI_FLOAT32_BOX2},
               {"aspect", ANARI_FLOAT32},
               {"height", ANARI_FLOAT32},
               {"near", ANARI_FLOAT32},
               {"far", ANARI_FLOAT32},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_ORTHOGRAPHIC";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 2;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_perspective_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "perspective camera object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"position", ANARI_FLOAT32_VEC3},
               {"direction", ANARI_FLOAT32_VEC3},
               {"up", ANARI_FLOAT32_VEC3},
               {"imageRegion", ANARI_FLOAT32_BOX2},
               {"fovy", ANARI_FLOAT32},
               {"aspect", ANARI_FLOAT32},
               {"near", ANARI_FLOAT32},
               {"far", ANARI_FLOAT32},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_CAMERA_PERSPECTIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 3;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cone_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "cone geometry object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"color", ANARI_FLOAT32_VEC4},
               {"attribute0", ANARI_FLOAT32_VEC4},
               {"attribute1", ANARI_FLOAT32_VEC4},
               {"attribute2", ANARI_FLOAT32_VEC4},
               {"attribute3", ANARI_FLOAT32_VEC4},
               {"primitive.color", ANARI_ARRAY1D},
               {"primitive.attribute0", ANARI_ARRAY1D},
               {"primitive.attribute1", ANARI_ARRAY1D},
               {"primitive.attribute2", ANARI_ARRAY1D},
               {"primitive.attribute3", ANARI_ARRAY1D},
               {"primitive.id", ANARI_ARRAY1D},
               {"vertex.position", ANARI_ARRAY1D},
               {"vertex.radius", ANARI_ARRAY1D},
               {"vertex.cap", ANARI_ARRAY1D},
               {"vertex.color", ANARI_ARRAY1D},
               {"vertex.attribute0", ANARI_ARRAY1D},
               {"vertex.attribute1", ANARI_ARRAY1D},
               {"vertex.attribute2", ANARI_ARRAY1D},
               {"vertex.attribute3", ANARI_ARRAY1D},
               {"primitive.index", ANARI_ARRAY1D},
               {"caps", ANARI_STRING},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CONE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 9;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_curve_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "curve geometry object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"color", ANARI_FLOAT32_VEC4},
               {"attribute0", ANARI_FLOAT32_VEC4},
               {"attribute1", ANARI_FLOAT32_VEC4},
               {"attribute2", ANARI_FLOAT32_VEC4},
               {"attribute3", ANARI_FLOAT32_VEC4},
               {"primitive.color", ANARI_ARRAY1D},
               {"primitive.attribute0", ANARI_ARRAY1D},
               {"primitive.attribute1", ANARI_ARRAY1D},
               {"primitive.attribute2", ANARI_ARRAY1D},
               {"primitive.attribute3", ANARI_ARRAY1D},
               {"primitive.id", ANARI_ARRAY1D},
               {"vertex.position", ANARI_ARRAY1D},
               {"vertex.radius", ANARI_ARRAY1D},
               {"vertex.color", ANARI_ARRAY1D},
               {"vertex.attribute0", ANARI_ARRAY1D},
               {"vertex.attribute1", ANARI_ARRAY1D},
               {"vertex.attribute2", ANARI_ARRAY1D},
               {"vertex.attribute3", ANARI_ARRAY1D},
               {"primitive.index", ANARI_ARRAY1D},
               {"radius", ANARI_FLOAT32},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CURVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 10;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_cylinder_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "cylinder geometry object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"color", ANARI_FLOAT32_VEC4},
               {"attribute0", ANARI_FLOAT32_VEC4},
               {"attribute1", ANARI_FLOAT32_VEC4},
               {"attribute2", ANARI_FLOAT32_VEC4},
               {"attribute3", ANARI_FLOAT32_VEC4},
               {"primitive.color", ANARI_ARRAY1D},
               {"primitive.attribute0", ANARI_ARRAY1D},
               {"primitive.attribute1", ANARI_ARRAY1D},
               {"primitive.attribute2", ANARI_ARRAY1D},
               {"primitive.attribute3", ANARI_ARRAY1D},
               {"primitive.id", ANARI_ARRAY1D},
               {"vertex.position", ANARI_ARRAY1D},
               {"vertex.cap", ANARI_ARRAY1D},
               {"vertex.color", ANARI_ARRAY1D},
               {"vertex.attribute0", ANARI_ARRAY1D},
               {"vertex.attribute1", ANARI_ARRAY1D},
               {"vertex.attribute2", ANARI_ARRAY1D},
               {"vertex.attribute3", ANARI_ARRAY1D},
               {"primitive.index", ANARI_ARRAY1D},
               {"primitive.radius", ANARI_ARRAY1D},
               {"radius", ANARI_FLOAT32},
               {"caps", ANARI_STRING},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_CYLINDER";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 11;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_quad_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "quad geometry object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"color", ANARI_FLOAT32_VEC4},
               {"attribute0", ANARI_FLOAT32_VEC4},
               {"attribute1", ANARI_FLOAT32_VEC4},
               {"attribute2", ANARI_FLOAT32_VEC4},
               {"attribute3", ANARI_FLOAT32_VEC4},
               {"primitive.color", ANARI_ARRAY1D},
               {"primitive.attribute0", ANARI_ARRAY1D},
               {"primitive.attribute1", ANARI_ARRAY1D},
               {"primitive.attribute2", ANARI_ARRAY1D},
               {"primitive.attribute3", ANARI_ARRAY1D},
               {"primitive.id", ANARI_ARRAY1D},
               {"vertex.position", ANARI_ARRAY1D},
               {"vertex.normal", ANARI_ARRAY1D},
               {"vertex.tangent", ANARI_ARRAY1D},
               {"vertex.color", ANARI_ARRAY1D},
               {"vertex.attribute0", ANARI_ARRAY1D},
               {"vertex.attribute1", ANARI_ARRAY1D},
               {"vertex.attribute2", ANARI_ARRAY1D},
               {"vertex.attribute3", ANARI_ARRAY1D},
               {"primitive.index", ANARI_ARRAY1D},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_QUAD";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 12;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_sphere_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "sphere geometry object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"color", ANARI_FLOAT32_VEC4},
               {"attribute0", ANARI_FLOAT32_VEC4},
               {"attribute1", ANARI_FLOAT32_VEC4},
               {"attribute2", ANARI_FLOAT32_VEC4},
               {"attribute3", ANARI_FLOAT32_VEC4},
               {"primitive.color", ANARI_ARRAY1D},
               {"primitive.attribute0", ANARI_ARRAY1D},
               {"primitive.attribute1", ANARI_ARRAY1D},
               {"primitive.attribute2", ANARI_ARRAY1D},
               {"primitive.attribute3", ANARI_ARRAY1D},
               {"primitive.id", ANARI_ARRAY1D},
               {"vertex.position", ANARI_ARRAY1D},
               {"vertex.radius", ANARI_ARRAY1D},
               {"vertex.color", ANARI_ARRAY1D},
               {"vertex.attribute0", ANARI_ARRAY1D},
               {"vertex.attribute1", ANARI_ARRAY1D},
               {"vertex.attribute2", ANARI_ARRAY1D},
               {"vertex.attribute3", ANARI_ARRAY1D},
               {"primitive.index", ANARI_ARRAY1D},
               {"radius", ANARI_FLOAT32},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_SPHERE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 13;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GEOMETRY_triangle_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "triangle geometry object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"color", ANARI_FLOAT32_VEC4},
               {"attribute0", ANARI_FLOAT32_VEC4},
               {"attribute1", ANARI_FLOAT32_VEC4},
               {"attribute2", ANARI_FLOAT32_VEC4},
               {"attribute3", ANARI_FLOAT32_VEC4},
               {"primitive.color", ANARI_ARRAY1D},
               {"primitive.attribute0", ANARI_ARRAY1D},
               {"primitive.attribute1", ANARI_ARRAY1D},
               {"primitive.attribute2", ANARI_ARRAY1D},
               {"primitive.attribute3", ANARI_ARRAY1D},
               {"primitive.id", ANARI_ARRAY1D},
               {"vertex.position", ANARI_ARRAY1D},
               {"vertex.normal", ANARI_ARRAY1D},
               {"vertex.tangent", ANARI_ARRAY1D},
               {"vertex.color", ANARI_ARRAY1D},
               {"vertex.attribute0", ANARI_ARRAY1D},
               {"vertex.attribute1", ANARI_ARRAY1D},
               {"vertex.attribute2", ANARI_ARRAY1D},
               {"vertex.attribute3", ANARI_ARRAY1D},
               {"primitive.index", ANARI_ARRAY1D},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_GEOMETRY_TRIANGLE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 14;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_MATERIAL_matte_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "matte material object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"color", ANARI_FLOAT32_VEC3},
               {"color", ANARI_SAMPLER},
               {"color", ANARI_STRING},
               {"opacity", ANARI_FLOAT32},
               {"opacity", ANARI_SAMPLER},
               {"opacity", ANARI_STRING},
               {"alphaMode", ANARI_STRING},
               {"alphaCutoff", ANARI_FLOAT32},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_MATERIAL_MATTE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 16;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image1D_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "image1D object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"image", ANARI_ARRAY1D},
               {"inAttribute", ANARI_STRING},
               {"filter", ANARI_STRING},
               {"wrapMode1", ANARI_STRING},
               {"inTransform", ANARI_FLOAT32_MAT4},
               {"inOffset", ANARI_FLOAT32_VEC4},
               {"outTransform", ANARI_FLOAT32_MAT4},
               {"outOffset", ANARI_FLOAT32_VEC4},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE1D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 20;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image2D_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "image2D object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"image", ANARI_ARRAY2D},
               {"inAttribute", ANARI_STRING},
               {"filter", ANARI_STRING},
               {"wrapMode1", ANARI_STRING},
               {"wrapMode2", ANARI_STRING},
               {"inTransform", ANARI_FLOAT32_MAT4},
               {"inOffset", ANARI_FLOAT32_VEC4},
               {"outTransform", ANARI_FLOAT32_MAT4},
               {"outOffset", ANARI_FLOAT32_VEC4},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE2D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 21;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_image3D_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "image3D object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"image", ANARI_ARRAY3D},
               {"inAttribute", ANARI_STRING},
               {"filter", ANARI_STRING},
               {"wrapMode1", ANARI_STRING},
               {"wrapMode2", ANARI_STRING},
               {"wrapMode3", ANARI_STRING},
               {"inTransform", ANARI_FLOAT32_MAT4},
               {"inOffset", ANARI_FLOAT32_VEC4},
               {"outTransform", ANARI_FLOAT32_MAT4},
               {"outOffset", ANARI_FLOAT32_VEC4},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_IMAGE3D";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 22;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_primitive_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "primitive sampler object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"array", ANARI_ARRAY1D},
               {"inOffset", ANARI_UINT64},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_PRIMITIVE";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 23;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SAMPLER_transform_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "transform sampler object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"inAttribute", ANARI_STRING},
               {"outTransform", ANARI_FLOAT32_MAT4},
               {"outOffset", ANARI_FLOAT32_VEC4},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SAMPLER_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 24;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SPATIAL_FIELD_structuredRegular_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "structured regular spatial field object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"data", ANARI_ARRAY3D},
               {"origin", ANARI_FLOAT32_VEC3},
               {"spacing", ANARI_FLOAT32_VEC3},
               {"filter", ANARI_STRING},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_SPATIAL_FIELD_STRUCTURED_REGULAR";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 25;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_CAMERA_info(const char *subtype, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 8:
         return ANARI_CAMERA_orthographic_info(infoName, infoType);
      case 9:
         return ANARI_CAMERA_perspective_info(infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_GEOMETRY_info(const char *subtype, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 0:
         return ANARI_GEOMETRY_cone_info(infoName, infoType);
      case 1:
         return ANARI_GEOMETRY_curve_info(infoName, infoType);
      case 2:
         return ANARI_GEOMETRY_cylinder_info(infoName, infoType);
      case 11:
         return ANARI_GEOMETRY_quad_info(infoName, infoType);
      case 12:
         return ANARI_GEOMETRY_sphere_info(infoName, infoType);
      case 16:
         return ANARI_GEOMETRY_triangle_info(infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_INSTANCE_info(const char *subtype, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 15:
         return ANARI_INSTANCE_transform_info(infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_MATERIAL_info(const char *subtype, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 7:
         return ANARI_MATERIAL_matte_info(infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_RENDERER_info(const char *subtype, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 3:
         return ANARI_RENDERER_default_info(infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SAMPLER_info(const char *subtype, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 4:
         return ANARI_SAMPLER_image1D_info(infoName, infoType);
      case 5:
         return ANARI_SAMPLER_image2D_info(infoName, infoType);
      case 6:
         return ANARI_SAMPLER_image3D_info(infoName, infoType);
      case 10:
         return ANARI_SAMPLER_primitive_info(infoName, infoType);
      case 15:
         return ANARI_SAMPLER_transform_info(infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SPATIAL_FIELD_info(const char *subtype, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 13:
         return ANARI_SPATIAL_FIELD_structuredRegular_info(infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_VOLUME_info(const char *subtype, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 14:
         return ANARI_VOLUME_transferFunction1D_info(infoName, infoType);
      default:
         return nullptr;
   }
}
const void * query_object_info_enum(ANARIDataType type, const char *subtype, int infoName, ANARIDataType infoType) {
   switch(type) {
      case ANARI_CAMERA:
         return ANARI_CAMERA_info(subtype, infoName, infoType);
      case ANARI_GEOMETRY:
         return ANARI_GEOMETRY_info(subtype, infoName, infoType);
      case ANARI_INSTANCE:
         return ANARI_INSTANCE_info(subtype, infoName, infoType);
      case ANARI_MATERIAL:
         return ANARI_MATERIAL_info(subtype, infoName, infoType);
      case ANARI_RENDERER:
         return ANARI_RENDERER_info(subtype, infoName, infoType);
      case ANARI_SAMPLER:
         return ANARI_SAMPLER_info(subtype, infoName, infoType);
      case ANARI_SPATIAL_FIELD:
         return ANARI_SPATIAL_FIELD_info(subtype, infoName, infoType);
      case ANARI_VOLUME:
         return ANARI_VOLUME_info(subtype, infoName, infoType);
      case ANARI_DEVICE:
         return ANARI_DEVICE_info(infoName, infoType);
      case ANARI_ARRAY1D:
         return ANARI_ARRAY1D_info(infoName, infoType);
      case ANARI_ARRAY2D:
         return ANARI_ARRAY2D_info(infoName, infoType);
      case ANARI_ARRAY3D:
         return ANARI_ARRAY3D_info(infoName, infoType);
      case ANARI_FRAME:
         return ANARI_FRAME_info(infoName, infoType);
      case ANARI_GROUP:
         return ANARI_GROUP_info(infoName, infoType);
      case ANARI_WORLD:
         return ANARI_WORLD_info(infoName, infoType);
      case ANARI_SURFACE:
         return ANARI_SURFACE_info(infoName, infoType);
      default:
         return nullptr;
   }
}
const void * query_object_info(ANARIDataType type, const char *subtype, const char *infoNameString, ANARIDataType infoType) {
   int infoName = info_hash(infoNameString);   return query_object_info_enum(type, subtype, infoName, infoType);}
}
