﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appintegrations/AppIntegrationsService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/appintegrations/model/ApplicationAssociationSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace AppIntegrationsService
{
namespace Model
{
  class ListApplicationAssociationsResult
  {
  public:
    AWS_APPINTEGRATIONSSERVICE_API ListApplicationAssociationsResult();
    AWS_APPINTEGRATIONSSERVICE_API ListApplicationAssociationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_APPINTEGRATIONSSERVICE_API ListApplicationAssociationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>List of Application Associations for the Application.</p>
     */
    inline const Aws::Vector<ApplicationAssociationSummary>& GetApplicationAssociations() const{ return m_applicationAssociations; }

    /**
     * <p>List of Application Associations for the Application.</p>
     */
    inline void SetApplicationAssociations(const Aws::Vector<ApplicationAssociationSummary>& value) { m_applicationAssociations = value; }

    /**
     * <p>List of Application Associations for the Application.</p>
     */
    inline void SetApplicationAssociations(Aws::Vector<ApplicationAssociationSummary>&& value) { m_applicationAssociations = std::move(value); }

    /**
     * <p>List of Application Associations for the Application.</p>
     */
    inline ListApplicationAssociationsResult& WithApplicationAssociations(const Aws::Vector<ApplicationAssociationSummary>& value) { SetApplicationAssociations(value); return *this;}

    /**
     * <p>List of Application Associations for the Application.</p>
     */
    inline ListApplicationAssociationsResult& WithApplicationAssociations(Aws::Vector<ApplicationAssociationSummary>&& value) { SetApplicationAssociations(std::move(value)); return *this;}

    /**
     * <p>List of Application Associations for the Application.</p>
     */
    inline ListApplicationAssociationsResult& AddApplicationAssociations(const ApplicationAssociationSummary& value) { m_applicationAssociations.push_back(value); return *this; }

    /**
     * <p>List of Application Associations for the Application.</p>
     */
    inline ListApplicationAssociationsResult& AddApplicationAssociations(ApplicationAssociationSummary&& value) { m_applicationAssociations.push_back(std::move(value)); return *this; }


    /**
     * <p>If there are additional results, this is the token for the next set of
     * results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>If there are additional results, this is the token for the next set of
     * results.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>If there are additional results, this is the token for the next set of
     * results.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>If there are additional results, this is the token for the next set of
     * results.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>If there are additional results, this is the token for the next set of
     * results.</p>
     */
    inline ListApplicationAssociationsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>If there are additional results, this is the token for the next set of
     * results.</p>
     */
    inline ListApplicationAssociationsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>If there are additional results, this is the token for the next set of
     * results.</p>
     */
    inline ListApplicationAssociationsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline ListApplicationAssociationsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline ListApplicationAssociationsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline ListApplicationAssociationsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    Aws::Vector<ApplicationAssociationSummary> m_applicationAssociations;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace AppIntegrationsService
} // namespace Aws
