﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cleanrooms/model/ProtectedQueryType.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace CleanRooms
  {
    namespace Model
    {
      namespace ProtectedQueryTypeMapper
      {

        static const int SQL_HASH = HashingUtils::HashString("SQL");


        ProtectedQueryType GetProtectedQueryTypeForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == SQL_HASH)
          {
            return ProtectedQueryType::SQL;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<ProtectedQueryType>(hashCode);
          }

          return ProtectedQueryType::NOT_SET;
        }

        Aws::String GetNameForProtectedQueryType(ProtectedQueryType enumValue)
        {
          switch(enumValue)
          {
          case ProtectedQueryType::NOT_SET:
            return {};
          case ProtectedQueryType::SQL:
            return "SQL";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace ProtectedQueryTypeMapper
    } // namespace Model
  } // namespace CleanRooms
} // namespace Aws
