﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/compute-optimizer/model/ExternalMetricStatus.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ComputeOptimizer
{
namespace Model
{

ExternalMetricStatus::ExternalMetricStatus() : 
    m_statusCode(ExternalMetricStatusCode::NOT_SET),
    m_statusCodeHasBeenSet(false),
    m_statusReasonHasBeenSet(false)
{
}

ExternalMetricStatus::ExternalMetricStatus(JsonView jsonValue)
  : ExternalMetricStatus()
{
  *this = jsonValue;
}

ExternalMetricStatus& ExternalMetricStatus::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("statusCode"))
  {
    m_statusCode = ExternalMetricStatusCodeMapper::GetExternalMetricStatusCodeForName(jsonValue.GetString("statusCode"));

    m_statusCodeHasBeenSet = true;
  }

  if(jsonValue.ValueExists("statusReason"))
  {
    m_statusReason = jsonValue.GetString("statusReason");

    m_statusReasonHasBeenSet = true;
  }

  return *this;
}

JsonValue ExternalMetricStatus::Jsonize() const
{
  JsonValue payload;

  if(m_statusCodeHasBeenSet)
  {
   payload.WithString("statusCode", ExternalMetricStatusCodeMapper::GetNameForExternalMetricStatusCode(m_statusCode));
  }

  if(m_statusReasonHasBeenSet)
  {
   payload.WithString("statusReason", m_statusReason);

  }

  return payload;
}

} // namespace Model
} // namespace ComputeOptimizer
} // namespace Aws
