﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/deadline/Deadline_EXPORTS.h>
#include <aws/deadline/model/AutoScalingMode.h>
#include <aws/deadline/model/CustomerManagedWorkerCapabilities.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace deadline
{
namespace Model
{

  /**
   * <p>The details of a customer managed fleet configuration.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CustomerManagedFleetConfiguration">AWS
   * API Reference</a></p>
   */
  class CustomerManagedFleetConfiguration
  {
  public:
    AWS_DEADLINE_API CustomerManagedFleetConfiguration();
    AWS_DEADLINE_API CustomerManagedFleetConfiguration(Aws::Utils::Json::JsonView jsonValue);
    AWS_DEADLINE_API CustomerManagedFleetConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_DEADLINE_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The Auto Scaling mode for the customer managed fleet configuration.</p>
     */
    inline const AutoScalingMode& GetMode() const{ return m_mode; }
    inline bool ModeHasBeenSet() const { return m_modeHasBeenSet; }
    inline void SetMode(const AutoScalingMode& value) { m_modeHasBeenSet = true; m_mode = value; }
    inline void SetMode(AutoScalingMode&& value) { m_modeHasBeenSet = true; m_mode = std::move(value); }
    inline CustomerManagedFleetConfiguration& WithMode(const AutoScalingMode& value) { SetMode(value); return *this;}
    inline CustomerManagedFleetConfiguration& WithMode(AutoScalingMode&& value) { SetMode(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The worker capabilities for a customer managed fleet configuration.</p>
     */
    inline const CustomerManagedWorkerCapabilities& GetWorkerCapabilities() const{ return m_workerCapabilities; }
    inline bool WorkerCapabilitiesHasBeenSet() const { return m_workerCapabilitiesHasBeenSet; }
    inline void SetWorkerCapabilities(const CustomerManagedWorkerCapabilities& value) { m_workerCapabilitiesHasBeenSet = true; m_workerCapabilities = value; }
    inline void SetWorkerCapabilities(CustomerManagedWorkerCapabilities&& value) { m_workerCapabilitiesHasBeenSet = true; m_workerCapabilities = std::move(value); }
    inline CustomerManagedFleetConfiguration& WithWorkerCapabilities(const CustomerManagedWorkerCapabilities& value) { SetWorkerCapabilities(value); return *this;}
    inline CustomerManagedFleetConfiguration& WithWorkerCapabilities(CustomerManagedWorkerCapabilities&& value) { SetWorkerCapabilities(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The storage profile ID.</p>
     */
    inline const Aws::String& GetStorageProfileId() const{ return m_storageProfileId; }
    inline bool StorageProfileIdHasBeenSet() const { return m_storageProfileIdHasBeenSet; }
    inline void SetStorageProfileId(const Aws::String& value) { m_storageProfileIdHasBeenSet = true; m_storageProfileId = value; }
    inline void SetStorageProfileId(Aws::String&& value) { m_storageProfileIdHasBeenSet = true; m_storageProfileId = std::move(value); }
    inline void SetStorageProfileId(const char* value) { m_storageProfileIdHasBeenSet = true; m_storageProfileId.assign(value); }
    inline CustomerManagedFleetConfiguration& WithStorageProfileId(const Aws::String& value) { SetStorageProfileId(value); return *this;}
    inline CustomerManagedFleetConfiguration& WithStorageProfileId(Aws::String&& value) { SetStorageProfileId(std::move(value)); return *this;}
    inline CustomerManagedFleetConfiguration& WithStorageProfileId(const char* value) { SetStorageProfileId(value); return *this;}
    ///@}
  private:

    AutoScalingMode m_mode;
    bool m_modeHasBeenSet = false;

    CustomerManagedWorkerCapabilities m_workerCapabilities;
    bool m_workerCapabilitiesHasBeenSet = false;

    Aws::String m_storageProfileId;
    bool m_storageProfileIdHasBeenSet = false;
  };

} // namespace Model
} // namespace deadline
} // namespace Aws
