﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/deadline/model/GetBudgetResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::deadline::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetBudgetResult::GetBudgetResult() : 
    m_status(BudgetStatus::NOT_SET),
    m_approximateDollarLimit(0.0)
{
}

GetBudgetResult::GetBudgetResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
  : GetBudgetResult()
{
  *this = result;
}

GetBudgetResult& GetBudgetResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("budgetId"))
  {
    m_budgetId = jsonValue.GetString("budgetId");

  }

  if(jsonValue.ValueExists("usageTrackingResource"))
  {
    m_usageTrackingResource = jsonValue.GetObject("usageTrackingResource");

  }

  if(jsonValue.ValueExists("status"))
  {
    m_status = BudgetStatusMapper::GetBudgetStatusForName(jsonValue.GetString("status"));

  }

  if(jsonValue.ValueExists("displayName"))
  {
    m_displayName = jsonValue.GetString("displayName");

  }

  if(jsonValue.ValueExists("description"))
  {
    m_description = jsonValue.GetString("description");

  }

  if(jsonValue.ValueExists("approximateDollarLimit"))
  {
    m_approximateDollarLimit = jsonValue.GetDouble("approximateDollarLimit");

  }

  if(jsonValue.ValueExists("usages"))
  {
    m_usages = jsonValue.GetObject("usages");

  }

  if(jsonValue.ValueExists("actions"))
  {
    Aws::Utils::Array<JsonView> actionsJsonList = jsonValue.GetArray("actions");
    for(unsigned actionsIndex = 0; actionsIndex < actionsJsonList.GetLength(); ++actionsIndex)
    {
      m_actions.push_back(actionsJsonList[actionsIndex].AsObject());
    }
  }

  if(jsonValue.ValueExists("schedule"))
  {
    m_schedule = jsonValue.GetObject("schedule");

  }

  if(jsonValue.ValueExists("createdBy"))
  {
    m_createdBy = jsonValue.GetString("createdBy");

  }

  if(jsonValue.ValueExists("createdAt"))
  {
    m_createdAt = jsonValue.GetString("createdAt");

  }

  if(jsonValue.ValueExists("updatedBy"))
  {
    m_updatedBy = jsonValue.GetString("updatedBy");

  }

  if(jsonValue.ValueExists("updatedAt"))
  {
    m_updatedAt = jsonValue.GetString("updatedAt");

  }

  if(jsonValue.ValueExists("queueStoppedAt"))
  {
    m_queueStoppedAt = jsonValue.GetString("queueStoppedAt");

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
