﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/athena/model/NotebookSessionSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Athena
{
namespace Model
{
  class ListNotebookSessionsResult
  {
  public:
    AWS_ATHENA_API ListNotebookSessionsResult();
    AWS_ATHENA_API ListNotebookSessionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ATHENA_API ListNotebookSessionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of the sessions belonging to the notebook.</p>
     */
    inline const Aws::Vector<NotebookSessionSummary>& GetNotebookSessionsList() const{ return m_notebookSessionsList; }
    inline void SetNotebookSessionsList(const Aws::Vector<NotebookSessionSummary>& value) { m_notebookSessionsList = value; }
    inline void SetNotebookSessionsList(Aws::Vector<NotebookSessionSummary>&& value) { m_notebookSessionsList = std::move(value); }
    inline ListNotebookSessionsResult& WithNotebookSessionsList(const Aws::Vector<NotebookSessionSummary>& value) { SetNotebookSessionsList(value); return *this;}
    inline ListNotebookSessionsResult& WithNotebookSessionsList(Aws::Vector<NotebookSessionSummary>&& value) { SetNotebookSessionsList(std::move(value)); return *this;}
    inline ListNotebookSessionsResult& AddNotebookSessionsList(const NotebookSessionSummary& value) { m_notebookSessionsList.push_back(value); return *this; }
    inline ListNotebookSessionsResult& AddNotebookSessionsList(NotebookSessionSummary&& value) { m_notebookSessionsList.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the <code>NextToken</code> from the response object of the previous page
     * call.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListNotebookSessionsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListNotebookSessionsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListNotebookSessionsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListNotebookSessionsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListNotebookSessionsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListNotebookSessionsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<NotebookSessionSummary> m_notebookSessionsList;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Athena
} // namespace Aws
