﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioCommitmentModificationError.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace BCMPricingCalculator
{
namespace Model
{

BatchCreateBillScenarioCommitmentModificationError::BatchCreateBillScenarioCommitmentModificationError() : 
    m_keyHasBeenSet(false),
    m_errorMessageHasBeenSet(false),
    m_errorCode(BatchCreateBillScenarioCommitmentModificationErrorCode::NOT_SET),
    m_errorCodeHasBeenSet(false)
{
}

BatchCreateBillScenarioCommitmentModificationError::BatchCreateBillScenarioCommitmentModificationError(JsonView jsonValue)
  : BatchCreateBillScenarioCommitmentModificationError()
{
  *this = jsonValue;
}

BatchCreateBillScenarioCommitmentModificationError& BatchCreateBillScenarioCommitmentModificationError::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("key"))
  {
    m_key = jsonValue.GetString("key");

    m_keyHasBeenSet = true;
  }

  if(jsonValue.ValueExists("errorMessage"))
  {
    m_errorMessage = jsonValue.GetString("errorMessage");

    m_errorMessageHasBeenSet = true;
  }

  if(jsonValue.ValueExists("errorCode"))
  {
    m_errorCode = BatchCreateBillScenarioCommitmentModificationErrorCodeMapper::GetBatchCreateBillScenarioCommitmentModificationErrorCodeForName(jsonValue.GetString("errorCode"));

    m_errorCodeHasBeenSet = true;
  }

  return *this;
}

JsonValue BatchCreateBillScenarioCommitmentModificationError::Jsonize() const
{
  JsonValue payload;

  if(m_keyHasBeenSet)
  {
   payload.WithString("key", m_key);

  }

  if(m_errorMessageHasBeenSet)
  {
   payload.WithString("errorMessage", m_errorMessage);

  }

  if(m_errorCodeHasBeenSet)
  {
   payload.WithString("errorCode", BatchCreateBillScenarioCommitmentModificationErrorCodeMapper::GetNameForBatchCreateBillScenarioCommitmentModificationErrorCode(m_errorCode));
  }

  return payload;
}

} // namespace Model
} // namespace BCMPricingCalculator
} // namespace Aws
