﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/RetrievalResultCustomDocumentLocation.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace BedrockAgentRuntime
{
namespace Model
{

RetrievalResultCustomDocumentLocation::RetrievalResultCustomDocumentLocation() : 
    m_idHasBeenSet(false)
{
}

RetrievalResultCustomDocumentLocation::RetrievalResultCustomDocumentLocation(JsonView jsonValue)
  : RetrievalResultCustomDocumentLocation()
{
  *this = jsonValue;
}

RetrievalResultCustomDocumentLocation& RetrievalResultCustomDocumentLocation::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("id"))
  {
    m_id = jsonValue.GetString("id");

    m_idHasBeenSet = true;
  }

  return *this;
}

JsonValue RetrievalResultCustomDocumentLocation::Jsonize() const
{
  JsonValue payload;

  if(m_idHasBeenSet)
  {
   payload.WithString("id", m_id);

  }

  return payload;
}

} // namespace Model
} // namespace BedrockAgentRuntime
} // namespace Aws
