#include "stdafx.h"
#include "resource.h"
#include <cstddef>
#include <cassert>
#include <cstring>
#include <aztecgen.h>
#include "BarcodeRendering.h"
#include "MainDlg.h"


BOOL CMainDlg::OnInitDialog(CWindow wndFocus, LPARAM lInitParam)
{
	// center the dialog on the screen
	CenterWindow();

	// set icons
	HICON hIcon = (HICON)::LoadImage(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
		IMAGE_ICON, ::GetSystemMetrics(SM_CXICON), ::GetSystemMetrics(SM_CYICON), LR_DEFAULTCOLOR);
	SetIcon(hIcon, TRUE);
	HICON hIconSmall = (HICON)::LoadImage(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
		IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), LR_DEFAULTCOLOR);
	SetIcon(hIconSmall, FALSE);

	// Получение имени программы
	m_appName.LoadString(IDR_MAINFRAME);

	// Инициализация DDX-переменных
	m_redundancyForErrorCorrection = 23;
	m_pointSizeInPixels = 5;
	m_pointSizeInMillimetres = 0.35;
	m_inputData = CString(MAKEINTRESOURCE(IDS_INITIAL_INPUT_DATA)) +
		_T("\r\n");

	DoDataExchange(DDX_LOAD);

	// Инициализация SymbolFormat контрола
	for (int i = IDS_SYMBOL_FORMAT_0; i <= IDS_SYMBOL_FORMAT_38; ++i)
		m_wndSymbolFormat.AddString(CString(MAKEINTRESOURCE(i)));
	m_wndSymbolFormat.SetCurSel(0);

	// Создание Picture контрола
	CRect rect;
	m_wndPictureHomePosition.GetWindowRect(rect);
	ScreenToClient(rect);

	m_wndPicture.Create(*this, rect, NULL, 0, WS_EX_CLIENTEDGE, IDC_PICTURE);

	// Инициализация логотипа
	m_wndLogo.SetHyperLink(CString(MAKEINTRESOURCE(IDS_LOGO_HYPERLINK)));

	// Инициализация "Toolbar"-а
	m_wndCopy.SetIcon((HICON) ::LoadImage(_Module.GetResourceInstance(),
		MAKEINTRESOURCE(IDI_COPY), IMAGE_ICON, 0, 0, LR_DEFAULTCOLOR));
	m_wndSave.SetIcon((HICON) ::LoadImage(_Module.GetResourceInstance(),
		MAKEINTRESOURCE(IDI_SAVE), IMAGE_ICON, 0, 0, LR_DEFAULTCOLOR));
	m_wndPrint.SetIcon((HICON) ::LoadImage(_Module.GetResourceInstance(),
		MAKEINTRESOURCE(IDI_PRINT), IMAGE_ICON, 0, 0, LR_DEFAULTCOLOR));

	m_pointSizeInPixelsActual = 0;
	m_pointSizeInMillimetresActual = 0;
	UpdateToolbarState();

	// Инициализация DlgResize
	DlgResize_Init(false);

	// Генерация штрих-кода
	PostMessage(WM_COMMAND, MAKEWPARAM(IDC_GENERATE, BN_CLICKED),
		LPARAM(HWND(GetDlgItem(IDC_GENERATE))));

	return TRUE;
}

void CMainDlg::OnCancel(UINT uNotifyCode, int nID, CWindow wndCtl)
{
	EndDialog(IDOK);
}

void CMainDlg::OnCopy(UINT uNotifyCode, int nID, CWindow wndCtl)
{
	// Получение изображения штрих-кода
	CImage img;
	if (!CreateBarcodeImage(&img, m_barcode.get(),
		m_pointSizeInPixelsActual, m_pointSizeInPixelsActual))
	{
		MessageBox(CString(MAKEINTRESOURCE(IDS_CREATE_IMAGE_ERROR)),
			m_appName, MB_OK | MB_ICONERROR);
		return;
	}

	// Сохранение изображения штрих-кода в буфер обмена
	if (!OpenClipboard())
	{
		MessageBox(CString(MAKEINTRESOURCE(IDS_OPEN_CLIPBOARD_ERROR)),
			m_appName, MB_OK | MB_ICONERROR);
		return;
	}

	EmptyClipboard();
	SetClipboardData(CF_BITMAP,
		CopyImage(img, IMAGE_BITMAP, 0, 0, 0));
	CloseClipboard();
}

void CMainDlg::OnSave(UINT uNotifyCode, int nID, CWindow wndCtl)
{
	// Получение параметров сохранения
	CFileDialog dlg(FALSE, _T("png"), NULL,
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST,
		_T("PNG (*.png)\0*.png\0BMP (*.bmp)\0*.bmp\0"), *this);

	if (dlg.DoModal() != IDOK)
		return;

	// Сохранение штрих-кода
	CImage img;
	if (!CreateBarcodeImage(&img, m_barcode.get(),
		m_pointSizeInPixelsActual, m_pointSizeInPixelsActual))
	{
		MessageBox(CString(MAKEINTRESOURCE(IDS_CREATE_IMAGE_ERROR)),
			m_appName, MB_OK | MB_ICONERROR);
		return;
	}

	if (FAILED(img.Save(dlg.m_szFileName)))
	{
		MessageBox(CString(MAKEINTRESOURCE(IDS_SAVE_IMAGE_ERROR)),
			m_appName, MB_OK | MB_ICONERROR);
		return;
	}
}

void CMainDlg::OnPrint(UINT uNotifyCode, int nID, CWindow wndCtl)
{
	// Получение параметров печати
	CPrintDialog dlg(FALSE,
		PD_HIDEPRINTTOFILE | PD_NOPAGENUMS | PD_NOSELECTION, *this);

	const INT_PTR dlgResult = dlg.DoModal();
	const CHeapPtr<void, CGlobalAllocator> devMode(dlg.m_pd.hDevMode);
	const CHeapPtr<void, CGlobalAllocator> devNames(dlg.m_pd.hDevNames);

	if (dlgResult != IDOK)
		return;

	// Распечатка штрих-кода
	CDC printerDC(dlg.GetPrinterDC());

	printerDC.StartDoc(m_appName);
	printerDC.StartPage();

	printerDC.SetMapMode(MM_HIMETRIC);
	DrawBarcode(HDC(printerDC), m_barcode.get(),
		m_pointSizeInMillimetresActual * 100,
		-m_pointSizeInMillimetresActual * 100);

	printerDC.EndPage();
	printerDC.EndDoc();
}

void CMainDlg::OnGenerate(UINT uNotifyCode, int nID, CWindow wndCtl)
{
	if (!DoDataExchange(DDX_SAVE))
		return;

	// Генерация штрих-кода
	ag_matrix_ptr barcode;
	if (!m_inputData.IsEmpty())
	{
		const CT2CA inputData(m_inputData);

		ag_settings settings;
		settings.mask =
			AG_SF_SYMBOL_FORMAT | AG_SF_REDUNDANCY_FOR_ERROR_CORRECTION;
		settings.symbol_format =
			unsigned char(m_wndSymbolFormat.GetCurSel());
		settings.redundancy_for_error_correction =
			unsigned char(m_redundancyForErrorCorrection);

		ag_matrix *pBarcode;
		if (ag_generate(&pBarcode, inputData, strlen(inputData),
			&settings) != AG_SUCCESS)
		{
			MessageBox(
				CString(MAKEINTRESOURCE(IDS_BARCODE_GENERATION_ERROR)),
				m_appName, MB_OK | MB_ICONERROR);
			return;
		}
		barcode.reset(pBarcode);
	}

	// Отображение штрих-кода
	if (barcode.get() != NULL)
		m_wndPicture.SetBarcode(barcode.get(),
			m_pointSizeInPixels, m_pointSizeInMillimetres);
	else
		m_wndPicture.ResetContent();

	// Обновление текущего состояния программы
	m_barcode.swap(barcode);
	m_pointSizeInPixelsActual = m_pointSizeInPixels;
	m_pointSizeInMillimetresActual = m_pointSizeInMillimetres;
	UpdateToolbarState();
}

void CMainDlg::OnDataExchangeError(UINT nCtrlID, BOOL /*bSave*/)
{
	MessageBox(CString(MAKEINTRESOURCE(IDS_DDX_EXCHANGE_ERROR)),
		m_appName, MB_OK | MB_ICONERROR);
	::SetFocus(GetDlgItem(nCtrlID));
}

void CMainDlg::OnDataValidateError(UINT nCtrlID, BOOL /*bSave*/, _XData &data)
{
	CString str(MAKEINTRESOURCE(IDS_DDX_VALIDATION_ERROR));

	switch (data.nDataType)
	{
		case ddxDataText:
			str.Format(IDS_DDX_TEXT_VALIDATION_ERROR,
				data.textData.nMaxLength);
			break;

		case ddxDataInt:
			str.Format(IDS_DDX_INT_VALIDATION_ERROR,
				data.intData.nMin, data.intData.nMax);
			break;

		case ddxDataFloat:
		case ddxDataDouble:
			str.Format(IDS_DDX_FLOAT_VALIDATION_ERROR,
				data.floatData.nMin, data.floatData.nMax);
			break;
	}

	MessageBox(str, m_appName, MB_OK | MB_ICONEXCLAMATION);
	::SetFocus(GetDlgItem(nCtrlID));
}

void CMainDlg::UpdateToolbarState()
{
	m_wndCopy.EnableWindow(
		m_barcode.get() != NULL &&
		m_pointSizeInPixelsActual > 0);

	m_wndSave.EnableWindow(
		m_barcode.get() != NULL &&
		m_pointSizeInPixelsActual > 0);

	m_wndPrint.EnableWindow(
		m_barcode.get() != NULL &&
		m_pointSizeInMillimetresActual > 0);
}
