;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; Check that synchronizing operations are considered to have side effects that
;; prevent them from being dropped.

;; RUN: wasm-opt %s -all --vacuum -S -o - | filecheck %s

(module
  ;; CHECK:      (type $shared (shared (struct (field i32))))
  (type $shared (shared (struct (field i32))))
  ;; CHECK:      (type $unshared (struct (field i32)))
  (type $unshared (struct (field i32)))

  ;; CHECK:      (func $get-unordered-unshared (type $0)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $get-unordered-unshared
    (drop
      (struct.get $unshared 0
        (struct.new_default $unshared)
      )
    )
  )

  ;; CHECK:      (func $get-unordered-shared (type $0)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $get-unordered-shared
    (drop
      (struct.get $shared 0
        (struct.new_default $shared)
      )
    )
  )

  ;; CHECK:      (func $get-seqcst-unshared (type $0)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.atomic.get $unshared 0
  ;; CHECK-NEXT:    (struct.new_default $unshared)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get-seqcst-unshared
    (drop
      (struct.atomic.get seqcst $unshared 0
        (struct.new_default $unshared)
      )
    )
  )

  ;; CHECK:      (func $get-seqcst-shared (type $0)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.atomic.get $shared 0
  ;; CHECK-NEXT:    (struct.new_default $shared)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get-seqcst-shared
    (drop
      (struct.atomic.get seqcst $shared 0
        (struct.new_default $shared)
      )
    )
  )

  ;; CHECK:      (func $get-acqrel-unshared (type $0)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $get-acqrel-unshared
    (drop
      (struct.atomic.get acqrel $unshared 0
        (struct.new_default $unshared)
      )
    )
  )

  ;; CHECK:      (func $get-acqrel-shared (type $0)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.atomic.get acqrel $shared 0
  ;; CHECK-NEXT:    (struct.new_default $shared)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $get-acqrel-shared
    (drop
      (struct.atomic.get acqrel $shared 0
        (struct.new_default $shared)
      )
    )
  )
)
